;; Rigid Roentgen: a bytebeat as a tiny Linux ELF
;; Copyright 2021 Hannu Hartikainen <hannu@hrtk.in>
;; Licensed under the terms of the GNU General Public License, either
;; version 3 or (at your option) any later version.
;;
;; Usage:
;;   ./rigid-roentgen | aplay
;;
;; To build:
;;	nasm -f bin -o rigid-roentgen rigid-roentgen.asm && chmod +x rigid-roentgen
;;
;; ELF header written with ideas and template by Brian Raiter from
;; http://www.muppetlabs.com/~breadbox/software/tiny/teensy.html

BITS 32

                org     0x00010000
  
                db      0x7F, "ELF"             ; e_ident
                dd      1                                       ; p_type
                dd      0                                       ; p_offset
                dd      $$                                      ; p_vaddr 
                dw      2                       ; e_type        ; p_paddr
                dw      3                       ; e_machine
                dd      _start                  ; e_version     ; p_filesz
                dd      _start                  ; e_entry       ; p_memsz
                dd      4                       ; e_phoff       ; p_flags

;; NOTE: the following bytes are needed in the ELF32 header
;; 0000002A  2000  ; e_phentsize
;; 0000002C  0100  ; e_phnum

_start:
		; stdout = 1
		inc	ebx
		; buffer = stack after push
		push eax
		mov	ecx, esp
_loop:
		; compute (2*t&0xfb)*(t>>5|t>>9|t>>10)
		; edi = t
		mov esi, edi
		shr esi, 1
		jmp _skip_data
_phdr_data:
		dw 0x20  ; e_phentsize
		dw 1     ; e_phnum
_skip_data:
		or esi, edi
		shr esi, 4
		or esi, edi
		shr esi, 5
		pop eax
		mov eax, edi
		and al, 0x7d
		mul esi
		shl eax, 1
		push eax
		xor eax, eax
		mov al, 4    ; syscall: write
		mov	dl, 1    ; length: 1
		int	0x80			; eax = write(ebx, ecx, edx)
		inc edi			  ; t++
		jmp _loop

