-- fft cart for mountain bytes'
-- set by CoLD SToRAGE by mantratronic
-- 
-- modified from a monday night bytes
-- jam cart on 2024/01/08 by 
-- mantratronic + jtruk 

M=math
S=M.sin
C=M.cos
A=M.abs
TAU=M.pi*2
function rot(x,y,a)
 return {x*C(a)-y*S(a),y*C(a)+x*S(a)}
end
cls(0)	

T=0
fftm={}
fftn={}
for i=0,255 do
	fftm[i]=0
	fftn[i]=0
end
LA={}
nLA=3+(M.random()*13)//1
for i=1,nLA do
LA[i]={x=10*S(i*TAU),y=10*C(i*TAU),z=10*S(i/nLA*TAU),a=10,b=28,c=8/3,dt=0.002}
--LA[i]={x=0.1+i,y=0,z=0,a=10,b=28,c=8/3,dt=0.002}
end
BUMP=M.random()*1000

function BOOT()

end


function mBDR1(y)
 local ry=S(y/200+T/50)*48+48
 local gy=S(y/200+T/50+TAU/3)*48+48
 local by=S(y/200+T/50+2*TAU/3)*48+48
 for i=0,15 do
 poke(0x3fc0+i*3, (i/15)*ry)
 poke(0x3fc0+i*3+1, (i/15)*gy)
 poke(0x3fc0+i*3+2, (i/15)*by)
 end
end
function mBDR2(y)
 local ry=S(y/100+T/51)*48+48
 local gy=S(y/100+T/51+TAU/3)*48+48
 local by=S(y/100+T/51+2*TAU/3)*48+48
 for i=1,4 do
 poke(0x3fc0+i*3, (i/4+1)*by)
 poke(0x3fc0+i*3+1, (i/4+1)*ry)
 poke(0x3fc0+i*3+2, (i/4+1)*gy)
 end
 for i=5,8 do
 poke(0x3fc0+i*3, ((i-4)/4+1)*by)
 poke(0x3fc0+i*3+1, ((i-4)/4+1)*gy)
 poke(0x3fc0+i*3+2, ((i-4)/4+1)*ry)
 end
 for i=9,12 do
 poke(0x3fc0+i*3, ((i-8)/4+1)*gy)
 poke(0x3fc0+i*3+1, ((i-8)/4+1)*ry)
 poke(0x3fc0+i*3+2, ((i-8)/4+1)*by)
 end
 for i=13,15 do
 poke(0x3fc0+i*3, ((i-12)/4+1)*gy)
 poke(0x3fc0+i*3+1, ((i-12)/4+1)*by)
 poke(0x3fc0+i*3+2, ((i-12)/4+1)*ry)
 end
end
topdelay=0
function mTIC()
 vbank(0)
 memcpy(0x8000,0,120*136)
	cls(12)	
 memcpy(120,0x8000,120*135)
	for x=0,240 do
		pix(x,y,fftn[x]*15)
	end
 vbank(1)
 if topdelay<2 then
 memcpy(0x8000,0,120*136)
	cls(0)	
 memcpy(120,0x8000,120*135)
 end
 topdelay = topdelay + 1
 if topdelay>2 then
  topdelay = 0
 end
	
	for i=0,99 do
	 local x=M.random(240)-1
	 local y=M.random(136)-1
		local col = pix(x,y)
		if col <13 then
 		circb(x,y,y/50+1,col)
  end
	end
	
	for i=1,nLA do
	 for j=1,fftn[(i/nLA*10)//1]*6+1 do
 	 local xt = LA[i].x + LA[i].dt*LA[i].a*(LA[i].y-LA[i].x)
 		local yt = LA[i].y + LA[i].dt*(LA[i].x*(LA[i].b-LA[i].z)-LA[i].y)
 		local zt = LA[i].z + LA[i].dt*(LA[i].x*LA[i].y-LA[i].c*LA[i].z)
 		LA[i].x=xt
 		LA[i].y=yt
 		LA[i].z=zt
 		local P=rot(LA[i].x,LA[i].y, T/100+i/(nLA-1)*2*M.pi)
 		local sx=P[1]*3
 		local sy=P[2]*2.5
 		
 		circ(sx+120,sy+68,1+LA[i].z/50,i/nLA*15+1)
  end
	end
end


function BDR(y)
 vbank(0)
 mBDR1(y)
 vbank(1)
 mBDR2(y)
end


function TIC()
	T=time()/100+BUMP
	for i=0,255 do
		fftm[i]=M.max(fftm[i]-0.0001*(1-(i+1)/256)^2,fft(i))
		fftn[i]=(fft(i)/fftm[i])*.2 + fftn[i]*.8
	end

 mTIC()
end



-- <WAVES>
-- 000:00000000ffffffff00000000ffffffff
-- 001:0123456789abcdeffedcba9876543210
-- 002:0123456789abcdef0123456789abcdef
-- </WAVES>

-- <PALETTE>
-- 000:1a1c2c5d275db13e53ef7d57ffcd75a7f07038b76425717929366f3b5dc941a6f673eff7f4f4f494b0c2566c86333c57
-- </PALETTE>

