varying vec2 texCoord;
uniform sampler2D colorMap;
uniform sampler2D displaceMap;
uniform sampler2D dispnormalMap;
uniform int offx;
uniform int offy;
uniform float angle;
uniform float timer;
uniform float testvalue;


vec2 GetGradient(vec2 intPos, float t) {

    // Uncomment for calculated rand
    float rand = fract(sin(dot(intPos, vec2(12.9898, 78.233))) * 43758.5453);;

    // Texture-based rand (a bit faster on my GPU)
    //float rand = texture(iChannel0, intPos / 64.0).r;

    // Rotate gradient: random starting rotation, random rotation rate
    float angle = 6.283185 * rand + 4.0 * t * rand;
    return vec2(cos(angle), sin(angle));
}


float Pseudo3dNoise(vec3 pos) {
    vec2 i = floor(pos.xy);
    vec2 f = pos.xy - i;
    vec2 blend = f * f * (3.0 - 2.0 * f);
    float noiseVal =
        mix(
            mix(
                dot(GetGradient(i + vec2(0, 0), pos.z), f - vec2(0, 0)),
                dot(GetGradient(i + vec2(1, 0), pos.z), f - vec2(1, 0)),
                blend.x),
            mix(
                dot(GetGradient(i + vec2(0, 1), pos.z), f - vec2(0, 1)),
                dot(GetGradient(i + vec2(1, 1), pos.z), f - vec2(1, 1)),
                blend.x),
        blend.y
    );
    return noiseVal / 0.7; // normalize to about [-1..1]
}

vec4 noiseColor;
void mainImage(vec2 fragCoord) {

	vec2 uv = fragCoord.xy;// / 1080.0f;
	uv.x=uv.x*(1920.0f/1080.0f);

    // Mouse up: show one noise channel

    //if (iMouse.z <= 0.0)
    {
        float noiseVal = 0.5 + 0.5 * Pseudo3dNoise(vec3(uv * 10.0, timer));
        noiseColor.rgb = vec3(noiseVal);
        noiseColor.a=1.0f;
    }

    // Mouse down: layered noise
    /*
    else {
		const int ITERATIONS = 10;
        float noiseVal = 0.0;
        float sum = 0.0;
        float multiplier = 1.0;
        for (int i = 0; i < ITERATIONS; i++) {
            vec3 noisePos = vec3(uv, 0.2 * timer / multiplier);
            noiseVal += multiplier * abs(Pseudo3dNoise(noisePos));
            sum += multiplier;
            multiplier *= 0.6;
            uv = 2.0 * uv + 4.3;
        }
        noiseVal /= sum;

        // Map to a color palette
        noiseColor.rgb = 0.5 + 0.5 * cos(6.283185 * (3.0 * noiseVal + vec3(0.15, 0.0, 0.0)));
        noiseColor.a=1.0f;
    }
    */
}



void main (void)
{
const float factor=15.0f;//30
//vec2 ftexCoord=texCoord;

//if (texCoord.y<1.7f/5.0f||texCoord.y>3.3f/5.0f)
if (false)
    gl_FragColor = texture2D(colorMap,texCoord);
else
{
    vec2 uv = texCoord.xy;// / vec2(1920.0f,1080.0f);
    float rot=angle;
    uv-=.5;
    const float a=1920.0f/1080.0f;
    const float z=1.0f/1.35f;
    uv.x*=a;
    float c=cos(rot);
    float s=sin(rot);
    mat2 m = mat2(c, -s, s, c);
    uv  = m * uv * z;
    uv.x/=a;
    uv+=.5;

    //ftexCoord.x=floor(ftexCoord.x*1920.0f)/1920.0f;
    //ftexCoord.y=floor(ftexCoord.y*1080.0f)/1080.0f;
    //float displace=texture2D(displaceMap, ftexCoord+vec2(float(offx)/1920.0f,float(offy)/1080.0f)).r;
    float displace=texture2D(displaceMap, uv+vec2(float(offx)/1920.0f,float(offy)/1080.0f)).r;
    vec2 displacedcoord=texCoord+vec2(displace/factor,displace/factor);

    vec4 dispnormal=texture2D(dispnormalMap, texCoord+vec2(0.0f,angle));
    vec2 displacedcoord2=vec2(dispnormal.r/1920.0f*2.5f,dispnormal.g/1080.0f*2.5f);
    displacedcoord2.x=clamp(displacedcoord2.x,0.0f,1.0f);
    displacedcoord2.y=clamp(displacedcoord2.y,0.0f,1.0f);
    //displacedcoord+=displacedcoord2;
    displacedcoord+=vec2(0.001f,0.001f);
    displacedcoord.x=(displacedcoord.x-0.5f)/1.15f+0.5f;
    displacedcoord.y=(displacedcoord.y-0.5f)/1.15f+0.5f;

    mainImage(texCoord.xy);
    vec2 displacedcoord3=displacedcoord+(noiseColor.xy/20.0f);
    displacedcoord3.x=clamp(displacedcoord3.x,0.0f,1.0f-1.0f/1080.0f);
    displacedcoord3.y=clamp(displacedcoord3.y,0.0f,1.0f-1.0f/1080.0f);

    vec4 pixel=texture2D(colorMap,displacedcoord3);
    //pixel=dispnormal;

    //gl_FragColor =texture2D(colorMap, texCoord);
    gl_FragColor = pixel;

    //gl_FragColor = vec4(1.0f,0.0f,0.0f,1.0f);
}
}

