uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D fxMap;
uniform float iTime;
uniform float qscale;
uniform float testvalue;

uniform vec3 rayorigin;
uniform vec3 raydirection;
uniform vec3 upvector;
uniform float fov;

#define inf 1000000.0
#define M_PI 3.1415926

vec2 p;

float rand(in vec4 p) {
	
    float sc=0.01;
    vec4 col = texture2D(iChannel0,vec2(p.x/sc,p.y/sc)); 
    
    float pxy=col.r;
    
	
	return fract(sin(p.x*1234. + p.y*2345. + p.z*3456. + p.w*4567.) * 5678.);+pxy;
}

float smoothnoise(in vec4 p) {
    const vec2 e = vec2(0.0, 1.0);
    vec4 i = floor(p);    
    vec4 f = fract(p);    
    
    f = f * f * (3. - 2. * f);
    
    return mix(mix(mix(mix(rand(i + e.xxxx),
                           rand(i + e.yxxx), f.x),
                       mix(rand(i + e.xyxx),
                           rand(i + e.yyxx), f.x), f.y),
                   mix(mix(rand(i + e.xxyx),
                           rand(i + e.yxyx), f.x),
                       mix(rand(i + e.xyyx),
                           rand(i + e.yyyx), f.x), f.y), f.z),
               mix(mix(mix(rand(i + e.xxxy),
                           rand(i + e.yxxy), f.x),
                       mix(rand(i + e.xyxy),
                           rand(i + e.yyxy), f.x), f.y),
                   mix(mix(rand(i + e.xxyy),
                           rand(i + e.yxyy), f.x),
                       mix(rand(i + e.xyyy),
                           rand(i + e.yyyy), f.x), f.y), f.z), f.w);
}

float noise4d(in vec4 p) {

    float s = 0.;
    float pow2 = 1.;
    for (int i = 0; i < 4; ++i) {
        float value=smoothnoise(p * pow2) / pow2;
	    s += value;
        pow2 *= 2.;
    }
    return s / 2.;
}

float sdEllipsoid( in vec3 p, in vec3 r ) 
{
    float k0 = length(p/r);
    float k1 = length(p/(r*r));
    return k0*(k0-1.0)/k1;
}

float flevelRange(float color, float minInput, float maxInput){
    return min(max(color - minInput, 0.0) / (maxInput - minInput), 1.0);
}

float hash2(vec3 p)  
{
    p  = fract( p*0.3183099+.1 );
	p *= 17.0;
    return fract( p.x*p.y*p.z*(p.x+p.y+p.z) );
}

float noisefast2( in vec3 x )
{
    vec3 i = floor(x);
    vec3 f = fract(x);
    f = f*f*(3.0-2.0*f);
	
    return mix(mix(mix( hash2(i+vec3(0,0,0)), 
                        hash2(i+vec3(1,0,0)),f.x),
                   mix( hash2(i+vec3(0,1,0)), 
                        hash2(i+vec3(1,1,0)),f.x),f.y),
               mix(mix( hash2(i+vec3(0,0,1)), 
                        hash2(i+vec3(1,0,1)),f.x),
                   mix( hash2(i+vec3(0,1,1)), 
                        hash2(i+vec3(1,1,1)),f.x),f.y),f.z);
}

float fbm(vec4 x){
    
    
    
    
    
    

    float res=noise4d(x);
    return res;
}

float noisefast( in vec3 x )
{
    ivec3 i = ivec3(floor(x));
    vec3 f = fract(x);
	f = f*f*(3.0-2.0*f);
	ivec2 uv = i.xy + ivec2(37,17)*i.z;
	vec2 rgA = texelFetch( iChannel0, (uv+ivec2(0,0))&255, 0 ).yx;
    vec2 rgB = texelFetch( iChannel0, (uv+ivec2(1,0))&255, 0 ).yx;
    vec2 rgC = texelFetch( iChannel0, (uv+ivec2(0,1))&255, 0 ).yx;
    vec2 rgD = texelFetch( iChannel0, (uv+ivec2(1,1))&255, 0 ).yx;
    vec2 rg = mix( mix( rgA, rgB, f.x ),
                   mix( rgC, rgD, f.x ), f.y );
    return mix( rg.x, rg.y, f.z );
}

float fbmold(vec3 x){
    float res=noisefast(x/4.0);
    return res;
}

float animate=0.0f;

vec4 map_cloud2(vec3 pos){
    pos*=0.65;
    pos.y+=10.0;
    pos.x+=20.0;
    const float slowdown=0.5;
    float time=2.0*iTime*2.5*slowdown*1.5;
    float time2=0.0;
    
    
    
    

    

    

    
pos*=3.0f;

    vec4 uv;
    
    uv=vec4(pos.xyz,0.0);
    
    
    
    
    
    



		float f,a;
        
        float m=1.0/1.4;
        

        
        
        
        uv/=7.5*0.3; 
        time *= 4.0;
        time *= 2.2*slowdown/2.0/5.0/10.0/3.0*0.45;
        vec4 anim=vec4(0.0,0.0,0.0,time/1.15f);
        
        float anim1=1.0+0.01*0.09*12.5*0.2;
        
		f  = 1.1000*fbm( uv +anim); uv = m*uv; anim*=anim1;
		
		
        







        a=f; 
    
    


    
    if (f<0) return vec4(0);
    a/=1.66;
    
    a=flevelRange(a,0.25,0.7);
    float wtime=time*1.7;
    
    float a2=texture2D(fxMap,vec2(wtime,a)).x;
    
    
    
    
    
    
    
    vec2 uf=vec2(a/2.0+0.2,a/2.0+0.2)*p*0.5+0.5+vec2(a2,a);
    

    float r=texture2D(iChannel1,uf).r;
    float g=texture2D(iChannel1,uf).g;
    float b=texture2D(iChannel1,uf).b;
    return vec4(r,g,b,a2);
    return vec4(r,g,b,1.0)*a2;

    return vec4(a2);
    return vec4(1.0,1.0,1.0,a);
}








#define time iTime*0.25
#define PI 3.14159265359

#define NOISE_METHOD 1
float noise( in vec3 x )
{

    x.y+=iTime;
     x.x-=iTime*1.2;
     x.z+=iTime*1.3;

    
    
    vec3 p = floor(x);
    vec3 f = fract(x);
	f = f*f*(3.0-2.0*f);

#if NOISE_METHOD==0
    
    
     
     
    return texture2D(iChannel2,(x+0.5)/32.0).y*2.0-1.0;
    return textureLod(iChannel2,(x+0.5)/32.0,0.0).x*2.0-1.0;
#endif
#if NOISE_METHOD==1
    
	vec2 uv = (p.xy+vec2(37.0,239.0)*p.z) + f.xy;
    vec2 rg = texture2D(iChannel0,(uv+0.5)/256.0).yx;
	return mix( rg.x, rg.y, f.z )*2.0-1.0;
#endif    
#if NOISE_METHOD==2
    ivec3 q = ivec3(p);
	ivec2 uv = q.xy + ivec2(37,239)*q.z;
	vec2 rg = mix(mix(texelFetch(iChannel0,(uv           )&255,0),
				      texelFetch(iChannel0,(uv+ivec2(1,0))&255,0),f.x),
				  mix(texelFetch(iChannel0,(uv+ivec2(0,1))&255,0),
				      texelFetch(iChannel0,(uv+ivec2(1,1))&255,0),f.x),f.y).yx;
	return mix( rg.x, rg.y, f.z )*2.0-1.0;
#endif
}

float noise2( in vec3 x )
{
    float iTime_=iTime*4.0;
    x.y+=iTime_*1.1;
     x.x-=iTime_*1.3;
     x.z+=iTime_*1.5;
    
    return noise(x);
}


mat3 rot(vec3 ang)
{
	mat3 x = mat3(1.0,0.0,0.0,0.0,cos(ang.x),-sin(ang.x),0.0,sin(ang.x),cos(ang.x));
	mat3 y = mat3(cos(ang.y),0.0,sin(ang.y),0.0,1.0,0.0,-sin(ang.y),0.0,cos(ang.y));
	mat3 z = mat3(cos(ang.z),-sin(ang.z),0.0,sin(ang.z),cos(ang.z),0.0,0.0,0.0,1.0);
	return x*y*z;
}

float noise3D(vec3 p)
{
	return fract(sin(dot(p ,vec3(12.9898,78.233,128.852))) * 43758.5453)*2.0-1.0;
}

float simplex3D(vec3 p)
{

	
    
     
       p.z+=iTime*2.75;
       p/=1.2;
    
	float f3 = 1.0/3.0;
	float s = (p.x+p.y+p.z)*f3;
	int i = int(floor(p.x+s));
	int j = int(floor(p.y+s));
	int k = int(floor(p.z+s));
	
	float g3 = 1.0/6.0;
	float t = float((i+j+k))*g3;
	float x0 = float(i)-t;
	float y0 = float(j)-t;
	float z0 = float(k)-t;
	x0 = p.x-x0;
	y0 = p.y-y0;
	z0 = p.z-z0;
	
	int i1,j1,k1;
	int i2,j2,k2;
	
	if(x0>=y0)
	{
		if(y0>=z0){ i1=1; j1=0; k1=0; i2=1; j2=1; k2=0; } 
		else if(x0>=z0){ i1=1; j1=0; k1=0; i2=1; j2=0; k2=1; } 
		else { i1=0; j1=0; k1=1; i2=1; j2=0; k2=1; }  
	}
	else 
	{ 
		if(y0<z0) { i1=0; j1=0; k1=1; i2=0; j2=1; k2=1; } 
		else if(x0<z0) { i1=0; j1=1; k1=0; i2=0; j2=1; k2=1; } 
		else { i1=0; j1=1; k1=0; i2=1; j2=1; k2=0; } 
	}
	
	float x1 = x0 - float(i1) + g3; 
	float y1 = y0 - float(j1) + g3;
	float z1 = z0 - float(k1) + g3;
	float x2 = x0 - float(i2) + 2.0*g3; 
	float y2 = y0 - float(j2) + 2.0*g3;
	float z2 = z0 - float(k2) + 2.0*g3;
	float x3 = x0 - 1.0 + 3.0*g3; 
	float y3 = y0 - 1.0 + 3.0*g3;
	float z3 = z0 - 1.0 + 3.0*g3;	
				 
	vec3 ijk0 = vec3(i,j,k);
	vec3 ijk1 = vec3(i+i1,j+j1,k+k1);	
	vec3 ijk2 = vec3(i+i2,j+j2,k+k2);
	vec3 ijk3 = vec3(i+1,j+1,k+1);	
            
	vec3 gr0 = normalize(vec3(noise3D(ijk0),noise3D(ijk0*2.01),noise3D(ijk0*2.02)));
	vec3 gr1 = normalize(vec3(noise3D(ijk1),noise3D(ijk1*2.01),noise3D(ijk1*2.02)));
	vec3 gr2 = normalize(vec3(noise3D(ijk2),noise3D(ijk2*2.01),noise3D(ijk2*2.02)));
	vec3 gr3 = normalize(vec3(noise3D(ijk3),noise3D(ijk3*2.01),noise3D(ijk3*2.02)));
	
	float n0 = 0.0;
	float n1 = 0.0;
	float n2 = 0.0;
	float n3 = 0.0;

	float t0 = 0.5 - x0*x0 - y0*y0 - z0*z0;
	if(t0>=0.0)
	{
		t0*=t0;
		n0 = t0 * t0 * dot(gr0, vec3(x0, y0, z0));
	}
	float t1 = 0.5 - x1*x1 - y1*y1 - z1*z1;
	if(t1>=0.0)
	{
		t1*=t1;
		n1 = t1 * t1 * dot(gr1, vec3(x1, y1, z1));
	}
	float t2 = 0.5 - x2*x2 - y2*y2 - z2*z2;
	if(t2>=0.0)
	{
		t2 *= t2;
		n2 = t2 * t2 * dot(gr2, vec3(x2, y2, z2));
	}
	float t3 = 0.5 - x3*x3 - y3*y3 - z3*z3;
	if(t3>=0.0)
	{
		t3 *= t3;
		n3 = t3 * t3 * dot(gr3, vec3(x3, y3, z3));
	}
	return 96.0*(n0+n1+n2+n3);
	
}

float fbm_(vec3 p)
{
    p*=0.75;
    
    
	float f;
    float ff=0.9;
    f  = 0.50000*simplex3D( p ); p = p*2.01*ff;
    f += 0.25000*simplex3D( p ); p = p*2.02*ff;
    f += 0.12500*simplex3D( p ); p = p*2.03*ff;
    f += 0.06250*simplex3D( p ); p = p*2.04*ff;
    f += 0.03125*simplex3D( p );
	return f;
}

float sdBox( vec3 p, vec3 b )
{
    vec3 d = abs(p) - b;
    return min(max(d.x,max(d.y,d.z)),0.0) + length(max(d,0.0));
}

float map(vec3 pos){
      float sc=0.8;
      float r=((0.5+(1.0+noise(pos*4.0))/5.0)+(1.0+noise(pos/2.5))/5.0);
      
      r/=7.5;
      r+=0.7;
    vec2 res = vec2( sdEllipsoid(    pos-vec3(-0.0,0.0, 0.0), 
               vec3(1.0*sc,1.0*sc,1.0*sc)*r*2.0), 26.9 );
    return res.x;
}

vec4 render( in vec3 ro, in vec3 rd, in vec2 fragCoord){
vec4 col=vec4(0.0);
    
    
    
    vec4 sum = vec4( 0.0 );
    
    
    float t = 0.1*(texture2D(iChannel0, fragCoord.xy/1024.0).r)/4.0;
    
    
    vec3 pos;
    float lighting;
    float su=2.0; 
    for( int i=0; i<1100/su*1.4; i++ )
    {
        if( sum.a > 0.8 ) break;
        pos = ro + t*rd;

        float r=sqrt(pos.x*pos.x+pos.y*pos.y);
        
          
        

        col = map_cloud2( pos.xyz )/1.2;

        
        

        
        
        col*=0.005;
        
        
        
        sum = sum + col*(1.0 - sum.a);
        t += 0.002*su;
    }
    
    

    
    

    return sum;

    vec3 cloudcol=vec3(sum.r);
    
    
    col=vec4(cloudcol,sum.a);

    
    
    
    return col.rgba;
}

mat3 setCamera( in vec3 ro, in vec3 ta, float cr )
{

    vec3 cw = normalize(ta-ro);

    
    vec3 cp = upvector;
    

    vec3 cu = normalize( cross(cw,cp) );
    vec3 cv = normalize( cross(cu,cw) );
    return mat3( cu, cv, cw );
}


void main()
{
    vec2 iResolution = vec2(1920/4,1080/4);

    vec2 fragCoord=gl_FragCoord;
    vec2 uv = fragCoord/iResolution.xy;
	p = uv*2.0-1.0;
	p.x*=(iResolution.x/iResolution.y);
	vec4 col = vec4(0.05);

    vec3 ro = vec3(0.0,0.0,-1.0);
    vec3 rd = normalize(vec3(p,0.0)-ro);

    
    
    
    

    vec3 rp = ro;
    



















    const float fl = 2.5; 
    ro=rayorigin;
    vec3 ta=raydirection;
    
    
    mat3 ca = setCamera( ro, ta, 0.0 );
    

    float fov_=fov;
    rd = ca * normalize( vec3(p.x,p.y,fov_ ) );


    
    col=render(ro,rd,fragCoord);
    float powf=0.75;
    col.r=pow(col.r,powf);
    col.g=pow(col.g,powf);
    col.b=pow(col.b,powf);
    
    
    
    
	
    gl_FragColor = col;
}
