#version 120

precision highp float;
#define MAX_LIGHTS 14
in vec3 alightVec[MAX_LIGHTS];

in vec2 texCoord;

in vec3 v;
in vec3 N;
in vec3 T;
in vec3 B;

uniform float xcoo;
uniform float ycoo;
in vec3 vcam;
in vec4 vcam4;
uniform float lens;
uniform float size;

uniform vec4 flash;
uniform vec4 glColor;
uniform vec3 camPos;

uniform float lightsPosx[MAX_LIGHTS];
uniform float lightsPosy[MAX_LIGHTS];
uniform float lightsPosz[MAX_LIGHTS];



uniform float lightsEnabled[MAX_LIGHTS];
uniform float lightsinvRadius[MAX_LIGHTS];
uniform float lightMapSelect[MAX_LIGHTS];


uniform float lightsAmbientr[MAX_LIGHTS];
uniform float lightsAmbientg[MAX_LIGHTS];
uniform float lightsAmbientb[MAX_LIGHTS];

uniform float lightsDiffuser[MAX_LIGHTS];
uniform float lightsDiffuseg[MAX_LIGHTS];
uniform float lightsDiffuseb[MAX_LIGHTS];

uniform float lightsSpecularr[MAX_LIGHTS];
uniform float lightsSpecularg[MAX_LIGHTS];
uniform float lightsSpecularb[MAX_LIGHTS];



uniform sampler2D colorMap;
uniform sampler2D normalMap;
uniform sampler2D lightMap;
uniform sampler2D specularMap;




const int maxnumalights=16;
uniform float widths[maxnumalights];
uniform float heights[maxnumalights];
uniform vec3 pnormals[maxnumalights];
uniform vec3 right[maxnumalights];


uniform int renderingmirror;
uniform vec4 clipeq;

vec3 CalcBumpedNormal()
{
    vec3 Normal = N;
    vec3 Tangent = T;
    Tangent = normalize(Tangent - dot(Tangent, Normal) * Normal);
    
    vec3 Bitangent = B;
    vec3 BumpMapNormal = texture2D(normalMap, texCoord).xyz;
    BumpMapNormal = 2.0 * BumpMapNormal - vec3(1.0, 1.0, 1.0);
    vec3 NewNormal;
    mat3 TBN = mat3(Tangent, Bitangent, Normal);
    NewNormal = TBN * BumpMapNormal;
    NewNormal = normalize(NewNormal);
    return NewNormal;
}




vec3 projectOnPlane(in vec3 p, in vec3 pc, in vec3 pn)
{
    float distance = dot(pn, p-pc);
    return p - distance*pn;
}
int sideOfPlane(in vec3 p, in vec3 pc, in vec3 pn){
   if (dot(p-pc,pn)>=0.0) return 1; else return 0;
}
vec3 linePlaneIntersect(in vec3 lp, in vec3 lv, in vec3 pc, in vec3 pn){
   return lp+lv*(dot(pn,pc-lp)/dot(pn,lv));
}

float calculateAttenuation(in int i, in float dist)
{
    
    
    return clamp(1.0 - lightsinvRadius[i] * sqrt(dist), 0.0, 1.0);
}










void main (void)
{

    vec3 lightVec;
    vec3 eyeVec;
    vec4 accvDiffuse = vec4(0.0);
    vec4 accvSpecular = vec4(0.0);
    float distSqr;
    vec3 lVec;
    vec3 vVec;
    float att;
    vec4 base;
    vec4 vAmbient;
    vec3 bump;
    float diffuse;
    vec4 vDiffuse;
    vec4 vSpecular;
    float specular;
    vec3 nrmltexture;
    vec3 V=v;
    vec3 N_=CalcBumpedNormal();

    base = texture2D(colorMap, texCoord);




    if (renderingmirror>0 && dot(clipeq, vec4(v,1.0)) < 0)
    {
        discard;
    }




vec4 aambient=vec4(0,0,0,0);
vec4 adiffuse=vec4(0,0,0,0);
vec4 aspecular=vec4(0,0,0,0);







































































    
    
    
    
    
    
    
    
    float div=vcam4.w;
    float rx=(vcam4.x/div/2.0-0.5)-xcoo;
    float ry=(vcam4.y/div/2.0-0.5)-ycoo;
    float u,v;
    u=0.5+rx/(size); v=0.5+ry/(size);
    
    
    vec2 uv=vec2(rx,ry)/size;

	
    

    float d=length(uv);
    float z = sqrt(1.0 - d * d);
    
    float r = atan(d, z) / 2.9;
    float phi = atan(uv.y, uv.x);
    
    uv = vec2(r*cos(phi)+.5,r*sin(phi)+.5);
    vec2 coo=vec2(xcoo,ycoo)+uv*size;
    
    
    
    
    coo.x=clamp(coo.x,-1.0+1.0/1920.0,0.0-1.0/1920.0);
    coo.y=clamp(coo.y,-1.0+1.0/1080.0,0.0-1.0/1080.0);
    gl_FragColor = (texture2D(lightMap, coo)*vec4(1.0,1.0,1.0,glColor.b*1.35));
    
}

