#version 450

#include "/shaders/math.glsl"

layout (location = 0) in vec3 a_position;
layout (location = 1) in vec3 a_normal;
layout (location = 2) in vec3 a_tangent;
layout (location = 3) in vec2 a_uv;

layout (location = 0) out vec2 v_uv;

layout (set = 0, binding = 0) uniform Context {
    mat4 g_projection_from_model;
    float height;
    float offset;
    float scale;
};

void main() {
    vec3 pos = a_position.xzy * (scale + 0.5);
    float h = height + 0.25;
    pos.y *= h;

    gl_Position = g_projection_from_model * vec4(pos, 1.0);
    v_uv = a_uv;
    v_uv.y *= h;
    v_uv.y += offset;
}