string Description = "This shader reduces the scene to black and white except for a chosen hue. Use the power value to select how many nearby hues are also preserved";
string Thumbnail = "ColorHighlight.png";

float2 ViewSize : ViewSize;

//scene image
texture frame : RENDERCOLORTARGET
< 
	string ResourceName = "";
	float2 ViewportRatio = { 1.0, 1.0 };
>;

sampler2D frameSamp = sampler_state {
    Texture = < frame >;
    MinFilter = Linear; MagFilter = Linear; MipFilter = Linear;
    AddressU = Clamp; AddressV = Clamp;
};

struct input 
{
	float4 pos : POSITION;
	float2 uv : TEXCOORD0;
};
 
struct output {

	float4 pos: POSITION;
	float2 uv: TEXCOORD0;

};

output VS( input IN ) 
{
	output OUT;

	//needs to be shifted by half a pixel.
    //Go here for more info: http://www.sjbrown.co.uk/?article=directx_texels
    
	float4 oPos = float4( IN.pos.xy + float2( -1.0f/ViewSize.x, 1.0f/ViewSize.y ),0.0,1.0 );
	OUT.pos = oPos;

	float2 uv = (IN.pos.xy + 1.0) / 2.0;
	uv.y = 1 - uv.y; 
	OUT.uv = uv;
	
	return OUT;	
}

float4 PSBNW( output IN, uniform sampler2D srcTex ) : COLOR
{
    float4 color = tex2D(srcTex,IN.uv);
    color.xyz = (color.x + color.y + color.z)/3.0;
    return color;
}

//2.0a version for NVIDIA cards
technique BlackAndWhite
<
	//the initial texture we want DarkBASIC Professional to place the scene
	string RenderColorTarget = "frame";
>
{
	pass BlackAndWhite
	<
		//use a blank render target to draw to the screen
		string RenderColorTarget = "";
	>
	{
		ZEnable = False;
		VertexShader = compile vs_1_1 VS();
		PixelShader = compile ps_2_a PSBNW( frameSamp );
	}
}

//2.0b version for ATI cards
technique BlackAndWhite
<
	string RenderColorTarget = "frame";
>
{
	pass BlackAndWhite
	<
		string RenderColorTarget = "";
	>
	{
		ZEnable = False;
		VertexShader = compile vs_1_1 VS();
		PixelShader = compile ps_2_b PSBNW( frameSamp );
	}
}
