string Description = "";

float4x4 World : World;
float4x4 WorldView : WorldView;
float4x4 WorldViewProj : WorldViewProjection;
float Time: Time;
float sintime : SinTime;

float SpriteRows : Power
<
    string UIName =  "Rows";
    string UIWidget = "slider";
    float UIMin = 1.0;
    float UIMax = 16.0;
    float UIStep = 1.0;
> = 8.000000;

float SpriteColumns : Power
<
    string UIName =  "Columns";
    string UIWidget = "slider";
    float UIMin = 1.0;
    float UIMax = 16.0;
    float UIStep = 1.0;
> = 8.000000;

float FramesPerSec : Power
<
    string UIName =  "Frames Per Second";
    string UIWidget = "slider";
    float UIMin = 0.0;
    float UIMax = 30.0;
    float UIStep = 0.5;
> = 25.000000;

float Looptime : Power
<
    string UIName =  "Loop Time";
    string UIWidget = "slider";
    float UIMin = 1.0;
    float UIMax = 200.0;
    float UIStep = 1.0;
> = 100.000000;

// RENDERCOLORTARGET simply indicates that we are using an RT (depth texture at bottom)
texture DiffuseMap : RENDERCOLORTARGET
<
    string Name = "D.dds";
    string type = "2D";
    string ResourceName = ""; 
>;

sampler2D DiffuseSampler = sampler_state
{
    Texture   = <DiffuseMap>;
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};

struct appdata 
{
    float4 Position	: POSITION;
    float4 UV0		: TEXCOORD0;
    float4 UV1		: TEXCOORD1;
    float4 Normal	: NORMAL;
};

struct vertexOutput
{
    float4 Position : POSITION;
    float2 atlasUV  : TEXCOORD0;
    float4 WPos    	: TEXCOORD1;
};

vertexOutput mainVS(appdata IN)   
{
	vertexOutput OUT;
    OUT.Position = mul(IN.Position, WorldViewProj);
	float2 DimensionsXY = float2(SpriteRows,SpriteColumns); 
	float2 atlasUVtemp = IN.UV0; 				
	float loopcounter  = floor(Time/Looptime);
	float offset = Looptime*loopcounter;
	float speed =(Time*FramesPerSec) - (offset*FramesPerSec);
	float index = floor( speed);
	float rowCount = floor( (index / DimensionsXY.y) );
	float2 offsetVector = float2(index, rowCount);
	float2 atlas = (1.0 / DimensionsXY) ;
	float2 move = (offsetVector + atlasUVtemp);
	OUT.atlasUV = (atlas.xy * move);
	OUT.WPos = float4(mul(IN.Position, World).xyz,7000-mul(IN.Position, WorldView).z);
    return OUT;
}

float4 mainPS(vertexOutput IN) : COLOR
{
    float4 diffuse = tex2D(DiffuseSampler,IN.atlasUV.xy);
    return diffuse;
}

float4 mainPS_renderdepth(vertexOutput IN) : COLOR
{
	clip(-1);
	//clip(tex2D(DiffuseSampler,IN.atlasUV.xy).a-0.124);
	return IN.WPos.wxyz;
}

technique All
{
    pass RenderDepthPixelsPass
	<
		string RenderColorTarget = "[depthtexture]";
	>
    {
        // shaders
        VertexShader = compile vs_3_0 mainVS();
        PixelShader  = compile ps_3_0 mainPS_renderdepth();
        AlphaTestEnable = false;
    }
    pass MainPass
	<
		string RenderColorTarget = "";
	>
    {
        VertexShader = compile vs_3_0 mainVS();
        PixelShader  = compile ps_3_0 mainPS();
        Lighting         = FALSE;
        FogEnable        = FALSE;
        AlphaBlendEnable = TRUE;
        AlphaTestEnable  = FALSE;
		ZWriteEnable     = FALSE;
    }
}
