.pc =$0801 "Basic Upstart Program"

.var music = LoadSid("Revenge_2_part_14.sid")

:BasicUpstart($1730)


.pc = $1730 "Main Program"



///////////////////////////////////////////////
////////// 1 pix RGB scroller Precalc ////////
/////////////////////////////////////////////

////////////
// clear //
//////////
	lda #$00
	ldx #$00
clr:	sta $2000,x
	sta $2100,x
	sta $2200,x
	sta $2300,x
	sta $2400,x
	sta $2500,x
	sta $2600,x

	

	inx
	cpx #00
	bne clr

///////////
// init //
/////////
	ldx #$00
sp_copy:
	lda sprite,x
	sta $2000,x
	sta $2500,x

	sta $2040,x
	sta $2540,x
	
	inx
	cpx #$40
	bne sp_copy


	

	ldx #$00
col_copy:
	lda colorpos,x
	tay
	lda colorvalue,x
	sta $2f00,y

	inx
	cpx#$08
	bne col_copy
	


	

start:


//////////////////////////////////
// Balra tolt 12 frame Precalc //
////////////////////////////////

	ldy #$00
loop:	
	clc

	lda lo,y
	sta p3+1
	adc #$01
	sta p1+1
	adc #$01
	sta p+1

	lda hi,y
	sta p+2
	sta p1+2
	sta p3+2

	lda lo+1,y
	sta p4+1
	adc #$01
	sta p2+1
	adc #$01
	sta p0+1

	lda hi+1,y
	sta p0+2
	sta p2+2
	sta p4+2

	

	ldx #$00	
eltol:

p:	lda nspr+2,x
	asl
	and sprite+2,x
p0:	sta nspr+2,x



p1:	lda nspr+1,x
	rol
	and sprite+1,x
p2:	sta nspr+1,x
	


p3:	lda nspr,x
	rol
	and sprite,x
p4:	sta nspr,x

	inx
	inx
	inx
	
	cpx #63
	bne eltol
	

	iny

	cpy #19
	bne loop



///////////////////////////////////
// Jobbra tolt 12 frame Precalc //
/////////////////////////////////

	ldy #$00
loop2:	
	clc

	lda lo,y
	sta q+1
	adc #$01
	sta q1+1
	adc #$01
	sta q3+1

	lda hi2,y
	sta q+2
	sta q1+2
	sta q3+2


	lda lo+1,y
	sta q0+1
	adc #$01
	sta q2+1
	adc #$01
	sta q4+1

	lda hi2+1,y
	sta q0+2
	sta q2+2
	sta q4+2



	ldx #$00	
eltol2:

q:	lda nspr,x
	lsr
	and sprite,x
q0:	sta nspr,x


q1:	lda nspr+1,x
	ror
	and sprite+1,x
q2:	sta nspr+1,x
	

q3:	lda nspr+2,x
	ror
	and sprite+2,x
q4:	sta nspr+2,x

	inx
	inx
	inx
	
	cpx #63
	bne eltol2

	iny

	cpy #19
	bne loop2



//////////////
// Metszet //
////////////
	ldx #$00
cut:
	lda $2000,x
	and $2500,x
	sta $2a00,x

	lda $2100,x
	and $2600,x
	sta $2b00,x

	lda $2200,x
	and $2700,x
	sta $2c00,x

	lda $2300,x
	and $2800,x
	sta $2d00,x

	lda $2400,x
	and $2900,x
	sta $2e00,x

	inx
	cpx #$00
	bne cut


//////////////////
// sprite init //
////////////////



	//7es leghátul, 0as legfelul!

	lda #$55
	sta $d00b
	sta $d009
	sta $d007
	sta $d005
	sta $d003
	sta $d001


	//alap pixel

	lda #$02
	sta $d02c //RED

	lda #$05
	sta $d02b //GREEN

	lda #$06
	sta $d02a //BLUE
	
	lda #$80	// mind teli pixel
	sta $07fd
	sta $07fc
	sta $07fb

	lda #25
	sta $d00a

	lda #25
	sta $d008

	lda #25
	sta $d006


	//subpixel

	lda #$80	//9e az ures!
	sta $07fa	//bal metszet
	sta $07f9	//jobb metszet
	sta $07f8	//kozep

	lda #25
	sta $d004
	sta $d002
	sta $d000

	lda #$01	// RGB=1  RG=4
	sta $d027

	lda #$03	// GB=3
	sta $d028

	lda #$07	// RG=7
	sta $d029


	lda $d020
	sta eredeti1
	sta eredeti3
	lda $d021
	sta eredeti2
	sta eredeti4



	

	
	


	sei
	lda #$7f
	sta $dc0d
	lda #$81
	sta $d01a
	lda #<intro
	sta $0314
	lda #>intro
	sta $0315
	lda #$02		//$59 a mainpartnak
	sta $d012
	lda #$1b
	sta $d011


	


	lda #$00
	tax
	tay
	jsr $1048


	cli





enddd:


	jmp enddd


irq:

	inc $d019



//////////////
//RGB setup//
////////////





	lda dpos
	clc
	adc #2
	sta $d00a

	lda #48
	sec
	sbc dpos
	sta $d006

	lda visible
	sta $d015
	lda kozep
	sta $d027

	ldx dpos
	lda sub1,x
	sta $07fa
	lda sub2,x
	sta $07f9
	lda sub3,x
	sta $07f8



//////////// 2:
	clc
	lda $d012
	adc #23
ch2:	cmp $d012
	bne ch2



	lda visible+1
	sta $d015
	lda kozep+1
	sta $d027

	lda #$5a+24
	sta $d00b
	sta $d009
	sta $d007
	sta $d005
	sta $d003
	sta $d001



//////////// 3:
	clc
	lda $d012
	adc #23
ch3:	cmp $d012
	bne ch3



	lda visible+2
	sta $d015
	lda kozep+2
	sta $d027


	lda #$5a+24*2
	sta $d00b
	sta $d009
	sta $d007
	sta $d005
	sta $d003
	sta $d001



//////////// 4:
	clc
	lda $d012
	adc #24
ch4:	cmp $d012
	bne ch4



	lda visible+3
	sta $d015
	lda kozep+3
	sta $d027

	lda #$5a+24*3
	sta $d00b
	sta $d009
	sta $d007
	sta $d005
	sta $d003
	sta $d001


//////////// 5:
	clc
	lda $d012
	adc #23
ch5:	cmp $d012
	bne ch5



	lda visible+4
	sta $d015
	lda kozep+4
	sta $d027


	lda #$5a+24*4
	sta $d00b
	sta $d009
	sta $d007
	sta $d005
	sta $d003
	sta $d001

//////////// reset
	clc
	lda $d012
	adc #22
ch6:	cmp $d012
	bne ch6

	lda #$5a
	sta $d00b
	sta $d009
	sta $d007
	sta $d005
	sta $d003
	sta $d001




////////////////
//pos limiter//
//////////////

	inc counter1
	lda counter1
	cmp #$02
	bne marad
	
	lda #$00
	sta counter1
	

	inc pos
	lda pos
	cmp #16
	bne marad

	jsr pottyez	//ha osszeallt az rgb konvertaljuk CHR modba
	
	lda #$00
	sta pos
	inc chr
	lda chr
	cmp #147	//txt hossz :)
	bne marad
	// innen ugrunk majd a scrollerre
	lda #$00
	sta chr

marad:
	ldx pos
	lda drift,x
	sta dpos


/////////////////////////////
//chr setup for next frame//
///////////////////////////

	ldx chr
	lda introtxt,x
	tax

	lda r1,x
	sta visible
	lda r2,x
	sta visible+1
	lda r3,x
	sta visible+2
	lda r4,x
	sta visible+3
	lda r5,x
	sta visible+4

	lda midcol1,x
	sta kozep
	lda midcol2,x
	sta kozep+1
	lda midcol3,x
	sta kozep+2
	lda midcol4,x
	sta kozep+3
	lda midcol5,x
	sta kozep+4

///////////
//scroll//
/////////

	ldx pos
	lda scr
	sec
	sbc scroll,x
	sta scr 
	bpl picitvar

	and #$07
	sta scr


	jsr masol
	jmp tov

picitvar:
	ldx #$ff
	dex
	bne picitvar+2

tov:
	lda scr
	sta $d016

	

	lda #$00
	jsr $1021


	

	jmp $ea31






hi:
.byte $20,$20,$20,$20,$21,$21,$21,$21,$22,$22,$22,$22,$23,$23,$23,$23,$24,$24,$24,$24
hi2:
.byte $25,$25,$25,$25,$26,$26,$26,$26,$27,$27,$27,$27,$28,$28,$28,$28,$29,$29,$29,$29

lo:
.byte $00,$40,$80,$c0,$00,$40,$80,$c0,$00,$40,$80,$c0,$00,$40,$80,$c0,$00,$40,$80,$c0



sub1:
.byte $b2,$b2,$b2,$b2,$93,$92,$91,$90,$8f,$8e,$8d,$8c,$8b,$8a,$89,$88,$87,$86,$85,$84,$83,$82,$81,$80

sub2:
.byte $b2,$b2,$b2,$b2,$a7,$a6,$a5,$a4,$a3,$a2,$a1,$a0,$9f,$9e,$9d,$9c,$9b,$9a,$99,$98,$97,$96,$95,$94

sub3:
.byte $b2,$b2,$b2,$b2,$b2,$b2,$b2,$b2,$b2,$b2,$b2,$b2,$b2,$b2,$b1,$b0,$af,$ae,$ad,$ac,$ab,$aa,$a9,$a8


drift:	// RGB pottyek mozgatása framenként
//.byte 0,2,4,6,8,10,12,14,15,17,18,19,21,22,23,23
.byte 16,10,0,2,4,6,8,10,12,14,15,17,19,20,22,23

scroll:	// CHR balra scroll 
.byte 7,5,4,3,2,1,1,1,0,0,0,0,0,0,0,0


colorpos:
.byte 0,32,16,52,8,41,26,63		//$d015->color konvertalo pretabla:)
colorvalue:
.byte 0,2,5,7,6,4,3,1

pos:
.byte 0

dpos:	//nem linearis eltolas
.byte 0

chr:
.byte 0

counter1:
.byte 0

counter2:
.byte 0

onoff1:
.byte 0

onoff2:
.byte 0

eredeti1:
.byte 0

eredeti2:
.byte 0

eredeti3:
.byte 0

eredeti4:
.byte 0

scr:
.byte 0

visible:
.byte 0,0,0,0,0

kozep:
.byte 0,0,0,0,0

introtxt:
.text "  #$%&'()** one pixel width rgb scroller! hold my beer )*) unreadable! who cares...  try to decode the color codes )*)  have fun )*) dnp rulz      "


r1:
.byte 0,63,63,63,52,63,63,63,41,16,8,41,32,41,52,16,52,16,52,63,63,41,41,41,41,41,63,0,0,0,0,0,0,63,0,63,0,0,0,0,0,63,63,0,0,0,0,0,63,8,63,63,32,63,63,63,63,63,0,0,0,0,0,63
r2:
.byte 0,41,41,32,41,32,32,32,41,16,8,41,32,63,41,41,41,41,41,32,16,41,41,41,41,41,8,0,0,0,0,0,0,8,0,0,63,0,0,0,63,0,63,0,0,0,0,0,41,26,8,8,32,32,32,8,41,41,16,0,0,0,0,8
r3:
.byte 0,63,52,32,41,52,52,41,63,16,8,52,32,41,41,41,52,41,52,16,16,41,41,41,16,16,16,0,0,0,0,0,0,16,0,0,0,63,0,0,0,63,63,0,0,0,0,0,41,8,63,26,63,63,63,8,63,63,0,0,0,0,0,16
r4:
.byte 0,41,41,32,41,32,32,41,41,16,41,41,32,41,41,41,32,41,41,8,16,41,41,63,41,16,32,0,0,0,0,0,0,0,0,0,0,0,63,0,63,0,63,0,8,0,0,0,41,8,32,8,8,8,41,8,41,8,16,0,0,0,0,0
r5:
.byte 0,41,63,63,52,63,32,63,41,16,16,41,63,41,41,16,32,26,41,63,16,63,16,41,41,16,63,0,0,0,0,0,0,16,0,0,0,0,0,63,0,63,63,0,16,0,16,0,63,8,63,63,8,63,63,8,63,63,0,0,0,0,0,16
midcol1:
.byte 0,1,1,1,0,1,1,1,4,0,0,4,0,4,0,0,0,0,0,1,1,4,4,4,4,4,1,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,1,0,1,1,1,1,1,0,0,0,0,0,1
midcol2:
.byte 0,4,4,0,4,0,0,0,4,0,0,4,0,1,4,4,4,4,4,0,0,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,1,0,0,0,0,0,4,0,0,0,0,0,0,0,4,4,0,0,0,0,0,0
midcol3:
.byte 0,1,0,0,4,0,0,4,1,0,0,0,0,4,4,4,0,4,0,0,0,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,1,0,0,0,0,0,4,0,1,0,1,1,1,0,1,1,0,0,0,0,0,0
midcol4:
.byte 0,4,4,0,4,0,0,4,4,0,4,4,0,4,4,4,0,4,4,0,0,4,4,1,4,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,1,0,0,0,0,0,4,0,0,0,0,0,4,0,4,0,0,0,0,0,0,0
midcol5:
.byte 0,4,1,1,0,1,0,1,4,0,0,4,1,4,4,0,0,0,4,1,0,1,0,4,4,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,0,0,0,0,0,1,0,1,1,0,1,1,0,1,1,0,0,0,0,0,0




sprite:
.byte %00000011, %11111100, %00000000
.byte %00001111, %11111111, %00000000
.byte %00011111, %11111111, %10000000
.byte %00111111, %11111111, %11000000
.byte %01111111, %11111111, %11100000
.byte %01111111, %11111111, %11100000

.byte %11111111, %11111111, %11110000
.byte %11111111, %11111111, %11110000
.byte %11111111, %11111111, %11110000
.byte %11111111, %11111111, %11110000
.byte %11111111, %11111111, %11110000
.byte %11111111, %11111111, %11110000
.byte %11111111, %11111111, %11110000
.byte %11111111, %11111111, %11110000

.byte %01111111, %11111111, %11100000
.byte %01111111, %11111111, %11100000
.byte %00111111, %11111111, %11000000
.byte %00011111, %11111111, %10000000
.byte %00001111, %11111111, %00000000
.byte %00000011, %11111100, %00000000

.byte %00000000, %00000000, %00000000

.byte 0


nspr:	//dummy valtozo :)
.byte

.pc = $3000 "font"
chrmap:
.byte %00000000
.byte %00000000
.byte %00000000
.byte %00000000
.byte %00000000
.byte %00000000
.byte %00000000
.byte %00000000


// 1x1
.byte %01111100
.byte %11111110
.byte %11111110
.byte %11111110
.byte %11111110
.byte %11111110
.byte %01111100
.byte %00000000

.byte 0, 8, 16, 0, 56, 68, 130, 254, 0, 0, 0, 0, 112, 128, 128, 64, 0, 0, 0, 0, 60, 2, 2, 62, 0, 64, 64, 64, 68, 72, 80, 96, 0, 128, 128, 128, 136, 144, 161, 193, 0, 0, 0, 0, 112, 136, 4, 4, 0, 0, 0, 0, 176, 192, 128, 128, 0, 0, 0, 0, 93, 98, 66, 66, 0, 0, 0, 0, 224, 17, 18, 19, 0, 32, 64, 0, 224, 16, 9, 249, 0, 0, 0, 0, 116, 140, 4, 4, 0, 0, 0, 0, 14, 16, 16, 8, 0, 0, 0, 0, 28, 32, 64, 64, 0, 0, 0, 0, 177, 194, 132, 132, 0, 2, 2, 2, 194, 34, 18, 18, 0, 64, 64, 64, 67, 68, 72, 79, 0, 0, 0, 0, 133, 70, 36, 228, 0, 0, 16, 16, 188, 16, 16, 16, 0, 0, 0, 0, 7, 8, 16, 16, 0, 0, 0, 0, 28, 32, 32, 16, 0, 128, 0, 0, 151, 152, 144, 144, 0, 2, 4, 0, 15, 128, 128, 143, 0, 16, 16, 16, 18, 147, 146, 146, 0, 2, 0, 0, 226, 18, 18, 18, 0, 8, 8, 8, 11, 12, 8, 8, 0, 0, 0, 0, 129, 66, 36, 39, 0, 2, 2, 2, 194, 34, 18, 242, 0, 10, 20, 0, 28, 34, 65, 65, 0, 32, 32, 32, 33, 34, 36, 39, 0, 0, 0, 0, 192, 32, 16, 240

.byte 0,0,0,0,0,0,0,0

.byte 128, 128, 68, 56, 0, 0, 0, 0, 32, 16, 16, 224, 0, 0, 0, 0, 66, 66, 70, 58, 0, 0, 0, 0, 80, 72, 68, 66, 0, 0, 0, 0, 161, 145, 136, 132, 0, 0, 0, 0, 4, 4, 136, 112, 0, 0, 0, 0, 128, 128, 128, 128, 0, 0, 0, 0, 66, 66, 66, 66, 0, 0, 0, 0, 18, 18, 17, 16, 0, 0, 0, 0, 1, 1, 16, 224, 0, 0, 0, 0, 4, 4, 140, 116, 4, 8, 240, 0, 4, 2, 2, 28, 0, 0, 0, 0, 64, 64, 32, 28, 0, 0, 0, 0, 132, 132, 130, 129, 0, 0, 0, 0, 18, 18, 34, 194, 0, 0, 0, 0, 72, 72, 68, 67, 0, 0, 0, 0, 4, 4, 68, 132, 0, 0, 0, 0, 16, 16, 16, 12, 0, 0, 0, 0, 16, 16, 8, 7, 0, 0, 0, 0, 8, 4, 4, 56, 0, 0, 0, 0, 144, 144, 144, 144, 0, 0, 0, 0, 144, 144, 145, 142, 0, 0, 0, 0, 146, 146, 146, 146, 0, 0, 0, 0, 18, 18, 18, 18, 0, 0, 0, 0, 8, 8, 12, 11, 0, 0, 0, 0, 36, 36, 66, 129, 0, 0, 0, 0, 2, 2, 34, 194, 0, 0, 0, 0, 65, 65, 34, 28, 0, 0, 0, 0, 36, 36, 34, 33, 0, 0, 0, 0, 0, 0, 32, 192, 0, 0, 0, 0

.byte 0, 0, 0, 0, 120, 4, 4, 124, 0, 0, 0, 0, 187, 196, 132, 132, 0, 4, 0, 0, 196, 36, 36, 36, 0, 0, 64, 64, 240, 64, 64, 64, 0, 0, 0, 0, 56, 64, 65, 33, 0, 0, 0, 0, 112, 136, 4, 252, 0, 0, 0, 0, 184, 196, 132, 132, 0, 129, 128, 128, 137, 145, 161, 193, 0, 0, 0, 0, 3, 4, 4, 2, 0, 0, 0, 0, 135, 8, 16, 31, 0, 0, 0, 0, 23, 152, 80, 208, 0, 0, 0, 0, 120, 132, 132, 132, 0, 0, 8, 8, 28, 8, 8, 8, 0, 0, 0, 0, 132, 132, 132, 132, 0, 2, 2, 2, 58, 70, 130, 130, 0, 0, 0, 0, 3, 4, 8, 15, 0, 8, 8, 8, 136, 72, 41, 233, 0, 0, 0, 0, 112, 136, 4, 4, 0, 128, 128, 128, 144, 144, 136, 136, 0, 0, 0, 0, 79, 64, 128, 143, 0, 0, 0, 0, 14, 144, 144, 136, 0, 0, 0, 0, 92, 98, 66, 66, 0, 64, 0, 0, 64, 64, 64, 64
.byte 132, 132, 140, 116, 0, 0, 0, 0, 132, 132, 132, 132, 0, 0, 0, 0, 36, 36, 36, 36, 0, 0, 0, 0, 64, 64, 64, 48, 0, 0, 0, 0, 17, 9, 8, 112, 0, 0, 0, 0, 0, 0, 136, 112, 0, 0, 0, 0, 132, 132, 132, 132, 0, 0, 0, 0, 161, 145, 137, 133, 0, 0, 0, 0, 1, 0, 0, 7, 0, 0, 0, 0, 16, 144, 136, 7, 0, 0, 0, 0, 16, 16, 144, 16, 0, 0, 0, 0, 132, 132, 132, 132, 0, 0, 0, 0, 8, 8, 8, 6, 0, 0, 0, 0, 132, 132, 140, 116, 0, 0, 0, 0, 130, 130, 70, 58, 0, 0, 0, 0, 8, 8, 4, 3, 0, 0, 0, 0, 9, 9, 72, 136, 0, 0, 0, 0, 4, 4, 136, 112, 0, 0, 0, 0, 133, 133, 130, 130, 0, 0, 0, 0, 16, 16, 17, 14, 0, 0, 0, 0, 132, 130, 130, 156, 0, 0, 0, 0, 66, 66, 66, 66, 0, 0, 0, 0, 64, 64, 64, 64, 0, 0, 0, 0

.byte 0, 0, 0, 0, 187, 196, 132, 132, 0, 4, 0, 0, 196, 36, 36, 36, 0, 128, 128, 128, 136, 144, 161, 193, 0, 0, 0, 0, 112, 136, 4, 4, 0, 0, 0, 0, 176, 192, 128, 128, 0, 0, 0, 0, 130, 130, 68, 68, 0, 0, 0, 0, 56, 68, 130, 130, 0, 64, 68, 68, 79, 68, 68, 68, 0, 0, 0, 0, 3, 4, 8, 15, 0, 0, 0, 0, 143, 64, 32, 225, 0, 0, 0, 0, 193, 65, 129, 1, 0, 0, 0, 0, 112, 136, 4, 4, 0, 0, 0, 0, 177, 194, 132, 132, 0, 2, 2, 2, 194, 35, 18, 18, 0, 1, 1, 1, 225, 17, 9, 9, 0, 2, 4, 0, 14, 17, 32, 63, 0, 0, 0, 0, 46, 49, 161, 161, 0, 0, 0, 0, 240, 8, 8, 8, 0, 0, 0, 0, 240, 8, 8, 248, 0, 0, 0, 0, 14, 17, 32, 63, 0, 0, 0, 0, 14, 17, 160, 160, 0, 0, 0, 0, 160, 160, 145, 145, 0, 0, 0, 0, 129, 130, 2, 1, 0, 0, 0, 0, 195, 4, 8, 8, 0, 0, 0, 0, 150, 24, 16, 16, 0, 0, 0, 0, 56, 68, 130, 130, 0, 72, 72, 72, 73, 73, 73, 73, 0, 0, 0, 0, 112, 136, 8, 8, 0, 33, 65, 1, 241, 9, 9, 249, 0, 14, 17, 1, 1, 2, 4, 4
.byte 132, 132, 132, 132, 0, 0, 0, 0, 36, 36, 36, 36, 0, 0, 0, 0, 161, 145, 136, 132, 0, 0, 0, 0, 4, 4, 136, 112, 0, 0, 0, 0, 128, 128, 128, 128, 0, 0, 0, 0, 40, 40, 16, 16, 0, 0, 0, 0, 130, 130, 68, 56, 0, 0, 0, 0, 68, 68, 68, 67, 0, 0, 0, 0, 8, 8, 4, 3, 0, 0, 0, 0, 2, 4, 72, 143, 0, 0, 0, 0, 1, 1, 1, 193, 1, 1, 1, 0, 4, 4, 136, 112, 0, 0, 0, 0, 132, 132, 130, 129, 0, 0, 0, 0, 18, 18, 35, 194, 0, 0, 0, 0, 9, 9, 17, 225, 0, 0, 0, 0, 32, 32, 17, 14, 0, 0, 0, 0, 33, 33, 33, 33, 0, 0, 0, 0, 9, 9, 9, 8, 0, 0, 0, 0, 8, 8, 24, 232, 0, 0, 0, 0, 32, 32, 17, 14, 0, 0, 0, 0, 32, 32, 17, 14, 0, 1, 62, 0, 138, 138, 132, 132, 132, 8, 48, 0, 0, 0, 0, 3, 0, 0, 0, 0, 136, 72, 68, 131, 0, 0, 0, 0, 16, 16, 16, 144, 0, 0, 0, 0, 130, 130, 68, 56, 0, 0, 0, 0, 73, 73, 73, 73, 0, 0, 0, 0, 9, 9, 9, 8, 0, 0, 0, 0, 9, 9, 25, 233, 0, 0, 0, 0, 0, 0, 4, 4, 0, 0, 0, 0





//3x3
.byte %00000011
.byte %00001111
.byte %00011111
.byte %00111111
.byte %01111111
.byte %01111111
.byte %11111111
.byte %11111111

.byte %11111100
.byte %11111111
.byte %11111111
.byte %11111111
.byte %11111111
.byte %11111111
.byte %11111111
.byte %11111111

.byte %00000000
.byte %00000000
.byte %10000000
.byte %11000000
.byte %11100000
.byte %11100000
.byte %11110000
.byte %11110000



.byte %11111111
.byte %11111111
.byte %11111111
.byte %11111111
.byte %11111111
.byte %11111111
.byte %01111111
.byte %01111111

.byte %11111111
.byte %11111111
.byte %11111111
.byte %11111111
.byte %11111111
.byte %11111111
.byte %11111111
.byte %11111111

.byte %11110000
.byte %11110000
.byte %11110000
.byte %11110000
.byte %11110000
.byte %11110000
.byte %11100000
.byte %11100000



.byte %00111111
.byte %00011111
.byte %00001111
.byte %00000011
.byte %00000000
.byte %00000000
.byte %00000000
.byte %00000000

.byte %11111111
.byte %11111111
.byte %11111111
.byte %11111100
.byte %00000000
.byte %00000000
.byte %00000000
.byte %00000000

.byte %11000000
.byte %10000000
.byte %00000000
.byte %00000000
.byte %00000000
.byte %00000000
.byte %00000000
.byte %00000000

.byte 0, 0, 120, 132, 128, 128, 64, 48, 0, 0, 128, 128, 128, 144, 144, 136, 0, 0, 15, 16, 16, 80, 72, 134, 0, 0, 0, 128, 0, 23, 24, 16, 0, 0, 0, 0, 0, 16, 144, 72, 0, 0, 0, 0, 0, 64, 68, 128
.byte 8, 4, 4, 132, 120, 0, 0, 0, 136, 133, 133, 130, 130, 2, 4, 24, 129, 0, 0, 16, 15, 0, 0, 0, 16, 144, 144, 152, 23, 16, 16, 16, 72, 69, 69, 130, 2, 2, 4, 24, 128, 0, 0, 4, 0, 0, 0, 0

.byte 0, 0, 248, 132, 130, 130, 130, 130, 0, 0, 0, 0, 0, 92, 98, 66, 0, 0, 124, 66, 65, 65, 65, 66, 0, 0, 0, 0, 0, 0, 16, 0
.byte 130, 130, 130, 132, 248, 0, 0, 0, 66, 66, 66, 66, 66, 0, 0, 0, 124, 64, 64, 64, 64, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0

//ScrollCHR
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,56,68,124,68,68
.byte 0,0,0,120,68,120,68,120
.byte 0,0,0,60,64,64,64,60
.byte 0,0,0,120,68,68,68,120
.byte 0,0,0,124,64,112,64,124
.byte 0,0,0,124,64,112,64,64
.byte 0,0,0,60,64,92,68,60
.byte 0,0,0,68,68,124,68,68
.byte 0,0,0,16,16,16,16,16
.byte 0,0,0,28,4,4,68,56
.byte 0,0,0,68,72,112,72,68
.byte 0,0,0,64,64,64,64,124
.byte 0,0,0,68,108,84,68,68
.byte 0,0,0,68,100,84,76,68
.byte 0,0,0,56,68,68,68,56
.byte 0,0,0,120,68,120,64,64
.byte 0,0,0,56,68,68,72,52
.byte 0,0,0,120,68,120,68,68
.byte 0,0,0,60,64,56,4,120
.byte 0,0,0,124,16,16,16,16
.byte 0,0,0,68,68,68,68,56
.byte 0,0,0,68,68,40,40,16
.byte 0,0,0,68,68,84,84,40
.byte 0,0,0,68,40,16,40,68
.byte 0,0,0,68,40,16,16,16
.byte 0,0,0,124,8,16,32,124
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,56,8,16,0,16
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,48,0,0,0,0
.byte 0,0,0,0,48,0,0,0
.byte 0,0,0,0,0,48,0,0
.byte 0,0,0,0,0,0,48,0
.byte 0,0,0,0,0,0,0,48
.byte 0,0,0,0,48,0,48,0
.byte 0,0,0,48,0,48,0,48
.byte 0,0,0,48,48,48,48,48
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,16,32
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,16
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,56,68,68,68,56
.byte 0,0,0,48,16,16,16,16
.byte 0,0,0,48,72,16,32,120
.byte 0,0,0,56,68,24,68,56
.byte 0,0,0,32,32,72,124,8
.byte 0,0,0,120,64,112,8,112
.byte 0,0,0,56,64,120,68,56
.byte 0,0,0,60,4,8,16,16
.byte 0,0,0,56,68,56,68,56
.byte 0,0,0,56,68,60,4,56


.pc = $0820 "etc funksonZ"
/////////
masol://
///////

	ldy #$00

chrmasol:

	lda $0400+5*40+1,y
	sta $0400+5*40,y

	lda $0400+6*40+1,y
	sta $0400+6*40,y

	lda $0400+7*40+1,y
	sta $0400+7*40,y

	lda $0400+8*40+1,y
	sta $0400+8*40,y

	lda $0400+9*40+1,y
	sta $0400+9*40,y

	lda $0400+10*40+1,y
	sta $0400+10*40,y

	lda $0400+11*40+1,y
	sta $0400+11*40,y

	lda $0400+12*40+1,y
	sta $0400+12*40,y

	lda $0400+13*40+1,y
	sta $0400+13*40,y

	lda $0400+14*40+1,y
	sta $0400+14*40,y

	lda $0400+15*40+1,y
	sta $0400+15*40,y

	lda $0400+16*40+1,y
	sta $0400+16*40,y

	lda $0400+17*40+1,y
	sta $0400+17*40,y

	lda $0400+18*40+1,y
	sta $0400+18*40,y

	lda $0400+19*40+1,y
	sta $0400+19*40,y

	iny
	cpy #35
	bne chrmasol

	ldy #$00
chc:	lda $0400+21*40+1,y
	sta $0400+21*40,y
	iny
	cpy#35
	bne chc

	ldy #$00

colmasol:
	lda $d800+5*40+1,y
	sta $d800+5*40,y

	lda $d800+6*40+1,y
	sta $d800+6*40,y

	lda $d800+7*40+1,y
	sta $d800+7*40,y



	lda $d800+8*40+1,y
	sta $d800+8*40,y

	lda $d800+9*40+1,y
	sta $d800+9*40,y

	lda $d800+10*40+1,y
	sta $d800+10*40,y



	lda $d800+11*40+1,y
	sta $d800+11*40,y

	lda $d800+12*40+1,y
	sta $d800+12*40,y

	lda $d800+13*40+1,y
	sta $d800+13*40,y



	lda $d800+14*40+1,y
	sta $d800+14*40,y

	lda $d800+15*40+1,y
	sta $d800+15*40,y

	lda $d800+16*40+1,y
	sta $d800+16*40,y



	lda $d800+17*40+1,y
	sta $d800+17*40,y

	lda $d800+18*40+1,y
	sta $d800+18*40,y

	lda $d800+19*40+1,y
	sta $d800+19*40,y


	iny
	cpy #35
	bne colmasol

	
	

	rts

/////////////
pottyez:  //
///////////

	lda #$a9
	sta $0400+5*40+32
	sta $0400+8*40+32
	sta $0400+11*40+32
	sta $0400+14*40+32
	sta $0400+17*40+32

	lda #$aa
	sta $0400+5*40+32+1
	sta $0400+8*40+32+1
	sta $0400+11*40+32+1
	sta $0400+14*40+32+1
	sta $0400+17*40+32+1

	lda #$ab
	sta $0400+5*40+32+2
	sta $0400+8*40+32+2
	sta $0400+11*40+32+2
	sta $0400+14*40+32+2
	sta $0400+17*40+32+2



	lda #$ac
	sta $0400+6*40+32
	sta $0400+9*40+32
	sta $0400+12*40+32
	sta $0400+15*40+32
	sta $0400+18*40+32

	lda #$ad
	sta $0400+6*40+32+1
	sta $0400+9*40+32+1
	sta $0400+12*40+32+1
	sta $0400+15*40+32+1
	sta $0400+18*40+32+1

	lda #$ae
	sta $0400+6*40+32+2
	sta $0400+9*40+32+2
	sta $0400+12*40+32+2
	sta $0400+15*40+32+2
	sta $0400+18*40+32+2



	lda #$af
	sta $0400+7*40+32
	sta $0400+10*40+32
	sta $0400+13*40+32
	sta $0400+16*40+32
	sta $0400+19*40+32

	lda #$b0
	sta $0400+7*40+32+1
	sta $0400+10*40+32+1
	sta $0400+13*40+32+1
	sta $0400+16*40+32+1
	sta $0400+19*40+32+1

	lda #$b1
	sta $0400+7*40+32+2
	sta $0400+10*40+32+2
	sta $0400+13*40+32+2
	sta $0400+16*40+32+2
	sta $0400+19*40+32+2

	
	//add some color :)

	ldx chr
	lda introtxt,x
	tay

	lda r1,y
	tax
	lda $2f00,x
	sta $d800+5*40+32
	sta $d800+5*40+32+1
	sta $d800+5*40+32+2
	sta $d800+6*40+32
	sta $d800+6*40+32+1
	sta $d800+6*40+32+2
	sta $d800+7*40+32
	sta $d800+7*40+32+1
	sta $d800+7*40+32+2

	lda r2,y
	tax
	lda $2f00,x
	sta $d800+8*40+32
	sta $d800+8*40+32+1
	sta $d800+8*40+32+2
	sta $d800+9*40+32
	sta $d800+9*40+32+1
	sta $d800+9*40+32+2
	sta $d800+10*40+32
	sta $d800+10*40+32+1
	sta $d800+10*40+32+2

	lda r3,y
	tax
	lda $2f00,x
	sta $d800+11*40+32
	sta $d800+11*40+32+1
	sta $d800+11*40+32+2
	sta $d800+12*40+32
	sta $d800+12*40+32+1
	sta $d800+12*40+32+2
	sta $d800+13*40+32
	sta $d800+13*40+32+1
	sta $d800+13*40+32+2

	lda r4,y
	tax
	lda $2f00,x
	sta $d800+14*40+32
	sta $d800+14*40+32+1
	sta $d800+14*40+32+2
	sta $d800+15*40+32
	sta $d800+15*40+32+1
	sta $d800+15*40+32+2
	sta $d800+16*40+32
	sta $d800+16*40+32+1
	sta $d800+16*40+32+2

	lda r5,y
	tax
	lda $2f00,x
	sta $d800+17*40+32
	sta $d800+17*40+32+1
	sta $d800+17*40+32+2
	sta $d800+18*40+32
	sta $d800+18*40+32+1
	sta $d800+18*40+32+2
	sta $d800+19*40+32
	sta $d800+19*40+32+1
	sta $d800+19*40+32+2


	ldx chr
	lda introtxt,x
	//and #%00011111
	clc
	adc #$c6
	sta $0400+21*40+33

	

	rts

/////////
intro://
///////

	inc $d019
ic:	lda #$02
	sta $d021
	sta $d020


	ldx eredeti1
	ldy eredeti2

	lda #$68
iw1:	cmp $d012
	bne iw1

	stx $d020
	sty $d021


	ldx eredeti3
	ldy eredeti4

	lda #$d0
iw2:	cmp $d012
	bne iw2

	stx $d020
	sty $d021
	
	lda #$01
	sta $d019


	inc counter2
	lda counter2
	cmp #$40
	bne st2
	
	lda #$05
	sta eredeti1
	sta eredeti2
st2:

	cmp #$80
	bne st3
	
	lda #$06
	sta eredeti3
	sta eredeti4

st3:
	cmp #$c0
	bne st4

	
	
	sei
	lda #<intro2
	sta $0314
	lda #>intro2
	sta $0315
	lda #$00		//$59
	sta $d012
	lda #$1b
	sta $d011
	cli
	
	ldx #$00
	lda #$20
clrscr:
	sta $0400,x
	sta $0500,x
	sta $0600,x
	sta $0700-24,x


	inx
	cpx #$00
	bne clrscr
	
	

	

st4:

	lda #$00
	jsr $1021


	jmp $ea31


//////////
intro2://
////////

	inc $d019
	lda #$02
	sta $d021
	sta $d020


col1:	ldx #$05
	ldy #$07


	lda #$68
iw3:	cmp $d012
	bne iw3

	sty $d020
	sty $d021


	lda #$6a
iw4:	cmp $d012
	bne iw4

	stx $d020
	stx $d021





	ldx #$06
	ldy #$03


	lda #$ce
iw5:	cmp $d012
	bne iw5

	sty $d020
	sty $d021

	lda #$d0
iw6:	cmp $d012
	bne iw6

	stx $d020
	stx $d021


	
	lda #$01
	sta $d019
	

chg:	inc iw4-1
	dec iw5-1


	lda iw4-1
	cmp #$9c
	bne vegechk

	lda #$ce
	sta chg
	lda #$ee
	sta chg+3
	lda #$01
	sta col1+1
	
vegechk:
	cmp #$68
	bne tovchg
	sei
	lda #<intro3
	sta $0314
	lda #>intro3
	sta $0315
	lda #$00		//$59
	sta $d012
	lda #$1b
	sta $d011
	cli




tovchg:

	lda #$00
	jsr $1021


	jmp $ea31


//////////
intro3://
////////

	
	inc $d019

	lda #$02
	sta $d021
	sta $d020


	ldx #$01
	ldy #$04


	lda #$66	// csokkenteni
iw7:	cmp $d012
	bne iw7

	sty $d020
	sty $d021


	lda #$68
iw8:	cmp $d012
	bne iw8

	stx $d020
	stx $d021





	ldx #$06
	ldy #$04


	lda #$d0
iw9:	cmp $d012
	bne iw9

	sty $d020
	sty $d021

	lda #$d2	//novelni
iw10:	cmp $d012
	bne iw10

	stx $d020
	stx $d021


	
	lda #$01
	sta $d019
	

chg2:	inc iw10-1
	dec iw7-1


	lda iw7-1
	cmp #$0a
	bne megmehet

	lda #<iw9-1
	sta chg2+1
	lda #>iw9-1
	sta chg2+2

	lda #<iw8-1
	sta chg2+4
	lda #>iw8-1
	sta chg2+5

megmehet:

	lda iw8-1
	cmp #$22
	beq nextpart
	jmp megmehet2

nextpart:
	lda #$01
	sta $d020
	sta $d021


	sei
	lda #<fb_irq
	sta $0314
	lda #>fb_irq
	sta $0315
	lda #$50		//#$59
	sta $d012
	lda #$1b
	sta $d011
	cli

	lda $d018
	and #%11110001
	ora #%00001100	//chr map $3000
	sta $d018

	lda #%00111111
	//sta $d015
	sta $d010

	//fb idezetek ki

	ldx #$00
idez1:
	txa
	clc
	adc #$02
	sta $0400+40*7+8,x
	adc #$1f
	sta $0400+40*8+8,x

	lda #$01
	sta $d800+40*7+8,x
	sta $d800+40*8+8,x

	inx
	cpx #30
	bne idez1

	ldx #$00
idez2:
	txa
	clc
	adc #63
	sta $0400+40*11+8,x
	clc
	adc #$17
	sta $0400+40*12+8,x

	lda #$01
	sta $d800+40*11+8,x
	sta $d800+40*12+8,x

	inx
	cpx #23
	bne idez2


	ldx #$00
idez3:
	txa
	clc
	adc #109
	sta $0400+40*15+8,x
	clc
	adc #$1e
	sta $0400+40*16+8,x

	lda #$01
	sta $d800+40*15+8,x
	sta $d800+40*16+8,x

	inx
	cpx #30
	bne idez3


	ldx #$00
idez4:
	txa
	clc
	adc #$b2
	sta $0400+40*7+1,x
	sta $0400+40*15+1,x
	clc
	adc #$06
	sta $0400+40*8+1,x
	sta $0400+40*16+1,x

	lda #$01
	sta $d800+40*7+1,x
	sta $d800+40*8+1,x
	sta $d800+40*15+1,x
	sta $d800+40*16+1,x

	inx
	cpx #6
	bne idez4

	ldx #$00
idez5:
	txa
	clc
	adc #$be
	sta $0400+40*11+1,x
	clc
	adc #$04
	sta $0400+40*12+1,x

	lda #$01
	sta $d800+40*11+1,x
	sta $d800+40*12+1,x

	inx
	cpx #04
	bne idez5




megmehet2:
	lda #$01
	sta $d019

	lda #$00
	jsr $1021

	jmp $ea31



fb_irq:
	inc $d019



	lda #$60
fbw:	cmp $d012
	bne fbw

	lda fbscroll
	sta $d016

	

// lassito
	inc scrollstep
	lda scrollstep
	cmp #$02
	bne fb1tov
	lda #$00
	sta scrollstep


// 7 pixeles bal scroll, ha elerte, pause
	dec fbscroll
	lda fbscroll
	cmp #$ff
	bne fb1tov
	lda #$00
	sta fbscroll
fb1tov:

// framecounter

	inc fbc1

	lda fbc1
	cmp #$40
	bne fbst1

	lda #$80
	sta fbw-1
	lda #$07
	sta fbscroll
	lda #$b8
	sta fbfill+1


fbst1:
	cmp #$80
	bne fbst2

	lda #$a0
	sta fbw-1
	lda #$07
	sta fbscroll
	lda #$58
	sta fbfill+1
	lda #$da
	sta fbfill+2
fbst2:
	cmp #$00
	bne fbst3
	
	sei
	lda #<irq
	sta $0314
	lda #>irq
	sta $0315
	lda #$58
	sta $d012
	lda #$1b
	sta $d011
	cli
	
	lda #$00
	sta $d020
	sta $d021

	lda #$01
	ldx #$00
ttt:	sta $d800+21*40,x
	inx
	cpx #40
	bne ttt

	lda #11
	sta $d800+21*40+0
	sta $d800+21*40+1
	sta $d800+21*40+2
	lda #12
	sta $d800+21*40+3
	sta $d800+21*40+4
	lda #15
	sta $d800+21*40+5
	sta $d800+21*40+6




fbst3:




	lda #$c0
fbw2:	cmp $d012
	bne fbw2
	
	lda #$00
	sta $d016


// colorfiller
	ldx fbscroll
	lda fbcolor,x

	ldx #80
fbfill:
	sta $d918,x
	dex
	bne fbfill




	lda #$00
	jsr $1021

	jmp $ea31


fbscroll:
.byte 7

scrollstep:
.byte 0

fbc1:
.byte 0

fbcolor:
.byte 0,11,12,15,13,7,1,1

.pc=music.location "Music"
.fill music.size, music.getData(i)



