   ; "the spirit" - 256b msdos intro
        ; by HellMood / DESIRE
      ; for Revision Party, 2024

; happy 40th boingiversary ^^
; big shoutouts to reflex!
; PC Speaker/Covox, NO MIDI 
; 190K cycles = AMD K6-2 300 MHz

; Dosbox-X recommended
; use the provided "dosbox-x.conf"
org 100h
push 0xa000-250		; graphic memory, hide top lines (bounce)
M: aas				; FPU aspect ratio constant
pop es				
or al,0x13
int 0x10			; 320 x 200 in 256 colors
mov al,49			; setting the PIT to ~ 24 KHz
out 0x40,al
salc
out 0x40,al
xchg bp,ax			; set BP (stack adressing) to zero
mov ax,0x251c
mov dx,timer 		; set timer interrupt routine
int 21h
X:
mov ax,0xCCCD		; rrrolas trick
mul di				; get coordinates in DH/DL
cmp dl,0x80			; fix pixel offset
sbb dh,77			; align
mov [si],dx			; save old DX (decouple wheel&bounce)
cmp bh,3			; time to bounce?
jl noj				; no jump
shld ax,bx,18		; get quadratic bounce movement from time
imul al
sub dh,ah			; adjust position accordinlgy
noj:
%define stack_offset 0
pusha				; all registers on stack for FPU usage
fild word [bp-8-stack_offset]			;<- dh+dl	; x
fmul st0											; x*x
fild word [si]										; x' x*x	(old x)
fild word [bp-9-stack_offset]			;<- dl+bh	; y x x*x
fmul dword [bp+si]									; y' x x*x  (aspect ratio)
fst st3												; y x x*x y
fst st4												; y x x*x y y
fmul st3,st0										; y x x*x y*y y
fpatan												; a x*x y*y y
fmul dword [bp+leconst-2]							; a' x*x y*y y
fistp word [bp-6-stack_offset]			;->cx		; x*x y*y y
faddp st1											; y*y+x*x y 
fisubr dword [byte bp+si+M+2]						; r*r-y*y-x*x y
fsqrt												; z y
fpatan												; arc2
fimul word [bp]										; arc2'
fistp word [bp-5-stack_offset]			;-> ax		; -
popa
sub al,0x80			; FPU ERROR? (out of sphere)
jz F				; skip sphere
test bh,bh			; time to spin already
jz JKL				; no
add ax,bx			; add time to spin
JKL:
shr dx,1			; correct y position
xor al,dh			; chessboard pattern with sphere angle
and al,16			; width = 16
jz MMM
mov al,9			; either 9 + 31 = RED
MMM:
add al,31			; or 31 = WHITE
jmp short G			; done with inside sphere
F:
test bh,bh			; time for stripes?
jz G				; no
xchg cx,ax			; get stripe angle in AX
HHHH:
add ax,bx			; rotate by time
shr ax,1			; bigger stripes
and al,14			; skip every other color 
add al,40			; to look like cocio finsprit logo
test bx,si			; time to go dark?
jnz G				; no
sub al,24			; go dark (BW stripes)
G:
stosb				; write pixel to screen
inc di				; rugged 3 step interpolation
inc di
jnz X				; frame done
in al,0x60			; test for ESC
dec al			
jnz X				; repeat if not
mov byte [timer],0xcf	; inject "IRET" into interrupt routine
out 61h,al			; turn of PC speaker (AX = 0)
ret					; the end
leconst:
dw 0x4222			; constant seamless wheel
musi:				; cocie & finsprit note divider approximations
db 49,49,55,49,62,62,82,83
db 49,55,62,62,73,73,82,1
db 124,124,110,98,82,83,82,83
db 49,55,62,62,73,73,82,1
timer:
inc word [bp+si-2]	; use this as sub-timer location
mov ax,word [bp+si-2]
test ax,0x01ff		; inc real timer (bx) all 512 steps
jnz D
inc bx
D:
pusha
push ax				; save sub timer
shr ax,5
cwd 				; use AH != 0 for later CWD
test bh,bh			; time for gabber?
jz NAH				; no
cmp al,13			; inside bass kick section?
jg FI				; no
test bx,si			; alternate bassline? (high/low)
mov al,95			; low bass line
jz FI
mov al,47			; high bass line
out 61h,al			; active  PC speaker
FI:
out 0x42,al			; send value to PC speaker
NAH:
pop ax				; restore sub timer
shr bx,3			; adjust note play tempo
and bx,byte 31 		; filter to 32 notes
movzx cx,[bx+musi]	; get note divider
div cx				; guess what ;)
imul ax,dx,byte 15	; custom envelope...
imul al				; to *somewhat* sound like...
mov al,ah			; cocio & finsprit :/
mov dx,378h			; Covox Port
out dx,al			; send!
popa				; restore all registers
iret				; return to main program