pico-8 cartridge // http://www.pico-8.com
version 42
__lua__

local radius= 10.0     -- radius of the cylinder

resetpal= {}

--[[
  TODO: 
  - load grid from cart, 0x4300 not available!
  - remove addspot
]]

eyetunnel = {
  eyex= 0,
  eyey= 0,
  zoom= 1,
  rotx= 0,
  roty= 0,
  u= 0,
  scaleu= 4,
  
  colors={},
  gfxdata={},
  circle_rle= {}
}

eyetunnel.setparams= function(this, p)
  this.eyex= p[1]
  this.eyey= p[2]
  this.zoom= p[3]
  this.rotx= p[4]
  this.roty= p[5]
  this.u= p[6]*32
  this.scaleu= p[7]
end

eyetunnel.load= function(this)
--  local eye_rle = { 59,74, 52,80,  48,84,44,87,41,90,38,93,35,96,33,98,31,100,29,102,27,104,25,106,24,108,22,109,21,110,20,111,19,112,18,114,18,115,17,116,17,117,17,117,17,117,17,117,17,117,18,117,19,117,20,117,22,116,23,116,25,115,27,115,29,114,30,113,32,111,34,109,37,106,40,103,44,97,48,90,52,80,57,71 }

  -- 8: eyelayers1
	-- 9: eyelayers2
	--10: texture13
  --11: palette
  --12: shade tables
  --13: map ??
  --14: 
--  poke(0x5f54,0x00,0x60) -- swap sprites and screen
  reload(0x8000, 0x0, 0x4300, "data_1.p8")

--  local remap= { [0]= 0,1,2,4,5,7,8,9,10,11,12,13,14,15,15,15 }

local start

for i=0,3 do
    px9_decomp(0,0, dict(0x8000,(i%3)+8), sget, sset) 
--    cstore(0x0, 0x0, 0x2000, "eyedebug"..i..".p8")

    if (i==0) then
      start= dict(0x8000,14)
      for y=0,peek2(start)/2 do
        local x1,x2= peek(start+y*2+2, 2)
        for x=x1,x2 do sset(x,45+y,0xf) end
      end
    end
    this.gfxdata[i]= storemem(0x0, 0x2000)
  end

  start= dict(0x8000,11)
  start= unpackmem(start, this.colors)
  start= unpackmem(start, resetpal)
--  this.colors= { [0]= 0x00,0x81,0x01,0x80,0x82,0x85,0x8d,0x05,0x86,0x06,0x0f,0x07,0x07,0x08,0x09,0x09 }
--             { [0]= 0x00,0x81,0x01,     0x82,0x85,     0x05,0x86,0x06,0x0f,0x07,0x08,0x08,0x08,0x08 }

  -- prepare grid shade table
  this.gfxdata[4]= storemem(dict(0x8000,12)+2, 41*16)

  -- map tiles
  px9_decomp(0,0, dict(0x8000,13), sget, sset) 
  memcpy(0x2000, 0x0, 0x2000)

  start= dict(0x8000,15)
  for i=0,25 do
    this.circle_rle[i]={}
    start= unpackmem(start, this.circle_rle[i])
  end

--[[  
  for y=0,15 do
    for x=0,15 do
      poke(0x2000+y*128+x, y*16+x)
    end
  end  
]]
end


eyetunnel.init= function(this)
  -- copy all data from lua memory where it's expected by the effect code
  for i=0,3 do
    restoremem(0x8000+(i<<13), this.gfxdata[i])
  end
  restoremem(0x4300, this.gfxdata[4])
  for i=0,255 do mset(i&15,i>>4,i) end
  poke(0x5f54, 0x0) -- background
  poke(0x5f55, 0x60) -- background
  poke(0x5f38, 16)
  poke(0x5f39, 16)

end


eyetunnel.update= function(this)
end


local function addspot(dx,dy, sx,sy, w,h)
  for y=0,h-1 do
    for x=0,w-1 do
      local a= sget(sx+x, sy+y) >> 4
      if (a>0) then
        local src= pget(dx+x, dy+y)
        src= src*(1-a) + a*12
        if (src<4) src=5
        if (src>13) src=13
        pset(dx+x,dy+y,src)
      end
    end
  end
end

  -- eye image is 50x50
local function copyline_aa(px, py, posx,posy, data)
    posy+=py
    for x=1,#data do
       local alpha= data[x] >> 4
       pset(
         posx+px+x,
         posy,
         pget(posx+px+x, posy)*alpha)
       
       pset(
         posx+50-px-x, 
         posy, 
         pget(posx+50-px-x,posy)*alpha)
    end

    -- TODO: use proper alpha map instead of background colors
    for x=px+#data, 50-px-#data do
     pset(
       posx+x,
       posy,
       sget(x,py+1))
    end
end      


--eyetunnel.draw_eye= function(this)
--end

eyetunnel.draw= function(this)

--  pal( {[0]=0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15},  0)
  pal( this.colors,  1)
--  pal( resetpal, 0)
--  pal( resetpal, 2)
--  pal( {[0]=0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15},  2)

  poke(0x5f5f, 0x0)
--  memset(0x5f70, 0x55, 16) -- scanline pal toggle
  poke(0x5f38, 16,16)
  palt(0x0, false)
  palt(0xf, true)

  local scale= min(flr(this.zoom), 55)
  local posx=  this.eyex
  local posy=  this.eyey
  local ox= min(4*scale/38,4)
  local x1,y1,x2,y2,dx= 0,0,128,128,128
  local gx1,gx2,gy1

  if scale<=1 then
    dx= 1
    x1= 43
    y1= 43
    x2= 92
    y2= 92

    gx1= 0
    gy1= 0
    gx2= 49
  else
    dx= 128/(128-scale*2)
    x1= (43-ox-scale)*dx
    y1= (43-ox-scale)*dx
    x2= (92-ox-scale)*dx 
    y2= (92-ox-scale)*dx 

    gx1= max( x1, 0 )
    gy1= max( y1, 0 )
    gx2= min( x2, 128 )
  end

  -- draw tunnel
--  memcpy(0x0, 0x8000, 0x2000) -- restore tunnel texture into sprite sheet

  local tmp= matrix_mul( matrix_rotz(this.roty), matrix_roty(0.0) )
  local cam = matrix_mul( tmp, matrix_rotx(this.rotx) )
	local grid = calc_grid(cam, 16, 16, this.scaleu, radius, (gx2-gx1)/16, gx1,gy1)

  fillp(0xa5a5.4)
  poke(0x5f54,0xc0)
  local ov= (this.u * this.scaleu) & 0xff.ffff
	draw_grid(grid, ov) -- draw the grid (fill the 8x8 cells)
  fillp()

  -- draw inner eye with a bit of antialias
  if (scale<=1) then
    poke(0x5f54,0xa0)
    spr(0, 15,42, 13,6) -- eye (white)

    poke(0x5f54,0x60)
    for y=0,24 do
      local r= this.circle_rle[y]
      local px= r[0] -- x start of aa part
  --     local s=  r[1] -- length

      copyline_aa(px, y,    posx,posy, r)
      copyline_aa(px, 49-y, posx,posy, r) -- eye is symetrical
    end
     
    -- restore sprite sheet
    poke(0x5f54,0x80)
    spr(0, 0,0, 16,16)
  elseif (scale<54) then
    poke(0x5f54,0xe0)
    sspr(
      scale+ox,scale+ox,
      128-scale*2,128-scale*2,
      0,0,
      128,128)
  end

  poke(0x5f54,0xa0)
  fillp()
  addspot(x1+5*dx,y1+10*dx, 112,16, 16,16)
  addspot(x2-14*dx,y2-19*dx,  112,0, 9,9)

--[[  
  -- debug: bounding rect of tunnel iris
  color(15)
  line(x1,y1, x2,y1)
  line(x2,y2)
  line(x1,y2)
  line(x1,y1)
]]    
end  

