pico-8 cartridge // http://www.pico-8.com
version 42
__lua__

local rk_parttrack={}
local rk_parts={}

function rk_loadtrack(start, track)
  local numkeys= peek2(start)
  start+=2
  for i=1,numkeys do
    local row= peek2(start)
    local value= peek4(start+2)
    local type= peek(start+6)
--    print(i..": "..row..":"..tostr(value,true).." ("..type..")")
    start+=7
    track[i]= { row, value, type }
  end
  track[0]= 1 -- remember last used key index
  return start
end

function rk_init()
    local start= 0x8000
    reload(start, 0x0, 0x2000, "tracks.p8")
    start= rk_loadtrack(start, rk_parttrack)

    local numparts= peek2(start)
    start+=2

    for i=0,numparts-1 do
      local numtracks= peek2(start)
      start+=2
      local tracks={}
      for j=1,numtracks do
--        print(" - track "..j..":")
        tracks[j]= {}
        start= rk_loadtrack(start, tracks[j])
      end
      rk_parts[i]= tracks
    end
end

function rk_gettrack(track, row)
  local idx= track[0]
--  print(#track)
  while (row>track[idx+1][1]) do
    idx+=1
  end
  track[0]= idx

  local key1= track[idx]
  -- interpolation type
  local type= key1[3]
  if (type == 0) then -- step
     return key1[2]
  end

  local key2= track[idx+1]
  local t= (row-key1[1])/(key2[1]-key1[1])
--  if (type == 1) -- linear
  if (type == 2) then
	   t = t * t * (3 - 2 * t)
  end
  -- no other interpolation types are used

  return key1[2] + (key2[2]-key1[2]) * t
end


function rk_update(row)
  local params= {}
  local part= rk_gettrack(rk_parttrack, row)

  if (part>=1 or part<=#rk_parts) then
     local active= rk_parts[part]
     if (active) then
     for i=1,#active do
        params[i]= rk_gettrack(active[i], row)
     end
     end
  end

   return part,params
end
