#version 330

varying vec4 Color;
varying vec3 VaryingColor;
varying vec3 Normal;
varying vec2 UV;
uniform sampler2D TextureSeeThrough;
uniform sampler2D Texture;
uniform sampler2D Paper;
uniform float ittime;
uniform float ttime;
uniform float k0;
uniform float k1;
uniform float k2;
uniform float k3;
uniform float k4;
uniform float k5;
uniform float OtherFlow;
uniform float Mode;
uniform float OtherMode;
uniform float ObjectType;

uniform float texture_width;
uniform float texture_height;
vec2 iResolution = vec2((16.0 / 9.0) * texture_width, texture_height);
//vec2 iResolution=vec2 (2000.0,1000.0);

int ShadowRun = 5;
float Dithering = 4;





////////////////////
////////////////////
////////////////////
////////////////////

float hash(float n)
{
	return fract(sin(n) * 43758.5453);
}

vec3 hash3(vec2 p) {
	vec3 q = vec3(dot(p, vec2(127.1, 311.7)),
		dot(p, vec2(269.5, 183.3)),
		dot(p, vec2(419.2, 371.9)));
	return fract(sin(q) * 43758.5453);
}
// noise
float iqnoise(in vec2 x, float u, float v) {
	vec2 p = floor(x);
	vec2 f = fract(x);

	float k = 1.0 + 63.0 * pow(1.0 - v, 4.0);

	float va = 0.0;
	float wt = 0.0;
	for (int j = -2; j <= 2; j++)
		for (int i = -2; i <= 2; i++)
		{
			vec2 g = vec2(float(i), float(j));
			vec3 o = hash3(p + g) * vec3(u, u, 1.0);
			vec2 r = g - f + o.xy;
			float d = dot(r, r);
			float ww = pow(1.0 - smoothstep(0.0, 1.414, sqrt(d)), k);
			va += o.z * ww;
			wt += ww;
		}

	return va / wt;
}


vec4 rgb_to_cmyk(vec3 col) {
	float a = max(col.r, max(col.g, col.b));
	return vec4((a - col.rgb) / a, 1.0 - a);
}

vec3 cmyk_to_rgb(vec4 col) {
	float ik = 1.0 - col.w;
	return (1.0 - col.rgb) * ik;
}

float ht(vec2 uv) {
	uv = fract(uv);
	return pow(length(uv - 0.5) / sqrt(0.5), 1.7);
}

vec2 rotate(vec2 p, float a) {
	float c = cos(a);
	float s = sin(a);
	return vec2(c * p.x + s * p.y, c * p.y - s * p.x);
}

vec4 cmyk_ht(vec2 uv) {
	return vec4(
		ht(rotate(uv, radians(15.0))),
		ht(rotate(uv, radians(75.0))),
		ht(rotate(uv, radians(0.0))),
		ht(rotate(uv, radians(45.0))));
}
vec3 rgb2hsv(vec3 c)
{
	vec4 K = vec4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);
	vec4 p = mix(vec4(c.bg, K.wz), vec4(c.gb, K.xy), step(c.b, c.g));
	vec4 q = mix(vec4(p.xyw, c.r), vec4(c.r, p.yzx), step(p.x, c.r));

	float d = q.x - min(q.w, q.y);
	float e = 1.0e-10;
	return vec3(abs(q.z + (q.w - q.y) / (6.0 * d + e)), d / (q.x + e), q.x);
}

vec3 hsv2rgb(in vec3 c)
{
	vec3 rgb = clamp(abs(mod(c.x * 6.0 + vec3(0.0, 4.0, 2.0), 6.0) - 3.0) - 1.0, 0.0, 1.0);

	return c.z * mix(vec3(1.0), rgb, c.y);
}


vec3 scene(vec2 fragCoord) {
	vec2 uv = fragCoord / iResolution.xy * 2.0 - 1.0;
	//uv.xy*=2.0;
	//uv.xy=mod (vec2 (0.0)+uv.xy,vec2 (1.0));
	uv.x *= iResolution.x / iResolution.y;
	uv.x *= 0.5 / 1.0;


	//uv.xy = 0.004*gl_FragCoord.xy;
	//if (Zposition<0.02) 
	Dithering = 4; // backgournd ?



	if (int(OtherMode) == 1)
	{
		Dithering = 20; // backgournd ?
		if (ttime >= 9.0)
			Dithering = 8; // backgournd ?


	}
	if (int(ObjectType) == 0) {
		Dithering = 10 - ttime * 0.1;
	}
	if (int(ObjectType) == 8) {
		Dithering = 2;
	}
	if (int(ObjectType) == 10) {
		Dithering = 2;
	}
	if (int(ObjectType) == 11) {
		Dithering = 3;
	}

	if (int(ObjectType) == 1) {
		if (ttime > 25.0)
			Dithering = 12; // backgournd ?
		if (ttime >= 41.0)
			Dithering = 7; // backgournd ?

	};
	if (ttime >= 49.0)
		Dithering = 3;
	if (ttime >= 61.0)
		Dithering = 7;
	if (ttime >= 65.0)
		Dithering = 4;
	if (ttime >= 73.0)
		Dithering = 3;

	if (ttime >= 73.0) {
		if (int(ObjectType) == 1)
			Dithering = 14;
	};


	if (ttime >= 89.0) {
		if (int(ObjectType) == 1)
			Dithering = 4;
	};
	if (int(ObjectType) == 13)			Dithering = 10.0;

	if (ttime >= 89.0) {
		if (int(ObjectType) == 1)
			Dithering = 4 + clamp((ttime - 103 + UV.x * 0.2) * 0.4, 0.0, 1.0) * 4.0;
	};


	if (ttime >= 89.0) {
		if (int(ObjectType) == 9)
			Dithering = 15;
	};
	if (ttime >= 121.0) {
		if (int(ObjectType) == 1)
			Dithering = 5;
		if (int(ObjectType) == 10)
			Dithering = 10;
		if (int(ObjectType) == 14) {
			Dithering = 10.0;
			//col.xyz = cacheother.xyz;
			//col.x = 10.0;
		//	col.y = 0.3;
		}

	}
	//Dithering = 8.0;
	//Dithering = 7.0;

	//if (ttime>=9.0)		Dithering = 3;

	if (ttime >= 153.0)
		Dithering = 3.0;

	if (ttime >= 161.0)
		Dithering = 7;

	if (ttime >= 169.0)
	{
		Dithering = 8;
		if (int(ObjectType) == 3)
			Dithering = 6;
		if (int(ObjectType) < -2)
			Dithering = 5;

	}
	if (ttime >= 241.0) {

		Dithering = 6;
		if (ttime >= 249.0)
			Dithering = 10;
	};

	float s = iResolution.y / Dithering;
	//s = 100000.0;
	vec2 suv = uv * s;
	//suv = UV.xy *10000.0* s;
	vec4 htp = cmyk_ht(suv);
	//uv.y=mod (uv.y,0.3)+k0;
	vec4 col;
	col = texture(Texture, uv * vec2(1.0 / (iResolution.x / iResolution.y), 0.5) + 0.5) + 1.0 / 255.0;
	if (ttime >= 169.0) {
		if (int(ObjectType) == 1)
		{
			//col *= col*1.2;
		}
	}

	if (ttime >= 145.0) {
		if (int(ObjectType) != 1)
			col *= clamp((ttime - 145.0) * 0.5, 0.0, 1.0); // clamp(2.3 - 4.0 * UV.y, 0.0, 1.0);
	}

	if (int(ObjectType) == 1)
		if (ttime < 153.0)
			if (ttime >= 145.0)
			{
				col *= 1.2;
				if (UV.y < 0.20) col *= 2.0;
				if (UV.y > 0.65) {
					col *= pow(UV.y - 0.3, 3.5) * 6.0 * clamp(10.0 * (sin(UV.y * 721.0) - 0.8), 0.0, 1.0);
				}
				//if (UV.x < 0.2) col *= 0.0;
			//if (UV.x > 0.8) col *= 0.0;
			}

	if (int(ObjectType) == 1)
		if (ttime >= 141.0)
			if (ttime < 145.0)
			{

				vec2 _UV = UV;
				for (int q = 0; q < 25; q++) {
					col = texture(Texture, _UV).xyzw;

					float fr = 4.0;
					//_UV.x += fr*0.001 * sin(_UV.y * 18.3*0.6 + 1.7 * ttime);
				//	_UV.y += fr * 0.02 * sin(_UV.x * 19.3 * 0.6 + 0.6 * ttime);
					_UV.x -= 0.5;
					_UV.x *= 1.0 + fr * col.x * 0.001 * sin(_UV.y * 62.3 * 0.6 + 1.9 * ttime);
					_UV.x += 0.5;

					_UV.y -= 0.5;
					_UV.y *= 1.0 + fr * col.y * 0.0002 * sin(_UV.x * 32.3 * 0.6 + 2.5 * ttime);
					_UV.y += 0.5;
					//_UV.x += fr * 0.01 * sin(_UV.y * 19.3 * 0.6 + 0.4 * ttime);
					//_UV.y += fr * 0.01 * sin(_UV.x * 17.3 * 0.6 + 0.3 * ttime);
				}
				float fcc = 0.0;
				col.x = texture(Texture, _UV + vec2(fcc * 0.003, 0.0)).x; // uv* vec2(1.0 / (iResolution.x / iResolution.y), 0.5) + 0.5) + 1.0 / 255.0;
				col.y = texture(Texture, _UV).y; // uv* vec2(1.0 / (iResolution.x / iResolution.y), 0.5) + 0.5) + 1.0 / 255.0;
				col.z = texture(Texture, _UV + vec2(fcc * -0.003, 0.0)).z; // uv* vec2(1.0 / (iResolution.x / iResolution.y), 0.5) + 0.5) + 1.0 / 255.0;
				col *= 0.5 + _UV.y;
				col *= col;
			}

	vec4 cachecol = col;

	col = cachecol;

	if (ttime>169.0)
		if (int(ObjectType) == 1)
	{
		float coun = 0;



		float distt = length(col.xyz - vec3(0.5, 0.0, 0.0));
		distt = 1.0 - pow(2.5 * distt, 5.0);
	

		coun = 0;
		col *= 0.0;

		float fr = 0.0 * (iqnoise(vec2(0.0 * ttime + UV.xy * 4.0), 1.0, 1.0) - 0.5);
		float parallel = (ttime - 4.0) * clamp((UV.y - 0.7), 0.0, 1.0) * 0.2;
		parallel += (ttime - 4.0) * clamp(((1.0 - UV.y) - 0.5), 0.0, 1.0) * 0.02;
		//parallel = sign(parallel)*pow (abs(parallel),4.0);
		for (int t = 0; t < 20; t++) {
			float ph = float(t) / 20.0;
			// clouds, parallel
				col += texture(Texture, vec2(distt *sin (fr+ttime*2.0*3.14159)* 0.055*0.01*ph + 1.0 * UV.x, UV.y));
				//ol += texture(Texture, vec2( UV.x+distt*k0*0.1, UV.y));
			coun++;
		}
		col /= coun;
		col.xyz -= vec3(0.2);
		col.xyz *= 1.5;
		col.xyz = clamp(col.xyz, vec3(0.0), vec3(1.0));
		//col *= col;

	}

	if (ttime>=209.0) 
	if (int(ObjectType) == 3) {
		
		float fradial = length(vec2(9.0 / 9.0, 1.0) * UV.xy - vec2(0.55,0.5));

		col.xyz *= 1.0-4.0*0.528*fradial;


	};


	if (ttime>=225.0)
	if (int(ObjectType) == 10) {
		col.xyz *= clamp (1.3-1.0*UV.y,0.0,1.0);
		col.xyz*= clamp(1.6 - 1.0 * UV.x, 0.0, 1.0);
		//col.xyz *= 1.0+2.0*clamp((ttime - 237.0) * 0.1, 0.0, 1.0);
		//col.xyz *= 1.0-length(UV.x - 0.5);
	};

if (ttime>=241.0) 
if (int(ObjectType) == 20) {
	//col.xyz =vec3 (1.0)- pow(col.xyz, vec3(3.0)); // clamp((ttime - 241.0) * 0.3, 0.0, 1.0);
	col.xyz += vec3(0.3);
	col.xyz = rgb2hsv(col.xyz);
	col.y = -1.0;
	col.x += k1+UV.x*0.5;

	col.xyz = hsv2rgb(col.xyz);
	
	col.xyz *= 1.0 - clamp((ttime - 252.0 - col.z) * 0.2, 0.0, 1.0);

	if (ttime >= 257.0)
		col *= 0.0;

	col.xyz *= clamp(1.0 - 1.0 * abs(UV.y - 0.5), 0.0, 1.0);
	col.xyz *= clamp(2.5 - 5.0 * abs(UV.x - 0.5), 0.0, 1.0);
}


	if (int(ObjectType) == 10)
	{

		vec2 Pos = vec2(0.5 + 0.5 * sin(0.3 * 4.0 * ttime), 0.5 + 0.5 * cos(ttime * 4.0 * 0.3));
		float fr2 = 2.0 * (iqnoise(vec2(0.7 * ttime + UV.xy * 7.4), 1.0, 1.0) - 0.5);


		float fradial = length(vec2(9.0 / 9.0, 1.0) * UV.xy - vec2(0.5));

		float fdist = length(col.xyz - 2.0 * vec3(0.165) - fradial * 0.0 + 0.05 * sin((UV.y + UV.x) * 2000.0));
		if (ttime > 35.0) {

			fdist = length(col.xyz - 2.0 * vec3(0.134) - fradial * 0.0 + 0.05 * sin((UV.y + UV.x) * 1000.0));
			//fdist *= 1.0-clamp(((1.0-UV.y) - k1)*5.0, 0.0, 1.0) 				+ clamp(((1.0 - UV.y) - k0) * 5.0, 0.0, 1.0);
		};

		if (ttime >= 57.0) {

			fdist = length(col.xyz - 2.0 * vec3(0.039) - fradial * 0.0 + 0.07 * sin((UV.y + UV.x) * 2500.0));
			//fdist *= 1.0-clamp(((1.0-UV.y) - k1)*5.0, 0.0, 1.0) 				+ clamp(((1.0 - UV.y) - k0) * 5.0, 0.0, 1.0);
		};

		if (ttime >= 73.0) {

			fdist = length(col.xyz - 2.0 * vec3(0.039) - fradial * 0.0 + 0.07 * sin((UV.y + UV.x) * 3000.0));
			//fdist *= 1.0-clamp(((1.0-UV.y) - k1)*5.0, 0.0, 1.0) 				+ clamp(((1.0 - UV.y) - k0) * 5.0, 0.0, 1.0);
		};

		//		fdist += -pow(length(vec2(2.0, 1.0) * (Pos - UV.xy)), 1.0); // +fr2;

				//fdist = clamp(fdist, 0.0, 1.0);
		if (fdist > 0.5)
		{
			col.xyz = col.xyz * 1.0; // vec3(1.0);
			if (ttime < 73.0)
				if (ttime >= 57.0)
					col.xyz = vec3(1.0);

			if (ttime > 73.0)
			{
				col.xyz *= 1.5;
				col.xyz = clamp(col.xyz, vec3(0.0), vec3(1.0));
			}
		}
		else
			col.xyz = vec3(0.0);
		//if (UV.y < 0.6) col *= 0.0;
		//col.xyz = vec3(fdist);
		//col = cachecol;

	}

	if (int(ObjectType) == 11)
	{

		vec2 Pos = vec2(0.5 + 0.5 * sin(0.3 * 4.0 * ttime), 0.5 + 0.5 * cos(ttime * 4.0 * 0.3));
		float fr2 = 2.0 * (iqnoise(vec2(0.7 * ttime + UV.xy * 7.4), 1.0, 1.0) - 0.5);


		float fradial = length(vec2(9.0 / 9.0, 1.0) * UV.xy - vec2(0.5));

		float fdist = length(col.xyz - 2.0 * vec3(0.165) - fradial * 0.0 + 0.05 * sin((UV.y + UV.x) * 2000.0));
		//		fdist += -pow(length(vec2(2.0, 1.0) * (Pos - UV.xy)), 1.0); // +fr2;
		//fdist -= 1.0-clamp(UV.y - k0, 0.0, 1.0);
			//fdist = clamp(fdist, 0.0, 1.0);
		if (fdist > 0.5)

			col.xyz = col.xyz * 1.0; // vec3(1.0);
		else
			col.xyz = vec3(0.0);
		//if (UV.y < 0.6) col *= 0.0;
		//col.xyz = vec3(fdist);
		//col = cachecol;

	}


	// mirror
	/*if (int(OtherMode) == 1)
	{
//		col = texture(Texture, vec2 (2.0,1.0)*uv * vec2(1.0 / (iResolution.x / iResolution.y), 0.5) + 0.5) + 1.0 / 255.0;
		//vec4 col2 = texture(Texture, vec2 (1.0,0) * vec2(1.0 / (iResolution.x / iResolution.y)) + vec2(2.0, 1.0) * uv * vec2(1.0 / (iResolution.x / iResolution.y), 0.5) + 0.5) + 1.0 / 255.0;
		//col = texture(Texture, uv * vec2(1.0 / (iResolution.x / iResolution.y), 0.5) + 0.5) + 1.0 / 255.0;

		vec2 myuv = uv * vec2(1.0 / (iResolution.x / iResolution.y), 0.5)+0.5;

		vec4 col2 = texture(Texture, vec2 (0.5+myuv.x,myuv.y));
		//col = texture(Texture, vec2 (4.0*UV.x,UV.y));

		float fres = 1.0-sin(3.1415926535*UV.x);

		//fres = myuv.x;

		fres = clamp(fres, 0.0, 1.0);
		fres = pow(fres, 6.0);
		//col += 1.0*vec4(fres);
		//if (UV.x < 0.5) col = vec4(1.0);
		//col = vec4(fres);
		//fres = 1.0;
		col += (col2 - col) * fres;

		//col = col2;
	}
	*/

	//col.xyz = pow(k4*10*col.xyz, vec3(5.0));
	/*
	col.xyz = vec3 (1.0)*pow (length(col.xyz - vec3(k4))*2.0,2.0);
	col.xyz = clamp(col.xyz, vec3(0.0), vec3(1.0));
	col.xyz *= 10.0;
	col.xyz = clamp(col.xyz, vec3(0.0), vec3(1.0));
	*/


	/*
	if (length(col.xyz - vec3(0.1, 0.2, 0.1)) > 0.5)
	{
		col.xyz *= 10.0;;

	}
	else
		col.xyz *= 0.0;;

		*/

	if (0 == 1)
	{

		vec2 Pos = vec2(0.9 + 0.4 * sin(0.3 * ttime), 0.5 + 0.3 * sin(ttime * 0.3 * 1.12));
		float fr2 = 2.0 * (iqnoise(vec2(0.7 * ttime + UV.xy * 7.4), 1.0, 1.0) - 0.5);
		fr2 *= 2.0 * (iqnoise(vec2(1.2 * ttime + UV.xy * 4.9), 1.0, 1.0) - 0.5);
		fr2 = abs(fr2);
		fr2 += 1.0;
		//fr2 = 1.0+clamp(fr2, 0.0, 1.0);

		float l = (k0 + (1.0 - UV.y)) * 6.0 * length(vec2(1.0, 1.0) * vec2(UV.xy * vec2(16.0 / 9.0, 1.0) - Pos));
		l = fr2 * k0 * 6.0 * length(vec2(1.0, 1.0) * vec2(UV.xy * vec2(16.0 / 9.0, 1.0) - Pos));
		l = 1.2 - l;
		l *= fr2;
		l = clamp(l, 0.1, 2.0);
		//l *= l;
		col *= l;
		//col += vec4(pow (1.0-UV.y,4.0))*l*1.5*vec4 (1.0,0.5,0.0,0.0);

	}


	col.xyz = rgb2hsv(col.xyz);
	vec3 cacheother = col.xyz;
	//col.y = 0;
	//col.z = 0.0;// 2.0 * col.z;
	//if (int(OtherMode) == 1)		col.x += ttime * 1;
	//col.x+=-0.6*sin (ttime*0.0+(uv.x+uv.y)*100.0);
	//col.x+=2*sin (ttime*10.0+(uv.x+uv.y)*220.0);
	//col.x += 0.6*length (UV.xy-vec2 (0.5));
	//col.y = 1.0;
//	col.x = -0.39;
	//col.x += UV.y;
	//col.y += UV.y;
	if (int(ObjectType) == 0) {
		col.y = 0.5;
		col.x = 0.638;
		//if (ttime < 9.0) 
		{
			col.z -= clamp((ttime - 3.0) * 0.3, 0.0, 0.6);
			col.z *= clamp((ttime - 0.0 - UV.y) * 0.25, 0.0, 1.0);
		}
		//col.z = 0.0;
	}
	if (int(ObjectType) == 1) {

	}

	if (ttime < 161.0)
		if (int(ObjectType) == 1) {
			col.y = 0.3;
			col.x += 0.669;
			col.z *= 1.0 - 0.3 * clamp((ttime - 8.0), 0.0, 1.0);
			if (ttime >= 9.0) {
				col.x = 0.0;
			}
			//col.y = 1.0;
			//col.x = 150.0*k0;

		}
	if (int(ObjectType) == 2) {
		col.y = 0.4;
		col.x += 0.4;
	}

	if (int(ObjectType) == 4) {
		col.y = 1.0;
		col.x += 1.0;
		col.z *= clamp((ttime - 0.0) * 0.5, 0.0, 1.0);
	}

	if (int(ObjectType) == 5) {
		col.y = 1.0;
		col.x += ttime;
	}
	if (int(ObjectType) == 8) {
		col.y += 0.2;
		col.x += ttime;
	}

	if (ttime >= 9.0) {

		//col.y *= clamp((ttime - 9.0), 0.0, 1.0);
		col.x -= ttime * 0.3;
		col.z *= clamp((ttime - 8.5), 0.0, 1.0);
	};

	if (ttime >= 13.0) {
		if (int(ObjectType) != 8)
			col.z *= clamp((ttime - 13.0), 0.0, 1.0);
	};

	if (ttime >= 17.0) {
		if (int(ObjectType) != 8)
			col.z *= clamp((ttime - 17.0), 0.0, 1.0);
	};


	if (int(ObjectType) == 10)
	{
		//col.x = ttime;
		//col.y = 0.2;
		col.x = float(int(ttime * 2.0)) / 2.0 * 0.2 + 0.1 * UV.y;
		col.y = 0.2;
		//col.z = 1.0;
	}




	if (ttime >= 25.0) {

		col.y += -1 + clamp((ttime - 25.0 - 0.0 * length(UV.xy - vec2(0.5))) * 0.3, 0.0, 1.0);
	};

	if (ttime < 89.0)
		if (ttime >= 73.0) {
			if (int(ObjectType) == 1)			col.z *= UV.y;
		};

	if (int(ObjectType) == 13) {
		col.y = 0.0;
		col.z *= 0.2;
	}
	//discard;

	if (ttime < 161.0)
		if (ttime >= 89.0)
		{
			if (int(ObjectType) == 1) {

				vec2 Pos = vec2(0.9 + 0.4 * sin(0.9 * ttime), 0.5 + 0.3 * sin(ttime * 0.9 * 1.12));
				float fr2 = 2.0 * (iqnoise(vec2(0.7 * ttime + UV.xy * 7.4), 1.0, 1.0) - 0.5);
				fr2 *= 2.0 * (iqnoise(vec2(0.5 * ttime + UV.xy * 2.9), 1.0, 1.0) - 0.5);
				fr2 = abs(fr2);

				fr2 += 1.0;
				fr2 = 1.0;
				//fr2 = 1.0+clamp(fr2, 0.0, 1.0);

				float l = (0.148 + (1.0 - UV.y)) * 6.0 * length(vec2(1.0, 1.0) * vec2(UV.xy * vec2(16.0 / 9.0, 1.0) - Pos));
				l = fr2 * 0.148 * 6.0 * length(vec2(1.0, 1.0) * vec2(UV.xy * vec2(16.0 / 9.0, 1.0) - Pos));
				l = 1.2 - l;
				l *= fr2;
				l = 1.5 * clamp(l, 0.3, 3.0);
				//l *= l;
				col.z *= l;
				//col.z *= clamp((ttime - 89) * 0.3, 0.0, 1.0);
					//col.z *= clamp((ttime - 89) * 0.2, 0.0, 1.0);

				//col.z *= UV.y;
			}
		};


	if (ttime >= 121.0) {
		if (int(ObjectType) == 10) {
			//col.xyz = cacheother.xyz;
			//col.x = 10.0;
		//	col.y = 0.3;
		}
	}

	/*
	if (ttime >= 161.0) {


		if (int(ObjectType) == 1) {
			//col.xyz = cacheother.xyz;
			//col.x = 10.0;
		//	col.y = 0.3;
			col.z *= 0.0;
		}
	}
	*/

	if (ttime >= 89) {

		//	col.z *= clamp((ttime - 89) * 0.2, 0.0, 1.0);
	};

	if (ttime >= 33.0) {

		col.y += -2 + 2.0 * clamp((ttime - 33.0 - 0.0 * length(UV.xy - vec2(0.5))) * 0.5, 0.0, 1.0);
	};
	if (ttime >= 45.0) {

		col.y += -2 + 2.0 * clamp((ttime - 45.0 - 0.0 * length(UV.xy - vec2(0.5))) * 0.5, 0.0, 1.0);
	};

	if (ttime >= 57.0) {

		col.y += -1 + 1.0 * clamp((ttime - 57.0 - 0.0 * length(UV.xy - vec2(0.5))) * 0.5, 0.0, 1.0);
	};

	if (ttime >= 257.0) {

		col.y += -10 + 10.0 * clamp((ttime - 257.0 - 0.0 * length(UV.xy - vec2(0.5))) * 0.15, 0.0, 1.0);
	};


	if (ttime >= 265.0) {

		col.y += -10 + 10.0 * clamp((ttime - 265.0 - 0.0 * length(UV.xy - vec2(0.5))) * 0.15, 0.0, 1.0);
	};



	if (ttime >= 273.0) {

		col.y += -10 + 10.0 * clamp((ttime - 273.0 - 0.0 * length(UV.xy - vec2(0.5))) * 0.15, 0.0, 1.0);
	};

	/*
		if (ttime >= 165.0) {

			col.y += -1 + 1.0 * clamp((ttime - 165.0 - 0.0 * length(UV.xy - vec2(0.5))) * 0.5, 0.0, 1.0);
			col.z *= 2.0 - 1.0 * clamp((ttime - 165.0 - 0.0 * length(UV.xy - vec2(0.5))) * 0.5, 0.0, 1.0);
		};
		*/
	if (ttime >= 61.0) {

		col.y += -1 + 1.0 *  clamp((ttime - 61.0 - 0.0 * length(UV.xy - vec2(0.5))) * 0.5, 0.0, 1.0);
	};
	if (ttime >= 209.0) {

		col.y += -2 + 2.0 * clamp((ttime - 209.0 - 0.0 * length(UV.xy - vec2(0.5))) * 0.5, 0.0, 1.0);
	};

	/*f (ttime >= 249.0) {

		col.y += -2 + 2.0 * clamp((ttime - 249.0 - 0.0 * length(UV.xy - vec2(0.5))) * 0.5, 0.0, 1.0);
	};
	*/
	if (ttime >= 217.0) {

		col.y += -2 + 2.0 * clamp((ttime - 217.0 - 0.0 * length(UV.xy - vec2(0.5))) * 0.5, 0.0, 1.0);
	};

	if (ttime >= 73.0) {

		col.y += -1 + 1.0 * clamp((ttime - 73.0 - 0.0 * length(UV.xy - vec2(0.5))) * 0.5, 0.0, 1.0);
	};

	if (ttime >= 177.0) {

		col.y += -3 + 3.0 * clamp((ttime - 177.0 - 0.0 * length(UV.xy - vec2(0.5))) * 0.5, 0.0, 1.0);
	};
	if (ttime >= 89.0) {

		col.z += -2 + 2.0 * clamp((ttime - 89.0 - 0.0 * length(UV.xy - vec2(0.5))) * 0.75, 0.0, 1.0);
	};

	if (ttime >= 97.0) {

		col.y += -2 + 2.0 * clamp((ttime - 97.0 - 0.0 * length(UV.xy - vec2(0.5))) * 0.5, 0.0, 1.0);
	};

	if (ttime >= 141.0) {
		//col.x = 100-col.x;
		if (int(ObjectType) != 1)
			col.y += -4 + 4.0 * clamp((ttime - 141.0 - 0.0 * length(UV.xy - vec2(0.5))) * 0.75, 0.0, 1.0);
	};

	if (ttime >= 113.0) {

		col.z -= 1 - 1.0 * clamp((ttime - 113.0 - 0.0 * length(UV.xy - vec2(0.5))) * 0.8, 0.0, 1.0);
	};

	if (ttime >= 137.0) {

		col.y += -2 + 2.0 * clamp((ttime - 137.0 - 0.0 * length(UV.xy - vec2(0.5))) * 0.5, 0.0, 1.0);
	};


	if (ttime >= 65.0) {

		col.y += -4 + 4.0 * clamp((ttime - 65.0 - 0.0 * length(UV.xy - vec2(0.5))) * 0.2, 0.0, 1.0);
	};

	if (ttime >= 81.0) {

		col.y += -4 + 4.0 * clamp((ttime - 81.0 - 0.0 * length(UV.xy - vec2(0.5))) * 0.2, 0.0, 1.0);
	};

	if (ttime >= 13.0) {

		col.y += -1 + clamp((ttime - 13.0 - 0.0 * length(UV.xy - vec2(0.5))) * 0.2, 0.0, 1.0);
	};

	if (ttime > 25.0)
		if (int(ObjectType) == 1) {
			//col.x = k0 * 250;
			//col.y = 0.7;
		}

	if (ttime < 121.0)
		if (ttime > 119.0) {

			if (int(ObjectType) != 12)
			{
				col.z -= clamp((ttime - 119.0 - UV.y * 0.5) * 0.75, 0.0, 1.0);
			}
		};

	if (ttime >= 121.0)
		if (ttime < 123.0) {

			if (int(ObjectType) != 12)
			{
				col.z *= clamp((ttime - 121.0 - UV.y * 0.5) * 0.5, 0.0, 1.0);
			}
		};


	if (ttime > 41.0)
	{

		float fs = sin(((0.154 + 1.0 + 2.0 * ttime) * 3.1415926535));
		fs = clamp(fs, 0.0, 1.0);
		fs = pow(fs, 5.0);
		col.y += -fs * 0.3;
		col.z += 0.0 * fs;

	}


	if (ttime < 73.0)
		if (ttime > 70.0)
			if (int(ObjectType) != 5)
				//	if (int(ObjectType) != 1)
			{

				float fr = 1.0 * (iqnoise(vec2(12.0 * ttime + UV.xy * 0.0), 1.0, 1.0) - 0.5);
				if (fr < -0.008 - 0.0 * (ttime - 70.0))
					col.z *= 0.3;
				else
					col.z *= 4.0 - 3.0 * clamp((ttime - 70.0) * 0.5, 0.0, 1.0);
			}


	if (int(ObjectType) == 14)
	{
		col.y = 0.0;
		col.z = cacheother.z * clamp((ttime - 121.0) * 3.0, 0.0, 1.0);
		col.z = clamp(pow(col.z * 1.4, 8.0), 0.0, 1.0);
		//col.z *= clamp (1.0-UV.y*1.0,0.0,1.0);
	}

	//if (int (ObjectType)==8)col.z *= clamp (1.8-1.4*UV.y,0.0,1.0);
	//if( col.z>k1) discard;
	//if (col.y>k0) discard;
	/*
	if (ttime>=254)
	if (int (ObjectType)!=20)
	if (ttime >= 254.0) {

		col.y *= 1.0-clamp ((ttime - 254.0),0.0,1.0);
	};
	*/
	col.xyz = hsv2rgb(col.xyz);


	//col.xyz = vec3(0.2);
	//if (sin ((uv.x+uv.y)*230.0)<0.0) discard;
	//col.xyz*=0.0;
	/*
	if (length (col.xyz-vec3 (k2,k4,k5))<0.3)
		col.xyz*=4.0; //2.0;
	else
		col.xyz*=1.0;
	*/

	//col*=1.0+0.05*sin(uv.x*5.0+4.0*ittime);
	
	

	col.xyz = clamp(col.xyz, vec3(0.0), vec3(1.0));
	vec4 cmyk = rgb_to_cmyk(col.rgb);

	cmyk = step(htp, cmyk);
	//cmyk=cmyk.yyyy;
	//cmyk.z=1.0;
	return clamp(cmyk_to_rgb(cmyk), vec3(0.0), vec3(1.0));
}


void mainImage(out vec4 fragColor, in vec2 fragCoord)
{
	// supersample
	const int N = 1;
	float w = 0.0;
	vec3 c = vec3(0.0);
	for (int x = -N; x <= N; ++x) {
		for (int y = -N; y <= N; ++y) {
			c += scene(fragCoord + vec2(x, y) / (2.5 * float(N)));
			w += 1.0;
		}
	}
	fragColor = vec4(c / w, 1.0);
	//fragColor.xyz*=texture(texture2d,fragCoord/iResolution.xy).xyz;
}
////////////////////
////////////////////
////////////////////
////////////////////
////////////////////
////////////////////
////////////////////















float IsGreen(vec3 Col) {

	//if (int(OtherMode) == 1) return 0.0;
	//	return 0.0;
	//if (Zposition<0.02) return 0.0; //discard;
	float fdist = length(Col.xyz - vec3(0, 1, 1));
	if (fdist < 0.5)
		//if (abs(Col.y - Col.x) > 0.2)
//if (abs(Col.y - Col.z) < 0.09)

return 1.0;
	return 0.0;
};






vec3 Edge(vec2 UV) {
	vec2 _UV = UV;
	//float f= 
	float fr = (iqnoise(vec2(1.0 * int(7.0 * ittime) + UV.xy * 20.0), 1.0, 1.0) - 0.5);

	float edge = 1.0;
	//if (ttime<73.0)
	if (ttime >= 65.0)		edge = 0.5;
	if (int(ObjectType) == 13) edge = 0.0;
	edge *= clamp((ttime - 1.0), 0.0, 1.0);

	if (ttime >= 89.0)
		edge = 1.5;

	if (ttime >= 97.0)
		edge = 2.5 - clamp((ttime - 101.0) * 0.4, 0.0, 1.0) * 2.0;
	if (ttime >= 113.0)
		edge = 0.0;

	edge += clamp((ttime - 122.0), 0.0, 1.0);


	if (ttime >= 145.0)
	{
		edge = 0.0 + 1.0 * clamp((ttime - 147.0), 0.0, 1.);
		if (int(ObjectType) == 12)
			edge = 0.0;

	}

	if (ttime >= 161.0)
	{
		if (int(ObjectType) == 1)
			edge = 0.0;

	}

	//edge -= clamp((ttime - 131.0), 0.0, 1.0);
//edge = 1.0;
	float coun = 0;
	float tot = 0;
	for (int ry = -ShadowRun; ry < ShadowRun; ry++)
		for (int rx = -ShadowRun; rx < ShadowRun; rx++)
		{
			tot++;
			vec2 pr = 0.002 * edge * vec2(rx, ry);
			vec3 Col = texture(Texture, _UV.xy + pr).xyz;
			if (IsGreen(Col.xyz) < 0.5) {
				coun += 1.0 + 0.6 * fr;
			}

		}
	coun /= tot;

	if (coun > 0.4) coun = 1.0; else coun = 0.0;
	return vec3(1.0) * coun;
}


void main(void)
{

	if (ttime >= 89) {

		if (int(ObjectType) == 11) {

			if (UV.x > 0.7 + 0.15 * OtherFlow) discard;
		};
	}

	if (int(ObjectType) == 20) {

		vec2 UVV = vec2(0.4, 1.0) *0.6* UV.xy;
		UVV.x += 0.433;
		UVV.y += 0.134;

		UVV = clamp(UVV, vec2(0.0), vec2(1.0));
		vec3 OtherColor = texture(TextureSeeThrough, UVV.xy).xyz;
		if (IsGreen(OtherColor) < 0.5) discard;
	};

	

	if (OtherFlow > 0.001)
		if (ttime < 140.0)
			if (ttime >= 113)
			{

				//if (int(ObjectType) == 11)
				{
					float fr = (iqnoise(vec2(0.2 * ittime + UV.xy * 15.5), 1.0, 1.0) - 0.5);
					if (UV.x < OtherFlow + fr * 0.02 - 0.00) discard;
				};
			}

	vec3 OrColor = texture(Texture, UV.xy).xyz;
	gl_FragData[0].xyz = texture(Texture, UV.xy).xyz;
	
	//if (UV.x < 0.2) gl_FragData[0].xyz = vec3(1, 1, 0);
	//gl_FragData[0].w = Zposition;
	//return;

	float fr = (iqnoise(vec2(15.0 * ittime + UV.xy * 0.0), 1.0, 1.0) - 0.5);
	float fr3 = (iqnoise(vec2(15.0 * ittime + UV.xy * 1.0), 1.0, 1.0) - 0.5);
	float fry = (iqnoise(vec2(17.0 * ittime + UV.xy * 0.0), 1.0, 1.0) - 0.5);
	float fr2 = (iqnoise(vec2(50.0 * ittime + UV.xy * 1.0), 1.0, 1.0) - 0.5);

	vec2 _UV = UV;
	/*
	_UV -= vec2(0.5);
	_UV.x += 0.0002 * fr;
	_UV.y += 0.0002 * fry;
	_UV.xy *= 1.0 + 0.002 * fr3;
	_UV += vec2(0.5);
	*/
	vec3 Col = texture(Texture, _UV.xy).xyz;

	if (IsGreen(Col) > 0.5) {
		vec3 edge = Edge(_UV);

		if (length(edge) < 0.1) discard;

		Col = edge * 1.0 * pow(texture(Paper, _UV.xy * vec2(1, 1)).xyz, vec3(0.8));; //*(1.0+sin ((UV.x+_UV.y)*1000.0));
		Col *= Color.xyz + (vec3(1.0) - Color.xyz) * 0.9;

	}
	else
	{
		//return;
		vec4 CCol;
		mainImage(CCol, _UV * iResolution);
		Col.xyz = CCol.xyz;
		//return;
		//if (int (OtherMode)==1) 		Col = texture(Texture, _UV.xy).xyz;
		//Col*=Color.xyz;
		//Col.xyz = Col.xxx;

		/*if (length(Col.xyz - vec3(0.2, 0.1, 0.1)) < 0.2)
			Col.xyz = vec3(1.0);
		else
			Col.xyz = vec3(0.0);
			*/
			//		 Col.xyz *= pow (texture(Paper, _UV.xy*vec2 (1,1)).xyz,vec3 (1.2));
	}


	//Col=Edge (UV);
	//Col.xyz *= pow(texture(Paper, _UV.xy * vec2(1, 1)).xyz, vec3(0.8));

	if (OtherFlow > 0.001)
		if (ttime >= 113)
		{

			//if (int(ObjectType) == 11)
			{
				float fr = (iqnoise(vec2(0.2 * ittime + UV.xy * 15.5), 1.0, 1.0) - 0.5);
				//		if (UV.x < OtherFlow + 0.02 + fr * 0.05) Col.xyz *= 0.8;
					//	if (UV.x < OtherFlow + 0.01 + fr * 0.05) Col.xyz *= 0.8;
			};
		}


	gl_FragData[0].xyz = Col; // *(1.0 + 0.2 * fr2);
	//gl_FragData[0].xyz+=vec3 (1,0,0);
	//gl_FragData[0].xyz=Color.xyz;
	//gl_FragData[0].xyz=texture(Texture, _UV.xy*1).xyz;


	//gl_FragData[0].xyz *= pow(texture(Paper, _UV.xy * vec2(1, 1)).xyz, vec3(0.8));


	gl_FragData[0].xyz *= Color.xyz;

	//if (ttime > 25.0) 

	vec3 CC = texture(Texture, _UV.xy).xyz;
	float fl = 2.0 * ttime * 0.2 - 1.0 * CC.x;
	//fl = sin(fl*3.0);
	// = pow(fl, 10.0);
	//fl = clamp(fl, 0.0, 1.0)*1.0;
	//if (int (Mode)==2) 
	//gl_FragData[0].xyz *= hsv2rgb(vec3(-fl,0.5,1.0));

	//gl_FragData[0].xyz = vec3(CC.z);
	//gl_FragData[0].xyz = vec3(_UV.xyx);
	gl_FragData[0].w = 0.0;

}
