#version 330

varying vec4 Color;
varying vec3 VaryingColor;
varying vec3 Normal;
varying vec2 UV;
uniform sampler2D Texture;
varying vec3 OriginalThePos;

uniform sampler2D Paper;
uniform float ttime;
uniform float ittime;
uniform float OtherMode;
uniform float k0;
uniform float k1;
uniform float k2;
uniform float IsStatue;
uniform float k3;
uniform float k4;
uniform float k5;
uniform float Mode;
uniform float Type;
uniform float element;
varying vec3 ThePos;
uniform vec3 HeadPosition;

uniform float texture_width;
uniform float texture_height;
vec2 iResolution=vec2 (texture_width,texture_height);

int ShadowRun=7;
float Dithering=4;

uniform vec3 Skeleton[22];





float hash(float n)
{
	return fract(sin(n) * 43758.5453);
}
float noise(in vec3 x)
{
	vec3 p = floor(x);
	vec3 f = fract(x);

	f = f * f * (3.0 - 2.0 * f);

	float n = p.x + p.y * 57.0 + 113.0 * p.z;

	float res = mix(mix(mix(hash(n + 0.0), hash(n + 1.0), f.x),
		mix(hash(n + 57.0), hash(n + 58.0), f.x), f.y),
		mix(mix(hash(n + 113.0), hash(n + 114.0), f.x),
			mix(hash(n + 170.0), hash(n + 171.0), f.x), f.y), f.z);
	return res;
}


float fbm(vec3 p)
{
	float f;
	f = 0.5000 * noise(p); p = p * 2.02;
	f += 0.2500 * noise(p); p = p * 2.03;
	f += 0.1250 * noise(p);
	return f;
}


vec3 hash3(vec2 p) {
	vec3 q = vec3(dot(p, vec2(127.1, 311.7)),
		dot(p, vec2(269.5, 183.3)),
		dot(p, vec2(419.2, 371.9)));
	return fract(sin(q) * 43758.5453);
}
// noise
float iqnoise(in vec2 x, float u, float v) {
	vec2 p = floor(x);
	vec2 f = fract(x);

	float k = 1.0 + 63.0 * pow(1.0 - v, 4.0);

	float va = 0.0;
	float wt = 0.0;
	for (int j = -2; j <= 2; j++)
		for (int i = -2; i <= 2; i++)
		{
			vec2 g = vec2(float(i), float(j));
			vec3 o = hash3(p + g) * vec3(u, u, 1.0);
			vec2 r = g - f + o.xy;
			float d = dot(r, r);
			float ww = pow(1.0 - smoothstep(0.0, 1.414, sqrt(d)), k);
			va += o.z * ww;
			wt += ww;
		}

	return va / wt;
}


////////////////////
////////////////////
////////////////////
////////////////////


vec4 rgb_to_cmyk(vec3 col) {
    float a = max(col.r, max(col.g, col.b));
    return vec4((a - col.rgb) / a, 1.0 - a);
}

vec3 cmyk_to_rgb(vec4 col) {
    float ik = 1.0 - col.w;
    return (1.0 - col.rgb) * ik;
}

float ht(vec2 uv) {
    uv = fract(uv);
    return pow(length(uv - 0.5) / sqrt(0.5), 1.7);
}

vec2 rotate (vec2 p, float a) {
    float c = cos(a);
    float s = sin(a);
    return vec2(c*p.x + s*p.y, c*p.y - s*p.x);
}

vec4 cmyk_ht(vec2 uv) {
    return vec4(
        ht(rotate(uv, radians(15.0))),
        ht(rotate(uv, radians(75.0))),
        ht(rotate(uv, radians(0.0))),
        ht(rotate(uv, radians(45.0))));
}

vec3 scene(vec2 fragCoord) {
    vec2 uv = fragCoord/iResolution.xy * 2.0 - 1.0;
    uv.x *= iResolution.x/iResolution.y;
    uv.x*=0.5/1.0;
    float s = iResolution.y / Dithering;
    vec2 suv = uv * s;
    vec4 htp = cmyk_ht(suv);


	float fr = (iqnoise(vec2(25.7 * ittime + uv.xy * 1.3), 1.0, 1.0) - 0.5);
	float frx = (iqnoise(vec2(15.0 * ittime + uv.xy * 1.0), 1.0, 1.0) - 0.5);

	uv.x+=fr*0.02;
	uv.y+=frx*0.02;
    vec4 col = texture(Texture, uv * vec2(1.0/(iResolution.x/iResolution.y), 0.5) + 0.5) + 1.0/255.0;

	
	//    col=vec4 (ivec4 (8.0*col.xxxx))/8.0;

	float leng = length (col.xyz-vec3 (0.15));
	if (leng>0.5) leng=0.7;// else leng=0.3;
	
	col=vec4 (leng);


	col*=1.0+0.05*sin(uv.x*5.0+4.0*ittime);

	if (texture(Texture, uv * vec2(1.0/(iResolution.x/iResolution.y), 0.5)+0.5+0.01).x<0.01) 		col*=0.0;
	if (texture(Texture, uv * vec2(1.0/(iResolution.x/iResolution.y), 0.5)+0.5-0.01).x<0.01) 		col*=0.0;


	vec4 cmyk = rgb_to_cmyk(col.rgb);
    
    cmyk = step(htp, cmyk);

    return clamp(cmyk_to_rgb(cmyk), vec3(0.0), vec3(1.0));
}






void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    // supersample
    const int N = 1;
    float w = 0.0;
    vec3 c = vec3(0.0);
    for (int x = -N; x <= N; ++x) {
        for (int y = -N; y <= N; ++y) {
            c += scene(fragCoord + vec2(x,y)/(1.5*float(N)));
            w += 1.0;
        }
    }
    fragColor = vec4(c / w, 1.0);
	//fragColor.xyz*=texture(texture2d,fragCoord/iResolution.xy).xyz;
}




////////////////////
////////////////////
////////////////////
////////////////////
////////////////////
////////////////////
////////////////////












float IsGreen(vec3 Col) {

	if (abs(Col.y - Col.x) > 0.2)
		if (abs(Col.y - Col.z) < 0.09)

			return 1.0;
	return 0.0;
};






vec3 Edge(vec2 UV) {
	vec2 _UV = UV;
	//float f= 
	float fr = (iqnoise(vec2(15.0 * ittime + UV.xy * 20.0), 1.0, 1.0) - 0.5);


	float coun = 0;
	float tot = 0;
	for (int ry = -ShadowRun; ry < ShadowRun; ry++)
		for (int rx = -ShadowRun; rx < ShadowRun; rx++)
		{
			tot++;
			vec2 pr = 0.0004 * vec2(rx, ry);
			vec3 Col = texture(Texture, _UV.xy + pr).xyz;
			if (IsGreen(Col.xyz) < 0.5) {
				coun += 1.0 + 0.6 * fr;
			}

		}
	coun /= tot;
	if (coun > 0.4) coun = 1.0; else coun = 0.0;
	return vec3(1.0) * coun;
}


void main(void)
{
	gl_FragData[0].w=0.5;
	{
	gl_FragData[0].xyz=pow (Color.xyz,vec3 (2.0)); //olor.xyz;


	//gl_FragData[0].xyz = vec3(1.0, 0, 0);
	if (IsStatue > 0.5) return;
	vec3 OriginalColor = texture(Texture, UV.xy).xyz;


	vec3 vf = texture(Paper, UV.xy).xyz;
	//0.0) + OriginalThePos.yz * 0.002, vec2(1.0))).xyz;
	//vf *= vf;
	//float f  = fbm (OriginalThePos*0.01+vec3 (ittime));
	gl_FragData[0].xyz*=vec3 (1.0)*vf;
	gl_FragData[0].xyz = texture(Texture, UV.xy).xyz;
	
	



	float dy = clamp(5.0 * -(OriginalThePos.y - 1.1), 0.0, 1.0);
	dy -= clamp(5.0 * -(OriginalThePos.y - 0.8), 0.0, 1.0);
	if (OriginalThePos.x < -0.25) dy = 0.0;
	if (OriginalThePos.x > 0.06) dy = 0.0;
	//dy -= 0.15*sin(clamp (OriginalThePos.x,-1.0,1.0)*17);
	//clamp(5.0 * -(OriginalThePos.y - 0.8), 0.0, 1.0);
	//dy += -0.3+0.7*texture(Texture, UV.xy).x;

	float dist = length(texture(Texture, UV.xy).xyz- vec3(k4));
	

	//dist *= 1.0-dy;
	//dist += dy*0.2*sin(90.0 * OriginalThePos.x) * sin(90.0*OriginalThePos.y);

	if (dist > 0.5)

	{
		gl_FragData[0].xyz = gl_FragData[0].xxx;
			gl_FragData[0].xyz = vec3(1.0);
	}
	else
		//gl_FragData[0].xyz = vec3(0, 1, 1);
		gl_FragData[0].xyz = vec3(0.0);

	 dist = length(texture(Texture, UV.xy).xyz - vec3(-0.4));
	dist *= 1.0 - dy;


	if (dist < 0.5)
		gl_FragData[0].xyz = vec3(0, 1, 1);






	gl_FragData[0].xyz = texture(Texture, UV.xy).xyz;



	{
		// lips

		float dist = length(texture(Texture, UV.xy).xyz - vec3(0.5,0.0,0.0));
		//if (dist < 0.4)			gl_FragData[0].xyz = vec3(1.0);

	}

	if (OriginalThePos.y > 1.55)
		if (OriginalThePos.y < 1.65)
		{

		//	gl_FragData[0].xyz = vec3(0, 1, 1);
		}

	//dy = 0.0;
/*	if (dist > 0.3 + dy) gl_FragData[0].xyz = vec3(1.0); // texture(Texture, UV.xy).xyz;
	else
		gl_FragData[0].xyz = vec3(0.0);
	*/
	float fr = (iqnoise(vec2(0.0003 * ittime + UV.xy * 25.3), 1.0, 1.0) - 0.5);
	//fr += 10.0*dy;
	float kk2 = 1.0;
	if (ttime >= 63.0)
		kk2 = -0.039;

	if (ttime<73.0)
	if (ttime>=65.0)
	if (fr > kk2)
		gl_FragData[0].xyz -= 0.2*vf; // vec3 vf = texture(Paper, mod(vec2(100.0) + OriginalThePos.yz * 0.002, vec2(1.0))).xyz;

	if (ttime<89.0)
	if (ttime >= 73.0) {

		//if (fr > kk2)			gl_FragData[0].xyz = pow ( k4*texture(Paper, 1.0*UV.xy).xyz,vec3 (4.0));

		fr = (iqnoise(vec2(0.0003 * ittime + UV.xy * 15.3), 1.0, 1.0) - 0.5);
		if (fr > 0.27)
			gl_FragData[0].xyz = vec3(0, 1, 1); // 0.2 * vf; // vec3 vf = texture(Paper, mod(vec2(100.0) + OriginalThePos.yz * 0.002, vec2(1.0))).xyz;

		/*
		if (OriginalThePos.x < 0.05)
			if (OriginalThePos.x >-0.2)
				if (OriginalThePos.y > 1.5)
					if (OriginalThePos.y < 1.8)
					{
						gl_FragData[0].xyz = vec3(0, 1, 1); // 0.2 * vf; // vec3 vf = texture(Paper, mod(vec2(100.0) + OriginalThePos.yz * 0.002, vec2(1.0))).xyz;
					}

					*/
		// (ttime<83.0)
		{

			float fdist = length(OriginalThePos.xy - vec2(-0.1, 1.65));
			if (fdist < 0.15-clamp ((ttime-84.0+2.0*-0.276-(OriginalThePos.y-1.7)*3.0)*6.1,0.0,1.0)) gl_FragData[0].xyz = vec3(0, 1, 1);

		}


	}

	if (ttime < 65.0)
		if (fr > kk2)
			gl_FragData[0].xyz =  vf; // vec3 vf = texture(Paper, mod(vec2(100.0) + OriginalThePos.yz * 0.002, vec2(1.0))).xyz;

	/*
	if (ttime > 65.0)
	{
		if (fr > k2)
			gl_FragData[0].xyz = vec3 (0,1,1); // vec3 vf = texture(Paper, mod(vec2(100.0) + OriginalThePos.yz * 0.002, vec2(1.0))).xyz;

		}

		*/




	//gl_FragData[0].xyz = vec3(float (index)*0.25);




	//gl_FragData[0].xyz *= clamp(5.0*(OriginalThePos.y - 1.0), 0.0, 1.0);
	//if (OriginalThePos.y < 1.1) gl_FragData[0].xyz = vec3(0.0, 0, 0);

	//gl_FragData[0].xyz = pow (texture(Texture, UV.xy).xxx,vec3 (2.0));



	//gl_FragData[0].xyz = vec3(1.0, 0, 0);
	return;
	}


	float fr = (iqnoise(vec2(0.0 * ittime + UV.xy * 3.0), 1.0, 1.0) - 0.5);
	

	float headl = length (HeadPosition -OriginalThePos);
	//if (headl>0.2) discard;


	//if (int (0.3*fr+ThePos.y*3.0)!=int (element)) 		discard;
	gl_FragData[0].xyz=vec3 (1.0);
	//return;
	vec4 CCol;
	mainImage( CCol, UV *iResolution);



	gl_FragData[0].xyz=texture(Texture, UV.xy).xyz;
	
	
	//gl_FragData[0].xyz=1.5*Color.xyz*CCol.xyz;
	
	
	
	if (Type<0.5) 
	{
		gl_FragData[0].xyz+=0.8*vec3 (1,1,0.7);
	}
	
	float error=10000.0;
	int index=-1;
	for (int t=0;t<22;t++) { 
		float len = length (OriginalThePos-Skeleton[t]);
		if (len<error) 
		{
			index=t;
			error=len;
		}
	};


}
