#version 330

varying vec2 UV;
varying vec4 Color;
uniform sampler2D texture2d;
uniform sampler2D texture2d2;
uniform sampler2D texture2ddepth;
uniform float ttime;
uniform float Type;
uniform float k0;
uniform float k1;
uniform float k2;
float fred2 = 0.0;
vec3 FinalNormal;
uniform float cachettime;

float qttime = ttime * 0.4;
vec3 iResolution=vec3 (1920.0,1080.0,0.0);

float aspect = iResolution.x / iResolution.y;
float RePosX = 0;
float RePosY = 0;

vec3 rgb2hsv(vec3 c)
{
	vec4 K = vec4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);
	vec4 p = mix(vec4(c.bg, K.wz), vec4(c.gb, K.xy), step(c.b, c.g));
	vec4 q = mix(vec4(p.xyw, c.r), vec4(c.r, p.yzx), step(p.x, c.r));

	float d = q.x - min(q.w, q.y);
	float e = 1.0e-10;
	return vec3(abs(q.z + (q.w - q.y) / (6.0 * d + e)), d / (q.x + e), q.x);
}


vec3 hsv2rgb(in vec3 c)
{
	vec3 rgb = clamp(abs(mod(c.x * 6.0 + vec3(0.0, 4.0, 2.0), 6.0) - 3.0) - 1.0, 0.0, 1.0);

	return c.z * mix(vec3(1.0), rgb, c.y);
}


vec2 Qhash(vec2 p) {
	p = vec2(dot(p, vec2(127.1, 311.7)), dot(p, vec2(269.5, 183.3)));
	return -1.0 + 2.0 * fract(sin(p) * 43758.5453123);
}

float Qnoise(in vec2 p) {
	const float K1 = 0.366025404; // (sqrt(3)-1)/2;
	const float K2 = 0.211324865; // (3-sqrt(3))/6;
	vec2 i = floor(p + (p.x + p.y) * K1);
	vec2 a = p - i + (i.x + i.y) * K2;
	vec2 o = (a.x > a.y) ? vec2(1.0, 0.0) : vec2(0.0, 1.0); //vec2 of = 0.5 + 0.5*vec2(sign(a.x-a.y), sign(a.y-a.x));
	vec2 b = a - o + K2;
	vec2 c = a - 1.0 + 2.0 * K2;
	vec3 h = max(0.5 - vec3(dot(a, a), dot(b, b), dot(c, c)), 0.0);
	vec3 n = h * h * h * h * vec3(dot(a, Qhash(i + 0.0)), dot(b, Qhash(i + o)), dot(c, Qhash(i + 1.0)));
	return dot(n, vec3(70.0));
}


float hash(float n)
{
	return fract(sin(n) * 43758.5453);
}

float rand(float n) { return fract(sin(n) * 43758.5453123); }


#define GOLDEN_ANGLE 2.39996

#define ITERATIONS 192
#define BOKEH_SIZE 1.6


mat2 rot = mat2(cos(GOLDEN_ANGLE), sin(GOLDEN_ANGLE), -sin(GOLDEN_ANGLE), cos(GOLDEN_ANGLE));

//-------------------------------------------------------------------------------------------
#define W0 0.5545497
#define W1 0.308517

float noise(in vec3 x)
{
	vec3 p = floor(x);
	vec3 f = fract(x);

	f = f * f * (3.0 - 2.0 * f);

	float n = p.x + p.y * 57.0 + 113.0 * p.z;

	float res = mix(mix(mix(hash(n + 0.0), hash(n + 1.0), f.x),
		mix(hash(n + 57.0), hash(n + 58.0), f.x), f.y),
		mix(mix(hash(n + 113.0), hash(n + 114.0), f.x),
			mix(hash(n + 170.0), hash(n + 171.0), f.x), f.y), f.z);
	return res;
}

float speed = 8.0;
float blockSize = 8.0;
float maxRGBSplitX = 1.0;
float maxRGBSplitY = 1.0;

float randomNoise(vec2 seed) {
	return fract(sin(dot(seed * floor(ttime * speed), vec2(17.13, 3.71))) * 43758.5453);
}

float randomNoise2(float seed) {
	return randomNoise(vec2(seed, 1.0));
}



float splitSize = 10.1;

vec4 Split(vec2 _UV)
{
	// Normalized pixel coordinates (from 0 to 1)
	vec2 uv = _UV;
	float dispPower = 1.0 - clamp((ttime - 4.0) * 0.2, 0.0, 1.0);
	dispPower = clamp((ttime - 18.0) * 0.2, 0.0, 1.0);
	dispPower = splitSize;
	float block = randomNoise(floor(uv * vec2(blockSize * 1.0, 0.7 * blockSize)));

	float displaceNoise = pow(block, 8.0) * pow(block, 13.0);
	float splitRGBNoise = pow(randomNoise2(7.2341), 17.0);
	float offsetX = displaceNoise - splitRGBNoise * maxRGBSplitX;
	float offsetY = displaceNoise - splitRGBNoise * maxRGBSplitY;

	float noiseX = 0.05 * randomNoise2(13.0);
	float noiseY = 0.05 * randomNoise2(7.0);
	vec2 offset = vec2(offsetX * noiseX, offsetY * noiseY);
	//	offset*=0.0;
	uv.x += displaceNoise * 0.02 * dispPower;
	offset *= dispPower;
	vec4 colorR = texture(texture2d, uv);
	vec4 colorG = texture(texture2d, uv + offset);
	vec4 colorB = texture(texture2d, uv - offset);
	colorR *= vec4(1.0, 0.5, 0.5, 1);
	colorG *= vec4(0, 0.5, 0, 1);
	colorB *= vec4(0., 0, 0.5, 1);

	//if( displaceNoise>0.501+1.0-dispPower) 	colorB*=3.0;


	return colorR + colorG + colorB;

}







float randomNoise(float seed) {
	return randomNoise(vec2(seed, 1.0));
}


float fbm(vec3 p)
{
	//return 1.0;
	float f;
	f = 0.5000 * noise(p); p = p * 2.02;
	f += 0.2500 * noise(p); p = p * 2.03;
	f += 0.1250 * noise(p);
	return f;
}

float hash2(in vec2 c)
{
	float x = c.x * fract(c.x * W0);
	float y = c.y * fract(c.y * W1);

	// NOTICE: as is - if a sampling an integer lattice
	// any zero input will cause a black line in that
	// direction. 
	return fract(x * y);
}
vec3 Bokeh(sampler2D tex, vec2 uv, float radius, vec2 fragCoord)
{
	vec3 acc = vec3(0), div = acc;
	float r = 1.;
	float _ITERATIONS = ITERATIONS;

	vec2 vangle = vec2(0.0, radius * .01 / sqrt(float(_ITERATIONS)));

	// rotate the initial vangle with time
	float t = hash2(fragCoord) / 8. + ttime * 100.0;
	mat2 rot2 = mat2(cos(t), sin(t), -sin(t), cos(t));
	vangle = rot2 * vangle;

	for (int j = 0; j < ITERATIONS; j++)
	{
		// the approx increase in the scale of sqrt(0, 1, 2, 3...)
		r += 1. / r;
		vangle = rot * vangle;
		//if (uv.y<0.015)		vangle*=0.5;










		vec2 UV2 = uv + (r - 1.) * vangle * vec2(1.0, aspect);


		//		vec3 col = texture(tex, clamp (uv + (r-1.) * vangle*vec2 (1.0,aspect),vec2 (0.0), vec2 (1.0))).xyz; /// ... Sample the image
		vec3 col = texture(tex, clamp(UV2, vec2(0.001), vec2(0.999))).xyz; /// ... Sample the image
		vec2 Sep = vec2(0.0005, 0.0);

		//col *= vec3(1, 0.5, 0);
		//col += vec3(0, 0.5, 1) * texture(tex, clamp(UV2 + Sep, vec2(0.0), vec2(1.0))).xyz; /// ... Sample the image
		/*
		if (UV2.x < 0.0) col *= 0.0;
		if (UV2.y < 0.0) col *= 0.0;
		if (UV2.x > 1.0) col *= 0.0;
		if (UV2.y > 0.99) col *= 0.0;

		*/

		//l = col * col *1.8; // ... Contrast it for better highlights - leave this out elsewhere.
		vec3 bokeh;
		bokeh = pow(col, vec3(2));
		acc += col * bokeh;
		div += bokeh;
	}
	return acc / div;
}



float Chrom = 0.4;
vec4 Chromatic2(vec2 UV)
{
	//vec2 iResolution = vec2(1920, 1080);
	vec2 fragCoord = UV * iResolution.xy;

	vec3 refractiveIndex = vec3(1.0, 1.0 + 0.01 * Chrom, 1.0 + Chrom * 0.02);
	vec2 uv = fragCoord.xy / iResolution.xy;
	vec2 normalizedTexCoord = vec2(2.0, 2.0) * uv - vec2(1.0, 1.0);    // [0, 1] -> [-1, 1]
	vec3 texVec = vec3(normalizedTexCoord, 1.0);
	vec3 normalVec = vec3(0.0, 0.0, -1.0);
	vec3 redRefractionVec = refract(texVec, normalVec, refractiveIndex.r);
	vec3 greenRefractionVec = refract(texVec, normalVec, refractiveIndex.g);
	vec3 blueRefractionVec = refract(texVec, normalVec, refractiveIndex.b);
	vec2 redTexCoord = ((redRefractionVec / redRefractionVec.z).xy + vec2(1.0, 1.0)) / vec2(2.0, 2.0);
	vec2 greenTexCoord = ((greenRefractionVec / greenRefractionVec.z).xy + vec2(1.0, 1.0)) / vec2(2.0, 2.0);
	vec2 blueTexCoord = ((blueRefractionVec / blueRefractionVec.z).xy + vec2(1.0, 1.0)) / vec2(2.0, 2.0);

	return vec4
	(
		texture(texture2d, redTexCoord).r,
		texture(texture2d, greenTexCoord).g,
		texture(texture2d, blueTexCoord).b,
		1.0
		);
}


vec3 Bokeh2(sampler2D tex, vec2 uv, float radius, vec2 fragCoord)
{
	vec3 acc = vec3(0), div = acc;
	float r = 1.;
	float _ITERATIONS = ITERATIONS;

	vec2 vangle = vec2(0.0, radius * .01 / sqrt(float(_ITERATIONS)));

	// rotate the initial vangle with time
	float t = hash2(fragCoord) / 8. + ttime * 100.0;
	mat2 rot2 = mat2(cos(t), sin(t), -sin(t), cos(t));
	vangle = rot2 * vangle;

	for (int j = 0; j < ITERATIONS; j++)
	{
		// the approx increase in the scale of sqrt(0, 1, 2, 3...)
		r += 1. / r;
		vangle = rot * vangle;
		//if (uv.y<0.015)		vangle*=0.5;










		vec2 UV2 = uv + (r - 1.) * vangle * vec2(1.0, aspect);


		//		vec3 col = texture(tex, clamp (uv + (r-1.) * vangle*vec2 (1.0,aspect),vec2 (0.0), vec2 (1.0))).xyz; /// ... Sample the image
		vec3 col = texture(tex, clamp(UV2, vec2(0.001), vec2(0.999))).xyz; /// ... Sample the image
		
		col= Chromatic2 (UV2).xyz;
		vec2 Sep = vec2(0.0005, 0.0);

		//col *= vec3(1, 0.5, 0);
		//col += vec3(0, 0.5, 1) * texture(tex, clamp(UV2 + Sep, vec2(0.0), vec2(1.0))).xyz; /// ... Sample the image
		/*
		if (UV2.x < 0.0) col *= 0.0;
		if (UV2.y < 0.0) col *= 0.0;
		if (UV2.x > 1.0) col *= 0.0;
		if (UV2.y > 0.99) col *= 0.0;

		*/

		//l = col * col *1.8; // ... Contrast it for better highlights - leave this out elsewhere.
		vec3 bokeh;
		bokeh = pow(col, vec3(1));
		acc += col; // * bokeh;
		div += vec3(1.0); //bokeh;
	}
	return acc / div;
}




vec3 SmoothLine(vec2 UV0) {



	vec3 Output = vec3(0.0);
	float tot = 0.0;
	float dstt = 1.0;
	for (int x = -70; x < 71; x++)
	{
		vec2 NUV = UV0 + vec2(float(x), float(0)) * vec2(iResolution.y / iResolution.x, 1.0) * 0.00174 * 1.5 * dstt;
		float dst;
		dst = 1.1 - 0.3 * abs(x) / 70.0;
		dst = clamp(dst, 0.0, 1.0);
		Output += pow(dst * 1.0 * texture2D(texture2d, NUV).xxx + vec3(0.0), vec3(20.5));
		tot += dst;
	}

	Output /= tot;
	//	Output*=0.5+0.5*sin(UV.y*5.0);
	float cc = fbm(vec3(UV.xy * 4, 2.0 * ttime));

	cc = pow(cc, 5.0);
	//cc=1.0;

	if (fbm(vec3(0.5, UV.y * 6.0, 5.0 * ttime)) < 0.53)		cc *= 0.0;

	//if (sin (150.0*UV.y)<0.8) cc*=0.0;
	Output *= cc;
	// (cc<0.4) Output*=0.0;
	//Output*=pow (fbm (vec3 (UV.xy*5,2.0*ttime)),8.0);
	return 1000.0 * Output;//*0.2;

}


vec3 Smooth2(vec2 UV0) {
	//depth-1-depth;
	vec3 Output = vec3(0.0);
	float tot = 0.0;
	float dstt = 1.0;

	for (int y = -7; y < 8; y++)
		for (int x = -7; x < 8; x++)
		{
			vec2 NUV = UV0 + vec2(float(x), float(y)) * vec2(iResolution.y / iResolution.x, 1.0) * 0.00174 * 1.0 * dstt;
			NUV = clamp(NUV, vec2(0.01), vec2(0.99));
			float dst = 1.0 / (1.0 + 40.0 * length(vec2(x, y)));
			dst = 1.0 - 0.10 * length(vec2(x, y));
			dst = clamp(dst, 0.0, 1.0);
			Output += pow(1.0 * texture2D(texture2d, NUV).xyz, vec3(1.5)) * dst;
			//*texture2D (Texture1, NUV).w;
			//Output+=NUV.xyx;
			tot += dst;

		}

	Output /= tot;
	return 1.0 * Output;//*0.2;


}

vec3 Smooth3(vec2 UV0) {

	//depth-1-depth;
	vec3 Output = vec3(0.0);
	float tot = 0.0;
	float dstt = 1.0;

	for (int y = -5; y < 6; y++)
		for (int x = -5; x < 6; x++)
		{
			vec2 NUV = UV0 + vec2(float(x), float(y)) * vec2(iResolution.y / iResolution.x, 1.0) * 0.00174 * 1.25 * dstt;
			NUV = clamp(NUV, vec2(0.01), vec2(0.99));
			float dst = 1.0 / (1.0 + 40.0 * length(vec2(x, y)));
			dst = 1.0 - 0.10 * length(vec2(x, y));
			dst = clamp(dst, 0.0, 1.0);
			Output += pow(1.0 * texture2D(texture2d, NUV).xyz, vec3(1.5)) * dst;
			//*texture2D (Texture1, NUV).w;
			//Output+=NUV.xyx;
			tot += dst;

		}

	Output /= tot;
	return 1.0 * Output;//*0.2;


}


vec3 SmoothRadial(vec2 UV0) {

	//depth-1-depth;
	vec3 Output = vec3(0.0);
	float tot = 0.0;
	float dstt = 1.0;
	vec2 DirV = UV0 - vec2(0.5);
	vec3 DV = vec3(DirV, 0);
	vec3 UpV = vec3(0, 0, 1);
	vec3 RightV = cross(DV, UpV);
	//for (int y = -5; y < 6; y++)
	for (int x = 0; x < 22; x++)
		for (int r = -4; r < 4; r++)
		{
			float dst = 1.0;
			vec2 NUV = UV0 - DirV * 0.05 * float(x) / 12.0;
			NUV += RightV.xy * float(r) * 0.003;
			vec3 col = texture2D(texture2d, NUV).xyz;
			dst = float(22 - x) / 22.0; //length (col);
			dst *= 1.0 + 3.0 * length(col);
			Output += dst * pow(col, vec3(1.0));
			//*texture2D (Texture1, NUV).w;
			//Output+=NUV.xyx;
			tot += dst;

		}

	Output /= tot;
	return Output * 0.3;


}


vec2 Barrel(vec2 UV)
{
	//vec2 iResolution = vec2(1920, 1080);
	vec2 fragCoord = UV * iResolution.xy;

	vec2 source_uv = fragCoord.xy / iResolution.xy;
	//assume your distortion center coordinate is (0.5,0.5),you can use your distortion center instead.
	vec2 distortion_center = vec2(0.5, 0.5);
	//Define algorithm dependent variables 
	float distortion_x, distortion_y, rr, r2, theta;
	//define distortion coefficient K1 and K2 ,In most cases we can only adjust K1. then K2 parameters can be adjusted more perfect Effect
	//iTime is used for Real-time change.
	//K1 < 0 is pincushion distortion
	//K1 >=0 is barrel distortion
	float distortion_k1 = -ttime * 0.1;
	float distortion_k2 = 0.5;
	vec2 dest_uv;
	rr = sqrt((source_uv.x - distortion_center.x) * (source_uv.x - distortion_center.x) + (source_uv.y - distortion_center.y) * (source_uv.y - distortion_center.y));
	r2 = rr * (1.0 + distortion_k1 * (rr * rr) + distortion_k2 * (rr * rr * rr * rr));
	theta = atan(source_uv.x - distortion_center.x, source_uv.y - distortion_center.y);
	distortion_x = sin(theta) * r2 * 1.0;//1.0 is  scale factor
	distortion_y = cos(theta) * r2 * 1.0;//1.0 is  scale factor
	dest_uv.x = distortion_x + 0.5;
	dest_uv.y = distortion_y + 0.5;
	return dest_uv;
}
vec4 Grain(vec2 uv) {

	float strength = 16.0;
	float x = (uv.x + 4.0) * (uv.y + 4.0) * (ttime * 10.0);
	vec4 grain = vec4(mod((mod(x, 13.0) + 1.0) * (mod(x, 123.0) + 1.0), 0.01) - 0.005) * strength;
	return 0.2 * grain;

}




vec4 rgb_to_cmyk(vec3 col) {
    float a = max(col.r, max(col.g, col.b));
    return vec4((a - col.rgb) / a, 1.0 - a);
}

vec3 cmyk_to_rgb(vec4 col) {
    float ik = 1.0 - col.w;
    return (1.0 - col.rgb) * ik;
}

float ht(vec2 uv) {
    uv = fract(uv);
    return pow(length(uv - 0.5) / sqrt(0.5), 1.7);
}

vec2 rotate (vec2 p, float a) {
    float c = cos(a);
    float s = sin(a);
    return vec2(c*p.x + s*p.y, c*p.y - s*p.x);
}

vec4 cmyk_ht(vec2 uv) {
    return vec4(
        ht(rotate(uv, radians(15.0))),
        ht(rotate(uv, radians(75.0))),
        ht(rotate(uv, radians(0.0))),
        ht(rotate(uv, radians(45.0))));
}

vec3 scene(vec2 fragCoord) {
    vec2 uv = fragCoord/iResolution.xy * 2.0 - 1.0;
    uv.x *= iResolution.x/iResolution.y;
    
    float s = iResolution.y / 6.0;
    vec2 suv = uv * s;
    vec4 htp = cmyk_ht(suv);

    vec4 col = texture(texture2d, uv * vec2(0.282, 0.5) + 0.5) + 1.0/255.0;
    vec4 cmyk = rgb_to_cmyk(col.rgb);
    
    cmyk = step(htp, cmyk);

    return clamp(cmyk_to_rgb(cmyk), vec3(0.0), vec3(1.0));
}

void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    // supersample
    const int N = 3;
    float w = 0.0;
    vec3 c = vec3(0.0);
    for (int x = -N; x <= N; ++x) {
        for (int y = -N; y <= N; ++y) {
            c += scene(fragCoord + vec2(x,y)/(1.5*float(N)));
            w += 1.0;
        }
    }
    fragColor = vec4(c / w, 1.0);
}


void main(void)
{
	vec2 _UV=UV;
	

	//gl_FragData[0].xyz= Smooth3(_UV.xy).xyz;
	gl_FragData[0].xyz= texture(texture2d, _UV.xy).xyz;
	gl_FragData[0].xyz= Chromatic2(_UV.xy).xyz;
	gl_FragData[0].w=1.0;

	float ft = length (UV.x-0.5+UV.y-0.5);
	ft*=ft;
	ft*=ft;

	if (ttime < 145.0)
		if (ttime >= 141.0) {
			ft += 1.0 * pow ((1.0-UV.y),2.0)*clamp((ttime - 141.0) * 0.3, 0.0, 1.0);
		
			//cl.xyz = hsv2rgb(vec3(0.0*length(oUV.xy - vec2(0.5))+cl.z * 0.6-k0-0.333+cl.w*0.0,0.7,		cl.x));

		};

	gl_FragData[0].xyz=Bokeh2(texture2d, UV, 0.20*ft, UV*vec2 (1920,1080)).xyz;

	//gl_FragData[0].xyz = texture(texture2d, _UV.xy).xyz;

//	gl_FragData[0].xyz *= 0.5;

	//gl_FragData[0].xyz=vec3 (1.0)*ft;
	//mainImage( gl_FragData[0], _UV.xy*vec2 (1920.0,1080.0));
	//gl_FragData[0].xyz=gl_FragData[0].xxx;

}

