layout(std140, binding = 0) uniform ConstantBuffer
{
    vec4 text_dimensions;
    ivec4 text_data;
    vec4 x_move_speed;
    ivec4 glyph_data_stride;
    ivec4 atlas_dimensions;
    vec4 time;
};

uniform sampler2D image;

out vec4 fragColor;

flat in int frag_glyph;
in vec2 frag_uv;
in vec2 frag_pos;

void main() {
  vec2 norm_glyph_dimensions = vec2(glyph_data_stride.xy) / vec2(atlas_dimensions.xy);
  vec2 norm_glyph_stride = vec2(glyph_data_stride.zw) / vec2(atlas_dimensions.xy);
  int glyph = frag_glyph  ;
  int glyph_row = glyph / atlas_dimensions.w;
  int glyph_column = glyph % atlas_dimensions.w;
  vec2 glyph_pos = vec2(
    norm_glyph_stride.x * float(glyph_column),
    // count from the bottom, and adjust for inconsistent matrix
    atlas_dimensions.y - norm_glyph_stride.y * (float(glyph_row) + 1.0) + (norm_glyph_stride.y - norm_glyph_dimensions.y)
  );

  vec2 tex_uv = mix(glyph_pos, glyph_pos + norm_glyph_dimensions, frag_uv);
  
  vec4 tex_col = texture(image, tex_uv);
  if (tex_col.a < 0.1) {
    discard;
  }

  fragColor = tex_col;

  switch (text_data.z) {
  case 1:
    if (tex_col.r > 0.0) {
      fragColor.rgb = frag_uv.xxx;
    }
    break;
  case 2:
    if (tex_col.r > 0.0) {
      fragColor.r = sin(frag_pos.x * 13.0 + time.x * 7.0) + 1.0;
      fragColor.g = cos(frag_pos.y * 7.0 + time.x * 3.0) + 1.0;
      fragColor.b = sin(frag_pos.x * 5.0 + time.x * 13.0) + 1.0;

      fragColor.rgb /= 2.0;
    }
    break;
  }

  fragColor.a = 1.0;
  if(time.y < 0.1)
  {
    float t = time.y * 10.0;
    fragColor.a = mix(0.0, 1.0, t);
    
  }

  if(time.y > 0.9)
  {
    float t = (time.y - 0.9) * 10.0;
    fragColor.a = mix(1.0, 0.0, t);
  }
}
