layout(location = 0)in int pos;
layout(location = 1)in int glyph;

layout(std140, binding = 0) uniform ConstantBuffer
{
    vec4 text_dimensions;
    ivec4 text_data;
    vec4 x_move_speed;
    ivec4 glyph_data_stride;
    ivec4 atlas_dimensions;
    vec4 time;
};

flat out int frag_glyph;
out vec2 frag_uv;
out vec2 frag_pos;

void main() {
  vec2 start_pos = text_dimensions.xy;
  vec2 text_screen_dimensions = text_dimensions.zw;

  float char_h_stride_norm = text_screen_dimensions.x / float(text_data.x);
  int chrn = pos / 6;

  vec2 top_left_corner = start_pos + vec2(
    0. + char_h_stride_norm * chrn,
    0.
  );

  vec2 positions[6] = {
    {0.0, 0.0}, {0.0, text_screen_dimensions.y}, 
    {char_h_stride_norm, 0.0}, {0.0, text_screen_dimensions.y}, 
    {char_h_stride_norm,text_screen_dimensions.y}, {char_h_stride_norm, 0.0}
  };

  vec2 uvs[6] = {
    {0.0, 0.0}, {0.0, 1.0}, 
    {1.0, 0.0}, {0.0, 1.0},
    {1.0, 1.0}, {1.0, 0.0}
  };

  frag_uv = uvs[pos % 6];
  gl_Position = vec4(top_left_corner + positions[pos % 6], .0, 1.);

  switch (text_data.y) {
  case 0:
    // none
    break;
  case 1:
    // wave
    gl_Position.y += sin(chrn / 3. + time.x * 2.) * text_screen_dimensions.y;
    break;
  }

  gl_Position.x += time.x * x_move_speed.x;

  frag_glyph = glyph;
  frag_pos = gl_Position.xy;
}
