layout(location = 0)in vec3 vertex_position;
layout(location = 1)in vec3 vertex_normal;
layout(location = 2)in vec2 vertex_uv;

out vec3 normal;
out vec2 uv;
out vec3 frag_position;
out float mat;

uniform mat4 wvp;

uniform vec3 eye;
uniform float fTime;

uniform int instanceX;
uniform int instanceZ;

mat2 rot(float a){
  float c=cos(a),s=sin(a);
  return mat2(c,s,-s,c);
}

void main() {
  normal = vertex_normal;
  uv = vertex_uv.xy;
  vec4 pos = vec4(vertex_position, 1.0);

  float dir = 0;
  if (uv.x > 1) dir = -1;
  if (uv.x < 0) dir = 1;
  float amt = max(0,-eye.x+instanceX*2.0*4.0-60);
  pos.y += amt*dir;    
  pos.x += instanceX * 2.0*4.0-60;
  mat2 rm = rot(instanceX);
  pos.yz *= rm;
  normal.yz *= rm;
  frag_position = pos.xyz;
  gl_Position = vec4(pos * wvp);
}
