var OrbitCamera=pc.createScript("orbitCamera");OrbitCamera.attributes.add("distanceMax",{type:"number",default:0,title:"Distance Max",description:"Setting this at 0 will give an infinite distance limit"}),OrbitCamera.attributes.add("distanceMin",{type:"number",default:0,title:"Distance Min"}),OrbitCamera.attributes.add("pitchAngleMax",{type:"number",default:90,title:"Pitch Angle Max (degrees)"}),OrbitCamera.attributes.add("pitchAngleMin",{type:"number",default:-90,title:"Pitch Angle Min (degrees)"}),OrbitCamera.attributes.add("inertiaFactor",{type:"number",default:0,title:"Inertia Factor",description:"Higher value means that the camera will continue moving after the user has stopped dragging. 0 is fully responsive."}),OrbitCamera.attributes.add("focusEntity",{type:"entity",title:"Focus Entity",description:"Entity for the camera to focus on. If blank, then the camera will use the whole scene"}),OrbitCamera.attributes.add("frameOnStart",{type:"boolean",default:!0,title:"Frame on Start",description:'Frames the entity or scene at the start of the application."'}),Object.defineProperty(OrbitCamera.prototype,"distance",{get:function(){return this._targetDistance},set:function(t){this._targetDistance=this._clampDistance(t)}}),Object.defineProperty(OrbitCamera.prototype,"pitch",{get:function(){return this._targetPitch},set:function(t){this._targetPitch=this._clampPitchAngle(t)}}),Object.defineProperty(OrbitCamera.prototype,"yaw",{get:function(){return this._targetYaw},set:function(t){this._targetYaw=t;var i=(this._targetYaw-this._yaw)%360;this._targetYaw=i>180?this._yaw-(360-i):i<-180?this._yaw+(360+i):this._yaw+i}}),Object.defineProperty(OrbitCamera.prototype,"pivotPoint",{get:function(){return this._pivotPoint},set:function(t){this._pivotPoint.copy(t)}}),OrbitCamera.prototype.focus=function(t){this._buildAabb(t);var i=this._modelsAabb.halfExtents,e=Math.max(i.x,Math.max(i.y,i.z));this.distance=1.5*e/Math.sin(.5*this.entity.camera.fov*pc.math.DEG_TO_RAD),this._removeInertia(),this._pivotPoint.copy(this._modelsAabb.center)},OrbitCamera.distanceBetween=new pc.Vec3,OrbitCamera.prototype.resetAndLookAtPoint=function(t,i){this.pivotPoint.copy(i),this.entity.setPosition(t),this.entity.lookAt(i);var e=OrbitCamera.distanceBetween;e.sub2(i,t),this.distance=e.length(),this.pivotPoint.copy(i);var a=this.entity.getRotation();this.yaw=this._calcYaw(a),this.pitch=this._calcPitch(a,this.yaw),this._removeInertia(),this._updatePosition()},OrbitCamera.prototype.resetAndLookAtEntity=function(t,i){this._buildAabb(i),this.resetAndLookAtPoint(t,this._modelsAabb.center)},OrbitCamera.prototype.reset=function(t,i,e){this.pitch=i,this.yaw=t,this.distance=e,this._removeInertia()},OrbitCamera.prototype.initialize=function(){var t=this,onWindowResize=function(){t._checkAspectRatio()};window.addEventListener("resize",onWindowResize,!1),this._checkAspectRatio(),this._modelsAabb=new pc.BoundingBox,this._buildAabb(this.focusEntity||this.app.root),this.entity.lookAt(this._modelsAabb.center),this._pivotPoint=new pc.Vec3,this._pivotPoint.copy(this._modelsAabb.center);var i=this.entity.getRotation();if(this._yaw=this._calcYaw(i),this._pitch=this._clampPitchAngle(this._calcPitch(i,this._yaw)),this.entity.setLocalEulerAngles(this._pitch,this._yaw,0),this._distance=0,this._targetYaw=this._yaw,this._targetPitch=this._pitch,this.frameOnStart)this.focus(this.focusEntity||this.app.root);else{var e=new pc.Vec3;e.sub2(this.entity.getPosition(),this._pivotPoint),this._distance=this._clampDistance(e.length())}this._targetDistance=this._distance,this.on("attr:distanceMin",(function(t,i){this._distance=this._clampDistance(this._distance)})),this.on("attr:distanceMax",(function(t,i){this._distance=this._clampDistance(this._distance)})),this.on("attr:pitchAngleMin",(function(t,i){this._pitch=this._clampPitchAngle(this._pitch)})),this.on("attr:pitchAngleMax",(function(t,i){this._pitch=this._clampPitchAngle(this._pitch)})),this.on("attr:focusEntity",(function(t,i){this.frameOnStart?this.focus(t||this.app.root):this.resetAndLookAtEntity(this.entity.getPosition(),t||this.app.root)})),this.on("attr:frameOnStart",(function(t,i){t&&this.focus(this.focusEntity||this.app.root)})),this.on("destroy",(function(){window.removeEventListener("resize",onWindowResize,!1)}))},OrbitCamera.prototype.update=function(t){var i=0===this.inertiaFactor?1:Math.min(t/this.inertiaFactor,1);this._distance=pc.math.lerp(this._distance,this._targetDistance,i),this._yaw=pc.math.lerp(this._yaw,this._targetYaw,i),this._pitch=pc.math.lerp(this._pitch,this._targetPitch,i),this._updatePosition()},OrbitCamera.prototype._updatePosition=function(){this.entity.setLocalPosition(0,0,0),this.entity.setLocalEulerAngles(this._pitch,this._yaw,0);var t=this.entity.getPosition();t.copy(this.entity.forward),t.mulScalar(-this._distance),t.add(this.pivotPoint),this.entity.setPosition(t)},OrbitCamera.prototype._removeInertia=function(){this._yaw=this._targetYaw,this._pitch=this._targetPitch,this._distance=this._targetDistance},OrbitCamera.prototype._checkAspectRatio=function(){var t=this.app.graphicsDevice.height,i=this.app.graphicsDevice.width;this.entity.camera.horizontalFov=t>i},OrbitCamera.prototype._buildAabb=function(t){var i,e,a=[],n=t.findComponents("render");for(i=0;i<n.length;i++){var o=n[i];for(e=0;e<o.meshInstances.length;e++)a.push(o.meshInstances[e])}var s=t.findComponents("model");for(i=0;i<s.length;i++){var r=s[i];for(e=0;e<r.meshInstances.length;e++)a.push(r.meshInstances[e])}for(i=0;i<a.length;i++)0===i?this._modelsAabb.copy(a[i].aabb):this._modelsAabb.add(a[i].aabb)},OrbitCamera.prototype._calcYaw=function(t){var i=new pc.Vec3;return t.transformVector(pc.Vec3.FORWARD,i),Math.atan2(-i.x,-i.z)*pc.math.RAD_TO_DEG},OrbitCamera.prototype._clampDistance=function(t){return this.distanceMax>0?pc.math.clamp(t,this.distanceMin,this.distanceMax):Math.max(t,this.distanceMin)},OrbitCamera.prototype._clampPitchAngle=function(t){return pc.math.clamp(t,-this.pitchAngleMax,-this.pitchAngleMin)},OrbitCamera.quatWithoutYaw=new pc.Quat,OrbitCamera.yawOffset=new pc.Quat,OrbitCamera.prototype._calcPitch=function(t,i){var e=OrbitCamera.quatWithoutYaw,a=OrbitCamera.yawOffset;a.setFromEulerAngles(0,-i,0),e.mul2(a,t);var n=new pc.Vec3;return e.transformVector(pc.Vec3.FORWARD,n),Math.atan2(n.y,-n.z)*pc.math.RAD_TO_DEG};var OrbitCameraInputMouse=pc.createScript("orbitCameraInputMouse");OrbitCameraInputMouse.attributes.add("orbitSensitivity",{type:"number",default:.3,title:"Orbit Sensitivity",description:"How fast the camera moves around the orbit. Higher is faster"}),OrbitCameraInputMouse.attributes.add("distanceSensitivity",{type:"number",default:.15,title:"Distance Sensitivity",description:"How fast the camera moves in and out. Higher is faster"}),OrbitCameraInputMouse.prototype.initialize=function(){if(this.orbitCamera=this.entity.script.orbitCamera,this.orbitCamera){var t=this,onMouseOut=function(i){t.onMouseOut(i)};this.app.mouse.on(pc.EVENT_MOUSEDOWN,this.onMouseDown,this),this.app.mouse.on(pc.EVENT_MOUSEUP,this.onMouseUp,this),this.app.mouse.on(pc.EVENT_MOUSEMOVE,this.onMouseMove,this),this.app.mouse.on(pc.EVENT_MOUSEWHEEL,this.onMouseWheel,this),window.addEventListener("mouseout",onMouseOut,!1),this.on("destroy",(function(){this.app.mouse.off(pc.EVENT_MOUSEDOWN,this.onMouseDown,this),this.app.mouse.off(pc.EVENT_MOUSEUP,this.onMouseUp,this),this.app.mouse.off(pc.EVENT_MOUSEMOVE,this.onMouseMove,this),this.app.mouse.off(pc.EVENT_MOUSEWHEEL,this.onMouseWheel,this),window.removeEventListener("mouseout",onMouseOut,!1)}))}this.app.mouse.disableContextMenu(),this.lookButtonDown=!1,this.panButtonDown=!1,this.lastPoint=new pc.Vec2},OrbitCameraInputMouse.fromWorldPoint=new pc.Vec3,OrbitCameraInputMouse.toWorldPoint=new pc.Vec3,OrbitCameraInputMouse.worldDiff=new pc.Vec3,OrbitCameraInputMouse.prototype.pan=function(t){var i=OrbitCameraInputMouse.fromWorldPoint,e=OrbitCameraInputMouse.toWorldPoint,a=OrbitCameraInputMouse.worldDiff,n=this.entity.camera,o=this.orbitCamera.distance;n.screenToWorld(t.x,t.y,o,i),n.screenToWorld(this.lastPoint.x,this.lastPoint.y,o,e),a.sub2(e,i),this.orbitCamera.pivotPoint.add(a)},OrbitCameraInputMouse.prototype.onMouseDown=function(t){switch(t.button){case pc.MOUSEBUTTON_LEFT:this.lookButtonDown=!0;break;case pc.MOUSEBUTTON_MIDDLE:case pc.MOUSEBUTTON_RIGHT:this.panButtonDown=!0}},OrbitCameraInputMouse.prototype.onMouseUp=function(t){switch(t.button){case pc.MOUSEBUTTON_LEFT:this.lookButtonDown=!1;break;case pc.MOUSEBUTTON_MIDDLE:case pc.MOUSEBUTTON_RIGHT:this.panButtonDown=!1}},OrbitCameraInputMouse.prototype.onMouseMove=function(t){this.lookButtonDown?(this.orbitCamera.pitch-=t.dy*this.orbitSensitivity,this.orbitCamera.yaw-=t.dx*this.orbitSensitivity):this.panButtonDown&&this.pan(t),this.lastPoint.set(t.x,t.y)},OrbitCameraInputMouse.prototype.onMouseWheel=function(t){this.orbitCamera.distance-=t.wheel*this.distanceSensitivity*(.1*this.orbitCamera.distance),t.event.preventDefault()},OrbitCameraInputMouse.prototype.onMouseOut=function(t){this.lookButtonDown=!1,this.panButtonDown=!1};var OrbitCameraInputTouch=pc.createScript("orbitCameraInputTouch");OrbitCameraInputTouch.attributes.add("orbitSensitivity",{type:"number",default:.4,title:"Orbit Sensitivity",description:"How fast the camera moves around the orbit. Higher is faster"}),OrbitCameraInputTouch.attributes.add("distanceSensitivity",{type:"number",default:.2,title:"Distance Sensitivity",description:"How fast the camera moves in and out. Higher is faster"}),OrbitCameraInputTouch.prototype.initialize=function(){this.orbitCamera=this.entity.script.orbitCamera,this.lastTouchPoint=new pc.Vec2,this.lastPinchMidPoint=new pc.Vec2,this.lastPinchDistance=0,this.orbitCamera&&this.app.touch&&(this.app.touch.on(pc.EVENT_TOUCHSTART,this.onTouchStartEndCancel,this),this.app.touch.on(pc.EVENT_TOUCHEND,this.onTouchStartEndCancel,this),this.app.touch.on(pc.EVENT_TOUCHCANCEL,this.onTouchStartEndCancel,this),this.app.touch.on(pc.EVENT_TOUCHMOVE,this.onTouchMove,this),this.on("destroy",(function(){this.app.touch.off(pc.EVENT_TOUCHSTART,this.onTouchStartEndCancel,this),this.app.touch.off(pc.EVENT_TOUCHEND,this.onTouchStartEndCancel,this),this.app.touch.off(pc.EVENT_TOUCHCANCEL,this.onTouchStartEndCancel,this),this.app.touch.off(pc.EVENT_TOUCHMOVE,this.onTouchMove,this)})))},OrbitCameraInputTouch.prototype.getPinchDistance=function(t,i){var e=t.x-i.x,a=t.y-i.y;return Math.sqrt(e*e+a*a)},OrbitCameraInputTouch.prototype.calcMidPoint=function(t,i,e){e.set(i.x-t.x,i.y-t.y),e.mulScalar(.5),e.x+=t.x,e.y+=t.y},OrbitCameraInputTouch.prototype.onTouchStartEndCancel=function(t){var i=t.touches;1===i.length?this.lastTouchPoint.set(i[0].x,i[0].y):2===i.length&&(this.lastPinchDistance=this.getPinchDistance(i[0],i[1]),this.calcMidPoint(i[0],i[1],this.lastPinchMidPoint))},OrbitCameraInputTouch.fromWorldPoint=new pc.Vec3,OrbitCameraInputTouch.toWorldPoint=new pc.Vec3,OrbitCameraInputTouch.worldDiff=new pc.Vec3,OrbitCameraInputTouch.prototype.pan=function(t){var i=OrbitCameraInputTouch.fromWorldPoint,e=OrbitCameraInputTouch.toWorldPoint,a=OrbitCameraInputTouch.worldDiff,n=this.entity.camera,o=this.orbitCamera.distance;n.screenToWorld(t.x,t.y,o,i),n.screenToWorld(this.lastPinchMidPoint.x,this.lastPinchMidPoint.y,o,e),a.sub2(e,i),this.orbitCamera.pivotPoint.add(a)},OrbitCameraInputTouch.pinchMidPoint=new pc.Vec2,OrbitCameraInputTouch.prototype.onTouchMove=function(t){var i=OrbitCameraInputTouch.pinchMidPoint,e=t.touches;if(1===e.length){var a=e[0];this.orbitCamera.pitch-=(a.y-this.lastTouchPoint.y)*this.orbitSensitivity,this.orbitCamera.yaw-=(a.x-this.lastTouchPoint.x)*this.orbitSensitivity,this.lastTouchPoint.set(a.x,a.y)}else if(2===e.length){var n=this.getPinchDistance(e[0],e[1]),o=n-this.lastPinchDistance;this.lastPinchDistance=n,this.orbitCamera.distance-=o*this.distanceSensitivity*.1*(.1*this.orbitCamera.distance),this.calcMidPoint(e[0],e[1],i),this.pan(i),this.lastPinchMidPoint.copy(i)}};var TreePlacementScript=pc.createScript("treePlacementScript");TreePlacementScript.attributes.add("treePrefab",{type:"entity"}),TreePlacementScript.attributes.add("densityMap",{type:"asset",assetType:"texture"}),TreePlacementScript.prototype.initialize=function(){this.treePrefab&&this.densityMap?this.app.assets.load(this.densityMap.id,"texture",function(e,t){if(e)console.error("Erreur lors du chargement de la carte de densité :",e);else{var r=t.resource.getSource().data,a=this.app.root.findByName("Terrain").model.meshInstances[0].mesh;this.placeTrees(a,r)}}.bind(this)):console.error("Veuillez définir le préfabriqué d'arbre et la carte de densité dans les propriétés du script.")},TreePlacementScript.prototype.placeTrees=function(e,t){for(var r=-e.aabb.halfExtents.x,a=-e.aabb.halfExtents.z,i=e.aabb.halfExtents.x,s=e.aabb.halfExtents.z,o=0,n=(i-r)/t.width,c=(s-a)/t.height,l=a;l<s;l+=c)for(var p=r;p<i;p+=n){var d=(p-r)/(i-r)*(t.width-1),h=(l-a)/(s-a)*(t.height-1),b=this.getPixelColor(t,d,h);(b.r+b.g+b.b)/3>.5&&(this.placeTreeAtPosition(this.treePrefab.clone(),p,0,l),o++)}console.log("Nombre d'arbres placés :",o)},TreePlacementScript.prototype.getPixelColor=function(e,t,r){var a=Math.floor(t),i=4*(Math.floor(r)*e.width+a);return{r:e.data[i]/255,g:e.data[i+1]/255,b:e.data[i+2]/255,a:e.data[i+3]/255}},TreePlacementScript.prototype.placeTreeAtPosition=function(e,t,r,a){e.setPosition(t,r,a),this.app.root.addChild(e)};/*!
 * 
 * Branch: main
 * Commit: 3a0dc6bd42111346b1ce5a41c940e32e0b430f5e
 * User: {}
 * Date: 2023-05-30T05:18:43.571Z
 *
 * MIT License
 *
 * Copyright (c) 2023 Kirill Osipov
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 *
 */
(()=>{"use strict";var e={166:function(e,t,n){var r=this&&this.__decorate||function(e,t,n,r){var i,o=arguments.length,s=o<3?t:null===r?r=Object.getOwnPropertyDescriptor(t,n):r;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)s=Reflect.decorate(e,t,n,r);else for(var a=e.length-1;a>=0;a--)(i=e[a])&&(s=(o<3?i(s):o>3?i(t,n,s):i(t,n))||s);return o>3&&s&&Object.defineProperty(t,n,s),s},i=this&&this.__awaiter||function(e,t,n,r){return new(n||(n=Promise))((function(i,o){function fulfilled(e){try{step(r.next(e))}catch(e){o(e)}}function rejected(e){try{step(r.throw(e))}catch(e){o(e)}}function step(e){e.done?i(e.value):function adopt(e){return e instanceof n?e:new n((function(t){t(e)}))}(e.value).then(fulfilled,rejected)}step((r=r.apply(e,t||[])).next())}))};Object.defineProperty(t,"__esModule",{value:!0}),t.PreventTextureRepetition=void 0;const o=n(78);let s=class PreventTextureRepetition extends pc.ScriptType{constructor(){super(...arguments),this.materials=[],this.noiseTеxture=null}initialize(){return i(this,void 0,void 0,(function*(){yield new Promise((e=>{var t;null===(t=this.noiseTеxture)||void 0===t||t.ready(e)}));for(const e of this.materials)this.preventTextureRepetition(e)}))}preventTextureRepetition(e){var t;return i(this,void 0,void 0,(function*(){yield new Promise((t=>{e.ready(t)}));const n=e.resources;for(const e of n){if(!(e instanceof pc.StandardMaterial))continue;const n=pc.shaderChunks.litShaderArgsPS+"\nuniform sampler2D uNoiseTexture;\n\nfloat sum( vec4 v ) { return v.x+v.y+v.z; }\n\nvec4 textureNoTile(sampler2D tex, in vec2 x )\n{\n  float v = 1.;\n  float k = texture( uNoiseTexture, 0.005*x ).x; // cheap (cache friendly) lookup\n  \n  vec2 duvdx = dFdx( x );\n  vec2 duvdy = dFdy( x );\n  \n  float l = k*8.0;\n  float f = fract(l);\n  \n#if 1\n  float ia = floor(l); // my method\n  float ib = ia + 1.0;\n#else\n  float ia = floor(l+0.5); // suslik's method (see comments)\n  float ib = floor(l);\n  f = min(f, 1.0-f)*2.0;\n#endif    \n  \n  vec2 offa = sin(vec2(3.0,7.0)*ia); // can replace with any other hash\n  vec2 offb = sin(vec2(3.0,7.0)*ib); // can replace with any other hash\n\n  vec4 cola = textureGrad( tex, x + v*offa, duvdx, duvdy );\n  vec4 colb = textureGrad( tex, x + v*offb, duvdx, duvdy );\n  return mix( cola, colb, smoothstep(0.2,0.8,f-0.1*sum(cola-colb)) );\n}\n";e.chunks.litShaderArgsPS=n;const r=["aoPS","clearCoatPS","clearCoatGlossPS","clearCoatNormalPS","diffusePS","diffuseDetailMapPS","emissivePS","glossPS","iridescencePS","iridescenceThicknessPS","lightmapSinglePS","metalnessPS","normalDetailMapPS","normalMapPS","opacityPS","parallaxPS","sheenPS","sheenGlossPS","specularPS","specularityFactorPS","thicknessPS","transmissionPS"];for(const t of r){const n=pc.shaderChunks[t];if(!n)continue;const r=n.replace("texture2DBias($SAMPLER, $UV, textureBias)","textureNoTile($SAMPLER, $UV)");e.chunks[t]=r}e.chunks.APIVersion="1.63.6",e.setParameter("uNoiseTexture",null===(t=this.noiseTеxture)||void 0===t?void 0:t.resource),e.update()}}))}};s=r([(0,o.createScript)({materials:{type:"asset",assetType:"material",description:"Material to prevent texture repeatition.",array:!0},"noiseTеxture":{type:"asset",assetType:"texture",description:"Noise texture."}})],s),t.PreventTextureRepetition=s},78:(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.createScript=void 0,t.createScript=function(e){return function(t){const n=t.name.charAt(0).toLowerCase()+t.name.slice(1);pc.registerScript(t,n);for(const n in e)t.attributes.add(n,e[n])}}}},t={};!function __webpack_require__(n){var r=t[n];if(void 0!==r)return r.exports;var i=t[n]={exports:{}};return e[n].call(i.exports,i,i.exports,__webpack_require__),i.exports}(166)})();pc.extend(pc,function(){var PixelatePostEffect=function(e,i,t){this.shader=new pc.Shader(e,{attributes:{aPosition:pc.SEMANTIC_POSITION},vshader:["attribute vec2 aPosition;","","varying vec2 vUv0;","","void main(void)","{","    gl_Position = vec4(aPosition, 0.0, 1.0);","    vUv0 = (aPosition.xy + 1.0) * 0.5;","}"].join("\n"),fshader:["precision "+e.precision+" float;","","uniform vec2 uResolution;","uniform float uPixelize;","uniform sampler2D uColorBuffer;","","varying vec2 vUv0;","","void main() {","    vec2 uv = gl_FragCoord.xy / uResolution.xy;","    vec2 div = vec2(uResolution.x * uPixelize / uResolution.y, uPixelize);","    uv = floor(uv * div)/div;","    vec4 color = texture2D(uColorBuffer, uv);","    gl_FragColor = color;","}"].join("\n")}),this.resolution=new Float32Array(2),this.pixelize=280};return(PixelatePostEffect=pc.inherits(PixelatePostEffect,pc.PostEffect)).prototype=pc.extend(PixelatePostEffect.prototype,{render:function(e,i,t){var o=this.device,r=o.scope;r.resolve("uColorBuffer").setValue(e.colorBuffer),this.resolution[0]=e.width,this.resolution[1]=e.height,r.resolve("uResolution").setValue(this.resolution),r.resolve("uPixelize").setValue(this.pixelize),pc.drawFullscreenQuad(o,i,this.vertexBuffer,this.shader,t)}}),{PixelatePostEffect:PixelatePostEffect}}());var PostEffectPixelate=pc.createScript("PostEffectPixelate");PostEffectPixelate.attributes.add("pixelize",{type:"number",default:100}),PostEffectPixelate.prototype.initialize=function(){var e=new pc.PixelatePostEffect(this.app.graphicsDevice),i=this.entity.camera.postEffects;i.addEffect(e),this.on("enable",(function(){i.addEffect(e,!1)})),this.on("disable",(function(){i.removeEffect(e)})),this.on("attr:pixelize",(function(e,i){this.pixelize=e}))};var DeformPlane=pc.createScript("deformPlane");DeformPlane.prototype.initialize=function(){for(var e=this.entity.model.meshInstances[0],t=e.mesh.vertexBuffer.format.elements[0].data,a=0;a<t.length;a+=3)t[a+1]+=.51*Math.sin(5*t[a]);e.mesh.vertexBuffer.setData(t)},DeformPlane.prototype.update=function(e){};var Deformation=pc.createScript("deformation");Deformation.attributes.add("strength",{type:"number",default:50,description:"L'intensité de la déformation."}),Deformation.attributes.add("waveIntensity",{type:"number",default:.01,description:"L'intensité de l'onde de la déformation."}),Deformation.attributes.add("deformationSpeed",{type:"number",default:1,description:"La vitesse de la déformation."}),Deformation.attributes.add("baseHeight",{type:"number",default:0,description:"La hauteur à partir de laquelle la déformation commence à s'appliquer."}),Deformation.prototype.initialize=function(){this.allMeshes=[];this.entity.findComponents("render").forEach((t=>{const e=t.meshInstances;for(let t=0;t<e.length;t++){const i=e[t].mesh,s=[];i.getPositions(s),this.allMeshes.push({mesh:i,srcPositions:s})}})),this.tempPositions=[],this.time=0},Deformation.prototype.update=function(t){this.time+=t*this.deformationSpeed;for(let t=0;t<this.allMeshes.length;t++){const{mesh:e,srcPositions:i}=this.allMeshes[t];this.tempPositions.length=0;for(let t=0;t<i.length;t+=3){const e=Math.max(0,i[t+1]-this.baseHeight)*this.waveIntensity;this.tempPositions[t]=i[t]+Math.sin(this.time)*Math.sin(e)*this.strength,this.tempPositions[t+1]=i[t+1]+Math.sin(this.time+e)*this.strength*e,this.tempPositions[t+2]=i[t+2]+Math.sin(this.time)*Math.sin(e)*this.strength}e.setPositions(this.tempPositions),e.update()}};var GroundScript=pc.createScript("groundScript");GroundScript.attributes.add("groundEntity",{type:"entity"}),GroundScript.attributes.add("groundBackEntity",{type:"entity"}),GroundScript.prototype.initialize=function(){this.camera=this.app.root.findByName("Camera"),this.ground=this.groundEntity,this.groundBack=this.groundBackEntity,this.boundingBox1=new pc.BoundingBox(this.ground.getPosition().clone(),this.groundEntity.getLocalScale()),this.boundingBox2=new pc.BoundingBox(this.groundBack.getPosition().clone(),this.groundEntity.getLocalScale()),this.groundSize=this.boundingBox1.halfExtents.scale(1),this.groundBackSize=this.boundingBox2.halfExtents.scale(1)},GroundScript.prototype.normalize=function(t){return pc.math.clamp(1-(t-50)/350,0,1)},GroundScript.prototype.update=function(t){this.time+=t;Math.sin(-5.5*this.time);var i=this.camera.getPosition(),n=this.ground.getPosition(),o=this.groundBack.getPosition(),e=i.distance(this.ground.getPosition()),r=i.distance(this.groundBack.getPosition());e<200&&(this.groundBack.render.meshInstances[0].setParameter("material_opacity",this.normalize(r)),this.groundBack.setLocalPosition(n.x,n.y,n.z-this.groundBackSize.z)),r<200&&(this.ground.setLocalPosition(o.x,o.y,o.z-this.groundSize.z),this.ground.render.meshInstances[0].setParameter("material_opacity",this.normalize(e)))};var SimpleShader=pc.createScript("simpleShader");SimpleShader.attributes.add("vs",{type:"asset",assetType:"shader",title:"Vertex Shader"}),SimpleShader.attributes.add("fs",{type:"asset",assetType:"shader",title:"Fragment Shader"}),SimpleShader.prototype.initialize=function(){this.time=0;var e=this.app.graphicsDevice,t=this.vs.resource,i="precision "+e.precision+" float;\n";i+=this.fs.resource;var a={attributes:{aPosition:pc.SEMANTIC_POSITION,aUv0:pc.SEMANTIC_TEXCOORD0},vshader:t,fshader:i};this.shader=new pc.Shader(e,a),this.material=new pc.Material,this.material.setParameter("iResolution",new pc.Vec3(this.app.graphicsDevice.width,this.app.graphicsDevice.height,0).data),window.onresize=function(e){this.material.setParameter("iResolution",new pc.Vec3(this.app.graphicsDevice.width,this.app.graphicsDevice.height,0).data)}.bind(this),this.material.shader=this.shader,this.material.setParameter("time",0);for(var s=this.entity.findComponents("render"),r=0;r<s.length;++r)for(var h=s[r].meshInstances,p=0;p<h.length;p++)h[p].material=this.material},SimpleShader.prototype.update=function(e){this.time+=e,this.material.setParameter("time",this.time)};var ForestGenerator=pc.createScript("forestGenerator");ForestGenerator.prototype.initialize=function(){const t=this.app.root.findByName("sol").getLocalPosition().y;for(var o=this.app.root.findByName("Arbre"),a=[],r=0;r<200;r++){a[r]=o.clone();var e=Math.round(360*Math.random()/25*25),n=-250*Math.random(),i=this.generateRandomNumberWithGap(-100,100,-2,2),s=3*Math.random()+2;a[r].setLocalPosition(i,t,n),a[r].setLocalEulerAngles(0,e,0),a[r].setLocalScale(1.5,s,1.5),this.app.root.addChild(a[r])}},ForestGenerator.prototype.generateRandomNumberWithGap=function(t,o,a,r){var e=Math.random()*(a-t)+t,n=Math.random()*(o-r)+r;return Math.random()<.5?e:n};var Mandala1=pc.createScript("mandala1");Mandala1.attributes.add("rotationSpeed",{type:"number",default:30}),Mandala1.attributes.add("distanceFromCamera",{type:"number",default:5}),Mandala1.prototype.initialize=function(){},Mandala1.prototype.camScreenPos=function(){this.cam=this.app.root.findByName("Camera");var a=this.cam.getPosition(),t=new pc.Vec3;return this.cam.camera.worldToScreen(a,t)},Mandala1.prototype.update=function(a){this.entity.rotate(0,0,this.rotationSpeed*a);this.rotationSpeed;var t=this.app.root.findByName("Camera").getPosition(),e=new pc.Vec3(0,-14,-this.distanceFromCamera);t.clone().add(e);this.entity.render.material.setParameter("material_opacity",.9),this.entity.setPosition(0,-14,-50)};var HillSpawner=pc.createScript("hillSpawner");HillSpawner.attributes.add("hillEntity",{type:"entity",title:"Hill Entity"}),HillSpawner.attributes.add("planeSize",{type:"vec2",default:[100,100],title:"Plane Size"}),HillSpawner.attributes.add("numHills",{type:"number",default:10,title:"Number of Hills"}),HillSpawner.attributes.add("minSize",{type:"number",default:.5,title:"Minimum Hill Size"}),HillSpawner.attributes.add("maxSize",{type:"number",default:2,title:"Maximum Hill Size"}),HillSpawner.prototype.initialize=function(){this.hills=[];for(var t=0;t<this.numHills;t++)this.spawnHill()},HillSpawner.prototype.spawnHill=function(){var t=this.getRandomPosition(),i=this.getRandomSize(),e=this.hillEntity.clone();e.setLocalPosition(t.x,t.y,t.z),e.setLocalScale(i,i,i),this.app.root.addChild(e),this.hills.push(e)},HillSpawner.prototype.getRandomPosition=function(){var t=(Math.random()-.5)*this.planeSize.width,i=(Math.random()-.5)*this.planeSize.height;return new pc.Vec3(t,0,i)},HillSpawner.prototype.getRandomSize=function(){return 100*Math.random()+50};var ShowImage=pc.createScript("showImage");ShowImage.attributes.add("imageAsset",{type:"asset",assetType:"texture",title:"Image Asset"}),ShowImage.prototype.initialize=function(){var e=new pc.Entity;e.addComponent("model",{type:"plane"});var t=new pc.StandardMaterial;t.emissiveMap=this.imageAsset.resource,t.opacityMap=this.imageAsset.resource,t.blendType=pc.BLEND_NORMAL,t.update(),e.model.material=t,e.setLocalPosition(0,-14,-5),this.app.root.findByName("Camera").addChild(e),this.plane=e,this.timer=0,this.showTime=1,this.hideTime=1,this.showing=!1},ShowImage.prototype.update=function(e){this.timer+=e,this.showing&&this.timer>this.showTime?(this.plane.enabled=!1,this.showing=!1,this.timer=0):!this.showing&&this.timer>this.hideTime&&(this.plane.enabled=!0,this.showing=!0,this.timer=0)};var ObjectSpawner=pc.createScript("objectSpawner");ObjectSpawner.attributes.add("objectToSpawn",{type:"entity",title:"Object To Spawn"}),ObjectSpawner.attributes.add("minDistance",{type:"number",default:5,title:"Min Distance"}),ObjectSpawner.attributes.add("maxDistance",{type:"number",default:10,title:"Max Distance"}),ObjectSpawner.attributes.add("numObjectsToSpawn",{type:"number",default:10,title:"Number of Objects to Spawn"}),ObjectSpawner.attributes.add("fadeInDuration",{type:"number",default:500,title:"Fade In Duration"}),ObjectSpawner.prototype.initialize=function(){this.objectsSpawned=0,this.distanceSinceLastSpawn=0,this.lastPosition=this.entity.getPosition().clone()},ObjectSpawner.prototype.update=function(t){if(this.entity.getPosition().z<=-1e3)this.enabled=!1;else{var e=this.entity.getPosition();if(this.distanceSinceLastSpawn+=e.distance(this.lastPosition),this.lastPosition.copy(e),this.distanceSinceLastSpawn>=this.minDistance){if(this.objectsSpawned<this.numObjectsToSpawn){var a=this.entity.forward.clone(),n=pc.math.random(this.minDistance,this.maxDistance),i=e.clone().add(a.scale(n)),s=this.entity.right.clone(),c=this.generateRandomNumberWithGap(-130,130,-30,30);i.z=pc.math.clamp(i.z,-1e3,155),i.y=-20.5,i.add(s.scale(c)),this.spawnObject(i),this.objectsSpawned++}else this.objectsSpawned=0;this.distanceSinceLastSpawn=0}}},ObjectSpawner.prototype.spawnObject=function(t){var e=this.objectToSpawn.clone();e.setPosition(t);var a=pc.math.random(0,360);e.setEulerAngles(0,a,0);var n=e.getLocalScale(),i=8.6*Math.random()+3.5;e.setLocalScale(n.x*i,n.y*i,n.z*i),this.app.root.addChild(e)},ObjectSpawner.prototype.generateRandomNumberWithGap=function(t,e,a,n){var i=Math.random()*(a-t)+t,s=Math.random()*(e-n)+n;return Math.random()<.5?i:s};function GodRaysEffect(t,e){pc.PostEffect.call(this,t),this.needsDepthBuffer=!0,this.lightScatterShader=new pc.Shader(t,{attributes:{aPosition:pc.SEMANTIC_POSITION},vshader:[t.webgl2?"#version 300 es\n\n"+pc.shaderChunks.gles3VS:"","attribute vec2 aPosition;","","varying vec2 vUv0;","","void main(void)","{","    gl_Position = vec4(aPosition, 0.0, 1.0);","    vUv0 = (aPosition.xy + 1.0) * 0.5;","}"].join("\n"),fshader:[t.webgl2?"#version 300 es\n\n"+pc.shaderChunks.gles3PS:"","precision "+t.precision+" float;",pc.shaderChunks.screenDepthPS,"","varying vec2 vUv0;","","uniform sampler2D uColorBuffer;","uniform float uAspect;","uniform vec4 uLightPosition;","uniform float uIntensity;","uniform float uWeight;","","float sun( vec2 uv, vec2 p ){","   float di = distance(uv, p) * uLightPosition.w;","   return (di <= .3333 / uWeight ? sqrt(1. - di*3./ uWeight) : 0.);","}","","void main()","{","    highp vec2 uv = vUv0; // variable_vertex.xy; // interpolated at pixel's center","    vec2 coords = uv;","","    coords.x *= uAspect;","    vec2 sunPos = uLightPosition.xy;","    sunPos.x *= uAspect;","    float light = sun(coords, sunPos);","","    float occluders = 1.0 - getLinearScreenDepth(uv) / camera_params.y;","","    float col = step(occluders, 0.0) * (light - occluders) * uIntensity;","    gl_FragColor = vec4(col * uLightPosition.z,occluders,0.0,0.0);","}"].join("\n")}),this.blurShader=new pc.Shader(t,{attributes:{aPosition:pc.SEMANTIC_POSITION},vshader:[t.webgl2?"#version 300 es\n\n"+pc.shaderChunks.gles3VS:"","attribute vec2 aPosition;","","varying vec2 vUv0;","","void main(void)","{","    gl_Position = vec4(aPosition, 0.0, 1.0);","    vUv0 = (aPosition.xy + 1.0) * 0.5;","}"].join("\n"),fshader:[t.webgl2?"#version 300 es\n\n"+pc.shaderChunks.gles3PS:"","precision "+t.precision+" float;",pc.shaderChunks.screenDepthPS,"","varying vec2 vUv0;","","uniform sampler2D uColorBuffer;","uniform sampler2D uLightScatterBuffer;","#define DITHER","#define SAMPLES "+e.toFixed(0),"#define DENSITY .95","#define WEIGHT .25","uniform vec4 uLightPosition;","uniform float uWeight;","uniform float uDecay;","uniform float uExposure;","uniform vec3 uColor;","","float random(const highp vec2 uv) {","   const highp float a = 12.9898, b = 78.233, c = 43758.5453;","   highp float dt = dot( uv.xy, vec2( a,b ) ), sn = mod( dt, 3.14159265359 );","   return fract(sin(sn) * c);","}","","void main() {","    highp vec2 uv = vUv0; // variable_vertex.xy; // interpolated at pixel's center","    vec2 coord = uv;        ","    vec2 lightPos = uLightPosition.xy;","","    vec4 lightScatterSampler = texture2D(uLightScatterBuffer, uv);","    float occ = lightScatterSampler.x; //light","    float obj = lightScatterSampler.y; //objects","    float dither = random(uv);","","    vec2 dtc = (coord - lightPos) * (1. / float(SAMPLES) * DENSITY);","    float illumdecay = 1.;","","    for(int i=0; i<SAMPLES; i++){","        coord -= dtc;","        float s = texture2D(uLightScatterBuffer, coord+(dtc*dither)).x;","        s *= illumdecay * WEIGHT;","        occ += s;","        illumdecay *= uDecay;","    }","","    float rays = occ*uExposure *uLightPosition.z;","    vec4 base = texture2D( uColorBuffer, vUv0 );","","    gl_FragColor = vec4(uColor * rays, 1.0) + (base * (1.5 - 0.4));","}"].join("\n")});var i=t.width,o=t.height;this.targets=[];for(var s=0;s<1;s++){var r=new pc.Texture(t,{format:pc.PIXELFORMAT_R8_G8_B8_A8,width:i,height:o,mipmaps:!1});r.minFilter=pc.FILTER_LINEAR,r.magFilter=pc.FILTER_LINEAR,r.addressU=pc.ADDRESS_CLAMP_TO_EDGE,r.addressV=pc.ADDRESS_CLAMP_TO_EDGE,r.name="lightScatter_"+s;var a=new pc.RenderTarget(t,r,{depth:!1});this.targets.push(a)}this.cameraEntity=void 0,this.lightEntity=void 0,this.vec=new pc.Vec3,this.lightPosition=new pc.Vec4,this.intensity=2,this.weight=.43,this.decay=.024,this.exposure=.3,this.color=new pc.Color(.835,.812,.318,1)}GodRaysEffect.prototype=Object.create(pc.PostEffect.prototype),GodRaysEffect.prototype.constructor=GodRaysEffect,Object.assign(GodRaysEffect.prototype,{render:function(t,e,i){var o=this.device,s=o.scope;if(this.lightEntity&&this.cameraEntity){var r=this.lightEntity.getPosition(),a=this.vec,c=o.width/window.devicePixelRatio,n=o.height/window.devicePixelRatio;this.cameraEntity.camera.worldToScreen(r,a),this.lightPosition.x=a.x/c,this.lightPosition.y=1-a.y/n,this.lightPosition.z=a.z>0?1:0,this.lightPosition.w=window.devicePixelRatio}s.resolve("uLightPosition").setValue([this.lightPosition.x,this.lightPosition.y,this.lightPosition.z,this.lightPosition.w]),s.resolve("uIntensity").setValue(this.intensity),s.resolve("uWeight").setValue(this.weight),s.resolve("uDecay").setValue(1-this.decay),s.resolve("uExposure").setValue(this.exposure),s.resolve("uColor").setValue([this.color.r,this.color.g,this.color.b]),s.resolve("uAspect").setValue(o.width/o.height),s.resolve("uColorBuffer").setValue(t.colorBuffer),pc.drawFullscreenQuad(o,this.targets[0],this.vertexBuffer,this.lightScatterShader,i),s.resolve("uLightScatterBuffer").setValue(this.targets[0].colorBuffer),pc.drawFullscreenQuad(o,e,this.vertexBuffer,this.blurShader,i)}});var GodRays=pc.createScript("godRays");GodRays.attributes.add("cameraEntity",{type:"entity",title:"Camera Entity"}),GodRays.attributes.add("lightEntity",{type:"entity",title:"Light Emitter",description:"Drag and drop any entity (not necessarily a light), its world position will be used to calculate the center of the effect on screen."}),GodRays.attributes.add("samples",{type:"number",default:32,precision:1,title:"Samples",description:"The number of iterations executed for rays distribution."}),GodRays.attributes.add("intensity",{type:"number",default:1.5,min:.01,max:3,title:"Intensity",description:"The intensity of the light accumulated in the center of the effect."}),GodRays.attributes.add("weight",{type:"number",default:.3,min:0,max:1,title:"Weight",description:"Determines the outer rim of the light on the center of the effect."}),GodRays.attributes.add("decay",{type:"number",default:.01,precision:3,min:0,max:1,title:"Decay",description:"Determines how fast the rays will decay from the light source."}),GodRays.attributes.add("exposure",{type:"number",default:.09,min:0,max:1,title:"Exposure",description:"A multiplier to increase exponentially the amount of light calculated."}),GodRays.attributes.add("color",{type:"rgb",default:[.835,.812,.318],title:"Color",description:"The color of the light source."}),GodRays.prototype.initialize=function(){if(this.cameraEntity){var t=this.cameraEntity.camera.postEffects;this.effect=this.createEffect(),this.on("attr",(function(e,i){this.effect[e]=i,"samples"===e&&(t.removeEffect(this.effect),this.effect=this.createEffect(),this.lightEntity.enabled&&t.addEffect(this.effect))}),this),this.lightEntity.enabled&&t.addEffect(this.effect),this.on("state",(function(e){e?t.addEffect(this.effect):t.removeEffect(this.effect)})),this.on("destroy",(function(){t.removeEffect(this.effect)}))}},GodRays.prototype.createEffect=function(){var t=new GodRaysEffect(this.app.graphicsDevice,this.samples);return t.cameraEntity=this.cameraEntity,t.lightEntity=this.lightEntity,t.intensity=this.intensity,t.weight=this.weight,t.decay=this.decay,t.exposure=this.exposure,t.color=this.color,t};var Camera1Setup=pc.createScript("camera1Setup");Camera1Setup.prototype.initialize=function(){this.entity.setPosition(0,-10,73.649);var t=new pc.Vec3(0,-19,0);this.entity.lookAt(t)},Camera1Setup.prototype.update=function(t){};var Ribbon=pc.createScript("ribbon");Ribbon.attributes.add("lifetime",{type:"number",default:.5}),Ribbon.attributes.add("xoffset",{type:"number",default:-.8}),Ribbon.attributes.add("yoffset",{type:"number",default:1}),Ribbon.attributes.add("height",{type:"number",default:.4});var MAX_VERTICES=600,VERTEX_SIZE=4;Ribbon.prototype.initialize=function(){var e=this.app;this.timer=0,this.node=null,this.vertices=[],this.vertexData=new Float32Array(MAX_VERTICES*VERTEX_SIZE);var t={attributes:{aPositionAge:pc.gfx.SEMANTIC_POSITION},vshader:["attribute vec4 aPositionAge;","","uniform mat4 matrix_viewProjection;","uniform float trail_time;","","varying float vAge;","","void main(void)","{","    vAge = trail_time - aPositionAge.w;","    gl_Position = matrix_viewProjection * vec4(aPositionAge.xyz, 1.0);","}"].join("\n"),fshader:["precision mediump float;","","varying float vAge;","","uniform float trail_lifetime;","","vec3 rainbow(float x)","{","float level = floor(x * 6.0);","float r = float(level <= 2.0) + float(level > 4.0) * 0.5;","float g = max(1.0 - abs(level - 2.0) * 0.5, 0.0);","float b = (1.0 - (level - 4.0) * 0.5) * float(level >= 4.0);","return vec3(r, g, b);","}","void main(void)","{","    gl_FragColor = vec4(rainbow(vAge / trail_lifetime), (1.0 - (vAge / trail_lifetime)) * 0.6);","}"].join("\n")},i=new pc.Shader(e.graphicsDevice,t),r=new pc.Material;r.shader=i,r.setParameter("trail_time",0),r.setParameter("trail_lifetime",this.lifetime),r.cull=pc.CULLFACE_NONE,r.blend=!0,r.blendSrc=pc.BLENDMODE_SRC_ALPHA,r.blendDst=pc.BLENDMODE_ONE_MINUS_SRC_ALPHA,r.blendEquation=pc.BLENDEQUATION_ADD,r.depthWrite=!1;var a=new pc.VertexFormat(e.graphicsDevice,[{semantic:pc.SEMANTIC_POSITION,components:4,type:pc.ELEMENTTYPE_FLOAT32}]),s=new pc.VertexBuffer(e.graphicsDevice,a,MAX_VERTICES,pc.USAGE_DYNAMIC),o=new pc.Mesh;o.vertexBuffer=s,o.indexBuffer[0]=null,o.primitive[0].type=pc.PRIMITIVE_TRISTRIP,o.primitive[0].base=0,o.primitive[0].count=0,o.primitive[0].indexed=!1;var n=new pc.GraphNode,l=new pc.MeshInstance(n,o,r);l.layer=pc.LAYER_WORLD,l.updateKey(),this.model=new pc.Model,this.model.graph=n,this.model.meshInstances.push(l),this.setNode(this.entity)},Ribbon.prototype.reset=function(){this.timer=0,this.vertices=[]},Ribbon.prototype.spawn=function(){var e=this.node,t=e.getPosition(),i=e.up.clone().scale(this.height),r=this.xoffset,a=this.yoffset;this.vertices.unshift({spawnTime:this.timer,vertexPair:[t.x+i.x*r,t.y+i.y*r,t.z+i.z*r,t.x+i.x*a,t.y+i.y*a,t.z+i.z*a]})},Ribbon.prototype.clearOld=function(){for(var e=this.vertices.length-1;e>=0;e--){var t=this.vertices[e];if(!(this.timer-t.spawnTime>=this.lifetime))return;this.vertices.pop()}},Ribbon.prototype.copyToArrayBuffer=function(){for(var e=0;e<this.vertices.length;e++){var t=this.vertices[e];this.vertexData[8*e+0]=t.vertexPair[0],this.vertexData[8*e+1]=t.vertexPair[1],this.vertexData[8*e+2]=t.vertexPair[2],this.vertexData[8*e+3]=t.spawnTime,this.vertexData[8*e+4]=t.vertexPair[3],this.vertexData[8*e+5]=t.vertexPair[4],this.vertexData[8*e+6]=t.vertexPair[5],this.vertexData[8*e+7]=t.spawnTime}},Ribbon.prototype.updateNumActive=function(){this.model.meshInstances[0].mesh.primitive[0].count=2*this.vertices.length},Ribbon.prototype.update=function(e){if(this.timer+=e,this.model.meshInstances[0].material.setParameter("trail_time",this.timer),this.spawn(),this.vertices.length>1){this.copyToArrayBuffer(),this.updateNumActive();var t=this.model.meshInstances[0].mesh.vertexBuffer;new Float32Array(t.lock()).set(this.vertexData),t.unlock(),this.app.scene.containsModel(this.model)||this.app.scene.addModel(this.model)}else this.app.scene.containsModel(this.model)&&this.app.scene.removeModel(this.model)},Ribbon.prototype.setNode=function(e){this.node=e};var Luciole=pc.createScript("luciole");Luciole.attributes.add("distanceFromCamera",{type:"number",default:5,description:"Distance de l'entité par rapport à la caméra"}),Luciole.attributes.add("oscillationAmplitude",{type:"number",default:1,description:"Amplitude de l'oscillation"}),Luciole.attributes.add("oscillationSpeed",{type:"number",default:2,description:"Vitesse de l'oscillation"}),Luciole.prototype.initialize=function(){this.time=0},Luciole.prototype.update=function(t){this.time+=t;var i=this.app.root.findByName("Camera"),e=i.getPosition(),o=i.forward,a=e.clone().add(o.clone().scale(this.distanceFromCamera)),l=Math.sin(this.time*this.oscillationSpeed)*this.oscillationAmplitude,s=Math.cos(this.time*this.oscillationSpeed)*this.oscillationAmplitude;a.x+=l,a.y+=s,this.entity.setPosition(a)};var Rotate=pc.createScript("rotate");Rotate.attributes.add("speed",{type:"number",default:1,description:"Speed of rotation"}),Rotate.attributes.add("rotateAxis",{type:"vec3",default:[0,1,0],description:"Axis of rotation (x, y, z)"}),Rotate.prototype.initialize=function(){this.axis=new pc.Vec3(this.rotateAxis.x,this.rotateAxis.y,this.rotateAxis.z).normalize()},Rotate.prototype.update=function(t){var e=this.speed*t;this.entity.rotateLocal(this.axis.x*e,this.axis.y*e,this.axis.z*e)};var Fallen=pc.createScript("fallen");Fallen.attributes.add("MainObj",{type:"entity",title:"MainObj"}),Fallen.attributes.add("ObjType",{default:"model",type:"string",title:"Object Type"}),Fallen.attributes.add("Type",{default:0,type:"number",title:"Type"}),Fallen.attributes.add("ScaleCoeff",{default:1,type:"number",title:"ScaleCoeff"}),Fallen.attributes.add("FlipZEnabledFlag",{default:!0,type:"boolean",title:"FlipZEnabledFlag"}),Fallen.prototype.initialize=function(){switch(this.Angles=new pc.Vec3,this.AnglesSpeed=new pc.Vec3,this.Pos=new pc.Vec3,this.Scale=new pc.Vec3,this.Speed=new pc.Vec3,this.SpeedMax=new pc.Vec3,this.SecTimeCntr=0,this.DiamMax=0,this.ObjType){case"sprite":this.Width=Utils.instance.GetMeshWidthMax(this.MainObj.sprite.aabb),this.Height=Utils.instance.GetMeshHeightMax(this.MainObj.sprite.aabb),this.Depth=0,this.DiamMax=this.Width,this.Height>this.DiamMax&&(this.DiamMax=this.Height);break;case"model":this.Width=Utils.instance.GetMeshWidthMax(this.MainObj.render.meshInstances[0].aabb),this.Height=Utils.instance.GetMeshHeightMax(this.MainObj.render.meshInstances[0].aabb),this.Depth=Utils.instance.GetMeshZMax(this.MainObj.render.meshInstances[0].aabb),this.DiamMax=this.Width,this.Height>this.DiamMax&&(this.DiamMax=this.Height),this.Depth>this.DiamMax&&(this.DiamMax=this.Depth)}this.RotateFlag=!1,this.GravityFlag=!1,this.entity.on("fall:create:vert",this.CreateVert,this),this.entity.on("fall:rotate",this.SetRotate,this),this.entity.on("fall:speed",this.SetSpeed,this),this.entity.on("fall:angles",this.SetAngles,this),this.entity.on("fall:checkout",this.CheckOut,this),this.entity.on("fall:sinx",this.SetSinusX,this),this.entity.on("fall:scalecoeff",this.SetScaleCoeff,this),this.entity.on("fall:gravity",this.SetGravity,this),this.entity.on("fall:z",this.SetZ,this)},Fallen.prototype.CreateVert=function(t,e,i,s){var a=Main.instance.CameraHeight+this.DiamMax,h=-Main.instance.CameraHeight-this.DiamMax;this.UpFlag=i;var n=a;this.UpFlag&&(n=h),this.Pos.set(t,n,e),this.entity.setPosition(this.Pos);var l=s/this.DiamMax;this.Scale.set(l,l,l),this.entity.setLocalScale(this.Scale),this.RadX=l*this.DiamMax/2,this.Angles.set(0,0,0),this.entity.setEulerAngles(this.Angles),this.Speed.set(0,0,0),this.RotateFlag=!1,this.SinusXFlag=!1,this.SecTimeCntr=1},Fallen.prototype.SetSinusX=function(t,e,i){this.X0=this.Pos.x,this.SinusXAmp=t,this.SinusXAngle=i,this.SinusXAngleSpeed=2*Math.PI/e,this.SinusXFlag=!0},Fallen.prototype.CheckInsideX=function(t){return Math.abs(t-this.Pos.x)<this.RadX},Fallen.prototype.SetFlipZ=function(){this.FlipZEnabledFlag&&(this.Scale.z=-this.Scale.z,this.entity.setLocalScale(this.Scale))},Fallen.prototype.SetScaleCoeff=function(t,e,i){this.Scale.x*=t,this.Scale.y*=e,this.Scale.z*=i,this.entity.setLocalScale(this.Scale)},Fallen.prototype.SetAngles=function(t,e,i){this.Angles.set(t,e,i),this.entity.setEulerAngles(this.Angles)},Fallen.prototype.SetSpeed=function(t,e,i){this.Speed.set(t,e,i)},Fallen.prototype.SetRotate=function(t,e,i){this.AnglesSpeed.set(t,e,i),this.RotateFlag=!0},Fallen.prototype.CheckOut=function(){if(this.entity.enabled)return this.GravityFlag?(this.Y_bott=-Main.instance.CameraHeight-this.DiamMax,void(this.Speed.y<0&&this.Pos.y<this.Y_bott&&(this.entity.enabled=!1))):void(this.UpFlag?(this.Y_top=Main.instance.CameraHeight+this.DiamMax,this.Pos.y>this.Y_top&&(this.entity.enabled=!1)):(this.Y_bott=-Main.instance.CameraHeight-this.DiamMax,this.Pos.y<this.Y_bott&&(this.entity.enabled=!1)))},Fallen.prototype.SetGravity=function(t,e){this.Gravity=t,this.SpeedMax.y=e,this.GravityFlag=!0},Fallen.prototype.SetZ=function(t){this.Pos.z=t,this.entity.setPosition(this.Pos)},Fallen.prototype.update=function(t){this.RotateFlag&&(this.Angles.x+=this.AnglesSpeed.x*t,this.Angles.y+=this.AnglesSpeed.y*t,this.Angles.z+=this.AnglesSpeed.z*t,this.entity.setEulerAngles(this.Angles)),this.Pos.x+=this.Speed.x*t,this.Pos.y+=this.Speed.y*t,this.GravityFlag&&(this.Speed.y+=this.Gravity*t,this.Speed.y<this.SpeedMax.y&&(this.Speed.y=this.SpeedMax.y)),this.SinusXFlag&&(this.Pos.x=this.X0+this.SinusXAmp*Math.sin(this.SinusXAngle),this.SinusXAngle+=this.SinusXAngleSpeed*t),this.entity.setPosition(this.Pos),(this.SecTimeCntr-=t)<0&&(this.SecTimeCntr=1,this.CheckOut())};var RandomColorChange=pc.createScript("randomColorChange");RandomColorChange.attributes.add("changeInterval",{type:"number",default:2,description:"Temps en secondes entre les changements de couleur"}),RandomColorChange.prototype.initialize=function(){this.timer=0,this.changeColors()},RandomColorChange.prototype.update=function(e){this.timer+=e,this.timer>=this.changeInterval&&(this.timer=0,this.changeColors())},RandomColorChange.prototype.changeColors=function(){this.entity.children.forEach((function(e){e.model&&e.model.meshInstances&&e.model.meshInstances.forEach((function(e){var o=e.material,n=new pc.Color(Math.random(),Math.random(),Math.random());o.diffuse.set(n.r,n.g,n.b),o.update()}))}))};!function(){"use strict";function getDefaultExportFromCjs($){return $&&$.__esModule&&Object.prototype.hasOwnProperty.call($,"default")?$.default:$}function getAugmentedNamespace($){if($.__esModule)return $;var W=Object.defineProperty({},"__esModule",{value:!0});return Object.keys($).forEach((function(G){var oe=Object.getOwnPropertyDescriptor($,G);Object.defineProperty(W,G,oe.get?oe:{enumerable:!0,get:function(){return $[G]}})})),W}var $={},W={},G=Array.isArray,oe="object"==typeof global&&global&&global.Object===Object&&global,ae="object"==typeof self&&self&&self.Object===Object&&self,ie=oe||ae||Function("return this")(),se=ie.Symbol,le=Object.prototype,ue=le.hasOwnProperty,de=le.toString,pe=se?se.toStringTag:void 0;var he=Object.prototype.toString;var ge=se?se.toStringTag:void 0;function baseGetTag($){return null==$?void 0===$?"[object Undefined]":"[object Null]":ge&&ge in Object($)?function getRawTag($){var W=ue.call($,pe),G=$[pe];try{$[pe]=void 0;var oe=!0}catch($){}var ae=de.call($);return oe&&(W?$[pe]=G:delete $[pe]),ae}($):function objectToString($){return he.call($)}($)}function isObjectLike($){return null!=$&&"object"==typeof $}function isSymbol($){return"symbol"==typeof $||isObjectLike($)&&"[object Symbol]"==baseGetTag($)}var ve=/\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/,we=/^\w*$/;function isObject($){var W=typeof $;return null!=$&&("object"==W||"function"==W)}var Se,Pe=ie["__core-js_shared__"],je=(Se=/[^.]+$/.exec(Pe&&Pe.keys&&Pe.keys.IE_PROTO||""))?"Symbol(src)_1."+Se:"";var Ie=Function.prototype.toString;var De=/^\[object .+?Constructor\]$/,$e=Function.prototype,Le=Object.prototype,Ke=$e.toString,Ge=Le.hasOwnProperty,Xe=RegExp("^"+Ke.call(Ge).replace(/[\\^$.*+?()[\]{}|]/g,"\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g,"$1.*?")+"$");function baseIsNative($){if(!isObject($)||function isMasked($){return!!je&&je in $}($))return!1;var W=function isFunction($){if(!isObject($))return!1;var W=baseGetTag($);return"[object Function]"==W||"[object GeneratorFunction]"==W||"[object AsyncFunction]"==W||"[object Proxy]"==W}($)?Xe:De;return W.test(function toSource($){if(null!=$){try{return Ie.call($)}catch($){}try{return $+""}catch($){}}return""}($))}function getNative($,W){var G=function getValue($,W){return null==$?void 0:$[W]}($,W);return baseIsNative(G)?G:void 0}var Ye=getNative(Object,"create");var Je=Object.prototype.hasOwnProperty;var Qe=Object.prototype.hasOwnProperty;function Hash($){var W=-1,G=null==$?0:$.length;for(this.clear();++W<G;){var oe=$[W];this.set(oe[0],oe[1])}}function assocIndexOf($,W){for(var G,oe,ae=$.length;ae--;)if((G=$[ae][0])===(oe=W)||G!=G&&oe!=oe)return ae;return-1}Hash.prototype.clear=function hashClear(){this.__data__=Ye?Ye(null):{},this.size=0},Hash.prototype.delete=function hashDelete($){var W=this.has($)&&delete this.__data__[$];return this.size-=W?1:0,W},Hash.prototype.get=function hashGet($){var W=this.__data__;if(Ye){var G=W[$];return"__lodash_hash_undefined__"===G?void 0:G}return Je.call(W,$)?W[$]:void 0},Hash.prototype.has=function hashHas($){var W=this.__data__;return Ye?void 0!==W[$]:Qe.call(W,$)},Hash.prototype.set=function hashSet($,W){var G=this.__data__;return this.size+=this.has($)?0:1,G[$]=Ye&&void 0===W?"__lodash_hash_undefined__":W,this};var Ze=Array.prototype.splice;function ListCache($){var W=-1,G=null==$?0:$.length;for(this.clear();++W<G;){var oe=$[W];this.set(oe[0],oe[1])}}ListCache.prototype.clear=function listCacheClear(){this.__data__=[],this.size=0},ListCache.prototype.delete=function listCacheDelete($){var W=this.__data__,G=assocIndexOf(W,$);return!(G<0)&&(G==W.length-1?W.pop():Ze.call(W,G,1),--this.size,!0)},ListCache.prototype.get=function listCacheGet($){var W=this.__data__,G=assocIndexOf(W,$);return G<0?void 0:W[G][1]},ListCache.prototype.has=function listCacheHas($){return assocIndexOf(this.__data__,$)>-1},ListCache.prototype.set=function listCacheSet($,W){var G=this.__data__,oe=assocIndexOf(G,$);return oe<0?(++this.size,G.push([$,W])):G[oe][1]=W,this};var et=getNative(ie,"Map");function getMapData($,W){var G=$.__data__;return function isKeyable($){var W=typeof $;return"string"==W||"number"==W||"symbol"==W||"boolean"==W?"__proto__"!==$:null===$}(W)?G["string"==typeof W?"string":"hash"]:G.map}function MapCache($){var W=-1,G=null==$?0:$.length;for(this.clear();++W<G;){var oe=$[W];this.set(oe[0],oe[1])}}MapCache.prototype.clear=function mapCacheClear(){this.size=0,this.__data__={hash:new Hash,map:new(et||ListCache),string:new Hash}},MapCache.prototype.delete=function mapCacheDelete($){var W=getMapData(this,$).delete($);return this.size-=W?1:0,W},MapCache.prototype.get=function mapCacheGet($){return getMapData(this,$).get($)},MapCache.prototype.has=function mapCacheHas($){return getMapData(this,$).has($)},MapCache.prototype.set=function mapCacheSet($,W){var G=getMapData(this,$),oe=G.size;return G.set($,W),this.size+=G.size==oe?0:1,this};function memoize$1($,W){if("function"!=typeof $||null!=W&&"function"!=typeof W)throw new TypeError("Expected a function");var memoized=function(){var G=arguments,oe=W?W.apply(this,G):G[0],ae=memoized.cache;if(ae.has(oe))return ae.get(oe);var ie=$.apply(this,G);return memoized.cache=ae.set(oe,ie)||ae,ie};return memoized.cache=new(memoize$1.Cache||MapCache),memoized}memoize$1.Cache=MapCache;var tt=/[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g,rt=/\\(\\)?/g,nt=function memoizeCapped($){var W=memoize$1($,(function($){return 500===G.size&&G.clear(),$})),G=W.cache;return W}((function($){var W=[];return 46===$.charCodeAt(0)&&W.push(""),$.replace(tt,(function($,G,oe,ae){W.push(oe?ae.replace(rt,"$1"):G||$)})),W}));var ot=se?se.prototype:void 0,at=ot?ot.toString:void 0;function baseToString($){if("string"==typeof $)return $;if(G($))return function arrayMap($,W){for(var G=-1,oe=null==$?0:$.length,ae=Array(oe);++G<oe;)ae[G]=W($[G],G,$);return ae}($,baseToString)+"";if(isSymbol($))return at?at.call($):"";var W=$+"";return"0"==W&&1/$==-Infinity?"-0":W}function castPath($,W){return G($)?$:function isKey($,W){if(G($))return!1;var oe=typeof $;return!("number"!=oe&&"symbol"!=oe&&"boolean"!=oe&&null!=$&&!isSymbol($))||we.test($)||!ve.test($)||null!=W&&$ in Object(W)}($,W)?[$]:nt(function toString($){return null==$?"":baseToString($)}($))}function toKey($){if("string"==typeof $||isSymbol($))return $;var W=$+"";return"0"==W&&1/$==-Infinity?"-0":W}var it=Object.freeze({__proto__:null,default:function get($,W,G){var oe=null==$?void 0:function baseGet($,W){for(var G=0,oe=(W=castPath(W,$)).length;null!=$&&G<oe;)$=$[toKey(W[G++])];return G&&G==oe?$:void 0}($,W);return void 0===oe?G:oe}}),st=getAugmentedNamespace(it);var lt=function overArg($,W){return function(G){return $(W(G))}}(Object.getPrototypeOf,Object),ut=Function.prototype,ct=Object.prototype,dt=ut.toString,ft=ct.hasOwnProperty,pt=dt.call(Object);var ht=getAugmentedNamespace(Object.freeze({__proto__:null,default:function isPlainObject($){if(!isObjectLike($)||"[object Object]"!=baseGetTag($))return!1;var W=lt($);if(null===W)return!0;var G=ft.call(W,"constructor")&&W.constructor;return"function"==typeof G&&G instanceof G&&dt.call(G)==pt}}));var mt=getAugmentedNamespace(Object.freeze({__proto__:null,default:function last($){var W=null==$?0:$.length;return W?$[W-1]:void 0}}));!function($){var W=Object.create,G=Object.defineProperty,oe=Object.defineProperties,ae=Object.getOwnPropertyDescriptor,ie=Object.getOwnPropertyDescriptors,se=Object.getOwnPropertyNames,le=Object.getOwnPropertySymbols,ue=Object.getPrototypeOf,de=Object.prototype.hasOwnProperty,pe=Object.prototype.propertyIsEnumerable,__defNormalProp=($,W,oe)=>W in $?G($,W,{enumerable:!0,configurable:!0,writable:!0,value:oe}):$[W]=oe,__markAsModule=$=>G($,"__esModule",{value:!0}),__toModule=$=>(($,W,oe)=>{if(W&&"object"==typeof W||"function"==typeof W)for(let ie of se(W))de.call($,ie)||"default"===ie||G($,ie,{get:()=>W[ie],enumerable:!(oe=ae(W,ie))||oe.enumerable});return $})(__markAsModule(G(null!=$?W(ue($)):{},"default",$&&$.__esModule&&"default"in $?{get:()=>$.default,enumerable:!0}:{value:$,enumerable:!0})),$);(($,W)=>{for(var oe in __markAsModule($),W)G($,oe,{get:W[oe],enumerable:!0})})($,{AbstractDerivation:()=>Je,Atom:()=>lt,Box:()=>ct,ConstantDerivation:()=>dt,DerivationFromSource:()=>Qe,PointerProxy:()=>xt,Ticker:()=>ft,getPointerParts:()=>getPointerParts,isDerivation:()=>isDerivation,isPointer:()=>isPointer,iterateAndCountTicks:()=>iterateAndCountTicks,iterateOver:()=>iterateOver,pointer:()=>nt,prism:()=>St,val:()=>val,valueDerivation:()=>valueDerivation});var he,ge,ve=__toModule(st),we=__toModule(ht),Se=__toModule(mt),Pe=class{constructor(){this._lastTapperId=0,this._tappers=new Map,this.tappable=new class{constructor($){this._untapFromSourceTimeout=null,this._cb=$=>{this._tappers.forEach((W=>{W($)}))},this._lastTapperId=0,this._untapFromSource=null,this._props=$,this._tappers=new Map}_check(){this._untapFromSource?0===this._tappers.size&&this._scheduleToUntapFromSource():0!==this._tappers.size&&(this._untapFromSource=this._props.tapToSource(this._cb))}_scheduleToUntapFromSource(){null===this._untapFromSourceTimeout&&(this._untapFromSourceTimeout=setTimeout((()=>{this._untapFromSourceTimeout=null,0===this._tappers.size&&(this._untapFromSource(),this._untapFromSource=null)}),0))}tap($){const W=this._lastTapperId++;return this._tappers.set(W,$),this._check(),()=>{this._removeTapperById(W)}}_removeTapperById($){this._tappers.delete($),this._check()}}({tapToSource:$=>this._tap($)})}_tap($){const W=this._lastTapperId++;return this._tappers.set(W,$),this._onNumberOfTappersChangeListener&&this._onNumberOfTappersChangeListener(this._tappers.size),()=>{this._removeTapperById(W)}}_removeTapperById($){const W=this._tappers.size;this._tappers.delete($);W!==this._tappers.size&&this._onNumberOfTappersChangeListener&&this._onNumberOfTappersChangeListener(this._tappers.size)}emit($){this._tappers.forEach((W=>{W($)}))}hasTappers(){return 0!==this._tappers.size}onNumberOfTappersChange($){this._onNumberOfTappersChangeListener=$}};function isDerivation($){return $&&$.isDerivation&&!0===$.isDerivation}(ge=he||(he={}))[ge.none=0]="none",ge[ge.dep=1]="dep",ge[ge.inner=2]="inner";var makeFlatMapDerivationClass=()=>{class FlatMapDerivation extends Je{constructor($,W){return super(),this._depDerivation=$,this._fn=W,this._innerDerivation=void 0,this._staleDependency=1,this._addDependency($),this}_recalculateHot(){const $=this._staleDependency;if(this._staleDependency=0,2===$)return this._innerDerivation.getValue();const W=this._fn(this._depDerivation.getValue());return isDerivation(W)?(this._innerDerivation=W,this._addDependency(W),W.getValue()):W}_recalculateCold(){const $=this._fn(this._depDerivation.getValue());return isDerivation($)?$.getValue():$}_recalculate(){return this.isHot?this._recalculateHot():this._recalculateCold()}_reactToDependencyBecomingStale($){const W=$===this._depDerivation?1:2;if(2===W&&$!==this._innerDerivation)throw Error("got a _reactToDependencyBecomingStale() from neither the dep nor the inner derivation");0===this._staleDependency?(this._staleDependency=W,1===W&&this._removeInnerDerivation()):1===this._staleDependency||1===W&&(this._staleDependency=1,this._removeInnerDerivation())}_removeInnerDerivation(){this._innerDerivation&&(this._removeDependency(this._innerDerivation),this._innerDerivation=void 0)}_keepHot(){this._staleDependency=1,this.getValue()}_becomeCold(){this._staleDependency=1,this._removeInnerDerivation()}}return FlatMapDerivation.displayName="flatMap",FlatMapDerivation},je=void 0;var makeMapDerivationClass=()=>class MapDerivation extends Je{constructor($,W){super(),this._dep=$,this._fn=W,this._addDependency($)}_recalculate(){return this._fn(this._dep.getValue())}_reactToDependencyBecomingStale(){}},Ie=void 0;var De=class{constructor(){this._head=void 0}peek(){return this._head&&this._head.data}pop(){const $=this._head;if($)return this._head=$.next,$.data}push($){const W={next:this._head,data:$};this._head=W}};function createMechanism(){const $=new De,noopCollector=()=>{};return{type:"Dataverse_discoveryMechanism",startIgnoringDependencies:()=>{$.push(noopCollector)},stopIgnoringDependencies:()=>{$.peek()!==noopCollector||$.pop()},reportResolutionStart:W=>{const G=$.peek();G&&G(W),$.push(noopCollector)},reportResolutionEnd:W=>{$.pop()},pushCollector:W=>{$.push(W)},popCollector:W=>{if($.peek()!==W)throw new Error("Popped collector is not on top of the stack");$.pop()}}}var{startIgnoringDependencies:$e,stopIgnoringDependencies:Le,reportResolutionEnd:Ke,reportResolutionStart:Ge,pushCollector:Xe,popCollector:Ye}=function getSharedMechanism(){const $="__dataverse_discoveryMechanism_sharedStack";if(window){const W=window[$];if(W&&"object"==typeof W&&"Dataverse_discoveryMechanism"===W.type)return W;{const W=createMechanism();return window[$]=W,W}}return createMechanism()}(),Je=class{constructor(){this.isDerivation=!0,this._didMarkDependentsAsStale=!1,this._isHot=!1,this._isFresh=!1,this._lastValue=void 0,this._dependents=new Set,this._dependencies=new Set,this._internal_markAsStale=$=>{this._reactToDependencyBecomingStale($),this._didMarkDependentsAsStale||(this._didMarkDependentsAsStale=!0,this._isFresh=!1,this._dependents.forEach(($=>{$(this)})))}}get isHot(){return this._isHot}_addDependency($){this._dependencies.has($)||(this._dependencies.add($),this._isHot&&$.addDependent(this._internal_markAsStale))}_removeDependency($){this._dependencies.has($)&&(this._dependencies.delete($),this._isHot&&$.removeDependent(this._internal_markAsStale))}changes($){return new class{constructor($,W){return this._possiblyMarkAsStale=()=>{this._ticker.onThisOrNextTick(this._refresh)},this._refresh=()=>{const $=this._derivation.getValue();$===this._lastValue&&!0===this._lastValueRecorded||(this._lastValue=$,this._lastValueRecorded=!0,this._emitter.emit($))},this._derivation=$,this._ticker=W,this._emitter=new Pe,this._emitter.onNumberOfTappersChange((()=>{this._reactToNumberOfTappersChange()})),this._hadTappers=!1,this._lastValueRecorded=!1,this._lastValue=void 0,this}_reactToNumberOfTappersChange(){const $=this._emitter.hasTappers();$!==this._hadTappers&&(this._hadTappers=$,$?this._derivation.addDependent(this._possiblyMarkAsStale):this._derivation.removeDependent(this._possiblyMarkAsStale))}tappable(){return this._emitter.tappable}}(this,$).tappable()}changesWithoutValues(){return new class{constructor($,W=!1){return this.dontEmitValues=W,this._possiblyMarkAsStale=()=>{this._emitter.emit(void 0)},this._derivation=$,this._emitter=new Pe,this._emitter.onNumberOfTappersChange((()=>{this._reactToNumberOfTappersChange()})),this._hadTappers=!1,this}_reactToNumberOfTappersChange(){const $=this._emitter.hasTappers();$!==this._hadTappers&&(this._hadTappers=$,$?this._derivation.addDependent(this._possiblyMarkAsStale):this._derivation.removeDependent(this._possiblyMarkAsStale))}tappable(){return this._emitter.tappable}}(this).tappable()}keepHot(){return this.changesWithoutValues().tap((()=>{}))}tapImmediate($,W){const G=this.changes($).tap(W);return W(this.getValue()),G}addDependent($){const W=this._dependents.size>0;this._dependents.add($);W!==this._dependents.size>0&&this._reactToNumberOfDependentsChange()}removeDependent($){const W=this._dependents.size>0;this._dependents.delete($);W!==this._dependents.size>0&&this._reactToNumberOfDependentsChange()}_markAsStale($){this._internal_markAsStale($)}getValue(){if(Ge(this),!this._isFresh){const $=this._recalculate();this._lastValue=$,this._isHot&&(this._isFresh=!0,this._didMarkDependentsAsStale=!1)}return Ke(this),this._lastValue}_reactToNumberOfDependentsChange(){const $=this._dependents.size>0;$!==this._isHot&&(this._isHot=$,this._didMarkDependentsAsStale=!1,this._isFresh=!1,$?(this._dependencies.forEach(($=>{$.addDependent(this._internal_markAsStale)})),this._keepHot()):(this._dependencies.forEach(($=>{$.removeDependent(this._internal_markAsStale)})),this._becomeCold()))}_keepHot(){}_becomeCold(){}map($){return function flatMap2($,W){return Ie||(Ie=makeMapDerivationClass()),new Ie($,W)}(this,$)}flatMap($){return function flatMap($,W){return je||(je=makeFlatMapDerivationClass()),new je($,W)}(this,$)}},noop=()=>{},Qe=class extends Je{constructor($,W){super(),this._tapToSource=$,this._getValueFromSource=W,this._untapFromChanges=noop,this._cachedValue=void 0,this._hasCachedValue=!1}_recalculate(){return this.isHot?(this._hasCachedValue||(this._cachedValue=this._getValueFromSource(),this._hasCachedValue=!0),this._cachedValue):this._getValueFromSource()}_keepHot(){this._hasCachedValue=!1,this._cachedValue=void 0,this._untapFromChanges=this._tapToSource(($=>{this._hasCachedValue=!0,this._cachedValue=$,this._markAsStale(this)}))}_becomeCold(){this._untapFromChanges(),this._untapFromChanges=noop,this._hasCachedValue=!1,this._cachedValue=void 0}_reactToDependencyBecomingStale(){}},Ze=new WeakMap,et=Symbol("pointerMeta"),tt=new WeakMap,rt={get($,W){if(W===et)return Ze.get($);let G=tt.get($);if(G||(G={},tt.set($,G)),G[W])return G[W];const oe=Ze.get($),ae=pointer({root:oe.root,path:[...oe.path,W]});return G[W]=ae,ae}},getPointerMeta=$=>$[et],getPointerParts=$=>{const{root:W,path:G}=getPointerMeta($);return{root:W,path:G}};function pointer($){var W;const G={root:$.root,path:null!=(W=$.path)?W:[]},oe={};return Ze.set(oe,G),new Proxy(oe,rt)}var nt=pointer,isPointer=$=>$&&!!getPointerMeta($);var ot,at,hoop=($,W,G)=>{if(0===W.length)return G($);if(Array.isArray($)){let[oe,...ae]=W;oe=parseInt(String(oe),10),isNaN(oe)&&(oe=0);const ie=$[oe],se=hoop(ie,ae,G);if(ie===se)return $;const le=[...$];return le.splice(oe,1,se),le}if("object"==typeof $&&null!==$){const[ae,...se]=W,ue=$[ae],he=hoop(ue,se,G);if(ue===he)return $;const ge=(($,W)=>oe($,ie(W)))((($,W)=>{for(var G in W||(W={}))de.call(W,G)&&__defNormalProp($,G,W[G]);if(le)for(var G of le(W))pe.call(W,G)&&__defNormalProp($,G,W[G]);return $})({},$),{[ae]:he});return ge}{const[$,...oe]=W;return{[$]:hoop(void 0,oe,G)}}};(at=ot||(ot={}))[at.Dict=0]="Dict",at[at.Array=1]="Array",at[at.Other=2]="Other";var getTypeOfValue=$=>Array.isArray($)?1:(0,we.default)($)?0:2,getKeyOfValue=($,W,G=getTypeOfValue($))=>0===G&&"string"==typeof W||1===G&&isValidArrayIndex(W)?$[W]:void 0,isValidArrayIndex=$=>{const W="number"==typeof $?$:parseInt($,10);return!isNaN(W)&&W>=0&&W<1/0&&(0|W)===W},it=class{constructor($,W){this._parent=$,this._path=W,this.children=new Map,this.identityChangeListeners=new Set}addIdentityChangeListener($){this.identityChangeListeners.add($)}removeIdentityChangeListener($){this.identityChangeListeners.delete($),this._checkForGC()}removeChild($){this.children.delete($),this._checkForGC()}getChild($){return this.children.get($)}getOrCreateChild($){let W=this.children.get($);return W||(W=W=new it(this,this._path.concat([$])),this.children.set($,W)),W}_checkForGC(){this.identityChangeListeners.size>0||this.children.size>0||this._parent&&this._parent.removeChild((0,Se.default)(this._path))}},lt=class{constructor($){this.$$isIdentityDerivationProvider=!0,this.reduceState=($,W)=>{const G=function updateDeep($,W,G){return 0===W.length?G($):hoop($,W,G)}(this.getState(),$,W);return this.setState(G),G},this._onPathValueChange=($,W)=>{const G=this._getOrCreateScopeForPath($);G.identityChangeListeners.add(W);return()=>{G.identityChangeListeners.delete(W)}},this._currentState=$,this._rootScope=new it(void 0,[]),this.pointer=nt({root:this,path:[]})}setState($){const W=this._currentState;this._currentState=$,this._checkUpdates(this._rootScope,W,$)}getState(){return this._currentState}getIn($){return 0===$.length?this.getState():(0,ve.default)(this.getState(),$)}setIn($,W){return this.reduceState($,(()=>W))}_checkUpdates($,W,G){if(W===G)return;if($.identityChangeListeners.forEach(($=>$(G))),0===$.children.size)return;const oe=getTypeOfValue(W),ae=getTypeOfValue(G);2===oe&&oe===ae||$.children.forEach((($,ie)=>{const se=getKeyOfValue(W,ie,oe),le=getKeyOfValue(G,ie,ae);this._checkUpdates($,se,le)}))}_getOrCreateScopeForPath($){let W=this._rootScope;for(const G of $)W=W.getOrCreateChild(G);return W}getIdentityDerivation($){return new Qe((W=>this._onPathValueChange($,W)),(()=>this.getIn($)))}},ut=new WeakMap,valueDerivation=$=>{const W=getPointerMeta($);let G=ut.get(W);if(!G){const $=W.root;if(!function isIdentityChangeProvider($){return"object"==typeof $&&null!==$&&!0===$.$$isIdentityDerivationProvider}($))throw new Error("Cannot run valueDerivation() on a pointer whose root is not an IdentityChangeProvider");const{path:oe}=W;G=$.getIdentityDerivation(oe),ut.set(W,G)}return G};var val=$=>isPointer($)?valueDerivation($).getValue():isDerivation($)?$.getValue():$,ct=class{constructor($){this._value=$,this._emitter=new Pe,this._publicDerivation=new Qe(($=>this._emitter.tappable.tap($)),this.get.bind(this))}set($){$!==this._value&&(this._value=$,this._emitter.emit($))}get(){return this._value}get derivation(){return this._publicDerivation}},dt=class extends Je{constructor($){return super(),this._v=$,this}_recalculate(){return this._v}_reactToDependencyBecomingStale(){}};function*iterateAndCountTicks($){let W;if(isPointer($))W=valueDerivation($);else{if(!isDerivation($))throw new Error("Only pointers and derivations are supported");W=$}let G=0;const oe=W.changesWithoutValues().tap((()=>{G++}));try{for(;;){const $=G;G=0,yield{value:W.getValue(),ticks:$}}}finally{oe()}}var ft=class{constructor(){this._ticking=!1,this._scheduledForThisOrNextTick=new Set,this._scheduledForNextTick=new Set,this._timeAtCurrentTick=0}onThisOrNextTick($){this._scheduledForThisOrNextTick.add($)}onNextTick($){this._scheduledForNextTick.add($)}offThisOrNextTick($){this._scheduledForThisOrNextTick.delete($)}offNextTick($){this._scheduledForNextTick.delete($)}get time(){return this._ticking?this._timeAtCurrentTick:performance.now()}tick($=performance.now()){this._ticking=!0,this._timeAtCurrentTick=$,this._scheduledForNextTick.forEach(($=>this._scheduledForThisOrNextTick.add($))),this._scheduledForNextTick.clear(),this._tick(0),this._ticking=!1}_tick($){const W=this.time;if($>10&&console.warn("_tick() recursing for 10 times"),$>100)throw new Error("Maximum recursion limit for _tick()");const G=this._scheduledForThisOrNextTick;if(this._scheduledForThisOrNextTick=new Set,G.forEach(($=>{$(W)})),this._scheduledForThisOrNextTick.size>0)return this._tick($+1)}};function*iterateOver($){let W;if(isPointer($))W=valueDerivation($);else{if(!isDerivation($))throw new Error("Only pointers and derivations are supported");W=$}const G=new ft,oe=W.changes(G).tap(($=>{}));try{for(;;)G.tick(),yield W.getValue()}finally{oe()}}var voidFn=()=>{},pt=class extends Je{constructor($){super(),this._fn=$,this._cacheOfDendencyValues=new Map,this._possiblyStaleDeps=new Set,this._prismScope=new gt}_recalculate(){let $;if(this._possiblyStaleDeps.size>0){let $=!1;$e();for(const W of this._possiblyStaleDeps)if(this._cacheOfDendencyValues.get(W)!==W.getValue()){$=!0;break}if(Le(),this._possiblyStaleDeps.clear(),!$)return this._lastValue}const W=new Set;this._cacheOfDendencyValues.clear();const collector=$=>{W.add($),this._addDependency($)};Xe(collector),vt.push(this._prismScope);try{$=this._fn()}catch($){console.error($)}finally{vt.pop()!==this._prismScope&&console.warn("The Prism hook stack has slipped. This is a bug.")}return Ye(collector),this._dependencies.forEach(($=>{W.has($)||this._removeDependency($)})),this._dependencies=W,$e(),W.forEach(($=>{this._cacheOfDendencyValues.set($,$.getValue())})),Le(),$}_reactToDependencyBecomingStale($){this._possiblyStaleDeps.add($)}_keepHot(){this._prismScope=new gt,$e(),this.getValue(),Le()}_becomeCold(){cleanupScopeStack(this._prismScope),this._prismScope=new gt}},gt=class{constructor(){this.isPrismScope=!0,this._subs={}}sub($){return this._subs[$]||(this._subs[$]=new gt),this._subs[$]}get subs(){return this._subs}};function cleanupScopeStack($){for(const[W,G]of Object.entries($.subs))cleanupScopeStack(G);!function cleanupEffects($){const W=bt.get($);if(W)for(const $ of Object.keys(W)){safelyRun(W[$].cleanup,void 0)}bt.delete($)}($)}function safelyRun($,W){let G=W,oe=!1;try{G=$(),oe=!0}catch($){setTimeout((()=>{throw $}))}return{success:oe,returnValue:G}}var vt=new De,yt=new WeakMap,bt=new WeakMap,wt=new WeakMap;function depsHaveChanged($,W){return void 0===$||void 0===W||($.length!==W.length||$.some((($,G)=>$!==W[G])))}function memo($,W,G){const oe=vt.peek();if(!oe)throw new Error("prism.memo() is called outside of a prism() call.");let ae=wt.get(oe);ae||(ae={},wt.set(oe,ae)),ae[$]||(ae[$]={cachedValue:null,deps:[{}]});const ie=ae[$];return depsHaveChanged(ie.deps,G)&&($e(),ie.cachedValue=safelyRun(W,void 0).returnValue,Le(),ie.deps=G),ie.cachedValue}var prism=$=>new pt($);prism.ref=function ref($,W){const G=vt.peek();if(!G)throw new Error("prism.ref() is called outside of a prism() call.");let oe=yt.get(G);if(oe||(oe={},yt.set(G,oe)),oe[$])return oe[$];{const G={current:W};return oe[$]=G,G}},prism.effect=function effect($,W,G){const oe=vt.peek();if(!oe)throw new Error("prism.effect() is called outside of a prism() call.");let ae=bt.get(oe);ae||(ae={},bt.set(oe,ae)),ae[$]||(ae[$]={cleanup:voidFn,deps:[{}]});const ie=ae[$];depsHaveChanged(ie.deps,G)&&(ie.cleanup(),$e(),ie.cleanup=safelyRun(W,voidFn).returnValue,Le(),ie.deps=G)},prism.memo=memo,prism.ensurePrism=function ensurePrism(){if(!vt.peek())throw new Error("The parent function is called outside of a prism() call.")},prism.state=function state($,W){const{b:G,setValue:oe}=prism.memo("state/"+$,(()=>{const $=new ct(W);return{b:$,setValue:W=>$.set(W)}}),[]);return[G.derivation.getValue(),oe]},prism.scope=function scope($,W){const G=vt.peek();if(!G)throw new Error("prism.scope() is called outside of a prism() call.");const oe=G.sub($);vt.push(oe);const ae=safelyRun(W,void 0).returnValue;return vt.pop(),ae},prism.sub=function sub($,W,G){return memo($,(()=>prism(W)),G).getValue()},prism.inPrism=function inPrism(){return!!vt.peek()};var St=prism,xt=class{constructor($){this.$$isIdentityDerivationProvider=!0,this._currentPointerBox=new ct($),this.pointer=nt({root:this,path:[]})}setPointer($){this._currentPointerBox.set($)}getIdentityDerivation($){return this._currentPointerBox.derivation.flatMap((W=>{const G=$.reduce((($,W)=>$[W]),W);return valueDerivation(G)}))}}}(W),function($){var G=Object.create,oe=Object.defineProperty,ae=Object.defineProperties,ie=Object.getOwnPropertyDescriptor,se=Object.getOwnPropertyDescriptors,le=Object.getOwnPropertyNames,ue=Object.getOwnPropertySymbols,de=Object.getPrototypeOf,pe=Object.prototype.hasOwnProperty,he=Object.prototype.propertyIsEnumerable,__defNormalProp=($,W,G)=>W in $?oe($,W,{enumerable:!0,configurable:!0,writable:!0,value:G}):$[W]=G,__spreadValues=($,W)=>{for(var G in W||(W={}))pe.call(W,G)&&__defNormalProp($,G,W[G]);if(ue)for(var G of ue(W))he.call(W,G)&&__defNormalProp($,G,W[G]);return $},__spreadProps=($,W)=>ae($,se(W)),__markAsModule=$=>oe($,"__esModule",{value:!0}),__commonJS=($,W)=>function __require(){return W||(0,$[Object.keys($)[0]])((W={exports:{}}).exports,W),W.exports},__export=($,W)=>{for(var G in __markAsModule($),W)oe($,G,{get:W[G],enumerable:!0})},__toModule=$=>(($,W,G)=>{if(W&&"object"==typeof W||"function"==typeof W)for(let ae of le(W))pe.call($,ae)||"default"===ae||oe($,ae,{get:()=>W[ae],enumerable:!(G=ie(W,ae))||G.enumerable});return $})(__markAsModule(oe(null!=$?G(de($)):{},"default",$&&$.__esModule&&"default"in $?{get:()=>$.default,enumerable:!0}:{value:$,enumerable:!0})),$),__publicField=($,W,G)=>(__defNormalProp($,"symbol"!=typeof W?W+"":W,G),G),ge=__commonJS({"../node_modules/timing-function/lib/UnitBezier.js"($,W){W.exports=function(){function UnitBezier3($,W,G,oe){this.set($,W,G,oe)}return UnitBezier3.prototype.set=function($,W,G,oe){this._cx=3*$,this._bx=3*(G-$)-this._cx,this._ax=1-this._cx-this._bx,this._cy=3*W,this._by=3*(oe-W)-this._cy,this._ay=1-this._cy-this._by},UnitBezier3.epsilon=1e-6,UnitBezier3.prototype._sampleCurveX=function($){return((this._ax*$+this._bx)*$+this._cx)*$},UnitBezier3.prototype._sampleCurveY=function($){return((this._ay*$+this._by)*$+this._cy)*$},UnitBezier3.prototype._sampleCurveDerivativeX=function($){return(3*this._ax*$+2*this._bx)*$+this._cx},UnitBezier3.prototype._solveCurveX=function($,W){var G,oe,ae,ie,se,le;for(ae=void 0,ie=void 0,se=void 0,le=void 0,G=void 0,oe=void 0,se=$,oe=0;oe<8;){if(le=this._sampleCurveX(se)-$,Math.abs(le)<W)return se;if(G=this._sampleCurveDerivativeX(se),Math.abs(G)<W)break;se-=le/G,oe++}if((se=$)<(ae=0))return ae;if(se>(ie=1))return ie;for(;ae<ie;){if(le=this._sampleCurveX(se),Math.abs(le-$)<W)return se;$>le?ae=se:ie=se,se=.5*(ie-ae)+ae}return se},UnitBezier3.prototype.solve=function($,W){return this._sampleCurveY(this._solveCurveX($,W))},UnitBezier3.prototype.solveSimple=function($){return this._sampleCurveY(this._solveCurveX($,1e-6))},UnitBezier3}()}}),ve=__commonJS({"../node_modules/levenshtein-edit-distance/index.js"($,W){var G,oe;G=[],oe=[],W.exports=function levenshtein($,W,ae){var ie,se,le,ue,de,pe,he,ge;if($===W)return 0;if(ie=$.length,se=W.length,0===ie)return se;if(0===se)return ie;for(ae&&($=$.toLowerCase(),W=W.toLowerCase()),he=0;he<ie;)oe[he]=$.charCodeAt(he),G[he]=++he;for(ge=0;ge<se;)for(le=W.charCodeAt(ge),ue=de=ge++,he=-1;++he<ie;)pe=le===oe[he]?de:de+1,de=G[he],G[he]=ue=de>ue?pe>ue?ue+1:pe:pe>de?de+1:pe;return ue}}}),we=__commonJS({"../node_modules/propose/propose.js"($,W){var G=ve();W.exports=function propose2(){var $,W,oe,ae,ie,se=0,le=arguments[0],ue=arguments[1],de=ue.length,pe=arguments[2];pe&&(ae=pe.threshold,ie=pe.ignoreCase),void 0===ae&&(ae=0);for(var he=0;he<de;++he)($=(W=ie?G(le,ue[he],!0):G(le,ue[he]))>le.length?1-W/ue[he].length:1-W/le.length)>se&&(se=$,oe=ue[he]);return se>=ae?oe:null}}}),Se=__commonJS({"../node_modules/fast-deep-equal/index.js"($,W){W.exports=function equal($,W){if($===W)return!0;if($&&W&&"object"==typeof $&&"object"==typeof W){if($.constructor!==W.constructor)return!1;var G,oe,ae;if(Array.isArray($)){if((G=$.length)!=W.length)return!1;for(oe=G;0!=oe--;)if(!equal($[oe],W[oe]))return!1;return!0}if($.constructor===RegExp)return $.source===W.source&&$.flags===W.flags;if($.valueOf!==Object.prototype.valueOf)return $.valueOf()===W.valueOf();if($.toString!==Object.prototype.toString)return $.toString()===W.toString();if((G=(ae=Object.keys($)).length)!==Object.keys(W).length)return!1;for(oe=G;0!=oe--;)if(!Object.prototype.hasOwnProperty.call(W,ae[oe]))return!1;for(oe=G;0!=oe--;){var ie=ae[oe];if(!equal($[ie],W[ie]))return!1}return!0}return $!=$&&W!=W}}});__export($,{getProject:()=>getProject,onChange:()=>onChange,types:()=>Jn,val:()=>val6});var Pe={};__export(Pe,{getProject:()=>getProject,onChange:()=>onChange,types:()=>Jn,val:()=>val6});var je=__toModule(W),Ie=new class{constructor(){__publicField(this,"atom",new je.Atom({projects:{}}))}add($,W){this.atom.reduceState(["projects",$],(()=>W))}get($){return this.atom.getState().projects[$]}has($){return!!this.get($)}},De=Ie,$e=new WeakMap;function privateAPI($){return $e.get($)}function setPrivateAPI($,W){$e.set($,W)}var Le=[],Ke=Array.isArray,Ge="object"==typeof window&&window&&window.Object===Object&&window,Xe="object"==typeof self&&self&&self.Object===Object&&self,Ye=Ge||Xe||Function("return this")(),Je=Ye.Symbol,Qe=Object.prototype,Ze=Qe.hasOwnProperty,et=Qe.toString,tt=Je?Je.toStringTag:void 0;var rt=function getRawTag($){var W=Ze.call($,tt),G=$[tt];try{$[tt]=void 0;var oe=!0}catch($){}var ae=et.call($);return oe&&(W?$[tt]=G:delete $[tt]),ae},nt=Object.prototype.toString;var ot=function objectToString($){return nt.call($)},at=Je?Je.toStringTag:void 0;var it=function baseGetTag($){return null==$?void 0===$?"[object Undefined]":"[object Null]":at&&at in Object($)?rt($):ot($)};var st=function isObjectLike($){return null!=$&&"object"==typeof $};var lt=function isSymbol($){return"symbol"==typeof $||st($)&&"[object Symbol]"==it($)},ut=/\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/,ct=/^\w*$/;var dt=function isKey($,W){if(Ke($))return!1;var G=typeof $;return!("number"!=G&&"symbol"!=G&&"boolean"!=G&&null!=$&&!lt($))||(ct.test($)||!ut.test($)||null!=W&&$ in Object(W))};var ft=function isObject($){var W=typeof $;return null!=$&&("object"==W||"function"==W)};var pt=function isFunction($){if(!ft($))return!1;var W=it($);return"[object Function]"==W||"[object GeneratorFunction]"==W||"[object AsyncFunction]"==W||"[object Proxy]"==W},ht=Ye["__core-js_shared__"],mt=function(){var $=/[^.]+$/.exec(ht&&ht.keys&&ht.keys.IE_PROTO||"");return $?"Symbol(src)_1."+$:""}();var gt=function isMasked($){return!!mt&&mt in $},vt=Function.prototype.toString;var yt=function toSource($){if(null!=$){try{return vt.call($)}catch($){}try{return $+""}catch($){}}return""},bt=/^\[object .+?Constructor\]$/,wt=Function.prototype,St=Object.prototype,xt=wt.toString,kt=St.hasOwnProperty,_t=RegExp("^"+xt.call(kt).replace(/[\\^$.*+?()[\]{}|]/g,"\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g,"$1.*?")+"$");var Pt=function baseIsNative($){return!(!ft($)||gt($))&&(pt($)?_t:bt).test(yt($))};var Et=function getValue($,W){return null==$?void 0:$[W]};var jt=function getNative($,W){var G=Et($,W);return Pt(G)?G:void 0},Ct=jt(Object,"create");var Ot=function hashClear(){this.__data__=Ct?Ct(null):{},this.size=0};var It=function hashDelete($){var W=this.has($)&&delete this.__data__[$];return this.size-=W?1:0,W},Tt=Object.prototype.hasOwnProperty;var Dt=function hashGet($){var W=this.__data__;if(Ct){var G=W[$];return"__lodash_hash_undefined__"===G?void 0:G}return Tt.call(W,$)?W[$]:void 0},At=Object.prototype.hasOwnProperty;var $t=function hashHas($){var W=this.__data__;return Ct?void 0!==W[$]:At.call(W,$)};var zt=function hashSet($,W){var G=this.__data__;return this.size+=this.has($)?0:1,G[$]=Ct&&void 0===W?"__lodash_hash_undefined__":W,this};function Hash($){var W=-1,G=null==$?0:$.length;for(this.clear();++W<G;){var oe=$[W];this.set(oe[0],oe[1])}}Hash.prototype.clear=Ot,Hash.prototype.delete=It,Hash.prototype.get=Dt,Hash.prototype.has=$t,Hash.prototype.set=zt;var Mt=Hash;var Rt=function listCacheClear(){this.__data__=[],this.size=0};var Bt=function eq($,W){return $===W||$!=$&&W!=W};var Ft=function assocIndexOf($,W){for(var G=$.length;G--;)if(Bt($[G][0],W))return G;return-1},Nt=Array.prototype.splice;var Lt=function listCacheDelete($){var W=this.__data__,G=Ft(W,$);return!(G<0)&&(G==W.length-1?W.pop():Nt.call(W,G,1),--this.size,!0)};var Ht=function listCacheGet($){var W=this.__data__,G=Ft(W,$);return G<0?void 0:W[G][1]};var Vt=function listCacheHas($){return Ft(this.__data__,$)>-1};var qt=function listCacheSet($,W){var G=this.__data__,oe=Ft(G,$);return oe<0?(++this.size,G.push([$,W])):G[oe][1]=W,this};function ListCache($){var W=-1,G=null==$?0:$.length;for(this.clear();++W<G;){var oe=$[W];this.set(oe[0],oe[1])}}ListCache.prototype.clear=Rt,ListCache.prototype.delete=Lt,ListCache.prototype.get=Ht,ListCache.prototype.has=Vt,ListCache.prototype.set=qt;var Ut=ListCache,Kt=jt(Ye,"Map");var Wt=function mapCacheClear(){this.size=0,this.__data__={hash:new Mt,map:new(Kt||Ut),string:new Mt}};var Gt=function isKeyable($){var W=typeof $;return"string"==W||"number"==W||"symbol"==W||"boolean"==W?"__proto__"!==$:null===$};var Xt=function getMapData($,W){var G=$.__data__;return Gt(W)?G["string"==typeof W?"string":"hash"]:G.map};var Yt=function mapCacheDelete($){var W=Xt(this,$).delete($);return this.size-=W?1:0,W};var Jt=function mapCacheGet($){return Xt(this,$).get($)};var Qt=function mapCacheHas($){return Xt(this,$).has($)};var Zt=function mapCacheSet($,W){var G=Xt(this,$),oe=G.size;return G.set($,W),this.size+=G.size==oe?0:1,this};function MapCache($){var W=-1,G=null==$?0:$.length;for(this.clear();++W<G;){var oe=$[W];this.set(oe[0],oe[1])}}MapCache.prototype.clear=Wt,MapCache.prototype.delete=Yt,MapCache.prototype.get=Jt,MapCache.prototype.has=Qt,MapCache.prototype.set=Zt;var er=MapCache;function memoize($,W){if("function"!=typeof $||null!=W&&"function"!=typeof W)throw new TypeError("Expected a function");var memoized=function(){var G=arguments,oe=W?W.apply(this,G):G[0],ae=memoized.cache;if(ae.has(oe))return ae.get(oe);var ie=$.apply(this,G);return memoized.cache=ae.set(oe,ie)||ae,ie};return memoized.cache=new(memoize.Cache||er),memoized}memoize.Cache=er;var tr=memoize;var rr=/[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g,nr=/\\(\\)?/g,or=function memoizeCapped($){var W=tr($,(function($){return 500===G.size&&G.clear(),$})),G=W.cache;return W}((function($){var W=[];return 46===$.charCodeAt(0)&&W.push(""),$.replace(rr,(function($,G,oe,ae){W.push(oe?ae.replace(nr,"$1"):G||$)})),W}));var ar=function arrayMap($,W){for(var G=-1,oe=null==$?0:$.length,ae=Array(oe);++G<oe;)ae[G]=W($[G],G,$);return ae},ir=Je?Je.prototype:void 0,sr=ir?ir.toString:void 0;var lr=function baseToString($){if("string"==typeof $)return $;if(Ke($))return ar($,baseToString)+"";if(lt($))return sr?sr.call($):"";var W=$+"";return"0"==W&&1/$==-Infinity?"-0":W};var ur=function toString($){return null==$?"":lr($)};var cr=function castPath($,W){return Ke($)?$:dt($,W)?[$]:or(ur($))};var dr=function toKey($){if("string"==typeof $||lt($))return $;var W=$+"";return"0"==W&&1/$==-Infinity?"-0":W};var fr=function baseGet($,W){for(var G=0,oe=(W=cr(W,$)).length;null!=$&&G<oe;)$=$[dr(W[G++])];return G&&G==oe?$:void 0};var pr=function get($,W,G){var oe=null==$?void 0:fr($,W);return void 0===oe?G:oe};var hr=class{constructor(){__publicField(this,"_values",{})}get($,W){if(this.has($))return this._values[$];{const G=W();return this._values[$]=G,G}}has($){return this._values.hasOwnProperty($)}},mr=__toModule(W),gr=function(){try{var $=jt(Object,"defineProperty");return $({},"",{}),$}catch($){}}();var vr=function baseAssignValue($,W,G){"__proto__"==W&&gr?gr($,W,{configurable:!0,enumerable:!0,value:G,writable:!0}):$[W]=G},yr=Object.prototype.hasOwnProperty;var br=function assignValue($,W,G){var oe=$[W];yr.call($,W)&&Bt(oe,G)&&(void 0!==G||W in $)||vr($,W,G)},wr=/^(?:0|[1-9]\d*)$/;var Sr=function isIndex($,W){var G=typeof $;return!!(W=null==W?9007199254740991:W)&&("number"==G||"symbol"!=G&&wr.test($))&&$>-1&&$%1==0&&$<W};var xr=function baseSet($,W,G,oe){if(!ft($))return $;for(var ae=-1,ie=(W=cr(W,$)).length,se=ie-1,le=$;null!=le&&++ae<ie;){var ue=dr(W[ae]),de=G;if("__proto__"===ue||"constructor"===ue||"prototype"===ue)return $;if(ae!=se){var pe=le[ue];void 0===(de=oe?oe(pe,ue,le):void 0)&&(de=ft(pe)?pe:Sr(W[ae+1])?[]:{})}br(le,ue,de),le=le[ue]}return $};var kr=function set($,W,G){return null==$?$:xr($,W,G)},_r=new WeakMap;function getDefaultsOfPropTypeConfig($){if(_r.has($))return _r.get($);const W="compound"===$.type?function generateDefaultsForCompound($){const W={};for(const[G,oe]of Object.entries($.props))W[G]=getDefaultsOfPropTypeConfig(oe);return W}($):"enum"===$.type?function generateDefaultsForEnum($){const W={$case:$.defaultCase};for(const[G,oe]of Object.entries($.cases))W[G]=getDefaultsOfPropTypeConfig(oe);return W}($):$.default;return _r.set($,W),W}var Pr=__toModule(W),Er={log:console.log,warn:console.warn,error:console.error,trace:console.trace},jr=__toModule(ge());function trackValueAtTime($,W){return(0,Pr.prism)((()=>{const G=(0,Pr.val)($),oe=Pr.prism.memo("driver",(()=>G?"BasicKeyframedTrack"===G.type?function trackValueAtTime_basicKeyframedTrack($,W){return(0,Pr.prism)((()=>{let G=Pr.prism.ref("state",{started:!1}),oe=G.current;const ae=W.getValue();return(!oe.started||ae<oe.validFrom||oe.validTo<=ae)&&(G.current=oe=pp(W,$)),oe.der.getValue()}))}(G,W):(Er.error("Track type not yet supported."),new Pr.ConstantDerivation(void 0)):new Pr.ConstantDerivation(void 0)),[G]);return oe.getValue()}))}var Cr=new Pr.ConstantDerivation(void 0),pp=($,W)=>{const G=$.getValue();if(0===W.keyframes.length)return{started:!0,validFrom:-1/0,validTo:1/0,der:Cr};let oe=0;for(;;){const ae=W.keyframes[oe];if(!ae)return Or.error;const ie=oe===W.keyframes.length-1;if(G<ae.position)return 0===oe?Or.beforeFirstKeyframe(ae):Or.error;if(ae.position===G)return ie?Or.lastKeyframe(ae):Or.between(ae,W.keyframes[oe+1],$);if(oe===W.keyframes.length-1)return Or.lastKeyframe(ae);{const ie=oe+1;if(W.keyframes[ie].position<=G){oe=ie;continue}return Or.between(ae,W.keyframes[oe+1],$)}}},Or={beforeFirstKeyframe:$=>({started:!0,validFrom:-1/0,validTo:$.position,der:new Pr.ConstantDerivation($.value)}),lastKeyframe:$=>({started:!0,validFrom:$.position,validTo:1/0,der:new Pr.ConstantDerivation($.value)}),between($,W,G){if(!$.connectedRight)return{started:!0,validFrom:$.position,validTo:W.position,der:new Pr.ConstantDerivation($.value)};const oe=new jr.default($.handles[2],$.handles[3],W.handles[0],W.handles[1]),ae=(0,Pr.prism)((()=>{const ae=(G.getValue()-$.position)/(W.position-$.position);const ie=oe.solveSimple(ae);return $.value+ie*(W.value-$.value)}));return{started:!0,validFrom:$.position,validTo:W.position,der:ae}},error:{started:!0,validFrom:-1/0,validTo:1/0,der:Cr}};function deepMergeWithCache($,W,G){const oe=G.get($);if(oe&&oe.override===W)return oe.merged;const ae=__spreadValues({},$);for(const oe of Object.keys(W)){const ie=W[oe],se=$[oe];ae[oe]="object"==typeof ie&&"object"==typeof se?deepMergeWithCache(se,ie,G):void 0===ie?se:ie}return G.set($,{override:W,merged:ae}),ae}function pointerDeep($,W){let G=$;for(const $ of W)G=G[$];return G}var Ir=__toModule(W),Tr=__toModule(W),Dr=new(__toModule(W).Ticker),Ar=Dr,onAnimationFrame=$=>{Dr.tick($),window.requestAnimationFrame(onAnimationFrame)};window.requestAnimationFrame(onAnimationFrame);var $r=__toModule(W),zr=__toModule(W);__toModule(we());var Mr=class extends Error{},Rr=class extends Mr{},Br=__toModule(W),Fr=__toModule(W),Nr=/\s/;var Lr=function trimmedEndIndex($){for(var W=$.length;W--&&Nr.test($.charAt(W)););return W},Hr=/^\s+/;var Vr=function baseTrim($){return $?$.slice(0,Lr($)+1).replace(Hr,""):$},qr=/^[-+]0x[0-9a-f]+$/i,Ur=/^0b[01]+$/i,Kr=/^0o[0-7]+$/i,Wr=parseInt;var Gr=function toNumber($){if("number"==typeof $)return $;if(lt($))return NaN;if(ft($)){var W="function"==typeof $.valueOf?$.valueOf():$;$=ft(W)?W+"":W}if("string"!=typeof $)return 0===$?$:+$;$=Vr($);var G=Ur.test($);return G||Kr.test($)?Wr($.slice(2),G?2:8):qr.test($)?NaN:+$},Xr=1/0;var Yr=function toFinite($){return $?($=Gr($))===Xr||$===-1/0?17976931348623157e292*($<0?-1:1):$==$?$:0:0===$?$:0};var Jr=function toInteger($){var W=Yr($),G=W%1;return W==W?G?W-G:W:0};var Qr=function overArg($,W){return function(G){return $(W(G))}}(Object.getPrototypeOf,Object),Zr=Function.prototype,en=Object.prototype,tn=Zr.toString,rn=en.hasOwnProperty,nn=tn.call(Object);var an=function isPlainObject($){if(!st($)||"[object Object]"!=it($))return!1;var W=Qr($);if(null===W)return!0;var G=rn.call(W,"constructor")&&W.constructor;return"function"==typeof G&&G instanceof G&&tn.call(G)==nn};var sn=function baseSlice($,W,G){var oe=-1,ae=$.length;W<0&&(W=-W>ae?0:ae+W),(G=G>ae?ae:G)<0&&(G+=ae),ae=W>G?0:G-W>>>0,W>>>=0;for(var ie=Array(ae);++oe<ae;)ie[oe]=$[oe+W];return ie};var ln=function castSlice($,W,G){var oe=$.length;return G=void 0===G?oe:G,!W&&G>=oe?$:sn($,W,G)},un=RegExp("[\\u200d\\ud800-\\udfff\\u0300-\\u036f\\ufe20-\\ufe2f\\u20d0-\\u20ff\\ufe0e\\ufe0f]");var cn=function hasUnicode($){return un.test($)};var dn=function asciiToArray($){return $.split("")},fn="[\\ud800-\\udfff]",pn="[\\u0300-\\u036f\\ufe20-\\ufe2f\\u20d0-\\u20ff]",hn="\\ud83c[\\udffb-\\udfff]",mn="[^\\ud800-\\udfff]",gn="(?:\\ud83c[\\udde6-\\uddff]){2}",vn="[\\ud800-\\udbff][\\udc00-\\udfff]",yn="(?:"+pn+"|"+hn+")"+"?",bn="[\\ufe0e\\ufe0f]?",wn=bn+yn+("(?:\\u200d(?:"+[mn,gn,vn].join("|")+")"+bn+yn+")*"),Sn="(?:"+[mn+pn+"?",pn,gn,vn,fn].join("|")+")",xn=RegExp(hn+"(?="+hn+")|"+Sn+wn,"g");var kn=function unicodeToArray($){return $.match(xn)||[]};var _n=function stringToArray($){return cn($)?kn($):dn($)};var Pn=function baseProperty($){return function(W){return null==W?void 0:W[$]}},En=Math.floor;var jn=function baseRepeat($,W){var G="";if(!$||W<1||W>9007199254740991)return G;do{W%2&&(G+=$),(W=En(W/2))&&($+=$)}while(W);return G},Cn=Pn("length"),On="[\\ud800-\\udfff]",In="[\\u0300-\\u036f\\ufe20-\\ufe2f\\u20d0-\\u20ff]",Tn="\\ud83c[\\udffb-\\udfff]",Dn="[^\\ud800-\\udfff]",An="(?:\\ud83c[\\udde6-\\uddff]){2}",$n="[\\ud800-\\udbff][\\udc00-\\udfff]",zn="(?:"+In+"|"+Tn+")"+"?",Mn="[\\ufe0e\\ufe0f]?",Rn=Mn+zn+("(?:\\u200d(?:"+[Dn,An,$n].join("|")+")"+Mn+zn+")*"),Bn="(?:"+[Dn+In+"?",In,An,$n,On].join("|")+")",Fn=RegExp(Tn+"(?="+Tn+")|"+Bn+Rn,"g");var Nn=function unicodeSize($){for(var W=Fn.lastIndex=0;Fn.test($);)++W;return W};var Ln=function stringSize($){return cn($)?Nn($):Cn($)},Hn=Math.ceil;var Vn=function createPadding($,W){var G=(W=void 0===W?" ":lr(W)).length;if(G<2)return G?jn(W,$):W;var oe=jn(W,Hn($/Ln(W)));return cn(W)?ln(_n(oe),0,$).join(""):oe.slice(0,$)};var qn=function padStart($,W,G){$=ur($);var oe=(W=Jr(W))?Ln($):0;return W&&oe<W?Vn(W-oe,G)+$:$};function defer(){let $,W;const G=new Promise(((G,ae)=>{$=$=>{G($),oe.status="resolved"},W=$=>{ae($),oe.status="rejected"}})),oe={resolve:$,reject:W,promise:G,status:"pending"};return oe}var noop_default=()=>{},Un=__toModule(W),Kn=__toModule(W);var Wn=class{constructor($){this._fps=$}formatSubUnitForGrid($){const W=$%1,G=1/this._fps;return Math.round(W/G)+"f"}formatFullUnitForGrid($){let W=$,G="";if(W>=Yn){G+=Math.floor(W/Yn)+"h",W%=Yn}if(W>=Xn){G+=Math.floor(W/Xn)+"m",W%=Xn}if(W>=Gn){G+=Math.floor(W/Gn)+"s",W%=Gn}const oe=1/this._fps;if(W>=oe){G+=Math.floor(W/oe)+"f",W%=oe}return 0===G.length?"0s":G}formatForPlayhead($){let W=$,G="";if(W>=Yn){const $=Math.floor(W/Yn);G+=qn($.toString(),2,"0")+"h",W%=Yn}if(W>=Xn){const $=Math.floor(W/Xn);G+=qn($.toString(),2,"0")+"m",W%=Xn}else G.length>0&&(G+="00m");if(W>=Gn){const $=Math.floor(W/Gn);G+=qn($.toString(),2,"0")+"s",W%=Gn}else G+="00s";const oe=1/this._fps;if(W>=oe){const $=Math.round(W/oe);G+=qn($.toString(),2,"0")+"f",W%=oe}else if(W/oe>.98){G+=qn(1..toString(),2,"0")+"f",W%=oe}else G+="00f";return 0===G.length?"00s00f":G}formatBasic($){return $.toFixed(2)+"s"}},Gn=1,Xn=60*Gn,Yn=60*Xn,Jn={};function ellipsify($,W){return $.length<=W?$:$.substr(0,W-3)+"..."}__export(Jn,{boolean:()=>boolean,compound:()=>compound,number:()=>number,string:()=>string,stringLiteral:()=>stringLiteral});var userReadableTypeOfValue_default=$=>"string"==typeof $?`string("${ellipsify($,10)}")`:"number"==typeof $?`number(${ellipsify(String($),10)})`:null===$?"null":void 0===$?"undefined":"boolean"==typeof $?String($):Array.isArray($)?"array":"object"==typeof $?"object":"unknown",Qn=Symbol("TheatrePropType_Basic");function isLonghandPropType($){return"object"==typeof $&&!!$&&"TheatrePropType"===$[Qn]}function toLonghandProp($){if("number"==typeof $)return number($);if("boolean"==typeof $)return boolean($);if("string"==typeof $)return string($);if("object"==typeof $&&$){if(isLonghandPropType($))return $;if(an($))return compound($);throw new Rr(`This value is not a valid prop type: ${userReadableTypeOfValue_default($)}`)}throw new Rr(`This value is not a valid prop type: ${userReadableTypeOfValue_default($)}`)}function sanitizeCompoundProps($){const W={};for(const G of Object.keys($)){const oe=$[G];isLonghandPropType(oe)?W[G]=oe:W[G]=toLonghandProp(oe)}return W}var compound=($,W)=>({type:"compound",props:sanitizeCompoundProps($),valueType:null,[Qn]:"TheatrePropType",label:null==W?void 0:W.label}),number=($,W)=>{var G;return __spreadProps(__spreadValues({type:"number",valueType:0,default:$,[Qn]:"TheatrePropType"},W||{}),{label:null==W?void 0:W.label,nudgeFn:null!=(G=null==W?void 0:W.nudgeFn)?G:defaultNumberNudgeFn,nudgeMultiplier:"number"==typeof(null==W?void 0:W.nudgeMultiplier)?W.nudgeMultiplier:1})},boolean=($,W)=>({type:"boolean",default:$,valueType:null,[Qn]:"TheatrePropType",label:null==W?void 0:W.label}),string=($,W)=>({type:"string",default:$,valueType:null,[Qn]:"TheatrePropType",label:null==W?void 0:W.label});function stringLiteral($,W,G){var oe;return{type:"stringLiteral",default:$,options:__spreadValues({},W),[Qn]:"TheatrePropType",valueType:null,as:null!=(oe=null==G?void 0:G.as)?oe:"menu",label:null==G?void 0:G.label}}var defaultNumberNudgeFn=({config:$,deltaX:W,deltaFraction:G,magnitude:oe})=>{const{range:ae}=$;return ae?G*(ae[1]-ae[0])*oe*$.nudgeMultiplier:W*oe*$.nudgeMultiplier};function validateAndSanitiseSlashedPathOrThrow($,W){return $.replace(/^[\s\/]*/,"").replace(/[\s\/]*$/,"").replace(/\s*\/\s*/," / ")}__toModule(Se());var Zn,eo,to=__toModule(W),ro=__toModule(W),no=__toModule(W),delay_default=$=>new Promise((W=>setTimeout(W,$)));function n($){for(var W=arguments.length,G=Array(W>1?W-1:0),oe=1;oe<W;oe++)G[oe-1]=arguments[oe];throw Error("[Immer] minified error nr: "+$+(G.length?" "+G.map((function($){return"'"+$+"'"})).join(","):"")+". Find the full error at: https://bit.ly/3cXEKWf")}function t2($){return!!$&&!!$[co]}function r($){return!!$&&(function($){if(!$||"object"!=typeof $)return!1;var W=Object.getPrototypeOf($);if(null===W)return!0;var G=Object.hasOwnProperty.call(W,"constructor")&&W.constructor;return G===Object||"function"==typeof G&&Function.toString.call(G)===fo}($)||Array.isArray($)||!!$[uo]||!!$.constructor[uo]||s($)||v($))}function i($,W,G){void 0===G&&(G=!1),0===o($)?(G?Object.keys:po)($).forEach((function(oe){G&&"symbol"==typeof oe||W(oe,$[oe],$)})):$.forEach((function(G,oe){return W(oe,G,$)}))}function o($){var W=$[co];return W?W.i>3?W.i-4:W.i:Array.isArray($)?1:s($)?2:v($)?3:0}function u($,W){return 2===o($)?$.has(W):Object.prototype.hasOwnProperty.call($,W)}function f($,W,G){var oe=o($);2===oe?$.set(W,G):3===oe?($.delete(W),$.add(G)):$[W]=G}function s($){return ao&&$ instanceof Map}function v($){return io&&$ instanceof Set}function p($){return $.o||$.t}function l($){if(Array.isArray($))return Array.prototype.slice.call($);var W=ho($);delete W[co];for(var G=po(W),oe=0;oe<G.length;oe++){var ae=G[oe],ie=W[ae];!1===ie.writable&&(ie.writable=!0,ie.configurable=!0),(ie.get||ie.set)&&(W[ae]={configurable:!0,writable:!0,enumerable:ie.enumerable,value:$[ae]})}return Object.create(Object.getPrototypeOf($),W)}function d($,W){return void 0===W&&(W=!1),y($)||t2($)||!r($)||(o($)>1&&($.set=$.add=$.clear=$.delete=h),Object.freeze($),W&&i($,(function($,W){return d(W,!0)}),!0)),$}function h(){n(2)}function y($){return null==$||"object"!=typeof $||Object.isFrozen($)}function b($){var W=mo[$];return W||n(18,$),W}function _(){return eo}function j($,W){W&&(b("Patches"),$.u=[],$.s=[],$.v=W)}function O($){g($),$.p.forEach(S),$.p=null}function g($){$===eo&&(eo=$.l)}function w($){return eo={p:[],l:eo,h:$,m:!0,_:0}}function S($){var W=$[co];0===W.i||1===W.i?W.j():W.O=!0}function P($,W){W._=W.p.length;var G=W.p[0],oe=void 0!==$&&$!==G;return W.h.g||b("ES5").S(W,$,oe),oe?(G[co].P&&(O(W),n(4)),r($)&&($=M(W,$),W.l||x(W,$)),W.u&&b("Patches").M(G[co],$,W.u,W.s)):$=M(W,G,[]),O(W),W.u&&W.v(W.u,W.s),$!==lo?$:void 0}function M($,W,G){if(y(W))return W;var oe=W[co];if(!oe)return i(W,(function(ae,ie){return A($,oe,W,ae,ie,G)}),!0),W;if(oe.A!==$)return W;if(!oe.P)return x($,oe.t,!0),oe.t;if(!oe.I){oe.I=!0,oe.A._--;var ae=4===oe.i||5===oe.i?oe.o=l(oe.k):oe.o;i(3===oe.i?new Set(ae):ae,(function(W,ie){return A($,oe,ae,W,ie,G)})),x($,ae,!1),G&&$.u&&b("Patches").R(oe,G,$.u,$.s)}return oe.o}function A($,W,G,oe,ae,ie){if(t2(ae)){var se=M($,ae,ie&&W&&3!==W.i&&!u(W.D,oe)?ie.concat(oe):void 0);if(f(G,oe,se),!t2(se))return;$.m=!1}if(r(ae)&&!y(ae)){if(!$.h.F&&$._<1)return;M($,ae),W&&W.A.l||x($,ae)}}function x($,W,G){void 0===G&&(G=!1),$.h.F&&$.m&&d(W,G)}function z($,W){var G=$[co];return(G?p(G):$)[W]}function I($,W){if(W in $)for(var G=Object.getPrototypeOf($);G;){var oe=Object.getOwnPropertyDescriptor(G,W);if(oe)return oe;G=Object.getPrototypeOf(G)}}function k($){$.P||($.P=!0,$.l&&k($.l))}function E($){$.o||($.o=l($.t))}function R($,W,G){var oe=s(W)?b("MapSet").N(W,G):v(W)?b("MapSet").T(W,G):$.g?function($,W){var G=Array.isArray($),oe={i:G?1:0,A:W?W.A:_(),P:!1,I:!1,D:{},l:W,t:$,k:null,o:null,j:null,C:!1},ae=oe,ie=go;G&&(ae=[oe],ie=vo);var se=Proxy.revocable(ae,ie),le=se.revoke,ue=se.proxy;return oe.k=ue,oe.j=le,ue}(W,G):b("ES5").J(W,G);return(G?G.A:_()).p.push(oe),oe}function D($){return t2($)||n(22,$),function n2($){if(!r($))return $;var W,G=$[co],oe=o($);if(G){if(!G.P&&(G.i<4||!b("ES5").K(G)))return G.t;G.I=!0,W=F($,oe),G.I=!1}else W=F($,oe);return i(W,(function($,oe){G&&function a($,W){return 2===o($)?$.get(W):$[W]}(G.t,$)===oe||f(W,$,n2(oe))})),3===oe?new Set(W):W}($)}function F($,W){switch(W){case 2:return new Map($);case 3:return Array.from($)}return l($)}var oo="undefined"!=typeof Symbol&&"symbol"==typeof Symbol("x"),ao="undefined"!=typeof Map,io="undefined"!=typeof Set,so="undefined"!=typeof Proxy&&void 0!==Proxy.revocable&&"undefined"!=typeof Reflect,lo=oo?Symbol.for("immer-nothing"):((Zn={})["immer-nothing"]=!0,Zn),uo=oo?Symbol.for("immer-draftable"):"__$immer_draftable",co=oo?Symbol.for("immer-state"):"__$immer_state",fo=""+Object.prototype.constructor,po="undefined"!=typeof Reflect&&Reflect.ownKeys?Reflect.ownKeys:void 0!==Object.getOwnPropertySymbols?function($){return Object.getOwnPropertyNames($).concat(Object.getOwnPropertySymbols($))}:Object.getOwnPropertyNames,ho=Object.getOwnPropertyDescriptors||function($){var W={};return po($).forEach((function(G){W[G]=Object.getOwnPropertyDescriptor($,G)})),W},mo={},go={get:function($,W){if(W===co)return $;var G,oe,ae,ie=p($);if(!u(ie,W))return G=$,(ae=I(ie,W))?"value"in ae?ae.value:null===(oe=ae.get)||void 0===oe?void 0:oe.call(G.k):void 0;var se=ie[W];return $.I||!r(se)?se:se===z($.t,W)?(E($),$.o[W]=R($.A.h,se,$)):se},has:function($,W){return W in p($)},ownKeys:function($){return Reflect.ownKeys(p($))},set:function($,W,G){var oe=I(p($),W);if(null==oe?void 0:oe.set)return oe.set.call($.k,G),!0;if(!$.P){var ae=z(p($),W),ie=null==ae?void 0:ae[co];if(ie&&ie.t===G)return $.o[W]=G,$.D[W]=!1,!0;if(function c($,W){return $===W?0!==$||1/$==1/W:$!=$&&W!=W}(G,ae)&&(void 0!==G||u($.t,W)))return!0;E($),k($)}return $.o[W]===G&&"number"!=typeof G&&(void 0!==G||W in $.o)||($.o[W]=G,$.D[W]=!0,!0)},deleteProperty:function($,W){return void 0!==z($.t,W)||W in $.t?($.D[W]=!1,E($),k($)):delete $.D[W],$.o&&delete $.o[W],!0},getOwnPropertyDescriptor:function($,W){var G=p($),oe=Reflect.getOwnPropertyDescriptor(G,W);return oe?{writable:!0,configurable:1!==$.i||"length"!==W,enumerable:oe.enumerable,value:G[W]}:oe},defineProperty:function(){n(11)},getPrototypeOf:function($){return Object.getPrototypeOf($.t)},setPrototypeOf:function(){n(12)}},vo={};i(go,(function($,W){vo[$]=function(){return arguments[0]=arguments[0][0],W.apply(this,arguments)}})),vo.deleteProperty=function($,W){return go.deleteProperty.call(this,$[0],W)},vo.set=function($,W,G){return go.set.call(this,$[0],W,G,$[0])};var yo=function(){function e2($){var W=this;this.g=so,this.F=!0,this.produce=function($,G,oe){if("function"==typeof $&&"function"!=typeof G){var ae=G;G=$;var ie=W;return function($){var W=this;void 0===$&&($=ae);for(var oe=arguments.length,se=Array(oe>1?oe-1:0),le=1;le<oe;le++)se[le-1]=arguments[le];return ie.produce($,(function($){var oe;return(oe=G).call.apply(oe,[W,$].concat(se))}))}}var se;if("function"!=typeof G&&n(6),void 0!==oe&&"function"!=typeof oe&&n(7),r($)){var le=w(W),ue=R(W,$,void 0),de=!0;try{se=G(ue),de=!1}finally{de?O(le):g(le)}return"undefined"!=typeof Promise&&se instanceof Promise?se.then((function($){return j(le,oe),P($,le)}),(function($){throw O(le),$})):(j(le,oe),P(se,le))}if(!$||"object"!=typeof $){if((se=G($))===lo)return;return void 0===se&&(se=$),W.F&&d(se,!0),se}n(21,$)},this.produceWithPatches=function($,G){return"function"==typeof $?function(G){for(var oe=arguments.length,ae=Array(oe>1?oe-1:0),ie=1;ie<oe;ie++)ae[ie-1]=arguments[ie];return W.produceWithPatches(G,(function(W){return $.apply(void 0,[W].concat(ae))}))}:[W.produce($,G,(function($,W){oe=$,ae=W})),oe,ae];var oe,ae},"boolean"==typeof(null==$?void 0:$.useProxies)&&this.setUseProxies($.useProxies),"boolean"==typeof(null==$?void 0:$.autoFreeze)&&this.setAutoFreeze($.autoFreeze)}var $=e2.prototype;return $.createDraft=function($){r($)||n(8),t2($)&&($=D($));var W=w(this),G=R(this,$,void 0);return G[co].C=!0,g(W),G},$.finishDraft=function($,W){var G=($&&$[co]).A;return j(G,W),P(void 0,G)},$.setAutoFreeze=function($){this.F=$},$.setUseProxies=function($){$&&!so&&n(20),this.g=$},$.applyPatches=function($,W){var G;for(G=W.length-1;G>=0;G--){var oe=W[G];if(0===oe.path.length&&"replace"===oe.op){$=oe.value;break}}var ae=b("Patches").$;return t2($)?ae($,W):this.produce($,(function($){return ae($,W.slice(G+1))}))},e2}(),bo=new yo;bo.produce,bo.produceWithPatches.bind(bo),bo.setAutoFreeze.bind(bo),bo.setUseProxies.bind(bo),bo.applyPatches.bind(bo),bo.createDraft.bind(bo),bo.finishDraft.bind(bo);var wo={currentProjectStateDefinitionVersion:"0.4.0"};async function initialiseProjectState($,W,G){await delay_default(0),$.transaction((({drafts:$})=>{var oe;const ae=W.address.projectId;function useBrowserState(){$.ephemeral.coreByProject[ae].loadingState={type:"loaded"}}$.ephemeral.coreByProject[ae]={lastExportedObject:null,loadingState:{type:"loading"}},$.ahistoric.coreByProject[ae]={ahistoricStuff:""};const ie=null==(oe=function e($){return t2($)||n(23,$),$[co].t}($.historic))?void 0:oe.coreByProject[W.address.projectId];ie?G&&-1==ie.revisionHistory.indexOf(G.revisionHistory[0])?function browserStateIsNotBasedOnDiskState(W){$.ephemeral.coreByProject[ae].loadingState={type:"browserStateIsNotBasedOnDiskState",onDiskState:W}}(G):useBrowserState():G?function useOnDiskState(W){$.ephemeral.coreByProject[ae].loadingState={type:"loaded"},$.historic.coreByProject[ae]=W}(G):function useInitialState(){$.ephemeral.coreByProject[ae].loadingState={type:"loaded"},$.historic.coreByProject[ae]={sheetsById:{},definitionVersion:wo.currentProjectStateDefinitionVersion,revisionHistory:[]}}()}))}__toModule(Se());var So=__toModule(W),xo=__toModule(W);function getProject($,W={}){const G=(($,W)=>{var G={};for(var oe in $)pe.call($,oe)&&W.indexOf(oe)<0&&(G[oe]=$[oe]);if(null!=$&&ue)for(var oe of ue($))W.indexOf(oe)<0&&he.call($,oe)&&(G[oe]=$[oe]);return G})(W,[]),oe=De.get($);return oe?oe.publicApi:(W.state&&deepValidateOnDiskState($,W.state),new class{get type(){return"Theatre_Project_PublicAPI"}constructor($,W={}){setPrivateAPI(this,new class{constructor($,W={},G){var oe;this.config=W,this.publicApi=G,__publicField(this,"pointers"),__publicField(this,"_pointerProxies"),__publicField(this,"address"),__publicField(this,"_readyDeferred"),__publicField(this,"_sheetTemplates",new no.Atom({})),__publicField(this,"sheetTemplatesP",this._sheetTemplates.pointer),__publicField(this,"_studio"),__publicField(this,"type","Theatre_Project"),this.address={projectId:$};const ae=new no.Atom({ahistoric:{ahistoricStuff:""},historic:null!=(oe=W.state)?oe:{sheetsById:{},definitionVersion:wo.currentProjectStateDefinitionVersion,revisionHistory:[]},ephemeral:{loadingState:{type:"loaded"},lastExportedObject:null}});this._pointerProxies={historic:new ro.PointerProxy(ae.pointer.historic),ahistoric:new ro.PointerProxy(ae.pointer.ahistoric),ephemeral:new ro.PointerProxy(ae.pointer.ephemeral)},this.pointers={historic:this._pointerProxies.historic.pointer,ahistoric:this._pointerProxies.ahistoric.pointer,ephemeral:this._pointerProxies.ephemeral.pointer},De.add($,this),this._readyDeferred=defer(),W.state?setTimeout((()=>{this._studio||this._readyDeferred.resolve(void 0)}),0):setTimeout((()=>{if(!this._studio)throw new Error(`Argument config.state in Theatre.getProject("${$}", config) is empty. This is fine while you are using @theatre/core along with @theatre/sutdio. But since @theatre/studio is not loaded, the state of project "${$}" will be empty.\n\nTo fix this, you need to add @theatre/studio into the bundle and export the projet's state. Learn how to do that at https://docs.theatrejs.com/in-depth/#exporting`)}),1e3)}attachToStudio($){if(this._studio){if(this._studio!==$)throw new Error(`Project ${this.address.projectId} is already attached to studio ${this._studio.address.studioId}`);console.warn(`Project ${this.address.projectId} is already attached to studio ${this._studio.address.studioId}`)}else this._studio=$,$.initialized.then((async()=>{await initialiseProjectState($,this,this.config.state),this._pointerProxies.historic.setPointer($.atomP.historic.coreByProject[this.address.projectId]),this._pointerProxies.ahistoric.setPointer($.atomP.ahistoric.coreByProject[this.address.projectId]),this._pointerProxies.ephemeral.setPointer($.atomP.ephemeral.coreByProject[this.address.projectId]),this._readyDeferred.resolve(void 0)}))}get isAttachedToStudio(){return!!this._studio}get ready(){return this._readyDeferred.promise}isReady(){return"resolved"===this._readyDeferred.status}getOrCreateSheet($,W="default"){let G=this._sheetTemplates.getState()[$];return G||(G=new class{constructor($,W){this.project=$,__publicField(this,"type","Theatre_SheetTemplate"),__publicField(this,"address"),__publicField(this,"_instances",new zr.Atom({})),__publicField(this,"instancesP",this._instances.pointer),__publicField(this,"_objectTemplates",new zr.Atom({})),__publicField(this,"objectTemplatesP",this._objectTemplates.pointer),this.address=__spreadProps(__spreadValues({},$.address),{sheetId:W})}getInstance($){let W=this._instances.getState()[$];return W||(W=new class{constructor($,W){this.template=$,this.instanceId=W,__publicField(this,"_objects",new to.Atom({})),__publicField(this,"_sequence"),__publicField(this,"address"),__publicField(this,"publicApi"),__publicField(this,"project"),__publicField(this,"objectsP",this._objects.pointer),__publicField(this,"type","Theatre_Sheet"),this.project=$.project,this.address=__spreadProps(__spreadValues({},$.address),{sheetInstanceId:this.instanceId}),this.publicApi=new class{get type(){return"Theatre_Sheet_PublicAPI"}constructor($){setPrivateAPI(this,$)}object($,W){const G=privateAPI(this),oe=validateAndSanitiseSlashedPathOrThrow($),ae=G.getObject(oe);if(ae)return ae.publicApi;{const $=compound(W);return G.createObject(oe,null,$).publicApi}}get sequence(){return privateAPI(this).getSequence().publicApi}get project(){return privateAPI(this).project.publicApi}get address(){return __spreadValues({},privateAPI(this).address)}}(this)}createObject($,W,G){const oe=this.template.getObjectTemplate($,W,G).createInstance(this,W,G);return this._objects.setIn([$],oe),oe}getObject($){return this._objects.getState()[$]}getSequence(){if(!this._sequence){const $=(0,to.valueDerivation)(this.project.pointers.historic.sheetsById[this.address.sheetId].sequence.length).map(($=>"number"==typeof $?$:10)),W=(0,to.valueDerivation)(this.project.pointers.historic.sheetsById[this.address.sheetId].sequence.subUnitsPerUnit).map(($=>"number"==typeof $?$:30));this._sequence=new class{constructor($,W,G,oe,ae){this._project=$,this._sheet=W,this._lengthD=G,this._subUnitsPerUnitD=oe,__publicField(this,"address"),__publicField(this,"publicApi"),__publicField(this,"_playbackControllerBox"),__publicField(this,"_statePointerDerivation"),__publicField(this,"_positionD"),__publicField(this,"_positionFormatterD"),__publicField(this,"_playableRangeD"),__publicField(this,"pointer",(0,Br.pointer)({root:this,path:[]})),__publicField(this,"$$isIdentityDerivationProvider",!0),__publicField(this,"closestGridPosition",($=>{const W=1/this.subUnitsPerUnit;return parseFloat((Math.round($/W)*W).toFixed(3))})),this.address=__spreadProps(__spreadValues({},this._sheet.address),{sequenceName:"default"}),this.publicApi=new class{get type(){return"Theatre_Sequence_PublicAPI"}constructor($){setPrivateAPI(this,$)}play($){if(privateAPI(this)._project.isReady())return privateAPI(this).play($);{const $=defer();return $.resolve(!0),$.promise}}pause(){privateAPI(this).pause()}get position(){return privateAPI(this).position}set position($){privateAPI(this).position=$}async attachAudio($){const{audioContext:W,destinationNode:G,decodedBuffer:oe,gainNode:ae}=await async function resolveAudioBuffer($){function getAudioContext(){if($.audioContext)return Promise.resolve($.audioContext);const W=new AudioContext;return"running"===W.state?Promise.resolve(W):new Promise(($=>{const listener=()=>{W.resume()},G=["mousedown","keydown","touchstart"],oe={capture:!0,passive:!1};G.forEach(($=>{window.addEventListener($,listener,oe)})),W.addEventListener("statechange",(()=>{"running"===W.state&&(G.forEach(($=>{window.removeEventListener($,listener,oe)})),$(W))}))}))}async function getAudioBuffer(){if($.source instanceof AudioBuffer)return $.source;const G=defer();if("string"!=typeof $.source)throw new Error("Error validating arguments to sequence.attachAudio(). args.source must either be a string or an instance of AudioBuffer.");let oe,ae,ie;try{oe=await fetch($.source)}catch(W){throw console.error(W),new Error(`Could not fetch '${$.source}'. Network error logged above.`)}try{ae=await oe.arrayBuffer()}catch(W){throw console.error(W),new Error(`Could not read '${$.source}' as an arrayBuffer.`)}(await W).decodeAudioData(ae,G.resolve,G.reject);try{ie=await G.promise}catch(W){throw console.error(W),new Error(`Could not decode ${$.source} as an audio file.`)}return ie}const W=getAudioContext(),G=getAudioBuffer(),[oe,ae]=await Promise.all([W,G]),ie=$.destinationNode||oe.destination,se=oe.createGain();return se.connect(ie),{audioContext:oe,decodedBuffer:ae,gainNode:se,destinationNode:ie}}($),ie=new class{constructor($,W,G,oe){this._ticker=$,this._decodedBuffer=W,this._audioContext=G,this._nodeDestination=oe,__publicField(this,"_mainGain"),__publicField(this,"_state",new Kn.Atom({position:0,playing:!1})),__publicField(this,"statePointer"),__publicField(this,"_stopPlayCallback",noop_default),this.statePointer=this._state.pointer,this._mainGain=this._audioContext.createGain(),this._mainGain.connect(this._nodeDestination)}get _playing(){return this._state.getState().playing}set _playing($){this._state.setIn(["playing"],$)}destroy(){}pause(){this._stopPlayCallback(),this._playing=!1,this._stopPlayCallback=noop_default}gotoPosition($){this._updatePositionInState($)}_updatePositionInState($){this._state.reduceState(["position"],(()=>$))}getCurrentPosition(){return this._state.getState().position}play($,W,G,oe){this._playing&&this.pause(),this._playing=!0;const ae=this._ticker;let ie=this.getCurrentPosition();const se=W[1]-W[0];if("normal"!==oe)throw new Rr(`Audio-controlled sequences can only be played in the "normal" direction. '${oe}' given.`);(ie<W[0]||ie>W[1]||ie===W[1])&&this._updatePositionInState(W[0]),ie=this.getCurrentPosition();const le=defer(),ue=this._audioContext.createBufferSource();ue.buffer=this._decodedBuffer,ue.connect(this._mainGain),ue.playbackRate.value=G,$>1e3&&(console.warn("Audio-controlled sequences cannot have an iterationCount larger than 1000. It has been clamped to 1000."),$=1e3),$>1&&(ue.loop=!0,ue.loopStart=W[0],ue.loopEnd=W[1]);const de=ae.time;let pe=ie-W[0];const he=se*$;ue.start(0,ie,he-pe);const tick=$=>{const oe=Math.max($-de,0)/1e3,ae=Math.min(oe*G+pe,he);if(ae!==he){let $=ae/se%1*se;this._updatePositionInState($+W[0]),requestNextTick()}else this._updatePositionInState(W[1]),this._playing=!1,cleanup(),le.resolve(!0)},cleanup=()=>{ue.stop(),ue.disconnect()};this._stopPlayCallback=()=>{cleanup(),ae.offThisOrNextTick(tick),ae.offNextTick(tick),this._playing&&le.resolve(!1)};const requestNextTick=()=>ae.onNextTick(tick);return ae.onThisOrNextTick(tick),le.promise}}(Ar,oe,W,ae);return privateAPI(this).replacePlaybackController(ie),{audioContext:W,destinationNode:G,decodedBuffer:oe,gainNode:ae}}get pointer(){return privateAPI(this).pointer}}(this),this._playbackControllerBox=new Fr.Box(null!=ae?ae:new class{constructor($){this._ticker=$,__publicField(this,"_stopPlayCallback",noop_default),__publicField(this,"_state",new Un.Atom({position:0,playing:!1})),__publicField(this,"statePointer"),this.statePointer=this._state.pointer}destroy(){}pause(){this._stopPlayCallback(),this.playing=!1,this._stopPlayCallback=noop_default}gotoPosition($){this._updatePositionInState($)}_updatePositionInState($){this._state.reduceState(["position"],(()=>$))}getCurrentPosition(){return this._state.getState().position}get playing(){return this._state.getState().playing}set playing($){this._state.setIn(["playing"],$)}play($,W,G,oe){this.playing&&this.pause(),this.playing=!0;const ae=this._ticker,ie=W[1]-W[0];{const $=this.getCurrentPosition();$<W[0]||$>W[1]?"normal"===oe||"alternate"===oe?this._updatePositionInState(W[0]):"reverse"!==oe&&"alternateReverse"!==oe||this._updatePositionInState(W[1]):"normal"===oe||"alternate"===oe?$===W[1]&&this._updatePositionInState(W[0]):$===W[0]&&this._updatePositionInState(W[1])}const se=defer(),le=ae.time,ue=ie*$;let de=this.getCurrentPosition()-W[0];"reverse"!==oe&&"alternateReverse"!==oe||(de=W[1]-this.getCurrentPosition());const tick=ae=>{const pe=Math.max(ae-le,0)/1e3,he=Math.min(pe*G+de,ue);if(he!==ue){const $=Math.floor(he/ie);let G=he/ie%1*ie;if("normal"!==oe)if("reverse"===oe)G=ie-G;else{const W=$%2==0;"alternate"===oe?W||(G=ie-G):W&&(G=ie-G)}this._updatePositionInState(G+W[0]),requestNextTick()}else{if("normal"===oe)this._updatePositionInState(W[1]);else if("reverse"===oe)this._updatePositionInState(W[0]);else{const G=($-1)%2==0;"alternate"===oe?G?this._updatePositionInState(W[1]):this._updatePositionInState(W[0]):G?this._updatePositionInState(W[0]):this._updatePositionInState(W[1])}this.playing=!1,se.resolve(!0)}};this._stopPlayCallback=()=>{ae.offThisOrNextTick(tick),ae.offNextTick(tick),this.playing&&se.resolve(!1)};const requestNextTick=()=>ae.onNextTick(tick);return ae.onThisOrNextTick(tick),se.promise}}(Ar)),this._statePointerDerivation=this._playbackControllerBox.derivation.map(($=>$.statePointer)),this._positionD=this._statePointerDerivation.flatMap(($=>(0,Fr.valueDerivation)($.position))),this._positionFormatterD=this._subUnitsPerUnitD.map(($=>new Wn($)))}getIdentityDerivation($){if(0===$.length)return(0,Fr.prism)((()=>({length:(0,Fr.val)(this.pointer.length),playing:(0,Fr.val)(this.pointer.playing),position:(0,Fr.val)(this.pointer.position)})));if($.length>1)return(0,Fr.prism)((()=>{}));const[W]=$;return"length"===W?this._lengthD:"position"===W?this._positionD:"playing"===W?(0,Fr.prism)((()=>(0,Fr.val)(this._statePointerDerivation.getValue().playing))):(0,Fr.prism)((()=>{}))}get positionFormatter(){return this._positionFormatterD.getValue()}get derivationToStatePointer(){return this._statePointerDerivation}get length(){return this._lengthD.getValue()}get positionDerivation(){return this._positionD}get position(){return this._playbackControllerBox.get().getCurrentPosition()}get subUnitsPerUnit(){return this._subUnitsPerUnitD.getValue()}get positionSnappedToGrid(){return this.closestGridPosition(this.position)}set position($){let W=$;this.pause(),W>this.length&&(W=this.length);const G=this.length;this._playbackControllerBox.get().gotoPosition(W>G?G:W)}getDurationCold(){return this._lengthD.getValue()}get playing(){return(0,Fr.val)(this._playbackControllerBox.get().statePointer.playing)}_makeRangeFromSequenceTemplate(){return(0,Fr.prism)((()=>[0,(0,Fr.val)(this._lengthD)]))}async play($){const W=this.length,G=$&&$.range?$.range:[0,W],oe=$&&"number"==typeof $.iterationCount?$.iterationCount:1,ae=$&&void 0!==$.rate?$.rate:1,ie=$&&$.direction?$.direction:"normal";return await this._play(oe,[G[0],G[1]],ae,ie)}_play($,W,G,oe){return this._playbackControllerBox.get().play($,W,G,oe)}pause(){this._playbackControllerBox.get().pause()}replacePlaybackController($){this.pause();const W=this._playbackControllerBox.get();this._playbackControllerBox.set($);const G=W.getCurrentPosition();W.destroy(),$.gotoPosition(G)}}(this.template.project,this,$,W)}return this._sequence}}(this,$),this._instances.setIn([$],W)),W}getObjectTemplate($,W,G){let oe=this._objectTemplates.getState()[$];return oe||(oe=new class{constructor($,W,G,oe){this.sheetTemplate=$,__publicField(this,"address"),__publicField(this,"type","Theatre_SheetObjectTemplate"),__publicField(this,"_config"),__publicField(this,"_cache",new hr),__publicField(this,"project"),this.address=__spreadProps(__spreadValues({},$.address),{objectKey:W}),this._config=new mr.Atom(oe),this.project=$.project}get config(){return this._config.getState()}createInstance($,W,G){return this._config.setState(G),new class{constructor($,W,G){this.sheet=$,this.template=W,this.nativeObject=G,__publicField(this,"$$isIdentityDerivationProvider",!0),__publicField(this,"address"),__publicField(this,"publicApi"),__publicField(this,"_initialValue",new Tr.Atom({})),__publicField(this,"_cache",new hr),this.address=__spreadProps(__spreadValues({},W.address),{sheetInstanceId:$.address.sheetInstanceId}),this.publicApi=new class{constructor($){__publicField(this,"_cache",new hr),setPrivateAPI(this,$)}get type(){return"Theatre_SheetObject_PublicAPI"}get props(){return privateAPI(this).propsP}get sheet(){return privateAPI(this).sheet.publicApi}get project(){return privateAPI(this).sheet.project.publicApi}get address(){return __spreadValues({},privateAPI(this).address)}_valuesDerivation(){return this._cache.get("onValuesChangeDerivation",(()=>{const $=privateAPI(this);return(0,$r.prism)((()=>(0,$r.val)($.getValues().getValue())))}))}onValuesChange($){return this._valuesDerivation().tapImmediate(Ar,$)}get value(){return this._valuesDerivation().getValue()}set initialValue($){privateAPI(this).setInitialValue($)}}(this)}get type(){return"Theatre_SheetObject"}getValues(){return this._cache.get("getValues()",(()=>(0,Tr.prism)((()=>{const $=deepMergeWithCache((0,Tr.val)(this.template.getDefaultValues()),(0,Tr.val)(this._initialValue.pointer),Tr.prism.memo("withInitialCache",(()=>new WeakMap),[]));let W,G=deepMergeWithCache($,(0,Tr.val)(this.template.getStaticValues()),Tr.prism.memo("withStatics",(()=>new WeakMap),[]));{const $=Tr.prism.memo("seq",(()=>this.getSequencedValues()),[]),oe=Tr.prism.memo("withSeqsCache",(()=>new WeakMap),[]);W=(0,Tr.val)((0,Tr.val)($)),G=deepMergeWithCache(G,W,oe)}return(($,W)=>{const G=Ir.prism.memo($,(()=>new Ir.Atom(W)),[]);return G.setState(W),G})("finalAtom",G).pointer}))))}getValueByPointer($){const W=(0,Tr.val)(this.getValues()),{path:G}=(0,Tr.getPointerParts)($);return(0,Tr.val)(pointerDeep(W,G))}getIdentityDerivation($){return(0,Tr.prism)((()=>{const W=(0,Tr.val)(this.getValues());return(0,Tr.val)(pointerDeep(W,$))}))}getSequencedValues(){return(0,Tr.prism)((()=>{const $=Tr.prism.memo("tracksToProcess",(()=>this.template.getArrayOfValidSequenceTracks()),[]),W=(0,Tr.val)($),G=new Tr.Atom({});return Tr.prism.effect("processTracks",(()=>{const $=[];for(const{trackId:oe,pathToProp:ae}of W){const W=this._trackIdToDerivation(oe),updateSequenceValueFromItsDerivation=()=>{G.setIn(ae,W.getValue())},ie=W.changesWithoutValues().tap(updateSequenceValueFromItsDerivation);updateSequenceValueFromItsDerivation(),$.push(ie)}return()=>{for(const W of $)W()}}),W),G.pointer}))}_trackIdToDerivation($){return trackValueAtTime(this.template.project.pointers.historic.sheetsById[this.address.sheetId].sequence.tracksByObject[this.address.objectKey].trackData[$],this.sheet.getSequence().positionDerivation)}get propsP(){return this._cache.get("propsP",(()=>(0,Tr.pointer)({root:this,path:[]})))}validateValue($,W){}setInitialValue($){this.validateValue(this.propsP,$),this._initialValue.setState($)}}($,this,W)}overrideConfig($){this._config.setState($)}getDefaultValues(){return this._cache.get("getDefaultValues()",(()=>(0,mr.prism)((()=>function getPropDefaultsOfSheetObject($){return getDefaultsOfPropTypeConfig($)}((0,mr.val)(this._config.pointer))))))}getStaticValues(){return this._cache.get("getDerivationOfStatics",(()=>(0,mr.prism)((()=>{const $=this.sheetTemplate.project.pointers.historic.sheetsById[this.address.sheetId];return(0,mr.val)($.staticOverrides.byObject[this.address.objectKey])||{}}))))}getArrayOfValidSequenceTracks(){return this._cache.get("getArrayOfValidSequenceTracks",(()=>(0,mr.prism)((()=>{const $=(0,mr.val)(this.getDefaultValues()),W=this.project.pointers.historic.sheetsById[this.address.sheetId],G=(0,mr.val)(W.sequence.tracksByObject[this.address.objectKey].trackIdByPropPath),oe=[];if(!G)return Le;for(const[W,ae]of Object.entries(G)){let G;try{G=JSON.parse(W)}catch($){Er.warn(`property ${JSON.stringify(W)} cannot be parsed. Skipping.`);continue}"number"==typeof pr($,G)&&oe.push({pathToProp:G,trackId:ae})}return 0===oe.length?Le:oe}))))}getMapOfValidSequenceTracks_forStudio(){return this._cache.get("getMapOfValidSequenceTracks_forStudio",(()=>this.getArrayOfValidSequenceTracks().map(($=>{let W={};for(const{pathToProp:G,trackId:oe}of $)kr(W,G,oe);return W}))))}getDefaultsAtPointer($){const{path:W}=(0,mr.getPointerParts)($),G=function getDeep($,W){return 0===W.length?$:pr($,W)}(this.getDefaultValues().getValue(),W);return G}}(this,$,W,G),this._objectTemplates.setIn([$],oe)),oe}}(this,$),this._sheetTemplates.setIn([$],G)),G.getInstance(W)}}($,W,this))}get ready(){return privateAPI(this).ready}get isReady(){return privateAPI(this).isReady()}get address(){return __spreadValues({},privateAPI(this).address)}sheet($,W="default"){const G=validateAndSanitiseSlashedPathOrThrow($);return privateAPI(this).getOrCreateSheet(G,W).publicApi}}($,G))}var deepValidateOnDiskState=($,W)=>{(($,W)=>{if(Array.isArray(W)||null==W||W.definitionVersion!==wo.currentProjectStateDefinitionVersion)throw new Rr(`Error validating conf.state in Theatre.getProject(${JSON.stringify($)}, conf). The state seems to be formatted in a way that is unreadable to Theatre.js. Read more at https://docs.theatrejs.com`)})($,W)};function onChange($,W){if((0,So.isPointer)($)){return(0,xo.valueDerivation)($).tapImmediate(Ar,W)}if((0,xo.isDerivation)($))return $.tapImmediate(Ar,W);throw new Error("Called onChange(p) where p is neither a pointer nor a derivation.")}function val6($){if((0,So.isPointer)($))return(0,xo.valueDerivation)($).getValue();throw new Error("Called val(p) where p is not a pointer.")}var ko="__TheatreJS_CoreBundle";!function registerCoreBundle(){if("undefined"==typeof window)return;const $=window[ko];if(void 0!==$)throw"object"==typeof $&&$&&"string"==typeof $.version?new Error("It seems that the module '@theatre/core' is loaded more than once. This could have two possible causes:\n1. You might have two separate versions of theatre in node_modules.\n2. Or this might be a bundling misconfiguration, in case you're using a bundler like Webpack/ESBuild/Rollup.\n\nNote that it **is okay** to import '@theatre/core' multiple times. But those imports should point to the same module."):new Error(`The variable window.${ko} seems to be already set by a module other than @theatre/core.`);const W=new class{constructor(){__publicField(this,"_studio")}get type(){return"Theatre_CoreBundle"}get version(){return"0.4.7"}getBitsForStudio($,W){if(this._studio)throw new Error("@theatre/core is already attached to @theatre/studio");this._studio=$,W({projectsP:De.atom.pointer.projects,privateAPI:privateAPI,coreExports:Pe})}};window[ko]=W;const G=window.__TheatreJS_StudioBundle;G&&null!==G&&"Theatre_StudioBundle"===G.type&&G.registerCoreBundle(W)}
/**
	 * @license
	 * Lodash (Custom Build) <https://lodash.com/>
	 * Build: `lodash modularize exports="es" -o ./`
	 * Copyright OpenJS Foundation and other contributors <https://openjsf.org/>
	 * Released under MIT license <https://lodash.com/license>
	 * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>
	 * Copyright Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
	 */()}($);var gt={exports:{}},vt={exports:{}},yt={},bt=Object.getOwnPropertySymbols,wt=Object.prototype.hasOwnProperty,St=Object.prototype.propertyIsEnumerable;function toObject($){if(null==$)throw new TypeError("Object.assign cannot be called with null or undefined");return Object($)}var xt=function shouldUseNative(){try{if(!Object.assign)return!1;var $=new String("abc");if($[5]="de","5"===Object.getOwnPropertyNames($)[0])return!1;for(var W={},G=0;G<10;G++)W["_"+String.fromCharCode(G)]=G;var oe=Object.getOwnPropertyNames(W).map((function($){return W[$]}));if("0123456789"!==oe.join(""))return!1;var ae={};return"abcdefghijklmnopqrst".split("").forEach((function($){ae[$]=$})),"abcdefghijklmnopqrst"===Object.keys(Object.assign({},ae)).join("")}catch($){return!1}}()?Object.assign:function($,W){for(var G,oe,ae=toObject($),ie=1;ie<arguments.length;ie++){for(var se in G=Object(arguments[ie]))wt.call(G,se)&&(ae[se]=G[se]);if(bt){oe=bt(G);for(var le=0;le<oe.length;le++)St.call(G,oe[le])&&(ae[oe[le]]=G[oe[le]])}}return ae},kt=xt,_t=60103,Pt=60106;
/** @license React v17.0.2
	 * react.production.min.js
	 *
	 * Copyright (c) Facebook, Inc. and its affiliates.
	 *
	 * This source code is licensed under the MIT license found in the
	 * LICENSE file in the root directory of this source tree.
	 */yt.Fragment=60107,yt.StrictMode=60108,yt.Profiler=60114;var Et=60109,jt=60110,Ct=60112;yt.Suspense=60113;var Ot=60115,It=60116;if("function"==typeof Symbol&&Symbol.for){var Tt=Symbol.for;_t=Tt("react.element"),Pt=Tt("react.portal"),yt.Fragment=Tt("react.fragment"),yt.StrictMode=Tt("react.strict_mode"),yt.Profiler=Tt("react.profiler"),Et=Tt("react.provider"),jt=Tt("react.context"),Ct=Tt("react.forward_ref"),yt.Suspense=Tt("react.suspense"),Ot=Tt("react.memo"),It=Tt("react.lazy")}var Dt="function"==typeof Symbol&&Symbol.iterator;function z$2($){for(var W="https://reactjs.org/docs/error-decoder.html?invariant="+$,G=1;G<arguments.length;G++)W+="&args[]="+encodeURIComponent(arguments[G]);return"Minified React error #"+$+"; visit "+W+" for the full message or use the non-minified dev environment for full errors and additional helpful warnings."}var At={isMounted:function(){return!1},enqueueForceUpdate:function(){},enqueueReplaceState:function(){},enqueueSetState:function(){}},$t={};function C$1($,W,G){this.props=$,this.context=W,this.refs=$t,this.updater=G||At}function D$1(){}function E$2($,W,G){this.props=$,this.context=W,this.refs=$t,this.updater=G||At}C$1.prototype.isReactComponent={},C$1.prototype.setState=function($,W){if("object"!=typeof $&&"function"!=typeof $&&null!=$)throw Error(z$2(85));this.updater.enqueueSetState(this,$,W,"setState")},C$1.prototype.forceUpdate=function($){this.updater.enqueueForceUpdate(this,$,"forceUpdate")},D$1.prototype=C$1.prototype;var zt=E$2.prototype=new D$1;zt.constructor=E$2,kt(zt,C$1.prototype),zt.isPureReactComponent=!0;var Mt={current:null},Rt=Object.prototype.hasOwnProperty,Bt={key:!0,ref:!0,__self:!0,__source:!0};function J$1($,W,G){var oe,ae={},ie=null,se=null;if(null!=W)for(oe in void 0!==W.ref&&(se=W.ref),void 0!==W.key&&(ie=""+W.key),W)Rt.call(W,oe)&&!Bt.hasOwnProperty(oe)&&(ae[oe]=W[oe]);var le=arguments.length-2;if(1===le)ae.children=G;else if(1<le){for(var ue=Array(le),de=0;de<le;de++)ue[de]=arguments[de+2];ae.children=ue}if($&&$.defaultProps)for(oe in le=$.defaultProps)void 0===ae[oe]&&(ae[oe]=le[oe]);return{$$typeof:_t,type:$,key:ie,ref:se,props:ae,_owner:Mt.current}}function L$1($){return"object"==typeof $&&null!==$&&$.$$typeof===_t}var Ft=/\/+/g;function N$2($,W){return"object"==typeof $&&null!==$&&null!=$.key?function escape($){var W={"=":"=0",":":"=2"};return"$"+$.replace(/[=:]/g,(function($){return W[$]}))}(""+$.key):W.toString(36)}function O$2($,W,G,oe,ae){var ie=typeof $;"undefined"!==ie&&"boolean"!==ie||($=null);var se=!1;if(null===$)se=!0;else switch(ie){case"string":case"number":se=!0;break;case"object":switch($.$$typeof){case _t:case Pt:se=!0}}if(se)return ae=ae(se=$),$=""===oe?"."+N$2(se,0):oe,Array.isArray(ae)?(G="",null!=$&&(G=$.replace(Ft,"$&/")+"/"),O$2(ae,W,G,"",(function($){return $}))):null!=ae&&(L$1(ae)&&(ae=function K$1($,W){return{$$typeof:_t,type:$.type,key:W,ref:$.ref,props:$.props,_owner:$._owner}}(ae,G+(!ae.key||se&&se.key===ae.key?"":(""+ae.key).replace(Ft,"$&/")+"/")+$)),W.push(ae)),1;if(se=0,oe=""===oe?".":oe+":",Array.isArray($))for(var le=0;le<$.length;le++){var ue=oe+N$2(ie=$[le],le);se+=O$2(ie,W,G,ue,ae)}else if(ue=function y$2($){return null===$||"object"!=typeof $?null:"function"==typeof($=Dt&&$[Dt]||$["@@iterator"])?$:null}($),"function"==typeof ue)for($=ue.call($),le=0;!(ie=$.next()).done;)se+=O$2(ie=ie.value,W,G,ue=oe+N$2(ie,le++),ae);else if("object"===ie)throw W=""+$,Error(z$2(31,"[object Object]"===W?"object with keys {"+Object.keys($).join(", ")+"}":W));return se}function P$2($,W,G){if(null==$)return $;var oe=[],ae=0;return O$2($,oe,"","",(function($){return W.call(G,$,ae++)})),oe}function Q$1($){if(-1===$._status){var W=$._result;W=W(),$._status=0,$._result=W,W.then((function(W){0===$._status&&(W=W.default,$._status=1,$._result=W)}),(function(W){0===$._status&&($._status=2,$._result=W)}))}if(1===$._status)return $._result;throw $._result}var Nt={current:null};function S$2(){var $=Nt.current;if(null===$)throw Error(z$2(321));return $}var Lt={ReactCurrentDispatcher:Nt,ReactCurrentBatchConfig:{transition:0},ReactCurrentOwner:Mt,IsSomeRendererActing:{current:!1},assign:kt};yt.Children={map:P$2,forEach:function($,W,G){P$2($,(function(){W.apply(this,arguments)}),G)},count:function($){var W=0;return P$2($,(function(){W++})),W},toArray:function($){return P$2($,(function($){return $}))||[]},only:function($){if(!L$1($))throw Error(z$2(143));return $}},yt.Component=C$1,yt.PureComponent=E$2,yt.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED=Lt,yt.cloneElement=function($,W,G){if(null==$)throw Error(z$2(267,$));var oe=kt({},$.props),ae=$.key,ie=$.ref,se=$._owner;if(null!=W){if(void 0!==W.ref&&(ie=W.ref,se=Mt.current),void 0!==W.key&&(ae=""+W.key),$.type&&$.type.defaultProps)var le=$.type.defaultProps;for(ue in W)Rt.call(W,ue)&&!Bt.hasOwnProperty(ue)&&(oe[ue]=void 0===W[ue]&&void 0!==le?le[ue]:W[ue])}var ue=arguments.length-2;if(1===ue)oe.children=G;else if(1<ue){le=Array(ue);for(var de=0;de<ue;de++)le[de]=arguments[de+2];oe.children=le}return{$$typeof:_t,type:$.type,key:ae,ref:ie,props:oe,_owner:se}},yt.createContext=function($,W){return void 0===W&&(W=null),($={$$typeof:jt,_calculateChangedBits:W,_currentValue:$,_currentValue2:$,_threadCount:0,Provider:null,Consumer:null}).Provider={$$typeof:Et,_context:$},$.Consumer=$},yt.createElement=J$1,yt.createFactory=function($){var W=J$1.bind(null,$);return W.type=$,W},yt.createRef=function(){return{current:null}},yt.forwardRef=function($){return{$$typeof:Ct,render:$}},yt.isValidElement=L$1,yt.lazy=function($){return{$$typeof:It,_payload:{_status:-1,_result:$},_init:Q$1}},yt.memo=function($,W){return{$$typeof:Ot,type:$,compare:void 0===W?null:W}},yt.useCallback=function($,W){return S$2().useCallback($,W)},yt.useContext=function($,W){return S$2().useContext($,W)},yt.useDebugValue=function(){},yt.useEffect=function($,W){return S$2().useEffect($,W)},yt.useImperativeHandle=function($,W,G){return S$2().useImperativeHandle($,W,G)},yt.useLayoutEffect=function($,W){return S$2().useLayoutEffect($,W)},yt.useMemo=function($,W){return S$2().useMemo($,W)},yt.useReducer=function($,W,G){return S$2().useReducer($,W,G)},yt.useRef=function($){return S$2().useRef($)},yt.useState=function($){return S$2().useState($)},yt.version="17.0.2",vt.exports=yt;var Ht=vt.exports,Vt={exports:{}},qt={},Ut={exports:{}},Kt={};
/** @license React v0.20.2
	 * scheduler.production.min.js
	 *
	 * Copyright (c) Facebook, Inc. and its affiliates.
	 *
	 * This source code is licensed under the MIT license found in the
	 * LICENSE file in the root directory of this source tree.
	 */
!function($){var W,G,oe,ae;if("object"==typeof performance&&"function"==typeof performance.now){var ie=performance;$.unstable_now=function(){return ie.now()}}else{var se=Date,le=se.now();$.unstable_now=function(){return se.now()-le}}if("undefined"==typeof window||"function"!=typeof MessageChannel){var ue=null,de=null,w=function(){if(null!==ue)try{var W=$.unstable_now();ue(!0,W),ue=null}catch($){throw setTimeout(w,0),$}};W=function($){null!==ue?setTimeout(W,0,$):(ue=$,setTimeout(w,0))},G=function($,W){de=setTimeout($,W)},oe=function(){clearTimeout(de)},$.unstable_shouldYield=function(){return!1},ae=$.unstable_forceFrameRate=function(){}}else{var pe=window.setTimeout,he=window.clearTimeout;if("undefined"!=typeof console){var ge=window.cancelAnimationFrame;"function"!=typeof window.requestAnimationFrame&&console.error("This browser doesn't support requestAnimationFrame. Make sure that you load a polyfill in older browsers. https://reactjs.org/link/react-polyfills"),"function"!=typeof ge&&console.error("This browser doesn't support cancelAnimationFrame. Make sure that you load a polyfill in older browsers. https://reactjs.org/link/react-polyfills")}var ve=!1,we=null,Se=-1,Pe=5,je=0;$.unstable_shouldYield=function(){return $.unstable_now()>=je},ae=function(){},$.unstable_forceFrameRate=function($){0>$||125<$?console.error("forceFrameRate takes a positive int between 0 and 125, forcing frame rates higher than 125 fps is not supported"):Pe=0<$?Math.floor(1e3/$):5};var Ie=new MessageChannel,De=Ie.port2;Ie.port1.onmessage=function(){if(null!==we){var W=$.unstable_now();je=W+Pe;try{we(!0,W)?De.postMessage(null):(ve=!1,we=null)}catch($){throw De.postMessage(null),$}}else ve=!1},W=function($){we=$,ve||(ve=!0,De.postMessage(null))},G=function(W,G){Se=pe((function(){W($.unstable_now())}),G)},oe=function(){he(Se),Se=-1}}function H($,W){var G=$.length;$.push(W);e:for(;;){var oe=G-1>>>1,ae=$[oe];if(!(void 0!==ae&&0<I(ae,W)))break e;$[oe]=W,$[G]=ae,G=oe}}function J($){return void 0===($=$[0])?null:$}function K($){var W=$[0];if(void 0!==W){var G=$.pop();if(G!==W){$[0]=G;e:for(var oe=0,ae=$.length;oe<ae;){var ie=2*(oe+1)-1,se=$[ie],le=ie+1,ue=$[le];if(void 0!==se&&0>I(se,G))void 0!==ue&&0>I(ue,se)?($[oe]=ue,$[le]=G,oe=le):($[oe]=se,$[ie]=G,oe=ie);else{if(!(void 0!==ue&&0>I(ue,G)))break e;$[oe]=ue,$[le]=G,oe=le}}}return W}return null}function I($,W){var G=$.sortIndex-W.sortIndex;return 0!==G?G:$.id-W.id}var $e=[],Le=[],Ke=1,Ge=null,Xe=3,Ye=!1,Je=!1,Qe=!1;function T($){for(var W=J(Le);null!==W;){if(null===W.callback)K(Le);else{if(!(W.startTime<=$))break;K(Le),W.sortIndex=W.expirationTime,H($e,W)}W=J(Le)}}function U($){if(Qe=!1,T($),!Je)if(null!==J($e))Je=!0,W(V);else{var oe=J(Le);null!==oe&&G(U,oe.startTime-$)}}function V(W,ae){Je=!1,Qe&&(Qe=!1,oe()),Ye=!0;var ie=Xe;try{for(T(ae),Ge=J($e);null!==Ge&&(!(Ge.expirationTime>ae)||W&&!$.unstable_shouldYield());){var se=Ge.callback;if("function"==typeof se){Ge.callback=null,Xe=Ge.priorityLevel;var le=se(Ge.expirationTime<=ae);ae=$.unstable_now(),"function"==typeof le?Ge.callback=le:Ge===J($e)&&K($e),T(ae)}else K($e);Ge=J($e)}if(null!==Ge)var ue=!0;else{var de=J(Le);null!==de&&G(U,de.startTime-ae),ue=!1}return ue}finally{Ge=null,Xe=ie,Ye=!1}}var Ze=ae;$.unstable_IdlePriority=5,$.unstable_ImmediatePriority=1,$.unstable_LowPriority=4,$.unstable_NormalPriority=3,$.unstable_Profiling=null,$.unstable_UserBlockingPriority=2,$.unstable_cancelCallback=function($){$.callback=null},$.unstable_continueExecution=function(){Je||Ye||(Je=!0,W(V))},$.unstable_getCurrentPriorityLevel=function(){return Xe},$.unstable_getFirstCallbackNode=function(){return J($e)},$.unstable_next=function($){switch(Xe){case 1:case 2:case 3:var W=3;break;default:W=Xe}var G=Xe;Xe=W;try{return $()}finally{Xe=G}},$.unstable_pauseExecution=function(){},$.unstable_requestPaint=Ze,$.unstable_runWithPriority=function($,W){switch($){case 1:case 2:case 3:case 4:case 5:break;default:$=3}var G=Xe;Xe=$;try{return W()}finally{Xe=G}},$.unstable_scheduleCallback=function(ae,ie,se){var le=$.unstable_now();switch("object"==typeof se&&null!==se?se="number"==typeof(se=se.delay)&&0<se?le+se:le:se=le,ae){case 1:var ue=-1;break;case 2:ue=250;break;case 5:ue=1073741823;break;case 4:ue=1e4;break;default:ue=5e3}return ae={id:Ke++,callback:ie,priorityLevel:ae,startTime:se,expirationTime:ue=se+ue,sortIndex:-1},se>le?(ae.sortIndex=se,H(Le,ae),null===J($e)&&ae===J(Le)&&(Qe?oe():Qe=!0,G(U,se-le))):(ae.sortIndex=ue,H($e,ae),Je||Ye||(Je=!0,W(V))),ae},$.unstable_wrapCallback=function($){var W=Xe;return function(){var G=Xe;Xe=W;try{return $.apply(this,arguments)}finally{Xe=G}}}}(Kt),Ut.exports=Kt;
/** @license React v17.0.2
	 * react-dom.production.min.js
	 *
	 * Copyright (c) Facebook, Inc. and its affiliates.
	 *
	 * This source code is licensed under the MIT license found in the
	 * LICENSE file in the root directory of this source tree.
	 */
var Wt=vt.exports,Gt=xt,Xt=Ut.exports;function y$1($){for(var W="https://reactjs.org/docs/error-decoder.html?invariant="+$,G=1;G<arguments.length;G++)W+="&args[]="+encodeURIComponent(arguments[G]);return"Minified React error #"+$+"; visit "+W+" for the full message or use the non-minified dev environment for full errors and additional helpful warnings."}if(!Wt)throw Error(y$1(227));var Yt=new Set,Jt={};function da($,W){ea($,W),ea($+"Capture",W)}function ea($,W){for(Jt[$]=W,$=0;$<W.length;$++)Yt.add(W[$])}var Qt=!("undefined"==typeof window||void 0===window.document||void 0===window.document.createElement),Zt=/^[:A-Z_a-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD][:A-Z_a-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD\-.0-9\u00B7\u0300-\u036F\u203F-\u2040]*$/,er=Object.prototype.hasOwnProperty,tr={},rr={};function B$1($,W,G,oe,ae,ie,se){this.acceptsBooleans=2===W||3===W||4===W,this.attributeName=oe,this.attributeNamespace=ae,this.mustUseProperty=G,this.propertyName=$,this.type=W,this.sanitizeURL=ie,this.removeEmptyString=se}var nr={};"children dangerouslySetInnerHTML defaultValue defaultChecked innerHTML suppressContentEditableWarning suppressHydrationWarning style".split(" ").forEach((function($){nr[$]=new B$1($,0,!1,$,null,!1,!1)})),[["acceptCharset","accept-charset"],["className","class"],["htmlFor","for"],["httpEquiv","http-equiv"]].forEach((function($){var W=$[0];nr[W]=new B$1(W,1,!1,$[1],null,!1,!1)})),["contentEditable","draggable","spellCheck","value"].forEach((function($){nr[$]=new B$1($,2,!1,$.toLowerCase(),null,!1,!1)})),["autoReverse","externalResourcesRequired","focusable","preserveAlpha"].forEach((function($){nr[$]=new B$1($,2,!1,$,null,!1,!1)})),"allowFullScreen async autoFocus autoPlay controls default defer disabled disablePictureInPicture disableRemotePlayback formNoValidate hidden loop noModule noValidate open playsInline readOnly required reversed scoped seamless itemScope".split(" ").forEach((function($){nr[$]=new B$1($,3,!1,$.toLowerCase(),null,!1,!1)})),["checked","multiple","muted","selected"].forEach((function($){nr[$]=new B$1($,3,!0,$,null,!1,!1)})),["capture","download"].forEach((function($){nr[$]=new B$1($,4,!1,$,null,!1,!1)})),["cols","rows","size","span"].forEach((function($){nr[$]=new B$1($,6,!1,$,null,!1,!1)})),["rowSpan","start"].forEach((function($){nr[$]=new B$1($,5,!1,$.toLowerCase(),null,!1,!1)}));var or=/[\-:]([a-z])/g;function pa($){return $[1].toUpperCase()}function qa($,W,G,oe){var ae=nr.hasOwnProperty(W)?nr[W]:null;(null!==ae?0===ae.type:!oe&&(2<W.length&&("o"===W[0]||"O"===W[0])&&("n"===W[1]||"N"===W[1])))||(function na($,W,G,oe){if(null==W||function ma($,W,G,oe){if(null!==G&&0===G.type)return!1;switch(typeof W){case"function":case"symbol":return!0;case"boolean":return!oe&&(null!==G?!G.acceptsBooleans:"data-"!==($=$.toLowerCase().slice(0,5))&&"aria-"!==$);default:return!1}}($,W,G,oe))return!0;if(oe)return!1;if(null!==G)switch(G.type){case 3:return!W;case 4:return!1===W;case 5:return isNaN(W);case 6:return isNaN(W)||1>W}return!1}(W,G,ae,oe)&&(G=null),oe||null===ae?function la($){return!!er.call(rr,$)||!er.call(tr,$)&&(Zt.test($)?rr[$]=!0:(tr[$]=!0,!1))}(W)&&(null===G?$.removeAttribute(W):$.setAttribute(W,""+G)):ae.mustUseProperty?$[ae.propertyName]=null===G?3!==ae.type&&"":G:(W=ae.attributeName,oe=ae.attributeNamespace,null===G?$.removeAttribute(W):(G=3===(ae=ae.type)||4===ae&&!0===G?"":""+G,oe?$.setAttributeNS(oe,W,G):$.setAttribute(W,G))))}"accent-height alignment-baseline arabic-form baseline-shift cap-height clip-path clip-rule color-interpolation color-interpolation-filters color-profile color-rendering dominant-baseline enable-background fill-opacity fill-rule flood-color flood-opacity font-family font-size font-size-adjust font-stretch font-style font-variant font-weight glyph-name glyph-orientation-horizontal glyph-orientation-vertical horiz-adv-x horiz-origin-x image-rendering letter-spacing lighting-color marker-end marker-mid marker-start overline-position overline-thickness paint-order panose-1 pointer-events rendering-intent shape-rendering stop-color stop-opacity strikethrough-position strikethrough-thickness stroke-dasharray stroke-dashoffset stroke-linecap stroke-linejoin stroke-miterlimit stroke-opacity stroke-width text-anchor text-decoration text-rendering underline-position underline-thickness unicode-bidi unicode-range units-per-em v-alphabetic v-hanging v-ideographic v-mathematical vector-effect vert-adv-y vert-origin-x vert-origin-y word-spacing writing-mode xmlns:xlink x-height".split(" ").forEach((function($){var W=$.replace(or,pa);nr[W]=new B$1(W,1,!1,$,null,!1,!1)})),"xlink:actuate xlink:arcrole xlink:role xlink:show xlink:title xlink:type".split(" ").forEach((function($){var W=$.replace(or,pa);nr[W]=new B$1(W,1,!1,$,"http://www.w3.org/1999/xlink",!1,!1)})),["xml:base","xml:lang","xml:space"].forEach((function($){var W=$.replace(or,pa);nr[W]=new B$1(W,1,!1,$,"http://www.w3.org/XML/1998/namespace",!1,!1)})),["tabIndex","crossOrigin"].forEach((function($){nr[$]=new B$1($,1,!1,$.toLowerCase(),null,!1,!1)})),nr.xlinkHref=new B$1("xlinkHref",1,!1,"xlink:href","http://www.w3.org/1999/xlink",!0,!1),["src","href","action","formAction"].forEach((function($){nr[$]=new B$1($,1,!1,$.toLowerCase(),null,!0,!0)}));var ar=Wt.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED,ir=60103,sr=60106,lr=60107,ur=60108,cr=60114,dr=60109,fr=60110,pr=60112,hr=60113,mr=60120,gr=60115,vr=60116,yr=60121,br=60128,wr=60129,Sr=60130,xr=60131;if("function"==typeof Symbol&&Symbol.for){var kr=Symbol.for;ir=kr("react.element"),sr=kr("react.portal"),lr=kr("react.fragment"),ur=kr("react.strict_mode"),cr=kr("react.profiler"),dr=kr("react.provider"),fr=kr("react.context"),pr=kr("react.forward_ref"),hr=kr("react.suspense"),mr=kr("react.suspense_list"),gr=kr("react.memo"),vr=kr("react.lazy"),yr=kr("react.block"),kr("react.scope"),br=kr("react.opaque.id"),wr=kr("react.debug_trace_mode"),Sr=kr("react.offscreen"),xr=kr("react.legacy_hidden")}var _r,Pr="function"==typeof Symbol&&Symbol.iterator;function La($){return null===$||"object"!=typeof $?null:"function"==typeof($=Pr&&$[Pr]||$["@@iterator"])?$:null}function Na($){if(void 0===_r)try{throw Error()}catch($){var W=$.stack.trim().match(/\n( *(at )?)/);_r=W&&W[1]||""}return"\n"+_r+$}var Er=!1;function Pa($,W){if(!$||Er)return"";Er=!0;var G=Error.prepareStackTrace;Error.prepareStackTrace=void 0;try{if(W)if(W=function(){throw Error()},Object.defineProperty(W.prototype,"props",{set:function(){throw Error()}}),"object"==typeof Reflect&&Reflect.construct){try{Reflect.construct(W,[])}catch($){var oe=$}Reflect.construct($,[],W)}else{try{W.call()}catch($){oe=$}$.call(W.prototype)}else{try{throw Error()}catch($){oe=$}$()}}catch($){if($&&oe&&"string"==typeof $.stack){for(var ae=$.stack.split("\n"),ie=oe.stack.split("\n"),se=ae.length-1,le=ie.length-1;1<=se&&0<=le&&ae[se]!==ie[le];)le--;for(;1<=se&&0<=le;se--,le--)if(ae[se]!==ie[le]){if(1!==se||1!==le)do{if(se--,0>--le||ae[se]!==ie[le])return"\n"+ae[se].replace(" at new "," at ")}while(1<=se&&0<=le);break}}}finally{Er=!1,Error.prepareStackTrace=G}return($=$?$.displayName||$.name:"")?Na($):""}function Qa($){switch($.tag){case 5:return Na($.type);case 16:return Na("Lazy");case 13:return Na("Suspense");case 19:return Na("SuspenseList");case 0:case 2:case 15:return $=Pa($.type,!1);case 11:return $=Pa($.type.render,!1);case 22:return $=Pa($.type._render,!1);case 1:return $=Pa($.type,!0);default:return""}}function Ra($){if(null==$)return null;if("function"==typeof $)return $.displayName||$.name||null;if("string"==typeof $)return $;switch($){case lr:return"Fragment";case sr:return"Portal";case cr:return"Profiler";case ur:return"StrictMode";case hr:return"Suspense";case mr:return"SuspenseList"}if("object"==typeof $)switch($.$$typeof){case fr:return($.displayName||"Context")+".Consumer";case dr:return($._context.displayName||"Context")+".Provider";case pr:var W=$.render;return W=W.displayName||W.name||"",$.displayName||(""!==W?"ForwardRef("+W+")":"ForwardRef");case gr:return Ra($.type);case yr:return Ra($._render);case vr:W=$._payload,$=$._init;try{return Ra($(W))}catch($){}}return null}function Sa($){switch(typeof $){case"boolean":case"number":case"object":case"string":case"undefined":return $;default:return""}}function Ta($){var W=$.type;return($=$.nodeName)&&"input"===$.toLowerCase()&&("checkbox"===W||"radio"===W)}function Va($){$._valueTracker||($._valueTracker=function Ua($){var W=Ta($)?"checked":"value",G=Object.getOwnPropertyDescriptor($.constructor.prototype,W),oe=""+$[W];if(!$.hasOwnProperty(W)&&void 0!==G&&"function"==typeof G.get&&"function"==typeof G.set){var ae=G.get,ie=G.set;return Object.defineProperty($,W,{configurable:!0,get:function(){return ae.call(this)},set:function($){oe=""+$,ie.call(this,$)}}),Object.defineProperty($,W,{enumerable:G.enumerable}),{getValue:function(){return oe},setValue:function($){oe=""+$},stopTracking:function(){$._valueTracker=null,delete $[W]}}}}($))}function Wa($){if(!$)return!1;var W=$._valueTracker;if(!W)return!0;var G=W.getValue(),oe="";return $&&(oe=Ta($)?$.checked?"true":"false":$.value),($=oe)!==G&&(W.setValue($),!0)}function Xa($){if(void 0===($=$||("undefined"!=typeof document?document:void 0)))return null;try{return $.activeElement||$.body}catch(W){return $.body}}function Ya($,W){var G=W.checked;return Gt({},W,{defaultChecked:void 0,defaultValue:void 0,value:void 0,checked:null!=G?G:$._wrapperState.initialChecked})}function Za($,W){var G=null==W.defaultValue?"":W.defaultValue,oe=null!=W.checked?W.checked:W.defaultChecked;G=Sa(null!=W.value?W.value:G),$._wrapperState={initialChecked:oe,initialValue:G,controlled:"checkbox"===W.type||"radio"===W.type?null!=W.checked:null!=W.value}}function $a($,W){null!=(W=W.checked)&&qa($,"checked",W,!1)}function ab($,W){$a($,W);var G=Sa(W.value),oe=W.type;if(null!=G)"number"===oe?(0===G&&""===$.value||$.value!=G)&&($.value=""+G):$.value!==""+G&&($.value=""+G);else if("submit"===oe||"reset"===oe)return void $.removeAttribute("value");W.hasOwnProperty("value")?bb($,W.type,G):W.hasOwnProperty("defaultValue")&&bb($,W.type,Sa(W.defaultValue)),null==W.checked&&null!=W.defaultChecked&&($.defaultChecked=!!W.defaultChecked)}function cb($,W,G){if(W.hasOwnProperty("value")||W.hasOwnProperty("defaultValue")){var oe=W.type;if(!("submit"!==oe&&"reset"!==oe||void 0!==W.value&&null!==W.value))return;W=""+$._wrapperState.initialValue,G||W===$.value||($.value=W),$.defaultValue=W}""!==(G=$.name)&&($.name=""),$.defaultChecked=!!$._wrapperState.initialChecked,""!==G&&($.name=G)}function bb($,W,G){"number"===W&&Xa($.ownerDocument)===$||(null==G?$.defaultValue=""+$._wrapperState.initialValue:$.defaultValue!==""+G&&($.defaultValue=""+G))}function eb($,W){return $=Gt({children:void 0},W),(W=function db($){var W="";return Wt.Children.forEach($,(function($){null!=$&&(W+=$)})),W}(W.children))&&($.children=W),$}function fb($,W,G,oe){if($=$.options,W){W={};for(var ae=0;ae<G.length;ae++)W["$"+G[ae]]=!0;for(G=0;G<$.length;G++)ae=W.hasOwnProperty("$"+$[G].value),$[G].selected!==ae&&($[G].selected=ae),ae&&oe&&($[G].defaultSelected=!0)}else{for(G=""+Sa(G),W=null,ae=0;ae<$.length;ae++){if($[ae].value===G)return $[ae].selected=!0,void(oe&&($[ae].defaultSelected=!0));null!==W||$[ae].disabled||(W=$[ae])}null!==W&&(W.selected=!0)}}function gb($,W){if(null!=W.dangerouslySetInnerHTML)throw Error(y$1(91));return Gt({},W,{value:void 0,defaultValue:void 0,children:""+$._wrapperState.initialValue})}function hb($,W){var G=W.value;if(null==G){if(G=W.children,W=W.defaultValue,null!=G){if(null!=W)throw Error(y$1(92));if(Array.isArray(G)){if(!(1>=G.length))throw Error(y$1(93));G=G[0]}W=G}null==W&&(W=""),G=W}$._wrapperState={initialValue:Sa(G)}}function ib($,W){var G=Sa(W.value),oe=Sa(W.defaultValue);null!=G&&((G=""+G)!==$.value&&($.value=G),null==W.defaultValue&&$.defaultValue!==G&&($.defaultValue=G)),null!=oe&&($.defaultValue=""+oe)}function jb($){var W=$.textContent;W===$._wrapperState.initialValue&&""!==W&&null!==W&&($.value=W)}var jr="http://www.w3.org/1999/xhtml",Cr="http://www.w3.org/2000/svg";function lb($){switch($){case"svg":return"http://www.w3.org/2000/svg";case"math":return"http://www.w3.org/1998/Math/MathML";default:return"http://www.w3.org/1999/xhtml"}}function mb($,W){return null==$||"http://www.w3.org/1999/xhtml"===$?lb(W):"http://www.w3.org/2000/svg"===$&&"foreignObject"===W?"http://www.w3.org/1999/xhtml":$}var Or,Ir,Tr=(Ir=function($,W){if($.namespaceURI!==Cr||"innerHTML"in $)$.innerHTML=W;else{for((Or=Or||document.createElement("div")).innerHTML="<svg>"+W.valueOf().toString()+"</svg>",W=Or.firstChild;$.firstChild;)$.removeChild($.firstChild);for(;W.firstChild;)$.appendChild(W.firstChild)}},"undefined"!=typeof MSApp&&MSApp.execUnsafeLocalFunction?function($,W,G,oe){MSApp.execUnsafeLocalFunction((function(){return Ir($,W)}))}:Ir);function pb($,W){if(W){var G=$.firstChild;if(G&&G===$.lastChild&&3===G.nodeType)return void(G.nodeValue=W)}$.textContent=W}var Dr={animationIterationCount:!0,borderImageOutset:!0,borderImageSlice:!0,borderImageWidth:!0,boxFlex:!0,boxFlexGroup:!0,boxOrdinalGroup:!0,columnCount:!0,columns:!0,flex:!0,flexGrow:!0,flexPositive:!0,flexShrink:!0,flexNegative:!0,flexOrder:!0,gridArea:!0,gridRow:!0,gridRowEnd:!0,gridRowSpan:!0,gridRowStart:!0,gridColumn:!0,gridColumnEnd:!0,gridColumnSpan:!0,gridColumnStart:!0,fontWeight:!0,lineClamp:!0,lineHeight:!0,opacity:!0,order:!0,orphans:!0,tabSize:!0,widows:!0,zIndex:!0,zoom:!0,fillOpacity:!0,floodOpacity:!0,stopOpacity:!0,strokeDasharray:!0,strokeDashoffset:!0,strokeMiterlimit:!0,strokeOpacity:!0,strokeWidth:!0},Ar=["Webkit","ms","Moz","O"];function sb($,W,G){return null==W||"boolean"==typeof W||""===W?"":G||"number"!=typeof W||0===W||Dr.hasOwnProperty($)&&Dr[$]?(""+W).trim():W+"px"}function tb($,W){for(var G in $=$.style,W)if(W.hasOwnProperty(G)){var oe=0===G.indexOf("--"),ae=sb(G,W[G],oe);"float"===G&&(G="cssFloat"),oe?$.setProperty(G,ae):$[G]=ae}}Object.keys(Dr).forEach((function($){Ar.forEach((function(W){W=W+$.charAt(0).toUpperCase()+$.substring(1),Dr[W]=Dr[$]}))}));var $r=Gt({menuitem:!0},{area:!0,base:!0,br:!0,col:!0,embed:!0,hr:!0,img:!0,input:!0,keygen:!0,link:!0,meta:!0,param:!0,source:!0,track:!0,wbr:!0});function vb($,W){if(W){if($r[$]&&(null!=W.children||null!=W.dangerouslySetInnerHTML))throw Error(y$1(137,$));if(null!=W.dangerouslySetInnerHTML){if(null!=W.children)throw Error(y$1(60));if("object"!=typeof W.dangerouslySetInnerHTML||!("__html"in W.dangerouslySetInnerHTML))throw Error(y$1(61))}if(null!=W.style&&"object"!=typeof W.style)throw Error(y$1(62))}}function wb($,W){if(-1===$.indexOf("-"))return"string"==typeof W.is;switch($){case"annotation-xml":case"color-profile":case"font-face":case"font-face-src":case"font-face-uri":case"font-face-format":case"font-face-name":case"missing-glyph":return!1;default:return!0}}function xb($){return($=$.target||$.srcElement||window).correspondingUseElement&&($=$.correspondingUseElement),3===$.nodeType?$.parentNode:$}var zr=null,Mr=null,Rr=null;function Bb($){if($=Cb($)){if("function"!=typeof zr)throw Error(y$1(280));var W=$.stateNode;W&&(W=Db(W),zr($.stateNode,$.type,W))}}function Eb($){Mr?Rr?Rr.push($):Rr=[$]:Mr=$}function Fb(){if(Mr){var $=Mr,W=Rr;if(Rr=Mr=null,Bb($),W)for($=0;$<W.length;$++)Bb(W[$])}}function Gb($,W){return $(W)}function Hb($,W,G,oe,ae){return $(W,G,oe,ae)}function Ib(){}var Br=Gb,Fr=!1,Nr=!1;function Mb(){null===Mr&&null===Rr||(Ib(),Fb())}function Ob($,W){var G=$.stateNode;if(null===G)return null;var oe=Db(G);if(null===oe)return null;G=oe[W];e:switch(W){case"onClick":case"onClickCapture":case"onDoubleClick":case"onDoubleClickCapture":case"onMouseDown":case"onMouseDownCapture":case"onMouseMove":case"onMouseMoveCapture":case"onMouseUp":case"onMouseUpCapture":case"onMouseEnter":(oe=!oe.disabled)||(oe=!("button"===($=$.type)||"input"===$||"select"===$||"textarea"===$)),$=!oe;break e;default:$=!1}if($)return null;if(G&&"function"!=typeof G)throw Error(y$1(231,W,typeof G));return G}var Lr=!1;if(Qt)try{var Hr={};Object.defineProperty(Hr,"passive",{get:function(){Lr=!0}}),window.addEventListener("test",Hr,Hr),window.removeEventListener("test",Hr,Hr)}catch(Ir){Lr=!1}function Rb($,W,G,oe,ae,ie,se,le,ue){var de=Array.prototype.slice.call(arguments,3);try{W.apply(G,de)}catch($){this.onError($)}}var Vr=!1,qr=null,Ur=!1,Kr=null,Wr={onError:function($){Vr=!0,qr=$}};function Xb($,W,G,oe,ae,ie,se,le,ue){Vr=!1,qr=null,Rb.apply(Wr,arguments)}function Zb($){var W=$,G=$;if($.alternate)for(;W.return;)W=W.return;else{$=W;do{0!=(1026&(W=$).flags)&&(G=W.return),$=W.return}while($)}return 3===W.tag?G:null}function $b($){if(13===$.tag){var W=$.memoizedState;if(null===W&&(null!==($=$.alternate)&&(W=$.memoizedState)),null!==W)return W.dehydrated}return null}function ac($){if(Zb($)!==$)throw Error(y$1(188))}function cc($){if($=function bc($){var W=$.alternate;if(!W){if(null===(W=Zb($)))throw Error(y$1(188));return W!==$?null:$}for(var G=$,oe=W;;){var ae=G.return;if(null===ae)break;var ie=ae.alternate;if(null===ie){if(null!==(oe=ae.return)){G=oe;continue}break}if(ae.child===ie.child){for(ie=ae.child;ie;){if(ie===G)return ac(ae),$;if(ie===oe)return ac(ae),W;ie=ie.sibling}throw Error(y$1(188))}if(G.return!==oe.return)G=ae,oe=ie;else{for(var se=!1,le=ae.child;le;){if(le===G){se=!0,G=ae,oe=ie;break}if(le===oe){se=!0,oe=ae,G=ie;break}le=le.sibling}if(!se){for(le=ie.child;le;){if(le===G){se=!0,G=ie,oe=ae;break}if(le===oe){se=!0,oe=ie,G=ae;break}le=le.sibling}if(!se)throw Error(y$1(189))}}if(G.alternate!==oe)throw Error(y$1(190))}if(3!==G.tag)throw Error(y$1(188));return G.stateNode.current===G?$:W}($),!$)return null;for(var W=$;;){if(5===W.tag||6===W.tag)return W;if(W.child)W.child.return=W,W=W.child;else{if(W===$)break;for(;!W.sibling;){if(!W.return||W.return===$)return null;W=W.return}W.sibling.return=W.return,W=W.sibling}}return null}function dc($,W){for(var G=$.alternate;null!==W;){if(W===$||W===G)return!0;W=W.return}return!1}var Gr,Xr,Yr,Jr,Qr=!1,Zr=[],en=null,tn=null,rn=null,nn=new Map,an=new Map,sn=[],ln="mousedown mouseup touchcancel touchend touchstart auxclick dblclick pointercancel pointerdown pointerup dragend dragstart drop compositionend compositionstart keydown keypress keyup input textInput copy cut paste click change contextmenu reset submit".split(" ");function rc($,W,G,oe,ae){return{blockedOn:$,domEventName:W,eventSystemFlags:16|G,nativeEvent:ae,targetContainers:[oe]}}function sc($,W){switch($){case"focusin":case"focusout":en=null;break;case"dragenter":case"dragleave":tn=null;break;case"mouseover":case"mouseout":rn=null;break;case"pointerover":case"pointerout":nn.delete(W.pointerId);break;case"gotpointercapture":case"lostpointercapture":an.delete(W.pointerId)}}function tc($,W,G,oe,ae,ie){return null===$||$.nativeEvent!==ie?($=rc(W,G,oe,ae,ie),null!==W&&(null!==(W=Cb(W))&&Xr(W)),$):($.eventSystemFlags|=oe,W=$.targetContainers,null!==ae&&-1===W.indexOf(ae)&&W.push(ae),$)}function vc($){var W=wc($.target);if(null!==W){var G=Zb(W);if(null!==G)if(13===(W=G.tag)){if(null!==(W=$b(G)))return $.blockedOn=W,void Jr($.lanePriority,(function(){Xt.unstable_runWithPriority($.priority,(function(){Yr(G)}))}))}else if(3===W&&G.stateNode.hydrate)return void($.blockedOn=3===G.tag?G.stateNode.containerInfo:null)}$.blockedOn=null}function xc($){if(null!==$.blockedOn)return!1;for(var W=$.targetContainers;0<W.length;){var G=yc($.domEventName,$.eventSystemFlags,W[0],$.nativeEvent);if(null!==G)return null!==(W=Cb(G))&&Xr(W),$.blockedOn=G,!1;W.shift()}return!0}function zc($,W,G){xc($)&&G.delete(W)}function Ac(){for(Qr=!1;0<Zr.length;){var $=Zr[0];if(null!==$.blockedOn){null!==($=Cb($.blockedOn))&&Gr($);break}for(var W=$.targetContainers;0<W.length;){var G=yc($.domEventName,$.eventSystemFlags,W[0],$.nativeEvent);if(null!==G){$.blockedOn=G;break}W.shift()}null===$.blockedOn&&Zr.shift()}null!==en&&xc(en)&&(en=null),null!==tn&&xc(tn)&&(tn=null),null!==rn&&xc(rn)&&(rn=null),nn.forEach(zc),an.forEach(zc)}function Bc($,W){$.blockedOn===W&&($.blockedOn=null,Qr||(Qr=!0,Xt.unstable_scheduleCallback(Xt.unstable_NormalPriority,Ac)))}function Cc($){function b(W){return Bc(W,$)}if(0<Zr.length){Bc(Zr[0],$);for(var W=1;W<Zr.length;W++){var G=Zr[W];G.blockedOn===$&&(G.blockedOn=null)}}for(null!==en&&Bc(en,$),null!==tn&&Bc(tn,$),null!==rn&&Bc(rn,$),nn.forEach(b),an.forEach(b),W=0;W<sn.length;W++)(G=sn[W]).blockedOn===$&&(G.blockedOn=null);for(;0<sn.length&&null===(W=sn[0]).blockedOn;)vc(W),null===W.blockedOn&&sn.shift()}function Dc($,W){var G={};return G[$.toLowerCase()]=W.toLowerCase(),G["Webkit"+$]="webkit"+W,G["Moz"+$]="moz"+W,G}var un={animationend:Dc("Animation","AnimationEnd"),animationiteration:Dc("Animation","AnimationIteration"),animationstart:Dc("Animation","AnimationStart"),transitionend:Dc("Transition","TransitionEnd")},cn={},dn={};function Hc($){if(cn[$])return cn[$];if(!un[$])return $;var W,G=un[$];for(W in G)if(G.hasOwnProperty(W)&&W in dn)return cn[$]=G[W];return $}Qt&&(dn=document.createElement("div").style,"AnimationEvent"in window||(delete un.animationend.animation,delete un.animationiteration.animation,delete un.animationstart.animation),"TransitionEvent"in window||delete un.transitionend.transition);var fn=Hc("animationend"),pn=Hc("animationiteration"),hn=Hc("animationstart"),mn=Hc("transitionend"),gn=new Map,vn=new Map,yn=["abort","abort",fn,"animationEnd",pn,"animationIteration",hn,"animationStart","canplay","canPlay","canplaythrough","canPlayThrough","durationchange","durationChange","emptied","emptied","encrypted","encrypted","ended","ended","error","error","gotpointercapture","gotPointerCapture","load","load","loadeddata","loadedData","loadedmetadata","loadedMetadata","loadstart","loadStart","lostpointercapture","lostPointerCapture","playing","playing","progress","progress","seeking","seeking","stalled","stalled","suspend","suspend","timeupdate","timeUpdate",mn,"transitionEnd","waiting","waiting"];function Pc($,W){for(var G=0;G<$.length;G+=2){var oe=$[G],ae=$[G+1];ae="on"+(ae[0].toUpperCase()+ae.slice(1)),vn.set(oe,W),gn.set(oe,ae),da(ae,[oe])}}(0,Xt.unstable_now)();var bn=8;function Rc($){if(0!=(1&$))return bn=15,1;if(0!=(2&$))return bn=14,2;if(0!=(4&$))return bn=13,4;var W=24&$;return 0!==W?(bn=12,W):0!=(32&$)?(bn=11,32):0!==(W=192&$)?(bn=10,W):0!=(256&$)?(bn=9,256):0!==(W=3584&$)?(bn=8,W):0!=(4096&$)?(bn=7,4096):0!==(W=4186112&$)?(bn=6,W):0!==(W=62914560&$)?(bn=5,W):67108864&$?(bn=4,67108864):0!=(134217728&$)?(bn=3,134217728):0!==(W=805306368&$)?(bn=2,W):0!=(1073741824&$)?(bn=1,1073741824):(bn=8,$)}function Uc($,W){var G=$.pendingLanes;if(0===G)return bn=0;var oe=0,ae=0,ie=$.expiredLanes,se=$.suspendedLanes,le=$.pingedLanes;if(0!==ie)oe=ie,ae=bn=15;else if(0!==(ie=134217727&G)){var ue=ie&~se;0!==ue?(oe=Rc(ue),ae=bn):0!==(le&=ie)&&(oe=Rc(le),ae=bn)}else 0!==(ie=G&~se)?(oe=Rc(ie),ae=bn):0!==le&&(oe=Rc(le),ae=bn);if(0===oe)return 0;if(oe=G&((0>(oe=31-wn(oe))?0:1<<oe)<<1)-1,0!==W&&W!==oe&&0==(W&se)){if(Rc(W),ae<=bn)return W;bn=ae}if(0!==(W=$.entangledLanes))for($=$.entanglements,W&=oe;0<W;)ae=1<<(G=31-wn(W)),oe|=$[G],W&=~ae;return oe}function Wc($){return 0!==($=-1073741825&$.pendingLanes)?$:1073741824&$?1073741824:0}function Xc($,W){switch($){case 15:return 1;case 14:return 2;case 12:return 0===($=Yc(24&~W))?Xc(10,W):$;case 10:return 0===($=Yc(192&~W))?Xc(8,W):$;case 8:return 0===($=Yc(3584&~W))&&(0===($=Yc(4186112&~W))&&($=512)),$;case 2:return 0===(W=Yc(805306368&~W))&&(W=268435456),W}throw Error(y$1(358,$))}function Yc($){return $&-$}function Zc($){for(var W=[],G=0;31>G;G++)W.push($);return W}function $c($,W,G){$.pendingLanes|=W;var oe=W-1;$.suspendedLanes&=oe,$.pingedLanes&=oe,($=$.eventTimes)[W=31-wn(W)]=G}var wn=Math.clz32?Math.clz32:function ad($){return 0===$?32:31-(Sn($)/xn|0)|0},Sn=Math.log,xn=Math.LN2;var kn=Xt.unstable_UserBlockingPriority,_n=Xt.unstable_runWithPriority,Pn=!0;function gd($,W,G,oe){Fr||Ib();var ae=hd,ie=Fr;Fr=!0;try{Hb(ae,$,W,G,oe)}finally{(Fr=ie)||Mb()}}function id($,W,G,oe){_n(kn,hd.bind(null,$,W,G,oe))}function hd($,W,G,oe){var ae;if(Pn)if((ae=0==(4&W))&&0<Zr.length&&-1<ln.indexOf($))$=rc(null,$,W,G,oe),Zr.push($);else{var ie=yc($,W,G,oe);if(null===ie)ae&&sc($,oe);else{if(ae){if(-1<ln.indexOf($))return $=rc(ie,$,W,G,oe),void Zr.push($);if(function uc($,W,G,oe,ae){switch(W){case"focusin":return en=tc(en,$,W,G,oe,ae),!0;case"dragenter":return tn=tc(tn,$,W,G,oe,ae),!0;case"mouseover":return rn=tc(rn,$,W,G,oe,ae),!0;case"pointerover":var ie=ae.pointerId;return nn.set(ie,tc(nn.get(ie)||null,$,W,G,oe,ae)),!0;case"gotpointercapture":return ie=ae.pointerId,an.set(ie,tc(an.get(ie)||null,$,W,G,oe,ae)),!0}return!1}(ie,$,W,G,oe))return;sc($,oe)}jd($,W,oe,null,G)}}}function yc($,W,G,oe){var ae=xb(oe);if(null!==(ae=wc(ae))){var ie=Zb(ae);if(null===ie)ae=null;else{var se=ie.tag;if(13===se){if(null!==(ae=$b(ie)))return ae;ae=null}else if(3===se){if(ie.stateNode.hydrate)return 3===ie.tag?ie.stateNode.containerInfo:null;ae=null}else ie!==ae&&(ae=null)}}return jd($,W,oe,ae,G),null}var En=null,jn=null,Cn=null;function nd(){if(Cn)return Cn;var $,W,G=jn,oe=G.length,ae="value"in En?En.value:En.textContent,ie=ae.length;for($=0;$<oe&&G[$]===ae[$];$++);var se=oe-$;for(W=1;W<=se&&G[oe-W]===ae[ie-W];W++);return Cn=ae.slice($,1<W?1-W:void 0)}function od($){var W=$.keyCode;return"charCode"in $?0===($=$.charCode)&&13===W&&($=13):$=W,10===$&&($=13),32<=$||13===$?$:0}function pd(){return!0}function qd(){return!1}function rd($){function b(W,G,oe,ae,ie){for(var se in this._reactName=W,this._targetInst=oe,this.type=G,this.nativeEvent=ae,this.target=ie,this.currentTarget=null,$)$.hasOwnProperty(se)&&(W=$[se],this[se]=W?W(ae):ae[se]);return this.isDefaultPrevented=(null!=ae.defaultPrevented?ae.defaultPrevented:!1===ae.returnValue)?pd:qd,this.isPropagationStopped=qd,this}return Gt(b.prototype,{preventDefault:function(){this.defaultPrevented=!0;var $=this.nativeEvent;$&&($.preventDefault?$.preventDefault():"unknown"!=typeof $.returnValue&&($.returnValue=!1),this.isDefaultPrevented=pd)},stopPropagation:function(){var $=this.nativeEvent;$&&($.stopPropagation?$.stopPropagation():"unknown"!=typeof $.cancelBubble&&($.cancelBubble=!0),this.isPropagationStopped=pd)},persist:function(){},isPersistent:pd}),b}var On,In,Tn,Dn={eventPhase:0,bubbles:0,cancelable:0,timeStamp:function($){return $.timeStamp||Date.now()},defaultPrevented:0,isTrusted:0},An=rd(Dn),$n=Gt({},Dn,{view:0,detail:0}),zn=rd($n),Mn=Gt({},$n,{screenX:0,screenY:0,clientX:0,clientY:0,pageX:0,pageY:0,ctrlKey:0,shiftKey:0,altKey:0,metaKey:0,getModifierState:zd,button:0,buttons:0,relatedTarget:function($){return void 0===$.relatedTarget?$.fromElement===$.srcElement?$.toElement:$.fromElement:$.relatedTarget},movementX:function($){return"movementX"in $?$.movementX:($!==Tn&&(Tn&&"mousemove"===$.type?(On=$.screenX-Tn.screenX,In=$.screenY-Tn.screenY):In=On=0,Tn=$),On)},movementY:function($){return"movementY"in $?$.movementY:In}}),Rn=rd(Mn),Bn=rd(Gt({},Mn,{dataTransfer:0})),Fn=rd(Gt({},$n,{relatedTarget:0})),Nn=rd(Gt({},Dn,{animationName:0,elapsedTime:0,pseudoElement:0})),Ln=Gt({},Dn,{clipboardData:function($){return"clipboardData"in $?$.clipboardData:window.clipboardData}}),Hn=rd(Ln),Vn=rd(Gt({},Dn,{data:0})),qn={Esc:"Escape",Spacebar:" ",Left:"ArrowLeft",Up:"ArrowUp",Right:"ArrowRight",Down:"ArrowDown",Del:"Delete",Win:"OS",Menu:"ContextMenu",Apps:"ContextMenu",Scroll:"ScrollLock",MozPrintableKey:"Unidentified"},Un={8:"Backspace",9:"Tab",12:"Clear",13:"Enter",16:"Shift",17:"Control",18:"Alt",19:"Pause",20:"CapsLock",27:"Escape",32:" ",33:"PageUp",34:"PageDown",35:"End",36:"Home",37:"ArrowLeft",38:"ArrowUp",39:"ArrowRight",40:"ArrowDown",45:"Insert",46:"Delete",112:"F1",113:"F2",114:"F3",115:"F4",116:"F5",117:"F6",118:"F7",119:"F8",120:"F9",121:"F10",122:"F11",123:"F12",144:"NumLock",145:"ScrollLock",224:"Meta"},Kn={Alt:"altKey",Control:"ctrlKey",Meta:"metaKey",Shift:"shiftKey"};function Pd($){var W=this.nativeEvent;return W.getModifierState?W.getModifierState($):!!($=Kn[$])&&!!W[$]}function zd(){return Pd}var Wn=Gt({},$n,{key:function($){if($.key){var W=qn[$.key]||$.key;if("Unidentified"!==W)return W}return"keypress"===$.type?13===($=od($))?"Enter":String.fromCharCode($):"keydown"===$.type||"keyup"===$.type?Un[$.keyCode]||"Unidentified":""},code:0,location:0,ctrlKey:0,shiftKey:0,altKey:0,metaKey:0,repeat:0,locale:0,getModifierState:zd,charCode:function($){return"keypress"===$.type?od($):0},keyCode:function($){return"keydown"===$.type||"keyup"===$.type?$.keyCode:0},which:function($){return"keypress"===$.type?od($):"keydown"===$.type||"keyup"===$.type?$.keyCode:0}}),Gn=rd(Wn),Xn=rd(Gt({},Mn,{pointerId:0,width:0,height:0,pressure:0,tangentialPressure:0,tiltX:0,tiltY:0,twist:0,pointerType:0,isPrimary:0})),Yn=rd(Gt({},$n,{touches:0,targetTouches:0,changedTouches:0,altKey:0,metaKey:0,ctrlKey:0,shiftKey:0,getModifierState:zd})),Jn=rd(Gt({},Dn,{propertyName:0,elapsedTime:0,pseudoElement:0})),Qn=Gt({},Mn,{deltaX:function($){return"deltaX"in $?$.deltaX:"wheelDeltaX"in $?-$.wheelDeltaX:0},deltaY:function($){return"deltaY"in $?$.deltaY:"wheelDeltaY"in $?-$.wheelDeltaY:"wheelDelta"in $?-$.wheelDelta:0},deltaZ:0,deltaMode:0}),Zn=rd(Qn),eo=[9,13,27,32],to=Qt&&"CompositionEvent"in window,ro=null;Qt&&"documentMode"in document&&(ro=document.documentMode);var no=Qt&&"TextEvent"in window&&!ro,oo=Qt&&(!to||ro&&8<ro&&11>=ro),ao=String.fromCharCode(32),io=!1;function ge$1($,W){switch($){case"keyup":return-1!==eo.indexOf(W.keyCode);case"keydown":return 229!==W.keyCode;case"keypress":case"mousedown":case"focusout":return!0;default:return!1}}function he$1($){return"object"==typeof($=$.detail)&&"data"in $?$.data:null}var so=!1;var lo={color:!0,date:!0,datetime:!0,"datetime-local":!0,email:!0,month:!0,number:!0,password:!0,range:!0,search:!0,tel:!0,text:!0,time:!0,url:!0,week:!0};function me$1($){var W=$&&$.nodeName&&$.nodeName.toLowerCase();return"input"===W?!!lo[$.type]:"textarea"===W}function ne$1($,W,G,oe){Eb(oe),0<(W=oe$1(W,"onChange")).length&&(G=new An("onChange","change",null,G,oe),$.push({event:G,listeners:W}))}var uo=null,co=null;function re$1($){se$1($,0)}function te$1($){if(Wa(ue$1($)))return $}function ve$1($,W){if("change"===$)return W}var fo=!1;if(Qt){var po;if(Qt){var ho="oninput"in document;if(!ho){var mo=document.createElement("div");mo.setAttribute("oninput","return;"),ho="function"==typeof mo.oninput}po=ho}else po=!1;fo=po&&(!document.documentMode||9<document.documentMode)}function Ae$1(){uo&&(uo.detachEvent("onpropertychange",Be$1),co=uo=null)}function Be$1($){if("value"===$.propertyName&&te$1(co)){var W=[];if(ne$1(W,co,$,xb($)),$=re$1,Fr)$(W);else{Fr=!0;try{Gb($,W)}finally{Fr=!1,Mb()}}}}function Ce$1($,W,G){"focusin"===$?(Ae$1(),co=G,(uo=W).attachEvent("onpropertychange",Be$1)):"focusout"===$&&Ae$1()}function De$1($){if("selectionchange"===$||"keyup"===$||"keydown"===$)return te$1(co)}function Ee$1($,W){if("click"===$)return te$1(W)}function Fe$1($,W){if("input"===$||"change"===$)return te$1(W)}var go="function"==typeof Object.is?Object.is:function Ge$1($,W){return $===W&&(0!==$||1/$==1/W)||$!=$&&W!=W},vo=Object.prototype.hasOwnProperty;function Je$1($,W){if(go($,W))return!0;if("object"!=typeof $||null===$||"object"!=typeof W||null===W)return!1;var G=Object.keys($),oe=Object.keys(W);if(G.length!==oe.length)return!1;for(oe=0;oe<G.length;oe++)if(!vo.call(W,G[oe])||!go($[G[oe]],W[G[oe]]))return!1;return!0}function Ke$1($){for(;$&&$.firstChild;)$=$.firstChild;return $}function Le$1($,W){var G,oe=Ke$1($);for($=0;oe;){if(3===oe.nodeType){if(G=$+oe.textContent.length,$<=W&&G>=W)return{node:oe,offset:W-$};$=G}e:{for(;oe;){if(oe.nextSibling){oe=oe.nextSibling;break e}oe=oe.parentNode}oe=void 0}oe=Ke$1(oe)}}function Me$1($,W){return!(!$||!W)&&($===W||(!$||3!==$.nodeType)&&(W&&3===W.nodeType?Me$1($,W.parentNode):"contains"in $?$.contains(W):!!$.compareDocumentPosition&&!!(16&$.compareDocumentPosition(W))))}function Ne$1(){for(var $=window,W=Xa();W instanceof $.HTMLIFrameElement;){try{var G="string"==typeof W.contentWindow.location.href}catch($){G=!1}if(!G)break;W=Xa(($=W.contentWindow).document)}return W}function Oe($){var W=$&&$.nodeName&&$.nodeName.toLowerCase();return W&&("input"===W&&("text"===$.type||"search"===$.type||"tel"===$.type||"url"===$.type||"password"===$.type)||"textarea"===W||"true"===$.contentEditable)}var yo=Qt&&"documentMode"in document&&11>=document.documentMode,bo=null,wo=null,So=null,xo=!1;function Ue$1($,W,G){var oe=G.window===G?G.document:9===G.nodeType?G:G.ownerDocument;xo||null==bo||bo!==Xa(oe)||("selectionStart"in(oe=bo)&&Oe(oe)?oe={start:oe.selectionStart,end:oe.selectionEnd}:oe={anchorNode:(oe=(oe.ownerDocument&&oe.ownerDocument.defaultView||window).getSelection()).anchorNode,anchorOffset:oe.anchorOffset,focusNode:oe.focusNode,focusOffset:oe.focusOffset},So&&Je$1(So,oe)||(So=oe,0<(oe=oe$1(wo,"onSelect")).length&&(W=new An("onSelect","select",null,W,G),$.push({event:W,listeners:oe}),W.target=bo)))}Pc("cancel cancel click click close close contextmenu contextMenu copy copy cut cut auxclick auxClick dblclick doubleClick dragend dragEnd dragstart dragStart drop drop focusin focus focusout blur input input invalid invalid keydown keyDown keypress keyPress keyup keyUp mousedown mouseDown mouseup mouseUp paste paste pause pause play play pointercancel pointerCancel pointerdown pointerDown pointerup pointerUp ratechange rateChange reset reset seeked seeked submit submit touchcancel touchCancel touchend touchEnd touchstart touchStart volumechange volumeChange".split(" "),0),Pc("drag drag dragenter dragEnter dragexit dragExit dragleave dragLeave dragover dragOver mousemove mouseMove mouseout mouseOut mouseover mouseOver pointermove pointerMove pointerout pointerOut pointerover pointerOver scroll scroll toggle toggle touchmove touchMove wheel wheel".split(" "),1),Pc(yn,2);for(var ko="change selectionchange textInput compositionstart compositionend compositionupdate".split(" "),_o=0;_o<ko.length;_o++)vn.set(ko[_o],0);ea("onMouseEnter",["mouseout","mouseover"]),ea("onMouseLeave",["mouseout","mouseover"]),ea("onPointerEnter",["pointerout","pointerover"]),ea("onPointerLeave",["pointerout","pointerover"]),da("onChange","change click focusin focusout input keydown keyup selectionchange".split(" ")),da("onSelect","focusout contextmenu dragend focusin keydown keyup mousedown mouseup selectionchange".split(" ")),da("onBeforeInput",["compositionend","keypress","textInput","paste"]),da("onCompositionEnd","compositionend focusout keydown keypress keyup mousedown".split(" ")),da("onCompositionStart","compositionstart focusout keydown keypress keyup mousedown".split(" ")),da("onCompositionUpdate","compositionupdate focusout keydown keypress keyup mousedown".split(" "));var Po="abort canplay canplaythrough durationchange emptied encrypted ended error loadeddata loadedmetadata loadstart pause play playing progress ratechange seeked seeking stalled suspend timeupdate volumechange waiting".split(" "),Eo=new Set("cancel close invalid load scroll toggle".split(" ").concat(Po));function Ze$1($,W,G){var oe=$.type||"unknown-event";$.currentTarget=G,function Yb($,W,G,oe,ae,ie,se,le,ue){if(Xb.apply(this,arguments),Vr){if(!Vr)throw Error(y$1(198));var de=qr;Vr=!1,qr=null,Ur||(Ur=!0,Kr=de)}}(oe,W,void 0,$),$.currentTarget=null}function se$1($,W){W=0!=(4&W);for(var G=0;G<$.length;G++){var oe=$[G],ae=oe.event;oe=oe.listeners;e:{var ie=void 0;if(W)for(var se=oe.length-1;0<=se;se--){var le=oe[se],ue=le.instance,de=le.currentTarget;if(le=le.listener,ue!==ie&&ae.isPropagationStopped())break e;Ze$1(ae,le,de),ie=ue}else for(se=0;se<oe.length;se++){if(ue=(le=oe[se]).instance,de=le.currentTarget,le=le.listener,ue!==ie&&ae.isPropagationStopped())break e;Ze$1(ae,le,de),ie=ue}}}if(Ur)throw $=Kr,Ur=!1,Kr=null,$}function G$1($,W){var G=$e$1(W),oe=$+"__bubble";G.has(oe)||(af(W,$,2,!1),G.add(oe))}var jo="_reactListening"+Math.random().toString(36).slice(2);function cf($){$[jo]||($[jo]=!0,Yt.forEach((function(W){Eo.has(W)||df(W,!1,$,null),df(W,!0,$,null)})))}function df($,W,G,oe){var ae=4<arguments.length&&void 0!==arguments[4]?arguments[4]:0,ie=G;if("selectionchange"===$&&9!==G.nodeType&&(ie=G.ownerDocument),null!==oe&&!W&&Eo.has($)){if("scroll"!==$)return;ae|=2,ie=oe}var se=$e$1(ie),le=$+"__"+(W?"capture":"bubble");se.has(le)||(W&&(ae|=4),af(ie,$,ae,W),se.add(le))}function af($,W,G,oe){var ae=vn.get(W);switch(void 0===ae?2:ae){case 0:ae=gd;break;case 1:ae=id;break;default:ae=hd}G=ae.bind(null,W,G,$),ae=void 0,!Lr||"touchstart"!==W&&"touchmove"!==W&&"wheel"!==W||(ae=!0),oe?void 0!==ae?$.addEventListener(W,G,{capture:!0,passive:ae}):$.addEventListener(W,G,!0):void 0!==ae?$.addEventListener(W,G,{passive:ae}):$.addEventListener(W,G,!1)}function jd($,W,G,oe,ae){var ie=oe;if(0==(1&W)&&0==(2&W)&&null!==oe)e:for(;;){if(null===oe)return;var se=oe.tag;if(3===se||4===se){var le=oe.stateNode.containerInfo;if(le===ae||8===le.nodeType&&le.parentNode===ae)break;if(4===se)for(se=oe.return;null!==se;){var ue=se.tag;if((3===ue||4===ue)&&((ue=se.stateNode.containerInfo)===ae||8===ue.nodeType&&ue.parentNode===ae))return;se=se.return}for(;null!==le;){if(null===(se=wc(le)))return;if(5===(ue=se.tag)||6===ue){oe=ie=se;continue e}le=le.parentNode}}oe=oe.return}!function Nb($,W,G){if(Nr)return $(W,G);Nr=!0;try{return Br($,W,G)}finally{Nr=!1,Mb()}}((function(){var oe=ie,ae=xb(G),se=[];e:{var le=gn.get($);if(void 0!==le){var ue=An,de=$;switch($){case"keypress":if(0===od(G))break e;case"keydown":case"keyup":ue=Gn;break;case"focusin":de="focus",ue=Fn;break;case"focusout":de="blur",ue=Fn;break;case"beforeblur":case"afterblur":ue=Fn;break;case"click":if(2===G.button)break e;case"auxclick":case"dblclick":case"mousedown":case"mousemove":case"mouseup":case"mouseout":case"mouseover":case"contextmenu":ue=Rn;break;case"drag":case"dragend":case"dragenter":case"dragexit":case"dragleave":case"dragover":case"dragstart":case"drop":ue=Bn;break;case"touchcancel":case"touchend":case"touchmove":case"touchstart":ue=Yn;break;case fn:case pn:case hn:ue=Nn;break;case mn:ue=Jn;break;case"scroll":ue=zn;break;case"wheel":ue=Zn;break;case"copy":case"cut":case"paste":ue=Hn;break;case"gotpointercapture":case"lostpointercapture":case"pointercancel":case"pointerdown":case"pointermove":case"pointerout":case"pointerover":case"pointerup":ue=Xn}var pe=0!=(4&W),he=!pe&&"scroll"===$,ge=pe?null!==le?le+"Capture":null:le;pe=[];for(var ve,we=oe;null!==we;){var Se=(ve=we).stateNode;if(5===ve.tag&&null!==Se&&(ve=Se,null!==ge&&(null!=(Se=Ob(we,ge))&&pe.push(ef(we,Se,ve)))),he)break;we=we.return}0<pe.length&&(le=new ue(le,de,null,G,ae),se.push({event:le,listeners:pe}))}}if(0==(7&W)){if(ue="mouseout"===$||"pointerout"===$,(!(le="mouseover"===$||"pointerover"===$)||0!=(16&W)||!(de=G.relatedTarget||G.fromElement)||!wc(de)&&!de[Mo])&&(ue||le)&&(le=ae.window===ae?ae:(le=ae.ownerDocument)?le.defaultView||le.parentWindow:window,ue?(ue=oe,null!==(de=(de=G.relatedTarget||G.toElement)?wc(de):null)&&(de!==(he=Zb(de))||5!==de.tag&&6!==de.tag)&&(de=null)):(ue=null,de=oe),ue!==de)){if(pe=Rn,Se="onMouseLeave",ge="onMouseEnter",we="mouse","pointerout"!==$&&"pointerover"!==$||(pe=Xn,Se="onPointerLeave",ge="onPointerEnter",we="pointer"),he=null==ue?le:ue$1(ue),ve=null==de?le:ue$1(de),(le=new pe(Se,we+"leave",ue,G,ae)).target=he,le.relatedTarget=ve,Se=null,wc(ae)===oe&&((pe=new pe(ge,we+"enter",de,G,ae)).target=ve,pe.relatedTarget=he,Se=pe),he=Se,ue&&de)e:{for(ge=de,we=0,ve=pe=ue;ve;ve=gf(ve))we++;for(ve=0,Se=ge;Se;Se=gf(Se))ve++;for(;0<we-ve;)pe=gf(pe),we--;for(;0<ve-we;)ge=gf(ge),ve--;for(;we--;){if(pe===ge||null!==ge&&pe===ge.alternate)break e;pe=gf(pe),ge=gf(ge)}pe=null}else pe=null;null!==ue&&hf(se,le,ue,pe,!1),null!==de&&null!==he&&hf(se,he,de,pe,!0)}if("select"===(ue=(le=oe?ue$1(oe):window).nodeName&&le.nodeName.toLowerCase())||"input"===ue&&"file"===le.type)var Pe=ve$1;else if(me$1(le))if(fo)Pe=Fe$1;else{Pe=De$1;var je=Ce$1}else(ue=le.nodeName)&&"input"===ue.toLowerCase()&&("checkbox"===le.type||"radio"===le.type)&&(Pe=Ee$1);switch(Pe&&(Pe=Pe($,oe))?ne$1(se,Pe,G,ae):(je&&je($,le,oe),"focusout"===$&&(je=le._wrapperState)&&je.controlled&&"number"===le.type&&bb(le,"number",le.value)),je=oe?ue$1(oe):window,$){case"focusin":(me$1(je)||"true"===je.contentEditable)&&(bo=je,wo=oe,So=null);break;case"focusout":So=wo=bo=null;break;case"mousedown":xo=!0;break;case"contextmenu":case"mouseup":case"dragend":xo=!1,Ue$1(se,G,ae);break;case"selectionchange":if(yo)break;case"keydown":case"keyup":Ue$1(se,G,ae)}var Ie;if(to)e:{switch($){case"compositionstart":var De="onCompositionStart";break e;case"compositionend":De="onCompositionEnd";break e;case"compositionupdate":De="onCompositionUpdate";break e}De=void 0}else so?ge$1($,G)&&(De="onCompositionEnd"):"keydown"===$&&229===G.keyCode&&(De="onCompositionStart");De&&(oo&&"ko"!==G.locale&&(so||"onCompositionStart"!==De?"onCompositionEnd"===De&&so&&(Ie=nd()):(jn="value"in(En=ae)?En.value:En.textContent,so=!0)),0<(je=oe$1(oe,De)).length&&(De=new Vn(De,$,null,G,ae),se.push({event:De,listeners:je}),Ie?De.data=Ie:null!==(Ie=he$1(G))&&(De.data=Ie))),(Ie=no?function je$1($,W){switch($){case"compositionend":return he$1(W);case"keypress":return 32!==W.which?null:(io=!0,ao);case"textInput":return($=W.data)===ao&&io?null:$;default:return null}}($,G):function ke$1($,W){if(so)return"compositionend"===$||!to&&ge$1($,W)?($=nd(),Cn=jn=En=null,so=!1,$):null;switch($){case"paste":default:return null;case"keypress":if(!(W.ctrlKey||W.altKey||W.metaKey)||W.ctrlKey&&W.altKey){if(W.char&&1<W.char.length)return W.char;if(W.which)return String.fromCharCode(W.which)}return null;case"compositionend":return oo&&"ko"!==W.locale?null:W.data}}($,G))&&(0<(oe=oe$1(oe,"onBeforeInput")).length&&(ae=new Vn("onBeforeInput","beforeinput",null,G,ae),se.push({event:ae,listeners:oe}),ae.data=Ie))}se$1(se,W)}))}function ef($,W,G){return{instance:$,listener:W,currentTarget:G}}function oe$1($,W){for(var G=W+"Capture",oe=[];null!==$;){var ae=$,ie=ae.stateNode;5===ae.tag&&null!==ie&&(ae=ie,null!=(ie=Ob($,G))&&oe.unshift(ef($,ie,ae)),null!=(ie=Ob($,W))&&oe.push(ef($,ie,ae))),$=$.return}return oe}function gf($){if(null===$)return null;do{$=$.return}while($&&5!==$.tag);return $||null}function hf($,W,G,oe,ae){for(var ie=W._reactName,se=[];null!==G&&G!==oe;){var le=G,ue=le.alternate,de=le.stateNode;if(null!==ue&&ue===oe)break;5===le.tag&&null!==de&&(le=de,ae?null!=(ue=Ob(G,ie))&&se.unshift(ef(G,ue,le)):ae||null!=(ue=Ob(G,ie))&&se.push(ef(G,ue,le))),G=G.return}0!==se.length&&$.push({event:W,listeners:se})}function jf(){}var Co=null,Oo=null;function mf($,W){switch($){case"button":case"input":case"select":case"textarea":return!!W.autoFocus}return!1}function nf($,W){return"textarea"===$||"option"===$||"noscript"===$||"string"==typeof W.children||"number"==typeof W.children||"object"==typeof W.dangerouslySetInnerHTML&&null!==W.dangerouslySetInnerHTML&&null!=W.dangerouslySetInnerHTML.__html}var Io="function"==typeof setTimeout?setTimeout:void 0,To="function"==typeof clearTimeout?clearTimeout:void 0;function qf($){1===$.nodeType?$.textContent="":9===$.nodeType&&(null!=($=$.body)&&($.textContent=""))}function rf($){for(;null!=$;$=$.nextSibling){var W=$.nodeType;if(1===W||3===W)break}return $}function sf($){$=$.previousSibling;for(var W=0;$;){if(8===$.nodeType){var G=$.data;if("$"===G||"$!"===G||"$?"===G){if(0===W)return $;W--}else"/$"===G&&W++}$=$.previousSibling}return null}var Do=0;var Ao=Math.random().toString(36).slice(2),$o="__reactFiber$"+Ao,zo="__reactProps$"+Ao,Mo="__reactContainer$"+Ao,Ro="__reactEvents$"+Ao;function wc($){var W=$[$o];if(W)return W;for(var G=$.parentNode;G;){if(W=G[Mo]||G[$o]){if(G=W.alternate,null!==W.child||null!==G&&null!==G.child)for($=sf($);null!==$;){if(G=$[$o])return G;$=sf($)}return W}G=($=G).parentNode}return null}function Cb($){return!($=$[$o]||$[Mo])||5!==$.tag&&6!==$.tag&&13!==$.tag&&3!==$.tag?null:$}function ue$1($){if(5===$.tag||6===$.tag)return $.stateNode;throw Error(y$1(33))}function Db($){return $[zo]||null}function $e$1($){var W=$[Ro];return void 0===W&&(W=$[Ro]=new Set),W}var Bo=[],Fo=-1;function Bf($){return{current:$}}function H$1($){0>Fo||($.current=Bo[Fo],Bo[Fo]=null,Fo--)}function I$1($,W){Fo++,Bo[Fo]=$.current,$.current=W}var No={},Lo=Bf(No),Ho=Bf(!1),Vo=No;function Ef($,W){var G=$.type.contextTypes;if(!G)return No;var oe=$.stateNode;if(oe&&oe.__reactInternalMemoizedUnmaskedChildContext===W)return oe.__reactInternalMemoizedMaskedChildContext;var ae,ie={};for(ae in G)ie[ae]=W[ae];return oe&&(($=$.stateNode).__reactInternalMemoizedUnmaskedChildContext=W,$.__reactInternalMemoizedMaskedChildContext=ie),ie}function Ff($){return null!=($=$.childContextTypes)}function Gf(){H$1(Ho),H$1(Lo)}function Hf($,W,G){if(Lo.current!==No)throw Error(y$1(168));I$1(Lo,W),I$1(Ho,G)}function If($,W,G){var oe=$.stateNode;if($=W.childContextTypes,"function"!=typeof oe.getChildContext)return G;for(var ae in oe=oe.getChildContext())if(!(ae in $))throw Error(y$1(108,Ra(W)||"Unknown",ae));return Gt({},G,oe)}function Jf($){return $=($=$.stateNode)&&$.__reactInternalMemoizedMergedChildContext||No,Vo=Lo.current,I$1(Lo,$),I$1(Ho,Ho.current),!0}function Kf($,W,G){var oe=$.stateNode;if(!oe)throw Error(y$1(169));G?($=If($,W,Vo),oe.__reactInternalMemoizedMergedChildContext=$,H$1(Ho),H$1(Lo),I$1(Lo,$)):H$1(Ho),I$1(Ho,G)}var qo=null,Uo=null,Ko=Xt.unstable_runWithPriority,Wo=Xt.unstable_scheduleCallback,Go=Xt.unstable_cancelCallback,Xo=Xt.unstable_shouldYield,Yo=Xt.unstable_requestPaint,Jo=Xt.unstable_now,Qo=Xt.unstable_getCurrentPriorityLevel,Zo=Xt.unstable_ImmediatePriority,ta=Xt.unstable_UserBlockingPriority,ra=Xt.unstable_NormalPriority,oa=Xt.unstable_LowPriority,aa=Xt.unstable_IdlePriority,ia={},sa=void 0!==Yo?Yo:function(){},ua=null,ca=null,fa=!1,ha=Jo(),ga=1e4>ha?Jo:function(){return Jo()-ha};function eg(){switch(Qo()){case Zo:return 99;case ta:return 98;case ra:return 97;case oa:return 96;case aa:return 95;default:throw Error(y$1(332))}}function fg($){switch($){case 99:return Zo;case 98:return ta;case 97:return ra;case 96:return oa;case 95:return aa;default:throw Error(y$1(332))}}function gg($,W){return $=fg($),Ko($,W)}function hg($,W,G){return $=fg($),Wo($,W,G)}function ig(){if(null!==ca){var $=ca;ca=null,Go($)}jg()}function jg(){if(!fa&&null!==ua){fa=!0;var $=0;try{var W=ua;gg(99,(function(){for(;$<W.length;$++){var G=W[$];do{G=G(!0)}while(null!==G)}})),ua=null}catch(W){throw null!==ua&&(ua=ua.slice($+1)),Wo(Zo,ig),W}finally{fa=!1}}}var va=ar.ReactCurrentBatchConfig;function lg($,W){if($&&$.defaultProps){for(var G in W=Gt({},W),$=$.defaultProps)void 0===W[G]&&(W[G]=$[G]);return W}return W}var ya=Bf(null),ba=null,wa=null,xa=null;function qg(){xa=wa=ba=null}function rg($){var W=ya.current;H$1(ya),$.type._context._currentValue=W}function sg($,W){for(;null!==$;){var G=$.alternate;if(($.childLanes&W)===W){if(null===G||(G.childLanes&W)===W)break;G.childLanes|=W}else $.childLanes|=W,null!==G&&(G.childLanes|=W);$=$.return}}function tg($,W){ba=$,xa=wa=null,null!==($=$.dependencies)&&null!==$.firstContext&&(0!=($.lanes&W)&&(Ui=!0),$.firstContext=null)}function vg($,W){if(xa!==$&&!1!==W&&0!==W)if("number"==typeof W&&1073741823!==W||(xa=$,W=1073741823),W={context:$,observedBits:W,next:null},null===wa){if(null===ba)throw Error(y$1(308));wa=W,ba.dependencies={lanes:0,firstContext:W,responders:null}}else wa=wa.next=W;return $._currentValue}var ka=!1;function xg($){$.updateQueue={baseState:$.memoizedState,firstBaseUpdate:null,lastBaseUpdate:null,shared:{pending:null},effects:null}}function yg($,W){$=$.updateQueue,W.updateQueue===$&&(W.updateQueue={baseState:$.baseState,firstBaseUpdate:$.firstBaseUpdate,lastBaseUpdate:$.lastBaseUpdate,shared:$.shared,effects:$.effects})}function zg($,W){return{eventTime:$,lane:W,tag:0,payload:null,callback:null,next:null}}function Ag($,W){if(null!==($=$.updateQueue)){var G=($=$.shared).pending;null===G?W.next=W:(W.next=G.next,G.next=W),$.pending=W}}function Bg($,W){var G=$.updateQueue,oe=$.alternate;if(null!==oe&&G===(oe=oe.updateQueue)){var ae=null,ie=null;if(null!==(G=G.firstBaseUpdate)){do{var se={eventTime:G.eventTime,lane:G.lane,tag:G.tag,payload:G.payload,callback:G.callback,next:null};null===ie?ae=ie=se:ie=ie.next=se,G=G.next}while(null!==G);null===ie?ae=ie=W:ie=ie.next=W}else ae=ie=W;return G={baseState:oe.baseState,firstBaseUpdate:ae,lastBaseUpdate:ie,shared:oe.shared,effects:oe.effects},void($.updateQueue=G)}null===($=G.lastBaseUpdate)?G.firstBaseUpdate=W:$.next=W,G.lastBaseUpdate=W}function Cg($,W,G,oe){var ae=$.updateQueue;ka=!1;var ie=ae.firstBaseUpdate,se=ae.lastBaseUpdate,le=ae.shared.pending;if(null!==le){ae.shared.pending=null;var ue=le,de=ue.next;ue.next=null,null===se?ie=de:se.next=de,se=ue;var pe=$.alternate;if(null!==pe){var he=(pe=pe.updateQueue).lastBaseUpdate;he!==se&&(null===he?pe.firstBaseUpdate=de:he.next=de,pe.lastBaseUpdate=ue)}}if(null!==ie){for(he=ae.baseState,se=0,pe=de=ue=null;;){le=ie.lane;var ge=ie.eventTime;if((oe&le)===le){null!==pe&&(pe=pe.next={eventTime:ge,lane:0,tag:ie.tag,payload:ie.payload,callback:ie.callback,next:null});e:{var ve=$,we=ie;switch(le=W,ge=G,we.tag){case 1:if("function"==typeof(ve=we.payload)){he=ve.call(ge,he,le);break e}he=ve;break e;case 3:ve.flags=-4097&ve.flags|64;case 0:if(null==(le="function"==typeof(ve=we.payload)?ve.call(ge,he,le):ve))break e;he=Gt({},he,le);break e;case 2:ka=!0}}null!==ie.callback&&($.flags|=32,null===(le=ae.effects)?ae.effects=[ie]:le.push(ie))}else ge={eventTime:ge,lane:le,tag:ie.tag,payload:ie.payload,callback:ie.callback,next:null},null===pe?(de=pe=ge,ue=he):pe=pe.next=ge,se|=le;if(null===(ie=ie.next)){if(null===(le=ae.shared.pending))break;ie=le.next,le.next=null,ae.lastBaseUpdate=le,ae.shared.pending=null}}null===pe&&(ue=he),ae.baseState=ue,ae.firstBaseUpdate=de,ae.lastBaseUpdate=pe,gs|=se,$.lanes=se,$.memoizedState=he}}function Eg($,W,G){if($=W.effects,W.effects=null,null!==$)for(W=0;W<$.length;W++){var oe=$[W],ae=oe.callback;if(null!==ae){if(oe.callback=null,oe=G,"function"!=typeof ae)throw Error(y$1(191,ae));ae.call(oe)}}}var _a=(new Wt.Component).refs;function Gg($,W,G,oe){G=null==(G=G(oe,W=$.memoizedState))?W:Gt({},W,G),$.memoizedState=G,0===$.lanes&&($.updateQueue.baseState=G)}var Ea={isMounted:function($){return!!($=$._reactInternals)&&Zb($)===$},enqueueSetState:function($,W,G){$=$._reactInternals;var oe=Hg(),ae=Ig($),ie=zg(oe,ae);ie.payload=W,null!=G&&(ie.callback=G),Ag($,ie),Jg($,ae,oe)},enqueueReplaceState:function($,W,G){$=$._reactInternals;var oe=Hg(),ae=Ig($),ie=zg(oe,ae);ie.tag=1,ie.payload=W,null!=G&&(ie.callback=G),Ag($,ie),Jg($,ae,oe)},enqueueForceUpdate:function($,W){$=$._reactInternals;var G=Hg(),oe=Ig($),ae=zg(G,oe);ae.tag=2,null!=W&&(ae.callback=W),Ag($,ae),Jg($,oe,G)}};function Lg($,W,G,oe,ae,ie,se){return"function"==typeof($=$.stateNode).shouldComponentUpdate?$.shouldComponentUpdate(oe,ie,se):!W.prototype||!W.prototype.isPureReactComponent||(!Je$1(G,oe)||!Je$1(ae,ie))}function Mg($,W,G){var oe=!1,ae=No,ie=W.contextType;return"object"==typeof ie&&null!==ie?ie=vg(ie):(ae=Ff(W)?Vo:Lo.current,ie=(oe=null!=(oe=W.contextTypes))?Ef($,ae):No),W=new W(G,ie),$.memoizedState=null!==W.state&&void 0!==W.state?W.state:null,W.updater=Ea,$.stateNode=W,W._reactInternals=$,oe&&(($=$.stateNode).__reactInternalMemoizedUnmaskedChildContext=ae,$.__reactInternalMemoizedMaskedChildContext=ie),W}function Ng($,W,G,oe){$=W.state,"function"==typeof W.componentWillReceiveProps&&W.componentWillReceiveProps(G,oe),"function"==typeof W.UNSAFE_componentWillReceiveProps&&W.UNSAFE_componentWillReceiveProps(G,oe),W.state!==$&&Ea.enqueueReplaceState(W,W.state,null)}function Og($,W,G,oe){var ae=$.stateNode;ae.props=G,ae.state=$.memoizedState,ae.refs=_a,xg($);var ie=W.contextType;"object"==typeof ie&&null!==ie?ae.context=vg(ie):(ie=Ff(W)?Vo:Lo.current,ae.context=Ef($,ie)),Cg($,G,ae,oe),ae.state=$.memoizedState,"function"==typeof(ie=W.getDerivedStateFromProps)&&(Gg($,W,ie,G),ae.state=$.memoizedState),"function"==typeof W.getDerivedStateFromProps||"function"==typeof ae.getSnapshotBeforeUpdate||"function"!=typeof ae.UNSAFE_componentWillMount&&"function"!=typeof ae.componentWillMount||(W=ae.state,"function"==typeof ae.componentWillMount&&ae.componentWillMount(),"function"==typeof ae.UNSAFE_componentWillMount&&ae.UNSAFE_componentWillMount(),W!==ae.state&&Ea.enqueueReplaceState(ae,ae.state,null),Cg($,G,ae,oe),ae.state=$.memoizedState),"function"==typeof ae.componentDidMount&&($.flags|=4)}var ja=Array.isArray;function Qg($,W,G){if(null!==($=G.ref)&&"function"!=typeof $&&"object"!=typeof $){if(G._owner){if(G=G._owner){if(1!==G.tag)throw Error(y$1(309));var oe=G.stateNode}if(!oe)throw Error(y$1(147,$));var ae=""+$;return null!==W&&null!==W.ref&&"function"==typeof W.ref&&W.ref._stringRef===ae?W.ref:(W=function($){var W=oe.refs;W===_a&&(W=oe.refs={}),null===$?delete W[ae]:W[ae]=$},W._stringRef=ae,W)}if("string"!=typeof $)throw Error(y$1(284));if(!G._owner)throw Error(y$1(290,$))}return $}function Rg($,W){if("textarea"!==$.type)throw Error(y$1(31,"[object Object]"===Object.prototype.toString.call(W)?"object with keys {"+Object.keys(W).join(", ")+"}":W))}function Sg($){function b(W,G){if($){var oe=W.lastEffect;null!==oe?(oe.nextEffect=G,W.lastEffect=G):W.firstEffect=W.lastEffect=G,G.nextEffect=null,G.flags=8}}function c(W,G){if(!$)return null;for(;null!==G;)b(W,G),G=G.sibling;return null}function d($,W){for($=new Map;null!==W;)null!==W.key?$.set(W.key,W):$.set(W.index,W),W=W.sibling;return $}function e($,W){return($=Tg($,W)).index=0,$.sibling=null,$}function f(W,G,oe){return W.index=oe,$?null!==(oe=W.alternate)?(oe=oe.index)<G?(W.flags=2,G):oe:(W.flags=2,G):G}function g(W){return $&&null===W.alternate&&(W.flags=2),W}function h($,W,G,oe){return null===W||6!==W.tag?((W=Ug(G,$.mode,oe)).return=$,W):((W=e(W,G)).return=$,W)}function k($,W,G,oe){return null!==W&&W.elementType===G.type?((oe=e(W,G.props)).ref=Qg($,W,G),oe.return=$,oe):((oe=Vg(G.type,G.key,G.props,null,$.mode,oe)).ref=Qg($,W,G),oe.return=$,oe)}function l($,W,G,oe){return null===W||4!==W.tag||W.stateNode.containerInfo!==G.containerInfo||W.stateNode.implementation!==G.implementation?((W=Wg(G,$.mode,oe)).return=$,W):((W=e(W,G.children||[])).return=$,W)}function n($,W,G,oe,ae){return null===W||7!==W.tag?((W=Xg(G,$.mode,oe,ae)).return=$,W):((W=e(W,G)).return=$,W)}function A($,W,G){if("string"==typeof W||"number"==typeof W)return(W=Ug(""+W,$.mode,G)).return=$,W;if("object"==typeof W&&null!==W){switch(W.$$typeof){case ir:return(G=Vg(W.type,W.key,W.props,null,$.mode,G)).ref=Qg($,null,W),G.return=$,G;case sr:return(W=Wg(W,$.mode,G)).return=$,W}if(ja(W)||La(W))return(W=Xg(W,$.mode,G,null)).return=$,W;Rg($,W)}return null}function p($,W,G,oe){var ae=null!==W?W.key:null;if("string"==typeof G||"number"==typeof G)return null!==ae?null:h($,W,""+G,oe);if("object"==typeof G&&null!==G){switch(G.$$typeof){case ir:return G.key===ae?G.type===lr?n($,W,G.props.children,oe,ae):k($,W,G,oe):null;case sr:return G.key===ae?l($,W,G,oe):null}if(ja(G)||La(G))return null!==ae?null:n($,W,G,oe,null);Rg($,G)}return null}function C($,W,G,oe,ae){if("string"==typeof oe||"number"==typeof oe)return h(W,$=$.get(G)||null,""+oe,ae);if("object"==typeof oe&&null!==oe){switch(oe.$$typeof){case ir:return $=$.get(null===oe.key?G:oe.key)||null,oe.type===lr?n(W,$,oe.props.children,ae,oe.key):k(W,$,oe,ae);case sr:return l(W,$=$.get(null===oe.key?G:oe.key)||null,oe,ae)}if(ja(oe)||La(oe))return n(W,$=$.get(G)||null,oe,ae,null);Rg(W,oe)}return null}function x(W,G,oe,ae){for(var ie=null,se=null,le=G,ue=G=0,de=null;null!==le&&ue<oe.length;ue++){le.index>ue?(de=le,le=null):de=le.sibling;var pe=p(W,le,oe[ue],ae);if(null===pe){null===le&&(le=de);break}$&&le&&null===pe.alternate&&b(W,le),G=f(pe,G,ue),null===se?ie=pe:se.sibling=pe,se=pe,le=de}if(ue===oe.length)return c(W,le),ie;if(null===le){for(;ue<oe.length;ue++)null!==(le=A(W,oe[ue],ae))&&(G=f(le,G,ue),null===se?ie=le:se.sibling=le,se=le);return ie}for(le=d(W,le);ue<oe.length;ue++)null!==(de=C(le,W,ue,oe[ue],ae))&&($&&null!==de.alternate&&le.delete(null===de.key?ue:de.key),G=f(de,G,ue),null===se?ie=de:se.sibling=de,se=de);return $&&le.forEach((function($){return b(W,$)})),ie}function w(W,G,oe,ae){var ie=La(oe);if("function"!=typeof ie)throw Error(y$1(150));if(null==(oe=ie.call(oe)))throw Error(y$1(151));for(var se=ie=null,le=G,ue=G=0,de=null,pe=oe.next();null!==le&&!pe.done;ue++,pe=oe.next()){le.index>ue?(de=le,le=null):de=le.sibling;var he=p(W,le,pe.value,ae);if(null===he){null===le&&(le=de);break}$&&le&&null===he.alternate&&b(W,le),G=f(he,G,ue),null===se?ie=he:se.sibling=he,se=he,le=de}if(pe.done)return c(W,le),ie;if(null===le){for(;!pe.done;ue++,pe=oe.next())null!==(pe=A(W,pe.value,ae))&&(G=f(pe,G,ue),null===se?ie=pe:se.sibling=pe,se=pe);return ie}for(le=d(W,le);!pe.done;ue++,pe=oe.next())null!==(pe=C(le,W,ue,pe.value,ae))&&($&&null!==pe.alternate&&le.delete(null===pe.key?ue:pe.key),G=f(pe,G,ue),null===se?ie=pe:se.sibling=pe,se=pe);return $&&le.forEach((function($){return b(W,$)})),ie}return function($,W,G,oe){var ae="object"==typeof G&&null!==G&&G.type===lr&&null===G.key;ae&&(G=G.props.children);var ie="object"==typeof G&&null!==G;if(ie)switch(G.$$typeof){case ir:e:{for(ie=G.key,ae=W;null!==ae;){if(ae.key===ie){if(7===ae.tag){if(G.type===lr){c($,ae.sibling),(W=e(ae,G.props.children)).return=$,$=W;break e}}else if(ae.elementType===G.type){c($,ae.sibling),(W=e(ae,G.props)).ref=Qg($,ae,G),W.return=$,$=W;break e}c($,ae);break}b($,ae),ae=ae.sibling}G.type===lr?((W=Xg(G.props.children,$.mode,oe,G.key)).return=$,$=W):((oe=Vg(G.type,G.key,G.props,null,$.mode,oe)).ref=Qg($,W,G),oe.return=$,$=oe)}return g($);case sr:e:{for(ae=G.key;null!==W;){if(W.key===ae){if(4===W.tag&&W.stateNode.containerInfo===G.containerInfo&&W.stateNode.implementation===G.implementation){c($,W.sibling),(W=e(W,G.children||[])).return=$,$=W;break e}c($,W);break}b($,W),W=W.sibling}(W=Wg(G,$.mode,oe)).return=$,$=W}return g($)}if("string"==typeof G||"number"==typeof G)return G=""+G,null!==W&&6===W.tag?(c($,W.sibling),(W=e(W,G)).return=$,$=W):(c($,W),(W=Ug(G,$.mode,oe)).return=$,$=W),g($);if(ja(G))return x($,W,G,oe);if(La(G))return w($,W,G,oe);if(ie&&Rg($,G),void 0===G&&!ae)switch($.tag){case 1:case 22:case 0:case 11:case 15:throw Error(y$1(152,Ra($.type)||"Component"))}return c($,W)}}var Ca=Sg(!0),Oa=Sg(!1),Ia={},Da=Bf(Ia),Aa=Bf(Ia),za=Bf(Ia);function dh($){if($===Ia)throw Error(y$1(174));return $}function eh($,W){switch(I$1(za,W),I$1(Aa,$),I$1(Da,Ia),$=W.nodeType){case 9:case 11:W=(W=W.documentElement)?W.namespaceURI:mb(null,"");break;default:W=mb(W=($=8===$?W.parentNode:W).namespaceURI||null,$=$.tagName)}H$1(Da),I$1(Da,W)}function fh(){H$1(Da),H$1(Aa),H$1(za)}function gh($){dh(za.current);var W=dh(Da.current),G=mb(W,$.type);W!==G&&(I$1(Aa,$),I$1(Da,G))}function hh($){Aa.current===$&&(H$1(Da),H$1(Aa))}var Ma=Bf(0);function ih($){for(var W=$;null!==W;){if(13===W.tag){var G=W.memoizedState;if(null!==G&&(null===(G=G.dehydrated)||"$?"===G.data||"$!"===G.data))return W}else if(19===W.tag&&void 0!==W.memoizedProps.revealOrder){if(0!=(64&W.flags))return W}else if(null!==W.child){W.child.return=W,W=W.child;continue}if(W===$)break;for(;null===W.sibling;){if(null===W.return||W.return===$)return null;W=W.return}W.sibling.return=W.return,W=W.sibling}return null}var Ba=null,Fa=null,Ha=!1;function mh($,W){var G=nh(5,null,null,0);G.elementType="DELETED",G.type="DELETED",G.stateNode=W,G.return=$,G.flags=8,null!==$.lastEffect?($.lastEffect.nextEffect=G,$.lastEffect=G):$.firstEffect=$.lastEffect=G}function oh($,W){switch($.tag){case 5:var G=$.type;return null!==(W=1!==W.nodeType||G.toLowerCase()!==W.nodeName.toLowerCase()?null:W)&&($.stateNode=W,!0);case 6:return null!==(W=""===$.pendingProps||3!==W.nodeType?null:W)&&($.stateNode=W,!0);default:return!1}}function ph($){if(Ha){var W=Fa;if(W){var G=W;if(!oh($,W)){if(!(W=rf(G.nextSibling))||!oh($,W))return $.flags=-1025&$.flags|2,Ha=!1,void(Ba=$);mh(Ba,G)}Ba=$,Fa=rf(W.firstChild)}else $.flags=-1025&$.flags|2,Ha=!1,Ba=$}}function qh($){for($=$.return;null!==$&&5!==$.tag&&3!==$.tag&&13!==$.tag;)$=$.return;Ba=$}function rh($){if($!==Ba)return!1;if(!Ha)return qh($),Ha=!0,!1;var W=$.type;if(5!==$.tag||"head"!==W&&"body"!==W&&!nf(W,$.memoizedProps))for(W=Fa;W;)mh($,W),W=rf(W.nextSibling);if(qh($),13===$.tag){if(!($=null!==($=$.memoizedState)?$.dehydrated:null))throw Error(y$1(317));e:{for($=$.nextSibling,W=0;$;){if(8===$.nodeType){var G=$.data;if("/$"===G){if(0===W){Fa=rf($.nextSibling);break e}W--}else"$"!==G&&"$!"!==G&&"$?"!==G||W++}$=$.nextSibling}Fa=null}}else Fa=Ba?rf($.stateNode.nextSibling):null;return!0}function sh(){Fa=Ba=null,Ha=!1}var Ka=[];function uh(){for(var $=0;$<Ka.length;$++)Ka[$]._workInProgressVersionPrimary=null;Ka.length=0}var Ga=ar.ReactCurrentDispatcher,Ja=ar.ReactCurrentBatchConfig,ei=0,si=null,_i=null,Ei=null,Ci=!1,Oi=!1;function Ah(){throw Error(y$1(321))}function Bh($,W){if(null===W)return!1;for(var G=0;G<W.length&&G<$.length;G++)if(!go($[G],W[G]))return!1;return!0}function Ch($,W,G,oe,ae,ie){if(ei=ie,si=W,W.memoizedState=null,W.updateQueue=null,W.lanes=0,Ga.current=null===$||null===$.memoizedState?Di:Ri,$=G(oe,ae),Oi){ie=0;do{if(Oi=!1,!(25>ie))throw Error(y$1(301));ie+=1,Ei=_i=null,W.updateQueue=null,Ga.current=Bi,$=G(oe,ae)}while(Oi)}if(Ga.current=Ti,W=null!==_i&&null!==_i.next,ei=0,Ei=_i=si=null,Ci=!1,W)throw Error(y$1(300));return $}function Hh(){var $={memoizedState:null,baseState:null,baseQueue:null,queue:null,next:null};return null===Ei?si.memoizedState=Ei=$:Ei=Ei.next=$,Ei}function Ih(){if(null===_i){var $=si.alternate;$=null!==$?$.memoizedState:null}else $=_i.next;var W=null===Ei?si.memoizedState:Ei.next;if(null!==W)Ei=W,_i=$;else{if(null===$)throw Error(y$1(310));$={memoizedState:(_i=$).memoizedState,baseState:_i.baseState,baseQueue:_i.baseQueue,queue:_i.queue,next:null},null===Ei?si.memoizedState=Ei=$:Ei=Ei.next=$}return Ei}function Jh($,W){return"function"==typeof W?W($):W}function Kh($){var W=Ih(),G=W.queue;if(null===G)throw Error(y$1(311));G.lastRenderedReducer=$;var oe=_i,ae=oe.baseQueue,ie=G.pending;if(null!==ie){if(null!==ae){var se=ae.next;ae.next=ie.next,ie.next=se}oe.baseQueue=ae=ie,G.pending=null}if(null!==ae){ae=ae.next,oe=oe.baseState;var le=se=ie=null,ue=ae;do{var de=ue.lane;if((ei&de)===de)null!==le&&(le=le.next={lane:0,action:ue.action,eagerReducer:ue.eagerReducer,eagerState:ue.eagerState,next:null}),oe=ue.eagerReducer===$?ue.eagerState:$(oe,ue.action);else{var pe={lane:de,action:ue.action,eagerReducer:ue.eagerReducer,eagerState:ue.eagerState,next:null};null===le?(se=le=pe,ie=oe):le=le.next=pe,si.lanes|=de,gs|=de}ue=ue.next}while(null!==ue&&ue!==ae);null===le?ie=oe:le.next=se,go(oe,W.memoizedState)||(Ui=!0),W.memoizedState=oe,W.baseState=ie,W.baseQueue=le,G.lastRenderedState=oe}return[W.memoizedState,G.dispatch]}function Lh($){var W=Ih(),G=W.queue;if(null===G)throw Error(y$1(311));G.lastRenderedReducer=$;var oe=G.dispatch,ae=G.pending,ie=W.memoizedState;if(null!==ae){G.pending=null;var se=ae=ae.next;do{ie=$(ie,se.action),se=se.next}while(se!==ae);go(ie,W.memoizedState)||(Ui=!0),W.memoizedState=ie,null===W.baseQueue&&(W.baseState=ie),G.lastRenderedState=ie}return[ie,oe]}function Mh($,W,G){var oe=W._getVersion;oe=oe(W._source);var ae=W._workInProgressVersionPrimary;if(null!==ae?$=ae===oe:($=$.mutableReadLanes,($=(ei&$)===$)&&(W._workInProgressVersionPrimary=oe,Ka.push(W))),$)return G(W._source);throw Ka.push(W),Error(y$1(350))}function Nh($,W,G,oe){var ae=ls;if(null===ae)throw Error(y$1(349));var ie=W._getVersion,se=ie(W._source),le=Ga.current,ue=le.useState((function(){return Mh(ae,W,G)})),de=ue[1],pe=ue[0];ue=Ei;var he=$.memoizedState,ge=he.refs,ve=ge.getSnapshot,we=he.source;he=he.subscribe;var Se=si;return $.memoizedState={refs:ge,source:W,subscribe:oe},le.useEffect((function(){ge.getSnapshot=G,ge.setSnapshot=de;var $=ie(W._source);if(!go(se,$)){$=G(W._source),go(pe,$)||(de($),$=Ig(Se),ae.mutableReadLanes|=$&ae.pendingLanes),$=ae.mutableReadLanes,ae.entangledLanes|=$;for(var oe=ae.entanglements,le=$;0<le;){var ue=31-wn(le),he=1<<ue;oe[ue]|=$,le&=~he}}}),[G,W,oe]),le.useEffect((function(){return oe(W._source,(function(){var $=ge.getSnapshot,G=ge.setSnapshot;try{G($(W._source));var oe=Ig(Se);ae.mutableReadLanes|=oe&ae.pendingLanes}catch($){G((function(){throw $}))}}))}),[W,oe]),go(ve,G)&&go(we,W)&&go(he,oe)||(($={pending:null,dispatch:null,lastRenderedReducer:Jh,lastRenderedState:pe}).dispatch=de=Oh.bind(null,si,$),ue.queue=$,ue.baseQueue=null,pe=Mh(ae,W,G),ue.memoizedState=ue.baseState=pe),pe}function Ph($,W,G){return Nh(Ih(),$,W,G)}function Qh($){var W=Hh();return"function"==typeof $&&($=$()),W.memoizedState=W.baseState=$,$=($=W.queue={pending:null,dispatch:null,lastRenderedReducer:Jh,lastRenderedState:$}).dispatch=Oh.bind(null,si,$),[W.memoizedState,$]}function Rh($,W,G,oe){return $={tag:$,create:W,destroy:G,deps:oe,next:null},null===(W=si.updateQueue)?(W={lastEffect:null},si.updateQueue=W,W.lastEffect=$.next=$):null===(G=W.lastEffect)?W.lastEffect=$.next=$:(oe=G.next,G.next=$,$.next=oe,W.lastEffect=$),$}function Sh($){return $={current:$},Hh().memoizedState=$}function Th(){return Ih().memoizedState}function Uh($,W,G,oe){var ae=Hh();si.flags|=$,ae.memoizedState=Rh(1|W,G,void 0,void 0===oe?null:oe)}function Vh($,W,G,oe){var ae=Ih();oe=void 0===oe?null:oe;var ie=void 0;if(null!==_i){var se=_i.memoizedState;if(ie=se.destroy,null!==oe&&Bh(oe,se.deps))return void Rh(W,G,ie,oe)}si.flags|=$,ae.memoizedState=Rh(1|W,G,ie,oe)}function Wh($,W){return Uh(516,4,$,W)}function Xh($,W){return Vh(516,4,$,W)}function Yh($,W){return Vh(4,2,$,W)}function Zh($,W){return"function"==typeof W?($=$(),W($),function(){W(null)}):null!=W?($=$(),W.current=$,function(){W.current=null}):void 0}function $h($,W,G){return G=null!=G?G.concat([$]):null,Vh(4,2,Zh.bind(null,W,$),G)}function ai(){}function bi($,W){var G=Ih();W=void 0===W?null:W;var oe=G.memoizedState;return null!==oe&&null!==W&&Bh(W,oe[1])?oe[0]:(G.memoizedState=[$,W],$)}function ci($,W){var G=Ih();W=void 0===W?null:W;var oe=G.memoizedState;return null!==oe&&null!==W&&Bh(W,oe[1])?oe[0]:($=$(),G.memoizedState=[$,W],$)}function di($,W){var G=eg();gg(98>G?98:G,(function(){$(!0)})),gg(97<G?97:G,(function(){var G=Ja.transition;Ja.transition=1;try{$(!1),W()}finally{Ja.transition=G}}))}function Oh($,W,G){var oe=Hg(),ae=Ig($),ie={lane:ae,action:G,eagerReducer:null,eagerState:null,next:null},se=W.pending;if(null===se?ie.next=ie:(ie.next=se.next,se.next=ie),W.pending=ie,se=$.alternate,$===si||null!==se&&se===si)Oi=Ci=!0;else{if(0===$.lanes&&(null===se||0===se.lanes)&&null!==(se=W.lastRenderedReducer))try{var le=W.lastRenderedState,ue=se(le,G);if(ie.eagerReducer=se,ie.eagerState=ue,go(ue,le))return}catch($){}Jg($,ae,oe)}}var Ti={readContext:vg,useCallback:Ah,useContext:Ah,useEffect:Ah,useImperativeHandle:Ah,useLayoutEffect:Ah,useMemo:Ah,useReducer:Ah,useRef:Ah,useState:Ah,useDebugValue:Ah,useDeferredValue:Ah,useTransition:Ah,useMutableSource:Ah,useOpaqueIdentifier:Ah,unstable_isNewReconciler:!1},Di={readContext:vg,useCallback:function($,W){return Hh().memoizedState=[$,void 0===W?null:W],$},useContext:vg,useEffect:Wh,useImperativeHandle:function($,W,G){return G=null!=G?G.concat([$]):null,Uh(4,2,Zh.bind(null,W,$),G)},useLayoutEffect:function($,W){return Uh(4,2,$,W)},useMemo:function($,W){var G=Hh();return W=void 0===W?null:W,$=$(),G.memoizedState=[$,W],$},useReducer:function($,W,G){var oe=Hh();return W=void 0!==G?G(W):W,oe.memoizedState=oe.baseState=W,$=($=oe.queue={pending:null,dispatch:null,lastRenderedReducer:$,lastRenderedState:W}).dispatch=Oh.bind(null,si,$),[oe.memoizedState,$]},useRef:Sh,useState:Qh,useDebugValue:ai,useDeferredValue:function($){var W=Qh($),G=W[0],oe=W[1];return Wh((function(){var W=Ja.transition;Ja.transition=1;try{oe($)}finally{Ja.transition=W}}),[$]),G},useTransition:function(){var $=Qh(!1),W=$[0];return Sh($=di.bind(null,$[1])),[$,W]},useMutableSource:function($,W,G){var oe=Hh();return oe.memoizedState={refs:{getSnapshot:W,setSnapshot:null},source:$,subscribe:G},Nh(oe,$,W,G)},useOpaqueIdentifier:function(){if(Ha){var $=!1,W=function uf($){return{$$typeof:br,toString:$,valueOf:$}}((function(){throw $||($=!0,G("r:"+(Do++).toString(36))),Error(y$1(355))})),G=Qh(W)[1];return 0==(2&si.mode)&&(si.flags|=516,Rh(5,(function(){G("r:"+(Do++).toString(36))}),void 0,null)),W}return Qh(W="r:"+(Do++).toString(36)),W},unstable_isNewReconciler:!1},Ri={readContext:vg,useCallback:bi,useContext:vg,useEffect:Xh,useImperativeHandle:$h,useLayoutEffect:Yh,useMemo:ci,useReducer:Kh,useRef:Th,useState:function(){return Kh(Jh)},useDebugValue:ai,useDeferredValue:function($){var W=Kh(Jh),G=W[0],oe=W[1];return Xh((function(){var W=Ja.transition;Ja.transition=1;try{oe($)}finally{Ja.transition=W}}),[$]),G},useTransition:function(){var $=Kh(Jh)[0];return[Th().current,$]},useMutableSource:Ph,useOpaqueIdentifier:function(){return Kh(Jh)[0]},unstable_isNewReconciler:!1},Bi={readContext:vg,useCallback:bi,useContext:vg,useEffect:Xh,useImperativeHandle:$h,useLayoutEffect:Yh,useMemo:ci,useReducer:Lh,useRef:Th,useState:function(){return Lh(Jh)},useDebugValue:ai,useDeferredValue:function($){var W=Lh(Jh),G=W[0],oe=W[1];return Xh((function(){var W=Ja.transition;Ja.transition=1;try{oe($)}finally{Ja.transition=W}}),[$]),G},useTransition:function(){var $=Lh(Jh)[0];return[Th().current,$]},useMutableSource:Ph,useOpaqueIdentifier:function(){return Lh(Jh)[0]},unstable_isNewReconciler:!1},Hi=ar.ReactCurrentOwner,Ui=!1;function fi($,W,G,oe){W.child=null===$?Oa(W,null,G,oe):Ca(W,$.child,G,oe)}function gi($,W,G,oe,ae){G=G.render;var ie=W.ref;return tg(W,ae),oe=Ch($,W,G,oe,ie,ae),null===$||Ui?(W.flags|=1,fi($,W,oe,ae),W.child):(W.updateQueue=$.updateQueue,W.flags&=-517,$.lanes&=~ae,hi($,W,ae))}function ii($,W,G,oe,ae,ie){if(null===$){var se=G.type;return"function"!=typeof se||ji(se)||void 0!==se.defaultProps||null!==G.compare||void 0!==G.defaultProps?(($=Vg(G.type,null,oe,W,W.mode,ie)).ref=W.ref,$.return=W,W.child=$):(W.tag=15,W.type=se,ki($,W,se,oe,ae,ie))}return se=$.child,0==(ae&ie)&&(ae=se.memoizedProps,(G=null!==(G=G.compare)?G:Je$1)(ae,oe)&&$.ref===W.ref)?hi($,W,ie):(W.flags|=1,($=Tg(se,oe)).ref=W.ref,$.return=W,W.child=$)}function ki($,W,G,oe,ae,ie){if(null!==$&&Je$1($.memoizedProps,oe)&&$.ref===W.ref){if(Ui=!1,0==(ie&ae))return W.lanes=$.lanes,hi($,W,ie);0!=(16384&$.flags)&&(Ui=!0)}return li($,W,G,oe,ie)}function mi($,W,G){var oe=W.pendingProps,ae=oe.children,ie=null!==$?$.memoizedState:null;if("hidden"===oe.mode||"unstable-defer-without-hiding"===oe.mode)if(0==(4&W.mode))W.memoizedState={baseLanes:0},ni(W,G);else{if(0==(1073741824&G))return $=null!==ie?ie.baseLanes|G:G,W.lanes=W.childLanes=1073741824,W.memoizedState={baseLanes:$},ni(W,$),null;W.memoizedState={baseLanes:0},ni(W,null!==ie?ie.baseLanes:G)}else null!==ie?(oe=ie.baseLanes|G,W.memoizedState=null):oe=G,ni(W,oe);return fi($,W,ae,G),W.child}function oi($,W){var G=W.ref;(null===$&&null!==G||null!==$&&$.ref!==G)&&(W.flags|=128)}function li($,W,G,oe,ae){var ie=Ff(G)?Vo:Lo.current;return ie=Ef(W,ie),tg(W,ae),G=Ch($,W,G,oe,ie,ae),null===$||Ui?(W.flags|=1,fi($,W,G,ae),W.child):(W.updateQueue=$.updateQueue,W.flags&=-517,$.lanes&=~ae,hi($,W,ae))}function pi($,W,G,oe,ae){if(Ff(G)){var ie=!0;Jf(W)}else ie=!1;if(tg(W,ae),null===W.stateNode)null!==$&&($.alternate=null,W.alternate=null,W.flags|=2),Mg(W,G,oe),Og(W,G,oe,ae),oe=!0;else if(null===$){var se=W.stateNode,le=W.memoizedProps;se.props=le;var ue=se.context,de=G.contextType;"object"==typeof de&&null!==de?de=vg(de):de=Ef(W,de=Ff(G)?Vo:Lo.current);var pe=G.getDerivedStateFromProps,he="function"==typeof pe||"function"==typeof se.getSnapshotBeforeUpdate;he||"function"!=typeof se.UNSAFE_componentWillReceiveProps&&"function"!=typeof se.componentWillReceiveProps||(le!==oe||ue!==de)&&Ng(W,se,oe,de),ka=!1;var ge=W.memoizedState;se.state=ge,Cg(W,oe,se,ae),ue=W.memoizedState,le!==oe||ge!==ue||Ho.current||ka?("function"==typeof pe&&(Gg(W,G,pe,oe),ue=W.memoizedState),(le=ka||Lg(W,G,le,oe,ge,ue,de))?(he||"function"!=typeof se.UNSAFE_componentWillMount&&"function"!=typeof se.componentWillMount||("function"==typeof se.componentWillMount&&se.componentWillMount(),"function"==typeof se.UNSAFE_componentWillMount&&se.UNSAFE_componentWillMount()),"function"==typeof se.componentDidMount&&(W.flags|=4)):("function"==typeof se.componentDidMount&&(W.flags|=4),W.memoizedProps=oe,W.memoizedState=ue),se.props=oe,se.state=ue,se.context=de,oe=le):("function"==typeof se.componentDidMount&&(W.flags|=4),oe=!1)}else{se=W.stateNode,yg($,W),le=W.memoizedProps,de=W.type===W.elementType?le:lg(W.type,le),se.props=de,he=W.pendingProps,ge=se.context,"object"==typeof(ue=G.contextType)&&null!==ue?ue=vg(ue):ue=Ef(W,ue=Ff(G)?Vo:Lo.current);var ve=G.getDerivedStateFromProps;(pe="function"==typeof ve||"function"==typeof se.getSnapshotBeforeUpdate)||"function"!=typeof se.UNSAFE_componentWillReceiveProps&&"function"!=typeof se.componentWillReceiveProps||(le!==he||ge!==ue)&&Ng(W,se,oe,ue),ka=!1,ge=W.memoizedState,se.state=ge,Cg(W,oe,se,ae);var we=W.memoizedState;le!==he||ge!==we||Ho.current||ka?("function"==typeof ve&&(Gg(W,G,ve,oe),we=W.memoizedState),(de=ka||Lg(W,G,de,oe,ge,we,ue))?(pe||"function"!=typeof se.UNSAFE_componentWillUpdate&&"function"!=typeof se.componentWillUpdate||("function"==typeof se.componentWillUpdate&&se.componentWillUpdate(oe,we,ue),"function"==typeof se.UNSAFE_componentWillUpdate&&se.UNSAFE_componentWillUpdate(oe,we,ue)),"function"==typeof se.componentDidUpdate&&(W.flags|=4),"function"==typeof se.getSnapshotBeforeUpdate&&(W.flags|=256)):("function"!=typeof se.componentDidUpdate||le===$.memoizedProps&&ge===$.memoizedState||(W.flags|=4),"function"!=typeof se.getSnapshotBeforeUpdate||le===$.memoizedProps&&ge===$.memoizedState||(W.flags|=256),W.memoizedProps=oe,W.memoizedState=we),se.props=oe,se.state=we,se.context=ue,oe=de):("function"!=typeof se.componentDidUpdate||le===$.memoizedProps&&ge===$.memoizedState||(W.flags|=4),"function"!=typeof se.getSnapshotBeforeUpdate||le===$.memoizedProps&&ge===$.memoizedState||(W.flags|=256),oe=!1)}return qi($,W,G,oe,ie,ae)}function qi($,W,G,oe,ae,ie){oi($,W);var se=0!=(64&W.flags);if(!oe&&!se)return ae&&Kf(W,G,!1),hi($,W,ie);oe=W.stateNode,Hi.current=W;var le=se&&"function"!=typeof G.getDerivedStateFromError?null:oe.render();return W.flags|=1,null!==$&&se?(W.child=Ca(W,$.child,null,ie),W.child=Ca(W,null,le,ie)):fi($,W,le,ie),W.memoizedState=oe.state,ae&&Kf(W,G,!0),W.child}function ri($){var W=$.stateNode;W.pendingContext?Hf(0,W.pendingContext,W.pendingContext!==W.context):W.context&&Hf(0,W.context,!1),eh($,W.containerInfo)}var Ji,Qi,es,ts={dehydrated:null,retryLane:0};function ti($,W,G){var oe,ae=W.pendingProps,ie=Ma.current,se=!1;return(oe=0!=(64&W.flags))||(oe=(null===$||null!==$.memoizedState)&&0!=(2&ie)),oe?(se=!0,W.flags&=-65):null!==$&&null===$.memoizedState||void 0===ae.fallback||!0===ae.unstable_avoidThisFallback||(ie|=1),I$1(Ma,1&ie),null===$?(void 0!==ae.fallback&&ph(W),$=ae.children,ie=ae.fallback,se?($=ui(W,$,ie,G),W.child.memoizedState={baseLanes:G},W.memoizedState=ts,$):"number"==typeof ae.unstable_expectedLoadTime?($=ui(W,$,ie,G),W.child.memoizedState={baseLanes:G},W.memoizedState=ts,W.lanes=33554432,$):((G=vi({mode:"visible",children:$},W.mode,G,null)).return=W,W.child=G)):($.memoizedState,se?(ae=wi($,W,ae.children,ae.fallback,G),se=W.child,ie=$.child.memoizedState,se.memoizedState=null===ie?{baseLanes:G}:{baseLanes:ie.baseLanes|G},se.childLanes=$.childLanes&~G,W.memoizedState=ts,ae):(G=xi($,W,ae.children,G),W.memoizedState=null,G))}function ui($,W,G,oe){var ae=$.mode,ie=$.child;return W={mode:"hidden",children:W},0==(2&ae)&&null!==ie?(ie.childLanes=0,ie.pendingProps=W):ie=vi(W,ae,0,null),G=Xg(G,ae,oe,null),ie.return=$,G.return=$,ie.sibling=G,$.child=ie,G}function xi($,W,G,oe){var ae=$.child;return $=ae.sibling,G=Tg(ae,{mode:"visible",children:G}),0==(2&W.mode)&&(G.lanes=oe),G.return=W,G.sibling=null,null!==$&&($.nextEffect=null,$.flags=8,W.firstEffect=W.lastEffect=$),W.child=G}function wi($,W,G,oe,ae){var ie=W.mode,se=$.child;$=se.sibling;var le={mode:"hidden",children:G};return 0==(2&ie)&&W.child!==se?((G=W.child).childLanes=0,G.pendingProps=le,null!==(se=G.lastEffect)?(W.firstEffect=G.firstEffect,W.lastEffect=se,se.nextEffect=null):W.firstEffect=W.lastEffect=null):G=Tg(se,le),null!==$?oe=Tg($,oe):(oe=Xg(oe,ie,ae,null)).flags|=2,oe.return=W,G.return=W,G.sibling=oe,W.child=G,oe}function yi($,W){$.lanes|=W;var G=$.alternate;null!==G&&(G.lanes|=W),sg($.return,W)}function zi($,W,G,oe,ae,ie){var se=$.memoizedState;null===se?$.memoizedState={isBackwards:W,rendering:null,renderingStartTime:0,last:oe,tail:G,tailMode:ae,lastEffect:ie}:(se.isBackwards=W,se.rendering=null,se.renderingStartTime=0,se.last=oe,se.tail=G,se.tailMode=ae,se.lastEffect=ie)}function Ai($,W,G){var oe=W.pendingProps,ae=oe.revealOrder,ie=oe.tail;if(fi($,W,oe.children,G),0!=(2&(oe=Ma.current)))oe=1&oe|2,W.flags|=64;else{if(null!==$&&0!=(64&$.flags))e:for($=W.child;null!==$;){if(13===$.tag)null!==$.memoizedState&&yi($,G);else if(19===$.tag)yi($,G);else if(null!==$.child){$.child.return=$,$=$.child;continue}if($===W)break e;for(;null===$.sibling;){if(null===$.return||$.return===W)break e;$=$.return}$.sibling.return=$.return,$=$.sibling}oe&=1}if(I$1(Ma,oe),0==(2&W.mode))W.memoizedState=null;else switch(ae){case"forwards":for(G=W.child,ae=null;null!==G;)null!==($=G.alternate)&&null===ih($)&&(ae=G),G=G.sibling;null===(G=ae)?(ae=W.child,W.child=null):(ae=G.sibling,G.sibling=null),zi(W,!1,ae,G,ie,W.lastEffect);break;case"backwards":for(G=null,ae=W.child,W.child=null;null!==ae;){if(null!==($=ae.alternate)&&null===ih($)){W.child=ae;break}$=ae.sibling,ae.sibling=G,G=ae,ae=$}zi(W,!0,G,null,ie,W.lastEffect);break;case"together":zi(W,!1,null,null,void 0,W.lastEffect);break;default:W.memoizedState=null}return W.child}function hi($,W,G){if(null!==$&&(W.dependencies=$.dependencies),gs|=W.lanes,0!=(G&W.childLanes)){if(null!==$&&W.child!==$.child)throw Error(y$1(153));if(null!==W.child){for(G=Tg($=W.child,$.pendingProps),W.child=G,G.return=W;null!==$.sibling;)$=$.sibling,(G=G.sibling=Tg($,$.pendingProps)).return=W;G.sibling=null}return W.child}return null}function Fi($,W){if(!Ha)switch($.tailMode){case"hidden":W=$.tail;for(var G=null;null!==W;)null!==W.alternate&&(G=W),W=W.sibling;null===G?$.tail=null:G.sibling=null;break;case"collapsed":G=$.tail;for(var oe=null;null!==G;)null!==G.alternate&&(oe=G),G=G.sibling;null===oe?W||null===$.tail?$.tail=null:$.tail.sibling=null:oe.sibling=null}}function Gi($,W,G){var oe=W.pendingProps;switch(W.tag){case 2:case 16:case 15:case 0:case 11:case 7:case 8:case 12:case 9:case 14:return null;case 1:case 17:return Ff(W.type)&&Gf(),null;case 3:return fh(),H$1(Ho),H$1(Lo),uh(),(oe=W.stateNode).pendingContext&&(oe.context=oe.pendingContext,oe.pendingContext=null),null!==$&&null!==$.child||(rh(W)?W.flags|=4:oe.hydrate||(W.flags|=256)),null;case 5:hh(W);var ae=dh(za.current);if(G=W.type,null!==$&&null!=W.stateNode)Qi($,W,G,oe),$.ref!==W.ref&&(W.flags|=128);else{if(!oe){if(null===W.stateNode)throw Error(y$1(166));return null}if($=dh(Da.current),rh(W)){oe=W.stateNode,G=W.type;var ie=W.memoizedProps;switch(oe[$o]=W,oe[zo]=ie,G){case"dialog":G$1("cancel",oe),G$1("close",oe);break;case"iframe":case"object":case"embed":G$1("load",oe);break;case"video":case"audio":for($=0;$<Po.length;$++)G$1(Po[$],oe);break;case"source":G$1("error",oe);break;case"img":case"image":case"link":G$1("error",oe),G$1("load",oe);break;case"details":G$1("toggle",oe);break;case"input":Za(oe,ie),G$1("invalid",oe);break;case"select":oe._wrapperState={wasMultiple:!!ie.multiple},G$1("invalid",oe);break;case"textarea":hb(oe,ie),G$1("invalid",oe)}for(var se in vb(G,ie),$=null,ie)ie.hasOwnProperty(se)&&(ae=ie[se],"children"===se?"string"==typeof ae?oe.textContent!==ae&&($=["children",ae]):"number"==typeof ae&&oe.textContent!==""+ae&&($=["children",""+ae]):Jt.hasOwnProperty(se)&&null!=ae&&"onScroll"===se&&G$1("scroll",oe));switch(G){case"input":Va(oe),cb(oe,ie,!0);break;case"textarea":Va(oe),jb(oe);break;case"select":case"option":break;default:"function"==typeof ie.onClick&&(oe.onclick=jf)}oe=$,W.updateQueue=oe,null!==oe&&(W.flags|=4)}else{switch(se=9===ae.nodeType?ae:ae.ownerDocument,$===jr&&($=lb(G)),$===jr?"script"===G?(($=se.createElement("div")).innerHTML="<script><\/script>",$=$.removeChild($.firstChild)):"string"==typeof oe.is?$=se.createElement(G,{is:oe.is}):($=se.createElement(G),"select"===G&&(se=$,oe.multiple?se.multiple=!0:oe.size&&(se.size=oe.size))):$=se.createElementNS($,G),$[$o]=W,$[zo]=oe,Ji($,W),W.stateNode=$,se=wb(G,oe),G){case"dialog":G$1("cancel",$),G$1("close",$),ae=oe;break;case"iframe":case"object":case"embed":G$1("load",$),ae=oe;break;case"video":case"audio":for(ae=0;ae<Po.length;ae++)G$1(Po[ae],$);ae=oe;break;case"source":G$1("error",$),ae=oe;break;case"img":case"image":case"link":G$1("error",$),G$1("load",$),ae=oe;break;case"details":G$1("toggle",$),ae=oe;break;case"input":Za($,oe),ae=Ya($,oe),G$1("invalid",$);break;case"option":ae=eb($,oe);break;case"select":$._wrapperState={wasMultiple:!!oe.multiple},ae=Gt({},oe,{value:void 0}),G$1("invalid",$);break;case"textarea":hb($,oe),ae=gb($,oe),G$1("invalid",$);break;default:ae=oe}vb(G,ae);var le=ae;for(ie in le)if(le.hasOwnProperty(ie)){var ue=le[ie];"style"===ie?tb($,ue):"dangerouslySetInnerHTML"===ie?null!=(ue=ue?ue.__html:void 0)&&Tr($,ue):"children"===ie?"string"==typeof ue?("textarea"!==G||""!==ue)&&pb($,ue):"number"==typeof ue&&pb($,""+ue):"suppressContentEditableWarning"!==ie&&"suppressHydrationWarning"!==ie&&"autoFocus"!==ie&&(Jt.hasOwnProperty(ie)?null!=ue&&"onScroll"===ie&&G$1("scroll",$):null!=ue&&qa($,ie,ue,se))}switch(G){case"input":Va($),cb($,oe,!1);break;case"textarea":Va($),jb($);break;case"option":null!=oe.value&&$.setAttribute("value",""+Sa(oe.value));break;case"select":$.multiple=!!oe.multiple,null!=(ie=oe.value)?fb($,!!oe.multiple,ie,!1):null!=oe.defaultValue&&fb($,!!oe.multiple,oe.defaultValue,!0);break;default:"function"==typeof ae.onClick&&($.onclick=jf)}mf(G,oe)&&(W.flags|=4)}null!==W.ref&&(W.flags|=128)}return null;case 6:if($&&null!=W.stateNode)es(0,W,$.memoizedProps,oe);else{if("string"!=typeof oe&&null===W.stateNode)throw Error(y$1(166));G=dh(za.current),dh(Da.current),rh(W)?(oe=W.stateNode,G=W.memoizedProps,oe[$o]=W,oe.nodeValue!==G&&(W.flags|=4)):((oe=(9===G.nodeType?G:G.ownerDocument).createTextNode(oe))[$o]=W,W.stateNode=oe)}return null;case 13:return H$1(Ma),oe=W.memoizedState,0!=(64&W.flags)?(W.lanes=G,W):(oe=null!==oe,G=!1,null===$?void 0!==W.memoizedProps.fallback&&rh(W):G=null!==$.memoizedState,oe&&!G&&0!=(2&W.mode)&&(null===$&&!0!==W.memoizedProps.unstable_avoidThisFallback||0!=(1&Ma.current)?0===ps&&(ps=3):(0!==ps&&3!==ps||(ps=4),null===ls||0==(134217727&gs)&&0==(134217727&vs)||Ii(ls,cs))),(oe||G)&&(W.flags|=4),null);case 4:return fh(),null===$&&cf(W.stateNode.containerInfo),null;case 10:return rg(W),null;case 19:if(H$1(Ma),null===(oe=W.memoizedState))return null;if(ie=0!=(64&W.flags),null===(se=oe.rendering))if(ie)Fi(oe,!1);else{if(0!==ps||null!==$&&0!=(64&$.flags))for($=W.child;null!==$;){if(null!==(se=ih($))){for(W.flags|=64,Fi(oe,!1),null!==(ie=se.updateQueue)&&(W.updateQueue=ie,W.flags|=4),null===oe.lastEffect&&(W.firstEffect=null),W.lastEffect=oe.lastEffect,oe=G,G=W.child;null!==G;)$=oe,(ie=G).flags&=2,ie.nextEffect=null,ie.firstEffect=null,ie.lastEffect=null,null===(se=ie.alternate)?(ie.childLanes=0,ie.lanes=$,ie.child=null,ie.memoizedProps=null,ie.memoizedState=null,ie.updateQueue=null,ie.dependencies=null,ie.stateNode=null):(ie.childLanes=se.childLanes,ie.lanes=se.lanes,ie.child=se.child,ie.memoizedProps=se.memoizedProps,ie.memoizedState=se.memoizedState,ie.updateQueue=se.updateQueue,ie.type=se.type,$=se.dependencies,ie.dependencies=null===$?null:{lanes:$.lanes,firstContext:$.firstContext}),G=G.sibling;return I$1(Ma,1&Ma.current|2),W.child}$=$.sibling}null!==oe.tail&&ga()>Ss&&(W.flags|=64,ie=!0,Fi(oe,!1),W.lanes=33554432)}else{if(!ie)if(null!==($=ih(se))){if(W.flags|=64,ie=!0,null!==(G=$.updateQueue)&&(W.updateQueue=G,W.flags|=4),Fi(oe,!0),null===oe.tail&&"hidden"===oe.tailMode&&!se.alternate&&!Ha)return null!==(W=W.lastEffect=oe.lastEffect)&&(W.nextEffect=null),null}else 2*ga()-oe.renderingStartTime>Ss&&1073741824!==G&&(W.flags|=64,ie=!0,Fi(oe,!1),W.lanes=33554432);oe.isBackwards?(se.sibling=W.child,W.child=se):(null!==(G=oe.last)?G.sibling=se:W.child=se,oe.last=se)}return null!==oe.tail?(G=oe.tail,oe.rendering=G,oe.tail=G.sibling,oe.lastEffect=W.lastEffect,oe.renderingStartTime=ga(),G.sibling=null,W=Ma.current,I$1(Ma,ie?1&W|2:1&W),G):null;case 23:case 24:return Ki(),null!==$&&null!==$.memoizedState!=(null!==W.memoizedState)&&"unstable-defer-without-hiding"!==oe.mode&&(W.flags|=4),null}throw Error(y$1(156,W.tag))}function Li($){switch($.tag){case 1:Ff($.type)&&Gf();var W=$.flags;return 4096&W?($.flags=-4097&W|64,$):null;case 3:if(fh(),H$1(Ho),H$1(Lo),uh(),0!=(64&(W=$.flags)))throw Error(y$1(285));return $.flags=-4097&W|64,$;case 5:return hh($),null;case 13:return H$1(Ma),4096&(W=$.flags)?($.flags=-4097&W|64,$):null;case 19:return H$1(Ma),null;case 4:return fh(),null;case 10:return rg($),null;case 23:case 24:return Ki(),null;default:return null}}function Mi($,W){try{var G="",oe=W;do{G+=Qa(oe),oe=oe.return}while(oe);var ae=G}catch($){ae="\nError generating stack: "+$.message+"\n"+$.stack}return{value:$,source:W,stack:ae}}function Ni($,W){try{console.error(W.value)}catch($){setTimeout((function(){throw $}))}}Ji=function($,W){for(var G=W.child;null!==G;){if(5===G.tag||6===G.tag)$.appendChild(G.stateNode);else if(4!==G.tag&&null!==G.child){G.child.return=G,G=G.child;continue}if(G===W)break;for(;null===G.sibling;){if(null===G.return||G.return===W)return;G=G.return}G.sibling.return=G.return,G=G.sibling}},Qi=function($,W,G,oe){var ae=$.memoizedProps;if(ae!==oe){$=W.stateNode,dh(Da.current);var ie,se=null;switch(G){case"input":ae=Ya($,ae),oe=Ya($,oe),se=[];break;case"option":ae=eb($,ae),oe=eb($,oe),se=[];break;case"select":ae=Gt({},ae,{value:void 0}),oe=Gt({},oe,{value:void 0}),se=[];break;case"textarea":ae=gb($,ae),oe=gb($,oe),se=[];break;default:"function"!=typeof ae.onClick&&"function"==typeof oe.onClick&&($.onclick=jf)}for(de in vb(G,oe),G=null,ae)if(!oe.hasOwnProperty(de)&&ae.hasOwnProperty(de)&&null!=ae[de])if("style"===de){var le=ae[de];for(ie in le)le.hasOwnProperty(ie)&&(G||(G={}),G[ie]="")}else"dangerouslySetInnerHTML"!==de&&"children"!==de&&"suppressContentEditableWarning"!==de&&"suppressHydrationWarning"!==de&&"autoFocus"!==de&&(Jt.hasOwnProperty(de)?se||(se=[]):(se=se||[]).push(de,null));for(de in oe){var ue=oe[de];if(le=null!=ae?ae[de]:void 0,oe.hasOwnProperty(de)&&ue!==le&&(null!=ue||null!=le))if("style"===de)if(le){for(ie in le)!le.hasOwnProperty(ie)||ue&&ue.hasOwnProperty(ie)||(G||(G={}),G[ie]="");for(ie in ue)ue.hasOwnProperty(ie)&&le[ie]!==ue[ie]&&(G||(G={}),G[ie]=ue[ie])}else G||(se||(se=[]),se.push(de,G)),G=ue;else"dangerouslySetInnerHTML"===de?(ue=ue?ue.__html:void 0,le=le?le.__html:void 0,null!=ue&&le!==ue&&(se=se||[]).push(de,ue)):"children"===de?"string"!=typeof ue&&"number"!=typeof ue||(se=se||[]).push(de,""+ue):"suppressContentEditableWarning"!==de&&"suppressHydrationWarning"!==de&&(Jt.hasOwnProperty(de)?(null!=ue&&"onScroll"===de&&G$1("scroll",$),se||le===ue||(se=[])):"object"==typeof ue&&null!==ue&&ue.$$typeof===br?ue.toString():(se=se||[]).push(de,ue))}G&&(se=se||[]).push("style",G);var de=se;(W.updateQueue=de)&&(W.flags|=4)}},es=function($,W,G,oe){G!==oe&&(W.flags|=4)};var rs="function"==typeof WeakMap?WeakMap:Map;function Pi($,W,G){(G=zg(-1,G)).tag=3,G.payload={element:null};var oe=W.value;return G.callback=function(){_s||(_s=!0,Ps=oe),Ni(0,W)},G}function Si($,W,G){(G=zg(-1,G)).tag=3;var oe=$.type.getDerivedStateFromError;if("function"==typeof oe){var ae=W.value;G.payload=function(){return Ni(0,W),oe(ae)}}var ie=$.stateNode;return null!==ie&&"function"==typeof ie.componentDidCatch&&(G.callback=function(){"function"!=typeof oe&&(null===Es?Es=new Set([this]):Es.add(this),Ni(0,W));var $=W.stack;this.componentDidCatch(W.value,{componentStack:null!==$?$:""})}),G}var ns="function"==typeof WeakSet?WeakSet:Set;function Vi($){var W=$.ref;if(null!==W)if("function"==typeof W)try{W(null)}catch(W){Wi($,W)}else W.current=null}function Xi($,W){switch(W.tag){case 0:case 11:case 15:case 22:case 5:case 6:case 4:case 17:return;case 1:if(256&W.flags&&null!==$){var G=$.memoizedProps,oe=$.memoizedState;W=($=W.stateNode).getSnapshotBeforeUpdate(W.elementType===W.type?G:lg(W.type,G),oe),$.__reactInternalSnapshotBeforeUpdate=W}return;case 3:return void(256&W.flags&&qf(W.stateNode.containerInfo))}throw Error(y$1(163))}function Yi($,W,G){switch(G.tag){case 0:case 11:case 15:case 22:if(null!==(W=null!==(W=G.updateQueue)?W.lastEffect:null)){$=W=W.next;do{if(3==(3&$.tag)){var oe=$.create;$.destroy=oe()}$=$.next}while($!==W)}if(null!==(W=null!==(W=G.updateQueue)?W.lastEffect:null)){$=W=W.next;do{var ae=$;oe=ae.next,0!=(4&(ae=ae.tag))&&0!=(1&ae)&&(Zi(G,$),$i(G,$)),$=oe}while($!==W)}return;case 1:return $=G.stateNode,4&G.flags&&(null===W?$.componentDidMount():(oe=G.elementType===G.type?W.memoizedProps:lg(G.type,W.memoizedProps),$.componentDidUpdate(oe,W.memoizedState,$.__reactInternalSnapshotBeforeUpdate))),void(null!==(W=G.updateQueue)&&Eg(G,W,$));case 3:if(null!==(W=G.updateQueue)){if($=null,null!==G.child)switch(G.child.tag){case 5:case 1:$=G.child.stateNode}Eg(G,W,$)}return;case 5:return $=G.stateNode,void(null===W&&4&G.flags&&mf(G.type,G.memoizedProps)&&$.focus());case 6:case 4:case 12:case 19:case 17:case 20:case 21:case 23:case 24:return;case 13:return void(null===G.memoizedState&&(G=G.alternate,null!==G&&(G=G.memoizedState,null!==G&&(G=G.dehydrated,null!==G&&Cc(G)))))}throw Error(y$1(163))}function aj($,W){for(var G=$;;){if(5===G.tag){var oe=G.stateNode;if(W)"function"==typeof(oe=oe.style).setProperty?oe.setProperty("display","none","important"):oe.display="none";else{oe=G.stateNode;var ae=G.memoizedProps.style;ae=null!=ae&&ae.hasOwnProperty("display")?ae.display:null,oe.style.display=sb("display",ae)}}else if(6===G.tag)G.stateNode.nodeValue=W?"":G.memoizedProps;else if((23!==G.tag&&24!==G.tag||null===G.memoizedState||G===$)&&null!==G.child){G.child.return=G,G=G.child;continue}if(G===$)break;for(;null===G.sibling;){if(null===G.return||G.return===$)return;G=G.return}G.sibling.return=G.return,G=G.sibling}}function bj($,W){if(Uo&&"function"==typeof Uo.onCommitFiberUnmount)try{Uo.onCommitFiberUnmount(qo,W)}catch($){}switch(W.tag){case 0:case 11:case 14:case 15:case 22:if(null!==($=W.updateQueue)&&null!==($=$.lastEffect)){var G=$=$.next;do{var oe=G,ae=oe.destroy;if(oe=oe.tag,void 0!==ae)if(0!=(4&oe))Zi(W,G);else{oe=W;try{ae()}catch($){Wi(oe,$)}}G=G.next}while(G!==$)}break;case 1:if(Vi(W),"function"==typeof($=W.stateNode).componentWillUnmount)try{$.props=W.memoizedProps,$.state=W.memoizedState,$.componentWillUnmount()}catch($){Wi(W,$)}break;case 5:Vi(W);break;case 4:cj($,W)}}function dj($){$.alternate=null,$.child=null,$.dependencies=null,$.firstEffect=null,$.lastEffect=null,$.memoizedProps=null,$.memoizedState=null,$.pendingProps=null,$.return=null,$.updateQueue=null}function ej($){return 5===$.tag||3===$.tag||4===$.tag}function fj($){e:{for(var W=$.return;null!==W;){if(ej(W))break e;W=W.return}throw Error(y$1(160))}var G=W;switch(W=G.stateNode,G.tag){case 5:var oe=!1;break;case 3:case 4:W=W.containerInfo,oe=!0;break;default:throw Error(y$1(161))}16&G.flags&&(pb(W,""),G.flags&=-17);e:t:for(G=$;;){for(;null===G.sibling;){if(null===G.return||ej(G.return)){G=null;break e}G=G.return}for(G.sibling.return=G.return,G=G.sibling;5!==G.tag&&6!==G.tag&&18!==G.tag;){if(2&G.flags)continue t;if(null===G.child||4===G.tag)continue t;G.child.return=G,G=G.child}if(!(2&G.flags)){G=G.stateNode;break e}}oe?gj($,G,W):hj($,G,W)}function gj($,W,G){var oe=$.tag,ae=5===oe||6===oe;if(ae)$=ae?$.stateNode:$.stateNode.instance,W?8===G.nodeType?G.parentNode.insertBefore($,W):G.insertBefore($,W):(8===G.nodeType?(W=G.parentNode).insertBefore($,G):(W=G).appendChild($),null!=(G=G._reactRootContainer)||null!==W.onclick||(W.onclick=jf));else if(4!==oe&&null!==($=$.child))for(gj($,W,G),$=$.sibling;null!==$;)gj($,W,G),$=$.sibling}function hj($,W,G){var oe=$.tag,ae=5===oe||6===oe;if(ae)$=ae?$.stateNode:$.stateNode.instance,W?G.insertBefore($,W):G.appendChild($);else if(4!==oe&&null!==($=$.child))for(hj($,W,G),$=$.sibling;null!==$;)hj($,W,G),$=$.sibling}function cj($,W){for(var G,oe,ae=W,ie=!1;;){if(!ie){ie=ae.return;e:for(;;){if(null===ie)throw Error(y$1(160));switch(G=ie.stateNode,ie.tag){case 5:oe=!1;break e;case 3:case 4:G=G.containerInfo,oe=!0;break e}ie=ie.return}ie=!0}if(5===ae.tag||6===ae.tag){e:for(var se=$,le=ae,ue=le;;)if(bj(se,ue),null!==ue.child&&4!==ue.tag)ue.child.return=ue,ue=ue.child;else{if(ue===le)break e;for(;null===ue.sibling;){if(null===ue.return||ue.return===le)break e;ue=ue.return}ue.sibling.return=ue.return,ue=ue.sibling}oe?(se=G,le=ae.stateNode,8===se.nodeType?se.parentNode.removeChild(le):se.removeChild(le)):G.removeChild(ae.stateNode)}else if(4===ae.tag){if(null!==ae.child){G=ae.stateNode.containerInfo,oe=!0,ae.child.return=ae,ae=ae.child;continue}}else if(bj($,ae),null!==ae.child){ae.child.return=ae,ae=ae.child;continue}if(ae===W)break;for(;null===ae.sibling;){if(null===ae.return||ae.return===W)return;4===(ae=ae.return).tag&&(ie=!1)}ae.sibling.return=ae.return,ae=ae.sibling}}function ij($,W){switch(W.tag){case 0:case 11:case 14:case 15:case 22:var G=W.updateQueue;if(null!==(G=null!==G?G.lastEffect:null)){var oe=G=G.next;do{3==(3&oe.tag)&&($=oe.destroy,oe.destroy=void 0,void 0!==$&&$()),oe=oe.next}while(oe!==G)}return;case 1:case 12:case 17:return;case 5:if(null!=(G=W.stateNode)){oe=W.memoizedProps;var ae=null!==$?$.memoizedProps:oe;$=W.type;var ie=W.updateQueue;if(W.updateQueue=null,null!==ie){for(G[zo]=oe,"input"===$&&"radio"===oe.type&&null!=oe.name&&$a(G,oe),wb($,ae),W=wb($,oe),ae=0;ae<ie.length;ae+=2){var se=ie[ae],le=ie[ae+1];"style"===se?tb(G,le):"dangerouslySetInnerHTML"===se?Tr(G,le):"children"===se?pb(G,le):qa(G,se,le,W)}switch($){case"input":ab(G,oe);break;case"textarea":ib(G,oe);break;case"select":$=G._wrapperState.wasMultiple,G._wrapperState.wasMultiple=!!oe.multiple,null!=(ie=oe.value)?fb(G,!!oe.multiple,ie,!1):$!==!!oe.multiple&&(null!=oe.defaultValue?fb(G,!!oe.multiple,oe.defaultValue,!0):fb(G,!!oe.multiple,oe.multiple?[]:"",!1))}}}return;case 6:if(null===W.stateNode)throw Error(y$1(162));return void(W.stateNode.nodeValue=W.memoizedProps);case 3:return void((G=W.stateNode).hydrate&&(G.hydrate=!1,Cc(G.containerInfo)));case 13:return null!==W.memoizedState&&(ws=ga(),aj(W.child,!0)),void kj(W);case 19:return void kj(W);case 23:case 24:return void aj(W,null!==W.memoizedState)}throw Error(y$1(163))}function kj($){var W=$.updateQueue;if(null!==W){$.updateQueue=null;var G=$.stateNode;null===G&&(G=$.stateNode=new ns),W.forEach((function(W){var oe=lj.bind(null,$,W);G.has(W)||(G.add(W),W.then(oe,oe))}))}}function mj($,W){return null!==$&&(null===($=$.memoizedState)||null!==$.dehydrated)&&(null!==(W=W.memoizedState)&&null===W.dehydrated)}var os=Math.ceil,as=ar.ReactCurrentDispatcher,is=ar.ReactCurrentOwner,ss=0,ls=null,us=null,cs=0,ds=0,fs=Bf(0),ps=0,hs=null,ms=0,gs=0,vs=0,ys=0,bs=null,ws=0,Ss=1/0;function wj(){Ss=ga()+500}var xs,ks=null,_s=!1,Ps=null,Es=null,js=!1,Cs=null,Os=90,Is=[],Ts=[],Ds=null,As=0,$s=null,zs=-1,Ms=0,Rs=0,Bs=null,Fs=!1;function Hg(){return 0!=(48&ss)?ga():-1!==zs?zs:zs=ga()}function Ig($){if(0==(2&($=$.mode)))return 1;if(0==(4&$))return 99===eg()?1:2;if(0===Ms&&(Ms=ms),0!==va.transition){0!==Rs&&(Rs=null!==bs?bs.pendingLanes:0),$=Ms;var W=4186112&~Rs;return 0===(W&=-W)&&(0===(W=($=4186112&~$)&-$)&&(W=8192)),W}return $=eg(),0!=(4&ss)&&98===$?$=Xc(12,Ms):$=Xc($=function Sc($){switch($){case 99:return 15;case 98:return 10;case 97:case 96:return 8;case 95:return 2;default:return 0}}($),Ms),$}function Jg($,W,G){if(50<As)throw As=0,$s=null,Error(y$1(185));if(null===($=Kj($,W)))return null;$c($,W,G),$===ls&&(vs|=W,4===ps&&Ii($,cs));var oe=eg();1===W?0!=(8&ss)&&0==(48&ss)?Lj($):(Mj($,G),0===ss&&(wj(),ig())):(0==(4&ss)||98!==oe&&99!==oe||(null===Ds?Ds=new Set([$]):Ds.add($)),Mj($,G)),bs=$}function Kj($,W){$.lanes|=W;var G=$.alternate;for(null!==G&&(G.lanes|=W),G=$,$=$.return;null!==$;)$.childLanes|=W,null!==(G=$.alternate)&&(G.childLanes|=W),G=$,$=$.return;return 3===G.tag?G.stateNode:null}function Mj($,W){for(var G=$.callbackNode,oe=$.suspendedLanes,ae=$.pingedLanes,ie=$.expirationTimes,se=$.pendingLanes;0<se;){var le=31-wn(se),ue=1<<le,de=ie[le];if(-1===de){if(0==(ue&oe)||0!=(ue&ae)){de=W,Rc(ue);var pe=bn;ie[le]=10<=pe?de+250:6<=pe?de+5e3:-1}}else de<=W&&($.expiredLanes|=ue);se&=~ue}if(oe=Uc($,$===ls?cs:0),W=bn,0===oe)null!==G&&(G!==ia&&Go(G),$.callbackNode=null,$.callbackPriority=0);else{if(null!==G){if($.callbackPriority===W)return;G!==ia&&Go(G)}15===W?(G=Lj.bind(null,$),null===ua?(ua=[G],ca=Wo(Zo,jg)):ua.push(G),G=ia):14===W?G=hg(99,Lj.bind(null,$)):(G=function Tc($){switch($){case 15:case 14:return 99;case 13:case 12:case 11:case 10:return 98;case 9:case 8:case 7:case 6:case 4:case 5:return 97;case 3:case 2:case 1:return 95;case 0:return 90;default:throw Error(y$1(358,$))}}(W),G=hg(G,Nj.bind(null,$))),$.callbackPriority=W,$.callbackNode=G}}function Nj($){if(zs=-1,Rs=Ms=0,0!=(48&ss))throw Error(y$1(327));var W=$.callbackNode;if(Oj()&&$.callbackNode!==W)return null;var G=Uc($,$===ls?cs:0);if(0===G)return null;var oe=G,ae=ss;ss|=16;var ie=Pj();for(ls===$&&cs===oe||(wj(),Qj($,oe));;)try{Rj();break}catch(W){Sj($,W)}if(qg(),as.current=ie,ss=ae,null!==us?oe=0:(ls=null,cs=0,oe=ps),0!=(ms&vs))Qj($,0);else if(0!==oe){if(2===oe&&(ss|=64,$.hydrate&&($.hydrate=!1,qf($.containerInfo)),0!==(G=Wc($))&&(oe=Tj($,G))),1===oe)throw W=hs,Qj($,0),Ii($,G),Mj($,ga()),W;switch($.finishedWork=$.current.alternate,$.finishedLanes=G,oe){case 0:case 1:throw Error(y$1(345));case 2:case 5:Uj($);break;case 3:if(Ii($,G),(62914560&G)===G&&10<(oe=ws+500-ga())){if(0!==Uc($,0))break;if(((ae=$.suspendedLanes)&G)!==G){Hg(),$.pingedLanes|=$.suspendedLanes&ae;break}$.timeoutHandle=Io(Uj.bind(null,$),oe);break}Uj($);break;case 4:if(Ii($,G),(4186112&G)===G)break;for(oe=$.eventTimes,ae=-1;0<G;){var se=31-wn(G);ie=1<<se,(se=oe[se])>ae&&(ae=se),G&=~ie}if(G=ae,10<(G=(120>(G=ga()-G)?120:480>G?480:1080>G?1080:1920>G?1920:3e3>G?3e3:4320>G?4320:1960*os(G/1960))-G)){$.timeoutHandle=Io(Uj.bind(null,$),G);break}Uj($);break;default:throw Error(y$1(329))}}return Mj($,ga()),$.callbackNode===W?Nj.bind(null,$):null}function Ii($,W){for(W&=~ys,W&=~vs,$.suspendedLanes|=W,$.pingedLanes&=~W,$=$.expirationTimes;0<W;){var G=31-wn(W),oe=1<<G;$[G]=-1,W&=~oe}}function Lj($){if(0!=(48&ss))throw Error(y$1(327));if(Oj(),$===ls&&0!=($.expiredLanes&cs)){var W=cs,G=Tj($,W);0!=(ms&vs)&&(G=Tj($,W=Uc($,W)))}else G=Tj($,W=Uc($,0));if(0!==$.tag&&2===G&&(ss|=64,$.hydrate&&($.hydrate=!1,qf($.containerInfo)),0!==(W=Wc($))&&(G=Tj($,W))),1===G)throw G=hs,Qj($,0),Ii($,W),Mj($,ga()),G;return $.finishedWork=$.current.alternate,$.finishedLanes=W,Uj($),Mj($,ga()),null}function Wj($,W){var G=ss;ss|=1;try{return $(W)}finally{0===(ss=G)&&(wj(),ig())}}function Xj($,W){var G=ss;ss&=-2,ss|=8;try{return $(W)}finally{0===(ss=G)&&(wj(),ig())}}function ni($,W){I$1(fs,ds),ds|=W,ms|=W}function Ki(){ds=fs.current,H$1(fs)}function Qj($,W){$.finishedWork=null,$.finishedLanes=0;var G=$.timeoutHandle;if(-1!==G&&($.timeoutHandle=-1,To(G)),null!==us)for(G=us.return;null!==G;){var oe=G;switch(oe.tag){case 1:null!=(oe=oe.type.childContextTypes)&&Gf();break;case 3:fh(),H$1(Ho),H$1(Lo),uh();break;case 5:hh(oe);break;case 4:fh();break;case 13:case 19:H$1(Ma);break;case 10:rg(oe);break;case 23:case 24:Ki()}G=G.return}ls=$,us=Tg($.current,null),cs=ds=ms=W,ps=0,hs=null,ys=vs=gs=0}function Sj($,W){for(;;){var G=us;try{if(qg(),Ga.current=Ti,Ci){for(var oe=si.memoizedState;null!==oe;){var ae=oe.queue;null!==ae&&(ae.pending=null),oe=oe.next}Ci=!1}if(ei=0,Ei=_i=si=null,Oi=!1,is.current=null,null===G||null===G.return){ps=1,hs=W,us=null;break}e:{var ie=$,se=G.return,le=G,ue=W;if(W=cs,le.flags|=2048,le.firstEffect=le.lastEffect=null,null!==ue&&"object"==typeof ue&&"function"==typeof ue.then){var de=ue;if(0==(2&le.mode)){var pe=le.alternate;pe?(le.updateQueue=pe.updateQueue,le.memoizedState=pe.memoizedState,le.lanes=pe.lanes):(le.updateQueue=null,le.memoizedState=null)}var he=0!=(1&Ma.current),ge=se;do{var ve;if(ve=13===ge.tag){var we=ge.memoizedState;if(null!==we)ve=null!==we.dehydrated;else{var Se=ge.memoizedProps;ve=void 0!==Se.fallback&&(!0!==Se.unstable_avoidThisFallback||!he)}}if(ve){var Pe=ge.updateQueue;if(null===Pe){var je=new Set;je.add(de),ge.updateQueue=je}else Pe.add(de);if(0==(2&ge.mode)){if(ge.flags|=64,le.flags|=16384,le.flags&=-2981,1===le.tag)if(null===le.alternate)le.tag=17;else{var Ie=zg(-1,1);Ie.tag=2,Ag(le,Ie)}le.lanes|=1;break e}ue=void 0,le=W;var De=ie.pingCache;if(null===De?(De=ie.pingCache=new rs,ue=new Set,De.set(de,ue)):void 0===(ue=De.get(de))&&(ue=new Set,De.set(de,ue)),!ue.has(le)){ue.add(le);var $e=Yj.bind(null,ie,de,le);de.then($e,$e)}ge.flags|=4096,ge.lanes=W;break e}ge=ge.return}while(null!==ge);ue=Error((Ra(le.type)||"A React component")+" suspended while rendering, but no fallback UI was specified.\n\nAdd a <Suspense fallback=...> component higher in the tree to provide a loading indicator or placeholder to display.")}5!==ps&&(ps=2),ue=Mi(ue,le),ge=se;do{switch(ge.tag){case 3:ie=ue,ge.flags|=4096,W&=-W,ge.lanes|=W,Bg(ge,Pi(0,ie,W));break e;case 1:ie=ue;var Le=ge.type,Ke=ge.stateNode;if(0==(64&ge.flags)&&("function"==typeof Le.getDerivedStateFromError||null!==Ke&&"function"==typeof Ke.componentDidCatch&&(null===Es||!Es.has(Ke)))){ge.flags|=4096,W&=-W,ge.lanes|=W,Bg(ge,Si(ge,ie,W));break e}}ge=ge.return}while(null!==ge)}Zj(G)}catch($){W=$,us===G&&null!==G&&(us=G=G.return);continue}break}}function Pj(){var $=as.current;return as.current=Ti,null===$?Ti:$}function Tj($,W){var G=ss;ss|=16;var oe=Pj();for(ls===$&&cs===W||Qj($,W);;)try{ak();break}catch(W){Sj($,W)}if(qg(),ss=G,as.current=oe,null!==us)throw Error(y$1(261));return ls=null,cs=0,ps}function ak(){for(;null!==us;)bk(us)}function Rj(){for(;null!==us&&!Xo();)bk(us)}function bk($){var W=xs($.alternate,$,ds);$.memoizedProps=$.pendingProps,null===W?Zj($):us=W,is.current=null}function Zj($){var W=$;do{var G=W.alternate;if($=W.return,0==(2048&W.flags)){if(null!==(G=Gi(G,W,ds)))return void(us=G);if(24!==(G=W).tag&&23!==G.tag||null===G.memoizedState||0!=(1073741824&ds)||0==(4&G.mode)){for(var oe=0,ae=G.child;null!==ae;)oe|=ae.lanes|ae.childLanes,ae=ae.sibling;G.childLanes=oe}null!==$&&0==(2048&$.flags)&&(null===$.firstEffect&&($.firstEffect=W.firstEffect),null!==W.lastEffect&&(null!==$.lastEffect&&($.lastEffect.nextEffect=W.firstEffect),$.lastEffect=W.lastEffect),1<W.flags&&(null!==$.lastEffect?$.lastEffect.nextEffect=W:$.firstEffect=W,$.lastEffect=W))}else{if(null!==(G=Li(W)))return G.flags&=2047,void(us=G);null!==$&&($.firstEffect=$.lastEffect=null,$.flags|=2048)}if(null!==(W=W.sibling))return void(us=W);us=W=$}while(null!==W);0===ps&&(ps=5)}function Uj($){var W=eg();return gg(99,dk.bind(null,$,W)),null}function dk($,W){do{Oj()}while(null!==Cs);if(0!=(48&ss))throw Error(y$1(327));var G=$.finishedWork;if(null===G)return null;if($.finishedWork=null,$.finishedLanes=0,G===$.current)throw Error(y$1(177));$.callbackNode=null;var oe=G.lanes|G.childLanes,ae=oe,ie=$.pendingLanes&~ae;$.pendingLanes=ae,$.suspendedLanes=0,$.pingedLanes=0,$.expiredLanes&=ae,$.mutableReadLanes&=ae,$.entangledLanes&=ae,ae=$.entanglements;for(var se=$.eventTimes,le=$.expirationTimes;0<ie;){var ue=31-wn(ie),de=1<<ue;ae[ue]=0,se[ue]=-1,le[ue]=-1,ie&=~de}if(null!==Ds&&0==(24&oe)&&Ds.has($)&&Ds.delete($),$===ls&&(us=ls=null,cs=0),1<G.flags?null!==G.lastEffect?(G.lastEffect.nextEffect=G,oe=G.firstEffect):oe=G:oe=G.firstEffect,null!==oe){if(ae=ss,ss|=32,is.current=null,Co=Pn,Oe(se=Ne$1())){if("selectionStart"in se)le={start:se.selectionStart,end:se.selectionEnd};else e:if(le=(le=se.ownerDocument)&&le.defaultView||window,(de=le.getSelection&&le.getSelection())&&0!==de.rangeCount){le=de.anchorNode,ie=de.anchorOffset,ue=de.focusNode,de=de.focusOffset;try{le.nodeType,ue.nodeType}catch($){le=null;break e}var pe=0,he=-1,ge=-1,ve=0,we=0,Se=se,Pe=null;t:for(;;){for(var je;Se!==le||0!==ie&&3!==Se.nodeType||(he=pe+ie),Se!==ue||0!==de&&3!==Se.nodeType||(ge=pe+de),3===Se.nodeType&&(pe+=Se.nodeValue.length),null!==(je=Se.firstChild);)Pe=Se,Se=je;for(;;){if(Se===se)break t;if(Pe===le&&++ve===ie&&(he=pe),Pe===ue&&++we===de&&(ge=pe),null!==(je=Se.nextSibling))break;Pe=(Se=Pe).parentNode}Se=je}le=-1===he||-1===ge?null:{start:he,end:ge}}else le=null;le=le||{start:0,end:0}}else le=null;Oo={focusedElem:se,selectionRange:le},Pn=!1,Bs=null,Fs=!1,ks=oe;do{try{ek()}catch($){if(null===ks)throw Error(y$1(330));Wi(ks,$),ks=ks.nextEffect}}while(null!==ks);Bs=null,ks=oe;do{try{for(se=$;null!==ks;){var Ie=ks.flags;if(16&Ie&&pb(ks.stateNode,""),128&Ie){var De=ks.alternate;if(null!==De){var $e=De.ref;null!==$e&&("function"==typeof $e?$e(null):$e.current=null)}}switch(1038&Ie){case 2:fj(ks),ks.flags&=-3;break;case 6:fj(ks),ks.flags&=-3,ij(ks.alternate,ks);break;case 1024:ks.flags&=-1025;break;case 1028:ks.flags&=-1025,ij(ks.alternate,ks);break;case 4:ij(ks.alternate,ks);break;case 8:cj(se,le=ks);var Le=le.alternate;dj(le),null!==Le&&dj(Le)}ks=ks.nextEffect}}catch($){if(null===ks)throw Error(y$1(330));Wi(ks,$),ks=ks.nextEffect}}while(null!==ks);if($e=Oo,De=Ne$1(),Ie=$e.focusedElem,se=$e.selectionRange,De!==Ie&&Ie&&Ie.ownerDocument&&Me$1(Ie.ownerDocument.documentElement,Ie)){null!==se&&Oe(Ie)&&(De=se.start,void 0===($e=se.end)&&($e=De),"selectionStart"in Ie?(Ie.selectionStart=De,Ie.selectionEnd=Math.min($e,Ie.value.length)):($e=(De=Ie.ownerDocument||document)&&De.defaultView||window).getSelection&&($e=$e.getSelection(),le=Ie.textContent.length,Le=Math.min(se.start,le),se=void 0===se.end?Le:Math.min(se.end,le),!$e.extend&&Le>se&&(le=se,se=Le,Le=le),le=Le$1(Ie,Le),ie=Le$1(Ie,se),le&&ie&&(1!==$e.rangeCount||$e.anchorNode!==le.node||$e.anchorOffset!==le.offset||$e.focusNode!==ie.node||$e.focusOffset!==ie.offset)&&((De=De.createRange()).setStart(le.node,le.offset),$e.removeAllRanges(),Le>se?($e.addRange(De),$e.extend(ie.node,ie.offset)):(De.setEnd(ie.node,ie.offset),$e.addRange(De))))),De=[];for($e=Ie;$e=$e.parentNode;)1===$e.nodeType&&De.push({element:$e,left:$e.scrollLeft,top:$e.scrollTop});for("function"==typeof Ie.focus&&Ie.focus(),Ie=0;Ie<De.length;Ie++)($e=De[Ie]).element.scrollLeft=$e.left,$e.element.scrollTop=$e.top}Pn=!!Co,Oo=Co=null,$.current=G,ks=oe;do{try{for(Ie=$;null!==ks;){var Ke=ks.flags;if(36&Ke&&Yi(Ie,ks.alternate,ks),128&Ke){De=void 0;var Ge=ks.ref;if(null!==Ge){var Xe=ks.stateNode;ks.tag,De=Xe,"function"==typeof Ge?Ge(De):Ge.current=De}}ks=ks.nextEffect}}catch($){if(null===ks)throw Error(y$1(330));Wi(ks,$),ks=ks.nextEffect}}while(null!==ks);ks=null,sa(),ss=ae}else $.current=G;if(js)js=!1,Cs=$,Os=W;else for(ks=oe;null!==ks;)W=ks.nextEffect,ks.nextEffect=null,8&ks.flags&&((Ke=ks).sibling=null,Ke.stateNode=null),ks=W;if(0===(oe=$.pendingLanes)&&(Es=null),1===oe?$===$s?As++:(As=0,$s=$):As=0,G=G.stateNode,Uo&&"function"==typeof Uo.onCommitFiberRoot)try{Uo.onCommitFiberRoot(qo,G,void 0,64==(64&G.current.flags))}catch($){}if(Mj($,ga()),_s)throw _s=!1,$=Ps,Ps=null,$;return 0!=(8&ss)||ig(),null}function ek(){for(;null!==ks;){var $=ks.alternate;Fs||null===Bs||(0!=(8&ks.flags)?dc(ks,Bs)&&(Fs=!0):13===ks.tag&&mj($,ks)&&dc(ks,Bs)&&(Fs=!0));var W=ks.flags;0!=(256&W)&&Xi($,ks),0==(512&W)||js||(js=!0,hg(97,(function(){return Oj(),null}))),ks=ks.nextEffect}}function Oj(){if(90!==Os){var $=97<Os?97:Os;return Os=90,gg($,fk)}return!1}function $i($,W){Is.push(W,$),js||(js=!0,hg(97,(function(){return Oj(),null})))}function Zi($,W){Ts.push(W,$),js||(js=!0,hg(97,(function(){return Oj(),null})))}function fk(){if(null===Cs)return!1;var $=Cs;if(Cs=null,0!=(48&ss))throw Error(y$1(331));var W=ss;ss|=32;var G=Ts;Ts=[];for(var oe=0;oe<G.length;oe+=2){var ae=G[oe],ie=G[oe+1],se=ae.destroy;if(ae.destroy=void 0,"function"==typeof se)try{se()}catch($){if(null===ie)throw Error(y$1(330));Wi(ie,$)}}for(G=Is,Is=[],oe=0;oe<G.length;oe+=2){ae=G[oe],ie=G[oe+1];try{var le=ae.create;ae.destroy=le()}catch($){if(null===ie)throw Error(y$1(330));Wi(ie,$)}}for(le=$.current.firstEffect;null!==le;)$=le.nextEffect,le.nextEffect=null,8&le.flags&&(le.sibling=null,le.stateNode=null),le=$;return ss=W,ig(),!0}function gk($,W,G){Ag($,W=Pi(0,W=Mi(G,W),1)),W=Hg(),null!==($=Kj($,1))&&($c($,1,W),Mj($,W))}function Wi($,W){if(3===$.tag)gk($,$,W);else for(var G=$.return;null!==G;){if(3===G.tag){gk(G,$,W);break}if(1===G.tag){var oe=G.stateNode;if("function"==typeof G.type.getDerivedStateFromError||"function"==typeof oe.componentDidCatch&&(null===Es||!Es.has(oe))){var ae=Si(G,$=Mi(W,$),1);if(Ag(G,ae),ae=Hg(),null!==(G=Kj(G,1)))$c(G,1,ae),Mj(G,ae);else if("function"==typeof oe.componentDidCatch&&(null===Es||!Es.has(oe)))try{oe.componentDidCatch(W,$)}catch($){}break}}G=G.return}}function Yj($,W,G){var oe=$.pingCache;null!==oe&&oe.delete(W),W=Hg(),$.pingedLanes|=$.suspendedLanes&G,ls===$&&(cs&G)===G&&(4===ps||3===ps&&(62914560&cs)===cs&&500>ga()-ws?Qj($,0):ys|=G),Mj($,W)}function lj($,W){var G=$.stateNode;null!==G&&G.delete(W),0===(W=0)&&(0==(2&(W=$.mode))?W=1:0==(4&W)?W=99===eg()?1:2:(0===Ms&&(Ms=ms),0===(W=Yc(62914560&~Ms))&&(W=4194304))),G=Hg(),null!==($=Kj($,W))&&($c($,W,G),Mj($,G))}function ik($,W,G,oe){this.tag=$,this.key=G,this.sibling=this.child=this.return=this.stateNode=this.type=this.elementType=null,this.index=0,this.ref=null,this.pendingProps=W,this.dependencies=this.memoizedState=this.updateQueue=this.memoizedProps=null,this.mode=oe,this.flags=0,this.lastEffect=this.firstEffect=this.nextEffect=null,this.childLanes=this.lanes=0,this.alternate=null}function nh($,W,G,oe){return new ik($,W,G,oe)}function ji($){return!(!($=$.prototype)||!$.isReactComponent)}function Tg($,W){var G=$.alternate;return null===G?((G=nh($.tag,W,$.key,$.mode)).elementType=$.elementType,G.type=$.type,G.stateNode=$.stateNode,G.alternate=$,$.alternate=G):(G.pendingProps=W,G.type=$.type,G.flags=0,G.nextEffect=null,G.firstEffect=null,G.lastEffect=null),G.childLanes=$.childLanes,G.lanes=$.lanes,G.child=$.child,G.memoizedProps=$.memoizedProps,G.memoizedState=$.memoizedState,G.updateQueue=$.updateQueue,W=$.dependencies,G.dependencies=null===W?null:{lanes:W.lanes,firstContext:W.firstContext},G.sibling=$.sibling,G.index=$.index,G.ref=$.ref,G}function Vg($,W,G,oe,ae,ie){var se=2;if(oe=$,"function"==typeof $)ji($)&&(se=1);else if("string"==typeof $)se=5;else e:switch($){case lr:return Xg(G.children,ae,ie,W);case wr:se=8,ae|=16;break;case ur:se=8,ae|=1;break;case cr:return($=nh(12,G,W,8|ae)).elementType=cr,$.type=cr,$.lanes=ie,$;case hr:return($=nh(13,G,W,ae)).type=hr,$.elementType=hr,$.lanes=ie,$;case mr:return($=nh(19,G,W,ae)).elementType=mr,$.lanes=ie,$;case Sr:return vi(G,ae,ie,W);case xr:return($=nh(24,G,W,ae)).elementType=xr,$.lanes=ie,$;default:if("object"==typeof $&&null!==$)switch($.$$typeof){case dr:se=10;break e;case fr:se=9;break e;case pr:se=11;break e;case gr:se=14;break e;case vr:se=16,oe=null;break e;case yr:se=22;break e}throw Error(y$1(130,null==$?$:typeof $,""))}return(W=nh(se,G,W,ae)).elementType=$,W.type=oe,W.lanes=ie,W}function Xg($,W,G,oe){return($=nh(7,$,oe,W)).lanes=G,$}function vi($,W,G,oe){return($=nh(23,$,oe,W)).elementType=Sr,$.lanes=G,$}function Ug($,W,G){return($=nh(6,$,null,W)).lanes=G,$}function Wg($,W,G){return(W=nh(4,null!==$.children?$.children:[],$.key,W)).lanes=G,W.stateNode={containerInfo:$.containerInfo,pendingChildren:null,implementation:$.implementation},W}function jk($,W,G){this.tag=W,this.containerInfo=$,this.finishedWork=this.pingCache=this.current=this.pendingChildren=null,this.timeoutHandle=-1,this.pendingContext=this.context=null,this.hydrate=G,this.callbackNode=null,this.callbackPriority=0,this.eventTimes=Zc(0),this.expirationTimes=Zc(-1),this.entangledLanes=this.finishedLanes=this.mutableReadLanes=this.expiredLanes=this.pingedLanes=this.suspendedLanes=this.pendingLanes=0,this.entanglements=Zc(0),this.mutableSourceEagerHydrationData=null}function kk($,W,G){var oe=3<arguments.length&&void 0!==arguments[3]?arguments[3]:null;return{$$typeof:sr,key:null==oe?null:""+oe,children:$,containerInfo:W,implementation:G}}function lk($,W,G,oe){var ae=W.current,ie=Hg(),se=Ig(ae);e:if(G){t:{if(Zb(G=G._reactInternals)!==G||1!==G.tag)throw Error(y$1(170));var le=G;do{switch(le.tag){case 3:le=le.stateNode.context;break t;case 1:if(Ff(le.type)){le=le.stateNode.__reactInternalMemoizedMergedChildContext;break t}}le=le.return}while(null!==le);throw Error(y$1(171))}if(1===G.tag){var ue=G.type;if(Ff(ue)){G=If(G,ue,le);break e}}G=le}else G=No;return null===W.context?W.context=G:W.pendingContext=G,(W=zg(ie,se)).payload={element:$},null!==(oe=void 0===oe?null:oe)&&(W.callback=oe),Ag(ae,W),Jg(ae,se,ie),se}function mk($){return($=$.current).child?($.child.tag,$.child.stateNode):null}function nk($,W){if(null!==($=$.memoizedState)&&null!==$.dehydrated){var G=$.retryLane;$.retryLane=0!==G&&G<W?G:W}}function ok($,W){nk($,W),($=$.alternate)&&nk($,W)}function qk($,W,G){var oe=null!=G&&null!=G.hydrationOptions&&G.hydrationOptions.mutableSources||null;if(G=new jk($,W,null!=G&&!0===G.hydrate),W=nh(3,null,null,2===W?7:1===W?3:0),G.current=W,W.stateNode=G,xg(W),$[Mo]=G.current,cf(8===$.nodeType?$.parentNode:$),oe)for($=0;$<oe.length;$++){var ae=(W=oe[$])._getVersion;ae=ae(W._source),null==G.mutableSourceEagerHydrationData?G.mutableSourceEagerHydrationData=[W,ae]:G.mutableSourceEagerHydrationData.push(W,ae)}this._internalRoot=G}function rk($){return!(!$||1!==$.nodeType&&9!==$.nodeType&&11!==$.nodeType&&(8!==$.nodeType||" react-mount-point-unstable "!==$.nodeValue))}function tk($,W,G,oe,ae){var ie=G._reactRootContainer;if(ie){var se=ie._internalRoot;if("function"==typeof ae){var le=ae;ae=function(){var $=mk(se);le.call($)}}lk(W,se,$,ae)}else{if(ie=G._reactRootContainer=function sk($,W){if(W||(W=!(!(W=$?9===$.nodeType?$.documentElement:$.firstChild:null)||1!==W.nodeType||!W.hasAttribute("data-reactroot"))),!W)for(var G;G=$.lastChild;)$.removeChild(G);return new qk($,0,W?{hydrate:!0}:void 0)}(G,oe),se=ie._internalRoot,"function"==typeof ae){var ue=ae;ae=function(){var $=mk(se);ue.call($)}}Xj((function(){lk(W,se,$,ae)}))}return mk(se)}function uk($,W){var G=2<arguments.length&&void 0!==arguments[2]?arguments[2]:null;if(!rk(W))throw Error(y$1(200));return kk($,W,null,G)}xs=function($,W,G){var oe=W.lanes;if(null!==$)if($.memoizedProps!==W.pendingProps||Ho.current)Ui=!0;else{if(0==(G&oe)){switch(Ui=!1,W.tag){case 3:ri(W),sh();break;case 5:gh(W);break;case 1:Ff(W.type)&&Jf(W);break;case 4:eh(W,W.stateNode.containerInfo);break;case 10:oe=W.memoizedProps.value;var ae=W.type._context;I$1(ya,ae._currentValue),ae._currentValue=oe;break;case 13:if(null!==W.memoizedState)return 0!=(G&W.child.childLanes)?ti($,W,G):(I$1(Ma,1&Ma.current),null!==(W=hi($,W,G))?W.sibling:null);I$1(Ma,1&Ma.current);break;case 19:if(oe=0!=(G&W.childLanes),0!=(64&$.flags)){if(oe)return Ai($,W,G);W.flags|=64}if(null!==(ae=W.memoizedState)&&(ae.rendering=null,ae.tail=null,ae.lastEffect=null),I$1(Ma,Ma.current),oe)break;return null;case 23:case 24:return W.lanes=0,mi($,W,G)}return hi($,W,G)}Ui=0!=(16384&$.flags)}else Ui=!1;switch(W.lanes=0,W.tag){case 2:if(oe=W.type,null!==$&&($.alternate=null,W.alternate=null,W.flags|=2),$=W.pendingProps,ae=Ef(W,Lo.current),tg(W,G),ae=Ch(null,W,oe,$,ae,G),W.flags|=1,"object"==typeof ae&&null!==ae&&"function"==typeof ae.render&&void 0===ae.$$typeof){if(W.tag=1,W.memoizedState=null,W.updateQueue=null,Ff(oe)){var ie=!0;Jf(W)}else ie=!1;W.memoizedState=null!==ae.state&&void 0!==ae.state?ae.state:null,xg(W);var se=oe.getDerivedStateFromProps;"function"==typeof se&&Gg(W,oe,se,$),ae.updater=Ea,W.stateNode=ae,ae._reactInternals=W,Og(W,oe,$,G),W=qi(null,W,oe,!0,ie,G)}else W.tag=0,fi(null,W,ae,G),W=W.child;return W;case 16:ae=W.elementType;e:{switch(null!==$&&($.alternate=null,W.alternate=null,W.flags|=2),$=W.pendingProps,ae=(ie=ae._init)(ae._payload),W.type=ae,ie=W.tag=function hk($){if("function"==typeof $)return ji($)?1:0;if(null!=$){if(($=$.$$typeof)===pr)return 11;if($===gr)return 14}return 2}(ae),$=lg(ae,$),ie){case 0:W=li(null,W,ae,$,G);break e;case 1:W=pi(null,W,ae,$,G);break e;case 11:W=gi(null,W,ae,$,G);break e;case 14:W=ii(null,W,ae,lg(ae.type,$),oe,G);break e}throw Error(y$1(306,ae,""))}return W;case 0:return oe=W.type,ae=W.pendingProps,li($,W,oe,ae=W.elementType===oe?ae:lg(oe,ae),G);case 1:return oe=W.type,ae=W.pendingProps,pi($,W,oe,ae=W.elementType===oe?ae:lg(oe,ae),G);case 3:if(ri(W),oe=W.updateQueue,null===$||null===oe)throw Error(y$1(282));if(oe=W.pendingProps,ae=null!==(ae=W.memoizedState)?ae.element:null,yg($,W),Cg(W,oe,null,G),(oe=W.memoizedState.element)===ae)sh(),W=hi($,W,G);else{if((ie=(ae=W.stateNode).hydrate)&&(Fa=rf(W.stateNode.containerInfo.firstChild),Ba=W,ie=Ha=!0),ie){if(null!=($=ae.mutableSourceEagerHydrationData))for(ae=0;ae<$.length;ae+=2)(ie=$[ae])._workInProgressVersionPrimary=$[ae+1],Ka.push(ie);for(G=Oa(W,null,oe,G),W.child=G;G;)G.flags=-3&G.flags|1024,G=G.sibling}else fi($,W,oe,G),sh();W=W.child}return W;case 5:return gh(W),null===$&&ph(W),oe=W.type,ae=W.pendingProps,ie=null!==$?$.memoizedProps:null,se=ae.children,nf(oe,ae)?se=null:null!==ie&&nf(oe,ie)&&(W.flags|=16),oi($,W),fi($,W,se,G),W.child;case 6:return null===$&&ph(W),null;case 13:return ti($,W,G);case 4:return eh(W,W.stateNode.containerInfo),oe=W.pendingProps,null===$?W.child=Ca(W,null,oe,G):fi($,W,oe,G),W.child;case 11:return oe=W.type,ae=W.pendingProps,gi($,W,oe,ae=W.elementType===oe?ae:lg(oe,ae),G);case 7:return fi($,W,W.pendingProps,G),W.child;case 8:case 12:return fi($,W,W.pendingProps.children,G),W.child;case 10:e:{oe=W.type._context,ae=W.pendingProps,se=W.memoizedProps,ie=ae.value;var le=W.type._context;if(I$1(ya,le._currentValue),le._currentValue=ie,null!==se)if(le=se.value,0===(ie=go(le,ie)?0:0|("function"==typeof oe._calculateChangedBits?oe._calculateChangedBits(le,ie):1073741823))){if(se.children===ae.children&&!Ho.current){W=hi($,W,G);break e}}else for(null!==(le=W.child)&&(le.return=W);null!==le;){var ue=le.dependencies;if(null!==ue){se=le.child;for(var de=ue.firstContext;null!==de;){if(de.context===oe&&0!=(de.observedBits&ie)){1===le.tag&&((de=zg(-1,G&-G)).tag=2,Ag(le,de)),le.lanes|=G,null!==(de=le.alternate)&&(de.lanes|=G),sg(le.return,G),ue.lanes|=G;break}de=de.next}}else se=10===le.tag&&le.type===W.type?null:le.child;if(null!==se)se.return=le;else for(se=le;null!==se;){if(se===W){se=null;break}if(null!==(le=se.sibling)){le.return=se.return,se=le;break}se=se.return}le=se}fi($,W,ae.children,G),W=W.child}return W;case 9:return ae=W.type,oe=(ie=W.pendingProps).children,tg(W,G),oe=oe(ae=vg(ae,ie.unstable_observedBits)),W.flags|=1,fi($,W,oe,G),W.child;case 14:return ie=lg(ae=W.type,W.pendingProps),ii($,W,ae,ie=lg(ae.type,ie),oe,G);case 15:return ki($,W,W.type,W.pendingProps,oe,G);case 17:return oe=W.type,ae=W.pendingProps,ae=W.elementType===oe?ae:lg(oe,ae),null!==$&&($.alternate=null,W.alternate=null,W.flags|=2),W.tag=1,Ff(oe)?($=!0,Jf(W)):$=!1,tg(W,G),Mg(W,oe,ae),Og(W,oe,ae,G),qi(null,W,oe,!0,$,G);case 19:return Ai($,W,G);case 23:case 24:return mi($,W,G)}throw Error(y$1(156,W.tag))},qk.prototype.render=function($){lk($,this._internalRoot,null,null)},qk.prototype.unmount=function(){var $=this._internalRoot,W=$.containerInfo;lk(null,$,null,(function(){W[Mo]=null}))},Gr=function($){13===$.tag&&(Jg($,4,Hg()),ok($,4))},Xr=function($){13===$.tag&&(Jg($,67108864,Hg()),ok($,67108864))},Yr=function($){if(13===$.tag){var W=Hg(),G=Ig($);Jg($,G,W),ok($,G)}},Jr=function($,W){return W()},zr=function($,W,G){switch(W){case"input":if(ab($,G),W=G.name,"radio"===G.type&&null!=W){for(G=$;G.parentNode;)G=G.parentNode;for(G=G.querySelectorAll("input[name="+JSON.stringify(""+W)+'][type="radio"]'),W=0;W<G.length;W++){var oe=G[W];if(oe!==$&&oe.form===$.form){var ae=Db(oe);if(!ae)throw Error(y$1(90));Wa(oe),ab(oe,ae)}}}break;case"textarea":ib($,G);break;case"select":null!=(W=G.value)&&fb($,!!G.multiple,W,!1)}},Gb=Wj,Hb=function($,W,G,oe,ae){var ie=ss;ss|=4;try{return gg(98,$.bind(null,W,G,oe,ae))}finally{0===(ss=ie)&&(wj(),ig())}},Ib=function(){0==(49&ss)&&(function Vj(){if(null!==Ds){var $=Ds;Ds=null,$.forEach((function($){$.expiredLanes|=24&$.pendingLanes,Mj($,ga())}))}ig()}(),Oj())},Br=function($,W){var G=ss;ss|=2;try{return $(W)}finally{0===(ss=G)&&(wj(),ig())}};var Ns={Events:[Cb,ue$1,Db,Eb,Fb,Oj,{current:!1}]},Ls={findFiberByHostInstance:wc,bundleType:0,version:"17.0.2",rendererPackageName:"react-dom"},Hs={bundleType:Ls.bundleType,version:Ls.version,rendererPackageName:Ls.rendererPackageName,rendererConfig:Ls.rendererConfig,overrideHookState:null,overrideHookStateDeletePath:null,overrideHookStateRenamePath:null,overrideProps:null,overridePropsDeletePath:null,overridePropsRenamePath:null,setSuspenseHandler:null,scheduleUpdate:null,currentDispatcherRef:ar.ReactCurrentDispatcher,findHostInstanceByFiber:function($){return null===($=cc($))?null:$.stateNode},findFiberByHostInstance:Ls.findFiberByHostInstance||function pk(){return null},findHostInstancesForRefresh:null,scheduleRefresh:null,scheduleRoot:null,setRefreshHandler:null,getCurrentFiber:null};if("undefined"!=typeof __REACT_DEVTOOLS_GLOBAL_HOOK__){var Vs=__REACT_DEVTOOLS_GLOBAL_HOOK__;if(!Vs.isDisabled&&Vs.supportsFiber)try{qo=Vs.inject(Hs),Uo=Vs}catch(Ir){}}qt.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED=Ns,qt.createPortal=uk,qt.findDOMNode=function($){if(null==$)return null;if(1===$.nodeType)return $;var W=$._reactInternals;if(void 0===W){if("function"==typeof $.render)throw Error(y$1(188));throw Error(y$1(268,Object.keys($)))}return $=null===($=cc(W))?null:$.stateNode},qt.flushSync=function($,W){var G=ss;if(0!=(48&G))return $(W);ss|=1;try{if($)return gg(99,$.bind(null,W))}finally{ss=G,ig()}},qt.hydrate=function($,W,G){if(!rk(W))throw Error(y$1(200));return tk(null,$,W,!0,G)},qt.render=function($,W,G){if(!rk(W))throw Error(y$1(200));return tk(null,$,W,!1,G)},qt.unmountComponentAtNode=function($){if(!rk($))throw Error(y$1(40));return!!$._reactRootContainer&&(Xj((function(){tk(null,null,$,!1,(function(){$._reactRootContainer=null,$[Mo]=null}))})),!0)},qt.unstable_batchedUpdates=Wj,qt.unstable_createPortal=function($,W){return uk($,W,2<arguments.length&&void 0!==arguments[2]?arguments[2]:null)},qt.unstable_renderSubtreeIntoContainer=function($,W,G,oe){if(!rk(G))throw Error(y$1(200));if(null==$||void 0===$._reactInternals)throw Error(y$1(38));return tk($,W,G,!1,oe)},qt.version="17.0.2";var qs={},Us=0;
/** @license React v0.20.2
	 * scheduler-tracing.production.min.js
	 *
	 * Copyright (c) Facebook, Inc. and its affiliates.
	 *
	 * This source code is licensed under the MIT license found in the
	 * LICENSE file in the root directory of this source tree.
	 */qs.__interactionsRef=null,qs.__subscriberRef=null,qs.unstable_clear=function($){return $()},qs.unstable_getCurrent=function(){return null},qs.unstable_getThreadID=function(){return++Us},qs.unstable_subscribe=function(){},qs.unstable_trace=function($,W,G){return G()},qs.unstable_unsubscribe=function(){},qs.unstable_wrap=function($){return $},function checkDCE(){if("undefined"!=typeof __REACT_DEVTOOLS_GLOBAL_HOOK__&&"function"==typeof __REACT_DEVTOOLS_GLOBAL_HOOK__.checkDCE)try{__REACT_DEVTOOLS_GLOBAL_HOOK__.checkDCE(checkDCE)}catch($){console.error($)}}(),Vt.exports=qt;var Ks={exports:{}},Ws={},Gs="function"==typeof Symbol&&Symbol.for,Xs=Gs?Symbol.for("react.element"):60103,Ys=Gs?Symbol.for("react.portal"):60106,Js=Gs?Symbol.for("react.fragment"):60107,Qs=Gs?Symbol.for("react.strict_mode"):60108,Zs=Gs?Symbol.for("react.profiler"):60114,el=Gs?Symbol.for("react.provider"):60109,tl=Gs?Symbol.for("react.context"):60110,rl=Gs?Symbol.for("react.async_mode"):60111,nl=Gs?Symbol.for("react.concurrent_mode"):60111,ol=Gs?Symbol.for("react.forward_ref"):60112,al=Gs?Symbol.for("react.suspense"):60113,il=Gs?Symbol.for("react.suspense_list"):60120,sl=Gs?Symbol.for("react.memo"):60115,ll=Gs?Symbol.for("react.lazy"):60116,ul=Gs?Symbol.for("react.block"):60121,cl=Gs?Symbol.for("react.fundamental"):60117,dl=Gs?Symbol.for("react.responder"):60118,fl=Gs?Symbol.for("react.scope"):60119;function z$1($){if("object"==typeof $&&null!==$){var W=$.$$typeof;switch(W){case Xs:switch($=$.type){case rl:case nl:case Js:case Zs:case Qs:case al:return $;default:switch($=$&&$.$$typeof){case tl:case ol:case ll:case sl:case el:return $;default:return W}}case Ys:return W}}}function A$1($){return z$1($)===nl}Ws.AsyncMode=rl,Ws.ConcurrentMode=nl,Ws.ContextConsumer=tl,Ws.ContextProvider=el,Ws.Element=Xs,Ws.ForwardRef=ol,Ws.Fragment=Js,Ws.Lazy=ll,Ws.Memo=sl,Ws.Portal=Ys,Ws.Profiler=Zs,Ws.StrictMode=Qs,Ws.Suspense=al,Ws.isAsyncMode=function($){return A$1($)||z$1($)===rl},Ws.isConcurrentMode=A$1,Ws.isContextConsumer=function($){return z$1($)===tl},Ws.isContextProvider=function($){return z$1($)===el},Ws.isElement=function($){return"object"==typeof $&&null!==$&&$.$$typeof===Xs},Ws.isForwardRef=function($){return z$1($)===ol},Ws.isFragment=function($){return z$1($)===Js},Ws.isLazy=function($){return z$1($)===ll},Ws.isMemo=function($){return z$1($)===sl},Ws.isPortal=function($){return z$1($)===Ys},Ws.isProfiler=function($){return z$1($)===Zs},Ws.isStrictMode=function($){return z$1($)===Qs},Ws.isSuspense=function($){return z$1($)===al},Ws.isValidElementType=function($){return"string"==typeof $||"function"==typeof $||$===Js||$===nl||$===Zs||$===Qs||$===al||$===il||"object"==typeof $&&null!==$&&($.$$typeof===ll||$.$$typeof===sl||$.$$typeof===el||$.$$typeof===tl||$.$$typeof===ol||$.$$typeof===cl||$.$$typeof===dl||$.$$typeof===fl||$.$$typeof===ul)},Ws.typeOf=z$1,Ks.exports=Ws;function stylis_min($){function M($,oe,ae,ie,se){for(var le,he,ve,we,Se,Pe=0,je=0,Ge=0,Ye=0,Qe=0,Ze=0,et=ve=le=0,tt=0,rt=0,nt=0,ot=0,at=ae.length,it=at-1,st="",lt="",ut="",ct="";tt<at;){if(he=ae.charCodeAt(tt),tt===it&&0!==je+Ye+Ge+Pe&&(0!==je&&(he=47===je?10:47),Ye=Ge=Pe=0,at++,it++),0===je+Ye+Ge+Pe){if(tt===it&&(0<rt&&(st=st.replace(G,"")),0<st.trim().length)){switch(he){case 32:case 9:case 59:case 13:case 10:break;default:st+=ae.charAt(tt)}he=59}switch(he){case 123:for(le=(st=st.trim()).charCodeAt(0),ve=1,ot=++tt;tt<at;){switch(he=ae.charCodeAt(tt)){case 123:ve++;break;case 125:ve--;break;case 47:switch(he=ae.charCodeAt(tt+1)){case 42:case 47:e:{for(et=tt+1;et<it;++et)switch(ae.charCodeAt(et)){case 47:if(42===he&&42===ae.charCodeAt(et-1)&&tt+2!==et){tt=et+1;break e}break;case 10:if(47===he){tt=et+1;break e}}tt=et}}break;case 91:he++;case 40:he++;case 34:case 39:for(;tt++<it&&ae.charCodeAt(tt)!==he;);}if(0===ve)break;tt++}if(ve=ae.substring(ot,tt),0===le&&(le=(st=st.replace(W,"").trim()).charCodeAt(0)),64===le){switch(0<rt&&(st=st.replace(G,"")),he=st.charCodeAt(1)){case 100:case 109:case 115:case 45:rt=oe;break;default:rt=Ke}if(ot=(ve=M(oe,rt,ve,he,se+1)).length,0<Xe&&(Se=H(3,ve,rt=X(Ke,st,nt),oe,De,Ie,ot,he,se,ie),st=rt.join(""),void 0!==Se&&0===(ot=(ve=Se.trim()).length)&&(he=0,ve="")),0<ot)switch(he){case 115:st=st.replace(ge,ea);case 100:case 109:case 45:ve=st+"{"+ve+"}";break;case 107:ve=(st=st.replace(ue,"$1 $2"))+"{"+ve+"}",ve=1===Le||2===Le&&L("@"+ve,3)?"@-webkit-"+ve+"@"+ve:"@"+ve;break;default:ve=st+ve,112===ie&&(lt+=ve,ve="")}else ve=""}else ve=M(oe,X(oe,st,nt),ve,ie,se+1);ut+=ve,ve=nt=rt=et=le=0,st="",he=ae.charCodeAt(++tt);break;case 125:case 59:if(1<(ot=(st=(0<rt?st.replace(G,""):st).trim()).length))switch(0===et&&(le=st.charCodeAt(0),45===le||96<le&&123>le)&&(ot=(st=st.replace(" ",":")).length),0<Xe&&void 0!==(Se=H(1,st,oe,$,De,Ie,lt.length,ie,se,ie))&&0===(ot=(st=Se.trim()).length)&&(st="\0\0"),le=st.charCodeAt(0),he=st.charCodeAt(1),le){case 0:break;case 64:if(105===he||99===he){ct+=st+ae.charAt(tt);break}default:58!==st.charCodeAt(ot-1)&&(lt+=P(st,le,he,st.charCodeAt(2)))}nt=rt=et=le=0,st="",he=ae.charCodeAt(++tt)}}switch(he){case 13:case 10:47===je?je=0:0===1+le&&107!==ie&&0<st.length&&(rt=1,st+="\0"),0<Xe*Je&&H(0,st,oe,$,De,Ie,lt.length,ie,se,ie),Ie=1,De++;break;case 59:case 125:if(0===je+Ye+Ge+Pe){Ie++;break}default:switch(Ie++,we=ae.charAt(tt),he){case 9:case 32:if(0===Ye+Pe+je)switch(Qe){case 44:case 58:case 9:case 32:we="";break;default:32!==he&&(we=" ")}break;case 0:we="\\0";break;case 12:we="\\f";break;case 11:we="\\v";break;case 38:0===Ye+je+Pe&&(rt=nt=1,we="\f"+we);break;case 108:if(0===Ye+je+Pe+$e&&0<et)switch(tt-et){case 2:112===Qe&&58===ae.charCodeAt(tt-3)&&($e=Qe);case 8:111===Ze&&($e=Ze)}break;case 58:0===Ye+je+Pe&&(et=tt);break;case 44:0===je+Ge+Ye+Pe&&(rt=1,we+="\r");break;case 34:case 39:0===je&&(Ye=Ye===he?0:0===Ye?he:Ye);break;case 91:0===Ye+je+Ge&&Pe++;break;case 93:0===Ye+je+Ge&&Pe--;break;case 41:0===Ye+je+Pe&&Ge--;break;case 40:if(0===Ye+je+Pe){if(0===le)if(2*Qe+3*Ze==533);else le=1;Ge++}break;case 64:0===je+Ge+Ye+Pe+et+ve&&(ve=1);break;case 42:case 47:if(!(0<Ye+Pe+Ge))switch(je){case 0:switch(2*he+3*ae.charCodeAt(tt+1)){case 235:je=47;break;case 220:ot=tt,je=42}break;case 42:47===he&&42===Qe&&ot+2!==tt&&(33===ae.charCodeAt(ot+2)&&(lt+=ae.substring(ot,tt+1)),we="",je=0)}}0===je&&(st+=we)}Ze=Qe,Qe=he,tt++}if(0<(ot=lt.length)){if(rt=oe,0<Xe&&(void 0!==(Se=H(2,lt,rt,$,De,Ie,ot,ie,se,ie))&&0===(lt=Se).length))return ct+lt+ut;if(lt=rt.join(",")+"{"+lt+"}",0!=Le*$e){switch(2!==Le||L(lt,2)||($e=0),$e){case 111:lt=lt.replace(pe,":-moz-$1")+lt;break;case 112:lt=lt.replace(de,"::-webkit-input-$1")+lt.replace(de,"::-moz-$1")+lt.replace(de,":-ms-input-$1")+lt}$e=0}}return ct+lt+ut}function X($,W,G){var oe=W.trim().split(se);W=oe;var ae=oe.length,ie=$.length;switch(ie){case 0:case 1:var le=0;for($=0===ie?"":$[0]+" ";le<ae;++le)W[le]=Z($,W[le],G).trim();break;default:var ue=le=0;for(W=[];le<ae;++le)for(var de=0;de<ie;++de)W[ue++]=Z($[de]+" ",oe[le],G).trim()}return W}function Z($,W,G){var oe=W.charCodeAt(0);switch(33>oe&&(oe=(W=W.trim()).charCodeAt(0)),oe){case 38:return W.replace(le,"$1"+$.trim());case 58:return $.trim()+W.replace(le,"$1"+$.trim());default:if(0<1*G&&0<W.indexOf("\f"))return W.replace(le,(58===$.charCodeAt(0)?"":"$1")+$.trim())}return $+W}function P($,W,G,se){var le=$+";",ue=2*W+3*G+4*se;if(944===ue){$=le.indexOf(":",9)+1;var de=le.substring($,le.length-1).trim();return de=le.substring(0,$).trim()+de+";",1===Le||2===Le&&L(de,1)?"-webkit-"+de+de:de}if(0===Le||2===Le&&!L(le,1))return le;switch(ue){case 1015:return 97===le.charCodeAt(10)?"-webkit-"+le+le:le;case 951:return 116===le.charCodeAt(3)?"-webkit-"+le+le:le;case 963:return 110===le.charCodeAt(5)?"-webkit-"+le+le:le;case 1009:if(100!==le.charCodeAt(4))break;case 969:case 942:return"-webkit-"+le+le;case 978:return"-webkit-"+le+"-moz-"+le+le;case 1019:case 983:return"-webkit-"+le+"-moz-"+le+"-ms-"+le+le;case 883:if(45===le.charCodeAt(8))return"-webkit-"+le+le;if(0<le.indexOf("image-set(",11))return le.replace(je,"$1-webkit-$2")+le;break;case 932:if(45===le.charCodeAt(4))switch(le.charCodeAt(5)){case 103:return"-webkit-box-"+le.replace("-grow","")+"-webkit-"+le+"-ms-"+le.replace("grow","positive")+le;case 115:return"-webkit-"+le+"-ms-"+le.replace("shrink","negative")+le;case 98:return"-webkit-"+le+"-ms-"+le.replace("basis","preferred-size")+le}return"-webkit-"+le+"-ms-"+le+le;case 964:return"-webkit-"+le+"-ms-flex-"+le+le;case 1023:if(99!==le.charCodeAt(8))break;return"-webkit-box-pack"+(de=le.substring(le.indexOf(":",15)).replace("flex-","").replace("space-between","justify"))+"-webkit-"+le+"-ms-flex-pack"+de+le;case 1005:return ae.test(le)?le.replace(oe,":-webkit-")+le.replace(oe,":-moz-")+le:le;case 1e3:switch(W=(de=le.substring(13).trim()).indexOf("-")+1,de.charCodeAt(0)+de.charCodeAt(W)){case 226:de=le.replace(he,"tb");break;case 232:de=le.replace(he,"tb-rl");break;case 220:de=le.replace(he,"lr");break;default:return le}return"-webkit-"+le+"-ms-"+de+le;case 1017:if(-1===le.indexOf("sticky",9))break;case 975:switch(W=(le=$).length-10,ue=(de=(33===le.charCodeAt(W)?le.substring(0,W):le).substring($.indexOf(":",7)+1).trim()).charCodeAt(0)+(0|de.charCodeAt(7))){case 203:if(111>de.charCodeAt(8))break;case 115:le=le.replace(de,"-webkit-"+de)+";"+le;break;case 207:case 102:le=le.replace(de,"-webkit-"+(102<ue?"inline-":"")+"box")+";"+le.replace(de,"-webkit-"+de)+";"+le.replace(de,"-ms-"+de+"box")+";"+le}return le+";";case 938:if(45===le.charCodeAt(5))switch(le.charCodeAt(6)){case 105:return de=le.replace("-items",""),"-webkit-"+le+"-webkit-box-"+de+"-ms-flex-"+de+le;case 115:return"-webkit-"+le+"-ms-flex-item-"+le.replace(we,"")+le;default:return"-webkit-"+le+"-ms-flex-line-pack"+le.replace("align-content","").replace(we,"")+le}break;case 973:case 989:if(45!==le.charCodeAt(3)||122===le.charCodeAt(4))break;case 931:case 953:if(!0===Pe.test($))return 115===(de=$.substring($.indexOf(":")+1)).charCodeAt(0)?P($.replace("stretch","fill-available"),W,G,se).replace(":fill-available",":stretch"):le.replace(de,"-webkit-"+de)+le.replace(de,"-moz-"+de.replace("fill-",""))+le;break;case 962:if(le="-webkit-"+le+(102===le.charCodeAt(5)?"-ms-"+le:"")+le,211===G+se&&105===le.charCodeAt(13)&&0<le.indexOf("transform",10))return le.substring(0,le.indexOf(";",27)+1).replace(ie,"$1-webkit-$2")+le}return le}function L($,W){var G=$.indexOf(1===W?":":"{"),oe=$.substring(0,3!==W?G:10);return G=$.substring(G+1,$.length-1),Ye(2!==W?oe:oe.replace(Se,"$1"),G,W)}function ea($,W){var G=P(W,W.charCodeAt(0),W.charCodeAt(1),W.charCodeAt(2));return G!==W+";"?G.replace(ve," or ($1)").substring(4):"("+W+")"}function H($,W,G,oe,ae,ie,se,le,ue,de){for(var pe,he=0,ge=W;he<Xe;++he)switch(pe=Ge[he].call(B,$,ge,G,oe,ae,ie,se,le,ue,de)){case void 0:case!1:case!0:case null:break;default:ge=pe}if(ge!==W)return ge}function U($){return void 0!==($=$.prefix)&&(Ye=null,$?"function"!=typeof $?Le=1:(Le=2,Ye=$):Le=0),U}function B($,W){var G=$;if(33>G.charCodeAt(0)&&(G=G.trim()),G=[G],0<Xe){var oe=H(-1,W,G,G,De,Ie,0,0,0,0);void 0!==oe&&"string"==typeof oe&&(W=oe)}var ae=M(Ke,G,W,0,0);return 0<Xe&&(void 0!==(oe=H(-2,ae,G,G,De,Ie,ae.length,0,0,0))&&(ae=oe)),"",$e=0,Ie=De=1,ae}var W=/^\0+/g,G=/[\0\r\f]/g,oe=/: */g,ae=/zoo|gra/,ie=/([,: ])(transform)/g,se=/,\r+?/g,le=/([\t\r\n ])*\f?&/g,ue=/@(k\w+)\s*(\S*)\s*/,de=/::(place)/g,pe=/:(read-only)/g,he=/[svh]\w+-[tblr]{2}/,ge=/\(\s*(.*)\s*\)/g,ve=/([\s\S]*?);/g,we=/-self|flex-/g,Se=/[^]*?(:[rp][el]a[\w-]+)[^]*/,Pe=/stretch|:\s*\w+\-(?:conte|avail)/,je=/([^-])(image-set\()/,Ie=1,De=1,$e=0,Le=1,Ke=[],Ge=[],Xe=0,Ye=null,Je=0;return B.use=function T($){switch($){case void 0:case null:Xe=Ge.length=0;break;default:if("function"==typeof $)Ge[Xe++]=$;else if("object"==typeof $)for(var W=0,G=$.length;W<G;++W)T($[W]);else Je=0|!!$}return T},B.set=U,void 0!==$&&U($),B}var pl={animationIterationCount:1,borderImageOutset:1,borderImageSlice:1,borderImageWidth:1,boxFlex:1,boxFlexGroup:1,boxOrdinalGroup:1,columnCount:1,columns:1,flex:1,flexGrow:1,flexPositive:1,flexShrink:1,flexNegative:1,flexOrder:1,gridRow:1,gridRowEnd:1,gridRowSpan:1,gridRowStart:1,gridColumn:1,gridColumnEnd:1,gridColumnSpan:1,gridColumnStart:1,msGridRow:1,msGridRowSpan:1,msGridColumn:1,msGridColumnSpan:1,fontWeight:1,lineHeight:1,opacity:1,order:1,orphans:1,tabSize:1,widows:1,zIndex:1,zoom:1,WebkitLineClamp:1,fillOpacity:1,floodOpacity:1,stopOpacity:1,strokeDasharray:1,strokeDashoffset:1,strokeMiterlimit:1,strokeOpacity:1,strokeWidth:1};var hl=/^((children|dangerouslySetInnerHTML|key|ref|autoFocus|defaultValue|defaultChecked|innerHTML|suppressContentEditableWarning|suppressHydrationWarning|valueLink|accept|acceptCharset|accessKey|action|allow|allowUserMedia|allowPaymentRequest|allowFullScreen|allowTransparency|alt|async|autoComplete|autoPlay|capture|cellPadding|cellSpacing|challenge|charSet|checked|cite|classID|className|cols|colSpan|content|contentEditable|contextMenu|controls|controlsList|coords|crossOrigin|data|dateTime|decoding|default|defer|dir|disabled|disablePictureInPicture|download|draggable|encType|form|formAction|formEncType|formMethod|formNoValidate|formTarget|frameBorder|headers|height|hidden|high|href|hrefLang|htmlFor|httpEquiv|id|inputMode|integrity|is|keyParams|keyType|kind|label|lang|list|loading|loop|low|marginHeight|marginWidth|max|maxLength|media|mediaGroup|method|min|minLength|multiple|muted|name|nonce|noValidate|open|optimum|pattern|placeholder|playsInline|poster|preload|profile|radioGroup|readOnly|referrerPolicy|rel|required|reversed|role|rows|rowSpan|sandbox|scope|scoped|scrolling|seamless|selected|shape|size|sizes|slot|span|spellCheck|src|srcDoc|srcLang|srcSet|start|step|style|summary|tabIndex|target|title|type|useMap|value|width|wmode|wrap|about|datatype|inlist|prefix|property|resource|typeof|vocab|autoCapitalize|autoCorrect|autoSave|color|inert|itemProp|itemScope|itemType|itemID|itemRef|on|results|security|unselectable|accentHeight|accumulate|additive|alignmentBaseline|allowReorder|alphabetic|amplitude|arabicForm|ascent|attributeName|attributeType|autoReverse|azimuth|baseFrequency|baselineShift|baseProfile|bbox|begin|bias|by|calcMode|capHeight|clip|clipPathUnits|clipPath|clipRule|colorInterpolation|colorInterpolationFilters|colorProfile|colorRendering|contentScriptType|contentStyleType|cursor|cx|cy|d|decelerate|descent|diffuseConstant|direction|display|divisor|dominantBaseline|dur|dx|dy|edgeMode|elevation|enableBackground|end|exponent|externalResourcesRequired|fill|fillOpacity|fillRule|filter|filterRes|filterUnits|floodColor|floodOpacity|focusable|fontFamily|fontSize|fontSizeAdjust|fontStretch|fontStyle|fontVariant|fontWeight|format|from|fr|fx|fy|g1|g2|glyphName|glyphOrientationHorizontal|glyphOrientationVertical|glyphRef|gradientTransform|gradientUnits|hanging|horizAdvX|horizOriginX|ideographic|imageRendering|in|in2|intercept|k|k1|k2|k3|k4|kernelMatrix|kernelUnitLength|kerning|keyPoints|keySplines|keyTimes|lengthAdjust|letterSpacing|lightingColor|limitingConeAngle|local|markerEnd|markerMid|markerStart|markerHeight|markerUnits|markerWidth|mask|maskContentUnits|maskUnits|mathematical|mode|numOctaves|offset|opacity|operator|order|orient|orientation|origin|overflow|overlinePosition|overlineThickness|panose1|paintOrder|pathLength|patternContentUnits|patternTransform|patternUnits|pointerEvents|points|pointsAtX|pointsAtY|pointsAtZ|preserveAlpha|preserveAspectRatio|primitiveUnits|r|radius|refX|refY|renderingIntent|repeatCount|repeatDur|requiredExtensions|requiredFeatures|restart|result|rotate|rx|ry|scale|seed|shapeRendering|slope|spacing|specularConstant|specularExponent|speed|spreadMethod|startOffset|stdDeviation|stemh|stemv|stitchTiles|stopColor|stopOpacity|strikethroughPosition|strikethroughThickness|string|stroke|strokeDasharray|strokeDashoffset|strokeLinecap|strokeLinejoin|strokeMiterlimit|strokeOpacity|strokeWidth|surfaceScale|systemLanguage|tableValues|targetX|targetY|textAnchor|textDecoration|textRendering|textLength|to|transform|u1|u2|underlinePosition|underlineThickness|unicode|unicodeBidi|unicodeRange|unitsPerEm|vAlphabetic|vHanging|vIdeographic|vMathematical|values|vectorEffect|version|vertAdvY|vertOriginX|vertOriginY|viewBox|viewTarget|visibility|widths|wordSpacing|writingMode|x|xHeight|x1|x2|xChannelSelector|xlinkActuate|xlinkArcrole|xlinkHref|xlinkRole|xlinkShow|xlinkTitle|xlinkType|xmlBase|xmlns|xmlnsXlink|xmlLang|xmlSpace|y|y1|y2|yChannelSelector|z|zoomAndPan|for|class|autofocus)|(([Dd][Aa][Tt][Aa]|[Aa][Rr][Ii][Aa]|x)-.*))$/,ml=function memoize($){var W={};return function(G){return void 0===W[G]&&(W[G]=$(G)),W[G]}}((function($){return hl.test($)||111===$.charCodeAt(0)&&110===$.charCodeAt(1)&&$.charCodeAt(2)<91})),gl=Ks.exports,vl={childContextTypes:!0,contextType:!0,contextTypes:!0,defaultProps:!0,displayName:!0,getDefaultProps:!0,getDerivedStateFromError:!0,getDerivedStateFromProps:!0,mixins:!0,propTypes:!0,type:!0},yl={name:!0,length:!0,prototype:!0,caller:!0,callee:!0,arguments:!0,arity:!0},bl={$$typeof:!0,compare:!0,defaultProps:!0,displayName:!0,propTypes:!0,type:!0},wl={};function getStatics($){return gl.isMemo($)?bl:wl[$.$$typeof]||vl}wl[gl.ForwardRef]={$$typeof:!0,render:!0,defaultProps:!0,displayName:!0,propTypes:!0},wl[gl.Memo]=bl;var Sl=Object.defineProperty,xl=Object.getOwnPropertyNames,kl=Object.getOwnPropertySymbols,_l=Object.getOwnPropertyDescriptor,Pl=Object.getPrototypeOf,El=Object.prototype;var jl=function hoistNonReactStatics($,W,G){if("string"!=typeof W){if(El){var oe=Pl(W);oe&&oe!==El&&hoistNonReactStatics($,oe,G)}var ae=xl(W);kl&&(ae=ae.concat(kl(W)));for(var ie=getStatics($),se=getStatics(W),le=0;le<ae.length;++le){var ue=ae[le];if(!(yl[ue]||G&&G[ue]||se&&se[ue]||ie&&ie[ue])){var de=_l(W,ue);try{Sl($,ue,de)}catch($){}}}}return $};function v(){return(v=Object.assign||function($){for(var W=1;W<arguments.length;W++){var G=arguments[W];for(var oe in G)Object.prototype.hasOwnProperty.call(G,oe)&&($[oe]=G[oe])}return $}).apply(this,arguments)}var g=function($,W){for(var G=[$[0]],oe=0,ae=W.length;oe<ae;oe+=1)G.push(W[oe],$[oe+1]);return G},S=function($){return null!==$&&"object"==typeof $&&"[object Object]"===($.toString?$.toString():Object.prototype.toString.call($))&&!Ks.exports.typeOf($)},Cl=Object.freeze([]),Ol=Object.freeze({});function b($){return"function"==typeof $}function _($){return $.displayName||$.name||"Component"}function N($){return $&&"string"==typeof $.styledComponentId}var Il="undefined"!=typeof process&&(process.env.REACT_APP_SC_ATTR||process.env.SC_ATTR)||"data-styled",Tl="undefined"!=typeof window&&"HTMLElement"in window,Dl=Boolean("boolean"==typeof SC_DISABLE_SPEEDY?SC_DISABLE_SPEEDY:"undefined"!=typeof process&&void 0!==process.env.REACT_APP_SC_DISABLE_SPEEDY&&""!==process.env.REACT_APP_SC_DISABLE_SPEEDY?"false"!==process.env.REACT_APP_SC_DISABLE_SPEEDY&&process.env.REACT_APP_SC_DISABLE_SPEEDY:"undefined"!=typeof process&&void 0!==process.env.SC_DISABLE_SPEEDY&&""!==process.env.SC_DISABLE_SPEEDY&&("false"!==process.env.SC_DISABLE_SPEEDY&&process.env.SC_DISABLE_SPEEDY)),Al={};function j($){for(var W=arguments.length,G=new Array(W>1?W-1:0),oe=1;oe<W;oe++)G[oe-1]=arguments[oe];throw new Error("An error occurred. See https://git.io/JUIaE#"+$+" for more information."+(G.length>0?" Args: "+G.join(", "):""))}var $l=function(){function e($){this.groupSizes=new Uint32Array(512),this.length=512,this.tag=$}var $=e.prototype;return $.indexOfGroup=function($){for(var W=0,G=0;G<$;G++)W+=this.groupSizes[G];return W},$.insertRules=function($,W){if($>=this.groupSizes.length){for(var G=this.groupSizes,oe=G.length,ae=oe;$>=ae;)(ae<<=1)<0&&j(16,""+$);this.groupSizes=new Uint32Array(ae),this.groupSizes.set(G),this.length=ae;for(var ie=oe;ie<ae;ie++)this.groupSizes[ie]=0}for(var se=this.indexOfGroup($+1),le=0,ue=W.length;le<ue;le++)this.tag.insertRule(se,W[le])&&(this.groupSizes[$]++,se++)},$.clearGroup=function($){if($<this.length){var W=this.groupSizes[$],G=this.indexOfGroup($),oe=G+W;this.groupSizes[$]=0;for(var ae=G;ae<oe;ae++)this.tag.deleteRule(G)}},$.getGroup=function($){var W="";if($>=this.length||0===this.groupSizes[$])return W;for(var G=this.groupSizes[$],oe=this.indexOfGroup($),ae=oe+G,ie=oe;ie<ae;ie++)W+=this.tag.getRule(ie)+"/*!sc*/\n";return W},e}(),zl=new Map,Ml=new Map,Rl=1,B=function($){if(zl.has($))return zl.get($);for(;Ml.has(Rl);)Rl++;var W=Rl++;return zl.set($,W),Ml.set(W,$),W},z=function($){return Ml.get($)},M=function($,W){W>=Rl&&(Rl=W+1),zl.set($,W),Ml.set(W,$)},Bl="style["+Il+'][data-styled-version="5.3.3"]',Fl=new RegExp("^"+Il+'\\.g(\\d+)\\[id="([\\w\\d-]+)"\\].*?"([^"]*)'),F=function($,W,G){for(var oe,ae=G.split(","),ie=0,se=ae.length;ie<se;ie++)(oe=ae[ie])&&$.registerName(W,oe)},Y=function($,W){for(var G=(W.textContent||"").split("/*!sc*/\n"),oe=[],ae=0,ie=G.length;ae<ie;ae++){var se=G[ae].trim();if(se){var le=se.match(Fl);if(le){var ue=0|parseInt(le[1],10),de=le[2];0!==ue&&(M(de,ue),F($,de,le[3]),$.getTag().insertRules(ue,oe)),oe.length=0}else oe.push(se)}}},q=function(){return"undefined"!=typeof window&&void 0!==window.__webpack_nonce__?window.__webpack_nonce__:null},H=function($){var W=document.head,G=$||W,oe=document.createElement("style"),ae=function($){for(var W=$.childNodes,G=W.length;G>=0;G--){var oe=W[G];if(oe&&1===oe.nodeType&&oe.hasAttribute(Il))return oe}}(G),ie=void 0!==ae?ae.nextSibling:null;oe.setAttribute(Il,"active"),oe.setAttribute("data-styled-version","5.3.3");var se=q();return se&&oe.setAttribute("nonce",se),G.insertBefore(oe,ie),oe},Nl=function(){function e($){var W=this.element=H($);W.appendChild(document.createTextNode("")),this.sheet=function($){if($.sheet)return $.sheet;for(var W=document.styleSheets,G=0,oe=W.length;G<oe;G++){var ae=W[G];if(ae.ownerNode===$)return ae}j(17)}(W),this.length=0}var $=e.prototype;return $.insertRule=function($,W){try{return this.sheet.insertRule(W,$),this.length++,!0}catch($){return!1}},$.deleteRule=function($){this.sheet.deleteRule($),this.length--},$.getRule=function($){var W=this.sheet.cssRules[$];return void 0!==W&&"string"==typeof W.cssText?W.cssText:""},e}(),Ll=function(){function e($){var W=this.element=H($);this.nodes=W.childNodes,this.length=0}var $=e.prototype;return $.insertRule=function($,W){if($<=this.length&&$>=0){var G=document.createTextNode(W),oe=this.nodes[$];return this.element.insertBefore(G,oe||null),this.length++,!0}return!1},$.deleteRule=function($){this.element.removeChild(this.nodes[$]),this.length--},$.getRule=function($){return $<this.length?this.nodes[$].textContent:""},e}(),Hl=function(){function e($){this.rules=[],this.length=0}var $=e.prototype;return $.insertRule=function($,W){return $<=this.length&&(this.rules.splice($,0,W),this.length++,!0)},$.deleteRule=function($){this.rules.splice($,1),this.length--},$.getRule=function($){return $<this.length?this.rules[$]:""},e}(),Vl=Tl,ql={isServer:!Tl,useCSSOMInjection:!Dl},Ul=function(){function e($,W,G){void 0===$&&($=Ol),void 0===W&&(W={}),this.options=v({},ql,{},$),this.gs=W,this.names=new Map(G),this.server=!!$.isServer,!this.server&&Tl&&Vl&&(Vl=!1,function($){for(var W=document.querySelectorAll(Bl),G=0,oe=W.length;G<oe;G++){var ae=W[G];ae&&"active"!==ae.getAttribute(Il)&&(Y($,ae),ae.parentNode&&ae.parentNode.removeChild(ae))}}(this))}e.registerId=function($){return B($)};var $=e.prototype;return $.reconstructWithOptions=function($,W){return void 0===W&&(W=!0),new e(v({},this.options,{},$),this.gs,W&&this.names||void 0)},$.allocateGSInstance=function($){return this.gs[$]=(this.gs[$]||0)+1},$.getTag=function(){return this.tag||(this.tag=(G=(W=this.options).isServer,oe=W.useCSSOMInjection,ae=W.target,$=G?new Hl(ae):oe?new Nl(ae):new Ll(ae),new $l($)));var $,W,G,oe,ae},$.hasNameForId=function($,W){return this.names.has($)&&this.names.get($).has(W)},$.registerName=function($,W){if(B($),this.names.has($))this.names.get($).add(W);else{var G=new Set;G.add(W),this.names.set($,G)}},$.insertRules=function($,W,G){this.registerName($,W),this.getTag().insertRules(B($),G)},$.clearNames=function($){this.names.has($)&&this.names.get($).clear()},$.clearRules=function($){this.getTag().clearGroup(B($)),this.clearNames($)},$.clearTag=function(){this.tag=void 0},$.toString=function(){return function($){for(var W=$.getTag(),G=W.length,oe="",ae=0;ae<G;ae++){var ie=z(ae);if(void 0!==ie){var se=$.names.get(ie),le=W.getGroup(ae);if(se&&le&&se.size){var ue=Il+".g"+ae+'[id="'+ie+'"]',de="";void 0!==se&&se.forEach((function($){$.length>0&&(de+=$+",")})),oe+=""+le+ue+'{content:"'+de+'"}/*!sc*/\n'}}}return oe}(this)},e}(),Kl=/(a)(d)/gi,Q=function($){return String.fromCharCode($+($>25?39:97))};function ee($){var W,G="";for(W=Math.abs($);W>52;W=W/52|0)G=Q(W%52)+G;return(Q(W%52)+G).replace(Kl,"$1-$2")}var te=function($,W){for(var G=W.length;G;)$=33*$^W.charCodeAt(--G);return $},ne=function($){return te(5381,$)};function re($){for(var W=0;W<$.length;W+=1){var G=$[W];if(b(G)&&!N(G))return!1}return!0}var Wl=ne("5.3.3"),Gl=function(){function e($,W,G){this.rules=$,this.staticRulesId="",this.isStatic=(void 0===G||G.isStatic)&&re($),this.componentId=W,this.baseHash=te(Wl,W),this.baseStyle=G,Ul.registerId(W)}return e.prototype.generateAndInjectStyles=function($,W,G){var oe=this.componentId,ae=[];if(this.baseStyle&&ae.push(this.baseStyle.generateAndInjectStyles($,W,G)),this.isStatic&&!G.hash)if(this.staticRulesId&&W.hasNameForId(oe,this.staticRulesId))ae.push(this.staticRulesId);else{var ie=Ne(this.rules,$,W,G).join(""),se=ee(te(this.baseHash,ie)>>>0);if(!W.hasNameForId(oe,se)){var le=G(ie,"."+se,void 0,oe);W.insertRules(oe,se,le)}ae.push(se),this.staticRulesId=se}else{for(var ue=this.rules.length,de=te(this.baseHash,G.hash),pe="",he=0;he<ue;he++){var ge=this.rules[he];if("string"==typeof ge)pe+=ge;else if(ge){var ve=Ne(ge,$,W,G),we=Array.isArray(ve)?ve.join(""):ve;de=te(de,we+he),pe+=we}}if(pe){var Se=ee(de>>>0);if(!W.hasNameForId(oe,Se)){var Pe=G(pe,"."+Se,void 0,oe);W.insertRules(oe,Se,Pe)}ae.push(Se)}}return ae.join(" ")},e}(),Xl=/^\s*\/\/.*$/gm,Yl=[":","[",".","#"];function ce($){var W,G,oe,ae,ie=void 0===$?Ol:$,se=ie.options,le=void 0===se?Ol:se,ue=ie.plugins,de=void 0===ue?Cl:ue,pe=new stylis_min(le),he=[],ge=function($){function t(W){if(W)try{$(W+"}")}catch($){}}return function(W,G,oe,ae,ie,se,le,ue,de,pe){switch(W){case 1:if(0===de&&64===G.charCodeAt(0))return $(G+";"),"";break;case 2:if(0===ue)return G+"/*|*/";break;case 3:switch(ue){case 102:case 112:return $(oe[0]+G),"";default:return G+(0===pe?"/*|*/":"")}case-2:G.split("/*|*/}").forEach(t)}}}((function($){he.push($)})),f=function($,oe,ie){return 0===oe&&-1!==Yl.indexOf(ie[G.length])||ie.match(ae)?$:"."+W};function m($,ie,se,le){void 0===le&&(le="&");var ue=$.replace(Xl,""),de=ie&&se?se+" "+ie+" { "+ue+" }":ue;return W=le,G=ie,oe=new RegExp("\\"+G+"\\b","g"),ae=new RegExp("(\\"+G+"\\b){2,}"),pe(se||!ie?"":ie,de)}return pe.use([].concat(de,[function($,W,ae){2===$&&ae.length&&ae[0].lastIndexOf(G)>0&&(ae[0]=ae[0].replace(oe,f))},ge,function($){if(-2===$){var W=he;return he=[],W}}])),m.hash=de.length?de.reduce((function($,W){return W.name||j(15),te($,W.name)}),5381).toString():"",m}var Jl=Ht.createContext(),Ql=Jl.Consumer,Zl=Ht.createContext(),eu=(Zl.Consumer,new Ul),tu=ce();function fe(){return vt.exports.useContext(Jl)||eu}function me(){return vt.exports.useContext(Zl)||tu}function ye($){var W=vt.exports.useState($.stylisPlugins),G=W[0],oe=W[1],ae=fe(),ie=vt.exports.useMemo((function(){var W=ae;return $.sheet?W=$.sheet:$.target&&(W=W.reconstructWithOptions({target:$.target},!1)),$.disableCSSOMInjection&&(W=W.reconstructWithOptions({useCSSOMInjection:!1})),W}),[$.disableCSSOMInjection,$.sheet,$.target]),se=vt.exports.useMemo((function(){return ce({options:{prefix:!$.disableVendorPrefixes},plugins:G})}),[$.disableVendorPrefixes,G]);return vt.exports.useEffect((function(){(function shallowEqual($,W,G,oe){var ae=G?G.call(oe,$,W):void 0;if(void 0!==ae)return!!ae;if($===W)return!0;if("object"!=typeof $||!$||"object"!=typeof W||!W)return!1;var ie=Object.keys($),se=Object.keys(W);if(ie.length!==se.length)return!1;for(var le=Object.prototype.hasOwnProperty.bind(W),ue=0;ue<ie.length;ue++){var de=ie[ue];if(!le(de))return!1;var pe=$[de],he=W[de];if(!1===(ae=G?G.call(oe,pe,he,de):void 0)||void 0===ae&&pe!==he)return!1}return!0})(G,$.stylisPlugins)||oe($.stylisPlugins)}),[$.stylisPlugins]),Ht.createElement(Jl.Provider,{value:ie},Ht.createElement(Zl.Provider,{value:se},$.children))}var ru=function(){function e($,W){var G=this;this.inject=function($,W){void 0===W&&(W=tu);var oe=G.name+W.hash;$.hasNameForId(G.id,oe)||$.insertRules(G.id,oe,W(G.rules,oe,"@keyframes"))},this.toString=function(){return j(12,String(G.name))},this.name=$,this.id="sc-keyframes-"+$,this.rules=W}return e.prototype.getName=function($){return void 0===$&&($=tu),this.name+$.hash},e}(),nu=/([A-Z])/,ou=/([A-Z])/g,au=/^ms-/,Ee=function($){return"-"+$.toLowerCase()};function be($){return nu.test($)?$.replace(ou,Ee).replace(au,"-ms-"):$}var _e=function($){return null==$||!1===$||""===$};function Ne($,W,G,oe){if(Array.isArray($)){for(var ae,ie=[],se=0,le=$.length;se<le;se+=1)""!==(ae=Ne($[se],W,G,oe))&&(Array.isArray(ae)?ie.push.apply(ie,ae):ie.push(ae));return ie}return _e($)?"":N($)?"."+$.styledComponentId:b($)?"function"!=typeof(ue=$)||ue.prototype&&ue.prototype.isReactComponent||!W?$:Ne($(W),W,G,oe):$ instanceof ru?G?($.inject(G,oe),$.getName(oe)):$:S($)?function e($,W){var G,oe,ae=[];for(var ie in $)$.hasOwnProperty(ie)&&!_e($[ie])&&(Array.isArray($[ie])&&$[ie].isCss||b($[ie])?ae.push(be(ie)+":",$[ie],";"):S($[ie])?ae.push.apply(ae,e($[ie],ie)):ae.push(be(ie)+": "+(G=ie,(null==(oe=$[ie])||"boolean"==typeof oe||""===oe?"":"number"!=typeof oe||0===oe||G in pl?String(oe).trim():oe+"px")+";")));return W?[W+" {"].concat(ae,["}"]):ae}($):$.toString();var ue}var Ae=function($){return Array.isArray($)&&($.isCss=!0),$};function Ce($){for(var W=arguments.length,G=new Array(W>1?W-1:0),oe=1;oe<W;oe++)G[oe-1]=arguments[oe];return b($)||S($)?Ae(Ne(g(Cl,[$].concat(G)))):0===G.length&&1===$.length&&"string"==typeof $[0]?$:Ae(Ne(g($,G)))}var Re=function($,W,G){return void 0===G&&(G=Ol),$.theme!==G.theme&&$.theme||W||G.theme},iu=/[!"#$%&'()*+,./:;<=>?@[\\\]^`{|}~-]+/g,su=/(^-|-$)/g;function Te($){return $.replace(iu,"-").replace(su,"")}var xe=function($){return ee(ne($)>>>0)};function ke($){return"string"==typeof $&&!0}var Ve=function($){return"function"==typeof $||"object"==typeof $&&null!==$&&!Array.isArray($)},Be=function($){return"__proto__"!==$&&"constructor"!==$&&"prototype"!==$};function ze($,W,G){var oe=$[G];Ve(W)&&Ve(oe)?Me(oe,W):$[G]=W}function Me($){for(var W=arguments.length,G=new Array(W>1?W-1:0),oe=1;oe<W;oe++)G[oe-1]=arguments[oe];for(var ae=0,ie=G;ae<ie.length;ae++){var se=ie[ae];if(Ve(se))for(var le in se)Be(le)&&ze($,se[le],le)}return $}var lu=Ht.createContext(),uu=lu.Consumer;var cu={};function qe($,W,G){var oe=N($),ae=!ke($),ie=W.attrs,se=void 0===ie?Cl:ie,le=W.componentId,ue=void 0===le?function($,W){var G="string"!=typeof $?"sc":Te($);cu[G]=(cu[G]||0)+1;var oe=G+"-"+xe("5.3.3"+G+cu[G]);return W?W+"-"+oe:oe}(W.displayName,W.parentComponentId):le,de=W.displayName,pe=void 0===de?function($){return ke($)?"styled."+$:"Styled("+_($)+")"}($):de,he=W.displayName&&W.componentId?Te(W.displayName)+"-"+W.componentId:W.componentId||ue,ge=oe&&$.attrs?Array.prototype.concat($.attrs,se).filter(Boolean):se,ve=W.shouldForwardProp;oe&&$.shouldForwardProp&&(ve=W.shouldForwardProp?function(G,oe,ae){return $.shouldForwardProp(G,oe,ae)&&W.shouldForwardProp(G,oe,ae)}:$.shouldForwardProp);var we,Se=new Gl(G,he,oe?$.componentStyle:void 0),Pe=Se.isStatic&&0===se.length,O=function($,W){return function($,W,G,oe){var ae=$.attrs,ie=$.componentStyle,se=$.defaultProps,le=$.foldedComponentIds,ue=$.shouldForwardProp,de=$.styledComponentId,pe=$.target,he=function($,W,G){void 0===$&&($=Ol);var oe=v({},W,{theme:$}),ae={};return G.forEach((function($){var W,G,ie,se=$;for(W in b(se)&&(se=se(oe)),se)oe[W]=ae[W]="className"===W?(G=ae[W],ie=se[W],G&&ie?G+" "+ie:G||ie):se[W]})),[oe,ae]}(Re(W,vt.exports.useContext(lu),se)||Ol,W,ae),ge=he[0],ve=he[1],we=function($,W,G,oe){var ae=fe(),ie=me();return W?$.generateAndInjectStyles(Ol,ae,ie):$.generateAndInjectStyles(G,ae,ie)}(ie,oe,ge),Se=G,Pe=ve.$as||W.$as||ve.as||W.as||pe,je=ke(Pe),Ie=ve!==W?v({},W,{},ve):W,De={};for(var $e in Ie)"$"!==$e[0]&&"as"!==$e&&("forwardedAs"===$e?De.as=Ie[$e]:(ue?ue($e,ml,Pe):!je||ml($e))&&(De[$e]=Ie[$e]));return W.style&&ve.style!==W.style&&(De.style=v({},W.style,{},ve.style)),De.className=Array.prototype.concat(le,de,we!==de?we:null,W.className,ve.className).filter(Boolean).join(" "),De.ref=Se,vt.exports.createElement(Pe,De)}(we,$,W,Pe)};return O.displayName=pe,(we=Ht.forwardRef(O)).attrs=ge,we.componentStyle=Se,we.displayName=pe,we.shouldForwardProp=ve,we.foldedComponentIds=oe?Array.prototype.concat($.foldedComponentIds,$.styledComponentId):Cl,we.styledComponentId=he,we.target=oe?$.target:$,we.withComponent=function($){var oe=W.componentId,ae=function($,W){if(null==$)return{};var G,oe,ae={},ie=Object.keys($);for(oe=0;oe<ie.length;oe++)G=ie[oe],W.indexOf(G)>=0||(ae[G]=$[G]);return ae}(W,["componentId"]),ie=oe&&oe+"-"+(ke($)?$:Te(_($)));return qe($,v({},ae,{attrs:ge,componentId:ie}),G)},Object.defineProperty(we,"defaultProps",{get:function(){return this._foldedDefaultProps},set:function(W){this._foldedDefaultProps=oe?Me({},$.defaultProps,W):W}}),we.toString=function(){return"."+we.styledComponentId},ae&&jl(we,$,{attrs:!0,componentStyle:!0,displayName:!0,foldedComponentIds:!0,shouldForwardProp:!0,styledComponentId:!0,target:!0,withComponent:!0}),we}var He=function($){return function e($,W,G){if(void 0===G&&(G=Ol),!Ks.exports.isValidElementType(W))return j(1,String(W));var s=function(){return $(W,G,Ce.apply(void 0,arguments))};return s.withConfig=function(oe){return e($,W,v({},G,{},oe))},s.attrs=function(oe){return e($,W,v({},G,{attrs:Array.prototype.concat(G.attrs,oe).filter(Boolean)}))},s}(qe,$)};["a","abbr","address","area","article","aside","audio","b","base","bdi","bdo","big","blockquote","body","br","button","canvas","caption","cite","code","col","colgroup","data","datalist","dd","del","details","dfn","dialog","div","dl","dt","em","embed","fieldset","figcaption","figure","footer","form","h1","h2","h3","h4","h5","h6","head","header","hgroup","hr","html","i","iframe","img","input","ins","kbd","keygen","label","legend","li","link","main","map","mark","marquee","menu","menuitem","meta","meter","nav","noscript","object","ol","optgroup","option","output","p","param","picture","pre","progress","q","rp","rt","ruby","s","samp","script","section","select","small","source","span","strong","style","sub","summary","sup","table","tbody","td","textarea","tfoot","th","thead","time","title","tr","track","u","ul","var","video","wbr","circle","clipPath","defs","ellipse","foreignObject","g","image","line","linearGradient","marker","mask","path","pattern","polygon","polyline","radialGradient","rect","stop","svg","text","textPath","tspan"].forEach((function($){He[$]=He($)}));var du=function(){function e($,W){this.rules=$,this.componentId=W,this.isStatic=re($),Ul.registerId(this.componentId+1)}var $=e.prototype;return $.createStyles=function($,W,G,oe){var ae=oe(Ne(this.rules,W,G,oe).join(""),""),ie=this.componentId+$;G.insertRules(ie,ie,ae)},$.removeStyles=function($,W){W.clearRules(this.componentId+$)},$.renderStyles=function($,W,G,oe){$>2&&Ul.registerId(this.componentId+$),this.removeStyles($,G),this.createStyles($,W,G,oe)},e}();var fu=function(){function e(){var $=this;this._emitSheetCSS=function(){var W=$.instance.toString();if(!W)return"";var G=q();return"<style "+[G&&'nonce="'+G+'"',Il+'="true"','data-styled-version="5.3.3"'].filter(Boolean).join(" ")+">"+W+"</style>"},this.getStyleTags=function(){return $.sealed?j(2):$._emitSheetCSS()},this.getStyleElement=function(){var W;if($.sealed)return j(2);var G=((W={})[Il]="",W["data-styled-version"]="5.3.3",W.dangerouslySetInnerHTML={__html:$.instance.toString()},W),oe=q();return oe&&(G.nonce=oe),[Ht.createElement("style",v({},G,{key:"sc-0-0"}))]},this.seal=function(){$.sealed=!0},this.instance=new Ul({isServer:!0}),this.sealed=!1}var $=e.prototype;return $.collectStyles=function($){return this.sealed?j(2):Ht.createElement(ye,{sheet:this.instance},$)},$.interleaveWithNodeStream=function($){return j(3)},e}(),pu={StyleSheet:Ul,masterSheet:eu},hu=Object.freeze({__proto__:null,default:He,ServerStyleSheet:fu,StyleSheetConsumer:Ql,StyleSheetContext:Jl,StyleSheetManager:ye,ThemeConsumer:uu,ThemeContext:lu,ThemeProvider:function Fe($){var W=vt.exports.useContext(lu),G=vt.exports.useMemo((function(){return function($,W){return $?b($)?$(W):Array.isArray($)||"object"!=typeof $?j(8):W?v({},W,{},$):$:j(14)}($.theme,W)}),[$.theme,W]);return $.children?Ht.createElement(lu.Provider,{value:G},$.children):null},__PRIVATE__:pu,createGlobalStyle:function We($){for(var W=arguments.length,G=new Array(W>1?W-1:0),oe=1;oe<W;oe++)G[oe-1]=arguments[oe];var ae=Ce.apply(void 0,[$].concat(G)),ie="sc-global-"+xe(JSON.stringify(ae)),se=new du(ae,ie);function l($){var W=fe(),G=me(),oe=vt.exports.useContext(lu),ae=vt.exports.useRef(W.allocateGSInstance(ie)).current;return W.server&&h(ae,$,W,oe,G),vt.exports.useLayoutEffect((function(){if(!W.server)return h(ae,$,W,oe,G),function(){return se.removeStyles(ae,W)}}),[ae,$,W,oe,G]),null}function h($,W,G,oe,ae){if(se.isStatic)se.renderStyles($,Al,G,ae);else{var ie=v({},W,{theme:Re(W,oe,l.defaultProps)});se.renderStyles($,ie,G,ae)}}return Ht.memo(l)},css:Ce,isStyledComponent:N,keyframes:function Ue($){for(var W=arguments.length,G=new Array(W>1?W-1:0),oe=1;oe<W;oe++)G[oe-1]=arguments[oe];var ae=Ce.apply(void 0,[$].concat(G)).join(""),ie=xe(ae);return new ru(ie,ae)},useTheme:function(){return vt.exports.useContext(lu)},version:"5.3.3",withTheme:function($){var W=Ht.forwardRef((function(W,G){var oe=vt.exports.useContext(lu),ae=$.defaultProps,ie=Re(W,oe,ae);return Ht.createElement($,v({},W,{theme:ie,ref:G}))}));return jl(W,$),W.displayName="WithTheme("+_($)+")",W}}),mu=getAugmentedNamespace(hu);!function($,G){var oe,ae=Object.create,ie=Object.defineProperty,se=Object.defineProperties,le=Object.getOwnPropertyDescriptor,ue=Object.getOwnPropertyDescriptors,de=Object.getOwnPropertyNames,pe=Object.getOwnPropertySymbols,he=Object.getPrototypeOf,ge=Object.prototype.hasOwnProperty,ve=Object.prototype.propertyIsEnumerable,__defNormalProp=($,W,G)=>W in $?ie($,W,{enumerable:!0,configurable:!0,writable:!0,value:G}):$[W]=G,__spreadValues=($,W)=>{for(var G in W||(W={}))ge.call(W,G)&&__defNormalProp($,G,W[G]);if(pe)for(var G of pe(W))ve.call(W,G)&&__defNormalProp($,G,W[G]);return $},__spreadProps=($,W)=>se($,ue(W)),__markAsModule=$=>ie($,"__esModule",{value:!0}),__objRest=($,W)=>{var G={};for(var oe in $)ge.call($,oe)&&W.indexOf(oe)<0&&(G[oe]=$[oe]);if(null!=$&&pe)for(var oe of pe($))W.indexOf(oe)<0&&ve.call($,oe)&&(G[oe]=$[oe]);return G},__commonJS=($,W)=>function __require(){return W||(0,$[Object.keys($)[0]])((W={exports:{}}).exports,W),W.exports},__toModule=$=>(($,W,G)=>{if(W&&"object"==typeof W||"function"==typeof W)for(let oe of de(W))ge.call($,oe)||"default"===oe||ie($,oe,{get:()=>W[oe],enumerable:!(G=le(W,oe))||G.enumerable});return $})(__markAsModule(ie(null!=$?ae(he($)):{},"default",$&&$.__esModule&&"default"in $?{get:()=>$.default,enumerable:!0}:{value:$,enumerable:!0})),$),__publicField=($,W,G)=>(__defNormalProp($,"symbol"!=typeof W?W+"":W,G),G),we=__commonJS({"../node_modules/queue-microtask/index.js"($,W){var G;W.exports="function"==typeof queueMicrotask?queueMicrotask.bind(window):$=>(G||(G=Promise.resolve())).then($).catch(($=>setTimeout((()=>{throw $}),0)))}}),Se=__commonJS({"../node_modules/polished/lib/internalHelpers/_curry.js"($,W){function curried2($,W,G){return function fn2(){var oe=G.concat(Array.prototype.slice.call(arguments));return oe.length>=W?$.apply(this,oe):curried2($,W,oe)}}$.__esModule=!0,$.default=function curry2($){return curried2($,$.length,[])},W.exports=$.default}}),Pe=__commonJS({"../node_modules/polished/lib/internalHelpers/_guard.js"($,W){$.__esModule=!0,$.default=void 0;var G=function guard2($,W,G){return Math.max($,Math.min(W,G))};$.default=G,W.exports=$.default}}),je=__commonJS({"../node_modules/polished/lib/internalHelpers/_hslToRgb.js"($,W){function colorToInt2($){return Math.round(255*$)}function convertToInt2($,W,G){return colorToInt2($)+","+colorToInt2(W)+","+colorToInt2(G)}$.__esModule=!0,$.default=void 0;var G=function hslToRgb2($,W,G,oe){if(void 0===oe&&(oe=convertToInt2),0===W)return oe(G,G,G);var ae=($%360+360)%360/60,ie=(1-Math.abs(2*G-1))*W,se=ie*(1-Math.abs(ae%2-1)),le=0,ue=0,de=0;ae>=0&&ae<1?(le=ie,ue=se):ae>=1&&ae<2?(le=se,ue=ie):ae>=2&&ae<3?(ue=ie,de=se):ae>=3&&ae<4?(ue=se,de=ie):ae>=4&&ae<5?(le=se,de=ie):ae>=5&&ae<6&&(le=ie,de=se);var pe=G-ie/2;return oe(le+pe,ue+pe,de+pe)};$.default=G,W.exports=$.default}}),Ie=__commonJS({"../node_modules/polished/lib/internalHelpers/_nameToHex.js"($,W){$.__esModule=!0,$.default=void 0;var G={aliceblue:"f0f8ff",antiquewhite:"faebd7",aqua:"00ffff",aquamarine:"7fffd4",azure:"f0ffff",beige:"f5f5dc",bisque:"ffe4c4",black:"000",blanchedalmond:"ffebcd",blue:"0000ff",blueviolet:"8a2be2",brown:"a52a2a",burlywood:"deb887",cadetblue:"5f9ea0",chartreuse:"7fff00",chocolate:"d2691e",coral:"ff7f50",cornflowerblue:"6495ed",cornsilk:"fff8dc",crimson:"dc143c",cyan:"00ffff",darkblue:"00008b",darkcyan:"008b8b",darkgoldenrod:"b8860b",darkgray:"a9a9a9",darkgreen:"006400",darkgrey:"a9a9a9",darkkhaki:"bdb76b",darkmagenta:"8b008b",darkolivegreen:"556b2f",darkorange:"ff8c00",darkorchid:"9932cc",darkred:"8b0000",darksalmon:"e9967a",darkseagreen:"8fbc8f",darkslateblue:"483d8b",darkslategray:"2f4f4f",darkslategrey:"2f4f4f",darkturquoise:"00ced1",darkviolet:"9400d3",deeppink:"ff1493",deepskyblue:"00bfff",dimgray:"696969",dimgrey:"696969",dodgerblue:"1e90ff",firebrick:"b22222",floralwhite:"fffaf0",forestgreen:"228b22",fuchsia:"ff00ff",gainsboro:"dcdcdc",ghostwhite:"f8f8ff",gold:"ffd700",goldenrod:"daa520",gray:"808080",green:"008000",greenyellow:"adff2f",grey:"808080",honeydew:"f0fff0",hotpink:"ff69b4",indianred:"cd5c5c",indigo:"4b0082",ivory:"fffff0",khaki:"f0e68c",lavender:"e6e6fa",lavenderblush:"fff0f5",lawngreen:"7cfc00",lemonchiffon:"fffacd",lightblue:"add8e6",lightcoral:"f08080",lightcyan:"e0ffff",lightgoldenrodyellow:"fafad2",lightgray:"d3d3d3",lightgreen:"90ee90",lightgrey:"d3d3d3",lightpink:"ffb6c1",lightsalmon:"ffa07a",lightseagreen:"20b2aa",lightskyblue:"87cefa",lightslategray:"789",lightslategrey:"789",lightsteelblue:"b0c4de",lightyellow:"ffffe0",lime:"0f0",limegreen:"32cd32",linen:"faf0e6",magenta:"f0f",maroon:"800000",mediumaquamarine:"66cdaa",mediumblue:"0000cd",mediumorchid:"ba55d3",mediumpurple:"9370db",mediumseagreen:"3cb371",mediumslateblue:"7b68ee",mediumspringgreen:"00fa9a",mediumturquoise:"48d1cc",mediumvioletred:"c71585",midnightblue:"191970",mintcream:"f5fffa",mistyrose:"ffe4e1",moccasin:"ffe4b5",navajowhite:"ffdead",navy:"000080",oldlace:"fdf5e6",olive:"808000",olivedrab:"6b8e23",orange:"ffa500",orangered:"ff4500",orchid:"da70d6",palegoldenrod:"eee8aa",palegreen:"98fb98",paleturquoise:"afeeee",palevioletred:"db7093",papayawhip:"ffefd5",peachpuff:"ffdab9",peru:"cd853f",pink:"ffc0cb",plum:"dda0dd",powderblue:"b0e0e6",purple:"800080",rebeccapurple:"639",red:"f00",rosybrown:"bc8f8f",royalblue:"4169e1",saddlebrown:"8b4513",salmon:"fa8072",sandybrown:"f4a460",seagreen:"2e8b57",seashell:"fff5ee",sienna:"a0522d",silver:"c0c0c0",skyblue:"87ceeb",slateblue:"6a5acd",slategray:"708090",slategrey:"708090",snow:"fffafa",springgreen:"00ff7f",steelblue:"4682b4",tan:"d2b48c",teal:"008080",thistle:"d8bfd8",tomato:"ff6347",turquoise:"40e0d0",violet:"ee82ee",wheat:"f5deb3",white:"fff",whitesmoke:"f5f5f5",yellow:"ff0",yellowgreen:"9acd32"};var oe=function nameToHex2($){if("string"!=typeof $)return $;var W=$.toLowerCase();return G[W]?"#"+G[W]:$};$.default=oe,W.exports=$.default}}),De=__commonJS({"../node_modules/polished/lib/internalHelpers/_errors.js"($,W){function _assertThisInitialized2($){if(void 0===$)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return $}function _wrapNativeSuper2($){var W="function"==typeof Map?new Map:void 0;return _wrapNativeSuper2=function _wrapNativeSuper3($){if(null===$||!function _isNativeFunction2($){return-1!==Function.toString.call($).indexOf("[native code]")}($))return $;if("function"!=typeof $)throw new TypeError("Super expression must either be null or a function");if(void 0!==W){if(W.has($))return W.get($);W.set($,Wrapper)}function Wrapper(){return _construct2($,arguments,_getPrototypeOf2(this).constructor)}return Wrapper.prototype=Object.create($.prototype,{constructor:{value:Wrapper,enumerable:!1,writable:!0,configurable:!0}}),_setPrototypeOf2(Wrapper,$)},_wrapNativeSuper2($)}function _construct2($,W,G){return(_construct2=_isNativeReflectConstruct2()?Reflect.construct:function _construct3($,W,G){var oe=[null];oe.push.apply(oe,W);var ae=new(Function.bind.apply($,oe));return G&&_setPrototypeOf2(ae,G.prototype),ae}).apply(null,arguments)}function _isNativeReflectConstruct2(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch($){return!1}}function _setPrototypeOf2($,W){return(_setPrototypeOf2=Object.setPrototypeOf||function _setPrototypeOf3($,W){return $.__proto__=W,$})($,W)}function _getPrototypeOf2($){return(_getPrototypeOf2=Object.setPrototypeOf?Object.getPrototypeOf:function _getPrototypeOf3($){return $.__proto__||Object.getPrototypeOf($)})($)}$.__esModule=!0,$.default=void 0;var G={1:"Passed invalid arguments to hsl, please pass multiple numbers e.g. hsl(360, 0.75, 0.4) or an object e.g. rgb({ hue: 255, saturation: 0.4, lightness: 0.75 }).\n\n",2:"Passed invalid arguments to hsla, please pass multiple numbers e.g. hsla(360, 0.75, 0.4, 0.7) or an object e.g. rgb({ hue: 255, saturation: 0.4, lightness: 0.75, alpha: 0.7 }).\n\n",3:"Passed an incorrect argument to a color function, please pass a string representation of a color.\n\n",4:"Couldn't generate valid rgb string from %s, it returned %s.\n\n",5:"Couldn't parse the color string. Please provide the color as a string in hex, rgb, rgba, hsl or hsla notation.\n\n",6:"Passed invalid arguments to rgb, please pass multiple numbers e.g. rgb(255, 205, 100) or an object e.g. rgb({ red: 255, green: 205, blue: 100 }).\n\n",7:"Passed invalid arguments to rgba, please pass multiple numbers e.g. rgb(255, 205, 100, 0.75) or an object e.g. rgb({ red: 255, green: 205, blue: 100, alpha: 0.75 }).\n\n",8:"Passed invalid argument to toColorString, please pass a RgbColor, RgbaColor, HslColor or HslaColor object.\n\n",9:"Please provide a number of steps to the modularScale helper.\n\n",10:"Please pass a number or one of the predefined scales to the modularScale helper as the ratio.\n\n",11:'Invalid value passed as base to modularScale, expected number or em string but got "%s"\n\n',12:'Expected a string ending in "px" or a number passed as the first argument to %s(), got "%s" instead.\n\n',13:'Expected a string ending in "px" or a number passed as the second argument to %s(), got "%s" instead.\n\n',14:'Passed invalid pixel value ("%s") to %s(), please pass a value like "12px" or 12.\n\n',15:'Passed invalid base value ("%s") to %s(), please pass a value like "12px" or 12.\n\n',16:"You must provide a template to this method.\n\n",17:"You passed an unsupported selector state to this method.\n\n",18:"minScreen and maxScreen must be provided as stringified numbers with the same units.\n\n",19:"fromSize and toSize must be provided as stringified numbers with the same units.\n\n",20:"expects either an array of objects or a single object with the properties prop, fromSize, and toSize.\n\n",21:"expects the objects in the first argument array to have the properties `prop`, `fromSize`, and `toSize`.\n\n",22:"expects the first argument object to have the properties `prop`, `fromSize`, and `toSize`.\n\n",23:"fontFace expects a name of a font-family.\n\n",24:"fontFace expects either the path to the font file(s) or a name of a local copy.\n\n",25:"fontFace expects localFonts to be an array.\n\n",26:"fontFace expects fileFormats to be an array.\n\n",27:"radialGradient requries at least 2 color-stops to properly render.\n\n",28:"Please supply a filename to retinaImage() as the first argument.\n\n",29:"Passed invalid argument to triangle, please pass correct pointingDirection e.g. 'right'.\n\n",30:"Passed an invalid value to `height` or `width`. Please provide a pixel based unit.\n\n",31:"The animation shorthand only takes 8 arguments. See the specification for more information: http://mdn.io/animation\n\n",32:"To pass multiple animations please supply them in arrays, e.g. animation(['rotate', '2s'], ['move', '1s'])\nTo pass a single animation please supply them in simple values, e.g. animation('rotate', '2s')\n\n",33:"The animation shorthand arrays can only have 8 elements. See the specification for more information: http://mdn.io/animation\n\n",34:"borderRadius expects a radius value as a string or number as the second argument.\n\n",35:'borderRadius expects one of "top", "bottom", "left" or "right" as the first argument.\n\n',36:"Property must be a string value.\n\n",37:"Syntax Error at %s.\n\n",38:"Formula contains a function that needs parentheses at %s.\n\n",39:"Formula is missing closing parenthesis at %s.\n\n",40:"Formula has too many closing parentheses at %s.\n\n",41:"All values in a formula must have the same unit or be unitless.\n\n",42:"Please provide a number of steps to the modularScale helper.\n\n",43:"Please pass a number or one of the predefined scales to the modularScale helper as the ratio.\n\n",44:"Invalid value passed as base to modularScale, expected number or em/rem string but got %s.\n\n",45:"Passed invalid argument to hslToColorString, please pass a HslColor or HslaColor object.\n\n",46:"Passed invalid argument to rgbToColorString, please pass a RgbColor or RgbaColor object.\n\n",47:"minScreen and maxScreen must be provided as stringified numbers with the same units.\n\n",48:"fromSize and toSize must be provided as stringified numbers with the same units.\n\n",49:"Expects either an array of objects or a single object with the properties prop, fromSize, and toSize.\n\n",50:"Expects the objects in the first argument array to have the properties prop, fromSize, and toSize.\n\n",51:"Expects the first argument object to have the properties prop, fromSize, and toSize.\n\n",52:"fontFace expects either the path to the font file(s) or a name of a local copy.\n\n",53:"fontFace expects localFonts to be an array.\n\n",54:"fontFace expects fileFormats to be an array.\n\n",55:"fontFace expects a name of a font-family.\n\n",56:"linearGradient requries at least 2 color-stops to properly render.\n\n",57:"radialGradient requries at least 2 color-stops to properly render.\n\n",58:"Please supply a filename to retinaImage() as the first argument.\n\n",59:"Passed invalid argument to triangle, please pass correct pointingDirection e.g. 'right'.\n\n",60:"Passed an invalid value to `height` or `width`. Please provide a pixel based unit.\n\n",61:"Property must be a string value.\n\n",62:"borderRadius expects a radius value as a string or number as the second argument.\n\n",63:'borderRadius expects one of "top", "bottom", "left" or "right" as the first argument.\n\n',64:"The animation shorthand only takes 8 arguments. See the specification for more information: http://mdn.io/animation.\n\n",65:"To pass multiple animations please supply them in arrays, e.g. animation(['rotate', '2s'], ['move', '1s'])\\nTo pass a single animation please supply them in simple values, e.g. animation('rotate', '2s').\n\n",66:"The animation shorthand arrays can only have 8 elements. See the specification for more information: http://mdn.io/animation.\n\n",67:"You must provide a template to this method.\n\n",68:"You passed an unsupported selector state to this method.\n\n",69:'Expected a string ending in "px" or a number passed as the first argument to %s(), got %s instead.\n\n',70:'Expected a string ending in "px" or a number passed as the second argument to %s(), got %s instead.\n\n',71:'Passed invalid pixel value %s to %s(), please pass a value like "12px" or 12.\n\n',72:'Passed invalid base value %s to %s(), please pass a value like "12px" or 12.\n\n',73:"Please provide a valid CSS variable.\n\n",74:"CSS variable not found and no default was provided.\n\n",75:"important requires a valid style object, got a %s instead.\n\n",76:"fromSize and toSize must be provided as stringified numbers with the same units as minScreen and maxScreen.\n\n",77:'remToPx expects a value in "rem" but you provided it in "%s".\n\n',78:'base must be set in "px" or "%" but you set it in "%s".\n'};function format4(){for(var $=arguments.length,W=new Array($),G=0;G<$;G++)W[G]=arguments[G];var oe,ae=W[0],ie=[];for(oe=1;oe<W.length;oe+=1)ie.push(W[oe]);return ie.forEach((function($){ae=ae.replace(/%[a-z]/,$)})),ae}var oe=function($){function PolishedError3(W){for(var oe=arguments.length,ae=new Array(oe>1?oe-1:0),ie=1;ie<oe;ie++)ae[ie-1]=arguments[ie];return _assertThisInitialized2($.call(this,format4.apply(void 0,[G[W]].concat(ae)))||this)}return function _inheritsLoose2($,W){$.prototype=Object.create(W.prototype),$.prototype.constructor=$,_setPrototypeOf2($,W)}(PolishedError3,$),PolishedError3}(_wrapNativeSuper2(Error));$.default=oe,W.exports=$.default}}),$e=__commonJS({"../node_modules/polished/lib/color/parseToRgb.js"($,W){$.__esModule=!0,$.default=function parseToRgb2($){if("string"!=typeof $)throw new ae.default(3);var W=(0,oe.default)($);if(W.match(ie))return{red:parseInt(""+W[1]+W[2],16),green:parseInt(""+W[3]+W[4],16),blue:parseInt(""+W[5]+W[6],16)};if(W.match(se)){var ve=parseFloat((parseInt(""+W[7]+W[8],16)/255).toFixed(2));return{red:parseInt(""+W[1]+W[2],16),green:parseInt(""+W[3]+W[4],16),blue:parseInt(""+W[5]+W[6],16),alpha:ve}}if(W.match(le))return{red:parseInt(""+W[1]+W[1],16),green:parseInt(""+W[2]+W[2],16),blue:parseInt(""+W[3]+W[3],16)};if(W.match(ue)){var we=parseFloat((parseInt(""+W[4]+W[4],16)/255).toFixed(2));return{red:parseInt(""+W[1]+W[1],16),green:parseInt(""+W[2]+W[2],16),blue:parseInt(""+W[3]+W[3],16),alpha:we}}var Se=de.exec(W);if(Se)return{red:parseInt(""+Se[1],10),green:parseInt(""+Se[2],10),blue:parseInt(""+Se[3],10)};var Pe=pe.exec(W.substring(0,50));if(Pe)return{red:parseInt(""+Pe[1],10),green:parseInt(""+Pe[2],10),blue:parseInt(""+Pe[3],10),alpha:parseFloat(""+Pe[4])};var je=he.exec(W);if(je){var Ie=parseInt(""+je[1],10),De=parseInt(""+je[2],10)/100,$e=parseInt(""+je[3],10)/100,Le="rgb("+(0,G.default)(Ie,De,$e)+")",Ke=de.exec(Le);if(!Ke)throw new ae.default(4,W,Le);return{red:parseInt(""+Ke[1],10),green:parseInt(""+Ke[2],10),blue:parseInt(""+Ke[3],10)}}var Ge=ge.exec(W.substring(0,50));if(Ge){var Xe=parseInt(""+Ge[1],10),Ye=parseInt(""+Ge[2],10)/100,Je=parseInt(""+Ge[3],10)/100,Qe="rgb("+(0,G.default)(Xe,Ye,Je)+")",Ze=de.exec(Qe);if(!Ze)throw new ae.default(4,W,Qe);return{red:parseInt(""+Ze[1],10),green:parseInt(""+Ze[2],10),blue:parseInt(""+Ze[3],10),alpha:parseFloat(""+Ge[4])}}throw new ae.default(5)};var G=_interopRequireDefault(je()),oe=_interopRequireDefault(Ie()),ae=_interopRequireDefault(De());function _interopRequireDefault($){return $&&$.__esModule?$:{default:$}}var ie=/^#[a-fA-F0-9]{6}$/,se=/^#[a-fA-F0-9]{8}$/,le=/^#[a-fA-F0-9]{3}$/,ue=/^#[a-fA-F0-9]{4}$/,de=/^rgb\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*\)$/i,pe=/^rgba\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*([-+]?[0-9]*[.]?[0-9]+)\s*\)$/i,he=/^hsl\(\s*(\d{0,3}[.]?[0-9]+)\s*,\s*(\d{1,3}[.]?[0-9]?)%\s*,\s*(\d{1,3}[.]?[0-9]?)%\s*\)$/i,ge=/^hsla\(\s*(\d{0,3}[.]?[0-9]+)\s*,\s*(\d{1,3}[.]?[0-9]?)%\s*,\s*(\d{1,3}[.]?[0-9]?)%\s*,\s*([-+]?[0-9]*[.]?[0-9]+)\s*\)$/i;W.exports=$.default}}),Le=__commonJS({"../node_modules/polished/lib/internalHelpers/_reduceHexValue.js"($,W){$.__esModule=!0,$.default=void 0;var G=function reduceHexValue4($){return 7===$.length&&$[1]===$[2]&&$[3]===$[4]&&$[5]===$[6]?"#"+$[1]+$[3]+$[5]:$};$.default=G,W.exports=$.default}}),Ke=__commonJS({"../node_modules/polished/lib/internalHelpers/_numberToHex.js"($,W){$.__esModule=!0,$.default=void 0;var G=function numberToHex2($){var W=$.toString(16);return 1===W.length?"0"+W:W};$.default=G,W.exports=$.default}}),Ge=__commonJS({"../node_modules/polished/lib/color/rgb.js"($,W){$.__esModule=!0,$.default=function rgb2($,W,ie){if("number"==typeof $&&"number"==typeof W&&"number"==typeof ie)return(0,G.default)("#"+(0,oe.default)($)+(0,oe.default)(W)+(0,oe.default)(ie));if("object"==typeof $&&void 0===W&&void 0===ie)return(0,G.default)("#"+(0,oe.default)($.red)+(0,oe.default)($.green)+(0,oe.default)($.blue));throw new ae.default(6)};var G=_interopRequireDefault(Le()),oe=_interopRequireDefault(Ke()),ae=_interopRequireDefault(De());function _interopRequireDefault($){return $&&$.__esModule?$:{default:$}}W.exports=$.default}}),Xe=__commonJS({"../node_modules/polished/lib/color/rgba.js"($,W){$.__esModule=!0,$.default=function rgba2($,W,ie,se){if("string"==typeof $&&"number"==typeof W){var le=(0,G.default)($);return"rgba("+le.red+","+le.green+","+le.blue+","+W+")"}if("number"==typeof $&&"number"==typeof W&&"number"==typeof ie&&"number"==typeof se)return se>=1?(0,oe.default)($,W,ie):"rgba("+$+","+W+","+ie+","+se+")";if("object"==typeof $&&void 0===W&&void 0===ie&&void 0===se)return $.alpha>=1?(0,oe.default)($.red,$.green,$.blue):"rgba("+$.red+","+$.green+","+$.blue+","+$.alpha+")";throw new ae.default(7)};var G=_interopRequireDefault($e()),oe=_interopRequireDefault(Ge()),ae=_interopRequireDefault(De());function _interopRequireDefault($){return $&&$.__esModule?$:{default:$}}W.exports=$.default}}),Ye=__commonJS({"../node_modules/polished/lib/color/transparentize.js"($,W){$.__esModule=!0,$.default=void 0;var G=_interopRequireDefault(Se()),oe=_interopRequireDefault(Pe()),ae=_interopRequireDefault(Xe()),ie=_interopRequireDefault($e());function _interopRequireDefault($){return $&&$.__esModule?$:{default:$}}function _extends2(){return _extends2=Object.assign||function($){for(var W=1;W<arguments.length;W++){var G=arguments[W];for(var oe in G)Object.prototype.hasOwnProperty.call(G,oe)&&($[oe]=G[oe])}return $},_extends2.apply(this,arguments)}function transparentize3($,W){if("transparent"===W)return W;var G=(0,ie.default)(W),se="number"==typeof G.alpha?G.alpha:1,le=_extends2({},G,{alpha:(0,oe.default)(0,1,+(100*se-100*parseFloat($)).toFixed(2)/100)});return(0,ae.default)(le)}var se=(0,G.default)(transparentize3);$.default=se,W.exports=$.default}}),Je=__commonJS({"../node_modules/react-error-boundary/dist/react-error-boundary.umd.js"($,W){var G,oe;G=$,oe=function($,W){function _interopNamespace($){if($&&$.__esModule)return $;var W=Object.create(null);return $&&Object.keys($).forEach((function(G){if("default"!==G){var oe=Object.getOwnPropertyDescriptor($,G);Object.defineProperty(W,G,oe.get?oe:{enumerable:!0,get:function(){return $[G]}})}})),W.default=$,Object.freeze(W)}var G=_interopNamespace(W);function _setPrototypeOf2($,W){return(_setPrototypeOf2=Object.setPrototypeOf||function _setPrototypeOf3($,W){return $.__proto__=W,$})($,W)}var oe={error:null},ae=function($){function ErrorBoundary3(){for(var W,G=arguments.length,ae=new Array(G),ie=0;ie<G;ie++)ae[ie]=arguments[ie];return(W=$.call.apply($,[this].concat(ae))||this).state=oe,W.updatedWithError=!1,W.resetErrorBoundary=function(){for(var $,G=arguments.length,oe=new Array(G),ae=0;ae<G;ae++)oe[ae]=arguments[ae];null==W.props.onReset||($=W.props).onReset.apply($,oe),W.reset()},W}!function _inheritsLoose2($,W){$.prototype=Object.create(W.prototype),$.prototype.constructor=$,_setPrototypeOf2($,W)}(ErrorBoundary3,$),ErrorBoundary3.getDerivedStateFromError=function getDerivedStateFromError($){return{error:$}};var W=ErrorBoundary3.prototype;return W.reset=function reset(){this.updatedWithError=!1,this.setState(oe)},W.componentDidCatch=function componentDidCatch($,W){var G,oe;null==(G=(oe=this.props).onError)||G.call(oe,$,W)},W.componentDidMount=function componentDidMount(){null!==this.state.error&&(this.updatedWithError=!0)},W.componentDidUpdate=function componentDidUpdate($){var W,G,oe=this.state.error,ae=this.props.resetKeys;null===oe||this.updatedWithError?null!==oe&&function changedArray2($,W){return void 0===$&&($=[]),void 0===W&&(W=[]),$.length!==W.length||$.some((function($,G){return!Object.is($,W[G])}))}($.resetKeys,ae)&&(null==(W=(G=this.props).onResetKeysChange)||W.call(G,$.resetKeys,ae),this.reset()):this.updatedWithError=!0},W.render=function render(){var $=this.state.error,W=this.props,oe=W.fallbackRender,ae=W.FallbackComponent,ie=W.fallback;if(null!==$){var se={error:$,resetErrorBoundary:this.resetErrorBoundary};if(G.isValidElement(ie))return ie;if("function"==typeof oe)return oe(se);if(ae)return G.createElement(ae,se);throw new Error("react-error-boundary requires either a fallback, fallbackRender, or FallbackComponent prop")}return this.props.children},ErrorBoundary3}(G.Component);$.ErrorBoundary=ae,$.useErrorHandler=function useErrorHandler($){var W=G.useState(null),oe=W[0],ae=W[1];if(null!=$)throw $;if(null!=oe)throw oe;return ae},$.withErrorBoundary=function withErrorBoundary($,W){var oe=function Wrapped2(oe){return G.createElement(ae,W,G.createElement($,oe))},ie=$.displayName||$.name||"Unknown";return oe.displayName="withErrorBoundary("+ie+")",oe},Object.defineProperty($,"__esModule",{value:!0})},"object"==typeof $&&void 0!==W?oe($,vt.exports):oe((G="undefined"!=typeof globalThis?globalThis:G||self).ReactErrorBoundary={},G.React)}}),Qe=__commonJS({"../node_modules/jiff/lib/lcs.js"($){function backtrack($,W,G,oe,ae,ie){return W[ae+oe]===G[ie+oe]?{value:$[ie+1][ae+1].value,type:0}:$[ie][ae+1].value<$[ie+1][ae].value?{value:$[ie][ae+1].value+1,type:-1}:{value:$[ie+1][ae].value+1,type:1}}$.compare=function compare($,W){for(var G=$.length,oe=W.length,ae=function findPrefix($,W){var G=0,oe=Math.min($.length,W.length);for(;G<oe&&$[G]===W[G];)++G;return G}($,W),ie=ae<G&&ae<oe?function findSuffix($,W){var G=$.length-1,oe=W.length-1,ae=Math.min(G,oe),ie=0;for(;ie<ae&&$[G-ie]===W[oe-ie];)++ie;return ie}($,W):0,se=ie+ae-1,le=function createMatrix($,W){var G,oe,ae,ie=[];for(ae=ie[W]=[],oe=0;oe<$;++oe)ae[oe]={value:$-oe,type:-1};for(G=0;G<W;++G)ie[G]=[],ie[G][$]={value:W-G,type:1};return ie[W][$]={value:0,type:0},ie}(G-=se,oe-=se),ue=G-1;ue>=0;--ue)for(var de=oe-1;de>=0;--de)le[de][ue]=backtrack(le,$,W,ae,ue,de);return{prefix:ae,matrix:le,suffix:ie}},$.reduce=function reduce($,W,G){var oe,ae,ie,se,le=G.matrix,ue=G.prefix;for(oe=0;oe<ue;++oe)W=$(W,0,oe,oe);ie=oe,ue=le.length,oe=0,ae=0;for(;oe<ue;)switch(se=le[oe][ae].type,W=$(W,se,oe+ie,ae+ie),se){case 0:++oe,++ae;break;case-1:++ae;break;case 1:++oe}for(oe+=ie,ae+=ie,ue=G.suffix,ie=0;ie<ue;++ie)W=$(W,0,oe+ie,ae+ie);return W},$.REMOVE=-1,$.ADD=1,$.EQUAL=0}}),Ze=__commonJS({"../node_modules/jiff/lib/array.js"($){$.cons=function cons($,W){var G=W.length,oe=new Array(G+1);oe[0]=$;for(var ae=0;ae<G;++ae)oe[ae+1]=W[ae];return oe},$.tail=function tail($){for(var W=$.length-1,G=new Array(W),oe=0;oe<W;++oe)G[oe]=$[oe+1];return G},$.map=function map($,W){for(var G=new Array(W.length),oe=0;oe<W.length;++oe)G[oe]=$(W[oe]);return G}}}),et=__commonJS({"../node_modules/jiff/lib/jsonPointerParse.js"($,W){W.exports=function jsonPointerParse($,W){var oe,ae,ie,se;oe="/"===$.charAt(0)?1:0,ae="",G.lastIndex=oe;for(;ie=G.exec($);)if(se=ie[0],ae+=$.slice(oe,G.lastIndex-se.length),oe=G.lastIndex,"/"===se){if(!1===W(ae))return $;ae=""}else ae+="~1"===se?"/":"~";return ae+=$.slice(oe),W(ae),$};var G=/\/|~1|~0/g}}),tt=__commonJS({"../node_modules/jiff/lib/jsonPointer.js"($){var W=et();$.find=function find($,oe,ae,ie){if("string"!=typeof oe)return;if(""===oe)return{target:$,key:void 0};if(oe===G)return{target:$,key:""};var se,le=$,ue=void 0!==ie;return W(oe,(function(W){if(null==$)return le=null,!1;se=Array.isArray($)?ue?function findIndex2($,W,G,oe){var ae=W;if(ae<0)throw new Error("array index out of bounds "+ae);if(void 0!==oe&&"function"==typeof $&&(ae=$(W,G,oe))<0)throw new Error("could not find patch context "+oe);return ae}(ae,parseArrayIndex(W),$,ie):"-"===W?W:parseArrayIndex(W):W,le=$,$=$[se]})),null===le?void 0:{target:le,key:se}},$.join=function join($){return $.join(G)},$.absolute=function absolute($){return $[0]===G?$:G+$},$.parse=function parse($){var G=[];return W($,G.push.bind(G)),G},$.contains=function contains2($,W){return 0===W.indexOf($)&&W[$.length]===G},$.encodeSegment=function encodeSegment($){return $.replace(ie,"~0").replace(oe,"~1")},$.decodeSegment=function decodeSegment($){return $.replace(ae,G).replace(se,"~")},$.parseArrayIndex=parseArrayIndex,$.isValidArrayIndex=isValidArrayIndex;var G="/",oe=/\//g,ae=/~1/g,ie=/~/g,se=/~0/g;var le=/^(0|[1-9]\d*)$/;function isValidArrayIndex($){return le.test($)}function parseArrayIndex($){if(isValidArrayIndex($))return+$;throw new SyntaxError("invalid array index "+$)}}}),rt=__commonJS({"../node_modules/jiff/lib/clone.js"($,W){function clone($){return null==$||"object"!=typeof $?$:Array.isArray($)?function cloneArray($){for(var W=$.length,G=new Array(W),oe=0;oe<W;++oe)G[oe]=clone($[oe]);return G}($):function cloneObject($){for(var W,G=Object.keys($),oe={},ae=0,ie=G.length;ae<ie;++ae)oe[W=G[ae]]=clone($[W]);return oe}($)}W.exports=clone}}),nt=__commonJS({"../node_modules/jiff/lib/deepEquals.js"($,W){function deepEquals($,W){return $===W||(Array.isArray($)&&Array.isArray(W)?function compareArrays($,W){if($.length!==W.length)return!1;for(var G=0;G<$.length;++G)if(!deepEquals($[G],W[G]))return!1;return!0}($,W):"object"==typeof $&&"object"==typeof W&&function compareObjects($,W){if(null===$&&null!==W||null!==$&&null===W)return!1;var G=Object.keys($),oe=Object.keys(W);if(G.length!==oe.length)return!1;for(var ae,ie=0;ie<G.length;++ie)if(!((ae=G[ie])in W)||!deepEquals($[ae],W[ae]))return!1;return!0}($,W))}W.exports=deepEquals}}),ot=__commonJS({"../node_modules/jiff/lib/commutePaths.js"($,W){var G=tt();function commuteArrayAncestor($,W,G,oe,ae){var ie=W.length-1,se=+W[ie],le=+oe[ie],ue=oe.slice();return se>le||("add"===$.op||"copy"===$.op?ue[ie]=Math.max(0,le-ae):"remove"===$.op&&(ue[ie]=Math.max(0,le+ae))),ue}function copyPatch($){return"remove"===$.op?{op:$.op,path:$.path}:"copy"===$.op||"move"===$.op?{op:$.op,path:$.path,from:$.from}:{op:$.op,path:$.path,value:$.value}}W.exports=function commutePaths($,W){var oe=G.parse($.path),ae=G.parse(W.path),ie=function getCommonPathPrefix($,W){var G=$.length,oe=W.length;if(0===G||0===oe||G<2&&oe<2)return[];var ae=G===oe?G-1:Math.min(G,oe),ie=0;for(;ie<ae&&$[ie]===W[ie];)++ie;return $.slice(0,ie)}(oe,ae),se=function isArrayPath($,W,oe){return G.isValidArrayIndex($[oe])&&G.isValidArrayIndex(W[oe])}(oe,ae,ie.length),le=copyPatch($),ue=copyPatch(W);return 0!==ie.length||se?se?function commuteArrayPaths($,W,oe,ae){if(W.length===ae.length)return function commuteArraySiblings($,W,oe,ae){var ie,se=W.length-1,le=+W[se],ue=+ae[se];le<ue?"add"===$.op||"copy"===$.op?((ie=ae.slice())[se]=Math.max(0,ue-1),oe.path=G.absolute(G.join(ie))):"remove"===$.op&&((ie=ae.slice())[se]=ue+1,oe.path=G.absolute(G.join(ie))):"add"===oe.op||"copy"===oe.op?((ie=W.slice())[se]=le+1,$.path=G.absolute(G.join(ie))):le>ue&&"remove"===oe.op&&((ie=W.slice())[se]=Math.max(0,le-1),$.path=G.absolute(G.join(ie)));return[oe,$]}($,W,oe,ae);W.length>ae.length?(W=commuteArrayAncestor(oe,ae,$,W,-1),$.path=G.absolute(G.join(W))):(ae=commuteArrayAncestor($,W,oe,ae,1),oe.path=G.absolute(G.join(ae)));return[oe,$]}(le,oe,ue,ae):function commuteTreePaths($,W,G,oe){if($.path===G.path)throw new TypeError("cannot commute "+$.op+","+G.op+" with identical object paths");return[G,$]}(le,0,ue):[ue,le]}}}),at=__commonJS({"../node_modules/jiff/lib/TestFailedError.js"($,W){function TestFailedError($){Error.call(this),this.name=this.constructor.name,this.message=$,"function"==typeof Error.captureStackTrace&&Error.captureStackTrace(this,this.constructor)}W.exports=TestFailedError,TestFailedError.prototype=Object.create(Error.prototype),TestFailedError.prototype.constructor=TestFailedError}}),it=__commonJS({"../node_modules/jiff/lib/InvalidPatchOperationError.js"($,W){function InvalidPatchOperationError($){Error.call(this),this.name=this.constructor.name,this.message=$,"function"==typeof Error.captureStackTrace&&Error.captureStackTrace(this,this.constructor)}W.exports=InvalidPatchOperationError,InvalidPatchOperationError.prototype=Object.create(Error.prototype),InvalidPatchOperationError.prototype.constructor=InvalidPatchOperationError}}),st=__commonJS({"../node_modules/jiff/lib/PatchNotInvertibleError.js"($,W){function PatchNotInvertibleError($){Error.call(this),this.name=this.constructor.name,this.message=$,"function"==typeof Error.captureStackTrace&&Error.captureStackTrace(this,this.constructor)}W.exports=PatchNotInvertibleError,PatchNotInvertibleError.prototype=Object.create(Error.prototype),PatchNotInvertibleError.prototype.constructor=PatchNotInvertibleError}}),lt=__commonJS({"../node_modules/jiff/lib/patches.js"($){var W=tt(),G=rt(),oe=nt(),ae=ot(),ie=Ze(),se=at(),le=it(),ue=st(),de=W.find,pe=W.parseArrayIndex;function _add($,W){var G=$.target;if(Array.isArray(G))if("-"===$.key)G.push(W);else{if($.key>G.length)throw new le("target of add outside of array bounds");G.splice($.key,0,W)}else{if(!isValidObject(G))throw new le("target of add must be an object or array "+$.key);G[$.key]=W}}function commuteAddOrCopy($,W){if($.path===W.path&&"remove"===W.op)throw new TypeError("Can't commute add,remove -> remove,add for same path");return ae($,W)}function _remove($){var W,G=$.target;if(Array.isArray(G))return(W=G.splice(pe($.key),1))[0];if(isValidObject(G))return W=G[$.key],delete G[$.key],W;throw new le("target of remove must be an object or array")}function notFound($){return void 0===$||null==$.target&&void 0!==$.key}function missingValue($){return void 0!==$.key&&void 0===$.target[$.key]}function isValidObject($){return null!==$&&"object"==typeof $}$.test={apply:function applyTest($,W,G){var ae,ie,le=de($,W.path,G.findContext,W.context),ue=le.target;Array.isArray(ue)?(ae=pe(le.key),ie=ue[ae]):ie=void 0===le.key?le.target:le.target[le.key];if(!oe(ie,W.value))throw new se("test failed "+JSON.stringify(W));return $},inverse:function invertTest($,W){return $.push(W),1},commute:function commuteTest($,W){if($.path===W.path&&"remove"===W.op)throw new TypeError("Can't commute test,remove -> remove,test for same path");if("test"===W.op||"replace"===W.op)return[W,$];return ae($,W)}},$.add={apply:function applyAdd($,W,oe){var ae=de($,W.path,oe.findContext,W.context);if(notFound(ae))throw new le("path does not exist "+W.path);if(void 0===W.value)throw new le("missing value");var ie=G(W.value);if(void 0===ae.key)return ie;return _add(ae,ie),$},inverse:function invertAdd($,W){var G=W.context;void 0!==G&&(G={before:G.before,after:ie.cons(W.value,G.after)});return $.push({op:"test",path:W.path,value:W.value,context:G}),$.push({op:"remove",path:W.path,context:G}),1},commute:commuteAddOrCopy},$.remove={apply:function applyRemove($,W,G){var oe=de($,W.path,G.findContext,W.context);if(notFound(oe)||void 0===oe.target[oe.key])throw new le("path does not exist "+W.path);return _remove(oe),$},inverse:function invertRemove($,W,G,oe){var ae=oe[G-1];if(void 0===ae||"test"!==ae.op||ae.path!==W.path)throw new ue("cannot invert remove w/o test");var se=ae.context;void 0!==se&&(se={before:se.before,after:ie.tail(se.after)});return $.push({op:"add",path:ae.path,value:ae.value,context:se}),2},commute:function commuteRemove($,W){if($.path===W.path&&"remove"===W.op)return[W,$];return ae($,W)}},$.replace={apply:function applyReplace($,W,oe){var ae=de($,W.path,oe.findContext,W.context);if(notFound(ae)||missingValue(ae))throw new le("path does not exist "+W.path);if(void 0===W.value)throw new le("missing value");var ie=G(W.value);if(void 0===ae.key)return ie;var se=ae.target;Array.isArray(se)?se[pe(ae.key)]=ie:se[ae.key]=ie;return $},inverse:function invertReplace($,W,G,oe){var ae=oe[G-1];if(void 0===ae||"test"!==ae.op||ae.path!==W.path)throw new ue("cannot invert replace w/o test");var se=ae.context;void 0!==se&&(se={before:se.before,after:ie.cons(ae.value,ie.tail(se.after))});return $.push({op:"test",path:ae.path,value:W.value}),$.push({op:"replace",path:ae.path,value:ae.value}),2},commute:function commuteReplace($,W){if($.path===W.path&&"remove"===W.op)throw new TypeError("Can't commute replace,remove -> remove,replace for same path");if("test"===W.op||"replace"===W.op)return[W,$];return ae($,W)}},$.move={apply:function applyMove($,G,oe){if(W.contains(G.path,G.from))throw new le("move.from cannot be ancestor of move.path");var ae=de($,G.path,oe.findContext,G.context),ie=de($,G.from,oe.findContext,G.fromContext);return _add(ae,_remove(ie)),$},inverse:function invertMove($,W){return $.push({op:"move",path:W.from,context:W.fromContext,from:W.path,fromContext:W.context}),1},commute:function commuteMove($,W){if($.path===W.path&&"remove"===W.op)throw new TypeError("Can't commute move,remove -> move,replace for same path");return ae($,W)}},$.copy={apply:function applyCopy($,W,oe){var ae=de($,W.path,oe.findContext,W.context),ie=de($,W.from,oe.findContext,W.fromContext);if(notFound(ie)||missingValue(ie))throw new le("copy.from must exist");var se,ue=ie.target;se=Array.isArray(ue)?ue[pe(ie.key)]:ue[ie.key];return _add(ae,G(se)),$},inverse:function notInvertible($,W){throw new ue("cannot invert "+W.op)},commute:commuteAddOrCopy}}}),ut=__commonJS({"../node_modules/jiff/lib/jsonPatch.js"($){var W=lt(),G=rt(),oe=it();$.apply=function patch2($,W,oe){return patchInPlace($,G(W),oe)},$.applyInPlace=patchInPlace,$.clone=G,$.isValidObject=isValidObject,$.defaultHash=function defaultHash($){return isValidObject($)||function isArray2($){return"[object Array]"===Object.prototype.toString.call($)}($)?JSON.stringify($):$};var ae={};function patchInPlace($,G,ie){if(ie||(ie=ae),!Array.isArray($))return G;for(var se,le,ue=0;ue<$.length;++ue){if(le=$[ue],void 0===(se=W[le.op]))throw new oe("invalid op "+JSON.stringify(le));G=se.apply(G,le,ie)}return G}function isValidObject($){return null!==$&&"[object Object]"===Object.prototype.toString.call($)}}}),ct=__commonJS({"../node_modules/jiff/lib/inverse.js"($,W){var G=lt();function invertOp($,W,oe,ae){var ie=G[W.op];return void 0!==ie&&"function"==typeof ie.inverse?ie.inverse($,W,oe,ae):1}W.exports=function inverse($){var W,G,oe=[];for(W=$.length-1;W>=0;W-=G)G=invertOp(oe,$[W],W,$);return oe}}}),dt=__commonJS({"../node_modules/jiff/jiff.js"($){var W=Qe(),G=Ze(),oe=ut(),ae=ct(),ie=tt().encodeSegment;$.diff=function diff($,W,G){return appendChanges($,W,"",function initState($,W){return"object"==typeof $?{patch:W,hash:orElse(isFunction2,$.hash,le),makeContext:orElse(isFunction2,$.makeContext,defaultContext),invertible:!(!1===$.invertible)}:{patch:W,hash:orElse(isFunction2,$,le),makeContext:defaultContext,invertible:!0}}(G,[])).patch},$.patch=oe.apply,$.patchInPlace=oe.applyInPlace,$.inverse=ae,$.clone=oe.clone,$.InvalidPatchOperationError=it(),$.TestFailedError=at(),$.PatchNotInvertibleError=st();var se=oe.isValidObject,le=oe.defaultHash;function appendChanges($,oe,ae,le){return Array.isArray($)&&Array.isArray(oe)?function appendArrayChanges($,oe,ae,ie){var se=G.map(ie.hash,$),le=G.map(ie.hash,oe),ue=W.compare(se,le);return function lcsToJsonPatch($,G,oe,ae,ie){var se=0;return W.reduce((function(ae,ie,le,ue){var de,pe,he=ae.patch,ge=oe+"/"+(ue+se);return ie===W.REMOVE?(de=he[he.length-1],pe=ae.makeContext(ue,$),ae.invertible&&he.push({op:"test",path:ge,value:$[ue],context:pe}),void 0!==de&&"add"===de.op&&de.path===ge?(de.op="replace",de.context=pe):he.push({op:"remove",path:ge,context:pe}),se-=1):ie===W.ADD?(he.push({op:"add",path:ge,value:G[le],context:ae.makeContext(ue,$)}),se+=1):appendChanges($[ue],G[le],ge,ae),ae}),ae,ie)}($,oe,ae,ie,ue)}($,oe,ae,le):se($)&&se(oe)?function appendObjectChanges($,W,G,oe){var ae,se,le=Object.keys(W),ue=oe.patch;for(ae=le.length-1;ae>=0;--ae){se=le[ae];var de=G+"/"+ie(se);void 0!==$[se]?appendChanges($[se],W[se],de,oe):ue.push({op:"add",path:de,value:W[se]})}for(le=Object.keys($),ae=le.length-1;ae>=0;--ae)if(void 0===W[se=le[ae]]){var pe=G+"/"+ie(se);oe.invertible&&ue.push({op:"test",path:pe,value:$[se]}),ue.push({op:"remove",path:pe})}return oe}($,oe,ae,le):function appendValueChanges($,W,G,oe){$!==W&&(oe.invertible&&oe.patch.push({op:"test",path:G,value:$}),oe.patch.push({op:"replace",path:G,value:W}));return oe}($,oe,ae,le)}function orElse($,W,G){return $(W)?W:G}function defaultContext(){}function isFunction2($){return"function"==typeof $}}}),ft=__commonJS({"../node_modules/json-touch-patch/lib/utils/pluck.js"($,W){W.exports=function pluck($,W){for(var G=0,oe=W.length-1;G<oe;G++){if(!$[W[G]])return null;$=$[W[G]]}return $}}}),pt=__commonJS({"../node_modules/json-touch-patch/lib/utils/toKeys.js"($,W){function esc($){return"~0"===$?"~":"/"}W.exports=function toKeys($){var W=$.split("/");if(-1===$.indexOf("~"))return W;for(var G=0,oe=W.length;G<oe;G++)-1!==W[G].indexOf("~")&&(W[G]=W[G].replace(/~[01]/g,esc));return W}}}),ht=__commonJS({"../node_modules/json-touch-patch/lib/get.js"($,W){var G=ft(),oe=pt();W.exports=function get2($,W){var ae=oe(W),ie=ae[ae.length-1],se=G($,ae);return se?se[ie]:void 0}}}),mt=__commonJS({"../node_modules/json-touch-patch/lib/utils/deepEqual.js"($,W){W.exports=function deepEqual($,W){if($===W)return!0;if(!$||!W||"object"!=typeof $||"object"!=typeof W)return!1;if($.length!==W.length)return!1;if(Array.isArray($)){if(!Array.isArray(W))return!1;for(var G=0,oe=$.length;G<oe;G++)if(!deepEqual($[G],W[G]))return!1;return!0}var ae=Object.keys($);if(ae.length!==Object.keys(W).length)return!1;for(var ie=0,se=ae.length;ie<se;ie++){var le=ae[ie];if(!deepEqual($[le],W[le]))return!1}return!0}}}),gt=__commonJS({"../node_modules/json-touch-patch/lib/utils/toArrayIndex.js"($,W){W.exports=function toArrayIndex($,W){if("-"===W)return $.length;for(var G=0,oe=W.length;G<oe;G++){var ae=W.charCodeAt(G);if(57<ae||ae<48)return 1/0}return+W}}}),yt=__commonJS({"../node_modules/json-touch-patch/lib/add.js"($,W){var G=mt(),oe=ft(),ae=gt(),ie=pt();W.exports=function add($,W,se,le){if(void 0===se)return"[op:add] require value, but got undefined";var ue=ie(W),de=ue[ue.length-1],pe=oe($,ue);if(null===pe)return"[op:add] path not found: "+W;if(Array.isArray(pe)){var he=ae(pe,de);if(pe.length<he)return"[op:add] invalid array index: "+W;le($,ue).splice(he,0,se)}else G(pe[de],se)||(le($,ue)[de]=se)}}}),bt=__commonJS({"../node_modules/json-touch-patch/lib/remove.js"($,W){var G=ft(),oe=gt(),ae=pt();W.exports=function remove($,W,ie){var se=ae(W),le=se[se.length-1],ue=G($,se);if(null===ue)return"[op:remove] path not found: "+W;if(Array.isArray(ue)){var de=oe(ue,le);if(ue.length<=de)return"[op:remove] invalid array index: "+W;ie($,se).splice(de,1)}else delete ie($,se)[le]}}}),wt=__commonJS({"../node_modules/json-touch-patch/lib/replace.js"($,W){var G=mt(),oe=ft(),ae=gt(),ie=pt();W.exports=function replace($,W,se,le){if(void 0===se)return"[op:replace] require value, but got undefined";var ue=ie(W),de=ue[ue.length-1],pe=oe($,ue);if(null===pe)return"[op:replace] path not found: "+W;if(Array.isArray(pe)){var he=ae(pe,de);if(pe.length<=he)return"[op:replace] invalid array index: "+W;G(pe[he],se)||le($,ue).splice(he,1,se)}else G(pe[de],se)||(le($,ue)[de]=se)}}}),St=__commonJS({"../node_modules/json-touch-patch/lib/move.js"($,W){var G=yt(),oe=ft(),ae=gt(),ie=pt();W.exports=function move($,W,se,le){if(se!==W){var ue=ie(W),de=ue[ue.length-1],pe=oe($,ue);if(null===pe)return"[op:move] path not found: "+W;var he=void 0;if(Array.isArray(pe)){var ge=ae(pe,de);if(pe.length<=ge)return"[op:move] invalid array index: "+se;he=pe[ge],le($,ue).splice(ge,1)}else he=pe[de],delete le($,ue)[de];return G($,se,he,le)}}}}),xt=__commonJS({"../node_modules/json-touch-patch/lib/copy.js"($,W){var G=ft(),oe=pt(),ae=yt();W.exports=function copy($,W,ie,se){var le=oe(W),ue=le[le.length-1],de=G($,le);return null===de?"[op:copy] path not found: "+W:ae($,ie,de[ue],se)}}}),kt=__commonJS({"../node_modules/json-touch-patch/lib/test.js"($,W){var G=mt(),oe=ft(),ae=pt();W.exports=function test($,W,ie){var se=ae(W),le=se[se.length-1],ue=oe($,se);return null===ue?"[op:test] path not found: "+W:G(ue[le],ie)?void 0:"[op:test] not matched: "+JSON.stringify(ue[le])+" "+JSON.stringify(ie)}}}),_t=__commonJS({"../node_modules/json-touch-patch/lib/utils/shallowCopy.js"($,W){W.exports=function shallowCopy($){if(!$||"object"!=typeof $)return $;if(Array.isArray($)){for(var W=$.length,G=new Array(W),oe=0;oe<W;oe++)G[oe]=$[oe];return G}for(var ae=Object.keys($),ie={},se=0,le=ae.length;se<le;se++){var ue=ae[se];ie[ue]=$[ue]}return ie}}}),Pt=__commonJS({"../node_modules/json-touch-patch/lib/utils/createAPI.js"($,W){var G=ht(),oe=yt(),ae=bt(),ie=wt(),se=St(),le=xt(),ue=kt(),de=mt(),pe=_t(),he=pt();W.exports=function createAPI($,W){return{get:function(W){return G($,W)},add:function(G,ae){return oe($,G,ae,W)},remove:function(G){return ae($,G,W)},replace:function(G,oe){return ie($,G,oe,W)},move:function(G,oe){return se($,G,oe,W)},copy:function(G,oe){return le($,G,oe,W)},test:function(W,G){return ue($,W,G)},deepEqual:de,shallowCopy:pe,toKeys:he}}}}),Et=__commonJS({"../node_modules/json-touch-patch/lib/utils/exit.js"($,W){W.exports=function exit($,W,G,oe){return oe.error=G,oe.partial?W[""]:$}}}),jt=__commonJS({"../node_modules/json-touch-patch/lib/utils/toBoolean.js"($,W){W.exports=function toBoolean($){return!!$}}}),Ct=__commonJS({"../node_modules/json-touch-patch/lib/utils/throwException.js"($,W){W.exports=function throwException($){if($)throw new TypeError($)}}}),Ot=__commonJS({"../node_modules/json-touch-patch/lib/utils/pluckWithShallowCopy.js"($,W){var G=_t();W.exports=function pluckWithShallowCopy($,W){for(var oe=0,ae=W.length-1;oe<ae;oe++)$=$[W[oe]]=G($[W[oe]]);return $}}}),It=__commonJS({"../node_modules/json-touch-patch/lib/utils/pluckWithCachedShallowCopy.js"($,W){var G=_t();function fetch($,W,oe){var ae=$[W];return oe.has(ae)||(ae=G(ae),oe.add(ae)),ae}W.exports=function pluckWithCachedShallowCopy($,W,G){for(var oe=0,ae=W.length-1;oe<ae;oe++)$=$[W[oe]]=fetch($,W[oe],G);return $}}}),Tt=__commonJS({"../node_modules/json-touch-patch/lib/patch.js"($,W){var G=Pt(),oe=Et(),ae=jt(),ie=Ct(),se=Ot(),le=It(),ue=yt(),de=bt(),pe=wt(),he=St(),ge=xt(),ve=kt(),we=window.Set||function(){var $=[];return $.has=function($){return-1!==this.indexOf($)},$.add=function($){this.push($)},$};W.exports=function patchFn($,W,Se){if(0===W.length)return $;for(var Pe,je,Ie=(Se=Se||{}).strict?ie:ae,De=1===W.length?se:(Pe=new we,function($,W){return le($,W,Pe)}),$e={"":$},Le=0,Ke=W.length;Le<Ke;Le++){var Ge=W[Le];switch(Ge.op){case"add":if(Ie(ue($e,""+Ge.path,Ge.value,De)))return oe($,$e,Ge,Se);break;case"remove":if(Ie(de($e,""+Ge.path,De)))return oe($,$e,Ge,Se);break;case"replace":if(Ie(pe($e,""+Ge.path,Ge.value,De)))return oe($,$e,Ge,Se);break;case"move":if(Ie(he($e,""+Ge.from,""+Ge.path,De)))return oe($,$e,Ge,Se);break;case"copy":if(Ie(ge($e,""+Ge.from,""+Ge.path,De)))return oe($,$e,Ge,Se);break;case"test":if(Ie(ve($e,""+Ge.path,Ge.value)))return oe($,$e,Ge,Se);break;default:if(!Se.custom||!Se.custom[Ge.op])return Ie("[op:"+Ge.op+"] unknown"),oe($,$e,Ge,Se);if(je=je||G($e,De),Ie(Se.custom[Ge.op](je,Ge,Le,W)))return oe($,$e,Ge,Se)}}return $e[""]}}}),Dt=__commonJS({"../node_modules/json-touch-patch/lib/index.js"($,W){W.exports=Tt()}});function getStudio(){return oe}function forEachDeep($,W,G=[]){if("object"==typeof $&&$)for(const[oe,ae]of Object.entries($))forEachDeep(ae,W,[...G,oe]);else{if(null==$)return;W($,G)}}(($,W)=>{for(var G in __markAsModule($),W)ie($,G,{get:W[G],enumerable:!0})})(G,{ToolbarDropdownSelect:()=>ToolbarDropdownSelect_default,ToolbarIconButton:()=>Qc,ToolbarSwitchSelect:()=>ToolbarSwitchSelect_default,default:()=>ix});var At=__toModule(W),$t={log:console.log,warn:console.warn,error:console.error,trace:console.trace},zt=typeAsserter("Theatre_Project"),Mt=typeAsserter("Theatre_Sheet"),Rt=typeAsserter("Theatre_SheetTemplate"),Bt=typeAsserter("Theatre_SheetObject"),Ft=typeAsserter("Theatre_SheetObjectTemplate"),Nt=typeAsserter("Theatre_Sheet_PublicAPI"),Lt=typeAsserter("Theatre_SheetObject_PublicAPI");function typeAsserter($){return W=>"object"==typeof W&&!!W&&W.type===$}var Ht=0,qt=__toModule(W),Ut=__toModule(W),Kt="object"==typeof window&&window&&window.Object===Object&&window,Wt="object"==typeof self&&self&&self.Object===Object&&self,Gt=Kt||Wt||Function("return this")(),Xt=Gt.Symbol,Yt=Object.prototype,Jt=Yt.hasOwnProperty,Qt=Yt.toString,Zt=Xt?Xt.toStringTag:void 0;var er=function getRawTag($){var W=Jt.call($,Zt),G=$[Zt];try{$[Zt]=void 0;var oe=!0}catch($){}var ae=Qt.call($);return oe&&(W?$[Zt]=G:delete $[Zt]),ae},tr=Object.prototype.toString;var rr=function objectToString($){return tr.call($)},nr=Xt?Xt.toStringTag:void 0;var or=function baseGetTag($){return null==$?void 0===$?"[object Undefined]":"[object Null]":nr&&nr in Object($)?er($):rr($)};var ar=function isObjectLike($){return null!=$&&"object"==typeof $};var ir=function isSymbol($){return"symbol"==typeof $||ar($)&&"[object Symbol]"==or($)};var sr=function arrayMap($,W){for(var G=-1,oe=null==$?0:$.length,ae=Array(oe);++G<oe;)ae[G]=W($[G],G,$);return ae},lr=Array.isArray,ur=Xt?Xt.prototype:void 0,cr=ur?ur.toString:void 0;var dr=function baseToString($){if("string"==typeof $)return $;if(lr($))return sr($,baseToString)+"";if(ir($))return cr?cr.call($):"";var W=$+"";return"0"==W&&1/$==-Infinity?"-0":W},fr=/\s/;var pr=function trimmedEndIndex($){for(var W=$.length;W--&&fr.test($.charAt(W)););return W},hr=/^\s+/;var mr=function baseTrim($){return $?$.slice(0,pr($)+1).replace(hr,""):$};var gr=function isObject($){var W=typeof $;return null!=$&&("object"==W||"function"==W)},vr=/^[-+]0x[0-9a-f]+$/i,yr=/^0b[01]+$/i,br=/^0o[0-7]+$/i,wr=parseInt;var Sr=function toNumber($){if("number"==typeof $)return $;if(ir($))return NaN;if(gr($)){var W="function"==typeof $.valueOf?$.valueOf():$;$=gr(W)?W+"":W}if("string"!=typeof $)return 0===$?$:+$;$=mr($);var G=yr.test($);return G||br.test($)?wr($.slice(2),G?2:8):vr.test($)?NaN:+$},xr=1/0;var kr=function toFinite($){return $?($=Sr($))===xr||$===-1/0?17976931348623157e292*($<0?-1:1):$==$?$:0:0===$?$:0};var _r=function toInteger($){var W=kr($),G=W%1;return W==W?G?W-G:W:0};var Pr=function identity($){return $};var Er=function isFunction($){if(!gr($))return!1;var W=or($);return"[object Function]"==W||"[object GeneratorFunction]"==W||"[object AsyncFunction]"==W||"[object Proxy]"==W},jr=Gt["__core-js_shared__"],Cr=function(){var $=/[^.]+$/.exec(jr&&jr.keys&&jr.keys.IE_PROTO||"");return $?"Symbol(src)_1."+$:""}();var Or=function isMasked($){return!!Cr&&Cr in $},Ir=Function.prototype.toString;var Tr=function toSource($){if(null!=$){try{return Ir.call($)}catch($){}try{return $+""}catch($){}}return""},Dr=/^\[object .+?Constructor\]$/,Ar=Function.prototype,$r=Object.prototype,zr=Ar.toString,Mr=$r.hasOwnProperty,Rr=RegExp("^"+zr.call(Mr).replace(/[\\^$.*+?()[\]{}|]/g,"\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g,"$1.*?")+"$");var Br=function baseIsNative($){return!(!gr($)||Or($))&&(Er($)?Rr:Dr).test(Tr($))};var Fr=function getValue($,W){return null==$?void 0:$[W]};var Nr=function getNative($,W){var G=Fr($,W);return Br(G)?G:void 0},Lr=Nr(Gt,"WeakMap");var Hr=function apply($,W,G){switch(G.length){case 0:return $.call(W);case 1:return $.call(W,G[0]);case 2:return $.call(W,G[0],G[1]);case 3:return $.call(W,G[0],G[1],G[2])}return $.apply(W,G)};var Vr=function noop(){};var qr=function copyArray($,W){var G=-1,oe=$.length;for(W||(W=Array(oe));++G<oe;)W[G]=$[G];return W},Ur=Date.now;var Kr=function shortOut($){var W=0,G=0;return function(){var oe=Ur(),ae=16-(oe-G);if(G=oe,ae>0){if(++W>=800)return arguments[0]}else W=0;return $.apply(void 0,arguments)}};var Wr=function constant($){return function(){return $}},Gr=function(){try{var $=Nr(Object,"defineProperty");return $({},"",{}),$}catch($){}}(),Xr=Kr(Gr?function($,W){return Gr($,"toString",{configurable:!0,enumerable:!1,value:Wr(W),writable:!0})}:Pr);var Yr=function baseFindIndex($,W,G,oe){for(var ae=$.length,ie=G+(oe?1:-1);oe?ie--:++ie<ae;)if(W($[ie],ie,$))return ie;return-1};var Jr=function baseIsNaN($){return $!=$};var Qr=function strictIndexOf($,W,G){for(var oe=G-1,ae=$.length;++oe<ae;)if($[oe]===W)return oe;return-1};var Zr=function baseIndexOf($,W,G){return W==W?Qr($,W,G):Yr($,Jr,G)};var en=function arrayIncludes($,W){return!!(null==$?0:$.length)&&Zr($,W,0)>-1},tn=/^(?:0|[1-9]\d*)$/;var rn=function isIndex($,W){var G=typeof $;return!!(W=null==W?9007199254740991:W)&&("number"==G||"symbol"!=G&&tn.test($))&&$>-1&&$%1==0&&$<W};var nn=function baseAssignValue($,W,G){"__proto__"==W&&Gr?Gr($,W,{configurable:!0,enumerable:!0,value:G,writable:!0}):$[W]=G};var an=function eq($,W){return $===W||$!=$&&W!=W},sn=Object.prototype.hasOwnProperty;var ln=function assignValue($,W,G){var oe=$[W];sn.call($,W)&&an(oe,G)&&(void 0!==G||W in $)||nn($,W,G)},un=Math.max;var cn=function overRest($,W,G){return W=un(void 0===W?$.length-1:W,0),function(){for(var oe=arguments,ae=-1,ie=un(oe.length-W,0),se=Array(ie);++ae<ie;)se[ae]=oe[W+ae];ae=-1;for(var le=Array(W+1);++ae<W;)le[ae]=oe[ae];return le[W]=G(se),Hr($,this,le)}};var dn=function baseRest($,W){return Xr(cn($,W,Pr),$+"")};var fn=function isLength($){return"number"==typeof $&&$>-1&&$%1==0&&$<=9007199254740991};var pn=function isArrayLike($){return null!=$&&fn($.length)&&!Er($)};var hn=function isIterateeCall($,W,G){if(!gr(G))return!1;var oe=typeof W;return!!("number"==oe?pn(G)&&rn(W,G.length):"string"==oe&&W in G)&&an(G[W],$)},mn=Object.prototype;var gn=function isPrototype($){var W=$&&$.constructor;return $===("function"==typeof W&&W.prototype||mn)};var vn=function baseTimes($,W){for(var G=-1,oe=Array($);++G<$;)oe[G]=W(G);return oe};var yn=function baseIsArguments($){return ar($)&&"[object Arguments]"==or($)},bn=Object.prototype,wn=bn.hasOwnProperty,Sn=bn.propertyIsEnumerable,xn=yn(function(){return arguments}())?yn:function($){return ar($)&&wn.call($,"callee")&&!Sn.call($,"callee")},kn=xn;var _n=function stubFalse(){return!1},Pn=G&&!G.nodeType&&G,En=Pn&&$&&!$.nodeType&&$,jn=En&&En.exports===Pn?Gt.Buffer:void 0,Cn=(jn?jn.isBuffer:void 0)||_n,On={};On["[object Float32Array]"]=On["[object Float64Array]"]=On["[object Int8Array]"]=On["[object Int16Array]"]=On["[object Int32Array]"]=On["[object Uint8Array]"]=On["[object Uint8ClampedArray]"]=On["[object Uint16Array]"]=On["[object Uint32Array]"]=!0,On["[object Arguments]"]=On["[object Array]"]=On["[object ArrayBuffer]"]=On["[object Boolean]"]=On["[object DataView]"]=On["[object Date]"]=On["[object Error]"]=On["[object Function]"]=On["[object Map]"]=On["[object Number]"]=On["[object Object]"]=On["[object RegExp]"]=On["[object Set]"]=On["[object String]"]=On["[object WeakMap]"]=!1;var In=function baseIsTypedArray($){return ar($)&&fn($.length)&&!!On[or($)]};var Tn=function baseUnary($){return function(W){return $(W)}},Dn=G&&!G.nodeType&&G,An=Dn&&$&&!$.nodeType&&$,$n=An&&An.exports===Dn&&Kt.process,zn=function(){try{var $=An&&An.require&&An.require("util").types;return $||$n&&$n.binding&&$n.binding("util")}catch($){}}(),Mn=zn&&zn.isTypedArray,Rn=Mn?Tn(Mn):In,Bn=Object.prototype.hasOwnProperty;var Fn=function arrayLikeKeys($,W){var G=lr($),oe=!G&&kn($),ae=!G&&!oe&&Cn($),ie=!G&&!oe&&!ae&&Rn($),se=G||oe||ae||ie,le=se?vn($.length,String):[],ue=le.length;for(var de in $)!W&&!Bn.call($,de)||se&&("length"==de||ae&&("offset"==de||"parent"==de)||ie&&("buffer"==de||"byteLength"==de||"byteOffset"==de)||rn(de,ue))||le.push(de);return le};var Nn=function overArg($,W){return function(G){return $(W(G))}},Ln=Nn(Object.keys,Object),Hn=Object.prototype.hasOwnProperty;var Vn=function baseKeys($){if(!gn($))return Ln($);var W=[];for(var G in Object($))Hn.call($,G)&&"constructor"!=G&&W.push(G);return W};var qn=function keys($){return pn($)?Fn($):Vn($)},Un=/\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/,Kn=/^\w*$/;var Wn=function isKey($,W){if(lr($))return!1;var G=typeof $;return!("number"!=G&&"symbol"!=G&&"boolean"!=G&&null!=$&&!ir($))||(Kn.test($)||!Un.test($)||null!=W&&$ in Object(W))},Gn=Nr(Object,"create");var Xn=function hashClear(){this.__data__=Gn?Gn(null):{},this.size=0};var Yn=function hashDelete($){var W=this.has($)&&delete this.__data__[$];return this.size-=W?1:0,W},Jn=Object.prototype.hasOwnProperty;var Qn=function hashGet($){var W=this.__data__;if(Gn){var G=W[$];return"__lodash_hash_undefined__"===G?void 0:G}return Jn.call(W,$)?W[$]:void 0},Zn=Object.prototype.hasOwnProperty;var eo=function hashHas($){var W=this.__data__;return Gn?void 0!==W[$]:Zn.call(W,$)};var to=function hashSet($,W){var G=this.__data__;return this.size+=this.has($)?0:1,G[$]=Gn&&void 0===W?"__lodash_hash_undefined__":W,this};function Hash($){var W=-1,G=null==$?0:$.length;for(this.clear();++W<G;){var oe=$[W];this.set(oe[0],oe[1])}}Hash.prototype.clear=Xn,Hash.prototype.delete=Yn,Hash.prototype.get=Qn,Hash.prototype.has=eo,Hash.prototype.set=to;var ro=Hash;var no=function listCacheClear(){this.__data__=[],this.size=0};var oo=function assocIndexOf($,W){for(var G=$.length;G--;)if(an($[G][0],W))return G;return-1},ao=Array.prototype.splice;var io=function listCacheDelete($){var W=this.__data__,G=oo(W,$);return!(G<0)&&(G==W.length-1?W.pop():ao.call(W,G,1),--this.size,!0)};var so=function listCacheGet($){var W=this.__data__,G=oo(W,$);return G<0?void 0:W[G][1]};var lo=function listCacheHas($){return oo(this.__data__,$)>-1};var uo=function listCacheSet($,W){var G=this.__data__,oe=oo(G,$);return oe<0?(++this.size,G.push([$,W])):G[oe][1]=W,this};function ListCache($){var W=-1,G=null==$?0:$.length;for(this.clear();++W<G;){var oe=$[W];this.set(oe[0],oe[1])}}ListCache.prototype.clear=no,ListCache.prototype.delete=io,ListCache.prototype.get=so,ListCache.prototype.has=lo,ListCache.prototype.set=uo;var co=ListCache,fo=Nr(Gt,"Map");var po=function mapCacheClear(){this.size=0,this.__data__={hash:new ro,map:new(fo||co),string:new ro}};var ho=function isKeyable($){var W=typeof $;return"string"==W||"number"==W||"symbol"==W||"boolean"==W?"__proto__"!==$:null===$};var mo=function getMapData($,W){var G=$.__data__;return ho(W)?G["string"==typeof W?"string":"hash"]:G.map};var go=function mapCacheDelete($){var W=mo(this,$).delete($);return this.size-=W?1:0,W};var vo=function mapCacheGet($){return mo(this,$).get($)};var yo=function mapCacheHas($){return mo(this,$).has($)};var bo=function mapCacheSet($,W){var G=mo(this,$),oe=G.size;return G.set($,W),this.size+=G.size==oe?0:1,this};function MapCache($){var W=-1,G=null==$?0:$.length;for(this.clear();++W<G;){var oe=$[W];this.set(oe[0],oe[1])}}MapCache.prototype.clear=po,MapCache.prototype.delete=go,MapCache.prototype.get=vo,MapCache.prototype.has=yo,MapCache.prototype.set=bo;var wo=MapCache;function memoize($,W){if("function"!=typeof $||null!=W&&"function"!=typeof W)throw new TypeError("Expected a function");var memoized=function(){var G=arguments,oe=W?W.apply(this,G):G[0],ae=memoized.cache;if(ae.has(oe))return ae.get(oe);var ie=$.apply(this,G);return memoized.cache=ae.set(oe,ie)||ae,ie};return memoized.cache=new(memoize.Cache||wo),memoized}memoize.Cache=wo;var So=memoize;var xo=/[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g,ko=/\\(\\)?/g,_o=function memoizeCapped($){var W=So($,(function($){return 500===G.size&&G.clear(),$})),G=W.cache;return W}((function($){var W=[];return 46===$.charCodeAt(0)&&W.push(""),$.replace(xo,(function($,G,oe,ae){W.push(oe?ae.replace(ko,"$1"):G||$)})),W}));var Po=function toString($){return null==$?"":dr($)};var Eo=function castPath($,W){return lr($)?$:Wn($,W)?[$]:_o(Po($))};var jo=function toKey($){if("string"==typeof $||ir($))return $;var W=$+"";return"0"==W&&1/$==-Infinity?"-0":W};var Co=function baseGet($,W){for(var G=0,oe=(W=Eo(W,$)).length;null!=$&&G<oe;)$=$[jo(W[G++])];return G&&G==oe?$:void 0};var Oo=function get($,W,G){var oe=null==$?void 0:Co($,W);return void 0===oe?G:oe};var Io=function arrayPush($,W){for(var G=-1,oe=W.length,ae=$.length;++G<oe;)$[ae+G]=W[G];return $},To=Xt?Xt.isConcatSpreadable:void 0;var Do=function isFlattenable($){return lr($)||kn($)||!!(To&&$&&$[To])};var Ao=function baseFlatten($,W,G,oe,ae){var ie=-1,se=$.length;for(G||(G=Do),ae||(ae=[]);++ie<se;){var le=$[ie];W>0&&G(le)?W>1?baseFlatten(le,W-1,G,oe,ae):Io(ae,le):oe||(ae[ae.length]=le)}return ae},$o=Nn(Object.getPrototypeOf,Object),zo=Function.prototype,Mo=Object.prototype,Ro=zo.toString,Bo=Mo.hasOwnProperty,Fo=Ro.call(Object);var No=function isPlainObject($){if(!ar($)||"[object Object]"!=or($))return!1;var W=$o($);if(null===W)return!0;var G=Bo.call(W,"constructor")&&W.constructor;return"function"==typeof G&&G instanceof G&&Ro.call(G)==Fo},Lo=Gt.isFinite,Ho=Math.min;var Vo=function createRound($){var W=Math[$];return function($,G){if($=Sr($),(G=null==G?0:Ho(_r(G),292))&&Lo($)){var oe=(Po($)+"e").split("e"),ae=W(oe[0]+"e"+(+oe[1]+G));return+((oe=(Po(ae)+"e").split("e"))[0]+"e"+(+oe[1]-G))}return W($)}};var qo=function baseClamp($,W,G){return $==$&&(void 0!==G&&($=$<=G?$:G),void 0!==W&&($=$>=W?$:W)),$};var Uo=function clamp($,W,G){return void 0===G&&(G=W,W=void 0),void 0!==G&&(G=(G=Sr(G))==G?G:0),void 0!==W&&(W=(W=Sr(W))==W?W:0),qo(Sr($),W,G)};var Ko=function stackClear(){this.__data__=new co,this.size=0};var Wo=function stackDelete($){var W=this.__data__,G=W.delete($);return this.size=W.size,G};var Go=function stackGet($){return this.__data__.get($)};var Xo=function stackHas($){return this.__data__.has($)};var Yo=function stackSet($,W){var G=this.__data__;if(G instanceof co){var oe=G.__data__;if(!fo||oe.length<199)return oe.push([$,W]),this.size=++G.size,this;G=this.__data__=new wo(oe)}return G.set($,W),this.size=G.size,this};function Stack($){var W=this.__data__=new co($);this.size=W.size}Stack.prototype.clear=Ko,Stack.prototype.delete=Wo,Stack.prototype.get=Go,Stack.prototype.has=Xo,Stack.prototype.set=Yo;var Jo=Stack;var Qo=function arrayFilter($,W){for(var G=-1,oe=null==$?0:$.length,ae=0,ie=[];++G<oe;){var se=$[G];W(se,G,$)&&(ie[ae++]=se)}return ie};var Zo=function stubArray(){return[]},ta=Object.prototype.propertyIsEnumerable,ra=Object.getOwnPropertySymbols,oa=ra?function($){return null==$?[]:($=Object($),Qo(ra($),(function(W){return ta.call($,W)})))}:Zo;var aa=function baseGetAllKeys($,W,G){var oe=W($);return lr($)?oe:Io(oe,G($))};var ia=function getAllKeys($){return aa($,qn,oa)},sa=Nr(Gt,"DataView"),ua=Nr(Gt,"Promise"),ca=Nr(Gt,"Set"),fa="[object Map]",ha="[object Promise]",ga="[object Set]",va="[object WeakMap]",ya="[object DataView]",ba=Tr(sa),wa=Tr(fo),xa=Tr(ua),ka=Tr(ca),_a=Tr(Lr),Ea=or;(sa&&Ea(new sa(new ArrayBuffer(1)))!=ya||fo&&Ea(new fo)!=fa||ua&&Ea(ua.resolve())!=ha||ca&&Ea(new ca)!=ga||Lr&&Ea(new Lr)!=va)&&(Ea=function($){var W=or($),G="[object Object]"==W?$.constructor:void 0,oe=G?Tr(G):"";if(oe)switch(oe){case ba:return ya;case wa:return fa;case xa:return ha;case ka:return ga;case _a:return va}return W});var ja=Ea,Ca=Gt.Uint8Array;var Oa=function setCacheAdd($){return this.__data__.set($,"__lodash_hash_undefined__"),this};var Ia=function setCacheHas($){return this.__data__.has($)};function SetCache($){var W=-1,G=null==$?0:$.length;for(this.__data__=new wo;++W<G;)this.add($[W])}SetCache.prototype.add=SetCache.prototype.push=Oa,SetCache.prototype.has=Ia;var Da=SetCache;var Aa=function arraySome($,W){for(var G=-1,oe=null==$?0:$.length;++G<oe;)if(W($[G],G,$))return!0;return!1};var za=function cacheHas($,W){return $.has(W)};var Ma=function equalArrays($,W,G,oe,ae,ie){var se=1&G,le=$.length,ue=W.length;if(le!=ue&&!(se&&ue>le))return!1;var de=ie.get($),pe=ie.get(W);if(de&&pe)return de==W&&pe==$;var he=-1,ge=!0,ve=2&G?new Da:void 0;for(ie.set($,W),ie.set(W,$);++he<le;){var we=$[he],Se=W[he];if(oe)var Pe=se?oe(Se,we,he,W,$,ie):oe(we,Se,he,$,W,ie);if(void 0!==Pe){if(Pe)continue;ge=!1;break}if(ve){if(!Aa(W,(function($,W){if(!za(ve,W)&&(we===$||ae(we,$,G,oe,ie)))return ve.push(W)}))){ge=!1;break}}else if(we!==Se&&!ae(we,Se,G,oe,ie)){ge=!1;break}}return ie.delete($),ie.delete(W),ge};var Ba=function mapToArray($){var W=-1,G=Array($.size);return $.forEach((function($,oe){G[++W]=[oe,$]})),G};var Fa=function setToArray($){var W=-1,G=Array($.size);return $.forEach((function($){G[++W]=$})),G},Ha=Xt?Xt.prototype:void 0,Ka=Ha?Ha.valueOf:void 0;var Ga=function equalByTag($,W,G,oe,ae,ie,se){switch(G){case"[object DataView]":if($.byteLength!=W.byteLength||$.byteOffset!=W.byteOffset)return!1;$=$.buffer,W=W.buffer;case"[object ArrayBuffer]":return!($.byteLength!=W.byteLength||!ie(new Ca($),new Ca(W)));case"[object Boolean]":case"[object Date]":case"[object Number]":return an(+$,+W);case"[object Error]":return $.name==W.name&&$.message==W.message;case"[object RegExp]":case"[object String]":return $==W+"";case"[object Map]":var le=Ba;case"[object Set]":var ue=1&oe;if(le||(le=Fa),$.size!=W.size&&!ue)return!1;var de=se.get($);if(de)return de==W;oe|=2,se.set($,W);var pe=Ma(le($),le(W),oe,ae,ie,se);return se.delete($),pe;case"[object Symbol]":if(Ka)return Ka.call($)==Ka.call(W)}return!1},Ja=Object.prototype.hasOwnProperty;var ei=function equalObjects($,W,G,oe,ae,ie){var se=1&G,le=ia($),ue=le.length;if(ue!=ia(W).length&&!se)return!1;for(var de=ue;de--;){var pe=le[de];if(!(se?pe in W:Ja.call(W,pe)))return!1}var he=ie.get($),ge=ie.get(W);if(he&&ge)return he==W&&ge==$;var ve=!0;ie.set($,W),ie.set(W,$);for(var we=se;++de<ue;){var Se=$[pe=le[de]],Pe=W[pe];if(oe)var je=se?oe(Pe,Se,pe,W,$,ie):oe(Se,Pe,pe,$,W,ie);if(!(void 0===je?Se===Pe||ae(Se,Pe,G,oe,ie):je)){ve=!1;break}we||(we="constructor"==pe)}if(ve&&!we){var Ie=$.constructor,De=W.constructor;Ie==De||!("constructor"in $)||!("constructor"in W)||"function"==typeof Ie&&Ie instanceof Ie&&"function"==typeof De&&De instanceof De||(ve=!1)}return ie.delete($),ie.delete(W),ve},si="[object Arguments]",_i="[object Array]",Ei="[object Object]",Ci=Object.prototype.hasOwnProperty;var Oi=function baseIsEqualDeep($,W,G,oe,ae,ie){var se=lr($),le=lr(W),ue=se?_i:ja($),de=le?_i:ja(W),pe=(ue=ue==si?Ei:ue)==Ei,he=(de=de==si?Ei:de)==Ei,ge=ue==de;if(ge&&Cn($)){if(!Cn(W))return!1;se=!0,pe=!1}if(ge&&!pe)return ie||(ie=new Jo),se||Rn($)?Ma($,W,G,oe,ae,ie):Ga($,W,ue,G,oe,ae,ie);if(!(1&G)){var ve=pe&&Ci.call($,"__wrapped__"),we=he&&Ci.call(W,"__wrapped__");if(ve||we){var Se=ve?$.value():$,Pe=we?W.value():W;return ie||(ie=new Jo),ae(Se,Pe,G,oe,ie)}}return!!ge&&(ie||(ie=new Jo),ei($,W,G,oe,ae,ie))};var Ti=function baseIsEqual($,W,G,oe,ae){return $===W||(null==$||null==W||!ar($)&&!ar(W)?$!=$&&W!=W:Oi($,W,G,oe,baseIsEqual,ae))};var Di=function baseIsMatch($,W,G,oe){var ae=G.length,ie=ae,se=!oe;if(null==$)return!ie;for($=Object($);ae--;){var le=G[ae];if(se&&le[2]?le[1]!==$[le[0]]:!(le[0]in $))return!1}for(;++ae<ie;){var ue=(le=G[ae])[0],de=$[ue],pe=le[1];if(se&&le[2]){if(void 0===de&&!(ue in $))return!1}else{var he=new Jo;if(oe)var ge=oe(de,pe,ue,$,W,he);if(!(void 0===ge?Ti(pe,de,3,oe,he):ge))return!1}}return!0};var Ri=function isStrictComparable($){return $==$&&!gr($)};var Bi=function getMatchData($){for(var W=qn($),G=W.length;G--;){var oe=W[G],ae=$[oe];W[G]=[oe,ae,Ri(ae)]}return W};var Hi=function matchesStrictComparable($,W){return function(G){return null!=G&&(G[$]===W&&(void 0!==W||$ in Object(G)))}};var Ui=function baseMatches($){var W=Bi($);return 1==W.length&&W[0][2]?Hi(W[0][0],W[0][1]):function(G){return G===$||Di(G,$,W)}};var Ji=function baseHasIn($,W){return null!=$&&W in Object($)};var Qi=function hasPath($,W,G){for(var oe=-1,ae=(W=Eo(W,$)).length,ie=!1;++oe<ae;){var se=jo(W[oe]);if(!(ie=null!=$&&G($,se)))break;$=$[se]}return ie||++oe!=ae?ie:!!(ae=null==$?0:$.length)&&fn(ae)&&rn(se,ae)&&(lr($)||kn($))};var es=function hasIn($,W){return null!=$&&Qi($,W,Ji)};var ts=function baseMatchesProperty($,W){return Wn($)&&Ri(W)?Hi(jo($),W):function(G){var oe=Oo(G,$);return void 0===oe&&oe===W?es(G,$):Ti(W,oe,3)}};var rs=function baseProperty($){return function(W){return null==W?void 0:W[$]}};var ns=function basePropertyDeep($){return function(W){return Co(W,$)}};var os=function property($){return Wn($)?rs(jo($)):ns($)};var as=function baseIteratee($){return"function"==typeof $?$:null==$?Pr:"object"==typeof $?lr($)?ts($[0],$[1]):Ui($):os($)};var is=function arrayAggregator($,W,G,oe){for(var ae=-1,ie=null==$?0:$.length;++ae<ie;){var se=$[ae];W(oe,se,G(se),$)}return oe};var ss=function createBaseFor($){return function(W,G,oe){for(var ae=-1,ie=Object(W),se=oe(W),le=se.length;le--;){var ue=se[$?le:++ae];if(!1===G(ie[ue],ue,ie))break}return W}},ls=ss();var us=function baseForOwn($,W){return $&&ls($,W,qn)};var cs=function createBaseEach($,W){return function(G,oe){if(null==G)return G;if(!pn(G))return $(G,oe);for(var ae=G.length,ie=W?ae:-1,se=Object(G);(W?ie--:++ie<ae)&&!1!==oe(se[ie],ie,se););return G}},ds=cs(us);var fs=function baseAggregator($,W,G,oe){return ds($,(function($,ae,ie){W(oe,$,G($),ie)})),oe};var ps=function createAggregator($,W){return function(G,oe){var ae=lr(G)?is:fs,ie=W?W():{};return ae(G,$,as(oe),ie)}},now_default=function(){return Gt.Date.now()},hs=Math.max,ms=Math.min;var gs=function debounce($,W,G){var oe,ae,ie,se,le,ue,de=0,pe=!1,he=!1,ge=!0;if("function"!=typeof $)throw new TypeError("Expected a function");function invokeFunc(W){var G=oe,ie=ae;return oe=ae=void 0,de=W,se=$.apply(ie,G)}function leadingEdge($){return de=$,le=setTimeout(timerExpired,W),pe?invokeFunc($):se}function shouldInvoke($){var G=$-ue;return void 0===ue||G>=W||G<0||he&&$-de>=ie}function timerExpired(){var $=now_default();if(shouldInvoke($))return trailingEdge($);le=setTimeout(timerExpired,function remainingWait($){var G=W-($-ue);return he?ms(G,ie-($-de)):G}($))}function trailingEdge($){return le=void 0,ge&&oe?invokeFunc($):(oe=ae=void 0,se)}function debounced(){var $=now_default(),G=shouldInvoke($);if(oe=arguments,ae=this,ue=$,G){if(void 0===le)return leadingEdge(ue);if(he)return clearTimeout(le),le=setTimeout(timerExpired,W),invokeFunc(ue)}return void 0===le&&(le=setTimeout(timerExpired,W)),se}return W=Sr(W)||0,gr(G)&&(pe=!!G.leading,ie=(he="maxWait"in G)?hs(Sr(G.maxWait)||0,W):ie,ge="trailing"in G?!!G.trailing:ge),debounced.cancel=function cancel(){void 0!==le&&clearTimeout(le),de=0,oe=ue=ae=le=void 0},debounced.flush=function flush(){return void 0===le?se:trailingEdge(now_default())},debounced};var vs=function arrayIncludesWith($,W,G){for(var oe=-1,ae=null==$?0:$.length;++oe<ae;)if(G(W,$[oe]))return!0;return!1};var ys=function last($){var W=null==$?0:$.length;return W?$[W-1]:void 0},bs=Math.max;var ws=function findIndex($,W,G){var oe=null==$?0:$.length;if(!oe)return-1;var ae=null==G?0:_r(G);return ae<0&&(ae=bs(oe+ae,0)),Yr($,as(W),ae)},Ss=Math.max,xs=Math.min;var ks=function findLastIndex($,W,G){var oe=null==$?0:$.length;if(!oe)return-1;var ae=oe-1;return void 0!==G&&(ae=_r(G),ae=G<0?Ss(oe+ae,0):xs(ae,oe-1)),Yr($,as(W),ae,!0)};var _s=function baseMap($,W){var G=-1,oe=pn($)?Array($.length):[];return ds($,(function($,ae,ie){oe[++G]=W($,ae,ie)})),oe},Ps=Math.max,Es=Math.min;var js=function baseInRange($,W,G){return $>=Es(W,G)&&$<Ps(W,G)};var Cs=function inRange($,W,G){return W=kr(W),void 0===G?(G=W,W=0):G=kr(G),$=Sr($),js($,W,G)};var Os=function isInteger($){return"number"==typeof $&&$==_r($)},Is=ps((function($,W,G){nn($,G,W)}));var Ts=function mapValues($,W){var G={};return W=as(W),us($,(function($,oe,ae){nn(G,oe,W($,oe,ae))})),G};var Ds=function baseSet($,W,G,oe){if(!gr($))return $;for(var ae=-1,ie=(W=Eo(W,$)).length,se=ie-1,le=$;null!=le&&++ae<ie;){var ue=jo(W[ae]),de=G;if("__proto__"===ue||"constructor"===ue||"prototype"===ue)return $;if(ae!=se){var pe=le[ue];void 0===(de=oe?oe(pe,ue,le):void 0)&&(de=gr(pe)?pe:rn(W[ae+1])?[]:{})}ln(le,ue,de),le=le[ue]}return $};var As=function baseSortBy($,W){var G=$.length;for($.sort(W);G--;)$[G]=$[G].value;return $};var $s=function compareAscending($,W){if($!==W){var G=void 0!==$,oe=null===$,ae=$==$,ie=ir($),se=void 0!==W,le=null===W,ue=W==W,de=ir(W);if(!le&&!de&&!ie&&$>W||ie&&se&&ue&&!le&&!de||oe&&se&&ue||!G&&ue||!ae)return 1;if(!oe&&!ie&&!de&&$<W||de&&G&&ae&&!oe&&!ie||le&&G&&ae||!se&&ae||!ue)return-1}return 0};var zs=function compareMultiple($,W,G){for(var oe=-1,ae=$.criteria,ie=W.criteria,se=ae.length,le=G.length;++oe<se;){var ue=$s(ae[oe],ie[oe]);if(ue)return oe>=le?ue:ue*("desc"==G[oe]?-1:1)}return $.index-W.index};var Ms=function baseOrderBy($,W,G){W=W.length?sr(W,(function($){return lr($)?function(W){return Co(W,1===$.length?$[0]:$)}:$})):[Pr];var oe=-1;W=sr(W,Tn(as));var ae=_s($,(function($,G,ae){return{criteria:sr(W,(function(W){return W($)})),index:++oe,value:$}}));return As(ae,(function($,W){return zs($,W,G)}))};var Rs=function baseIndexOfWith($,W,G,oe){for(var ae=G-1,ie=$.length;++ae<ie;)if(oe($[ae],W))return ae;return-1},Bs=Array.prototype.splice;var Fs=function basePullAll($,W,G,oe){var ae=oe?Rs:Zr,ie=-1,se=W.length,le=$;for($===W&&(W=qr(W)),G&&(le=sr($,Tn(G)));++ie<se;)for(var ue=0,de=W[ie],pe=G?G(de):de;(ue=ae(le,pe,ue,oe))>-1;)le!==$&&Bs.call(le,ue,1),Bs.call($,ue,1);return $};var Ns=dn((function pullAll($,W){return $&&$.length&&W&&W.length?Fs($,W):$})),Ls=Vo("round");var Hs=function set($,W,G){return null==$?$:Ds($,W,G)},Vs=dn((function($,W){if(null==$)return[];var G=W.length;return G>1&&hn($,W[0],W[1])?W=[]:G>2&&hn(W[0],W[1],W[2])&&(W=[W[0]]),Ms($,Ao(W,1),[])})),qs=ca&&1/Fa(new ca([,-0]))[1]==1/0?function($){return new ca($)}:Vr;var Us=function baseUniq($,W,G){var oe=-1,ae=en,ie=$.length,se=!0,le=[],ue=le;if(G)se=!1,ae=vs;else if(ie>=200){var de=W?null:qs($);if(de)return Fa(de);se=!1,ae=za,ue=new Da}else ue=W?[]:le;e:for(;++oe<ie;){var pe=$[oe],he=W?W(pe):pe;if(pe=G||0!==pe?pe:0,se&&he==he){for(var ge=ue.length;ge--;)if(ue[ge]===he)continue e;W&&ue.push(he),le.push(pe)}else ae(ue,he,G)||(ue!==le&&ue.push(he),le.push(pe))}return le};var Ks=function uniq($){return $&&$.length?Us($):[]},Ws=__toModule(we()),Gs=__toModule(vt.exports),Xs=__toModule(Vt.exports),Ys={log:console.log};function usePrism($,W,G){const oe=(0,Gs.useCallback)($,W),ae=(0,Gs.useRef)(null);ae.current?ae.current.set(oe):ae.current=new qt.Box(oe);return function useDerivation($,W){const G=function useForceUpdate($){const[,W]=(0,Gs.useState)(0);return(0,Gs.useCallback)((()=>{$&&Ys.log($,"forceUpdate",{trace:new Error}),W(($=>$+1))}),[])}(W),oe=(0,Gs.useRef)(void 0);oe.current||(Js++,oe.current={queueItem:{debugLabel:W,order:Js,runUpdate:()=>{oe.current.unmounted||G()}},unmounted:!1});const ae=(0,Gs.useCallback)((()=>{var $;$=oe.current.queueItem,_pushToQueue($),queueIfNeeded()}),[]);(0,Gs.useLayoutEffect)((()=>{const W=$.changesWithoutValues().tap((()=>{ae()}));return ie.current!==$.getValue()&&ae(),W}),[$]),(0,Gs.useLayoutEffect)((()=>function onUnmount(){oe.current.unmounted=!0,removeFromQueue(oe.current.queueItem)}),[]);const ie=(0,Gs.useRef)(void 0),se=oe.current.queueItem;Zs.has(se)&&Qs[0]!==oe.current.queueItem||(removeFromQueue(se),ie.current=$.getValue());return ie.current}((0,Gs.useMemo)((()=>(0,Ut.prism)((()=>ae.current.derivation.getValue()()))),[]),G)}var useVal=($,W)=>usePrism((()=>(0,Ut.val)($)),[$],W),Js=0,Qs=[],Zs=new Set,el=!1,_pushToQueue=$=>{if(!Zs.has($))if(Zs.add($),0===Qs.length)Qs.push($);else{const W=ws(Qs,(W=>W.order>=$.order));if(-1===W)Qs.push($);else{Qs[W].order>$.order&&Qs.splice(W,0,$)}}},removeFromQueue=$=>{if(!Zs.has($))return;Zs.delete($);const W=ws(Qs,(W=>W===$));Qs.splice(W,1)};function queueIfNeeded(){el||(el=!0,(0,Ws.default)((()=>{let $=0;for(;Qs.length>0;){if($++,4===$){setTimeout(queueIfNeeded,1);break}(0,Xs.unstable_batchedUpdates)((()=>{for(const $ of Qs)$.runUpdate()}),1)}el=!1})))}var tl=__toModule(W),rl=__toModule(vt.exports),nl=__toModule(mu),ol=__toModule(vt.exports),al=__toModule(mu);function _extends(){return _extends=Object.assign||function($){for(var W=1;W<arguments.length;W++){var G=arguments[W];for(var oe in G)Object.prototype.hasOwnProperty.call(G,oe)&&($[oe]=G[oe])}return $},_extends.apply(this,arguments)}function _assertThisInitialized($){if(void 0===$)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return $}function _setPrototypeOf($,W){return(_setPrototypeOf=Object.setPrototypeOf||function _setPrototypeOf2($,W){return $.__proto__=W,$})($,W)}function _getPrototypeOf($){return(_getPrototypeOf=Object.setPrototypeOf?Object.getPrototypeOf:function _getPrototypeOf2($){return $.__proto__||Object.getPrototypeOf($)})($)}function _isNativeReflectConstruct(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch($){return!1}}function _construct($,W,G){return(_construct=_isNativeReflectConstruct()?Reflect.construct:function _construct2($,W,G){var oe=[null];oe.push.apply(oe,W);var ae=new(Function.bind.apply($,oe));return G&&_setPrototypeOf(ae,G.prototype),ae}).apply(null,arguments)}function _wrapNativeSuper($){var W="function"==typeof Map?new Map:void 0;return _wrapNativeSuper=function _wrapNativeSuper2($){if(null===$||!function _isNativeFunction($){return-1!==Function.toString.call($).indexOf("[native code]")}($))return $;if("function"!=typeof $)throw new TypeError("Super expression must either be null or a function");if(void 0!==W){if(W.has($))return W.get($);W.set($,Wrapper)}function Wrapper(){return _construct($,arguments,_getPrototypeOf(this).constructor)}return Wrapper.prototype=Object.create($.prototype,{constructor:{value:Wrapper,enumerable:!1,writable:!0,configurable:!0}}),_setPrototypeOf(Wrapper,$)},_wrapNativeSuper($)}var il={1:"Passed invalid arguments to hsl, please pass multiple numbers e.g. hsl(360, 0.75, 0.4) or an object e.g. rgb({ hue: 255, saturation: 0.4, lightness: 0.75 }).\n\n",2:"Passed invalid arguments to hsla, please pass multiple numbers e.g. hsla(360, 0.75, 0.4, 0.7) or an object e.g. rgb({ hue: 255, saturation: 0.4, lightness: 0.75, alpha: 0.7 }).\n\n",3:"Passed an incorrect argument to a color function, please pass a string representation of a color.\n\n",4:"Couldn't generate valid rgb string from %s, it returned %s.\n\n",5:"Couldn't parse the color string. Please provide the color as a string in hex, rgb, rgba, hsl or hsla notation.\n\n",6:"Passed invalid arguments to rgb, please pass multiple numbers e.g. rgb(255, 205, 100) or an object e.g. rgb({ red: 255, green: 205, blue: 100 }).\n\n",7:"Passed invalid arguments to rgba, please pass multiple numbers e.g. rgb(255, 205, 100, 0.75) or an object e.g. rgb({ red: 255, green: 205, blue: 100, alpha: 0.75 }).\n\n",8:"Passed invalid argument to toColorString, please pass a RgbColor, RgbaColor, HslColor or HslaColor object.\n\n",9:"Please provide a number of steps to the modularScale helper.\n\n",10:"Please pass a number or one of the predefined scales to the modularScale helper as the ratio.\n\n",11:'Invalid value passed as base to modularScale, expected number or em string but got "%s"\n\n',12:'Expected a string ending in "px" or a number passed as the first argument to %s(), got "%s" instead.\n\n',13:'Expected a string ending in "px" or a number passed as the second argument to %s(), got "%s" instead.\n\n',14:'Passed invalid pixel value ("%s") to %s(), please pass a value like "12px" or 12.\n\n',15:'Passed invalid base value ("%s") to %s(), please pass a value like "12px" or 12.\n\n',16:"You must provide a template to this method.\n\n",17:"You passed an unsupported selector state to this method.\n\n",18:"minScreen and maxScreen must be provided as stringified numbers with the same units.\n\n",19:"fromSize and toSize must be provided as stringified numbers with the same units.\n\n",20:"expects either an array of objects or a single object with the properties prop, fromSize, and toSize.\n\n",21:"expects the objects in the first argument array to have the properties `prop`, `fromSize`, and `toSize`.\n\n",22:"expects the first argument object to have the properties `prop`, `fromSize`, and `toSize`.\n\n",23:"fontFace expects a name of a font-family.\n\n",24:"fontFace expects either the path to the font file(s) or a name of a local copy.\n\n",25:"fontFace expects localFonts to be an array.\n\n",26:"fontFace expects fileFormats to be an array.\n\n",27:"radialGradient requries at least 2 color-stops to properly render.\n\n",28:"Please supply a filename to retinaImage() as the first argument.\n\n",29:"Passed invalid argument to triangle, please pass correct pointingDirection e.g. 'right'.\n\n",30:"Passed an invalid value to `height` or `width`. Please provide a pixel based unit.\n\n",31:"The animation shorthand only takes 8 arguments. See the specification for more information: http://mdn.io/animation\n\n",32:"To pass multiple animations please supply them in arrays, e.g. animation(['rotate', '2s'], ['move', '1s'])\nTo pass a single animation please supply them in simple values, e.g. animation('rotate', '2s')\n\n",33:"The animation shorthand arrays can only have 8 elements. See the specification for more information: http://mdn.io/animation\n\n",34:"borderRadius expects a radius value as a string or number as the second argument.\n\n",35:'borderRadius expects one of "top", "bottom", "left" or "right" as the first argument.\n\n',36:"Property must be a string value.\n\n",37:"Syntax Error at %s.\n\n",38:"Formula contains a function that needs parentheses at %s.\n\n",39:"Formula is missing closing parenthesis at %s.\n\n",40:"Formula has too many closing parentheses at %s.\n\n",41:"All values in a formula must have the same unit or be unitless.\n\n",42:"Please provide a number of steps to the modularScale helper.\n\n",43:"Please pass a number or one of the predefined scales to the modularScale helper as the ratio.\n\n",44:"Invalid value passed as base to modularScale, expected number or em/rem string but got %s.\n\n",45:"Passed invalid argument to hslToColorString, please pass a HslColor or HslaColor object.\n\n",46:"Passed invalid argument to rgbToColorString, please pass a RgbColor or RgbaColor object.\n\n",47:"minScreen and maxScreen must be provided as stringified numbers with the same units.\n\n",48:"fromSize and toSize must be provided as stringified numbers with the same units.\n\n",49:"Expects either an array of objects or a single object with the properties prop, fromSize, and toSize.\n\n",50:"Expects the objects in the first argument array to have the properties prop, fromSize, and toSize.\n\n",51:"Expects the first argument object to have the properties prop, fromSize, and toSize.\n\n",52:"fontFace expects either the path to the font file(s) or a name of a local copy.\n\n",53:"fontFace expects localFonts to be an array.\n\n",54:"fontFace expects fileFormats to be an array.\n\n",55:"fontFace expects a name of a font-family.\n\n",56:"linearGradient requries at least 2 color-stops to properly render.\n\n",57:"radialGradient requries at least 2 color-stops to properly render.\n\n",58:"Please supply a filename to retinaImage() as the first argument.\n\n",59:"Passed invalid argument to triangle, please pass correct pointingDirection e.g. 'right'.\n\n",60:"Passed an invalid value to `height` or `width`. Please provide a pixel based unit.\n\n",61:"Property must be a string value.\n\n",62:"borderRadius expects a radius value as a string or number as the second argument.\n\n",63:'borderRadius expects one of "top", "bottom", "left" or "right" as the first argument.\n\n',64:"The animation shorthand only takes 8 arguments. See the specification for more information: http://mdn.io/animation.\n\n",65:"To pass multiple animations please supply them in arrays, e.g. animation(['rotate', '2s'], ['move', '1s'])\\nTo pass a single animation please supply them in simple values, e.g. animation('rotate', '2s').\n\n",66:"The animation shorthand arrays can only have 8 elements. See the specification for more information: http://mdn.io/animation.\n\n",67:"You must provide a template to this method.\n\n",68:"You passed an unsupported selector state to this method.\n\n",69:'Expected a string ending in "px" or a number passed as the first argument to %s(), got %s instead.\n\n',70:'Expected a string ending in "px" or a number passed as the second argument to %s(), got %s instead.\n\n',71:'Passed invalid pixel value %s to %s(), please pass a value like "12px" or 12.\n\n',72:'Passed invalid base value %s to %s(), please pass a value like "12px" or 12.\n\n',73:"Please provide a valid CSS variable.\n\n",74:"CSS variable not found and no default was provided.\n\n",75:"important requires a valid style object, got a %s instead.\n\n",76:"fromSize and toSize must be provided as stringified numbers with the same units as minScreen and maxScreen.\n\n",77:'remToPx expects a value in "rem" but you provided it in "%s".\n\n',78:'base must be set in "px" or "%" but you set it in "%s".\n'};function format(){for(var $=arguments.length,W=new Array($),G=0;G<$;G++)W[G]=arguments[G];var oe,ae=W[0],ie=[];for(oe=1;oe<W.length;oe+=1)ie.push(W[oe]);return ie.forEach((function($){ae=ae.replace(/%[a-z]/,$)})),ae}var sl=function($){function PolishedError2(W){for(var G=arguments.length,oe=new Array(G>1?G-1:0),ae=1;ae<G;ae++)oe[ae-1]=arguments[ae];return _assertThisInitialized($.call(this,format.apply(void 0,[il[W]].concat(oe)))||this)}return function _inheritsLoose($,W){$.prototype=Object.create(W.prototype),$.prototype.constructor=$,_setPrototypeOf($,W)}(PolishedError2,$),PolishedError2}(_wrapNativeSuper(Error));var ll=["Top","Right","Bottom","Left"];function generateProperty($,W){if(!$)return W.toLowerCase();var G=$.split("-");if(G.length>1)return G.splice(1,0,W),G.reduce((function($,W){return""+$+function capitalizeString($){return $.charAt(0).toUpperCase()+$.slice(1)}(W)}));var oe=$.replace(/([a-z])([A-Z])/g,"$1"+W+"$2");return $===oe?""+$+W:oe}function generateStyles($,W){for(var G={},oe=0;oe<W.length;oe+=1)(W[oe]||0===W[oe])&&(G[generateProperty($,ll[oe])]=W[oe]);return G}function directionalProperty($){for(var W=arguments.length,G=new Array(W>1?W-1:0),oe=1;oe<W;oe++)G[oe-1]=arguments[oe];var ae=G[0],ie=G[1],se=void 0===ie?ae:ie,le=G[2],ue=void 0===le?ae:le,de=G[3],pe=void 0===de?se:de,he=[ae,se,ue,pe];return generateStyles($,he)}function colorToInt($){return Math.round(255*$)}function convertToInt($,W,G){return colorToInt($)+","+colorToInt(W)+","+colorToInt(G)}function hslToRgb($,W,G,oe){if(void 0===oe&&(oe=convertToInt),0===W)return oe(G,G,G);var ae=($%360+360)%360/60,ie=(1-Math.abs(2*G-1))*W,se=ie*(1-Math.abs(ae%2-1)),le=0,ue=0,de=0;ae>=0&&ae<1?(le=ie,ue=se):ae>=1&&ae<2?(le=se,ue=ie):ae>=2&&ae<3?(ue=ie,de=se):ae>=3&&ae<4?(ue=se,de=ie):ae>=4&&ae<5?(le=se,de=ie):ae>=5&&ae<6&&(le=ie,de=se);var pe=G-ie/2;return oe(le+pe,ue+pe,de+pe)}var ul={aliceblue:"f0f8ff",antiquewhite:"faebd7",aqua:"00ffff",aquamarine:"7fffd4",azure:"f0ffff",beige:"f5f5dc",bisque:"ffe4c4",black:"000",blanchedalmond:"ffebcd",blue:"0000ff",blueviolet:"8a2be2",brown:"a52a2a",burlywood:"deb887",cadetblue:"5f9ea0",chartreuse:"7fff00",chocolate:"d2691e",coral:"ff7f50",cornflowerblue:"6495ed",cornsilk:"fff8dc",crimson:"dc143c",cyan:"00ffff",darkblue:"00008b",darkcyan:"008b8b",darkgoldenrod:"b8860b",darkgray:"a9a9a9",darkgreen:"006400",darkgrey:"a9a9a9",darkkhaki:"bdb76b",darkmagenta:"8b008b",darkolivegreen:"556b2f",darkorange:"ff8c00",darkorchid:"9932cc",darkred:"8b0000",darksalmon:"e9967a",darkseagreen:"8fbc8f",darkslateblue:"483d8b",darkslategray:"2f4f4f",darkslategrey:"2f4f4f",darkturquoise:"00ced1",darkviolet:"9400d3",deeppink:"ff1493",deepskyblue:"00bfff",dimgray:"696969",dimgrey:"696969",dodgerblue:"1e90ff",firebrick:"b22222",floralwhite:"fffaf0",forestgreen:"228b22",fuchsia:"ff00ff",gainsboro:"dcdcdc",ghostwhite:"f8f8ff",gold:"ffd700",goldenrod:"daa520",gray:"808080",green:"008000",greenyellow:"adff2f",grey:"808080",honeydew:"f0fff0",hotpink:"ff69b4",indianred:"cd5c5c",indigo:"4b0082",ivory:"fffff0",khaki:"f0e68c",lavender:"e6e6fa",lavenderblush:"fff0f5",lawngreen:"7cfc00",lemonchiffon:"fffacd",lightblue:"add8e6",lightcoral:"f08080",lightcyan:"e0ffff",lightgoldenrodyellow:"fafad2",lightgray:"d3d3d3",lightgreen:"90ee90",lightgrey:"d3d3d3",lightpink:"ffb6c1",lightsalmon:"ffa07a",lightseagreen:"20b2aa",lightskyblue:"87cefa",lightslategray:"789",lightslategrey:"789",lightsteelblue:"b0c4de",lightyellow:"ffffe0",lime:"0f0",limegreen:"32cd32",linen:"faf0e6",magenta:"f0f",maroon:"800000",mediumaquamarine:"66cdaa",mediumblue:"0000cd",mediumorchid:"ba55d3",mediumpurple:"9370db",mediumseagreen:"3cb371",mediumslateblue:"7b68ee",mediumspringgreen:"00fa9a",mediumturquoise:"48d1cc",mediumvioletred:"c71585",midnightblue:"191970",mintcream:"f5fffa",mistyrose:"ffe4e1",moccasin:"ffe4b5",navajowhite:"ffdead",navy:"000080",oldlace:"fdf5e6",olive:"808000",olivedrab:"6b8e23",orange:"ffa500",orangered:"ff4500",orchid:"da70d6",palegoldenrod:"eee8aa",palegreen:"98fb98",paleturquoise:"afeeee",palevioletred:"db7093",papayawhip:"ffefd5",peachpuff:"ffdab9",peru:"cd853f",pink:"ffc0cb",plum:"dda0dd",powderblue:"b0e0e6",purple:"800080",rebeccapurple:"639",red:"f00",rosybrown:"bc8f8f",royalblue:"4169e1",saddlebrown:"8b4513",salmon:"fa8072",sandybrown:"f4a460",seagreen:"2e8b57",seashell:"fff5ee",sienna:"a0522d",silver:"c0c0c0",skyblue:"87ceeb",slateblue:"6a5acd",slategray:"708090",slategrey:"708090",snow:"fffafa",springgreen:"00ff7f",steelblue:"4682b4",tan:"d2b48c",teal:"008080",thistle:"d8bfd8",tomato:"ff6347",turquoise:"40e0d0",violet:"ee82ee",wheat:"f5deb3",white:"fff",whitesmoke:"f5f5f5",yellow:"ff0",yellowgreen:"9acd32"};var cl=/^#[a-fA-F0-9]{6}$/,dl=/^#[a-fA-F0-9]{8}$/,fl=/^#[a-fA-F0-9]{3}$/,pl=/^#[a-fA-F0-9]{4}$/,hl=/^rgb\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*\)$/i,ml=/^rgba\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*([-+]?[0-9]*[.]?[0-9]+)\s*\)$/i,gl=/^hsl\(\s*(\d{0,3}[.]?[0-9]+)\s*,\s*(\d{1,3}[.]?[0-9]?)%\s*,\s*(\d{1,3}[.]?[0-9]?)%\s*\)$/i,vl=/^hsla\(\s*(\d{0,3}[.]?[0-9]+)\s*,\s*(\d{1,3}[.]?[0-9]?)%\s*,\s*(\d{1,3}[.]?[0-9]?)%\s*,\s*([-+]?[0-9]*[.]?[0-9]+)\s*\)$/i;function parseToRgb($){if("string"!=typeof $)throw new sl(3);var W=function nameToHex($){if("string"!=typeof $)return $;var W=$.toLowerCase();return ul[W]?"#"+ul[W]:$}($);if(W.match(cl))return{red:parseInt(""+W[1]+W[2],16),green:parseInt(""+W[3]+W[4],16),blue:parseInt(""+W[5]+W[6],16)};if(W.match(dl)){var G=parseFloat((parseInt(""+W[7]+W[8],16)/255).toFixed(2));return{red:parseInt(""+W[1]+W[2],16),green:parseInt(""+W[3]+W[4],16),blue:parseInt(""+W[5]+W[6],16),alpha:G}}if(W.match(fl))return{red:parseInt(""+W[1]+W[1],16),green:parseInt(""+W[2]+W[2],16),blue:parseInt(""+W[3]+W[3],16)};if(W.match(pl)){var oe=parseFloat((parseInt(""+W[4]+W[4],16)/255).toFixed(2));return{red:parseInt(""+W[1]+W[1],16),green:parseInt(""+W[2]+W[2],16),blue:parseInt(""+W[3]+W[3],16),alpha:oe}}var ae=hl.exec(W);if(ae)return{red:parseInt(""+ae[1],10),green:parseInt(""+ae[2],10),blue:parseInt(""+ae[3],10)};var ie=ml.exec(W.substring(0,50));if(ie)return{red:parseInt(""+ie[1],10),green:parseInt(""+ie[2],10),blue:parseInt(""+ie[3],10),alpha:parseFloat(""+ie[4])};var se=gl.exec(W);if(se){var le="rgb("+hslToRgb(parseInt(""+se[1],10),parseInt(""+se[2],10)/100,parseInt(""+se[3],10)/100)+")",ue=hl.exec(le);if(!ue)throw new sl(4,W,le);return{red:parseInt(""+ue[1],10),green:parseInt(""+ue[2],10),blue:parseInt(""+ue[3],10)}}var de=vl.exec(W.substring(0,50));if(de){var pe="rgb("+hslToRgb(parseInt(""+de[1],10),parseInt(""+de[2],10)/100,parseInt(""+de[3],10)/100)+")",he=hl.exec(pe);if(!he)throw new sl(4,W,pe);return{red:parseInt(""+he[1],10),green:parseInt(""+he[2],10),blue:parseInt(""+he[3],10),alpha:parseFloat(""+de[4])}}throw new sl(5)}function parseToHsl($){return function rgbToHsl($){var W,G=$.red/255,oe=$.green/255,ae=$.blue/255,ie=Math.max(G,oe,ae),se=Math.min(G,oe,ae),le=(ie+se)/2;if(ie===se)return void 0!==$.alpha?{hue:0,saturation:0,lightness:le,alpha:$.alpha}:{hue:0,saturation:0,lightness:le};var ue=ie-se,de=le>.5?ue/(2-ie-se):ue/(ie+se);switch(ie){case G:W=(oe-ae)/ue+(oe<ae?6:0);break;case oe:W=(ae-G)/ue+2;break;default:W=(G-oe)/ue+4}return W*=60,void 0!==$.alpha?{hue:W,saturation:de,lightness:le,alpha:$.alpha}:{hue:W,saturation:de,lightness:le}}(parseToRgb($))}var yl=function reduceHexValue2($){return 7===$.length&&$[1]===$[2]&&$[3]===$[4]&&$[5]===$[6]?"#"+$[1]+$[3]+$[5]:$};function numberToHex($){var W=$.toString(16);return 1===W.length?"0"+W:W}function colorToHex($){return numberToHex(Math.round(255*$))}function convertToHex($,W,G){return yl("#"+colorToHex($)+colorToHex(W)+colorToHex(G))}function hslToHex($,W,G){return hslToRgb($,W,G,convertToHex)}function rgb($,W,G){if("number"==typeof $&&"number"==typeof W&&"number"==typeof G)return yl("#"+numberToHex($)+numberToHex(W)+numberToHex(G));if("object"==typeof $&&void 0===W&&void 0===G)return yl("#"+numberToHex($.red)+numberToHex($.green)+numberToHex($.blue));throw new sl(6)}function rgba($,W,G,oe){if("string"==typeof $&&"number"==typeof W){var ae=parseToRgb($);return"rgba("+ae.red+","+ae.green+","+ae.blue+","+W+")"}if("number"==typeof $&&"number"==typeof W&&"number"==typeof G&&"number"==typeof oe)return oe>=1?rgb($,W,G):"rgba("+$+","+W+","+G+","+oe+")";if("object"==typeof $&&void 0===W&&void 0===G&&void 0===oe)return $.alpha>=1?rgb($.red,$.green,$.blue):"rgba("+$.red+","+$.green+","+$.blue+","+$.alpha+")";throw new sl(7)}function toColorString($){if("object"!=typeof $)throw new sl(8);if(function isRgba2($){return"number"==typeof $.red&&"number"==typeof $.green&&"number"==typeof $.blue&&"number"==typeof $.alpha}($))return rgba($);if(function isRgb2($){return"number"==typeof $.red&&"number"==typeof $.green&&"number"==typeof $.blue&&("number"!=typeof $.alpha||void 0===$.alpha)}($))return rgb($);if(function isHsla2($){return"number"==typeof $.hue&&"number"==typeof $.saturation&&"number"==typeof $.lightness&&"number"==typeof $.alpha}($))return function hsla($,W,G,oe){if("number"==typeof $&&"number"==typeof W&&"number"==typeof G&&"number"==typeof oe)return oe>=1?hslToHex($,W,G):"rgba("+hslToRgb($,W,G)+","+oe+")";if("object"==typeof $&&void 0===W&&void 0===G&&void 0===oe)return $.alpha>=1?hslToHex($.hue,$.saturation,$.lightness):"rgba("+hslToRgb($.hue,$.saturation,$.lightness)+","+$.alpha+")";throw new sl(2)}($);if(function isHsl2($){return"number"==typeof $.hue&&"number"==typeof $.saturation&&"number"==typeof $.lightness&&("number"!=typeof $.alpha||void 0===$.alpha)}($))return function hsl($,W,G){if("number"==typeof $&&"number"==typeof W&&"number"==typeof G)return hslToHex($,W,G);if("object"==typeof $&&void 0===W&&void 0===G)return hslToHex($.hue,$.saturation,$.lightness);throw new sl(1)}($);throw new sl(8)}function curried($,W,G){return function fn2(){var oe=G.concat(Array.prototype.slice.call(arguments));return oe.length>=W?$.apply(this,oe):curried($,W,oe)}}function curry($){return curried($,$.length,[])}function guard($,W,G){return Math.max($,Math.min(W,G))}function darken($,W){if("transparent"===W)return W;var G=parseToHsl(W);return toColorString(_extends({},G,{lightness:guard(0,1,G.lightness-parseFloat($))}))}var bl=curry(darken);function lighten($,W){if("transparent"===W)return W;var G=parseToHsl(W);return toColorString(_extends({},G,{lightness:guard(0,1,G.lightness+parseFloat($))}))}var wl=curry(lighten);function transparentize($,W){if("transparent"===W)return W;var G=parseToRgb(W);return rgba(_extends({},G,{alpha:guard(0,1,+(100*("number"==typeof G.alpha?G.alpha:1)-100*parseFloat($)).toFixed(2)/100)}))}var Sl=curry(transparentize),xl=["absolute","fixed","relative","static","sticky"];function position($){for(var W=arguments.length,G=new Array(W>1?W-1:0),oe=1;oe<W;oe++)G[oe-1]=arguments[oe];return xl.indexOf($)>=0&&$?_extends({},directionalProperty.apply(void 0,[""].concat(G)),{position:$}):directionalProperty.apply(void 0,["",$].concat(G))}var kl=__toModule(mu).css`
  #pointer-root & {
    pointer-events: none;
  }
  #pointer-root.normal & {
    pointer-events: auto;
  }
`,_l={panel:{bg:"#282b2f",head:{title:{color:"#bbb"},punctuation:{color:"#808080"}},body:{compoudThing:{label:{get color(){return wl(.6,_l.panel.bg)}}}}}},Pl=__toModule(mu),El={get outlinePanel(){return 1},get propsPanel(){return El.outlinePanel},get sequenceEditorPanel(){return this.outlinePanel-1},get toolbar(){return this.outlinePanel+1},get pluginPanes(){return this.sequenceEditorPanel-1}},jl=_l.panel.bg,Cl=Pl.default.span`
  white-space: nowrap;
`,Ol=Pl.default.span`
  white-space: nowrap;
  color: ${_l.panel.head.punctuation.color};
`,Il=Pl.default.div`
  background: ${jl};
  flex-grow: 1;
  overflow-y: scroll;
  padding: 0;
`,Tl=Pl.default.div`
  height: ${20}px;
  box-sizing: border-box;
  display: flex;
  align-items: center;
  padding: 0 10px;
  position: relative;
  color: #adadadb3;
  border-bottom: 1px solid rgb(0 0 0 / 13%);
  background-color: #25272b;
  font-size: 10px;
  font-weight: 500;
  overflow: hidden;
  white-space: nowrap;
  text-overflow: ellipsis;
`,Dl=__toModule(W),Al=__toModule(vt.exports),$l=__toModule(mu),zl=__toModule(vt.exports),Ml=__toModule(vt.exports),Rl=__toModule(vt.exports),Bl=__toModule(vt.exports),Fl={color:void 0,size:void 0,className:void 0,style:void 0,attr:void 0},Nl=Bl.default.createContext&&Bl.default.createContext(Fl),__assign=function(){return __assign=Object.assign||function($){for(var W,G=1,oe=arguments.length;G<oe;G++)for(var ae in W=arguments[G])Object.prototype.hasOwnProperty.call(W,ae)&&($[ae]=W[ae]);return $},__assign.apply(this,arguments)};function Tree2Element($){return $&&$.map((function($,W){return Rl.default.createElement($.tag,__assign({key:W},$.attr),Tree2Element($.child))}))}function GenIcon($){return function(W){return Rl.default.createElement(IconBase,__assign({attr:__assign({},$.attr)},W),Tree2Element($.child))}}function IconBase($){var elem=function(W){var G,oe=$.attr,ae=$.size,ie=$.title,se=function($,W){var G={};for(var oe in $)Object.prototype.hasOwnProperty.call($,oe)&&W.indexOf(oe)<0&&(G[oe]=$[oe]);if(null!=$&&"function"==typeof Object.getOwnPropertySymbols){var ae=0;for(oe=Object.getOwnPropertySymbols($);ae<oe.length;ae++)W.indexOf(oe[ae])<0&&Object.prototype.propertyIsEnumerable.call($,oe[ae])&&(G[oe[ae]]=$[oe[ae]])}return G}($,["attr","size","title"]),le=ae||W.size||"1em";return W.className&&(G=W.className),$.className&&(G=(G?G+" ":"")+$.className),Rl.default.createElement("svg",__assign({stroke:"currentColor",fill:"currentColor",strokeWidth:"0"},W.attr,oe,se,{className:G,style:__assign(__assign({color:$.color||W.color},W.style),$.style),height:le,width:le,xmlns:"http://www.w3.org/2000/svg"}),ie&&Rl.default.createElement("title",null,ie),$.children)};return void 0!==Nl?Rl.default.createElement(Nl.Consumer,null,(function($){return elem($)})):elem(Fl)}function IoClose($){return GenIcon({tag:"svg",attr:{viewBox:"0 0 512 512"},child:[{tag:"path",attr:{d:"M289.94 256l95-95A24 24 0 00351 127l-95 95-95-95a24 24 0 00-34 34l95 95-95 95a24 24 0 1034 34l95-95 95 95a24 24 0 0034-34z"}}]})($)}function GoChevronLeft($){return GenIcon({tag:"svg",attr:{viewBox:"0 0 8 16"},child:[{tag:"path",attr:{fillRule:"evenodd",d:"M5.5 3L7 4.5 3.25 8 7 11.5 5.5 13l-5-5 5-5z"}}]})($)}function GoChevronRight($){return GenIcon({tag:"svg",attr:{viewBox:"0 0 8 16"},child:[{tag:"path",attr:{fillRule:"evenodd",d:"M7.5 8l-5 5L1 11.5 4.75 8 1 4.5 2.5 3l5 5z"}}]})($)}function DiHtml53DEffects($){return GenIcon({tag:"svg",attr:{version:"1.1",viewBox:"0 0 32 32"},child:[{tag:"path",attr:{d:"M16.957 6.062l-5.808 1.88 12.58 4.070v8.027l-8.383 2.711-7.074-2.287v-7.863l6.836 2.213 5.808-1.879-12.598-4.077-3.622 1.172v13.036l10.649 3.445 11.958-3.869v-13.23z"}}]})($)}function HiOutlineChevronRight($){return GenIcon({tag:"svg",attr:{fill:"none",viewBox:"0 0 24 24",stroke:"currentColor"},child:[{tag:"path",attr:{strokeLinecap:"round",strokeLinejoin:"round",strokeWidth:"2",d:"M9 5l7 7-7 7"}}]})($)}function CgSelect($){return GenIcon({tag:"svg",attr:{viewBox:"0 0 24 24",fill:"none"},child:[{tag:"path",attr:{d:"M6 9.65685L7.41421 11.0711L11.6569 6.82843L15.8995 11.0711L17.3137 9.65685L11.6569 4L6 9.65685Z",fill:"currentColor"}},{tag:"path",attr:{d:"M6 14.4433L7.41421 13.0291L11.6569 17.2717L15.8995 13.0291L17.3137 14.4433L11.6569 20.1001L6 14.4433Z",fill:"currentColor"}}]})($)}function VscListTree($){return GenIcon({tag:"svg",attr:{viewBox:"0 0 16 16",fill:"currentColor"},child:[{tag:"path",attr:{d:"M14 3v1H2V3h12zm-1 3v1H6V6h7zm0 3v1H5V9h8zm0 3v1H5v-1h8z"}},{tag:"path",attr:{d:"M5 4h1v9H5z"}}]})($)}function VscTriangleUp($){return GenIcon({tag:"svg",attr:{viewBox:"0 0 16 16",fill:"currentColor"},child:[{tag:"path",attr:{d:"M14 10.44l-.413.56H2.393L2 10.46 7.627 5h.827L14 10.44z"}}]})($)}var Ll=__toModule(mu),noop_default2=()=>{},Hl=Ll.default.li`
  margin: 0;
  padding: 0;
  list-style: none;
  display: flex;
  justify-content: flex-start;
  flex-direction: column;
  align-items: flex-start;
`,Vl=Ll.default.div``,ql=(0,Ll.default)(Vl)`
  padding-left: calc(4px + var(--depth) * 16px);
  padding-right: 8px;
  height: 28px;
  box-sizing: border-box;
  display: flex;
  flex-wrap: nowrap;
  align-items: center;
  pointer-events: none;
  white-space: nowrap;

  color: rgba(255, 255, 255, 0.75);
  --item-bg: ${"#3e4447"};
  --item-border-color: ${"#34343e"};

  &.descendant-is-selected {
    color: rgba(255, 255, 255, 0.9);

    --item-bg: #2e4244ed;
    --item-border-color: #254355;
  }

  &:hover {
    color: #fff;

    --item-bg: #1e5866;
    --item-border-color: #152f42;
  }

  &.selected {
    color: rgba(255, 255, 255, 0.9);

    --item-bg: #1e5866;
    --item-border-color: #152f42;
  }
`,Ul=Ll.css`
  font-weight: 500;
  font-size: 11px;
  & {
  }
`,Kl=Ll.default.span`
  ${Ul};

  padding: 2px 8px;
  ${kl};
  position: relative;
  display: flex;
  height: 17px;
  align-items: center;

  background-color: var(--item-bg);

  &:after {
    border: 1px solid var(--item-border-color);
    position: absolute;
    inset: 0px;
    display: block;
    content: ' ';
    z-index: -1;
    pointer-events: none;
    border-radius: 2px;
    box-sizing: border-box;
    box-shadow: 0px 3px 4px -1px rgba(0, 0, 0, 0.48);
  }

  // hit-zone
  &:before {
    position: absolute;
    inset: -1px -20px;
    display: block;
    content: ' ';
    z-index: 0;
    ${kl};
  }
`,Wl=Ll.default.span`
  width: 18px;
  box-sizing: border-box;
  height: 18px;
  margin-right: 4px;
  font-weight: 500;
  display: flex;
  align-items: center;
  justify-content: center;
  position: relative;
  opacity: 0.99;

  &:after {
    display: block;
    content: ' ';
    position: absolute;
    inset: 0px;
    z-index: -1;
    background-color: var(--item-bg);
    opacity: 0.6;
    border-radius: 2px;
  }
`,Gl=Ll.default.span`
  font-size: 9px;
  position: relative;
  display: block;
  transform: rotateZ(${$=>$.isOpen?90:0}deg);
`,Xl=Ll.default.ul`
  margin: 0;
  padding: 0;
  list-style: none;
`,BaseItem_default=({label:$,children:W,depth:G,select:oe,selectionStatus:ae,labelDecoration:ie})=>{const se=void 0!==W;return Ml.default.createElement(Hl,{style:{"--depth":G}},Ml.default.createElement(ql,{className:ae,onClick:null!=oe?oe:noop_default2},Ml.default.createElement(Wl,null,se?Ml.default.createElement(Gl,{isOpen:!0},Ml.default.createElement(GoChevronRight,null)):Ml.default.createElement(DiHtml53DEffects,null)),Ml.default.createElement(Kl,null,Ml.default.createElement("span",null,$)),ie),se&&Ml.default.createElement(Xl,null,W))},Yl=__toModule(W),getOutlineSelection=()=>{var $;const W=(0,Yl.val)(getStudio().projectsP),G=(null!=($=(0,Yl.val)(getStudio().atomP.historic.panels.outlinePanel.selection))?$:[]).map(($=>{const G=W[$.projectId];if(!G)return;if("Project"===$.type)return G;if(!(0,Yl.val)(G.sheetTemplatesP[$.sheetId]))return;const oe=getSelectedInstanceOfSheetId(G,$.sheetId);if(!oe)return;if("Sheet"===$.type)return oe;const ae=(0,Yl.val)(oe.objectsP[$.objectKey]);return ae||void 0}));return Ks(G.filter(($=>void 0!==$)))},getSelectedInstanceOfSheetId=($,W)=>{const G=getStudio().atomP.historic.projects.stateByProjectId[$.address.projectId],oe=(0,Yl.val)(G.stateBySheetId[W].selectedInstanceId),ae=(0,Yl.val)($.sheetTemplatesP[W]);if(ae){if(oe)return(0,Yl.val)(ae.instancesP[oe]);{const $=(0,Yl.val)(ae.instancesP);return $[Object.keys($)[0]]}}};var Jl=__toModule(vt.exports),Ql=__toModule(W),Zl=__toModule(vt.exports),eu=__toModule(mu),tu=__toModule(vt.exports),ru=__toModule(mu),nu=__toModule(W),ou=__toModule(vt.exports),au=__toModule(mu),iu=__toModule(vt.exports),ObjectItem=({sheetObject:$,depth:W})=>{const G=usePrism((()=>getOutlineSelection()),[]);return iu.default.createElement(BaseItem_default,{select:()=>{getStudio().transaction((({stateEditors:W})=>{W.studio.historic.panels.outline.selection.set([$])}))},label:$.address.objectKey,depth:W,selectionStatus:G.includes($)?"selected":"not-selected"})};au.default.li`
  color: ${$=>$.isSelected?"white":"hsl(1, 1%, 80%)"};
`;var ObjectsList_default=({sheet:$,depth:W})=>usePrism((()=>{const G=(0,nu.val)($.objectsP),oe=Object.entries(G);return ou.default.createElement(ou.default.Fragment,null,oe.map((([$,G])=>ou.default.createElement(ObjectItem,{depth:W,key:"objectPath("+$+")",sheetObject:G}))))}),[$,W]),su=ru.default.div`
  display: flex;
`;ru.default.li`
  color: ${$=>$.isSelected?"white":"hsl(1, 1%, 80%)"};
`;var lu=ru.default.div``,SheetInstanceItem=({sheet:$,depth:W})=>{const G=(0,tu.useCallback)((()=>{getStudio().transaction((({stateEditors:W})=>{W.studio.historic.panels.outline.selection.set([$])}))}),[$]);return usePrism((()=>{const oe=getOutlineSelection();return tu.default.createElement(BaseItem_default,{depth:W,select:G,selectionStatus:oe.some((W=>W===$))?"selected":oe.some((W=>"Theatre_SheetObject"===W.type&&W.sheet===$))?"descendant-is-selected":"not-selected",label:tu.default.createElement(su,null,$.address.sheetId,": ",$.address.sheetInstanceId)},tu.default.createElement(lu,null,tu.default.createElement(ObjectsList_default,{depth:W+1,sheet:$,key:"objectList"+$.address.sheetInstanceId})))}),[W])};eu.default.div`
  display: flex;
`,eu.default.li`
  color: ${$=>$.isSelected?"white":"hsl(1, 1%, 80%)"};
`,eu.default.div``;var SheetItem=({sheetId:$,depth:W,project:G})=>usePrism((()=>{const oe=(0,Ql.val)(G.sheetTemplatesP[$]);if(!oe)return Zl.default.createElement(Zl.default.Fragment,null);const ae=(0,Ql.val)(oe.instancesP);return Zl.default.createElement(Zl.default.Fragment,null,Object.entries(ae).map((([$,G])=>Zl.default.createElement(SheetInstanceItem,{key:G.address.sheetInstanceId,sheet:G,depth:W}))))}),[W,$,G]),SheetsList_default=({project:$,depth:W})=>usePrism((()=>{if(!$)return null;const G=function getRegisteredSheetIds($){return Object.keys((0,Yl.val)($.sheetTemplatesP))}($);return Jl.default.createElement(Jl.default.Fragment,null,G.map((G=>Jl.default.createElement(SheetItem,{depth:W,sheetId:G,key:`sheet-${G}`,project:$}))))}),[$,W]),uu=__toModule(W),cu=__toModule(mu).default.div`
  color: #ff6363;
  margin-left: 11px;
  background: #4c282d;
  padding: 2px 8px;
  border-radius: 2px;
  font-size: 10px;
  box-shadow: 0 2px 8px -4px black;
`,ProjectListItem_default=({depth:$,project:W})=>{const G=usePrism((()=>getOutlineSelection()),[]),oe=usePrism((()=>{const $=W.address.projectId,G=(0,uu.val)(getStudio().atomP.ephemeral.coreByProject[$].loadingState);return"browserStateIsNotBasedOnDiskState"===(null==G?void 0:G.type)}),[W]),ae=(0,zl.useCallback)((()=>{getStudio().transaction((({stateEditors:$})=>{$.studio.historic.panels.outline.selection.set([W])}))}),[W]);return zl.default.createElement(BaseItem_default,{depth:$,label:W.address.projectId,labelDecoration:oe?zl.default.createElement(cu,null,"Has Conflicts"):null,children:zl.default.createElement(SheetsList_default,{project:W,depth:$+1}),selectionStatus:G.includes(W)?"selected":G.some(($=>$.address.projectId===W.address.projectId))?"descendant-is-selected":"not-selected",select:ae})},du=$l.default.ul`
  list-style: none;
  margin: 0;
  padding: 0;
  padding-right: 4px;
`,ProjectsList_default=$=>usePrism((()=>{const $=(0,Dl.val)(getStudio().projectsP);return Al.default.createElement(du,null,Object.keys($).map((W=>{const G=$[W];return Al.default.createElement(ProjectListItem_default,{depth:0,project:G,key:`projectListItem-${W}`})})))}),[]),fu=__toModule(mu),pu=__toModule(vt.exports),hu=__toModule(vt.exports);function useRefAndState($){const W=(0,hu.useMemo)((()=>{let W=$;return{get current(){return W},set current($){W=$,oe($)}}}),[]),[G,oe]=(0,hu.useState)((()=>$));return[W,G]}var gu=__toModule(vt.exports),vu=__toModule(vt.exports),yu=__toModule(vt.exports),bu=__toModule(vt.exports),wu=__toModule(vt.exports),Su=__toModule(vt.exports),xu=__toModule(vt.exports),ku=__toModule(vt.exports),_u=__toModule(vt.exports),useEffectOnce_default=function($){(0,_u.useEffect)($,[])},useUnmount_default=function($){var W=(0,ku.useRef)($);W.current=$,useEffectOnce_default((function(){return function(){return W.current()}}))},useRafState_default=function($){var W=(0,xu.useRef)(0),G=(0,xu.useState)($),oe=G[0],ae=G[1],ie=(0,xu.useCallback)((function($){cancelAnimationFrame(W.current),W.current=requestAnimationFrame((function(){ae($)}))}),[]);return useUnmount_default((function(){cancelAnimationFrame(W.current)})),[oe,ie]};var Pu="undefined"!=typeof window,useWindowSize_default=function($,W){void 0===$&&($=1/0),void 0===W&&(W=1/0);var G=useRafState_default({width:Pu?window.innerWidth:$,height:Pu?window.innerHeight:W}),oe=G[0],ae=G[1];return(0,Su.useEffect)((function(){if(Pu){var handler_1=function(){ae({width:window.innerWidth,height:window.innerHeight})};return function on($){for(var W=[],G=1;G<arguments.length;G++)W[G-1]=arguments[G];$&&$.addEventListener&&$.addEventListener.apply($,W)}(window,"resize",handler_1),function(){!function off($){for(var W=[],G=1;G<arguments.length;G++)W[G-1]=arguments[G];$&&$.removeEventListener&&$.removeEventListener.apply($,W)}(window,"resize",handler_1)}}}),[]),oe},Eu=__toModule(vt.exports);function useBoundingClientRect($){const[W,G]=(0,Eu.useState)(null);return(0,Eu.useLayoutEffect)((()=>($&&G($.getBoundingClientRect()),()=>{G(null)})),[$]),W}var ju=(0,__toModule(vt.exports).createContext)({}),Cu=__toModule(vt.exports);var TooltipWrapper_default=$=>{var W;const G=$.children(),[oe,ae]=useRefAndState(null),ie=G.props.style?__spreadValues({},G.props.style):{};ie.position="absolute";const se=useBoundingClientRect(ae),le=useBoundingClientRect($.target),ue=useWindowSize_default(),[de,pe]=(0,wu.useState)({});return(0,wu.useLayoutEffect)((()=>{if(!se||!ae||!le)return;const W={};let G="bottom",oe=0,ie=0;le.bottom+se.height+8<ue.height?(G="bottom",oe=le.bottom+8,W.top="0px"):le.top>se.height+8?(G="top",oe=le.top-(se.height+8),W.bottom="0px",W.transform="rotateZ(180deg)"):G="overlay";let de=0;if("overlay"!==G){const $=le.left+le.width/2;$<se.width/2?(ie=8,de=Math.max($-8,8)):$+se.width/2>ue.width?(ie=ue.width-(8+se.width),de=Math.min($-ie,se.width-8)):(ie=$-se.width/2,de=se.width/2),W.left=de+"px"}const he=ie,ge=oe;return ae.style.left=he+"px",ae.style.top=ge+"px",pe(W),$.onPointerOutside?function onPointerOutside($,W,G){const oe=$.getBoundingClientRect(),onMouseMove=$=>{($.clientX<oe.left-W||$.clientX>oe.left+oe.width+W||$.clientY<oe.top-W||$.clientY>oe.top+oe.height+W)&&G($)};return window.addEventListener("mousemove",onMouseMove),()=>{window.removeEventListener("mousemove",onMouseMove)}}(ae,$.onPointerOutside.threshold,$.onPointerOutside.callback):void 0}),[se,ae,$.target,le,ue]),function useOnClickOutside($,W){(0,Cu.useEffect)((()=>{if(!$)return;const onMouseDown=G=>{G.composedPath().includes($)||W(G)};return window.addEventListener("mousedown",onMouseDown,{capture:!0}),()=>{window.removeEventListener("mousedown",onMouseDown,{capture:!0})}}),[$,W])}(ae,null!=(W=$.onClickOutside)?W:noop_default2),bu.default.createElement(ju.Provider,{value:de},(0,wu.cloneElement)(G,{ref:oe,style:ie}))},Ou=__toModule(Vt.exports),Iu=__toModule(W),Tu=__toModule(vt.exports),Du=(0,Tu.createContext)(null),Au=0,TooltipContext_default=({children:$})=>{const W=(0,Tu.useMemo)((()=>new Iu.Box(-1)),[]),G=W.derivation,oe=(0,Tu.useMemo)((()=>{let $;return(G,oe)=>{const ae=void 0!==$;void 0!==$&&(clearTimeout($),$=void 0),0===oe||ae?W.set(G):$=setTimeout((()=>{W.set(G),$=void 0}),oe)}}),[]);return Tu.default.createElement(Du.Provider,{value:{cur:G,set:oe}},$)};function _defineProperty($,W,G){return W in $?Object.defineProperty($,W,{value:G,enumerable:!0,configurable:!0,writable:!0}):$[W]=G,$}function ownKeys($,W){var G=Object.keys($);if(Object.getOwnPropertySymbols){var oe=Object.getOwnPropertySymbols($);W&&(oe=oe.filter((function(W){return Object.getOwnPropertyDescriptor($,W).enumerable}))),G.push.apply(G,oe)}return G}function _objectSpread2($){for(var W=1;W<arguments.length;W++){var G=null!=arguments[W]?arguments[W]:{};W%2?ownKeys(Object(G),!0).forEach((function(W){_defineProperty($,W,G[W])})):Object.getOwnPropertyDescriptors?Object.defineProperties($,Object.getOwnPropertyDescriptors(G)):ownKeys(Object(G)).forEach((function(W){Object.defineProperty($,W,Object.getOwnPropertyDescriptor(G,W))}))}return $}function _objectWithoutPropertiesLoose($,W){if(null==$)return{};var G,oe,ae={},ie=Object.keys($);for(oe=0;oe<ie.length;oe++)G=ie[oe],W.indexOf(G)>=0||(ae[G]=$[G]);return ae}var $u=__toModule(vt.exports),zu=(0,__toModule(vt.exports).createContext)({});function _defineProperty2($,W,G){return W in $?Object.defineProperty($,W,{value:G,enumerable:!0,configurable:!0,writable:!0}):$[W]=G,$}function ownKeys2($,W){var G=Object.keys($);if(Object.getOwnPropertySymbols){var oe=Object.getOwnPropertySymbols($);W&&(oe=oe.filter((function(W){return Object.getOwnPropertyDescriptor($,W).enumerable}))),G.push.apply(G,oe)}return G}function _objectSpread22($){for(var W=1;W<arguments.length;W++){var G=null!=arguments[W]?arguments[W]:{};W%2?ownKeys2(Object(G),!0).forEach((function(W){_defineProperty2($,W,G[W])})):Object.getOwnPropertyDescriptors?Object.defineProperties($,Object.getOwnPropertyDescriptors(G)):ownKeys2(Object(G)).forEach((function(W){Object.defineProperty($,W,Object.getOwnPropertyDescriptor(G,W))}))}return $}function _objectWithoutPropertiesLoose2($,W){if(null==$)return{};var G,oe,ae={},ie=Object.keys($);for(oe=0;oe<ie.length;oe++)G=ie[oe],W.indexOf(G)>=0||(ae[G]=$[G]);return ae}function _arrayLikeToArray($,W){(null==W||W>$.length)&&(W=$.length);for(var G=0,oe=new Array(W);G<W;G++)oe[G]=$[G];return oe}function _createForOfIteratorHelperLoose($,W){var G;if("undefined"==typeof Symbol||null==$[Symbol.iterator]){if(Array.isArray($)||(G=function _unsupportedIterableToArray($,W){if($){if("string"==typeof $)return _arrayLikeToArray($,W);var G=Object.prototype.toString.call($).slice(8,-1);return"Object"===G&&$.constructor&&(G=$.constructor.name),"Map"===G||"Set"===G?Array.from($):"Arguments"===G||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(G)?_arrayLikeToArray($,W):void 0}}($))||W&&$&&"number"==typeof $.length){G&&($=G);var oe=0;return function(){return oe>=$.length?{done:!0}:{done:!1,value:$[oe++]}}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}return(G=$[Symbol.iterator]()).next.bind(G)}var Mu=__toModule(vt.exports);var Ru=function useCreateElement2($,W,G){void 0===G&&(G=W.children);var oe=(0,Mu.useContext)(zu);return oe.useCreateElement?oe.useCreateElement($,W,G):"string"==typeof $&&function isRenderProp($){return"function"==typeof $}(G)?(W.children,G(_objectWithoutPropertiesLoose2(W,["children"]))):(0,Mu.createElement)($,W,G)};function _defineProperty3($,W,G){return W in $?Object.defineProperty($,W,{value:G,enumerable:!0,configurable:!0,writable:!0}):$[W]=G,$}function ownKeys3($,W){var G=Object.keys($);if(Object.getOwnPropertySymbols){var oe=Object.getOwnPropertySymbols($);W&&(oe=oe.filter((function(W){return Object.getOwnPropertyDescriptor($,W).enumerable}))),G.push.apply(G,oe)}return G}function _objectSpread23($){for(var W=1;W<arguments.length;W++){var G=null!=arguments[W]?arguments[W]:{};W%2?ownKeys3(Object(G),!0).forEach((function(W){_defineProperty3($,W,G[W])})):Object.getOwnPropertyDescriptors?Object.defineProperties($,Object.getOwnPropertyDescriptors(G)):ownKeys3(Object(G)).forEach((function(W){Object.defineProperty($,W,Object.getOwnPropertyDescriptor(G,W))}))}return $}function _arrayLikeToArray2($,W){(null==W||W>$.length)&&(W=$.length);for(var G=0,oe=new Array(W);G<W;G++)oe[G]=$[G];return oe}function _createForOfIteratorHelperLoose2($,W){var G;if("undefined"==typeof Symbol||null==$[Symbol.iterator]){if(Array.isArray($)||(G=function _unsupportedIterableToArray2($,W){if($){if("string"==typeof $)return _arrayLikeToArray2($,W);var G=Object.prototype.toString.call($).slice(8,-1);return"Object"===G&&$.constructor&&(G=$.constructor.name),"Map"===G||"Set"===G?Array.from($):"Arguments"===G||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(G)?_arrayLikeToArray2($,W):void 0}}($))||W&&$&&"number"==typeof $.length){G&&($=G);var oe=0;return function(){return oe>=$.length?{done:!0}:{done:!1,value:$[oe++]}}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}return(G=$[Symbol.iterator]()).next.bind(G)}function isPlainObject2($){var W;if(!function isObject2($){return"object"==typeof $&&null!=$}($))return!1;var G=Object.getPrototypeOf($);return null==G||(null===(W=G.constructor)||void 0===W?void 0:W.toString())===Object.toString()}function __deprecatedSplitProps($,W){for(var G={},oe={},ae=0,ie=Object.keys($);ae<ie.length;ae++){var se=ie[ae];W.indexOf(se)>=0?G[se]=$[se]:oe[se]=$[se]}return[G,oe]}function splitProps($,W){if(void 0===W&&(W=[]),!isPlainObject2($.state))return __deprecatedSplitProps($,W);var G=__deprecatedSplitProps($,[].concat(W,["state"])),oe=G[0],ae=G[1],ie=oe.state,se=function _objectWithoutPropertiesLoose3($,W){if(null==$)return{};var G,oe,ae={},ie=Object.keys($);for(oe=0;oe<ie.length;oe++)G=ie[oe],W.indexOf(G)>=0||(ae[G]=$[G]);return ae}(oe,["state"]);return[_objectSpread23(_objectSpread23({},ie),se),ae]}function shallowEqual($,W){if($===W)return!0;if(!$)return!1;if(!W)return!1;if("object"!=typeof $)return!1;if("object"!=typeof W)return!1;var G=Object.keys($),oe=Object.keys(W),ae=G.length;if(oe.length!==ae)return!1;for(var ie=0,se=G;ie<se.length;ie++){var le=se[ie];if($[le]!==W[le])return!1}return!0}function normalizePropsAreEqual($){return"normalizePropsAreEqualInner"===$.name?$:function normalizePropsAreEqualInner(W,G){return isPlainObject2(W.state)&&isPlainObject2(G.state)?$(_objectSpread23(_objectSpread23({},W.state),W),_objectSpread23(_objectSpread23({},G.state),G)):$(W,G)}}function createComponent($){var W=$.as,G=$.useHook,oe=$.memo,ae=$.propsAreEqual,ie=void 0===ae?null==G?void 0:G.unstable_propsAreEqual:ae,se=$.keys,le=void 0===se?(null==G?void 0:G.__keys)||[]:se,ue=$.useCreateElement,de=void 0===ue?Ru:ue,pe=function Comp2($,oe){var ae=$.as,ie=void 0===ae?W:ae,se=_objectWithoutPropertiesLoose2($,["as"]);if(G){var ue,pe=splitProps(se,le),he=pe[0],ge=pe[1],ve=G(he,_objectSpread22({ref:oe},ge)),we=ve.wrapElement,Se=_objectWithoutPropertiesLoose2(ve,["wrapElement"]),Pe=(null===(ue=ie.render)||void 0===ue?void 0:ue.__keys)||ie.__keys,je=Pe&&splitProps(se,Pe)[0],Ie=je?_objectSpread22(_objectSpread22({},Se),je):Se,De=de(ie,Ie);return we?we(De):De}return de(ie,_objectSpread22({ref:oe},se))};return G&&(pe.displayName=G.name.replace(/^(unstable_)?use/,"")),pe=function forwardRef($){return(0,$u.forwardRef)($)}(pe),oe&&(pe=function memo($,W){return(0,$u.memo)($,W)}(pe,ie&&normalizePropsAreEqual(ie))),pe.__keys=le,pe.unstable_propsAreEqual=normalizePropsAreEqual(ie||shallowEqual),pe}__toModule(vt.exports);var Bu=__toModule(vt.exports);function useToken($,W){(0,Bu.useDebugValue)($);var G=(0,Bu.useContext)(zu);return null!=G[$]?G[$]:W}var Fu=__toModule(vt.exports);var Nu=__toModule(vt.exports);function createHook($){var W,G,oe=function toArray($){return Array.isArray($)?$:void 0!==$?[$]:[]}($.compose),ae=function __useOptions2(W,G){if($.useOptions&&(W=$.useOptions(W,G)),$.name&&(W=function useOptions($,W,G){void 0===W&&(W={}),void 0===G&&(G={});var oe="use"+$+"Options";(0,Nu.useDebugValue)(oe);var ae=useToken(oe);return ae?_objectSpread22(_objectSpread22({},W),ae(W,G)):W}($.name,W,G)),$.compose)for(var ae,ie=_createForOfIteratorHelperLoose(oe);!(ae=ie()).done;){W=ae.value.__useOptions(W,G)}return W},ie=function useHook2(W,G,ie){if(void 0===W&&(W={}),void 0===G&&(G={}),void 0===ie&&(ie=!1),ie||(W=ae(W,G)),$.useProps&&(G=$.useProps(W,G)),$.name&&(G=function useProps($,W,G){void 0===W&&(W={}),void 0===G&&(G={});var oe="use"+$+"Props";(0,Fu.useDebugValue)(oe);var ae=useToken(oe);return ae?ae(W,G):G}($.name,W,G)),$.compose)if($.useComposeOptions&&(W=$.useComposeOptions(W,G)),$.useComposeProps)G=$.useComposeProps(W,G);else for(var se,le=_createForOfIteratorHelperLoose(oe);!(se=le()).done;){G=(0,se.value)(W,G,!0)}var ue={},de=G||{};for(var pe in de)void 0!==de[pe]&&(ue[pe]=de[pe]);return ue};ie.__useOptions=ae;var se=oe.reduce((function($,W){return $.push.apply($,W.__keys||[]),$}),[]);return ie.__keys=[].concat(se,(null===(W=$.useState)||void 0===W?void 0:W.__keys)||[],$.keys||[]),ie.unstable_propsAreEqual=$.propsAreEqual||(null===(G=oe[0])||void 0===G?void 0:G.unstable_propsAreEqual)||shallowEqual,$.name&&Object.defineProperty(ie,"name",{value:"use"+$.name}),ie}__toModule(vt.exports);var Lu=__toModule(vt.exports);function setRef($,W){void 0===W&&(W=null),$&&("function"==typeof $?$(W):$.current=W)}function useForkRef($,W){return(0,Lu.useMemo)((function(){return null==$&&null==W?null:function(G){setRef($,G),setRef(W,G)}}),[$,W])}var Hu=["button","color","file","image","reset","submit"];function isButton($){if("BUTTON"===$.tagName)return!0;if("INPUT"===$.tagName){var W=$;return-1!==Hu.indexOf(W.type)}return!1}function flatten($){for(var W,G=[],oe=_createForOfIteratorHelperLoose2($);!(W=oe()).done;){var ae=W.value;Array.isArray(ae)?G.push.apply(G,flatten(ae)):G.push(ae)}return G}function warning($){var W;if($){for(var G=arguments.length,oe=new Array(G>1?G-1:0),ae=1;ae<G;ae++)oe[ae-1]=arguments[ae];var ie=flatten(oe.map((function($){return[$,"\n"]})));(W=console).warn.apply(W,ie.slice(0,-1));try{throw Error(ie.join(""))}catch($){}}}__toModule(vt.exports),__toModule(vt.exports);var Vu,qu=__toModule(vt.exports);function getDocument($){return $?$.ownerDocument||$:document}try{Vu=window}catch($){}var Uu=function checkIsBrowser(){var $=function getWindow($){return $&&getDocument($).defaultView||Vu}();return Boolean(void 0!==$&&$.document&&$.document.createElement)}(),Ku=__toModule(vt.exports),Wu=Uu?Ku.useLayoutEffect:Ku.useEffect;function useLiveRef($){var W=(0,qu.useRef)($);return Wu((function(){W.current=$})),W}function contains($,W){return $===W||$.contains(W)}function hasFocusWithin($){var W=function getActiveElement($){var W=getDocument($).activeElement;return null!=W&&W.nodeName?W:null}($);if(!W)return!1;if(contains($,W))return!0;var G=W.getAttribute("aria-activedescendant");return!!G&&(G===$.id||!!$.querySelector("#"+G))}function isUA($){return!!Uu&&-1!==window.navigator.userAgent.indexOf($)}var Gu=createHook({name:"Role",keys:["unstable_system"],propsAreEqual:function propsAreEqual($,W){var G=$.unstable_system,oe=_objectWithoutPropertiesLoose($,["unstable_system"]),ae=W.unstable_system,ie=_objectWithoutPropertiesLoose(W,["unstable_system"]);return!(G!==ae&&!shallowEqual(G,ae))&&shallowEqual(oe,ie)}});createComponent({as:"div",useHook:Gu});var Xu=__toModule(vt.exports),Yu=isUA("Mac")&&!isUA("Chrome")&&(isUA("Safari")||isUA("Firefox"));function focusIfNeeded($){!hasFocusWithin($)&&function isFocusable($){return function matches($,W){return"matches"in $?$.matches(W):"msMatchesSelector"in $?$.msMatchesSelector(W):$.webkitMatchesSelector(W)}($,"input:not([type='hidden']):not([disabled]), select:not([disabled]), textarea:not([disabled]), a[href], button:not([disabled]), [tabindex], iframe, object, embed, area[href], audio[controls], video[controls], [contenteditable]:not([contenteditable='false'])")&&function isVisible($){var W=$;return W.offsetWidth>0||W.offsetHeight>0||$.getClientRects().length>0}($)}($)&&$.focus()}function getTabIndex($,W,G,oe){return $?W&&!G?-1:void 0:W?oe:oe||0}function useDisableEvent($,W){return(0,Xu.useCallback)((function(G){var oe;null===(oe=$.current)||void 0===oe||oe.call($,G),G.defaultPrevented||W&&(G.stopPropagation(),G.preventDefault())}),[$,W])}var Ju=createHook({name:"Tabbable",compose:Gu,keys:["disabled","focusable"],useOptions:function useOptions2($,W){return _objectSpread2({disabled:W.disabled},$)},useProps:function useProps2($,W){var G=W.ref,oe=W.tabIndex,ae=W.onClickCapture,ie=W.onMouseDownCapture,se=W.onMouseDown,le=W.onKeyPressCapture,ue=W.style,de=_objectWithoutPropertiesLoose(W,["ref","tabIndex","onClickCapture","onMouseDownCapture","onMouseDown","onKeyPressCapture","style"]),pe=(0,Xu.useRef)(null),he=useLiveRef(ae),ge=useLiveRef(ie),ve=useLiveRef(se),we=useLiveRef(le),Se=!!$.disabled&&!$.focusable,Pe=(0,Xu.useState)(!0),je=Pe[0],Ie=Pe[1],De=(0,Xu.useState)(!0),$e=De[0],Le=De[1],Ke=$.disabled?_objectSpread2({pointerEvents:"none"},ue):ue;Wu((function(){var $=pe.current;$?(function isNativeTabbable($){return"BUTTON"===$.tagName||"INPUT"===$.tagName||"SELECT"===$.tagName||"TEXTAREA"===$.tagName||"A"===$.tagName}($)||Ie(!1),function supportsDisabledAttribute($){return"BUTTON"===$.tagName||"INPUT"===$.tagName||"SELECT"===$.tagName||"TEXTAREA"===$.tagName}($)||Le(!1)):warning(!0,"Can't determine if the element is a native tabbable element because `ref` wasn't passed to the component.","See https://reakit.io/docs/tabbable")}),[]);var Ge=useDisableEvent(he,$.disabled),Xe=useDisableEvent(ge,$.disabled),Ye=useDisableEvent(we,$.disabled),Je=(0,Xu.useCallback)((function($){var W;null===(W=ve.current)||void 0===W||W.call(ve,$);var G=$.currentTarget;if(!$.defaultPrevented&&Yu&&!function isPortalEvent($){return!contains($.currentTarget,$.target)}($)&&isButton(G)){var oe=requestAnimationFrame((function(){G.removeEventListener("mouseup",ae,!0),focusIfNeeded(G)})),ae=function focusImmediately2(){cancelAnimationFrame(oe),focusIfNeeded(G)};G.addEventListener("mouseup",ae,{once:!0,capture:!0})}}),[]);return _objectSpread2({ref:useForkRef(pe,G),style:Ke,tabIndex:getTabIndex(Se,je,$e,oe),disabled:!(!Se||!$e)||void 0,"aria-disabled":!!$.disabled||void 0,onClickCapture:Ge,onMouseDownCapture:Xe,onMouseDown:Je,onKeyPressCapture:Ye},de)}});createComponent({as:"div",useHook:Ju});var Qu=__toModule(vt.exports);var Zu=createHook({name:"Clickable",compose:Ju,keys:["unstable_clickOnEnter","unstable_clickOnSpace"],useOptions:function useOptions3($){var W=$.unstable_clickOnEnter,G=void 0===W||W,oe=$.unstable_clickOnSpace;return _objectSpread2({unstable_clickOnEnter:G,unstable_clickOnSpace:void 0===oe||oe},_objectWithoutPropertiesLoose($,["unstable_clickOnEnter","unstable_clickOnSpace"]))},useProps:function useProps3($,W){var G=W.onKeyDown,oe=W.onKeyUp,ae=_objectWithoutPropertiesLoose(W,["onKeyDown","onKeyUp"]),ie=(0,Qu.useState)(!1),se=ie[0],le=ie[1],ue=useLiveRef(G),de=useLiveRef(oe),pe=(0,Qu.useCallback)((function(W){var G;if(null===(G=ue.current)||void 0===G||G.call(ue,W),!W.defaultPrevented&&!$.disabled&&!W.metaKey&&function isSelfTarget($){return $.target===$.currentTarget}(W)){var oe=$.unstable_clickOnEnter&&"Enter"===W.key,ae=$.unstable_clickOnSpace&&" "===W.key;if(oe||ae){if(function isNativeClick($){var W=$.currentTarget;return!!$.isTrusted&&(isButton(W)||"INPUT"===W.tagName||"TEXTAREA"===W.tagName||"A"===W.tagName||"SELECT"===W.tagName)}(W))return;W.preventDefault(),oe?W.currentTarget.click():ae&&le(!0)}}}),[$.disabled,$.unstable_clickOnEnter,$.unstable_clickOnSpace]),he=(0,Qu.useCallback)((function(W){var G;if(null===(G=de.current)||void 0===G||G.call(de,W),!W.defaultPrevented&&!$.disabled&&!W.metaKey){var oe=$.unstable_clickOnSpace&&" "===W.key;se&&oe&&(le(!1),W.currentTarget.click())}}),[$.disabled,$.unstable_clickOnSpace,se]);return _objectSpread2({"data-active":se||void 0,onKeyDown:pe,onKeyUp:he},ae)}});createComponent({as:"button",memo:!0,useHook:Zu});var ec=__toModule(vt.exports),nc=createComponent({as:"button",memo:!0,useHook:createHook({name:"Button",compose:Zu,keys:[],useProps:function useProps4($,W){var G=W.ref,oe=_objectWithoutPropertiesLoose(W,["ref"]),ae=(0,ec.useRef)(null),ie=(0,ec.useState)(void 0),se=ie[0],le=ie[1],ue=(0,ec.useState)("button"),de=ue[0],pe=ue[1];return(0,ec.useEffect)((function(){var $=ae.current;$?isButton($)||("A"!==$.tagName&&le("button"),pe(void 0)):warning(!0,"Can't determine whether the element is a native button because `ref` wasn't passed to the component","See https://reakit.io/docs/button")}),[]),_objectSpread2({ref:useForkRef(ae,G),role:se,type:de},oe)}})}),oc=createComponent({as:"div",useHook:createHook({name:"Group",compose:Gu,keys:[],useProps:function useProps5($,W){return _objectSpread2({role:"group"},W)}})});__toModule(Vt.exports);var ic=__toModule(vt.exports);__toModule(Vt.exports);var lc,fc=(0,ic.createContext)(function getBodyElement(){return Uu?document.body:null}());function useTooltip($,W){const G=!1!==$.enabled,[oe,ae]=(()=>{const $=(0,Tu.useMemo)((()=>Au++),[]),{cur:W,set:G}=(0,Tu.useContext)(Du),[oe,ae]=useRefAndState(!1),ie=(0,Tu.useCallback)(((W,oe)=>{G(W?$:-1,oe)}),[]);return(0,Tu.useEffect)((()=>W.changesWithoutValues().tap((()=>{const G=W.getValue()===$;oe.current!==G&&(oe.current=G)}))),[W,$]),[ae,ie]})(),[ie,se]=useRefAndState(null);(0,vu.useEffect)((()=>{if(!G)return;const W=ie.current;if(!W)return;const onMouseEnter=()=>{var W;return ae(!0,null!=(W=$.enterDelay)?W:400)},onMouseLeave=()=>{var W;return ae(!1,null!=(W=$.exitDelay)?W:200)};return W.addEventListener("mouseenter",onMouseEnter),W.addEventListener("mouseleave",onMouseLeave),()=>{W.removeEventListener("mouseenter",onMouseEnter),W.removeEventListener("mouseleave",onMouseLeave)}}),[ie,G,$.enterDelay,$.exitDelay]);const le=(0,gu.useContext)(fc);return[G&&oe&&se?(0,Ou.createPortal)(yu.default.createElement(TooltipWrapper_default,{children:W,target:se,onClickOutside:noop_default2}),le):yu.default.createElement(yu.default.Fragment,null),ie,oe]}"undefined"!=typeof window&&(lc={get passive(){}},window.addEventListener("testPassive",null,lc),window.removeEventListener("testPassive",null,lc)),"undefined"!=typeof window&&window.navigator&&window.navigator.platform&&(/iP(ad|hone|od)/.test(window.navigator.platform)||"MacIntel"===window.navigator.platform&&window.navigator.maxTouchPoints);var pc=function mergeRefs($){return function(W){$.forEach((function($){"function"==typeof $?$(W):null!=$&&($.current=W)}))}},hc=__toModule(mu),mc=__toModule(mu),gc=__toModule(vt.exports),kc=__toModule(mu),_c=__toModule(vt.exports),Ec=__toModule(mu),jc=Ec.default.div`
  position: absolute;
  width: 0;
  height: 0;
  color: var(--popover-arrow-color);
  pointer-events: none;
`,Oc=Ec.default.div`
  width: 12px;
  height: 8px;
  position: absolute;
  left: -7px;
  top: -8px;
  text-align: center;
  line-height: 0;
`,Ic=Ec.default.path`
  fill: var(--popover-bg);
`,Mc=Ec.default.path`
  fill: var(--popover-inner-stroke);
`,Fc=Ec.default.path`
  fill: var(--popover-outer-stroke);
`,Nc=(0,_c.forwardRef)((({className:$},W)=>{const G=(0,_c.useContext)(ju);return _c.default.createElement(jc,{className:$,ref:W,style:__spreadValues({},G)},_c.default.createElement(Oc,null,_c.default.createElement("svg",{width:"12",height:"8",viewBox:"0 0 12 8",fill:"none",xmlns:"http://www.w3.org/2000/svg"},_c.default.createElement(Fc,{d:"M6 0L0 6H12L6 0Z"}),_c.default.createElement(Mc,{d:"M6 1.5L0 7.5H12L6 1.5Z"}),_c.default.createElement(Ic,{d:"M6 3L0 9H12L6 3Z"}))))})),Lc=Sl(.05,"#2a2a31"),Vc=kc.default.div`
  position: absolute;
  --popover-bg: ${Lc};
  --popover-inner-stroke: #505159;
  --popover-outer-stroke: #111;

  background: var(--popover-bg);

  color: white;
  padding: 0;
  margin: 0;
  cursor: default;
  ${kl};
  border-radius: 3px;
  z-index: 10000;
  border: 1px solid var(--popover-inner-stroke);
  box-shadow: 0 0 0 1px var(--popover-outer-stroke), 0 6px 8px -4px black;
  backdrop-filter: blur(8px);

  & a {
    color: inherit;
  }
`,qc=gc.default.forwardRef((({children:$,className:W},G)=>gc.default.createElement(Vc,{className:W,ref:G},gc.default.createElement(Nc,null),$))),Kc=(0,mc.default)(qc)`
  padding: 1em;
  max-width: 240px;
  pointer-events: none !important;
  --popover-outer-stroke: transparent;
  --popover-inner-stroke: #45464d;
`,Gc=(0,hc.default)(Kc)`
  padding: 6px;
`,Jc=fu.default.button`
  ${kl};
  position: relative;
  display: flex;
  align-items: center;
  justify-content: center;
  font-size: 14px;
  font-weight: 600;
  width: 24px;
  height: 24px;
  outline: none;

  color: rgba(255, 255, 255, 0.75);
  background-color: rgb(47, 49, 53);

  &:hover {
    color: #fff;

    background-color: rgba(28, 30, 32, 0.95);
    &:after {
      border-color: rgba(90, 90, 90, 1);
    }
  }

  &.selected {
    color: #fff;

    background-color: rgba(17, 18, 20, 0.95);
    &:after {
      border-color: rgb(43, 43, 43);
    }
  }

  &:before {
    border: 1px solid rgb(62, 62, 62);
    position: absolute;
    inset: -1px;
    display: block;
    content: ' ';
    z-index: -1;
    pointer-events: none;
    border-radius: 2px;
    box-sizing: border-box;
    box-shadow: 0px 3px 4px -3px rgba(0, 0, 0, 0.49);
  }

  border: 0;
`,Qc=pu.default.forwardRef((($,W)=>{var G=$,{title:oe}=G,ae=__objRest(G,["title"]);const[ie,se]=useTooltip({enabled:"string"==typeof oe},(()=>pu.default.createElement(Gc,null,oe)));return pu.default.createElement(pu.default.Fragment,null,ie,pu.default.createElement(Jc,__spreadValues({ref:pc([se,W])},ae))," ")})),ed=__toModule(W),td=(0,__toModule(mu).default)(Kc)`
  --popover-outer-stroke: #e11c1c;
  --popover-inner-stroke: #2c1c1c;
  --popover-bg: #2c1c1c;
  pointer-events: none !important;
`,sd=al.default.div`
  background-color: transparent;
  pointer-events: none;
  position: absolute;
  left: 0;
  top: 12px;
  bottom: 0px;
  right: 0;
  z-index: ${El.outlinePanel};

  &:before {
    display: block;
    content: ' ';
    position: absolute;
    top: 0;
    bottom: 0;
    left: 0;
    width: 40px;
    ${kl};
  }
  &:hover:before {
    top: -12px;
    width: 300px;
  }
`,ld=al.default.div`
  margin-left: 12px;
  position: relative;
  display: flex;
  flex-direction: row;
  justify-content: flex-start;
  align-items: center;
`,ud=al.default.div`
  position: absolute;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  transform: translateX(-100%);
  pointer-events: none;

  ${sd}:hover & {
    transform: translateX(0);
  }
`,cd="32px",dd=(0,al.default)(Qc)`
  ${sd}:hover & {
    background-color: rgba(36, 38, 42, 0.95);
    &:after {
      border-color: rgba(255, 255, 255, 0.22);
    }
    color: white;
  }
`;al.default.div`
  margin: 0 12px;
  color: #ffffffc2;
  font-weight: 500;
  font-size: 10px;
  user-select: none;
  position: relative;
  display: none;
  background-color: rgba(60, 60, 60, 0.2);
  height: 24px;
  ${sd}:hover & {
    display: block;
  }

  &:after {
    position: absolute;
    inset: 4px 0px;
    display: block;
    content: ' ';
    pointer-events: none;
    z-index: -1;
    background-color: #69777947;
    border-radius: 0 2px 2px 0;
  }
`;var fd=al.default.div`
  ${kl};
  position: absolute;
  top: ${cd};
  left: 8px;
  height: auto;
  max-height: calc(100% - ${cd});
  overflow-y: scroll;
  overflow-x: hidden;
  padding: 0;
  user-select: none;
`,md=al.default.div`
  color: white;
  width: 14px;
  height: 14px;
  background: #d00;
  border-radius: 4px;
  text-align: center;
  line-height: 14px;
  font-weight: 600;
  font-size: 8px;
  position: relative;
  left: -6px;
  top: -11px;
  margin-right: -14px;
  box-shadow: 0 4px 6px -4px #00000059;
`,OutlinePanel_default=$=>{const W=usePrism((()=>{const $=(0,ed.val)(getStudio().atomP.ephemeral.coreByProject);return Object.entries($).map((([$,W])=>({projectId:$,state:W}))).filter((({state:$})=>"browserStateIsNotBasedOnDiskState"===$.loadingState.type))}),[]),[G,oe]=useTooltip({enabled:W.length>0,enterDelay:W.length>0?0:200},(()=>W.length>0?ol.default.createElement(td,null,1===W.length?`There is a state conflict in project "${W[0].projectId}". Select the project in the outline below in order to fix it.`:`There are ${W.length} projects that have state conflicts. They are highlighted in the outline below. `):ol.default.createElement(Kc,null,"Outline")));return ol.default.createElement(sd,null,ol.default.createElement(ld,null,G,ol.default.createElement(dd,{ref:oe},ol.default.createElement(VscListTree,null)),W.length>0?ol.default.createElement(md,null,W.length):null),ol.default.createElement(ud,null,ol.default.createElement(fd,null,ol.default.createElement(ProjectsList_default,null))))},vd=__toModule(vt.exports),yd=__toModule(mu),bd=__toModule(vt.exports),wd=__toModule(W),Sd=__toModule(vt.exports),xd=__toModule(vt.exports);function getDeep($,W){return 0===W.length?$:Oo($,W)}var kd,_d=__toModule(W),Ed=__toModule(vt.exports),Cd=__toModule(vt.exports),Od=__toModule(mu),Id={defaultState:{color:Sl(.85,"#C4C4C4")},withStaticOverride:{color:Sl(.85,"#C4C4C4")}},Td=Od.default.div`
  width: 16px;
  margin: 0 0px 0 2px;
  display: flex;
  justify-content: center;
  align-items: center;

  color: ${$=>$.hasStaticOverride?Id.withStaticOverride.color:Id.defaultState.color};
`,Dd=Od.default.rect`
  fill: currentColor;
`,Icon=()=>Cd.default.createElement("svg",{width:"5",height:"5",viewBox:"0 0 5 5",fill:"none",xmlns:"http://www.w3.org/2000/svg"},Cd.default.createElement(Dd,{width:"5",height:"5"})),DefaultValueIndicator_default=$=>Cd.default.createElement(Td,{hasStaticOverride:$.hasStaticOverride},Cd.default.createElement(Icon,null)),Ad=__toModule(vt.exports),$d=__toModule(mu),Md=$d.default.div`
  display: flex;
  justify-content: center;
  align-items: center;
  width: 16px;
  margin: 0 0px 0 2px;
  position: relative;
  z-index: 0;
  opacity: 0.7;

  &:after {
    position: absolute;
    left: -14px;
    right: -14px;
    top: -2px;
    bottom: -2px;
    content: ' ';
    display: none;
    z-index: -1;
    background: ${Sl(.2,"black")};
  }

  &:hover {
    opacity: 1;
    &:after {
      display: block;
    }
  }
`,Rd=$d.default.div`
  background: none;
  position: relative;
  border: 0;
  transition: transform 0.1s ease-out;
  z-index: 0;
  outline: none;
  cursor: pointer;

  &:after {
    display: none;
    ${Md}:hover & {
      display: block;
    }
    position: absolute;
    left: -4px;
    right: -4px;
    top: -4px;
    bottom: -4px;
    content: ' ';
    z-index: -1;
  }
`,Bd="#555",Fd="#e0c917",Nd=(0,$d.default)(Rd)`
  &:hover {
    color: #e0c917;
  }
  color: ${$=>$.isOn?Fd:Bd};
`,Ld=$d.css`
  pointer-events: none !important;
`,Hd=(0,$d.default)(Rd)`
  color: ${$=>$.available?Fd:Bd};

  ${$=>$.available?kl:Ld};
`,Vd=(0,$d.default)(Hd)`
  transform: translateX(2px);
  ${Md}:hover & {
    transform: translateX(-7px);
  }
`,Ud=(0,$d.default)(Hd)`
  transform: translateX(-2px);

  ${Md}:hover & {
    transform: translateX(7px);
  }
`;!function($){const W=$d.default.g`
    stroke-width: 1;
    ${Hd}:hover & path {
      stroke-width: 3;
    }
  `;$.Prev=()=>Ad.default.createElement("svg",{width:"12",height:"12",viewBox:"0 0 12 12",fill:"none",xmlns:"http://www.w3.org/2000/svg"},Ad.default.createElement(W,{transform:"translate(6 3)"},Ad.default.createElement("path",{d:"M4 1L1 4L4 7",stroke:"currentColor"}))),$.Next=()=>Ad.default.createElement("svg",{width:"12",height:"12",viewBox:"0 0 12 12",fill:"none",xmlns:"http://www.w3.org/2000/svg"},Ad.default.createElement(W,{transform:"translate(1 3)"},Ad.default.createElement("path",{d:"M1 1L4 4L1 7",stroke:"currentColor"})));const G=$d.default.g`
    stroke-width: 0;
    ${Nd}:hover & path {
      stroke: currentColor;
      stroke-width: 2;
    }
  `;$.Cur=()=>Ad.default.createElement("svg",{width:"8",height:"12",viewBox:"0 0 8 12",fill:"none",xmlns:"http://www.w3.org/2000/svg"},Ad.default.createElement(G,{transform:"translate(1 4)"},Ad.default.createElement("path",{d:"M3 0L6 3L3 6L0 3L3 0Z",fill:"currentColor"})))}(kd||(kd={}));var NextPrevKeyframeCursors_default=$=>Ad.default.createElement(Md,null,Ad.default.createElement(Vd,{available:!!$.prev,onClick:()=>{$.prev&&$.jumpToPosition($.prev.position)}},Ad.default.createElement(kd.Prev,null)),Ad.default.createElement(Nd,{isOn:!!$.cur,onClick:()=>{$.toggleKeyframeOnCurrentPosition()}},Ad.default.createElement(kd.Cur,null)),Ad.default.createElement(Ud,{available:!!$.next,onClick:()=>{$.next&&$.jumpToPosition($.next.position)}},Ad.default.createElement(kd.Next,null)));function useEditingToolsForPrimitiveProp($,W,G){return usePrism((()=>{var oe;const ae=(0,_d.getPointerParts)($).path,ie=W.getValueByPointer($),se=_d.prism.memo("callbacks",(()=>{let W=null;return{temporarilySetValue(G){W||(W=getStudio().scrub()),W.capture((W=>{W.set($,G)}))},discardTemporaryValue(){W&&(W.discard(),W=null)},permenantlySetValue(G){W?(W.capture((W=>{W.set($,G)})),W.commit(),W=null):getStudio().transaction((W=>{W.set($,G)}))}}}),[]),le=!0===(0,_d.val)(Oo(getStudio().atomP.ephemeral.projects.stateByProjectId[W.address.projectId].stateBySheetId[W.address.sheetId].stateByObjectKey[W.address.objectKey].valuesBeingScrubbed,(0,_d.getPointerParts)($).path)),ue=[],de=__spreadProps(__spreadValues({},se),{value:ie,beingScrubbed:le,contextMenuItems:ue,controlIndicators:Ed.default.createElement(Ed.default.Fragment,null)}),pe=function isPropConfSequencable($){return"number"===$.type}(G);if(pe){const G=getDeep((0,_d.val)(W.template.getMapOfValidSequenceTracks_forStudio()),ae);if("string"==typeof G){ue.push({label:"Make static",callback:()=>{getStudio().transaction((({stateEditors:G})=>{const oe=__spreadProps(__spreadValues({},W.address),{pathToProp:ae});G.coreByProject.historic.sheetsById.sequence.setPrimitivePropAsStatic(__spreadProps(__spreadValues({},oe),{value:W.getValueByPointer($)}))}))}});const ie=G,se=_d.prism.sub("lcr",(()=>{const $=(0,_d.val)(W.template.project.pointers.historic.sheetsById[W.address.sheetId].sequence.tracksByObject[W.address.objectKey].trackData[ie]);if(!$||0===$.keyframes.length)return{};const G=(0,_d.val)(W.sheet.getSequence().positionDerivation),oe=$.keyframes.findIndex(($=>$.position>=G));if(-1===oe)return{prev:ys($.keyframes)};const ae=$.keyframes[oe];return ae.position===G?{prev:oe>0?$.keyframes[oe-1]:void 0,cur:ae,next:oe===$.keyframes.length-1?void 0:$.keyframes[oe+1]}:{next:ae,prev:oe>0?$.keyframes[oe-1]:void 0}}),[ie]);let le;le=de.beingScrubbed?"Sequenced_OnKeyframe_BeingScrubbed":se.cur?"Sequenced_OnKeyframe":!0===(null==(oe=se.prev)?void 0:oe.connectedRight)?"Sequenced_BeingInterpolated":"Sequened_NotBeingInterpolated";const pe=Ed.default.createElement(NextPrevKeyframeCursors_default,__spreadProps(__spreadValues({},se),{jumpToPosition:$=>{W.sheet.getSequence().position=$},toggleKeyframeOnCurrentPosition:()=>{se.cur?getStudio().transaction((W=>{W.unset($)})):getStudio().transaction((W=>{W.set($,de.value)}))}}));return __spreadProps(__spreadValues({},de),{type:"Sequenced",shade:le,nearbyKeyframes:se,controlIndicators:pe})}}ue.push({label:"Reset to default",callback:()=>{getStudio().transaction((({unset:W})=>{W($)}))}}),pe&&ue.push({label:"Sequence",callback:()=>{getStudio().transaction((({stateEditors:$})=>{const G=__spreadProps(__spreadValues({},W.address),{pathToProp:ae});$.coreByProject.historic.sheetsById.sequence.setPrimitivePropAsSequenced(G)}))}});if(void 0!==getDeep((0,_d.val)(W.template.getStaticValues()),ae)){return __spreadProps(__spreadValues({},de),{type:"Static",shade:de.beingScrubbed?"Static_BeingScrubbed":"Static",controlIndicators:Ed.default.createElement(DefaultValueIndicator_default,{hasStaticOverride:!0})})}return __spreadProps(__spreadValues({},de),{type:"Default",shade:"Default",controlIndicators:Ed.default.createElement(DefaultValueIndicator_default,{hasStaticOverride:!1})})}),[])}var Kd=__toModule(W),Wd=__toModule(vt.exports),Gd=__toModule(Ye()),Xd=__toModule(vt.exports),Yd=__toModule(vt.exports),Jd=__toModule(Vt.exports),Qd=__toModule(mu),Zd=__toModule(vt.exports),tf=__toModule(mu),of=tf.default.li`
  height: ${26}px;
  padding: 0 12px;
  margin: 0;
  display: flex;
  align-items: center;
  font-size: 11px;
  font-weight: 400;
  position: relative;
  pointer-events: ${$=>$.enabled?"auto":"none"};
  color: ${$=>$.enabled?"white":"#AAA"};

  &:after {
    position: absolute;
    inset: 2px 1px;
    display: block;
    content: ' ';
    pointer-events: none;
    z-index: -1;
    border-radius: 3px;
  }

  &:hover:after {
    background-color: rgba(63, 174, 191, 0.75);
  }
`,lf=tf.default.span``,Item_default=$=>Zd.default.createElement(of,{onClick:$.enabled?$.onClick:noop_default2,enabled:$.enabled},Zd.default.createElement(lf,null,$.label)),ff=__toModule(vt.exports);var pf=Qd.default.ul`
  position: absolute;
  min-width: ${190}px;
  z-index: 10000;
  background: ${(0,Gd.default)(.2,"#111")};
  backdrop-filter: blur(2px);
  color: white;
  list-style-type: none;
  padding: 2px 0;
  margin: 0;
  border-radius: 1px;
  cursor: default;
  ${kl};
  border-radius: 3px;
`,RightClickMenu_default=$=>{const[W,G]=(0,Yd.useState)(null),oe=useBoundingClientRect(W),ae=useWindowSize_default();(0,Yd.useLayoutEffect)((()=>{if(!oe||!W)return;const G=oe.width/2,ie=13,se={left:$.rightClickPoint.clientX-G,top:$.rightClickPoint.clientY-ie};se.left<0?se.left=0:se.left+oe.width>ae.width&&(se.left=ae.width-oe.width),se.top<0?se.top=0:se.top+oe.height>ae.height&&(se.top=ae.height-oe.height),W.style.left=se.left+"px",W.style.top=se.top+"px";const onMouseMove=W=>{(W.clientX<se.left-20||W.clientX>se.left+oe.width+20||W.clientY<se.top-20||W.clientY>se.top+oe.height+20)&&$.onRequestClose()};return window.addEventListener("mousemove",onMouseMove),()=>{window.removeEventListener("mousemove",onMouseMove)}}),[oe,W,$.rightClickPoint,ae,$.onRequestClose]);const ie=(0,Xd.useContext)(fc);!function useOnKeyDown($){const W=(0,ff.useRef)($);W.current=$,(0,ff.useEffect)((()=>{const onKeyDown=$=>W.current($);return window.addEventListener("keydown",onKeyDown),()=>{window.removeEventListener("keydown",onKeyDown)}}),[])}((W=>{"Escape"===W.key&&$.onRequestClose()}));const se=Array.isArray($.items)?$.items:$.items();return(0,Jd.createPortal)(Yd.default.createElement(pf,{ref:G},se.map(((W,G)=>Yd.default.createElement(Item_default,{key:`item-${G}`,label:W.label,enabled:!1!==W.enabled,onClick:G=>{W.callback&&W.callback(G),$.onRequestClose()}})))),ie)},vf=__toModule(vt.exports),useRequestContextMenu_default=$=>{const[W,G]=(0,vf.useState)({isOpen:!1}),oe=(0,vf.useCallback)((()=>G({isOpen:!1})),[]);return(0,vf.useEffect)((()=>{if(!$)return void G({isOpen:!1});const onContextMenu=$=>{G({isOpen:!0,event:$}),$.preventDefault(),$.stopPropagation()};return $.addEventListener("contextmenu",onContextMenu),()=>{$.removeEventListener("contextmenu",onContextMenu)}}),[$]),[W,oe]},yf=Wd.default.createElement(Wd.default.Fragment,null);function useContextMenu($,W){const[G,oe]=useRequestContextMenu_default($);return[G.isOpen?Wd.default.createElement(RightClickMenu_default,{items:W.items,rightClickPoint:G.event,onRequestClose:oe}):yf,oe,G.isOpen]}var bf=__toModule(vt.exports),wf=__toModule(mu),Sf="calc(var(--left-pad) + var(--depth) * var(--step))",xf=Sl(.05,"#282b2f"),kf=wf.css`
  &:after,
  &:before {
    position: absolute;
    display: block;
    content: ' ';
    z-index: -1;
    box-sizing: content-box;
  }

  &:after {
    inset: 0px 0 1px calc(-2px + var(--left-pad) + var(--depth) * var(--step));
    background-color: ${xf};
  }

  &:before {
    height: 2px;
    right: 0;
    bottom: 0px;
    left: calc(-2px + var(--left-pad) + var(--depth) * var(--step));
    background-color: ${Sl(.2,xf)};
  }
`,_f=wf.css`
  font-weight: 300;
  font-size: 11px;
  color: #9a9a9a;
  text-shadow: 0.5px 0.5px 2px rgba(0, 0, 0, 0.3);
`,Pf=wf.default.div`
  display: flex;
  height: 30px;
  justify-content: flex-start;
  align-items: stretch;
  --right-width: 60%;
  position: relative;
  ${kl};

  ${kf};
`,Cf=wf.default.div`
  box-sizing: border-box;
  padding-left: ${Sf};
  padding-right: 4px;
  display: flex;
  flex-direction: row;
  justify-content: flex-start;
  align-items: stretch;
  gap: 4px;
  flex-grow: 0;
  flex-shrink: 0;
  width: calc(100% - var(--right-width));
`,Of=wf.default.div`
  text-align: left;
  flex: 1 0;
  white-space: nowrap;
  overflow: hidden;
  text-overflow: ellipsis;
  display: flex;
  align-items: center;
  user-select: none;
  cursor: default;

  ${_f};
  &:hover {
    color: white;
  }
`,Tf=wf.default.div`
  flex-basis: 8px;
  flex: 0 0;
  display: flex;
  align-items: center;
`,Df=wf.default.div`
  display: flex;
  align-items: center;
  justify-content: stretch;
  padding: 0 8px 0 2px;
  box-sizing: border-box;
  height: 100%;
  width: var(--right-width);
  flex-shrink: 0;
  flex-grow: 0;
`,SingleRowPropEditor=({propConfig:$,pointerToProp:W,stuff:G,children:oe})=>{var ae;const ie=null!=(ae=$.label)?ae:ys((0,Kd.getPointerParts)(W).path),[se,le]=useRefAndState(null),[ue]=useContextMenu(le,{items:G.contextMenuItems});return G.shade,bf.default.createElement(Pf,null,ue,bf.default.createElement(Cf,null,bf.default.createElement(Tf,null,G.controlIndicators),bf.default.createElement(Of,{ref:se,title:["obj","props",...(0,Kd.getPointerParts)(W).path].join(".")},ie)),bf.default.createElement(Df,null,oe))},Af=__toModule(mu),$f=__toModule(mu).default.input.attrs({type:"checkbox"})`
  outline: none;
`,zf=(0,Af.default)($f)`
  margin-left: 6px;
`,BooleanPropEditor_default=({propConfig:$,pointerToProp:W,obj:G})=>{const oe=useEditingToolsForPrimitiveProp(W,G,$),ae=(0,xd.useCallback)(($=>{oe.permenantlySetValue(Boolean($.target.checked))}),[$,W,G]);return xd.default.createElement(SingleRowPropEditor,__spreadValues({},{stuff:oe,propConfig:$,pointerToProp:W}),xd.default.createElement(zf,{checked:oe.value,onChange:ae}))};function isPropConfigComposite($){return"compound"===$.type||"enum"===$.type}var Mf=__toModule(W),Rf=__toModule(vt.exports),Nf=__toModule(mu),Lf=Nf.default.div`
  --step: 8px;
  --left-pad: 0px;
  ${kl};
`,Vf=Nf.default.div`
  height: 30px;
  display: flex;
  align-items: stretch;
  position: relative;

  ${kf};
`,Uf=Nf.default.div`
  padding-left: ${Sf};
  display: flex;
  align-items: center;
`,Wf=Nf.default.div`
  margin-left: 4px;
  cursor: default;
  height: 100%;
  display: flex;
  align-items: center;
  user-select: none;
  &:hover {
    /* color: white; */
  }

  ${()=>_f};
`,Xf=Sl(.05,"#282b2f"),Yf=Nf.default.div`
  /* background: ${({depth:$})=>bl(.03*$,Xf)}; */
  /* padding: ${$=>$.lastSubIsComposite?0:"4px"} 0; */
`,CompoundPropEditor_default=({pointerToProp:$,obj:W,propConfig:G,depth:oe})=>{var ae;const ie=null!=(ae=G.label)?ae:ys((0,Mf.getPointerParts)($).path),se=Object.entries(G.props),le=se.filter((([$,W])=>isPropConfigComposite(W))),ue=se.filter((([$,W])=>!isPropConfigComposite(W))),[de,pe]=useRefAndState(null),he=le.length>0;return Rf.default.createElement(Lf,null,Rf.default.createElement(Vf,{style:{"--depth":oe-1}},Rf.default.createElement(Uf,null,Rf.default.createElement(DefaultValueIndicator_default,{hasStaticOverride:!1}),Rf.default.createElement(Wf,{ref:de},ie||"Props"))),Rf.default.createElement(Yf,{style:{"--depth":oe},depth:oe,lastSubIsComposite:he},[...ue,...le].map((([G,ae])=>Rf.default.createElement(DeterminePropEditor_default,{key:"prop-"+G,propConfig:ae,pointerToProp:$[G],obj:W,depth:oe+1})))))},Qf=__toModule(vt.exports),Zf=__toModule(mu),voidFn=()=>{},ep=[],tp=__toModule(vt.exports);function createCursorLock($){const W=document.createElement("div");W.style.cssText="\n    position: fixed;\n    top: 0;\n    right: 0;\n    bottom: 0;\n    left: 0;\n    z-index: 9999999;",W.style.cursor=$,document.body.appendChild(W);return()=>{document.body.removeChild(W)}}var rp=class extends tp.default.PureComponent{constructor($){super($),__publicField(this,"s"),__publicField(this,"mode","notDragging"),__publicField(this,"getDeltas"),__publicField(this,"relinquishCursorLock",voidFn),__publicField(this,"disableUnwantedClick",($=>{this.s.dragHappened&&(this.props.dontBlockMouseDown||"notDragging"===this.mode||($.stopPropagation(),$.preventDefault()),this.s.dragHappened=!1)})),__publicField(this,"dragStartHandler",($=>{if(0!==$.button)return;if(!1===(this.props.onDragStart&&this.props.onDragStart($)))return;this.props.dontBlockMouseDown||($.stopPropagation(),$.preventDefault()),this.mode="dragStartCalled";const{screenX:W,screenY:G}=$;this.s.startPos={x:W,y:G},this.s.dragHappened=!1,this.addDragListeners()})),__publicField(this,"dragEndHandler",(()=>{this.removeDragListeners(),this.mode="notDragging",this.props.onDragEnd&&this.props.onDragEnd(this.s.dragHappened),this.relinquishCursorLock(),this.relinquishCursorLock=voidFn})),__publicField(this,"dragHandler",($=>{!this.s.dragHappened&&this.props.lockCursorTo&&(this.relinquishCursorLock=createCursorLock(this.props.lockCursorTo)),this.s.dragHappened||(this.s.dragHappened=!0),this.mode="dragging";const W=this.getDeltas($);this.props.onDrag(W[0],W[1],$)})),this.s={dragHappened:!1,startPos:{x:0,y:0}},$.shouldReturnMovement?this.getDeltas=this.getMovements:this.getDeltas=this.getDistances}render(){return!1!==this.props.enabled?tp.default.cloneElement(this.props.children,{onMouseDown:this.dragStartHandler,onClickCapture:this.disableUnwantedClick}):this.props.children}addDragListeners(){document.addEventListener("mousemove",this.dragHandler),document.addEventListener("mouseup",this.dragEndHandler)}removeDragListeners(){document.removeEventListener("mousemove",this.dragHandler),document.removeEventListener("mouseup",this.dragEndHandler)}UNSAFE_componentWillReceiveProps($){$.lockCursorTo!==this.props.lockCursorTo&&this.s.dragHappened&&(this.relinquishCursorLock(),this.relinquishCursorLock=voidFn,$.lockCursorTo&&(this.relinquishCursorLock=createCursorLock($.lockCursorTo)))}getDistances($){const{startPos:W}=this.s;return[$.screenX-W.x,$.screenY-W.y]}getMovements($){return[$.movementX,$.movementY]}componentWillUnmount(){"notDragging"!==this.mode&&(this.relinquishCursorLock(),this.relinquishCursorLock=voidFn,this.removeDragListeners(),this.props.onDragEnd&&this.props.onDragEnd("dragging"===this.mode),this.mode="notDragging")}},np=Zf.default.div`
  height: 100%;
  width: 100%;
  position: relative;
  z-index: 0;
  box-sizing: border-box;
  display: flex;
  align-items: center;

  &:after {
    position: absolute;
    inset: 1px 0 2px;
    display: block;
    content: ' ';
    background-color: transparent;
    border: 1px solid transparent;
    z-index: -2;
    box-sizing: border-box;
    border-radius: 1px;
  }

  &:hover,
  &.dragging,
  &.editingViaKeyboard {
    &:after {
      background-color: #10101042;
      border-color: #00000059;
    }
  }
`,op=Zf.default.input`
  background: transparent;
  border: 1px solid transparent;
  color: rgba(255, 255, 255, 0.9);
  padding: 1px 6px;
  font: inherit;
  outline: none;
  cursor: ew-resize;
  text-align: left;
  width: 100%;
  height: calc(100% - 4px);
  border-radius: 2px;

  &:focus {
    cursor: text;
  }
`,ap=Zf.default.div`
  position: absolute;
  inset: 3px 2px 4px;
  transform: scale(var(--percentage), 1);
  transform-origin: top left;
  background-color: #2d5561;
  z-index: -1;
  border-radius: 2px;
  pointer-events: none;

  ${np}.dragging &, ${np}.noFocus:hover & {
    background-color: #338198;
  }
`,alwaysValid=$=>!0;var BasicNumberInput_default=$=>{var W;const[G,oe]=(0,Qf.useState)({mode:"noFocus"}),ae=null!=(W=$.isValid)?W:alwaysValid,ie=(0,Qf.useRef)({state:G,props:$});ie.current={state:G,props:$};const se=(0,Qf.useRef)(null),le=(0,Qf.useRef)(null),ue=(0,Qf.useMemo)((()=>{const commitKeyboardInput=()=>{const $=ie.current.state,W=parseFloat($.currentEditedValueInString);isFinite(W)&&ae(W)?$.valueBeforeEditing===W?ie.current.props.discardTemporaryValue():ie.current.props.permenantlySetValue(W):ie.current.props.discardTemporaryValue()},transitionToEditingViaKeyboardMode=()=>{const $=ie.current.props.value;oe({mode:"editingViaKeyboard",currentEditedValueInString:String($),valueBeforeEditing:$}),setTimeout((()=>{se.current.focus(),se.current.setSelectionRange(0,100)}))};let W;return{inputChange:$=>{const W=$.target,{value:G}=W,se=ie.current.state;oe(__spreadProps(__spreadValues({},se),{currentEditedValueInString:G}));const le=parseFloat(G);isFinite(le)&&ae(le)&&ie.current.props.temporarilySetValue(le)},onBlur:()=>{"editingViaKeyboard"===ie.current.state.mode&&(commitKeyboardInput(),oe({mode:"noFocus"})),$.onBlur&&$.onBlur()},transitionToDraggingMode:()=>{var $;const G=ie.current.props.value;W=null==($=se.current)?void 0:$.getBoundingClientRect().width,oe({mode:"dragging",valueBeforeDragging:G,currentDraggingValue:G}),le.current=document.body.style.cursor},onInputKeyDown:$=>{"Escape"===$.key?(ie.current.props.discardTemporaryValue(),se.current.blur()):"Enter"!==$.key&&"Tab"!==$.key||(commitKeyboardInput(),se.current.blur())},onClick:$=>{if("noFocus"===ie.current.state.mode){se.current.focus(),$.preventDefault(),$.stopPropagation()}else $.stopPropagation()},onFocus:()=>{"noFocus"===ie.current.state.mode?transitionToEditingViaKeyboardMode():ie.current.state.mode},onDragEnd:$=>{if($){const $=ie.current.state,W=$.currentDraggingValue;$.valueBeforeDragging===W?ie.current.props.discardTemporaryValue():ie.current.props.permenantlySetValue(W),oe({mode:"noFocus"})}else ie.current.props.discardTemporaryValue(),oe({mode:"noFocus"}),se.current.focus(),se.current.setSelectionRange(0,100)},onDrag:(G,ae)=>{const se=ie.current.state;let le=se.valueBeforeDragging+$.nudge({deltaX:G,deltaFraction:G/W,magnitude:1});$.range&&(le=Uo(le,$.range[0],$.range[1])),oe(__spreadProps(__spreadValues({},se),{currentDraggingValue:le})),ie.current.props.temporarilySetValue(le)}}}),[ie,oe,se]);let de="editingViaKeyboard"!==G.mode?function format2($){return isNaN($)?"NaN":Os($)?$.toFixed(0):Ls($,3).toString()}($.value):G.currentEditedValueInString;"number"==typeof de&&isNaN(de)&&(de="NaN");const pe=[se];$.inputRef&&pe.push($.inputRef);const he=Qf.default.createElement(op,{key:"input",type:"text",onChange:ue.inputChange,value:de,onBlur:ue.onBlur,onKeyDown:ue.onInputKeyDown,onClick:ue.onClick,onFocus:ue.onFocus,ref:pc(pe),onMouseDown:$=>{$.stopPropagation()},onDoubleClick:$=>{$.preventDefault(),$.stopPropagation()}}),{range:ge}=$,ve=parseFloat(de),we=ge?Qf.default.createElement(ap,{style:{"--percentage":Uo((ve-ge[0])/(ge[1]-ge[0]),0,1)}}):null;return Qf.default.createElement(np,{className:$.className+" "+ie.current.state.mode},Qf.default.createElement(rp,{key:"draggableArea",onDragStart:ue.transitionToDraggingMode,onDragEnd:ue.onDragEnd,onDrag:ue.onDrag,enabled:"editingViaKeyboard"!==ie.current.state.mode,lockCursorTo:"ew-resize"},he),we)},ip=__toModule(vt.exports),NumberPropEditor_default=({propConfig:$,pointerToProp:W,obj:G})=>{const oe=useEditingToolsForPrimitiveProp(W,G,$),ae=(0,ip.useCallback)((W=>$.nudgeFn(__spreadProps(__spreadValues({},W),{config:$}))),[$]);return ip.default.createElement(SingleRowPropEditor,__spreadValues({},{stuff:oe,propConfig:$,pointerToProp:W}),ip.default.createElement(BasicNumberInput_default,{value:oe.value,temporarilySetValue:oe.temporarilySetValue,discardTemporaryValue:oe.discardTemporaryValue,permenantlySetValue:oe.permenantlySetValue,range:$.range,nudge:ae}))},sp=__toModule(vt.exports),lp=__toModule(vt.exports),up=__toModule(mu),cp=up.default.form`
  display: flex;
  flex-direction: row;
  align-items: stretch;
  vertical-align: middle;
  justify-content: stretch;
  height: 24px;
  width: 100%;
`,dp=up.default.label`
  padding: 0 0.5em;
  background: transparent;
  /* background: #373748; */
  display: flex;
  align-items: center;
  justify-content: center;
  flex-grow: 1;
  color: #a7a7a7;
  border: 1px solid transparent;
  box-sizing: border-box;
  border-right-width: 0px;

  & + &:last-child {
    border-right-width: 1px;
  }

  ${cp}:hover > & {
    border-color: #1c2123;
    /* background-color: #373748; */
    /* color: ${bl(.1,"white")}; */
  }

  &&:hover {
    background-color: #464654;
  }

  &&[data-checked='true'] {
    color: white;
    background: #3f3f4c;
  }
`,fp=up.default.input`
  position: absolute;
  opacity: 0;
  pointer-events: none;
  width: 0;
  height: 0;
`,BasicSwitch_default=({value:$,onChange:W,options:G})=>{const oe=(0,lp.useCallback)(($=>{W(String($.target.value))}),[W]);return lp.default.createElement(cp,{role:"radiogroup"},Object.keys(G).map(((W,ae)=>lp.default.createElement(dp,{key:"label-"+ae,"data-checked":$===W},G[W],lp.default.createElement(fp,{type:"radio",checked:$===W,value:W,onChange:oe,name:"switchbox"})))))},hp=__toModule(vt.exports),mp=__toModule(mu),gp=mp.default.div`
  width: 100%;
  position: relative;
`,vp=mp.default.div`
  position: absolute;
  right: 0px;
  top: 0;
  bottom: 0;
  width: 1.5em;
  font-size: 14px;
  display: flex;
  align-items: center;
  color: #6b7280;
  pointer-events: none;
`,yp=mp.default.select`
  background-color: transparent;
  box-sizing: border-box;
  border: 1px solid transparent;
  color: rgba(255, 255, 255, 0.85);
  padding: 1px 6px;
  font: inherit;
  outline: none;
  text-align: left;
  width: 100%;
  height: calc(100% - 4px);
  border-radius: 2px;

  color-adjust: exact;
  appearance: none;

  &:hover,
  &:focus {
    background-color: #10101042;
    border-color: #00000059;
  }
`,BasicSelect_default=({value:$,onChange:W,options:G,className:oe})=>{const ae=(0,hp.useCallback)(($=>{W(String($.target.value))}),[W]);return hp.default.createElement(gp,null,hp.default.createElement(yp,{className:oe,value:$,onChange:ae},Object.keys(G).map((($,W)=>hp.default.createElement("option",{key:"option-"+W,value:$},G[$])))),hp.default.createElement(vp,null,hp.default.createElement(CgSelect,null)))},StringLiteralPropEditor_default=({propConfig:$,pointerToProp:W,obj:G})=>{const oe=useEditingToolsForPrimitiveProp(W,G,$),ae=(0,sp.useCallback)(($=>{oe.permenantlySetValue($)}),[$,W,G]);return sp.default.createElement(SingleRowPropEditor,__spreadValues({},{stuff:oe,propConfig:$,pointerToProp:W}),"menu"===$.as?sp.default.createElement(BasicSelect_default,{value:oe.value,onChange:ae,options:$.options}):sp.default.createElement(BasicSwitch_default,{value:oe.value,onChange:ae,options:$.options}))},bp=__toModule(vt.exports),wp=__toModule(mu),Sp=__toModule(vt.exports),xp=wp.default.input.attrs({type:"text"})`
  background: transparent;
  border: 1px solid transparent;
  color: rgba(255, 255, 255, 0.9);
  padding: 1px 6px;
  font: inherit;
  outline: none;
  cursor: text;
  text-align: left;
  width: 100%;
  height: calc(100% - 4px);
  border-radius: 2px;
  border: 1px solid transparent;
  box-sizing: border-box;

  &:hover {
    background-color: #10101042;
    border-color: #00000059;
  }

  &:hover,
  &:focus {
    cursor: text;
    background-color: #10101042;
    border-color: #00000059;
  }
`,alwaysValid2=$=>!0;var BasicStringInput_default=$=>{var W;const[G,oe]=(0,Sp.useState)({mode:"noFocus"}),ae=null!=(W=$.isValid)?W:alwaysValid2,ie=(0,Sp.useRef)({state:G,props:$});ie.current={state:G,props:$};const se=(0,Sp.useRef)(null),le=(0,Sp.useMemo)((()=>{const commitKeyboardInput=()=>{const $=ie.current.state,W=$.currentEditedValueInString;ae(W)?$.valueBeforeEditing===W?ie.current.props.discardTemporaryValue():ie.current.props.permenantlySetValue(W):ie.current.props.discardTemporaryValue()},transitionToEditingViaKeyboardMode=()=>{const $=ie.current.props.value;oe({mode:"editingViaKeyboard",currentEditedValueInString:String($),valueBeforeEditing:$}),setTimeout((()=>{se.current.focus()}))};return{inputChange:$=>{const W=$.target,{value:G}=W,se=ie.current.state;oe(__spreadProps(__spreadValues({},se),{currentEditedValueInString:G})),ae(G)&&ie.current.props.temporarilySetValue(G)},onBlur:()=>{"editingViaKeyboard"===ie.current.state.mode&&(commitKeyboardInput(),oe({mode:"noFocus"})),$.onBlur&&$.onBlur()},onInputKeyDown:$=>{"Escape"===$.key?(ie.current.props.discardTemporaryValue(),se.current.blur()):"Enter"!==$.key&&"Tab"!==$.key||(commitKeyboardInput(),se.current.blur())},onClick:$=>{if("noFocus"===ie.current.state.mode){se.current.focus(),$.preventDefault(),$.stopPropagation()}else $.stopPropagation()},onFocus:()=>{"noFocus"===ie.current.state.mode?transitionToEditingViaKeyboardMode():ie.current.state.mode}}}),[ie,oe,se]);let ue="editingViaKeyboard"!==G.mode?$.value:G.currentEditedValueInString;const de=[se];$.inputRef&&de.push($.inputRef);const pe=Sp.default.createElement(xp,{key:"input",type:"text",onChange:le.inputChange,value:ue,onBlur:le.onBlur,onKeyDown:le.onInputKeyDown,onClick:le.onClick,onFocus:le.onFocus,ref:pc(de),onMouseDown:$=>{$.stopPropagation()},onDoubleClick:$=>{$.preventDefault(),$.stopPropagation()}});return pe},kp={compound:CompoundPropEditor_default,number:NumberPropEditor_default,string:({propConfig:$,pointerToProp:W,obj:G})=>{const oe=useEditingToolsForPrimitiveProp(W,G,$);return bp.default.createElement(SingleRowPropEditor,__spreadValues({},{stuff:oe,propConfig:$,pointerToProp:W}),bp.default.createElement(BasicStringInput_default,{value:oe.value,temporarilySetValue:oe.temporarilySetValue,discardTemporaryValue:oe.discardTemporaryValue,permenantlySetValue:oe.permenantlySetValue}))},enum:()=>Sd.default.createElement(Sd.default.Fragment,null),boolean:BooleanPropEditor_default,stringLiteral:StringLiteralPropEditor_default},DeterminePropEditor_default=$=>{var W;const G=null!=(W=$.propConfig)?W:(($,W)=>{const G=W.template.config.props,oe=(0,wd.getPointerParts)($).path;let ae=G;for(;0!==oe.length;){const $=oe.shift();if("string"!=typeof $)throw"number"==typeof $?new Error("Number indexes are not implemented yet. @todo"):new Error("getPropTypeConfigByPath() is called with an invalid path.");if("compound"===ae.type){if(ae=ae.props[$],!ae)throw new Error("getPropTypeConfigByPath() is called with an invalid path.")}else{if("enum"!==ae.type)throw new Error("getPropTypeConfigByPath() is called with an invalid path.");if(ae=ae.cases[$],!ae)throw new Error("getPropTypeConfigByPath() is called with an invalid path.")}}return ae})($.pointerToProp,$.obj),oe=kp[G.type];return Sd.default.createElement(oe,{obj:$.obj,depth:$.depth,pointerToProp:$.pointerToProp,propConfig:G})},ObjectDetails_default=({objects:$})=>{const W=$[0],G=(0,bd.useMemo)((()=>JSON.stringify(W.address)),[W]);return bd.default.createElement(DeterminePropEditor_default,{key:G,obj:W,pointerToProp:W.propsP,propConfig:W.template.config,depth:1})},_p=__toModule(vt.exports),Pp=__toModule(Vt.exports);function usePopover($,W){const[G,oe]=(0,_p.useState)({isOpen:!1}),ae=(0,_p.useCallback)((($,W)=>{oe({isOpen:!0,clickPoint:{clientX:$.clientX,clientY:$.clientY},target:W})}),[]),ie=(0,_p.useCallback)((()=>{oe({isOpen:!1})}),[]),se=(0,_p.useCallback)((()=>{!1!==$.closeOnClickOutside&&ie()}),[$.closeOnClickOutside]),le=(0,_p.useContext)(fc),ue=(0,_p.useMemo)((()=>{var W;if(!1!==$.closeWhenPointerIsDistant)return{threshold:null!=(W=$.pointerDistanceThreshold)?W:100,callback:ie}}),[$.closeWhenPointerIsDistant]);return[G.isOpen?(0,Pp.createPortal)(_p.default.createElement(TooltipWrapper_default,{children:W,target:G.target,onClickOutside:se,onPointerOutside:ue}),le):_p.default.createElement(_p.default.Fragment,null),ae,ie,G.isOpen]}var Ep=__toModule(vt.exports),jp=__toModule(mu),Cp=__toModule(vt.exports),Op=__toModule(mu);function generateDiskStateRevision(){return(($=21)=>{let W="",G=crypto.getRandomValues(new Uint8Array($));for(;$--;){let oe=63&G[$];W+=oe<36?oe.toString(36):oe<62?(oe-26).toString(36).toUpperCase():oe<63?"_":"-"}return W})(16)}var Ip=__toModule(mu).default.button`
  text-align: center;
  padding: 8px;
  border-radius: 2px;
  border: 1px solid #627b7b87;
  background-color: #4b787d3d;
  color: #eaeaea;
  font-weight: 400;
  display: block;
  appearance: none;
  flex-grow: 1;
  cursor: ${$=>$.disabled?"none":"pointer"};
  opacity: ${$=>$.disabled?.4:1};

  &:hover {
    background-color: #7dc1c878;
    border-color: #9ebcbf;
  }
`,Tp=Op.default.div`
  padding: 8px 10px;
  position: relative;
  background-color: #6d232352;
  &:before {
    position: absolute;
    content: ' ';
    display: block;
    left: 0;
    top: 0;
    bottom: 0;
    width: 2px;
    background-color: #ff000070;
  }
`,Dp=Op.default.div`
  margin-bottom: 1em;
  & a {
    color: inherit;
  }
`,Ap=Op.default.div`
  display: flex;
  gap: 8px;
`,InConflict=({projectId:$,loadingState:W})=>{const[G,oe]=useTooltip({},(()=>Cp.default.createElement(Kc,null,"The browser's state will override the disk state."))),[ae,ie]=useTooltip({},(()=>Cp.default.createElement(Kc,null,"The disk's state will override the browser's state.")));return Cp.default.createElement(Tp,null,Cp.default.createElement(Dp,null,"Browser state is not based on disk state."," ",Cp.default.createElement("a",{href:"https://docs.theatrejs.com/in-depth/#exporting",target:"_blank"},"Learn more.")),Cp.default.createElement(Ap,null,G,Cp.default.createElement(Ip,{onClick:()=>{getStudio().transaction((({drafts:G,stateEditors:oe})=>{oe.coreByProject.historic.revisionHistory.add({projectId:$,revision:W.onDiskState.revisionHistory[0]}),oe.coreByProject.historic.revisionHistory.add({projectId:$,revision:generateDiskStateRevision()}),G.ephemeral.coreByProject[$].loadingState={type:"loaded"}}))},ref:oe},"Use browser's state"),ae,Cp.default.createElement(Ip,{onClick:()=>{getStudio().transaction((({drafts:G})=>{G.historic.coreByProject[$]=W.onDiskState,G.ephemeral.coreByProject[$].loadingState={type:"loaded"}}))},ref:ie},"Use disk state")))},StateConflictRow_default=({projectId:$})=>{const W=useVal(getStudio().atomP.ephemeral.coreByProject[$].loadingState);return W&&"browserStateIsNotBasedOnDiskState"===W.type?Cp.default.createElement(InConflict,{loadingState:W,projectId:$}):null},$p=jp.default.div`
  background-color: ${xf};
`,zp=jp.default.div`
  padding: 8px 10px;
  display: flex;
  flex-direction: column;
  align-items: stretch;
`,Mp=(0,jp.default)(qc)`
  width: 280px;
  padding: 1em;
`,ProjectDetails_default=({projects:$})=>{const W=$[0],G=W.address.projectId,[oe,ae]=(0,Ep.useState)(!1),ie=(0,Ep.useCallback)((()=>{const $=JSON.stringify(getStudio().createContentOfSaveFile(W.address.projectId),null,2),G=new File([$],"state.json",{type:"application/json"}),oe=URL.createObjectURL(G),ie=document.createElement("a");ie.href=oe,ie.target="_blank",ie.setAttribute("download","state.json"),ie.rel="noopener",ie.click(),ae(!0),setTimeout((()=>{ae(!1)}),2e3),setTimeout((()=>{URL.revokeObjectURL(oe)}),4e4)}),[]),[se,le]=usePopover({pointerDistanceThreshold:50},(()=>Ep.default.createElement(Mp,null,"This will create a JSON file with the state of your project. You can commit this file to your git repo and include it in your production bundle.",Ep.default.createElement("a",{href:"https://docs.theatrejs.com/in-depth/#exporting",target:"_blank"},"Here is a quick guide on how to export to production."))));return Ep.default.createElement(Ep.default.Fragment,null,se,Ep.default.createElement($p,null,Ep.default.createElement(StateConflictRow_default,{projectId:G}),Ep.default.createElement(zp,null,Ep.default.createElement(Ip,{onMouseEnter:$=>le($,$.target),onClick:oe?void 0:ie,disabled:oe},oe?"(Exported)":`Export ${G} to JSON`))))},Rp=yd.default.div`
  background-color: transparent;
  pointer-events: none;
  position: fixed;
  left: 0;
  right: 0;
  top: 12px;
  bottom: 0px;
  z-index: ${El.propsPanel};

  &:before {
    display: block;
    content: ' ';
    position: absolute;
    top: 0;
    bottom: 0;
    right: 0;
    width: 20px;
    ${kl};
  }
`,Bp=yd.default.div`
  position: absolute;
  top: 0;
  right: 0;
  width: 260px;
  bottom: 0;
  /* transform: translateX(100%); */
  /* pointer-events: none; */

  ${Rp}:hover & {
    transform: translateX(0);
  }
`,Fp=yd.default.div`
  margin: 0 10px;
  color: #ffffffc2;
  font-weight: 500;
  font-size: 10px;
  user-select: none;
  ${kl};
  white-space: nowrap;
  overflow: hidden;
  text-overflow: ellipsis;
`,Np="32px",Lp=yd.default.div`
  height: ${Np};
  display: flex;
  align-items: center;
  position: absolute;
  top: 0;
  left: 0;
  right: 0;

  &:after {
    position: absolute;
    inset: 1px 0px;
    display: block;
    content: ' ';
    pointer-events: none;
    z-index: -1;
    background-color: #262c2dd1;
    /* border-radius: 2px 0 0 2px; */
  }
`,Hp=yd.default.div`
  ${kl};
  position: absolute;
  top: ${Np};
  left: 0;
  right: 0;
  height: auto;
  max-height: calc(100% - ${Np});
  overflow-y: scroll;
  padding: 0;
  user-select: none;
`,DetailPanel_default=$=>usePrism((()=>{const $=getOutlineSelection(),W=$.find(Bt);if(W)return vd.default.createElement(Rp,null,vd.default.createElement(Bp,null,vd.default.createElement(Lp,null,vd.default.createElement(Fp,{title:`${W.sheet.address.sheetId}: ${W.sheet.address.sheetInstanceId} > ${W.address.objectKey}`},vd.default.createElement(Cl,null,W.sheet.address.sheetId," "),vd.default.createElement(Ol,null,":"," "),vd.default.createElement(Cl,null,W.sheet.address.sheetInstanceId," "),vd.default.createElement(Ol,null," ",">"," "),vd.default.createElement(Cl,null,W.address.objectKey))),vd.default.createElement(Hp,null,vd.default.createElement(ObjectDetails_default,{objects:[W]}))));const G=$.find(zt);return G?vd.default.createElement(Rp,null,vd.default.createElement(Bp,null,vd.default.createElement(Lp,null,vd.default.createElement(Fp,{title:`${G.address.projectId}`},vd.default.createElement(Cl,null,G.address.projectId," "))),vd.default.createElement(Hp,null,vd.default.createElement(ProjectDetails_default,{projects:[G]})))):vd.default.createElement(vd.default.Fragment,null)}),[]),Vp=__toModule(vt.exports),qp=__toModule(vt.exports),Up=__toModule(mu),Kp=__toModule(W),Wp=__toModule(vt.exports);var Gp=__toModule(vt.exports),panelDimsToPanelPosition=($,W)=>{const G=$.left/W.width,oe=($.left+$.width)/W.width,ae=$.top/W.height,ie=($.height+$.top)/W.height;return{edges:{left:G<=.5?{from:"screenLeft",distance:G}:{from:"screenRight",distance:1-G},right:oe<=.5?{from:"screenLeft",distance:oe}:{from:"screenRight",distance:1-oe},top:ae<=.5?{from:"screenTop",distance:ae}:{from:"screenBottom",distance:1-ae},bottom:ie<=.5?{from:"screenTop",distance:ie}:{from:"screenBottom",distance:1-ie}}}},Xp=Gp.default.createContext(null),usePanel=()=>(0,Gp.useContext)(Xp),BasePanel_default=({panelId:$,children:W,defaultPosition:G,minDims:oe})=>{const ae=useWindowSize_default(800,200),[ie,se]=function useLockSet(){const[$,W]=(0,Wp.useState)(!1);return[$,(0,Wp.useMemo)((()=>{const $=new Set;return()=>{const unlock=()=>{$.delete(unlock),W($.size>0)};return $.add(unlock),W(!0),unlock}}),[])]}(),{stuff:le}=usePrism((()=>{var W;const{edges:le}=null!=(W=(0,Kp.val)(getStudio().atomP.historic.panelPositions[$]))?W:G,ue=Math.floor(ae.width*("screenLeft"===le.left.from?le.left.distance:1-le.left.distance)),de=Math.floor(ae.width*("screenLeft"===le.right.from?le.right.distance:1-le.right.distance)),pe=Math.floor(ae.height*("screenTop"===le.top.from?le.top.distance:1-le.top.distance)),he=Math.floor(ae.height*("screenTop"===le.bottom.from?le.bottom.distance:1-le.bottom.distance));return{stuff:{dims:{width:Math.max(de-ue,oe.width),left:ue,top:pe,height:Math.max(he-pe,oe.height)},panelId:$,minDims:oe,boundsHighlighted:ie,addBoundsHighlightLock:se}}}),[$,ae,ie,se]);return Gp.default.createElement(Xp.Provider,{value:le},W)},Yp=__toModule(vt.exports),Jp=__toModule(vt.exports),Qp=__toModule(mu),Zp=Qp.default.div`
  pointer-events: auto;
  &.normal {
    pointer-events: none;
  }
`,th=Qp.default.div`
  position: absolute;
  inset: 0;
  pointer-events: none;

  #pointer-root:not(.normal) > & {
    pointer-events: auto;
  }
`,ah=(0,Jp.createContext)({}),useCursorLock=($,W,G)=>{const oe=(0,Jp.useContext)(ah);(0,Jp.useLayoutEffect)((()=>{if($)return oe.getLock(W,G)}),[$,W,G])},PointerEventsHandler_default=$=>{var W,G,oe,ae;const[ie,se]=(0,Jp.useState)([]),le=(0,Jp.useMemo)((()=>({getLock:($,W)=>{const G={className:$,cursor:W};se(($=>[...$,G]));return()=>{se(($=>$.filter(($=>$!==G))))}}})),[]);return Jp.default.createElement(ah.Provider,{value:le},Jp.default.createElement(Zp,{id:"pointer-root",className:(null!=(G=null==(W=ie[0])?void 0:W.className)?G:"normal")+" "+$.className},Jp.default.createElement(th,{style:{cursor:null!=(ae=null==(oe=ie[0])?void 0:oe.cursor)?ae:""}},$.children)))};function useDrag($,W){const G=(0,Yp.useRef)(W);G.current=W;const[oe,ae]=useRefAndState("notDragging");useCursorLock("dragging"===ae&&"string"==typeof W.lockCursorTo,"dragging",W.lockCursorTo);const ie=(0,Yp.useRef)({dragHappened:!1,startPos:{x:0,y:0}});return(0,Yp.useLayoutEffect)((()=>{if(!$)return;const dragHandler=$=>{ie.current.dragHappened||(ie.current.dragHappened=!0),oe.current="dragging";const W=($=>{const{startPos:W}=ie.current;return[$.screenX-W.x,$.screenY-W.y]})($);G.current.onDrag(W[0],W[1],$)},dragEndHandler=()=>{removeDragListeners(),oe.current="notDragging",G.current.onDragEnd&&G.current.onDragEnd(ie.current.dragHappened)},removeDragListeners=()=>{document.removeEventListener("mousemove",dragHandler),document.removeEventListener("mouseup",dragEndHandler)},preventUnwantedClick=$=>{G.current.disabled||ie.current.dragHappened&&(G.current.dontBlockMouseDown||"notDragging"===oe.current||($.stopPropagation(),$.preventDefault()),ie.current.dragHappened=!1)},dragStartHandler=$=>{const W=G.current;if(!0===W.disabled)return;if(0!==$.button)return;if(!1===(W.onDragStart&&W.onDragStart($)))return;W.dontBlockMouseDown||($.stopPropagation(),$.preventDefault()),oe.current="dragStartCalled";const{screenX:ae,screenY:se}=$;ie.current.startPos={x:ae,y:se},ie.current.dragHappened=!1,document.addEventListener("mousemove",dragHandler),document.addEventListener("mouseup",dragEndHandler)},onMouseDown=$=>{dragStartHandler($)};return $.addEventListener("mousedown",onMouseDown),$.addEventListener("click",preventUnwantedClick),()=>{removeDragListeners(),$.removeEventListener("mousedown",onMouseDown),$.removeEventListener("click",preventUnwantedClick),"notDragging"!==oe.current&&G.current.onDragEnd&&G.current.onDragEnd("dragging"===oe.current),oe.current="notDragging"}}),[$]),["dragging"===ae]}var lh=__toModule(vt.exports),ch=__toModule(mu).default.div`
  cursor: move;
`,PanelDragZone_default=$=>{const W=usePanel(),G=(0,lh.useRef)(W);G.current=W;const[oe,ae]=useRefAndState(null);useDrag(ae,(0,lh.useMemo)((()=>{let $,oe,ae=G.current;return{lockCursorTo:"move",onDragStart(){if(ae=G.current,oe){const $=oe;oe=void 0,$()}oe=W.addBoundsHighlightLock()},onDrag(W,G){const oe=__spreadProps(__spreadValues({},ae.dims),{top:ae.dims.top+G,left:ae.dims.left+W}),ie=panelDimsToPanelPosition(oe,{width:window.innerWidth,height:window.innerHeight});null==$||$.discard(),$=getStudio().tempTransaction((({stateEditors:$})=>{$.studio.historic.panelPositions.setPanelPosition({position:ie,panelId:ae.panelId})}))},onDragEnd(W){if(oe){const $=oe;oe=void 0,$()}W?null==$||$.commit():null==$||$.discard(),$=void 0}}}),[]));const[ie,se]=(0,lh.useMemo)((()=>{let $;return[function onMouseEnter2(){if($){const W=$;$=void 0,W()}$=W.addBoundsHighlightLock()},function onMouseLeave2(){if($){const W=$;$=void 0,W()}}]}),[]);return lh.default.createElement(ch,__spreadProps(__spreadValues({},$),{ref:oe,onMouseEnter:ie,onMouseLeave:se}))},vh=__toModule(vt.exports),yh=__toModule(mu),bh=__toModule(vt.exports),wh=__toModule(mu),xh=__toModule(vt.exports),kh=__toModule(mu),_h=kh.default.div`
  position: absolute;
  z-index: 10;
  ${kl};
  &:after {
    position: absolute;
    top: -2px;
    right: -2px;
    bottom: -2px;
    left: -2px;
    display: block;
    content: ' ';
  }

  opacity: 0;
  background-color: #478698;

  &.isHighlighted {
    opacity: 0.7;
  }

  &.isDragging {
    opacity: 1;
    /* background-color: ${wl(.2,"#478698")}; */
  }

  &:hover {
    opacity: 1;
  }
`,Eh=(0,kh.default)(_h)`
  left: 0;
  right: 0;
  height: 1px;
`,jh=(0,kh.default)(Eh)`
  top: 0;
`,Dh=(0,kh.default)(Eh)`
  bottom: 0;
`,zh=(0,kh.default)(_h)`
  top: 0;
  bottom: 0;
  width: 1px;
`,Fh=(0,kh.default)(zh)`
  left: 0;
`,Gh=(0,kh.default)(zh)`
  right: 0;
`,em=(0,kh.default)(_h)`
  width: 8px;
  height: 8px;
`,tm={Top:jh,TopLeft:(0,kh.default)(em)`
  top: 0;
  left: 0;
`,TopRight:(0,kh.default)(em)`
  top: 0;
  right: 0;
`,Bottom:Dh,BottomLeft:(0,kh.default)(em)`
  bottom: 0;
  left: 0;
`,BottomRight:(0,kh.default)(em)`
  bottom: 0;
  right: 0;
`,Left:Fh,Right:Gh},rm={Top:"ns-resize",Bottom:"ns-resize",Left:"ew-resize",Right:"ew-resize",TopLeft:"nw-resize",TopRight:"ne-resize",BottomLeft:"sw-resize",BottomRight:"se-resize"},PanelResizeHandle_default=({which:$})=>{const W=usePanel(),G=(0,xh.useRef)(W);G.current=W;const[oe,ae]=(0,xh.useState)(!1),[ie,se]=useRefAndState(null);useDrag(se,(0,xh.useMemo)((()=>{let oe,ie,se=G.current;return{lockCursorTo:rm[$],onDragStart(){if(se=G.current,ae(!0),ie){const $=ie;ie=void 0,$()}ie=W.addBoundsHighlightLock()},onDrag(W,G){const ae=__spreadValues({},se.dims);if($.startsWith("Bottom"))ae.height=Math.max(ae.height+G,se.minDims.height);else if($.startsWith("Top")){const $=ae.top+ae.height,W=Math.min($-se.minDims.height,ae.top+G),oe=$-W;ae.height=oe,ae.top=W}if($.endsWith("Left")){const $=ae.left+ae.width,G=Math.min($-se.minDims.width,ae.left+W),oe=$-G;ae.width=oe,ae.left=G}else $.endsWith("Right")&&(ae.width=Math.max(ae.width+W,se.minDims.width));const ie=panelDimsToPanelPosition(ae,{width:window.innerWidth,height:window.innerHeight});null==oe||oe.discard(),oe=getStudio().tempTransaction((({stateEditors:$})=>{$.studio.historic.panelPositions.setPanelPosition({position:ie,panelId:se.panelId})}))},onDragEnd($){if(ie){const $=ie;ie=void 0,$()}ae(!1),$?null==oe||oe.commit():null==oe||oe.discard(),oe=void 0}}}),[$]));const le=tm[$],ue=$.length<=6;return xh.default.createElement(le,{ref:ie,className:[oe?"isDragging":"",W.boundsHighlighted&&ue?"isHighlighted":""].join(" "),style:{cursor:rm[$]}})};wh.default.div``;var PanelResizers_default=$=>bh.default.createElement(bh.default.Fragment,null,bh.default.createElement(PanelResizeHandle_default,{which:"Bottom"}),bh.default.createElement(PanelResizeHandle_default,{which:"Top"}),bh.default.createElement(PanelResizeHandle_default,{which:"Left"}),bh.default.createElement(PanelResizeHandle_default,{which:"Right"}),bh.default.createElement(PanelResizeHandle_default,{which:"TopLeft"}),bh.default.createElement(PanelResizeHandle_default,{which:"TopRight"}),bh.default.createElement(PanelResizeHandle_default,{which:"BottomLeft"}),bh.default.createElement(PanelResizeHandle_default,{which:"BottomRight"})),nm=yh.default.div`
  position: absolute;
  user-select: none;
  box-sizing: border-box;
  ${kl};
  /* box-shadow: 1px 2px 10px -5px black; */

  z-index: 1000;
`,om=vh.default.forwardRef((($,W)=>{const G=usePanel(),oe=$,{style:ae,children:ie}=oe,se=__objRest(oe,["style","children"]);return vh.default.createElement(nm,__spreadProps(__spreadValues({ref:W},se),{style:__spreadValues({width:G.dims.width+"px",height:G.dims.height+"px",top:G.dims.top+"px",left:G.dims.left+"px"},null!=ae?ae:{})}),vh.default.createElement(PanelResizers_default,null),ie)})),am=__toModule(Je()),im={edges:{left:{from:"screenLeft",distance:.3},right:{from:"screenRight",distance:.3},top:{from:"screenTop",distance:.3},bottom:{from:"screenBottom",distance:.3}}},sm={width:300,height:300},lm=(0,Up.default)(om)`
  overflow-y: hidden;
  display: flex;
  flex-direction: column;

  box-shadow: 0px 5px 12px -4px rgb(0 0 0 / 22%);
  z-index: ${El.pluginPanes};
`,um=Up.default.div`
  width: 100%;
`,cm=Up.default.div`
  display: flex;
  align-items: center;
  opacity: 1;
  position: absolute;
  right: 4px;
  top: 0;
  bottom: 0;
`,dm=Up.default.button`
  display: flex;
  align-items: center;
  justify-content: center;
  border-radius: 2px;
  font-size: 11px;
  height: 10px;
  width: 18px;
  color: #adadadb3;
  background: transparent;
  border: none;
  cursor: pointer;
  &:hover {
    color: white;
  }
`,fm=(0,Up.default)(Il)`
  position: relative;
  overflow: hidden;

  &:after {
    z-index: 10;
    position: absolute;
    inset: 0;
    display: block;
    content: ' ';
    pointer-events: none;

    #pointer-root:not(.normal) & {
      pointer-events: auto;
    }
  }
`,pm=Up.default.div`
  padding: 12px;

  & > pre {
    border: 1px solid #ff62624f;
    background-color: rgb(255 0 0 / 5%);
    margin: 8px 0;
    padding: 8px;
    font-family: monospace;
    overflow: scroll;
    color: #ff9896;
  }
`,ErrorFallback=$=>qp.default.createElement(pm,null,"An Error occured rendering this pane. Open the console for more info.",qp.default.createElement("pre",null,JSON.stringify({message:$.error.message,stack:$.error.stack},null,2))),Content3=({paneInstance:$})=>{const W=$.definition.component,G=(0,qp.useCallback)((()=>{getStudio().paneManager.destroyPane($.instanceId)}),[$]);return qp.default.createElement(lm,null,qp.default.createElement(PanelDragZone_default,null,qp.default.createElement(Tl,null,qp.default.createElement(cm,null,qp.default.createElement(dm,{onClick:G,title:"Close Pane"},qp.default.createElement(IoClose,null))),qp.default.createElement(um,null,$.instanceId))),qp.default.createElement(fm,null,qp.default.createElement(am.ErrorBoundary,{FallbackComponent:ErrorFallback},qp.default.createElement(W,{paneId:$.instanceId}))))},PaneWrapper_default=({paneInstance:$})=>qp.default.createElement(BasePanel_default,{panelId:`pane-${$.instanceId}`,defaultPosition:im,minDims:sm},qp.default.createElement(Content3,{paneInstance:$})),hm=__toModule(W),valToAtom=($,W)=>{const G=hm.prism.memo($,(()=>new hm.Atom(W)),[]);return G.setState(W),G},mm=__toModule(W),gm=__toModule(vt.exports),vm=__toModule(mu),ym=__toModule(vt.exports),bm=__toModule(mu),wm=__toModule(W),Sm=__toModule(vt.exports),xm=__toModule(mu),km=__toModule(vt.exports),_m=__toModule(mu),Pm=__toModule(vt.exports),Em=__toModule(mu),jm=__toModule(vt.exports),Cm=__toModule(mu),Om=Cm.default.li`
  --depth: ${$=>$.depth};
  margin: 0;
  padding: 0;
  list-style: none;
`,Im=Cm.default.div`
  border-bottom: 1px solid #7695b705;
`,Tm=(0,Cm.default)(Im)`
  padding-left: calc(16px + var(--depth) * 20px);

  display: flex;
  align-items: stretch;
  color: ${_l.panel.body.compoudThing.label.color};

  box-sizing: border-box;

  ${$=>$.isSelected&&"background: blue"};
`,Dm=Cm.default.span`
  ${_f};
  overflow-x: hidden;
  text-overflow: ellipsis;
  white-space: nowrap;
  padding-right: 4px;
  line-height: 26px;
  flex-wrap: nowrap;
`,Am=Cm.default.span`
  width: 12px;
  margin-right: 8px;
  font-size: 9px;
  display: flex;
  align-items: center;

  transform: rotateZ(${$=>$.isOpen?90:0}deg);
`,$m=Cm.default.ul`
  margin: 0;
  padding: 0;
  list-style: none;
`,AnyCompositeRow_default=({leaf:$,label:W,children:G,isSelectable:oe,isSelected:ae,toggleSelect:ie})=>{const se=Array.isArray(G)&&G.length>0;return jm.default.createElement(Om,{depth:$.depth},jm.default.createElement(Tm,{style:{height:$.nodeHeight+"px"},isSelectable:!0===oe,isSelected:!0===ae,onClick:ie,isEven:$.n%2==0},jm.default.createElement(Am,{isOpen:!0},jm.default.createElement(HiOutlineChevronRight,null)),jm.default.createElement(Dm,null,W)),se&&jm.default.createElement($m,null,G))},zm=__toModule(vt.exports),Mm=__toModule(mu),encodePathToProp=$=>JSON.stringify($);var Rm=__toModule(W),Bm=__toModule(vt.exports),Fm=__toModule(mu),Nm=__toModule(W),Lm=__toModule(vt.exports),Hm=__toModule(mu),Vm=__toModule(W),qm=__toModule(vt.exports),Um=__toModule(mu),Km=__toModule(vt.exports),Wm=__toModule(vt.exports);function useKeyDown($){const[W,G]=(0,Km.useState)(!1);return function useKeyDownCallback($,W){const G=(0,Wm.useRef)({combo:$,listener:W});G.current={combo:$,listener:W},(0,Wm.useEffect)((()=>{function onKeyDown($){$.key===G.current.combo&&G.current.listener({down:!0,event:$})}function onKeyUp($){$.key===G.current.combo&&G.current.listener({down:!1,event:$})}function onBlur($){G.current.listener({down:!1,event:void 0})}return document.addEventListener("keydown",onKeyDown),document.addEventListener("keyup",onKeyUp),window.addEventListener("blur",onBlur),()=>{document.removeEventListener("keydown",onKeyDown),document.removeEventListener("keyup",onKeyUp),window.removeEventListener("blur",onBlur)}}),[])}($,(({down:$})=>{G($)})),W}var Gm=__toModule(W),Xm=__toModule(vt.exports);var Ym=__toModule(W);function mutableSetDeep($,W,G){const oe=(0,Ym.getPointerParts)(W((0,Ym.pointer)({root:{},path:[]}))).path;Hs($,oe,G)}var Jm,Qm=__toModule(W),Zm=__toModule(vt.exports),ng=__toModule(mu),og=ng.default.div`
  cursor: ${$=>$.isShiftDown?"cell":"default"};
`;!function($){const W={primitiveProp($,W,G,oe){const{sheetObject:ae,trackId:ie}=W,se=(0,Qm.val)(getStudio().atomP.historic.coreByProject[ae.address.projectId].sheetsById[ae.address.sheetId].sequence.tracksByObject[ae.address.objectKey].trackData[ie]);se.keyframes.filter(($=>$.position>=G.positions[0]&&$.position<=G.positions[1]));for(const $ of se.keyframes)if(!($.position<=G.positions[0])){if($.position>=G.positions[1])break;mutableSetDeep(oe,(W=>W.byObjectKey[ae.address.objectKey].byTrackId[ie].byKeyframeId[$.id]),!0)}}};function collectFromAnyLeaf($,G,oe,ae){if(oe.ys[0]>G.top+G.heightIncludingChildren||G.top>oe.ys[1])return;const ie=W[G.type];ie?ie($,G,oe,ae):(($,W,G,oe)=>{if("children"in W)for(const ae of W.children)collectFromAnyLeaf($,ae,G,oe)})($,G,oe,ae)}$.boundsToSelection=function boundsToSelection($,W){const G=(0,Qm.val)($.tree.sheet),oe={type:"DopeSheetSelection",byObjectKey:{},getDragHandlers(W){let ae,ie;return{onDragStart(){ie=(0,Qm.val)($.scaledSpace.toUnitSpace)},onDrag($,se,le){let ue=ie($);ae&&(ae.discard(),ae=void 0);const de=le.composedPath().find(($=>$ instanceof Element&&$!==W.domNode&&$.hasAttribute("data-pos")));if(de){const $=parseFloat(de.getAttribute("data-pos"));isFinite($)&&(ue=$-W.positionAtStartOfDrag)}ae=getStudio().tempTransaction((({stateEditors:$})=>{const ae=$.coreByProject.historic.sheetsById.sequence.transformKeyframes;for(const $ of Object.keys(oe.byObjectKey)){const{byTrackId:ie}=oe.byObjectKey[$];for(const oe of Object.keys(ie)){const{byKeyframeId:se}=ie[oe];ae({trackId:oe,keyframeIds:Object.keys(se),translate:ue,scale:1,origin:0,snappingFunction:G.getSequence().closestGridPosition,objectKey:$,projectId:W.projectId,sheetId:W.sheetId})}}}))},onDragEnd($){$?ae&&ae.commit():ae&&ae.discard(),ae=void 0}}},delete(){getStudio().transaction((({stateEditors:$})=>{const W=$.coreByProject.historic.sheetsById.sequence.deleteKeyframes;for(const $ of Object.keys(oe.byObjectKey)){const{byTrackId:ae}=oe.byObjectKey[$];for(const oe of Object.keys(ae)){const{byKeyframeId:ie}=ae[oe];W(__spreadProps(__spreadValues({},G.address),{objectKey:$,trackId:oe,keyframeIds:Object.keys(ie)}))}}}))}};W=sortBounds(W);const ae=(0,Qm.val)($.tree);return collectFromAnyLeaf($,ae,W,oe),oe}}(Jm||(Jm={}));var ag=ng.default.div`
  position: absolute;
  background: rgba(255, 255, 255, 0.1);
  border: 1px dashed rgba(255, 255, 255, 0.4);
  box-size: border-box;
`,sortBounds=$=>({positions:[...$.positions].sort((($,W)=>$-W)),ys:[...$.ys].sort((($,W)=>$-W))}),SelectionRectangle=({state:$,layoutP:W})=>{const G=function useValToAtom($){const W=(0,Xm.useMemo)((()=>new Gm.Atom($)),[]);return(0,Xm.useLayoutEffect)((()=>{W.setState($)}),[$]),W}($);return usePrism((()=>{const $=(0,Qm.val)(G.pointer),oe=sortBounds($),ae=(0,Qm.val)(W.scaledSpace.fromUnitSpace),ie=oe.positions.map(ae),se=oe.ys[0],le=oe.ys[1]-oe.ys[0],ue=ie[0],de=ie[1]-ie[0];return Zm.default.createElement(ag,{style:{top:se+"px",height:le+"px",left:ue+"px",width:de+"px"}})}),[W,G])},DopeSheetSelectionView_default=({layoutP:$,children:W})=>{const[G,oe]=useRefAndState(null),ae=useKeyDown("Shift"),ie=function useCaptureSelection($,W){const[G,oe]=useRefAndState(null);return useDrag(W,(0,Zm.useMemo)((()=>({dontBlockMouseDown:!0,lockCursorTo:"cell",onDragStart(oe){if(!oe.shiftKey||oe.target instanceof HTMLInputElement)return!1;const ae=W.getBoundingClientRect(),ie=oe.clientX-ae.left,se=(0,Qm.val)($.scaledSpace.toUnitSpace)(ie);G.current={positions:[se,se],ys:[oe.clientY-ae.top,oe.clientY-ae.top]},(0,Qm.val)($.selectionAtom).setState({current:void 0})},onDrag(oe,ae,ie){G.current;const se=W.getBoundingClientRect(),le=ie.clientX-se.left,ue=(0,Qm.val)($.scaledSpace.toUnitSpace)(le);G.current={positions:[G.current.positions[0],ue],ys:[G.current.ys[0],ie.clientY-se.top]};const de=Jm.boundsToSelection($,G.current);(0,Qm.val)($.selectionAtom).setState({current:de})},onDragEnd($){G.current=null}})),[$,W,G])),oe}($,oe);return(0,Zm.useRef)(ie).current=ie,Zm.default.createElement(og,{ref:G,isShiftDown:ae},ie&&Zm.default.createElement(SelectionRectangle,{state:ie,layoutP:$}),W)},ug=__toModule(W),cg=__toModule(vt.exports),dg=__toModule(mu),pg=__toModule(vt.exports),mg=__toModule(mu).default.div`
  position: absolute;
  top: 0;
  right: 0;
  left: 0;
  bottom: 0;
  overflow-x: hidden;
  overflow-y: scroll;
  z-index: ${()=>xw.scrollableArea};

  &::-webkit-scrollbar {
    display: none;
  }
`,bg=(0,pg.createContext)(voidFn),VerticalScrollContainer_default=$=>{const W=(0,pg.useRef)(null),G=(0,pg.useCallback)(($=>{}),[]);return pg.default.createElement(bg.Provider,{value:G},pg.default.createElement(mg,{ref:W},$.children))},wg=dg.default.div`
  position: absolute;

  right: 0;
  overflow-x: scroll;
  overflow-y: hidden;
  ${kl};

  // hide the scrollbar on Gecko
  scrollbar-width: none;

  // hide the scrollbar on Webkit/Blink
  &::-webkit-scrollbar {
    display: none;
  }
`,kg=dg.default.div`
  position: absolute;
`,_g=cg.default.memo((({layoutP:$,children:W,height:G})=>{const{width:oe,unitSpaceToScaledSpaceMultiplier:ae}=usePrism((()=>({width:(0,ug.val)($.rightDims.width),unitSpaceToScaledSpaceMultiplier:(0,ug.val)($.scaledSpace.fromUnitSpace)(1)})),[$]),[ie,se]=useRefAndState(null);return function useHandlePanAndZoom($,W){(0,pg.useContext)(bg),(0,cg.useLayoutEffect)((()=>{if(!W)return;const receiveWheelEvent=G=>{if(Math.abs(G.deltaY)<Math.abs(G.deltaX)){G.preventDefault(),G.stopPropagation();const W=(0,ug.val)($.scaledSpace.toUnitSpace)(1*G.deltaX),oe=(0,ug.val)($.clippedSpace.range),ae=Ts(oe,($=>$+W));(0,ug.val)($.clippedSpace.setRange)(ae)}else if(G.ctrlKey){G.preventDefault(),G.stopPropagation();const oe=G.clientX-W.getBoundingClientRect().left,ae=(0,ug.val)($.clippedSpace.toUnitSpace)(oe),ie=(0,ug.val)($.clippedSpace.range),se=1+.03*normalize(G.deltaY,[-50,50]),le=Ts(ie,($=>($-ae)*se+ae)),ue=(0,ug.val)($.sheet).getSequence().length,de=ue+.25*ue;(0,ug.val)($.clippedSpace.setRange)(function normalizeRange($,W){return Ts($,($=>normalize($,W)))}(le,[0,de]))}else if(G.shiftKey){G.preventDefault(),G.stopPropagation();const W=(0,ug.val)($.sheet).getSequence().length,oe=(0,ug.val)($.clippedSpace.range),ae=(oe.end-oe.start)/W,ie=.05*normalize(G.deltaY,[-50,50])*ae,se=Ts(oe,($=>$+ie));(0,ug.val)($.clippedSpace.setRange)(se)}},G={capture:!0,passive:!1};return W.addEventListener("wheel",receiveWheelEvent,G),()=>{W.removeEventListener("wheel",receiveWheelEvent,G)}}),[W,$])}($,se),function useDragHandlers($,W){const G=(0,cg.useMemo)((()=>{let G,oe,ae=0;const ie=(0,ug.val)($.seeker.setIsSeeking);return{onDrag($,W,ie){const se=oe($);let le=Uo(ae+se,0,G.length);const ue=ie.composedPath().find(($=>$ instanceof Element&&$.hasAttribute("data-pos")));if(ue){const $=parseFloat(ue.getAttribute("data-pos"));isFinite($)&&(le=$)}G.position=le},onDragStart(se){if(se.target instanceof HTMLInputElement)return!1;if(se.shiftKey||se.altKey||se.ctrlKey||se.metaKey)return!1;if(se.composedPath().some(($=>$ instanceof HTMLElement&&!0===$.draggable)))return!1;const le=se.clientX-W.getBoundingClientRect().left,ue=Uo((0,ug.val)($.clippedSpace.toUnitSpace)(le),0,1/0);G=(0,ug.val)($.sheet).getSequence(),G.position=ue,ae=ue,oe=(0,ug.val)($.scaledSpace.toUnitSpace),ie(!0)},onDragEnd(){ie(!1)}}}),[$,W]),[oe]=useDrag(W,G);useCursorLock(oe,"draggingPositionInSequenceEditor","ew-resize")}($,se),function useUpdateScrollFromClippedSpaceRange($,W){(0,cg.useLayoutEffect)((()=>{if(!W)return;const G=(0,ug.prism)((()=>{const W=(0,ug.val)($.clippedSpace.range);return(0,ug.val)($.scaledSpace.fromUnitSpace)(W.start)})),update=()=>{const $=G.getValue();W.scrollLeft=$},oe=G.changesWithoutValues().tap(update);update();const ae=setTimeout(update,100);return()=>{clearTimeout(ae),oe()}}),[$,W])}($,se),cg.default.createElement(wg,{ref:ie,style:{width:oe+"px",height:G+"px","--unitSpaceToScaledSpaceMultiplier":ae}},cg.default.createElement(kg,{style:{left:(0,ug.val)($.scaledSpace.leftPadding)+"px"}},W))}));function normalize($,[W,G]){return Math.max(Math.min($,G),W)}var Pg,Dg,$g=__toModule(vt.exports),Fg=__toModule(mu),Kg=__toModule(vt.exports),Yg=__toModule(mu),Zg=__toModule(vt.exports),ev=__toModule(mu),tv=__toModule(W),rv=__toModule(vt.exports),nv=__toModule(W),ov=__toModule(vt.exports),av=__toModule(mu),iv=__toModule(vt.exports),sv=__toModule(mu),lv=__toModule(W),uv=__toModule(vt.exports),cv=__toModule(vt.exports),dv=__toModule(mu),fv=__toModule(W),pv=__toModule(vt.exports),hv=__toModule(mu),mv=__toModule(W),gv=__toModule(W),vv=(0,gv.prism)((()=>{const[$,W]=gv.prism.state("pos",null);return gv.prism.effect("setupListeners",(()=>{const handleMouseMove=$=>{W($)};return document.addEventListener("mousemove",handleMouseMove),()=>{document.removeEventListener("mousemove",handleMouseMove)}}),[]),$})),yv=vv,bv=__toModule(vt.exports);(Dg=Pg||(Pg={}))[Dg.hidden=0]="hidden",Dg[Dg.locked=1]="locked",Dg[Dg.snapped=2]="snapped",Dg[Dg.free=3]="free";var wv=(0,bv.createContext)(null),Sv=0,useLockFrameStampPosition=($,W)=>{const{getLock:G}=(0,bv.useContext)(wv),oe=(0,bv.useRef)();(0,bv.useLayoutEffect)((()=>{if($)return oe.current=G(),()=>{oe.current.unlock()}}),[$]),(0,bv.useLayoutEffect)((()=>{$&&oe.current.set(W)}),[W])},xv="data-theatre-lock-framestamp-to",pointerPositionInUnitSpace=$=>(0,mv.prism)((()=>{const W=(0,mv.val)($.rightDims),G=(0,mv.val)($.clippedSpace.toUnitSpace);(0,mv.val)($.scaledSpace.leftPadding);const oe=(0,mv.val)(yv);if(!oe)return[-1,0];for(const $ of oe.composedPath()){if(!($ instanceof HTMLElement||$ instanceof SVGElement))break;if($.hasAttribute(xv)){const W=$.getAttribute(xv);if("string"!=typeof W)continue;if("hide"===W)return[-1,0];const G=parseFloat(W);if(isFinite(G)&&G>=0)return[G,2]}}const{clientX:ae,clientY:ie}=oe,{screenX:se,screenY:le,width:ue,height:de}=W;if(Cs(ae,se,se+ue)&&Cs(ie,le,le+de)){return[G(ae-se),3]}return[-1,0]})),FrameStampPositionProvider_default=({children:$,layoutP:W})=>{const G=(0,bv.useMemo)((()=>new mv.Atom({list:[]})),[]),oe=(0,bv.useMemo)((()=>(0,mv.prism)((()=>{const $=mv.prism.memo("p",(()=>pointerPositionInUnitSpace(W)),[W]).getValue(),oe=(0,mv.val)(G.pointer.list);return oe.length>0?ys(oe).position:$}))),[W]),ae=(0,bv.useCallback)((()=>{const $=Sv++;G.reduceState(["list"],(W=>[...W,{id:$,position:[-1,0]}]));return{set:W=>{G.reduceState(["list"],(G=>{const oe=G.findIndex((W=>W.id===$));if(-1===oe)return console.warn("Lock is already freed. This is a bug."),G;const ae=[...G];return ae.splice(oe,1,{id:$,position:[W,-1===W?0:1]}),ae}))},unlock:()=>{G.reduceState(["list"],(W=>W.filter((W=>W.id!==$))))}}}),[]),ie={currentD:oe,getLock:ae};return bv.default.createElement(wv.Provider,{value:ie},$)},dims=$=>`\n  left: ${-$/2}px;\n  top: ${-$/2}px;\n  width: ${$}px;\n  height: ${$}px;\n`,kv={normalColor:"#40AAA4",get selectedColor(){return wl(.35,kv.normalColor)}},_v=hv.default.div`
  position: absolute;
  background: ${$=>$.isSelected?kv.selectedColor:kv.normalColor};
  transform: rotateZ(45deg);

  z-index: 1;
  pointer-events: none;
  ${$=>dims(($.isSelected,6))}
`,Pv=hv.default.div`
  position: absolute;
  ${dims(12)};

  z-index: 1;

  cursor: ew-resize;

  #pointer-root.draggingPositionInSequenceEditor & {
    pointer-events: auto;
    &:hover:after {
      position: absolute;
      top: calc(50% - ${17}px);
      left: calc(50% - ${17}px);
      width: ${34}px;
      height: ${34}px;
      display: block;
      content: ' ';
      background: url(${"data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMzQiIGhlaWdodD0iMzQiIHZpZXdCb3g9IjAgMCAzNCAzNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KICA8cGF0aCBkPSJNMSA3VjFINyIgc3Ryb2tlPSIjNzRGRkRFIiBzdHJva2Utd2lkdGg9IjAuMjUiIC8+CiAgPHBhdGggZD0iTTcgMzNIMUwxIDI3IiBzdHJva2U9IiM3NEZGREUiIHN0cm9rZS13aWR0aD0iMC4yNSIgLz4KICA8cGF0aCBkPSJNMzMgMjdWMzNIMjciIHN0cm9rZT0iIzc0RkZERSIgc3Ryb2tlLXdpZHRoPSIwLjI1IiAvPgogIDxwYXRoIGQ9Ik0yNyAxTDMzIDFWNyIgc3Ryb2tlPSIjNzRGRkRFIiBzdHJva2Utd2lkdGg9IjAuMjUiIC8+Cjwvc3ZnPg=="}) no-repeat 100% 100%;
      // This icon might also fit: GiConvergenceTarget
    }
  }

  &.beingDragged {
    pointer-events: none !important;
  }

  &:hover + ${_v}, &.beingDragged + ${_v} {
    ${dims(11)}
  }
`,Dot_default=$=>{const[W,G]=useRefAndState(null),[oe]=function useKeyframeContextMenu($,W){return useContextMenu($,{items:()=>[{label:W.selection?"Delete Selection":"Delete Keyframe",callback:()=>{W.selection?W.selection.delete():getStudio().transaction((({stateEditors:$})=>{$.coreByProject.historic.sheetsById.sequence.deleteKeyframes(__spreadProps(__spreadValues({},W.leaf.sheetObject.address),{keyframeIds:[W.keyframe.id],trackId:W.leaf.trackId}))}))}}]})}(G,$),[ae]=function useDragKeyframe($,W){const[G,oe]=(0,pv.useState)(!1);useLockFrameStampPosition(G,W.keyframe.position);const ae=(0,pv.useRef)(W);ae.current=W;const ie=(0,pv.useMemo)((()=>{let W,G,ie,se;return{onDragStart(G){var le;oe(!0);const ue=ae.current;if(ue.selection){const{selection:W,leaf:oe}=ue,{sheetObject:ae}=oe;return se=W.getDragHandlers(__spreadProps(__spreadValues({},ae.address),{pathToProp:oe.pathToProp,trackId:oe.trackId,keyframeId:ue.keyframe.id,domNode:$,positionAtStartOfDrag:ue.trackData.keyframes[ue.index].position})),void(null==(le=se.onDragStart)||le.call(se,G))}ie=ue,W=(0,fv.val)(ie.layoutP.scaledSpace.toUnitSpace)},onDrag(oe,ae,le){if(se)return void se.onDrag(oe,ae,le);const ue=ie.trackData.keyframes[ie.index],de=W(oe);let pe=Math.max(ue.position+de,0);const he=le.composedPath().find((W=>W instanceof Element&&W!==$&&W.hasAttribute("data-pos")));if(he){const $=parseFloat(he.getAttribute("data-pos"));isFinite($)&&(pe=$)}G&&(G.discard(),G=void 0),G=getStudio().tempTransaction((({stateEditors:$})=>{$.coreByProject.historic.sheetsById.sequence.replaceKeyframes(__spreadProps(__spreadValues({},ie.leaf.sheetObject.address),{trackId:ie.leaf.trackId,keyframes:[__spreadProps(__spreadValues({},ue),{position:pe})],snappingFunction:(0,fv.val)(ie.layoutP.sheet).getSequence().closestGridPosition}))}))},onDragEnd($){var W;oe(!1),se&&(null==(W=se.onDragEnd)||W.call(se,$),se=void 0),$?G&&G.commit():G&&G.discard(),G=void 0}}}),[]);return useDrag($,ie),useCursorLock(G,"draggingPositionInSequenceEditor","ew-resize"),[G]}(G,$);return pv.default.createElement(pv.default.Fragment,null,pv.default.createElement(Pv,__spreadProps(__spreadValues({ref:W,"data-pos":$.keyframe.position.toFixed(3)},{[xv]:$.keyframe.position.toFixed(3)}),{className:ae?"beingDragged":""})),pv.default.createElement(_v,{isSelected:!!$.selection}),oe)};var Ev={normalColor:"#365b59",get hoverColor(){return wl(.1,Ev.normalColor)},get selectedColor(){return wl(.2,Ev.normalColor)},get selectedHoverColor(){return wl(.4,Ev.normalColor)}},jv=dv.default.div`
  position: absolute;
  background: ${$=>$.isSelected?Ev.selectedColor:Ev.normalColor};
  height: ${4}px;
  width: ${1e3}px;

  left: 0;
  top: -${2}px;
  transform-origin: top left;
  z-index: 0;
  cursor: ew-resize;

  &:hover {
    background: ${$=>$.isSelected?Ev.selectedHoverColor:Ev.hoverColor};
  }
`,Connector_default=$=>{const{index:W,trackData:G}=$,oe=G.keyframes[W],ae=G.keyframes[W+1],ie=ae.position-oe.position,[se,le]=useRefAndState(null),[ue]=useContextMenu(le,{items:()=>[{label:$.selection?"Delete Selection":"Delete both Keyframes",callback:()=>{$.selection?$.selection.delete():getStudio().transaction((({stateEditors:W})=>{W.coreByProject.historic.sheetsById.sequence.deleteKeyframes(__spreadProps(__spreadValues({},$.leaf.sheetObject.address),{keyframeIds:[oe.id,ae.id],trackId:$.leaf.trackId}))}))}}]});return function useDragKeyframe2($,W){const G=(0,cv.useRef)(W);G.current=W;const oe=(0,cv.useMemo)((()=>{let W,oe,ae,ie,se;return{lockCursorTo:"ew-resize",onDragStart(oe){var le;const ue=G.current;if(ue.selection){const{selection:W,leaf:G}=ue,{sheetObject:ae}=G;return ie=W.getDragHandlers(__spreadProps(__spreadValues({},ae.address),{pathToProp:G.pathToProp,trackId:G.trackId,keyframeId:ue.keyframe.id,domNode:$,positionAtStartOfDrag:ue.trackData.keyframes[ue.index].position})),void(null==(le=ie.onDragStart)||le.call(ie,oe))}ae=ue,se=(0,lv.val)(ae.layoutP.sheet).getSequence(),W=(0,lv.val)(ae.layoutP.scaledSpace.toUnitSpace)},onDrag($,G,le){if(ie)return void ie.onDrag($,G,le);const ue=W($);oe&&(oe.discard(),oe=void 0),oe=getStudio().tempTransaction((({stateEditors:$})=>{$.coreByProject.historic.sheetsById.sequence.transformKeyframes(__spreadProps(__spreadValues({},ae.leaf.sheetObject.address),{trackId:ae.leaf.trackId,keyframeIds:[ae.keyframe.id,ae.trackData.keyframes[ae.index+1].id],translate:ue,scale:1,origin:0,snappingFunction:se.closestGridPosition}))}))},onDragEnd($){var W;ie&&(null==(W=ie.onDragEnd)||W.call(ie,$),ie=void 0),$?oe&&oe.commit():oe&&oe.discard(),oe=void 0}}}),[]);useDrag($,oe)}(le,$),uv.default.createElement(jv,{isSelected:!!$.selection,ref:se,onClick:$=>{if(0!==$.button)return;JSON.stringify([oe.handles[2],oe.handles[3],ae.handles[0],ae.handles[1]])},style:{transform:`scale3d(calc(var(--unitSpaceToScaledSpaceMultiplier) * ${ie/1e3}), 1, 1)`}},ue)};var Cv=sv.default.div`
  position: absolute;
`,Ov=iv.default.createElement(iv.default.Fragment,null),KeyframeEditor_default=$=>{const{index:W,trackData:G}=$,oe=G.keyframes[W],ae=G.keyframes[W+1],ie=oe.connectedRight&&!!ae;return iv.default.createElement(Cv,{style:{top:$.leaf.nodeHeight/2+"px",left:`calc(var(--unitSpaceToScaledSpaceMultiplier) * ${oe.position}px)`}},iv.default.createElement(Dot_default,__spreadValues({},$)),ie?iv.default.createElement(Connector_default,__spreadValues({},$)):Ov)};av.default.div``;var Iv=ov.default.memo((({layoutP:$,trackData:W,leaf:G})=>{const{selectedKeyframeIds:oe,selection:ae}=usePrism((()=>{const W=(0,nv.val)($.selectionAtom),oe=(0,nv.val)(W.pointer.current.byObjectKey[G.sheetObject.address.objectKey].byTrackId[G.trackId].byKeyframeId);return oe?{selectedKeyframeIds:oe,selection:(0,nv.val)(W.pointer.current)}:{selectedKeyframeIds:{},selection:void 0}}),[$,G.trackId]),ie=W.keyframes.map(((ie,se)=>ov.default.createElement(KeyframeEditor_default,{keyframe:ie,index:se,trackData:W,layoutP:$,leaf:G,key:"keyframe-"+ie.id,selection:!0===oe[ie.id]?ae:void 0})));return ov.default.createElement(ov.default.Fragment,null,ie)})),Tv=Iv,Dv=__toModule(vt.exports),Av=__toModule(mu),$v=Av.default.li`
  margin: 0;
  padding: 0;
  list-style: none;
  box-sizing: border-box;
  position: relative;
`,zv=Av.default.div`
  box-sizing: border-box;
  width: 100%;
  position: relative;

  &:before {
    position: absolute;
    display: block;
    content: ' ';
    left: -40px;
    top: 0;
    bottom: 0;
    right: 0;
    box-sizing: border-box;
    border-bottom: 1px solid #252b3869;
    background: ${$=>$.isEven?"transparent":"#6b8fb505"};
  }
`,Mv=Av.default.ul`
  margin: 0;
  padding: 0;
  list-style: none;
`,Row_default=({leaf:$,children:W,node:G})=>{const oe=Array.isArray(W)&&W.length>0;return Dv.default.createElement($v,null,Dv.default.createElement(zv,{style:{height:$.nodeHeight+"px"},isEven:$.n%2==0},G),oe&&Dv.default.createElement(Mv,null,W))},PrimitivePropRow_default=({leaf:$,layoutP:W})=>usePrism((()=>{const{sheetObject:G}=$,{trackId:oe}=$,ae=(0,tv.val)(getStudio().atomP.historic.coreByProject[G.address.projectId].sheetsById[G.address.sheetId].sequence.tracksByObject[G.address.objectKey].trackData[oe]);if("BasicKeyframedTrack"!==(null==ae?void 0:ae.type))return console.error(`trackData type ${null==ae?void 0:ae.type} is not yet supported on the sequence editor`),rv.default.createElement(Row_default,{leaf:$,node:rv.default.createElement("div",null)});{const G=rv.default.createElement(Tv,{layoutP:W,trackData:ae,leaf:$});return rv.default.createElement(Row_default,{leaf:$,node:G})}}),[$,W]),decideRowByPropType=($,W)=>"propWithChildren"===$.type?Zg.default.createElement(PropWithChildrenRow,{layoutP:W,leaf:$,key:"prop"+$.pathToProp[$.pathToProp.length-1]}):Zg.default.createElement(PrimitivePropRow_default,{layoutP:W,leaf:$,key:"prop"+$.pathToProp[$.pathToProp.length-1]});ev.default.div``;var PropWithChildrenRow=({leaf:$,layoutP:W})=>usePrism((()=>{const G=Zg.default.createElement("div",null);return Zg.default.createElement(Row_default,{leaf:$,node:G},$.children.map(($=>decideRowByPropType($,W))))}),[$,W]);Yg.default.div``;var SheetObjectRow_default=({leaf:$,layoutP:W})=>usePrism((()=>{const G=Kg.default.createElement("div",null);return Kg.default.createElement(Row_default,{leaf:$,node:G},$.children.map(($=>decideRowByPropType($,W))))}),[$,W]);Fg.default.div``;var SheetRow_default=({leaf:$,layoutP:W})=>usePrism((()=>$g.default.createElement($g.default.Fragment,null,$.children.map(($=>$g.default.createElement(SheetObjectRow_default,{layoutP:W,key:"sheetObject-"+$.sheetObject.address.objectKey,leaf:$}))))),[$,W]),Rv=1e6,Bv=Um.default.ul`
  margin: 0;
  padding: 0;
  list-style: none;
  position: absolute;
  left: 0;
  width: ${Rv}px;
`;Um.default.div`
  position: absolute;
  top: 0;
  right: 0;
  width: ${$=>$.width};
  bottom: 0;
  z-index: ${()=>xw.rightBackground};
  overflow: hidden;
  background: ${bl(.03,_l.panel.bg)};
`;var Right_default=({layoutP:$})=>usePrism((()=>{const W=(0,Vm.val)($.tree),G=(0,Vm.val)($.tree.top)+Math.max((0,Vm.val)($.tree.heightIncludingChildren),(0,Vm.val)($.dopeSheetDims.height));return qm.default.createElement(qm.default.Fragment,null,qm.default.createElement(_g,{layoutP:$,height:G},qm.default.createElement(DopeSheetSelectionView_default,{layoutP:$},qm.default.createElement(Bv,{style:{top:W.top+"px"}},qm.default.createElement(SheetRow_default,{leaf:W,layoutP:$})))))}),[$]),Fv=__toModule(W),Nv=__toModule(vt.exports),Lv=__toModule(mu),Hv=__toModule(vt.exports),Vv=__toModule(mu),qv=__toModule(vt.exports),Uv=__toModule(mu),Kv=__toModule(vt.exports),Wv=__toModule(mu).default.path`
  stroke-width: 2;
  stroke: var(--main-color);
  fill: none;
  vector-effect: non-scaling-stroke;
`;function transformBox($,W,G,oe){0===G&&(G=1e-4);0===oe&&(oe=.001);return`translate(${`calc(var(--unitSpaceToScaledSpaceMultiplier) * ${$}px)`}, ${`calc((var(--graphEditorVerticalSpace) - var(--graphEditorVerticalSpace) * ${W}) * 1px)`}) scale(${`calc(var(--unitSpaceToScaledSpaceMultiplier) * ${G})`}, ${`calc(var(--graphEditorVerticalSpace) * ${-1*oe})`})`}var Curve_default=$=>{const{index:W,trackData:G}=$,oe=G.keyframes[W],ae=G.keyframes[W+1];oe.handles[2],oe.handles[3],ae.handles[0],ae.handles[1];const ie=ae.position-oe.position,[se,le]=useRefAndState(null),[ue]=function useConnectorContextMenu($,W){const{index:G,trackData:oe}=W,ae=oe.keyframes[G],ie=oe.keyframes[G+1];return useContextMenu($,{items:()=>[{label:"Delete",callback:()=>{getStudio().transaction((({stateEditors:$})=>{const{deleteKeyframes:G}=$.coreByProject.historic.sheetsById.sequence;G(__spreadProps(__spreadValues({},W.sheetObject.address),{trackId:W.trackId,keyframeIds:[ae.id,ie.id]}))}))}}]})}(le,$),de=$.extremumSpace.fromValueSpace(oe.value),pe=$.extremumSpace.fromValueSpace(ae.value)-de,he=transformBox(oe.position,de,ie,pe),ge=`M 0 0 C ${oe.handles[2]} ${oe.handles[3]} ${ae.handles[0]} ${ae.handles[1]} 1 1`;return Kv.default.createElement(Kv.default.Fragment,null,Kv.default.createElement(Wv,{ref:se,d:ge,style:{transform:he}}),ue)};var Gv=__toModule(W),Xv=__toModule(vt.exports),Yv=__toModule(mu),Jv=Yv.default.circle`
  stroke-width: 1px;
  vector-effect: non-scaling-stroke;
  fill: var(--main-color);
  r: 2px;
  pointer-events: none;
`,Qv=Yv.default.circle`
  stroke-width: 6px;
  vector-effect: non-scaling-stroke;
  r: 6px;
  fill: transparent;
  cursor: move;
  ${kl};
  &:hover {
  }
  &:hover + ${Jv} {
    r: 6px;
  }
`,Zv=Yv.default.path`
  stroke-width: 1;
  stroke: var(--main-color);
  /* stroke: gray; */
  fill: none;
  vector-effect: non-scaling-stroke;
`,CurveHandle_default=$=>{const[W,G]=useRefAndState(null),{index:oe,trackData:ae}=$,ie=ae.keyframes[oe],se=ae.keyframes[oe+1],[le]=function useOurContextMenu($,W){return useContextMenu($,{items:()=>[{label:"Delete",callback:()=>{getStudio().transaction((({stateEditors:$})=>{$.coreByProject.historic.sheetsById.sequence.deleteKeyframes(__spreadProps(__spreadValues({},W.sheetObject.address),{keyframeIds:[W.keyframe.id],trackId:W.trackId}))}))}}]})}(G,$);!function useOurDrags($,W){const G=(0,Xv.useRef)(W);G.current=W;const oe=(0,Xv.useMemo)((()=>{let $,W,oe,ae,ie;return{lockCursorTo:"move",onDragStart(){oe=G.current,$=(0,Gv.val)(oe.layoutP.scaledSpace.toUnitSpace),W=(0,Gv.val)(oe.layoutP.graphEditorVerticalSpace.toExtremumSpace),ie=oe.extremumSpace.lock()},onDrag(G,ie){ae&&(ae.discard(),ae=void 0);const{index:se,trackData:le}=oe,ue=le.keyframes[se],de=le.keyframes[se+1];let pe=$(G)/(de.position-ue.position);const he=W(-ie),ge=oe.extremumSpace.deltaToValueSpace(he)/(de.value-ue.value);if("left"===oe.which){const $=Uo(ue.handles[2]+pe,0,1),W=ue.handles[3]+ge;ae=getStudio().tempTransaction((({stateEditors:G})=>{G.coreByProject.historic.sheetsById.sequence.replaceKeyframes(__spreadProps(__spreadValues({},oe.sheetObject.address),{snappingFunction:(0,Gv.val)(oe.layoutP.sheet).getSequence().closestGridPosition,trackId:oe.trackId,keyframes:[__spreadProps(__spreadValues({},ue),{handles:[ue.handles[0],ue.handles[1],$,W]})]}))}))}else{const $=Uo(de.handles[0]+pe,0,1),W=de.handles[1]+ge;ae=getStudio().tempTransaction((({stateEditors:G})=>{G.coreByProject.historic.sheetsById.sequence.replaceKeyframes(__spreadProps(__spreadValues({},oe.sheetObject.address),{trackId:oe.trackId,snappingFunction:(0,Gv.val)(oe.layoutP.sheet).getSequence().closestGridPosition,keyframes:[__spreadProps(__spreadValues({},de),{handles:[$,W,de.handles[2],de.handles[3]]})]}))}))}},onDragEnd($){if(ie){const $=ie;ie=void 0,$()}$?ae&&ae.commit():ae&&ae.discard(),ae=void 0}}}),[]);useDrag($,oe)}(G,$);const ue="left"===$.which?ie.handles[2]:se.handles[0],de=ie.position+(se.position-ie.position)*ue,pe="left"===$.which?ie.handles[3]:se.handles[1],he=ie.value+(se.value-ie.value)*pe,ge=$.extremumSpace.fromValueSpace(he),ve=ge-$.extremumSpace.fromValueSpace("left"===$.which?ie.value:se.value),we=transformBox("left"===$.which?ie.position:se.position,$.extremumSpace.fromValueSpace("left"===$.which?ie.value:se.value),de-("left"===$.which?ie.position:se.position),ve);return Xv.default.createElement("g",null,Xv.default.createElement(Qv,{ref:W,style:{cx:`calc(var(--unitSpaceToScaledSpaceMultiplier) * ${de} * 1px)`,cy:`calc((var(--graphEditorVerticalSpace) - var(--graphEditorVerticalSpace) * ${ge}) * 1px)`}}),Xv.default.createElement(Jv,{style:{cx:`calc(var(--unitSpaceToScaledSpaceMultiplier) * ${de} * 1px)`,cy:`calc((var(--graphEditorVerticalSpace) - var(--graphEditorVerticalSpace) * ${ge}) * 1px)`}}),Xv.default.createElement(Zv,{d:"M 0 0 L 1 1",style:{transform:we}}),le)};var ey=__toModule(W),ty=__toModule(vt.exports),ry=__toModule(mu),ny=ry.default.circle`
  fill: var(--main-color);
  stroke-width: 1px;
  vector-effect: non-scaling-stroke;

  r: 2px;
`,oy=ry.default.circle`
  stroke-width: 6px;
  vector-effect: non-scaling-stroke;
  r: 6px;
  fill: transparent;
  ${kl};

  &:hover + ${ny} {
    r: 6px;
  }

  #pointer-root.normal & {
    cursor: move;
  }

  #pointer-root.draggingPositionInSequenceEditor & {
    pointer-events: auto;
  }

  &.beingDragged {
    pointer-events: none !important;
  }
`,Dot_default2=$=>{const[W,G]=useRefAndState(null),{index:oe,trackData:ae}=$,ie=ae.keyframes[oe];ae.keyframes[oe+1];const[se]=function useKeyframeContextMenu2($,W){return useContextMenu($,{items:()=>[{label:"Delete",callback:()=>{getStudio().transaction((({stateEditors:$})=>{$.coreByProject.historic.sheetsById.sequence.deleteKeyframes(__spreadProps(__spreadValues({},W.sheetObject.address),{keyframeIds:[W.keyframe.id],trackId:W.trackId}))}))}}]})}(G,$),le=function useDragKeyframe3($,W){const[G,oe]=(0,ty.useState)(!1);useLockFrameStampPosition(G,W.keyframe.position);const ae=(0,ty.useRef)(W);ae.current=W;const ie=(0,ty.useMemo)((()=>{let $,W,G,ie,se,le=!1;return{lockCursorTo:"move",onDragStart(G){oe(!0),le=!!G.altKey,W=ae.current,$=(0,ey.val)(W.layoutP.scaledSpace.toUnitSpace),ie=(0,ey.val)(W.layoutP.graphEditorVerticalSpace.toExtremumSpace),se=W.extremumSpace.lock()},onDrag(oe,ae){const se=W.trackData.keyframes[W.index],ue=$(oe),de=ie(-ae),pe=W.extremumSpace.deltaToValueSpace(de),he=[],ge=__spreadProps(__spreadValues({},se),{position:se.position+ue,value:se.value+pe,handles:[...se.handles]});if(he.push(ge),le){const $=W.trackData.keyframes[W.index-1];if($&&Math.abs(se.value-$.value)>0){const W=__spreadProps(__spreadValues({},$),{handles:[...$.handles]});he.push(W),W.handles[3]=function preserveRightHandle($,W,G,oe,ae){return(oe-W)*$/(ae-G)}($.handles[3],$.value,$.value,se.value,ge.value)}const G=W.trackData.keyframes[W.index+1];if(G&&Math.abs(se.value-G.value)>0){const $=__spreadProps(__spreadValues({},G),{handles:[...G.handles]});he.push($),$.handles[1]=function preserveLeftHandle($,W,G,oe,ae){return((W-oe)*$+oe-W+G-ae)/(G-ae)}($.handles[1],$.value,$.value,se.value,ge.value)}}null==G||G.discard(),G=getStudio().tempTransaction((({stateEditors:$})=>{$.coreByProject.historic.sheetsById.sequence.replaceKeyframes(__spreadProps(__spreadValues({},W.sheetObject.address),{trackId:W.trackId,keyframes:he,snappingFunction:(0,ey.val)(W.layoutP.sheet).getSequence().closestGridPosition}))}))},onDragEnd($){if(oe(!1),se){const $=se;se=void 0,$()}$?null==G||G.commit():null==G||G.discard(),G=void 0}}}),[]);return useDrag($,ie),useCursorLock(G,"draggingPositionInSequenceEditor","move"),G}(G,$),ue=$.extremumSpace.fromValueSpace(ie.value);return ty.default.createElement(ty.default.Fragment,null,ty.default.createElement(oy,__spreadProps(__spreadValues({ref:W,style:{cx:`calc(var(--unitSpaceToScaledSpaceMultiplier) * ${ie.position} * 1px)`,cy:`calc((var(--graphEditorVerticalSpace) - var(--graphEditorVerticalSpace) * ${ue}) * 1px)`}},{[xv]:ie.position.toFixed(3)}),{"data-pos":ie.position.toFixed(3),className:le?"beingDragged":""})),ty.default.createElement(ny,{style:{cx:`calc(var(--unitSpaceToScaledSpaceMultiplier) * ${ie.position} * 1px)`,cy:`calc((var(--graphEditorVerticalSpace) - var(--graphEditorVerticalSpace) * ${ue}) * 1px)`}}),se)};var ay=Uv.default.g`
  /* position: absolute; */
`,iy=qv.default.createElement(qv.default.Fragment,null),KeyframeEditor_default2=$=>{const{index:W,trackData:G}=$,oe=G.keyframes[W],ae=G.keyframes[W+1],ie=oe.connectedRight&&!!ae&&ae.value-oe.value!=0;return qv.default.createElement(ay,null,ie?qv.default.createElement(qv.default.Fragment,null,qv.default.createElement(Curve_default,__spreadValues({},$)),qv.default.createElement(CurveHandle_default,__spreadProps(__spreadValues({},$),{which:"left"})),qv.default.createElement(CurveHandle_default,__spreadProps(__spreadValues({},$),{which:"right"}))):iy,qv.default.createElement(Dot_default2,__spreadValues({},$)))};Vv.default.div``;var sy=Hv.default.memo((({layoutP:$,trackData:W,sheetObject:G,trackId:oe,color:ae})=>{const[ie,se]=(0,Hv.useState)(!1),le=(0,Hv.useMemo)((()=>{const $=new Set;return function lockExtremums2(){const W=0===$.size;function unlock(){const W=$.size>0;$.delete(unlock),W&&0===$.size&&se(!1)}return $.add(unlock),W&&se(!0),unlock}}),[]),ue=(0,Hv.useMemo)((()=>{const $=function calculateExtremums($){let W=1/0,G=-1/0;function check($){W=Math.min($,W),G=Math.max($,G)}return $.forEach(((W,G)=>{if(check(W.value),!W.connectedRight)return;const oe=$[G+1];if(!oe)return;const ae=oe.value-W.value;check(W.value+W.handles[3]*ae),check(W.value+oe.handles[1]*ae)})),[W,G]}(W.keyframes),deltaToValueSpace=W=>W*($[1]-$[0]);return{fromValueSpace:W=>(W-$[0])/($[1]-$[0]),toValueSpace:W=>$[0]+deltaToValueSpace(W),deltaToValueSpace:deltaToValueSpace,lock:le}}),[W.keyframes]),de=(0,Hv.useRef)(void 0);ie||(de.current=ue);const pe=W.keyframes.map(((ie,se)=>Hv.default.createElement(KeyframeEditor_default2,{keyframe:ie,index:se,trackData:W,layoutP:$,sheetObject:G,trackId:oe,key:"keyframe-"+ie.id,extremumSpace:de.current,color:ae})));return Hv.default.createElement("g",{style:{"--main-color":vy[ae].iconColor}},pe)})),ly=sy;Lv.default.div``;var PrimitivePropGraph_default=$=>usePrism((()=>{const{sheetObject:W,trackId:G,pathToProp:oe}=$,ae=(0,Fv.val)(getStudio().atomP.historic.coreByProject[W.address.projectId].sheetsById[W.address.sheetId].sequence.tracksByObject[W.address.objectKey].trackData[G]);return"BasicKeyframedTrack"!==(null==ae?void 0:ae.type)?(console.error(`trackData type ${null==ae?void 0:ae.type} is not yet supported on the graph editor`),Nv.default.createElement(Nv.default.Fragment,null)):Nv.default.createElement(ly,__spreadProps(__spreadValues({},$),{trackData:ae}))}),[$.trackId,$.layoutP]),uy=__toModule(W),cy=__toModule(vt.exports),dy=__toModule(mu),fy=So(($=>{const W=[];for(let G=1;G<=$;G++)$%G==0&&W.push(G);return W}));function createGrid({clippedSpaceRange:$,clippedSpaceWidth:W,fps:G,gapWidth:oe=120},ae){const ie=1/G,se=W/(G*($.end-$.start)),le=Math.floor(oe/se),ue=(le<G?fy(G).find(($=>$>=le)):G*Math.floor(le/G))*ie,de=Math.floor($.start/ue),pe=Math.ceil($.end/ue);for(let $=de;$<=pe;$++){const W=$*ue;ae(W,W%1==0)}}var py=new(__toModule(W).Ticker),hy=py,onAnimationFrame=$=>{py.tick($),window.requestAnimationFrame(onAnimationFrame)};window.requestAnimationFrame(onAnimationFrame);var my=dy.default.div`
  position: absolute;
  top: 0;
  left: 0;
  height: 100%;
  pointer-events: none;
`,gy=dy.default.canvas`
  position: relative;
  left: 0;
`,getRatio=$=>(window.devicePixelRatio||1)/($=>{const W=$;return W.webkitBackingStorePixelRatio||W.mozBackingStorePixelRatio||W.msBackingStorePixelRatio||W.oBackingStorePixelRatio||W.backingStorePixelRatio||1})($),FrameGrid_default=({layoutP:$,width:W,height:G})=>{const oe=(0,cy.useRef)(null),[ae,ie]=(0,cy.useState)(null),{ctx:se,ratio:le}=(0,cy.useMemo)((()=>{if(!ae)return{};const $=ae.getContext("2d");return{ctx:$,ratio:getRatio($)}}),[ae]);return(0,cy.useLayoutEffect)((()=>{if(!se)return;ae.width=W*le,ae.height=G*le;const oe=(0,uy.prism)((()=>{const W=(0,uy.val)($.sheet).getSequence();return{ctx:se,clippedSpaceRange:(0,uy.val)($.clippedSpace.range),clippedSpaceWidth:(0,uy.val)($.clippedSpace.width),unitSpaceToClippedSpace:(0,uy.val)($.clippedSpace.fromUnitSpace),height:G,leftPadding:(0,uy.val)($.scaledSpace.leftPadding),fps:W.subUnitsPerUnit,snapToGrid:$=>W.closestGridPosition($)}})).tapImmediate(hy,($=>{se.save(),se.scale(le,le),function drawGrid($){const{clippedSpaceWidth:W,height:G,ctx:oe,unitSpaceToClippedSpace:ae,snapToGrid:ie}=$;oe.clearRect(0,0,W,G),createGrid($,(($,W)=>{const se=ie($),le=Math.floor(ae(se));oe.strokeStyle=W?"rgba(225, 225, 225, 0.04)":"rgba(255, 255, 255, 0.01)",oe.beginPath(),oe.moveTo(le,0),oe.lineTo(le,G),oe.stroke(),oe.closePath()}))}($),se.restore()}));return()=>{oe()}}),[se,W,G,$]),cy.default.createElement(my,{ref:oe,style:{width:W+"px"}},cy.default.createElement(gy,{ref:ie,style:{width:W+"px",height:G+"px"}}))};var vy={1:{iconColor:"#b98b08"},2:{iconColor:"#70a904"},3:{iconColor:"#2e928a"},4:{iconColor:"#a943bb"},5:{iconColor:"#b90808"},6:{iconColor:"#b4bf0e"}},yy=Hm.default.div`
  position: absolute;
  right: 0;
  bottom: 0;
  background: ${Sl(.03,"#1a1c1e")};
`,by=Hm.default.svg`
  position: absolute;
  top: 0;
  left: 0;
  margin: 0;
  pointer-events: none;
`,GraphEditor_default=({layoutP:$})=>usePrism((()=>{const W=(0,Nm.val)($.sheet),G=(0,Nm.val)(getStudio().atomP.historic.projects.stateByProjectId[W.address.projectId].stateBySheetId[W.address.sheetId].sequenceEditor.selectedPropsByObject),oe=(0,Nm.val)($.graphEditorDims.height),ae=(0,Nm.val)($.scaledSpace.fromUnitSpace)(1),ie=[];if(G)for(const[oe,ae]of Object.entries(G)){const G=W.getObject(oe);if(!G)continue;const le=(0,Nm.val)(G.template.getMapOfValidSequenceTracks_forStudio());for(const[W,ue]of Object.entries(ae)){const ae=(se=W,JSON.parse(se)),de=getDeep(le,ae);de&&ie.push(Lm.default.createElement(PrimitivePropGraph_default,{key:`graph-${oe}-${W}`,sheetObject:G,pathToProp:ae,layoutP:$,trackId:de,color:ue}))}}var se;const le=(0,Nm.val)($.rightDims.width);return Lm.default.createElement(yy,{style:{width:le+"px",height:oe+"px","--unitSpaceToScaledSpaceMultiplier":ae,"--graphEditorVerticalSpace":`${(0,Nm.val)($.graphEditorVerticalSpace.space)}`}},Lm.default.createElement(FrameGrid_default,{layoutP:$,width:le,height:oe}),Lm.default.createElement(_g,{layoutP:$,height:oe},Lm.default.createElement(by,{width:Rv,height:oe,viewBox:`0 0 1000000 ${oe}`},Lm.default.createElement("g",{style:{transform:`translate(0, ${(0,Nm.val)($.graphEditorDims.padding.top)}px)`}},ie))))}),[$]),wy={color:"#9a9a9a"},Sy=(0,Fm.default)(Om)``,xy=(0,Fm.default)(Im)`
  display: flex;
  color: ${wy.color};
  padding-right: 12px;
  align-items: center;
  justify-content: flex-end;
  box-sizing: border-box;
`,ky=Fm.default.button`
  background: none;
  border: none;
  outline: none;
  display: flex;
  box-sizing: border-box;
  font-size: 14px;
  align-items: center;
  height: 100%;
  margin-left: 12px;
  color: ${$=>$.isSelected?vy[$.graphEditorColor].iconColor:Bd};

  &:hover {
    color: white;
  }
`,GraphIcon=()=>Bm.default.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",width:"10",height:"12",viewBox:"0 0 640 512"},Bm.default.createElement("g",{transform:"translate(0 100)"},Bm.default.createElement("path",{fill:"currentColor",d:"M368 32h-96c-17.67 0-32 14.33-32 32v96c0 17.67 14.33 32 32 32h96c17.67 0 32-14.33 32-32V64c0-17.67-14.33-32-32-32zM208 88h-84.75C113.75 64.56 90.84 48 64 48 28.66 48 0 76.65 0 112s28.66 64 64 64c26.84 0 49.75-16.56 59.25-40h79.73c-55.37 32.52-95.86 87.32-109.54 152h49.4c11.3-41.61 36.77-77.21 71.04-101.56-3.7-8.08-5.88-16.99-5.88-26.44V88zm-48 232H64c-17.67 0-32 14.33-32 32v96c0 17.67 14.33 32 32 32h96c17.67 0 32-14.33 32-32v-96c0-17.67-14.33-32-32-32zM576 48c-26.84 0-49.75 16.56-59.25 40H432v72c0 9.45-2.19 18.36-5.88 26.44 34.27 24.35 59.74 59.95 71.04 101.56h49.4c-13.68-64.68-54.17-119.48-109.54-152h79.73c9.5 23.44 32.41 40 59.25 40 35.34 0 64-28.65 64-64s-28.66-64-64-64zm0 272h-96c-17.67 0-32 14.33-32 32v96c0 17.67 14.33 32 32 32h96c17.67 0 32-14.33 32-32v-96c0-17.67-14.33-32-32-32z"}))),_y=Fm.default.span`
  margin-right: 4px;
  ${_f};
`,PrimitivePropRow_default2=({leaf:$})=>{const W=function pointerDeep($,W){let G=$;for(const $ of W)G=G[$];return G}($.sheetObject.propsP,$.pathToProp),G=$.sheetObject,{controlIndicators:oe}=useEditingToolsForPrimitiveProp(W,G,$.propConf),ae=usePrism((()=>{const W=$.sheetObject.address,G=encodePathToProp($.pathToProp);return(0,Rm.val)(getStudio().atomP.historic.projects.stateByProjectId[W.projectId].stateBySheetId[W.sheetId].sequenceEditor.selectedPropsByObject[W.objectKey][G])}),[$]),ie=(0,Bm.useRef)(!1),se="string"==typeof ae;ie.current=se;const le=(0,Bm.useCallback)((()=>{const W=$.sheetObject.address;getStudio().transaction((({stateEditors:G})=>{ie.current?G.studio.historic.projects.stateByProjectId.stateBySheetId.sequenceEditor.removePropFromGraphEditor(__spreadProps(__spreadValues({},W),{pathToProp:$.pathToProp})):(G.studio.historic.projects.stateByProjectId.stateBySheetId.sequenceEditor.addPropToGraphEditor(__spreadProps(__spreadValues({},W),{pathToProp:$.pathToProp})),G.studio.historic.panels.sequenceEditor.graphEditor.setIsOpen({isOpen:!0}))}))}),[$]),ue=$.pathToProp[$.pathToProp.length-1];return Bm.default.createElement(Sy,{depth:$.depth},Bm.default.createElement(xy,{isEven:$.n%2==0,style:{height:$.nodeHeight+"px"},isSelected:!0===se},Bm.default.createElement(_y,null,ue),oe,Bm.default.createElement(ky,{onClick:le,isSelected:!0===se,graphEditorColor:null!=ae?ae:"1"},Bm.default.createElement(GraphIcon,null))))},decideRowByPropType2=$=>"propWithChildren"===$.type?zm.default.createElement(PropWithChildrenRow2,{leaf:$,key:"prop"+$.pathToProp[$.pathToProp.length-1]}):zm.default.createElement(PrimitivePropRow_default2,{leaf:$,key:"prop"+$.pathToProp[$.pathToProp.length-1]});Mm.default.div``;var PropWithChildrenRow2=({leaf:$})=>usePrism((()=>zm.default.createElement(AnyCompositeRow_default,{leaf:$,label:$.pathToProp[$.pathToProp.length-1]},$.children.map(($=>decideRowByPropType2($))))),[$]);Em.default.div``;var SheetObjectRow_default2=({leaf:$})=>usePrism((()=>Pm.default.createElement(AnyCompositeRow_default,{leaf:$,label:$.sheetObject.address.objectKey},$.children.map(($=>decideRowByPropType2($))))),[$]);_m.default.div``;var SheetRow_default2=({leaf:$})=>usePrism((()=>km.default.createElement(km.default.Fragment,null,$.children.map(($=>km.default.createElement(SheetObjectRow_default2,{key:"sheetObject-"+$.sheetObject.address.objectKey,leaf:$}))))),[$]),Py=xm.default.div`
  position: absolute;
  left: 0;
  overflow-x: visible;
`,Ey=xm.default.ul`
  margin: 0;
  padding: 0;
  list-style: none;
`,Left_default=({layoutP:$})=>usePrism((()=>{const W=(0,wm.val)($.tree),G=(0,wm.val)($.leftDims.width);return Sm.default.createElement(Py,{style:{width:G+"px",top:W.top+"px"}},Sm.default.createElement(Ey,null,Sm.default.createElement(SheetRow_default2,{leaf:W})))}),[$]),jy=__toModule(vt.exports),Cy=__toModule(mu).default.div`
  position: absolute;
  top: 0;
  right: 0;
  bottom: 0;
  z-index: ${()=>xw.rightBackground};
  overflow: hidden;
  background: ${Sl(.01,bl(.03,_l.panel.bg))};
  pointer-events: none;
`,DopeSheetBackground_default=({layoutP:$})=>{const W=useVal($.rightDims.width),G=useVal($.panelDims.height);return jy.default.createElement(Cy,{style:{width:W+"px"}},jy.default.createElement(FrameGrid_default,{width:W,height:G,layoutP:$}))},Oy=bm.default.div`
  position: absolute;
  left: 0;
  right: 0;
`,DopeSheet_default=({layoutP:$})=>{const W=useVal($.dopeSheetDims.height);return ym.default.createElement(Oy,{style:{height:W+"px"}},ym.default.createElement(DopeSheetBackground_default,{layoutP:$}),ym.default.createElement(VerticalScrollContainer_default,null,ym.default.createElement(Left_default,{layoutP:$}),ym.default.createElement(Right_default,{layoutP:$})))},Iy=__toModule(W);var Ty=__toModule(W),Dy=__toModule(W),Ay=28,calculateSequenceEditorTree=$=>{Dy.prism.ensurePrism();let W=20,G=0;const oe={type:"sheet",sheet:$,children:[],top:W,depth:-1,n:G,nodeHeight:0,heightIncludingChildren:-1};W+=oe.nodeHeight,G+=1;for(const[W,G]of Object.entries((0,Dy.val)($.objectsP)))addObject(G,oe.children,oe.depth+1);function addObject($,oe,ae){const ie=(0,Dy.val)($.template.getMapOfValidSequenceTracks_forStudio());if(0===Object.keys(ie).length)return;const se={type:"sheetObject",top:W,children:[],depth:ae,n:G,sheetObject:$,nodeHeight:Ay,heightIncludingChildren:-1};oe.push(se),G+=1,W+=Ay,addProps($,ie,[],$.template.config,se.children,ae+1),se.heightIncludingChildren=W-se.top}function addProps($,W,G,oe,ae,ie){for(const[se,le]of Object.entries(W)){const W=oe.props[se];isPropConfigComposite(W)||addProp($,le,[...G,se],W,ae,ie)}for(const[se,le]of Object.entries(W)){const W=oe.props[se];isPropConfigComposite(W)&&addProp($,le,[...G,se],W,ae,ie)}}function addProp($,oe,ae,ie,se,le){if("compound"===ie.type){!function addProp_compound($,oe,ae,ie,se,le){const ue={type:"propWithChildren",pathToProp:ae,sheetObject:$,top:W,children:[],nodeHeight:Ay,heightIncludingChildren:-1,depth:le,trackMapping:oe,n:G};W+=Ay,G+=1,se.push(ue),addProps($,oe,ae,ie,ue.children,le+1),ue.heightIncludingChildren=W-ue.top}($,oe,ae,ie,se,le)}else if("enum"===ie.type)$t.warn("Prop type enum is not yet supported in the sequence editor");else{!function addProp_primitive($,oe,ae,ie,se,le){const ue={type:"primitiveProp",propConf:ie,depth:le,sheetObject:$,pathToProp:ae,top:W,nodeHeight:Ay,heightIncludingChildren:Ay,trackId:oe,n:G};se.push(ue),G+=1,W+=Ay}($,oe,ae,ie,se,le)}}return oe.heightIncludingChildren=W-oe.top,oe},$y={start:0,end:10};function sequenceEditorPanelLayout($,W){const G=getStudio(),oe=G.atomP.ahistoric.projects.stateByProjectId[$.address.projectId].stateBySheetId[$.address.sheetId],ae=G.atomP.historic.projects.stateByProjectId[$.address.projectId].stateBySheetId[$.address.sheetId];return(0,Ty.prism)((()=>{var ie;const se=function subPrism($,W,G){return Iy.prism.memo($,(()=>(0,Iy.prism)(W)),G).getValue()}("tree",(()=>calculateSequenceEditorTree($)),[]),le=(0,Ty.val)(W),ue=(0,Ty.val)(G.atomP.historic.panels.sequenceEditor.graphEditor),de=(0,Ty.val)(ae.sequenceEditor.selectedPropsByObject),pe=!!de&&Object.keys(de).length>0,{leftDims:he,rightDims:ge,graphEditorDims:ve,dopeSheetDims:we,horizontalScrollbarDims:Se}=Ty.prism.memo("leftDims",(()=>{var $;const W={width:Math.floor(.2*le.width),height:le.height,screenX:le.screenX,screenY:le.screenY},G={width:le.width-W.width,height:le.height,screenX:le.screenX+W.width,screenY:le.screenY},oe=pe&&!0===(null==ue?void 0:ue.isOpen),ae=Math.floor((oe?Uo(null!=($=null==ue?void 0:ue.height)?$:.5,.1,.7):0)*le.heightWithoutBorder),ie=0+ae,se=le.height-ie,de={width:le.width,height:se,screenX:le.screenX,screenY:le.screenY};return{leftDims:W,rightDims:G,graphEditorDims:{isAvailable:pe,isOpen:oe,width:G.width,height:ae,screenX:le.screenX,screenY:le.screenY+se,padding:{top:20,bottom:20}},dopeSheetDims:de,horizontalScrollbarDims:{bottom:0}}}),[le,ue,pe]),Pe=Ty.prism.memo("graphEditorVerticalSpace",(()=>{const $=ve.height-ve.padding.top-ve.padding.bottom;return{space:$,fromExtremumSpace:W=>W*$,toExtremumSpace:W=>W/$}}),[ve]),[je,Ie]=Ty.prism.state("isSeeking",!1),De={isSeeking:je,setIsSeeking:Ie},$e=null!=(ie=(0,Ty.val)(oe.sequence.clippedSpaceRange))?ie:$y,Le=Ty.prism.memo("scaledSpace",(()=>{const $=$e.end-$e.start,W=ge.width,G=$/W,oe=W/$;return{fromUnitSpace:$=>$*oe,toUnitSpace:$=>$*G,leftPadding:10}}),[$e,ge.width]),Ke=Ty.prism.memo("setClippedSpaceRange",(()=>function setClippedSpaceRange2(W){G.transaction((({stateEditors:G})=>{const oe=__spreadValues({},W);if(oe.end<=oe.start&&(oe.end=oe.start+1),oe.start<0){const $=oe.end-oe.start;oe.start=0,oe.end=$}G.studio.ahistoric.projects.stateByProjectId.stateBySheetId.sequence.clippedSpaceRange.set(__spreadProps(__spreadValues({},$.address),{range:oe}))}))}),[]),Ge=Ty.prism.memo("clippedSpace",(()=>({range:$e,width:ge.width,fromUnitSpace:$=>Le.fromUnitSpace($-$e.start)+Le.leftPadding,toUnitSpace:$=>Le.toUnitSpace($-Le.leftPadding)+$e.start,setRange:Ke})),[$e,ge.width,Le,Ke]),Xe=Ty.prism.memo("selection.current",(()=>new Ty.Atom({})),[]);return valToAtom("finalAtom",{sheet:$,tree:se,panelDims:le,leftDims:he,rightDims:ge,dopeSheetDims:we,horizontalScrollbarDims:Se,seeker:De,unitSpace:{},scaledSpace:Le,clippedSpace:Ge,graphEditorDims:ve,graphEditorVerticalSpace:Pe,selectionAtom:Xe}).pointer}))}var zy=__toModule(W),My=__toModule(vt.exports),Ry=__toModule(mu),By=__toModule(W),Fy=__toModule(vt.exports),Ny=__toModule(mu),Ly=__toModule(vt.exports),Hy=__toModule(mu),Vy=__toModule(W),qy=__toModule(vt.exports),Uy=__toModule(mu),Ky=Uy.default.div`
  position: absolute;
  top: 0;
  left: 0;
  height: 100%;
  pointer-events: none;
`,Wy={fullUnitStampColor:"#6a6a6a",stampFontSize:"10px",get subUnitStampColor(){return bl(.2,Wy.fullUnitStampColor)}},Gy=Uy.default.div`
  position: absolute;
  top: 0;
  height: 100%;
  left: 0;
  overflow: hidden;
  /* z-index: 2; */
  will-change: transform;
  pointer-events: none;
`,Xy=Uy.default.div`
  position: absolute;
  top: 0;
  left: 0;

  & > span {
    position: absolute;
    display: block;
    top: 9px;
    left: -10px;
    color: ${Wy.fullUnitStampColor};
    text-align: center;
    font-size: ${Wy.stampFontSize};
    width: 20px;

    &.full-unit {
      color: ${Wy.fullUnitStampColor};
    }

    &.sub-unit {
      color: ${Wy.subUnitStampColor};
    }
  }

  pointer-events: none;
`,StampsGrid_default=({layoutP:$,width:W})=>{const G=(0,qy.useRef)(null),[oe,ae]=(0,qy.useState)(null);return(0,qy.useLayoutEffect)((()=>{if(oe)return(0,Vy.prism)((()=>{const W=(0,Vy.val)($.sheet).getSequence();return{fullSecondStampsContainer:oe,clippedSpaceRange:(0,Vy.val)($.clippedSpace.range),clippedSpaceWidth:(0,Vy.val)($.clippedSpace.width),unitSpaceToClippedSpace:(0,Vy.val)($.clippedSpace.fromUnitSpace),leftPadding:(0,Vy.val)($.scaledSpace.leftPadding),fps:W.subUnitsPerUnit,sequencePositionFormatter:W.positionFormatter,snapToGrid:$=>W.closestGridPosition($)}})).tapImmediate(hy,drawStamps)}),[oe,W,$]),qy.default.createElement(Ky,{ref:G,style:{width:W+"px"}},qy.default.createElement(Gy,{style:{width:W+"px"}},qy.default.createElement(Xy,{ref:ae})))};function drawStamps($){const{fullSecondStampsContainer:W,sequencePositionFormatter:G,snapToGrid:oe,unitSpaceToClippedSpace:ae}=$;let ie="";createGrid($,(($,W)=>{const se=oe($),le=ae(se);ie+=W?createStampClass(G.formatFullUnitForGrid(se),le,"full-unit"):createStampClass(G.formatSubUnitForGrid(se),le,"sub-unit")})),W.innerHTML=ie}function createStampClass($,W,G){return`<span class="${G}" style="transform: translate3d(${W.toFixed(1)}px, -50%, 0);">${$}</span>`}var Yy="#1f2120eb",Jy="#1c1e21",Qy=(0,Hy.default)(PanelDragZone_default)`
  position: absolute;
  top: 0;
  left: 0;
  right: 0;
  height: ${20}px;
  box-sizing: border-box;
  background: ${Yy};
  border-bottom: 1px solid ${Jy};
  ${kl};
`,TopStrip_default=({layoutP:$})=>{const W=useVal($.rightDims.width);return Ly.default.createElement(Qy,__spreadValues({},{[xv]:"hide"}),Ly.default.createElement(StampsGrid_default,{layoutP:$,width:W,height:20}))},Zy=__toModule(vt.exports),rb=__toModule(mu),greaterThanZero=$=>isFinite($)&&$>0,nb=rb.default.div`
  display: flex;
  gap: 8px;
  padding: 4px 8px;
  height: 28px;
  align-items: center;
`,ob=rb.default.div`
  ${_f};
  white-space: nowrap;
`,nudge=({deltaX:$})=>.25*$,LengthEditorPopover_default=({layoutP:$,onRequestClose:W})=>{const G=useVal($.sheet),oe=(0,Zy.useMemo)((()=>{let $;return{temporarilySetValue(W){$&&($.discard(),$=void 0),$=getStudio().tempTransaction((({stateEditors:$})=>{$.coreByProject.historic.sheetsById.sequence.setLength(__spreadProps(__spreadValues({},G.address),{length:W}))}))},discardTemporaryValue(){$&&($.discard(),$=void 0)},permenantlySetValue(W){$&&($.discard(),$=void 0),getStudio().transaction((({stateEditors:$})=>{$.coreByProject.historic.sheetsById.sequence.setLength(__spreadProps(__spreadValues({},G.address),{length:W}))}))}}}),[$,G]),ae=(0,Zy.useRef)(null);return(0,Zy.useLayoutEffect)((()=>{ae.current.focus()}),[]),usePrism((()=>{const $=G.getSequence().length;return Zy.default.createElement(nb,null,Zy.default.createElement(ob,null,"Sequence length"),Zy.default.createElement(BasicNumberInput_default,__spreadProps(__spreadValues({value:$},oe),{isValid:greaterThanZero,inputRef:ae,onBlur:W,nudge:nudge})))}),[G,oe,ae])},ub="#0000006c",yb="#000000",Sb=Ny.default.div`
  position: absolute;
  top: 0;
  left: 0;
  width: 4px;
  z-index: ${()=>xw.lengthIndicatorStrip};
  pointer-events: none;

  &:after {
    display: block;
    content: ' ';
    position: absolute;
    /* top: ${20}px; */
    top: 0;
    bottom: 0;
    left: -1px;
    width: 1px;
    background-color: ${ub};
  }

  &:hover:after,
  &.dragging:after {
    background-color: ${yb};
  }
`,kb=Ny.default.div`
  position: absolute;
  top: ${5}px;
  width: 100px;
  left: -50px;
  pointer-events: none;
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  z-index: 1;
`,_b=Ny.default.div`
  margin-top: 8px;
  font-size: 10px;
  white-space: nowrap;
  padding: 2px 8px;
  border-radius: 2px;
  ${kl};
  cursor: ew-resize;
  color: #464646;
  background-color: #0000004d;
  display: none;

  ${Sb}:hover &, ${Sb}.dragging & {
    display: block;
    color: white;
    background-color: ${yb};
  }
`,Pb=Ny.default.div`
  font-size: 10px;
  white-space: nowrap;
  padding: 1px 2px;
  border-radius: 2px;
  ${kl};
  justify-content: center;
  align-items: center;
  cursor: ew-resize;
  color: #5d5d5d;
  background-color: #191919;

  ${Sb}:hover &, ${Sb}.dragging & {
    color: white;
    background-color: ${yb};

    & > svg:first-child {
      margin-right: -1px;
    }
  }

  & > svg:first-child {
    margin-right: -4px;
  }
`,Tb=Ny.default.div`
  position: absolute;
  top: 0;
  left: 0;
  background-color: rgb(23 23 23 / 43%);
  width: ${1e3}px;
  z-index: ${()=>xw.lengthIndicatorCover};
  transform-origin: left top;

  ${Sb}.dragging ~ &, ${Sb}:hover ~ & {
    background-color: rgb(23 23 23 / 60%);
  }
`;var LengthIndicator_default=({layoutP:$})=>{const[W,G]=useRefAndState(null),[oe]=function useDragBulge($,W){const G=(0,Fy.useRef)(W);G.current=W;const[oe,ae]=(0,Fy.useState)(!1);useLockFrameStampPosition(oe,-1);const ie=(0,Fy.useMemo)((()=>{let $,W,oe,ie,se;return{lockCursorTo:"ew-resize",onDragStart(W){ae(!0),oe=G.current,ie=(0,By.val)(G.current.layoutP.sheet),se=ie.getSequence().length,$=(0,By.val)(oe.layoutP.scaledSpace.toUnitSpace)},onDrag(G,oe,ae){const le=$(G);W&&(W.discard(),W=void 0),W=getStudio().tempTransaction((({stateEditors:$})=>{$.coreByProject.historic.sheetsById.sequence.setLength(__spreadProps(__spreadValues({},ie.address),{length:se+le}))}))},onDragEnd($){ae(!1),$?W&&W.commit():W&&W.discard(),W=void 0}}}),[]);return useDrag($,ie),[oe]}(G,{layoutP:$}),[ae,ie,se,le]=usePopover({},(()=>Fy.default.createElement(qc,null,Fy.default.createElement(LengthEditorPopover_default,{layoutP:$,onRequestClose:se}))));return usePrism((()=>{const se=(0,By.val)($.sheet),le=(0,By.val)($.rightDims.height),ue=se.getSequence(),de=ue.length,pe=de;let he,ge,ve=(0,By.val)($.clippedSpace.fromUnitSpace)(pe),we=(0,By.val)($.clippedSpace.width);return ve>we?(ge=0,he=0):(ve<0&&(ve=0),ge=ve,he=(we-ve)/1e3),Fy.default.createElement(Fy.default.Fragment,null,ae,Fy.default.createElement(Sb,{style:{height:le+"px",transform:`translateX(${0===ge?-1e3:ge}px)`},className:(0,By.val)(oe)?"dragging":""},Fy.default.createElement(kb,null,Fy.default.createElement(Pb,__spreadValues({ref:W,onClick:$=>{ie($,G)}},{[xv]:"hide"}),Fy.default.createElement(GoChevronLeft,null),Fy.default.createElement(GoChevronRight,null)),Fy.default.createElement(_b,null,"Sequence length:"," ",ue.positionFormatter.formatBasic(de)))),Fy.default.createElement(Tb,{title:"Length",style:{height:le+"px",transform:`translateX(${ge}px) scale(${he}, 1)`}}))}),[$,W,oe,ae])},Ab=__toModule(W),zb=__toModule(vt.exports),Lb=__toModule(mu),Vb=Lb.default.div`
  position: absolute;
  top: 16px;
  font-size: ${Wy.stampFontSize};
  color: ${Wy.fullUnitStampColor};
  text-align: center;
  transform: translateX(-50%);
  background: ${Yy};
  padding: 1px 8px;
  font-variant-numeric: tabular-nums;
  pointer-events: none;
  z-index: ${()=>xw.currentFrameStamp};
`,qb=Lb.default.div`
  position: absolute;
  top: 5px;
  left: -0px;
  bottom: 0;
  width: 0.5px;
  background: rgba(100, 100, 100, 0.2);
  pointer-events: none;
`,Ub=zb.default.memo((({layoutP:$})=>{const[W,G]=useVal((0,bv.useContext)(wv).currentD),oe=useVal($.clippedSpace.fromUnitSpace),{sequence:ae,formatter:ie,clippedSpaceWidth:se}=usePrism((()=>{const W=(0,Ab.val)($.sheet).getSequence(),G=(0,Ab.val)($.clippedSpace.width);return{sequence:W,formatter:W.positionFormatter,clippedSpaceWidth:G}}),[$]);if(-1==W)return zb.default.createElement(zb.default.Fragment,null);const le=G===Pg.free?ae.closestGridPosition(W):W,ue=oe(le),de=ue>=0&&ue<=se;return zb.default.createElement(zb.default.Fragment,null,zb.default.createElement(Vb,{style:{opacity:de?1:0,transform:`translate3d(calc(${ue}px - 50%), 0, 0)`}},ie.formatForPlayhead(le)),zb.default.createElement(qb,{posType:G,style:{opacity:de?1:0,transform:`translate3d(${ue}px, 0, 0)`}}))})),Kb=__toModule(W),Wb=__toModule(vt.exports),Jb=__toModule(mu),Qb=Jb.default.div`
  --threadHeight: 6px;
  --bg-inactive: #32353b;
  --bg-active: #5b5c5d;
  position: absolute;
  height: 0;
  width: 100%;
  left: 12px;
  /* bottom: 8px; */
  ${kl};
  z-index: ${()=>xw.horizontalScrollbar};
`,ew=Jb.default.div`
  position: relative;
  top: 0;
  left: 0;
  width: 100%;
  height: var(--threadHeight);
`,tw=Jb.default.div`
  position: absolute;
  height: 5px;
  background: var(--bg-inactive);
  cursor: ew-resize;
  z-index: 2;

  &:hover,
  &:active {
    background: var(--bg-active);
  }

  &:after {
    ${position("absolute","-4px")};
    display: block;
    content: ' ';
  }
`,rw=Jb.default.div`
  position: absolute;
  height: 5px;
  width: 7px;
  left: 0;
  z-index: 2;
  top: 0;
  bottom: 0;
  display: block;

  &:hover:before {
    background: var(--bg-active);
  }

  &:before {
    ${position("absolute","0")};
    display: block;
    content: ' ';
    background: var(--bg-inactive);
    border-radius: 0 2px 2px 0;
  }

  &:after {
    ${position("absolute","-4px")};
    display: block;
    content: ' ';
  }
`,nw=(0,Jb.default)(rw)`
  left: calc(-1 * 7px);
  cursor: w-resize;
  &:before {
    transform: scaleX(-1);
  }
`,ow=(0,Jb.default)(rw)`
  cursor: e-resize;
  left: 0px;
`,aw=Jb.default.div`
  display: ${$=>$.active?"block":"none"};
  position: absolute;
  top: -20px;
  left: 4px;
  padding: 0 4px;
  transform: translateX(-50%);
  background: #131d1f;
  border-radius: 4px;
  color: #fff;
  font-size: 10px;
  line-height: 18px;
  text-align: center;

  ${nw}:hover &,
  ${ow}:hover &,
  ${tw}:hover ~ ${nw} &,
  ${tw}:hover ~ ${ow} & {
    display: block;
  }
`,HorizontalScrollbar_default=({layoutP:$})=>{const W=(0,Wb.useCallback)(($=>$.toFixed(2)),[]),G=(0,Wb.useMemo)((()=>(0,Kb.prism)((()=>{const W=(0,Kb.val)($.rightDims.width)-25,G=(0,Kb.val)($.clippedSpace.range),oe=(0,Kb.val)($.sheet).getSequence().length,ae=Math.max(G.end,oe);return{rightWidth:W,clippedSpaceRange:G,sequenceLength:oe,assumedLengthOfSequence:ae,rangeStartX:G.start/ae*W,rangeEndX:G.end/ae*W,bottom:(0,Kb.val)($.horizontalScrollbarDims.bottom)}}))),[$]),{rangeStartX:oe,rangeEndX:ae,clippedSpaceRange:ie,bottom:se}=useVal(G),[le,ue]=(0,Wb.useState)("nothing"),de=(0,Wb.useMemo)((()=>{let W=(0,Kb.val)(G);const deltaXToDeltaPos=$=>$/W.rightWidth*W.assumedLengthOfSequence;return{onDragStart(){W=(0,Kb.val)(G)},onDragEnd(){ue("nothing")},dragRange:G=>{ue("both");const oe=deltaXToDeltaPos(G),ae=Ts(W.clippedSpaceRange,($=>$+oe));(0,Kb.val)($.clippedSpace.setRange)(ae)},dragRangeStart:G=>{ue("start");const oe=deltaXToDeltaPos(G),ae={start:W.clippedSpaceRange.start+oe,end:W.clippedSpaceRange.end};ae.start>ae.end-1&&(ae.start=ae.end-1),ae.start<=0&&(ae.start=0),(0,Kb.val)($.clippedSpace.setRange)(ae)},dragRangeEnd:G=>{ue("end");const oe=deltaXToDeltaPos(G),ae={start:W.clippedSpaceRange.start,end:W.clippedSpaceRange.end+oe};ae.end<ae.start+1&&(ae.end=ae.start+1),ae.end>=W.assumedLengthOfSequence&&(ae.end=W.assumedLengthOfSequence),(0,Kb.val)($.clippedSpace.setRange)(ae)}}}),[$,G]);return Wb.default.createElement(Qb,__spreadValues({style:{bottom:se+8+"px"}},{[xv]:"hide"}),Wb.default.createElement(ew,null,Wb.default.createElement(rp,{onDragStart:de.onDragStart,onDragEnd:de.onDragEnd,onDrag:de.dragRange,lockCursorTo:"ew-resize"},Wb.default.createElement(tw,{style:{width:ae-oe+"px",transform:`translate3d(${oe}px, 0, 0)`}})),Wb.default.createElement(rp,{onDragStart:de.onDragStart,onDrag:de.dragRangeStart,lockCursorTo:"w-resize"},Wb.default.createElement(nw,{style:{transform:`translate3d(${oe}px, 0, 0)`}},Wb.default.createElement(aw,{active:"both"===le||"start"===le},W(ie.start)))),Wb.default.createElement(rp,{onDragStart:de.onDragStart,onDrag:de.dragRangeEnd,lockCursorTo:"e-resize"},Wb.default.createElement(ow,{style:{transform:`translate3d(${ae}px, 0, 0)`}},Wb.default.createElement(aw,{active:"both"===le||"end"===le},W(ie.end))))))},iw=__toModule(vt.exports),sw=__toModule(mu).default.div`
  position: absolute;
  inset: ${$=>-1*$.room}px;
`,RoomToClick_default=$=>iw.default.createElement(sw,{room:$.room}),lw=__toModule(W),uw=__toModule(vt.exports),cw=__toModule(mu),dw=cw.default.div`
  --thumbColor: #00e0ff;
  position: absolute;
  top: 0;
  left: 0;
  width: 5px;
  height: 100%;
  z-index: ${()=>xw.playhead};
  pointer-events: none;

  display: ${$=>$.isVisible?"block":"none"};
`,fw=cw.default.div`
  position: absolute;
  top: 8px;
  width: 0;
  height: calc(100% - 8px);
  border-left: 1px solid #27e0fd;
  z-index: 10;

  #pointer-root.draggingPositionInSequenceEditor &:not(.seeking) {
    pointer-events: auto;

    &:after {
      position: absolute;
      inset: -8px;
      display: block;
      content: ' ';
    }
  }
`,pw=cw.default.div`
  background-color: var(--thumbColor);
  position: absolute;
  width: 5px;
  height: 13px;
  top: -4px;
  left: -2px;
  z-index: 11;
  cursor: ew-resize;
  ${kl};

  #pointer-root.draggingPositionInSequenceEditor &:not(.seeking) {
    pointer-events: auto;
  }

  &:before {
    position: absolute;
    display: block;
    content: ' ';
    left: -2px;
    width: 0;
    height: 0;
    border-bottom: 4px solid #1f2b2b;
    border-left: 2px solid transparent;
  }

  &:after {
    position: absolute;
    display: block;
    content: ' ';
    right: -2px;
    width: 0;
    height: 0;
    border-bottom: 4px solid #1f2b2b;
    border-right: 2px solid transparent;
  }
`,hw=cw.default.div`
  position: absolute;
  left: 1px;
  right: 1px;
  top: 13px;
  border-top: 3px solid var(--thumbColor);
  border-right: 1px solid transparent;
  border-left: 1px solid transparent;
  pointer-events: none;

  &:before {
    position: absolute;
    display: block;
    content: ' ';
    top: -4px;
    left: -2px;
    height: 8px;
    width: 2px;
    background: none;
    border-radius: 0 100% 0 0;
    border-top: 1px solid var(--thumbColor);
    border-right: 1px solid var(--thumbColor);
  }

  &:after {
    position: absolute;
    display: block;
    content: ' ';
    top: -4px;
    right: -2px;
    height: 8px;
    width: 2px;
    background: none;
    border-radius: 100% 0 0 0;
    border-top: 1px solid var(--thumbColor);
    border-left: 1px solid var(--thumbColor);
  }
`,mw=cw.default.div`
  display: none;
  position: absolute;
  top: -20px;
  left: 4px;
  padding: 0 2px;
  transform: translateX(-50%);
  background: #1a1a1a;
  border-radius: 4px;
  color: #fff;
  font-size: 10px;
  line-height: 18px;
  text-align: center;
  ${pw}:hover &, ${dw}.seeking & {
    display: block;
  }
`,Playhead_default=({layoutP:$})=>{const[W,G]=useRefAndState(null),oe=(0,uw.useMemo)((()=>{const W=(0,lw.val)($.seeker.setIsSeeking);let oe,ae,ie=0;return{onDragStart(){oe=(0,lw.val)($.sheet).getSequence(),ie=oe.position,ae=(0,lw.val)($.scaledSpace.toUnitSpace),W(!0)},onDrag($,W,se){const le=ae($);let ue=Uo(ie+le,0,oe.length);const de=se.composedPath().find(($=>$ instanceof Element&&$!==G&&$.hasAttribute("data-pos")));if(de){const $=parseFloat(de.getAttribute("data-pos"));isFinite($)&&(ue=$)}oe.position=ue},onDragEnd(){W(!1)},lockCursorTo:"ew-resize"}}),[]);return useDrag(G,oe),useLockFrameStampPosition(useVal($.seeker.isSeeking),-1),usePrism((()=>{const G=(0,lw.val)($.seeker.isSeeking),oe=(0,lw.val)($.sheet).getSequence(),ae=oe.positionDerivation.getValue(),ie=(0,lw.val)($.clippedSpace.fromUnitSpace)(ae),se=ie>=0&&ie<=(0,lw.val)($.clippedSpace.width);return uw.default.createElement(dw,__spreadValues({isVisible:se,style:{transform:`translate3d(${ie}px, 0, 0)`},className:G?"seeking":""},{[xv]:"hide"}),uw.default.createElement(pw,{ref:W,"data-pos":ae.toFixed(3)},uw.default.createElement(RoomToClick_default,{room:8}),uw.default.createElement(hw,null),uw.default.createElement(mw,null,oe.positionFormatter.formatForPlayhead(oe.closestGridPosition(ae)))),uw.default.createElement(fw,{"data-pos":ae.toFixed(3),className:G?"seeking":""}))}),[$])},gw=Ry.default.div`
  position: absolute;
  top: 0;
  right: 0;
  bottom: 0;
  z-index: ${()=>xw.rightOverlay};
  overflow: visible;
  pointer-events: none;
`,RightOverlay_default=({layoutP:$})=>usePrism((()=>{const W=(0,zy.val)($.rightDims.width);return My.default.createElement(gw,{style:{width:W+"px"}},My.default.createElement(Playhead_default,{layoutP:$}),My.default.createElement(HorizontalScrollbar_default,{layoutP:$}),My.default.createElement(Ub,{layoutP:$}),My.default.createElement(TopStrip_default,{layoutP:$}),My.default.createElement(LengthIndicator_default,{layoutP:$}))}),[$]),vw=__toModule(W),yw=__toModule(vt.exports),bw=__toModule(mu).default.button`
  outline: none;
  background-color: #1c1d21;
  border: 1px solid #191919;
  border-radius: 2px;
  display: flex;
  bottom: 14px;
  right: 8px;
  z-index: 1;
  position: absolute;

  padding: 4px 8px;
  display: flex;
  color: #656d77;
  line-height: 20px;
  font-size: 10px;

  &:hover {
    color: white;
  }

  & > svg {
    transition: transform 0.3s;
    transform: rotateZ(0deg);
  }

  &:hover > svg {
    transform: rotateZ(-20deg);
  }

  &.open > svg {
    transform: rotateZ(-180deg);
  }

  &.open:hover > svg {
    transform: rotateZ(-160deg);
  }
`,GraphEditorToggle_default=({layoutP:$})=>{const W=useVal($.graphEditorDims.isOpen),G=(0,yw.useCallback)((()=>{(0,vw.val)($.sheet);const W=(0,vw.val)($.graphEditorDims.isOpen);getStudio().transaction((({stateEditors:$})=>{$.studio.historic.panels.sequenceEditor.graphEditor.setIsOpen({isOpen:!W})}))}),[$]);return yw.default.createElement(bw,__spreadValues({onClick:G,title:"Toggle graph editor",className:W?"open":""},{[xv]:"hide"}),yw.default.createElement(VscTriangleUp,null))},ww=(0,vm.default)(om)`
  z-index: ${El.sequenceEditorPanel};
  box-shadow: 2px 2px 0 rgb(0 0 0 / 11%);
`,Sw=vm.default.div`
  background-color: rgba(40, 43, 47, 0.99);
  position: absolute;
  left: 0;
  top: 0;
  bottom: 0;
  z-index: -1;
  pointer-events: none;
`,xw=(()=>{const $={rightBackground:0,scrollableArea:0,rightOverlay:0,lengthIndicatorCover:0,lengthIndicatorStrip:0,playhead:0,currentFrameStamp:0,horizontalScrollbar:0};let W=-1;for(const G of Object.keys($))$[G]=W,W++;return $})(),kw=(0,vm.default)(PanelDragZone_default)`
  position: absolute;
  left: 0;
  top: 0;
  z-index: 1;
`,_w={edges:{left:{from:"screenLeft",distance:.1},right:{from:"screenRight",distance:.2},top:{from:"screenBottom",distance:.4},bottom:{from:"screenBottom",distance:.01}}},Pw={width:800,height:200},Content4=()=>{const{dims:$}=usePanel();return usePrism((()=>{const W=mm.prism.memo("panelSize",(()=>{const W=$.width,G=$.height;return{width:W,height:G,widthWithoutBorder:W-2,heightWithoutBorder:G-4,screenX:$.left,screenY:$.top}}),[$]),G=Ks(getOutlineSelection().filter(($=>Mt($)||Bt($))).map(($=>Bt($)?$.sheet:$)));if(1!==Ks(G.map(($=>$.template))).length)return gm.default.createElement(gm.default.Fragment,null);const oe=G[0];if(!oe)return gm.default.createElement(gm.default.Fragment,null);const ae=valToAtom("panelSizeP",W).pointer,ie=mm.prism.memo("key",(()=>JSON.stringify(oe.address)),[oe]),se=mm.prism.memo("layout",(()=>sequenceEditorPanelLayout(oe,ae)),[oe,ae]).getValue();if(0===(0,mm.val)(se.tree.children).length)return gm.default.createElement(gm.default.Fragment,null);const le=mm.prism.memo("containerRef",preventHorizontalWheelEvents,[]),ue=(0,mm.val)(se.graphEditorDims.isAvailable),de=(0,mm.val)(se.graphEditorDims.isOpen);return gm.default.createElement(ww,{ref:le},gm.default.createElement(Sw,{style:{width:`${(0,mm.val)(se.leftDims.width)}px`}}),gm.default.createElement(FrameStampPositionProvider_default,{layoutP:se},gm.default.createElement(Header5,{layoutP:se}),gm.default.createElement(DopeSheet_default,{key:ie+"-dopeSheet",layoutP:se}),de&&gm.default.createElement(GraphEditor_default,{key:ie+"-graphEditor",layoutP:se}),ue&&gm.default.createElement(GraphEditorToggle_default,{layoutP:se}),gm.default.createElement(RightOverlay_default,{layoutP:se})))}),[$])},Header5=({layoutP:$})=>usePrism((()=>{const W=(0,mm.val)($.sheet);return gm.default.createElement(kw,{style:{width:(0,mm.val)($.leftDims.width)}},gm.default.createElement(Tl,null,gm.default.createElement(Cl,null,W.address.sheetId," "),gm.default.createElement(Ol,null,":"," "),gm.default.createElement(Cl,null,W.address.sheetInstanceId," "),gm.default.createElement(Ol,null," ",">"," "),gm.default.createElement(Cl,null,"Sequence")))}),[$]),SequenceEditorPanel_default=$=>gm.default.createElement(BasePanel_default,{panelId:"sequenceEditor",defaultPosition:_w,minDims:Pw},gm.default.createElement(Content4,null)),preventHorizontalWheelEvents=()=>{let $=null;const W={passive:!1,capture:!1},receiveWheelEvent=$=>{Math.abs($.deltaY)<Math.abs($.deltaX)&&($.preventDefault(),$.stopPropagation())};return G=>{$!==G&&$&&$.removeEventListener("wheel",receiveWheelEvent,W),$=G,G&&G.addEventListener("wheel",receiveWheelEvent,W)}},PanelsRoot_default=()=>{const $=useVal(getStudio().paneManager.allPanesD),W=Object.entries($).map((([$,W])=>Vp.default.createElement(PaneWrapper_default,{key:`pane-${$}`,paneInstance:W})));return Vp.default.createElement(Vp.default.Fragment,null,W,Vp.default.createElement(OutlinePanel_default,null),Vp.default.createElement(DetailPanel_default,null),Vp.default.createElement(SequenceEditorPanel_default,null))},Ew=__toModule(vt.exports),jw=__toModule(mu).default.div`
  --colors-panel-1: red;
`,ProvideTheme_default=$=>Ew.default.createElement(jw,null,$.children),Cw=__toModule(vt.exports),Ow=__toModule(mu),Iw=Ow.default.div`
  position: fixed;
  z-index: ${El.toolbar};

  top: 12px;
  right: 12px;
  left: 12px;
  height: 36px;
  pointer-events: none;

  display: flex;
  gap: 1rem;
  justify-content: center;
`,Tw=Ow.default.div`
  display: flex;
  align-items: center;
  gap: 1rem;

  border-radius: 4px;
  padding: 6px 6px;

  ${kl};

  &:hover {
    background-color: rgba(0, 0, 0, 0.15);
    backdrop-filter: blur(4px);
  }
`,GlobalToolbar_default=$=>{const W=[],G=useVal(getStudio().atomP.ephemeral.extensions.byId);for(const[,$]of Object.entries(G))$&&$.globalToolbar&&W.push(Cw.default.createElement($.globalToolbar.component,{key:"extensionToolbar-"+$.id}));return 0===W.length?null:Cw.default.createElement(Iw,null,Cw.default.createElement(Tw,null,W))},Dw=__toModule(vt.exports),Aw=navigator&&navigator.platform.toUpperCase().indexOf("MAC")>=0;function useKeyboardShortcuts(){const $=getStudio();(0,Dw.useEffect)((()=>{const handleKeyDown=W=>{const G=W.composedPath()[0];if(!G||"INPUT"!==G.tagName&&"TEXTAREA"!==G.tagName){if("z"===W.key||"Z"===W.key||"KeyZ"===W.code){if(!($=>Aw?!0===$.metaKey:!0===$.ctrlKey)(W))return;!0===W.shiftKey?$.redo():$.undo()}else if(" "!==W.key||W.shiftKey||W.metaKey||W.altKey||W.ctrlKey){if(!W.altKey||"\\"!==W.key&&"Backslash"!==W.code&&"IntlBackslash"!==W.code)return;$.transaction((({stateEditors:$,drafts:W})=>{$.studio.ahistoric.setVisibilityState("everythingIsHidden"===W.ahistoric.visibilityState?"everythingIsVisible":"everythingIsHidden")}))}else{const $=function getSelectedSequence(){const $=Ks(getOutlineSelection().filter(($=>Mt($)||Bt($))).map(($=>Bt($)?$.sheet:$)))[0];if($)return $.getSequence()}();if(!$)return;$.playing?$.pause():$.play({iterationCount:1e3})}W.preventDefault(),W.stopPropagation()}};return window.addEventListener("keydown",handleKeyDown),()=>{window.removeEventListener("keydown",handleKeyDown)}}),[])}var $w=nl.createGlobalStyle`
  :host {
    contain: strict;
    all: initial;
    color: white;
    font: 11px -apple-system, BlinkMacSystemFont, Segoe WPC, Segoe Editor,
      HelveticaNeue-Light, Ubuntu, Droid Sans, sans-serif;
  }

  * {
    padding: 0;
    margin: 0;
    font-size: 100%;
    font: inherit;
    vertical-align: baseline;
    list-style: none;
  }
`,zw=(0,nl.default)(PointerEventsHandler_default)`
  z-index: 50;
  position: fixed;
  top: 0px;
  right: 0px;
  bottom: 0px;
  left: 0px;

  &.invisible {
    pointer-events: none !important;
    opacity: 0;
    transform: translateX(1000000px);
  }
`,Mw=nl.default.div`
  z-index: 51;
  position: fixed;
  top: 0px;
  right: 0px;
  bottom: 0px;
  left: 0px;
  pointer-events: none;
`;function UIRoot(){const $=getStudio(),[W,G]=useRefAndState(void 0);useRefAndState(void 0),useKeyboardShortcuts();const oe=useVal($.atomP.ahistoric.visibilityState);(0,rl.useEffect)((()=>("everythingIsHidden"===oe&&console.warn("Theatre Studio is hidden. Use the keyboard shortcut 'alt + \\' to restore the studio, or call studio.ui.restore()."),()=>{})),[oe]);return usePrism((()=>{const oe=(0,tl.val)($.atomP.ahistoric.visibilityState);return(0,tl.val)($.atomP.ephemeral.initialised)?rl.default.createElement(nl.StyleSheetManager,{disableVendorPrefixes:!0,target:getStudio().ui.containerShadow},rl.default.createElement(rl.default.Fragment,null,rl.default.createElement($w,null),rl.default.createElement(ProvideTheme_default,null,rl.default.createElement(fc.Provider,{value:G},rl.default.createElement(TooltipContext_default,null,rl.default.createElement(zw,{className:"everythingIsHidden"===oe?"invisible":""},rl.default.createElement(Mw,{ref:W}),rl.default.createElement(GlobalToolbar_default,null),rl.default.createElement(PanelsRoot_default,null))))))):null}),[$,W,G])}var Rw=__toModule(vt.exports),Bw=__toModule(Vt.exports),Fw=__toModule(W),Nw=__toModule(W);function identity2($){return $}var Lw,actionCreator_default=($,W=identity2)=>{const originalActionCreator=G=>({type:$,payload:W(G)});return originalActionCreator.type=$,originalActionCreator.is=W=>W&&W.type&&W.type===$,originalActionCreator},Hw=__toModule(dt()),Vw=__toModule(Dt()),qw=new Uint8Array(16);function rng(){if(!Lw&&!(Lw="undefined"!=typeof crypto&&crypto.getRandomValues&&crypto.getRandomValues.bind(crypto)||"undefined"!=typeof msCrypto&&"function"==typeof msCrypto.getRandomValues&&msCrypto.getRandomValues.bind(msCrypto)))throw new Error("crypto.getRandomValues() not supported. See https://github.com/uuidjs/uuid#getrandomvalues-not-supported");return Lw(qw)}var Uw=/^(?:[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}|00000000-0000-0000-0000-000000000000)$/i;for(var Kw=function validate($){return"string"==typeof $&&Uw.test($)},Ww=[],Gw=0;Gw<256;++Gw)Ww.push((Gw+256).toString(16).substr(1));var Xw=function stringify($){var W=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0,G=(Ww[$[W+0]]+Ww[$[W+1]]+Ww[$[W+2]]+Ww[$[W+3]]+"-"+Ww[$[W+4]]+Ww[$[W+5]]+"-"+Ww[$[W+6]]+Ww[$[W+7]]+"-"+Ww[$[W+8]]+Ww[$[W+9]]+"-"+Ww[$[W+10]]+Ww[$[W+11]]+Ww[$[W+12]]+Ww[$[W+13]]+Ww[$[W+14]]+Ww[$[W+15]]).toLowerCase();if(!Kw(G))throw TypeError("Stringified UUID is invalid");return G};var Yw=function v4($,W,G){var oe=($=$||{}).random||($.rng||rng)();if(oe[6]=15&oe[6]|64,oe[8]=63&oe[8]|128,W){G=G||0;for(var ae=0;ae<16;++ae)W[G+ae]=oe[ae];return W}return Xw(oe)},Jw={replaceHistory:actionCreator_default("@history/replaceHistory"),startHistoryFromScratch:actionCreator_default("@history/startHistoryFromScratch"),undo:actionCreator_default("@history/undo"),redo:actionCreator_default("@history/redo")},Qw={type:"@history/unknownAction",payload:""},Zw={maxNumberOfCommits:100};function createEmptyHistory($){return{currentCommitHash:void 0,commitsByHash:{},listOfCommitHashes:[],innerState:$}}var eS,tS,rS={ahistoric:{visibilityState:"everythingIsVisible",theTrigger:{position:{closestCorner:"bottomLeft",distanceFromHorizontalEdge:.02,distanceFromVerticalEdge:.02}},coreByProject:{},projects:{stateByProjectId:{}}},historic:{projects:{stateByProjectId:{}},autoKey:!0,coreByProject:{},panelInstanceDesceriptors:{}},ephemeral:{initialised:!1,coreByProject:{},projects:{stateByProjectId:{}},extensions:{byId:{},paneClasses:{}}}},nS=actionCreator_default("@storeBundle/replacePersistentState",($=>$)),oS=actionCreator_default("@storeBundle/reduceParts",($=>$)),aS={historic:Jw,replacePersistentState:nS,reduceParts:oS},iS=actionCreator_default("@storeBundle/setInnerHistoricState",($=>$)),sS=(($,W=Zw)=>{const G=createEmptyHistory($(void 0,Qw));return function historicReducer(oe,ae){return Jw.startHistoryFromScratch.is(ae)?createEmptyHistory($(void 0,ae.payload)):Jw.replaceHistory.is(ae)?ae.payload:Jw.undo.is(ae)?oe?function undo($){if(void 0===$.currentCommitHash)return $;const W=$.listOfCommitHashes.findIndex((W=>W===$.currentCommitHash));if(-1===W)throw new Error("This should never happen");const G=$.commitsByHash[$.currentCommitHash],oe=(0,Vw.default)($.innerState,G.backwardDiff),ae=W-1,ie=-1===ae?void 0:$.listOfCommitHashes[ae];return __spreadProps(__spreadValues({},$),{currentCommitHash:ie,innerState:oe})}(oe):G:Jw.redo.is(ae)?oe?function redo($){if(0===$.listOfCommitHashes.length)return $;const W=$.listOfCommitHashes.findIndex((W=>W===$.currentCommitHash));if(W===$.listOfCommitHashes.length-1)return $;const G=W+1,oe=$.listOfCommitHashes[G],ae=$.commitsByHash[oe],ie=(0,Vw.default)($.innerState,ae.forwardDiff);return __spreadProps(__spreadValues({},$),{currentCommitHash:oe,innerState:ie})}(oe):G:oe?function pushCommit($,W,G){if(W===$.innerState)return $;const oe=function createCommit($,W){const G=Hw.default.diff($,W,{invertible:!1}),oe=Hw.default.diff(W,$,{invertible:!1}),ae=Date.now(),ie=Yw();return{forwardDiff:G,backwardDiff:oe,timestamp:ae,hash:ie}}($.innerState,W);if(0===oe.forwardDiff.length)return $;const ae=ys($.listOfCommitHashes),ie={currentCommitHash:oe.hash,commitsByHash:__spreadValues({},$.commitsByHash),listOfCommitHashes:[...$.listOfCommitHashes],innerState:W};if($.currentCommitHash!==ae){const W=$.listOfCommitHashes.findIndex((W=>W===$.currentCommitHash));$.listOfCommitHashes.slice(W+1).forEach(($=>{delete ie.commitsByHash[$]})),ie.listOfCommitHashes.splice(W+1,ie.listOfCommitHashes.length)}if(ie.listOfCommitHashes.push(oe.hash),ie.commitsByHash[oe.hash]=oe,ie.listOfCommitHashes.length>G.maxNumberOfCommits){const $=ie.listOfCommitHashes.length-G.maxNumberOfCommits;ie.listOfCommitHashes.slice(0,$).forEach(($=>{delete ie.commitsByHash[$]})),ie.listOfCommitHashes.splice(0,$)}return ie}(oe,$(oe.innerState,ae),W):createEmptyHistory($(void 0,ae))}})((($=rS.historic,W)=>iS.is(W)?W.payload:$)),permanentReducer=($,W)=>{if(nS.is(W)){const{historic:G,ahistoric:oe}=W.payload;return{$persistent:{historic:G,ahistoric:oe},ephemeral:(null==$?void 0:$.ephemeral)||rS.ephemeral}}if($){let{historic:G,ahistoric:oe}=$.$persistent,{ephemeral:ae}=$;if(oS.is(W)){const ie={historic:$.$persistent.historic.innerState,ahistoric:$.$persistent.ahistoric,ephemeral:$.ephemeral},se=W.payload(ie);if(se===ie)return $;G.innerState!==se.historic&&(G=sS(G,iS(se.historic))),oe=se.ahistoric,ae=se.ephemeral}else{const oe=sS(G,W);if(oe===G)return $;G=oe}return{$persistent:G===$.$persistent.historic&&oe===$.$persistent.ahistoric?$.$persistent:{historic:G,ahistoric:oe},ephemeral:ae}}return{$persistent:{historic:sS(void 0,{}),ahistoric:rS.ahistoric},ephemeral:rS.ephemeral}},lS=actionCreator_default("@history/pushTempAction",($=>$)),uS=actionCreator_default("@history/discardTempAction",($=>$)),cS=actionCreator_default("@history/commitTempAction",($=>$)),dS=0,studioReducer=($,W)=>{if($){let G,{tempActions:oe,permanent:ae}=$.$temps;if(lS.is(W))oe=[...oe,W];else if(cS.is(W)){const $=oe.find(($=>$.payload.id===W.payload));$?(G=$.payload.originalAction,oe=oe.filter(($=>$.payload.id!==W.payload))):$t.error(`Comitting temp action group ${W.payload} isn't possible as this group doesn't exist`)}else uS.is(W)?oe=oe.filter(($=>$.payload.id!==W.payload)):G=W;G&&(ae=permanentReducer($.$temps.permanent,G));let ie={historic:ae.$persistent.historic.innerState,ahistoric:ae.$persistent.ahistoric,ephemeral:ae.ephemeral};for(const $ of oe){ie=$.payload.originalAction.payload(ie)}return __spreadValues({$temps:{tempActions:oe,permanent:ae},$persistent:ae.$persistent},ie)}{const $=permanentReducer(void 0,W);return{$temps:{permanent:$,tempActions:[]},$persistent:$.$persistent,historic:$.$persistent.historic.innerState,ahistoric:$.$persistent.ahistoric,ephemeral:$.ephemeral}}},nanoid2=($=21)=>{let W="",G=$;for(;G--;)W+="ModuleSymbhasOwnPr-0123456789ABCDEFGHNRVfgctiUvz_KqYTJkLxpZXIjQW"[64*Math.random()|0];return W};function generateKeyframeId(){return nanoid2(10)}function removePathFromObject($,W){if("object"!=typeof $||null===$)return;if(0===W.length){const W=Object.keys($);for(const G of W)delete $[G];return}const G=W.slice(0,W.length-1);let oe=$;const ae=new WeakMap;for(const $ of G){const W=oe,G=W[$];if("object"!=typeof G||null===G)return;ae.set(G,W),oe=G}const ie=W.slice().reverse();for(const $ of ie){if(delete oe[$],0!==Object.keys(oe).length)return;oe=ae.get(oe)}}function n($){for(var W=arguments.length,G=Array(W>1?W-1:0),oe=1;oe<W;oe++)G[oe-1]=arguments[oe];var ae=bS[$],ie=ae?"function"==typeof ae?ae.apply(null,G):ae:"unknown error nr: "+$;throw Error("[Immer] "+ie)}function t($){return!!$&&!!$[yS]}function r($){return!!$&&(function($){if(!$||"object"!=typeof $)return!1;var W=Object.getPrototypeOf($);if(null===W)return!0;var G=Object.hasOwnProperty.call(W,"constructor")&&W.constructor;return G===Object||"function"==typeof G&&Function.toString.call(G)===wS}($)||Array.isArray($)||!!$[vS]||!!$.constructor[vS]||s($)||v($))}function i($,W,G){void 0===G&&(G=!1),0===o($)?(G?Object.keys:SS)($).forEach((function(oe){G&&"symbol"==typeof oe||W(oe,$[oe],$)})):$.forEach((function(G,oe){return W(oe,G,$)}))}function o($){var W=$[yS];return W?W.i>3?W.i-4:W.i:Array.isArray($)?1:s($)?2:v($)?3:0}function u($,W){return 2===o($)?$.has(W):Object.prototype.hasOwnProperty.call($,W)}function f($,W,G){var oe=o($);2===oe?$.set(W,G):3===oe?($.delete(W),$.add(G)):$[W]=G}function s($){return pS&&$ instanceof Map}function v($){return hS&&$ instanceof Set}function p($){return $.o||$.t}function l($){if(Array.isArray($))return Array.prototype.slice.call($);var W=xS($);delete W[yS];for(var G=SS(W),oe=0;oe<G.length;oe++){var ae=G[oe],ie=W[ae];!1===ie.writable&&(ie.writable=!0,ie.configurable=!0),(ie.get||ie.set)&&(W[ae]={configurable:!0,writable:!0,enumerable:ie.enumerable,value:$[ae]})}return Object.create(Object.getPrototypeOf($),W)}function d($,W){return void 0===W&&(W=!1),y($)||t($)||!r($)||(o($)>1&&($.set=$.add=$.clear=$.delete=h),Object.freeze($),W&&i($,(function($,W){return d(W,!0)}),!0)),$}function h(){n(2)}function y($){return null==$||"object"!=typeof $||Object.isFrozen($)}function b($){var W=kS[$];return W||n(18,$),W}function _(){return tS||n(0),tS}function j($,W){W&&(b("Patches"),$.u=[],$.s=[],$.v=W)}function O($){g($),$.p.forEach(S),$.p=null}function g($){$===tS&&(tS=$.l)}function w($){return tS={p:[],l:tS,h:$,m:!0,_:0}}function S($){var W=$[yS];0===W.i||1===W.i?W.j():W.O=!0}function P($,W){W._=W.p.length;var G=W.p[0],oe=void 0!==$&&$!==G;return W.h.g||b("ES5").S(W,$,oe),oe?(G[yS].P&&(O(W),n(4)),r($)&&($=M(W,$),W.l||x(W,$)),W.u&&b("Patches").M(G[yS],$,W.u,W.s)):$=M(W,G,[]),O(W),W.u&&W.v(W.u,W.s),$!==gS?$:void 0}function M($,W,G){if(y(W))return W;var oe=W[yS];if(!oe)return i(W,(function(ae,ie){return A($,oe,W,ae,ie,G)}),!0),W;if(oe.A!==$)return W;if(!oe.P)return x($,oe.t,!0),oe.t;if(!oe.I){oe.I=!0,oe.A._--;var ae=4===oe.i||5===oe.i?oe.o=l(oe.k):oe.o;i(3===oe.i?new Set(ae):ae,(function(W,ie){return A($,oe,ae,W,ie,G)})),x($,ae,!1),G&&$.u&&b("Patches").R(oe,G,$.u,$.s)}return oe.o}function A($,W,G,oe,ae,ie){if(ae===G&&n(5),t(ae)){var se=M($,ae,ie&&W&&3!==W.i&&!u(W.D,oe)?ie.concat(oe):void 0);if(f(G,oe,se),!t(se))return;$.m=!1}if(r(ae)&&!y(ae)){if(!$.h.F&&$._<1)return;M($,ae),W&&W.A.l||x($,ae)}}function x($,W,G){void 0===G&&(G=!1),$.h.F&&$.m&&d(W,G)}function z($,W){var G=$[yS];return(G?p(G):$)[W]}function I($,W){if(W in $)for(var G=Object.getPrototypeOf($);G;){var oe=Object.getOwnPropertyDescriptor(G,W);if(oe)return oe;G=Object.getPrototypeOf(G)}}function k($){$.P||($.P=!0,$.l&&k($.l))}function E($){$.o||($.o=l($.t))}function R($,W,G){var oe=s(W)?b("MapSet").N(W,G):v(W)?b("MapSet").T(W,G):$.g?function($,W){var G=Array.isArray($),oe={i:G?1:0,A:W?W.A:_(),P:!1,I:!1,D:{},l:W,t:$,k:null,o:null,j:null,C:!1},ae=oe,ie=_S;G&&(ae=[oe],ie=PS);var se=Proxy.revocable(ae,ie),le=se.revoke,ue=se.proxy;return oe.k=ue,oe.j=le,ue}(W,G):b("ES5").J(W,G);return(G?G.A:_()).p.push(oe),oe}function D($){return t($)||n(22,$),function n2($){if(!r($))return $;var W,G=$[yS],oe=o($);if(G){if(!G.P&&(G.i<4||!b("ES5").K(G)))return G.t;G.I=!0,W=F($,oe),G.I=!1}else W=F($,oe);return i(W,(function($,oe){G&&function a($,W){return 2===o($)?$.get(W):$[W]}(G.t,$)===oe||f(W,$,n2(oe))})),3===oe?new Set(W):W}($)}function F($,W){switch(W){case 2:return new Map($);case 3:return Array.from($)}return l($)}var fS="undefined"!=typeof Symbol&&"symbol"==typeof Symbol("x"),pS="undefined"!=typeof Map,hS="undefined"!=typeof Set,mS="undefined"!=typeof Proxy&&void 0!==Proxy.revocable&&"undefined"!=typeof Reflect,gS=fS?Symbol.for("immer-nothing"):((eS={})["immer-nothing"]=!0,eS),vS=fS?Symbol.for("immer-draftable"):"__$immer_draftable",yS=fS?Symbol.for("immer-state"):"__$immer_state",bS={0:"Illegal state",1:"Immer drafts cannot have computed properties",2:"This object has been frozen and should not be mutated",3:function($){return"Cannot use a proxy that has been revoked. Did you pass an object from inside an immer function to an async process? "+$},4:"An immer producer returned a new value *and* modified its draft. Either return a new value *or* modify the draft.",5:"Immer forbids circular references",6:"The first or second argument to `produce` must be a function",7:"The third argument to `produce` must be a function or undefined",8:"First argument to `createDraft` must be a plain object, an array, or an immerable object",9:"First argument to `finishDraft` must be a draft returned by `createDraft`",10:"The given draft is already finalized",11:"Object.defineProperty() cannot be used on an Immer draft",12:"Object.setPrototypeOf() cannot be used on an Immer draft",13:"Immer only supports deleting array indices",14:"Immer only supports setting array indices and the 'length' property",15:function($){return"Cannot apply patch, path doesn't resolve: "+$},16:'Sets cannot have "replace" patches.',17:function($){return"Unsupported patch operation: "+$},18:function($){return"The plugin for '"+$+"' has not been loaded into Immer. To enable the plugin, import and call `enable"+$+"()` when initializing your application."},20:"Cannot use proxies if Proxy, Proxy.revocable or Reflect are not available",21:function($){return"produce can only be called on things that are draftable: plain objects, arrays, Map, Set or classes that are marked with '[immerable]: true'. Got '"+$+"'"},22:function($){return"'current' expects a draft, got: "+$},23:function($){return"'original' expects a draft, got: "+$},24:"Patching reserved attributes like __proto__, prototype and constructor is not allowed"},wS=""+Object.prototype.constructor,SS="undefined"!=typeof Reflect&&Reflect.ownKeys?Reflect.ownKeys:void 0!==Object.getOwnPropertySymbols?function($){return Object.getOwnPropertyNames($).concat(Object.getOwnPropertySymbols($))}:Object.getOwnPropertyNames,xS=Object.getOwnPropertyDescriptors||function($){var W={};return SS($).forEach((function(G){W[G]=Object.getOwnPropertyDescriptor($,G)})),W},kS={},_S={get:function($,W){if(W===yS)return $;var G,oe,ae,ie=p($);if(!u(ie,W))return G=$,(ae=I(ie,W))?"value"in ae?ae.value:null===(oe=ae.get)||void 0===oe?void 0:oe.call(G.k):void 0;var se=ie[W];return $.I||!r(se)?se:se===z($.t,W)?(E($),$.o[W]=R($.A.h,se,$)):se},has:function($,W){return W in p($)},ownKeys:function($){return Reflect.ownKeys(p($))},set:function($,W,G){var oe=I(p($),W);if(null==oe?void 0:oe.set)return oe.set.call($.k,G),!0;if(!$.P){var ae=z(p($),W),ie=null==ae?void 0:ae[yS];if(ie&&ie.t===G)return $.o[W]=G,$.D[W]=!1,!0;if(function c($,W){return $===W?0!==$||1/$==1/W:$!=$&&W!=W}(G,ae)&&(void 0!==G||u($.t,W)))return!0;E($),k($)}return $.o[W]===G&&"number"!=typeof G&&(void 0!==G||W in $.o)||($.o[W]=G,$.D[W]=!0,!0)},deleteProperty:function($,W){return void 0!==z($.t,W)||W in $.t?($.D[W]=!1,E($),k($)):delete $.D[W],$.o&&delete $.o[W],!0},getOwnPropertyDescriptor:function($,W){var G=p($),oe=Reflect.getOwnPropertyDescriptor(G,W);return oe?{writable:!0,configurable:1!==$.i||"length"!==W,enumerable:oe.enumerable,value:G[W]}:oe},defineProperty:function(){n(11)},getPrototypeOf:function($){return Object.getPrototypeOf($.t)},setPrototypeOf:function(){n(12)}},PS={};i(_S,(function($,W){PS[$]=function(){return arguments[0]=arguments[0][0],W.apply(this,arguments)}})),PS.deleteProperty=function($,W){return isNaN(parseInt(W))&&n(13),_S.deleteProperty.call(this,$[0],W)},PS.set=function($,W,G){return"length"!==W&&isNaN(parseInt(W))&&n(14),_S.set.call(this,$[0],W,G,$[0])};var ES=function(){function e($){var W=this;this.g=mS,this.F=!0,this.produce=function($,G,oe){if("function"==typeof $&&"function"!=typeof G){var ae=G;G=$;var ie=W;return function($){var W=this;void 0===$&&($=ae);for(var oe=arguments.length,se=Array(oe>1?oe-1:0),le=1;le<oe;le++)se[le-1]=arguments[le];return ie.produce($,(function($){var oe;return(oe=G).call.apply(oe,[W,$].concat(se))}))}}var se;if("function"!=typeof G&&n(6),void 0!==oe&&"function"!=typeof oe&&n(7),r($)){var le=w(W),ue=R(W,$,void 0),de=!0;try{se=G(ue),de=!1}finally{de?O(le):g(le)}return"undefined"!=typeof Promise&&se instanceof Promise?se.then((function($){return j(le,oe),P($,le)}),(function($){throw O(le),$})):(j(le,oe),P(se,le))}if(!$||"object"!=typeof $){if((se=G($))===gS)return;return void 0===se&&(se=$),W.F&&d(se,!0),se}n(21,$)},this.produceWithPatches=function($,G){return"function"==typeof $?function(G){for(var oe=arguments.length,ae=Array(oe>1?oe-1:0),ie=1;ie<oe;ie++)ae[ie-1]=arguments[ie];return W.produceWithPatches(G,(function(W){return $.apply(void 0,[W].concat(ae))}))}:[W.produce($,G,(function($,W){oe=$,ae=W})),oe,ae];var oe,ae},"boolean"==typeof(null==$?void 0:$.useProxies)&&this.setUseProxies($.useProxies),"boolean"==typeof(null==$?void 0:$.autoFreeze)&&this.setAutoFreeze($.autoFreeze)}var $=e.prototype;return $.createDraft=function($){r($)||n(8),t($)&&($=D($));var W=w(this),G=R(this,$,void 0);return G[yS].C=!0,g(W),G},$.finishDraft=function($,W){var G=$&&$[yS];G&&G.C||n(9),G.I&&n(10);var oe=G.A;return j(oe,W),P(void 0,oe)},$.setAutoFreeze=function($){this.F=$},$.setUseProxies=function($){$&&!mS&&n(20),this.g=$},$.applyPatches=function($,W){var G;for(G=W.length-1;G>=0;G--){var oe=W[G];if(0===oe.path.length&&"replace"===oe.op){$=oe.value;break}}var ae=b("Patches").$;return t($)?ae($,W):this.produce($,(function($){return ae($,W.slice(G+1))}))},e}(),jS=new ES;jS.produce,jS.produceWithPatches.bind(jS),jS.setAutoFreeze.bind(jS),jS.setUseProxies.bind(jS),jS.applyPatches.bind(jS);var CS,OS,IS,TS,DS,AS,$S,zS,MS,RS,BS,FS,NS,LS,HS,VS=jS.createDraft.bind(jS),qS=jS.finishDraft.bind(jS),setDrafts__onlyMeantToBeCalledByTransaction=$=>(CS=$,OS),drafts=()=>{if(void 0===CS)throw new Error("Calling stateEditors outside of a transaction is not allowed.");return CS};function defer(){let $,W;const G=new Promise(((G,ae)=>{$=$=>{G($),oe.status="resolved"},W=$=>{ae($),oe.status="rejected"}})),oe={resolve:$,reject:W,promise:G,status:"pending"};return oe}IS=OS||(OS={}),TS=IS.studio||(IS.studio={}),((DS=TS.historic||(TS.historic={})).panelPositions||(DS.panelPositions={})).setPanelPosition=function setPanelPosition($){const W=drafts().historic;null!=W.panelPositions||(W.panelPositions={}),W.panelPositions[$.panelId]=$.position},(AS=DS.panels||(DS.panels={}))._ensure=function _ensure(){var $;return null!=($=drafts().historic).panels||($.panels={}),drafts().historic.panels},($S=AS.outline||(AS.outline={}))._ensure=function _ensure2(){const $=IS.studio.historic.panels._ensure();return null!=$.outlinePanel||($.outlinePanel={}),$.outlinePanel},(zS=$S.selection||($S.selection={})).set=function set2($){const W=[];for(const G of Ks($))zt(G)?W.push(__spreadValues({type:"Project"},G.address)):Mt(G)?(W.push(__spreadValues({type:"Sheet"},G.template.address)),IS.studio.historic.projects.stateByProjectId.stateBySheetId.setSelectedInstanceId(G.address)):Rt(G)?W.push(__spreadValues({type:"Sheet"},G.address)):Bt(G)?(W.push(__spreadValues({type:"SheetObject"},G.template.address)),IS.studio.historic.projects.stateByProjectId.stateBySheetId.setSelectedInstanceId(G.sheet.address)):Ft(G)&&W.push(__spreadValues({type:"SheetObject"},G.address));$S._ensure().selection=W},zS.unset=function unset(){$S._ensure().selection=[]},(MS=AS.sequenceEditor||(AS.sequenceEditor={}))._ensure=function _ensure2(){const $=IS.studio.historic.panels._ensure();return null!=$.sequenceEditor||($.sequenceEditor={}),$.sequenceEditor},(MS.graphEditor||(MS.graphEditor={})).setIsOpen=function setIsOpen($){(function _ensure3(){const $=MS._ensure();return null!=$.graphEditor||($.graphEditor={height:.5,isOpen:!1}),$.graphEditor}()).isOpen=$.isOpen},RS=DS.projects||(DS.projects={}),(BS=RS.stateByProjectId||(RS.stateByProjectId={}))._ensure=function _ensure($){const W=drafts().historic;return W.projects.stateByProjectId[$.projectId]||(W.projects.stateByProjectId[$.projectId]={stateBySheetId:{}}),W.projects.stateByProjectId[$.projectId]},(FS=BS.stateBySheetId||(BS.stateBySheetId={}))._ensure=function _ensure2($){const W=IS.studio.historic.projects.stateByProjectId._ensure($);return W.stateBySheetId[$.sheetId]||(W.stateBySheetId[$.sheetId]={selectedInstanceId:void 0,sequenceEditor:{selectedPropsByObject:{}}}),W.stateBySheetId[$.sheetId]},FS.setSelectedInstanceId=function setSelectedInstanceId($){IS.studio.historic.projects.stateByProjectId.stateBySheetId._ensure($).selectedInstanceId=$.sheetInstanceId},function($){$.addPropToGraphEditor=function addPropToGraphEditor($){const{selectedPropsByObject:W}=FS._ensure($).sequenceEditor;W[$.objectKey]||(W[$.objectKey]={});const G=W[$.objectKey],oe=encodePathToProp($.pathToProp),ae=new Set(Object.keys(vy));for(const[$,G]of Object.entries(D(W)))for(const[$,W]of Object.entries(G))ae.delete(W);const ie=ae.size>0?ae.values().next().value:Object.keys(vy)[0];G[oe]=ie},$.removePropFromGraphEditor=function removePropFromGraphEditor($){const{selectedPropsByObject:W}=FS._ensure($).sequenceEditor;if(!W[$.objectKey])return;const G=W[$.objectKey],oe=encodePathToProp($.pathToProp);G[oe]&&removePathFromObject(W,[$.objectKey,oe])}}(FS.sequenceEditor||(FS.sequenceEditor={})),function($){!function($){$._ensure=function _ensure($){const W=drafts().ephemeral;return W.projects.stateByProjectId[$.projectId]||(W.projects.stateByProjectId[$.projectId]={stateBySheetId:{}}),W.projects.stateByProjectId[$.projectId]},function($){var W;$._ensure=function _ensure2($){const W=IS.studio.ephemeral.projects.stateByProjectId._ensure($);return W.stateBySheetId[$.sheetId]||(W.stateBySheetId[$.sheetId]={stateByObjectKey:{}}),W.stateBySheetId[$.sheetId]},(W=$.stateByObjectKey||($.stateByObjectKey={}))._ensure=function _ensure3($){var W;const G=IS.studio.ephemeral.projects.stateByProjectId.stateBySheetId._ensure($).stateByObjectKey;return null!=G[W=$.objectKey]||(G[W]={}),G[$.objectKey]},function($){function _ensure4($){const W=IS.studio.ephemeral.projects.stateByProjectId.stateBySheetId.stateByObjectKey._ensure($);return null!=W.valuesBeingScrubbed||(W.valuesBeingScrubbed={}),W.valuesBeingScrubbed}$._ensure=_ensure4,$.flag=function flag($){Hs(_ensure4($),$.pathToProp,!0)}}(W.propsBeingScrubbed||(W.propsBeingScrubbed={}))}($.stateBySheetId||($.stateBySheetId={}))}($.stateByProjectId||($.stateByProjectId={}))}((NS=TS.ephemeral||(TS.ephemeral={})).projects||(NS.projects={})),(LS=TS.ahistoric||(TS.ahistoric={})).setVisibilityState=function setVisibilityState($){drafts().ahistoric.visibilityState=$},function($){!function($){$._ensure=function _ensure($){const W=drafts().ahistoric;return W.projects.stateByProjectId[$.projectId]||(W.projects.stateByProjectId[$.projectId]={stateBySheetId:{}}),W.projects.stateByProjectId[$.projectId]},function($){var W;$._ensure=function _ensure2($){const W=IS.studio.ahistoric.projects.stateByProjectId._ensure($);return W.stateBySheetId[$.sheetId]||(W.stateBySheetId[$.sheetId]={}),W.stateBySheetId[$.sheetId]},(W=$.sequence||($.sequence={}))._ensure=function _ensure3($){const W=IS.studio.ahistoric.projects.stateByProjectId.stateBySheetId._ensure($);return W.sequence||(W.sequence={}),W.sequence},(W.clippedSpaceRange||(W.clippedSpaceRange={})).set=function set2($){IS.studio.ahistoric.projects.stateByProjectId.stateBySheetId.sequence._ensure($).clippedSpaceRange=__spreadValues({},$.range)}}($.stateBySheetId||($.stateBySheetId={}))}($.stateByProjectId||($.stateByProjectId={}))}(LS.projects||(LS.projects={})),function($){var W,G;($.revisionHistory||($.revisionHistory={})).add=function add($){const W=drafts().historic.coreByProject[$.projectId].revisionHistory;W.unshift($.revision),W.length>50&&(W.length=50)},(W=$.sheetsById||($.sheetsById={}))._ensure=function _ensure($){const W=drafts().historic.coreByProject[$.projectId].sheetsById;return W[$.sheetId]||(W[$.sheetId]={staticOverrides:{byObject:{}}}),W[$.sheetId]},function($){function _ensure2($){const W=IS.coreByProject.historic.sheetsById._ensure($);return null!=W.sequence||(W.sequence={subUnitsPerUnit:30,length:10,type:"PositionalSequence",tracksByObject:{}}),W.sequence}function _ensureTracksOfObject($){var W;const G=IS.coreByProject.historic.sheetsById.sequence._ensure($).tracksByObject;return null!=G[W=$.objectKey]||(G[W]={trackData:{},trackIdByPropPath:{}}),G[$.objectKey]}function _getTrack($){return _ensureTracksOfObject($).trackData[$.trackId]}function replaceKeyframes($){const W=_getTrack($);if(!W)return;const G=D(W.keyframes),oe=$.keyframes.filter(($=>!!isFinite($.value)&&!!$.handles.every(($=>isFinite($))))).map((W=>__spreadProps(__spreadValues({},W),{position:$.snappingFunction(W.position)}))),ae=Is(oe,"id"),ie=G.filter(($=>!ae[$.id])),se=Is(ie,"position");oe.forEach((({position:$})=>{const W=se[$];W&&Ns(ie,W)}));const le=Vs([...ie,...oe],"position");W.keyframes=le}$._ensure=_ensure2,$.setLength=function setLength($){_ensure2($).length=parseFloat($.length.toFixed(2))},$.setPrimitivePropAsSequenced=function setPrimitivePropAsSequenced($){const W=_ensureTracksOfObject($),G=encodePathToProp($.pathToProp);if("string"==typeof W.trackIdByPropPath[G])return;const oe=function generateSequenceTrackId(){return nanoid2(10)}();W.trackData[oe]={type:"BasicKeyframedTrack",keyframes:[]},W.trackIdByPropPath[G]=oe},$.setPrimitivePropAsStatic=function setPrimitivePropAsStatic($){const W=_ensureTracksOfObject($),G=JSON.stringify($.pathToProp),oe=W.trackIdByPropPath[G];"string"==typeof oe&&(delete W.trackIdByPropPath[G],delete W.trackData[oe],IS.coreByProject.historic.sheetsById.staticOverrides.byObject.setValueOfPrimitiveProp($))},$.setCompoundPropAsStatic=function setCompoundPropAsStatic($){const W=_ensureTracksOfObject($);for(const G of Object.keys(W.trackIdByPropPath)){const oe=JSON.parse(G),ae=$.pathToProp.every((($,W)=>oe[W]===$));if(ae){const $=W.trackIdByPropPath[G];if("string"!=typeof $)continue;delete W.trackIdByPropPath[G],delete W.trackData[$]}}IS.coreByProject.historic.sheetsById.staticOverrides.byObject.setValueOfCompoundProp($)},$.setKeyframeAtPosition=function setKeyframeAtPosition($){const W=$.snappingFunction($.position),G=_getTrack($);if(!G)return;const{keyframes:oe}=G,ae=oe.findIndex(($=>$.position===W));if(-1!==ae)return void(oe[ae].value=$.value);const ie=ks(oe,($=>$.position<W));if(-1===ie)return void oe.unshift({id:generateKeyframeId(),position:W,connectedRight:!0,handles:[.5,1,.5,0],value:$.value});const se=oe[ie];oe.splice(ie+1,0,{id:generateKeyframeId(),position:W,connectedRight:se.connectedRight,handles:[.5,1,.5,0],value:$.value})},$.unsetKeyframeAtPosition=function unsetKeyframeAtPosition($){const W=_getTrack($);if(!W)return;const{keyframes:G}=W,oe=G.findIndex((W=>W.position===$.position));-1!==oe&&G.splice(oe,1)},$.transformKeyframes=function transformKeyframes($){const W=_getTrack($);if(!W)return;const G=D(W.keyframes).filter((W=>-1!==$.keyframeIds.indexOf(W.id))),oe=G.map((W=>{const G=W.position,oe=$.snappingFunction(function transformNumber($,{scale:W,origin:G,translate:oe}){return oe+(G+($-G)*W)}(G,$));return __spreadProps(__spreadValues({},W),{position:oe})}));replaceKeyframes(__spreadProps(__spreadValues({},$),{keyframes:oe}))},$.deleteKeyframes=function deleteKeyframes($){const W=_getTrack($);W&&(W.keyframes=W.keyframes.filter((W=>-1===$.keyframeIds.indexOf(W.id))))},$.replaceKeyframes=replaceKeyframes}(W.sequence||(W.sequence={})),function($){function _ensure2($){var W;const G=IS.coreByProject.historic.sheetsById._ensure($).staticOverrides.byObject;return null!=G[W=$.objectKey]||(G[W]={}),G[$.objectKey]}$.setValueOfCompoundProp=function setValueOfCompoundProp($){const W=_ensure2($);Hs(W,$.pathToProp,$.value)},$.setValueOfPrimitiveProp=function setValueOfPrimitiveProp($){const W=_ensure2($);Hs(W,$.pathToProp,$.value)},$.unsetValueOfPrimitiveProp=function unsetValueOfPrimitiveProp($){const W=IS.coreByProject.historic.sheetsById._ensure($).staticOverrides.byObject[$.objectKey];W&&removePathFromObject(W,$.pathToProp)}}((G=W.staticOverrides||(W.staticOverrides={})).byObject||(G.byObject={}))}((HS=IS.coreByProject||(IS.coreByProject={})).historic||(HS.historic={}));var US=__toModule(W);var KS=function symbolObservablePonyfill($){var W,G=$.Symbol;return"function"==typeof G?G.observable?W=G.observable:(W=G("observable"),G.observable=W):W="@@observable",W}("undefined"!=typeof self?self:"undefined"!=typeof window||"undefined"!=typeof window?window:$),WS="@@redux/INIT";function createStore($,W,G){var oe;if("function"==typeof W&&void 0===G&&(G=W,W=void 0),void 0!==G){if("function"!=typeof G)throw new Error("Expected the enhancer to be a function.");return G(createStore)($,W)}if("function"!=typeof $)throw new Error("Expected the reducer to be a function.");var ae=$,ie=W,se=[],le=se,ue=!1;function ensureCanMutateNextListeners(){le===se&&(le=se.slice())}function getState(){return ie}function subscribe($){if("function"!=typeof $)throw new Error("Expected listener to be a function.");var W=!0;return ensureCanMutateNextListeners(),le.push($),function unsubscribe(){if(W){W=!1,ensureCanMutateNextListeners();var G=le.indexOf($);le.splice(G,1)}}}function dispatch($){if(!No($))throw new Error("Actions must be plain objects. Use custom middleware for async actions.");if(void 0===$.type)throw new Error('Actions may not have an undefined "type" property. Have you misspelled a constant?');if(ue)throw new Error("Reducers may not dispatch actions.");try{ue=!0,ie=ae(ie,$)}finally{ue=!1}for(var W=se=le,G=0;G<W.length;G++){(0,W[G])()}return $}return dispatch({type:WS}),(oe={dispatch:dispatch,subscribe:subscribe,getState:getState,replaceReducer:function replaceReducer($){if("function"!=typeof $)throw new Error("Expected the nextReducer to be a function.");ae=$,dispatch({type:WS})}})[KS]=function observable(){var $,W=subscribe;return($={subscribe:function subscribe2($){if("object"!=typeof $)throw new TypeError("Expected the observer to be an object.");function observeState(){$.next&&$.next(getState())}return observeState(),{unsubscribe:W(observeState)}}})[KS]=function(){return this},$},oe}function isCrushed(){}function configureStore($){const W=[];{const G="object"==typeof window&&window.__REDUX_DEVTOOLS_EXTENSION__?window.__REDUX_DEVTOOLS_EXTENSION__($.devtoolsOptions):Pr;W.push(G)}const G=function compose(){for(var $=arguments.length,W=Array($),G=0;G<$;G++)W[G]=arguments[G];return 0===W.length?function($){return $}:1===W.length?W[0]:W.reduce((function($,W){return function(){return $(W.apply(void 0,arguments))}}))}(...W);return createStore($.rootReducer,void 0,G)}"string"==typeof isCrushed.name&&"isCrushed"!==isCrushed.name&&function warning2($){"undefined"!=typeof console&&"function"==typeof console.error&&console.error($);try{throw new Error($)}catch($){}}("You are currently using minified code outside of NODE_ENV === 'production'. This means that you are running a slower development build of Redux. You can use loose-envify (https://github.com/zertosh/loose-envify) for browserify or DefinePlugin for webpack (http://stackoverflow.com/questions/30030031) to ensure you have the correct code for your production build.");var GS=__toModule(W),persistStateOfStudio=($,W,G)=>{const oe=G+".persistent",getState=()=>$.getState().$persistent;!function loadFromPersistentStorage(){const G=localStorage.getItem(oe);if(G){let oe,ie=!0;try{oe=JSON.parse(G),ie=!1}catch($){$t.warn("Could not parse Theatre's persisted state. This must be a bug. Please report it.")}finally{ie||(ae=oe,$.dispatch(aS.replacePersistentState(ae))),W()}}else W();var ae}();let ae=getState();const persist=()=>{const $=getState();$!==ae&&(ae=$,localStorage.setItem(oe,JSON.stringify($)))};$.subscribe(gs(persist,1e3)),window&&window.addEventListener("beforeunload",persist)},XS=__toModule(W),YS=class{constructor(){__publicField(this,"_values",{})}get($,W){if(this.has($))return this._values[$];{const G=W();return this._values[$]=G,G}}has($){return this._values.hasOwnProperty($)}},JS=__toModule(W),QS="__TheatreJS_StudioBundle",ZS=__toModule(vt.exports),ex=__toModule(mu),tx=(0,ex.default)(Qc)``;function OptionButton({value:$,label:W,icon:G,onClick:oe,isSelected:ae}){return ZS.default.createElement(ZS.default.Fragment,null,ZS.default.createElement(tx,{forwardedAs:nc,className:ae?"selected":void 0,"aria-label":W,onClick:oe,title:W},G))}var rx=(0,ex.default)(oc)`
  display: flex;
  gap: 5px;
`,ToolbarSwitchSelect_default=({value:$,onChange:W,options:G})=>ZS.default.createElement(rx,null,G.map((({label:G,icon:oe,value:ae})=>ZS.default.createElement(OptionButton,{key:ae,value:ae,isSelected:$===ae,label:G,icon:oe,onClick:()=>W(ae)})))),nx=__toModule(vt.exports),ox=__toModule(mu).default.div``,ToolbarDropdownSelect_default=$=>nx.default.createElement(ox,null),ax=new class{constructor(){__publicField(this,"ui"),__publicField(this,"publicApi"),__publicField(this,"address"),__publicField(this,"_projectsProxy",new Nw.PointerProxy(new Nw.Atom({}).pointer)),__publicField(this,"projectsP",this._projectsProxy.pointer),__publicField(this,"_store",new class{constructor(){__publicField(this,"_reduxStore"),__publicField(this,"_atom"),__publicField(this,"atomP"),this._reduxStore=configureStore({rootReducer:studioReducer,devtoolsOptions:{name:"Theatre.js Studio"}}),this._atom=function atomFromReduxStore($){let W=$.getState();const G=new US.Atom(W);return $.subscribe((()=>{const oe=$.getState();G.setState(oe),W=oe})),G}(this._reduxStore),this.atomP=this._atom.pointer}initialize($){const W=defer();return!0===$.usePersistentStorage?persistStateOfStudio(this._reduxStore,(()=>{this.tempTransaction((({drafts:$})=>{$.ephemeral.initialised=!0})).commit(),W.resolve()}),$.persistenceKey):(this.tempTransaction((({drafts:$})=>{$.ephemeral.initialised=!0})).commit(),W.resolve()),W.promise}getState(){return this._reduxStore.getState()}__dev_startHistoryFromScratch($){this._reduxStore.dispatch(aS.historic.startHistoryFromScratch(aS.reduceParts((W=>__spreadProps(__spreadValues({},W),{historic:$})))))}tempTransaction($){const W=(()=>{const $=dS++;return{push:W=>lS({id:$,originalAction:W}),discard:()=>uS($),commit:()=>cS($)}})();let G;const oe=W.push(aS.reduceParts((W=>{const oe={historic:VS(W.historic),ahistoric:VS(W.ahistoric),ephemeral:VS(W.ephemeral)};let ae=!0,ensureRunning=()=>{if(!ae)throw new Error("You seem to have called the transaction api after studio.transaction() has finished running")};const ie={set:($,W)=>{ensureRunning();const{root:G}=(0,GS.getPointerParts)($);if(!Bt(G))throw new Error("Only setting props of SheetObject-s is supported in a transaction so far");{G.validateValue($,W);const oe=(0,GS.val)(G.template.getMapOfValidSequenceTracks_forStudio().getValue());forEachDeep(W,(($,W)=>{if(null==$)return;const ae=__spreadProps(__spreadValues({},G.address),{pathToProp:W}),ie=Oo(oe,W);if("string"==typeof ie){const W=G.sheet.getSequence();W.position=W.closestGridPosition(W.position),se.coreByProject.historic.sheetsById.sequence.setKeyframeAtPosition(__spreadProps(__spreadValues({},ae),{trackId:ie,position:W.position,value:$,snappingFunction:W.closestGridPosition}))}else se.coreByProject.historic.sheetsById.staticOverrides.byObject.setValueOfPrimitiveProp(__spreadProps(__spreadValues({},ae),{value:$}))}),(0,GS.getPointerParts)($).path)}},unset:$=>{ensureRunning();const{root:W,path:G}=(0,GS.getPointerParts)($);if(!Bt(W))throw new Error("Only setting props of SheetObject-s is supported in a transaction so far");{const oe=(0,GS.val)(W.template.getMapOfValidSequenceTracks_forStudio().getValue());forEachDeep(getDeep(W.template.getDefaultValues().getValue(),G),(($,G)=>{const ae=__spreadProps(__spreadValues({},W.address),{pathToProp:G}),ie=Oo(oe,G);"string"==typeof ie?se.coreByProject.historic.sheetsById.sequence.unsetKeyframeAtPosition(__spreadProps(__spreadValues({},ae),{trackId:ie,position:W.sheet.getSequence().positionSnappedToGrid})):se.coreByProject.historic.sheetsById.staticOverrides.byObject.unsetValueOfPrimitiveProp(ae)}),(0,GS.getPointerParts)($).path)}},get drafts(){return ensureRunning(),oe},get stateEditors(){return se}},se=setDrafts__onlyMeantToBeCalledByTransaction(oe);try{return $(ie),ae=!1,{historic:qS(oe.historic),ahistoric:qS(oe.ahistoric),ephemeral:qS(oe.ephemeral)}}catch($){return G=$,W}finally{setDrafts__onlyMeantToBeCalledByTransaction(void 0)}})));if(this._reduxStore.dispatch(oe),G)throw this._reduxStore.dispatch(W.discard()),G;return{commit:()=>{this._reduxStore.dispatch(W.commit())},discard:()=>{this._reduxStore.dispatch(W.discard())}}}undo(){this._reduxStore.dispatch(aS.historic.undo())}redo(){this._reduxStore.dispatch(aS.historic.redo())}createContentOfSaveFile($){if(!this._reduxStore.getState().$persistent.historic.innerState.coreByProject[$])throw new Error(`Project ${$} has not been initialized.`);const W=generateDiskStateRevision();this.tempTransaction((({stateEditors:G})=>{G.coreByProject.historic.revisionHistory.add({projectId:$,revision:W})})).commit();const G=this._reduxStore.getState().$persistent.historic.innerState.coreByProject[$];return __spreadValues({},G)}}),__publicField(this,"_corePrivateApi"),__publicField(this,"_cache",new YS),__publicField(this,"paneManager"),__publicField(this,"_coreAtom",new Nw.Atom({})),__publicField(this,"_initializedDeferred",defer()),__publicField(this,"_initializeFnCalled",!1),this.address={studioId:nanoid2(10)},this.publicApi=new class{constructor($){__publicField(this,"ui",{hide(){getStudio().ui.hide()},get isHidden(){return getStudio().ui.isHidden},restore(){getStudio().ui.restore()}}),__publicField(this,"_cache",new YS)}initialize($){return getStudio().initialize($)}extend($){getStudio().extend($)}transaction($){return getStudio().transaction((({set:W,unset:G})=>$({set:W,unset:G})))}_getSelectionDerivation(){return this._cache.get("_getStateDerivation()",(()=>(0,XS.prism)((()=>getOutlineSelection().filter(($=>"Theatre_SheetObject"===$.type||"Theatre_Sheet"===$.type)).map(($=>$.publicApi))))))}_getSelection(){return this._getSelectionDerivation().getValue()}setSelection($){const W=[...$].filter(($=>Lt($)||Nt($))).map(($=>getStudio().corePrivateAPI($)));getStudio().transaction((({stateEditors:$})=>{$.studio.historic.panels.outline.selection.set(W)}))}onSelectionChange($){return this._getSelectionDerivation().tapImmediate(hy,$)}get selection(){return this._getSelection()}scrub(){return getStudio().scrub()}getStudioProject(){const $=getStudio().core;if(!$)throw new Error("You're calling studio.getStudioProject() before `@theatre/core` is loaded. To fix this:\n1. Check if `@theatre/core` is import/required in your bundle.\n2. Check the stack trace of this error and make sure the funciton that calls getStudioProject() is run after `@theatre/core` is loaded.");return getStudio().getStudioProject($)}debouncedScrub($=1e3){let W;const G=gs((()=>{const $=W;$&&(W=void 0,$.commit())}),$);return{capture:$=>{W||(W=this.scrub());let oe=!0;try{W.capture($),oe=!1}finally{if(oe){const $=W;W=void 0,$.discard()}else G()}}}}createPane($){return getStudio().paneManager.createPane($)}destroyPane($){return getStudio().paneManager.destroyPane($)}createContentOfSaveFile($){return getStudio().createContentOfSaveFile($)}}(this),this.ui=new class{constructor($){this.studio=$,__publicField(this,"containerEl",document.createElement("div")),__publicField(this,"_rendered",!1),__publicField(this,"_renderTimeout"),__publicField(this,"_documentBodyUIIsRenderedIn"),__publicField(this,"containerShadow"),this.containerEl.id="theatrejs-studio-root",this.containerEl.style.cssText="\n      position: fixed;\n      top: 0;\n      right: 0;\n      bottom: 0;\n      left: 0;\n      pointer-events: none;\n      z-index: 100;\n    ",this.containerShadow=this.containerEl.attachShadow({mode:"open"})}render(){this._rendered||(this._rendered=!0,this._render())}_render(){const renderCallback=()=>{document.body?(this._renderTimeout=void 0,this._documentBodyUIIsRenderedIn=document.body,this._documentBodyUIIsRenderedIn.appendChild(this.containerEl),Bw.default.render(Rw.default.createElement(UIRoot),this.containerShadow)):this._renderTimeout=setTimeout(renderCallback,5)};this._renderTimeout=setTimeout(renderCallback,10)}hide(){this.studio.transaction((({drafts:$})=>{$.ahistoric.visibilityState="everythingIsHidden"}))}restore(){this.render(),this.studio.transaction((({drafts:$})=>{$.ahistoric.visibilityState="everythingIsVisible"}))}get isHidden(){return"everythingIsHidden"===(0,Fw.val)(this.studio.atomP.ahistoric.visibilityState)}}(this),this._attachToIncomingProjects(),this.paneManager=new class{constructor($){this._studio=$,__publicField(this,"_cache",new YS),this._instantiatePanesAsTheyComeIn()}_instantiatePanesAsTheyComeIn(){const $=this._getAllPanes();$.changesWithoutValues().tap((()=>{$.getValue()}))}_getAllPanes(){return this._cache.get("_getAllPanels()",(()=>(0,JS.prism)((()=>{if(!(0,JS.val)(this._studio.coreP))return{};const $=(0,JS.val)(this._studio.atomP.historic.panelInstanceDesceriptors),W=(0,JS.val)(this._studio.atomP.ephemeral.extensions.paneClasses),G={};for(const[,oe]of Object.entries($)){const $=W[oe.paneClass];if(!$)continue;const{instanceId:ae}=oe,{extensionId:ie,classDefinition:se}=$,le=JS.prism.memo(`instance-${oe.instanceId}`,(()=>({extensionId:ie,instanceId:ae,definition:se})),ep);G[ae]=le}return G}))))}get allPanesD(){return this._getAllPanes()}createPane($){if(!this._studio.core)throw new Error("Can't create a pane because @theatre/core is not yet loaded");const W=(0,JS.val)(this._studio.atomP.ephemeral.extensions.paneClasses[$].extensionId),G=(0,JS.val)(this._studio.atomP.historic.panelInstanceDesceriptors);let oe;for(let W=1;W<1e3&&(oe=`${$} #${W}`,G[oe]);W++);if(!W)throw new Error(`Pance class "${$}" is not registered.`);return this._studio.transaction((({drafts:W})=>{W.historic.panelInstanceDesceriptors[oe]={instanceId:oe,paneClass:$}})),this._getAllPanes().getValue()[oe]}destroyPane($){if(!this._studio.core)throw new Error("Can't do this yet because @theatre/core is not yet loaded");this._studio.transaction((({drafts:W})=>{delete W.historic.panelInstanceDesceriptors[$]}))}}(this)}get atomP(){return this._store.atomP}initialize($){return W=this,G=null,oe=function*(){if(this._initializeFnCalled)return this._initializedDeferred.promise;const W={persistenceKey:"theatre-0.4",usePersistentStorage:!0};"string"==typeof(null==$?void 0:$.persistenceKey)&&(W.persistenceKey=$.persistenceKey),!1===(null==$?void 0:$.usePersistentStorage)&&(W.usePersistentStorage=!1);try{yield this._store.initialize(W)}catch($){return void this._initializedDeferred.reject($)}this._initializedDeferred.resolve(),this.ui.render()},new Promise((($,ae)=>{var fulfilled=$=>{try{step(oe.next($))}catch($){ae($)}},rejected=$=>{try{step(oe.throw($))}catch($){ae($)}},step=W=>W.done?$(W.value):Promise.resolve(W.value).then(fulfilled,rejected);step((oe=oe.apply(W,G)).next())}));var W,G,oe}get initialized(){return this._initializedDeferred.promise}_attachToIncomingProjects(){const $=(0,Nw.valueDerivation)(this.projectsP),attachToProjects=$=>{for(const W of Object.values($))W.isAttachedToStudio||W.attachToStudio(this)};$.changesWithoutValues().tap((()=>{attachToProjects($.getValue())})),attachToProjects($.getValue())}setCoreBits($){this._corePrivateApi=$.privateAPI,this._coreAtom.setIn(["core"],$.coreExports),this._setProjectsP($.projectsP)}_setProjectsP($){this._projectsProxy.setPointer($)}scrub(){return new class{constructor($){this._studio=$,__publicField(this,"_id"),__publicField(this,"_state",{type:"Ready"}),this._id=String(Ht++)}get status(){return this._state.type}reset(){const{_state:$}=this;if("Ready"!==$.type){if("Captured"!==$.type)throw"Committed"===$.type?new Error("This scrub is already committed and can't be reset."):new Error("This scrub is already discarded and can't be reset.");this._state={type:"Ready"},$.transaction.discard(),$.flagsTransaction.discard()}}commit(){const{_state:$}=this;if("Captured"!==$.type){if("Ready"===$.type)return void $t.warn("Scrub is empty. Nothing to commit.");throw"Committed"===$.type?new Error("This scrub is already committed."):new Error("This scrub is already discarded and can't be comitted.")}$.transaction.commit(),$.flagsTransaction.discard(),this._state={type:"Committed"}}capture($){if("Captured"===this._state.type&&this.reset(),"Ready"!==this._state.type)throw"Committed"===this._state.type?new Error("This scrub is already committed and cannot capture again.If you wish to capture more, you can start a new studio.scrub() or do so before scrub.commit()"):new Error("This scrub is already discarded and cannot capture again.If you wish to capture more, you can start a new studio.scrub() or do so before scrub.discard()");{let W=!0;try{this._state=__spreadValues({type:"Captured"},this._capture($)),W=!1}finally{W&&(this._state={type:"Discarded"})}}}_capture($){const W=[];return{transaction:this._studio.tempTransaction((G=>{let oe=!0;const ae={set:($,ae)=>{if(!oe)throw new Error("You seem to have called the scrub api after scrub.capture()");const{root:ie,path:se}=(0,At.getPointerParts)($);if(!Bt(ie))throw new Error("We can only scrub props of Sheet Objects for now");G.set($,ae),W.push($)}};try{$(ae)}finally{oe=!1}})),flagsTransaction:this._studio.tempTransaction((({stateEditors:$})=>{W.forEach((W=>{const{root:G,path:oe}=(0,At.getPointerParts)(W);Bt(G)&&forEachDeep(G.template.getDefaultsAtPointer(W),((W,oe)=>{$.studio.ephemeral.projects.stateByProjectId.stateBySheetId.stateByObjectKey.propsBeingScrubbed.flag(__spreadProps(__spreadValues({},G.address),{pathToProp:oe}))}),oe)}))}))}}discard(){const{_state:$}=this;if("Captured"!==$.type&&"Ready"!==$.type)throw"Committed"===$.type?new Error("This scrub is already committed and can't be discarded."):new Error("This scrub is already discarded");"Captured"===$.type&&($.transaction.discard(),$.flagsTransaction.discard()),this._state={type:"Discarded"}}}(this)}tempTransaction($){return this._store.tempTransaction($)}transaction($){return this.tempTransaction($).commit()}__dev_startHistoryFromScratch($){return this._store.__dev_startHistoryFromScratch($)}get corePrivateAPI(){return this._corePrivateApi}get core(){return this._coreAtom.getState().core}get coreP(){return this._coreAtom.pointer.core}extend($){if(!$||"object"!=typeof $)throw new Error("Extensions must be JS objects");if("string"!=typeof $.id)throw new Error("extension.id must be a string");this.transaction((({drafts:W})=>{var G;if(W.ephemeral.extensions.byId[$.id])throw new Error(`Extension id "${$.id}" is already defined`);W.ephemeral.extensions.byId[$.id]=$;const oe=W.ephemeral.extensions.paneClasses;null==(G=$.panes)||G.forEach((W=>{if("string"!=typeof W.class)throw new Error("pane.class must be a string");if(W.class.length<3)throw new Error("pane.class should be a string with 3 or more characters");const G=oe[W.class];if(G)throw new Error(`Pane class "${W.class}" already exists and is supplied by extension ${G}`);oe[W.class]={extensionId:$.id,classDefinition:W}}))}))}getStudioProject($){return this._cache.get("getStudioProject",(()=>$.getProject("Studio")))}getExtensionSheet($,W){return this._cache.get("extensionSheet-"+$,(()=>this.getStudioProject(W).sheet("Extension "+$)))}undo(){this._store.undo()}redo(){this._store.redo()}createContentOfSaveFile($){return this._store.createContentOfSaveFile($)}};!function setStudio($){oe=$}(ax);var ix=ax.publicApi;!function registerStudioBundle(){if("undefined"==typeof window)return;const $=window[QS];if(void 0!==$)throw"object"==typeof $&&$&&"string"==typeof $.version?new Error("It seems that the module '@theatre/studio' is loaded more than once. This could have two possible causes:\n1. You might have two separate versions of theatre in node_modules.\n2. Or this might be a bundling misconfiguration, in case you're using a bundler like Webpack/ESBuild/Rollup.\n\nNote that it **is okay** to import '@theatre/studio' multiple times. But those imports should point to the same module."):new Error(`The variable window.${QS} seems to be already set by a module other than @theatre/core.`);const W=new class{constructor($){this._studio=$,__publicField(this,"_coreBundle")}get type(){return"Theatre_StudioBundle"}registerCoreBundle($){if(this._coreBundle)throw new Error("StudioBundle.coreBundle is already registered. This is a bug.");let W;this._coreBundle=$,$.getBitsForStudio(this._studio,($=>{W=$})),this._studio.setCoreBits(W)}}(ax);window[QS]=W;const G=window.__TheatreJS_CoreBundle;G&&null!==G&&"Theatre_CoreBundle"===G.type&&W.registerCoreBundle(G)}
/*! queue-microtask. MIT License. Feross Aboukhadijeh <https://feross.org/opensource> */
/**
	 * @license
	 * Lodash (Custom Build) <https://lodash.com/>
	 * Build: `lodash modularize exports="es" -o ./`
	 * Copyright OpenJS Foundation and other contributors <https://openjsf.org/>
	 * Released under MIT license <https://lodash.com/license>
	 * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>
	 * Copyright Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
	 */
/** @license MIT License (c) copyright 2010-2014 original author or authors */()}(gt,gt.exports);var gu=getDefaultExportFromCjs(gt.exports);window.getProject=$.getProject,window.studio=gu,window.t=$.types}();var Animator=pc.createScript("animator");Animator.prototype.initialize=function(){this.decollage=!1,window.scriptOnOff("Camera","flyCamera",0);const e=this.app.root.findByName("thx-bb-cuteliltune"),i=this.app.root.findByName("Camera"),o=new pc.Quat;studio.initialize(),studio.ui.hide();const n=this.app.assets.find("animation.json").resource;this.proj=getProject("Anim1",{state:n}),this.sheet=this.proj.sheet("sheet1"),this.start=!0,this.app.on("startAnim1",this.startAnim1,this);const getPropVec3=e=>({x:t.number(0,{nudgeMultiplier:e}),y:t.number(0,{nudgeMultiplier:e}),z:t.number(0,{nudgeMultiplier:e})}),s=this.sheet.object("Camera",{position:getPropVec3(.1),rotation:getPropVec3(.2),visible:!0});this.sheet.object("txtIntro",{position:getPropVec3(.1),rotation:getPropVec3(.2),visible:!0}).onValuesChange((function pAnimText1OnChange(t){const i=t.position,n=t.rotation;e.setPosition(i.x,i.y,i.z),o.setFromEulerAngles(n.x,n.y,n.z),e.setLocalRotation(o)})),s.onValuesChange((function cameraOnChange(t){const e=t.position,n=t.rotation;i.setPosition(e.x,e.y,e.z),o.setFromEulerAngles(n.x,n.y,n.z),i.setLocalRotation(o)})),console.log("\n              SPACE BAR : plays animation\n              C : enable  disable flyCamera\n              X : SHOW / HIDE theatreJS UI "),this.app.keyboard.on(pc.EVENT_KEYDOWN,(function onKey(t){if(t.key===pc.KEY_SPACE&&(this.sheet.sequence.position=0,this.sheet.sequence.play()),t.key===pc.KEY_C){var e=i.script.flyCamera;1==e.enabled?e.enabled=!1:e.enabled=!0}t.key===pc.KEY_X&&(studio.ui.isHidden?studio.ui.restore():studio.ui.hide())}),this)},Animator.prototype.startAnim1=function(){!0===this.start&&(console.log("(animation.js) : startAnim1"),this.start=!1),this.proj.ready.then((()=>this.sheet.sequence.play()))},Animator.prototype.update=function(t){console.log(this.sheet.sequence.position),this.sheet.sequence.position>135&&!this.decollage&&(this.decollage=!0,this.app.fire("decollage"))};var Animintro=pc.createScript("animintro");Animintro.prototype.initialize=function(){const e=this.app.root.findByName("flower"),o=this.app.root.findByName("bee"),i=this.app.root.findByName("betext"),n=this.app.assets.find("animintro.json").resource,s=getProject("intro",{state:n}),a=s.sheet("introscene"),getPropVec3=e=>({x:t.number(0,{nudgeMultiplier:e}),y:t.number(0,{nudgeMultiplier:e}),z:t.number(0,{nudgeMultiplier:e})}),r=a.object("Flower",{position:getPropVec3(.1),rotation:getPropVec3(.2),visible:!0}),l=a.object("Bee",{position:getPropVec3(.01),rotation:getPropVec3(.01),scale:getPropVec3(.01),visible:!0}),c=a.object("Be",{position:getPropVec3(.01),rotation:getPropVec3(.01),scale:getPropVec3(.01),visible:!0}),u=new pc.Quat;r.onValuesChange((function cameraOnChange(t){const o=t.position,i=t.rotation;e.setPosition(o.x,o.y,o.z),u.setFromEulerAngles(i.x,i.y,i.z),e.setLocalRotation(u)})),l.onValuesChange((function beeOnChange(t){const e=t.position,i=t.rotation;o.setPosition(e.x,e.y,e.z),u.setFromEulerAngles(i.x,i.y,i.z),o.setLocalRotation(u)})),c.onValuesChange((function beOnChange(t){const e=t.position,o=t.rotation;i.setPosition(e.x,e.y,e.z),u.setFromEulerAngles(o.x,o.y,o.z),i.setLocalRotation(u)})),studio.initialize(),studio.ui.hide(),a.sequence.position=0,s.ready.then((()=>a.sequence.play()))};var Anim2=pc.createScript("anim2");Anim2.prototype.initialize=function(){const e=this.app.root.findByName("Camera2"),i=this.app.assets.find("anim2.json").resource,n=getProject("cam2",{state:i}),o=n.sheet("camera2"),getPropVec3=e=>({x:t.number(0,{nudgeMultiplier:e}),y:t.number(0,{nudgeMultiplier:e}),z:t.number(0,{nudgeMultiplier:e})}),a=o.object("Camera2",{position:getPropVec3(.1),rotation:getPropVec3(.2),visible:!0}),s=new pc.Quat;a.onValuesChange((function cameraOnChange(t){const i=t.position,n=t.rotation;e.setPosition(i.x,i.y,i.z),s.setFromEulerAngles(n.x,n.y,n.z),e.setLocalRotation(s)})),studio.initialize(),studio.ui.hide(),o.sequence.position=0,n.ready.then((()=>o.sequence.play()))};var Son=pc.createScript("son");Son.prototype.initialize=function(){this.app.on("sounds:stopAll",(function(){this.entity.sound.stop()}),this)},Son.prototype.update=function(t){};!function(t,i){"use strict";
/*! *****************************************************************************
    Copyright (c) Microsoft Corporation.

    Permission to use, copy, modify, and/or distribute this software for any
    purpose with or without fee is hereby granted.

    THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
    REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
    AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
    INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
    LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
    OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
    PERFORMANCE OF THIS SOFTWARE.
    ***************************************************************************** */var extendStatics=function(t,i){return extendStatics=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,i){t.__proto__=i}||function(t,i){for(var e in i)Object.prototype.hasOwnProperty.call(i,e)&&(t[e]=i[e])},extendStatics(t,i)};function rotateHue(t,i){var e=Math.cos(i*Math.PI/180),s=Math.sin(i*Math.PI/180),a=e+(1-e)/3,o=(1-e)/3-Math.sqrt(1/3)*s,n=(1-e)/3+Math.sqrt(1/3)*s,r=t.r*a+t.g*o+t.b*n,h=t.r*n+t.g*a+t.b*o,l=t.r*o+t.g*n+t.b*a;t.r=r,t.g=h,t.b=l}var e=new i.Color,s=function(t){function WaterfallDisplay(){var e=null!==t&&t.apply(this,arguments)||this;return e.material=new i.StandardMaterial,e.graphNode=new i.GraphNode,e.binVector=new i.Vec3,e.quat=new i.Quat,e}return function __extends(t,i){function __(){this.constructor=t}extendStatics(t,i),t.prototype=null===i?Object.create(i):(__.prototype=i.prototype,new __)}(WaterfallDisplay,t),WaterfallDisplay.prototype.initialize=function(){var t=this;this.on("attr:fftSize",(function(){t.analyzerNode.fftSize=t.fftSize,t.binCount=t.analyzerNode.frequencyBinCount,t.reset()})),this.on("attr:smoothingTimeConstant",(function(){t.analyzerNode.smoothingTimeConstant=t.smoothingTimeConstant})),this.on("attr:length",(function(){t.length%1!=0&&(t.length=Math.floor(t.length)),t.reset()})),this.ctx=this.app.systems.sound.context,this.analyzerNode=this.ctx.createAnalyser(),this.analyzerNode.fftSize=this.fftSize,this.analyzerNode.smoothingTimeConstant=this.smoothingTimeConstant,this.materialAsset&&(this.material=this.materialAsset.resource),this.reset()},WaterfallDisplay.prototype.update=function(t){if(this.cycleColors&&(rotateHue(this.colorMax,-50*t),rotateHue(this.colorMin,-50*t)),this.active){if(this.addWindow(),1!==this.fadeDecay)for(var i=0;i<this.colors.length/4;i++)this.colors[4*i+3]*=this.fadeDecay;for(i=this.binCount;i<this.vertices.length/3;i++)this.vertices[3*i+0]+=this.velocity.x,this.vertices[3*i+1]+=this.velocity.y,this.vertices[3*i+2]+=this.velocity.z;this.updateMesh()}},WaterfallDisplay.prototype.play=function(t){var i,e;this.active||(this.active=!0),this.entity.sound.stop(),this.playbackInstance=this.entity.sound.play(t),null===(e=null===(i=this.playbackInstance)||void 0===i?void 0:i._connectorNode)||void 0===e||e.connect(this.analyzerNode)},WaterfallDisplay.prototype.stop=function(){this.entity.sound.stop()},WaterfallDisplay.prototype.reset=function(){var t,i;this.binCount=this.analyzerNode.frequencyBinCount,null===(i=null===(t=this.playbackInstance)||void 0===t?void 0:t._connectorNode)||void 0===i||i.connect(this.analyzerNode);var e=this.binCount*this.length;this.fftWindowData=new Float32Array(this.binCount),this.bins=new Float32Array(e),this.vertices=new Float32Array(3*e),this.uvs=new Float32Array(2*e),this.colors=new Float32Array(4*e).fill(1,0,4*e),this.calculateUvs(),this.calculateTriangles(),this.createMeshInstance()},WaterfallDisplay.prototype.addWindow=function(){this.analyzerNode.getFloatFrequencyData(this.fftWindowData);for(var t=this.fftWindowData.length,i=0;i<this.fftWindowData.length;i++)this.fftWindowData[i]=(this.fftWindowData[i]+148+this.gain)/148,this.fftWindowData[i]*=this.amp;for(i=this.bins.length-1-t;i>=0;i--)this.bins[i+t]=this.bins[i];for(i=this.colors.length-1-4*t;i>=0;i--)this.colors[i+4*t]=this.colors[i];for(i=this.vertices.length-1-3*t;i>=0;i--)this.vertices[i+3*t]=this.vertices[i];for(i=0;i<t;i++)this.bins[i]=this.fftWindowData[i];for(i=0;i<t;i++){switch(e.set(0,0,0,0),this.colorMode){case"amp":e.lerp(this.colorMin,this.colorMax,Math.max(0,Math.min(1,this.fftWindowData[i]/this.amp)));break;case"freq":e.lerp(this.colorMin,this.colorMax,Math.max(0,i/t))}this.colors[4*i+0]=e.r,this.colors[4*i+1]=e.g,this.colors[4*i+2]=e.b,this.colors[4*i+3]=e.a}this.quat.setFromEulerAngles(this.rotation.x,this.rotation.y,this.rotation.z);for(i=0;i<t;i++){var s=this.width/t;this.binVector.x=i*s-this.width/2,this.binVector.y=Math.max(0,this.fftWindowData[i]),this.binVector.z=0,this.quat.transformVector(this.binVector,this.binVector),this.vertices[3*i+0]=this.binVector.x+this.position.x,this.vertices[3*i+1]=this.binVector.y+this.position.y,this.vertices[3*i+2]=this.binVector.z+this.position.z}},WaterfallDisplay.prototype.updateMesh=function(t){void 0===t&&(t=!1),this.mesh.setPositions(this.vertices),this.mesh.setColors(this.colors),this.mesh.setNormals(i.calculateNormals(this.vertices,this.triangles)),t&&(this.mesh.setUvs(0,this.uvs),this.mesh.setIndices(this.triangles)),this.mesh.update(i.PRIMITIVE_TRIANGLES)},WaterfallDisplay.prototype.createMeshInstance=function(){this.mesh=new i.Mesh(this.app.graphicsDevice),this.mesh.clear(!0,!0),this.updateMesh(!0),this.graphNode=new i.GraphNode,this.meshInstance=new i.MeshInstance(this.graphNode,this.mesh,this.material),this.meshInstance.renderStyle=i.RENDERSTYLE_SOLID,this.entity.model||this.entity.addComponent("model");var t=new i.Model;t.graph=this.graphNode,t.meshInstances=[this.meshInstance],this.entity.model.model=t},WaterfallDisplay.prototype.calculateUvs=function(){for(var t=0;t<this.length;t++)for(var i=0;i<this.binCount;i++){var e=i+t*this.binCount;this.uvs[2*e]=i/this.binCount,this.uvs[2*e+1]=1-t/this.length}},WaterfallDisplay.prototype.calculateTriangles=function(){this.triangles=[];for(var t=0;t<this.binCount-1;t++)for(var i=0;i<this.length-1;i++)this.triangles.push(t+1+i*this.binCount,t+(i+1)*this.binCount,t+i*this.binCount,t+(i+1)*this.binCount,t+1+i*this.binCount,t+1+(i+1)*this.binCount)},WaterfallDisplay}(i.ScriptType);i.registerScript(s,"waterfallDisplay"),s.attributes.add("active",{description:"Curently recording FFT windows.",title:"Active",default:!0,type:"boolean"}),s.attributes.add("fftSize",{description:"The fftSize property of the AnalyserNode interface is an unsigned long value and represents the window size in samples that is used when performing a Fast Fourier Transform (FFT) to get frequency domain data.",title:"FFT Size",type:"number",enum:[{32:32},{64:64},{128:128},{256:256},{512:512},{1024:1024},{2048:2048},{4096:4096}],default:256}),s.attributes.add("position",{description:"Spawn point for new windows.",title:"Position",type:"vec3",default:[0,0,0]}),s.attributes.add("rotation",{description:"Spawn rotation.",title:"Rotation",type:"vec3",default:[0,0,0]}),s.attributes.add("velocity",{description:"Static velocity.",title:"Velocity",type:"vec3",default:[0,0,0]}),s.attributes.add("smoothingTimeConstant",{description:"The smoothingTimeConstant property of the AnalyserNode interface is a double value representing the averaging constant with the last analysis frame.",title:"Smoothing",type:"number",default:.7,min:0,max:1}),s.attributes.add("width",{description:"Trail width extent.",title:"Width",type:"number",default:1,min:0,max:64}),s.attributes.add("amp",{description:"Mesh Z axis extent.",title:"Amp",type:"number",default:1,min:.01,max:10}),s.attributes.add("gain",{description:"Gain gain applid to visualization.",title:"Gain",type:"number",default:0,min:-48,max:48}),s.attributes.add("length",{description:"The number of FFT windows stored from previous updates.",title:"Length",type:"number",default:128,min:1,max:256,precision:.1}),s.attributes.add("fadeDecay",{description:"Animate fade.",title:"Fade Decay",type:"number",default:.97,min:.9,max:1}),s.attributes.add("colorMax",{description:"Vertice color (max).",title:"Color Max",type:"rgba",default:[1,0,0,1]}),s.attributes.add("colorMin",{description:"Vertice color (min).",title:"Color Min",type:"rgba",default:[0,1,0,1]}),s.attributes.add("cycleColors",{description:"Easter egg.",title:"Cycle Color",type:"boolean",default:!1}),s.attributes.add("colorMode",{description:"",title:"Color Mode",type:"string",enum:[{Amp:"amp"},{Frequency:"freq"}],default:"amp"}),s.attributes.add("materialAsset",{description:"Material asset.",title:"Material",type:"asset"}),t.WaterfallDisplay=s}(this.pc=this.pc||{},pc);var PetalVortex=pc.createScript("petalVortex");PetalVortex.attributes.add("petalModel",{type:"entity",title:"Petal Model"}),PetalVortex.attributes.add("numberOfPetals",{type:"number",default:100,title:"Number of Petals"}),PetalVortex.attributes.add("vortexSpeed",{type:"number",default:1,title:"Vortex Speed"}),PetalVortex.attributes.add("radius",{type:"number",default:5,title:"Radius of Vortex"}),PetalVortex.prototype.initialize=function(){this.petals=[];for(let r=0;r<this.numberOfPetals;r++){var t=this.petalModel.clone();this.entity.addChild(t),this.petals.push(t);var e=Math.random()*Math.PI*2,a=Math.cos(e)*this.radius,i=Math.random()*this.radius*2-this.radius,s=Math.sin(e)*this.radius;t.setLocalPosition(a,i,s)}},PetalVortex.prototype.update=function(t){this.petals.forEach((function(e){var a=e.getLocalPosition();a.x+=Math.cos(a.y)*t*this.vortexSpeed,a.z+=Math.sin(a.y)*t*this.vortexSpeed,a.y-=t*this.vortexSpeed,a.y<-this.radius&&(a.y=this.radius),e.setLocalPosition(a.x,a.y,a.z)}),this)};var FlyCamera=pc.createScript("flyCamera");FlyCamera.attributes.add("speed",{type:"number",default:10}),FlyCamera.attributes.add("fastSpeed",{type:"number",default:20}),FlyCamera.attributes.add("mode",{type:"number",default:0,enum:[{Lock:0},{Drag:1}]}),FlyCamera.prototype.initialize=function(){var e=this.entity.getLocalEulerAngles();this.ex=e.x,this.ey=e.y,this.moved=!1,this.lmbDown=!1,this.app.mouse.disableContextMenu(),this.app.mouse.on(pc.EVENT_MOUSEMOVE,this.onMouseMove,this),this.app.mouse.on(pc.EVENT_MOUSEDOWN,this.onMouseDown,this),this.app.mouse.on(pc.EVENT_MOUSEUP,this.onMouseUp,this)},FlyCamera.prototype.update=function(e){this.entity.setLocalEulerAngles(this.ex,this.ey,0);var t=this.app,s=this.speed;t.keyboard.isPressed(pc.KEY_SHIFT)&&(s=this.fastSpeed),t.keyboard.isPressed(pc.KEY_UP)||t.keyboard.isPressed(pc.KEY_W)?this.entity.translateLocal(0,0,-s*e):(t.keyboard.isPressed(pc.KEY_DOWN)||t.keyboard.isPressed(pc.KEY_S))&&this.entity.translateLocal(0,0,s*e),t.keyboard.isPressed(pc.KEY_LEFT)||t.keyboard.isPressed(pc.KEY_A)?this.entity.translateLocal(-s*e,0,0):(t.keyboard.isPressed(pc.KEY_RIGHT)||t.keyboard.isPressed(pc.KEY_D))&&this.entity.translateLocal(s*e,0,0)},FlyCamera.prototype.onMouseMove=function(e){if(this.mode){if(!this.lmbDown)return}else if(!pc.Mouse.isPointerLocked())return;this.moved?(this.ex-=e.dy/5,this.ex=pc.math.clamp(this.ex,-90,90),this.ey-=e.dx/5):this.moved=!0},FlyCamera.prototype.onMouseDown=function(e){0===e.button&&(this.lmbDown=!0,this.mode||pc.Mouse.isPointerLocked()||this.app.mouse.enablePointerLock())},FlyCamera.prototype.onMouseUp=function(e){0===e.button&&(this.lmbDown=!1)};var BlackBarsController=pc.createScript("blackBarsController");BlackBarsController.prototype.distanceFromCamera=3,BlackBarsController.attributes.add("topBar",{type:"entity",title:"Top Bar"}),BlackBarsController.attributes.add("bottomBar",{type:"entity",title:"Bottom Bar"}),BlackBarsController.prototype.initialize=function(){this.removing=!1,this.cameraEntity=this.app.root.findByName("Camera"),this.app.on("removeBars",this.removeBars,this),this.positionBlackBars()},BlackBarsController.prototype.positionBlackBars=function(){var t=this.cameraEntity.getPosition(),o=this.cameraEntity.forward.clone().scale(this.distanceFromCamera),a=t.clone().add(o).add(new pc.Vec3(0,1.75,0)),r=t.clone().add(o).add(new pc.Vec3(0,-1.8,0));this.topBar.setPosition(a),this.bottomBar.setPosition(r),this.topBar.lookAt(t),this.bottomBar.lookAt(t)};var compteur=0;BlackBarsController.prototype.update=function(t){var o=-t;compteur+=.2*t;var a=this.topBar.render.material;this.removing?(this.topBar.translateLocal(0,.2*t,0),a.opacity=Math.max(0,o),a.update(),this.bottomBar.translateLocal(0,.2*-t,0)):this.positionBlackBars(),compteur>=3&&window.entityDisable("bandes_intro","(blackBarsController.js)")},BlackBarsController.prototype.removeBars=function(){console.log("(blackBarsController.js) : removingBars"),this.removing=!0};var PlaceInFrontOfCamera=pc.createScript("placeInFrontOfCamera");PlaceInFrontOfCamera.prototype.isFadingOut=!1,PlaceInFrontOfCamera.prototype.fadeDuration=2,PlaceInFrontOfCamera.prototype.fadeTimer=0,PlaceInFrontOfCamera.prototype.distanceFromCamera=2,PlaceInFrontOfCamera.attributes.add("delayInSeconds",{type:"number",default:13,title:"Delay Before Event (Seconds)"}),PlaceInFrontOfCamera.attributes.add("barEntity",{type:"entity",title:"Bar Entity"}),PlaceInFrontOfCamera.prototype.timer=0,PlaceInFrontOfCamera.prototype.initialize=function(){console.log("(placeInFrontOfCamera.js) : godRays = 0"),window.scriptOnOff("soleil","godRays",0),this.startAnim=!0,this.removeBars=!0,this.cameraEntity=this.app.root.findByName("Camera"),this.timer=this.delayInSeconds,this.positionBar(),setTimeout((()=>{this.startFadeOut()}),5e3)},PlaceInFrontOfCamera.prototype.startFadeOut=function(){this.isFadingOut=!0,this.fadeTimer=this.fadeDuration},PlaceInFrontOfCamera.prototype.updateFadeOut=function(t){if(this.isFadingOut)if(this.fadeTimer>0){this.fadeTimer-=t;var a=this.fadeTimer/this.fadeDuration;this.setOpacity(a)}else this.isFadingOut=!1},PlaceInFrontOfCamera.prototype.setOpacity=function(t){var a=this.barEntity.model.material;a.opacity=t,a.blendType=pc.BLEND_NORMAL,a.update()},PlaceInFrontOfCamera.prototype.positionBar=function(){var t=this.cameraEntity.getPosition(),a=this.cameraEntity.forward.clone().scale(this.distanceFromCamera),e=t.clone().add(a);this.barEntity.setPosition(e),this.barEntity.lookAt(t)},PlaceInFrontOfCamera.prototype.update=function(t){this.timer>0&&(this.timer-=t,this.timer<=11&&!0===this.startAnim&&(console.log("(placeInFrontOfCamera.js) => startAnim1"),this.app.fire("startAnim1"),this.startAnim=!1),this.timer<=1.5&&!0===this.removeBars&&(console.log("(placeInFrontOfCamera.js) => removeBars"),this.app.fire("removeBars"),this.removeBars=!1),this.timer<=0&&(console.log("(placeInFrontOfCamera.js) : godRays = 1"),window.scriptOnOff("soleil","godRays",1))),this.cameraEntity&&this.positionBar(),this.updateFadeOut(t)};var Utils=pc.createScript("utils");Utils.prototype.initialize=function(){window.scriptOnOff=this.scriptOnOff.bind(this),window.entityDisable=this.entityDisable.bind(this)},Utils.prototype.scriptOnOff=function(t,i,n){var o=this.app.root.findByName(t);o?o.script&&o.script.hasOwnProperty(i)?o.script[i].enabled=1===n:console.warn('Script "'+i+'" not found on entity "'+t+'".'):console.warn('Entity "'+t+'" not found.')},Utils.prototype.entityDisable=function entitySet(t,i){var n=this.app.root.findByName(t);""==i&&(i="inconnu"),n?(n.enabled=!1,console.log(i+" => "+t+" : désactivé")):console.warn('Entité nommée "'+t+'" non trouvée.')};var Instancer=pc.createScript("instancer");Instancer.attributes.add("sourceTemplate",{type:"asset",assetType:"template"}),Instancer.attributes.add("randomiseTransforms",{type:"boolean",default:!1,title:"Randomise Transforms"}),Instancer.attributes.add("instances",{type:"json",title:"Instances",schema:[{name:"id",type:"string"},{name:"position",type:"vec3"},{name:"rotation",type:"vec3"},{name:"scale",type:"vec3"}],array:!0}),Instancer.prototype.initialize=function(){this.rotation=new pc.Quat,this.matrix=new pc.Mat4,this.matrixIndex=0,this.sourceTemplateInstance=null,this.assetListLoader=void 0,this.on("attr:instances",this.render,this),this.on("attr:randomiseTransforms",this.render,this)},Instancer.prototype.postInitialize=function(){this.render()},Instancer.prototype.verifyInstances=function(){for(let t=0;t<this.instances.length;t++)this.instances[t].id||(this.instances[t].id=`${this.entity.name}-${t}`)},Instancer.prototype.getAllInstanceIds=function(){let t=[];for(const e of this.instances)t.push(e.id);return t},Instancer.prototype.fullyLoadtemplate=function(t,e,s){console.log(`Instantiating the source Template for: ${t.name}`),this.app.assets.load(t),t.ready((()=>{this.sourceTemplateInstance=t.resource.instantiate(),this.entity.addChild(this.sourceTemplateInstance);const n=[];for(const t of this.sourceTemplateInstance.findComponents("render")){const e=this.app.assets.getAssetById(t.asset);n.push(e),e?.data?.containerAsset&&n.push(e.data.containerAsset)}this.assetListLoader=new pc.AssetListLoader(n,this.app.assets),this.assetListLoader.load(((t,a)=>{t?(console.error(`${a.length} assets failed to load`),s()):(console.log(`${n.length} assets loaded`),e())}))}))},Instancer.prototype.render=function(t){this.verifyInstances(),null!==this.sourceTemplateInstance?this.app.graphicsDevice.supportsInstancing?this.renderHardwareInstanced():this.renderPcEntity():this.fullyLoadtemplate(this.sourceTemplate,(()=>{this.render()}),(()=>{console.log(`Something went wrong while attempting to load template: ${this.sourceTemplate.name}`)}))},Instancer.prototype.renderHardwareInstanced=function(){console.log(`Hardware Instancing for: ${this.entity.name}`);const t=this.instances.length,e=new Float32Array(16*t);this.matrixIndex=0;for(const t of this.instances){!0===this.randomiseTransforms&&(t.position.set(500*Math.random(),1,2e3*Math.random()),t.rotation.set(50*Math.random(),50*Math.random(),50*Math.random()),t.scale.set(50*Math.random(),50*Math.random(),50*Math.random())),this.rotation.setFromEulerAngles(t.rotation),this.matrix.setTRS(t.position,this.rotation,this.entity.getLocalScale()),console.log(this.matrix);for(let t=0;t<16;t++)e[this.matrixIndex++]=this.matrix.data[t]}const s=new pc.VertexBuffer(this.app.graphicsDevice,pc.VertexFormat.getDefaultInstancingFormat(this.app.graphicsDevice),t,pc.BUFFER_DYNAMIC,e),n=this.entity.findComponents("render");for(const t of n)for(const e of t.meshInstances)e.setInstancing(s)},Instancer.prototype.renderPcEntity=function(){console.log("Rendering PC entity")};var DistributeVegetation=pc.createScript("distributeVegetation");DistributeVegetation.attributes.add("templateAsset",{type:"asset",assetType:"template",title:"Template Asset"}),DistributeVegetation.attributes.add("height",{type:"number",default:0,title:"Height"}),DistributeVegetation.attributes.add("count",{type:"number",default:100,title:"Count"}),DistributeVegetation.attributes.add("areaSize",{type:"vec2",default:[100,100],title:"Area Size"}),DistributeVegetation.prototype.initialize=function(){for(let a=0;a<this.count;a++){var t=this.templateAsset.resource.instantiate(),e=(Math.random()-.5)*this.areaSize.x,i=(Math.random()-.5)*this.areaSize.y;t.setLocalPosition(e,this.height,i),this.app.root.addChild(t)}};var DistributeOnPlane=pc.createScript("distributeOnPlane");DistributeOnPlane.attributes.add("template",{type:"asset",assetType:"template"}),DistributeOnPlane.attributes.add("rows",{type:"number",default:5}),DistributeOnPlane.attributes.add("columns",{type:"number",default:5}),DistributeOnPlane.prototype.initialize=function(){this.distributeObjects()},DistributeOnPlane.prototype.distributeObjects=function(){for(var t=this.entity.getLocalScale(),e=0;e<this.rows;e++)for(var i=0;i<this.columns;i++){var s=this.template.resource.instantiate();this.app.root.addChild(s);var a=(e-(this.rows-1)/2)*(t.x/this.rows),r=(i-(this.columns-1)/2)*(t.z/this.columns);s.setLocalPosition(a,0,r)}};var TemplateDistributor=pc.createScript("templateDistributor");TemplateDistributor.attributes.add("template",{type:"asset",assetType:"template",title:"Template"}),TemplateDistributor.attributes.add("instanceCount",{type:"number",default:10,title:"Instance Count"}),TemplateDistributor.prototype.initialize=function(){for(var t=this.entity.model.meshInstances[0].aabb.halfExtents,e=2*t.x,a=2*t.z,i=e/Math.sqrt(this.instanceCount),s=a/Math.sqrt(this.instanceCount),r=0;r<Math.sqrt(this.instanceCount);r++)for(var n=0;n<Math.sqrt(this.instanceCount);n++){var o=this.template.resource.instantiate();this.app.root.addChild(o);var p=r*i-e/2+i/2,l=n*s-a/2+s/2;o.setLocalPosition(p,0,l)}};var Motion=pc.createScript("motion");Motion.attributes.add("motions",{type:"json",schema:[{name:"name",type:"string"},{name:"position",type:"curve",curves:["x","y","z"]},{name:"rotation",type:"curve",curves:["x","y","z"]},{name:"scale",type:"curve",curves:["x","y","z"]},{name:"speed",type:"number",default:1},{name:"autoplay",type:"boolean",default:!1},{name:"loop",type:"boolean",default:!1}],array:!0}),Motion.attributes.add("events",{type:"json",schema:[{name:"animationName",type:"string"},{name:"eventName",type:"string"},{name:"time",type:"number",default:1},{name:"type",type:"string",default:"Anytime",enum:[{Anytime:"Anytime"},{Start:"Start"},{End:"End"}]}],array:!0}),Motion.attributes.add("lerp",{type:"number",default:.5}),Motion.prototype.initialize=function(){this.timestamp=0,this.currentSpeed=0,this.currentMotion=!1,this.isReverting=!1,this.startPosition=this.entity.getLocalPosition().clone(),this.startRotation=this.entity.getLocalEulerAngles().clone(),this.startScale=this.entity.getLocalScale().clone(),this.position=new pc.Vec3(0,0,0),this.rotation=new pc.Vec3(0,0,0),this.scale=new pc.Vec3(0,0,0),this.motions.length>0&&this.motions[0].autoplay&&this.onMotionPlay(this.motions[0].name),this.app.on("Motion",this.onMotionPlay,this),this.app.on("Motion:Stop",this.onMotionStop,this),this.entity.on("Motion",this.onMotionPlay,this),this.entity.on("Motion:Stop",this.onMotionStop,this)},Motion.prototype.findMotion=function(t){var i=!1;for(var n in this.motions){var e=this.motions[n];e.name==t&&(i=e)}return i},Motion.prototype.onMotionStop=function(t){this.currentMotion&&this.currentMotion.name==t&&(this.isPlaying=!1,this.currentMotion=!1)},Motion.prototype.onMotionPlay=function(t,i){if(!i&&this.currentMotion&&this.currentMotion.name==t)return!1;var n=this.findMotion(t);if(!n)return!1;this.isPlaying=!0,this.timestamp=0,this.currentMotion=n,this.triggerStartEvent(this.currentMotion)},Motion.prototype.triggerEvents=function(t){for(var i in this.events){var n=this.events[i],e=n.time;n.animationName==this.currentMotion.name&&e>this.timestamp&&e<=this.timestamp+t&&this.app.fire(n.eventName)}},Motion.prototype.findEventByMotion=function(t,i){for(var n in this.events){var e=this.events[n];if(e.animationName==t.name&&e.type==i)return e}},Motion.prototype.triggerStartEvent=function(t){var i=this.findEventByMotion(t,"Start");i&&this.app.fire(i.eventName)},Motion.prototype.triggerEndEvent=function(t){var i=this.findEventByMotion(t,"End");i&&this.app.fire(i.eventName)},Motion.prototype.update=function(t){if(!this.isPlaying)return!1;if(!this.currentMotion)return!1;var i=this.currentMotion.position.value(this.timestamp),n=this.currentMotion.rotation.value(this.timestamp),e=this.currentMotion.scale.value(this.timestamp);this.position=this.position.lerp(this.position,new pc.Vec3(i[0],i[1],i[2]),this.lerp),this.rotation=this.rotation.lerp(this.rotation,new pc.Vec3(n[0],n[1],n[2]),this.lerp),this.scale=this.scale.lerp(this.scale,new pc.Vec3(e[0],e[1],e[2]),this.lerp),this.entity.setLocalPosition(this.position.clone().add(this.startPosition)),this.entity.setLocalEulerAngles(this.rotation.clone().add(this.startRotation)),this.entity.setLocalScale(this.scale.clone().add(this.startScale)),this.triggerEvents(t),this.timestamp>=1&&(this.isPlaying=!1,this.currentMotion.loop?this.onMotionPlay(this.currentMotion.name,!0):(this.triggerEndEvent(this.currentMotion),this.currentMotion=!1)),this.isReverting?(this.timestamp-=t*this.currentMotion.speed,this.timestamp<=0&&(this.triggerEndEvent(this.currentMotion),this.currentMotion=!1,this.isPlaying=!1,this.isReverting=!1)):this.timestamp+=t*this.currentMotion.speed,this.timestamp=Math.max(this.timestamp,0),this.timestamp=Math.min(this.timestamp,1)};var BubbleEffect=pc.createScript("bubbleEffect");BubbleEffect.attributes.add("bubbleTemplate",{type:"entity"}),BubbleEffect.attributes.add("bubbleCount",{type:"number",default:10}),BubbleEffect.attributes.add("riseSpeed",{type:"number",default:.5}),BubbleEffect.prototype.initialize=function(){this.generateBubbles()},BubbleEffect.prototype.generateBubbles=function(){for(var e=0;e<this.bubbleCount;e++){var t=this.bubbleTemplate.clone();t.enabled=!0,t.setLocalPosition(pc.math.random(-1,1),pc.math.random(-2,0),pc.math.random(-1,1)),this.entity.addChild(t),this.animateBubble(t)}},BubbleEffect.prototype.animateBubble=function(e){var t=e.getLocalPosition(),b=new pc.Vec3(t.x,t.y+10,t.z),a=this.riseSpeed,animation=function(){if(e){var t=e.getLocalPosition();t.y<b.y?(e.setLocalPosition(t.x,t.y+a*pc.app.timeScale,t.z),requestAnimationFrame(animation)):e.destroy()}};animation()};var CustomShader=pc.createScript("customShader");CustomShader.attributes.add("targetEntity",{type:"entity"}),CustomShader.attributes.add("shaderAsset",{type:"asset"}),CustomShader.attributes.add("eventName",{type:"string",default:"applyShader",title:"Event Name"}),CustomShader.prototype.initialize=function(){this.time=0,this.app.on(this.eventName,this.applyShaderEvent,this)},CustomShader.prototype.applyShaderEvent=function(){this.targetEntity&&this.shaderAsset?(console.log(">> customShader.js <<"),this.app.assets.load(this.shaderAsset),this.shaderAsset.ready(this.onShaderAssetReady.bind(this))):console.error("Entité cible ou asset de shader non spécifié.")},CustomShader.prototype.onShaderAssetReady=function(t){var e=t.resource.split("/*FRAGMENT_SHADER*/"),a=e[0].trim(),s=e[1].trim();this.createAndApplyShader(a,s)},CustomShader.prototype.createAndApplyShader=function(t,e){var a=new pc.Shader(this.app.graphicsDevice,{attributes:{aPosition:pc.SEMANTIC_POSITION},vshader:t,fshader:e}),s=new pc.Material;if(s.shader=a,this.updateShaderUniforms(s),this.targetEntity.model)for(var r=this.targetEntity.model.model.meshInstances,i=0;i<r.length;i++)r[i].material=s},CustomShader.prototype.updateShaderUniforms=function(t){t.setParameter("uTime",this.time),t.setParameter("matrix_model",this.targetEntity.getWorldTransform().data),t.setParameter("matrix_viewProjection",this.app.systems.camera.cameras[0].camera.projectionMatrix.data),t.setParameter("cameraPos",this.app.systems.camera.cameras[0].entity.getPosition().data)},CustomShader.prototype.update=function(t){this.time+=t;var e=this.targetEntity.model?this.targetEntity.model.model.meshInstances[0].material:null;e&&e.setParameter("uTime",this.time)};var Progression=pc.createScript("progression");Progression.prototype.initialize=function(){this.rayons=this.app.root.findByName("rayons"),this.eltText=this.app.root.findByName("everylittlething"),this.cameraEntity=this.app.root.findByName("Camera"),this.hasShader1BeenActivated=!1,this.showRayons=!1,this.showeltText=!1,this.rayons.enabled=!1,this.eltText.enabled=!1,this.stopText=!1,this.shaderTunnel=!1,this.tunnel=this.app.root.findByName("tunnel"),this.tunnel.script.enabled=!1,this.arbres=this.app.root.findByName("Trees"),this.scriptArbres=!1,window.scriptOnOff("Trees","objectSpawner",0)};var eltTextC=0,cntRotation=0;Progression.prototype.update=function(t){var e=this.rayons.getPosition(),s=this.cameraEntity.getPosition(),i=this.eltText.getPosition();if(s.y>317&&s.z<1062&&!this.hasShader1BeenActivated&&(this.activateShader1(),console.log("shader 1"),this.hasShader1BeenActivated=!0),this.hasShader1BeenActivated&&!this.showeltText&&(this.isShowingText=!0),this.isShowingText&&!this.stopText&&(this.eltText.enabled=!0,i.y>=310&&(this.showRayons=!0),i.y>=485&&(this.isShowingText=!1,this.stopText=!0),eltTextC+=.16*t,this.eltText.translate(0,eltTextC,0)),this.showRayons&&(this.rayons.enabled=!0,this.rayons.translate(0,49.2*t,0)),e.y>180){this.showRayons=!1,cntRotation+=1,console.log("rot rayons : "+cntRotation);this.rayons.getEulerAngles().y;this.rayons.rotateLocal(0,12*t,0),this.shaderTunnel||(console.log("shader tunnel on"),this.shaderTunnel=!0,this.tunnel.script.enabled=1)}},Progression.prototype.activateShader1=function(){this.app.fire("applyShader1"),console.log("Shader 1 Activated")};var Billboard=pc.createScript("billboard");Billboard.prototype.initialize=function(){this.camera=this.app.root.findByTag("Camera")[0]},Billboard.prototype.update=function(t){if(this.camera){var i=this.camera.getPosition();this.entity.lookAt(i);var a=this.entity.getEulerAngles();this.entity.setEulerAngles(0,a.y,0)}};var RotateMaterial=pc.createScript("rotateMaterial");RotateMaterial.attributes.add("rotationSpeed",{type:"number",default:1,title:"Rotation Speed"}),RotateMaterial.prototype.initialize=function(){this.time=0,this.entity.render&&this.entity.render.material?this.material=this.entity.render.material:console.error("L'entité n'a pas de matériau à faire tourner.")},RotateMaterial.prototype.update=function(t){if(this.material){this.time+=t*this.rotationSpeed;var e=this.time%1;this.material.diffuseMapOffset.set(0,e),this.material.update()}};var RainbowShader=pc.createScript("rainbowShader");RainbowShader.prototype.initialize=function(){var i=new pc.Shader(this.app.graphicsDevice,{attributes:{aPosition:pc.SEMANTIC_POSITION,aUv0:pc.SEMANTIC_TEXCOORD0},vshader:"\n        attribute vec3 aPosition;\n        attribute vec2 aUv0;\n        varying vec2 vUv0;\n        uniform mat4 matrix_model;\n        uniform mat4 matrix_viewProjection;\n        void main(void) {\n            gl_Position = matrix_viewProjection * matrix_model * vec4(aPosition, 1.0);\n            vUv0 = aUv0;\n        }\n    ",fshader:"\n        precision mediump float;\n        varying vec2 vUv0;\n        uniform float uTime;\n        void main(void) {\n            float y = vUv0.y + sin(uTime) * 0.5 + 0.5;\n            vec3 color = vec3(0.0);\n            if (y < 1.0 / 7.0) color = vec3(1.0, 0.0, 0.0);\n            else if (y < 2.0 / 7.0) color = vec3(1.0, 0.5, 0.0);\n            else if (y < 3.0 / 7.0) color = vec3(1.0, 1.0, 0.0);\n            else if (y < 4.0 / 7.0) color = vec3(0.0, 1.0, 0.0);\n            else if (y < 5.0 / 7.0) color = vec3(0.0, 0.0, 1.0);\n            else if (y < 6.0 / 7.0) color = vec3(0.29, 0.0, 0.51);\n            else color = vec3(0.56, 0.0, 1.0);\n            gl_FragColor = vec4(color, 1.0);\n        }\n    "});this.material=new pc.Material,this.material.shader=i,this.entity.model.meshInstances.forEach((function(i){i.material=this.material}),this),this.time=0},RainbowShader.prototype.update=function(i){this.time+=i,this.material.setParameter("uTime",this.time)};var TriangleTunnel=pc.createScript("triangleTunnel");TriangleTunnel.attributes.add("triangleTemplate",{type:"asset",assetType:"template",title:"Triangle Template"}),TriangleTunnel.attributes.add("repeatCount",{type:"number",default:10,title:"Repeat Count"}),TriangleTunnel.attributes.add("spacing",{type:"number",default:2,title:"Spacing"}),TriangleTunnel.prototype.initialize=function(){if(this.triangleTemplate.resource)for(let t=0;t<this.repeatCount;t++){var e=this.triangleTemplate.resource.instantiate();e.setLocalPosition(0,0,t*this.spacing),this.app.root.addChild(e)}else console.error("Triangle template asset not set or not loaded.")};pc.script.createLoadingScreen((function(e){var t,a;t=["body {","    background-color: #03111a;","}","#application-splash-wrapper {","    position: absolute;","    top: 0;","    left: 0;","    height: 100%;","    width: 100%;","    background-color: #03111a;","}","#txtintro {","display:block;","font-weight: bold;","font-size:48px;","position: absolute;","top: 45%;","text-align:center;","height: 50px;","padding-bottom: 10px;","width: 100%;","color: #ffffff;","    background-color: #03111a;","}","#application-splash {","    position: absolute;","    display: block;","    width: 0px;","    height: auto;","}","#application-splash img {","    width: 100%;","}","#progress-bar-container {","    margin: 20px auto 0 auto;","    height: 4px;","    width: 100%;","    background-color: #ed4591;","}","#progress-bar {","    width: 0%;","    height: 100%;","    background-color: #ed4591;","}","@media (max-width: 480px) {","    #application-splash {","        width: 170px;","        left: calc(50% - 85px);","    }","}"].join("\n"),(a=document.createElement("style")).type="text/css",a.styleSheet?a.styleSheet.cssText=t:a.appendChild(document.createTextNode(t)),document.head.appendChild(a),function(){var e=document.createElement("div");e.id="application-splash-wrapper",document.body.appendChild(e);var t=document.createElement("div");t.id="application-splash",e.appendChild(t),t.style.display="block";var a=document.createElement("div");a.id="progress-bar-container",t.appendChild(a);var o=document.createElement("div");o.innerText="loading . . . ",o.id="txtintro",e.appendChild(o);var i=document.createElement("div");i.id="progress-bar",e.appendChild(i)}(),e.on("preload:end",(function(){e.off("preload:progress")})),e.on("preload:progress",(function(e){var t=document.getElementById("progress-bar");t&&(e=Math.min(1,Math.max(0,e)),t.style.width=100*e+"%")})),e.on("start",(function(){var e=document.getElementById("application-splash-wrapper");e.parentElement.removeChild(e)}))}));var RotateByJumps=pc.createScript("rotateByJumps");RotateByJumps.prototype.initialize=function(){this.currentRotationY=0,this.rotateAmount=45,this.interval=setInterval(function(){this.currentRotationY+=this.rotateAmount,this.currentRotationY>=360&&(this.currentRotationY-=360),this.entity.setEulerAngles(0,this.currentRotationY,0)}.bind(this),250)},RotateByJumps.prototype.destroy=function(){this.interval&&clearInterval(this.interval)};var OscillateZ=pc.createScript("oscillateZ");OscillateZ.attributes.add("speed",{type:"number",default:1,title:"Speed"}),OscillateZ.attributes.add("amplitude",{type:"number",default:100,title:"Amplitude"}),OscillateZ.attributes.add("rotationSpeed",{type:"number",default:90,title:"Rotation Speed"}),OscillateZ.prototype.initialize=function(){this.initialZ=this.entity.getPosition().z,this.startTime=pc.now()},OscillateZ.prototype.update=function(t){var i=this.amplitude*Math.sin(this.speed*(pc.now()-this.startTime)*.001)+this.initialZ;this.entity.setPosition(this.entity.getPosition().x,this.entity.getPosition().y,i);var e=this.entity.getLocalEulerAngles();e.z+=this.rotationSpeed*t,this.entity.setLocalEulerAngles(e)};var PulseScale=pc.createScript("pulseScale");PulseScale.attributes.add("frequency",{type:"number",default:1,title:"Frequency"}),PulseScale.attributes.add("amplitude",{type:"number",default:.5,title:"Amplitude"}),PulseScale.attributes.add("baseScale",{type:"vec3",default:[1,1,1],title:"Base Scale"}),PulseScale.prototype.initialize=function(){this.time=0},PulseScale.prototype.update=function(e){this.time+=e;var t=Math.sin(this.time*this.frequency*2*Math.PI)*this.amplitude+1,a=new pc.Vec3(this.baseScale.x*t,this.baseScale.y*t,this.baseScale.z*t);this.entity.setLocalScale(a)};var Baguette=pc.createScript("baguette");Baguette.attributes.add("trembleAmplitude",{type:"number",default:.1,title:"Tremble Amplitude"}),Baguette.attributes.add("trembleSpeed",{type:"number",default:20,title:"Tremble Speed"}),Baguette.attributes.add("launchSpeed",{type:"number",default:5,title:"Launch Speed"}),Baguette.prototype.initialize=function(){this.originalPosition=this.entity.getPosition().clone(),this.isTrembling=!1,this.isLaunching=!1,this.launchTime=0,this.app.on("decollage",this.startTremble,this)},Baguette.prototype.startTremble=function(){this.isTrembling=!0,this.launchTime=pc.now()},Baguette.prototype.update=function(t){if(this.isTrembling){var e=pc.now(),i=Math.sin(.001*e*this.trembleSpeed)*this.trembleAmplitude,s=Math.cos(.001*e*this.trembleSpeed)*this.trembleAmplitude;this.entity.setPosition(this.originalPosition.x+i,this.originalPosition.y,this.originalPosition.z+s),e-this.launchTime>5e3&&(this.isTrembling=!1,this.isLaunching=!0)}else if(this.isLaunching){var n=this.entity.getPosition();n.y+=this.launchSpeed*t,this.entity.setPosition(n)}},Baguette.prototype.onDestroy=function(){this.app.off("decollage",this.startTremble,this)};