; vim: set ft=rgbds:

RGB888 : macro
	dw (((\1 >>3)<<0)|((\2 >>3)<<5)|(\3 >>3)<<10)
endm

include "hardware.inc"

section "header", ROM0[$100]

_start:
	di
	jp main

rept $150 - $104
	db 0
endr

section "vectors", ROM0[$000]

	jp main

rept $48 - 3
	db 0
endr

irq_stat:
	jp hblank
	reti
	nop
	nop
	nop
	nop

section "text", ROM0[$200]

main:
	; wait for vbl before disabling the lcdc
.waitVBlank
	ldh a, [rLY]
	cp 144
	jr c, .waitVBlank

	xor a
	ldh [rLCDC], a
	ldh [rSCY], a
	ldh [rSCX], a
	ldh [rNR52], a ; disable sound

	; Init display registers
	ld a, %11100100
	ldh [rBGP], a

	; Turn screen on, display background
	ld a, %10000001
	ldh [rLCDC], a

	ld a, $08
	ldh [rSTAT], a

	; wheee
	ld a, $03
	ldh [rIE], a
	ei

	; Lock up
.lockup
	halt
	jr .lockup

section "hblank", ROM0[$400]

hblank:
	ld a, $80
	ldh [rBCPS], a
	ldh a, [rLY]
	add $08
	srl a
	srl a
	srl a
	srl a
	srl a
	sla a
	ld b, a
	ld hl, $0210;colorlut ; TODO: FIXME: REALLY UGLY HACK, ADDR SHOULDN'T BE HARDCODED
	add l
	ld l, a
	ld a, [hl]
	ldh [rBCPD], a
	inc hl
	ld a, [hl]
	ldh [rBCPD], a
	reti

	; reuse the GBA/NDS one
;colorlut:
;	RGB888 $59, $C8, $F3
;	RGB888 $ED, $A5, $B3
;	RGB888 $FF, $FF, $FF
;	RGB888 $ED, $A5, $B3
;	RGB888 $59, $C8, $F3
;	;dw ((($46>>3)<<0)|(($C2>>3)<<5)|(($E4>>3)<<10))
;	;dw ((($E5>>3)<<0)|(($96>>3)<<5)|(($B6>>3)<<10))
;	;dw ((($FF>>3)<<0)|(($FF>>3)<<5)|(($FF>>3)<<10))
;	;dw ((($E5>>3)<<0)|(($96>>3)<<5)|(($B6>>3)<<10))
;	;dw ((($46>>3)<<0)|(($C2>>3)<<5)|(($E4>>3)<<10))

