#!/usr/bin/env python3

import sys, os

#       # DOL DATA1 load address
#                 # DOL DATA1 size
PADSIZE = 0x10000 + 0x9600

def insert(a1: bytearray, a2: bytearray) -> bytearray:
    rv = (a2 + a1[len(a2):]) if len(a1) > len(a2) \
                             else (a1 + a2[len(a1):])
    return rv + b'\x00'*(PADSIZE-len(rv))

def merge(a1: bytearray, a2: bytearray) -> bytearray:
    sh = a1 if len(a1) < len(a2) else a2
    lo = a2 if len(a1) < len(a2) else a1

    torm = lo[-len(sh):]
    assert all(x == 0 for x in torm)
    trunc = lo[:-len(sh)]
    return trunc + sh

in1 = bytearray(open(sys.argv[1],'rb').read())
in2 = bytearray(open(sys.argv[2],'rb').read())
in3 = bytearray(open(sys.argv[3],'rb').read())

merged = insert(in1, in2)
merged = merge(merged, in3)

# also fix the GBA entrypoint by adding a random branch somewhere
merged[0x200C:0x2010] = [0x73,0xF8,0xFF,0xEA]

sys.stdout.buffer.write(merged)

