# ca65 linker config for 128K SMC

# Physical areas of memory
# Names need not match, but it makes it easier to remember if they do.
MEMORY {
    ZEROPAGE:   start =      0, size =  $100;
    BSS:        start =   $200, size = $1800;
    ROM:        start =  $8000, size = $8000, fill = yes;
    BANK1:      start = $18000, size = $8000, fill = no;
    BANK2:      start = $28000, size = $8000, fill = no;
    BANK3:      start = $38000, size = $8000, fill = no;
}

# Logical areas code/data can be put into.
SEGMENTS {
    ZEROPAGE:   load = ZEROPAGE,    type = zp;
    BSS:        load = BSS,         type = bss, align = $100;

#   CODE2:      load = ROM,         start =  $FE00;
    CODE:       load = ROM,         start =  $FF80;
    RODATA:     load = ROM;
    HEADER:     load = ROM,         start =  $FFC0;
#   ROMINFO:    load = ROM,         start =  $FFD5, optional = yes;
#   VECTORS:    load = ROM,         start =  $FFE0;

    # The extra three banks
    BANK1:      load = BANK1,       align = $8000, optional = yes;
    BANK2:      load = BANK2,       align = $8000, optional = yes;
    BANK3:      load = BANK3,       align = $8000, optional = yes;
}

