; vim: set ft=snes:

.define RGB888(r,g,b) ((r>>3)|((g>>3)<<5)|((b>>3)<<10))

.define INIDISP  $2100
.define BGMODE   $2105
.define VMAIN    $2115
.define VMADDL   $2116
.define VMADDH   $2117
.define VMDATAL  $2118
.define VMDATAH  $2119
.define CGADD    $2121
.define CGDATA   $2122
.define SETINI   $2133
.define OPHCT    $213C
.define OPVCT    $213D

.define INIDISPz $00
.define BGMODEz  $05
.define VMAINz   $15
.define VMADDLz  $16
.define VMADDHz  $17
.define VMDATALz $18
.define VMDATAHz $19
.define CGADDz   $21
.define CGDATAz  $22
.define SETINIz  $33
.define OPHCTz   $3C
.define OPVCTz   $3D

.define NMITIMEN $4200
.define HTIMEL   $4207
.define HTIMEH   $4208
.define VTIMEL   $4209
.define VTIMEH   $420A
; ?????
.define MDMAEN   $420B
.define HDMAEN   $420C
.define MEMSEL   $420D
.define RDNMI    $4210
.define TIMEUP   $4211
.define HVBJOY   $4212

;.define DMAP(x) ($4300|((x)<<4))
;.define BBAD(x) ($4301|((x)<<4))
;.define A1TL(x) ($4302|((x)<<4))
;.define A1TH(x) ($4303|((x)<<4))
;.define A1B(x)  ($4304|((x)<<4))
;.define DASL(x) ($4305|((x)<<4))
;.define DASH(x) ($4306|((x)<<4))
;.define DASB(x) ($4307|((x)<<4))
;.define A2AL(x) ($4308|((x)<<4))
;.define A2AH(x) ($4309|((x)<<4))
;.define NTLR(x) ($430A|((x)<<4))

.p816   ; 65816 processor
.i16    ; X/Y are 16 bits
.a8     ; A is 8 bits

.segment "HEADER"        ; +$7FE0 in file
;	.byte "CA65 EXAMPLE" ; ROM name
_start:
;	sei
	clc			; native mode
	xce
	rep #$10	; X/Y 16-bit
	sep #$20	; A 8-bit

	; clear PPU regs
	ldx #$33
@loop:
	stz $2100, x
	stz $4200, x
	dex
	bpl @loop
	;jmp _start_2
	sei
	bra _start_3
	;nop
	;nop

	; lol fallthru
;.segment "ROMINFO"       ; +$7FD5 in file
	; bmi :+; : ora $00
	.byte $30            ; LoROM, fast-capable
	.byte 0              ; no battery RAM
	.byte $05            ; 128K ROM
	.byte $0
_start_2:
	;jmp _start_3
	.byte 'T','T','N'
;	.byte 0,0,0,0
	.word $AAAA,$5555    ; dummy checksum and complement

;.segment "VECTORS"
	; cop brk abort nmi(vbl) reset irq(vcount)
	;.word 0, 0, 0, 0, 0, 0, 0, 0
_start_3:
	;sei
	pea $2100		; direct page at $2100
	pld

	; wait for 1st vbl
	stz SETINIz
:	bit HVBJOY
	bpl :-

_vblank:
	; stuff?

	; set screen on
	lda #$0F
	sta INIDISPz

	jmp _vblank_2

COLTAB:
	;.word RGB888($46,$C2,$E4)
	;.word RGB888($E5,$96,$B6)
	;.word RGB888($FF,$FF,$FF)
	;.word RGB888($E5,$96,$B6)
	;.word RGB888($46,$C2,$E4)
	.word RGB888($59,$C8,$F3)
	.word RGB888($ED,$A5,$B3)
	.word RGB888($FF,$FF,$FF)
	.word RGB888($ED,$A5,$B3)
	.word RGB888($59,$C8,$F3)

	; cop abort nmi(vbl) res brk irq(vcount)
	;.word 0, 0, 0, 0, 0, 0
	.word _start;, 0
	.byte 'K','2'

.segment "CODE"

_vblank_2:
	; wait for active disp.
:	bit HVBJOY
	bmi :-

st0:
	ldy #$000C

mainloop:
	; wait for blank
:	bit HVBJOY
	bmi _vblank_2
	bvc :-
	; wait for active display
:	bit HVBJOY
	;bmi _vblank_2
	bvs :-

	ldx #$12
:	dex
	bpl :-

	iny
	tya
	lsr
	lsr
	lsr
	sta $80, s
	lsr
	lsr
	sta $81, s
	lsr
	clc
	adc $81, s
	clc
	adc $80, s
	lsr
	lsr
	lsr
	clc
	asl
	tax
	stz CGADDz
	lda COLTAB  , x
	sta CGDATAz
	lda COLTAB+1, x
	sta CGDATAz

	bra mainloop

