
.define NOFLICKER 1
.define BASICSTUB 0

.segment "LOADADDR"
.export __LOADADDR__
__LOADADDR__:
	.p816
	.word __start

.segment "CODE"
	.setcpu "6502X"

.if BASICSTUB
.export __start: absolute = $0801

	; BASIC bootstub
	; $0801 == 2049
	.byte $0b,$08 ; ptr to next line
	.byte $d4;,$xx ; basic lineno
line:
.if NOFLICKER
	.byte $05
.else
	.byte $0a
.endif
	.byte $9e     ; SYS
	.byte $32,$30,$36,$31 ; _start addr ('2061' in PETSCII decimals == $080d)
	.byte 0,0,0 ; EOF

.else
.export __start: absolute = $1115 ; $1189 ; $0d77 ; $0d67
.endif

_start:
	lda #%01111111
	sta $DC0D

	lda #<isr
	sta $0314
	lda #>isr
	sta $0315

	ldx #0
	stx $D011
	;stx $D012
	inx;lda #1
	stx $D01A

	rts

isr:
	ldx line
	lda collutp1-1,x
	sta $D020

	lda linelutp1-2,x
	sta $D012

	asl $D019

	dex
	txa
	bne :+
.if NOFLICKER
	lda #5
.else
	lda #$a
.endif
:	sta line

	jmp $ea31

linelutp1:
	;.byte 234 ; == $ea in the jmp above
	.byte      176, 117, 59
.if NOFLICKER
.else
	.byte 0
	.byte 234, 176, 117, 59;, 0
.endif

collutp1:
	.byte $a, 1, $a, 3
.if NOFLICKER
.else
	.byte 3,  4, 1,  4, 3
.endif
	.byte 3

line:
.if NOFLICKER
	.byte $05
.else
	.byte $0a
.endif

