# vim: set ft=gas:

.macro liw dest num
	#li   \dest\(), ((\num\()) & 0xFFFF)
	ori  \dest\(), r0, ((\num\()) & 0xFFFF)
	oris \dest\(), \dest\(), (((\num\()) & 0xFFFF0000)>>16)
.endm

/*#define RGB2Y(r,g,b) ((299*(r)+587*(g)+114*(b))/1000)
#define RGB2Cb(r,g,b) (((- 16874)*(r)- 33126*(g)+50000*(b)+12800000)/100000)
#define RGB2Cr(r,g,b) ((50000*(r)- 41869*(g)- 8131*(b)+12800000)/100000)*/
#define RGB2Y(r,g,b)  (((((r)<<6)+((r)<<1)+((g)<<7)+((g)<<1)+((b)<<4)+((b)<<3)+((b)<<1))>>8)+16)
#define RGB2Cb(r,g,b) (((((r)<<2)-((r)<<5)+((r)<<1)-((g)<<6)-((g)<<3)-((g)<<1)+((b)<<7)-((b)<<4))>>8)+128)
#define RGB2Cr(r,g,b) (((((r)<<7)-((r)<<4)+((g)<<1)-((g)<<5)-((g)<<6)-((b)<<4)-((b)<<1))>>8)+128)

#define RGB2Y2CbCr(b,g,r) (((RGB2Y(r,g,b)*0x10001)<<8)|(RGB2Cb(r,g,b)<<16)|RGB2Cr(r,g,b))

#define LOADADDR 0x81010000

#include "vimodeset.S"

.globl _start
_start:
	li  r0, 0
	# initialize VI
	liw r1, VI_BASE

	liw r2, 0x0f060001
	stw r2, 0x00(r1)
	liw r2, 0x02ea5140
	stw r2, 0x08(r1)
	liw r2, 0x00030018
	stw r2, 0x0C(r1)
	liw r2, 0x00000019
	stw r2, 0x10(r1)
	liw r2, 0x00435a4e
	stw r2, 0x1c(r1)
	liw r2, 0x00435a4e
	stw r2, 0x24(r1)

	/* assert RST */
	/*li  r2, 0x02
	sth r2, VI_DCR(r1)

	# wait a bit
	li     r2, 1000
1:	subic. r2, r2, 1
	bne    1b

	# stop asserting RST
	#li  r2, 0
	sth r0, VI_DCR(r1)

	# fill registers
	liw r2, vrHTR0
	stw r2, VI_HTR0(r1)
	liw r2, vrHTR1
	stw r2, VI_HTR1(r1)
	li  r2, vrVTR
	sth r2, VI_VTR(r1)
	liw r2, vrVTO
	stw r2, VI_VTO(r1)
	liw r2, vrVTE
	stw r2, VI_VTE(r1)
	liw r2, vrBBOI
	stw r2, VI_BBOI(r1)
	liw r2, vrBBEI
	stw r2, VI_BBEI(r1)
	li  r2, vrHSR
	sth r2, VI_HSR(r1)

	liw r2, vrTBFBL
	stw r2, VI_TFBL(r1)
	stw r2, VI_BFBL(r1)

	# start VI
	li  r2, vrDCR
	sth r2, VI_DCR(r1)
#if (vrVICLK == 0)
	sth r0, VI_VICLK(r1)
#else
	li  r2, vrVICLK
	sth r2, VI_VICLK(r1)
#endif */

	li  r10, HEIGHT
mainloop:
	liw r8 , LOADADDR+(colors_ycbcr - _start)
	liw r6, XFB_BASE
	li  r3, 0

outer_loop:
	li r4, WIDTH

inner_loop:
	mulli r7, r3, (5*4)
	divwu r7, r7, r10
	mulli r7, r7, 4
	lwzx  r7, r8, r7
	stwu  r7, 4(r6)

	# next pixel
	subic. r4, r4, 1
	bne    inner_loop

	# next scanline
	addic  r3, r3, 1
	cmpwi  r3, HEIGHT
	bne    outer_loop

vblank:
	# wait until we're at scanline 1
	lhz   r8, VI_DPV(r1)
	cmpwi r8, 1
	bne   vblank
	b     mainloop

colors_ycbcr:
	#.4byte RGB2Y2CbCr(0x46,0xC2,0xE4)
	#.4byte RGB2Y2CbCr(0xE5,0x96,0xB6)
	#.4byte RGB2Y2CbCr(0xFF,0xFF,0xFF)
	#.4byte RGB2Y2CbCr(0xE5,0x96,0xB6)
	#.4byte RGB2Y2CbCr(0x46,0xC2,0xE4)
	.4byte RGB2Y2CbCr(0x59,0xC8,0xF3)
	.4byte RGB2Y2CbCr(0xED,0xA5,0xB3)
	.4byte RGB2Y2CbCr(0xFF,0xFF,0xFF)
	.4byte RGB2Y2CbCr(0xED,0xA5,0xB3)
	.4byte RGB2Y2CbCr(0x59,0xC8,0xF3)

