# vim: set ft=gas:

#define VI_BASE 0xCC002000
#define VI_VTR        0x00
#define VI_DCR        0x02
#define VI_HTR0       0x04
#define VI_HTR1       0x08
#define VI_VTO        0x0C
#define VI_VTE        0x10
#define VI_BBOI       0x14
#define VI_BBEI       0x18
#define VI_TFBL       0x1C
#define VI_BFBL       0x24
#define VI_DPV        0x2C
#define VI_HSR        0x4A
#define VI_VICLK      0x6C

#define XFB_BASE 0x080435A00

/*#define PAL*/
/*#define PROGRESSIVE*/ /* currently borked */
#define INTERLACED

#ifdef PROGRESSIVE
#ifdef PAL
// VT 7
#define EQU  (  0x0A)
#define ACV  (0x0240)
#define PRBO (0x003E)
#define PRBE (0x003E)
#define PSBO (0x0006)
#define PSBE (0x0006)
#define BS1  (  0x14)
#define BS2  (  0x14)
#define BS3  (  0x14)
#define BS4  (  0x14)
#define BE1  (0x04D8)
#define BE2  (0x04D8)
#define BE3  (0x04D8)
#define BE4  (0x04D8)
#define NHLINES (0x04E2)
#define HLW  (0x01B0)
#define HSY  (  0x40)
#define HCS  (  0x4B)
#define HCE  (  0x6A)
#define HBE640 (0xAC)
#define HBS640 (0x017C)
#else /* NTSC */
# VT 6
#define EQU  (  0x0C)
#define ACV  (0x01E0)
#define PRBO (0x0030)
#define PRBE (0x0030)
#define PSBO (0x0006)
#define PSBE (0x0006)
#define BS1  (  0x18)
#define BS2  (  0x18)
#define BS3  (  0x18)
#define BS4  (  0x18)
#define BE1  (0x040E)
#define BE2  (0x040E)
#define BE3  (0x040E)
#define BE4  (0x040E)
#define NHLINES (0x041A)
#define HLW  (0x01AD)
#define HSY  (  0x40)
#define HCS  (  0x47)
#define HCE  (  0x69)
#define HBE640 (0xA2)
#define HBS640 (0x0175)
#endif /* PAL/NTSC */
#else /* !PROGRESSIVE */
#ifdef INTERLACED
#ifdef PAL
// VT 2
#define EQU  (  0x05)
#define ACV  (0x0120)
#define PRBO (0x0021)
#define PRBE (0x0022)
#define PSBO (0x0001)
#define PSBE (0x0000)
#define BS1  (  0x0A)
#define BS2  (  0x0B)
#define BS3  (  0x0A)
#define BS4  (  0x0B)
#define BE1  (0x026D)
#define BE2  (0x026C)
#define BE3  (0x026D)
#define BE4  (0x026C)
#define NHLINES (0x0271)
#define HLW  (0x01B0)
#define HSY  (  0x40)
#define HCS  (  0x4B)
#define HCE  (  0x6A)
#define HBE640 (0xAC)
#define HBS640 (0x017C)
#else /* NTSC */
# VT 0
#define EQU  (  0x06)
#define ACV  (0x00F0)
#define PRBO (0x0018)
#define PRBE (0x0019)
#define PSBO (0x0003)
#define PSBE (0x0002)
#define BS1  (  0x0C)
#define BS2  (  0x0D)
#define BS3  (  0x0C)
#define BS4  (  0x0D)
#define BE1  (0x0208)
#define BE2  (0x0207)
#define BE3  (0x0208)
#define BE4  (0x0207)
#define NHLINES (0x020D)
#define HLW  (0x01AD)
#define HSY  (  0x40)
#define HCS  (  0x47)
#define HCE  (  0x69)
#define HBE640 (0xA2)
#define HBS640 (0x0175)
#endif /* PAL/NTSC */
#else /* !INTERLACED (DS) */
#ifdef PAL
// VT 3
#define EQU  (  0x05)
#define ACV  (0x011F)
#define PRBO (0x0021)
#define PRBE (0x0021)
#define PSBO (0x0002)
#define PSBE (0x0002)
#define BS1  (  0x0D)
#define BS2  (  0x0B)
#define BS3  (  0x0D)
#define BS4  (  0x0B)
#define BE1  (0x026B)
#define BE2  (0x026D)
#define BE3  (0x026B)
#define BE4  (0x026D)
#define NHLINES (0x0270)
#define HLW  (0x01B0)
#define HSY  (  0x40)
#define HCS  (  0x4B)
#define HCE  (  0x6A)
#define HBE640 (0xAC)
#define HBS640 (0x017C)
#else /* NTSC */
# VT 1
#define EQU  (  0x06)
#define ACV  (0x00F0)
#define PRBO (0x0018)
#define PRBE (0x0018)
#define PSBO (0x0004)
#define PSBE (0x0004)
#define BS1  (  0x0C)
#define BS2  (  0x0C)
#define BS3  (  0x0C)
#define BS4  (  0x0C)
#define BE1  (0x0208)
#define BE2  (0x0208)
#define BE3  (0x0208)
#define BE4  (0x0208)
#define NHLINES (0x020E)
#define HLW  (0x01AD)
#define HSY  (  0x40)
#define HCS  (  0x47)
#define HCE  (  0x69)
#define HBE640 (0xA2)
#define HBS640 (0x0175)
#endif /* PAL/NTSC */
#endif /* INTERLACED */
#endif /* PROGRESSIVE */

#if !defined(PROGRESSIVE) && defined(INTERLACED)
#define INTERLACE (1)
#else
#define INTERLACE (0)
#endif

#define vrVTR  (EQU | (ACV << 4))
#define vrHTR0 (HLW | (HCS << 24) | (HCE << 16))
#define vrHTR1 ((HBS640 << 17) | (HBE640 << 7) | HSY)
#define vrVTO  (((PSBO+2)<<16) | (PRBO + (ACV << 1) - 2))
#define vrVTE  (((PSBE+2)<<16) | (PRBE + (ACV << 1) - 2))
#define vrBBOI ((BE3 << 21) | (BS3 << 16) | (BE1 << 5) | BS1)
#define vrBBEI ((BE4 << 21) | (BS4 << 16) | (BE2 << 5) | BS2)
/*#define vrDI0  (((0x1000|((NHLINES/2)+1))<<16) | (HLW + 1))
#define vrDI1  (0x10010001)*/
#define vrHSR  (0x0100/*0x2828*/ /* ??? */)

#define WIDTH   (640)
#ifdef PAL
#define VI_MODE (  1)
#define HEIGHT  (574)
#define vrTBFBL (0x00435A4E /* ??? */)
#else
#define VI_MODE (  0) /* NTSC */
#define HEIGHT  (480)
#define vrTBFBL (0x00435A4E /* ??? */)
#endif

#ifdef PROGRESSIVE
#define vrDCR  ((VI_MODE << 8) | 0x0005 /* enable, no interlace */)
#define vrVICLK (0x0001 /* 54 MHz prog-scan clock */)
#else
#define vrDCR  ((VI_MODE << 8) | ((1^INTERLACE) << 2) | 0x0001 /* enable */)
#define vrVICLK (0x0000 /* standard 27 MHz clock */)
#endif

