#version 330 core
out vec4 fragColor;

uniform float time;
uniform vec2 resolution;
uniform sampler2D iChannel0;

vec2 getWaveCenter(float time)
{
    float x = sin(time * 0.5) * 0.5 + 0.5;
    float y = cos(time * 0.3) * 0.5 + 0.5;
    return vec2(x, y);
}

void main()
{
    vec2 uv = (gl_FragCoord.xy * 2.0 - resolution) / vec2(resolution.x, resolution.x);
    vec2 tuv = gl_FragCoord.xy / resolution;
    if(time > 8)
    {
        vec2 uv = gl_FragCoord.xy / resolution;
        vec2 waveCenter = getWaveCenter(time);
        vec2 centeredUV = uv - waveCenter;
        float dist = length(centeredUV) * 2.0;
        float wave = sin(dist * 12.0 - time * 4.0);
        wave = (wave + 1.0) * 0.5;
        vec3 baseColor = vec3(0.2, 0.5, 0.8) * wave;
        vec4 texColor = texture(iChannel0, uv);
        fragColor = mix(texColor, vec4(baseColor, 1.0), 0.5);
    }
    else
    {
	float r = sin(time * 10.0 + uv.x * 12.0);
	float g = sin(time * -10.0 + uv.x * 12.0);
	float b = sin(time * 10.0 + uv.y * 8.0);
	vec4 color = vec4(r, g, b, abs(sin(time)));
        color = mix(color, texture(iChannel0, tuv), .5);
	fragColor = color;
    }
}
