/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.data;

import com.jsyn.data.Function;
import com.jsyn.data.ShortSample;
import com.jsyn.exceptions.ChannelMismatchException;

public class DoubleTable
implements Function {
    private double[] table;

    public DoubleTable(int numFrames) {
        this.allocate(numFrames);
    }

    public DoubleTable(double[] data) {
        this.allocate(data.length);
        this.write(data);
    }

    public DoubleTable(ShortSample shortSample) {
        int numTransfer;
        int framesLeft;
        if (shortSample.getChannelsPerFrame() != 1) {
            throw new ChannelMismatchException("DoubleTable can only be built from mono samples.");
        }
        short[] buffer = new short[256];
        this.allocate(framesLeft);
        int cursor = 0;
        for (framesLeft = shortSample.getNumFrames(); framesLeft > 0; framesLeft -= numTransfer) {
            numTransfer = framesLeft;
            if (numTransfer > buffer.length) {
                numTransfer = buffer.length;
            }
            shortSample.read(cursor, buffer, 0, numTransfer);
            this.write(cursor, buffer, 0, numTransfer);
            cursor += numTransfer;
        }
    }

    public void allocate(int numFrames) {
        this.table = new double[numFrames];
    }

    public int length() {
        return this.table.length;
    }

    public void write(double[] data) {
        this.write(0, data, 0, data.length);
    }

    public void write(int startFrame, short[] data, int startIndex, int numFrames) {
        for (int i = 0; i < numFrames; ++i) {
            this.table[startFrame + i] = (double)data[startIndex + i] * 3.0517578125E-5;
        }
    }

    public void write(int startFrame, double[] data, int startIndex, int numFrames) {
        for (int i = 0; i < numFrames; ++i) {
            this.table[startFrame + i] = data[startIndex + i];
        }
    }

    @Override
    public double evaluate(double input) {
        double interp;
        if (input < -1.0) {
            interp = this.table[0];
        } else if (input < 1.0) {
            double fractionalIndex = (double)(this.table.length - 1) * (input - -1.0) / 2.0;
            int index = (int)fractionalIndex;
            double fraction = fractionalIndex - (double)index;
            double s1 = this.table[index];
            double s2 = this.table[index + 1];
            interp = (s2 - s1) * fraction + s1;
        } else {
            interp = this.table[this.table.length - 1];
        }
        return interp;
    }
}

