/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.data;

import com.jsyn.data.SequentialDataCommon;

public class SegmentedEnvelope
extends SequentialDataCommon {
    private double[] buffer;

    public SegmentedEnvelope(int maxFrames) {
        this.allocate(maxFrames);
    }

    public SegmentedEnvelope(double[] pairs) {
        this(pairs.length / 2);
        this.write(pairs);
    }

    public void allocate(int maxFrames) {
        this.buffer = new double[maxFrames * 2];
        this.maxFrames = maxFrames;
        this.numFrames = 0;
    }

    public void write(int startFrame, double[] data, int startIndex, int numToWrite) {
        System.arraycopy(data, startIndex * 2, this.buffer, startFrame * 2, numToWrite * 2);
        if (startFrame + numToWrite > this.numFrames) {
            this.numFrames = startFrame + numToWrite;
        }
    }

    public void read(int startFrame, double[] data, int startIndex, int numToRead) {
        System.arraycopy(this.buffer, startFrame * 2, data, startIndex * 2, numToRead * 2);
    }

    public void write(double[] data) {
        this.write(0, data, 0, data.length / 2);
    }

    public void read(double[] data) {
        this.read(0, data, 0, data.length / 2);
    }

    @Override
    public double readDouble(int index) {
        return this.buffer[index * 2 + 1];
    }

    @Override
    public void writeDouble(int index, double value) {
        this.buffer[index * 2 + 1] = value;
        if (index + 1 > this.numFrames) {
            this.numFrames = index + 1;
        }
    }

    @Override
    public double getRateScaler(int index, double synthesisPeriod) {
        double duration = this.buffer[index * 2];
        if (duration < synthesisPeriod) {
            duration = synthesisPeriod;
        }
        return 1.0 / duration;
    }

    @Override
    public int getChannelsPerFrame() {
        return 1;
    }
}

