/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.instruments;

import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.Circuit;
import com.jsyn.unitgen.EnvelopeAttackDecay;
import com.jsyn.unitgen.PinkNoise;
import com.jsyn.unitgen.UnitVoice;
import com.jsyn.util.VoiceDescription;
import com.softsynth.shared.time.TimeStamp;

public class NoiseHit
extends Circuit
implements UnitVoice {
    EnvelopeAttackDecay ampEnv;
    PinkNoise noise = new PinkNoise();
    private static final int NUM_PRESETS = 3;

    public NoiseHit() {
        this.add(this.noise);
        this.ampEnv = new EnvelopeAttackDecay();
        this.add(this.ampEnv);
        this.noise.output.connect(this.ampEnv.amplitude);
        this.ampEnv.export(this, "Amp");
        this.ampEnv.setupAutoDisable(this);
        this.usePreset(0);
    }

    @Override
    public void noteOff(TimeStamp timeStamp) {
    }

    @Override
    public void noteOn(double freq, double ampl, TimeStamp timeStamp) {
        this.noise.amplitude.set(ampl, timeStamp);
        this.ampEnv.input.trigger();
    }

    @Override
    public UnitOutputPort getOutput() {
        return this.ampEnv.output;
    }

    @Override
    public void usePreset(int presetIndex) {
        int n = presetIndex % 3;
        switch (n) {
            case 0: {
                this.ampEnv.attack.set(0.001);
                this.ampEnv.decay.set(0.1);
                break;
            }
            case 1: {
                this.ampEnv.attack.set(0.03);
                this.ampEnv.decay.set(1.4);
                break;
            }
            default: {
                this.ampEnv.attack.set(0.9);
                this.ampEnv.decay.set(0.3);
            }
        }
    }

    public static VoiceDescription getVoiceDescription() {
        return new MyVoiceDescription();
    }

    static class MyVoiceDescription
    extends VoiceDescription {
        static String[] presetNames = new String[]{"ShortNoiseHit", "LongNoiseHit", "SlowNoiseHit"};
        static String[] tags = new String[]{"electronic", "noise"};

        public MyVoiceDescription() {
            super("NoiseHit", presetNames);
        }

        @Override
        public UnitVoice createUnitVoice() {
            return new NoiseHit();
        }

        @Override
        public String[] getTags(int presetIndex) {
            return tags;
        }

        @Override
        public String getVoiceClassName() {
            return NoiseHit.class.getName();
        }
    }
}

