/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.swing;

import com.jsyn.swing.DoubleBoundedRangeModel;
import com.jsyn.swing.DoubleBoundedTextField;
import com.jsyn.swing.EnvelopeEditorBox;
import com.jsyn.swing.EnvelopePoints;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class EnvelopeEditorPanel
extends JPanel {
    EnvelopeEditorBox editor;
    Checkbox pointsBox;
    Checkbox sustainBox;
    Checkbox releaseBox;
    Checkbox autoBox;
    Button onButton;
    Button offButton;
    Button clearButton;
    Button yUpButton;
    Button yDownButton;
    DoubleBoundedTextField zoomField;

    public EnvelopeEditorPanel(EnvelopePoints points, int maxFrames) {
        this.setSize(600, 300);
        this.setLayout(new BorderLayout());
        this.editor = new EnvelopeEditorBox();
        this.editor.setMaxPoints(maxFrames);
        this.editor.setBackground(Color.cyan);
        this.editor.setPoints(points);
        this.editor.setMinimumSize(new Dimension(500, 300));
        this.add((Component)this.editor, "Center");
        JPanel buttonPanel = new JPanel();
        this.add((Component)buttonPanel, "South");
        CheckboxGroup cbg = new CheckboxGroup();
        this.pointsBox = new Checkbox("points", cbg, true);
        this.pointsBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                EnvelopeEditorPanel.this.editor.setMode(0);
            }
        });
        buttonPanel.add(this.pointsBox);
        this.sustainBox = new Checkbox("onLoop", cbg, false);
        this.sustainBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                EnvelopeEditorPanel.this.editor.setMode(1);
            }
        });
        buttonPanel.add(this.sustainBox);
        this.releaseBox = new Checkbox("offLoop", cbg, false);
        this.releaseBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                EnvelopeEditorPanel.this.editor.setMode(2);
            }
        });
        buttonPanel.add(this.releaseBox);
        this.autoBox = new Checkbox("AutoStop", false);
        this.yUpButton = new Button("Y*2");
        buttonPanel.add(this.yUpButton);
        this.yUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EnvelopeEditorPanel.this.scaleEnvelopeValues(2.0);
            }
        });
        this.yDownButton = new Button("Y/2");
        buttonPanel.add(this.yDownButton);
        this.yDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EnvelopeEditorPanel.this.scaleEnvelopeValues(0.5);
            }
        });
        double max = this.getMaxEnvelopeValue(this.editor.getPoints());
        this.editor.setMaxWorldY(max);
        buttonPanel.add(new Label("YMax ="));
        final DoubleBoundedRangeModel model = new DoubleBoundedRangeModel("YMax", 100000, 1.0, 100001.0, 1.0);
        this.zoomField = new DoubleBoundedTextField(model, 8);
        buttonPanel.add(this.zoomField);
        model.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    double val = model.getDoubleValue();
                    EnvelopeEditorPanel.this.editor.setMaxWorldY(val);
                    EnvelopeEditorPanel.this.editor.repaint();
                }
                catch (NumberFormatException exp) {
                    EnvelopeEditorPanel.this.zoomField.setText("ERROR");
                    EnvelopeEditorPanel.this.zoomField.selectAll();
                }
            }
        });
        this.validate();
    }

    double getMaxEnvelopeValue(EnvelopePoints points) {
        double max = 1.0;
        for (int i = 0; i < points.size(); ++i) {
            double value = points.getValue(i);
            if (!(value > max)) continue;
            max = value;
        }
        return max;
    }

    void scaleEnvelopeValues(double scalar) {
        EnvelopePoints points = this.editor.getPoints();
        for (int i = 0; i < points.size(); ++i) {
            double[] dar = points.getPoint(i);
            dar[1] = dar[1] * scalar;
        }
        points.setDirty(true);
        this.editor.repaint();
    }
}

