/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.swing;

import com.jsyn.data.SegmentedEnvelope;
import java.util.Vector;

public class EnvelopePoints
extends Vector {
    private String name = "";
    private double maximumValue = 1.0;
    private int sustainBegin = -1;
    private int sustainEnd = -1;
    private int releaseBegin = -1;
    private int releaseEnd = -1;
    private boolean dirty = false;

    public void updateEnvelopeIfDirty(SegmentedEnvelope envelope) {
        if (this.dirty) {
            this.updateEnvelope(envelope);
        }
    }

    public void updateEnvelope(SegmentedEnvelope envelope) {
        int numFrames = this.size();
        for (int i = 0; i < numFrames; ++i) {
            envelope.write(i, this.getPoint(i), 0, 1);
        }
        envelope.setSustainBegin(this.getSustainBegin());
        envelope.setSustainEnd(this.getSustainEnd());
        envelope.setReleaseBegin(this.getReleaseBegin());
        envelope.setReleaseEnd(this.getReleaseEnd());
        envelope.setNumFrames(numFrames);
        this.dirty = false;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setMaximumValue(double maximumValue) {
        this.maximumValue = maximumValue;
    }

    public double getMaximumValue() {
        return this.maximumValue;
    }

    public void add(double dur, double value) {
        double[] dar = new double[]{dur, value};
        this.addElement(dar);
        this.dirty = true;
    }

    public void insert(int index, double dur, double y) {
        double[] dar = new double[]{dur, y};
        if (index < this.size()) {
            double[] dArray = (double[])this.elementAt(index);
            dArray[0] = dArray[0] - dur;
        }
        this.insertElementAt(dar, index);
        if (index <= this.sustainBegin) {
            ++this.sustainBegin;
        }
        if (index <= this.sustainEnd) {
            ++this.sustainEnd;
        }
        if (index <= this.releaseBegin) {
            ++this.releaseBegin;
        }
        if (index <= this.releaseEnd) {
            ++this.releaseEnd;
        }
        this.dirty = true;
    }

    public void removePoint(int index) {
        super.removeElementAt(index);
        if (index < this.sustainBegin) {
            --this.sustainBegin;
        }
        if (index <= this.sustainEnd) {
            --this.sustainEnd;
        }
        if (index < this.releaseBegin) {
            --this.releaseBegin;
        }
        if (index <= this.releaseEnd) {
            --this.releaseEnd;
        }
        if (this.sustainBegin > this.sustainEnd) {
            this.sustainBegin = -1;
            this.sustainEnd = -1;
        }
        if (this.releaseBegin > this.releaseEnd) {
            this.releaseBegin = -1;
            this.releaseEnd = -1;
        }
        this.dirty = true;
    }

    public double getDuration(int index) {
        return ((double[])this.elementAt(index))[0];
    }

    public double getValue(int index) {
        return ((double[])this.elementAt(index))[1];
    }

    public double[] getPoint(int index) {
        return (double[])this.elementAt(index);
    }

    public double getTotalDuration() {
        double sum = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            double[] dar = (double[])this.elementAt(i);
            sum += dar[0];
        }
        return sum;
    }

    public void setSustainLoop(int startFrame, int endFrame) {
        this.sustainBegin = startFrame;
        this.sustainEnd = endFrame;
        this.dirty = true;
    }

    public int getSustainBegin() {
        return this.sustainBegin;
    }

    public int getSustainEnd() {
        return this.sustainEnd;
    }

    public int getSustainSize() {
        return this.sustainEnd - this.sustainBegin;
    }

    public void setReleaseLoop(int startFrame, int endFrame) {
        this.releaseBegin = startFrame;
        this.releaseEnd = endFrame;
        this.dirty = true;
    }

    public int getReleaseBegin() {
        return this.releaseBegin;
    }

    public int getReleaseEnd() {
        return this.releaseEnd;
    }

    public int getReleaseSize() {
        return this.releaseEnd - this.releaseBegin;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean b) {
        this.dirty = b;
    }
}

