/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.unitgen.GrainCommon;
import com.jsyn.unitgen.GrainSource;
import com.jsyn.unitgen.SineOscillator;

public class GrainSourceSine
extends GrainCommon
implements GrainSource {
    protected double phase;
    protected double phaseIncrement;

    public GrainSourceSine() {
        this.setRate(1.0);
    }

    public void setPhaseIncrement(double phaseIncrement) {
        this.phaseIncrement = phaseIncrement;
    }

    @Override
    public double next() {
        this.phase += this.phaseIncrement;
        if (this.phase > 1.0) {
            this.phase -= 2.0;
        }
        return SineOscillator.fastSin(this.phase);
    }

    @Override
    public void setRate(double rate) {
        this.setPhaseIncrement(rate * 0.1 / Math.PI);
    }
}

