/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.unitgen.UnitFilter;

public class InterpolatingDelay
extends UnitFilter {
    public UnitInputPort delay = new UnitInputPort("Delay");
    private float[] buffer;
    private int cursor;
    private int numFrames;

    public InterpolatingDelay() {
        this.addPort(this.delay);
    }

    public void allocate(int numFrames) {
        this.numFrames = numFrames;
        this.buffer = new float[numFrames + 1];
    }

    @Override
    public void generate(int start, int limit) {
        double[] inputs = this.input.getValues();
        double[] outputs = this.output.getValues();
        double[] delays = this.delay.getValues();
        for (int i = start; i < limit; ++i) {
            if (this.cursor == this.numFrames) {
                this.buffer[this.numFrames] = (float)inputs[i];
                this.cursor = 0;
            }
            this.buffer[this.cursor] = (float)inputs[i];
            double delayFrames = delays[i] * (double)this.getFrameRate();
            if (delayFrames <= 0.0) {
                outputs[i] = this.buffer[this.cursor];
            } else {
                double readIndex;
                if (delayFrames >= (double)this.numFrames) {
                    delayFrames = this.numFrames - 1;
                }
                if ((readIndex = (double)this.cursor - delayFrames) < 0.0) {
                    readIndex += (double)this.numFrames;
                }
                int iReadIndex = (int)readIndex;
                double frac = readIndex - (double)iReadIndex;
                double val0 = this.buffer[iReadIndex];
                double val1 = this.buffer[iReadIndex + 1];
                outputs[i] = val0 + frac * (val1 - val0);
            }
            ++this.cursor;
        }
    }
}

