/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.data.SpectralWindow;
import com.jsyn.data.Spectrum;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.ports.UnitSpectralInputPort;
import com.jsyn.unitgen.RectangularWindow;
import com.jsyn.unitgen.UnitGenerator;
import com.softsynth.math.FourierMath;

public class SpectralIFFT
extends UnitGenerator {
    public UnitSpectralInputPort input;
    public UnitOutputPort output;
    private Spectrum localSpectrum;
    private double[] buffer;
    private int cursor;
    private SpectralWindow window = RectangularWindow.getInstance();

    public SpectralIFFT() {
        this.output = new UnitOutputPort();
        this.addPort(this.output);
        this.input = new UnitSpectralInputPort("Input");
        this.addPort(this.input);
    }

    @Override
    public void generate(int start, int limit) {
        double[] outputs = this.output.getValues();
        if (this.buffer == null) {
            if (this.input.isAvailable()) {
                Spectrum spectrum = this.input.getSpectrum();
                int size = spectrum.size();
                this.localSpectrum = new Spectrum(size);
                this.buffer = this.localSpectrum.getReal();
                this.cursor = 0;
            } else {
                for (int i = start; i < limit; ++i) {
                    outputs[i] = 0.0;
                }
            }
        }
        if (this.buffer != null) {
            for (int i = start; i < limit; ++i) {
                if (this.cursor == 0) {
                    Spectrum spectrum = this.input.getSpectrum();
                    spectrum.copyTo(this.localSpectrum);
                    FourierMath.ifft(this.buffer.length, this.localSpectrum.getReal(), this.localSpectrum.getImaginary());
                }
                outputs[i] = this.buffer[this.cursor] * this.window.get(this.cursor);
                ++this.cursor;
                if (this.cursor != this.buffer.length) continue;
                this.cursor = 0;
            }
        }
    }

    public SpectralWindow getWindow() {
        return this.window;
    }

    public void setWindow(SpectralWindow window) {
        this.window = window;
    }
}

