/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.util;

import java.util.Random;

public class PseudoRandom {
    private static final double INT_TO_DOUBLE = 4.656612873077393E-10;
    private long seed = 99887766L;

    public PseudoRandom() {
        this(new Random().nextInt());
    }

    public PseudoRandom(int seed) {
        this.setSeed(seed);
    }

    public void setSeed(int seed) {
        this.seed = seed;
    }

    public int getSeed() {
        return (int)this.seed;
    }

    public double random() {
        int positiveInt = this.nextRandomInteger() & Integer.MAX_VALUE;
        return (double)positiveInt * 4.656612873077393E-10;
    }

    public double nextRandomDouble() {
        return (double)this.nextRandomInteger() * 4.656612873077393E-10;
    }

    public int nextRandomInteger() {
        this.seed = this.seed * 6364136223846793005L + 1442695040888963407L;
        return (int)(this.seed >> 32);
    }

    public int choose(int range) {
        long positiveInt = this.nextRandomInteger() & Integer.MAX_VALUE;
        long temp = positiveInt * (long)range;
        return (int)(temp >> 31);
    }
}

