/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.util;

import com.jsyn.data.FloatSample;
import com.jsyn.util.AudioSampleLoader;
import com.jsyn.util.JavaTools;
import com.jsyn.util.soundfile.CustomSampleLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class SampleLoader {
    private static boolean javaSoundPreferred = false;
    private static final String JS_LOADER_NAME = "com.jsyn.util.JavaSoundSampleLoader";

    private static AudioSampleLoader createLoader() {
        AudioSampleLoader loader = null;
        try {
            loader = javaSoundPreferred ? (AudioSampleLoader)JavaTools.loadClass(JS_LOADER_NAME).newInstance() : new CustomSampleLoader();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return loader;
    }

    public static FloatSample loadFloatSample(File fileIn) throws IOException {
        AudioSampleLoader loader = SampleLoader.createLoader();
        return loader.loadFloatSample(fileIn);
    }

    public static FloatSample loadFloatSample(InputStream inputStream) throws IOException {
        AudioSampleLoader loader = SampleLoader.createLoader();
        return loader.loadFloatSample(inputStream);
    }

    public static FloatSample loadFloatSample(URL url) throws IOException {
        AudioSampleLoader loader = SampleLoader.createLoader();
        return loader.loadFloatSample(url);
    }

    public static boolean isJavaSoundPreferred() {
        return javaSoundPreferred;
    }

    public static void setJavaSoundPreferred(boolean javaSoundPreferred) {
        SampleLoader.javaSoundPreferred = javaSoundPreferred;
    }

    public static void decodeBigI24ToF32(byte[] audioBytes, int offset, int numBytes, float[] data, int outputOffset) {
        int lastByte = offset + numBytes;
        int byteCursor = offset;
        int floatCursor = outputOffset;
        while (byteCursor < lastByte) {
            int hi = audioBytes[byteCursor++] & 0xFF;
            int mid = audioBytes[byteCursor++] & 0xFF;
            int lo = audioBytes[byteCursor++] & 0xFF;
            int value = hi << 24 | mid << 16 | lo << 8;
            data[floatCursor++] = (float)value * 4.656613E-10f;
        }
    }

    public static void decodeBigI16ToF32(byte[] audioBytes, int offset, int numBytes, float[] data, int outputOffset) {
        int lastByte = offset + numBytes;
        int byteCursor = offset;
        int floatCursor = outputOffset;
        while (byteCursor < lastByte) {
            int hi = audioBytes[byteCursor++] & 0xFF;
            int lo = audioBytes[byteCursor++] & 0xFF;
            short value = (short)(hi << 8 | lo);
            data[floatCursor++] = (float)value * 3.0517578E-5f;
        }
    }

    public static void decodeBigF32ToF32(byte[] audioBytes, int offset, int numBytes, float[] data, int outputOffset) {
        int lastByte = offset + numBytes;
        int byteCursor = offset;
        int floatCursor = outputOffset;
        while (byteCursor < lastByte) {
            int bits = audioBytes[byteCursor++];
            bits = bits << 8 | audioBytes[byteCursor++] & 0xFF;
            bits = bits << 8 | audioBytes[byteCursor++] & 0xFF;
            bits = bits << 8 | audioBytes[byteCursor++] & 0xFF;
            data[floatCursor++] = Float.intBitsToFloat(bits);
        }
    }

    public static void decodeBigI32ToF32(byte[] audioBytes, int offset, int numBytes, float[] data, int outputOffset) {
        int lastByte = offset + numBytes;
        int byteCursor = offset;
        int floatCursor = outputOffset;
        while (byteCursor < lastByte) {
            int value = audioBytes[byteCursor++];
            value = value << 8 | audioBytes[byteCursor++] & 0xFF;
            value = value << 8 | audioBytes[byteCursor++] & 0xFF;
            value = value << 8 | audioBytes[byteCursor++] & 0xFF;
            data[floatCursor++] = (float)value * 4.656613E-10f;
        }
    }

    public static void decodeLittleF32ToF32(byte[] audioBytes, int offset, int numBytes, float[] data, int outputOffset) {
        int lastByte = offset + numBytes;
        int byteCursor = offset;
        int floatCursor = outputOffset;
        while (byteCursor < lastByte) {
            int bits = audioBytes[byteCursor++] & 0xFF;
            bits += (audioBytes[byteCursor++] & 0xFF) << 8;
            bits += (audioBytes[byteCursor++] & 0xFF) << 16;
            data[floatCursor++] = Float.intBitsToFloat(bits += audioBytes[byteCursor++] << 24);
        }
    }

    public static void decodeLittleI32ToF32(byte[] audioBytes, int offset, int numBytes, float[] data, int outputOffset) {
        int lastByte = offset + numBytes;
        int byteCursor = offset;
        int floatCursor = outputOffset;
        while (byteCursor < lastByte) {
            int value = audioBytes[byteCursor++] & 0xFF;
            value += (audioBytes[byteCursor++] & 0xFF) << 8;
            value += (audioBytes[byteCursor++] & 0xFF) << 16;
            data[floatCursor++] = (float)(value += audioBytes[byteCursor++] << 24) * 4.656613E-10f;
        }
    }

    public static void decodeLittleI24ToF32(byte[] audioBytes, int offset, int numBytes, float[] data, int outputOffset) {
        int lastByte = offset + numBytes;
        int byteCursor = offset;
        int floatCursor = outputOffset;
        while (byteCursor < lastByte) {
            int lo = audioBytes[byteCursor++] & 0xFF;
            int mid = audioBytes[byteCursor++] & 0xFF;
            int hi = audioBytes[byteCursor++] & 0xFF;
            int value = hi << 24 | mid << 16 | lo << 8;
            data[floatCursor++] = (float)value * 4.656613E-10f;
        }
    }

    public static void decodeLittleI16ToF32(byte[] audioBytes, int offset, int numBytes, float[] data, int outputOffset) {
        int lastByte = offset + numBytes;
        int byteCursor = offset;
        int floatCursor = outputOffset;
        while (byteCursor < lastByte) {
            int lo = audioBytes[byteCursor++] & 0xFF;
            int hi = audioBytes[byteCursor++] & 0xFF;
            short value = (short)(hi << 8 | lo);
            float sample = (float)value * 3.0517578E-5f;
            data[floatCursor++] = sample;
        }
    }
}

