/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.util;

import com.jsyn.util.TransportListener;
import java.util.concurrent.CopyOnWriteArrayList;

public class TransportModel {
    public static final int STATE_STOPPED = 0;
    public static final int STATE_PAUSED = 1;
    public static final int STATE_RUNNING = 2;
    private CopyOnWriteArrayList<TransportListener> listeners = new CopyOnWriteArrayList();
    private int state = 0;
    private long position;

    public void addTransportListener(TransportListener listener) {
        this.listeners.add(listener);
    }

    public void removeTransportListener(TransportListener listener) {
        this.listeners.remove(listener);
    }

    public void setState(int newState) {
        this.state = newState;
        this.fireStateChanged(newState);
    }

    public int getState() {
        return this.state;
    }

    public void setPosition(long newPosition) {
        this.position = newPosition;
        this.firePositionChanged(newPosition);
    }

    public long getPosition() {
        return this.position;
    }

    public void fireStateChanged(int newState) {
        for (TransportListener listener : this.listeners) {
            listener.stateChanged(this, newState);
        }
    }

    public void firePositionChanged(long newPosition) {
        for (TransportListener listener : this.listeners) {
            listener.positionChanged(this, newPosition);
        }
    }
}

