/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.shared.time;

import com.softsynth.shared.time.TimeStamp;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

public class ScheduledQueue<T> {
    private final SortedMap<TimeStamp, List<T>> timeNodes = new TreeMap<TimeStamp, List<T>>();

    public boolean isEmpty() {
        return this.timeNodes.isEmpty();
    }

    public synchronized void add(TimeStamp time, T obj) {
        LinkedList<T> timeList = (LinkedList<T>)this.timeNodes.get(time);
        if (timeList == null) {
            timeList = new LinkedList<T>();
            this.timeNodes.put(time, timeList);
        }
        timeList.add(obj);
    }

    public synchronized List<T> removeNextList(TimeStamp time) {
        TimeStamp lowestTime;
        List timeList = null;
        if (!this.timeNodes.isEmpty() && (lowestTime = this.timeNodes.firstKey()).compareTo(time) <= 0) {
            timeList = (List)this.timeNodes.remove(lowestTime);
        }
        return timeList;
    }

    public synchronized Object removeNext(TimeStamp time) {
        List timeList;
        TimeStamp lowestTime;
        Object next = null;
        if (!this.timeNodes.isEmpty() && (lowestTime = this.timeNodes.firstKey()).compareTo(time) <= 0 && (timeList = (List)this.timeNodes.get(lowestTime)) != null) {
            next = timeList.remove(0);
            if (timeList.isEmpty()) {
                this.timeNodes.remove(lowestTime);
            }
        }
        return next;
    }

    public synchronized void clear() {
        this.timeNodes.clear();
    }

    public TimeStamp getNextTime() {
        return this.timeNodes.firstKey();
    }
}

