/*
The wavelengths of visible light are:
Violet: 380–450 nm (688–789 THz frequency)
Blue: 450–495 nm.
Green: 495–570 nm.
Yellow: 570–590 nm.
Orange: 590–620 nm.
Red: 620–750 nm (400–484 THz frequency)
*/

/*
Converting Sound to Color
The code above converts the frequency of sound to a frequency of light by doubling the sound frenency (going up one octave each time) until it reaches a frequency in the range of 400–800 THz (400,000,000,000,000 – 800,000,000,000,000 Hz).

That frequency is then converted into a wavelength of light, using the formula:

wavelength = speedOfLight / frequency

The speed of light that is used is the observed speed of light in a vacuum (299,792,458 m/sec).

I believe that this is a reasonable approach, even though we are not playing these sounds in a vacuum. The code for rendering colors (see below) is based on this same constant for speed of light; When looking at resonance, I believe that it is really the frequency of the sound and light that we want to match, not the wavelength.

Rendering Colors of Light
To display a particular wavelength of light on HTML Web pages is problematic.

Colors of light are pure frequencies that our eyes perceive as a single color. The RGB (red, green, blue) color system used by HTML and as displayed on most color monitors uses a blend of three pure light sources (a red gun, a green gun, and a blue gun, in the case of the older CRT displays) to create the impression of a single color to our eyes. In the RGB system our eyes perceive some colors that do not exist as pure colors of the spectrum, such as pink and white. These colors are blends of multiple colors from the pure spectum. The RGB color model is called an “additive" color system, because it is adding colors together to render a perceived color.

To render pure colors as RGB, I have used this table from [Bruno 2006], page 2:

Color  Frequency  Wavelength
violet  668–789 THz  380–450 nm
blue  631–668 THz  450–475 nm
cyan  606–630 THz  476–495 nm
green  526–606 THz  495–570 nm
yellow  508–526 THz  570–590 nm
orange  484–508 THz  590–620 nm
red  400–484 THz  620–750 nm
To approximate these colors in the RGB color model, I coded a JavaScript routine that is based on code implemented in C# by Phillip Laven that was originally from a Fortran coding of an algorithm from Dan Bruton's Color Science Page. Note that my JavaScript version is heavily modified, so the results do not match these earlier C# and Fortran implementations, but more closely approximate this rendering done in 2010 by David Eccles (generated from code he implemented in R):

Sound Spectrum by David Eccles

A description of this rendering is provided on the Wikimedia page for this image, and the code that generated this image is available at this code page.

If you print these color renditions, the problems of color rendition are compounded. Most printers use yet another color model, CMYK (Cyan, Magenta, Yellow, Black). Not only are the RGB colors converted to CMYK colors somewhere along the path from web page to printer, but the printer color model is a “subtractive” model — the paper starts out white and material is tossed onto the page to make it darker.

So, the bottom line is, the color renditions used on Flutopedia for color rendering of wavelengths of light are, at best, a “good try” at displaying colors, but should not be used for work that calls for a more serious treatment.

Converting RGB Colors to Color Frequencies
I've been asked about the possibility of converting an RGB color into a frequency of light. This poses some issues. As part of the pitch-to-color calculator, we’re mapping one number (frequency) onto three numbers (R, G, and B). But we’re not producing all possible combinations of R, G, and B … just some of them. That means that, if you pick an arbitrary R, G, and B, it might not have any frequency that (in my algorithm) would have generated that RGB.

An analogy could be made to drawing a line on a map. Each point on the line can be identified by its distance from the start of the line, and each point on the line has an [X,Y] coordinate on the map. However, each [X,Y] coordinate on the map does not have a position on the line.

Another way to look at this is … consider the rainbow. Can you find brown in it? Not really. But there’s brown in RGB space.
*/
