import json
import sys

_, infile, outfile = sys.argv

with open(infile, "r") as f:
	j = json.load(f)


fieldFirstCode = j["compressedFormat"]["fieldFirstCode"]
fieldCodeBase = j["compressedFormat"]["fieldCodeBase"]
fieldArray = j["compressedFormat"]["fieldArray"]
del j["compressedFormat"]["fieldFirstCode"]
del j["compressedFormat"]["fieldCodeBase"]
del j["compressedFormat"]["fieldArray"]

def decompressKey(k):
	if len(k)>2:
		return k
	i = 0
	for ch in k:
		i = i * fieldCodeBase + ord(ch) - fieldFirstCode
	return fieldArray[i]

def transform(j):
	if type(j) == list:
		return [transform(item) for item in j]
	elif type(j) == dict:
		return {decompressKey(k):transform(v) for k,v in j.items()}
	return j

# only entities section is compressed
j["entities"] = transform(j["entities"])

with open(outfile, "w") as f:
	json.dump(j, f, indent=2)