/**
 * @license
 * PlayCanvas Engine v1.65.5 revision 026dc4259 (RELEASE)
 * Copyright 2011-2023 PlayCanvas Ltd. All rights reserved.
 */
(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
	typeof define === 'function' && define.amd ? define(['exports'], factory) :
	(global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.pc = {}));
})(this, (function (exports) { 'use strict';

	function defineProtoFunc(cls, name, func) {
		if (!cls.prototype[name]) {
			Object.defineProperty(cls.prototype, name, {
				value: func,
				configurable: true,
				enumerable: false,
				writable: true
			});
		}
	}

	defineProtoFunc(Array, 'fill', function (value) {
		if (this == null) {
			throw new TypeError('this is null or not defined');
		}
		var O = Object(this);
		var len = O.length >>> 0;
		var start = arguments[1];
		var relativeStart = start >> 0;
		var k = relativeStart < 0 ? Math.max(len + relativeStart, 0) : Math.min(relativeStart, len);
		var end = arguments[2];
		var relativeEnd = end === undefined ? len : end >> 0;
		var finalValue = relativeEnd < 0 ? Math.max(len + relativeEnd, 0) : Math.min(relativeEnd, len);
		while (k < finalValue) {
			O[k] = value;
			k++;
		}
		return O;
	});

	defineProtoFunc(Array, 'find', function (predicate) {
		if (this == null) {
			throw TypeError('"this" is null or not defined');
		}
		var o = Object(this);
		var len = o.length >>> 0;
		if (typeof predicate !== 'function') {
			throw TypeError('predicate must be a function');
		}
		var thisArg = arguments[1];
		var k = 0;
		while (k < len) {
			var kValue = o[k];
			if (predicate.call(thisArg, kValue, k, o)) {
				return kValue;
			}
			k++;
		}
		return undefined;
	});

	defineProtoFunc(Array, 'findIndex', function (predicate) {
		if (this == null) {
			throw new TypeError('"this" is null or not defined');
		}
		var o = Object(this);
		var len = o.length >>> 0;
		if (typeof predicate !== 'function') {
			throw new TypeError('predicate must be a function');
		}
		var thisArg = arguments[1];
		var k = 0;
		while (k < len) {
			var kValue = o[k];
			if (predicate.call(thisArg, kValue, k, o)) {
				return k;
			}
			k++;
		}
		return -1;
	});

	Math.log2 = Math.log2 || function (x) {
		return Math.log(x) * Math.LOG2E;
	};

	if (!Math.sign) {
		Math.sign = function (x) {
			return (x > 0) - (x < 0) || +x;
		};
	}

	if (Number.isFinite === undefined) Number.isFinite = function (value) {
		return typeof value === 'number' && isFinite(value);
	};

	if (typeof Object.assign != 'function') {
		Object.defineProperty(Object, "assign", {
			value: function assign(target, varArgs) {

				if (target == null) {
					throw new TypeError('Cannot convert undefined or null to object');
				}
				var to = Object(target);
				for (var index = 1; index < arguments.length; index++) {
					var nextSource = arguments[index];
					if (nextSource != null) {
						for (var nextKey in nextSource) {
							if (Object.prototype.hasOwnProperty.call(nextSource, nextKey)) {
								to[nextKey] = nextSource[nextKey];
							}
						}
					}
				}
				return to;
			},
			writable: true,
			configurable: true
		});
	}

	Object.values = Object.values || function (object) {
		return Object.keys(object).map(function (key) {
			return object[key];
		});
	};

	(function () {
		if (typeof navigator === 'undefined' || typeof document === 'undefined') {
			return;
		}
		navigator.pointer = navigator.pointer || navigator.webkitPointer || navigator.mozPointer;
		var pointerlockchange = function pointerlockchange() {
			var e = document.createEvent('CustomEvent');
			e.initCustomEvent('pointerlockchange', true, false, null);
			document.dispatchEvent(e);
		};
		var pointerlockerror = function pointerlockerror() {
			var e = document.createEvent('CustomEvent');
			e.initCustomEvent('pointerlockerror', true, false, null);
			document.dispatchEvent(e);
		};
		document.addEventListener('webkitpointerlockchange', pointerlockchange, false);
		document.addEventListener('webkitpointerlocklost', pointerlockchange, false);
		document.addEventListener('mozpointerlockchange', pointerlockchange, false);
		document.addEventListener('mozpointerlocklost', pointerlockchange, false);
		document.addEventListener('webkitpointerlockerror', pointerlockerror, false);
		document.addEventListener('mozpointerlockerror', pointerlockerror, false);
		if (Element.prototype.mozRequestPointerLock) {
			Element.prototype.requestPointerLock = function () {
				this.mozRequestPointerLock();
			};
		} else {
			Element.prototype.requestPointerLock = Element.prototype.requestPointerLock || Element.prototype.webkitRequestPointerLock || Element.prototype.mozRequestPointerLock;
		}
		if (!Element.prototype.requestPointerLock && navigator.pointer) {
			Element.prototype.requestPointerLock = function () {
				var el = this;
				document.pointerLockElement = el;
				navigator.pointer.lock(el, pointerlockchange, pointerlockerror);
			};
		}
		document.exitPointerLock = document.exitPointerLock || document.webkitExitPointerLock || document.mozExitPointerLock;
		if (!document.exitPointerLock) {
			document.exitPointerLock = function () {
				if (navigator.pointer) {
					document.pointerLockElement = null;
					navigator.pointer.unlock();
				}
			};
		}
	})();

	defineProtoFunc(String, 'endsWith', function (search, this_len) {
		if (this_len === undefined || this_len > this.length) {
			this_len = this.length;
		}
		return this.substring(this_len - search.length, this_len) === search;
	});
	defineProtoFunc(String, 'includes', function (search, start) {

		if (typeof start !== 'number') {
			start = 0;
		}
		if (start + search.length > this.length) {
			return false;
		} else {
			return this.indexOf(search, start) !== -1;
		}
	});
	defineProtoFunc(String, 'startsWith', function (search, rawPos) {
		var pos = rawPos > 0 ? rawPos | 0 : 0;
		return this.substring(pos, pos + search.length) === search;
	});
	defineProtoFunc(String, 'trimEnd', function () {
		return this.replace(new RegExp(/[\x09\x0A\x0B\x0C\x0D\x20\xA0\u1680\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u3000\u2028\u2029\uFEFF]+/.source + '$', 'g'), '');
	});

	var typedArrays = [Int8Array, Uint8Array, Uint8ClampedArray, Int16Array, Uint16Array, Int32Array, Uint32Array, Float32Array];
	for (var _i = 0, _typedArrays = typedArrays; _i < _typedArrays.length; _i++) {
		var typedArray = _typedArrays[_i];
		defineProtoFunc(typedArray, "fill", Array.prototype.fill);
		defineProtoFunc(typedArray, "join", Array.prototype.join);
	}

	var glErrorShadow = {};
	function error(msg) {
		if (window.console && window.console.error) {
			window.console.error(msg);
		}
	}
	function log$1(msg) {
		if (window.console && window.console.log) {
			window.console.log(msg);
		}
	}
	function synthesizeGLError(err, opt_msg) {
		glErrorShadow[err] = true;
		if (opt_msg !== undefined) {
			error(opt_msg);
		}
	}
	function wrapGLError(gl) {
		var f = gl.getError;
		gl.getError = function () {
			var err;
			do {
				err = f.apply(gl);
				if (err != gl.NO_ERROR) {
					glErrorShadow[err] = true;
				}
			} while (err != gl.NO_ERROR);
			for (var err in glErrorShadow) {
				if (glErrorShadow[err]) {
					delete glErrorShadow[err];
					return parseInt(err);
				}
			}
			return gl.NO_ERROR;
		};
	}
	var WebGLVertexArrayObjectOES = function WebGLVertexArrayObjectOES(ext) {
		var gl = ext.gl;
		this.ext = ext;
		this.isAlive = true;
		this.hasBeenBound = false;
		this.elementArrayBuffer = null;
		this.attribs = new Array(ext.maxVertexAttribs);
		for (var n = 0; n < this.attribs.length; n++) {
			var attrib = new WebGLVertexArrayObjectOES.VertexAttrib(gl);
			this.attribs[n] = attrib;
		}
		this.maxAttrib = 0;
	};
	WebGLVertexArrayObjectOES.VertexAttrib = function VertexAttrib(gl) {
		this.enabled = false;
		this.buffer = null;
		this.size = 4;
		this.type = gl.FLOAT;
		this.normalized = false;
		this.stride = 16;
		this.offset = 0;
		this.cached = "";
		this.recache();
	};
	WebGLVertexArrayObjectOES.VertexAttrib.prototype.recache = function recache() {
		this.cached = [this.size, this.type, this.normalized, this.stride, this.offset].join(":");
	};
	var OESVertexArrayObject = function OESVertexArrayObject(gl) {
		var self = this;
		this.gl = gl;
		wrapGLError(gl);
		var original = this.original = {
			getParameter: gl.getParameter,
			enableVertexAttribArray: gl.enableVertexAttribArray,
			disableVertexAttribArray: gl.disableVertexAttribArray,
			bindBuffer: gl.bindBuffer,
			getVertexAttrib: gl.getVertexAttrib,
			vertexAttribPointer: gl.vertexAttribPointer
		};
		gl.getParameter = function getParameter(pname) {
			if (pname == self.VERTEX_ARRAY_BINDING_OES) {
				if (self.currentVertexArrayObject == self.defaultVertexArrayObject) {
					return null;
				} else {
					return self.currentVertexArrayObject;
				}
			}
			return original.getParameter.apply(this, arguments);
		};
		gl.enableVertexAttribArray = function enableVertexAttribArray(index) {
			var vao = self.currentVertexArrayObject;
			vao.maxAttrib = Math.max(vao.maxAttrib, index);
			var attrib = vao.attribs[index];
			attrib.enabled = true;
			return original.enableVertexAttribArray.apply(this, arguments);
		};
		gl.disableVertexAttribArray = function disableVertexAttribArray(index) {
			var vao = self.currentVertexArrayObject;
			vao.maxAttrib = Math.max(vao.maxAttrib, index);
			var attrib = vao.attribs[index];
			attrib.enabled = false;
			return original.disableVertexAttribArray.apply(this, arguments);
		};
		gl.bindBuffer = function bindBuffer(target, buffer) {
			switch (target) {
				case gl.ARRAY_BUFFER:
					self.currentArrayBuffer = buffer;
					break;
				case gl.ELEMENT_ARRAY_BUFFER:
					self.currentVertexArrayObject.elementArrayBuffer = buffer;
					break;
			}
			return original.bindBuffer.apply(this, arguments);
		};
		gl.getVertexAttrib = function getVertexAttrib(index, pname) {
			var vao = self.currentVertexArrayObject;
			var attrib = vao.attribs[index];
			switch (pname) {
				case gl.VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:
					return attrib.buffer;
				case gl.VERTEX_ATTRIB_ARRAY_ENABLED:
					return attrib.enabled;
				case gl.VERTEX_ATTRIB_ARRAY_SIZE:
					return attrib.size;
				case gl.VERTEX_ATTRIB_ARRAY_STRIDE:
					return attrib.stride;
				case gl.VERTEX_ATTRIB_ARRAY_TYPE:
					return attrib.type;
				case gl.VERTEX_ATTRIB_ARRAY_NORMALIZED:
					return attrib.normalized;
				default:
					return original.getVertexAttrib.apply(this, arguments);
			}
		};
		gl.vertexAttribPointer = function vertexAttribPointer(indx, size, type, normalized, stride, offset) {
			var vao = self.currentVertexArrayObject;
			vao.maxAttrib = Math.max(vao.maxAttrib, indx);
			var attrib = vao.attribs[indx];
			attrib.buffer = self.currentArrayBuffer;
			attrib.size = size;
			attrib.type = type;
			attrib.normalized = normalized;
			attrib.stride = stride;
			attrib.offset = offset;
			attrib.recache();
			return original.vertexAttribPointer.apply(this, arguments);
		};
		if (gl.instrumentExtension) {
			gl.instrumentExtension(this, "OES_vertex_array_object");
		}
		gl.canvas.addEventListener('webglcontextrestored', function () {
			log$1("OESVertexArrayObject emulation library context restored");
			self.reset_();
		}, true);
		this.reset_();
	};
	OESVertexArrayObject.prototype.VERTEX_ARRAY_BINDING_OES = 0x85B5;
	OESVertexArrayObject.prototype.reset_ = function reset_() {
		var contextWasLost = this.vertexArrayObjects !== undefined;
		if (contextWasLost) {
			for (var ii = 0; ii < this.vertexArrayObjects.length; ++ii) {
				this.vertexArrayObjects.isAlive = false;
			}
		}
		var gl = this.gl;
		this.maxVertexAttribs = gl.getParameter(gl.MAX_VERTEX_ATTRIBS);
		this.defaultVertexArrayObject = new WebGLVertexArrayObjectOES(this);
		this.currentVertexArrayObject = null;
		this.currentArrayBuffer = null;
		this.vertexArrayObjects = [this.defaultVertexArrayObject];
		this.bindVertexArrayOES(null);
	};
	OESVertexArrayObject.prototype.createVertexArrayOES = function createVertexArrayOES() {
		var arrayObject = new WebGLVertexArrayObjectOES(this);
		this.vertexArrayObjects.push(arrayObject);
		return arrayObject;
	};
	OESVertexArrayObject.prototype.deleteVertexArrayOES = function deleteVertexArrayOES(arrayObject) {
		arrayObject.isAlive = false;
		this.vertexArrayObjects.splice(this.vertexArrayObjects.indexOf(arrayObject), 1);
		if (this.currentVertexArrayObject == arrayObject) {
			this.bindVertexArrayOES(null);
		}
	};
	OESVertexArrayObject.prototype.isVertexArrayOES = function isVertexArrayOES(arrayObject) {
		if (arrayObject && arrayObject instanceof WebGLVertexArrayObjectOES) {
			if (arrayObject.hasBeenBound && arrayObject.ext == this) {
				return true;
			}
		}
		return false;
	};
	OESVertexArrayObject.prototype.bindVertexArrayOES = function bindVertexArrayOES(arrayObject) {
		var gl = this.gl;
		if (arrayObject && !arrayObject.isAlive) {
			synthesizeGLError(gl.INVALID_OPERATION, "bindVertexArrayOES: attempt to bind deleted arrayObject");
			return;
		}
		var original = this.original;
		var oldVAO = this.currentVertexArrayObject;
		this.currentVertexArrayObject = arrayObject || this.defaultVertexArrayObject;
		this.currentVertexArrayObject.hasBeenBound = true;
		var newVAO = this.currentVertexArrayObject;
		if (oldVAO == newVAO) {
			return;
		}
		if (!oldVAO || newVAO.elementArrayBuffer != oldVAO.elementArrayBuffer) {
			original.bindBuffer.call(gl, gl.ELEMENT_ARRAY_BUFFER, newVAO.elementArrayBuffer);
		}
		var currentBinding = this.currentArrayBuffer;
		var maxAttrib = Math.max(oldVAO ? oldVAO.maxAttrib : 0, newVAO.maxAttrib);
		for (var n = 0; n <= maxAttrib; n++) {
			var attrib = newVAO.attribs[n];
			var oldAttrib = oldVAO ? oldVAO.attribs[n] : null;
			if (!oldVAO || attrib.enabled != oldAttrib.enabled) {
				if (attrib.enabled) {
					original.enableVertexAttribArray.call(gl, n);
				} else {
					original.disableVertexAttribArray.call(gl, n);
				}
			}
			if (attrib.enabled) {
				var bufferChanged = false;
				if (!oldVAO || attrib.buffer != oldAttrib.buffer) {
					if (currentBinding != attrib.buffer) {
						original.bindBuffer.call(gl, gl.ARRAY_BUFFER, attrib.buffer);
						currentBinding = attrib.buffer;
					}
					bufferChanged = true;
				}
				if (bufferChanged || attrib.cached != oldAttrib.cached) {
					original.vertexAttribPointer.call(gl, n, attrib.size, attrib.type, attrib.normalized, attrib.stride, attrib.offset);
				}
			}
		}
		if (this.currentArrayBuffer != currentBinding) {
			original.bindBuffer.call(gl, gl.ARRAY_BUFFER, this.currentArrayBuffer);
		}
	};
	var setupVertexArrayObject = function setupVertexArrayObject(gl) {
		if (gl.getSupportedExtensions) {
			var exts = gl.getSupportedExtensions();
			if (exts.indexOf("OES_vertex_array_object") != -1) {
				return;
			}
		} else if (gl.getExtension) {
			var vao = gl.getExtension("OES_vertex_array_object");
			if (vao) {
				return;
			}
		}
		if (gl.getSupportedExtensions) {
			var original_getSupportedExtensions = gl.getSupportedExtensions;
			gl.getSupportedExtensions = function getSupportedExtensions() {
				var list = original_getSupportedExtensions.call(this) || [];
				list.push("OES_vertex_array_object");
				return list;
			};
		}
		var original_getExtension = gl.getExtension;
		gl.getExtension = function getExtension(name) {
			if (name == "OES_vertex_array_object") {
				if (!gl.__OESVertexArrayObject) {
					gl.__OESVertexArrayObject = new OESVertexArrayObject(gl);
				}
				return gl.__OESVertexArrayObject;
			}
			if (original_getExtension) {
				return original_getExtension.call(this, name);
			} else {
				return null;
			}
		};
	};

	var TRACEID_RENDER_FRAME = 'RenderFrame';
	var TRACEID_RENDER_FRAME_TIME = 'RenderFrameTime';
	var TRACEID_RENDER_PASS = 'RenderPass';
	var TRACEID_RENDER_PASS_DETAIL = 'RenderPassDetail';
	var TRACEID_RENDER_ACTION = 'RenderAction';
	var TRACEID_RENDER_TARGET_ALLOC = 'RenderTargetAlloc';
	var TRACEID_TEXTURE_ALLOC = 'TextureAlloc';
	var TRACEID_SHADER_ALLOC = 'ShaderAlloc';
	var TRACEID_SHADER_COMPILE = 'ShaderCompile';
	var TRACEID_VRAM_TEXTURE = 'VRAM.Texture';
	var TRACEID_VRAM_VB = 'VRAM.Vb';
	var TRACEID_VRAM_IB = 'VRAM.Ib';
	var TRACEID_BINDGROUP_ALLOC = 'BindGroupAlloc';
	var TRACEID_BINDGROUPFORMAT_ALLOC = 'BindGroupFormatAlloc';
	var TRACEID_RENDERPIPELINE_ALLOC = 'RenderPipelineAlloc';
	var TRACEID_PIPELINELAYOUT_ALLOC = 'PipelineLayoutAlloc';
	var TRACE_ID_ELEMENT = "Element";
	var TRACEID_TEXTURES = 'Textures';
	var TRACEID_RENDER_QUEUE = 'RenderQueue';
	var TRACEID_GPU_TIMINGS = 'GpuTimings';

	var version = '1.65.5';
	var revision = '026dc4259';
	var config = {};
	var common = {};
	var apps = {};
	var data = {};
	var _typeLookup = function () {
		var result = {};
		var names = ['Array', 'Object', 'Function', 'Date', 'RegExp', 'Float32Array'];
		for (var i = 0; i < names.length; i++) result['[object ' + names[i] + ']'] = names[i].toLowerCase();
		return result;
	}();
	function type$1(obj) {
		if (obj === null) {
			return 'null';
		}
		var type = typeof obj;
		if (type === 'undefined' || type === 'number' || type === 'string' || type === 'boolean') {
			return type;
		}
		return _typeLookup[Object.prototype.toString.call(obj)];
	}
	function extend(target, ex) {
		for (var prop in ex) {
			var copy = ex[prop];
			if (type$1(copy) === 'object') {
				target[prop] = extend({}, copy);
			} else if (type$1(copy) === 'array') {
				target[prop] = extend([], copy);
			} else {
				target[prop] = copy;
			}
		}
		return target;
	}

	function _regeneratorRuntime() {
	  _regeneratorRuntime = function () {
	    return exports;
	  };
	  var exports = {},
	    Op = Object.prototype,
	    hasOwn = Op.hasOwnProperty,
	    defineProperty = Object.defineProperty || function (obj, key, desc) {
	      obj[key] = desc.value;
	    },
	    $Symbol = "function" == typeof Symbol ? Symbol : {},
	    iteratorSymbol = $Symbol.iterator || "@@iterator",
	    asyncIteratorSymbol = $Symbol.asyncIterator || "@@asyncIterator",
	    toStringTagSymbol = $Symbol.toStringTag || "@@toStringTag";
	  function define(obj, key, value) {
	    return Object.defineProperty(obj, key, {
	      value: value,
	      enumerable: !0,
	      configurable: !0,
	      writable: !0
	    }), obj[key];
	  }
	  try {
	    define({}, "");
	  } catch (err) {
	    define = function (obj, key, value) {
	      return obj[key] = value;
	    };
	  }
	  function wrap(innerFn, outerFn, self, tryLocsList) {
	    var protoGenerator = outerFn && outerFn.prototype instanceof Generator ? outerFn : Generator,
	      generator = Object.create(protoGenerator.prototype),
	      context = new Context(tryLocsList || []);
	    return defineProperty(generator, "_invoke", {
	      value: makeInvokeMethod(innerFn, self, context)
	    }), generator;
	  }
	  function tryCatch(fn, obj, arg) {
	    try {
	      return {
	        type: "normal",
	        arg: fn.call(obj, arg)
	      };
	    } catch (err) {
	      return {
	        type: "throw",
	        arg: err
	      };
	    }
	  }
	  exports.wrap = wrap;
	  var ContinueSentinel = {};
	  function Generator() {}
	  function GeneratorFunction() {}
	  function GeneratorFunctionPrototype() {}
	  var IteratorPrototype = {};
	  define(IteratorPrototype, iteratorSymbol, function () {
	    return this;
	  });
	  var getProto = Object.getPrototypeOf,
	    NativeIteratorPrototype = getProto && getProto(getProto(values([])));
	  NativeIteratorPrototype && NativeIteratorPrototype !== Op && hasOwn.call(NativeIteratorPrototype, iteratorSymbol) && (IteratorPrototype = NativeIteratorPrototype);
	  var Gp = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(IteratorPrototype);
	  function defineIteratorMethods(prototype) {
	    ["next", "throw", "return"].forEach(function (method) {
	      define(prototype, method, function (arg) {
	        return this._invoke(method, arg);
	      });
	    });
	  }
	  function AsyncIterator(generator, PromiseImpl) {
	    function invoke(method, arg, resolve, reject) {
	      var record = tryCatch(generator[method], generator, arg);
	      if ("throw" !== record.type) {
	        var result = record.arg,
	          value = result.value;
	        return value && "object" == typeof value && hasOwn.call(value, "__await") ? PromiseImpl.resolve(value.__await).then(function (value) {
	          invoke("next", value, resolve, reject);
	        }, function (err) {
	          invoke("throw", err, resolve, reject);
	        }) : PromiseImpl.resolve(value).then(function (unwrapped) {
	          result.value = unwrapped, resolve(result);
	        }, function (error) {
	          return invoke("throw", error, resolve, reject);
	        });
	      }
	      reject(record.arg);
	    }
	    var previousPromise;
	    defineProperty(this, "_invoke", {
	      value: function (method, arg) {
	        function callInvokeWithMethodAndArg() {
	          return new PromiseImpl(function (resolve, reject) {
	            invoke(method, arg, resolve, reject);
	          });
	        }
	        return previousPromise = previousPromise ? previousPromise.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg();
	      }
	    });
	  }
	  function makeInvokeMethod(innerFn, self, context) {
	    var state = "suspendedStart";
	    return function (method, arg) {
	      if ("executing" === state) throw new Error("Generator is already running");
	      if ("completed" === state) {
	        if ("throw" === method) throw arg;
	        return doneResult();
	      }
	      for (context.method = method, context.arg = arg;;) {
	        var delegate = context.delegate;
	        if (delegate) {
	          var delegateResult = maybeInvokeDelegate(delegate, context);
	          if (delegateResult) {
	            if (delegateResult === ContinueSentinel) continue;
	            return delegateResult;
	          }
	        }
	        if ("next" === context.method) context.sent = context._sent = context.arg;else if ("throw" === context.method) {
	          if ("suspendedStart" === state) throw state = "completed", context.arg;
	          context.dispatchException(context.arg);
	        } else "return" === context.method && context.abrupt("return", context.arg);
	        state = "executing";
	        var record = tryCatch(innerFn, self, context);
	        if ("normal" === record.type) {
	          if (state = context.done ? "completed" : "suspendedYield", record.arg === ContinueSentinel) continue;
	          return {
	            value: record.arg,
	            done: context.done
	          };
	        }
	        "throw" === record.type && (state = "completed", context.method = "throw", context.arg = record.arg);
	      }
	    };
	  }
	  function maybeInvokeDelegate(delegate, context) {
	    var methodName = context.method,
	      method = delegate.iterator[methodName];
	    if (undefined === method) return context.delegate = null, "throw" === methodName && delegate.iterator.return && (context.method = "return", context.arg = undefined, maybeInvokeDelegate(delegate, context), "throw" === context.method) || "return" !== methodName && (context.method = "throw", context.arg = new TypeError("The iterator does not provide a '" + methodName + "' method")), ContinueSentinel;
	    var record = tryCatch(method, delegate.iterator, context.arg);
	    if ("throw" === record.type) return context.method = "throw", context.arg = record.arg, context.delegate = null, ContinueSentinel;
	    var info = record.arg;
	    return info ? info.done ? (context[delegate.resultName] = info.value, context.next = delegate.nextLoc, "return" !== context.method && (context.method = "next", context.arg = undefined), context.delegate = null, ContinueSentinel) : info : (context.method = "throw", context.arg = new TypeError("iterator result is not an object"), context.delegate = null, ContinueSentinel);
	  }
	  function pushTryEntry(locs) {
	    var entry = {
	      tryLoc: locs[0]
	    };
	    1 in locs && (entry.catchLoc = locs[1]), 2 in locs && (entry.finallyLoc = locs[2], entry.afterLoc = locs[3]), this.tryEntries.push(entry);
	  }
	  function resetTryEntry(entry) {
	    var record = entry.completion || {};
	    record.type = "normal", delete record.arg, entry.completion = record;
	  }
	  function Context(tryLocsList) {
	    this.tryEntries = [{
	      tryLoc: "root"
	    }], tryLocsList.forEach(pushTryEntry, this), this.reset(!0);
	  }
	  function values(iterable) {
	    if (iterable) {
	      var iteratorMethod = iterable[iteratorSymbol];
	      if (iteratorMethod) return iteratorMethod.call(iterable);
	      if ("function" == typeof iterable.next) return iterable;
	      if (!isNaN(iterable.length)) {
	        var i = -1,
	          next = function next() {
	            for (; ++i < iterable.length;) if (hasOwn.call(iterable, i)) return next.value = iterable[i], next.done = !1, next;
	            return next.value = undefined, next.done = !0, next;
	          };
	        return next.next = next;
	      }
	    }
	    return {
	      next: doneResult
	    };
	  }
	  function doneResult() {
	    return {
	      value: undefined,
	      done: !0
	    };
	  }
	  return GeneratorFunction.prototype = GeneratorFunctionPrototype, defineProperty(Gp, "constructor", {
	    value: GeneratorFunctionPrototype,
	    configurable: !0
	  }), defineProperty(GeneratorFunctionPrototype, "constructor", {
	    value: GeneratorFunction,
	    configurable: !0
	  }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, toStringTagSymbol, "GeneratorFunction"), exports.isGeneratorFunction = function (genFun) {
	    var ctor = "function" == typeof genFun && genFun.constructor;
	    return !!ctor && (ctor === GeneratorFunction || "GeneratorFunction" === (ctor.displayName || ctor.name));
	  }, exports.mark = function (genFun) {
	    return Object.setPrototypeOf ? Object.setPrototypeOf(genFun, GeneratorFunctionPrototype) : (genFun.__proto__ = GeneratorFunctionPrototype, define(genFun, toStringTagSymbol, "GeneratorFunction")), genFun.prototype = Object.create(Gp), genFun;
	  }, exports.awrap = function (arg) {
	    return {
	      __await: arg
	    };
	  }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, asyncIteratorSymbol, function () {
	    return this;
	  }), exports.AsyncIterator = AsyncIterator, exports.async = function (innerFn, outerFn, self, tryLocsList, PromiseImpl) {
	    void 0 === PromiseImpl && (PromiseImpl = Promise);
	    var iter = new AsyncIterator(wrap(innerFn, outerFn, self, tryLocsList), PromiseImpl);
	    return exports.isGeneratorFunction(outerFn) ? iter : iter.next().then(function (result) {
	      return result.done ? result.value : iter.next();
	    });
	  }, defineIteratorMethods(Gp), define(Gp, toStringTagSymbol, "Generator"), define(Gp, iteratorSymbol, function () {
	    return this;
	  }), define(Gp, "toString", function () {
	    return "[object Generator]";
	  }), exports.keys = function (val) {
	    var object = Object(val),
	      keys = [];
	    for (var key in object) keys.push(key);
	    return keys.reverse(), function next() {
	      for (; keys.length;) {
	        var key = keys.pop();
	        if (key in object) return next.value = key, next.done = !1, next;
	      }
	      return next.done = !0, next;
	    };
	  }, exports.values = values, Context.prototype = {
	    constructor: Context,
	    reset: function (skipTempReset) {
	      if (this.prev = 0, this.next = 0, this.sent = this._sent = undefined, this.done = !1, this.delegate = null, this.method = "next", this.arg = undefined, this.tryEntries.forEach(resetTryEntry), !skipTempReset) for (var name in this) "t" === name.charAt(0) && hasOwn.call(this, name) && !isNaN(+name.slice(1)) && (this[name] = undefined);
	    },
	    stop: function () {
	      this.done = !0;
	      var rootRecord = this.tryEntries[0].completion;
	      if ("throw" === rootRecord.type) throw rootRecord.arg;
	      return this.rval;
	    },
	    dispatchException: function (exception) {
	      if (this.done) throw exception;
	      var context = this;
	      function handle(loc, caught) {
	        return record.type = "throw", record.arg = exception, context.next = loc, caught && (context.method = "next", context.arg = undefined), !!caught;
	      }
	      for (var i = this.tryEntries.length - 1; i >= 0; --i) {
	        var entry = this.tryEntries[i],
	          record = entry.completion;
	        if ("root" === entry.tryLoc) return handle("end");
	        if (entry.tryLoc <= this.prev) {
	          var hasCatch = hasOwn.call(entry, "catchLoc"),
	            hasFinally = hasOwn.call(entry, "finallyLoc");
	          if (hasCatch && hasFinally) {
	            if (this.prev < entry.catchLoc) return handle(entry.catchLoc, !0);
	            if (this.prev < entry.finallyLoc) return handle(entry.finallyLoc);
	          } else if (hasCatch) {
	            if (this.prev < entry.catchLoc) return handle(entry.catchLoc, !0);
	          } else {
	            if (!hasFinally) throw new Error("try statement without catch or finally");
	            if (this.prev < entry.finallyLoc) return handle(entry.finallyLoc);
	          }
	        }
	      }
	    },
	    abrupt: function (type, arg) {
	      for (var i = this.tryEntries.length - 1; i >= 0; --i) {
	        var entry = this.tryEntries[i];
	        if (entry.tryLoc <= this.prev && hasOwn.call(entry, "finallyLoc") && this.prev < entry.finallyLoc) {
	          var finallyEntry = entry;
	          break;
	        }
	      }
	      finallyEntry && ("break" === type || "continue" === type) && finallyEntry.tryLoc <= arg && arg <= finallyEntry.finallyLoc && (finallyEntry = null);
	      var record = finallyEntry ? finallyEntry.completion : {};
	      return record.type = type, record.arg = arg, finallyEntry ? (this.method = "next", this.next = finallyEntry.finallyLoc, ContinueSentinel) : this.complete(record);
	    },
	    complete: function (record, afterLoc) {
	      if ("throw" === record.type) throw record.arg;
	      return "break" === record.type || "continue" === record.type ? this.next = record.arg : "return" === record.type ? (this.rval = this.arg = record.arg, this.method = "return", this.next = "end") : "normal" === record.type && afterLoc && (this.next = afterLoc), ContinueSentinel;
	    },
	    finish: function (finallyLoc) {
	      for (var i = this.tryEntries.length - 1; i >= 0; --i) {
	        var entry = this.tryEntries[i];
	        if (entry.finallyLoc === finallyLoc) return this.complete(entry.completion, entry.afterLoc), resetTryEntry(entry), ContinueSentinel;
	      }
	    },
	    catch: function (tryLoc) {
	      for (var i = this.tryEntries.length - 1; i >= 0; --i) {
	        var entry = this.tryEntries[i];
	        if (entry.tryLoc === tryLoc) {
	          var record = entry.completion;
	          if ("throw" === record.type) {
	            var thrown = record.arg;
	            resetTryEntry(entry);
	          }
	          return thrown;
	        }
	      }
	      throw new Error("illegal catch attempt");
	    },
	    delegateYield: function (iterable, resultName, nextLoc) {
	      return this.delegate = {
	        iterator: values(iterable),
	        resultName: resultName,
	        nextLoc: nextLoc
	      }, "next" === this.method && (this.arg = undefined), ContinueSentinel;
	    }
	  }, exports;
	}
	function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) {
	  try {
	    var info = gen[key](arg);
	    var value = info.value;
	  } catch (error) {
	    reject(error);
	    return;
	  }
	  if (info.done) {
	    resolve(value);
	  } else {
	    Promise.resolve(value).then(_next, _throw);
	  }
	}
	function _asyncToGenerator(fn) {
	  return function () {
	    var self = this,
	      args = arguments;
	    return new Promise(function (resolve, reject) {
	      var gen = fn.apply(self, args);
	      function _next(value) {
	        asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value);
	      }
	      function _throw(err) {
	        asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err);
	      }
	      _next(undefined);
	    });
	  };
	}
	function _defineProperties(target, props) {
	  for (var i = 0; i < props.length; i++) {
	    var descriptor = props[i];
	    descriptor.enumerable = descriptor.enumerable || false;
	    descriptor.configurable = true;
	    if ("value" in descriptor) descriptor.writable = true;
	    Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor);
	  }
	}
	function _createClass(Constructor, protoProps, staticProps) {
	  if (protoProps) _defineProperties(Constructor.prototype, protoProps);
	  if (staticProps) _defineProperties(Constructor, staticProps);
	  Object.defineProperty(Constructor, "prototype", {
	    writable: false
	  });
	  return Constructor;
	}
	function _extends() {
	  _extends = Object.assign ? Object.assign.bind() : function (target) {
	    for (var i = 1; i < arguments.length; i++) {
	      var source = arguments[i];
	      for (var key in source) {
	        if (Object.prototype.hasOwnProperty.call(source, key)) {
	          target[key] = source[key];
	        }
	      }
	    }
	    return target;
	  };
	  return _extends.apply(this, arguments);
	}
	function _inheritsLoose(subClass, superClass) {
	  subClass.prototype = Object.create(superClass.prototype);
	  subClass.prototype.constructor = subClass;
	  _setPrototypeOf(subClass, superClass);
	}
	function _setPrototypeOf(o, p) {
	  _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) {
	    o.__proto__ = p;
	    return o;
	  };
	  return _setPrototypeOf(o, p);
	}
	function _assertThisInitialized(self) {
	  if (self === void 0) {
	    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
	  }
	  return self;
	}
	function _unsupportedIterableToArray(o, minLen) {
	  if (!o) return;
	  if (typeof o === "string") return _arrayLikeToArray(o, minLen);
	  var n = Object.prototype.toString.call(o).slice(8, -1);
	  if (n === "Object" && o.constructor) n = o.constructor.name;
	  if (n === "Map" || n === "Set") return Array.from(o);
	  if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
	}
	function _arrayLikeToArray(arr, len) {
	  if (len == null || len > arr.length) len = arr.length;
	  for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i];
	  return arr2;
	}
	function _createForOfIteratorHelperLoose(o, allowArrayLike) {
	  var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"];
	  if (it) return (it = it.call(o)).next.bind(it);
	  if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") {
	    if (it) o = it;
	    var i = 0;
	    return function () {
	      if (i >= o.length) return {
	        done: true
	      };
	      return {
	        done: false,
	        value: o[i++]
	      };
	    };
	  }
	  throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
	}
	function _toPrimitive(input, hint) {
	  if (typeof input !== "object" || input === null) return input;
	  var prim = input[Symbol.toPrimitive];
	  if (prim !== undefined) {
	    var res = prim.call(input, hint || "default");
	    if (typeof res !== "object") return res;
	    throw new TypeError("@@toPrimitive must return a primitive value.");
	  }
	  return (hint === "string" ? String : Number)(input);
	}
	function _toPropertyKey(arg) {
	  var key = _toPrimitive(arg, "string");
	  return typeof key === "symbol" ? key : String(key);
	}

	var EventHandler = function () {
		function EventHandler() {
			this._callbacks = new Map();
			this._callbackActive = new Map();
		}
		var _proto = EventHandler.prototype;
		_proto.initEventHandler = function initEventHandler() {
			this._callbacks = new Map();
			this._callbackActive = new Map();
		};
		_proto._addCallback = function _addCallback(name, callback, scope, once) {
			if (!name || typeof name !== 'string' || !callback) return;
			if (!this._callbacks.has(name)) this._callbacks.set(name, []);
			if (this._callbackActive.has(name)) {
				var callbackActive = this._callbackActive.get(name);
				if (callbackActive && callbackActive === this._callbacks.get(name)) {
					this._callbackActive.set(name, callbackActive.slice());
				}
			}
			this._callbacks.get(name).push({
				callback: callback,
				scope: scope,
				once: once
			});
		};
		_proto.on = function on(name, callback, scope) {
			if (scope === void 0) {
				scope = this;
			}
			this._addCallback(name, callback, scope, false);
			return this;
		};
		_proto.once = function once(name, callback, scope) {
			if (scope === void 0) {
				scope = this;
			}
			this._addCallback(name, callback, scope, true);
			return this;
		};
		_proto.off = function off(name, callback, scope) {
			if (name) {
				if (this._callbackActive.has(name) && this._callbackActive.get(name) === this._callbacks.get(name)) this._callbackActive.set(name, this._callbackActive.get(name).slice());
			} else {
				for (var _iterator = _createForOfIteratorHelperLoose(this._callbackActive), _step; !(_step = _iterator()).done;) {
					var _step$value = _step.value,
						key = _step$value[0],
						callbacks = _step$value[1];
					if (!this._callbacks.has(key)) continue;
					if (this._callbacks.get(key) !== callbacks) continue;
					this._callbackActive.set(key, callbacks.slice());
				}
			}
			if (!name) {
				this._callbacks.clear();
			} else if (!callback) {
				if (this._callbacks.has(name)) this._callbacks.delete(name);
			} else {
				var events = this._callbacks.get(name);
				if (!events) return this;
				var count = events.length;
				for (var i = 0; i < count; i++) {
					if (events[i].callback !== callback) continue;
					if (scope && events[i].scope !== scope) continue;
					events[i--] = events[--count];
				}
				events.length = count;
				if (events.length === 0) this._callbacks.delete(name);
			}
			return this;
		};
		_proto.fire = function fire(name, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8) {
			if (!name) return this;
			var callbacksInitial = this._callbacks.get(name);
			if (!callbacksInitial) return this;
			var callbacks;
			if (!this._callbackActive.has(name)) {
				this._callbackActive.set(name, callbacksInitial);
			} else if (this._callbackActive.get(name) !== callbacksInitial) {
				callbacks = callbacksInitial.slice();
			}
			for (var i = 0; (callbacks || this._callbackActive.get(name)) && i < (callbacks || this._callbackActive.get(name)).length; i++) {
				var evt = (callbacks || this._callbackActive.get(name))[i];
				evt.callback.call(evt.scope, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
				if (evt.once) {
					var existingCallback = this._callbacks.get(name);
					var ind = existingCallback ? existingCallback.indexOf(evt) : -1;
					if (ind !== -1) {
						if (this._callbackActive.get(name) === existingCallback) this._callbackActive.set(name, this._callbackActive.get(name).slice());
						var _callbacks = this._callbacks.get(name);
						if (!_callbacks) continue;
						_callbacks.splice(ind, 1);
						if (_callbacks.length === 0) this._callbacks.delete(name);
					}
				}
			}
			if (!callbacks) this._callbackActive.delete(name);
			return this;
		};
		_proto.hasEvent = function hasEvent(name) {
			var _this$_callbacks$get;
			return !!((_this$_callbacks$get = this._callbacks.get(name)) != null && _this$_callbacks$get.length);
		};
		return EventHandler;
	}();

	var events = {
		attach: function attach(target) {
			var ev = events;
			target._addCallback = ev._addCallback;
			target.on = ev.on;
			target.off = ev.off;
			target.fire = ev.fire;
			target.once = ev.once;
			target.hasEvent = ev.hasEvent;
			EventHandler.prototype.initEventHandler.call(target);
			return target;
		},
		_addCallback: EventHandler.prototype._addCallback,
		on: EventHandler.prototype.on,
		off: EventHandler.prototype.off,
		fire: EventHandler.prototype.fire,
		once: EventHandler.prototype.once,
		hasEvent: EventHandler.prototype.hasEvent
	};

	var guid = {
		create: function create() {
			return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
				var r = Math.random() * 16 | 0;
				var v = c === 'x' ? r : r & 0x3 | 0x8;
				return v.toString(16);
			});
		}
	};

	var Tracing = function () {
		function Tracing() {}
		Tracing.set = function set(channel, enabled) {
		};
		Tracing.get = function get(channel) {
			return Tracing._traceChannels.has(channel);
		};
		return Tracing;
	}();
	Tracing._traceChannels = new Set();
	Tracing.stack = false;

	var path = {
		delimiter: '/',
		join: function join() {
			var num = arguments.length;
			var result = arguments[0];
			for (var index = 0; index < num - 1; ++index) {
				var one = arguments[index];
				var two = arguments[index + 1];
				if (two[0] === path.delimiter) {
					result = two;
					continue;
				}
				if (one && two && one[one.length - 1] !== path.delimiter && two[0] !== path.delimiter) {
					result += path.delimiter + two;
				} else {
					result += two;
				}
			}
			return result;
		},
		normalize: function normalize(pathname) {
			var lead = pathname.startsWith(path.delimiter);
			var trail = pathname.endsWith(path.delimiter);
			var parts = pathname.split('/');
			var result = '';
			var cleaned = [];
			for (var i = 0; i < parts.length; i++) {
				if (parts[i] === '') continue;
				if (parts[i] === '.') continue;
				if (parts[i] === '..' && cleaned.length > 0) {
					cleaned = cleaned.slice(0, cleaned.length - 2);
					continue;
				}
				if (i > 0) cleaned.push(path.delimiter);
				cleaned.push(parts[i]);
			}
			result = cleaned.join('');
			if (!lead && result[0] === path.delimiter) {
				result = result.slice(1);
			}
			if (trail && result[result.length - 1] !== path.delimiter) {
				result += path.delimiter;
			}
			return result;
		},
		split: function split(pathname) {
			var lastDelimiterIndex = pathname.lastIndexOf(path.delimiter);
			if (lastDelimiterIndex !== -1) {
				return [pathname.substring(0, lastDelimiterIndex), pathname.substring(lastDelimiterIndex + 1)];
			}
			return ["", pathname];
		},
		getBasename: function getBasename(pathname) {
			return path.split(pathname)[1];
		},
		getDirectory: function getDirectory(pathname) {
			return path.split(pathname)[0];
		},
		getExtension: function getExtension(pathname) {
			var ext = pathname.split('?')[0].split('.').pop();
			if (ext !== pathname) {
				return '.' + ext;
			}
			return '';
		},
		isRelativePath: function isRelativePath(pathname) {
			return pathname.charAt(0) !== '/' && pathname.match(/:\/\//) === null;
		},
		extractPath: function extractPath(pathname) {
			var result = '';
			var parts = pathname.split('/');
			var i = 0;
			if (parts.length > 1) {
				if (path.isRelativePath(pathname)) {
					if (parts[0] === '.') {
						for (i = 0; i < parts.length - 1; ++i) {
							result += i === 0 ? parts[i] : '/' + parts[i];
						}
					} else if (parts[0] === '..') {
						for (i = 0; i < parts.length - 1; ++i) {
							result += i === 0 ? parts[i] : '/' + parts[i];
						}
					} else {
						result = '.';
						for (i = 0; i < parts.length - 1; ++i) {
							result += '/' + parts[i];
						}
					}
				} else {
					for (i = 0; i < parts.length - 1; ++i) {
						result += i === 0 ? parts[i] : '/' + parts[i];
					}
				}
			}
			return result;
		}
	};

	var detectPassiveEvents = function detectPassiveEvents() {
		var result = false;
		try {
			var opts = Object.defineProperty({}, 'passive', {
				get: function get() {
					result = true;
					return false;
				}
			});
			window.addEventListener('testpassive', null, opts);
			window.removeEventListener('testpassive', null, opts);
		} catch (e) {}
		return result;
	};
	var ua = typeof navigator !== 'undefined' ? navigator.userAgent : '';
	var environment = typeof window !== 'undefined' ? 'browser' : 'node';
	var platformName = /android/i.test(ua) ? 'android' : /ip([ao]d|hone)/i.test(ua) ? 'ios' : /windows/i.test(ua) ? 'windows' : /mac os/i.test(ua) ? 'osx' : /linux/i.test(ua) ? 'linux' : /cros/i.test(ua) ? 'cros' : null;
	var browserName = environment !== 'browser' ? null : /(Chrome\/|Chromium\/|Edg.*\/)/.test(ua) ? 'chrome' : /Safari\//.test(ua) ? 'safari' : /Firefox\//.test(ua) ? 'firefox' : 'other';
	var xbox = /xbox/i.test(ua);
	var touch = environment === 'browser' && ('ontouchstart' in window || 'maxTouchPoints' in navigator && navigator.maxTouchPoints > 0);
	var gamepads = environment === 'browser' && (!!navigator.getGamepads || !!navigator.webkitGetGamepads);
	var workers = typeof Worker !== 'undefined';
	var passiveEvents = detectPassiveEvents();
	var platform = {
		environment: environment,
		global: environment === 'browser' ? window : global,
		browser: environment === 'browser',
		desktop: ['windows', 'osx', 'linux', 'cros'].includes(platformName),
		mobile: ['android', 'ios'].includes(platformName),
		ios: platformName === 'ios',
		android: platformName === 'android',
		xbox: xbox,
		gamepads: gamepads,
		touch: touch,
		workers: workers,
		passiveEvents: passiveEvents,
		browserName: browserName
	};

	var ASCII_LOWERCASE = 'abcdefghijklmnopqrstuvwxyz';
	var ASCII_UPPERCASE = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
	var ASCII_LETTERS = ASCII_LOWERCASE + ASCII_UPPERCASE;
	var HIGH_SURROGATE_BEGIN = 0xD800;
	var HIGH_SURROGATE_END = 0xDBFF;
	var LOW_SURROGATE_BEGIN = 0xDC00;
	var LOW_SURROGATE_END = 0xDFFF;
	var ZERO_WIDTH_JOINER = 0x200D;
	var REGIONAL_INDICATOR_BEGIN = 0x1F1E6;
	var REGIONAL_INDICATOR_END = 0x1F1FF;
	var FITZPATRICK_MODIFIER_BEGIN = 0x1F3FB;
	var FITZPATRICK_MODIFIER_END = 0x1F3FF;
	var DIACRITICAL_MARKS_BEGIN = 0x20D0;
	var DIACRITICAL_MARKS_END = 0x20FF;
	var VARIATION_MODIFIER_BEGIN = 0xFE00;
	var VARIATION_MODIFIER_END = 0xFE0F;
	function getCodePointData(string, i) {
		if (i === void 0) {
			i = 0;
		}
		var size = string.length;
		if (i < 0 || i >= size) {
			return null;
		}
		var first = string.charCodeAt(i);
		if (size > 1 && first >= HIGH_SURROGATE_BEGIN && first <= HIGH_SURROGATE_END) {
			var second = string.charCodeAt(i + 1);
			if (second >= LOW_SURROGATE_BEGIN && second <= LOW_SURROGATE_END) {
				return {
					code: (first - HIGH_SURROGATE_BEGIN) * 0x400 + second - LOW_SURROGATE_BEGIN + 0x10000,
					long: true
				};
			}
		}
		return {
			code: first,
			long: false
		};
	}
	function isCodeBetween(string, begin, end) {
		if (!string) return false;
		var codeData = getCodePointData(string);
		if (codeData) {
			var code = codeData.code;
			return code >= begin && code <= end;
		}
		return false;
	}
	function numCharsToTakeForNextSymbol(string, index) {
		if (index === string.length - 1) {
			return 1;
		}
		if (isCodeBetween(string[index], HIGH_SURROGATE_BEGIN, HIGH_SURROGATE_END)) {
			var first = string.substring(index, index + 2);
			var second = string.substring(index + 2, index + 4);
			if (isCodeBetween(second, FITZPATRICK_MODIFIER_BEGIN, FITZPATRICK_MODIFIER_END) || isCodeBetween(first, REGIONAL_INDICATOR_BEGIN, REGIONAL_INDICATOR_END) && isCodeBetween(second, REGIONAL_INDICATOR_BEGIN, REGIONAL_INDICATOR_END)) {
				return 4;
			}
			if (isCodeBetween(second, VARIATION_MODIFIER_BEGIN, VARIATION_MODIFIER_END)) {
				return 3;
			}
			return 2;
		}
		if (isCodeBetween(string[index + 1], VARIATION_MODIFIER_BEGIN, VARIATION_MODIFIER_END)) {
			return 2;
		}
		return 1;
	}
	var string = {
		ASCII_LOWERCASE: ASCII_LOWERCASE,
		ASCII_UPPERCASE: ASCII_UPPERCASE,
		ASCII_LETTERS: ASCII_LETTERS,
		format: function format(s) {
			for (var i = 0; i < (arguments.length <= 1 ? 0 : arguments.length - 1); i++) {
				s = s.replace("{" + i + "}", i + 1 < 1 || arguments.length <= i + 1 ? undefined : arguments[i + 1]);
			}
			return s;
		},
		getCodePoint: function getCodePoint(string, i) {
			var codePointData = getCodePointData(string, i);
			return codePointData && codePointData.code;
		},
		getCodePoints: function getCodePoints(string) {
			if (typeof string !== 'string') {
				throw new TypeError('Not a string');
			}
			var i = 0;
			var arr = [];
			var codePoint;
			while (!!(codePoint = getCodePointData(string, i))) {
				arr.push(codePoint.code);
				i += codePoint.long ? 2 : 1;
			}
			return arr;
		},
		getSymbols: function getSymbols(string) {
			if (typeof string !== 'string') {
				throw new TypeError('Not a string');
			}
			var index = 0;
			var length = string.length;
			var output = [];
			var take = 0;
			var ch;
			while (index < length) {
				take += numCharsToTakeForNextSymbol(string, index + take);
				ch = string[index + take];
				if (isCodeBetween(ch, DIACRITICAL_MARKS_BEGIN, DIACRITICAL_MARKS_END)) {
					ch = string[index + take++];
				}
				if (isCodeBetween(ch, VARIATION_MODIFIER_BEGIN, VARIATION_MODIFIER_END)) {
					ch = string[index + take++];
				}
				if (ch && ch.charCodeAt(0) === ZERO_WIDTH_JOINER) {
					ch = string[index + take++];
					continue;
				}
				var char = string.substring(index, index + take);
				output.push(char);
				index += take;
				take = 0;
			}
			return output;
		},
		fromCodePoint: function fromCodePoint() {
			var chars = [];
			var current;
			var codePoint;
			var units;
			for (var i = 0; i < arguments.length; ++i) {
				current = Number(arguments[i]);
				codePoint = current - 0x10000;
				units = current > 0xFFFF ? [(codePoint >> 10) + 0xD800, codePoint % 0x400 + 0xDC00] : [current];
				chars.push(String.fromCharCode.apply(null, units));
			}
			return chars.join('');
		}
	};

	var IndexedList = function () {
		function IndexedList() {
			this._list = [];
			this._index = {};
		}
		var _proto = IndexedList.prototype;
		_proto.push = function push(key, item) {
			if (this._index[key]) {
				throw Error('Key already in index ' + key);
			}
			var location = this._list.push(item) - 1;
			this._index[key] = location;
		};
		_proto.has = function has(key) {
			return this._index[key] !== undefined;
		};
		_proto.get = function get(key) {
			var location = this._index[key];
			if (location !== undefined) {
				return this._list[location];
			}
			return null;
		};
		_proto.remove = function remove(key) {
			var location = this._index[key];
			if (location !== undefined) {
				this._list.splice(location, 1);
				delete this._index[key];
				for (key in this._index) {
					var idx = this._index[key];
					if (idx > location) {
						this._index[key] = idx - 1;
					}
				}
				return true;
			}
			return false;
		};
		_proto.list = function list() {
			return this._list;
		};
		_proto.clear = function clear() {
			this._list.length = 0;
			for (var prop in this._index) {
				delete this._index[prop];
			}
		};
		return IndexedList;
	}();

	var cachedResult = function cachedResult(func) {
		var uninitToken = {};
		var result = uninitToken;
		return function () {
			if (result === uninitToken) {
				result = func();
			}
			return result;
		};
	};
	var Impl = function () {
		function Impl() {}
		Impl.loadScript = function loadScript(url, callback) {
			var s = document.createElement('script');
			s.setAttribute('src', url);
			s.onload = function () {
				callback(null);
			};
			s.onerror = function () {
				callback("Failed to load script='" + url + "'");
			};
			document.body.appendChild(s);
		};
		Impl.loadWasm = function loadWasm(moduleName, config, callback) {
			var loadUrl = Impl.wasmSupported() && config.glueUrl && config.wasmUrl ? config.glueUrl : config.fallbackUrl;
			if (loadUrl) {
				Impl.loadScript(loadUrl, function (err) {
					if (err) {
						callback(err, null);
					} else {
						var module = window[moduleName];
						window[moduleName] = undefined;
						module({
							locateFile: function locateFile() {
								return config.wasmUrl;
							},
							onAbort: function onAbort() {
								callback('wasm module aborted.');
							}
						}).then(function (instance) {
							callback(null, instance);
						});
					}
				});
			} else {
				callback('No supported wasm modules found.', null);
			}
		};
		Impl.getModule = function getModule(name) {
			if (!Impl.modules.hasOwnProperty(name)) {
				Impl.modules[name] = {
					config: null,
					initializing: false,
					instance: null,
					callbacks: []
				};
			}
			return Impl.modules[name];
		};
		Impl.initialize = function initialize(moduleName, module) {
			if (module.initializing) {
				return;
			}
			var config = module.config;
			if (config.glueUrl || config.wasmUrl || config.fallbackUrl) {
				module.initializing = true;
				Impl.loadWasm(moduleName, config, function (err, instance) {
					if (err) {
						if (config.errorHandler) {
							config.errorHandler(err);
						} else {
							console.error("failed to initialize module=" + moduleName + " error=" + err);
						}
					} else {
						module.instance = instance;
						module.callbacks.forEach(function (callback) {
							callback(instance);
						});
					}
				});
			}
		};
		return Impl;
	}();
	Impl.modules = {};
	Impl.wasmSupported = cachedResult(function () {
		try {
			if (typeof WebAssembly === "object" && typeof WebAssembly.instantiate === "function") {
				var module = new WebAssembly.Module(Uint8Array.of(0x0, 0x61, 0x73, 0x6d, 0x01, 0x00, 0x00, 0x00));
				if (module instanceof WebAssembly.Module) return new WebAssembly.Instance(module) instanceof WebAssembly.Instance;
			}
		} catch (e) {}
		return false;
	});
	var WasmModule = function () {
		function WasmModule() {}
		WasmModule.setConfig = function setConfig(moduleName, config) {
			var module = Impl.getModule(moduleName);
			module.config = config;
			if (module.callbacks.length > 0) {
				Impl.initialize(moduleName, module);
			}
		};
		WasmModule.getConfig = function getConfig(moduleName) {
			var _Impl$modules;
			return (_Impl$modules = Impl.modules) == null || (_Impl$modules = _Impl$modules[moduleName]) == null ? void 0 : _Impl$modules.config;
		};
		WasmModule.getInstance = function getInstance(moduleName, callback) {
			var module = Impl.getModule(moduleName);
			if (module.instance) {
				callback(module.instance);
			} else {
				module.callbacks.push(callback);
				if (module.config) {
					Impl.initialize(moduleName, module);
				}
			}
		};
		return WasmModule;
	}();

	var ReadStream = function () {
		function ReadStream(arraybuffer) {
			this.arraybuffer = arraybuffer;
			this.dataView = new DataView(arraybuffer);
			this.offset = 0;
			this.stack = [];
		}
		var _proto = ReadStream.prototype;
		_proto.reset = function reset(offset) {
			if (offset === void 0) {
				offset = 0;
			}
			this.offset = offset;
		};
		_proto.skip = function skip(bytes) {
			this.offset += bytes;
		};
		_proto.align = function align(bytes) {
			this.offset = this.offset + bytes - 1 & ~(bytes - 1);
		};
		_proto._inc = function _inc(amount) {
			this.offset += amount;
			return this.offset - amount;
		};
		_proto.readChar = function readChar() {
			return String.fromCharCode(this.dataView.getUint8(this.offset++));
		};
		_proto.readChars = function readChars(numChars) {
			var result = '';
			for (var i = 0; i < numChars; ++i) {
				result += this.readChar();
			}
			return result;
		};
		_proto.readU8 = function readU8() {
			return this.dataView.getUint8(this.offset++);
		};
		_proto.readU16 = function readU16() {
			return this.dataView.getUint16(this._inc(2), true);
		};
		_proto.readU32 = function readU32() {
			return this.dataView.getUint32(this._inc(4), true);
		};
		_proto.readU64 = function readU64() {
			return this.readU32() + Math.pow(2, 32) * this.readU32();
		};
		_proto.readU32be = function readU32be() {
			return this.dataView.getUint32(this._inc(4), false);
		};
		_proto.readArray = function readArray(result) {
			for (var i = 0; i < result.length; ++i) {
				result[i] = this.readU8();
			}
		};
		_proto.readLine = function readLine() {
			var view = this.dataView;
			var result = '';
			while (true) {
				if (this.offset >= view.byteLength) {
					break;
				}
				var c = String.fromCharCode(this.readU8());
				if (c === '\n') {
					break;
				}
				result += c;
			}
			return result;
		};
		_createClass(ReadStream, [{
			key: "remainingBytes",
			get: function get() {
				return this.dataView.byteLength - this.offset;
			}
		}]);
		return ReadStream;
	}();

	var SortedLoopArray = function () {
		function SortedLoopArray(args) {
			this.items = [];
			this.length = 0;
			this.loopIndex = -1;
			this._sortBy = void 0;
			this._sortHandler = void 0;
			this._sortBy = args.sortBy;
			this._sortHandler = this._doSort.bind(this);
		}
		var _proto = SortedLoopArray.prototype;
		_proto._binarySearch = function _binarySearch(item) {
			var left = 0;
			var right = this.items.length - 1;
			var search = item[this._sortBy];
			var middle;
			var current;
			while (left <= right) {
				middle = Math.floor((left + right) / 2);
				current = this.items[middle][this._sortBy];
				if (current <= search) {
					left = middle + 1;
				} else if (current > search) {
					right = middle - 1;
				}
			}
			return left;
		};
		_proto._doSort = function _doSort(a, b) {
			var sortBy = this._sortBy;
			return a[sortBy] - b[sortBy];
		};
		_proto.insert = function insert(item) {
			var index = this._binarySearch(item);
			this.items.splice(index, 0, item);
			this.length++;
			if (this.loopIndex >= index) {
				this.loopIndex++;
			}
		};
		_proto.append = function append(item) {
			this.items.push(item);
			this.length++;
		};
		_proto.remove = function remove(item) {
			var idx = this.items.indexOf(item);
			if (idx < 0) return;
			this.items.splice(idx, 1);
			this.length--;
			if (this.loopIndex >= idx) {
				this.loopIndex--;
			}
		};
		_proto.sort = function sort() {
			var current = this.loopIndex >= 0 ? this.items[this.loopIndex] : null;
			this.items.sort(this._sortHandler);
			if (current !== null) {
				this.loopIndex = this.items.indexOf(current);
			}
		};
		return SortedLoopArray;
	}();

	var Tags = function (_EventHandler) {
		_inheritsLoose(Tags, _EventHandler);
		function Tags(parent) {
			var _this;
			_this = _EventHandler.call(this) || this;
			_this._index = {};
			_this._list = [];
			_this._parent = parent;
			return _this;
		}
		var _proto = Tags.prototype;
		_proto.add = function add() {
			var changed = false;
			var tags = this._processArguments(arguments, true);
			if (!tags.length) return changed;
			for (var i = 0; i < tags.length; i++) {
				if (this._index[tags[i]]) continue;
				changed = true;
				this._index[tags[i]] = true;
				this._list.push(tags[i]);
				this.fire('add', tags[i], this._parent);
			}
			if (changed) this.fire('change', this._parent);
			return changed;
		};
		_proto.remove = function remove() {
			var changed = false;
			if (!this._list.length) return changed;
			var tags = this._processArguments(arguments, true);
			if (!tags.length) return changed;
			for (var i = 0; i < tags.length; i++) {
				if (!this._index[tags[i]]) continue;
				changed = true;
				delete this._index[tags[i]];
				this._list.splice(this._list.indexOf(tags[i]), 1);
				this.fire('remove', tags[i], this._parent);
			}
			if (changed) this.fire('change', this._parent);
			return changed;
		};
		_proto.clear = function clear() {
			if (!this._list.length) return;
			var tags = this._list.slice(0);
			this._list = [];
			this._index = {};
			for (var i = 0; i < tags.length; i++) this.fire('remove', tags[i], this._parent);
			this.fire('change', this._parent);
		};
		_proto.has = function has() {
			if (!this._list.length) return false;
			return this._has(this._processArguments(arguments));
		};
		_proto._has = function _has(tags) {
			if (!this._list.length || !tags.length) return false;
			for (var i = 0; i < tags.length; i++) {
				if (tags[i].length === 1) {
					if (this._index[tags[i][0]]) return true;
				} else {
					var multiple = true;
					for (var t = 0; t < tags[i].length; t++) {
						if (this._index[tags[i][t]]) continue;
						multiple = false;
						break;
					}
					if (multiple) return true;
				}
			}
			return false;
		};
		_proto.list = function list() {
			return this._list.slice(0);
		};
		_proto._processArguments = function _processArguments(args, flat) {
			var tags = [];
			var tmp = [];
			if (!args || !args.length) return tags;
			for (var i = 0; i < args.length; i++) {
				if (args[i] instanceof Array) {
					if (!flat) tmp = [];
					for (var t = 0; t < args[i].length; t++) {
						if (typeof args[i][t] !== 'string') continue;
						if (flat) {
							tags.push(args[i][t]);
						} else {
							tmp.push(args[i][t]);
						}
					}
					if (!flat && tmp.length) tags.push(tmp);
				} else if (typeof args[i] === 'string') {
					if (flat) {
						tags.push(args[i]);
					} else {
						tags.push([args[i]]);
					}
				}
			}
			return tags;
		};
		_createClass(Tags, [{
			key: "size",
			get: function get() {
				return this._list.length;
			}
		}]);
		return Tags;
	}(EventHandler);

	var now = typeof window !== 'undefined' && window.performance && window.performance.now ? performance.now.bind(performance) : Date.now;

	function createURI(options) {
		var s = '';
		if ((options.authority || options.scheme) && (options.host || options.hostpath)) {
			throw new Error('Can\'t have \'scheme\' or \'authority\' and \'host\' or \'hostpath\' option');
		}
		if (options.host && options.hostpath) {
			throw new Error('Can\'t have \'host\' and \'hostpath\' option');
		}
		if (options.path && options.hostpath) {
			throw new Error('Can\'t have \'path\' and \'hostpath\' option');
		}
		if (options.scheme) {
			s += options.scheme + ':';
		}
		if (options.authority) {
			s += '//' + options.authority;
		}
		if (options.host) {
			s += options.host;
		}
		if (options.path) {
			s += options.path;
		}
		if (options.hostpath) {
			s += options.hostpath;
		}
		if (options.query) {
			s += '?' + options.query;
		}
		if (options.fragment) {
			s += '#' + options.fragment;
		}
		return s;
	}
	var re = /^(([^:\/?#]+):)?(\/\/([^\/?#]*))?([^?#]*)(\?([^#]*))?(#(.*))?/;
	var URI = function () {
		function URI(uri) {
			this.scheme = void 0;
			this.authority = void 0;
			this.path = void 0;
			this.query = void 0;
			this.fragment = void 0;
			var result = uri.match(re);
			this.scheme = result[2];
			this.authority = result[4];
			this.path = result[5];
			this.query = result[7];
			this.fragment = result[9];
		}
		var _proto = URI.prototype;
		_proto.toString = function toString() {
			var s = '';
			if (this.scheme) {
				s += this.scheme + ':';
			}
			if (this.authority) {
				s += '//' + this.authority;
			}
			s += this.path;
			if (this.query) {
				s += '?' + this.query;
			}
			if (this.fragment) {
				s += '#' + this.fragment;
			}
			return s;
		};
		_proto.getQuery = function getQuery() {
			var result = {};
			if (this.query) {
				var queryParams = decodeURIComponent(this.query).split('&');
				for (var _iterator = _createForOfIteratorHelperLoose(queryParams), _step; !(_step = _iterator()).done;) {
					var queryParam = _step.value;
					var pair = queryParam.split('=');
					result[pair[0]] = pair[1];
				}
			}
			return result;
		};
		_proto.setQuery = function setQuery(params) {
			var q = '';
			for (var key in params) {
				if (params.hasOwnProperty(key)) {
					if (q !== '') {
						q += '&';
					}
					q += encodeURIComponent(key) + '=' + encodeURIComponent(params[key]);
				}
			}
			this.query = q;
		};
		return URI;
	}();

	var CURVE_LINEAR = 0;
	var CURVE_SMOOTHSTEP = 1;
	var CURVE_CATMULL = 2;
	var CURVE_CARDINAL = 3;
	var CURVE_SPLINE = 4;
	var CURVE_STEP = 5;

	var math = {
		DEG_TO_RAD: Math.PI / 180,
		RAD_TO_DEG: 180 / Math.PI,
		clamp: function clamp(value, min, max) {
			if (value >= max) return max;
			if (value <= min) return min;
			return value;
		},
		intToBytes24: function intToBytes24(i) {
			var r = i >> 16 & 0xff;
			var g = i >> 8 & 0xff;
			var b = i & 0xff;
			return [r, g, b];
		},
		intToBytes32: function intToBytes32(i) {
			var r = i >> 24 & 0xff;
			var g = i >> 16 & 0xff;
			var b = i >> 8 & 0xff;
			var a = i & 0xff;
			return [r, g, b, a];
		},
		bytesToInt24: function bytesToInt24(r, g, b) {
			if (r.length) {
				b = r[2];
				g = r[1];
				r = r[0];
			}
			return r << 16 | g << 8 | b;
		},
		bytesToInt32: function bytesToInt32(r, g, b, a) {
			if (r.length) {
				a = r[3];
				b = r[2];
				g = r[1];
				r = r[0];
			}
			return (r << 24 | g << 16 | b << 8 | a) >>> 0;
		},
		lerp: function lerp(a, b, alpha) {
			return a + (b - a) * math.clamp(alpha, 0, 1);
		},
		lerpAngle: function lerpAngle(a, b, alpha) {
			if (b - a > 180) {
				b -= 360;
			}
			if (b - a < -180) {
				b += 360;
			}
			return math.lerp(a, b, math.clamp(alpha, 0, 1));
		},
		powerOfTwo: function powerOfTwo(x) {
			return x !== 0 && !(x & x - 1);
		},
		nextPowerOfTwo: function nextPowerOfTwo(val) {
			val--;
			val |= val >> 1;
			val |= val >> 2;
			val |= val >> 4;
			val |= val >> 8;
			val |= val >> 16;
			val++;
			return val;
		},
		nearestPowerOfTwo: function nearestPowerOfTwo(val) {
			return Math.pow(2, Math.round(Math.log(val) / Math.log(2)));
		},
		random: function random(min, max) {
			var diff = max - min;
			return Math.random() * diff + min;
		},
		smoothstep: function smoothstep(min, max, x) {
			if (x <= min) return 0;
			if (x >= max) return 1;
			x = (x - min) / (max - min);
			return x * x * (3 - 2 * x);
		},
		smootherstep: function smootherstep(min, max, x) {
			if (x <= min) return 0;
			if (x >= max) return 1;
			x = (x - min) / (max - min);
			return x * x * x * (x * (x * 6 - 15) + 10);
		},
		roundUp: function roundUp(numToRound, multiple) {
			if (multiple === 0) return numToRound;
			return Math.ceil(numToRound / multiple) * multiple;
		},
		between: function between(num, a, b, inclusive) {
			var min = Math.min(a, b);
			var max = Math.max(a, b);
			return inclusive ? num >= min && num <= max : num > min && num < max;
		}
	};

	var Color = function () {
		function Color(r, g, b, a) {
			if (r === void 0) {
				r = 0;
			}
			if (g === void 0) {
				g = 0;
			}
			if (b === void 0) {
				b = 0;
			}
			if (a === void 0) {
				a = 1;
			}
			this.r = void 0;
			this.g = void 0;
			this.b = void 0;
			this.a = void 0;
			var length = r.length;
			if (length === 3 || length === 4) {
				this.r = r[0];
				this.g = r[1];
				this.b = r[2];
				this.a = r[3] !== undefined ? r[3] : 1;
			} else {
				this.r = r;
				this.g = g;
				this.b = b;
				this.a = a;
			}
		}
		var _proto = Color.prototype;
		_proto.clone = function clone() {
			var cstr = this.constructor;
			return new cstr(this.r, this.g, this.b, this.a);
		};
		_proto.copy = function copy(rhs) {
			this.r = rhs.r;
			this.g = rhs.g;
			this.b = rhs.b;
			this.a = rhs.a;
			return this;
		};
		_proto.equals = function equals(rhs) {
			return this.r === rhs.r && this.g === rhs.g && this.b === rhs.b && this.a === rhs.a;
		};
		_proto.set = function set(r, g, b, a) {
			if (a === void 0) {
				a = 1;
			}
			this.r = r;
			this.g = g;
			this.b = b;
			this.a = a;
			return this;
		};
		_proto.lerp = function lerp(lhs, rhs, alpha) {
			this.r = lhs.r + alpha * (rhs.r - lhs.r);
			this.g = lhs.g + alpha * (rhs.g - lhs.g);
			this.b = lhs.b + alpha * (rhs.b - lhs.b);
			this.a = lhs.a + alpha * (rhs.a - lhs.a);
			return this;
		};
		_proto.fromString = function fromString(hex) {
			var i = parseInt(hex.replace('#', '0x'), 16);
			var bytes;
			if (hex.length > 7) {
				bytes = math.intToBytes32(i);
			} else {
				bytes = math.intToBytes24(i);
				bytes[3] = 255;
			}
			this.set(bytes[0] / 255, bytes[1] / 255, bytes[2] / 255, bytes[3] / 255);
			return this;
		};
		_proto.toString = function toString(alpha) {
			var s = '#' + ((1 << 24) + (Math.round(this.r * 255) << 16) + (Math.round(this.g * 255) << 8) + Math.round(this.b * 255)).toString(16).slice(1);
			if (alpha === true) {
				var a = Math.round(this.a * 255).toString(16);
				if (this.a < 16 / 255) {
					s += '0' + a;
				} else {
					s += a;
				}
			}
			return s;
		};
		return Color;
	}();
	Color.BLACK = Object.freeze(new Color(0, 0, 0, 1));
	Color.BLUE = Object.freeze(new Color(0, 0, 1, 1));
	Color.CYAN = Object.freeze(new Color(0, 1, 1, 1));
	Color.GRAY = Object.freeze(new Color(0.5, 0.5, 0.5, 1));
	Color.GREEN = Object.freeze(new Color(0, 1, 0, 1));
	Color.MAGENTA = Object.freeze(new Color(1, 0, 1, 1));
	Color.RED = Object.freeze(new Color(1, 0, 0, 1));
	Color.WHITE = Object.freeze(new Color(1, 1, 1, 1));
	Color.YELLOW = Object.freeze(new Color(1, 1, 0, 1));

	var CurveEvaluator = function () {
		function CurveEvaluator(curve, time) {
			if (time === void 0) {
				time = 0;
			}
			this._curve = void 0;
			this._left = -Infinity;
			this._right = Infinity;
			this._recip = 0;
			this._p0 = 0;
			this._p1 = 0;
			this._m0 = 0;
			this._m1 = 0;
			this._curve = curve;
			this._reset(time);
		}
		var _proto = CurveEvaluator.prototype;
		_proto.evaluate = function evaluate(time, forceReset) {
			if (forceReset === void 0) {
				forceReset = false;
			}
			if (forceReset || time < this._left || time >= this._right) {
				this._reset(time);
			}
			var result;
			var type = this._curve.type;
			if (type === CURVE_STEP) {
				result = this._p0;
			} else {
				var t = this._recip === 0 ? 0 : (time - this._left) * this._recip;
				if (type === CURVE_LINEAR) {
					result = math.lerp(this._p0, this._p1, t);
				} else if (type === CURVE_SMOOTHSTEP) {
					result = math.lerp(this._p0, this._p1, t * t * (3 - 2 * t));
				} else {
					result = this._evaluateHermite(this._p0, this._p1, this._m0, this._m1, t);
				}
			}
			return result;
		};
		_proto._reset = function _reset(time) {
			var keys = this._curve.keys;
			var len = keys.length;
			if (!len) {
				this._left = -Infinity;
				this._right = Infinity;
				this._recip = 0;
				this._p0 = this._p1 = this._m0 = this._m1 = 0;
			} else {
				if (time < keys[0][0]) {
					this._left = -Infinity;
					this._right = keys[0][0];
					this._recip = 0;
					this._p0 = this._p1 = keys[0][1];
					this._m0 = this._m1 = 0;
				} else if (time >= keys[len - 1][0]) {
					this._left = keys[len - 1][0];
					this._right = Infinity;
					this._recip = 0;
					this._p0 = this._p1 = keys[len - 1][1];
					this._m0 = this._m1 = 0;
				} else {
					var index = 0;
					while (time >= keys[index + 1][0]) {
						index++;
					}
					this._left = keys[index][0];
					this._right = keys[index + 1][0];
					var diff = 1.0 / (this._right - this._left);
					this._recip = isFinite(diff) ? diff : 0;
					this._p0 = keys[index][1];
					this._p1 = keys[index + 1][1];
					if (this._isHermite()) {
						this._calcTangents(keys, index);
					}
				}
			}
		};
		_proto._isHermite = function _isHermite() {
			return this._curve.type === CURVE_CATMULL || this._curve.type === CURVE_CARDINAL || this._curve.type === CURVE_SPLINE;
		};
		_proto._calcTangents = function _calcTangents(keys, index) {
			var a;
			var b = keys[index];
			var c = keys[index + 1];
			var d;
			if (index === 0) {
				a = [keys[0][0] + (keys[0][0] - keys[1][0]), keys[0][1] + (keys[0][1] - keys[1][1])];
			} else {
				a = keys[index - 1];
			}
			if (index === keys.length - 2) {
				d = [keys[index + 1][0] + (keys[index + 1][0] - keys[index][0]), keys[index + 1][1] + (keys[index + 1][1] - keys[index][1])];
			} else {
				d = keys[index + 2];
			}
			if (this._curve.type === CURVE_SPLINE) {
				var s1_ = 2 * (c[0] - b[0]) / (c[0] - a[0]);
				var s2_ = 2 * (c[0] - b[0]) / (d[0] - b[0]);
				this._m0 = this._curve.tension * (isFinite(s1_) ? s1_ : 0) * (c[1] - a[1]);
				this._m1 = this._curve.tension * (isFinite(s2_) ? s2_ : 0) * (d[1] - b[1]);
			} else {
				var s1 = (c[0] - b[0]) / (b[0] - a[0]);
				var s2 = (c[0] - b[0]) / (d[0] - c[0]);
				var a_ = b[1] + (a[1] - b[1]) * (isFinite(s1) ? s1 : 0);
				var d_ = c[1] + (d[1] - c[1]) * (isFinite(s2) ? s2 : 0);
				var tension = this._curve.type === CURVE_CATMULL ? 0.5 : this._curve.tension;
				this._m0 = tension * (c[1] - a_);
				this._m1 = tension * (d_ - b[1]);
			}
		};
		_proto._evaluateHermite = function _evaluateHermite(p0, p1, m0, m1, t) {
			var t2 = t * t;
			var twot = t + t;
			var omt = 1 - t;
			var omt2 = omt * omt;
			return p0 * ((1 + twot) * omt2) + m0 * (t * omt2) + p1 * (t2 * (3 - twot)) + m1 * (t2 * (t - 1));
		};
		return CurveEvaluator;
	}();

	var Curve = function () {
		function Curve(data) {
			this.keys = [];
			this.type = CURVE_SMOOTHSTEP;
			this.tension = 0.5;
			this._eval = new CurveEvaluator(this);
			if (data) {
				for (var i = 0; i < data.length - 1; i += 2) {
					this.keys.push([data[i], data[i + 1]]);
				}
			}
			this.sort();
		}
		var _proto = Curve.prototype;
		_proto.add = function add(time, value) {
			var keys = this.keys;
			var len = keys.length;
			var i = 0;
			for (; i < len; i++) {
				if (keys[i][0] > time) {
					break;
				}
			}
			var key = [time, value];
			this.keys.splice(i, 0, key);
			return key;
		};
		_proto.get = function get(index) {
			return this.keys[index];
		};
		_proto.sort = function sort() {
			this.keys.sort(function (a, b) {
				return a[0] - b[0];
			});
		};
		_proto.value = function value(time) {
			return this._eval.evaluate(time, true);
		};
		_proto.closest = function closest(time) {
			var keys = this.keys;
			var length = keys.length;
			var min = 2;
			var result = null;
			for (var i = 0; i < length; i++) {
				var diff = Math.abs(time - keys[i][0]);
				if (min >= diff) {
					min = diff;
					result = keys[i];
				} else {
					break;
				}
			}
			return result;
		};
		_proto.clone = function clone() {
			var result = new this.constructor();
			result.keys = extend(result.keys, this.keys);
			result.type = this.type;
			result.tension = this.tension;
			return result;
		};
		_proto.quantize = function quantize(precision) {
			precision = Math.max(precision, 2);
			var values = new Float32Array(precision);
			var step = 1.0 / (precision - 1);
			values[0] = this._eval.evaluate(0, true);
			for (var i = 1; i < precision; i++) {
				values[i] = this._eval.evaluate(step * i);
			}
			return values;
		};
		_proto.quantizeClamped = function quantizeClamped(precision, min, max) {
			var result = this.quantize(precision);
			for (var i = 0; i < result.length; ++i) {
				result[i] = Math.min(max, Math.max(min, result[i]));
			}
			return result;
		};
		_createClass(Curve, [{
			key: "length",
			get: function get() {
				return this.keys.length;
			}
		}]);
		return Curve;
	}();

	var CurveSet = function () {
		function CurveSet() {
			this.curves = [];
			this._type = CURVE_SMOOTHSTEP;
			if (arguments.length > 1) {
				for (var i = 0; i < arguments.length; i++) {
					this.curves.push(new Curve(arguments[i]));
				}
			} else {
				if (arguments.length === 0) {
					this.curves.push(new Curve());
				} else {
					var arg = arguments[0];
					if (typeof arg === 'number') {
						for (var _i = 0; _i < arg; _i++) {
							this.curves.push(new Curve());
						}
					} else {
						for (var _i2 = 0; _i2 < arg.length; _i2++) {
							this.curves.push(new Curve(arg[_i2]));
						}
					}
				}
			}
		}
		var _proto = CurveSet.prototype;
		_proto.get = function get(index) {
			return this.curves[index];
		};
		_proto.value = function value(time, result) {
			if (result === void 0) {
				result = [];
			}
			var length = this.curves.length;
			result.length = length;
			for (var i = 0; i < length; i++) {
				result[i] = this.curves[i].value(time);
			}
			return result;
		};
		_proto.clone = function clone() {
			var result = new this.constructor();
			result.curves = [];
			for (var i = 0; i < this.curves.length; i++) {
				result.curves.push(this.curves[i].clone());
			}
			result._type = this._type;
			return result;
		};
		_proto.quantize = function quantize(precision) {
			precision = Math.max(precision, 2);
			var numCurves = this.curves.length;
			var values = new Float32Array(precision * numCurves);
			var step = 1.0 / (precision - 1);
			for (var c = 0; c < numCurves; c++) {
				var ev = new CurveEvaluator(this.curves[c]);
				for (var i = 0; i < precision; i++) {
					values[i * numCurves + c] = ev.evaluate(step * i);
				}
			}
			return values;
		};
		_proto.quantizeClamped = function quantizeClamped(precision, min, max) {
			var result = this.quantize(precision);
			for (var i = 0; i < result.length; ++i) {
				result[i] = Math.min(max, Math.max(min, result[i]));
			}
			return result;
		};
		_createClass(CurveSet, [{
			key: "length",
			get: function get() {
				return this.curves.length;
			}
		}, {
			key: "type",
			get: function get() {
				return this._type;
			},
			set: function set(value) {
				this._type = value;
				for (var i = 0; i < this.curves.length; i++) {
					this.curves[i].type = value;
				}
			}
		}]);
		return CurveSet;
	}();

	var Vec3 = function () {
		function Vec3(x, y, z) {
			if (x === void 0) {
				x = 0;
			}
			if (y === void 0) {
				y = 0;
			}
			if (z === void 0) {
				z = 0;
			}
			this.x = void 0;
			this.y = void 0;
			this.z = void 0;
			if (x.length === 3) {
				this.x = x[0];
				this.y = x[1];
				this.z = x[2];
			} else {
				this.x = x;
				this.y = y;
				this.z = z;
			}
		}
		var _proto = Vec3.prototype;
		_proto.add = function add(rhs) {
			this.x += rhs.x;
			this.y += rhs.y;
			this.z += rhs.z;
			return this;
		};
		_proto.add2 = function add2(lhs, rhs) {
			this.x = lhs.x + rhs.x;
			this.y = lhs.y + rhs.y;
			this.z = lhs.z + rhs.z;
			return this;
		};
		_proto.addScalar = function addScalar(scalar) {
			this.x += scalar;
			this.y += scalar;
			this.z += scalar;
			return this;
		};
		_proto.clone = function clone() {
			var cstr = this.constructor;
			return new cstr(this.x, this.y, this.z);
		};
		_proto.copy = function copy(rhs) {
			this.x = rhs.x;
			this.y = rhs.y;
			this.z = rhs.z;
			return this;
		};
		_proto.cross = function cross(lhs, rhs) {
			var lx = lhs.x;
			var ly = lhs.y;
			var lz = lhs.z;
			var rx = rhs.x;
			var ry = rhs.y;
			var rz = rhs.z;
			this.x = ly * rz - ry * lz;
			this.y = lz * rx - rz * lx;
			this.z = lx * ry - rx * ly;
			return this;
		};
		_proto.distance = function distance(rhs) {
			var x = this.x - rhs.x;
			var y = this.y - rhs.y;
			var z = this.z - rhs.z;
			return Math.sqrt(x * x + y * y + z * z);
		};
		_proto.div = function div(rhs) {
			this.x /= rhs.x;
			this.y /= rhs.y;
			this.z /= rhs.z;
			return this;
		};
		_proto.div2 = function div2(lhs, rhs) {
			this.x = lhs.x / rhs.x;
			this.y = lhs.y / rhs.y;
			this.z = lhs.z / rhs.z;
			return this;
		};
		_proto.divScalar = function divScalar(scalar) {
			this.x /= scalar;
			this.y /= scalar;
			this.z /= scalar;
			return this;
		};
		_proto.dot = function dot(rhs) {
			return this.x * rhs.x + this.y * rhs.y + this.z * rhs.z;
		};
		_proto.equals = function equals(rhs) {
			return this.x === rhs.x && this.y === rhs.y && this.z === rhs.z;
		};
		_proto.length = function length() {
			return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
		};
		_proto.lengthSq = function lengthSq() {
			return this.x * this.x + this.y * this.y + this.z * this.z;
		};
		_proto.lerp = function lerp(lhs, rhs, alpha) {
			this.x = lhs.x + alpha * (rhs.x - lhs.x);
			this.y = lhs.y + alpha * (rhs.y - lhs.y);
			this.z = lhs.z + alpha * (rhs.z - lhs.z);
			return this;
		};
		_proto.mul = function mul(rhs) {
			this.x *= rhs.x;
			this.y *= rhs.y;
			this.z *= rhs.z;
			return this;
		};
		_proto.mul2 = function mul2(lhs, rhs) {
			this.x = lhs.x * rhs.x;
			this.y = lhs.y * rhs.y;
			this.z = lhs.z * rhs.z;
			return this;
		};
		_proto.mulScalar = function mulScalar(scalar) {
			this.x *= scalar;
			this.y *= scalar;
			this.z *= scalar;
			return this;
		};
		_proto.normalize = function normalize() {
			var lengthSq = this.x * this.x + this.y * this.y + this.z * this.z;
			if (lengthSq > 0) {
				var invLength = 1 / Math.sqrt(lengthSq);
				this.x *= invLength;
				this.y *= invLength;
				this.z *= invLength;
			}
			return this;
		};
		_proto.floor = function floor() {
			this.x = Math.floor(this.x);
			this.y = Math.floor(this.y);
			this.z = Math.floor(this.z);
			return this;
		};
		_proto.ceil = function ceil() {
			this.x = Math.ceil(this.x);
			this.y = Math.ceil(this.y);
			this.z = Math.ceil(this.z);
			return this;
		};
		_proto.round = function round() {
			this.x = Math.round(this.x);
			this.y = Math.round(this.y);
			this.z = Math.round(this.z);
			return this;
		};
		_proto.min = function min(rhs) {
			if (rhs.x < this.x) this.x = rhs.x;
			if (rhs.y < this.y) this.y = rhs.y;
			if (rhs.z < this.z) this.z = rhs.z;
			return this;
		};
		_proto.max = function max(rhs) {
			if (rhs.x > this.x) this.x = rhs.x;
			if (rhs.y > this.y) this.y = rhs.y;
			if (rhs.z > this.z) this.z = rhs.z;
			return this;
		};
		_proto.project = function project(rhs) {
			var a_dot_b = this.x * rhs.x + this.y * rhs.y + this.z * rhs.z;
			var b_dot_b = rhs.x * rhs.x + rhs.y * rhs.y + rhs.z * rhs.z;
			var s = a_dot_b / b_dot_b;
			this.x = rhs.x * s;
			this.y = rhs.y * s;
			this.z = rhs.z * s;
			return this;
		};
		_proto.set = function set(x, y, z) {
			this.x = x;
			this.y = y;
			this.z = z;
			return this;
		};
		_proto.sub = function sub(rhs) {
			this.x -= rhs.x;
			this.y -= rhs.y;
			this.z -= rhs.z;
			return this;
		};
		_proto.sub2 = function sub2(lhs, rhs) {
			this.x = lhs.x - rhs.x;
			this.y = lhs.y - rhs.y;
			this.z = lhs.z - rhs.z;
			return this;
		};
		_proto.subScalar = function subScalar(scalar) {
			this.x -= scalar;
			this.y -= scalar;
			this.z -= scalar;
			return this;
		};
		_proto.toString = function toString() {
			return "[" + this.x + ", " + this.y + ", " + this.z + "]";
		};
		return Vec3;
	}();
	Vec3.ZERO = Object.freeze(new Vec3(0, 0, 0));
	Vec3.ONE = Object.freeze(new Vec3(1, 1, 1));
	Vec3.UP = Object.freeze(new Vec3(0, 1, 0));
	Vec3.DOWN = Object.freeze(new Vec3(0, -1, 0));
	Vec3.RIGHT = Object.freeze(new Vec3(1, 0, 0));
	Vec3.LEFT = Object.freeze(new Vec3(-1, 0, 0));
	Vec3.FORWARD = Object.freeze(new Vec3(0, 0, -1));
	Vec3.BACK = Object.freeze(new Vec3(0, 0, 1));

	var Mat3 = function () {
		function Mat3() {
			this.data = new Float32Array(9);
			this.data[0] = this.data[4] = this.data[8] = 1;
		}
		var _proto = Mat3.prototype;
		_proto.clone = function clone() {
			var cstr = this.constructor;
			return new cstr().copy(this);
		};
		_proto.copy = function copy(rhs) {
			var src = rhs.data;
			var dst = this.data;
			dst[0] = src[0];
			dst[1] = src[1];
			dst[2] = src[2];
			dst[3] = src[3];
			dst[4] = src[4];
			dst[5] = src[5];
			dst[6] = src[6];
			dst[7] = src[7];
			dst[8] = src[8];
			return this;
		};
		_proto.set = function set(src) {
			var dst = this.data;
			dst[0] = src[0];
			dst[1] = src[1];
			dst[2] = src[2];
			dst[3] = src[3];
			dst[4] = src[4];
			dst[5] = src[5];
			dst[6] = src[6];
			dst[7] = src[7];
			dst[8] = src[8];
			return this;
		};
		_proto.equals = function equals(rhs) {
			var l = this.data;
			var r = rhs.data;
			return l[0] === r[0] && l[1] === r[1] && l[2] === r[2] && l[3] === r[3] && l[4] === r[4] && l[5] === r[5] && l[6] === r[6] && l[7] === r[7] && l[8] === r[8];
		};
		_proto.isIdentity = function isIdentity() {
			var m = this.data;
			return m[0] === 1 && m[1] === 0 && m[2] === 0 && m[3] === 0 && m[4] === 1 && m[5] === 0 && m[6] === 0 && m[7] === 0 && m[8] === 1;
		};
		_proto.setIdentity = function setIdentity() {
			var m = this.data;
			m[0] = 1;
			m[1] = 0;
			m[2] = 0;
			m[3] = 0;
			m[4] = 1;
			m[5] = 0;
			m[6] = 0;
			m[7] = 0;
			m[8] = 1;
			return this;
		};
		_proto.toString = function toString() {
			return '[' + this.data.join(', ') + ']';
		};
		_proto.transpose = function transpose() {
			var m = this.data;
			var tmp;
			tmp = m[1];
			m[1] = m[3];
			m[3] = tmp;
			tmp = m[2];
			m[2] = m[6];
			m[6] = tmp;
			tmp = m[5];
			m[5] = m[7];
			m[7] = tmp;
			return this;
		};
		_proto.setFromMat4 = function setFromMat4(m) {
			var src = m.data;
			var dst = this.data;
			dst[0] = src[0];
			dst[1] = src[1];
			dst[2] = src[2];
			dst[3] = src[4];
			dst[4] = src[5];
			dst[5] = src[6];
			dst[6] = src[8];
			dst[7] = src[9];
			dst[8] = src[10];
			return this;
		};
		_proto.transformVector = function transformVector(vec, res) {
			if (res === void 0) {
				res = new Vec3();
			}
			var m = this.data;
			var x = vec.x;
			var y = vec.y;
			var z = vec.z;
			res.x = x * m[0] + y * m[3] + z * m[6];
			res.y = x * m[1] + y * m[4] + z * m[7];
			res.z = x * m[2] + y * m[5] + z * m[8];
			return res;
		};
		return Mat3;
	}();
	Mat3.IDENTITY = Object.freeze(new Mat3());
	Mat3.ZERO = Object.freeze(new Mat3().set([0, 0, 0, 0, 0, 0, 0, 0, 0]));

	var Vec2 = function () {
		function Vec2(x, y) {
			if (x === void 0) {
				x = 0;
			}
			if (y === void 0) {
				y = 0;
			}
			this.x = void 0;
			this.y = void 0;
			if (x.length === 2) {
				this.x = x[0];
				this.y = x[1];
			} else {
				this.x = x;
				this.y = y;
			}
		}
		var _proto = Vec2.prototype;
		_proto.add = function add(rhs) {
			this.x += rhs.x;
			this.y += rhs.y;
			return this;
		};
		_proto.add2 = function add2(lhs, rhs) {
			this.x = lhs.x + rhs.x;
			this.y = lhs.y + rhs.y;
			return this;
		};
		_proto.addScalar = function addScalar(scalar) {
			this.x += scalar;
			this.y += scalar;
			return this;
		};
		_proto.clone = function clone() {
			var cstr = this.constructor;
			return new cstr(this.x, this.y);
		};
		_proto.copy = function copy(rhs) {
			this.x = rhs.x;
			this.y = rhs.y;
			return this;
		};
		_proto.cross = function cross(rhs) {
			return this.x * rhs.y - this.y * rhs.x;
		};
		_proto.distance = function distance(rhs) {
			var x = this.x - rhs.x;
			var y = this.y - rhs.y;
			return Math.sqrt(x * x + y * y);
		};
		_proto.div = function div(rhs) {
			this.x /= rhs.x;
			this.y /= rhs.y;
			return this;
		};
		_proto.div2 = function div2(lhs, rhs) {
			this.x = lhs.x / rhs.x;
			this.y = lhs.y / rhs.y;
			return this;
		};
		_proto.divScalar = function divScalar(scalar) {
			this.x /= scalar;
			this.y /= scalar;
			return this;
		};
		_proto.dot = function dot(rhs) {
			return this.x * rhs.x + this.y * rhs.y;
		};
		_proto.equals = function equals(rhs) {
			return this.x === rhs.x && this.y === rhs.y;
		};
		_proto.length = function length() {
			return Math.sqrt(this.x * this.x + this.y * this.y);
		};
		_proto.lengthSq = function lengthSq() {
			return this.x * this.x + this.y * this.y;
		};
		_proto.lerp = function lerp(lhs, rhs, alpha) {
			this.x = lhs.x + alpha * (rhs.x - lhs.x);
			this.y = lhs.y + alpha * (rhs.y - lhs.y);
			return this;
		};
		_proto.mul = function mul(rhs) {
			this.x *= rhs.x;
			this.y *= rhs.y;
			return this;
		};
		_proto.mul2 = function mul2(lhs, rhs) {
			this.x = lhs.x * rhs.x;
			this.y = lhs.y * rhs.y;
			return this;
		};
		_proto.mulScalar = function mulScalar(scalar) {
			this.x *= scalar;
			this.y *= scalar;
			return this;
		};
		_proto.normalize = function normalize() {
			var lengthSq = this.x * this.x + this.y * this.y;
			if (lengthSq > 0) {
				var invLength = 1 / Math.sqrt(lengthSq);
				this.x *= invLength;
				this.y *= invLength;
			}
			return this;
		};
		_proto.floor = function floor() {
			this.x = Math.floor(this.x);
			this.y = Math.floor(this.y);
			return this;
		};
		_proto.ceil = function ceil() {
			this.x = Math.ceil(this.x);
			this.y = Math.ceil(this.y);
			return this;
		};
		_proto.round = function round() {
			this.x = Math.round(this.x);
			this.y = Math.round(this.y);
			return this;
		};
		_proto.min = function min(rhs) {
			if (rhs.x < this.x) this.x = rhs.x;
			if (rhs.y < this.y) this.y = rhs.y;
			return this;
		};
		_proto.max = function max(rhs) {
			if (rhs.x > this.x) this.x = rhs.x;
			if (rhs.y > this.y) this.y = rhs.y;
			return this;
		};
		_proto.set = function set(x, y) {
			this.x = x;
			this.y = y;
			return this;
		};
		_proto.sub = function sub(rhs) {
			this.x -= rhs.x;
			this.y -= rhs.y;
			return this;
		};
		_proto.sub2 = function sub2(lhs, rhs) {
			this.x = lhs.x - rhs.x;
			this.y = lhs.y - rhs.y;
			return this;
		};
		_proto.subScalar = function subScalar(scalar) {
			this.x -= scalar;
			this.y -= scalar;
			return this;
		};
		_proto.toString = function toString() {
			return "[" + this.x + ", " + this.y + "]";
		};
		Vec2.angleRad = function angleRad(lhs, rhs) {
			return Math.atan2(lhs.x * rhs.y - lhs.y * rhs.x, lhs.x * rhs.x + lhs.y * rhs.y);
		};
		return Vec2;
	}();
	Vec2.ZERO = Object.freeze(new Vec2(0, 0));
	Vec2.ONE = Object.freeze(new Vec2(1, 1));
	Vec2.UP = Object.freeze(new Vec2(0, 1));
	Vec2.DOWN = Object.freeze(new Vec2(0, -1));
	Vec2.RIGHT = Object.freeze(new Vec2(1, 0));
	Vec2.LEFT = Object.freeze(new Vec2(-1, 0));

	var Vec4 = function () {
		function Vec4(x, y, z, w) {
			if (x === void 0) {
				x = 0;
			}
			if (y === void 0) {
				y = 0;
			}
			if (z === void 0) {
				z = 0;
			}
			if (w === void 0) {
				w = 0;
			}
			this.x = void 0;
			this.y = void 0;
			this.z = void 0;
			this.w = void 0;
			if (x.length === 4) {
				this.x = x[0];
				this.y = x[1];
				this.z = x[2];
				this.w = x[3];
			} else {
				this.x = x;
				this.y = y;
				this.z = z;
				this.w = w;
			}
		}
		var _proto = Vec4.prototype;
		_proto.add = function add(rhs) {
			this.x += rhs.x;
			this.y += rhs.y;
			this.z += rhs.z;
			this.w += rhs.w;
			return this;
		};
		_proto.add2 = function add2(lhs, rhs) {
			this.x = lhs.x + rhs.x;
			this.y = lhs.y + rhs.y;
			this.z = lhs.z + rhs.z;
			this.w = lhs.w + rhs.w;
			return this;
		};
		_proto.addScalar = function addScalar(scalar) {
			this.x += scalar;
			this.y += scalar;
			this.z += scalar;
			this.w += scalar;
			return this;
		};
		_proto.clone = function clone() {
			var cstr = this.constructor;
			return new cstr(this.x, this.y, this.z, this.w);
		};
		_proto.copy = function copy(rhs) {
			this.x = rhs.x;
			this.y = rhs.y;
			this.z = rhs.z;
			this.w = rhs.w;
			return this;
		};
		_proto.div = function div(rhs) {
			this.x /= rhs.x;
			this.y /= rhs.y;
			this.z /= rhs.z;
			this.w /= rhs.w;
			return this;
		};
		_proto.div2 = function div2(lhs, rhs) {
			this.x = lhs.x / rhs.x;
			this.y = lhs.y / rhs.y;
			this.z = lhs.z / rhs.z;
			this.w = lhs.w / rhs.w;
			return this;
		};
		_proto.divScalar = function divScalar(scalar) {
			this.x /= scalar;
			this.y /= scalar;
			this.z /= scalar;
			this.w /= scalar;
			return this;
		};
		_proto.dot = function dot(rhs) {
			return this.x * rhs.x + this.y * rhs.y + this.z * rhs.z + this.w * rhs.w;
		};
		_proto.equals = function equals(rhs) {
			return this.x === rhs.x && this.y === rhs.y && this.z === rhs.z && this.w === rhs.w;
		};
		_proto.length = function length() {
			return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
		};
		_proto.lengthSq = function lengthSq() {
			return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
		};
		_proto.lerp = function lerp(lhs, rhs, alpha) {
			this.x = lhs.x + alpha * (rhs.x - lhs.x);
			this.y = lhs.y + alpha * (rhs.y - lhs.y);
			this.z = lhs.z + alpha * (rhs.z - lhs.z);
			this.w = lhs.w + alpha * (rhs.w - lhs.w);
			return this;
		};
		_proto.mul = function mul(rhs) {
			this.x *= rhs.x;
			this.y *= rhs.y;
			this.z *= rhs.z;
			this.w *= rhs.w;
			return this;
		};
		_proto.mul2 = function mul2(lhs, rhs) {
			this.x = lhs.x * rhs.x;
			this.y = lhs.y * rhs.y;
			this.z = lhs.z * rhs.z;
			this.w = lhs.w * rhs.w;
			return this;
		};
		_proto.mulScalar = function mulScalar(scalar) {
			this.x *= scalar;
			this.y *= scalar;
			this.z *= scalar;
			this.w *= scalar;
			return this;
		};
		_proto.normalize = function normalize() {
			var lengthSq = this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
			if (lengthSq > 0) {
				var invLength = 1 / Math.sqrt(lengthSq);
				this.x *= invLength;
				this.y *= invLength;
				this.z *= invLength;
				this.w *= invLength;
			}
			return this;
		};
		_proto.floor = function floor() {
			this.x = Math.floor(this.x);
			this.y = Math.floor(this.y);
			this.z = Math.floor(this.z);
			this.w = Math.floor(this.w);
			return this;
		};
		_proto.ceil = function ceil() {
			this.x = Math.ceil(this.x);
			this.y = Math.ceil(this.y);
			this.z = Math.ceil(this.z);
			this.w = Math.ceil(this.w);
			return this;
		};
		_proto.round = function round() {
			this.x = Math.round(this.x);
			this.y = Math.round(this.y);
			this.z = Math.round(this.z);
			this.w = Math.round(this.w);
			return this;
		};
		_proto.min = function min(rhs) {
			if (rhs.x < this.x) this.x = rhs.x;
			if (rhs.y < this.y) this.y = rhs.y;
			if (rhs.z < this.z) this.z = rhs.z;
			if (rhs.w < this.w) this.w = rhs.w;
			return this;
		};
		_proto.max = function max(rhs) {
			if (rhs.x > this.x) this.x = rhs.x;
			if (rhs.y > this.y) this.y = rhs.y;
			if (rhs.z > this.z) this.z = rhs.z;
			if (rhs.w > this.w) this.w = rhs.w;
			return this;
		};
		_proto.set = function set(x, y, z, w) {
			this.x = x;
			this.y = y;
			this.z = z;
			this.w = w;
			return this;
		};
		_proto.sub = function sub(rhs) {
			this.x -= rhs.x;
			this.y -= rhs.y;
			this.z -= rhs.z;
			this.w -= rhs.w;
			return this;
		};
		_proto.sub2 = function sub2(lhs, rhs) {
			this.x = lhs.x - rhs.x;
			this.y = lhs.y - rhs.y;
			this.z = lhs.z - rhs.z;
			this.w = lhs.w - rhs.w;
			return this;
		};
		_proto.subScalar = function subScalar(scalar) {
			this.x -= scalar;
			this.y -= scalar;
			this.z -= scalar;
			this.w -= scalar;
			return this;
		};
		_proto.toString = function toString() {
			return "[" + this.x + ", " + this.y + ", " + this.z + ", " + this.w + "]";
		};
		return Vec4;
	}();
	Vec4.ZERO = Object.freeze(new Vec4(0, 0, 0, 0));
	Vec4.ONE = Object.freeze(new Vec4(1, 1, 1, 1));

	var _halfSize$1 = new Vec2();
	var x = new Vec3();
	var y = new Vec3();
	var z = new Vec3();
	var scale = new Vec3();
	var Mat4 = function () {
		function Mat4() {
			this.data = new Float32Array(16);
			this.data[0] = this.data[5] = this.data[10] = this.data[15] = 1;
		}
		Mat4._getPerspectiveHalfSize = function _getPerspectiveHalfSize(halfSize, fov, aspect, znear, fovIsHorizontal) {
			if (fovIsHorizontal) {
				halfSize.x = znear * Math.tan(fov * Math.PI / 360);
				halfSize.y = halfSize.x / aspect;
			} else {
				halfSize.y = znear * Math.tan(fov * Math.PI / 360);
				halfSize.x = halfSize.y * aspect;
			}
		};
		var _proto = Mat4.prototype;
		_proto.add2 = function add2(lhs, rhs) {
			var a = lhs.data,
				b = rhs.data,
				r = this.data;
			r[0] = a[0] + b[0];
			r[1] = a[1] + b[1];
			r[2] = a[2] + b[2];
			r[3] = a[3] + b[3];
			r[4] = a[4] + b[4];
			r[5] = a[5] + b[5];
			r[6] = a[6] + b[6];
			r[7] = a[7] + b[7];
			r[8] = a[8] + b[8];
			r[9] = a[9] + b[9];
			r[10] = a[10] + b[10];
			r[11] = a[11] + b[11];
			r[12] = a[12] + b[12];
			r[13] = a[13] + b[13];
			r[14] = a[14] + b[14];
			r[15] = a[15] + b[15];
			return this;
		};
		_proto.add = function add(rhs) {
			return this.add2(this, rhs);
		};
		_proto.clone = function clone() {
			var cstr = this.constructor;
			return new cstr().copy(this);
		};
		_proto.copy = function copy(rhs) {
			var src = rhs.data,
				dst = this.data;
			dst[0] = src[0];
			dst[1] = src[1];
			dst[2] = src[2];
			dst[3] = src[3];
			dst[4] = src[4];
			dst[5] = src[5];
			dst[6] = src[6];
			dst[7] = src[7];
			dst[8] = src[8];
			dst[9] = src[9];
			dst[10] = src[10];
			dst[11] = src[11];
			dst[12] = src[12];
			dst[13] = src[13];
			dst[14] = src[14];
			dst[15] = src[15];
			return this;
		};
		_proto.equals = function equals(rhs) {
			var l = this.data,
				r = rhs.data;
			return l[0] === r[0] && l[1] === r[1] && l[2] === r[2] && l[3] === r[3] && l[4] === r[4] && l[5] === r[5] && l[6] === r[6] && l[7] === r[7] && l[8] === r[8] && l[9] === r[9] && l[10] === r[10] && l[11] === r[11] && l[12] === r[12] && l[13] === r[13] && l[14] === r[14] && l[15] === r[15];
		};
		_proto.isIdentity = function isIdentity() {
			var m = this.data;
			return m[0] === 1 && m[1] === 0 && m[2] === 0 && m[3] === 0 && m[4] === 0 && m[5] === 1 && m[6] === 0 && m[7] === 0 && m[8] === 0 && m[9] === 0 && m[10] === 1 && m[11] === 0 && m[12] === 0 && m[13] === 0 && m[14] === 0 && m[15] === 1;
		};
		_proto.mul2 = function mul2(lhs, rhs) {
			var a = lhs.data;
			var b = rhs.data;
			var r = this.data;
			var a00 = a[0];
			var a01 = a[1];
			var a02 = a[2];
			var a03 = a[3];
			var a10 = a[4];
			var a11 = a[5];
			var a12 = a[6];
			var a13 = a[7];
			var a20 = a[8];
			var a21 = a[9];
			var a22 = a[10];
			var a23 = a[11];
			var a30 = a[12];
			var a31 = a[13];
			var a32 = a[14];
			var a33 = a[15];
			var b0, b1, b2, b3;
			b0 = b[0];
			b1 = b[1];
			b2 = b[2];
			b3 = b[3];
			r[0] = a00 * b0 + a10 * b1 + a20 * b2 + a30 * b3;
			r[1] = a01 * b0 + a11 * b1 + a21 * b2 + a31 * b3;
			r[2] = a02 * b0 + a12 * b1 + a22 * b2 + a32 * b3;
			r[3] = a03 * b0 + a13 * b1 + a23 * b2 + a33 * b3;
			b0 = b[4];
			b1 = b[5];
			b2 = b[6];
			b3 = b[7];
			r[4] = a00 * b0 + a10 * b1 + a20 * b2 + a30 * b3;
			r[5] = a01 * b0 + a11 * b1 + a21 * b2 + a31 * b3;
			r[6] = a02 * b0 + a12 * b1 + a22 * b2 + a32 * b3;
			r[7] = a03 * b0 + a13 * b1 + a23 * b2 + a33 * b3;
			b0 = b[8];
			b1 = b[9];
			b2 = b[10];
			b3 = b[11];
			r[8] = a00 * b0 + a10 * b1 + a20 * b2 + a30 * b3;
			r[9] = a01 * b0 + a11 * b1 + a21 * b2 + a31 * b3;
			r[10] = a02 * b0 + a12 * b1 + a22 * b2 + a32 * b3;
			r[11] = a03 * b0 + a13 * b1 + a23 * b2 + a33 * b3;
			b0 = b[12];
			b1 = b[13];
			b2 = b[14];
			b3 = b[15];
			r[12] = a00 * b0 + a10 * b1 + a20 * b2 + a30 * b3;
			r[13] = a01 * b0 + a11 * b1 + a21 * b2 + a31 * b3;
			r[14] = a02 * b0 + a12 * b1 + a22 * b2 + a32 * b3;
			r[15] = a03 * b0 + a13 * b1 + a23 * b2 + a33 * b3;
			return this;
		};
		_proto.mulAffine2 = function mulAffine2(lhs, rhs) {
			var a = lhs.data;
			var b = rhs.data;
			var r = this.data;
			var a00 = a[0];
			var a01 = a[1];
			var a02 = a[2];
			var a10 = a[4];
			var a11 = a[5];
			var a12 = a[6];
			var a20 = a[8];
			var a21 = a[9];
			var a22 = a[10];
			var a30 = a[12];
			var a31 = a[13];
			var a32 = a[14];
			var b0, b1, b2;
			b0 = b[0];
			b1 = b[1];
			b2 = b[2];
			r[0] = a00 * b0 + a10 * b1 + a20 * b2;
			r[1] = a01 * b0 + a11 * b1 + a21 * b2;
			r[2] = a02 * b0 + a12 * b1 + a22 * b2;
			r[3] = 0;
			b0 = b[4];
			b1 = b[5];
			b2 = b[6];
			r[4] = a00 * b0 + a10 * b1 + a20 * b2;
			r[5] = a01 * b0 + a11 * b1 + a21 * b2;
			r[6] = a02 * b0 + a12 * b1 + a22 * b2;
			r[7] = 0;
			b0 = b[8];
			b1 = b[9];
			b2 = b[10];
			r[8] = a00 * b0 + a10 * b1 + a20 * b2;
			r[9] = a01 * b0 + a11 * b1 + a21 * b2;
			r[10] = a02 * b0 + a12 * b1 + a22 * b2;
			r[11] = 0;
			b0 = b[12];
			b1 = b[13];
			b2 = b[14];
			r[12] = a00 * b0 + a10 * b1 + a20 * b2 + a30;
			r[13] = a01 * b0 + a11 * b1 + a21 * b2 + a31;
			r[14] = a02 * b0 + a12 * b1 + a22 * b2 + a32;
			r[15] = 1;
			return this;
		};
		_proto.mul = function mul(rhs) {
			return this.mul2(this, rhs);
		};
		_proto.transformPoint = function transformPoint(vec, res) {
			if (res === void 0) {
				res = new Vec3();
			}
			var m = this.data;
			var x = vec.x;
			var y = vec.y;
			var z = vec.z;
			res.x = x * m[0] + y * m[4] + z * m[8] + m[12];
			res.y = x * m[1] + y * m[5] + z * m[9] + m[13];
			res.z = x * m[2] + y * m[6] + z * m[10] + m[14];
			return res;
		};
		_proto.transformVector = function transformVector(vec, res) {
			if (res === void 0) {
				res = new Vec3();
			}
			var m = this.data;
			var x = vec.x;
			var y = vec.y;
			var z = vec.z;
			res.x = x * m[0] + y * m[4] + z * m[8];
			res.y = x * m[1] + y * m[5] + z * m[9];
			res.z = x * m[2] + y * m[6] + z * m[10];
			return res;
		};
		_proto.transformVec4 = function transformVec4(vec, res) {
			if (res === void 0) {
				res = new Vec4();
			}
			var m = this.data;
			var x = vec.x;
			var y = vec.y;
			var z = vec.z;
			var w = vec.w;
			res.x = x * m[0] + y * m[4] + z * m[8] + w * m[12];
			res.y = x * m[1] + y * m[5] + z * m[9] + w * m[13];
			res.z = x * m[2] + y * m[6] + z * m[10] + w * m[14];
			res.w = x * m[3] + y * m[7] + z * m[11] + w * m[15];
			return res;
		};
		_proto.setLookAt = function setLookAt(position, target, up) {
			z.sub2(position, target).normalize();
			y.copy(up).normalize();
			x.cross(y, z).normalize();
			y.cross(z, x);
			var r = this.data;
			r[0] = x.x;
			r[1] = x.y;
			r[2] = x.z;
			r[3] = 0;
			r[4] = y.x;
			r[5] = y.y;
			r[6] = y.z;
			r[7] = 0;
			r[8] = z.x;
			r[9] = z.y;
			r[10] = z.z;
			r[11] = 0;
			r[12] = position.x;
			r[13] = position.y;
			r[14] = position.z;
			r[15] = 1;
			return this;
		};
		_proto.setFrustum = function setFrustum(left, right, bottom, top, znear, zfar) {
			var temp1 = 2 * znear;
			var temp2 = right - left;
			var temp3 = top - bottom;
			var temp4 = zfar - znear;
			var r = this.data;
			r[0] = temp1 / temp2;
			r[1] = 0;
			r[2] = 0;
			r[3] = 0;
			r[4] = 0;
			r[5] = temp1 / temp3;
			r[6] = 0;
			r[7] = 0;
			r[8] = (right + left) / temp2;
			r[9] = (top + bottom) / temp3;
			r[10] = (-zfar - znear) / temp4;
			r[11] = -1;
			r[12] = 0;
			r[13] = 0;
			r[14] = -temp1 * zfar / temp4;
			r[15] = 0;
			return this;
		};
		_proto.setPerspective = function setPerspective(fov, aspect, znear, zfar, fovIsHorizontal) {
			Mat4._getPerspectiveHalfSize(_halfSize$1, fov, aspect, znear, fovIsHorizontal);
			return this.setFrustum(-_halfSize$1.x, _halfSize$1.x, -_halfSize$1.y, _halfSize$1.y, znear, zfar);
		};
		_proto.setOrtho = function setOrtho(left, right, bottom, top, near, far) {
			var r = this.data;
			r[0] = 2 / (right - left);
			r[1] = 0;
			r[2] = 0;
			r[3] = 0;
			r[4] = 0;
			r[5] = 2 / (top - bottom);
			r[6] = 0;
			r[7] = 0;
			r[8] = 0;
			r[9] = 0;
			r[10] = -2 / (far - near);
			r[11] = 0;
			r[12] = -(right + left) / (right - left);
			r[13] = -(top + bottom) / (top - bottom);
			r[14] = -(far + near) / (far - near);
			r[15] = 1;
			return this;
		};
		_proto.setFromAxisAngle = function setFromAxisAngle(axis, angle) {
			angle *= math.DEG_TO_RAD;
			var x = axis.x;
			var y = axis.y;
			var z = axis.z;
			var c = Math.cos(angle);
			var s = Math.sin(angle);
			var t = 1 - c;
			var tx = t * x;
			var ty = t * y;
			var m = this.data;
			m[0] = tx * x + c;
			m[1] = tx * y + s * z;
			m[2] = tx * z - s * y;
			m[3] = 0;
			m[4] = tx * y - s * z;
			m[5] = ty * y + c;
			m[6] = ty * z + s * x;
			m[7] = 0;
			m[8] = tx * z + s * y;
			m[9] = ty * z - x * s;
			m[10] = t * z * z + c;
			m[11] = 0;
			m[12] = 0;
			m[13] = 0;
			m[14] = 0;
			m[15] = 1;
			return this;
		};
		_proto.setTranslate = function setTranslate(x, y, z) {
			var m = this.data;
			m[0] = 1;
			m[1] = 0;
			m[2] = 0;
			m[3] = 0;
			m[4] = 0;
			m[5] = 1;
			m[6] = 0;
			m[7] = 0;
			m[8] = 0;
			m[9] = 0;
			m[10] = 1;
			m[11] = 0;
			m[12] = x;
			m[13] = y;
			m[14] = z;
			m[15] = 1;
			return this;
		};
		_proto.setScale = function setScale(x, y, z) {
			var m = this.data;
			m[0] = x;
			m[1] = 0;
			m[2] = 0;
			m[3] = 0;
			m[4] = 0;
			m[5] = y;
			m[6] = 0;
			m[7] = 0;
			m[8] = 0;
			m[9] = 0;
			m[10] = z;
			m[11] = 0;
			m[12] = 0;
			m[13] = 0;
			m[14] = 0;
			m[15] = 1;
			return this;
		};
		_proto.setViewport = function setViewport(x, y, width, height) {
			var m = this.data;
			m[0] = width * 0.5;
			m[1] = 0;
			m[2] = 0;
			m[3] = 0;
			m[4] = 0;
			m[5] = height * 0.5;
			m[6] = 0;
			m[7] = 0;
			m[8] = 0;
			m[9] = 0;
			m[10] = 0.5;
			m[11] = 0;
			m[12] = x + width * 0.5;
			m[13] = y + height * 0.5;
			m[14] = 0.5;
			m[15] = 1;
			return this;
		};
		_proto.setReflection = function setReflection(normal, distance) {
			var a = normal.x;
			var b = normal.y;
			var c = normal.z;
			var data = this.data;
			data[0] = 1.0 - 2 * a * a;
			data[1] = -2 * a * b;
			data[2] = -2 * a * c;
			data[3] = 0;
			data[4] = -2 * a * b;
			data[5] = 1.0 - 2 * b * b;
			data[6] = -2 * b * c;
			data[7] = 0;
			data[8] = -2 * a * c;
			data[9] = -2 * b * c;
			data[10] = 1.0 - 2 * c * c;
			data[11] = 0;
			data[12] = -2 * a * distance;
			data[13] = -2 * b * distance;
			data[14] = -2 * c * distance;
			data[15] = 1;
			return this;
		};
		_proto.invert = function invert() {
			var m = this.data;
			var a00 = m[0];
			var a01 = m[1];
			var a02 = m[2];
			var a03 = m[3];
			var a10 = m[4];
			var a11 = m[5];
			var a12 = m[6];
			var a13 = m[7];
			var a20 = m[8];
			var a21 = m[9];
			var a22 = m[10];
			var a23 = m[11];
			var a30 = m[12];
			var a31 = m[13];
			var a32 = m[14];
			var a33 = m[15];
			var b00 = a00 * a11 - a01 * a10;
			var b01 = a00 * a12 - a02 * a10;
			var b02 = a00 * a13 - a03 * a10;
			var b03 = a01 * a12 - a02 * a11;
			var b04 = a01 * a13 - a03 * a11;
			var b05 = a02 * a13 - a03 * a12;
			var b06 = a20 * a31 - a21 * a30;
			var b07 = a20 * a32 - a22 * a30;
			var b08 = a20 * a33 - a23 * a30;
			var b09 = a21 * a32 - a22 * a31;
			var b10 = a21 * a33 - a23 * a31;
			var b11 = a22 * a33 - a23 * a32;
			var det = b00 * b11 - b01 * b10 + b02 * b09 + b03 * b08 - b04 * b07 + b05 * b06;
			if (det === 0) {
				this.setIdentity();
			} else {
				var invDet = 1 / det;
				m[0] = (a11 * b11 - a12 * b10 + a13 * b09) * invDet;
				m[1] = (-a01 * b11 + a02 * b10 - a03 * b09) * invDet;
				m[2] = (a31 * b05 - a32 * b04 + a33 * b03) * invDet;
				m[3] = (-a21 * b05 + a22 * b04 - a23 * b03) * invDet;
				m[4] = (-a10 * b11 + a12 * b08 - a13 * b07) * invDet;
				m[5] = (a00 * b11 - a02 * b08 + a03 * b07) * invDet;
				m[6] = (-a30 * b05 + a32 * b02 - a33 * b01) * invDet;
				m[7] = (a20 * b05 - a22 * b02 + a23 * b01) * invDet;
				m[8] = (a10 * b10 - a11 * b08 + a13 * b06) * invDet;
				m[9] = (-a00 * b10 + a01 * b08 - a03 * b06) * invDet;
				m[10] = (a30 * b04 - a31 * b02 + a33 * b00) * invDet;
				m[11] = (-a20 * b04 + a21 * b02 - a23 * b00) * invDet;
				m[12] = (-a10 * b09 + a11 * b07 - a12 * b06) * invDet;
				m[13] = (a00 * b09 - a01 * b07 + a02 * b06) * invDet;
				m[14] = (-a30 * b03 + a31 * b01 - a32 * b00) * invDet;
				m[15] = (a20 * b03 - a21 * b01 + a22 * b00) * invDet;
			}
			return this;
		};
		_proto.set = function set(src) {
			var dst = this.data;
			dst[0] = src[0];
			dst[1] = src[1];
			dst[2] = src[2];
			dst[3] = src[3];
			dst[4] = src[4];
			dst[5] = src[5];
			dst[6] = src[6];
			dst[7] = src[7];
			dst[8] = src[8];
			dst[9] = src[9];
			dst[10] = src[10];
			dst[11] = src[11];
			dst[12] = src[12];
			dst[13] = src[13];
			dst[14] = src[14];
			dst[15] = src[15];
			return this;
		};
		_proto.setIdentity = function setIdentity() {
			var m = this.data;
			m[0] = 1;
			m[1] = 0;
			m[2] = 0;
			m[3] = 0;
			m[4] = 0;
			m[5] = 1;
			m[6] = 0;
			m[7] = 0;
			m[8] = 0;
			m[9] = 0;
			m[10] = 1;
			m[11] = 0;
			m[12] = 0;
			m[13] = 0;
			m[14] = 0;
			m[15] = 1;
			return this;
		};
		_proto.setTRS = function setTRS(t, r, s) {
			var qx = r.x;
			var qy = r.y;
			var qz = r.z;
			var qw = r.w;
			var sx = s.x;
			var sy = s.y;
			var sz = s.z;
			var x2 = qx + qx;
			var y2 = qy + qy;
			var z2 = qz + qz;
			var xx = qx * x2;
			var xy = qx * y2;
			var xz = qx * z2;
			var yy = qy * y2;
			var yz = qy * z2;
			var zz = qz * z2;
			var wx = qw * x2;
			var wy = qw * y2;
			var wz = qw * z2;
			var m = this.data;
			m[0] = (1 - (yy + zz)) * sx;
			m[1] = (xy + wz) * sx;
			m[2] = (xz - wy) * sx;
			m[3] = 0;
			m[4] = (xy - wz) * sy;
			m[5] = (1 - (xx + zz)) * sy;
			m[6] = (yz + wx) * sy;
			m[7] = 0;
			m[8] = (xz + wy) * sz;
			m[9] = (yz - wx) * sz;
			m[10] = (1 - (xx + yy)) * sz;
			m[11] = 0;
			m[12] = t.x;
			m[13] = t.y;
			m[14] = t.z;
			m[15] = 1;
			return this;
		};
		_proto.transpose = function transpose() {
			var tmp;
			var m = this.data;
			tmp = m[1];
			m[1] = m[4];
			m[4] = tmp;
			tmp = m[2];
			m[2] = m[8];
			m[8] = tmp;
			tmp = m[3];
			m[3] = m[12];
			m[12] = tmp;
			tmp = m[6];
			m[6] = m[9];
			m[9] = tmp;
			tmp = m[7];
			m[7] = m[13];
			m[13] = tmp;
			tmp = m[11];
			m[11] = m[14];
			m[14] = tmp;
			return this;
		};
		_proto.invertTo3x3 = function invertTo3x3(res) {
			var m = this.data;
			var r = res.data;
			var m0 = m[0];
			var m1 = m[1];
			var m2 = m[2];
			var m4 = m[4];
			var m5 = m[5];
			var m6 = m[6];
			var m8 = m[8];
			var m9 = m[9];
			var m10 = m[10];
			var a11 = m10 * m5 - m6 * m9;
			var a21 = -m10 * m1 + m2 * m9;
			var a31 = m6 * m1 - m2 * m5;
			var a12 = -m10 * m4 + m6 * m8;
			var a22 = m10 * m0 - m2 * m8;
			var a32 = -m6 * m0 + m2 * m4;
			var a13 = m9 * m4 - m5 * m8;
			var a23 = -m9 * m0 + m1 * m8;
			var a33 = m5 * m0 - m1 * m4;
			var det = m0 * a11 + m1 * a12 + m2 * a13;
			if (det === 0) {
				return this;
			}
			var idet = 1 / det;
			r[0] = idet * a11;
			r[1] = idet * a21;
			r[2] = idet * a31;
			r[3] = idet * a12;
			r[4] = idet * a22;
			r[5] = idet * a32;
			r[6] = idet * a13;
			r[7] = idet * a23;
			r[8] = idet * a33;
			return this;
		};
		_proto.getTranslation = function getTranslation(t) {
			if (t === void 0) {
				t = new Vec3();
			}
			return t.set(this.data[12], this.data[13], this.data[14]);
		};
		_proto.getX = function getX(x) {
			if (x === void 0) {
				x = new Vec3();
			}
			return x.set(this.data[0], this.data[1], this.data[2]);
		};
		_proto.getY = function getY(y) {
			if (y === void 0) {
				y = new Vec3();
			}
			return y.set(this.data[4], this.data[5], this.data[6]);
		};
		_proto.getZ = function getZ(z) {
			if (z === void 0) {
				z = new Vec3();
			}
			return z.set(this.data[8], this.data[9], this.data[10]);
		};
		_proto.getScale = function getScale(scale) {
			if (scale === void 0) {
				scale = new Vec3();
			}
			this.getX(x);
			this.getY(y);
			this.getZ(z);
			scale.set(x.length(), y.length(), z.length());
			return scale;
		};
		_proto.setFromEulerAngles = function setFromEulerAngles(ex, ey, ez) {
			ex *= math.DEG_TO_RAD;
			ey *= math.DEG_TO_RAD;
			ez *= math.DEG_TO_RAD;
			var s1 = Math.sin(-ex);
			var c1 = Math.cos(-ex);
			var s2 = Math.sin(-ey);
			var c2 = Math.cos(-ey);
			var s3 = Math.sin(-ez);
			var c3 = Math.cos(-ez);
			var m = this.data;
			m[0] = c2 * c3;
			m[1] = -c2 * s3;
			m[2] = s2;
			m[3] = 0;
			m[4] = c1 * s3 + c3 * s1 * s2;
			m[5] = c1 * c3 - s1 * s2 * s3;
			m[6] = -c2 * s1;
			m[7] = 0;
			m[8] = s1 * s3 - c1 * c3 * s2;
			m[9] = c3 * s1 + c1 * s2 * s3;
			m[10] = c1 * c2;
			m[11] = 0;
			m[12] = 0;
			m[13] = 0;
			m[14] = 0;
			m[15] = 1;
			return this;
		};
		_proto.getEulerAngles = function getEulerAngles(eulers) {
			if (eulers === void 0) {
				eulers = new Vec3();
			}
			this.getScale(scale);
			var sx = scale.x;
			var sy = scale.y;
			var sz = scale.z;
			if (sx === 0 || sy === 0 || sz === 0) return eulers.set(0, 0, 0);
			var m = this.data;
			var y = Math.asin(-m[2] / sx);
			var halfPi = Math.PI * 0.5;
			var x, z;
			if (y < halfPi) {
				if (y > -halfPi) {
					x = Math.atan2(m[6] / sy, m[10] / sz);
					z = Math.atan2(m[1] / sx, m[0] / sx);
				} else {
					z = 0;
					x = -Math.atan2(m[4] / sy, m[5] / sy);
				}
			} else {
				z = 0;
				x = Math.atan2(m[4] / sy, m[5] / sy);
			}
			return eulers.set(x, y, z).mulScalar(math.RAD_TO_DEG);
		};
		_proto.toString = function toString() {
			return '[' + this.data.join(', ') + ']';
		};
		_createClass(Mat4, [{
			key: "scaleSign",
			get: function get() {
				this.getX(x);
				this.getY(y);
				this.getZ(z);
				x.cross(x, y);
				return x.dot(z) < 0 ? -1 : 1;
			}
		}]);
		return Mat4;
	}();
	Mat4.IDENTITY = Object.freeze(new Mat4());
	Mat4.ZERO = Object.freeze(new Mat4().set([0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]));

	var Quat = function () {
		function Quat(x, y, z, w) {
			if (x === void 0) {
				x = 0;
			}
			if (y === void 0) {
				y = 0;
			}
			if (z === void 0) {
				z = 0;
			}
			if (w === void 0) {
				w = 1;
			}
			this.x = void 0;
			this.y = void 0;
			this.z = void 0;
			this.w = void 0;
			if (x.length === 4) {
				this.x = x[0];
				this.y = x[1];
				this.z = x[2];
				this.w = x[3];
			} else {
				this.x = x;
				this.y = y;
				this.z = z;
				this.w = w;
			}
		}
		var _proto = Quat.prototype;
		_proto.clone = function clone() {
			var cstr = this.constructor;
			return new cstr(this.x, this.y, this.z, this.w);
		};
		_proto.conjugate = function conjugate() {
			this.x *= -1;
			this.y *= -1;
			this.z *= -1;
			return this;
		};
		_proto.copy = function copy(rhs) {
			this.x = rhs.x;
			this.y = rhs.y;
			this.z = rhs.z;
			this.w = rhs.w;
			return this;
		};
		_proto.equals = function equals(rhs) {
			return this.x === rhs.x && this.y === rhs.y && this.z === rhs.z && this.w === rhs.w;
		};
		_proto.equalsApprox = function equalsApprox(rhs, epsilon) {
			if (epsilon === void 0) {
				epsilon = 1e-6;
			}
			return Math.abs(this.x - rhs.x) < epsilon && Math.abs(this.y - rhs.y) < epsilon && Math.abs(this.z - rhs.z) < epsilon && Math.abs(this.w - rhs.w) < epsilon;
		};
		_proto.getAxisAngle = function getAxisAngle(axis) {
			var rad = Math.acos(this.w) * 2;
			var s = Math.sin(rad / 2);
			if (s !== 0) {
				axis.x = this.x / s;
				axis.y = this.y / s;
				axis.z = this.z / s;
				if (axis.x < 0 || axis.y < 0 || axis.z < 0) {
					axis.x *= -1;
					axis.y *= -1;
					axis.z *= -1;
					rad *= -1;
				}
			} else {
				axis.x = 1;
				axis.y = 0;
				axis.z = 0;
			}
			return rad * math.RAD_TO_DEG;
		};
		_proto.getEulerAngles = function getEulerAngles(eulers) {
			if (eulers === void 0) {
				eulers = new Vec3();
			}
			var x, y, z;
			var qx = this.x;
			var qy = this.y;
			var qz = this.z;
			var qw = this.w;
			var a2 = 2 * (qw * qy - qx * qz);
			if (a2 <= -0.99999) {
				x = 2 * Math.atan2(qx, qw);
				y = -Math.PI / 2;
				z = 0;
			} else if (a2 >= 0.99999) {
				x = 2 * Math.atan2(qx, qw);
				y = Math.PI / 2;
				z = 0;
			} else {
				x = Math.atan2(2 * (qw * qx + qy * qz), 1 - 2 * (qx * qx + qy * qy));
				y = Math.asin(a2);
				z = Math.atan2(2 * (qw * qz + qx * qy), 1 - 2 * (qy * qy + qz * qz));
			}
			return eulers.set(x, y, z).mulScalar(math.RAD_TO_DEG);
		};
		_proto.invert = function invert() {
			return this.conjugate().normalize();
		};
		_proto.length = function length() {
			return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
		};
		_proto.lengthSq = function lengthSq() {
			return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
		};
		_proto.mul = function mul(rhs) {
			var q1x = this.x;
			var q1y = this.y;
			var q1z = this.z;
			var q1w = this.w;
			var q2x = rhs.x;
			var q2y = rhs.y;
			var q2z = rhs.z;
			var q2w = rhs.w;
			this.x = q1w * q2x + q1x * q2w + q1y * q2z - q1z * q2y;
			this.y = q1w * q2y + q1y * q2w + q1z * q2x - q1x * q2z;
			this.z = q1w * q2z + q1z * q2w + q1x * q2y - q1y * q2x;
			this.w = q1w * q2w - q1x * q2x - q1y * q2y - q1z * q2z;
			return this;
		};
		_proto.mul2 = function mul2(lhs, rhs) {
			var q1x = lhs.x;
			var q1y = lhs.y;
			var q1z = lhs.z;
			var q1w = lhs.w;
			var q2x = rhs.x;
			var q2y = rhs.y;
			var q2z = rhs.z;
			var q2w = rhs.w;
			this.x = q1w * q2x + q1x * q2w + q1y * q2z - q1z * q2y;
			this.y = q1w * q2y + q1y * q2w + q1z * q2x - q1x * q2z;
			this.z = q1w * q2z + q1z * q2w + q1x * q2y - q1y * q2x;
			this.w = q1w * q2w - q1x * q2x - q1y * q2y - q1z * q2z;
			return this;
		};
		_proto.normalize = function normalize() {
			var len = this.length();
			if (len === 0) {
				this.x = this.y = this.z = 0;
				this.w = 1;
			} else {
				len = 1 / len;
				this.x *= len;
				this.y *= len;
				this.z *= len;
				this.w *= len;
			}
			return this;
		};
		_proto.set = function set(x, y, z, w) {
			this.x = x;
			this.y = y;
			this.z = z;
			this.w = w;
			return this;
		};
		_proto.setFromAxisAngle = function setFromAxisAngle(axis, angle) {
			angle *= 0.5 * math.DEG_TO_RAD;
			var sa = Math.sin(angle);
			var ca = Math.cos(angle);
			this.x = sa * axis.x;
			this.y = sa * axis.y;
			this.z = sa * axis.z;
			this.w = ca;
			return this;
		};
		_proto.setFromEulerAngles = function setFromEulerAngles(ex, ey, ez) {
			if (ex instanceof Vec3) {
				var vec = ex;
				ex = vec.x;
				ey = vec.y;
				ez = vec.z;
			}
			var halfToRad = 0.5 * math.DEG_TO_RAD;
			ex *= halfToRad;
			ey *= halfToRad;
			ez *= halfToRad;
			var sx = Math.sin(ex);
			var cx = Math.cos(ex);
			var sy = Math.sin(ey);
			var cy = Math.cos(ey);
			var sz = Math.sin(ez);
			var cz = Math.cos(ez);
			this.x = sx * cy * cz - cx * sy * sz;
			this.y = cx * sy * cz + sx * cy * sz;
			this.z = cx * cy * sz - sx * sy * cz;
			this.w = cx * cy * cz + sx * sy * sz;
			return this;
		};
		_proto.setFromMat4 = function setFromMat4(m) {
			var m00, m01, m02, m10, m11, m12, m20, m21, m22, s, rs, lx, ly, lz;
			m = m.data;
			m00 = m[0];
			m01 = m[1];
			m02 = m[2];
			m10 = m[4];
			m11 = m[5];
			m12 = m[6];
			m20 = m[8];
			m21 = m[9];
			m22 = m[10];
			lx = m00 * m00 + m01 * m01 + m02 * m02;
			if (lx === 0) return this;
			lx = 1 / Math.sqrt(lx);
			ly = m10 * m10 + m11 * m11 + m12 * m12;
			if (ly === 0) return this;
			ly = 1 / Math.sqrt(ly);
			lz = m20 * m20 + m21 * m21 + m22 * m22;
			if (lz === 0) return this;
			lz = 1 / Math.sqrt(lz);
			m00 *= lx;
			m01 *= lx;
			m02 *= lx;
			m10 *= ly;
			m11 *= ly;
			m12 *= ly;
			m20 *= lz;
			m21 *= lz;
			m22 *= lz;
			var tr = m00 + m11 + m22;
			if (tr >= 0) {
				s = Math.sqrt(tr + 1);
				this.w = s * 0.5;
				s = 0.5 / s;
				this.x = (m12 - m21) * s;
				this.y = (m20 - m02) * s;
				this.z = (m01 - m10) * s;
			} else {
				if (m00 > m11) {
					if (m00 > m22) {
						rs = m00 - (m11 + m22) + 1;
						rs = Math.sqrt(rs);
						this.x = rs * 0.5;
						rs = 0.5 / rs;
						this.w = (m12 - m21) * rs;
						this.y = (m01 + m10) * rs;
						this.z = (m02 + m20) * rs;
					} else {
						rs = m22 - (m00 + m11) + 1;
						rs = Math.sqrt(rs);
						this.z = rs * 0.5;
						rs = 0.5 / rs;
						this.w = (m01 - m10) * rs;
						this.x = (m20 + m02) * rs;
						this.y = (m21 + m12) * rs;
					}
				} else if (m11 > m22) {
					rs = m11 - (m22 + m00) + 1;
					rs = Math.sqrt(rs);
					this.y = rs * 0.5;
					rs = 0.5 / rs;
					this.w = (m20 - m02) * rs;
					this.z = (m12 + m21) * rs;
					this.x = (m10 + m01) * rs;
				} else {
					rs = m22 - (m00 + m11) + 1;
					rs = Math.sqrt(rs);
					this.z = rs * 0.5;
					rs = 0.5 / rs;
					this.w = (m01 - m10) * rs;
					this.x = (m20 + m02) * rs;
					this.y = (m21 + m12) * rs;
				}
			}
			return this;
		};
		_proto.setFromDirections = function setFromDirections(from, to) {
			var dotProduct = 1 + from.dot(to);
			if (dotProduct < Number.EPSILON) {
				if (Math.abs(from.x) > Math.abs(from.y)) {
					this.x = -from.z;
					this.y = 0;
					this.z = from.x;
					this.w = 0;
				} else {
					this.x = 0;
					this.y = -from.z;
					this.z = from.y;
					this.w = 0;
				}
			} else {
				this.x = from.y * to.z - from.z * to.y;
				this.y = from.z * to.x - from.x * to.z;
				this.z = from.x * to.y - from.y * to.x;
				this.w = dotProduct;
			}
			return this.normalize();
		};
		_proto.slerp = function slerp(lhs, rhs, alpha) {
			var lx = lhs.x;
			var ly = lhs.y;
			var lz = lhs.z;
			var lw = lhs.w;
			var rx = rhs.x;
			var ry = rhs.y;
			var rz = rhs.z;
			var rw = rhs.w;
			var cosHalfTheta = lw * rw + lx * rx + ly * ry + lz * rz;
			if (cosHalfTheta < 0) {
				rw = -rw;
				rx = -rx;
				ry = -ry;
				rz = -rz;
				cosHalfTheta = -cosHalfTheta;
			}
			if (Math.abs(cosHalfTheta) >= 1) {
				this.w = lw;
				this.x = lx;
				this.y = ly;
				this.z = lz;
				return this;
			}
			var halfTheta = Math.acos(cosHalfTheta);
			var sinHalfTheta = Math.sqrt(1 - cosHalfTheta * cosHalfTheta);
			if (Math.abs(sinHalfTheta) < 0.001) {
				this.w = lw * 0.5 + rw * 0.5;
				this.x = lx * 0.5 + rx * 0.5;
				this.y = ly * 0.5 + ry * 0.5;
				this.z = lz * 0.5 + rz * 0.5;
				return this;
			}
			var ratioA = Math.sin((1 - alpha) * halfTheta) / sinHalfTheta;
			var ratioB = Math.sin(alpha * halfTheta) / sinHalfTheta;
			this.w = lw * ratioA + rw * ratioB;
			this.x = lx * ratioA + rx * ratioB;
			this.y = ly * ratioA + ry * ratioB;
			this.z = lz * ratioA + rz * ratioB;
			return this;
		};
		_proto.transformVector = function transformVector(vec, res) {
			if (res === void 0) {
				res = new Vec3();
			}
			var x = vec.x,
				y = vec.y,
				z = vec.z;
			var qx = this.x,
				qy = this.y,
				qz = this.z,
				qw = this.w;
			var ix = qw * x + qy * z - qz * y;
			var iy = qw * y + qz * x - qx * z;
			var iz = qw * z + qx * y - qy * x;
			var iw = -qx * x - qy * y - qz * z;
			res.x = ix * qw + iw * -qx + iy * -qz - iz * -qy;
			res.y = iy * qw + iw * -qy + iz * -qx - ix * -qz;
			res.z = iz * qw + iw * -qz + ix * -qy - iy * -qx;
			return res;
		};
		_proto.toString = function toString() {
			return "[" + this.x + ", " + this.y + ", " + this.z + ", " + this.w + "]";
		};
		return Quat;
	}();
	Quat.IDENTITY = Object.freeze(new Quat(0, 0, 0, 1));
	Quat.ZERO = Object.freeze(new Quat(0, 0, 0, 0));

	var tmpVecA$1 = new Vec3();
	var tmpVecB$1 = new Vec3();
	var tmpVecC = new Vec3();
	var tmpVecD = new Vec3();
	var tmpVecE = new Vec3();
	var BoundingBox = function () {
		function BoundingBox(center, halfExtents) {
			if (center === void 0) {
				center = new Vec3();
			}
			if (halfExtents === void 0) {
				halfExtents = new Vec3(0.5, 0.5, 0.5);
			}
			this.center = void 0;
			this.halfExtents = void 0;
			this._min = new Vec3();
			this._max = new Vec3();
			this.center = center;
			this.halfExtents = halfExtents;
		}
		var _proto = BoundingBox.prototype;
		_proto.add = function add(other) {
			var tc = this.center;
			var tcx = tc.x;
			var tcy = tc.y;
			var tcz = tc.z;
			var th = this.halfExtents;
			var thx = th.x;
			var thy = th.y;
			var thz = th.z;
			var tminx = tcx - thx;
			var tmaxx = tcx + thx;
			var tminy = tcy - thy;
			var tmaxy = tcy + thy;
			var tminz = tcz - thz;
			var tmaxz = tcz + thz;
			var oc = other.center;
			var ocx = oc.x;
			var ocy = oc.y;
			var ocz = oc.z;
			var oh = other.halfExtents;
			var ohx = oh.x;
			var ohy = oh.y;
			var ohz = oh.z;
			var ominx = ocx - ohx;
			var omaxx = ocx + ohx;
			var ominy = ocy - ohy;
			var omaxy = ocy + ohy;
			var ominz = ocz - ohz;
			var omaxz = ocz + ohz;
			if (ominx < tminx) tminx = ominx;
			if (omaxx > tmaxx) tmaxx = omaxx;
			if (ominy < tminy) tminy = ominy;
			if (omaxy > tmaxy) tmaxy = omaxy;
			if (ominz < tminz) tminz = ominz;
			if (omaxz > tmaxz) tmaxz = omaxz;
			tc.x = (tminx + tmaxx) * 0.5;
			tc.y = (tminy + tmaxy) * 0.5;
			tc.z = (tminz + tmaxz) * 0.5;
			th.x = (tmaxx - tminx) * 0.5;
			th.y = (tmaxy - tminy) * 0.5;
			th.z = (tmaxz - tminz) * 0.5;
		};
		_proto.copy = function copy(src) {
			this.center.copy(src.center);
			this.halfExtents.copy(src.halfExtents);
		};
		_proto.clone = function clone() {
			return new BoundingBox(this.center.clone(), this.halfExtents.clone());
		};
		_proto.intersects = function intersects(other) {
			var aMax = this.getMax();
			var aMin = this.getMin();
			var bMax = other.getMax();
			var bMin = other.getMin();
			return aMin.x <= bMax.x && aMax.x >= bMin.x && aMin.y <= bMax.y && aMax.y >= bMin.y && aMin.z <= bMax.z && aMax.z >= bMin.z;
		};
		_proto._intersectsRay = function _intersectsRay(ray, point) {
			var tMin = tmpVecA$1.copy(this.getMin()).sub(ray.origin);
			var tMax = tmpVecB$1.copy(this.getMax()).sub(ray.origin);
			var dir = ray.direction;
			if (dir.x === 0) {
				tMin.x = tMin.x < 0 ? -Number.MAX_VALUE : Number.MAX_VALUE;
				tMax.x = tMax.x < 0 ? -Number.MAX_VALUE : Number.MAX_VALUE;
			} else {
				tMin.x /= dir.x;
				tMax.x /= dir.x;
			}
			if (dir.y === 0) {
				tMin.y = tMin.y < 0 ? -Number.MAX_VALUE : Number.MAX_VALUE;
				tMax.y = tMax.y < 0 ? -Number.MAX_VALUE : Number.MAX_VALUE;
			} else {
				tMin.y /= dir.y;
				tMax.y /= dir.y;
			}
			if (dir.z === 0) {
				tMin.z = tMin.z < 0 ? -Number.MAX_VALUE : Number.MAX_VALUE;
				tMax.z = tMax.z < 0 ? -Number.MAX_VALUE : Number.MAX_VALUE;
			} else {
				tMin.z /= dir.z;
				tMax.z /= dir.z;
			}
			var realMin = tmpVecC.set(Math.min(tMin.x, tMax.x), Math.min(tMin.y, tMax.y), Math.min(tMin.z, tMax.z));
			var realMax = tmpVecD.set(Math.max(tMin.x, tMax.x), Math.max(tMin.y, tMax.y), Math.max(tMin.z, tMax.z));
			var minMax = Math.min(Math.min(realMax.x, realMax.y), realMax.z);
			var maxMin = Math.max(Math.max(realMin.x, realMin.y), realMin.z);
			var intersects = minMax >= maxMin && maxMin >= 0;
			if (intersects) point.copy(ray.direction).mulScalar(maxMin).add(ray.origin);
			return intersects;
		};
		_proto._fastIntersectsRay = function _fastIntersectsRay(ray) {
			var diff = tmpVecA$1;
			var cross = tmpVecB$1;
			var prod = tmpVecC;
			var absDiff = tmpVecD;
			var absDir = tmpVecE;
			var rayDir = ray.direction;
			diff.sub2(ray.origin, this.center);
			absDiff.set(Math.abs(diff.x), Math.abs(diff.y), Math.abs(diff.z));
			prod.mul2(diff, rayDir);
			if (absDiff.x > this.halfExtents.x && prod.x >= 0) return false;
			if (absDiff.y > this.halfExtents.y && prod.y >= 0) return false;
			if (absDiff.z > this.halfExtents.z && prod.z >= 0) return false;
			absDir.set(Math.abs(rayDir.x), Math.abs(rayDir.y), Math.abs(rayDir.z));
			cross.cross(rayDir, diff);
			cross.set(Math.abs(cross.x), Math.abs(cross.y), Math.abs(cross.z));
			if (cross.x > this.halfExtents.y * absDir.z + this.halfExtents.z * absDir.y) return false;
			if (cross.y > this.halfExtents.x * absDir.z + this.halfExtents.z * absDir.x) return false;
			if (cross.z > this.halfExtents.x * absDir.y + this.halfExtents.y * absDir.x) return false;
			return true;
		};
		_proto.intersectsRay = function intersectsRay(ray, point) {
			if (point) {
				return this._intersectsRay(ray, point);
			}
			return this._fastIntersectsRay(ray);
		};
		_proto.setMinMax = function setMinMax(min, max) {
			this.center.add2(max, min).mulScalar(0.5);
			this.halfExtents.sub2(max, min).mulScalar(0.5);
		};
		_proto.getMin = function getMin() {
			return this._min.copy(this.center).sub(this.halfExtents);
		};
		_proto.getMax = function getMax() {
			return this._max.copy(this.center).add(this.halfExtents);
		};
		_proto.containsPoint = function containsPoint(point) {
			var min = this.getMin();
			var max = this.getMax();
			if (point.x < min.x || point.x > max.x || point.y < min.y || point.y > max.y || point.z < min.z || point.z > max.z) {
				return false;
			}
			return true;
		};
		_proto.setFromTransformedAabb = function setFromTransformedAabb(aabb, m, ignoreScale) {
			if (ignoreScale === void 0) {
				ignoreScale = false;
			}
			var ac = aabb.center;
			var ar = aabb.halfExtents;
			var d = m.data;
			var mx0 = d[0];
			var mx1 = d[4];
			var mx2 = d[8];
			var my0 = d[1];
			var my1 = d[5];
			var my2 = d[9];
			var mz0 = d[2];
			var mz1 = d[6];
			var mz2 = d[10];
			if (ignoreScale) {
				var lengthSq = mx0 * mx0 + mx1 * mx1 + mx2 * mx2;
				if (lengthSq > 0) {
					var invLength = 1 / Math.sqrt(lengthSq);
					mx0 *= invLength;
					mx1 *= invLength;
					mx2 *= invLength;
				}
				lengthSq = my0 * my0 + my1 * my1 + my2 * my2;
				if (lengthSq > 0) {
					var _invLength = 1 / Math.sqrt(lengthSq);
					my0 *= _invLength;
					my1 *= _invLength;
					my2 *= _invLength;
				}
				lengthSq = mz0 * mz0 + mz1 * mz1 + mz2 * mz2;
				if (lengthSq > 0) {
					var _invLength2 = 1 / Math.sqrt(lengthSq);
					mz0 *= _invLength2;
					mz1 *= _invLength2;
					mz2 *= _invLength2;
				}
			}
			this.center.set(d[12] + mx0 * ac.x + mx1 * ac.y + mx2 * ac.z, d[13] + my0 * ac.x + my1 * ac.y + my2 * ac.z, d[14] + mz0 * ac.x + mz1 * ac.y + mz2 * ac.z);
			this.halfExtents.set(Math.abs(mx0) * ar.x + Math.abs(mx1) * ar.y + Math.abs(mx2) * ar.z, Math.abs(my0) * ar.x + Math.abs(my1) * ar.y + Math.abs(my2) * ar.z, Math.abs(mz0) * ar.x + Math.abs(mz1) * ar.y + Math.abs(mz2) * ar.z);
		};
		BoundingBox.computeMinMax = function computeMinMax(vertices, min, max, numVerts) {
			if (numVerts === void 0) {
				numVerts = vertices.length / 3;
			}
			if (numVerts > 0) {
				var minx = vertices[0];
				var miny = vertices[1];
				var minz = vertices[2];
				var maxx = minx;
				var maxy = miny;
				var maxz = minz;
				var n = numVerts * 3;
				for (var i = 3; i < n; i += 3) {
					var x = vertices[i];
					var y = vertices[i + 1];
					var z = vertices[i + 2];
					if (x < minx) minx = x;
					if (y < miny) miny = y;
					if (z < minz) minz = z;
					if (x > maxx) maxx = x;
					if (y > maxy) maxy = y;
					if (z > maxz) maxz = z;
				}
				min.set(minx, miny, minz);
				max.set(maxx, maxy, maxz);
			}
		};
		_proto.compute = function compute(vertices, numVerts) {
			BoundingBox.computeMinMax(vertices, tmpVecA$1, tmpVecB$1, numVerts);
			this.setMinMax(tmpVecA$1, tmpVecB$1);
		};
		_proto.intersectsBoundingSphere = function intersectsBoundingSphere(sphere) {
			var sq = this._distanceToBoundingSphereSq(sphere);
			if (sq <= sphere.radius * sphere.radius) {
				return true;
			}
			return false;
		};
		_proto._distanceToBoundingSphereSq = function _distanceToBoundingSphereSq(sphere) {
			var boxMin = this.getMin();
			var boxMax = this.getMax();
			var sq = 0;
			var axis = ['x', 'y', 'z'];
			for (var i = 0; i < 3; ++i) {
				var out = 0;
				var pn = sphere.center[axis[i]];
				var bMin = boxMin[axis[i]];
				var bMax = boxMax[axis[i]];
				var val = 0;
				if (pn < bMin) {
					val = bMin - pn;
					out += val * val;
				}
				if (pn > bMax) {
					val = pn - bMax;
					out += val * val;
				}
				sq += out;
			}
			return sq;
		};
		_proto._expand = function _expand(expandMin, expandMax) {
			tmpVecA$1.add2(this.getMin(), expandMin);
			tmpVecB$1.add2(this.getMax(), expandMax);
			this.setMinMax(tmpVecA$1, tmpVecB$1);
		};
		return BoundingBox;
	}();

	var tmpVecA = new Vec3();
	var tmpVecB = new Vec3();
	var BoundingSphere = function () {
		function BoundingSphere(center, radius) {
			if (center === void 0) {
				center = new Vec3();
			}
			if (radius === void 0) {
				radius = 0.5;
			}
			this.center = void 0;
			this.radius = void 0;
			this.center = center;
			this.radius = radius;
		}
		var _proto = BoundingSphere.prototype;
		_proto.containsPoint = function containsPoint(point) {
			var lenSq = tmpVecA.sub2(point, this.center).lengthSq();
			var r = this.radius;
			return lenSq < r * r;
		};
		_proto.intersectsRay = function intersectsRay(ray, point) {
			var m = tmpVecA.copy(ray.origin).sub(this.center);
			var b = m.dot(tmpVecB.copy(ray.direction).normalize());
			var c = m.dot(m) - this.radius * this.radius;
			if (c > 0 && b > 0) return false;
			var discr = b * b - c;
			if (discr < 0) return false;
			var t = Math.abs(-b - Math.sqrt(discr));
			if (point) point.copy(ray.direction).mulScalar(t).add(ray.origin);
			return true;
		};
		_proto.intersectsBoundingSphere = function intersectsBoundingSphere(sphere) {
			tmpVecA.sub2(sphere.center, this.center);
			var totalRadius = sphere.radius + this.radius;
			if (tmpVecA.lengthSq() <= totalRadius * totalRadius) {
				return true;
			}
			return false;
		};
		return BoundingSphere;
	}();

	var Frustum = function () {
		function Frustum() {
			this.planes = [];
			for (var i = 0; i < 6; i++) this.planes[i] = [];
		}
		var _proto = Frustum.prototype;
		_proto.setFromMat4 = function setFromMat4(matrix) {
			var vpm = matrix.data;
			var plane;
			var planes = this.planes;
			plane = planes[0];
			plane[0] = vpm[3] - vpm[0];
			plane[1] = vpm[7] - vpm[4];
			plane[2] = vpm[11] - vpm[8];
			plane[3] = vpm[15] - vpm[12];
			var t = Math.sqrt(plane[0] * plane[0] + plane[1] * plane[1] + plane[2] * plane[2]);
			plane[0] /= t;
			plane[1] /= t;
			plane[2] /= t;
			plane[3] /= t;
			plane = planes[1];
			plane[0] = vpm[3] + vpm[0];
			plane[1] = vpm[7] + vpm[4];
			plane[2] = vpm[11] + vpm[8];
			plane[3] = vpm[15] + vpm[12];
			t = Math.sqrt(plane[0] * plane[0] + plane[1] * plane[1] + plane[2] * plane[2]);
			plane[0] /= t;
			plane[1] /= t;
			plane[2] /= t;
			plane[3] /= t;
			plane = planes[2];
			plane[0] = vpm[3] + vpm[1];
			plane[1] = vpm[7] + vpm[5];
			plane[2] = vpm[11] + vpm[9];
			plane[3] = vpm[15] + vpm[13];
			t = Math.sqrt(plane[0] * plane[0] + plane[1] * plane[1] + plane[2] * plane[2]);
			plane[0] /= t;
			plane[1] /= t;
			plane[2] /= t;
			plane[3] /= t;
			plane = planes[3];
			plane[0] = vpm[3] - vpm[1];
			plane[1] = vpm[7] - vpm[5];
			plane[2] = vpm[11] - vpm[9];
			plane[3] = vpm[15] - vpm[13];
			t = Math.sqrt(plane[0] * plane[0] + plane[1] * plane[1] + plane[2] * plane[2]);
			plane[0] /= t;
			plane[1] /= t;
			plane[2] /= t;
			plane[3] /= t;
			plane = planes[4];
			plane[0] = vpm[3] - vpm[2];
			plane[1] = vpm[7] - vpm[6];
			plane[2] = vpm[11] - vpm[10];
			plane[3] = vpm[15] - vpm[14];
			t = Math.sqrt(plane[0] * plane[0] + plane[1] * plane[1] + plane[2] * plane[2]);
			plane[0] /= t;
			plane[1] /= t;
			plane[2] /= t;
			plane[3] /= t;
			plane = planes[5];
			plane[0] = vpm[3] + vpm[2];
			plane[1] = vpm[7] + vpm[6];
			plane[2] = vpm[11] + vpm[10];
			plane[3] = vpm[15] + vpm[14];
			t = Math.sqrt(plane[0] * plane[0] + plane[1] * plane[1] + plane[2] * plane[2]);
			plane[0] /= t;
			plane[1] /= t;
			plane[2] /= t;
			plane[3] /= t;
		};
		_proto.containsPoint = function containsPoint(point) {
			var p, plane;
			for (p = 0; p < 6; p++) {
				plane = this.planes[p];
				if (plane[0] * point.x + plane[1] * point.y + plane[2] * point.z + plane[3] <= 0) {
					return false;
				}
			}
			return true;
		};
		_proto.containsSphere = function containsSphere(sphere) {
			var c = 0;
			var d;
			var p;
			var sr = sphere.radius;
			var sc = sphere.center;
			var scx = sc.x;
			var scy = sc.y;
			var scz = sc.z;
			var planes = this.planes;
			var plane;
			for (p = 0; p < 6; p++) {
				plane = planes[p];
				d = plane[0] * scx + plane[1] * scy + plane[2] * scz + plane[3];
				if (d <= -sr) return 0;
				if (d > sr) c++;
			}
			return c === 6 ? 2 : 1;
		};
		return Frustum;
	}();

	var Ray = function () {
		function Ray(origin, direction) {
			this.origin = new Vec3();
			this.direction = Vec3.FORWARD.clone();
			if (origin) {
				this.origin.copy(origin);
			}
			if (direction) {
				this.direction.copy(direction);
			}
		}
		var _proto = Ray.prototype;
		_proto.set = function set(origin, direction) {
			this.origin.copy(origin);
			this.direction.copy(direction);
			return this;
		};
		_proto.copy = function copy(src) {
			return this.set(src.origin, src.direction);
		};
		_proto.clone = function clone() {
			return new this.constructor(this.origin, this.direction);
		};
		return Ray;
	}();

	var tmpRay = new Ray();
	var tmpVec3$2 = new Vec3();
	var tmpSphere = new BoundingSphere();
	var tmpMat4$1 = new Mat4();
	var OrientedBox = function () {
		function OrientedBox(worldTransform, halfExtents) {
			if (worldTransform === void 0) {
				worldTransform = new Mat4();
			}
			if (halfExtents === void 0) {
				halfExtents = new Vec3(0.5, 0.5, 0.5);
			}
			this.halfExtents = void 0;
			this._modelTransform = void 0;
			this._worldTransform = void 0;
			this._aabb = void 0;
			this.halfExtents = halfExtents;
			this._modelTransform = worldTransform.clone().invert();
			this._worldTransform = worldTransform.clone();
			this._aabb = new BoundingBox(new Vec3(), this.halfExtents);
		}
		var _proto = OrientedBox.prototype;
		_proto.intersectsRay = function intersectsRay(ray, point) {
			this._modelTransform.transformPoint(ray.origin, tmpRay.origin);
			this._modelTransform.transformVector(ray.direction, tmpRay.direction);
			if (point) {
				var result = this._aabb._intersectsRay(tmpRay, point);
				tmpMat4$1.copy(this._modelTransform).invert().transformPoint(point, point);
				return result;
			}
			return this._aabb._fastIntersectsRay(tmpRay);
		};
		_proto.containsPoint = function containsPoint(point) {
			this._modelTransform.transformPoint(point, tmpVec3$2);
			return this._aabb.containsPoint(tmpVec3$2);
		};
		_proto.intersectsBoundingSphere = function intersectsBoundingSphere(sphere) {
			this._modelTransform.transformPoint(sphere.center, tmpSphere.center);
			tmpSphere.radius = sphere.radius;
			if (this._aabb.intersectsBoundingSphere(tmpSphere)) {
				return true;
			}
			return false;
		};
		_createClass(OrientedBox, [{
			key: "worldTransform",
			get: function get() {
				return this._worldTransform;
			},
			set: function set(value) {
				this._worldTransform.copy(value);
				this._modelTransform.copy(value).invert();
			}
		}]);
		return OrientedBox;
	}();

	var Plane = function () {
		function Plane(normal, distance) {
			if (normal === void 0) {
				normal = Vec3.UP;
			}
			if (distance === void 0) {
				distance = 0;
			}
			this.normal = new Vec3();
			this.distance = void 0;
			this.normal.copy(normal);
			this.distance = distance;
		}
		var _proto = Plane.prototype;
		_proto.setFromPointNormal = function setFromPointNormal(point, normal) {
			this.normal.copy(normal);
			this.distance = -this.normal.dot(point);
			return this;
		};
		_proto.intersectsLine = function intersectsLine(start, end, point) {
			var d = this.distance;
			var d0 = this.normal.dot(start) + d;
			var d1 = this.normal.dot(end) + d;
			var t = d0 / (d0 - d1);
			var intersects = t >= 0 && t <= 1;
			if (intersects && point) point.lerp(start, end, t);
			return intersects;
		};
		_proto.intersectsRay = function intersectsRay(ray, point) {
			var denominator = this.normal.dot(ray.direction);
			if (denominator === 0) return false;
			var t = -(this.normal.dot(ray.origin) + this.distance) / denominator;
			if (t >= 0 && point) {
				point.copy(ray.direction).mulScalar(t).add(ray.origin);
			}
			return t >= 0;
		};
		_proto.copy = function copy(src) {
			this.normal.copy(src.normal);
			this.distance = src.distance;
			return this;
		};
		_proto.clone = function clone() {
			var cstr = this.constructor;
			return new cstr().copy(this);
		};
		return Plane;
	}();

	var DISTANCE_LINEAR = 'linear';
	var DISTANCE_INVERSE = 'inverse';
	var DISTANCE_EXPONENTIAL = 'exponential';

	var ADDRESS_REPEAT = 0;
	var ADDRESS_CLAMP_TO_EDGE = 1;
	var ADDRESS_MIRRORED_REPEAT = 2;
	var BLENDMODE_ZERO = 0;
	var BLENDMODE_ONE = 1;
	var BLENDMODE_SRC_COLOR = 2;
	var BLENDMODE_ONE_MINUS_SRC_COLOR = 3;
	var BLENDMODE_DST_COLOR = 4;
	var BLENDMODE_ONE_MINUS_DST_COLOR = 5;
	var BLENDMODE_SRC_ALPHA = 6;
	var BLENDMODE_SRC_ALPHA_SATURATE = 7;
	var BLENDMODE_ONE_MINUS_SRC_ALPHA = 8;
	var BLENDMODE_DST_ALPHA = 9;
	var BLENDMODE_ONE_MINUS_DST_ALPHA = 10;
	var BLENDMODE_CONSTANT = 11;
	var BLENDMODE_ONE_MINUS_CONSTANT = 12;
	var BLENDEQUATION_ADD = 0;
	var BLENDEQUATION_SUBTRACT = 1;
	var BLENDEQUATION_REVERSE_SUBTRACT = 2;
	var BLENDEQUATION_MIN = 3;
	var BLENDEQUATION_MAX = 4;
	var BUFFER_STATIC = 0;
	var BUFFER_DYNAMIC = 1;
	var BUFFER_STREAM = 2;
	var BUFFER_GPUDYNAMIC = 3;
	var CLEARFLAG_COLOR = 1;
	var CLEARFLAG_DEPTH = 2;
	var CLEARFLAG_STENCIL = 4;
	var CUBEFACE_POSX = 0;
	var CUBEFACE_NEGX = 1;
	var CUBEFACE_POSY = 2;
	var CUBEFACE_NEGY = 3;
	var CUBEFACE_POSZ = 4;
	var CUBEFACE_NEGZ = 5;
	var CULLFACE_NONE = 0;
	var CULLFACE_BACK = 1;
	var CULLFACE_FRONT = 2;
	var CULLFACE_FRONTANDBACK = 3;
	var FILTER_NEAREST = 0;
	var FILTER_LINEAR = 1;
	var FILTER_NEAREST_MIPMAP_NEAREST = 2;
	var FILTER_NEAREST_MIPMAP_LINEAR = 3;
	var FILTER_LINEAR_MIPMAP_NEAREST = 4;
	var FILTER_LINEAR_MIPMAP_LINEAR = 5;
	var FUNC_NEVER = 0;
	var FUNC_LESS = 1;
	var FUNC_EQUAL = 2;
	var FUNC_LESSEQUAL = 3;
	var FUNC_GREATER = 4;
	var FUNC_NOTEQUAL = 5;
	var FUNC_GREATEREQUAL = 6;
	var FUNC_ALWAYS = 7;
	var INDEXFORMAT_UINT8 = 0;
	var INDEXFORMAT_UINT16 = 1;
	var INDEXFORMAT_UINT32 = 2;
	var PIXELFORMAT_A8 = 0;
	var PIXELFORMAT_L8 = 1;
	var PIXELFORMAT_LA8 = 2;
	var PIXELFORMAT_RGB565 = 3;
	var PIXELFORMAT_RGBA5551 = 4;
	var PIXELFORMAT_RGBA4 = 5;
	var PIXELFORMAT_RGB8 = 6;
	var PIXELFORMAT_RGBA8 = 7;
	var PIXELFORMAT_DXT1 = 8;
	var PIXELFORMAT_DXT3 = 9;
	var PIXELFORMAT_DXT5 = 10;
	var PIXELFORMAT_RGB16F = 11;
	var PIXELFORMAT_RGBA16F = 12;
	var PIXELFORMAT_RGB32F = 13;
	var PIXELFORMAT_RGBA32F = 14;
	var PIXELFORMAT_R32F = 15;
	var PIXELFORMAT_DEPTH = 16;
	var PIXELFORMAT_DEPTHSTENCIL = 17;
	var PIXELFORMAT_111110F = 18;
	var PIXELFORMAT_SRGB = 19;
	var PIXELFORMAT_SRGBA = 20;
	var PIXELFORMAT_ETC1 = 21;
	var PIXELFORMAT_ETC2_RGB = 22;
	var PIXELFORMAT_ETC2_RGBA = 23;
	var PIXELFORMAT_PVRTC_2BPP_RGB_1 = 24;
	var PIXELFORMAT_PVRTC_2BPP_RGBA_1 = 25;
	var PIXELFORMAT_PVRTC_4BPP_RGB_1 = 26;
	var PIXELFORMAT_PVRTC_4BPP_RGBA_1 = 27;
	var PIXELFORMAT_ASTC_4x4 = 28;
	var PIXELFORMAT_ATC_RGB = 29;
	var PIXELFORMAT_ATC_RGBA = 30;
	var PIXELFORMAT_BGRA8 = 31;
	var pixelFormatInfo = new Map([[PIXELFORMAT_A8, {
		name: 'A8',
		size: 1
	}], [PIXELFORMAT_L8, {
		name: 'L8',
		size: 1
	}], [PIXELFORMAT_LA8, {
		name: 'LA8',
		size: 2
	}], [PIXELFORMAT_RGB565, {
		name: 'RGB565',
		size: 2
	}], [PIXELFORMAT_RGBA5551, {
		name: 'RGBA5551',
		size: 2
	}], [PIXELFORMAT_RGBA4, {
		name: 'RGBA4',
		size: 2
	}], [PIXELFORMAT_RGB8, {
		name: 'RGB8',
		size: 4
	}], [PIXELFORMAT_RGBA8, {
		name: 'RGBA8',
		size: 4
	}], [PIXELFORMAT_RGB16F, {
		name: 'RGB16F',
		size: 8
	}], [PIXELFORMAT_RGBA16F, {
		name: 'RGBA16F',
		size: 8
	}], [PIXELFORMAT_RGB32F, {
		name: 'RGB32F',
		size: 16
	}], [PIXELFORMAT_RGBA32F, {
		name: 'RGBA32F',
		size: 16
	}], [PIXELFORMAT_R32F, {
		name: 'R32F',
		size: 4
	}], [PIXELFORMAT_DEPTH, {
		name: 'DEPTH',
		size: 4
	}], [PIXELFORMAT_DEPTHSTENCIL, {
		name: 'DEPTHSTENCIL',
		size: 4
	}], [PIXELFORMAT_111110F, {
		name: '111110F',
		size: 4
	}], [PIXELFORMAT_SRGB, {
		name: 'SRGB',
		size: 4
	}], [PIXELFORMAT_SRGBA, {
		name: 'SRGBA',
		size: 4
	}], [PIXELFORMAT_BGRA8, {
		name: 'BGRA8',
		size: 4
	}], [PIXELFORMAT_DXT1, {
		name: 'DXT1',
		blockSize: 8
	}], [PIXELFORMAT_DXT3, {
		name: 'DXT3',
		blockSize: 16
	}], [PIXELFORMAT_DXT5, {
		name: 'DXT5',
		blockSize: 16
	}], [PIXELFORMAT_ETC1, {
		name: 'ETC1',
		blockSize: 8
	}], [PIXELFORMAT_ETC2_RGB, {
		name: 'ETC2_RGB',
		blockSize: 8
	}], [PIXELFORMAT_ETC2_RGBA, {
		name: 'ETC2_RGBA',
		blockSize: 16
	}], [PIXELFORMAT_PVRTC_2BPP_RGB_1, {
		name: 'PVRTC_2BPP_RGB_1',
		blockSize: 8
	}], [PIXELFORMAT_PVRTC_2BPP_RGBA_1, {
		name: 'PVRTC_2BPP_RGBA_1',
		blockSize: 8
	}], [PIXELFORMAT_PVRTC_4BPP_RGB_1, {
		name: 'PVRTC_4BPP_RGB_1',
		blockSize: 8
	}], [PIXELFORMAT_PVRTC_4BPP_RGBA_1, {
		name: 'PVRTC_4BPP_RGBA_1',
		blockSize: 8
	}], [PIXELFORMAT_ASTC_4x4, {
		name: 'ASTC_4x4',
		blockSize: 16
	}], [PIXELFORMAT_ATC_RGB, {
		name: 'ATC_RGB',
		blockSize: 8
	}], [PIXELFORMAT_ATC_RGBA, {
		name: 'ATC_RGBA',
		blockSize: 16
	}]]);
	var isCompressedPixelFormat = function isCompressedPixelFormat(format) {
		return pixelFormatInfo.get(format).blockSize !== undefined;
	};
	var getPixelFormatArrayType = function getPixelFormatArrayType(format) {
		switch (format) {
			case PIXELFORMAT_RGB32F:
			case PIXELFORMAT_RGBA32F:
				return Float32Array;
			case PIXELFORMAT_RGB565:
			case PIXELFORMAT_RGBA5551:
			case PIXELFORMAT_RGBA4:
			case PIXELFORMAT_RGB16F:
			case PIXELFORMAT_RGBA16F:
				return Uint16Array;
			default:
				return Uint8Array;
		}
	};
	var PRIMITIVE_POINTS = 0;
	var PRIMITIVE_LINES = 1;
	var PRIMITIVE_LINELOOP = 2;
	var PRIMITIVE_LINESTRIP = 3;
	var PRIMITIVE_TRIANGLES = 4;
	var PRIMITIVE_TRISTRIP = 5;
	var PRIMITIVE_TRIFAN = 6;
	var SEMANTIC_POSITION = "POSITION";
	var SEMANTIC_NORMAL = "NORMAL";
	var SEMANTIC_TANGENT = "TANGENT";
	var SEMANTIC_BLENDWEIGHT = "BLENDWEIGHT";
	var SEMANTIC_BLENDINDICES = "BLENDINDICES";
	var SEMANTIC_COLOR = "COLOR";
	var SEMANTIC_TEXCOORD = "TEXCOORD";
	var SEMANTIC_TEXCOORD0 = "TEXCOORD0";
	var SEMANTIC_TEXCOORD1 = "TEXCOORD1";
	var SEMANTIC_TEXCOORD2 = "TEXCOORD2";
	var SEMANTIC_TEXCOORD3 = "TEXCOORD3";
	var SEMANTIC_TEXCOORD4 = "TEXCOORD4";
	var SEMANTIC_TEXCOORD5 = "TEXCOORD5";
	var SEMANTIC_TEXCOORD6 = "TEXCOORD6";
	var SEMANTIC_TEXCOORD7 = "TEXCOORD7";
	var SEMANTIC_ATTR = "ATTR";
	var SEMANTIC_ATTR0 = "ATTR0";
	var SEMANTIC_ATTR1 = "ATTR1";
	var SEMANTIC_ATTR2 = "ATTR2";
	var SEMANTIC_ATTR3 = "ATTR3";
	var SEMANTIC_ATTR4 = "ATTR4";
	var SEMANTIC_ATTR5 = "ATTR5";
	var SEMANTIC_ATTR6 = "ATTR6";
	var SEMANTIC_ATTR7 = "ATTR7";
	var SEMANTIC_ATTR8 = "ATTR8";
	var SEMANTIC_ATTR9 = "ATTR9";
	var SEMANTIC_ATTR10 = "ATTR10";
	var SEMANTIC_ATTR11 = "ATTR11";
	var SEMANTIC_ATTR12 = "ATTR12";
	var SEMANTIC_ATTR13 = "ATTR13";
	var SEMANTIC_ATTR14 = "ATTR14";
	var SEMANTIC_ATTR15 = "ATTR15";
	var SHADERTAG_MATERIAL = 1;
	var STENCILOP_KEEP = 0;
	var STENCILOP_ZERO = 1;
	var STENCILOP_REPLACE = 2;
	var STENCILOP_INCREMENT = 3;
	var STENCILOP_INCREMENTWRAP = 4;
	var STENCILOP_DECREMENT = 5;
	var STENCILOP_DECREMENTWRAP = 6;
	var STENCILOP_INVERT = 7;
	var TEXTURELOCK_READ = 1;
	var TEXTURELOCK_WRITE = 2;
	var TEXTURETYPE_DEFAULT = 'default';
	var TEXTURETYPE_RGBM = 'rgbm';
	var TEXTURETYPE_RGBE = 'rgbe';
	var TEXTURETYPE_RGBP = 'rgbp';
	var TEXTURETYPE_SWIZZLEGGGR = 'swizzleGGGR';
	var TEXHINT_NONE = 0;
	var TEXHINT_SHADOWMAP = 1;
	var TEXHINT_ASSET = 2;
	var TEXHINT_LIGHTMAP = 3;
	var TEXTUREDIMENSION_1D = '1d';
	var TEXTUREDIMENSION_2D = '2d';
	var TEXTUREDIMENSION_2D_ARRAY = '2d-array';
	var TEXTUREDIMENSION_CUBE = 'cube';
	var TEXTUREDIMENSION_CUBE_ARRAY = 'cube-array';
	var TEXTUREDIMENSION_3D = '3d';
	var SAMPLETYPE_FLOAT = 0;
	var SAMPLETYPE_UNFILTERABLE_FLOAT = 1;
	var SAMPLETYPE_DEPTH = 2;
	var TEXTUREPROJECTION_NONE = "none";
	var TEXTUREPROJECTION_CUBE = "cube";
	var TEXTUREPROJECTION_EQUIRECT = "equirect";
	var TEXTUREPROJECTION_OCTAHEDRAL = "octahedral";
	var SHADERLANGUAGE_GLSL = 'glsl';
	var SHADERLANGUAGE_WGSL = 'wgsl';
	var TYPE_INT8 = 0;
	var TYPE_UINT8 = 1;
	var TYPE_INT16 = 2;
	var TYPE_UINT16 = 3;
	var TYPE_INT32 = 4;
	var TYPE_UINT32 = 5;
	var TYPE_FLOAT32 = 6;
	var UNIFORMTYPE_BOOL = 0;
	var UNIFORMTYPE_INT = 1;
	var UNIFORMTYPE_FLOAT = 2;
	var UNIFORMTYPE_VEC2 = 3;
	var UNIFORMTYPE_VEC3 = 4;
	var UNIFORMTYPE_VEC4 = 5;
	var UNIFORMTYPE_IVEC2 = 6;
	var UNIFORMTYPE_IVEC3 = 7;
	var UNIFORMTYPE_IVEC4 = 8;
	var UNIFORMTYPE_BVEC2 = 9;
	var UNIFORMTYPE_BVEC3 = 10;
	var UNIFORMTYPE_BVEC4 = 11;
	var UNIFORMTYPE_MAT2 = 12;
	var UNIFORMTYPE_MAT3 = 13;
	var UNIFORMTYPE_MAT4 = 14;
	var UNIFORMTYPE_TEXTURE2D = 15;
	var UNIFORMTYPE_TEXTURECUBE = 16;
	var UNIFORMTYPE_FLOATARRAY = 17;
	var UNIFORMTYPE_TEXTURE2D_SHADOW = 18;
	var UNIFORMTYPE_TEXTURECUBE_SHADOW = 19;
	var UNIFORMTYPE_TEXTURE3D = 20;
	var UNIFORMTYPE_VEC2ARRAY = 21;
	var UNIFORMTYPE_VEC3ARRAY = 22;
	var UNIFORMTYPE_VEC4ARRAY = 23;
	var UNIFORMTYPE_MAT4ARRAY = 24;
	var uniformTypeToName = ['bool', 'int', 'float', 'vec2', 'vec3', 'vec4', 'ivec2', 'ivec3', 'ivec4', 'bec2', 'bec3', 'bec4', 'mat2', 'mat3', 'mat4', 'sampler2D', 'samplerCube', '', 'sampler2DShadow', 'samplerCubeShadow', 'sampler3D', '', '', ''];
	var DEVICETYPE_WEBGL1 = 'webgl1';
	var DEVICETYPE_WEBGL2 = 'webgl2';
	var DEVICETYPE_WEBGPU = 'webgpu';
	var SHADERSTAGE_VERTEX = 1;
	var SHADERSTAGE_FRAGMENT = 2;
	var SHADERSTAGE_COMPUTE = 4;
	var BINDGROUP_MESH = 0;
	var BINDGROUP_VIEW = 1;
	var bindGroupNames = ['mesh', 'view'];
	var UNIFORM_BUFFER_DEFAULT_SLOT_NAME = 'default';
	var typedArrayTypes = [Int8Array, Uint8Array, Int16Array, Uint16Array, Int32Array, Uint32Array, Float32Array];
	var typedArrayTypesByteSize = [1, 1, 2, 2, 4, 4, 4];
	var vertexTypesNames = ['INT8', 'UINT8', 'INT16', 'UINT16', 'INT32', 'UINT32', 'FLOAT32'];
	var typedArrayToType = {
		"Int8Array": TYPE_INT8,
		"Uint8Array": TYPE_UINT8,
		"Int16Array": TYPE_INT16,
		"Uint16Array": TYPE_UINT16,
		"Int32Array": TYPE_INT32,
		"Uint32Array": TYPE_UINT32,
		"Float32Array": TYPE_FLOAT32
	};
	var typedArrayIndexFormats = [Uint8Array, Uint16Array, Uint32Array];
	var typedArrayIndexFormatsByteSize = [1, 2, 4];
	var semanticToLocation = {};
	semanticToLocation[SEMANTIC_POSITION] = 0;
	semanticToLocation[SEMANTIC_NORMAL] = 1;
	semanticToLocation[SEMANTIC_BLENDWEIGHT] = 2;
	semanticToLocation[SEMANTIC_BLENDINDICES] = 3;
	semanticToLocation[SEMANTIC_COLOR] = 4;
	semanticToLocation[SEMANTIC_TEXCOORD0] = 5;
	semanticToLocation[SEMANTIC_TEXCOORD1] = 6;
	semanticToLocation[SEMANTIC_TEXCOORD2] = 7;
	semanticToLocation[SEMANTIC_TEXCOORD3] = 8;
	semanticToLocation[SEMANTIC_TEXCOORD4] = 9;
	semanticToLocation[SEMANTIC_TEXCOORD5] = 10;
	semanticToLocation[SEMANTIC_TEXCOORD6] = 11;
	semanticToLocation[SEMANTIC_TEXCOORD7] = 12;
	semanticToLocation[SEMANTIC_TANGENT] = 13;
	semanticToLocation[SEMANTIC_ATTR0] = 0;
	semanticToLocation[SEMANTIC_ATTR1] = 1;
	semanticToLocation[SEMANTIC_ATTR2] = 2;
	semanticToLocation[SEMANTIC_ATTR3] = 3;
	semanticToLocation[SEMANTIC_ATTR4] = 4;
	semanticToLocation[SEMANTIC_ATTR5] = 5;
	semanticToLocation[SEMANTIC_ATTR6] = 6;
	semanticToLocation[SEMANTIC_ATTR7] = 7;
	semanticToLocation[SEMANTIC_ATTR8] = 8;
	semanticToLocation[SEMANTIC_ATTR9] = 9;
	semanticToLocation[SEMANTIC_ATTR10] = 10;
	semanticToLocation[SEMANTIC_ATTR11] = 11;
	semanticToLocation[SEMANTIC_ATTR12] = 12;
	semanticToLocation[SEMANTIC_ATTR13] = 13;
	semanticToLocation[SEMANTIC_ATTR14] = 14;
	semanticToLocation[SEMANTIC_ATTR15] = 15;
	var CHUNKAPI_1_51 = '1.51';
	var CHUNKAPI_1_55 = '1.55';
	var CHUNKAPI_1_56 = '1.56';
	var CHUNKAPI_1_57 = '1.57';
	var CHUNKAPI_1_58 = '1.58';
	var CHUNKAPI_1_60 = '1.60';
	var CHUNKAPI_1_62 = '1.62';
	var CHUNKAPI_1_65 = '1.65';

	var BitPacking = {
		set: function set(storage, value, shift, mask) {
			if (mask === void 0) {
				mask = 1;
			}
			var data = storage & ~(mask << shift);
			return data | value << shift;
		},
		get: function get(storage, shift, mask) {
			if (mask === void 0) {
				mask = 1;
			}
			return storage >> shift & mask;
		},
		all: function all(storage, shift, mask) {
			if (mask === void 0) {
				mask = 1;
			}
			var shifted = mask << shift;
			return (storage & shifted) === shifted;
		},
		any: function any(storage, shift, mask) {
			if (mask === void 0) {
				mask = 1;
			}
			return (storage & mask << shift) !== 0;
		}
	};

	var opMask = 7;
	var factorMask = 15;
	var colorOpShift = 0;
	var colorSrcFactorShift = 3;
	var colorDstFactorShift = 7;
	var alphaOpShift = 11;
	var alphaSrcFactorShift = 14;
	var alphaDstFactorShift = 18;
	var redWriteShift = 22;
	var greenWriteShift = 23;
	var blueWriteShift = 24;
	var alphaWriteShift = 25;
	var blendShift = 26;
	var allWriteMasks = 15;
	var allWriteShift = redWriteShift;
	var BlendState = function () {
		function BlendState(blend, colorOp, colorSrcFactor, colorDstFactor, alphaOp, alphaSrcFactor, alphaDstFactor, redWrite, greenWrite, blueWrite, alphaWrite) {
			if (blend === void 0) {
				blend = false;
			}
			if (colorOp === void 0) {
				colorOp = BLENDEQUATION_ADD;
			}
			if (colorSrcFactor === void 0) {
				colorSrcFactor = BLENDMODE_ONE;
			}
			if (colorDstFactor === void 0) {
				colorDstFactor = BLENDMODE_ZERO;
			}
			if (redWrite === void 0) {
				redWrite = true;
			}
			if (greenWrite === void 0) {
				greenWrite = true;
			}
			if (blueWrite === void 0) {
				blueWrite = true;
			}
			if (alphaWrite === void 0) {
				alphaWrite = true;
			}
			this.target0 = 0;
			this.setColorBlend(colorOp, colorSrcFactor, colorDstFactor);
			this.setAlphaBlend(alphaOp != null ? alphaOp : colorOp, alphaSrcFactor != null ? alphaSrcFactor : colorSrcFactor, alphaDstFactor != null ? alphaDstFactor : colorDstFactor);
			this.setColorWrite(redWrite, greenWrite, blueWrite, alphaWrite);
			this.blend = blend;
		}
		var _proto = BlendState.prototype;
		_proto.setColorBlend = function setColorBlend(op, srcFactor, dstFactor) {
			this.target0 = BitPacking.set(this.target0, op, colorOpShift, opMask);
			this.target0 = BitPacking.set(this.target0, srcFactor, colorSrcFactorShift, factorMask);
			this.target0 = BitPacking.set(this.target0, dstFactor, colorDstFactorShift, factorMask);
		};
		_proto.setAlphaBlend = function setAlphaBlend(op, srcFactor, dstFactor) {
			this.target0 = BitPacking.set(this.target0, op, alphaOpShift, opMask);
			this.target0 = BitPacking.set(this.target0, srcFactor, alphaSrcFactorShift, factorMask);
			this.target0 = BitPacking.set(this.target0, dstFactor, alphaDstFactorShift, factorMask);
		};
		_proto.setColorWrite = function setColorWrite(redWrite, greenWrite, blueWrite, alphaWrite) {
			this.redWrite = redWrite;
			this.greenWrite = greenWrite;
			this.blueWrite = blueWrite;
			this.alphaWrite = alphaWrite;
		};
		_proto.copy = function copy(rhs) {
			this.target0 = rhs.target0;
			return this;
		};
		_proto.clone = function clone() {
			var clone = new this.constructor();
			return clone.copy(this);
		};
		_proto.equals = function equals(rhs) {
			return this.target0 === rhs.target0;
		};
		_createClass(BlendState, [{
			key: "blend",
			get: function get() {
				return BitPacking.all(this.target0, blendShift);
			},
			set: function set(value) {
				this.target0 = BitPacking.set(this.target0, value ? 1 : 0, blendShift);
			}
		}, {
			key: "colorOp",
			get: function get() {
				return BitPacking.get(this.target0, colorOpShift, opMask);
			}
		}, {
			key: "colorSrcFactor",
			get: function get() {
				return BitPacking.get(this.target0, colorSrcFactorShift, factorMask);
			}
		}, {
			key: "colorDstFactor",
			get: function get() {
				return BitPacking.get(this.target0, colorDstFactorShift, factorMask);
			}
		}, {
			key: "alphaOp",
			get: function get() {
				return BitPacking.get(this.target0, alphaOpShift, opMask);
			}
		}, {
			key: "alphaSrcFactor",
			get: function get() {
				return BitPacking.get(this.target0, alphaSrcFactorShift, factorMask);
			}
		}, {
			key: "alphaDstFactor",
			get: function get() {
				return BitPacking.get(this.target0, alphaDstFactorShift, factorMask);
			}
		}, {
			key: "redWrite",
			get: function get() {
				return BitPacking.all(this.target0, redWriteShift);
			},
			set: function set(value) {
				this.target0 = BitPacking.set(this.target0, value ? 1 : 0, redWriteShift);
			}
		}, {
			key: "greenWrite",
			get: function get() {
				return BitPacking.all(this.target0, greenWriteShift);
			},
			set: function set(value) {
				this.target0 = BitPacking.set(this.target0, value ? 1 : 0, greenWriteShift);
			}
		}, {
			key: "blueWrite",
			get: function get() {
				return BitPacking.all(this.target0, blueWriteShift);
			},
			set: function set(value) {
				this.target0 = BitPacking.set(this.target0, value ? 1 : 0, blueWriteShift);
			}
		}, {
			key: "alphaWrite",
			get: function get() {
				return BitPacking.all(this.target0, alphaWriteShift);
			},
			set: function set(value) {
				this.target0 = BitPacking.set(this.target0, value ? 1 : 0, alphaWriteShift);
			}
		}, {
			key: "allWrite",
			get: function get() {
				return BitPacking.get(this.target0, allWriteShift, allWriteMasks);
			}
		}, {
			key: "key",
			get: function get() {
				return this.target0;
			}
		}]);
		return BlendState;
	}();
	BlendState.NOBLEND = Object.freeze(new BlendState());
	BlendState.NOWRITE = Object.freeze(new BlendState(undefined, undefined, undefined, undefined, undefined, undefined, undefined, false, false, false, false));
	BlendState.ALPHABLEND = Object.freeze(new BlendState(true, BLENDEQUATION_ADD, BLENDMODE_SRC_ALPHA, BLENDMODE_ONE_MINUS_SRC_ALPHA));

	var funcMask = 7;
	var funcShift = 0;
	var writeShift = 3;
	var DepthState = function () {
		function DepthState(func, write) {
			if (func === void 0) {
				func = FUNC_LESSEQUAL;
			}
			if (write === void 0) {
				write = true;
			}
			this.data = 0;
			this.func = func;
			this.write = write;
		}
		var _proto = DepthState.prototype;
		_proto.copy = function copy(rhs) {
			this.data = rhs.data;
			return this;
		};
		_proto.clone = function clone() {
			var clone = new this.constructor();
			return clone.copy(this);
		};
		_proto.equals = function equals(rhs) {
			return this.data === rhs.data;
		};
		_createClass(DepthState, [{
			key: "test",
			get: function get() {
				return this.func !== FUNC_ALWAYS;
			},
			set: function set(value) {
				this.func = value ? FUNC_LESSEQUAL : FUNC_ALWAYS;
			}
		}, {
			key: "write",
			get: function get() {
				return BitPacking.all(this.data, writeShift);
			},
			set: function set(value) {
				this.data = BitPacking.set(this.data, value ? 1 : 0, writeShift);
			}
		}, {
			key: "func",
			get: function get() {
				return BitPacking.get(this.data, funcShift, funcMask);
			},
			set: function set(value) {
				this.data = BitPacking.set(this.data, value, funcShift, funcMask);
			}
		}, {
			key: "key",
			get: function get() {
				return this.data;
			}
		}]);
		return DepthState;
	}();
	DepthState.DEFAULT = Object.freeze(new DepthState());
	DepthState.NODEPTH = Object.freeze(new DepthState(FUNC_ALWAYS, false));
	DepthState.WRITEDEPTH = Object.freeze(new DepthState(FUNC_ALWAYS, true));

	var Version = function () {
		function Version() {
			this.globalId = 0;
			this.revision = 0;
		}
		var _proto = Version.prototype;
		_proto.equals = function equals(other) {
			return this.globalId === other.globalId && this.revision === other.revision;
		};
		_proto.copy = function copy(other) {
			this.globalId = other.globalId;
			this.revision = other.revision;
		};
		_proto.reset = function reset() {
			this.globalId = 0;
			this.revision = 0;
		};
		return Version;
	}();

	var idCounter = 0;
	var VersionedObject = function () {
		function VersionedObject() {
			idCounter++;
			this.version = new Version();
			this.version.globalId = idCounter;
		}
		var _proto = VersionedObject.prototype;
		_proto.increment = function increment() {
			this.version.revision++;
		};
		return VersionedObject;
	}();

	var ScopeId = function () {
		function ScopeId(name) {
			this.name = name;
			this.value = null;
			this.versionObject = new VersionedObject();
		}
		var _proto = ScopeId.prototype;
		_proto.toJSON = function toJSON(key) {
			return undefined;
		};
		_proto.setValue = function setValue(value) {
			this.value = value;
			this.versionObject.increment();
		};
		_proto.getValue = function getValue() {
			return this.value;
		};
		return ScopeId;
	}();

	var ScopeSpace = function () {
		function ScopeSpace(name) {
			this.name = name;
			this.variables = new Map();
		}
		var _proto = ScopeSpace.prototype;
		_proto.resolve = function resolve(name) {
			if (!this.variables.has(name)) {
				this.variables.set(name, new ScopeId(name));
			}
			return this.variables.get(name);
		};
		_proto.removeValue = function removeValue(value) {
			for (var uniformName in this.variables) {
				var uniform = this.variables[uniformName];
				if (uniform.value === value) {
					uniform.value = null;
				}
			}
		};
		return ScopeSpace;
	}();

	var id$9 = 0;
	var VertexBuffer = function () {
		function VertexBuffer(graphicsDevice, format, numVertices, usage, initialData) {
			if (usage === void 0) {
				usage = BUFFER_STATIC;
			}
			this.device = graphicsDevice;
			this.format = format;
			this.numVertices = numVertices;
			this.usage = usage;
			this.id = id$9++;
			this.impl = graphicsDevice.createVertexBufferImpl(this, format);
			this.numBytes = format.verticesByteSize ? format.verticesByteSize : format.size * numVertices;
			this.adjustVramSizeTracking(graphicsDevice._vram, this.numBytes);
			if (initialData) {
				this.setData(initialData);
			} else {
				this.storage = new ArrayBuffer(this.numBytes);
			}
			this.device.buffers.push(this);
		}
		var _proto = VertexBuffer.prototype;
		_proto.destroy = function destroy() {
			var device = this.device;
			var idx = device.buffers.indexOf(this);
			if (idx !== -1) {
				device.buffers.splice(idx, 1);
			}
			if (this.impl.initialized) {
				this.impl.destroy(device);
				this.adjustVramSizeTracking(device._vram, -this.storage.byteLength);
			}
		};
		_proto.adjustVramSizeTracking = function adjustVramSizeTracking(vram, size) {
			vram.vb += size;
		};
		_proto.loseContext = function loseContext() {
			this.impl.loseContext();
		};
		_proto.getFormat = function getFormat() {
			return this.format;
		};
		_proto.getUsage = function getUsage() {
			return this.usage;
		};
		_proto.getNumVertices = function getNumVertices() {
			return this.numVertices;
		};
		_proto.lock = function lock() {
			return this.storage;
		};
		_proto.unlock = function unlock() {
			this.impl.unlock(this);
		};
		_proto.setData = function setData(data) {
			if (data.byteLength !== this.numBytes) {
				return false;
			}
			this.storage = data;
			this.unlock();
			return true;
		};
		return VertexBuffer;
	}();

	function hashCode(str) {
		var hash = 0;
		for (var i = 0, len = str.length; i < len; i++) {
			hash = (hash << 5) - hash + str.charCodeAt(i);
			hash |= 0;
		}
		return hash;
	}
	function hash32Fnv1a(array) {
		var prime = 16777619;
		var hash = 2166136261;
		for (var i = 0; i < array.length; i++) {
			hash ^= array[i];
			hash *= prime;
		}
		return hash >>> 0;
	}

	var StringIds = function () {
		function StringIds() {
			this.map = new Map();
			this.id = 0;
		}
		var _proto = StringIds.prototype;
		_proto.get = function get(name) {
			var value = this.map.get(name);
			if (value === undefined) {
				value = this.id++;
				this.map.set(name, value);
			}
			return value;
		};
		return StringIds;
	}();

	var stringIds$3 = new StringIds();
	var VertexFormat = function () {
		function VertexFormat(graphicsDevice, description, vertexCount) {
			this.device = graphicsDevice;
			this._elements = [];
			this.hasUv0 = false;
			this.hasUv1 = false;
			this.hasColor = false;
			this.hasTangents = false;
			this.verticesByteSize = 0;
			this.vertexCount = vertexCount;
			this.interleaved = vertexCount === undefined;
			this.instancing = false;
			this.size = description.reduce(function (total, desc) {
				return total + Math.ceil(desc.components * typedArrayTypesByteSize[desc.type] / 4) * 4;
			}, 0);
			var offset = 0,
				elementSize;
			for (var i = 0, len = description.length; i < len; i++) {
				var _elementDesc$normaliz;
				var elementDesc = description[i];
				elementSize = elementDesc.components * typedArrayTypesByteSize[elementDesc.type];
				if (vertexCount) {
					offset = math.roundUp(offset, elementSize);
				}
				var element = {
					name: elementDesc.semantic,
					offset: vertexCount ? offset : elementDesc.hasOwnProperty('offset') ? elementDesc.offset : offset,
					stride: vertexCount ? elementSize : elementDesc.hasOwnProperty('stride') ? elementDesc.stride : this.size,
					dataType: elementDesc.type,
					numComponents: elementDesc.components,
					normalize: (_elementDesc$normaliz = elementDesc.normalize) != null ? _elementDesc$normaliz : false,
					size: elementSize
				};
				this._elements.push(element);
				if (vertexCount) {
					offset += elementSize * vertexCount;
				} else {
					offset += Math.ceil(elementSize / 4) * 4;
				}
				if (elementDesc.semantic === SEMANTIC_TEXCOORD0) {
					this.hasUv0 = true;
				} else if (elementDesc.semantic === SEMANTIC_TEXCOORD1) {
					this.hasUv1 = true;
				} else if (elementDesc.semantic === SEMANTIC_COLOR) {
					this.hasColor = true;
				} else if (elementDesc.semantic === SEMANTIC_TANGENT) {
					this.hasTangents = true;
				}
			}
			if (vertexCount) {
				this.verticesByteSize = offset;
			}
			this._evaluateHash();
		}
		VertexFormat.getDefaultInstancingFormat = function getDefaultInstancingFormat(graphicsDevice) {
			if (!VertexFormat._defaultInstancingFormat) {
				VertexFormat._defaultInstancingFormat = new VertexFormat(graphicsDevice, [{
					semantic: SEMANTIC_ATTR12,
					components: 4,
					type: TYPE_FLOAT32
				}, {
					semantic: SEMANTIC_ATTR13,
					components: 4,
					type: TYPE_FLOAT32
				}, {
					semantic: SEMANTIC_ATTR14,
					components: 4,
					type: TYPE_FLOAT32
				}, {
					semantic: SEMANTIC_ATTR15,
					components: 4,
					type: TYPE_FLOAT32
				}]);
			}
			return VertexFormat._defaultInstancingFormat;
		};
		var _proto = VertexFormat.prototype;
		_proto.update = function update() {
			this._evaluateHash();
		};
		_proto._evaluateHash = function _evaluateHash() {
			var stringElementBatch;
			var stringElementsBatch = [];
			var stringElementRender;
			var stringElementsRender = [];
			var len = this._elements.length;
			for (var i = 0; i < len; i++) {
				var element = this._elements[i];
				stringElementBatch = element.name;
				stringElementBatch += element.dataType;
				stringElementBatch += element.numComponents;
				stringElementBatch += element.normalize;
				stringElementsBatch.push(stringElementBatch);
				stringElementRender = stringElementBatch;
				stringElementRender += element.offset;
				stringElementRender += element.stride;
				stringElementRender += element.size;
				stringElementsRender.push(stringElementRender);
			}
			stringElementsBatch.sort();
			this.batchingHash = hashCode(stringElementsBatch.join());
			this.renderingHashString = stringElementsRender.join('_');
			this.renderingHash = stringIds$3.get(this.renderingHashString);
		};
		_createClass(VertexFormat, [{
			key: "elements",
			get: function get() {
				return this._elements;
			}
		}]);
		return VertexFormat;
	}();
	VertexFormat._defaultInstancingFormat = null;

	var stringIds$2 = new StringIds();
	var StencilParameters = function () {
		function StencilParameters(options) {
			var _options$func, _options$ref, _options$readMask, _options$writeMask, _options$fail, _options$zfail, _options$zpass;
			if (options === void 0) {
				options = {};
			}
			this._func = void 0;
			this._ref = void 0;
			this._fail = void 0;
			this._zfail = void 0;
			this._zpass = void 0;
			this._readMask = void 0;
			this._writeMask = void 0;
			this._dirty = true;
			this._key = void 0;
			this._func = (_options$func = options.func) != null ? _options$func : FUNC_ALWAYS;
			this._ref = (_options$ref = options.ref) != null ? _options$ref : 0;
			this._readMask = (_options$readMask = options.readMask) != null ? _options$readMask : 0xFF;
			this._writeMask = (_options$writeMask = options.writeMask) != null ? _options$writeMask : 0xFF;
			this._fail = (_options$fail = options.fail) != null ? _options$fail : STENCILOP_KEEP;
			this._zfail = (_options$zfail = options.zfail) != null ? _options$zfail : STENCILOP_KEEP;
			this._zpass = (_options$zpass = options.zpass) != null ? _options$zpass : STENCILOP_KEEP;
			this._evalKey();
		}
		var _proto = StencilParameters.prototype;
		_proto._evalKey = function _evalKey() {
			var _func = this._func,
				_ref = this._ref,
				_fail = this._fail,
				_zfail = this._zfail,
				_zpass = this._zpass,
				_readMask = this._readMask,
				_writeMask = this._writeMask;
			var key = _func + "," + _ref + "," + _fail + "," + _zfail + "," + _zpass + "," + _readMask + "," + _writeMask;
			this._key = stringIds$2.get(key);
			this._dirty = false;
		};
		_proto.copy = function copy(rhs) {
			this._func = rhs._func;
			this._ref = rhs._ref;
			this._readMask = rhs._readMask;
			this._writeMask = rhs._writeMask;
			this._fail = rhs._fail;
			this._zfail = rhs._zfail;
			this._zpass = rhs._zpass;
			this._dirty = rhs._dirty;
			this._key = rhs._key;
			return this;
		};
		_proto.clone = function clone() {
			var clone = new this.constructor();
			return clone.copy(this);
		};
		_createClass(StencilParameters, [{
			key: "func",
			get: function get() {
				return this._func;
			},
			set: function set(value) {
				this._func = value;
				this._dirty = true;
			}
		}, {
			key: "ref",
			get: function get() {
				return this._ref;
			},
			set: function set(value) {
				this._ref = value;
				this._dirty = true;
			}
		}, {
			key: "fail",
			get: function get() {
				return this._fail;
			},
			set: function set(value) {
				this._fail = value;
				this._dirty = true;
			}
		}, {
			key: "zfail",
			get: function get() {
				return this._zfail;
			},
			set: function set(value) {
				this._zfail = value;
				this._dirty = true;
			}
		}, {
			key: "zpass",
			get: function get() {
				return this._zpass;
			},
			set: function set(value) {
				this._zpass = value;
				this._dirty = true;
			}
		}, {
			key: "readMask",
			get: function get() {
				return this._readMask;
			},
			set: function set(value) {
				this._readMask = value;
				this._dirty = true;
			}
		}, {
			key: "writeMask",
			get: function get() {
				return this._writeMask;
			},
			set: function set(value) {
				this._writeMask = value;
				this._dirty = true;
			}
		}, {
			key: "key",
			get: function get() {
				if (this._dirty) {
					this._evalKey();
				}
				return this._key;
			}
		}]);
		return StencilParameters;
	}();
	StencilParameters.DEFAULT = Object.freeze(new StencilParameters());

	var GraphicsDevice = function (_EventHandler) {
		_inheritsLoose(GraphicsDevice, _EventHandler);
		function GraphicsDevice(canvas, options) {
			var _this$initOptions, _this$initOptions$dep, _this$initOptions2, _this$initOptions2$st, _this$initOptions3, _this$initOptions3$an, _this$initOptions4, _this$initOptions4$po;
			var _this;
			_this = _EventHandler.call(this) || this;
			_this.canvas = void 0;
			_this.isWebGPU = false;
			_this.scope = void 0;
			_this.boneLimit = void 0;
			_this.maxAnisotropy = void 0;
			_this.maxCubeMapSize = void 0;
			_this.maxTextureSize = void 0;
			_this.maxVolumeSize = void 0;
			_this.maxColorAttachments = 1;
			_this.precision = void 0;
			_this.samples = void 0;
			_this.supportsStencil = void 0;
			_this.supportsMrt = false;
			_this.supportsVolumeTextures = false;
			_this.renderTarget = null;
			_this.renderVersion = 0;
			_this.renderPassIndex = void 0;
			_this.insideRenderPass = false;
			_this.supportsInstancing = void 0;
			_this.supportsUniformBuffers = false;
			_this.textureFloatRenderable = void 0;
			_this.textureHalfFloatRenderable = void 0;
			_this.quadVertexBuffer = void 0;
			_this.blendState = new BlendState();
			_this.depthState = new DepthState();
			_this.stencilEnabled = false;
			_this.stencilFront = new StencilParameters();
			_this.stencilBack = new StencilParameters();
			_this.dynamicBuffers = void 0;
			_this.gpuProfiler = void 0;
			_this.defaultClearOptions = {
				color: [0, 0, 0, 1],
				depth: 1,
				stencil: 0,
				flags: CLEARFLAG_COLOR | CLEARFLAG_DEPTH
			};
			_this.canvas = canvas;
			_this.initOptions = _extends({}, options);
			(_this$initOptions$dep = (_this$initOptions = _this.initOptions).depth) != null ? _this$initOptions$dep : _this$initOptions.depth = true;
			(_this$initOptions2$st = (_this$initOptions2 = _this.initOptions).stencil) != null ? _this$initOptions2$st : _this$initOptions2.stencil = true;
			(_this$initOptions3$an = (_this$initOptions3 = _this.initOptions).antialias) != null ? _this$initOptions3$an : _this$initOptions3.antialias = true;
			(_this$initOptions4$po = (_this$initOptions4 = _this.initOptions).powerPreference) != null ? _this$initOptions4$po : _this$initOptions4.powerPreference = 'high-performance';
			_this._width = 0;
			_this._height = 0;
			_this._maxPixelRatio = platform.browser ? Math.min(1, window.devicePixelRatio) : 1;
			_this.shaders = [];
			_this.buffers = [];
			_this.textures = [];
			_this.targets = [];
			_this._vram = {
				tex: 0,
				vb: 0,
				ib: 0,
				ub: 0
			};
			_this._shaderStats = {
				vsCompiled: 0,
				fsCompiled: 0,
				linked: 0,
				materialShaders: 0,
				compileTime: 0
			};
			_this.initializeContextCaches();
			_this._drawCallsPerFrame = 0;
			_this._shaderSwitchesPerFrame = 0;
			_this._primsPerFrame = [];
			for (var i = PRIMITIVE_POINTS; i <= PRIMITIVE_TRIFAN; i++) {
				_this._primsPerFrame[i] = 0;
			}
			_this._renderTargetCreationTime = 0;
			_this.scope = new ScopeSpace("Device");
			_this.textureBias = _this.scope.resolve("textureBias");
			_this.textureBias.setValue(0.0);
			return _this;
		}
		var _proto = GraphicsDevice.prototype;
		_proto.postInit = function postInit() {
			var vertexFormat = new VertexFormat(this, [{
				semantic: SEMANTIC_POSITION,
				components: 2,
				type: TYPE_FLOAT32
			}]);
			var positions = new Float32Array([-1, -1, 1, -1, -1, 1, 1, 1]);
			this.quadVertexBuffer = new VertexBuffer(this, vertexFormat, 4, BUFFER_STATIC, positions);
		};
		_proto.destroy = function destroy() {
			var _this$quadVertexBuffe, _this$dynamicBuffers, _this$gpuProfiler;
			this.fire('destroy');
			(_this$quadVertexBuffe = this.quadVertexBuffer) == null ? void 0 : _this$quadVertexBuffe.destroy();
			this.quadVertexBuffer = null;
			(_this$dynamicBuffers = this.dynamicBuffers) == null ? void 0 : _this$dynamicBuffers.destroy();
			this.dynamicBuffers = null;
			(_this$gpuProfiler = this.gpuProfiler) == null ? void 0 : _this$gpuProfiler.destroy();
			this.gpuProfiler = null;
		};
		_proto.onDestroyShader = function onDestroyShader(shader) {
			this.fire('destroy:shader', shader);
			var idx = this.shaders.indexOf(shader);
			if (idx !== -1) {
				this.shaders.splice(idx, 1);
			}
		};
		_proto.postDestroy = function postDestroy() {
			this.scope = null;
			this.canvas = null;
		};
		_proto.toJSON = function toJSON(key) {
			return undefined;
		};
		_proto.initializeContextCaches = function initializeContextCaches() {
			this.indexBuffer = null;
			this.vertexBuffers = [];
			this.shader = null;
			this.renderTarget = null;
		};
		_proto.initializeRenderState = function initializeRenderState() {
			this.blendState = new BlendState();
			this.depthState = new DepthState();
			this.cullMode = CULLFACE_BACK;
			this.vx = this.vy = this.vw = this.vh = 0;
			this.sx = this.sy = this.sw = this.sh = 0;
		};
		_proto.setStencilState = function setStencilState(stencilFront, stencilBack) {};
		_proto.setBlendState = function setBlendState(blendState) {};
		_proto.setDepthState = function setDepthState(depthState) {};
		_proto.setCullMode = function setCullMode(cullMode) {};
		_proto.setRenderTarget = function setRenderTarget(renderTarget) {
			this.renderTarget = renderTarget;
		};
		_proto.setIndexBuffer = function setIndexBuffer(indexBuffer) {
			this.indexBuffer = indexBuffer;
		};
		_proto.setVertexBuffer = function setVertexBuffer(vertexBuffer) {
			if (vertexBuffer) {
				this.vertexBuffers.push(vertexBuffer);
			}
		};
		_proto.getRenderTarget = function getRenderTarget() {
			return this.renderTarget;
		};
		_proto.initRenderTarget = function initRenderTarget(target) {
			if (target.initialized) return;
			target.init();
			this.targets.push(target);
		};
		_proto._isBrowserInterface = function _isBrowserInterface(texture) {
			return this._isImageBrowserInterface(texture) || this._isImageCanvasInterface(texture) || this._isImageVideoInterface(texture);
		};
		_proto._isImageBrowserInterface = function _isImageBrowserInterface(texture) {
			return typeof ImageBitmap !== 'undefined' && texture instanceof ImageBitmap || typeof HTMLImageElement !== 'undefined' && texture instanceof HTMLImageElement;
		};
		_proto._isImageCanvasInterface = function _isImageCanvasInterface(texture) {
			return typeof HTMLCanvasElement !== 'undefined' && texture instanceof HTMLCanvasElement;
		};
		_proto._isImageVideoInterface = function _isImageVideoInterface(texture) {
			return typeof HTMLVideoElement !== 'undefined' && texture instanceof HTMLVideoElement;
		};
		_proto.resizeCanvas = function resizeCanvas(width, height) {};
		_proto.setResolution = function setResolution(width, height) {
			this._width = width;
			this._height = height;
			this.canvas.width = width;
			this.canvas.height = height;
			this.fire(GraphicsDevice.EVENT_RESIZE, width, height);
		};
		_proto.updateClientRect = function updateClientRect() {
			this.clientRect = this.canvas.getBoundingClientRect();
		};
		_proto.getBoneLimit = function getBoneLimit() {
			return this.boneLimit;
		};
		_proto.setBoneLimit = function setBoneLimit(maxBones) {
			this.boneLimit = maxBones;
		};
		_proto.frameStart = function frameStart() {
			this.renderPassIndex = 0;
			this.renderVersion++;
		};
		_proto.frameEnd = function frameEnd() {};
		_createClass(GraphicsDevice, [{
			key: "width",
			get: function get() {
				return this.canvas.width;
			}
		}, {
			key: "height",
			get: function get() {
				return this.canvas.height;
			}
		}, {
			key: "fullscreen",
			get: function get() {
				return false;
			},
			set: function set(fullscreen) {}
		}, {
			key: "maxPixelRatio",
			get: function get() {
				return this._maxPixelRatio;
			},
			set: function set(ratio) {
				if (this._maxPixelRatio !== ratio) {
					this._maxPixelRatio = ratio;
					this.resizeCanvas(this._width, this._height);
				}
			}
		}, {
			key: "deviceType",
			get: function get() {
				return this._deviceType;
			}
		}]);
		return GraphicsDevice;
	}(EventHandler);
	GraphicsDevice.EVENT_RESIZE = 'resizecanvas';

	var id$8 = 0;
	var RenderTarget = function () {
		function RenderTarget(options) {
			var _options$face, _this$_colorBuffer, _this$_depthBuffer, _this$_colorBuffers, _options$samples, _options$autoResolve, _options$flipY;
			if (options === void 0) {
				options = {};
			}
			this.name = void 0;
			this._device = void 0;
			this._colorBuffer = void 0;
			this._colorBuffers = void 0;
			this._depthBuffer = void 0;
			this._depth = void 0;
			this._stencil = void 0;
			this._samples = void 0;
			this.autoResolve = void 0;
			this._face = void 0;
			this.flipY = void 0;
			this.id = id$8++;
			var _arg2 = arguments[1];
			var _arg3 = arguments[2];
			if (options instanceof GraphicsDevice) {
				this._colorBuffer = _arg2;
				options = _arg3;
			} else {
				this._colorBuffer = options.colorBuffer;
			}
			if (this._colorBuffer) {
				this._colorBuffers = [this._colorBuffer];
			}
			this._depthBuffer = options.depthBuffer;
			this._face = (_options$face = options.face) != null ? _options$face : 0;
			if (this._depthBuffer) {
				var format = this._depthBuffer._format;
				if (format === PIXELFORMAT_DEPTH) {
					this._depth = true;
					this._stencil = false;
				} else if (format === PIXELFORMAT_DEPTHSTENCIL) {
					this._depth = true;
					this._stencil = true;
				} else {
					this._depth = false;
					this._stencil = false;
				}
			} else {
				var _options$depth, _options$stencil;
				this._depth = (_options$depth = options.depth) != null ? _options$depth : true;
				this._stencil = (_options$stencil = options.stencil) != null ? _options$stencil : false;
			}
			if (options.colorBuffers) {
				if (!this._colorBuffers) {
					this._colorBuffers = [].concat(options.colorBuffers);
					this._colorBuffer = options.colorBuffers[0];
				}
			}
			var device = ((_this$_colorBuffer = this._colorBuffer) == null ? void 0 : _this$_colorBuffer.device) || ((_this$_depthBuffer = this._depthBuffer) == null ? void 0 : _this$_depthBuffer.device) || options.graphicsDevice;
			this._device = device;
			(_this$_colorBuffers = this._colorBuffers) == null ? void 0 : _this$_colorBuffers.forEach(function (colorBuffer) {
				colorBuffer._isRenderTarget = true;
			});
			var maxSamples = this._device.maxSamples;
			this._samples = Math.min((_options$samples = options.samples) != null ? _options$samples : 1, maxSamples);
			if (device.isWebGPU) {
				this._samples = this._samples > 1 ? maxSamples : 1;
			}
			this.autoResolve = (_options$autoResolve = options.autoResolve) != null ? _options$autoResolve : true;
			this.name = options.name;
			if (!this.name) {
				var _this$_colorBuffer2;
				this.name = (_this$_colorBuffer2 = this._colorBuffer) == null ? void 0 : _this$_colorBuffer2.name;
			}
			if (!this.name) {
				var _this$_depthBuffer2;
				this.name = (_this$_depthBuffer2 = this._depthBuffer) == null ? void 0 : _this$_depthBuffer2.name;
			}
			if (!this.name) {
				this.name = "Untitled";
			}
			this.flipY = (_options$flipY = options.flipY) != null ? _options$flipY : false;
			this.validateMrt();
			this.impl = device.createRenderTargetImpl(this);
		}
		var _proto = RenderTarget.prototype;
		_proto.destroy = function destroy() {
			var device = this._device;
			if (device) {
				var idx = device.targets.indexOf(this);
				if (idx !== -1) {
					device.targets.splice(idx, 1);
				}
				if (device.renderTarget === this) {
					device.setRenderTarget(null);
				}
				this.destroyFrameBuffers();
			}
		};
		_proto.destroyFrameBuffers = function destroyFrameBuffers() {
			var device = this._device;
			if (device) {
				this.impl.destroy(device);
			}
		};
		_proto.destroyTextureBuffers = function destroyTextureBuffers() {
			var _this$_depthBuffer3, _this$_colorBuffers2;
			(_this$_depthBuffer3 = this._depthBuffer) == null ? void 0 : _this$_depthBuffer3.destroy();
			this._depthBuffer = null;
			(_this$_colorBuffers2 = this._colorBuffers) == null ? void 0 : _this$_colorBuffers2.forEach(function (colorBuffer) {
				colorBuffer.destroy();
			});
			this._colorBuffers = null;
			this._colorBuffer = null;
		};
		_proto.validateMrt = function validateMrt() {};
		_proto.init = function init() {
			this.impl.init(this._device, this);
		};
		_proto.loseContext = function loseContext() {
			this.impl.loseContext();
		};
		_proto.resolve = function resolve(color, depth) {
			if (color === void 0) {
				color = true;
			}
			if (depth === void 0) {
				depth = !!this._depthBuffer;
			}
			if (this._device && this._samples > 1) {
				this.impl.resolve(this._device, this, color, depth);
			}
		};
		_proto.copy = function copy(source, color, depth) {
			if (!this._device) {
				if (source._device) {
					this._device = source._device;
				} else {
					return false;
				}
			}
			var success = this._device.copyRenderTarget(source, this, color, depth);
			return success;
		};
		_proto.getColorBuffer = function getColorBuffer(index) {
			var _this$_colorBuffers3;
			return (_this$_colorBuffers3 = this._colorBuffers) == null ? void 0 : _this$_colorBuffers3[index];
		};
		_createClass(RenderTarget, [{
			key: "initialized",
			get: function get() {
				return this.impl.initialized;
			}
		}, {
			key: "samples",
			get: function get() {
				return this._samples;
			}
		}, {
			key: "depth",
			get: function get() {
				return this._depth;
			}
		}, {
			key: "stencil",
			get: function get() {
				return this._stencil;
			}
		}, {
			key: "colorBuffer",
			get: function get() {
				return this._colorBuffer;
			}
		}, {
			key: "depthBuffer",
			get: function get() {
				return this._depthBuffer;
			}
		}, {
			key: "face",
			get: function get() {
				return this._face;
			}
		}, {
			key: "width",
			get: function get() {
				var _this$_colorBuffer3, _this$_depthBuffer4;
				return ((_this$_colorBuffer3 = this._colorBuffer) == null ? void 0 : _this$_colorBuffer3.width) || ((_this$_depthBuffer4 = this._depthBuffer) == null ? void 0 : _this$_depthBuffer4.width) || this._device.width;
			}
		}, {
			key: "height",
			get: function get() {
				var _this$_colorBuffer4, _this$_depthBuffer5;
				return ((_this$_colorBuffer4 = this._colorBuffer) == null ? void 0 : _this$_colorBuffer4.height) || ((_this$_depthBuffer5 = this._depthBuffer) == null ? void 0 : _this$_depthBuffer5.height) || this._device.height;
			}
		}]);
		return RenderTarget;
	}();

	var WebgpuBindGroup = function () {
		function WebgpuBindGroup() {
			this.bindGroup = void 0;
		}
		var _proto = WebgpuBindGroup.prototype;
		_proto.update = function update(bindGroup) {
			this.destroy();
			var device = bindGroup.device;
			var descr = this.createDescriptor(device, bindGroup);
			this.bindGroup = device.wgpu.createBindGroup(descr);
		};
		_proto.destroy = function destroy() {
			this.bindGroup = null;
		};
		_proto.createDescriptor = function createDescriptor(device, bindGroup) {
			var entries = [];
			var format = bindGroup.format;
			var index = 0;
			bindGroup.uniformBuffers.forEach(function (ub) {
				var buffer = ub.persistent ? ub.impl.buffer : ub.allocation.gpuBuffer.buffer;
				entries.push({
					binding: index++,
					resource: {
						buffer: buffer,
						offset: 0,
						size: ub.format.byteSize
					}
				});
			});
			bindGroup.textures.forEach(function (tex, textureIndex) {
				var wgpuTexture = tex.impl;
				var textureFormat = format.textureFormats[textureIndex];
				var view = wgpuTexture.getView(device);
				entries.push({
					binding: index++,
					resource: view
				});
				var sampler = wgpuTexture.getSampler(device, textureFormat.sampleType);
				entries.push({
					binding: index++,
					resource: sampler
				});
			});
			var descr = {
				layout: bindGroup.format.impl.bindGroupLayout,
				entries: entries
			};
			return descr;
		};
		return WebgpuBindGroup;
	}();

	var WebgpuUtils = function () {
		function WebgpuUtils() {}
		WebgpuUtils.shaderStage = function shaderStage(stage) {
			var ret = 0;
			if (stage & SHADERSTAGE_VERTEX) ret |= GPUShaderStage.VERTEX;
			if (stage & SHADERSTAGE_FRAGMENT) ret |= GPUShaderStage.FRAGMENT;
			if (stage & SHADERSTAGE_COMPUTE) ret |= GPUShaderStage.COMPUTE;
			return ret;
		};
		return WebgpuUtils;
	}();

	var samplerTypes = [];
	samplerTypes[SAMPLETYPE_FLOAT] = 'filtering';
	samplerTypes[SAMPLETYPE_UNFILTERABLE_FLOAT] = 'non-filtering';
	samplerTypes[SAMPLETYPE_DEPTH] = 'comparison';
	var sampleTypes = [];
	sampleTypes[SAMPLETYPE_FLOAT] = 'float';
	sampleTypes[SAMPLETYPE_UNFILTERABLE_FLOAT] = 'unfilterable-float';
	sampleTypes[SAMPLETYPE_DEPTH] = 'depth';
	var stringIds$1 = new StringIds();
	var WebgpuBindGroupFormat = function () {
		function WebgpuBindGroupFormat(bindGroupFormat) {
			var device = bindGroupFormat.device;
			var _this$createDescripto = this.createDescriptor(bindGroupFormat),
				key = _this$createDescripto.key,
				descr = _this$createDescripto.descr;
			this.key = stringIds$1.get(key);
			this.bindGroupLayout = device.wgpu.createBindGroupLayout(descr);
		}
		var _proto = WebgpuBindGroupFormat.prototype;
		_proto.destroy = function destroy() {
			this.bindGroupLayout = null;
		};
		_proto.loseContext = function loseContext() {};
		_proto.getTextureSlot = function getTextureSlot(bindGroupFormat, index) {
			return bindGroupFormat.bufferFormats.length + index * 2;
		};
		_proto.createDescriptor = function createDescriptor(bindGroupFormat) {
			var entries = [];
			var key = '';
			var index = 0;
			bindGroupFormat.bufferFormats.forEach(function (bufferFormat) {
				var visibility = WebgpuUtils.shaderStage(bufferFormat.visibility);
				key += "#" + index + "U:" + visibility;
				entries.push({
					binding: index++,
					visibility: visibility,
					buffer: {
						type: 'uniform',
						hasDynamicOffset: true
					}
				});
			});
			bindGroupFormat.textureFormats.forEach(function (textureFormat) {
				var visibility = WebgpuUtils.shaderStage(textureFormat.visibility);
				var sampleType = textureFormat.sampleType;
				var viewDimension = textureFormat.textureDimension;
				var multisampled = false;
				var gpuSampleType = sampleTypes[sampleType];
				key += "#" + index + "T:" + visibility + "-" + gpuSampleType + "-" + viewDimension + "-" + multisampled;
				entries.push({
					binding: index++,
					visibility: visibility,
					texture: {
						sampleType: gpuSampleType,
						viewDimension: viewDimension,
						multisampled: multisampled
					}
				});
				var gpuSamplerType = samplerTypes[sampleType];
				key += "#" + index + "S:" + visibility + "-" + gpuSamplerType;
				entries.push({
					binding: index++,
					visibility: visibility,
					sampler: {
						type: gpuSamplerType
					}
				});
			});
			var descr = {
				entries: entries
			};
			return {
				key: key,
				descr: descr
			};
		};
		return WebgpuBindGroupFormat;
	}();

	var WebgpuBuffer = function () {
		function WebgpuBuffer() {
			this.buffer = null;
		}
		var _proto = WebgpuBuffer.prototype;
		_proto.destroy = function destroy(device) {
			if (this.buffer) {
				this.buffer.destroy();
				this.buffer = null;
			}
		};
		_proto.loseContext = function loseContext() {};
		_proto.unlock = function unlock(device, usage, target, storage) {
			var _storage$byteOffset, _storage$buffer;
			var wgpu = device.wgpu;
			if (!this.buffer) {
				var size = storage.byteLength + 3 & ~3;
				this.buffer = device.wgpu.createBuffer({
					size: size,
					usage: target | GPUBufferUsage.COPY_DST
				});
			}
			var srcOffset = (_storage$byteOffset = storage.byteOffset) != null ? _storage$byteOffset : 0;
			var srcData = new Uint8Array((_storage$buffer = storage.buffer) != null ? _storage$buffer : storage, srcOffset, storage.byteLength);
			var data = new Uint8Array(this.buffer.size);
			data.set(srcData);
			wgpu.queue.writeBuffer(this.buffer, 0, data, 0, data.length);
		};
		_createClass(WebgpuBuffer, [{
			key: "initialized",
			get: function get() {
				return !!this.buffer;
			}
		}]);
		return WebgpuBuffer;
	}();

	var WebgpuIndexBuffer = function (_WebgpuBuffer) {
		_inheritsLoose(WebgpuIndexBuffer, _WebgpuBuffer);
		function WebgpuIndexBuffer(indexBuffer) {
			var _this;
			_this = _WebgpuBuffer.call(this) || this;
			_this.format = null;
			_this.format = indexBuffer.format === INDEXFORMAT_UINT16 ? "uint16" : "uint32";
			return _this;
		}
		var _proto = WebgpuIndexBuffer.prototype;
		_proto.unlock = function unlock(indexBuffer) {
			var device = indexBuffer.device;
			_WebgpuBuffer.prototype.unlock.call(this, device, indexBuffer.usage, GPUBufferUsage.INDEX, indexBuffer.storage);
		};
		return WebgpuIndexBuffer;
	}(WebgpuBuffer);

	var array = {
		equals: function equals(arr1, arr2) {
			if (arr1.size !== arr2.size) {
				return false;
			}
			for (var i = 0; i < arr1.length; i++) {
				if (arr1[i] !== arr2[i]) {
					return false;
				}
			}
			return true;
		}
	};

	var gpuVertexFormats = [];
	gpuVertexFormats[TYPE_INT8] = 'sint8';
	gpuVertexFormats[TYPE_UINT8] = 'uint8';
	gpuVertexFormats[TYPE_INT16] = 'sint16';
	gpuVertexFormats[TYPE_UINT16] = 'uint16';
	gpuVertexFormats[TYPE_INT32] = 'sint32';
	gpuVertexFormats[TYPE_UINT32] = 'uint32';
	gpuVertexFormats[TYPE_FLOAT32] = 'float32';
	var gpuVertexFormatsNormalized = [];
	gpuVertexFormatsNormalized[TYPE_INT8] = 'snorm8';
	gpuVertexFormatsNormalized[TYPE_UINT8] = 'unorm8';
	gpuVertexFormatsNormalized[TYPE_INT16] = 'snorm16';
	gpuVertexFormatsNormalized[TYPE_UINT16] = 'unorm16';
	gpuVertexFormatsNormalized[TYPE_INT32] = 'sint32';
	gpuVertexFormatsNormalized[TYPE_UINT32] = 'uint32';
	gpuVertexFormatsNormalized[TYPE_FLOAT32] = 'float32';
	var WebgpuVertexBufferLayout = function () {
		function WebgpuVertexBufferLayout() {
			this.cache = new Map();
		}
		var _proto = WebgpuVertexBufferLayout.prototype;
		_proto.get = function get(vertexFormat0, vertexFormat1) {
			if (vertexFormat1 === void 0) {
				vertexFormat1 = null;
			}
			var key = this.getKey(vertexFormat0, vertexFormat1);
			var layout = this.cache.get(key);
			if (!layout) {
				layout = this.create(vertexFormat0, vertexFormat1);
				this.cache.set(key, layout);
			}
			return layout;
		};
		_proto.getKey = function getKey(vertexFormat0, vertexFormat1) {
			var _vertexFormat;
			if (vertexFormat1 === void 0) {
				vertexFormat1 = null;
			}
			return (vertexFormat0 == null ? void 0 : vertexFormat0.renderingHashString) + "-" + ((_vertexFormat = vertexFormat1) == null ? void 0 : _vertexFormat.renderingHashString);
		};
		_proto.create = function create(vertexFormat0, vertexFormat1) {
			var layout = [];
			var addFormat = function addFormat(format) {
				var interleaved = format.interleaved;
				var stepMode = format.instancing ? 'instance' : 'vertex';
				var attributes = [];
				var elementCount = format.elements.length;
				for (var i = 0; i < elementCount; i++) {
					var element = format.elements[i];
					var location = semanticToLocation[element.name];
					var formatTable = element.normalize ? gpuVertexFormatsNormalized : gpuVertexFormats;
					attributes.push({
						shaderLocation: location,
						offset: interleaved ? element.offset : 0,
						format: "" + formatTable[element.dataType] + (element.numComponents > 1 ? 'x' + element.numComponents : '')
					});
					if (!interleaved || i === elementCount - 1) {
						layout.push({
							attributes: attributes,
							arrayStride: element.stride,
							stepMode: stepMode
						});
						attributes = [];
					}
				}
			};
			if (vertexFormat0) addFormat(vertexFormat0);
			if (vertexFormat1) addFormat(vertexFormat1);
			return layout;
		};
		return WebgpuVertexBufferLayout;
	}();

	var _primitiveTopology = ['point-list', 'line-list', undefined, 'line-strip', 'triangle-list', 'triangle-strip', undefined];
	var _blendOperation = ['add', 'subtract', 'reverse-subtract', 'min', 'max'];
	var _blendFactor = ['zero', 'one', 'src', 'one-minus-src', 'dst', 'one-minus-dst', 'src-alpha', 'src-alpha-saturated', 'one-minus-src-alpha', 'dst-alpha', 'one-minus-dst-alpha', 'constant', 'one-minus-constant'];
	var _compareFunction = ['never', 'less', 'equal', 'less-equal', 'greater', 'not-equal', 'greater-equal', 'always'];
	var _cullModes = ['none', 'back', 'front'];
	var _stencilOps = ['keep', 'zero', 'replace', 'increment-clamp', 'increment-wrap', 'decrement-clamp', 'decrement-wrap', 'invert'];
	var _bindGroupLayouts = [];
	var CacheEntry = function CacheEntry() {
		this.pipeline = void 0;
		this.hashes = void 0;
	};
	var WebgpuRenderPipeline = function () {
		function WebgpuRenderPipeline(device) {
			this.lookupHashes = new Uint32Array(13);
			this.device = device;
			this.vertexBufferLayout = new WebgpuVertexBufferLayout();
			this.cache = new Map();
		}
		var _proto = WebgpuRenderPipeline.prototype;
		_proto.get = function get(primitive, vertexFormat0, vertexFormat1, shader, renderTarget, bindGroupFormats, blendState, depthState, cullMode, stencilEnabled, stencilFront, stencilBack) {
			var _vertexFormat0$render, _vertexFormat1$render, _bindGroupFormats$0$k, _bindGroupFormats$, _bindGroupFormats$1$k, _bindGroupFormats$2, _bindGroupFormats$2$k, _bindGroupFormats$3;
			var lookupHashes = this.lookupHashes;
			lookupHashes[0] = primitive.type;
			lookupHashes[1] = shader.id;
			lookupHashes[2] = cullMode;
			lookupHashes[3] = depthState.key;
			lookupHashes[4] = blendState.key;
			lookupHashes[5] = (_vertexFormat0$render = vertexFormat0 == null ? void 0 : vertexFormat0.renderingHash) != null ? _vertexFormat0$render : 0;
			lookupHashes[6] = (_vertexFormat1$render = vertexFormat1 == null ? void 0 : vertexFormat1.renderingHash) != null ? _vertexFormat1$render : 0;
			lookupHashes[7] = renderTarget.impl.key;
			lookupHashes[8] = (_bindGroupFormats$0$k = (_bindGroupFormats$ = bindGroupFormats[0]) == null ? void 0 : _bindGroupFormats$.key) != null ? _bindGroupFormats$0$k : 0;
			lookupHashes[9] = (_bindGroupFormats$1$k = (_bindGroupFormats$2 = bindGroupFormats[1]) == null ? void 0 : _bindGroupFormats$2.key) != null ? _bindGroupFormats$1$k : 0;
			lookupHashes[10] = (_bindGroupFormats$2$k = (_bindGroupFormats$3 = bindGroupFormats[2]) == null ? void 0 : _bindGroupFormats$3.key) != null ? _bindGroupFormats$2$k : 0;
			lookupHashes[11] = stencilEnabled ? stencilFront.key : 0;
			lookupHashes[12] = stencilEnabled ? stencilBack.key : 0;
			var hash = hash32Fnv1a(lookupHashes);
			var cacheEntries = this.cache.get(hash);
			if (cacheEntries) {
				for (var i = 0; i < cacheEntries.length; i++) {
					var entry = cacheEntries[i];
					if (array.equals(entry.hashes, lookupHashes)) {
						return entry.pipeline;
					}
				}
			}
			var primitiveTopology = _primitiveTopology[primitive.type];
			var pipelineLayout = this.getPipelineLayout(bindGroupFormats);
			var vertexBufferLayout = this.vertexBufferLayout.get(vertexFormat0, vertexFormat1);
			var cacheEntry = new CacheEntry();
			cacheEntry.hashes = new Uint32Array(lookupHashes);
			cacheEntry.pipeline = this.create(primitiveTopology, shader, renderTarget, pipelineLayout, blendState, depthState, vertexBufferLayout, cullMode, stencilEnabled, stencilFront, stencilBack);
			if (cacheEntries) {
				cacheEntries.push(cacheEntry);
			} else {
				cacheEntries = [cacheEntry];
			}
			this.cache.set(hash, cacheEntries);
			return cacheEntry.pipeline;
		};
		_proto.getPipelineLayout = function getPipelineLayout(bindGroupFormats) {
			bindGroupFormats.forEach(function (format) {
				_bindGroupLayouts.push(format.bindGroupLayout);
			});
			var descr = {
				bindGroupLayouts: _bindGroupLayouts
			};
			var pipelineLayout = this.device.wgpu.createPipelineLayout(descr);
			_bindGroupLayouts.length = 0;
			return pipelineLayout;
		};
		_proto.getBlend = function getBlend(blendState) {
			var blend;
			if (blendState.blend) {
				blend = {
					color: {
						operation: _blendOperation[blendState.colorOp],
						srcFactor: _blendFactor[blendState.colorSrcFactor],
						dstFactor: _blendFactor[blendState.colorDstFactor]
					},
					alpha: {
						operation: _blendOperation[blendState.alphaOp],
						srcFactor: _blendFactor[blendState.alphaSrcFactor],
						dstFactor: _blendFactor[blendState.alphaDstFactor]
					}
				};
			}
			return blend;
		};
		_proto.getDepthStencil = function getDepthStencil(depthState, renderTarget, stencilEnabled, stencilFront, stencilBack) {
			var depthStencil;
			var depth = renderTarget.depth,
				stencil = renderTarget.stencil;
			if (depth || stencil) {
				depthStencil = {
					format: renderTarget.impl.depthFormat
				};
				if (depth) {
					depthStencil.depthWriteEnabled = depthState.write;
					depthStencil.depthCompare = _compareFunction[depthState.func];
				} else {
					depthStencil.depthWriteEnabled = false;
					depthStencil.depthCompare = 'always';
				}
				if (stencil && stencilEnabled) {
					depthStencil.stencilReadMas = stencilFront.readMask;
					depthStencil.stencilWriteMask = stencilFront.writeMask;
					depthStencil.stencilFront = {
						compare: _compareFunction[stencilFront.func],
						failOp: _stencilOps[stencilFront.fail],
						passOp: _stencilOps[stencilFront.zpass],
						depthFailOp: _stencilOps[stencilFront.zfail]
					};
					depthStencil.stencilBack = {
						compare: _compareFunction[stencilBack.func],
						failOp: _stencilOps[stencilBack.fail],
						passOp: _stencilOps[stencilBack.zpass],
						depthFailOp: _stencilOps[stencilBack.zfail]
					};
				}
			}
			return depthStencil;
		};
		_proto.create = function create(primitiveTopology, shader, renderTarget, pipelineLayout, blendState, depthState, vertexBufferLayout, cullMode, stencilEnabled, stencilFront, stencilBack) {
			var wgpu = this.device.wgpu;
			var webgpuShader = shader.impl;
			var descr = {
				vertex: {
					module: webgpuShader.getVertexShaderModule(),
					entryPoint: webgpuShader.vertexEntryPoint,
					buffers: vertexBufferLayout
				},
				fragment: {
					module: webgpuShader.getFragmentShaderModule(),
					entryPoint: webgpuShader.fragmentEntryPoint,
					targets: []
				},
				primitive: {
					topology: primitiveTopology,
					frontFace: 'ccw',
					cullMode: _cullModes[cullMode]
				},
				depthStencil: this.getDepthStencil(depthState, renderTarget, stencilEnabled, stencilFront, stencilBack),
				multisample: {
					count: renderTarget.samples
				},
				layout: pipelineLayout
			};
			var colorAttachments = renderTarget.impl.colorAttachments;
			if (colorAttachments.length > 0) {
				var writeMask = 0;
				if (blendState.redWrite) writeMask |= GPUColorWrite.RED;
				if (blendState.greenWrite) writeMask |= GPUColorWrite.GREEN;
				if (blendState.blueWrite) writeMask |= GPUColorWrite.BLUE;
				if (blendState.alphaWrite) writeMask |= GPUColorWrite.ALPHA;
				var blend = this.getBlend(blendState);
				colorAttachments.forEach(function (attachment) {
					descr.fragment.targets.push({
						format: attachment.format,
						writeMask: writeMask,
						blend: blend
					});
				});
			}
			var pipeline = wgpu.createRenderPipeline(descr);
			return pipeline;
		};
		return WebgpuRenderPipeline;
	}();

	var stringIds = new StringIds();
	var ColorAttachment = function () {
		function ColorAttachment() {
			this.format = void 0;
			this.multisampledBuffer = void 0;
		}
		var _proto = ColorAttachment.prototype;
		_proto.destroy = function destroy() {
			var _this$multisampledBuf;
			(_this$multisampledBuf = this.multisampledBuffer) == null ? void 0 : _this$multisampledBuf.destroy();
			this.multisampledBuffer = null;
		};
		return ColorAttachment;
	}();
	var WebgpuRenderTarget = function () {
		function WebgpuRenderTarget(renderTarget) {
			var _this = this;
			this.initialized = false;
			this.key = void 0;
			this.colorAttachments = [];
			this.depthFormat = void 0;
			this.hasStencil = void 0;
			this.depthTexture = null;
			this.depthTextureInternal = false;
			this.assignedColorTexture = null;
			this.renderPassDescriptor = {};
			this.renderTarget = renderTarget;
			if (renderTarget._colorBuffers) {
				renderTarget._colorBuffers.forEach(function (colorBuffer, index) {
					_this.setColorAttachment(index, undefined, colorBuffer.impl.format);
				});
			}
			this.updateKey();
		}
		var _proto2 = WebgpuRenderTarget.prototype;
		_proto2.destroy = function destroy(device) {
			this.initialized = false;
			if (this.depthTextureInternal) {
				var _this$depthTexture;
				(_this$depthTexture = this.depthTexture) == null ? void 0 : _this$depthTexture.destroy();
				this.depthTexture = null;
			}
			this.assignedColorTexture = null;
			this.colorAttachments.forEach(function (colorAttachment) {
				colorAttachment.destroy();
			});
			this.colorAttachments.length = 0;
		};
		_proto2.updateKey = function updateKey() {
			var rt = this.renderTarget;
			var key = rt.samples + ":" + (rt.depth ? this.depthFormat : 'nodepth');
			this.colorAttachments.forEach(function (colorAttachment) {
				key += ":" + colorAttachment.format;
			});
			this.key = stringIds.get(key);
		};
		_proto2.setDepthFormat = function setDepthFormat(depthFormat) {
			this.depthFormat = depthFormat;
			this.hasStencil = depthFormat === 'depth24plus-stencil8';
		};
		_proto2.assignColorTexture = function assignColorTexture(gpuTexture) {
			this.assignedColorTexture = gpuTexture;
			var view = gpuTexture.createView();
			var colorAttachment = this.renderPassDescriptor.colorAttachments[0];
			var samples = this.renderTarget.samples;
			if (samples > 1) {
				colorAttachment.resolveTarget = view;
			} else {
				colorAttachment.view = view;
			}
			this.setColorAttachment(0, undefined, gpuTexture.format);
			this.updateKey();
		};
		_proto2.setColorAttachment = function setColorAttachment(index, multisampledBuffer, format) {
			if (!this.colorAttachments[index]) {
				this.colorAttachments[index] = new ColorAttachment();
			}
			if (multisampledBuffer) {
				this.colorAttachments[index].multisampledBuffer = multisampledBuffer;
			}
			if (format) {
				this.colorAttachments[index].format = format;
			}
		};
		_proto2.init = function init(device, renderTarget) {
			var _renderTarget$_colorB, _renderTarget$_colorB2;
			var wgpu = device.wgpu;
			this.initDepthStencil(wgpu, renderTarget);
			this.renderPassDescriptor.colorAttachments = [];
			var count = (_renderTarget$_colorB = (_renderTarget$_colorB2 = renderTarget._colorBuffers) == null ? void 0 : _renderTarget$_colorB2.length) != null ? _renderTarget$_colorB : 1;
			for (var i = 0; i < count; ++i) {
				var _this$colorAttachment;
				var colorAttachment = this.initColor(wgpu, renderTarget, i);
				var isDefaultFramebuffer = i === 0 && ((_this$colorAttachment = this.colorAttachments[0]) == null ? void 0 : _this$colorAttachment.format);
				if (colorAttachment.view || isDefaultFramebuffer) {
					this.renderPassDescriptor.colorAttachments.push(colorAttachment);
				}
			}
			this.initialized = true;
		};
		_proto2.initDepthStencil = function initDepthStencil(wgpu, renderTarget) {
			var samples = renderTarget.samples,
				width = renderTarget.width,
				height = renderTarget.height,
				depth = renderTarget.depth,
				depthBuffer = renderTarget.depthBuffer;
			if (depth || depthBuffer) {
				if (!depthBuffer) {
					this.setDepthFormat('depth24plus-stencil8');
					var depthTextureDesc = {
						size: [width, height, 1],
						dimension: '2d',
						sampleCount: samples,
						format: this.depthFormat,
						usage: GPUTextureUsage.RENDER_ATTACHMENT
					};
					if (samples > 1) {
						depthTextureDesc.usage |= GPUTextureUsage.TEXTURE_BINDING;
					} else {
						depthTextureDesc.usage |= GPUTextureUsage.COPY_SRC;
					}
					this.depthTexture = wgpu.createTexture(depthTextureDesc);
					this.depthTextureInternal = true;
				} else {
					this.depthTexture = depthBuffer.impl.gpuTexture;
					this.setDepthFormat(depthBuffer.impl.format);
				}
				this.renderPassDescriptor.depthStencilAttachment = {
					view: this.depthTexture.createView()
				};
			}
		};
		_proto2.initColor = function initColor(wgpu, renderTarget, index) {
			var colorAttachment = {};
			var samples = renderTarget.samples,
				width = renderTarget.width,
				height = renderTarget.height;
			var colorBuffer = renderTarget.getColorBuffer(index);
			var colorView = null;
			if (colorBuffer) {
				var mipLevelCount = 1;
				if (colorBuffer.cubemap) {
					colorView = colorBuffer.impl.createView({
						dimension: '2d',
						baseArrayLayer: renderTarget.face,
						arrayLayerCount: 1,
						mipLevelCount: mipLevelCount
					});
				} else {
					colorView = colorBuffer.impl.createView({
						mipLevelCount: mipLevelCount
					});
				}
			}
			if (samples > 1) {
				var _this$colorAttachment2, _this$colorAttachment3;
				var multisampledTextureDesc = {
					size: [width, height, 1],
					dimension: '2d',
					sampleCount: samples,
					format: (_this$colorAttachment2 = (_this$colorAttachment3 = this.colorAttachments[index]) == null ? void 0 : _this$colorAttachment3.format) != null ? _this$colorAttachment2 : colorBuffer.impl.format,
					usage: GPUTextureUsage.RENDER_ATTACHMENT
				};
				var multisampledColorBuffer = wgpu.createTexture(multisampledTextureDesc);
				this.setColorAttachment(index, multisampledColorBuffer);
				colorAttachment.view = multisampledColorBuffer.createView();
				colorAttachment.resolveTarget = colorView;
			} else {
				colorAttachment.view = colorView;
			}
			return colorAttachment;
		};
		_proto2.setupForRenderPass = function setupForRenderPass(renderPass) {
			var _this$renderPassDescr, _this$renderPassDescr2;
			var count = (_this$renderPassDescr = (_this$renderPassDescr2 = this.renderPassDescriptor.colorAttachments) == null ? void 0 : _this$renderPassDescr2.length) != null ? _this$renderPassDescr : 0;
			for (var i = 0; i < count; ++i) {
				var colorAttachment = this.renderPassDescriptor.colorAttachments[i];
				var colorOps = renderPass.colorArrayOps[i];
				colorAttachment.clearValue = colorOps.clearValue;
				colorAttachment.loadOp = colorOps.clear ? 'clear' : 'load';
				colorAttachment.storeOp = colorOps.store ? 'store' : 'discard';
			}
			var depthAttachment = this.renderPassDescriptor.depthStencilAttachment;
			if (depthAttachment) {
				depthAttachment.depthClearValue = renderPass.depthStencilOps.clearDepthValue;
				depthAttachment.depthLoadOp = renderPass.depthStencilOps.clearDepth ? 'clear' : 'load';
				depthAttachment.depthStoreOp = renderPass.depthStencilOps.storeDepth ? 'store' : 'discard';
				depthAttachment.depthReadOnly = false;
				if (this.hasStencil) {
					depthAttachment.stencilClearValue = renderPass.depthStencilOps.clearStencilValue;
					depthAttachment.stencilLoadOp = renderPass.depthStencilOps.clearStencil ? 'clear' : 'load';
					depthAttachment.stencilStoreOp = renderPass.depthStencilOps.storeStencil ? 'store' : 'discard';
					depthAttachment.stencilReadOnly = false;
				}
			}
		};
		_proto2.loseContext = function loseContext() {
			this.initialized = false;
		};
		_proto2.resolve = function resolve(device, target, color, depth) {};
		return WebgpuRenderTarget;
	}();

	var uniformTypeToNumElements = [];
	uniformTypeToNumElements[UNIFORMTYPE_FLOAT] = 1;
	uniformTypeToNumElements[UNIFORMTYPE_VEC2] = 2;
	uniformTypeToNumElements[UNIFORMTYPE_VEC3] = 3;
	uniformTypeToNumElements[UNIFORMTYPE_VEC4] = 4;
	uniformTypeToNumElements[UNIFORMTYPE_INT] = 1;
	uniformTypeToNumElements[UNIFORMTYPE_IVEC2] = 2;
	uniformTypeToNumElements[UNIFORMTYPE_IVEC3] = 3;
	uniformTypeToNumElements[UNIFORMTYPE_IVEC4] = 4;
	uniformTypeToNumElements[UNIFORMTYPE_BOOL] = 1;
	uniformTypeToNumElements[UNIFORMTYPE_BVEC2] = 2;
	uniformTypeToNumElements[UNIFORMTYPE_BVEC3] = 3;
	uniformTypeToNumElements[UNIFORMTYPE_BVEC4] = 4;
	uniformTypeToNumElements[UNIFORMTYPE_MAT2] = 8;
	uniformTypeToNumElements[UNIFORMTYPE_MAT3] = 12;
	uniformTypeToNumElements[UNIFORMTYPE_MAT4] = 16;
	var UniformFormat = function () {
		function UniformFormat(name, type, count) {
			if (count === void 0) {
				count = 0;
			}
			this.name = void 0;
			this.type = void 0;
			this.byteSize = void 0;
			this.offset = void 0;
			this.scopeId = void 0;
			this.count = void 0;
			this.shortName = name;
			this.name = count ? name + "[0]" : name;
			this.type = type;
			this.updateType = type;
			if (count) {
				switch (type) {
					case UNIFORMTYPE_FLOAT:
						this.updateType = UNIFORMTYPE_FLOATARRAY;
						break;
					case UNIFORMTYPE_VEC2:
						this.updateType = UNIFORMTYPE_VEC2ARRAY;
						break;
					case UNIFORMTYPE_VEC3:
						this.updateType = UNIFORMTYPE_VEC3ARRAY;
						break;
					case UNIFORMTYPE_VEC4:
						this.updateType = UNIFORMTYPE_VEC4ARRAY;
						break;
					case UNIFORMTYPE_MAT4:
						this.updateType = UNIFORMTYPE_MAT4ARRAY;
						break;
				}
			}
			this.count = count;
			var elementSize = uniformTypeToNumElements[type];
			if (count) elementSize = math.roundUp(elementSize, 4);
			this.byteSize = elementSize * 4;
			if (count) this.byteSize *= count;
		}
		var _proto = UniformFormat.prototype;
		_proto.calculateOffset = function calculateOffset(offset) {
			var alignment = this.byteSize <= 8 ? this.byteSize : 16;
			if (this.count) alignment = 16;
			offset = math.roundUp(offset, alignment);
			this.offset = offset / 4;
		};
		return UniformFormat;
	}();
	var UniformBufferFormat = function () {
		function UniformBufferFormat(graphicsDevice, uniforms) {
			this.byteSize = 0;
			this.map = new Map();
			this.scope = graphicsDevice.scope;
			this.uniforms = uniforms;
			var offset = 0;
			for (var i = 0; i < uniforms.length; i++) {
				var uniform = uniforms[i];
				uniform.calculateOffset(offset);
				offset = uniform.offset * 4 + uniform.byteSize;
				uniform.scopeId = this.scope.resolve(uniform.name);
				this.map.set(uniform.name, uniform);
			}
			this.byteSize = math.roundUp(offset, 16);
		}
		var _proto2 = UniformBufferFormat.prototype;
		_proto2.get = function get(name) {
			return this.map.get(name);
		};
		_proto2.getShaderDeclaration = function getShaderDeclaration(bindGroup, bindIndex) {
			var name = bindGroupNames[bindGroup];
			var code = "layout(set = " + bindGroup + ", binding = " + bindIndex + ", std140) uniform ub_" + name + " {\n";
			this.uniforms.forEach(function (uniform) {
				var typeString = uniformTypeToName[uniform.type];
				code += "    " + typeString + " " + uniform.shortName + (uniform.count ? "[" + uniform.count + "]" : '') + ";\n";
			});
			return code + '};\n';
		};
		return UniformBufferFormat;
	}();

	var _textureDimensionInfo;
	var id$7 = 0;
	var textureDimensionInfo = (_textureDimensionInfo = {}, _textureDimensionInfo[TEXTUREDIMENSION_2D] = 'texture2D', _textureDimensionInfo[TEXTUREDIMENSION_CUBE] = 'textureCube', _textureDimensionInfo[TEXTUREDIMENSION_3D] = 'texture3D', _textureDimensionInfo);
	var BindBufferFormat = function BindBufferFormat(name, visibility) {
		this.name = name;
		this.visibility = visibility;
	};
	var BindTextureFormat = function BindTextureFormat(name, visibility, textureDimension, sampleType) {
		if (textureDimension === void 0) {
			textureDimension = TEXTUREDIMENSION_2D;
		}
		if (sampleType === void 0) {
			sampleType = SAMPLETYPE_FLOAT;
		}
		this.scopeId = void 0;
		this.name = name;
		this.visibility = visibility;
		this.textureDimension = textureDimension;
		this.sampleType = sampleType;
	};
	var BindGroupFormat = function () {
		function BindGroupFormat(graphicsDevice, bufferFormats, textureFormats) {
			var _this = this;
			if (bufferFormats === void 0) {
				bufferFormats = [];
			}
			if (textureFormats === void 0) {
				textureFormats = [];
			}
			this.id = id$7++;
			this.device = graphicsDevice;
			this.bufferFormats = bufferFormats;
			this.bufferFormatsMap = new Map();
			bufferFormats.forEach(function (bf, i) {
				return _this.bufferFormatsMap.set(bf.name, i);
			});
			this.textureFormats = textureFormats;
			var scope = graphicsDevice.scope;
			this.textureFormatsMap = new Map();
			textureFormats.forEach(function (tf, i) {
				_this.textureFormatsMap.set(tf.name, i);
				tf.scopeId = scope.resolve(tf.name);
			});
			this.impl = graphicsDevice.createBindGroupFormatImpl(this);
		}
		var _proto = BindGroupFormat.prototype;
		_proto.destroy = function destroy() {
			this.impl.destroy();
		};
		_proto.getTexture = function getTexture(name) {
			var index = this.textureFormatsMap.get(name);
			if (index !== undefined) {
				return this.textureFormats[index];
			}
			return null;
		};
		_proto.getShaderDeclarationTextures = function getShaderDeclarationTextures(bindGroup) {
			var code = '';
			var bindIndex = this.bufferFormats.length;
			this.textureFormats.forEach(function (format) {
				var textureType = textureDimensionInfo[format.textureDimension];
				code += "layout(set = " + bindGroup + ", binding = " + bindIndex++ + ") uniform " + textureType + " " + format.name + ";\n" + ("layout(set = " + bindGroup + ", binding = " + bindIndex++ + ") uniform sampler " + format.name + "_sampler;\n");
			});
			return code;
		};
		_proto.loseContext = function loseContext() {};
		return BindGroupFormat;
	}();

	var KEYWORD$1 = /[ \t]*(\battribute\b|\bvarying\b|\buniform\b)/g;
	var KEYWORD_LINE = /(\battribute\b|\bvarying\b|\bout\b|\buniform\b)[ \t]*([^;]+)([;]+)/g;
	var MARKER = '@@@';
	var ARRAY_IDENTIFIER = /([\w-]+)\[(.*?)\]/;
	var precisionQualifiers = new Set(['highp', 'mediump', 'lowp']);
	var shadowSamplers = new Set(['sampler2DShadow', 'samplerCubeShadow']);
	var textureDimensions = {
		sampler2D: TEXTUREDIMENSION_2D,
		sampler3D: TEXTUREDIMENSION_3D,
		samplerCube: TEXTUREDIMENSION_CUBE,
		samplerCubeShadow: TEXTUREDIMENSION_CUBE,
		sampler2DShadow: TEXTUREDIMENSION_2D,
		sampler2DArray: TEXTUREDIMENSION_2D_ARRAY,
		sampler2DArrayShadow: TEXTUREDIMENSION_2D_ARRAY
	};
	var UniformLine = function UniformLine(line, shader) {
		this.line = line;
		var words = line.trim().split(/\s+/);
		if (precisionQualifiers.has(words[0])) {
			this.precision = words.shift();
		}
		this.type = words.shift();
		if (line.includes(',')) ;
		if (line.includes('[')) {
			var rest = words.join(' ');
			var match = ARRAY_IDENTIFIER.exec(rest);
			this.name = match[1];
			this.arraySize = Number(match[2]);
			if (isNaN(this.arraySize)) {
				shader.failed = true;
			}
		} else {
			this.name = words.shift();
			this.arraySize = 0;
		}
		this.isSampler = this.type.indexOf('sampler') !== -1;
	};
	var ShaderProcessor = function () {
		function ShaderProcessor() {}
		ShaderProcessor.run = function run(device, shaderDefinition, shader) {
			var varyingMap = new Map();
			var vertexExtracted = ShaderProcessor.extract(shaderDefinition.vshader);
			var fragmentExtracted = ShaderProcessor.extract(shaderDefinition.fshader);
			var attributesBlock = ShaderProcessor.processAttributes(vertexExtracted.attributes, shaderDefinition.attributes, shaderDefinition.processingOptions);
			var vertexVaryingsBlock = ShaderProcessor.processVaryings(vertexExtracted.varyings, varyingMap, true);
			var fragmentVaryingsBlock = ShaderProcessor.processVaryings(fragmentExtracted.varyings, varyingMap, false);
			var outBlock = ShaderProcessor.processOuts(fragmentExtracted.outs);
			var concatUniforms = vertexExtracted.uniforms.concat(fragmentExtracted.uniforms);
			var uniforms = Array.from(new Set(concatUniforms));
			var parsedUniforms = uniforms.map(function (line) {
				return new UniformLine(line, shader);
			});
			var uniformsData = ShaderProcessor.processUniforms(device, parsedUniforms, shaderDefinition.processingOptions, shader);
			var vBlock = attributesBlock + '\n' + vertexVaryingsBlock + '\n' + uniformsData.code;
			var vshader = vertexExtracted.src.replace(MARKER, vBlock);
			var fBlock = fragmentVaryingsBlock + '\n' + outBlock + '\n' + uniformsData.code;
			var fshader = fragmentExtracted.src.replace(MARKER, fBlock);
			return {
				vshader: vshader,
				fshader: fshader,
				meshUniformBufferFormat: uniformsData.meshUniformBufferFormat,
				meshBindGroupFormat: uniformsData.meshBindGroupFormat
			};
		};
		ShaderProcessor.extract = function extract(src) {
			var attributes = [];
			var varyings = [];
			var outs = [];
			var uniforms = [];
			var replacement = MARKER + "\n";
			var match;
			while ((match = KEYWORD$1.exec(src)) !== null) {
				var keyword = match[1];
				switch (keyword) {
					case 'attribute':
					case 'varying':
					case 'uniform':
					case 'out':
						{
							KEYWORD_LINE.lastIndex = match.index;
							var lineMatch = KEYWORD_LINE.exec(src);
							if (keyword === 'attribute') {
								attributes.push(lineMatch[2]);
							} else if (keyword === 'varying') {
								varyings.push(lineMatch[2]);
							} else if (keyword === 'out') {
								outs.push(lineMatch[2]);
							} else if (keyword === 'uniform') {
								uniforms.push(lineMatch[2]);
							}
							src = ShaderProcessor.cutOut(src, match.index, KEYWORD_LINE.lastIndex, replacement);
							KEYWORD$1.lastIndex = match.index + replacement.length;
							replacement = '';
							break;
						}
				}
			}
			return {
				src: src,
				attributes: attributes,
				varyings: varyings,
				outs: outs,
				uniforms: uniforms
			};
		};
		ShaderProcessor.processUniforms = function processUniforms(device, uniforms, processingOptions, shader) {
			var uniformLinesSamplers = [];
			var uniformLinesNonSamplers = [];
			uniforms.forEach(function (uniform) {
				if (uniform.isSampler) {
					uniformLinesSamplers.push(uniform);
				} else {
					uniformLinesNonSamplers.push(uniform);
				}
			});
			var meshUniforms = [];
			uniformLinesNonSamplers.forEach(function (uniform) {
				if (!processingOptions.hasUniform(uniform.name)) {
					var uniformType = uniformTypeToName.indexOf(uniform.type);
					var uniformFormat = new UniformFormat(uniform.name, uniformType, uniform.arraySize);
					meshUniforms.push(uniformFormat);
				}
			});
			var meshUniformBufferFormat = meshUniforms.length ? new UniformBufferFormat(device, meshUniforms) : null;
			var bufferFormats = [];
			if (meshUniformBufferFormat) {
				bufferFormats.push(new BindBufferFormat(UNIFORM_BUFFER_DEFAULT_SLOT_NAME, SHADERSTAGE_VERTEX | SHADERSTAGE_FRAGMENT));
			}
			var textureFormats = [];
			uniformLinesSamplers.forEach(function (uniform) {
				if (!processingOptions.hasTexture(uniform.name)) {
					var sampleType = SAMPLETYPE_FLOAT;
					if (uniform.precision === 'highp') sampleType = SAMPLETYPE_UNFILTERABLE_FLOAT;
					if (shadowSamplers.has(uniform.type)) sampleType = SAMPLETYPE_DEPTH;
					var dimension = textureDimensions[uniform.type];
					textureFormats.push(new BindTextureFormat(uniform.name, SHADERSTAGE_VERTEX | SHADERSTAGE_FRAGMENT, dimension, sampleType));
				}
			});
			var meshBindGroupFormat = new BindGroupFormat(device, bufferFormats, textureFormats);
			var code = '';
			processingOptions.uniformFormats.forEach(function (format, bindGroupIndex) {
				if (format) {
					code += format.getShaderDeclaration(bindGroupIndex, 0);
				}
			});
			if (meshUniformBufferFormat) {
				code += meshUniformBufferFormat.getShaderDeclaration(BINDGROUP_MESH, 0);
			}
			processingOptions.bindGroupFormats.forEach(function (format, bindGroupIndex) {
				if (format) {
					code += format.getShaderDeclarationTextures(bindGroupIndex);
				}
			});
			code += meshBindGroupFormat.getShaderDeclarationTextures(BINDGROUP_MESH);
			return {
				code: code,
				meshUniformBufferFormat: meshUniformBufferFormat,
				meshBindGroupFormat: meshBindGroupFormat
			};
		};
		ShaderProcessor.processVaryings = function processVaryings(varyingLines, varyingMap, isVertex) {
			var block = '';
			var op = isVertex ? 'out' : 'in';
			varyingLines.forEach(function (line, index) {
				var words = ShaderProcessor.splitToWords(line);
				var type = words[0];
				var name = words[1];
				if (isVertex) {
					varyingMap.set(name, index);
				} else {
					index = varyingMap.get(name);
				}
				block += "layout(location = " + index + ") " + op + " " + type + " " + name + ";\n";
			});
			return block;
		};
		ShaderProcessor.processOuts = function processOuts(outsLines) {
			var block = '';
			outsLines.forEach(function (line, index) {
				block += "layout(location = " + index + ") out " + line + ";\n";
			});
			return block;
		};
		ShaderProcessor.getTypeCount = function getTypeCount(type) {
			var lastChar = type.substring(type.length - 1);
			var num = parseInt(lastChar, 10);
			return isNaN(num) ? 1 : num;
		};
		ShaderProcessor.processAttributes = function processAttributes(attributeLines, shaderDefinitionAttributes, processingOptions) {
			var block = '';
			attributeLines.forEach(function (line) {
				var words = ShaderProcessor.splitToWords(line);
				var type = words[0];
				var name = words[1];
				if (shaderDefinitionAttributes.hasOwnProperty(name)) {
					var semantic = shaderDefinitionAttributes[name];
					var location = semanticToLocation[semantic];
					var copyCode;
					var element = processingOptions.getVertexElement(semantic);
					if (element) {
						var dataType = element.dataType;
						if (dataType !== TYPE_FLOAT32 && !element.normalize) {
							var attribNumElements = ShaderProcessor.getTypeCount(type);
							var newName = "_private_" + name;
							copyCode = "vec" + attribNumElements + " " + name + " = vec" + attribNumElements + "(" + newName + ");\n";
							name = newName;
							var isSignedType = dataType === TYPE_INT8 || dataType === TYPE_INT16 || dataType === TYPE_INT32;
							if (attribNumElements === 1) {
								type = isSignedType ? 'int' : 'uint';
							} else {
								type = isSignedType ? "ivec" + attribNumElements : "uvec" + attribNumElements;
							}
						}
					}
					block += "layout(location = " + location + ") in " + type + " " + name + ";\n";
					if (copyCode) {
						block += copyCode;
					}
				}
			});
			return block;
		};
		ShaderProcessor.splitToWords = function splitToWords(line) {
			line = line.replace(/\s+/g, ' ').trim();
			return line.split(' ');
		};
		ShaderProcessor.cutOut = function cutOut(src, start, end, replacement) {
			return src.substring(0, start) + replacement + src.substring(end);
		};
		return ShaderProcessor;
	}();

	var WebgpuShader = function () {
		function WebgpuShader(shader) {
			this._vertexCode = void 0;
			this._fragmentCode = void 0;
			this.vertexEntryPoint = 'main';
			this.fragmentEntryPoint = 'main';
			this.shader = shader;
			var definition = shader.definition;
			if (definition.shaderLanguage === SHADERLANGUAGE_WGSL) {
				this._vertexCode = definition.vshader;
				this._fragmentCode = definition.fshader;
				this.vertexEntryPoint = 'vertexMain';
				this.fragmentEntryPoint = 'fragmentMain';
				shader.ready = true;
			} else {
				if (definition.processingOptions) {
					this.process();
				}
			}
		}
		var _proto = WebgpuShader.prototype;
		_proto.destroy = function destroy(shader) {
			this._vertexCode = null;
			this._fragmentCode = null;
		};
		_proto.createShaderModule = function createShaderModule(code, shaderType) {
			var device = this.shader.device;
			var wgpu = device.wgpu;
			var shaderModule = wgpu.createShaderModule({
				code: code
			});
			return shaderModule;
		};
		_proto.getVertexShaderModule = function getVertexShaderModule() {
			return this.createShaderModule(this._vertexCode, 'Vertex');
		};
		_proto.getFragmentShaderModule = function getFragmentShaderModule() {
			return this.createShaderModule(this._fragmentCode, 'Fragment');
		};
		_proto.process = function process() {
			var shader = this.shader;
			var processed = ShaderProcessor.run(shader.device, shader.definition, shader);
			this._vertexCode = this.transpile(processed.vshader, 'vertex', shader.definition.vshader);
			this._fragmentCode = this.transpile(processed.fshader, 'fragment', shader.definition.fshader);
			if (!(this._vertexCode && this._fragmentCode)) {
				shader.failed = true;
			} else {
				shader.ready = true;
			}
			shader.meshUniformBufferFormat = processed.meshUniformBufferFormat;
			shader.meshBindGroupFormat = processed.meshBindGroupFormat;
		};
		_proto.transpile = function transpile(src, shaderType, originalSrc) {
			try {
				var spirv = this.shader.device.glslang.compileGLSL(src, shaderType);
				return this.shader.device.twgsl.convertSpirV2WGSL(spirv);
			} catch (err) {
				console.error("Failed to transpile webgl " + shaderType + " shader [" + this.shader.label + "] to WebGPU: [" + err.message + "]", {
					processed: src,
					original: originalSrc,
					shader: this.shader
				});
			}
		};
		_proto.loseContext = function loseContext() {};
		_proto.restoreContext = function restoreContext(device, shader) {};
		_createClass(WebgpuShader, [{
			key: "vertexCode",
			get: function get() {
				return this._vertexCode;
			}
		}, {
			key: "fragmentCode",
			get: function get() {
				return this._fragmentCode;
			}
		}]);
		return WebgpuShader;
	}();

	var TextureUtils = function () {
		function TextureUtils() {}
		TextureUtils.calcLevelDimension = function calcLevelDimension(dimension, mipLevel) {
			return Math.max(dimension >> mipLevel, 1);
		};
		TextureUtils.calcLevelGpuSize = function calcLevelGpuSize(width, height, depth, format) {
			var _pixelFormatInfo$get$, _pixelFormatInfo$get, _formatInfo$blockSize;
			var formatInfo = pixelFormatInfo.get(format);
			var pixelSize = (_pixelFormatInfo$get$ = (_pixelFormatInfo$get = pixelFormatInfo.get(format)) == null ? void 0 : _pixelFormatInfo$get.size) != null ? _pixelFormatInfo$get$ : 0;
			if (pixelSize > 0) {
				return width * height * depth * pixelSize;
			}
			var blockSize = (_formatInfo$blockSize = formatInfo.blockSize) != null ? _formatInfo$blockSize : 0;
			var blockWidth = Math.floor((width + 3) / 4);
			var blockHeight = Math.floor((height + 3) / 4);
			var blockDepth = Math.floor((depth + 3) / 4);
			if (format === PIXELFORMAT_PVRTC_2BPP_RGB_1 || format === PIXELFORMAT_PVRTC_2BPP_RGBA_1) {
				blockWidth = Math.max(Math.floor(blockWidth / 2), 1);
			}
			return blockWidth * blockHeight * blockDepth * blockSize;
		};
		TextureUtils.calcGpuSize = function calcGpuSize(width, height, depth, format, mipmaps, cubemap) {
			var result = 0;
			while (1) {
				result += TextureUtils.calcLevelGpuSize(width, height, depth, format);
				if (!mipmaps || width === 1 && height === 1 && depth === 1) {
					break;
				}
				width = Math.max(width >> 1, 1);
				height = Math.max(height >> 1, 1);
				depth = Math.max(depth >> 1, 1);
			}
			return result * (cubemap ? 6 : 1);
		};
		return TextureUtils;
	}();

	var gpuTextureFormats = [];
	gpuTextureFormats[PIXELFORMAT_A8] = '';
	gpuTextureFormats[PIXELFORMAT_L8] = 'r8unorm';
	gpuTextureFormats[PIXELFORMAT_LA8] = 'rg8unorm';
	gpuTextureFormats[PIXELFORMAT_RGB565] = '';
	gpuTextureFormats[PIXELFORMAT_RGBA5551] = '';
	gpuTextureFormats[PIXELFORMAT_RGBA4] = '';
	gpuTextureFormats[PIXELFORMAT_RGB8] = 'rgba8unorm';
	gpuTextureFormats[PIXELFORMAT_RGBA8] = 'rgba8unorm';
	gpuTextureFormats[PIXELFORMAT_DXT1] = 'bc1-rgba-unorm';
	gpuTextureFormats[PIXELFORMAT_DXT3] = 'bc2-rgba-unorm';
	gpuTextureFormats[PIXELFORMAT_DXT5] = 'bc3-rgba-unorm';
	gpuTextureFormats[PIXELFORMAT_RGB16F] = '';
	gpuTextureFormats[PIXELFORMAT_RGBA16F] = 'rgba16float';
	gpuTextureFormats[PIXELFORMAT_RGB32F] = '';
	gpuTextureFormats[PIXELFORMAT_RGBA32F] = 'rgba32float';
	gpuTextureFormats[PIXELFORMAT_R32F] = 'r32float';
	gpuTextureFormats[PIXELFORMAT_DEPTH] = 'depth32float';
	gpuTextureFormats[PIXELFORMAT_DEPTHSTENCIL] = 'depth24plus-stencil8';
	gpuTextureFormats[PIXELFORMAT_111110F] = 'rg11b10ufloat';
	gpuTextureFormats[PIXELFORMAT_SRGB] = '';
	gpuTextureFormats[PIXELFORMAT_SRGBA] = '';
	gpuTextureFormats[PIXELFORMAT_ETC1] = '';
	gpuTextureFormats[PIXELFORMAT_ETC2_RGB] = 'etc2-rgb8unorm';
	gpuTextureFormats[PIXELFORMAT_ETC2_RGBA] = 'etc2-rgba8unorm';
	gpuTextureFormats[PIXELFORMAT_PVRTC_2BPP_RGB_1] = '';
	gpuTextureFormats[PIXELFORMAT_PVRTC_2BPP_RGBA_1] = '';
	gpuTextureFormats[PIXELFORMAT_PVRTC_4BPP_RGB_1] = '';
	gpuTextureFormats[PIXELFORMAT_PVRTC_4BPP_RGBA_1] = '';
	gpuTextureFormats[PIXELFORMAT_ASTC_4x4] = 'astc-4x4-unorm';
	gpuTextureFormats[PIXELFORMAT_ATC_RGB] = '';
	gpuTextureFormats[PIXELFORMAT_ATC_RGBA] = '';
	gpuTextureFormats[PIXELFORMAT_BGRA8] = 'bgra8unorm';
	var gpuAddressModes = [];
	gpuAddressModes[ADDRESS_REPEAT] = 'repeat';
	gpuAddressModes[ADDRESS_CLAMP_TO_EDGE] = 'clamp-to-edge';
	gpuAddressModes[ADDRESS_MIRRORED_REPEAT] = 'mirror-repeat';
	var gpuFilterModes = [];
	gpuFilterModes[FILTER_NEAREST] = {
		level: 'nearest',
		mip: 'nearest'
	};
	gpuFilterModes[FILTER_LINEAR] = {
		level: 'linear',
		mip: 'nearest'
	};
	gpuFilterModes[FILTER_NEAREST_MIPMAP_NEAREST] = {
		level: 'nearest',
		mip: 'nearest'
	};
	gpuFilterModes[FILTER_NEAREST_MIPMAP_LINEAR] = {
		level: 'nearest',
		mip: 'linear'
	};
	gpuFilterModes[FILTER_LINEAR_MIPMAP_NEAREST] = {
		level: 'linear',
		mip: 'nearest'
	};
	gpuFilterModes[FILTER_LINEAR_MIPMAP_LINEAR] = {
		level: 'linear',
		mip: 'linear'
	};
	var WebgpuTexture = function () {
		function WebgpuTexture(texture) {
			this.gpuTexture = void 0;
			this.view = void 0;
			this.samplers = [];
			this.descr = void 0;
			this.format = void 0;
			this.texture = texture;
			this.format = gpuTextureFormats[texture.format];
			this.create(texture.device);
		}
		var _proto = WebgpuTexture.prototype;
		_proto.create = function create(device) {
			var texture = this.texture;
			var wgpu = device.wgpu;
			var mipLevelCount = texture.requiredMipLevels;
			this.descr = {
				size: {
					width: texture.width,
					height: texture.height,
					depthOrArrayLayers: texture.cubemap ? 6 : 1
				},
				format: this.format,
				mipLevelCount: mipLevelCount,
				sampleCount: 1,
				dimension: texture.volume ? '3d' : '2d',
				usage: GPUTextureUsage.TEXTURE_BINDING | GPUTextureUsage.COPY_DST | GPUTextureUsage.RENDER_ATTACHMENT | GPUTextureUsage.COPY_SRC
			};
			this.gpuTexture = wgpu.createTexture(this.descr);
			var viewDescr;
			if (this.texture.format === PIXELFORMAT_DEPTHSTENCIL) {
				viewDescr = {
					format: 'depth24plus',
					aspect: 'depth-only'
				};
			}
			this.view = this.createView(viewDescr);
		};
		_proto.destroy = function destroy(device) {};
		_proto.propertyChanged = function propertyChanged(flag) {
			this.samplers.length = 0;
		};
		_proto.getView = function getView(device) {
			this.uploadImmediate(device, this.texture);
			return this.view;
		};
		_proto.createView = function createView(viewDescr) {
			var _options$format, _options$dimension, _options$aspect, _options$baseMipLevel, _options$mipLevelCoun, _options$baseArrayLay, _options$arrayLayerCo;
			var options = viewDescr != null ? viewDescr : {};
			var textureDescr = this.descr;
			var texture = this.texture;
			var defaultViewDimension = function defaultViewDimension() {
				if (texture.cubemap) return 'cube';
				if (texture.volume) return '3d';
				return '2d';
			};
			var descr = {
				format: (_options$format = options.format) != null ? _options$format : textureDescr.format,
				dimension: (_options$dimension = options.dimension) != null ? _options$dimension : defaultViewDimension(),
				aspect: (_options$aspect = options.aspect) != null ? _options$aspect : 'all',
				baseMipLevel: (_options$baseMipLevel = options.baseMipLevel) != null ? _options$baseMipLevel : 0,
				mipLevelCount: (_options$mipLevelCoun = options.mipLevelCount) != null ? _options$mipLevelCoun : textureDescr.mipLevelCount,
				baseArrayLayer: (_options$baseArrayLay = options.baseArrayLayer) != null ? _options$baseArrayLay : 0,
				arrayLayerCount: (_options$arrayLayerCo = options.arrayLayerCount) != null ? _options$arrayLayerCo : textureDescr.depthOrArrayLayers
			};
			var view = this.gpuTexture.createView(descr);
			return view;
		};
		_proto.getSampler = function getSampler(device, sampleType) {
			var sampler = this.samplers[sampleType];
			if (!sampler) {
				var texture = this.texture;
				var descr = {
					addressModeU: gpuAddressModes[texture.addressU],
					addressModeV: gpuAddressModes[texture.addressV],
					addressModeW: gpuAddressModes[texture.addressW],
					maxAnisotropy: math.clamp(Math.round(texture._anisotropy), 1, device.maxTextureAnisotropy)
				};
				if (!sampleType && texture.compareOnRead) {
					sampleType = SAMPLETYPE_DEPTH;
				}
				if (sampleType === SAMPLETYPE_DEPTH) {
					descr.compare = 'less';
					descr.magFilter = 'linear';
					descr.minFilter = 'linear';
				} else if (sampleType === SAMPLETYPE_UNFILTERABLE_FLOAT) {
					descr.magFilter = 'nearest';
					descr.minFilter = 'nearest';
					descr.mipmapFilter = 'nearest';
				} else {
					if (this.texture.format === PIXELFORMAT_RGBA32F || this.texture.format === PIXELFORMAT_DEPTHSTENCIL || this.texture.format === PIXELFORMAT_RGBA16F) {
						descr.magFilter = 'nearest';
						descr.minFilter = 'nearest';
						descr.mipmapFilter = 'nearest';
					} else {
						descr.magFilter = gpuFilterModes[texture.magFilter].level;
						descr.minFilter = gpuFilterModes[texture.minFilter].level;
						descr.mipmapFilter = gpuFilterModes[texture.minFilter].mip;
					}
				}
				sampler = device.wgpu.createSampler(descr);
				this.samplers[sampleType] = sampler;
			}
			return sampler;
		};
		_proto.loseContext = function loseContext() {};
		_proto.uploadImmediate = function uploadImmediate(device, texture) {
			if (texture._needsUpload || texture._needsMipmapsUpload) {
				this.uploadData(device);
				texture._needsUpload = false;
				texture._needsMipmapsUpload = false;
			}
		};
		_proto.uploadData = function uploadData(device) {
			var texture = this.texture;
			if (texture._levels) {
				var anyUploads = false;
				var requiredMipLevels = texture.requiredMipLevels;
				for (var mipLevel = 0; mipLevel < requiredMipLevels; mipLevel++) {
					var mipObject = texture._levels[mipLevel];
					if (mipObject) {
						if (texture.cubemap) {
							for (var face = 0; face < 6; face++) {
								var faceSource = mipObject[face];
								if (faceSource) {
									if (this.isExternalImage(faceSource)) {
										this.uploadExternalImage(device, faceSource, mipLevel, face);
										anyUploads = true;
									} else if (ArrayBuffer.isView(faceSource)) {
										this.uploadTypedArrayData(device, faceSource, mipLevel, face);
										anyUploads = true;
									} else ;
								}
							}
						} else if (texture._volume) ; else {
							if (this.isExternalImage(mipObject)) {
								this.uploadExternalImage(device, mipObject, mipLevel, 0);
								anyUploads = true;
							} else if (ArrayBuffer.isView(mipObject)) {
								this.uploadTypedArrayData(device, mipObject, mipLevel, 0);
								anyUploads = true;
							} else ;
						}
					}
				}
				if (anyUploads && texture.mipmaps) {
					device.mipmapRenderer.generate(this);
				}
			}
		};
		_proto.isExternalImage = function isExternalImage(image) {
			return image instanceof ImageBitmap || image instanceof HTMLVideoElement || image instanceof HTMLCanvasElement || image instanceof OffscreenCanvas;
		};
		_proto.uploadExternalImage = function uploadExternalImage(device, image, mipLevel, face) {
			var src = {
				source: image,
				origin: [0, 0],
				flipY: false
			};
			var dst = {
				texture: this.gpuTexture,
				mipLevel: mipLevel,
				origin: [0, 0, face],
				aspect: 'all'
			};
			var copySize = {
				width: this.descr.size.width,
				height: this.descr.size.height,
				depthOrArrayLayers: 1
			};
			device.submit();
			device.wgpu.queue.copyExternalImageToTexture(src, dst, copySize);
		};
		_proto.uploadTypedArrayData = function uploadTypedArrayData(device, data, mipLevel, face) {
			var _formatInfo$size;
			var texture = this.texture;
			var wgpu = device.wgpu;
			var dest = {
				texture: this.gpuTexture,
				origin: [0, 0, face],
				mipLevel: mipLevel
			};
			var width = TextureUtils.calcLevelDimension(texture.width, mipLevel);
			var height = TextureUtils.calcLevelDimension(texture.height, mipLevel);
			TextureUtils.calcLevelGpuSize(width, height, 1, texture.format);
			var formatInfo = pixelFormatInfo.get(texture.format);
			var pixelSize = (_formatInfo$size = formatInfo.size) != null ? _formatInfo$size : 0;
			var bytesPerRow = pixelSize * width;
			var dataLayout = {
				offset: 0,
				bytesPerRow: bytesPerRow,
				rowsPerImage: height
			};
			var size = {
				width: width,
				height: height,
				depthOrArrayLayers: 1
			};
			device.submit();
			wgpu.queue.writeTexture(dest, data, dataLayout, size);
		};
		return WebgpuTexture;
	}();

	var WebgpuUniformBuffer = function (_WebgpuBuffer) {
		_inheritsLoose(WebgpuUniformBuffer, _WebgpuBuffer);
		function WebgpuUniformBuffer(uniformBuffer) {
			return _WebgpuBuffer.call(this) || this;
		}
		var _proto = WebgpuUniformBuffer.prototype;
		_proto.destroy = function destroy(device) {
			_WebgpuBuffer.prototype.destroy.call(this, device);
		};
		_proto.unlock = function unlock(uniformBuffer) {
			var device = uniformBuffer.device;
			_WebgpuBuffer.prototype.unlock.call(this, device, undefined, GPUBufferUsage.UNIFORM, uniformBuffer.storage);
		};
		return WebgpuUniformBuffer;
	}(WebgpuBuffer);

	var WebgpuVertexBuffer = function (_WebgpuBuffer) {
		_inheritsLoose(WebgpuVertexBuffer, _WebgpuBuffer);
		function WebgpuVertexBuffer(vertexBuffer, format) {
			return _WebgpuBuffer.call(this) || this;
		}
		var _proto = WebgpuVertexBuffer.prototype;
		_proto.destroy = function destroy(device) {
			_WebgpuBuffer.prototype.destroy.call(this, device);
		};
		_proto.unlock = function unlock(vertexBuffer) {
			var device = vertexBuffer.device;
			_WebgpuBuffer.prototype.unlock.call(this, device, vertexBuffer.usage, GPUBufferUsage.VERTEX, vertexBuffer.storage);
		};
		return WebgpuVertexBuffer;
	}(WebgpuBuffer);

	var KEYWORD = /[ \t]*#(ifn?def|if|endif|else|elif|define|undef|extension)/g;
	var DEFINE = /define[ \t]+([^\n]+)\r?(?:\n|$)/g;
	var EXTENSION = /extension[ \t]+([\w-]+)[ \t]*:[ \t]*(enable|require)/g;
	var UNDEF = /undef[ \t]+([^\n]+)\r?(?:\n|$)/g;
	var IF = /(ifdef|ifndef|if)[ \t]*([^\r\n]+)\r?\n/g;
	var ENDIF = /(endif|else|elif)([ \t]+[^\r\n]+)?\r?(?:\n|$)/g;
	var IDENTIFIER$1 = /([\w-]+)/;
	var DEFINED = /(!|\s)?defined\(([\w-]+)\)/;
	var INVALID = /[><=|&+-]/g;
	var Preprocessor = function () {
		function Preprocessor() {}
		Preprocessor.run = function run(source, stripUnusedColorAttachments) {
			if (stripUnusedColorAttachments === void 0) {
				stripUnusedColorAttachments = false;
			}
			source = source.replace(/\/\*[\s\S]*?\*\/|([^\\:]|^)\/\/.*$/gm, '$1');
			source = source.split(/\r?\n/).map(function (line) {
				return line.trimEnd();
			}).join('\n');
			var defines = new Map();
			if (stripUnusedColorAttachments) {
				var counts = new Map();
				var regex = /(pcFragColor[1-8])\b/g;
				var matches = source.match(regex);
				matches == null ? void 0 : matches.forEach(function (match) {
					var _counts$get;
					var index = parseInt(match.charAt(match.length - 1), 10);
					counts.set(index, ((_counts$get = counts.get(index)) != null ? _counts$get : 0) + 1);
				});
				counts.forEach(function (count, index) {
					if (count === 1) {
						defines.set("REMOVE_COLOR_ATTACHMENT_" + index, '');
					}
				});
			}
			source = this._preprocess(source, defines);
			var intDefines = new Map();
			defines.forEach(function (value, key) {
				if (Number.isInteger(parseFloat(value)) && !value.includes('.')) {
					intDefines.set(key, value);
				}
			});
			if (source !== null) {
				source = source.split(/\r?\n/).map(function (line) {
					return line.trim() === '' ? '' : line;
				}).map(function (line) {
					intDefines.forEach(function (value, key) {
						line = line.replace(new RegExp("\\[" + key + "\\]", 'g'), "[" + value + "]");
					});
					return line;
				}).join('\n');
				source = source.replace(/(\n\n){3,}/gm, '\n\n');
			}
			return source;
		};
		Preprocessor._preprocess = function _preprocess(source, defines) {
			if (defines === void 0) {
				defines = new Map();
			}
			var originalSource = source;
			var stack = [];
			var error = false;
			var match;
			while ((match = KEYWORD.exec(source)) !== null) {
				var keyword = match[1];
				switch (keyword) {
					case 'define':
						{
							DEFINE.lastIndex = match.index;
							var define = DEFINE.exec(source);
							error || (error = define === null);
							var expression = define[1];
							IDENTIFIER$1.lastIndex = define.index;
							var identifierValue = IDENTIFIER$1.exec(expression);
							var identifier = identifierValue[1];
							var value = expression.substring(identifier.length).trim();
							if (value === "") value = "true";
							var keep = Preprocessor._keep(stack);
							if (keep) {
								defines.set(identifier, value);
							}
							KEYWORD.lastIndex = define.index + define[0].length;
							break;
						}
					case 'undef':
						{
							UNDEF.lastIndex = match.index;
							var undef = UNDEF.exec(source);
							var _identifier = undef[1].trim();
							var _keep2 = Preprocessor._keep(stack);
							if (_keep2) {
								defines.delete(_identifier);
							}
							KEYWORD.lastIndex = undef.index + undef[0].length;
							break;
						}
					case 'extension':
						{
							EXTENSION.lastIndex = match.index;
							var extension = EXTENSION.exec(source);
							error || (error = extension === null);
							if (extension) {
								var _identifier2 = extension[1];
								var _keep3 = Preprocessor._keep(stack);
								if (_keep3) {
									defines.set(_identifier2, "true");
								}
							}
							KEYWORD.lastIndex = extension.index + extension[0].length;
							break;
						}
					case 'ifdef':
					case 'ifndef':
					case 'if':
						{
							IF.lastIndex = match.index;
							var iff = IF.exec(source);
							var _expression = iff[2];
							var evaluated = Preprocessor.evaluate(_expression, defines);
							error || (error = evaluated.error);
							var result = evaluated.result;
							if (keyword === 'ifndef') {
								result = !result;
							}
							stack.push({
								anyKeep: result,
								keep: result,
								start: match.index,
								end: IF.lastIndex
							});
							KEYWORD.lastIndex = iff.index + iff[0].length;
							break;
						}
					case 'endif':
					case 'else':
					case 'elif':
						{
							ENDIF.lastIndex = match.index;
							var endif = ENDIF.exec(source);
							var blockInfo = stack.pop();
							var blockCode = blockInfo.keep ? source.substring(blockInfo.end, match.index) : "";
							source = source.substring(0, blockInfo.start) + blockCode + source.substring(ENDIF.lastIndex);
							KEYWORD.lastIndex = blockInfo.start + blockCode.length;
							var endifCommand = endif[1];
							if (endifCommand === 'else' || endifCommand === 'elif') {
								var _result = false;
								if (!blockInfo.anyKeep) {
									if (endifCommand === 'else') {
										_result = !blockInfo.keep;
									} else {
										var _evaluated = Preprocessor.evaluate(endif[2], defines);
										_result = _evaluated.result;
										error || (error = _evaluated.error);
									}
								}
								stack.push({
									anyKeep: blockInfo.anyKeep || _result,
									keep: _result,
									start: KEYWORD.lastIndex,
									end: KEYWORD.lastIndex
								});
							}
							break;
						}
				}
			}
			if (error) {
				console.warn("Failed to preprocess shader: ", {
					source: originalSource
				});
				return originalSource;
			}
			return source;
		};
		Preprocessor._keep = function _keep(stack) {
			for (var i = 0; i < stack.length; i++) {
				if (!stack[i].keep) return false;
			}
			return true;
		};
		Preprocessor.evaluate = function evaluate(expression, defines) {
			var correct = INVALID.exec(expression) === null;
			var invert = false;
			var defined = DEFINED.exec(expression);
			if (defined) {
				invert = defined[1] === '!';
				expression = defined[2];
			}
			expression = expression.trim();
			var exists = defines.has(expression);
			if (invert) {
				exists = !exists;
			}
			return {
				result: exists,
				error: !correct
			};
		};
		return Preprocessor;
	}();

	var id$6 = 0;
	var Shader = function () {
		function Shader(graphicsDevice, definition) {
			this.meshUniformBufferFormat = void 0;
			this.meshBindGroupFormat = void 0;
			this.id = id$6++;
			this.device = graphicsDevice;
			this.definition = definition;
			this.name = definition.name || 'Untitled';
			definition.vshader = Preprocessor.run(definition.vshader);
			definition.fshader = Preprocessor.run(definition.fshader, graphicsDevice.webgl2);
			this.init();
			this.impl = graphicsDevice.createShaderImpl(this);
		}
		var _proto = Shader.prototype;
		_proto.init = function init() {
			this.ready = false;
			this.failed = false;
		};
		_proto.destroy = function destroy() {
			this.device.onDestroyShader(this);
			this.impl.destroy(this);
		};
		_proto.loseContext = function loseContext() {
			this.init();
			this.impl.loseContext();
		};
		_proto.restoreContext = function restoreContext() {
			this.impl.restoreContext(this.device, this);
		};
		_createClass(Shader, [{
			key: "label",
			get: function get() {
				return "Shader Id " + this.id + " " + this.name;
			}
		}]);
		return Shader;
	}();

	var id$5 = 0;
	var BindGroup = function () {
		function BindGroup(graphicsDevice, format, defaultUniformBuffer) {
			this.renderVersionUpdated = -1;
			this.uniformBuffers = void 0;
			this.uniformBufferOffsets = [];
			this.id = id$5++;
			this.device = graphicsDevice;
			this.format = format;
			this.dirty = true;
			this.impl = graphicsDevice.createBindGroupImpl(this);
			this.textures = [];
			this.uniformBuffers = [];
			this.defaultUniformBuffer = defaultUniformBuffer;
			if (defaultUniformBuffer) {
				this.setUniformBuffer(UNIFORM_BUFFER_DEFAULT_SLOT_NAME, defaultUniformBuffer);
			}
		}
		var _proto = BindGroup.prototype;
		_proto.destroy = function destroy() {
			this.impl.destroy();
			this.impl = null;
			this.format = null;
			this.defaultUniformBuffer = null;
		};
		_proto.setUniformBuffer = function setUniformBuffer(name, uniformBuffer) {
			var index = this.format.bufferFormatsMap.get(name);
			if (this.uniformBuffers[index] !== uniformBuffer) {
				this.uniformBuffers[index] = uniformBuffer;
				this.dirty = true;
			}
		};
		_proto.setTexture = function setTexture(name, texture) {
			var index = this.format.textureFormatsMap.get(name);
			if (this.textures[index] !== texture) {
				this.textures[index] = texture;
				this.dirty = true;
			} else if (this.renderVersionUpdated < texture.renderVersionDirty) {
				this.dirty = true;
			}
		};
		_proto.update = function update() {
			var textureFormats = this.format.textureFormats;
			for (var i = 0; i < textureFormats.length; i++) {
				var textureFormat = textureFormats[i];
				var value = textureFormat.scopeId.value;
				this.setTexture(textureFormat.name, value);
			}
			this.uniformBufferOffsets.length = this.uniformBuffers.length;
			for (var _i = 0; _i < this.uniformBuffers.length; _i++) {
				var uniformBuffer = this.uniformBuffers[_i];
				this.uniformBufferOffsets[_i] = uniformBuffer.offset;
				if (this.renderVersionUpdated < uniformBuffer.renderVersionDirty) {
					this.dirty = true;
				}
			}
			if (this.dirty) {
				this.dirty = false;
				this.renderVersionUpdated = this.device.renderVersion;
				this.impl.update(this);
			}
		};
		return BindGroup;
	}();

	var DynamicBuffer = function DynamicBuffer(device) {
		this.device = void 0;
		this.device = device;
	};
	var UsedBuffer = function UsedBuffer() {
		this.gpuBuffer = void 0;
		this.stagingBuffer = void 0;
		this.offset = void 0;
		this.size = void 0;
	};
	var DynamicBufferAllocation = function DynamicBufferAllocation() {
		this.storage = void 0;
		this.gpuBuffer = void 0;
		this.offset = void 0;
	};
	var DynamicBuffers = function () {
		function DynamicBuffers(device, bufferSize, bufferAlignment) {
			this.bufferSize = void 0;
			this.gpuBuffers = [];
			this.stagingBuffers = [];
			this.usedBuffers = [];
			this.activeBuffer = null;
			this.device = device;
			this.bufferSize = bufferSize;
			this.bufferAlignment = bufferAlignment;
		}
		var _proto = DynamicBuffers.prototype;
		_proto.destroy = function destroy() {
			var _this = this;
			this.gpuBuffers.forEach(function (gpuBuffer) {
				gpuBuffer.destroy(_this.device);
			});
			this.gpuBuffers = null;
			this.stagingBuffers.forEach(function (stagingBuffer) {
				stagingBuffer.destroy(_this.device);
			});
			this.stagingBuffers = null;
			this.usedBuffers = null;
			this.activeBuffer = null;
		};
		_proto.alloc = function alloc(allocation, size) {
			if (this.activeBuffer) {
				var _alignedStart = math.roundUp(this.activeBuffer.size, this.bufferAlignment);
				var space = this.bufferSize - _alignedStart;
				if (space < size) {
					this.scheduleSubmit();
				}
			}
			if (!this.activeBuffer) {
				var gpuBuffer = this.gpuBuffers.pop();
				if (!gpuBuffer) {
					gpuBuffer = this.createBuffer(this.device, this.bufferSize, false);
				}
				var stagingBuffer = this.stagingBuffers.pop();
				if (!stagingBuffer) {
					stagingBuffer = this.createBuffer(this.device, this.bufferSize, true);
				}
				this.activeBuffer = new UsedBuffer();
				this.activeBuffer.stagingBuffer = stagingBuffer;
				this.activeBuffer.gpuBuffer = gpuBuffer;
				this.activeBuffer.offset = 0;
				this.activeBuffer.size = 0;
			}
			var activeBuffer = this.activeBuffer;
			var alignedStart = math.roundUp(activeBuffer.size, this.bufferAlignment);
			allocation.gpuBuffer = activeBuffer.gpuBuffer;
			allocation.offset = alignedStart;
			allocation.storage = activeBuffer.stagingBuffer.alloc(alignedStart, size);
			activeBuffer.size = alignedStart + size;
		};
		_proto.scheduleSubmit = function scheduleSubmit() {
			if (this.activeBuffer) {
				this.usedBuffers.push(this.activeBuffer);
				this.activeBuffer = null;
			}
		};
		_proto.submit = function submit() {
			this.scheduleSubmit();
		};
		return DynamicBuffers;
	}();

	var _updateFunctions = [];
	_updateFunctions[UNIFORMTYPE_FLOAT] = function (uniformBuffer, value, offset) {
		var dst = uniformBuffer.storageFloat32;
		dst[offset] = value;
	};
	_updateFunctions[UNIFORMTYPE_VEC2] = function (uniformBuffer, value, offset) {
		var dst = uniformBuffer.storageFloat32;
		dst[offset] = value[0];
		dst[offset + 1] = value[1];
	};
	_updateFunctions[UNIFORMTYPE_VEC3] = function (uniformBuffer, value, offset) {
		var dst = uniformBuffer.storageFloat32;
		dst[offset] = value[0];
		dst[offset + 1] = value[1];
		dst[offset + 2] = value[2];
	};
	_updateFunctions[UNIFORMTYPE_VEC4] = function (uniformBuffer, value, offset) {
		var dst = uniformBuffer.storageFloat32;
		dst[offset] = value[0];
		dst[offset + 1] = value[1];
		dst[offset + 2] = value[2];
		dst[offset + 3] = value[3];
	};
	_updateFunctions[UNIFORMTYPE_INT] = function (uniformBuffer, value, offset) {
		var dst = uniformBuffer.storageInt32;
		dst[offset] = value;
	};
	_updateFunctions[UNIFORMTYPE_IVEC2] = function (uniformBuffer, value, offset) {
		var dst = uniformBuffer.storageInt32;
		dst[offset] = value[0];
		dst[offset + 1] = value[1];
	};
	_updateFunctions[UNIFORMTYPE_IVEC3] = function (uniformBuffer, value, offset) {
		var dst = uniformBuffer.storageInt32;
		dst[offset] = value[0];
		dst[offset + 1] = value[1];
		dst[offset + 2] = value[2];
	};
	_updateFunctions[UNIFORMTYPE_IVEC4] = function (uniformBuffer, value, offset) {
		var dst = uniformBuffer.storageInt32;
		dst[offset] = value[0];
		dst[offset + 1] = value[1];
		dst[offset + 2] = value[2];
		dst[offset + 3] = value[3];
	};
	_updateFunctions[UNIFORMTYPE_MAT2] = function (uniformBuffer, value, offset) {
		var dst = uniformBuffer.storageFloat32;
		dst[offset] = value[0];
		dst[offset + 1] = value[1];
		dst[offset + 4] = value[2];
		dst[offset + 5] = value[3];
		dst[offset + 8] = value[4];
		dst[offset + 9] = value[5];
	};
	_updateFunctions[UNIFORMTYPE_MAT3] = function (uniformBuffer, value, offset) {
		var dst = uniformBuffer.storageFloat32;
		dst[offset] = value[0];
		dst[offset + 1] = value[1];
		dst[offset + 2] = value[2];
		dst[offset + 4] = value[3];
		dst[offset + 5] = value[4];
		dst[offset + 6] = value[5];
		dst[offset + 8] = value[6];
		dst[offset + 9] = value[7];
		dst[offset + 10] = value[8];
	};
	_updateFunctions[UNIFORMTYPE_FLOATARRAY] = function (uniformBuffer, value, offset, count) {
		var dst = uniformBuffer.storageFloat32;
		for (var i = 0; i < count; i++) {
			dst[offset + i * 4] = value[i];
		}
	};
	_updateFunctions[UNIFORMTYPE_VEC2ARRAY] = function (uniformBuffer, value, offset, count) {
		var dst = uniformBuffer.storageFloat32;
		for (var i = 0; i < count; i++) {
			dst[offset + i * 4] = value[i * 2];
			dst[offset + i * 4 + 1] = value[i * 2 + 1];
		}
	};
	_updateFunctions[UNIFORMTYPE_VEC3ARRAY] = function (uniformBuffer, value, offset, count) {
		var dst = uniformBuffer.storageFloat32;
		for (var i = 0; i < count; i++) {
			dst[offset + i * 4] = value[i * 3];
			dst[offset + i * 4 + 1] = value[i * 3 + 1];
			dst[offset + i * 4 + 2] = value[i * 3 + 2];
		}
	};
	var UniformBuffer = function () {
		function UniformBuffer(graphicsDevice, format, persistent) {
			if (persistent === void 0) {
				persistent = true;
			}
			this.device = void 0;
			this.persistent = void 0;
			this.allocation = void 0;
			this.storageFloat32 = void 0;
			this.storageInt32 = void 0;
			this.renderVersionDirty = 0;
			this.device = graphicsDevice;
			this.format = format;
			this.persistent = persistent;
			if (persistent) {
				this.impl = graphicsDevice.createUniformBufferImpl(this);
				var storage = new ArrayBuffer(format.byteSize);
				this.assignStorage(new Int32Array(storage));
				graphicsDevice._vram.ub += this.format.byteSize;
			} else {
				this.allocation = new DynamicBufferAllocation();
			}
		}
		var _proto = UniformBuffer.prototype;
		_proto.destroy = function destroy() {
			if (this.persistent) {
				var device = this.device;
				this.impl.destroy(device);
				device._vram.ub -= this.format.byteSize;
			}
		};
		_proto.assignStorage = function assignStorage(storage) {
			this.storageInt32 = storage;
			this.storageFloat32 = new Float32Array(storage.buffer, storage.byteOffset, storage.byteLength / 4);
		};
		_proto.loseContext = function loseContext() {
			var _this$impl;
			(_this$impl = this.impl) == null ? void 0 : _this$impl.loseContext();
		};
		_proto.setUniform = function setUniform(uniformFormat) {
			var offset = uniformFormat.offset;
			var value = uniformFormat.scopeId.value;
			if (value !== null && value !== undefined) {
				var updateFunction = _updateFunctions[uniformFormat.updateType];
				if (updateFunction) {
					updateFunction(this, value, offset, uniformFormat.count);
				} else {
					this.storageFloat32.set(value, offset);
				}
			}
		};
		_proto.set = function set(name) {
			var uniformFormat = this.format.map.get(name);
			if (uniformFormat) {
				this.setUniform(uniformFormat);
			}
		};
		_proto.update = function update() {
			var persistent = this.persistent;
			if (!persistent) {
				var allocation = this.allocation;
				var oldGpuBuffer = allocation.gpuBuffer;
				this.device.dynamicBuffers.alloc(allocation, this.format.byteSize);
				this.assignStorage(allocation.storage);
				if (oldGpuBuffer !== allocation.gpuBuffer) {
					this.renderVersionDirty = this.device.renderVersion;
				}
			}
			var uniforms = this.format.uniforms;
			for (var i = 0; i < uniforms.length; i++) {
				this.setUniform(uniforms[i]);
			}
			if (persistent) {
				this.impl.unlock(this);
			} else {
				this.storageFloat32 = null;
				this.storageInt32 = null;
			}
		};
		_createClass(UniformBuffer, [{
			key: "offset",
			get: function get() {
				return this.persistent ? 0 : this.allocation.offset;
			}
		}]);
		return UniformBuffer;
	}();

	var primitive = {
		type: PRIMITIVE_TRISTRIP,
		base: 0,
		count: 4,
		indexed: false
	};
	var WebgpuClearRenderer = function () {
		function WebgpuClearRenderer(device) {
			var code = "\n\n            struct ub_mesh {\n                color : vec4f,\n                depth: f32\n            }\n\n            @group(0) @binding(0) var<uniform> ubMesh : ub_mesh;\n\n            var<private> pos : array<vec2f, 4> = array<vec2f, 4>(\n                vec2(-1.0, 1.0), vec2(1.0, 1.0),\n                vec2(-1.0, -1.0), vec2(1.0, -1.0)\n            );\n\n            struct VertexOutput {\n                @builtin(position) position : vec4f\n            }\n\n            @vertex\n            fn vertexMain(@builtin(vertex_index) vertexIndex : u32) -> VertexOutput {\n                var output : VertexOutput;\n                output.position = vec4(pos[vertexIndex], ubMesh.depth, 1.0);\n                return output;\n            }\n\n            @fragment\n            fn fragmentMain() -> @location(0) vec4f {\n                return ubMesh.color;\n            }\n        ";
			this.shader = new Shader(device, {
				name: 'WebGPUClearRendererShader',
				shaderLanguage: SHADERLANGUAGE_WGSL,
				vshader: code,
				fshader: code
			});
			this.uniformBuffer = new UniformBuffer(device, new UniformBufferFormat(device, [new UniformFormat('color', UNIFORMTYPE_VEC4), new UniformFormat('depth', UNIFORMTYPE_FLOAT)]), false);
			var bindGroupFormat = new BindGroupFormat(device, [new BindBufferFormat(UNIFORM_BUFFER_DEFAULT_SLOT_NAME, SHADERSTAGE_VERTEX | SHADERSTAGE_FRAGMENT)]);
			this.bindGroup = new BindGroup(device, bindGroupFormat, this.uniformBuffer);
			this.colorData = new Float32Array(4);
			this.colorId = device.scope.resolve('color');
			this.depthId = device.scope.resolve('depth');
		}
		var _proto = WebgpuClearRenderer.prototype;
		_proto.destroy = function destroy() {
			this.shader.destroy();
			this.shader = null;
			this.uniformBuffer.destroy();
			this.uniformBuffer = null;
			this.bindGroup.destroy();
			this.bindGroup = null;
		};
		_proto.clear = function clear(device, renderTarget, options, defaultOptions) {
			var _options$flags;
			options = options || defaultOptions;
			var flags = (_options$flags = options.flags) != null ? _options$flags : defaultOptions.flags;
			if (flags !== 0) {
				if (flags & CLEARFLAG_COLOR && renderTarget.colorBuffer) {
					var _options$color;
					var color = (_options$color = options.color) != null ? _options$color : defaultOptions.color;
					this.colorData.set(color);
					device.setBlendState(BlendState.NOBLEND);
				} else {
					device.setBlendState(BlendState.NOWRITE);
				}
				this.colorId.setValue(this.colorData);
				if (flags & CLEARFLAG_DEPTH && renderTarget.depth) {
					var _options$depth;
					var depth = (_options$depth = options.depth) != null ? _options$depth : defaultOptions.depth;
					this.depthId.setValue(depth);
					device.setDepthState(DepthState.WRITEDEPTH);
				} else {
					this.depthId.setValue(1);
					device.setDepthState(DepthState.NODEPTH);
				}
				if (flags & CLEARFLAG_STENCIL && renderTarget.stencil) ;
				device.setCullMode(CULLFACE_NONE);
				device.setShader(this.shader);
				var bindGroup = this.bindGroup;
				bindGroup.defaultUniformBuffer.update();
				bindGroup.update();
				device.setBindGroup(BINDGROUP_MESH, bindGroup);
				device.draw(primitive);
			}
		};
		return WebgpuClearRenderer;
	}();

	var WebgpuMipmapRenderer = function () {
		function WebgpuMipmapRenderer(device) {
			this.device = void 0;
			this.device = device;
			var code = "\n \n            var<private> pos : array<vec2f, 4> = array<vec2f, 4>(\n                vec2(-1.0, 1.0), vec2(1.0, 1.0),\n                vec2(-1.0, -1.0), vec2(1.0, -1.0)\n            );\n\n            struct VertexOutput {\n                @builtin(position) position : vec4f,\n                @location(0) texCoord : vec2f\n            };\n\n            @vertex\n            fn vertexMain(@builtin(vertex_index) vertexIndex : u32) -> VertexOutput {\n              var output : VertexOutput;\n              output.texCoord = pos[vertexIndex] * vec2f(0.5, -0.5) + vec2f(0.5);\n              output.position = vec4f(pos[vertexIndex], 0, 1);\n              return output;\n            }\n\n            @group(0) @binding(0) var imgSampler : sampler;\n            @group(0) @binding(1) var img : texture_2d<f32>;\n\n            @fragment\n            fn fragmentMain(@location(0) texCoord : vec2f) -> @location(0) vec4f {\n              return textureSample(img, imgSampler, texCoord);\n            }\n        ";
			this.shader = new Shader(device, {
				name: 'WebGPUMipmapRendererShader',
				shaderLanguage: SHADERLANGUAGE_WGSL,
				vshader: code,
				fshader: code
			});
			this.minSampler = device.wgpu.createSampler({
				minFilter: 'linear'
			});
		}
		var _proto = WebgpuMipmapRenderer.prototype;
		_proto.destroy = function destroy() {
			this.shader.destroy();
			this.shader = null;
		};
		_proto.generate = function generate(webgpuTexture) {
			var _device$commandEncode;
			var textureDescr = webgpuTexture.descr;
			if (textureDescr.mipLevelCount <= 1) {
				return;
			}
			if (webgpuTexture.texture.volume) {
				return;
			}
			var device = this.device;
			var wgpu = device.wgpu;
			var webgpuShader = this.shader.impl;
			var pipeline = wgpu.createRenderPipeline({
				layout: 'auto',
				vertex: {
					module: webgpuShader.getVertexShaderModule(),
					entryPoint: webgpuShader.vertexEntryPoint
				},
				fragment: {
					module: webgpuShader.getFragmentShaderModule(),
					entryPoint: webgpuShader.fragmentEntryPoint,
					targets: [{
						format: textureDescr.format
					}]
				},
				primitive: {
					topology: 'triangle-strip'
				}
			});
			var numFaces = webgpuTexture.texture.cubemap ? 6 : 1;
			var srcViews = [];
			for (var face = 0; face < numFaces; face++) {
				srcViews.push(webgpuTexture.createView({
					dimension: '2d',
					baseMipLevel: 0,
					mipLevelCount: 1,
					baseArrayLayer: face
				}));
			}
			var commandEncoder = (_device$commandEncode = device.commandEncoder) != null ? _device$commandEncode : wgpu.createCommandEncoder();
			for (var i = 1; i < textureDescr.mipLevelCount; i++) {
				for (var _face = 0; _face < numFaces; _face++) {
					var dstView = webgpuTexture.createView({
						dimension: '2d',
						baseMipLevel: i,
						mipLevelCount: 1,
						baseArrayLayer: _face
					});
					var passEncoder = commandEncoder.beginRenderPass({
						colorAttachments: [{
							view: dstView,
							loadOp: 'clear',
							storeOp: 'store'
						}]
					});
					var bindGroup = wgpu.createBindGroup({
						layout: pipeline.getBindGroupLayout(0),
						entries: [{
							binding: 0,
							resource: this.minSampler
						}, {
							binding: 1,
							resource: srcViews[_face]
						}]
					});
					passEncoder.setPipeline(pipeline);
					passEncoder.setBindGroup(0, bindGroup);
					passEncoder.draw(4);
					passEncoder.end();
					srcViews[_face] = dstView;
				}
			}
			if (!device.commandEncoder) {
				var cb = commandEncoder.finish();
				device.addCommandBuffer(cb);
			}
			device.pipeline = null;
		};
		return WebgpuMipmapRenderer;
	}();

	var WebgpuDynamicBuffer = function (_DynamicBuffer) {
		_inheritsLoose(WebgpuDynamicBuffer, _DynamicBuffer);
		function WebgpuDynamicBuffer(device, size, isStaging) {
			var _this;
			_this = _DynamicBuffer.call(this, device) || this;
			_this.buffer = null;
			_this.mappedRange = null;
			_this.buffer = device.wgpu.createBuffer({
				size: size,
				usage: isStaging ? GPUBufferUsage.MAP_WRITE | GPUBufferUsage.COPY_SRC : GPUBufferUsage.UNIFORM | GPUBufferUsage.COPY_DST,
				mappedAtCreation: isStaging
			});
			if (isStaging) {
				_this.onAvailable();
			}
			device._vram.ub += size;
			return _this;
		}
		var _proto = WebgpuDynamicBuffer.prototype;
		_proto.destroy = function destroy(device) {
			device._vram.ub -= this.buffer.size;
			this.buffer.destroy();
			this.buffer = null;
		};
		_proto.onAvailable = function onAvailable() {
			this.mappedRange = this.buffer.getMappedRange();
		};
		_proto.alloc = function alloc(offset, size) {
			return new Int32Array(this.mappedRange, offset, size / 4);
		};
		return WebgpuDynamicBuffer;
	}(DynamicBuffer);

	var WebgpuDynamicBuffers = function (_DynamicBuffers) {
		_inheritsLoose(WebgpuDynamicBuffers, _DynamicBuffers);
		function WebgpuDynamicBuffers() {
			var _this;
			for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
				args[_key] = arguments[_key];
			}
			_this = _DynamicBuffers.call.apply(_DynamicBuffers, [this].concat(args)) || this;
			_this.pendingStagingBuffers = [];
			return _this;
		}
		var _proto = WebgpuDynamicBuffers.prototype;
		_proto.createBuffer = function createBuffer(device, size, isStaging) {
			return new WebgpuDynamicBuffer(device, size, isStaging);
		};
		_proto.submit = function submit() {
			_DynamicBuffers.prototype.submit.call(this);
			var count = this.usedBuffers.length;
			if (count) {
				var device = this.device;
				var gpuBuffers = this.gpuBuffers;
				var commandEncoder = device.wgpu.createCommandEncoder();
				for (var i = count - 1; i >= 0; i--) {
					var usedBuffer = this.usedBuffers[i];
					var stagingBuffer = usedBuffer.stagingBuffer,
						gpuBuffer = usedBuffer.gpuBuffer,
						offset = usedBuffer.offset,
						size = usedBuffer.size;
					var src = stagingBuffer.buffer;
					src.unmap();
					commandEncoder.copyBufferToBuffer(src, offset, gpuBuffer.buffer, offset, size);
					gpuBuffers.push(gpuBuffer);
				}
				var cb = commandEncoder.finish();
				device.addCommandBuffer(cb, true);
				for (var _i = 0; _i < count; _i++) {
					var _stagingBuffer = this.usedBuffers[_i].stagingBuffer;
					this.pendingStagingBuffers.push(_stagingBuffer);
				}
				this.usedBuffers.length = 0;
			}
		};
		_proto.onCommandBuffersSubmitted = function onCommandBuffersSubmitted() {
			var _this2 = this;
			var count = this.pendingStagingBuffers.length;
			if (count) {
				var _loop = function _loop() {
					var stagingBuffer = _this2.pendingStagingBuffers[i];
					stagingBuffer.buffer.mapAsync(GPUMapMode.WRITE).then(function () {
						stagingBuffer.onAvailable();
						_this2.stagingBuffers.push(stagingBuffer);
					});
				};
				for (var i = 0; i < count; i++) {
					_loop();
				}
				this.pendingStagingBuffers.length = 0;
			}
		};
		return WebgpuDynamicBuffers;
	}(DynamicBuffers);

	var GpuProfiler = function () {
		function GpuProfiler() {
			this.frameAllocations = [];
			this.pastFrameAllocations = new Map();
			this._enabled = false;
			this._enableRequest = false;
			this._frameTime = 0;
		}
		var _proto = GpuProfiler.prototype;
		_proto.loseContext = function loseContext() {
			this.pastFrameAllocations.clear();
		};
		_proto.processEnableRequest = function processEnableRequest() {
			if (this._enableRequest !== this._enabled) {
				this._enabled = this._enableRequest;
				if (!this._enabled) {
					this._frameTime = 0;
				}
			}
		};
		_proto.request = function request(renderVersion) {
			this.pastFrameAllocations.set(renderVersion, this.frameAllocations);
			this.frameAllocations = [];
		};
		_proto.report = function report(renderVersion, timings) {
			if (timings) {
				var allocations = this.pastFrameAllocations.get(renderVersion);
				if (timings.length > 0) {
					this._frameTime = timings[0];
				}
				if (Tracing.get(TRACEID_GPU_TIMINGS)) {
					for (var i = 0; i < allocations.length; ++i) {
						allocations[i];
					}
				}
			}
			this.pastFrameAllocations.delete(renderVersion);
		};
		_proto.getSlot = function getSlot(name) {
			var slot = this.frameAllocations.length;
			this.frameAllocations.push(name);
			return slot;
		};
		_createClass(GpuProfiler, [{
			key: "enabled",
			get: function get() {
				return this._enableRequest;
			},
			set: function set(value) {
				this._enableRequest = value;
			}
		}, {
			key: "slotCount",
			get: function get() {
				return this.frameAllocations.length;
			}
		}]);
		return GpuProfiler;
	}();

	var WebgpuQuerySet = function () {
		function WebgpuQuerySet(device, isTimestamp, capacity) {
			this.querySet = void 0;
			this.stagingBuffers = [];
			this.activeStagingBuffer = null;
			this.bytesPerSlot = void 0;
			this.device = device;
			this.capacity = capacity;
			this.bytesPerSlot = isTimestamp ? 8 : 4;
			var wgpu = device.wgpu;
			this.querySet = wgpu.createQuerySet({
				type: isTimestamp ? 'timestamp' : 'occlusion',
				count: capacity
			});
			this.queryBuffer = wgpu.createBuffer({
				size: this.bytesPerSlot * capacity,
				usage: GPUBufferUsage.QUERY_RESOLVE | GPUBufferUsage.STORAGE | GPUBufferUsage.COPY_SRC | GPUBufferUsage.COPY_DST
			});
		}
		var _proto = WebgpuQuerySet.prototype;
		_proto.destroy = function destroy() {
			var _this$querySet, _this$queryBuffer;
			(_this$querySet = this.querySet) == null ? void 0 : _this$querySet.destroy();
			this.querySet = null;
			(_this$queryBuffer = this.queryBuffer) == null ? void 0 : _this$queryBuffer.destroy();
			this.queryBuffer = null;
			this.activeStagingBuffer = null;
			this.stagingBuffers.forEach(function (stagingBuffer) {
				stagingBuffer.destroy();
			});
			this.stagingBuffers = null;
		};
		_proto.getStagingBuffer = function getStagingBuffer() {
			var stagingBuffer = this.stagingBuffers.pop();
			if (!stagingBuffer) {
				stagingBuffer = this.device.wgpu.createBuffer({
					size: this.queryBuffer.size,
					usage: GPUBufferUsage.COPY_DST | GPUBufferUsage.MAP_READ
				});
			}
			return stagingBuffer;
		};
		_proto.resolve = function resolve(count) {
			var device = this.device;
			var commandEncoder = device.wgpu.createCommandEncoder();
			commandEncoder.resolveQuerySet(this.querySet, 0, count, this.queryBuffer, 0);
			var activeStagingBuffer = this.getStagingBuffer();
			this.activeStagingBuffer = activeStagingBuffer;
			commandEncoder.copyBufferToBuffer(this.queryBuffer, 0, activeStagingBuffer, 0, this.bytesPerSlot * count);
			var cb = commandEncoder.finish();
			device.addCommandBuffer(cb);
		};
		_proto.request = function request(count, renderVersion) {
			var _this = this;
			var stagingBuffer = this.activeStagingBuffer;
			this.activeStagingBuffer = null;
			return stagingBuffer.mapAsync(GPUMapMode.READ).then(function () {
				var srcTimings = new BigInt64Array(stagingBuffer.getMappedRange());
				var timings = [];
				for (var i = 0; i < count; i++) {
					timings.push(Number(srcTimings[i * 2 + 1] - srcTimings[i * 2]) * 0.000001);
				}
				stagingBuffer.unmap();
				_this.stagingBuffers.push(stagingBuffer);
				return {
					renderVersion: renderVersion,
					timings: timings
				};
			});
		};
		return WebgpuQuerySet;
	}();

	var WebgpuGpuProfiler = function (_GpuProfiler) {
		_inheritsLoose(WebgpuGpuProfiler, _GpuProfiler);
		function WebgpuGpuProfiler(device) {
			var _this;
			_this = _GpuProfiler.call(this) || this;
			_this.device = void 0;
			_this.frameGPUMarkerSlot = void 0;
			_this.device = device;
			_this.timestampQueriesSet = device.supportsTimestampQuery ? new WebgpuQuerySet(device, true, 512) : null;
			return _this;
		}
		var _proto = WebgpuGpuProfiler.prototype;
		_proto.destroy = function destroy() {
			var _this$timestampQuerie;
			(_this$timestampQuerie = this.timestampQueriesSet) == null ? void 0 : _this$timestampQuerie.destroy();
			this.timestampQueriesSet = null;
		};
		_proto.frameMarker = function frameMarker(isStart) {
			if (this.timestampQueriesSet) {
				var commandEncoder = this.device.wgpu.createCommandEncoder();
				this.frameGPUMarkerSlot = isStart ? this.getSlot('GpuFrame') : this.frameGPUMarkerSlot;
				commandEncoder.writeTimestamp(this.timestampQueriesSet.querySet, this.frameGPUMarkerSlot * 2 + (isStart ? 0 : 1));
				var cb = commandEncoder.finish();
				this.device.addCommandBuffer(cb, isStart);
			}
		};
		_proto.frameStart = function frameStart() {
			this.processEnableRequest();
			if (this._enabled) {
				this.frameMarker(true);
			}
		};
		_proto.frameEnd = function frameEnd() {
			if (this._enabled) {
				var _this$timestampQuerie2;
				this.frameMarker(false);
				(_this$timestampQuerie2 = this.timestampQueriesSet) == null ? void 0 : _this$timestampQuerie2.resolve(this.slotCount * 2);
			}
		};
		_proto.request = function request() {
			var _this2 = this;
			if (this._enabled) {
				var _this$timestampQuerie3;
				var renderVersion = this.device.renderVersion;
				(_this$timestampQuerie3 = this.timestampQueriesSet) == null ? void 0 : _this$timestampQuerie3.request(this.slotCount, renderVersion).then(function (results) {
					_this2.report(results.renderVersion, results.timings);
				});
				_GpuProfiler.prototype.request.call(this, renderVersion);
			}
		};
		return WebgpuGpuProfiler;
	}(GpuProfiler);

	var WebgpuResolver = function () {
		function WebgpuResolver(device) {
			this.device = void 0;
			this.pipelineCache = new Map();
			this.device = device;
			var code = "\n \n            var<private> pos : array<vec2f, 4> = array<vec2f, 4>(\n                vec2(-1.0, 1.0), vec2(1.0, 1.0), vec2(-1.0, -1.0), vec2(1.0, -1.0)\n            );\n\n            struct VertexOutput {\n                @builtin(position) position : vec4f,\n            };\n\n            @vertex\n            fn vertexMain(@builtin(vertex_index) vertexIndex : u32) -> VertexOutput {\n              var output : VertexOutput;\n              output.position = vec4f(pos[vertexIndex], 0, 1);\n              return output;\n            }\n\n            @group(0) @binding(0) var img : texture_depth_multisampled_2d;\n\n            @fragment\n            fn fragmentMain(@builtin(position) fragColor: vec4f) -> @location(0) vec4f {\n                // load th depth value from sample index 0\n                var depth = textureLoad(img, vec2i(fragColor.xy), 0u);\n                return vec4<f32>(depth, 0.0, 0.0, 0.0);\n            }\n        ";
			this.shader = new Shader(device, {
				name: 'WebGPUResolverDepthShader',
				shaderLanguage: SHADERLANGUAGE_WGSL,
				vshader: code,
				fshader: code
			});
		}
		var _proto = WebgpuResolver.prototype;
		_proto.destroy = function destroy() {
			this.shader.destroy();
			this.shader = null;
			this.pipelineCache = null;
		};
		_proto.getPipeline = function getPipeline(format) {
			var pipeline = this.pipelineCache.get(format);
			if (!pipeline) {
				pipeline = this.createPipeline(format);
				this.pipelineCache.set(format, pipeline);
			}
			return pipeline;
		};
		_proto.createPipeline = function createPipeline(format) {
			var webgpuShader = this.shader.impl;
			var pipeline = this.device.wgpu.createRenderPipeline({
				layout: 'auto',
				vertex: {
					module: webgpuShader.getVertexShaderModule(),
					entryPoint: webgpuShader.vertexEntryPoint
				},
				fragment: {
					module: webgpuShader.getFragmentShaderModule(),
					entryPoint: webgpuShader.fragmentEntryPoint,
					targets: [{
						format: format
					}]
				},
				primitive: {
					topology: 'triangle-strip'
				}
			});
			return pipeline;
		};
		_proto.resolveDepth = function resolveDepth(commandEncoder, sourceTexture, destinationTexture) {
			var device = this.device;
			var wgpu = device.wgpu;
			var pipeline = this.getPipeline(destinationTexture.format);
			var numFaces = sourceTexture.depthOrArrayLayers;
			for (var face = 0; face < numFaces; face++) {
				var srcView = sourceTexture.createView({
					dimension: '2d',
					aspect: 'depth-only',
					baseMipLevel: 0,
					mipLevelCount: 1,
					baseArrayLayer: face
				});
				var dstView = destinationTexture.createView({
					dimension: '2d',
					baseMipLevel: 0,
					mipLevelCount: 1,
					baseArrayLayer: face
				});
				var passEncoder = commandEncoder.beginRenderPass({
					colorAttachments: [{
						view: dstView,
						loadOp: 'clear',
						storeOp: 'store'
					}]
				});
				var bindGroup = wgpu.createBindGroup({
					layout: pipeline.getBindGroupLayout(0),
					entries: [{
						binding: 0,
						resource: srcView
					}]
				});
				passEncoder.setPipeline(pipeline);
				passEncoder.setBindGroup(0, bindGroup);
				passEncoder.draw(4);
				passEncoder.end();
			}
			device.pipeline = null;
		};
		return WebgpuResolver;
	}();

	var WebgpuGraphicsDevice = function (_GraphicsDevice) {
		_inheritsLoose(WebgpuGraphicsDevice, _GraphicsDevice);
		function WebgpuGraphicsDevice(canvas, options) {
			var _this;
			if (options === void 0) {
				options = {};
			}
			_this = _GraphicsDevice.call(this, canvas, options) || this;
			_this.frameBuffer = void 0;
			_this.renderPipeline = new WebgpuRenderPipeline(_assertThisInitialized(_this));
			_this.clearRenderer = void 0;
			_this.mipmapRenderer = void 0;
			_this.pipeline = void 0;
			_this.bindGroupFormats = [];
			_this.commandEncoder = void 0;
			_this.commandBuffers = [];
			_this.limits = void 0;
			options = _this.initOptions;
			_this.isWebGPU = true;
			_this._deviceType = DEVICETYPE_WEBGPU;
			_this.samples = options.antialias ? 4 : 1;
			_this.setupPassEncoderDefaults();
			return _this;
		}
		var _proto = WebgpuGraphicsDevice.prototype;
		_proto.destroy = function destroy() {
			this.clearRenderer.destroy();
			this.clearRenderer = null;
			this.mipmapRenderer.destroy();
			this.mipmapRenderer = null;
			this.resolver.destroy();
			this.resolver = null;
			_GraphicsDevice.prototype.destroy.call(this);
		};
		_proto.initDeviceCaps = function initDeviceCaps() {
			this.disableParticleSystem = true;
			var limits = this.gpuAdapter.limits;
			this.limits = limits;
			this.precision = 'highp';
			this.maxPrecision = 'highp';
			this.maxSamples = 4;
			this.maxTextures = 16;
			this.maxTextureSize = limits.maxTextureDimension2D;
			this.maxCubeMapSize = limits.maxTextureDimension2D;
			this.maxVolumeSize = limits.maxTextureDimension3D;
			this.maxColorAttachments = limits.maxColorAttachments;
			this.maxPixelRatio = 1;
			this.maxAnisotropy = 16;
			this.supportsInstancing = true;
			this.supportsUniformBuffers = true;
			this.supportsVolumeTextures = true;
			this.supportsBoneTextures = true;
			this.supportsMorphTargetTexturesCore = true;
			this.supportsAreaLights = true;
			this.supportsDepthShadow = true;
			this.supportsGpuParticles = false;
			this.supportsMrt = true;
			this.extUintElement = true;
			this.extTextureFloat = true;
			this.textureFloatRenderable = true;
			this.extTextureHalfFloat = true;
			this.textureHalfFloatRenderable = true;
			this.textureHalfFloatUpdatable = true;
			this.boneLimit = 1024;
			this.supportsImageBitmap = true;
			this.extStandardDerivatives = true;
			this.extBlendMinmax = true;
			this.areaLightLutFormat = this.floatFilterable ? PIXELFORMAT_RGBA32F : PIXELFORMAT_RGBA8;
			this.supportsTextureFetch = true;
		};
		_proto.initWebGpu = function () {
			var _initWebGpu = _asyncToGenerator(_regeneratorRuntime().mark(function _callee(glslangUrl, twgslUrl) {
				var _this2 = this;
				var loadScript, wasmPath, adapterOptions, requiredFeatures, requireFeature, deviceDescr, preferredCanvasFormat;
				return _regeneratorRuntime().wrap(function _callee$(_context) {
					while (1) switch (_context.prev = _context.next) {
						case 0:
							if (window.navigator.gpu) {
								_context.next = 2;
								break;
							}
							throw new Error('Unable to retrieve GPU. Ensure you are using a browser that supports WebGPU rendering.');
						case 2:
							loadScript = function loadScript(url) {
								return new Promise(function (resolve, reject) {
									var script = document.createElement('script');
									script.src = url;
									script.async = false;
									script.onload = function () {
										resolve(url);
									};
									script.onerror = function () {
										reject(new Error("Failed to download script " + url));
									};
									document.body.appendChild(script);
								});
							};
							_context.next = 5;
							return loadScript(glslangUrl);
						case 5:
							_context.next = 7;
							return loadScript(twgslUrl);
						case 7:
							_context.next = 9;
							return glslang();
						case 9:
							this.glslang = _context.sent;
							wasmPath = twgslUrl.replace('.js', '.wasm');
							_context.next = 13;
							return twgsl(wasmPath);
						case 13:
							this.twgsl = _context.sent;
							adapterOptions = {
								powerPreference: this.initOptions.powerPreference !== 'default' ? this.initOptions.powerPreference : undefined
							};
							_context.next = 17;
							return window.navigator.gpu.requestAdapter(adapterOptions);
						case 17:
							this.gpuAdapter = _context.sent;
							requiredFeatures = [];
							requireFeature = function requireFeature(feature) {
								var supported = _this2.gpuAdapter.features.has(feature);
								if (supported) {
									requiredFeatures.push(feature);
								}
								return supported;
							};
							this.floatFilterable = requireFeature('float32-filterable');
							this.extCompressedTextureS3TC = requireFeature('texture-compression-bc');
							this.extCompressedTextureETC = requireFeature('texture-compression-etc2');
							this.extCompressedTextureASTC = requireFeature('texture-compression-astc');
							this.supportsTimestampQuery = requireFeature('timestamp-query');
							deviceDescr = {
								requiredFeatures: requiredFeatures,
								requiredLimits: {},
								defaultQueue: {
									label: 'Default Queue'
								}
							};
							_context.next = 28;
							return this.gpuAdapter.requestDevice(deviceDescr);
						case 28:
							this.wgpu = _context.sent;
							this.initDeviceCaps();
							this.setResolution(window.innerWidth, window.innerHeight);
							this.gpuContext = this.canvas.getContext('webgpu');
							preferredCanvasFormat = navigator.gpu.getPreferredCanvasFormat();
							this.framebufferFormat = preferredCanvasFormat === 'rgba8unorm' ? PIXELFORMAT_RGBA8 : PIXELFORMAT_BGRA8;
							this.canvasConfig = {
								device: this.wgpu,
								colorSpace: 'srgb',
								alphaMode: 'opaque',
								format: preferredCanvasFormat,
								usage: GPUTextureUsage.RENDER_ATTACHMENT | GPUTextureUsage.COPY_SRC | GPUTextureUsage.COPY_DST,
								viewFormats: []
							};
							this.gpuContext.configure(this.canvasConfig);
							this.createFramebuffer();
							this.clearRenderer = new WebgpuClearRenderer(this);
							this.mipmapRenderer = new WebgpuMipmapRenderer(this);
							this.resolver = new WebgpuResolver(this);
							this.postInit();
							return _context.abrupt("return", this);
						case 42:
						case "end":
							return _context.stop();
					}
				}, _callee, this);
			}));
			function initWebGpu(_x, _x2) {
				return _initWebGpu.apply(this, arguments);
			}
			return initWebGpu;
		}();
		_proto.postInit = function postInit() {
			_GraphicsDevice.prototype.postInit.call(this);
			this.gpuProfiler = new WebgpuGpuProfiler(this);
			this.dynamicBuffers = new WebgpuDynamicBuffers(this, 1024 * 1024, this.limits.minUniformBufferOffsetAlignment);
		};
		_proto.createFramebuffer = function createFramebuffer() {
			this.supportsStencil = this.initOptions.stencil;
			this.frameBufferDimensions = new Vec2();
			this.frameBuffer = new RenderTarget({
				name: 'WebgpuFramebuffer',
				graphicsDevice: this,
				depth: this.initOptions.depth,
				stencil: this.supportsStencil,
				samples: this.samples
			});
		};
		_proto.resizeCanvas = function resizeCanvas(width, height) {
			this._width = width;
			this._height = height;
			if (this.canvas.width !== width || this.canvas.height !== height) {
				this.canvas.width = width;
				this.canvas.height = height;
				this.fire(GraphicsDevice.EVENT_RESIZE, width, height);
			}
		};
		_proto.frameStart = function frameStart() {
			_GraphicsDevice.prototype.frameStart.call(this);
			this.gpuProfiler.frameStart();
			this.submit();
			var outColorBuffer = this.gpuContext.getCurrentTexture();
			if (this.frameBufferDimensions.x !== outColorBuffer.width || this.frameBufferDimensions.y !== outColorBuffer.height) {
				this.frameBufferDimensions.set(outColorBuffer.width, outColorBuffer.height);
				this.frameBuffer.destroy();
				this.frameBuffer = null;
				this.createFramebuffer();
			}
			var rt = this.frameBuffer;
			var wrt = rt.impl;
			wrt.setColorAttachment(0, undefined, outColorBuffer.format);
			this.initRenderTarget(rt);
			wrt.assignColorTexture(outColorBuffer);
		};
		_proto.frameEnd = function frameEnd() {
			_GraphicsDevice.prototype.frameEnd.call(this);
			this.gpuProfiler.frameEnd();
			this.submit();
			this.gpuProfiler.request();
		};
		_proto.createUniformBufferImpl = function createUniformBufferImpl(uniformBuffer) {
			return new WebgpuUniformBuffer(uniformBuffer);
		};
		_proto.createVertexBufferImpl = function createVertexBufferImpl(vertexBuffer, format) {
			return new WebgpuVertexBuffer(vertexBuffer, format);
		};
		_proto.createIndexBufferImpl = function createIndexBufferImpl(indexBuffer) {
			return new WebgpuIndexBuffer(indexBuffer);
		};
		_proto.createShaderImpl = function createShaderImpl(shader) {
			return new WebgpuShader(shader);
		};
		_proto.createTextureImpl = function createTextureImpl(texture) {
			return new WebgpuTexture(texture);
		};
		_proto.createRenderTargetImpl = function createRenderTargetImpl(renderTarget) {
			return new WebgpuRenderTarget(renderTarget);
		};
		_proto.createBindGroupFormatImpl = function createBindGroupFormatImpl(bindGroupFormat) {
			return new WebgpuBindGroupFormat(bindGroupFormat);
		};
		_proto.createBindGroupImpl = function createBindGroupImpl(bindGroup) {
			return new WebgpuBindGroup();
		};
		_proto.setBindGroup = function setBindGroup(index, bindGroup) {
			if (this.passEncoder) {
				this.passEncoder.setBindGroup(index, bindGroup.impl.bindGroup, bindGroup.uniformBufferOffsets);
				this.bindGroupFormats[index] = bindGroup.format.impl;
			}
		};
		_proto.submitVertexBuffer = function submitVertexBuffer(vertexBuffer, slot) {
			var elements = vertexBuffer.format.elements;
			var elementCount = elements.length;
			var vbBuffer = vertexBuffer.impl.buffer;
			for (var i = 0; i < elementCount; i++) {
				this.passEncoder.setVertexBuffer(slot + i, vbBuffer, elements[i].offset);
			}
			return elementCount;
		};
		_proto.draw = function draw(primitive, numInstances, keepBuffers) {
			if (numInstances === void 0) {
				numInstances = 1;
			}
			if (this.shader.ready && !this.shader.failed) {
				var passEncoder = this.passEncoder;
				var vb0 = this.vertexBuffers[0];
				var vb1 = this.vertexBuffers[1];
				this.vertexBuffers.length = 0;
				if (vb0) {
					var vbSlot = this.submitVertexBuffer(vb0, 0);
					if (vb1) {
						this.submitVertexBuffer(vb1, vbSlot);
					}
				}
				var pipeline = this.renderPipeline.get(primitive, vb0 == null ? void 0 : vb0.format, vb1 == null ? void 0 : vb1.format, this.shader, this.renderTarget, this.bindGroupFormats, this.blendState, this.depthState, this.cullMode, this.stencilEnabled, this.stencilFront, this.stencilBack);
				if (this.pipeline !== pipeline) {
					this.pipeline = pipeline;
					passEncoder.setPipeline(pipeline);
				}
				var ib = this.indexBuffer;
				if (ib) {
					this.indexBuffer = null;
					passEncoder.setIndexBuffer(ib.impl.buffer, ib.impl.format);
					passEncoder.drawIndexed(primitive.count, numInstances, 0, 0, 0);
				} else {
					passEncoder.draw(primitive.count, numInstances, 0, 0);
				}
			}
		};
		_proto.setShader = function setShader(shader) {
			this.shader = shader;
			return true;
		};
		_proto.setBlendState = function setBlendState(blendState) {
			this.blendState.copy(blendState);
		};
		_proto.setDepthState = function setDepthState(depthState) {
			this.depthState.copy(depthState);
		};
		_proto.setStencilState = function setStencilState(stencilFront, stencilBack) {
			if (stencilFront || stencilBack) {
				this.stencilEnabled = true;
				this.stencilFront.copy(stencilFront != null ? stencilFront : StencilParameters.DEFAULT);
				this.stencilBack.copy(stencilBack != null ? stencilBack : StencilParameters.DEFAULT);
				var ref = this.stencilFront.ref;
				if (this.stencilRef !== ref) {
					this.stencilRef = ref;
					this.passEncoder.setStencilReference(ref);
				}
			} else {
				this.stencilEnabled = false;
			}
		};
		_proto.setBlendColor = function setBlendColor(r, g, b, a) {};
		_proto.setCullMode = function setCullMode(cullMode) {
			this.cullMode = cullMode;
		};
		_proto.setAlphaToCoverage = function setAlphaToCoverage(state) {};
		_proto.initializeContextCaches = function initializeContextCaches() {
			_GraphicsDevice.prototype.initializeContextCaches.call(this);
		};
		_proto.setupPassEncoderDefaults = function setupPassEncoderDefaults() {
			this.stencilRef = 0;
		};
		_proto.startPass = function startPass(renderPass) {
			var rt = renderPass.renderTarget || this.frameBuffer;
			this.renderTarget = rt;
			var wrt = rt.impl;
			this.commandEncoder = this.wgpu.createCommandEncoder();
			if (rt !== this.frameBuffer) {
				this.initRenderTarget(rt);
			}
			wrt.setupForRenderPass(renderPass);
			this.pipeline = null;
			var renderPassDesc = wrt.renderPassDescriptor;
			if (this.gpuProfiler._enabled) {
				if (this.gpuProfiler.timestampQueriesSet) {
					var slot = this.gpuProfiler.getSlot(renderPass.name);
					renderPassDesc.timestampWrites = {
						querySet: this.gpuProfiler.timestampQueriesSet.querySet,
						beginningOfPassWriteIndex: slot * 2,
						endOfPassWriteIndex: slot * 2 + 1
					};
				}
			}
			this.passEncoder = this.commandEncoder.beginRenderPass(renderPassDesc);
			this.setupPassEncoderDefaults();
			var width = rt.width,
				height = rt.height;
			this.setViewport(0, 0, width, height);
			this.setScissor(0, 0, width, height);
			this.insideRenderPass = true;
		};
		_proto.endPass = function endPass(renderPass) {
			this.passEncoder.end();
			this.passEncoder = null;
			this.insideRenderPass = false;
			this.bindGroupFormats.length = 0;
			for (var i = 0; i < renderPass.colorArrayOps.length; i++) {
				var colorOps = renderPass.colorArrayOps[i];
				if (colorOps.mipmaps) {
					this.mipmapRenderer.generate(renderPass.renderTarget._colorBuffers[i].impl);
				}
			}
			var cb = this.commandEncoder.finish();
			this.addCommandBuffer(cb);
			this.commandEncoder = null;
		};
		_proto.addCommandBuffer = function addCommandBuffer(commandBuffer, front) {
			if (front === void 0) {
				front = false;
			}
			if (front) {
				this.commandBuffers.unshift(commandBuffer);
			} else {
				this.commandBuffers.push(commandBuffer);
			}
		};
		_proto.submit = function submit() {
			if (this.commandBuffers.length > 0) {
				this.dynamicBuffers.submit();
				this.wgpu.queue.submit(this.commandBuffers);
				this.commandBuffers.length = 0;
				this.dynamicBuffers.onCommandBuffersSubmitted();
			}
		};
		_proto.clear = function clear(options) {
			if (options.flags) {
				this.clearRenderer.clear(this, this.renderTarget, options, this.defaultClearOptions);
			}
		};
		_proto.setDepthBias = function setDepthBias(on) {};
		_proto.setDepthBiasValues = function setDepthBiasValues(constBias, slopeBias) {};
		_proto.setViewport = function setViewport(x, y, w, h) {
			if (this.passEncoder) {
				if (!this.renderTarget.flipY) {
					y = this.renderTarget.height - y - h;
				}
				this.vx = x;
				this.vy = y;
				this.vw = w;
				this.vh = h;
				this.passEncoder.setViewport(x, y, w, h, 0, 1);
			}
		};
		_proto.setScissor = function setScissor(x, y, w, h) {
			if (this.passEncoder) {
				if (!this.renderTarget.flipY) {
					y = this.renderTarget.height - y - h;
				}
				this.sx = x;
				this.sy = y;
				this.sw = w;
				this.sh = h;
				this.passEncoder.setScissorRect(x, y, w, h);
			}
		};
		_proto.copyRenderTarget = function copyRenderTarget(source, dest, color, depth) {
			var _this$commandEncoder;
			var copySize = {
				width: source ? source.width : dest.width,
				height: source ? source.height : dest.height,
				depthOrArrayLayers: 1
			};
			var commandEncoder = (_this$commandEncoder = this.commandEncoder) != null ? _this$commandEncoder : this.wgpu.createCommandEncoder();
			if (color) {
				var copySrc = {
					texture: source ? source.colorBuffer.impl.gpuTexture : this.renderTarget.impl.assignedColorTexture,
					mipLevel: 0
				};
				var copyDst = {
					texture: dest ? dest.colorBuffer.impl.gpuTexture : this.renderTarget.impl.assignedColorTexture,
					mipLevel: 0
				};
				commandEncoder.copyTextureToTexture(copySrc, copyDst, copySize);
			}
			if (depth) {
				var sourceRT = source ? source : this.renderTarget;
				var sourceTexture = sourceRT.impl.depthTexture;
				if (source.samples > 1) {
					var destTexture = dest.colorBuffer.impl.gpuTexture;
					this.resolver.resolveDepth(commandEncoder, sourceTexture, destTexture);
				} else {
					var _destTexture = dest ? dest.depthBuffer.impl.gpuTexture : this.renderTarget.impl.depthTexture;
					var _copySrc = {
						texture: sourceTexture,
						mipLevel: 0
					};
					var _copyDst = {
						texture: _destTexture,
						mipLevel: 0
					};
					commandEncoder.copyTextureToTexture(_copySrc, _copyDst, copySize);
				}
			}
			if (!this.commandEncoder) {
				var cb = commandEncoder.finish();
				this.addCommandBuffer(cb);
			}
			return true;
		};
		_createClass(WebgpuGraphicsDevice, [{
			key: "width",
			get: function get() {
				return this._width;
			}
		}, {
			key: "height",
			get: function get() {
				return this._height;
			}
		}]);
		return WebgpuGraphicsDevice;
	}(GraphicsDevice);

	var id$4 = 0;
	var Texture = function () {
		function Texture(graphicsDevice, options) {
			var _options$name, _options$width, _options$height, _options$format, _options$cubemap, _options$fixCubemapSe, _options$flipY, _options$premultiplyA, _ref, _options$mipmaps, _options$minFilter, _options$magFilter, _options$anisotropy, _options$addressU, _options$addressV, _options$addressW, _options$compareOnRea, _options$compareFunc;
			if (options === void 0) {
				options = {};
			}
			this.name = void 0;
			this._isRenderTarget = false;
			this._gpuSize = 0;
			this.id = id$4++;
			this._invalid = false;
			this._lockedLevel = -1;
			this.renderVersionDirty = 0;
			this.device = graphicsDevice;
			this.name = (_options$name = options.name) != null ? _options$name : null;
			this._width = (_options$width = options.width) != null ? _options$width : 4;
			this._height = (_options$height = options.height) != null ? _options$height : 4;
			this._format = (_options$format = options.format) != null ? _options$format : PIXELFORMAT_RGBA8;
			this._compressed = isCompressedPixelFormat(this._format);
			if (graphicsDevice.supportsVolumeTextures) {
				var _options$volume, _options$depth;
				this._volume = (_options$volume = options.volume) != null ? _options$volume : false;
				this._depth = (_options$depth = options.depth) != null ? _options$depth : 1;
			} else {
				this._volume = false;
				this._depth = 1;
			}
			this._cubemap = (_options$cubemap = options.cubemap) != null ? _options$cubemap : false;
			this.fixCubemapSeams = (_options$fixCubemapSe = options.fixCubemapSeams) != null ? _options$fixCubemapSe : false;
			this._flipY = (_options$flipY = options.flipY) != null ? _options$flipY : false;
			this._premultiplyAlpha = (_options$premultiplyA = options.premultiplyAlpha) != null ? _options$premultiplyA : false;
			this._mipmaps = (_ref = (_options$mipmaps = options.mipmaps) != null ? _options$mipmaps : options.autoMipmap) != null ? _ref : true;
			this._minFilter = (_options$minFilter = options.minFilter) != null ? _options$minFilter : FILTER_LINEAR_MIPMAP_LINEAR;
			this._magFilter = (_options$magFilter = options.magFilter) != null ? _options$magFilter : FILTER_LINEAR;
			this._anisotropy = (_options$anisotropy = options.anisotropy) != null ? _options$anisotropy : 1;
			this._addressU = (_options$addressU = options.addressU) != null ? _options$addressU : ADDRESS_REPEAT;
			this._addressV = (_options$addressV = options.addressV) != null ? _options$addressV : ADDRESS_REPEAT;
			this._addressW = (_options$addressW = options.addressW) != null ? _options$addressW : ADDRESS_REPEAT;
			this._compareOnRead = (_options$compareOnRea = options.compareOnRead) != null ? _options$compareOnRea : false;
			this._compareFunc = (_options$compareFunc = options.compareFunc) != null ? _options$compareFunc : FUNC_LESS;
			this.type = TEXTURETYPE_DEFAULT;
			if (options.hasOwnProperty('type')) {
				this.type = options.type;
			} else if (options.hasOwnProperty('rgbm')) {
				this.type = options.rgbm ? TEXTURETYPE_RGBM : TEXTURETYPE_DEFAULT;
			} else if (options.hasOwnProperty('swizzleGGGR')) {
				this.type = options.swizzleGGGR ? TEXTURETYPE_SWIZZLEGGGR : TEXTURETYPE_DEFAULT;
			}
			this.projection = TEXTUREPROJECTION_NONE;
			if (this._cubemap) {
				this.projection = TEXTUREPROJECTION_CUBE;
			} else if (options.projection && options.projection !== TEXTUREPROJECTION_CUBE) {
				this.projection = options.projection;
			}
			this.impl = graphicsDevice.createTextureImpl(this);
			this.dirtyAll();
			this._levels = options.levels;
			if (this._levels) {
				this.upload();
			} else {
				this._levels = this._cubemap ? [[null, null, null, null, null, null]] : [null];
			}
			graphicsDevice.textures.push(this);
		}
		var _proto = Texture.prototype;
		_proto.destroy = function destroy() {
			if (this.device) {
				var device = this.device;
				var idx = device.textures.indexOf(this);
				if (idx !== -1) {
					device.textures.splice(idx, 1);
				}
				device.scope.removeValue(this);
				this.impl.destroy(device);
				this.adjustVramSizeTracking(device._vram, -this._gpuSize);
				this._levels = null;
				this.device = null;
			}
		};
		_proto.loseContext = function loseContext() {
			this.impl.loseContext();
			this.dirtyAll();
		};
		_proto.adjustVramSizeTracking = function adjustVramSizeTracking(vram, size) {
			vram.tex += size;
		};
		_proto.propertyChanged = function propertyChanged(flag) {
			this.impl.propertyChanged(flag);
			this.renderVersionDirty = this.device.renderVersion;
		};
		_proto.dirtyAll = function dirtyAll() {
			this._levelsUpdated = this._cubemap ? [[true, true, true, true, true, true]] : [true];
			this._needsUpload = true;
			this._needsMipmapsUpload = this._mipmaps;
			this._mipmapsUploaded = false;
			this.propertyChanged(255);
		};
		_proto.lock = function lock(options) {
			if (options === void 0) {
				options = {};
			}
			if (options.level === undefined) {
				options.level = 0;
			}
			if (options.face === undefined) {
				options.face = 0;
			}
			if (options.mode === undefined) {
				options.mode = TEXTURELOCK_WRITE;
			}
			this._lockedLevel = options.level;
			var levels = this.cubemap ? this._levels[options.face] : this._levels;
			if (levels[options.level] === null) {
				var width = Math.max(1, this._width >> options.level);
				var height = Math.max(1, this._height >> options.level);
				var depth = Math.max(1, this._depth >> options.level);
				var data = new ArrayBuffer(TextureUtils.calcLevelGpuSize(width, height, depth, this._format));
				levels[options.level] = new (getPixelFormatArrayType(this._format))(data);
			}
			return levels[options.level];
		};
		_proto.setSource = function setSource(source, mipLevel) {
			if (mipLevel === void 0) {
				mipLevel = 0;
			}
			var invalid = false;
			var width, height;
			if (this._cubemap) {
				if (source[0]) {
					width = source[0].width || 0;
					height = source[0].height || 0;
					for (var i = 0; i < 6; i++) {
						var face = source[i];
						if (!face || face.width !== width || face.height !== height || !this.device._isBrowserInterface(face)) {
							invalid = true;
							break;
						}
					}
				} else {
					invalid = true;
				}
				if (!invalid) {
					for (var _i = 0; _i < 6; _i++) {
						if (this._levels[mipLevel][_i] !== source[_i]) this._levelsUpdated[mipLevel][_i] = true;
					}
				}
			} else {
				if (!this.device._isBrowserInterface(source)) invalid = true;
				if (!invalid) {
					if (source !== this._levels[mipLevel]) this._levelsUpdated[mipLevel] = true;
					width = source.width;
					height = source.height;
				}
			}
			if (invalid) {
				this._width = 4;
				this._height = 4;
				if (this._cubemap) {
					for (var _i2 = 0; _i2 < 6; _i2++) {
						this._levels[mipLevel][_i2] = null;
						this._levelsUpdated[mipLevel][_i2] = true;
					}
				} else {
					this._levels[mipLevel] = null;
					this._levelsUpdated[mipLevel] = true;
				}
			} else {
				if (mipLevel === 0) {
					this._width = width;
					this._height = height;
				}
				this._levels[mipLevel] = source;
			}
			if (this._invalid !== invalid || !invalid) {
				this._invalid = invalid;
				this.upload();
			}
		};
		_proto.getSource = function getSource(mipLevel) {
			if (mipLevel === void 0) {
				mipLevel = 0;
			}
			return this._levels[mipLevel];
		};
		_proto.unlock = function unlock() {
			if (this._lockedLevel === -1) ;
			this.upload();
			this._lockedLevel = -1;
		};
		_proto.upload = function upload() {
			var _this$impl$uploadImme, _this$impl;
			this._needsUpload = true;
			this._needsMipmapsUpload = this._mipmaps;
			(_this$impl$uploadImme = (_this$impl = this.impl).uploadImmediate) == null ? void 0 : _this$impl$uploadImme.call(_this$impl, this.device, this);
		};
		_proto.downloadAsync = function () {
			var _downloadAsync = _asyncToGenerator(_regeneratorRuntime().mark(function _callee() {
				var _this = this;
				var promises, _loop, i;
				return _regeneratorRuntime().wrap(function _callee$(_context2) {
					while (1) switch (_context2.prev = _context2.next) {
						case 0:
							promises = [];
							_loop = _regeneratorRuntime().mark(function _loop() {
								var renderTarget, levels, level, promise;
								return _regeneratorRuntime().wrap(function _loop$(_context) {
									while (1) switch (_context.prev = _context.next) {
										case 0:
											renderTarget = new RenderTarget({
												colorBuffer: _this,
												depth: false,
												face: i
											});
											_this.device.setRenderTarget(renderTarget);
											_this.device.initRenderTarget(renderTarget);
											levels = _this.cubemap ? _this._levels[i] : _this._levels;
											level = levels[0];
											if (levels[0] && _this.device._isBrowserInterface(levels[0])) {
												levels[0] = null;
											}
											level = _this.lock({
												face: i
											});
											promise = _this.device.readPixelsAsync == null ? void 0 : _this.device.readPixelsAsync(0, 0, _this.width, _this.height, level).then(function () {
												return renderTarget.destroy();
											});
											promises.push(promise);
										case 9:
										case "end":
											return _context.stop();
									}
								}, _loop);
							});
							i = 0;
						case 3:
							if (!(i < (this.cubemap ? 6 : 1))) {
								_context2.next = 8;
								break;
							}
							return _context2.delegateYield(_loop(), "t0", 5);
						case 5:
							i++;
							_context2.next = 3;
							break;
						case 8:
							_context2.next = 10;
							return Promise.all(promises);
						case 10:
						case "end":
							return _context2.stop();
					}
				}, _callee, this);
			}));
			function downloadAsync() {
				return _downloadAsync.apply(this, arguments);
			}
			return downloadAsync;
		}();
		_proto.getDds = function getDds() {
			var fsize = 128;
			var idx = 0;
			while (this._levels[idx]) {
				if (!this.cubemap) {
					var mipSize = this._levels[idx].length;
					if (!mipSize) {
						return undefined;
					}
					fsize += mipSize;
				} else {
					for (var face = 0; face < 6; face++) {
						if (!this._levels[idx][face]) {
							return undefined;
						}
						var _mipSize = this._levels[idx][face].length;
						if (!_mipSize) {
							return undefined;
						}
						fsize += _mipSize;
					}
				}
				fsize += this._levels[idx].length;
				idx++;
			}
			var buff = new ArrayBuffer(fsize);
			var header = new Uint32Array(buff, 0, 128 / 4);
			var DDS_MAGIC = 542327876;
			var DDS_HEADER_SIZE = 124;
			var DDS_FLAGS_REQUIRED = 0x01 | 0x02 | 0x04 | 0x1000 | 0x80000;
			var DDS_FLAGS_MIPMAP = 0x20000;
			var DDS_PIXELFORMAT_SIZE = 32;
			var DDS_PIXELFLAGS_RGBA8 = 0x01 | 0x40;
			var DDS_CAPS_REQUIRED = 0x1000;
			var DDS_CAPS_MIPMAP = 0x400000;
			var DDS_CAPS_COMPLEX = 0x8;
			var DDS_CAPS2_CUBEMAP = 0x200 | 0x400 | 0x800 | 0x1000 | 0x2000 | 0x4000 | 0x8000;
			var flags = DDS_FLAGS_REQUIRED;
			if (this._levels.length > 1) flags |= DDS_FLAGS_MIPMAP;
			var caps = DDS_CAPS_REQUIRED;
			if (this._levels.length > 1) caps |= DDS_CAPS_MIPMAP;
			if (this._levels.length > 1 || this.cubemap) caps |= DDS_CAPS_COMPLEX;
			var caps2 = this.cubemap ? DDS_CAPS2_CUBEMAP : 0;
			header[0] = DDS_MAGIC;
			header[1] = DDS_HEADER_SIZE;
			header[2] = flags;
			header[3] = this.height;
			header[4] = this.width;
			header[5] = this.width * this.height * 4;
			header[6] = 0;
			header[7] = this._levels.length;
			for (var i = 0; i < 11; i++) {
				header[8 + i] = 0;
			}
			header[19] = DDS_PIXELFORMAT_SIZE;
			header[20] = DDS_PIXELFLAGS_RGBA8;
			header[21] = 0;
			header[22] = 32;
			header[23] = 0x00FF0000;
			header[24] = 0x0000FF00;
			header[25] = 0x000000FF;
			header[26] = 0xFF000000;
			header[27] = caps;
			header[28] = caps2;
			header[29] = 0;
			header[30] = 0;
			header[31] = 0;
			var offset = 128;
			if (!this.cubemap) {
				for (var _i3 = 0; _i3 < this._levels.length; _i3++) {
					var level = this._levels[_i3];
					var mip = new Uint8Array(buff, offset, level.length);
					for (var j = 0; j < level.length; j++) {
						mip[j] = level[j];
					}
					offset += level.length;
				}
			} else {
				for (var _face = 0; _face < 6; _face++) {
					for (var _i4 = 0; _i4 < this._levels.length; _i4++) {
						var _level = this._levels[_i4][_face];
						var _mip = new Uint8Array(buff, offset, _level.length);
						for (var _j = 0; _j < _level.length; _j++) {
							_mip[_j] = _level[_j];
						}
						offset += _level.length;
					}
				}
			}
			return buff;
		};
		_createClass(Texture, [{
			key: "requiredMipLevels",
			get: function get() {
				return this.mipmaps ? Math.floor(Math.log2(Math.max(this.width, this.height))) + 1 : 1;
			}
		}, {
			key: "minFilter",
			get: function get() {
				return this._minFilter;
			},
			set: function set(v) {
				if (this._minFilter !== v) {
					this._minFilter = v;
					this.propertyChanged(1);
				}
			}
		}, {
			key: "magFilter",
			get: function get() {
				return this._magFilter;
			},
			set: function set(v) {
				if (this._magFilter !== v) {
					this._magFilter = v;
					this.propertyChanged(2);
				}
			}
		}, {
			key: "addressU",
			get: function get() {
				return this._addressU;
			},
			set: function set(v) {
				if (this._addressU !== v) {
					this._addressU = v;
					this.propertyChanged(4);
				}
			}
		}, {
			key: "addressV",
			get: function get() {
				return this._addressV;
			},
			set: function set(v) {
				if (this._addressV !== v) {
					this._addressV = v;
					this.propertyChanged(8);
				}
			}
		}, {
			key: "addressW",
			get: function get() {
				return this._addressW;
			},
			set: function set(addressW) {
				if (!this.device.supportsVolumeTextures) return;
				if (!this._volume) {
					return;
				}
				if (addressW !== this._addressW) {
					this._addressW = addressW;
					this.propertyChanged(16);
				}
			}
		}, {
			key: "compareOnRead",
			get: function get() {
				return this._compareOnRead;
			},
			set: function set(v) {
				if (this._compareOnRead !== v) {
					this._compareOnRead = v;
					this.propertyChanged(32);
				}
			}
		}, {
			key: "compareFunc",
			get: function get() {
				return this._compareFunc;
			},
			set: function set(v) {
				if (this._compareFunc !== v) {
					this._compareFunc = v;
					this.propertyChanged(64);
				}
			}
		}, {
			key: "anisotropy",
			get: function get() {
				return this._anisotropy;
			},
			set: function set(v) {
				if (this._anisotropy !== v) {
					this._anisotropy = v;
					this.propertyChanged(128);
				}
			}
		}, {
			key: "mipmaps",
			get: function get() {
				return this._mipmaps;
			},
			set: function set(v) {
				if (this._mipmaps !== v) {
					this._mipmaps = v;
					if (this.device.isWebGPU) ;
					if (v) this._needsMipmapsUpload = true;
				}
			}
		}, {
			key: "width",
			get: function get() {
				return this._width;
			}
		}, {
			key: "height",
			get: function get() {
				return this._height;
			}
		}, {
			key: "depth",
			get: function get() {
				return this._depth;
			}
		}, {
			key: "format",
			get: function get() {
				return this._format;
			}
		}, {
			key: "cubemap",
			get: function get() {
				return this._cubemap;
			}
		}, {
			key: "gpuSize",
			get: function get() {
				var mips = this.pot && this._mipmaps && !(this._compressed && this._levels.length === 1);
				return TextureUtils.calcGpuSize(this._width, this._height, this._depth, this._format, mips, this._cubemap);
			}
		}, {
			key: "volume",
			get: function get() {
				return this._volume;
			}
		}, {
			key: "flipY",
			get: function get() {
				return this._flipY;
			},
			set: function set(flipY) {
				if (this._flipY !== flipY) {
					this._flipY = flipY;
					this._needsUpload = true;
				}
			}
		}, {
			key: "premultiplyAlpha",
			get: function get() {
				return this._premultiplyAlpha;
			},
			set: function set(premultiplyAlpha) {
				if (this._premultiplyAlpha !== premultiplyAlpha) {
					this._premultiplyAlpha = premultiplyAlpha;
					this._needsUpload = true;
				}
			}
		}, {
			key: "pot",
			get: function get() {
				return math.powerOfTwo(this._width) && math.powerOfTwo(this._height);
			}
		}, {
			key: "encoding",
			get: function get() {
				switch (this.type) {
					case TEXTURETYPE_RGBM:
						return 'rgbm';
					case TEXTURETYPE_RGBE:
						return 'rgbe';
					case TEXTURETYPE_RGBP:
						return 'rgbp';
					default:
						return this.format === PIXELFORMAT_RGB16F || this.format === PIXELFORMAT_RGB32F || this.format === PIXELFORMAT_RGBA16F || this.format === PIXELFORMAT_RGBA32F ? 'linear' : 'srgb';
				}
			}
		}]);
		return Texture;
	}();

	var WebglBuffer = function () {
		function WebglBuffer() {
			this.bufferId = null;
		}
		var _proto = WebglBuffer.prototype;
		_proto.destroy = function destroy(device) {
			if (this.bufferId) {
				device.gl.deleteBuffer(this.bufferId);
				this.bufferId = null;
			}
		};
		_proto.loseContext = function loseContext() {
			this.bufferId = null;
		};
		_proto.unlock = function unlock(device, usage, target, storage) {
			var gl = device.gl;
			if (!this.bufferId) {
				this.bufferId = gl.createBuffer();
			}
			var glUsage;
			switch (usage) {
				case BUFFER_STATIC:
					glUsage = gl.STATIC_DRAW;
					break;
				case BUFFER_DYNAMIC:
					glUsage = gl.DYNAMIC_DRAW;
					break;
				case BUFFER_STREAM:
					glUsage = gl.STREAM_DRAW;
					break;
				case BUFFER_GPUDYNAMIC:
					if (device.webgl2) {
						glUsage = gl.DYNAMIC_COPY;
					} else {
						glUsage = gl.STATIC_DRAW;
					}
					break;
			}
			gl.bindBuffer(target, this.bufferId);
			gl.bufferData(target, storage, glUsage);
		};
		_createClass(WebglBuffer, [{
			key: "initialized",
			get: function get() {
				return !!this.bufferId;
			}
		}]);
		return WebglBuffer;
	}();

	var WebglVertexBuffer = function (_WebglBuffer) {
		_inheritsLoose(WebglVertexBuffer, _WebglBuffer);
		function WebglVertexBuffer() {
			var _this;
			for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
				args[_key] = arguments[_key];
			}
			_this = _WebglBuffer.call.apply(_WebglBuffer, [this].concat(args)) || this;
			_this.vao = null;
			return _this;
		}
		var _proto = WebglVertexBuffer.prototype;
		_proto.destroy = function destroy(device) {
			_WebglBuffer.prototype.destroy.call(this, device);
			device.boundVao = null;
			device.gl.bindVertexArray(null);
		};
		_proto.loseContext = function loseContext() {
			_WebglBuffer.prototype.loseContext.call(this);
			this.vao = null;
		};
		_proto.unlock = function unlock(vertexBuffer) {
			var device = vertexBuffer.device;
			_WebglBuffer.prototype.unlock.call(this, device, vertexBuffer.usage, device.gl.ARRAY_BUFFER, vertexBuffer.storage);
		};
		return WebglVertexBuffer;
	}(WebglBuffer);

	var WebglIndexBuffer = function (_WebglBuffer) {
		_inheritsLoose(WebglIndexBuffer, _WebglBuffer);
		function WebglIndexBuffer(indexBuffer) {
			var _this;
			_this = _WebglBuffer.call(this) || this;
			var gl = indexBuffer.device.gl;
			var format = indexBuffer.format;
			if (format === INDEXFORMAT_UINT8) {
				_this.glFormat = gl.UNSIGNED_BYTE;
			} else if (format === INDEXFORMAT_UINT16) {
				_this.glFormat = gl.UNSIGNED_SHORT;
			} else if (format === INDEXFORMAT_UINT32) {
				_this.glFormat = gl.UNSIGNED_INT;
			}
			return _this;
		}
		var _proto = WebglIndexBuffer.prototype;
		_proto.unlock = function unlock(indexBuffer) {
			var device = indexBuffer.device;
			_WebglBuffer.prototype.unlock.call(this, device, indexBuffer.usage, device.gl.ELEMENT_ARRAY_BUFFER, indexBuffer.storage);
		};
		return WebglIndexBuffer;
	}(WebglBuffer);

	var WebglShaderInput = function WebglShaderInput(graphicsDevice, name, type, locationId) {
		this.locationId = locationId;
		this.scopeId = graphicsDevice.scope.resolve(name);
		this.version = new Version();
		if (name.substring(name.length - 3) === "[0]") {
			switch (type) {
				case UNIFORMTYPE_FLOAT:
					type = UNIFORMTYPE_FLOATARRAY;
					break;
				case UNIFORMTYPE_VEC2:
					type = UNIFORMTYPE_VEC2ARRAY;
					break;
				case UNIFORMTYPE_VEC3:
					type = UNIFORMTYPE_VEC3ARRAY;
					break;
				case UNIFORMTYPE_VEC4:
					type = UNIFORMTYPE_VEC4ARRAY;
					break;
			}
		}
		this.dataType = type;
		this.value = [null, null, null, null];
		this.array = [];
	};

	var DeviceCache = function () {
		function DeviceCache() {
			this._cache = new Map();
		}
		var _proto = DeviceCache.prototype;
		_proto.get = function get(device, onCreate) {
			var _this = this;
			if (!this._cache.has(device)) {
				this._cache.set(device, onCreate());
				device.on('destroy', function () {
					_this.remove(device);
				});
				device.on('devicelost', function () {
					var _this$_cache$get;
					(_this$_cache$get = _this._cache.get(device)) == null || _this$_cache$get.loseContext == null ? void 0 : _this$_cache$get.loseContext(device);
				});
			}
			return this._cache.get(device);
		};
		_proto.remove = function remove(device) {
			var _this$_cache$get2;
			(_this$_cache$get2 = this._cache.get(device)) == null || _this$_cache$get2.destroy == null ? void 0 : _this$_cache$get2.destroy(device);
			this._cache.delete(device);
		};
		return DeviceCache;
	}();

	var _vertexShaderBuiltins = ['gl_VertexID', 'gl_InstanceID', 'gl_DrawID', 'gl_BaseVertex', 'gl_BaseInstance'];
	var CompiledShaderCache = function () {
		function CompiledShaderCache() {
			this.map = new Map();
		}
		var _proto = CompiledShaderCache.prototype;
		_proto.destroy = function destroy(device) {
			this.map.forEach(function (shader) {
				device.gl.deleteShader(shader);
			});
		};
		_proto.loseContext = function loseContext(device) {
			this.map.clear();
		};
		return CompiledShaderCache;
	}();
	var ShaderBatchCache = function () {
		function ShaderBatchCache() {
			this.shaders = [];
		}
		var _proto2 = ShaderBatchCache.prototype;
		_proto2.loseContext = function loseContext(device) {
			this.shaders = [];
		};
		return ShaderBatchCache;
	}();
	var _vertexShaderCache = new DeviceCache();
	var _fragmentShaderCache = new DeviceCache();
	var _shaderBatchCache = new DeviceCache();
	var WebglShader = function () {
		function WebglShader(shader) {
			this.compileDuration = 0;
			this.init();
			this.compile(shader.device, shader);
			WebglShader.getBatchShaders(shader.device).push(shader);
			shader.device.shaders.push(shader);
		}
		var _proto3 = WebglShader.prototype;
		_proto3.destroy = function destroy(shader) {
			if (this.glProgram) {
				shader.device.gl.deleteProgram(this.glProgram);
				this.glProgram = null;
			}
		};
		_proto3.init = function init() {
			this.uniforms = [];
			this.samplers = [];
			this.attributes = [];
			this.glProgram = null;
			this.glVertexShader = null;
			this.glFragmentShader = null;
		};
		WebglShader.getBatchShaders = function getBatchShaders(device) {
			var batchCache = _shaderBatchCache.get(device, function () {
				return new ShaderBatchCache();
			});
			return batchCache.shaders;
		};
		WebglShader.endShaderBatch = function endShaderBatch(device) {
			var shaders = WebglShader.getBatchShaders(device);
			shaders.forEach(function (shader) {
				return shader.impl.link(device, shader);
			});
			shaders.length = 0;
		};
		_proto3.loseContext = function loseContext() {
			this.init();
		};
		_proto3.restoreContext = function restoreContext(device, shader) {
			this.compile(device, shader);
		};
		_proto3.compile = function compile(device, shader) {
			var definition = shader.definition;
			this.glVertexShader = this._compileShaderSource(device, definition.vshader, true);
			this.glFragmentShader = this._compileShaderSource(device, definition.fshader, false);
		};
		_proto3.link = function link(device, shader) {
			if (this.glProgram) return;
			var gl = device.gl;
			if (gl.isContextLost()) {
				return;
			}
			var glProgram = gl.createProgram();
			this.glProgram = glProgram;
			gl.attachShader(glProgram, this.glVertexShader);
			gl.attachShader(glProgram, this.glFragmentShader);
			var definition = shader.definition;
			var attrs = definition.attributes;
			if (device.webgl2 && definition.useTransformFeedback) {
				var outNames = [];
				for (var attr in attrs) {
					if (attrs.hasOwnProperty(attr)) {
						outNames.push("out_" + attr);
					}
				}
				gl.transformFeedbackVaryings(glProgram, outNames, gl.INTERLEAVED_ATTRIBS);
			}
			for (var _attr in attrs) {
				if (attrs.hasOwnProperty(_attr)) {
					var semantic = attrs[_attr];
					var loc = semanticToLocation[semantic];
					gl.bindAttribLocation(glProgram, loc, _attr);
				}
			}
			gl.linkProgram(glProgram);
		};
		_proto3._compileShaderSource = function _compileShaderSource(device, src, isVertexShader) {
			var gl = device.gl;
			var shaderDeviceCache = isVertexShader ? _vertexShaderCache : _fragmentShaderCache;
			var shaderCache = shaderDeviceCache.get(device, function () {
				return new CompiledShaderCache();
			});
			var glShader = shaderCache.map.get(src);
			if (!glShader) {
				glShader = gl.createShader(isVertexShader ? gl.VERTEX_SHADER : gl.FRAGMENT_SHADER);
				if (!glShader && gl.isContextLost()) {
					return glShader;
				}
				gl.shaderSource(glShader, src);
				gl.compileShader(glShader);
				shaderCache.map.set(src, glShader);
			}
			return glShader;
		};
		_proto3.finalize = function finalize(device, shader) {
			var gl = device.gl;
			if (gl.isContextLost()) {
				return true;
			}
			if (!this.glProgram) this.link(device, shader);
			var glProgram = this.glProgram;
			var definition = shader.definition;
			var linkStatus = gl.getProgramParameter(glProgram, gl.LINK_STATUS);
			if (!linkStatus) {
				if (!this._isCompiled(device, shader, this.glVertexShader, definition.vshader, "vertex")) return false;
				if (!this._isCompiled(device, shader, this.glFragmentShader, definition.fshader, "fragment")) return false;
				var message = "Failed to link shader program. Error: " + gl.getProgramInfoLog(glProgram);
				console.error(message);
				return false;
			}
			var i = 0;
			var numAttributes = gl.getProgramParameter(glProgram, gl.ACTIVE_ATTRIBUTES);
			while (i < numAttributes) {
				var info = gl.getActiveAttrib(glProgram, i++);
				var location = gl.getAttribLocation(glProgram, info.name);
				if (_vertexShaderBuiltins.indexOf(info.name) !== -1) continue;
				if (definition.attributes[info.name] === undefined) {
					console.error("Vertex shader attribute \"" + info.name + "\" is not mapped to a semantic in shader definition, shader [" + shader.label + "]", shader);
					shader.failed = true;
				}
				var shaderInput = new WebglShaderInput(device, definition.attributes[info.name], device.pcUniformType[info.type], location);
				this.attributes.push(shaderInput);
			}
			i = 0;
			var numUniforms = gl.getProgramParameter(glProgram, gl.ACTIVE_UNIFORMS);
			while (i < numUniforms) {
				var _info = gl.getActiveUniform(glProgram, i++);
				var _location = gl.getUniformLocation(glProgram, _info.name);
				var _shaderInput = new WebglShaderInput(device, _info.name, device.pcUniformType[_info.type], _location);
				if (_info.type === gl.SAMPLER_2D || _info.type === gl.SAMPLER_CUBE || device.webgl2 && (_info.type === gl.SAMPLER_2D_SHADOW || _info.type === gl.SAMPLER_CUBE_SHADOW || _info.type === gl.SAMPLER_3D)) {
					this.samplers.push(_shaderInput);
				} else {
					this.uniforms.push(_shaderInput);
				}
			}
			shader.ready = true;
			return true;
		};
		_proto3._isCompiled = function _isCompiled(device, shader, glShader, source, shaderType) {
			var gl = device.gl;
			if (!gl.getShaderParameter(glShader, gl.COMPILE_STATUS)) {
				var infoLog = gl.getShaderInfoLog(glShader);
				var _this$_processError = this._processError(source, infoLog),
					code = _this$_processError[0];
					_this$_processError[1];
				var message = "Failed to compile " + shaderType + " shader:\n\n" + infoLog + "\n" + code;
				console.error(message);
				return false;
			}
			return true;
		};
		_proto3._processError = function _processError(src, infoLog) {
			var error = {};
			var code = '';
			if (src) {
				var lines = src.split('\n');
				var from = 0;
				var to = lines.length;
				if (infoLog && infoLog.startsWith('ERROR:')) {
					var match = infoLog.match(/^ERROR:\s([0-9]+):([0-9]+):\s*(.+)/);
					if (match) {
						error.message = match[3];
						error.line = parseInt(match[2], 10);
						from = Math.max(0, error.line - 6);
						to = Math.min(lines.length, error.line + 5);
					}
				}
				for (var i = from; i < to; i++) {
					code += i + 1 + ":\t" + lines[i] + '\n';
				}
				error.source = src;
			}
			return [code, error];
		};
		return WebglShader;
	}();

	function downsampleImage(image, size) {
		var srcW = image.width;
		var srcH = image.height;
		if (srcW > size || srcH > size) {
			var scale = size / Math.max(srcW, srcH);
			var dstW = Math.floor(srcW * scale);
			var dstH = Math.floor(srcH * scale);
			var canvas = document.createElement('canvas');
			canvas.width = dstW;
			canvas.height = dstH;
			var context = canvas.getContext('2d');
			context.drawImage(image, 0, 0, srcW, srcH, 0, 0, dstW, dstH);
			return canvas;
		}
		return image;
	}
	var WebglTexture = function () {
		function WebglTexture() {
			this._glTexture = null;
			this._glTarget = void 0;
			this._glFormat = void 0;
			this._glInternalFormat = void 0;
			this._glPixelType = void 0;
			this.dirtyParameterFlags = 0;
		}
		var _proto = WebglTexture.prototype;
		_proto.destroy = function destroy(device) {
			if (this._glTexture) {
				for (var i = 0; i < device.textureUnits.length; i++) {
					var textureUnit = device.textureUnits[i];
					for (var j = 0; j < textureUnit.length; j++) {
						if (textureUnit[j] === this._glTexture) {
							textureUnit[j] = null;
						}
					}
				}
				device.gl.deleteTexture(this._glTexture);
				this._glTexture = null;
			}
		};
		_proto.loseContext = function loseContext() {
			this._glTexture = null;
		};
		_proto.propertyChanged = function propertyChanged(flag) {
			this.dirtyParameterFlags |= flag;
		};
		_proto.initialize = function initialize(device, texture) {
			var gl = device.gl;
			this._glTexture = gl.createTexture();
			this._glTarget = texture._cubemap ? gl.TEXTURE_CUBE_MAP : texture._volume ? gl.TEXTURE_3D : gl.TEXTURE_2D;
			switch (texture._format) {
				case PIXELFORMAT_A8:
					this._glFormat = gl.ALPHA;
					this._glInternalFormat = gl.ALPHA;
					this._glPixelType = gl.UNSIGNED_BYTE;
					break;
				case PIXELFORMAT_L8:
					this._glFormat = gl.LUMINANCE;
					this._glInternalFormat = gl.LUMINANCE;
					this._glPixelType = gl.UNSIGNED_BYTE;
					break;
				case PIXELFORMAT_LA8:
					this._glFormat = gl.LUMINANCE_ALPHA;
					this._glInternalFormat = gl.LUMINANCE_ALPHA;
					this._glPixelType = gl.UNSIGNED_BYTE;
					break;
				case PIXELFORMAT_RGB565:
					this._glFormat = gl.RGB;
					this._glInternalFormat = gl.RGB;
					this._glPixelType = gl.UNSIGNED_SHORT_5_6_5;
					break;
				case PIXELFORMAT_RGBA5551:
					this._glFormat = gl.RGBA;
					this._glInternalFormat = gl.RGBA;
					this._glPixelType = gl.UNSIGNED_SHORT_5_5_5_1;
					break;
				case PIXELFORMAT_RGBA4:
					this._glFormat = gl.RGBA;
					this._glInternalFormat = gl.RGBA;
					this._glPixelType = gl.UNSIGNED_SHORT_4_4_4_4;
					break;
				case PIXELFORMAT_RGB8:
					this._glFormat = gl.RGB;
					this._glInternalFormat = device.webgl2 ? gl.RGB8 : gl.RGB;
					this._glPixelType = gl.UNSIGNED_BYTE;
					break;
				case PIXELFORMAT_RGBA8:
					this._glFormat = gl.RGBA;
					this._glInternalFormat = device.webgl2 ? gl.RGBA8 : gl.RGBA;
					this._glPixelType = gl.UNSIGNED_BYTE;
					break;
				case PIXELFORMAT_DXT1:
					this._glFormat = gl.RGB;
					this._glInternalFormat = device.extCompressedTextureS3TC.COMPRESSED_RGB_S3TC_DXT1_EXT;
					break;
				case PIXELFORMAT_DXT3:
					this._glFormat = gl.RGBA;
					this._glInternalFormat = device.extCompressedTextureS3TC.COMPRESSED_RGBA_S3TC_DXT3_EXT;
					break;
				case PIXELFORMAT_DXT5:
					this._glFormat = gl.RGBA;
					this._glInternalFormat = device.extCompressedTextureS3TC.COMPRESSED_RGBA_S3TC_DXT5_EXT;
					break;
				case PIXELFORMAT_ETC1:
					this._glFormat = gl.RGB;
					this._glInternalFormat = device.extCompressedTextureETC1.COMPRESSED_RGB_ETC1_WEBGL;
					break;
				case PIXELFORMAT_PVRTC_2BPP_RGB_1:
					this._glFormat = gl.RGB;
					this._glInternalFormat = device.extCompressedTexturePVRTC.COMPRESSED_RGB_PVRTC_2BPPV1_IMG;
					break;
				case PIXELFORMAT_PVRTC_2BPP_RGBA_1:
					this._glFormat = gl.RGBA;
					this._glInternalFormat = device.extCompressedTexturePVRTC.COMPRESSED_RGBA_PVRTC_2BPPV1_IMG;
					break;
				case PIXELFORMAT_PVRTC_4BPP_RGB_1:
					this._glFormat = gl.RGB;
					this._glInternalFormat = device.extCompressedTexturePVRTC.COMPRESSED_RGB_PVRTC_4BPPV1_IMG;
					break;
				case PIXELFORMAT_PVRTC_4BPP_RGBA_1:
					this._glFormat = gl.RGBA;
					this._glInternalFormat = device.extCompressedTexturePVRTC.COMPRESSED_RGBA_PVRTC_4BPPV1_IMG;
					break;
				case PIXELFORMAT_ETC2_RGB:
					this._glFormat = gl.RGB;
					this._glInternalFormat = device.extCompressedTextureETC.COMPRESSED_RGB8_ETC2;
					break;
				case PIXELFORMAT_ETC2_RGBA:
					this._glFormat = gl.RGBA;
					this._glInternalFormat = device.extCompressedTextureETC.COMPRESSED_RGBA8_ETC2_EAC;
					break;
				case PIXELFORMAT_ASTC_4x4:
					this._glFormat = gl.RGBA;
					this._glInternalFormat = device.extCompressedTextureASTC.COMPRESSED_RGBA_ASTC_4x4_KHR;
					break;
				case PIXELFORMAT_ATC_RGB:
					this._glFormat = gl.RGB;
					this._glInternalFormat = device.extCompressedTextureATC.COMPRESSED_RGB_ATC_WEBGL;
					break;
				case PIXELFORMAT_ATC_RGBA:
					this._glFormat = gl.RGBA;
					this._glInternalFormat = device.extCompressedTextureATC.COMPRESSED_RGBA_ATC_INTERPOLATED_ALPHA_WEBGL;
					break;
				case PIXELFORMAT_RGB16F:
					this._glFormat = gl.RGB;
					if (device.webgl2) {
						this._glInternalFormat = gl.RGB16F;
						this._glPixelType = gl.HALF_FLOAT;
					} else {
						this._glInternalFormat = gl.RGB;
						this._glPixelType = device.extTextureHalfFloat.HALF_FLOAT_OES;
					}
					break;
				case PIXELFORMAT_RGBA16F:
					this._glFormat = gl.RGBA;
					if (device.webgl2) {
						this._glInternalFormat = gl.RGBA16F;
						this._glPixelType = gl.HALF_FLOAT;
					} else {
						this._glInternalFormat = gl.RGBA;
						this._glPixelType = device.extTextureHalfFloat.HALF_FLOAT_OES;
					}
					break;
				case PIXELFORMAT_RGB32F:
					this._glFormat = gl.RGB;
					if (device.webgl2) {
						this._glInternalFormat = gl.RGB32F;
					} else {
						this._glInternalFormat = gl.RGB;
					}
					this._glPixelType = gl.FLOAT;
					break;
				case PIXELFORMAT_RGBA32F:
					this._glFormat = gl.RGBA;
					if (device.webgl2) {
						this._glInternalFormat = gl.RGBA32F;
					} else {
						this._glInternalFormat = gl.RGBA;
					}
					this._glPixelType = gl.FLOAT;
					break;
				case PIXELFORMAT_R32F:
					this._glFormat = gl.RED;
					this._glInternalFormat = gl.R32F;
					this._glPixelType = gl.FLOAT;
					break;
				case PIXELFORMAT_DEPTH:
					if (device.webgl2) {
						this._glFormat = gl.DEPTH_COMPONENT;
						this._glInternalFormat = gl.DEPTH_COMPONENT32F;
						this._glPixelType = gl.FLOAT;
					} else {
						this._glFormat = gl.DEPTH_COMPONENT;
						this._glInternalFormat = gl.DEPTH_COMPONENT;
						this._glPixelType = gl.UNSIGNED_SHORT;
					}
					break;
				case PIXELFORMAT_DEPTHSTENCIL:
					this._glFormat = gl.DEPTH_STENCIL;
					if (device.webgl2) {
						this._glInternalFormat = gl.DEPTH24_STENCIL8;
						this._glPixelType = gl.UNSIGNED_INT_24_8;
					} else {
						this._glInternalFormat = gl.DEPTH_STENCIL;
						this._glPixelType = device.extDepthTexture.UNSIGNED_INT_24_8_WEBGL;
					}
					break;
				case PIXELFORMAT_111110F:
					this._glFormat = gl.RGB;
					this._glInternalFormat = gl.R11F_G11F_B10F;
					this._glPixelType = gl.UNSIGNED_INT_10F_11F_11F_REV;
					break;
				case PIXELFORMAT_SRGB:
					this._glFormat = gl.RGB;
					this._glInternalFormat = gl.SRGB8;
					this._glPixelType = gl.UNSIGNED_BYTE;
					break;
				case PIXELFORMAT_SRGBA:
					this._glFormat = gl.RGBA;
					this._glInternalFormat = gl.SRGB8_ALPHA8;
					this._glPixelType = gl.UNSIGNED_BYTE;
					break;
			}
		};
		_proto.upload = function upload(device, texture) {
			var gl = device.gl;
			if (!texture._needsUpload && (texture._needsMipmapsUpload && texture._mipmapsUploaded || !texture.pot)) return;
			var mipLevel = 0;
			var mipObject;
			var resMult;
			var requiredMipLevels = texture.requiredMipLevels;
			while (texture._levels[mipLevel] || mipLevel === 0) {
				if (!texture._needsUpload && mipLevel === 0) {
					mipLevel++;
					continue;
				} else if (mipLevel && (!texture._needsMipmapsUpload || !texture._mipmaps)) {
					break;
				}
				mipObject = texture._levels[mipLevel];
				if (mipLevel === 1 && !texture._compressed && texture._levels.length < requiredMipLevels) {
					gl.generateMipmap(this._glTarget);
					texture._mipmapsUploaded = true;
				}
				if (texture._cubemap) {
					var face = void 0;
					if (device._isBrowserInterface(mipObject[0])) {
						for (face = 0; face < 6; face++) {
							if (!texture._levelsUpdated[0][face]) continue;
							var src = mipObject[face];
							if (device._isImageBrowserInterface(src)) {
								if (src.width > device.maxCubeMapSize || src.height > device.maxCubeMapSize) {
									src = downsampleImage(src, device.maxCubeMapSize);
									if (mipLevel === 0) {
										texture._width = src.width;
										texture._height = src.height;
									}
								}
							}
							device.setUnpackFlipY(false);
							device.setUnpackPremultiplyAlpha(texture._premultiplyAlpha);
							gl.texImage2D(gl.TEXTURE_CUBE_MAP_POSITIVE_X + face, mipLevel, this._glInternalFormat, this._glFormat, this._glPixelType, src);
						}
					} else {
						resMult = 1 / Math.pow(2, mipLevel);
						for (face = 0; face < 6; face++) {
							if (!texture._levelsUpdated[0][face]) continue;
							var texData = mipObject[face];
							if (texture._compressed) {
								gl.compressedTexImage2D(gl.TEXTURE_CUBE_MAP_POSITIVE_X + face, mipLevel, this._glInternalFormat, Math.max(texture._width * resMult, 1), Math.max(texture._height * resMult, 1), 0, texData);
							} else {
								device.setUnpackFlipY(false);
								device.setUnpackPremultiplyAlpha(texture._premultiplyAlpha);
								gl.texImage2D(gl.TEXTURE_CUBE_MAP_POSITIVE_X + face, mipLevel, this._glInternalFormat, Math.max(texture._width * resMult, 1), Math.max(texture._height * resMult, 1), 0, this._glFormat, this._glPixelType, texData);
							}
						}
					}
				} else if (texture._volume) {
					resMult = 1 / Math.pow(2, mipLevel);
					if (texture._compressed) {
						gl.compressedTexImage3D(gl.TEXTURE_3D, mipLevel, this._glInternalFormat, Math.max(texture._width * resMult, 1), Math.max(texture._height * resMult, 1), Math.max(texture._depth * resMult, 1), 0, mipObject);
					} else {
						device.setUnpackFlipY(false);
						device.setUnpackPremultiplyAlpha(texture._premultiplyAlpha);
						gl.texImage3D(gl.TEXTURE_3D, mipLevel, this._glInternalFormat, Math.max(texture._width * resMult, 1), Math.max(texture._height * resMult, 1), Math.max(texture._depth * resMult, 1), 0, this._glFormat, this._glPixelType, mipObject);
					}
				} else {
					if (device._isBrowserInterface(mipObject)) {
						if (device._isImageBrowserInterface(mipObject)) {
							if (mipObject.width > device.maxTextureSize || mipObject.height > device.maxTextureSize) {
								mipObject = downsampleImage(mipObject, device.maxTextureSize);
								if (mipLevel === 0) {
									texture._width = mipObject.width;
									texture._height = mipObject.height;
								}
							}
						}
						device.setUnpackFlipY(texture._flipY);
						device.setUnpackPremultiplyAlpha(texture._premultiplyAlpha);
						gl.texImage2D(gl.TEXTURE_2D, mipLevel, this._glInternalFormat, this._glFormat, this._glPixelType, mipObject);
					} else {
						resMult = 1 / Math.pow(2, mipLevel);
						if (texture._compressed) {
							gl.compressedTexImage2D(gl.TEXTURE_2D, mipLevel, this._glInternalFormat, Math.max(Math.floor(texture._width * resMult), 1), Math.max(Math.floor(texture._height * resMult), 1), 0, mipObject);
						} else {
							device.setUnpackFlipY(false);
							device.setUnpackPremultiplyAlpha(texture._premultiplyAlpha);
							gl.texImage2D(gl.TEXTURE_2D, mipLevel, this._glInternalFormat, Math.max(texture._width * resMult, 1), Math.max(texture._height * resMult, 1), 0, this._glFormat, this._glPixelType, mipObject);
						}
					}
					if (mipLevel === 0) {
						texture._mipmapsUploaded = false;
					} else {
						texture._mipmapsUploaded = true;
					}
				}
				mipLevel++;
			}
			if (texture._needsUpload) {
				if (texture._cubemap) {
					for (var i = 0; i < 6; i++) texture._levelsUpdated[0][i] = false;
				} else {
					texture._levelsUpdated[0] = false;
				}
			}
			if (!texture._compressed && texture._mipmaps && texture._needsMipmapsUpload && (texture.pot || device.webgl2) && texture._levels.length === 1) {
				gl.generateMipmap(this._glTarget);
				texture._mipmapsUploaded = true;
			}
			if (texture._gpuSize) {
				texture.adjustVramSizeTracking(device._vram, -texture._gpuSize);
			}
			texture._gpuSize = texture.gpuSize;
			texture.adjustVramSizeTracking(device._vram, texture._gpuSize);
		};
		return WebglTexture;
	}();

	var FramebufferPair = function () {
		function FramebufferPair(msaaFB, resolveFB) {
			this.msaaFB = void 0;
			this.resolveFB = void 0;
			this.msaaFB = msaaFB;
			this.resolveFB = resolveFB;
		}
		var _proto = FramebufferPair.prototype;
		_proto.destroy = function destroy(gl) {
			if (this.msaaFB) {
				gl.deleteRenderbuffer(this.msaaFB);
				this.msaaFB = null;
			}
			if (this.resolveFB) {
				gl.deleteRenderbuffer(this.resolveFB);
				this.resolveFB = null;
			}
		};
		return FramebufferPair;
	}();
	var WebglRenderTarget = function () {
		function WebglRenderTarget() {
			this._glFrameBuffer = null;
			this._glDepthBuffer = null;
			this._glResolveFrameBuffer = null;
			this.colorMrtFramebuffers = null;
			this._glMsaaColorBuffers = [];
			this._glMsaaDepthBuffer = null;
		}
		var _proto2 = WebglRenderTarget.prototype;
		_proto2.destroy = function destroy(device) {
			var _this$colorMrtFramebu;
			var gl = device.gl;
			if (this._glFrameBuffer) {
				gl.deleteFramebuffer(this._glFrameBuffer);
				this._glFrameBuffer = null;
			}
			if (this._glDepthBuffer) {
				gl.deleteRenderbuffer(this._glDepthBuffer);
				this._glDepthBuffer = null;
			}
			if (this._glResolveFrameBuffer) {
				gl.deleteFramebuffer(this._glResolveFrameBuffer);
				this._glResolveFrameBuffer = null;
			}
			this._glMsaaColorBuffers.forEach(function (buffer) {
				gl.deleteRenderbuffer(buffer);
			});
			this._glMsaaColorBuffers.length = 0;
			(_this$colorMrtFramebu = this.colorMrtFramebuffers) == null ? void 0 : _this$colorMrtFramebu.forEach(function (framebuffer) {
				framebuffer.destroy(gl);
			});
			this.colorMrtFramebuffers = null;
			if (this._glMsaaDepthBuffer) {
				gl.deleteRenderbuffer(this._glMsaaDepthBuffer);
				this._glMsaaDepthBuffer = null;
			}
		};
		_proto2.init = function init(device, target) {
			var _target$_colorBuffers, _target$_colorBuffers2, _device$extDrawBuffer, _device$extDrawBuffer2;
			var gl = device.gl;
			this._glFrameBuffer = gl.createFramebuffer();
			device.setFramebuffer(this._glFrameBuffer);
			var colorBufferCount = (_target$_colorBuffers = (_target$_colorBuffers2 = target._colorBuffers) == null ? void 0 : _target$_colorBuffers2.length) != null ? _target$_colorBuffers : 0;
			var attachmentBaseConstant = device.webgl2 ? gl.COLOR_ATTACHMENT0 : (_device$extDrawBuffer = (_device$extDrawBuffer2 = device.extDrawBuffers) == null ? void 0 : _device$extDrawBuffer2.COLOR_ATTACHMENT0_WEBGL) != null ? _device$extDrawBuffer : gl.COLOR_ATTACHMENT0;
			var buffers = [];
			for (var i = 0; i < colorBufferCount; ++i) {
				var colorBuffer = target.getColorBuffer(i);
				if (colorBuffer) {
					if (!colorBuffer.impl._glTexture) {
						colorBuffer._width = Math.min(colorBuffer.width, device.maxRenderBufferSize);
						colorBuffer._height = Math.min(colorBuffer.height, device.maxRenderBufferSize);
						device.setTexture(colorBuffer, 0);
					}
					gl.framebufferTexture2D(gl.FRAMEBUFFER, attachmentBaseConstant + i, colorBuffer._cubemap ? gl.TEXTURE_CUBE_MAP_POSITIVE_X + target._face : gl.TEXTURE_2D, colorBuffer.impl._glTexture, 0);
					buffers.push(attachmentBaseConstant + i);
				}
			}
			if (device.drawBuffers) {
				device.drawBuffers(buffers);
			}
			var depthBuffer = target._depthBuffer;
			if (depthBuffer) {
				if (!depthBuffer.impl._glTexture) {
					depthBuffer._width = Math.min(depthBuffer.width, device.maxRenderBufferSize);
					depthBuffer._height = Math.min(depthBuffer.height, device.maxRenderBufferSize);
					device.setTexture(depthBuffer, 0);
				}
				if (target._stencil) {
					gl.framebufferTexture2D(gl.FRAMEBUFFER, gl.DEPTH_STENCIL_ATTACHMENT, depthBuffer._cubemap ? gl.TEXTURE_CUBE_MAP_POSITIVE_X + target._face : gl.TEXTURE_2D, target._depthBuffer.impl._glTexture, 0);
				} else {
					gl.framebufferTexture2D(gl.FRAMEBUFFER, gl.DEPTH_ATTACHMENT, depthBuffer._cubemap ? gl.TEXTURE_CUBE_MAP_POSITIVE_X + target._face : gl.TEXTURE_2D, target._depthBuffer.impl._glTexture, 0);
				}
			} else if (target._depth) {
				var willRenderMsaa = target._samples > 1 && device.webgl2;
				if (!willRenderMsaa) {
					if (!this._glDepthBuffer) {
						this._glDepthBuffer = gl.createRenderbuffer();
					}
					gl.bindRenderbuffer(gl.RENDERBUFFER, this._glDepthBuffer);
					if (target._stencil) {
						gl.renderbufferStorage(gl.RENDERBUFFER, gl.DEPTH_STENCIL, target.width, target.height);
						gl.framebufferRenderbuffer(gl.FRAMEBUFFER, gl.DEPTH_STENCIL_ATTACHMENT, gl.RENDERBUFFER, this._glDepthBuffer);
					} else {
						var depthFormat = device.webgl2 ? gl.DEPTH_COMPONENT32F : gl.DEPTH_COMPONENT16;
						gl.renderbufferStorage(gl.RENDERBUFFER, depthFormat, target.width, target.height);
						gl.framebufferRenderbuffer(gl.FRAMEBUFFER, gl.DEPTH_ATTACHMENT, gl.RENDERBUFFER, this._glDepthBuffer);
					}
					gl.bindRenderbuffer(gl.RENDERBUFFER, null);
				}
			}
			if (device.webgl2 && target._samples > 1) {
				var _target$_colorBuffers3, _target$_colorBuffers4;
				this._glResolveFrameBuffer = this._glFrameBuffer;
				this._glFrameBuffer = gl.createFramebuffer();
				device.setFramebuffer(this._glFrameBuffer);
				var _colorBufferCount = (_target$_colorBuffers3 = (_target$_colorBuffers4 = target._colorBuffers) == null ? void 0 : _target$_colorBuffers4.length) != null ? _target$_colorBuffers3 : 0;
				for (var _i = 0; _i < _colorBufferCount; ++_i) {
					var _colorBuffer = target.getColorBuffer(_i);
					if (_colorBuffer) {
						var buffer = gl.createRenderbuffer();
						this._glMsaaColorBuffers.push(buffer);
						gl.bindRenderbuffer(gl.RENDERBUFFER, buffer);
						gl.renderbufferStorageMultisample(gl.RENDERBUFFER, target._samples, _colorBuffer.impl._glInternalFormat, target.width, target.height);
						gl.framebufferRenderbuffer(gl.FRAMEBUFFER, gl.COLOR_ATTACHMENT0 + _i, gl.RENDERBUFFER, buffer);
					}
				}
				if (target._depth) {
					if (!this._glMsaaDepthBuffer) {
						this._glMsaaDepthBuffer = gl.createRenderbuffer();
					}
					gl.bindRenderbuffer(gl.RENDERBUFFER, this._glMsaaDepthBuffer);
					if (target._stencil) {
						gl.renderbufferStorageMultisample(gl.RENDERBUFFER, target._samples, gl.DEPTH24_STENCIL8, target.width, target.height);
						gl.framebufferRenderbuffer(gl.FRAMEBUFFER, gl.DEPTH_STENCIL_ATTACHMENT, gl.RENDERBUFFER, this._glMsaaDepthBuffer);
					} else {
						gl.renderbufferStorageMultisample(gl.RENDERBUFFER, target._samples, gl.DEPTH_COMPONENT32F, target.width, target.height);
						gl.framebufferRenderbuffer(gl.FRAMEBUFFER, gl.DEPTH_ATTACHMENT, gl.RENDERBUFFER, this._glMsaaDepthBuffer);
					}
				}
				if (_colorBufferCount > 1) {
					this._createMsaaMrtFramebuffers(device, target, _colorBufferCount);
					device.setFramebuffer(this._glFrameBuffer);
					device.drawBuffers(buffers);
				}
			}
		};
		_proto2._createMsaaMrtFramebuffers = function _createMsaaMrtFramebuffers(device, target, colorBufferCount) {
			var gl = device.gl;
			this.colorMrtFramebuffers = [];
			for (var i = 0; i < colorBufferCount; ++i) {
				var colorBuffer = target.getColorBuffer(i);
				var srcFramebuffer = gl.createFramebuffer();
				device.setFramebuffer(srcFramebuffer);
				var buffer = this._glMsaaColorBuffers[i];
				gl.bindRenderbuffer(gl.RENDERBUFFER, buffer);
				gl.renderbufferStorageMultisample(gl.RENDERBUFFER, target._samples, colorBuffer.impl._glInternalFormat, target.width, target.height);
				gl.framebufferRenderbuffer(gl.FRAMEBUFFER, gl.COLOR_ATTACHMENT0, gl.RENDERBUFFER, buffer);
				device.drawBuffers([gl.COLOR_ATTACHMENT0]);
				var dstFramebuffer = gl.createFramebuffer();
				device.setFramebuffer(dstFramebuffer);
				gl.framebufferTexture2D(gl.FRAMEBUFFER, gl.COLOR_ATTACHMENT0, colorBuffer._cubemap ? gl.TEXTURE_CUBE_MAP_POSITIVE_X + target._face : gl.TEXTURE_2D, colorBuffer.impl._glTexture, 0);
				this.colorMrtFramebuffers[i] = new FramebufferPair(srcFramebuffer, dstFramebuffer);
			}
		};
		_proto2._checkFbo = function _checkFbo(device, target, type) {
			var gl = device.gl;
			var status = gl.checkFramebufferStatus(gl.FRAMEBUFFER);
			switch (status) {
				case gl.FRAMEBUFFER_INCOMPLETE_ATTACHMENT:
					break;
				case gl.FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:
					break;
				case gl.FRAMEBUFFER_INCOMPLETE_DIMENSIONS:
					break;
				case gl.FRAMEBUFFER_UNSUPPORTED:
					break;
			}
		};
		_proto2.loseContext = function loseContext() {
			this._glFrameBuffer = null;
			this._glDepthBuffer = null;
			this._glResolveFrameBuffer = null;
			this._glMsaaColorBuffers.length = 0;
			this._glMsaaDepthBuffer = null;
			this.colorMrtFramebuffers = null;
		};
		_proto2.internalResolve = function internalResolve(device, src, dst, target, mask) {
			var gl = device.gl;
			gl.bindFramebuffer(gl.READ_FRAMEBUFFER, src);
			gl.bindFramebuffer(gl.DRAW_FRAMEBUFFER, dst);
			gl.blitFramebuffer(0, 0, target.width, target.height, 0, 0, target.width, target.height, mask, gl.NEAREST);
		};
		_proto2.resolve = function resolve(device, target, color, depth) {
			if (device.webgl2) {
				var gl = device.gl;
				if (this.colorMrtFramebuffers) {
					if (color) {
						for (var i = 0; i < this.colorMrtFramebuffers.length; i++) {
							var fbPair = this.colorMrtFramebuffers[i];
							this.internalResolve(device, fbPair.msaaFB, fbPair.resolveFB, target, gl.COLOR_BUFFER_BIT);
						}
					}
					if (depth) {
						this.internalResolve(device, this._glFrameBuffer, this._glResolveFrameBuffer, target, gl.DEPTH_BUFFER_BIT);
					}
				} else {
					this.internalResolve(device, this._glFrameBuffer, this._glResolveFrameBuffer, target, (color ? gl.COLOR_BUFFER_BIT : 0) | (depth ? gl.DEPTH_BUFFER_BIT : 0));
				}
				gl.bindFramebuffer(gl.FRAMEBUFFER, this._glFrameBuffer);
			}
		};
		_createClass(WebglRenderTarget, [{
			key: "initialized",
			get: function get() {
				return this._glFrameBuffer !== null;
			}
		}]);
		return WebglRenderTarget;
	}();

	var gles2PS = "\n\n#define pcFragColor0 gl_FragData[0]\n\n#if COLOR_ATTACHMENT_1\n#define pcFragColor1 gl_FragData[1]\n#endif\n\n#if COLOR_ATTACHMENT_2\n#define pcFragColor2 gl_FragData[2]\n#endif\n\n#if COLOR_ATTACHMENT_3\n#define pcFragColor3 gl_FragData[3]\n#endif\n\n#if COLOR_ATTACHMENT_4\n#define pcFragColor4 gl_FragData[4]\n#endif\n\n#if COLOR_ATTACHMENT_5\n#define pcFragColor5 gl_FragData[5]\n#endif\n\n#if COLOR_ATTACHMENT_6\n#define pcFragColor6 gl_FragData[6]\n#endif\n\n#if COLOR_ATTACHMENT_7\n#define pcFragColor7 gl_FragData[7]\n#endif\n\n#define texture2DBias texture2D\n\n// pass / accept shadow map or texture as a function parameter, on webgl this is simply passed as is\n// but this is needed for WebGPU\n#define SHADOWMAP_PASS(name) name\n#define SHADOWMAP_ACCEPT(name) sampler2D name\n#define TEXTURE_PASS(name) name\n#define TEXTURE_ACCEPT(name) sampler2D name\n\n#ifndef SUPPORTS_TEXLOD\n\n    // fallback for lod instructions\n    #define texture2DLodEXT texture2D\n    #define texture2DProjLodEXT textureProj\n    #define textureCubeLodEXT textureCube\n    #define textureShadow texture2D\n\n#else\n\n    #define textureShadow(res, uv) texture2DGradEXT(res, uv, vec2(1, 1), vec2(1, 1))\n\n#endif\n\n#ifdef SUPPORTS_MRT\n    #define gl_FragColor pcFragColor0\n#endif\n\n";

	var gles3PS = "\nlayout(location = 0) out highp vec4 pc_fragColor;\n\n#ifndef REMOVE_COLOR_ATTACHMENT_1\n#if COLOR_ATTACHMENT_1\nlayout(location = 1) out highp vec4 pc_fragColor1;\n#endif\n#endif\n\n#ifndef REMOVE_COLOR_ATTACHMENT_2\n#if COLOR_ATTACHMENT_2\nlayout(location = 2) out highp vec4 pc_fragColor2;\n#endif\n#endif\n\n#ifndef REMOVE_COLOR_ATTACHMENT_3\n#if COLOR_ATTACHMENT_3\nlayout(location = 3) out highp vec4 pc_fragColor3;\n#endif\n#endif\n\n#ifndef REMOVE_COLOR_ATTACHMENT_4\n#if COLOR_ATTACHMENT_4\nlayout(location = 4) out highp vec4 pc_fragColor4;\n#endif\n#endif\n\n#ifndef REMOVE_COLOR_ATTACHMENT_5\n#if COLOR_ATTACHMENT_5\nlayout(location = 5) out highp vec4 pc_fragColor5;\n#endif\n#endif\n\n#ifndef REMOVE_COLOR_ATTACHMENT_6\n#if COLOR_ATTACHMENT_6\nlayout(location = 6) out highp vec4 pc_fragColor6;\n#endif\n#endif\n\n#ifndef REMOVE_COLOR_ATTACHMENT_7\n#if COLOR_ATTACHMENT_7\nlayout(location = 7) out highp vec4 pc_fragColor7;\n#endif\n#endif\n\n#define gl_FragColor pc_fragColor\n\n#define pcFragColor0 pc_fragColor\n#define pcFragColor1 pc_fragColor1\n#define pcFragColor2 pc_fragColor2\n#define pcFragColor3 pc_fragColor3\n#define pcFragColor4 pc_fragColor4\n#define pcFragColor5 pc_fragColor5\n#define pcFragColor6 pc_fragColor6\n#define pcFragColor7 pc_fragColor7\n\n#define varying in\n\n#define texture2D texture\n#define texture2DBias texture\n#define textureCube texture\n#define texture2DProj textureProj\n#define texture2DLodEXT textureLod\n#define texture2DProjLodEXT textureProjLod\n#define textureCubeLodEXT textureLod\n#define texture2DGradEXT textureGrad\n#define texture2DProjGradEXT textureProjGrad\n#define textureCubeGradEXT textureGrad\n\n// sample shadows using textureGrad to remove derivatives in the dynamic loops (which are used by\n// clustered lighting) - as DirectX shader compiler tries to unroll the loops and takes long time\n// to compile the shader. Using textureLod would be even better, but WebGl does not translate it to\n// lod instruction for DirectX correctly and uses SampleCmp instead of SampleCmpLevelZero or similar.\n#define textureShadow(res, uv) textureGrad(res, uv, vec2(1, 1), vec2(1, 1))\n\n// pass / accept shadow map or texture as a function parameter, on webgl this is simply passed as is\n// but this is needed for WebGPU\n#define SHADOWMAP_PASS(name) name\n#define SHADOWMAP_ACCEPT(name) sampler2DShadow name\n#define TEXTURE_PASS(name) name\n#define TEXTURE_ACCEPT(name) sampler2D name\n\n#define GL2\n#define SUPPORTS_TEXLOD\n#define SUPPORTS_MRT\n";

	var gles3VS = "\n#define attribute in\n#define varying out\n#define texture2D texture\n#define GL2\n#define VERTEXSHADER\n";

	var webgpuPS = "\n\n// texelFetch support and others\n#extension GL_EXT_samplerless_texture_functions : require\n\nlayout(location = 0) out highp vec4 pc_fragColor;\nlayout(location = 1) out highp vec4 pc_fragColor1;\nlayout(location = 2) out highp vec4 pc_fragColor2;\nlayout(location = 3) out highp vec4 pc_fragColor3;\nlayout(location = 4) out highp vec4 pc_fragColor4;\nlayout(location = 5) out highp vec4 pc_fragColor5;\nlayout(location = 6) out highp vec4 pc_fragColor6;\nlayout(location = 7) out highp vec4 pc_fragColor7;\n\n#define gl_FragColor pc_fragColor\n\n#define pcFragColor0 pc_fragColor\n#define pcFragColor1 pc_fragColor1\n#define pcFragColor2 pc_fragColor2\n#define pcFragColor3 pc_fragColor3\n#define pcFragColor4 pc_fragColor4\n#define pcFragColor5 pc_fragColor5\n#define pcFragColor6 pc_fragColor6\n#define pcFragColor7 pc_fragColor7\n\n#define texture2D(res, uv) texture(sampler2D(res, res ## _sampler), uv)\n#define texture2DBias(res, uv, bias) texture(sampler2D(res, res ## _sampler), uv, bias)\n#define texture2DLodEXT(res, uv, lod) textureLod(sampler2D(res, res ## _sampler), uv, lod)\n#define textureCube(res, uv) texture(samplerCube(res, res ## _sampler), uv)\n#define textureCubeLodEXT(res, uv, lod) textureLod(samplerCube(res, res ## _sampler), uv, lod)\n#define textureShadow(res, uv) textureLod(sampler2DShadow(res, res ## _sampler), uv, 0.0)\n\n// TODO: implement other texture sampling macros\n// #define texture2DProj textureProj\n// #define texture2DProjLodEXT textureProjLod\n// #define texture2DGradEXT textureGrad\n// #define texture2DProjGradEXT textureProjGrad\n// #define textureCubeGradEXT textureGrad\n\n// pass / accept shadow map as a function parameter, passes both the texture as well as sampler\n// as the combined sampler can be only created at a point of use\n#define SHADOWMAP_PASS(name) name, name ## _sampler\n#define SHADOWMAP_ACCEPT(name) texture2D name, sampler name ## _sampler\n#define TEXTURE_PASS(name) name, name ## _sampler\n#define TEXTURE_ACCEPT(name) texture2D name, sampler name ## _sampler\n\n#define GL2\n#define WEBGPU\n#define SUPPORTS_TEXLOD\n#define SUPPORTS_MRT\n";

	var webgpuVS = "\n\n// texelFetch support and others\n#extension GL_EXT_samplerless_texture_functions : require\n\n#define texture2D(res, uv) texture(sampler2D(res, res ## _sampler), uv)\n\n#define GL2\n#define WEBGPU\n#define VERTEXSHADER\n";

	var sharedFS = "\n\n// convert clip space position into texture coordinates to sample scene grab textures\nvec2 getGrabScreenPos(vec4 clipPos) {\n    vec2 uv = (clipPos.xy / clipPos.w) * 0.5 + 0.5;\n\n    #ifdef WEBGPU\n        uv.y = 1.0 - uv.y;\n    #endif\n\n    return uv;\n}\n\n// convert uv coordinates to sample image effect texture (render target texture rendered without\n// forward renderer which does the flip in the projection matrix)\nvec2 getImageEffectUV(vec2 uv) {\n    #ifdef WEBGPU\n        uv.y = 1.0 - uv.y;\n    #endif\n\n    return uv;\n}\n";

	var _attrib2Semantic = {
		vertex_position: SEMANTIC_POSITION,
		vertex_normal: SEMANTIC_NORMAL,
		vertex_tangent: SEMANTIC_TANGENT,
		vertex_texCoord0: SEMANTIC_TEXCOORD0,
		vertex_texCoord1: SEMANTIC_TEXCOORD1,
		vertex_texCoord2: SEMANTIC_TEXCOORD2,
		vertex_texCoord3: SEMANTIC_TEXCOORD3,
		vertex_texCoord4: SEMANTIC_TEXCOORD4,
		vertex_texCoord5: SEMANTIC_TEXCOORD5,
		vertex_texCoord6: SEMANTIC_TEXCOORD6,
		vertex_texCoord7: SEMANTIC_TEXCOORD7,
		vertex_color: SEMANTIC_COLOR,
		vertex_boneIndices: SEMANTIC_BLENDINDICES,
		vertex_boneWeights: SEMANTIC_BLENDWEIGHT
	};
	var ShaderUtils = function () {
		function ShaderUtils() {}
		ShaderUtils.createDefinition = function createDefinition(device, options) {
			var _options$name, _options$attributes;
			var getDefines = function getDefines(gpu, gl2, gl1, isVertex) {
				var deviceIntro = device.isWebGPU ? gpu : device.webgl2 ? gl2 : ShaderUtils.gl1Extensions(device, options) + gl1;
				var attachmentsDefine = '';
				for (var i = 0; i < device.maxColorAttachments; i++) {
					attachmentsDefine += "#define COLOR_ATTACHMENT_" + i + "\n";
				}
				return attachmentsDefine + deviceIntro;
			};
			var name = (_options$name = options.name) != null ? _options$name : 'Untitled';
			var vertDefines = options.vertexDefines || getDefines(webgpuVS, gles3VS, '');
			var vertCode = ShaderUtils.versionCode(device) + vertDefines + sharedFS + ShaderUtils.getShaderNameCode(name) + options.vertexCode;
			var fragDefines = options.fragmentDefines || getDefines(webgpuPS, gles3PS, gles2PS);
			var fragCode = (options.fragmentPreamble || '') + ShaderUtils.versionCode(device) + fragDefines + ShaderUtils.precisionCode(device) + '\n' + sharedFS + ShaderUtils.getShaderNameCode(name) + (options.fragmentCode || ShaderUtils.dummyFragmentCode());
			var attribs = (_options$attributes = options.attributes) != null ? _options$attributes : ShaderUtils.collectAttributes(options.vertexCode);
			return {
				name: name,
				attributes: attribs,
				vshader: vertCode,
				fshader: fragCode,
				useTransformFeedback: options.useTransformFeedback
			};
		};
		ShaderUtils.getShaderNameCode = function getShaderNameCode(name) {
			return "#define SHADER_NAME " + name + "\n";
		};
		ShaderUtils.gl1Extensions = function gl1Extensions(device, options, isVertex) {
			var code;
			if (isVertex) {
				code = options.vertexExtensions ? options.vertexExtensions + "\n" : '';
			} else {
				code = options.fragmentExtensions ? options.fragmentExtensions + "\n" : '';
				if (device.extStandardDerivatives) {
					code += "#extension GL_OES_standard_derivatives : enable\n";
				}
				if (device.extTextureLod) {
					code += "#extension GL_EXT_shader_texture_lod : enable\n";
					code += "#define SUPPORTS_TEXLOD\n";
				}
				if (device.extDrawBuffers) {
					code += "#extension GL_EXT_draw_buffers : require\n";
					code += "#define SUPPORTS_MRT\n";
				}
			}
			return code;
		};
		ShaderUtils.dummyFragmentCode = function dummyFragmentCode() {
			return "void main(void) {gl_FragColor = vec4(0.0);}";
		};
		ShaderUtils.versionCode = function versionCode(device) {
			if (device.isWebGPU) {
				return '#version 450\n';
			}
			return device.webgl2 ? "#version 300 es\n" : "";
		};
		ShaderUtils.precisionCode = function precisionCode(device, forcePrecision) {
			var code = '';
			if (forcePrecision && forcePrecision !== 'highp' && forcePrecision !== 'mediump' && forcePrecision !== 'lowp') {
				forcePrecision = null;
			}
			if (forcePrecision) {
				if (forcePrecision === 'highp' && device.maxPrecision !== 'highp') {
					forcePrecision = 'mediump';
				}
				if (forcePrecision === 'mediump' && device.maxPrecision === 'lowp') {
					forcePrecision = 'lowp';
				}
			}
			var precision = forcePrecision ? forcePrecision : device.precision;
			if (!device.isWebGPU) {
				code = "precision " + precision + " float;\n";
				if (device.webgl2) {
					code += "precision " + precision + " sampler2DShadow;\n";
				}
			} else {
				code = "precision " + precision + " float;\nprecision " + precision + " int;\n";
			}
			return code;
		};
		ShaderUtils.collectAttributes = function collectAttributes(vsCode) {
			var attribs = {};
			var attrs = 0;
			var found = vsCode.indexOf("attribute");
			while (found >= 0) {
				if (found > 0 && vsCode[found - 1] === "/") break;
				var endOfLine = vsCode.indexOf(';', found);
				var startOfAttribName = vsCode.lastIndexOf(' ', endOfLine);
				var attribName = vsCode.substring(startOfAttribName + 1, endOfLine);
				var semantic = _attrib2Semantic[attribName];
				if (semantic !== undefined) {
					attribs[attribName] = semantic;
				} else {
					attribs[attribName] = "ATTR" + attrs;
					attrs++;
				}
				found = vsCode.indexOf("attribute", found + 1);
			}
			return attribs;
		};
		return ShaderUtils;
	}();

	var FrameQueriesInfo = function () {
		function FrameQueriesInfo() {
			this.renderVersion = void 0;
			this.queries = [];
		}
		var _proto = FrameQueriesInfo.prototype;
		_proto.destroy = function destroy(gl) {
			this.queries.forEach(function (query) {
				return gl.deleteQuery(query);
			});
			this.queries = null;
		};
		return FrameQueriesInfo;
	}();
	var WebglGpuProfiler = function (_GpuProfiler) {
		_inheritsLoose(WebglGpuProfiler, _GpuProfiler);
		function WebglGpuProfiler(device) {
			var _this;
			_this = _GpuProfiler.call(this) || this;
			_this.device = void 0;
			_this.freeQueries = [];
			_this.frameQueries = [];
			_this.previousFrameQueries = [];
			_this.timings = [];
			_this.device = device;
			_this.ext = device.extDisjointTimerQuery;
			return _this;
		}
		var _proto2 = WebglGpuProfiler.prototype;
		_proto2.destroy = function destroy() {
			var _this2 = this;
			this.freeQueries.forEach(function (query) {
				return _this2.device.gl.deleteQuery(query);
			});
			this.frameQueries.forEach(function (query) {
				return _this2.device.gl.deleteQuery(query);
			});
			this.previousFrameQueries.forEach(function (frameQueriesInfo) {
				return frameQueriesInfo.destroy(_this2.device.gl);
			});
			this.freeQueries = null;
			this.frameQueries = null;
			this.previousFrameQueries = null;
		};
		_proto2.loseContext = function loseContext() {
			_GpuProfiler.prototype.loseContext.call(this);
			this.freeQueries = [];
			this.frameQueries = [];
			this.previousFrameQueries = [];
		};
		_proto2.restoreContext = function restoreContext() {
			this.ext = this.device.extDisjointTimerQuery;
		};
		_proto2.getQuery = function getQuery() {
			var _this$freeQueries$pop;
			return (_this$freeQueries$pop = this.freeQueries.pop()) != null ? _this$freeQueries$pop : this.device.gl.createQuery();
		};
		_proto2.start = function start(name) {
			if (this.ext) {
				var slot = this.getSlot(name);
				var query = this.getQuery();
				this.frameQueries[slot] = query;
				this.device.gl.beginQuery(this.ext.TIME_ELAPSED_EXT, query);
				return slot;
			}
			return undefined;
		};
		_proto2.end = function end(slot) {
			if (slot !== undefined) {
				this.device.gl.endQuery(this.ext.TIME_ELAPSED_EXT);
			}
		};
		_proto2.frameStart = function frameStart() {
			this.processEnableRequest();
			if (this._enabled) {
				this.frameGPUMarkerSlot = this.start('GpuFrame');
			}
		};
		_proto2.frameEnd = function frameEnd() {
			if (this._enabled) {
				this.end(this.frameGPUMarkerSlot);
			}
		};
		_proto2.request = function request() {
			var _this3 = this;
			if (this._enabled) {
				var ext = this.ext;
				var gl = this.device.gl;
				var renderVersion = this.device.renderVersion;
				var frameQueries = this.frameQueries;
				if (frameQueries.length > 0) {
					this.frameQueries = [];
					var frameQueriesInfo = new FrameQueriesInfo();
					frameQueriesInfo.queries = frameQueries;
					frameQueriesInfo.renderVersion = renderVersion;
					this.previousFrameQueries.push(frameQueriesInfo);
				}
				if (this.previousFrameQueries.length > 0) {
					var previousQueriesInfo = this.previousFrameQueries[0];
					var previousQueries = previousQueriesInfo.queries;
					var lastQuery = previousQueries[previousQueries.length - 1];
					var available = gl.getQueryParameter(lastQuery, gl.QUERY_RESULT_AVAILABLE);
					var disjoint = gl.getParameter(ext.GPU_DISJOINT_EXT);
					if (available && !disjoint) {
						this.previousFrameQueries.shift();
						var timings = this.timings;
						timings.length = 0;
						for (var i = 0; i < previousQueries.length; i++) {
							var query = previousQueries[i];
							var duration = gl.getQueryParameter(query, gl.QUERY_RESULT);
							timings[i] = duration * 0.000001;
							this.freeQueries.push(query);
						}
						this.report(previousQueriesInfo.renderVersion, timings);
					}
					if (disjoint) {
						this.previousFrameQueries.forEach(function (frameQueriesInfo) {
							_this3.report(frameQueriesInfo.renderVersion, null);
							frameQueriesInfo.destroy(gl);
						});
						this.previousFrameQueries.length = 0;
					}
				}
				_GpuProfiler.prototype.request.call(this, renderVersion);
			}
		};
		return WebglGpuProfiler;
	}(GpuProfiler);

	var invalidateAttachments = [];
	var _fullScreenQuadVS = "\nattribute vec2 vertex_position;\nvarying vec2 vUv0;\nvoid main(void)\n{\n    gl_Position = vec4(vertex_position, 0.5, 1.0);\n    vUv0 = vertex_position.xy*0.5+0.5;\n}\n";
	var _precisionTest1PS = "\nvoid main(void) { \n    gl_FragColor = vec4(2147483648.0);\n}\n";
	var _precisionTest2PS = "\nuniform sampler2D source;\nvec4 packFloat(float depth) {\n    const vec4 bit_shift = vec4(256.0 * 256.0 * 256.0, 256.0 * 256.0, 256.0, 1.0);\n    const vec4 bit_mask  = vec4(0.0, 1.0 / 256.0, 1.0 / 256.0, 1.0 / 256.0);\n    vec4 res = mod(depth * bit_shift * vec4(255), vec4(256) ) / vec4(255);\n    res -= res.xxyz * bit_mask;\n    return res;\n}\nvoid main(void) {\n    float c = texture2D(source, vec2(0.0)).r;\n    float diff = abs(c - 2147483648.0) / 2147483648.0;\n    gl_FragColor = packFloat(diff);\n}\n";
	var _outputTexture2D = "\nvarying vec2 vUv0;\nuniform sampler2D source;\nvoid main(void) {\n    gl_FragColor = texture2D(source, vUv0);\n}\n";
	function quadWithShader(device, target, shader) {
		var oldRt = device.renderTarget;
		device.setRenderTarget(target);
		device.updateBegin();
		device.setCullMode(CULLFACE_NONE);
		device.setBlendState(BlendState.NOBLEND);
		device.setDepthState(DepthState.NODEPTH);
		device.setStencilState(null, null);
		device.setVertexBuffer(device.quadVertexBuffer, 0);
		device.setShader(shader);
		device.draw({
			type: PRIMITIVE_TRISTRIP,
			base: 0,
			count: 4,
			indexed: false
		});
		device.updateEnd();
		device.setRenderTarget(oldRt);
		device.updateBegin();
	}
	function testRenderable(gl, pixelFormat) {
		var result = true;
		var texture = gl.createTexture();
		gl.bindTexture(gl.TEXTURE_2D, texture);
		gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, gl.NEAREST);
		gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MAG_FILTER, gl.NEAREST);
		gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_S, gl.CLAMP_TO_EDGE);
		gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_T, gl.CLAMP_TO_EDGE);
		gl.texImage2D(gl.TEXTURE_2D, 0, gl.RGBA, 2, 2, 0, gl.RGBA, pixelFormat, null);
		var framebuffer = gl.createFramebuffer();
		gl.bindFramebuffer(gl.FRAMEBUFFER, framebuffer);
		gl.framebufferTexture2D(gl.FRAMEBUFFER, gl.COLOR_ATTACHMENT0, gl.TEXTURE_2D, texture, 0);
		if (gl.checkFramebufferStatus(gl.FRAMEBUFFER) !== gl.FRAMEBUFFER_COMPLETE) {
			result = false;
		}
		gl.bindTexture(gl.TEXTURE_2D, null);
		gl.deleteTexture(texture);
		gl.bindFramebuffer(gl.FRAMEBUFFER, null);
		gl.deleteFramebuffer(framebuffer);
		return result;
	}
	function testTextureHalfFloatUpdatable(gl, pixelFormat) {
		var result = true;
		var texture = gl.createTexture();
		gl.bindTexture(gl.TEXTURE_2D, texture);
		gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, gl.NEAREST);
		gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MAG_FILTER, gl.NEAREST);
		gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_S, gl.CLAMP_TO_EDGE);
		gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_T, gl.CLAMP_TO_EDGE);
		var data = new Uint16Array(4 * 2 * 2);
		gl.texImage2D(gl.TEXTURE_2D, 0, gl.RGBA, 2, 2, 0, gl.RGBA, pixelFormat, data);
		if (gl.getError() !== gl.NO_ERROR) {
			result = false;
			console.log("Above error related to HALF_FLOAT_OES can be ignored, it was triggered by testing half float texture support");
		}
		gl.bindTexture(gl.TEXTURE_2D, null);
		gl.deleteTexture(texture);
		return result;
	}
	function testTextureFloatHighPrecision(device) {
		if (!device.textureFloatRenderable) return false;
		var shader1 = new Shader(device, ShaderUtils.createDefinition(device, {
			name: 'ptest1',
			vertexCode: _fullScreenQuadVS,
			fragmentCode: _precisionTest1PS
		}));
		var shader2 = new Shader(device, ShaderUtils.createDefinition(device, {
			name: 'ptest2',
			vertexCode: _fullScreenQuadVS,
			fragmentCode: _precisionTest2PS
		}));
		var textureOptions = {
			format: PIXELFORMAT_RGBA32F,
			width: 1,
			height: 1,
			mipmaps: false,
			minFilter: FILTER_NEAREST,
			magFilter: FILTER_NEAREST,
			name: 'testFHP'
		};
		var tex1 = new Texture(device, textureOptions);
		var targ1 = new RenderTarget({
			colorBuffer: tex1,
			depth: false
		});
		quadWithShader(device, targ1, shader1);
		textureOptions.format = PIXELFORMAT_RGBA8;
		var tex2 = new Texture(device, textureOptions);
		var targ2 = new RenderTarget({
			colorBuffer: tex2,
			depth: false
		});
		device.constantTexSource.setValue(tex1);
		quadWithShader(device, targ2, shader2);
		var prevFramebuffer = device.activeFramebuffer;
		device.setFramebuffer(targ2.impl._glFrameBuffer);
		var pixels = new Uint8Array(4);
		device.readPixels(0, 0, 1, 1, pixels);
		device.setFramebuffer(prevFramebuffer);
		var x = pixels[0] / 255;
		var y = pixels[1] / 255;
		var z = pixels[2] / 255;
		var w = pixels[3] / 255;
		var f = x / (256 * 256 * 256) + y / (256 * 256) + z / 256 + w;
		tex1.destroy();
		targ1.destroy();
		tex2.destroy();
		targ2.destroy();
		shader1.destroy();
		shader2.destroy();
		return f === 0;
	}
	var WebglGraphicsDevice = function (_GraphicsDevice) {
		_inheritsLoose(WebglGraphicsDevice, _GraphicsDevice);
		function WebglGraphicsDevice(canvas, options) {
			var _this;
			if (options === void 0) {
				options = {};
			}
			_this = _GraphicsDevice.call(this, canvas, options) || this;
			_this.gl = void 0;
			_this.webgl2 = void 0;
			options = _this.initOptions;
			_this.defaultFramebuffer = null;
			_this.updateClientRect();
			_this.contextLost = false;
			_this._contextLostHandler = function (event) {
				event.preventDefault();
				_this.contextLost = true;
				_this.loseContext();
				_this.fire('devicelost');
			};
			_this._contextRestoredHandler = function () {
				_this.restoreContext();
				_this.contextLost = false;
				_this.fire('devicerestored');
			};
			var ua = typeof navigator !== 'undefined' && navigator.userAgent;
			_this.forceDisableMultisampling = ua && ua.includes('AppleWebKit') && (ua.includes('15.4') || ua.includes('15_4'));
			if (_this.forceDisableMultisampling) {
				options.antialias = false;
			}
			var gl = null;
			if (options.gl) {
				gl = options.gl;
			} else {
				var preferWebGl2 = options.preferWebGl2 !== undefined ? options.preferWebGl2 : true;
				var names = preferWebGl2 ? ["webgl2", "webgl", "experimental-webgl"] : ["webgl", "experimental-webgl"];
				for (var i = 0; i < names.length; i++) {
					gl = canvas.getContext(names[i], options);
					if (gl) {
						break;
					}
				}
			}
			if (!gl) {
				throw new Error("WebGL not supported");
			}
			_this.gl = gl;
			_this.webgl2 = typeof WebGL2RenderingContext !== 'undefined' && gl instanceof WebGL2RenderingContext;
			_this._deviceType = _this.webgl2 ? DEVICETYPE_WEBGL2 : DEVICETYPE_WEBGL1;
			var alphaBits = gl.getParameter(gl.ALPHA_BITS);
			_this.framebufferFormat = alphaBits ? PIXELFORMAT_RGBA8 : PIXELFORMAT_RGB8;
			var isChrome = platform.browserName === 'chrome';
			var isSafari = platform.browserName === 'safari';
			var isMac = platform.browser && navigator.appVersion.indexOf("Mac") !== -1;
			_this._tempEnableSafariTextureUnitWorkaround = isSafari;
			_this._tempMacChromeBlitFramebufferWorkaround = isMac && isChrome && !options.alpha;
			if (!_this.webgl2) {
				setupVertexArrayObject(gl);
			}
			canvas.addEventListener("webglcontextlost", _this._contextLostHandler, false);
			canvas.addEventListener("webglcontextrestored", _this._contextRestoredHandler, false);
			_this.initializeExtensions();
			_this.initializeCapabilities();
			_this.initializeRenderState();
			_this.initializeContextCaches();
			_this.supportsImageBitmap = !isSafari && typeof ImageBitmap !== 'undefined';
			_this.glAddress = [gl.REPEAT, gl.CLAMP_TO_EDGE, gl.MIRRORED_REPEAT];
			_this.glBlendEquation = [gl.FUNC_ADD, gl.FUNC_SUBTRACT, gl.FUNC_REVERSE_SUBTRACT, _this.webgl2 ? gl.MIN : _this.extBlendMinmax ? _this.extBlendMinmax.MIN_EXT : gl.FUNC_ADD, _this.webgl2 ? gl.MAX : _this.extBlendMinmax ? _this.extBlendMinmax.MAX_EXT : gl.FUNC_ADD];
			_this.glBlendFunctionColor = [gl.ZERO, gl.ONE, gl.SRC_COLOR, gl.ONE_MINUS_SRC_COLOR, gl.DST_COLOR, gl.ONE_MINUS_DST_COLOR, gl.SRC_ALPHA, gl.SRC_ALPHA_SATURATE, gl.ONE_MINUS_SRC_ALPHA, gl.DST_ALPHA, gl.ONE_MINUS_DST_ALPHA, gl.CONSTANT_COLOR, gl.ONE_MINUS_CONSTANT_COLOR];
			_this.glBlendFunctionAlpha = [gl.ZERO, gl.ONE, gl.SRC_COLOR, gl.ONE_MINUS_SRC_COLOR, gl.DST_COLOR, gl.ONE_MINUS_DST_COLOR, gl.SRC_ALPHA, gl.SRC_ALPHA_SATURATE, gl.ONE_MINUS_SRC_ALPHA, gl.DST_ALPHA, gl.ONE_MINUS_DST_ALPHA, gl.CONSTANT_ALPHA, gl.ONE_MINUS_CONSTANT_ALPHA];
			_this.glComparison = [gl.NEVER, gl.LESS, gl.EQUAL, gl.LEQUAL, gl.GREATER, gl.NOTEQUAL, gl.GEQUAL, gl.ALWAYS];
			_this.glStencilOp = [gl.KEEP, gl.ZERO, gl.REPLACE, gl.INCR, gl.INCR_WRAP, gl.DECR, gl.DECR_WRAP, gl.INVERT];
			_this.glClearFlag = [0, gl.COLOR_BUFFER_BIT, gl.DEPTH_BUFFER_BIT, gl.COLOR_BUFFER_BIT | gl.DEPTH_BUFFER_BIT, gl.STENCIL_BUFFER_BIT, gl.STENCIL_BUFFER_BIT | gl.COLOR_BUFFER_BIT, gl.STENCIL_BUFFER_BIT | gl.DEPTH_BUFFER_BIT, gl.STENCIL_BUFFER_BIT | gl.COLOR_BUFFER_BIT | gl.DEPTH_BUFFER_BIT];
			_this.glCull = [0, gl.BACK, gl.FRONT, gl.FRONT_AND_BACK];
			_this.glFilter = [gl.NEAREST, gl.LINEAR, gl.NEAREST_MIPMAP_NEAREST, gl.NEAREST_MIPMAP_LINEAR, gl.LINEAR_MIPMAP_NEAREST, gl.LINEAR_MIPMAP_LINEAR];
			_this.glPrimitive = [gl.POINTS, gl.LINES, gl.LINE_LOOP, gl.LINE_STRIP, gl.TRIANGLES, gl.TRIANGLE_STRIP, gl.TRIANGLE_FAN];
			_this.glType = [gl.BYTE, gl.UNSIGNED_BYTE, gl.SHORT, gl.UNSIGNED_SHORT, gl.INT, gl.UNSIGNED_INT, gl.FLOAT];
			_this.pcUniformType = {};
			_this.pcUniformType[gl.BOOL] = UNIFORMTYPE_BOOL;
			_this.pcUniformType[gl.INT] = UNIFORMTYPE_INT;
			_this.pcUniformType[gl.FLOAT] = UNIFORMTYPE_FLOAT;
			_this.pcUniformType[gl.FLOAT_VEC2] = UNIFORMTYPE_VEC2;
			_this.pcUniformType[gl.FLOAT_VEC3] = UNIFORMTYPE_VEC3;
			_this.pcUniformType[gl.FLOAT_VEC4] = UNIFORMTYPE_VEC4;
			_this.pcUniformType[gl.INT_VEC2] = UNIFORMTYPE_IVEC2;
			_this.pcUniformType[gl.INT_VEC3] = UNIFORMTYPE_IVEC3;
			_this.pcUniformType[gl.INT_VEC4] = UNIFORMTYPE_IVEC4;
			_this.pcUniformType[gl.BOOL_VEC2] = UNIFORMTYPE_BVEC2;
			_this.pcUniformType[gl.BOOL_VEC3] = UNIFORMTYPE_BVEC3;
			_this.pcUniformType[gl.BOOL_VEC4] = UNIFORMTYPE_BVEC4;
			_this.pcUniformType[gl.FLOAT_MAT2] = UNIFORMTYPE_MAT2;
			_this.pcUniformType[gl.FLOAT_MAT3] = UNIFORMTYPE_MAT3;
			_this.pcUniformType[gl.FLOAT_MAT4] = UNIFORMTYPE_MAT4;
			_this.pcUniformType[gl.SAMPLER_2D] = UNIFORMTYPE_TEXTURE2D;
			_this.pcUniformType[gl.SAMPLER_CUBE] = UNIFORMTYPE_TEXTURECUBE;
			if (_this.webgl2) {
				_this.pcUniformType[gl.SAMPLER_2D_SHADOW] = UNIFORMTYPE_TEXTURE2D_SHADOW;
				_this.pcUniformType[gl.SAMPLER_CUBE_SHADOW] = UNIFORMTYPE_TEXTURECUBE_SHADOW;
				_this.pcUniformType[gl.SAMPLER_3D] = UNIFORMTYPE_TEXTURE3D;
			}
			_this.targetToSlot = {};
			_this.targetToSlot[gl.TEXTURE_2D] = 0;
			_this.targetToSlot[gl.TEXTURE_CUBE_MAP] = 1;
			_this.targetToSlot[gl.TEXTURE_3D] = 2;
			var scopeX, scopeY, scopeZ, scopeW;
			var uniformValue;
			_this.commitFunction = [];
			_this.commitFunction[UNIFORMTYPE_BOOL] = function (uniform, value) {
				if (uniform.value !== value) {
					gl.uniform1i(uniform.locationId, value);
					uniform.value = value;
				}
			};
			_this.commitFunction[UNIFORMTYPE_INT] = _this.commitFunction[UNIFORMTYPE_BOOL];
			_this.commitFunction[UNIFORMTYPE_FLOAT] = function (uniform, value) {
				if (uniform.value !== value) {
					gl.uniform1f(uniform.locationId, value);
					uniform.value = value;
				}
			};
			_this.commitFunction[UNIFORMTYPE_VEC2] = function (uniform, value) {
				uniformValue = uniform.value;
				scopeX = value[0];
				scopeY = value[1];
				if (uniformValue[0] !== scopeX || uniformValue[1] !== scopeY) {
					gl.uniform2fv(uniform.locationId, value);
					uniformValue[0] = scopeX;
					uniformValue[1] = scopeY;
				}
			};
			_this.commitFunction[UNIFORMTYPE_VEC3] = function (uniform, value) {
				uniformValue = uniform.value;
				scopeX = value[0];
				scopeY = value[1];
				scopeZ = value[2];
				if (uniformValue[0] !== scopeX || uniformValue[1] !== scopeY || uniformValue[2] !== scopeZ) {
					gl.uniform3fv(uniform.locationId, value);
					uniformValue[0] = scopeX;
					uniformValue[1] = scopeY;
					uniformValue[2] = scopeZ;
				}
			};
			_this.commitFunction[UNIFORMTYPE_VEC4] = function (uniform, value) {
				uniformValue = uniform.value;
				scopeX = value[0];
				scopeY = value[1];
				scopeZ = value[2];
				scopeW = value[3];
				if (uniformValue[0] !== scopeX || uniformValue[1] !== scopeY || uniformValue[2] !== scopeZ || uniformValue[3] !== scopeW) {
					gl.uniform4fv(uniform.locationId, value);
					uniformValue[0] = scopeX;
					uniformValue[1] = scopeY;
					uniformValue[2] = scopeZ;
					uniformValue[3] = scopeW;
				}
			};
			_this.commitFunction[UNIFORMTYPE_IVEC2] = function (uniform, value) {
				uniformValue = uniform.value;
				scopeX = value[0];
				scopeY = value[1];
				if (uniformValue[0] !== scopeX || uniformValue[1] !== scopeY) {
					gl.uniform2iv(uniform.locationId, value);
					uniformValue[0] = scopeX;
					uniformValue[1] = scopeY;
				}
			};
			_this.commitFunction[UNIFORMTYPE_BVEC2] = _this.commitFunction[UNIFORMTYPE_IVEC2];
			_this.commitFunction[UNIFORMTYPE_IVEC3] = function (uniform, value) {
				uniformValue = uniform.value;
				scopeX = value[0];
				scopeY = value[1];
				scopeZ = value[2];
				if (uniformValue[0] !== scopeX || uniformValue[1] !== scopeY || uniformValue[2] !== scopeZ) {
					gl.uniform3iv(uniform.locationId, value);
					uniformValue[0] = scopeX;
					uniformValue[1] = scopeY;
					uniformValue[2] = scopeZ;
				}
			};
			_this.commitFunction[UNIFORMTYPE_BVEC3] = _this.commitFunction[UNIFORMTYPE_IVEC3];
			_this.commitFunction[UNIFORMTYPE_IVEC4] = function (uniform, value) {
				uniformValue = uniform.value;
				scopeX = value[0];
				scopeY = value[1];
				scopeZ = value[2];
				scopeW = value[3];
				if (uniformValue[0] !== scopeX || uniformValue[1] !== scopeY || uniformValue[2] !== scopeZ || uniformValue[3] !== scopeW) {
					gl.uniform4iv(uniform.locationId, value);
					uniformValue[0] = scopeX;
					uniformValue[1] = scopeY;
					uniformValue[2] = scopeZ;
					uniformValue[3] = scopeW;
				}
			};
			_this.commitFunction[UNIFORMTYPE_BVEC4] = _this.commitFunction[UNIFORMTYPE_IVEC4];
			_this.commitFunction[UNIFORMTYPE_MAT2] = function (uniform, value) {
				gl.uniformMatrix2fv(uniform.locationId, false, value);
			};
			_this.commitFunction[UNIFORMTYPE_MAT3] = function (uniform, value) {
				gl.uniformMatrix3fv(uniform.locationId, false, value);
			};
			_this.commitFunction[UNIFORMTYPE_MAT4] = function (uniform, value) {
				gl.uniformMatrix4fv(uniform.locationId, false, value);
			};
			_this.commitFunction[UNIFORMTYPE_FLOATARRAY] = function (uniform, value) {
				gl.uniform1fv(uniform.locationId, value);
			};
			_this.commitFunction[UNIFORMTYPE_VEC2ARRAY] = function (uniform, value) {
				gl.uniform2fv(uniform.locationId, value);
			};
			_this.commitFunction[UNIFORMTYPE_VEC3ARRAY] = function (uniform, value) {
				gl.uniform3fv(uniform.locationId, value);
			};
			_this.commitFunction[UNIFORMTYPE_VEC4ARRAY] = function (uniform, value) {
				gl.uniform4fv(uniform.locationId, value);
			};
			_this.supportsBoneTextures = _this.extTextureFloat && _this.maxVertexTextures > 0;
			var numUniforms = _this.vertexUniformsCount;
			numUniforms -= 4 * 4;
			numUniforms -= 8;
			numUniforms -= 1;
			numUniforms -= 4 * 4;
			_this.boneLimit = Math.floor(numUniforms / 3);
			_this.boneLimit = Math.min(_this.boneLimit, 128);
			if (_this.unmaskedRenderer === 'Mali-450 MP') {
				_this.boneLimit = 34;
			}
			_this.constantTexSource = _this.scope.resolve("source");
			if (_this.extTextureFloat) {
				if (_this.webgl2) {
					_this.textureFloatRenderable = !!_this.extColorBufferFloat;
				} else {
					_this.textureFloatRenderable = testRenderable(gl, gl.FLOAT);
				}
			} else {
				_this.textureFloatRenderable = false;
			}
			if (_this.extColorBufferHalfFloat) {
				_this.textureHalfFloatRenderable = !!_this.extColorBufferHalfFloat;
			} else if (_this.extTextureHalfFloat) {
				if (_this.webgl2) {
					_this.textureHalfFloatRenderable = !!_this.extColorBufferFloat;
				} else {
					_this.textureHalfFloatRenderable = testRenderable(gl, _this.extTextureHalfFloat.HALF_FLOAT_OES);
				}
			} else {
				_this.textureHalfFloatRenderable = false;
			}
			_this.supportsMorphTargetTexturesCore = _this.maxPrecision === "highp" && _this.maxVertexTextures >= 2;
			_this.supportsDepthShadow = _this.webgl2;
			_this._textureFloatHighPrecision = undefined;
			_this._textureHalfFloatUpdatable = undefined;
			_this.areaLightLutFormat = PIXELFORMAT_RGBA8;
			if (_this.extTextureHalfFloat && _this.textureHalfFloatUpdatable && _this.extTextureHalfFloatLinear) {
				_this.areaLightLutFormat = PIXELFORMAT_RGBA16F;
			} else if (_this.extTextureFloat && _this.extTextureFloatLinear) {
				_this.areaLightLutFormat = PIXELFORMAT_RGBA32F;
			}
			_this.postInit();
			return _this;
		}
		var _proto = WebglGraphicsDevice.prototype;
		_proto.postInit = function postInit() {
			_GraphicsDevice.prototype.postInit.call(this);
			this.gpuProfiler = new WebglGpuProfiler(this);
		};
		_proto.destroy = function destroy() {
			_GraphicsDevice.prototype.destroy.call(this);
			var gl = this.gl;
			if (this.webgl2 && this.feedback) {
				gl.deleteTransformFeedback(this.feedback);
			}
			this.clearVertexArrayObjectCache();
			this.canvas.removeEventListener('webglcontextlost', this._contextLostHandler, false);
			this.canvas.removeEventListener('webglcontextrestored', this._contextRestoredHandler, false);
			this._contextLostHandler = null;
			this._contextRestoredHandler = null;
			this.gl = null;
			_GraphicsDevice.prototype.postDestroy.call(this);
		};
		_proto.createVertexBufferImpl = function createVertexBufferImpl(vertexBuffer, format) {
			return new WebglVertexBuffer();
		};
		_proto.createIndexBufferImpl = function createIndexBufferImpl(indexBuffer) {
			return new WebglIndexBuffer(indexBuffer);
		};
		_proto.createShaderImpl = function createShaderImpl(shader) {
			return new WebglShader(shader);
		};
		_proto.createTextureImpl = function createTextureImpl(texture) {
			return new WebglTexture();
		};
		_proto.createRenderTargetImpl = function createRenderTargetImpl(renderTarget) {
			return new WebglRenderTarget();
		};
		_proto.getPrecision = function getPrecision() {
			var gl = this.gl;
			var precision = "highp";
			if (gl.getShaderPrecisionFormat) {
				var vertexShaderPrecisionHighpFloat = gl.getShaderPrecisionFormat(gl.VERTEX_SHADER, gl.HIGH_FLOAT);
				var vertexShaderPrecisionMediumpFloat = gl.getShaderPrecisionFormat(gl.VERTEX_SHADER, gl.MEDIUM_FLOAT);
				var fragmentShaderPrecisionHighpFloat = gl.getShaderPrecisionFormat(gl.FRAGMENT_SHADER, gl.HIGH_FLOAT);
				var fragmentShaderPrecisionMediumpFloat = gl.getShaderPrecisionFormat(gl.FRAGMENT_SHADER, gl.MEDIUM_FLOAT);
				if (vertexShaderPrecisionHighpFloat && vertexShaderPrecisionMediumpFloat && fragmentShaderPrecisionHighpFloat && fragmentShaderPrecisionMediumpFloat) {
					var highpAvailable = vertexShaderPrecisionHighpFloat.precision > 0 && fragmentShaderPrecisionHighpFloat.precision > 0;
					var mediumpAvailable = vertexShaderPrecisionMediumpFloat.precision > 0 && fragmentShaderPrecisionMediumpFloat.precision > 0;
					if (!highpAvailable) {
						if (mediumpAvailable) {
							precision = "mediump";
						} else {
							precision = "lowp";
						}
					}
				}
			}
			return precision;
		};
		_proto.getExtension = function getExtension() {
			for (var i = 0; i < arguments.length; i++) {
				if (this.supportedExtensions.indexOf(arguments[i]) !== -1) {
					return this.gl.getExtension(arguments[i]);
				}
			}
			return null;
		};
		_proto.initializeExtensions = function initializeExtensions() {
			var _gl$getSupportedExten;
			var gl = this.gl;
			this.supportedExtensions = (_gl$getSupportedExten = gl.getSupportedExtensions()) != null ? _gl$getSupportedExten : [];
			this._extDisjointTimerQuery = null;
			if (this.webgl2) {
				this.extBlendMinmax = true;
				this.extDrawBuffers = true;
				this.drawBuffers = gl.drawBuffers.bind(gl);
				this.extInstancing = true;
				this.extStandardDerivatives = true;
				this.extTextureFloat = true;
				this.extTextureHalfFloat = true;
				this.extTextureLod = true;
				this.extUintElement = true;
				this.extVertexArrayObject = true;
				this.extColorBufferFloat = this.getExtension('EXT_color_buffer_float');
				this.extDepthTexture = true;
			} else {
				var _this$extDrawBuffers;
				this.extBlendMinmax = this.getExtension("EXT_blend_minmax");
				this.extDrawBuffers = this.getExtension('WEBGL_draw_buffers');
				this.extInstancing = this.getExtension("ANGLE_instanced_arrays");
				this.drawBuffers = (_this$extDrawBuffers = this.extDrawBuffers) == null ? void 0 : _this$extDrawBuffers.drawBuffersWEBGL.bind(this.extDrawBuffers);
				if (this.extInstancing) {
					var ext = this.extInstancing;
					gl.drawArraysInstanced = ext.drawArraysInstancedANGLE.bind(ext);
					gl.drawElementsInstanced = ext.drawElementsInstancedANGLE.bind(ext);
					gl.vertexAttribDivisor = ext.vertexAttribDivisorANGLE.bind(ext);
				}
				this.extStandardDerivatives = this.getExtension("OES_standard_derivatives");
				this.extTextureFloat = this.getExtension("OES_texture_float");
				this.extTextureHalfFloat = this.getExtension("OES_texture_half_float");
				this.extTextureLod = this.getExtension('EXT_shader_texture_lod');
				this.extUintElement = this.getExtension("OES_element_index_uint");
				this.extVertexArrayObject = this.getExtension("OES_vertex_array_object");
				if (this.extVertexArrayObject) {
					var _ext = this.extVertexArrayObject;
					gl.createVertexArray = _ext.createVertexArrayOES.bind(_ext);
					gl.deleteVertexArray = _ext.deleteVertexArrayOES.bind(_ext);
					gl.isVertexArray = _ext.isVertexArrayOES.bind(_ext);
					gl.bindVertexArray = _ext.bindVertexArrayOES.bind(_ext);
				}
				this.extColorBufferFloat = null;
				this.extDepthTexture = gl.getExtension('WEBGL_depth_texture');
			}
			this.extDebugRendererInfo = this.getExtension('WEBGL_debug_renderer_info');
			this.extTextureFloatLinear = this.getExtension("OES_texture_float_linear");
			this.extTextureHalfFloatLinear = this.getExtension("OES_texture_half_float_linear");
			this.extFloatBlend = this.getExtension("EXT_float_blend");
			this.extTextureFilterAnisotropic = this.getExtension('EXT_texture_filter_anisotropic', 'WEBKIT_EXT_texture_filter_anisotropic');
			this.extCompressedTextureETC1 = this.getExtension('WEBGL_compressed_texture_etc1');
			this.extCompressedTextureETC = this.getExtension('WEBGL_compressed_texture_etc');
			this.extCompressedTexturePVRTC = this.getExtension('WEBGL_compressed_texture_pvrtc', 'WEBKIT_WEBGL_compressed_texture_pvrtc');
			this.extCompressedTextureS3TC = this.getExtension('WEBGL_compressed_texture_s3tc', 'WEBKIT_WEBGL_compressed_texture_s3tc');
			this.extCompressedTextureATC = this.getExtension('WEBGL_compressed_texture_atc');
			this.extCompressedTextureASTC = this.getExtension('WEBGL_compressed_texture_astc');
			this.extParallelShaderCompile = this.getExtension('KHR_parallel_shader_compile');
			this.extColorBufferHalfFloat = this.getExtension("EXT_color_buffer_half_float");
		};
		_proto.initializeCapabilities = function initializeCapabilities() {
			var _contextAttribs$antia, _contextAttribs$stenc;
			var gl = this.gl;
			var ext;
			var userAgent = typeof navigator !== 'undefined' ? navigator.userAgent : "";
			this.maxPrecision = this.precision = this.getPrecision();
			var contextAttribs = gl.getContextAttributes();
			this.supportsMsaa = (_contextAttribs$antia = contextAttribs == null ? void 0 : contextAttribs.antialias) != null ? _contextAttribs$antia : false;
			this.supportsStencil = (_contextAttribs$stenc = contextAttribs == null ? void 0 : contextAttribs.stencil) != null ? _contextAttribs$stenc : false;
			this.supportsInstancing = !!this.extInstancing;
			this.maxTextureSize = gl.getParameter(gl.MAX_TEXTURE_SIZE);
			this.maxCubeMapSize = gl.getParameter(gl.MAX_CUBE_MAP_TEXTURE_SIZE);
			this.maxRenderBufferSize = gl.getParameter(gl.MAX_RENDERBUFFER_SIZE);
			this.maxTextures = gl.getParameter(gl.MAX_TEXTURE_IMAGE_UNITS);
			this.maxCombinedTextures = gl.getParameter(gl.MAX_COMBINED_TEXTURE_IMAGE_UNITS);
			this.maxVertexTextures = gl.getParameter(gl.MAX_VERTEX_TEXTURE_IMAGE_UNITS);
			this.vertexUniformsCount = gl.getParameter(gl.MAX_VERTEX_UNIFORM_VECTORS);
			this.fragmentUniformsCount = gl.getParameter(gl.MAX_FRAGMENT_UNIFORM_VECTORS);
			if (this.webgl2) {
				this.maxDrawBuffers = gl.getParameter(gl.MAX_DRAW_BUFFERS);
				this.maxColorAttachments = gl.getParameter(gl.MAX_COLOR_ATTACHMENTS);
				this.maxVolumeSize = gl.getParameter(gl.MAX_3D_TEXTURE_SIZE);
				this.supportsMrt = true;
				this.supportsVolumeTextures = true;
			} else {
				ext = this.extDrawBuffers;
				this.supportsMrt = !!ext;
				this.maxDrawBuffers = ext ? gl.getParameter(ext.MAX_DRAW_BUFFERS_WEBGL) : 1;
				this.maxColorAttachments = ext ? gl.getParameter(ext.MAX_COLOR_ATTACHMENTS_WEBGL) : 1;
				this.maxVolumeSize = 1;
			}
			ext = this.extDebugRendererInfo;
			this.unmaskedRenderer = ext ? gl.getParameter(ext.UNMASKED_RENDERER_WEBGL) : '';
			this.unmaskedVendor = ext ? gl.getParameter(ext.UNMASKED_VENDOR_WEBGL) : '';
			var maliRendererRegex = /\bMali-G52+/;
			var samsungModelRegex = /SM-[a-zA-Z0-9]+/;
			this.supportsGpuParticles = !(this.unmaskedVendor === 'ARM' && userAgent.match(samsungModelRegex)) && !this.unmaskedRenderer.match(maliRendererRegex);
			ext = this.extTextureFilterAnisotropic;
			this.maxAnisotropy = ext ? gl.getParameter(ext.MAX_TEXTURE_MAX_ANISOTROPY_EXT) : 1;
			this.samples = gl.getParameter(gl.SAMPLES);
			this.maxSamples = this.webgl2 && !this.forceDisableMultisampling ? gl.getParameter(gl.MAX_SAMPLES) : 1;
			this.supportsAreaLights = this.webgl2 || !platform.android;
			this.supportsTextureFetch = this.webgl2;
			if (this.maxTextures <= 8) {
				this.supportsAreaLights = false;
			}
		};
		_proto.initializeRenderState = function initializeRenderState() {
			_GraphicsDevice.prototype.initializeRenderState.call(this);
			var gl = this.gl;
			gl.disable(gl.BLEND);
			gl.blendFunc(gl.ONE, gl.ZERO);
			gl.blendEquation(gl.FUNC_ADD);
			gl.colorMask(true, true, true, true);
			this.blendColor = new Color(0, 0, 0, 0);
			gl.blendColor(0, 0, 0, 0);
			gl.enable(gl.CULL_FACE);
			gl.cullFace(gl.BACK);
			gl.enable(gl.DEPTH_TEST);
			gl.depthFunc(gl.LEQUAL);
			gl.depthMask(true);
			this.stencil = false;
			gl.disable(gl.STENCIL_TEST);
			this.stencilFuncFront = this.stencilFuncBack = FUNC_ALWAYS;
			this.stencilRefFront = this.stencilRefBack = 0;
			this.stencilMaskFront = this.stencilMaskBack = 0xFF;
			gl.stencilFunc(gl.ALWAYS, 0, 0xFF);
			this.stencilFailFront = this.stencilFailBack = STENCILOP_KEEP;
			this.stencilZfailFront = this.stencilZfailBack = STENCILOP_KEEP;
			this.stencilZpassFront = this.stencilZpassBack = STENCILOP_KEEP;
			this.stencilWriteMaskFront = 0xFF;
			this.stencilWriteMaskBack = 0xFF;
			gl.stencilOp(gl.KEEP, gl.KEEP, gl.KEEP);
			gl.stencilMask(0xFF);
			this.alphaToCoverage = false;
			this.raster = true;
			if (this.webgl2) {
				gl.disable(gl.SAMPLE_ALPHA_TO_COVERAGE);
				gl.disable(gl.RASTERIZER_DISCARD);
			}
			this.depthBiasEnabled = false;
			gl.disable(gl.POLYGON_OFFSET_FILL);
			this.clearDepth = 1;
			gl.clearDepth(1);
			this.clearColor = new Color(0, 0, 0, 0);
			gl.clearColor(0, 0, 0, 0);
			this.clearStencil = 0;
			gl.clearStencil(0);
			if (this.webgl2) {
				gl.hint(gl.FRAGMENT_SHADER_DERIVATIVE_HINT, gl.NICEST);
			} else {
				if (this.extStandardDerivatives) {
					gl.hint(this.extStandardDerivatives.FRAGMENT_SHADER_DERIVATIVE_HINT_OES, gl.NICEST);
				}
			}
			gl.enable(gl.SCISSOR_TEST);
			gl.pixelStorei(gl.UNPACK_COLORSPACE_CONVERSION_WEBGL, gl.NONE);
			this.unpackFlipY = false;
			gl.pixelStorei(gl.UNPACK_FLIP_Y_WEBGL, false);
			this.unpackPremultiplyAlpha = false;
			gl.pixelStorei(gl.UNPACK_PREMULTIPLY_ALPHA_WEBGL, false);
			gl.pixelStorei(gl.UNPACK_ALIGNMENT, 1);
		};
		_proto.initializeContextCaches = function initializeContextCaches() {
			_GraphicsDevice.prototype.initializeContextCaches.call(this);
			this._vaoMap = new Map();
			this.boundVao = null;
			this.activeFramebuffer = null;
			this.feedback = null;
			this.transformFeedbackBuffer = null;
			this.textureUnit = 0;
			this.textureUnits = [];
			for (var i = 0; i < this.maxCombinedTextures; i++) {
				this.textureUnits.push([null, null, null]);
			}
		};
		_proto.loseContext = function loseContext() {
			var _this$gpuProfiler;
			for (var _iterator = _createForOfIteratorHelperLoose(this.shaders), _step; !(_step = _iterator()).done;) {
				var shader = _step.value;
				shader.loseContext();
			}
			for (var _iterator2 = _createForOfIteratorHelperLoose(this.textures), _step2; !(_step2 = _iterator2()).done;) {
				var texture = _step2.value;
				texture.loseContext();
			}
			for (var _iterator3 = _createForOfIteratorHelperLoose(this.buffers), _step3; !(_step3 = _iterator3()).done;) {
				var buffer = _step3.value;
				buffer.loseContext();
			}
			for (var _iterator4 = _createForOfIteratorHelperLoose(this.targets), _step4; !(_step4 = _iterator4()).done;) {
				var target = _step4.value;
				target.loseContext();
			}
			(_this$gpuProfiler = this.gpuProfiler) == null ? void 0 : _this$gpuProfiler.loseContext();
		};
		_proto.restoreContext = function restoreContext() {
			var _this$gpuProfiler2;
			this.initializeExtensions();
			this.initializeCapabilities();
			this.initializeRenderState();
			this.initializeContextCaches();
			for (var _iterator5 = _createForOfIteratorHelperLoose(this.shaders), _step5; !(_step5 = _iterator5()).done;) {
				var shader = _step5.value;
				shader.restoreContext();
			}
			for (var _iterator6 = _createForOfIteratorHelperLoose(this.buffers), _step6; !(_step6 = _iterator6()).done;) {
				var buffer = _step6.value;
				buffer.unlock();
			}
			(_this$gpuProfiler2 = this.gpuProfiler) == null ? void 0 : _this$gpuProfiler2.restoreContext();
		};
		_proto.endShaderBatch = function endShaderBatch() {
			WebglShader.endShaderBatch(this);
		};
		_proto.setViewport = function setViewport(x, y, w, h) {
			if (this.vx !== x || this.vy !== y || this.vw !== w || this.vh !== h) {
				this.gl.viewport(x, y, w, h);
				this.vx = x;
				this.vy = y;
				this.vw = w;
				this.vh = h;
			}
		};
		_proto.setScissor = function setScissor(x, y, w, h) {
			if (this.sx !== x || this.sy !== y || this.sw !== w || this.sh !== h) {
				this.gl.scissor(x, y, w, h);
				this.sx = x;
				this.sy = y;
				this.sw = w;
				this.sh = h;
			}
		};
		_proto.setFramebuffer = function setFramebuffer(fb) {
			if (this.activeFramebuffer !== fb) {
				var gl = this.gl;
				gl.bindFramebuffer(gl.FRAMEBUFFER, fb);
				this.activeFramebuffer = fb;
			}
		};
		_proto.copyRenderTarget = function copyRenderTarget(source, dest, color, depth) {
			var gl = this.gl;
			if (!this.webgl2 && depth) {
				return false;
			}
			if (color) {
				if (!dest) {
					if (!source._colorBuffer) {
						return false;
					}
				} else if (source) {
					if (!source._colorBuffer || !dest._colorBuffer) {
						return false;
					}
					if (source._colorBuffer._format !== dest._colorBuffer._format) {
						return false;
					}
				}
			}
			if (depth && source) {
				if (!source._depth) {
					if (!source._depthBuffer || !dest._depthBuffer) {
						return false;
					}
					if (source._depthBuffer._format !== dest._depthBuffer._format) {
						return false;
					}
				}
			}
			if (this.webgl2 && dest) {
				var prevRt = this.renderTarget;
				this.renderTarget = dest;
				this.updateBegin();
				gl.bindFramebuffer(gl.READ_FRAMEBUFFER, source ? source.impl._glFrameBuffer : null);
				gl.bindFramebuffer(gl.DRAW_FRAMEBUFFER, dest.impl._glFrameBuffer);
				var w = source ? source.width : dest.width;
				var h = source ? source.height : dest.height;
				gl.blitFramebuffer(0, 0, w, h, 0, 0, w, h, (color ? gl.COLOR_BUFFER_BIT : 0) | (depth ? gl.DEPTH_BUFFER_BIT : 0), gl.NEAREST);
				this.renderTarget = prevRt;
				gl.bindFramebuffer(gl.FRAMEBUFFER, prevRt ? prevRt.impl._glFrameBuffer : null);
			} else {
				var shader = this.getCopyShader();
				this.constantTexSource.setValue(source._colorBuffer);
				quadWithShader(this, dest, shader);
			}
			return true;
		};
		_proto.getCopyShader = function getCopyShader() {
			if (!this._copyShader) {
				this._copyShader = new Shader(this, ShaderUtils.createDefinition(this, {
					name: 'outputTex2D',
					vertexCode: _fullScreenQuadVS,
					fragmentCode: _outputTexture2D
				}));
			}
			return this._copyShader;
		};
		_proto.frameStart = function frameStart() {
			_GraphicsDevice.prototype.frameStart.call(this);
			this.gpuProfiler.frameStart();
		};
		_proto.frameEnd = function frameEnd() {
			_GraphicsDevice.prototype.frameEnd.call(this);
			this.gpuProfiler.frameEnd();
			this.gpuProfiler.request();
		};
		_proto.startPass = function startPass(renderPass) {
			this.setRenderTarget(renderPass.renderTarget);
			this.updateBegin();
			var colorOps = renderPass.colorOps;
			var depthStencilOps = renderPass.depthStencilOps;
			if (colorOps != null && colorOps.clear || depthStencilOps.clearDepth || depthStencilOps.clearStencil) {
				var rt = renderPass.renderTarget;
				var width = rt ? rt.width : this.width;
				var height = rt ? rt.height : this.height;
				this.setViewport(0, 0, width, height);
				this.setScissor(0, 0, width, height);
				var clearFlags = 0;
				var clearOptions = {};
				if (colorOps != null && colorOps.clear) {
					clearFlags |= CLEARFLAG_COLOR;
					clearOptions.color = [colorOps.clearValue.r, colorOps.clearValue.g, colorOps.clearValue.b, colorOps.clearValue.a];
				}
				if (depthStencilOps.clearDepth) {
					clearFlags |= CLEARFLAG_DEPTH;
					clearOptions.depth = depthStencilOps.clearDepthValue;
				}
				if (depthStencilOps.clearStencil) {
					clearFlags |= CLEARFLAG_STENCIL;
					clearOptions.stencil = depthStencilOps.clearStencilValue;
				}
				clearOptions.flags = clearFlags;
				this.clear(clearOptions);
			}
			this.insideRenderPass = true;
		};
		_proto.endPass = function endPass(renderPass) {
			this.unbindVertexArray();
			var target = this.renderTarget;
			var colorBufferCount = renderPass.colorArrayOps.length;
			if (target) {
				var _renderPass$colorOps;
				if (this.webgl2) {
					invalidateAttachments.length = 0;
					var gl = this.gl;
					for (var i = 0; i < colorBufferCount; i++) {
						var colorOps = renderPass.colorArrayOps[i];
						if (!(colorOps.store || colorOps.resolve)) {
							invalidateAttachments.push(gl.COLOR_ATTACHMENT0 + i);
						}
					}
					if (!renderPass.depthStencilOps.storeDepth) {
						invalidateAttachments.push(gl.DEPTH_ATTACHMENT);
					}
					if (!renderPass.depthStencilOps.storeStencil) {
						invalidateAttachments.push(gl.STENCIL_ATTACHMENT);
					}
					if (invalidateAttachments.length > 0) {
						if (renderPass.fullSizeClearRect) {
							gl.invalidateFramebuffer(gl.DRAW_FRAMEBUFFER, invalidateAttachments);
						}
					}
				}
				if ((_renderPass$colorOps = renderPass.colorOps) != null && _renderPass$colorOps.resolve) {
					if (this.webgl2 && renderPass.samples > 1 && target.autoResolve) {
						target.resolve(true, false);
					}
				}
				for (var _i = 0; _i < colorBufferCount; _i++) {
					var _colorOps = renderPass.colorArrayOps[_i];
					if (_colorOps.mipmaps) {
						var colorBuffer = target._colorBuffers[_i];
						if (colorBuffer && colorBuffer.impl._glTexture && colorBuffer.mipmaps && (colorBuffer.pot || this.webgl2)) {
							this.activeTexture(this.maxCombinedTextures - 1);
							this.bindTexture(colorBuffer);
							this.gl.generateMipmap(colorBuffer.impl._glTarget);
						}
					}
				}
			}
			this.insideRenderPass = false;
		};
		_proto.updateBegin = function updateBegin() {
			this.boundVao = null;
			if (this._tempEnableSafariTextureUnitWorkaround) {
				for (var unit = 0; unit < this.textureUnits.length; ++unit) {
					for (var slot = 0; slot < 3; ++slot) {
						this.textureUnits[unit][slot] = null;
					}
				}
			}
			var target = this.renderTarget;
			if (target) {
				if (!target.impl.initialized) {
					this.initRenderTarget(target);
				} else {
					this.setFramebuffer(target.impl._glFrameBuffer);
				}
			} else {
				this.setFramebuffer(this.defaultFramebuffer);
			}
		};
		_proto.updateEnd = function updateEnd() {
			this.unbindVertexArray();
			var target = this.renderTarget;
			if (target) {
				if (this.webgl2 && target._samples > 1 && target.autoResolve) {
					target.resolve();
				}
				var colorBuffer = target._colorBuffer;
				if (colorBuffer && colorBuffer.impl._glTexture && colorBuffer.mipmaps && (colorBuffer.pot || this.webgl2)) {
					this.activeTexture(this.maxCombinedTextures - 1);
					this.bindTexture(colorBuffer);
					this.gl.generateMipmap(colorBuffer.impl._glTarget);
				}
			}
		};
		_proto.setUnpackFlipY = function setUnpackFlipY(flipY) {
			if (this.unpackFlipY !== flipY) {
				this.unpackFlipY = flipY;
				var gl = this.gl;
				gl.pixelStorei(gl.UNPACK_FLIP_Y_WEBGL, flipY);
			}
		};
		_proto.setUnpackPremultiplyAlpha = function setUnpackPremultiplyAlpha(premultiplyAlpha) {
			if (this.unpackPremultiplyAlpha !== premultiplyAlpha) {
				this.unpackPremultiplyAlpha = premultiplyAlpha;
				var gl = this.gl;
				gl.pixelStorei(gl.UNPACK_PREMULTIPLY_ALPHA_WEBGL, premultiplyAlpha);
			}
		};
		_proto.activeTexture = function activeTexture(textureUnit) {
			if (this.textureUnit !== textureUnit) {
				this.gl.activeTexture(this.gl.TEXTURE0 + textureUnit);
				this.textureUnit = textureUnit;
			}
		};
		_proto.bindTexture = function bindTexture(texture) {
			var impl = texture.impl;
			var textureTarget = impl._glTarget;
			var textureObject = impl._glTexture;
			var textureUnit = this.textureUnit;
			var slot = this.targetToSlot[textureTarget];
			if (this.textureUnits[textureUnit][slot] !== textureObject) {
				this.gl.bindTexture(textureTarget, textureObject);
				this.textureUnits[textureUnit][slot] = textureObject;
			}
		};
		_proto.bindTextureOnUnit = function bindTextureOnUnit(texture, textureUnit) {
			var impl = texture.impl;
			var textureTarget = impl._glTarget;
			var textureObject = impl._glTexture;
			var slot = this.targetToSlot[textureTarget];
			if (this.textureUnits[textureUnit][slot] !== textureObject) {
				this.activeTexture(textureUnit);
				this.gl.bindTexture(textureTarget, textureObject);
				this.textureUnits[textureUnit][slot] = textureObject;
			}
		};
		_proto.setTextureParameters = function setTextureParameters(texture) {
			var gl = this.gl;
			var flags = texture.impl.dirtyParameterFlags;
			var target = texture.impl._glTarget;
			if (flags & 1) {
				var filter = texture._minFilter;
				if (!texture.pot && !this.webgl2 || !texture._mipmaps || texture._compressed && texture._levels.length === 1) {
					if (filter === FILTER_NEAREST_MIPMAP_NEAREST || filter === FILTER_NEAREST_MIPMAP_LINEAR) {
						filter = FILTER_NEAREST;
					} else if (filter === FILTER_LINEAR_MIPMAP_NEAREST || filter === FILTER_LINEAR_MIPMAP_LINEAR) {
						filter = FILTER_LINEAR;
					}
				}
				gl.texParameteri(target, gl.TEXTURE_MIN_FILTER, this.glFilter[filter]);
			}
			if (flags & 2) {
				gl.texParameteri(target, gl.TEXTURE_MAG_FILTER, this.glFilter[texture._magFilter]);
			}
			if (flags & 4) {
				if (this.webgl2) {
					gl.texParameteri(target, gl.TEXTURE_WRAP_S, this.glAddress[texture._addressU]);
				} else {
					gl.texParameteri(target, gl.TEXTURE_WRAP_S, this.glAddress[texture.pot ? texture._addressU : ADDRESS_CLAMP_TO_EDGE]);
				}
			}
			if (flags & 8) {
				if (this.webgl2) {
					gl.texParameteri(target, gl.TEXTURE_WRAP_T, this.glAddress[texture._addressV]);
				} else {
					gl.texParameteri(target, gl.TEXTURE_WRAP_T, this.glAddress[texture.pot ? texture._addressV : ADDRESS_CLAMP_TO_EDGE]);
				}
			}
			if (flags & 16) {
				if (this.webgl2) {
					gl.texParameteri(target, gl.TEXTURE_WRAP_R, this.glAddress[texture._addressW]);
				}
			}
			if (flags & 32) {
				if (this.webgl2) {
					gl.texParameteri(target, gl.TEXTURE_COMPARE_MODE, texture._compareOnRead ? gl.COMPARE_REF_TO_TEXTURE : gl.NONE);
				}
			}
			if (flags & 64) {
				if (this.webgl2) {
					gl.texParameteri(target, gl.TEXTURE_COMPARE_FUNC, this.glComparison[texture._compareFunc]);
				}
			}
			if (flags & 128) {
				var ext = this.extTextureFilterAnisotropic;
				if (ext) {
					gl.texParameterf(target, ext.TEXTURE_MAX_ANISOTROPY_EXT, math.clamp(Math.round(texture._anisotropy), 1, this.maxAnisotropy));
				}
			}
		};
		_proto.setTexture = function setTexture(texture, textureUnit) {
			var impl = texture.impl;
			if (!impl._glTexture) impl.initialize(this, texture);
			if (impl.dirtyParameterFlags > 0 || texture._needsUpload || texture._needsMipmapsUpload) {
				this.activeTexture(textureUnit);
				this.bindTexture(texture);
				if (impl.dirtyParameterFlags) {
					this.setTextureParameters(texture);
					impl.dirtyParameterFlags = 0;
				}
				if (texture._needsUpload || texture._needsMipmapsUpload) {
					impl.upload(this, texture);
					texture._needsUpload = false;
					texture._needsMipmapsUpload = false;
				}
			} else {
				this.bindTextureOnUnit(texture, textureUnit);
			}
		};
		_proto.createVertexArray = function createVertexArray(vertexBuffers) {
			var key, vao;
			var useCache = vertexBuffers.length > 1;
			if (useCache) {
				key = "";
				for (var i = 0; i < vertexBuffers.length; i++) {
					var vertexBuffer = vertexBuffers[i];
					key += vertexBuffer.id + vertexBuffer.format.renderingHash;
				}
				vao = this._vaoMap.get(key);
			}
			if (!vao) {
				var gl = this.gl;
				vao = gl.createVertexArray();
				gl.bindVertexArray(vao);
				gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER, null);
				for (var _i2 = 0; _i2 < vertexBuffers.length; _i2++) {
					var _vertexBuffer = vertexBuffers[_i2];
					gl.bindBuffer(gl.ARRAY_BUFFER, _vertexBuffer.impl.bufferId);
					var elements = _vertexBuffer.format.elements;
					for (var j = 0; j < elements.length; j++) {
						var e = elements[j];
						var loc = semanticToLocation[e.name];
						gl.vertexAttribPointer(loc, e.numComponents, this.glType[e.dataType], e.normalize, e.stride, e.offset);
						gl.enableVertexAttribArray(loc);
						if (_vertexBuffer.format.instancing) {
							gl.vertexAttribDivisor(loc, 1);
						}
					}
				}
				gl.bindVertexArray(null);
				gl.bindBuffer(gl.ARRAY_BUFFER, null);
				if (useCache) {
					this._vaoMap.set(key, vao);
				}
			}
			return vao;
		};
		_proto.unbindVertexArray = function unbindVertexArray() {
			if (this.boundVao) {
				this.boundVao = null;
				this.gl.bindVertexArray(null);
			}
		};
		_proto.setBuffers = function setBuffers() {
			var gl = this.gl;
			var vao;
			if (this.vertexBuffers.length === 1) {
				var vertexBuffer = this.vertexBuffers[0];
				if (!vertexBuffer.impl.vao) {
					vertexBuffer.impl.vao = this.createVertexArray(this.vertexBuffers);
				}
				vao = vertexBuffer.impl.vao;
			} else {
				vao = this.createVertexArray(this.vertexBuffers);
			}
			if (this.boundVao !== vao) {
				this.boundVao = vao;
				gl.bindVertexArray(vao);
			}
			this.vertexBuffers.length = 0;
			var bufferId = this.indexBuffer ? this.indexBuffer.impl.bufferId : null;
			gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER, bufferId);
		};
		_proto.draw = function draw(primitive, numInstances, keepBuffers) {
			var gl = this.gl;
			var sampler, samplerValue, texture, numTextures;
			var uniform, scopeId, uniformVersion, programVersion;
			var shader = this.shader;
			if (!shader) return;
			var samplers = shader.impl.samplers;
			var uniforms = shader.impl.uniforms;
			if (!keepBuffers) {
				this.setBuffers();
			}
			var textureUnit = 0;
			for (var i = 0, len = samplers.length; i < len; i++) {
				sampler = samplers[i];
				samplerValue = sampler.scopeId.value;
				if (!samplerValue) {
					return;
				}
				if (samplerValue instanceof Texture) {
					texture = samplerValue;
					this.setTexture(texture, textureUnit);
					if (sampler.slot !== textureUnit) {
						gl.uniform1i(sampler.locationId, textureUnit);
						sampler.slot = textureUnit;
					}
					textureUnit++;
				} else {
					sampler.array.length = 0;
					numTextures = samplerValue.length;
					for (var j = 0; j < numTextures; j++) {
						texture = samplerValue[j];
						this.setTexture(texture, textureUnit);
						sampler.array[j] = textureUnit;
						textureUnit++;
					}
					gl.uniform1iv(sampler.locationId, sampler.array);
				}
			}
			for (var _i3 = 0, _len = uniforms.length; _i3 < _len; _i3++) {
				uniform = uniforms[_i3];
				scopeId = uniform.scopeId;
				uniformVersion = uniform.version;
				programVersion = scopeId.versionObject.version;
				if (uniformVersion.globalId !== programVersion.globalId || uniformVersion.revision !== programVersion.revision) {
					uniformVersion.globalId = programVersion.globalId;
					uniformVersion.revision = programVersion.revision;
					if (scopeId.value !== null) {
						this.commitFunction[uniform.dataType](uniform, scopeId.value);
					}
				}
			}
			if (this.webgl2 && this.transformFeedbackBuffer) {
				gl.bindBufferBase(gl.TRANSFORM_FEEDBACK_BUFFER, 0, this.transformFeedbackBuffer.impl.bufferId);
				gl.beginTransformFeedback(gl.POINTS);
			}
			var mode = this.glPrimitive[primitive.type];
			var count = primitive.count;
			if (primitive.indexed) {
				var indexBuffer = this.indexBuffer;
				var format = indexBuffer.impl.glFormat;
				var offset = primitive.base * indexBuffer.bytesPerIndex;
				if (numInstances > 0) {
					gl.drawElementsInstanced(mode, count, format, offset, numInstances);
				} else {
					gl.drawElements(mode, count, format, offset);
				}
			} else {
				var first = primitive.base;
				if (numInstances > 0) {
					gl.drawArraysInstanced(mode, first, count, numInstances);
				} else {
					gl.drawArrays(mode, first, count);
				}
			}
			if (this.webgl2 && this.transformFeedbackBuffer) {
				gl.endTransformFeedback();
				gl.bindBufferBase(gl.TRANSFORM_FEEDBACK_BUFFER, 0, null);
			}
			this._drawCallsPerFrame++;
		};
		_proto.clear = function clear(options) {
			var _options$flags;
			var defaultOptions = this.defaultClearOptions;
			options = options || defaultOptions;
			var flags = (_options$flags = options.flags) != null ? _options$flags : defaultOptions.flags;
			if (flags !== 0) {
				var gl = this.gl;
				if (flags & CLEARFLAG_COLOR) {
					var _options$color;
					var color = (_options$color = options.color) != null ? _options$color : defaultOptions.color;
					var r = color[0];
					var g = color[1];
					var b = color[2];
					var a = color[3];
					var c = this.clearColor;
					if (r !== c.r || g !== c.g || b !== c.b || a !== c.a) {
						this.gl.clearColor(r, g, b, a);
						this.clearColor.set(r, g, b, a);
					}
					this.setBlendState(BlendState.NOBLEND);
				}
				if (flags & CLEARFLAG_DEPTH) {
					var _options$depth;
					var depth = (_options$depth = options.depth) != null ? _options$depth : defaultOptions.depth;
					if (depth !== this.clearDepth) {
						this.gl.clearDepth(depth);
						this.clearDepth = depth;
					}
					this.setDepthState(DepthState.WRITEDEPTH);
				}
				if (flags & CLEARFLAG_STENCIL) {
					var _options$stencil;
					var stencil = (_options$stencil = options.stencil) != null ? _options$stencil : defaultOptions.stencil;
					if (stencil !== this.clearStencil) {
						this.gl.clearStencil(stencil);
						this.clearStencil = stencil;
					}
				}
				gl.clear(this.glClearFlag[flags]);
			}
		};
		_proto.submit = function submit() {
			this.gl.flush();
		};
		_proto.readPixels = function readPixels(x, y, w, h, pixels) {
			var gl = this.gl;
			gl.readPixels(x, y, w, h, gl.RGBA, gl.UNSIGNED_BYTE, pixels);
		};
		_proto.readPixelsAsync = function () {
			var _readPixelsAsync = _asyncToGenerator(_regeneratorRuntime().mark(function _callee(x, y, w, h, pixels) {
				var _this2 = this,
					_this$renderTarget$co,
					_impl$_glFormat,
					_impl$_glPixelType;
				var gl, clientWaitAsync, impl, format, pixelType, buf;
				return _regeneratorRuntime().wrap(function _callee$(_context) {
					while (1) switch (_context.prev = _context.next) {
						case 0:
							gl = this.gl;
							if (this.webgl2) {
								_context.next = 3;
								break;
							}
							return _context.abrupt("return", this.readPixels(x, y, w, h, pixels));
						case 3:
							clientWaitAsync = function clientWaitAsync(flags, interval_ms) {
								var sync = gl.fenceSync(gl.SYNC_GPU_COMMANDS_COMPLETE, 0);
								_this2.submit();
								return new Promise(function (resolve, reject) {
									function test() {
										var res = gl.clientWaitSync(sync, flags, 0);
										if (res === gl.WAIT_FAILED) {
											gl.deleteSync(sync);
											reject(new Error('webgl clientWaitSync sync failed'));
										} else if (res === gl.TIMEOUT_EXPIRED) {
											setTimeout(test, interval_ms);
										} else {
											gl.deleteSync(sync);
											resolve();
										}
									}
									test();
								});
							};
							impl = (_this$renderTarget$co = this.renderTarget.colorBuffer) == null ? void 0 : _this$renderTarget$co.impl;
							format = (_impl$_glFormat = impl == null ? void 0 : impl._glFormat) != null ? _impl$_glFormat : gl.RGBA;
							pixelType = (_impl$_glPixelType = impl == null ? void 0 : impl._glPixelType) != null ? _impl$_glPixelType : gl.UNSIGNED_BYTE;
							buf = gl.createBuffer();
							gl.bindBuffer(gl.PIXEL_PACK_BUFFER, buf);
							gl.bufferData(gl.PIXEL_PACK_BUFFER, pixels.byteLength, gl.STREAM_READ);
							gl.readPixels(x, y, w, h, format, pixelType, 0);
							gl.bindBuffer(gl.PIXEL_PACK_BUFFER, null);
							_context.next = 14;
							return clientWaitAsync(0, 20);
						case 14:
							gl.bindBuffer(gl.PIXEL_PACK_BUFFER, buf);
							gl.getBufferSubData(gl.PIXEL_PACK_BUFFER, 0, pixels);
							gl.bindBuffer(gl.PIXEL_PACK_BUFFER, null);
							gl.deleteBuffer(buf);
						case 18:
						case "end":
							return _context.stop();
					}
				}, _callee, this);
			}));
			function readPixelsAsync(_x, _x2, _x3, _x4, _x5) {
				return _readPixelsAsync.apply(this, arguments);
			}
			return readPixelsAsync;
		}();
		_proto.setAlphaToCoverage = function setAlphaToCoverage(state) {
			if (!this.webgl2) return;
			if (this.alphaToCoverage === state) return;
			this.alphaToCoverage = state;
			if (state) {
				this.gl.enable(this.gl.SAMPLE_ALPHA_TO_COVERAGE);
			} else {
				this.gl.disable(this.gl.SAMPLE_ALPHA_TO_COVERAGE);
			}
		};
		_proto.setTransformFeedbackBuffer = function setTransformFeedbackBuffer(tf) {
			if (this.transformFeedbackBuffer === tf) return;
			this.transformFeedbackBuffer = tf;
			if (this.webgl2) {
				var _gl = this.gl;
				if (tf) {
					if (!this.feedback) {
						this.feedback = _gl.createTransformFeedback();
					}
					_gl.bindTransformFeedback(_gl.TRANSFORM_FEEDBACK, this.feedback);
				} else {
					_gl.bindTransformFeedback(_gl.TRANSFORM_FEEDBACK, null);
				}
			}
		};
		_proto.setRaster = function setRaster(on) {
			if (this.raster === on) return;
			this.raster = on;
			if (this.webgl2) {
				if (on) {
					this.gl.disable(this.gl.RASTERIZER_DISCARD);
				} else {
					this.gl.enable(this.gl.RASTERIZER_DISCARD);
				}
			}
		};
		_proto.setDepthBias = function setDepthBias(on) {
			if (this.depthBiasEnabled === on) return;
			this.depthBiasEnabled = on;
			if (on) {
				this.gl.enable(this.gl.POLYGON_OFFSET_FILL);
			} else {
				this.gl.disable(this.gl.POLYGON_OFFSET_FILL);
			}
		};
		_proto.setDepthBiasValues = function setDepthBiasValues(constBias, slopeBias) {
			this.gl.polygonOffset(slopeBias, constBias);
		};
		_proto.setStencilTest = function setStencilTest(enable) {
			if (this.stencil !== enable) {
				var _gl2 = this.gl;
				if (enable) {
					_gl2.enable(_gl2.STENCIL_TEST);
				} else {
					_gl2.disable(_gl2.STENCIL_TEST);
				}
				this.stencil = enable;
			}
		};
		_proto.setStencilFunc = function setStencilFunc(func, ref, mask) {
			if (this.stencilFuncFront !== func || this.stencilRefFront !== ref || this.stencilMaskFront !== mask || this.stencilFuncBack !== func || this.stencilRefBack !== ref || this.stencilMaskBack !== mask) {
				this.gl.stencilFunc(this.glComparison[func], ref, mask);
				this.stencilFuncFront = this.stencilFuncBack = func;
				this.stencilRefFront = this.stencilRefBack = ref;
				this.stencilMaskFront = this.stencilMaskBack = mask;
			}
		};
		_proto.setStencilFuncFront = function setStencilFuncFront(func, ref, mask) {
			if (this.stencilFuncFront !== func || this.stencilRefFront !== ref || this.stencilMaskFront !== mask) {
				var _gl3 = this.gl;
				_gl3.stencilFuncSeparate(_gl3.FRONT, this.glComparison[func], ref, mask);
				this.stencilFuncFront = func;
				this.stencilRefFront = ref;
				this.stencilMaskFront = mask;
			}
		};
		_proto.setStencilFuncBack = function setStencilFuncBack(func, ref, mask) {
			if (this.stencilFuncBack !== func || this.stencilRefBack !== ref || this.stencilMaskBack !== mask) {
				var _gl4 = this.gl;
				_gl4.stencilFuncSeparate(_gl4.BACK, this.glComparison[func], ref, mask);
				this.stencilFuncBack = func;
				this.stencilRefBack = ref;
				this.stencilMaskBack = mask;
			}
		};
		_proto.setStencilOperation = function setStencilOperation(fail, zfail, zpass, writeMask) {
			if (this.stencilFailFront !== fail || this.stencilZfailFront !== zfail || this.stencilZpassFront !== zpass || this.stencilFailBack !== fail || this.stencilZfailBack !== zfail || this.stencilZpassBack !== zpass) {
				this.gl.stencilOp(this.glStencilOp[fail], this.glStencilOp[zfail], this.glStencilOp[zpass]);
				this.stencilFailFront = this.stencilFailBack = fail;
				this.stencilZfailFront = this.stencilZfailBack = zfail;
				this.stencilZpassFront = this.stencilZpassBack = zpass;
			}
			if (this.stencilWriteMaskFront !== writeMask || this.stencilWriteMaskBack !== writeMask) {
				this.gl.stencilMask(writeMask);
				this.stencilWriteMaskFront = writeMask;
				this.stencilWriteMaskBack = writeMask;
			}
		};
		_proto.setStencilOperationFront = function setStencilOperationFront(fail, zfail, zpass, writeMask) {
			if (this.stencilFailFront !== fail || this.stencilZfailFront !== zfail || this.stencilZpassFront !== zpass) {
				this.gl.stencilOpSeparate(this.gl.FRONT, this.glStencilOp[fail], this.glStencilOp[zfail], this.glStencilOp[zpass]);
				this.stencilFailFront = fail;
				this.stencilZfailFront = zfail;
				this.stencilZpassFront = zpass;
			}
			if (this.stencilWriteMaskFront !== writeMask) {
				this.gl.stencilMaskSeparate(this.gl.FRONT, writeMask);
				this.stencilWriteMaskFront = writeMask;
			}
		};
		_proto.setStencilOperationBack = function setStencilOperationBack(fail, zfail, zpass, writeMask) {
			if (this.stencilFailBack !== fail || this.stencilZfailBack !== zfail || this.stencilZpassBack !== zpass) {
				this.gl.stencilOpSeparate(this.gl.BACK, this.glStencilOp[fail], this.glStencilOp[zfail], this.glStencilOp[zpass]);
				this.stencilFailBack = fail;
				this.stencilZfailBack = zfail;
				this.stencilZpassBack = zpass;
			}
			if (this.stencilWriteMaskBack !== writeMask) {
				this.gl.stencilMaskSeparate(this.gl.BACK, writeMask);
				this.stencilWriteMaskBack = writeMask;
			}
		};
		_proto.setBlendState = function setBlendState(blendState) {
			var currentBlendState = this.blendState;
			if (!currentBlendState.equals(blendState)) {
				var _gl5 = this.gl;
				var blend = blendState.blend,
					colorOp = blendState.colorOp,
					alphaOp = blendState.alphaOp,
					colorSrcFactor = blendState.colorSrcFactor,
					colorDstFactor = blendState.colorDstFactor,
					alphaSrcFactor = blendState.alphaSrcFactor,
					alphaDstFactor = blendState.alphaDstFactor;
				if (currentBlendState.blend !== blend) {
					if (blend) {
						_gl5.enable(_gl5.BLEND);
					} else {
						_gl5.disable(_gl5.BLEND);
					}
				}
				if (currentBlendState.colorOp !== colorOp || currentBlendState.alphaOp !== alphaOp) {
					var glBlendEquation = this.glBlendEquation;
					_gl5.blendEquationSeparate(glBlendEquation[colorOp], glBlendEquation[alphaOp]);
				}
				if (currentBlendState.colorSrcFactor !== colorSrcFactor || currentBlendState.colorDstFactor !== colorDstFactor || currentBlendState.alphaSrcFactor !== alphaSrcFactor || currentBlendState.alphaDstFactor !== alphaDstFactor) {
					_gl5.blendFuncSeparate(this.glBlendFunctionColor[colorSrcFactor], this.glBlendFunctionColor[colorDstFactor], this.glBlendFunctionAlpha[alphaSrcFactor], this.glBlendFunctionAlpha[alphaDstFactor]);
				}
				if (currentBlendState.allWrite !== blendState.allWrite) {
					this.gl.colorMask(blendState.redWrite, blendState.greenWrite, blendState.blueWrite, blendState.alphaWrite);
				}
				currentBlendState.copy(blendState);
			}
		};
		_proto.setBlendColor = function setBlendColor(r, g, b, a) {
			var c = this.blendColor;
			if (r !== c.r || g !== c.g || b !== c.b || a !== c.a) {
				this.gl.blendColor(r, g, b, a);
				c.set(r, g, b, a);
			}
		};
		_proto.setStencilState = function setStencilState(stencilFront, stencilBack) {
			if (stencilFront || stencilBack) {
				this.setStencilTest(true);
				if (stencilFront === stencilBack) {
					this.setStencilFunc(stencilFront.func, stencilFront.ref, stencilFront.readMask);
					this.setStencilOperation(stencilFront.fail, stencilFront.zfail, stencilFront.zpass, stencilFront.writeMask);
				} else {
					var _stencilFront, _stencilBack;
					(_stencilFront = stencilFront) != null ? _stencilFront : stencilFront = StencilParameters.DEFAULT;
					this.setStencilFuncFront(stencilFront.func, stencilFront.ref, stencilFront.readMask);
					this.setStencilOperationFront(stencilFront.fail, stencilFront.zfail, stencilFront.zpass, stencilFront.writeMask);
					(_stencilBack = stencilBack) != null ? _stencilBack : stencilBack = StencilParameters.DEFAULT;
					this.setStencilFuncBack(stencilBack.func, stencilBack.ref, stencilBack.readMask);
					this.setStencilOperationBack(stencilBack.fail, stencilBack.zfail, stencilBack.zpass, stencilBack.writeMask);
				}
			} else {
				this.setStencilTest(false);
			}
		};
		_proto.setDepthState = function setDepthState(depthState) {
			var currentDepthState = this.depthState;
			if (!currentDepthState.equals(depthState)) {
				var _gl6 = this.gl;
				var write = depthState.write;
				if (currentDepthState.write !== write) {
					_gl6.depthMask(write);
				}
				var func = depthState.func,
					test = depthState.test;
				if (!test && write) {
					test = true;
					func = FUNC_ALWAYS;
				}
				if (currentDepthState.func !== func) {
					_gl6.depthFunc(this.glComparison[func]);
				}
				if (currentDepthState.test !== test) {
					if (test) {
						_gl6.enable(_gl6.DEPTH_TEST);
					} else {
						_gl6.disable(_gl6.DEPTH_TEST);
					}
				}
				currentDepthState.copy(depthState);
			}
		};
		_proto.setCullMode = function setCullMode(cullMode) {
			if (this.cullMode !== cullMode) {
				if (cullMode === CULLFACE_NONE) {
					this.gl.disable(this.gl.CULL_FACE);
				} else {
					if (this.cullMode === CULLFACE_NONE) {
						this.gl.enable(this.gl.CULL_FACE);
					}
					var mode = this.glCull[cullMode];
					if (this.cullFace !== mode) {
						this.gl.cullFace(mode);
						this.cullFace = mode;
					}
				}
				this.cullMode = cullMode;
			}
		};
		_proto.setShader = function setShader(shader) {
			if (shader !== this.shader) {
				if (shader.failed) {
					return false;
				} else if (!shader.ready && !shader.impl.finalize(this, shader)) {
					shader.failed = true;
					return false;
				}
				this.shader = shader;
				this.gl.useProgram(shader.impl.glProgram);
				this.attributesInvalidated = true;
			}
			return true;
		};
		_proto.getHdrFormat = function getHdrFormat(preferLargest, renderable, updatable, filterable) {
			var f16Valid = this.extTextureHalfFloat && (!renderable || this.textureHalfFloatRenderable) && (!updatable || this.textureHalfFloatUpdatable) && (!filterable || this.extTextureHalfFloatLinear);
			var f32Valid = this.extTextureFloat && (!renderable || this.textureFloatRenderable) && (!filterable || this.extTextureFloatLinear);
			if (f16Valid && f32Valid) {
				return preferLargest ? PIXELFORMAT_RGBA32F : PIXELFORMAT_RGBA16F;
			} else if (f16Valid) {
				return PIXELFORMAT_RGBA16F;
			} else if (f32Valid) {
				return PIXELFORMAT_RGBA32F;
			}
			return null;
		};
		_proto.clearVertexArrayObjectCache = function clearVertexArrayObjectCache() {
			var gl = this.gl;
			this._vaoMap.forEach(function (item, key, mapObj) {
				gl.deleteVertexArray(item);
			});
			this._vaoMap.clear();
		};
		_proto.resizeCanvas = function resizeCanvas(width, height) {
			this._width = width;
			this._height = height;
			var ratio = Math.min(this._maxPixelRatio, platform.browser ? window.devicePixelRatio : 1);
			width = Math.floor(width * ratio);
			height = Math.floor(height * ratio);
			if (this.canvas.width !== width || this.canvas.height !== height) {
				this.canvas.width = width;
				this.canvas.height = height;
				this.fire(GraphicsDevice.EVENT_RESIZE, width, height);
			}
		};
		_createClass(WebglGraphicsDevice, [{
			key: "extDisjointTimerQuery",
			get: function get() {
				if (!this._extDisjointTimerQuery) {
					if (this.webgl2) {
						this._extDisjointTimerQuery = this.getExtension('EXT_disjoint_timer_query_webgl2', 'EXT_disjoint_timer_query');
					}
				}
				return this._extDisjointTimerQuery;
			}
		}, {
			key: "width",
			get: function get() {
				return this.gl.drawingBufferWidth || this.canvas.width;
			}
		}, {
			key: "height",
			get: function get() {
				return this.gl.drawingBufferHeight || this.canvas.height;
			}
		}, {
			key: "fullscreen",
			get: function get() {
				return !!document.fullscreenElement;
			},
			set: function set(fullscreen) {
				if (fullscreen) {
					var canvas = this.gl.canvas;
					canvas.requestFullscreen();
				} else {
					document.exitFullscreen();
				}
			}
		}, {
			key: "textureFloatHighPrecision",
			get: function get() {
				if (this._textureFloatHighPrecision === undefined) {
					this._textureFloatHighPrecision = testTextureFloatHighPrecision(this);
				}
				return this._textureFloatHighPrecision;
			}
		}, {
			key: "textureHalfFloatUpdatable",
			get: function get() {
				if (this._textureHalfFloatUpdatable === undefined) {
					if (this.webgl2) {
						this._textureHalfFloatUpdatable = true;
					} else {
						this._textureHalfFloatUpdatable = testTextureHalfFloatUpdatable(this.gl, this.extTextureHalfFloat.HALF_FLOAT_OES);
					}
				}
				return this._textureHalfFloatUpdatable;
			}
		}]);
		return WebglGraphicsDevice;
	}(GraphicsDevice);

	function createGraphicsDevice(canvas, options) {
		var _options$deviceTypes;
		if (options === void 0) {
			options = {};
		}
		var deviceTypes = (_options$deviceTypes = options.deviceTypes) != null ? _options$deviceTypes : [];
		if (!deviceTypes.includes(DEVICETYPE_WEBGL2)) {
			deviceTypes.push(DEVICETYPE_WEBGL2);
		}
		if (!deviceTypes.includes(DEVICETYPE_WEBGL1)) {
			deviceTypes.push(DEVICETYPE_WEBGL1);
		}
		if (platform.browser && !!navigator.xr) {
			var _options, _options$xrCompatible;
			(_options$xrCompatible = (_options = options).xrCompatible) != null ? _options$xrCompatible : _options.xrCompatible = true;
		}
		var device;
		for (var i = 0; i < deviceTypes.length; i++) {
			var _window;
			var deviceType = deviceTypes[i];
			if (deviceType === DEVICETYPE_WEBGPU && (_window = window) != null && (_window = _window.navigator) != null && _window.gpu) {
				device = new WebgpuGraphicsDevice(canvas, options);
				return device.initWebGpu(options.glslangUrl, options.twgslUrl);
			}
			if (deviceType !== DEVICETYPE_WEBGPU) {
				options.preferWebGl2 = deviceType === DEVICETYPE_WEBGL2;
				device = new WebglGraphicsDevice(canvas, options);
				return Promise.resolve(device);
			}
		}
		return Promise.reject(new Error("Failed to allocate graphics device"));
	}

	var id$3 = 0;
	var IndexBuffer = function () {
		function IndexBuffer(graphicsDevice, format, numIndices, usage, initialData) {
			if (usage === void 0) {
				usage = BUFFER_STATIC;
			}
			this.device = graphicsDevice;
			this.format = format;
			this.numIndices = numIndices;
			this.usage = usage;
			this.id = id$3++;
			this.impl = graphicsDevice.createIndexBufferImpl(this);
			var bytesPerIndex = typedArrayIndexFormatsByteSize[format];
			this.bytesPerIndex = bytesPerIndex;
			this.numBytes = this.numIndices * bytesPerIndex;
			if (initialData) {
				this.setData(initialData);
			} else {
				this.storage = new ArrayBuffer(this.numBytes);
			}
			this.adjustVramSizeTracking(graphicsDevice._vram, this.numBytes);
			this.device.buffers.push(this);
		}
		var _proto = IndexBuffer.prototype;
		_proto.destroy = function destroy() {
			var device = this.device;
			var idx = device.buffers.indexOf(this);
			if (idx !== -1) {
				device.buffers.splice(idx, 1);
			}
			if (this.device.indexBuffer === this) {
				this.device.indexBuffer = null;
			}
			if (this.impl.initialized) {
				this.impl.destroy(device);
				this.adjustVramSizeTracking(device._vram, -this.storage.byteLength);
			}
		};
		_proto.adjustVramSizeTracking = function adjustVramSizeTracking(vram, size) {
			vram.ib += size;
		};
		_proto.loseContext = function loseContext() {
			this.impl.loseContext();
		};
		_proto.getFormat = function getFormat() {
			return this.format;
		};
		_proto.getNumIndices = function getNumIndices() {
			return this.numIndices;
		};
		_proto.lock = function lock() {
			return this.storage;
		};
		_proto.unlock = function unlock() {
			this.impl.unlock(this);
		};
		_proto.setData = function setData(data) {
			if (data.byteLength !== this.numBytes) {
				return false;
			}
			this.storage = data;
			this.unlock();
			return true;
		};
		_proto._lockTypedArray = function _lockTypedArray() {
			var lock = this.lock();
			var indices = this.format === INDEXFORMAT_UINT32 ? new Uint32Array(lock) : this.format === INDEXFORMAT_UINT16 ? new Uint16Array(lock) : new Uint8Array(lock);
			return indices;
		};
		_proto.writeData = function writeData(data, count) {
			var indices = this._lockTypedArray();
			if (data.length > count) {
				if (ArrayBuffer.isView(data)) {
					data = data.subarray(0, count);
					indices.set(data);
				} else {
					for (var i = 0; i < count; i++) indices[i] = data[i];
				}
			} else {
				indices.set(data);
			}
			this.unlock();
		};
		_proto.readData = function readData(data) {
			var indices = this._lockTypedArray();
			var count = this.numIndices;
			if (ArrayBuffer.isView(data)) {
				data.set(indices);
			} else {
				data.length = 0;
				for (var i = 0; i < count; i++) data[i] = indices[i];
			}
			return count;
		};
		return IndexBuffer;
	}();

	var TransformFeedback = function () {
		function TransformFeedback(inputBuffer, usage) {
			if (usage === void 0) {
				usage = BUFFER_GPUDYNAMIC;
			}
			this.device = inputBuffer.device;
			var gl = this.device.gl;
			this._inputBuffer = inputBuffer;
			if (usage === BUFFER_GPUDYNAMIC && inputBuffer.usage !== usage) {
				gl.bindBuffer(gl.ARRAY_BUFFER, inputBuffer.impl.bufferId);
				gl.bufferData(gl.ARRAY_BUFFER, inputBuffer.storage, gl.DYNAMIC_COPY);
			}
			this._outputBuffer = new VertexBuffer(inputBuffer.device, inputBuffer.format, inputBuffer.numVertices, usage, inputBuffer.storage);
		}
		TransformFeedback.createShader = function createShader(graphicsDevice, vertexCode, name) {
			return new Shader(graphicsDevice, ShaderUtils.createDefinition(graphicsDevice, {
				name: name,
				vertexCode: vertexCode,
				useTransformFeedback: true
			}));
		};
		var _proto = TransformFeedback.prototype;
		_proto.destroy = function destroy() {
			this._outputBuffer.destroy();
		};
		_proto.process = function process(shader, swap) {
			if (swap === void 0) {
				swap = true;
			}
			var device = this.device;
			var oldRt = device.getRenderTarget();
			device.setRenderTarget(null);
			device.updateBegin();
			device.setVertexBuffer(this._inputBuffer, 0);
			device.setRaster(false);
			device.setTransformFeedbackBuffer(this._outputBuffer);
			device.setShader(shader);
			device.draw({
				type: PRIMITIVE_POINTS,
				base: 0,
				count: this._inputBuffer.numVertices,
				indexed: false
			});
			device.setTransformFeedbackBuffer(null);
			device.setRaster(true);
			device.updateEnd();
			device.setRenderTarget(oldRt);
			if (swap) {
				var tmp = this._inputBuffer.impl.bufferId;
				this._inputBuffer.impl.bufferId = this._outputBuffer.impl.bufferId;
				this._outputBuffer.impl.bufferId = tmp;
				tmp = this._inputBuffer.impl.vao;
				this._inputBuffer.impl.vao = this._outputBuffer.impl.vao;
				this._outputBuffer.impl.vao = tmp;
			}
		};
		_createClass(TransformFeedback, [{
			key: "inputBuffer",
			get: function get() {
				return this._inputBuffer;
			}
		}, {
			key: "outputBuffer",
			get: function get() {
				return this._outputBuffer;
			}
		}]);
		return TransformFeedback;
	}();

	function set1(a) {
		this.array[this.index] = a;
	}
	function set2(a, b) {
		this.array[this.index] = a;
		this.array[this.index + 1] = b;
	}
	function set3(a, b, c) {
		this.array[this.index] = a;
		this.array[this.index + 1] = b;
		this.array[this.index + 2] = c;
	}
	function set4(a, b, c, d) {
		this.array[this.index] = a;
		this.array[this.index + 1] = b;
		this.array[this.index + 2] = c;
		this.array[this.index + 3] = d;
	}
	function arraySet1(index, inputArray, inputIndex) {
		this.array[index] = inputArray[inputIndex];
	}
	function arraySet2(index, inputArray, inputIndex) {
		this.array[index] = inputArray[inputIndex];
		this.array[index + 1] = inputArray[inputIndex + 1];
	}
	function arraySet3(index, inputArray, inputIndex) {
		this.array[index] = inputArray[inputIndex];
		this.array[index + 1] = inputArray[inputIndex + 1];
		this.array[index + 2] = inputArray[inputIndex + 2];
	}
	function arraySet4(index, inputArray, inputIndex) {
		this.array[index] = inputArray[inputIndex];
		this.array[index + 1] = inputArray[inputIndex + 1];
		this.array[index + 2] = inputArray[inputIndex + 2];
		this.array[index + 3] = inputArray[inputIndex + 3];
	}
	function arrayGet1(offset, outputArray, outputIndex) {
		outputArray[outputIndex] = this.array[offset];
	}
	function arrayGet2(offset, outputArray, outputIndex) {
		outputArray[outputIndex] = this.array[offset];
		outputArray[outputIndex + 1] = this.array[offset + 1];
	}
	function arrayGet3(offset, outputArray, outputIndex) {
		outputArray[outputIndex] = this.array[offset];
		outputArray[outputIndex + 1] = this.array[offset + 1];
		outputArray[outputIndex + 2] = this.array[offset + 2];
	}
	function arrayGet4(offset, outputArray, outputIndex) {
		outputArray[outputIndex] = this.array[offset];
		outputArray[outputIndex + 1] = this.array[offset + 1];
		outputArray[outputIndex + 2] = this.array[offset + 2];
		outputArray[outputIndex + 3] = this.array[offset + 3];
	}
	var VertexIteratorAccessor = function () {
		function VertexIteratorAccessor(buffer, vertexElement, vertexFormat) {
			this.index = 0;
			this.numComponents = vertexElement.numComponents;
			if (vertexFormat.interleaved) {
				this.array = new typedArrayTypes[vertexElement.dataType](buffer, vertexElement.offset);
			} else {
				this.array = new typedArrayTypes[vertexElement.dataType](buffer, vertexElement.offset, vertexFormat.vertexCount * vertexElement.numComponents);
			}
			this.stride = vertexElement.stride / this.array.constructor.BYTES_PER_ELEMENT;
			switch (vertexElement.numComponents) {
				case 1:
					this.set = set1;
					this.getToArray = arrayGet1;
					this.setFromArray = arraySet1;
					break;
				case 2:
					this.set = set2;
					this.getToArray = arrayGet2;
					this.setFromArray = arraySet2;
					break;
				case 3:
					this.set = set3;
					this.getToArray = arrayGet3;
					this.setFromArray = arraySet3;
					break;
				case 4:
					this.set = set4;
					this.getToArray = arrayGet4;
					this.setFromArray = arraySet4;
					break;
			}
		}
		var _proto = VertexIteratorAccessor.prototype;
		_proto.get = function get(offset) {
			return this.array[this.index + offset];
		};
		_proto.set = function set(a, b, c, d) {};
		_proto.getToArray = function getToArray(offset, outputArray, outputIndex) {};
		_proto.setFromArray = function setFromArray(index, inputArray, inputIndex) {};
		return VertexIteratorAccessor;
	}();
	var VertexIterator = function () {
		function VertexIterator(vertexBuffer) {
			this.vertexBuffer = vertexBuffer;
			this.vertexFormatSize = vertexBuffer.getFormat().size;
			this.buffer = this.vertexBuffer.lock();
			this.accessors = [];
			this.element = {};
			var vertexFormat = this.vertexBuffer.getFormat();
			for (var i = 0; i < vertexFormat.elements.length; i++) {
				var vertexElement = vertexFormat.elements[i];
				this.accessors[i] = new VertexIteratorAccessor(this.buffer, vertexElement, vertexFormat);
				this.element[vertexElement.name] = this.accessors[i];
			}
		}
		var _proto2 = VertexIterator.prototype;
		_proto2.next = function next(count) {
			if (count === void 0) {
				count = 1;
			}
			var i = 0;
			var accessors = this.accessors;
			var numAccessors = this.accessors.length;
			while (i < numAccessors) {
				var accessor = accessors[i++];
				accessor.index += count * accessor.stride;
			}
		};
		_proto2.end = function end() {
			this.vertexBuffer.unlock();
		};
		_proto2.writeData = function writeData(semantic, data, numVertices) {
			var element = this.element[semantic];
			if (element) {
				if (numVertices > this.vertexBuffer.numVertices) {
					numVertices = this.vertexBuffer.numVertices;
				}
				var numComponents = element.numComponents;
				if (this.vertexBuffer.getFormat().interleaved) {
					var index = 0;
					for (var i = 0; i < numVertices; i++) {
						element.setFromArray(index, data, i * numComponents);
						index += element.stride;
					}
				} else {
					if (data.length > numVertices * numComponents) {
						var copyCount = numVertices * numComponents;
						if (ArrayBuffer.isView(data)) {
							data = data.subarray(0, copyCount);
							element.array.set(data);
						} else {
							for (var _i = 0; _i < copyCount; _i++) element.array[_i] = data[_i];
						}
					} else {
						element.array.set(data);
					}
				}
			}
		};
		_proto2.readData = function readData(semantic, data) {
			var element = this.element[semantic];
			var count = 0;
			if (element) {
				count = this.vertexBuffer.numVertices;
				var i;
				var numComponents = element.numComponents;
				if (this.vertexBuffer.getFormat().interleaved) {
					if (Array.isArray(data)) data.length = 0;
					element.index = 0;
					var offset = 0;
					for (i = 0; i < count; i++) {
						element.getToArray(offset, data, i * numComponents);
						offset += element.stride;
					}
				} else {
					if (ArrayBuffer.isView(data)) {
						data.set(element.array);
					} else {
						data.length = 0;
						var copyCount = count * numComponents;
						for (i = 0; i < copyCount; i++) data[i] = element.array[i];
					}
				}
			}
			return count;
		};
		return VertexIterator;
	}();

	var ACTION_MOUSE = 'mouse';
	var ACTION_KEYBOARD = 'keyboard';
	var ACTION_GAMEPAD = 'gamepad';
	var AXIS_MOUSE_X = 'mousex';
	var AXIS_MOUSE_Y = 'mousey';
	var AXIS_PAD_L_X = 'padlx';
	var AXIS_PAD_L_Y = 'padly';
	var AXIS_PAD_R_X = 'padrx';
	var AXIS_PAD_R_Y = 'padry';
	var AXIS_KEY = 'key';
	var EVENT_KEYDOWN = 'keydown';
	var EVENT_KEYUP = 'keyup';
	var EVENT_MOUSEDOWN = 'mousedown';
	var EVENT_MOUSEMOVE = 'mousemove';
	var EVENT_MOUSEUP = 'mouseup';
	var EVENT_MOUSEWHEEL = 'mousewheel';
	var EVENT_TOUCHSTART = 'touchstart';
	var EVENT_TOUCHEND = 'touchend';
	var EVENT_TOUCHMOVE = 'touchmove';
	var EVENT_TOUCHCANCEL = 'touchcancel';
	var EVENT_SELECT = 'select';
	var EVENT_SELECTSTART = 'selectstart';
	var EVENT_SELECTEND = 'selectend';
	var KEY_BACKSPACE = 8;
	var KEY_TAB = 9;
	var KEY_RETURN = 13;
	var KEY_ENTER = 13;
	var KEY_SHIFT = 16;
	var KEY_CONTROL = 17;
	var KEY_ALT = 18;
	var KEY_PAUSE = 19;
	var KEY_CAPS_LOCK = 20;
	var KEY_ESCAPE = 27;
	var KEY_SPACE = 32;
	var KEY_PAGE_UP = 33;
	var KEY_PAGE_DOWN = 34;
	var KEY_END = 35;
	var KEY_HOME = 36;
	var KEY_LEFT = 37;
	var KEY_UP = 38;
	var KEY_RIGHT = 39;
	var KEY_DOWN = 40;
	var KEY_PRINT_SCREEN = 44;
	var KEY_INSERT = 45;
	var KEY_DELETE = 46;
	var KEY_0 = 48;
	var KEY_1 = 49;
	var KEY_2 = 50;
	var KEY_3 = 51;
	var KEY_4 = 52;
	var KEY_5 = 53;
	var KEY_6 = 54;
	var KEY_7 = 55;
	var KEY_8 = 56;
	var KEY_9 = 57;
	var KEY_SEMICOLON = 59;
	var KEY_EQUAL = 61;
	var KEY_A = 65;
	var KEY_B = 66;
	var KEY_C = 67;
	var KEY_D = 68;
	var KEY_E = 69;
	var KEY_F = 70;
	var KEY_G = 71;
	var KEY_H = 72;
	var KEY_I = 73;
	var KEY_J = 74;
	var KEY_K = 75;
	var KEY_L = 76;
	var KEY_M = 77;
	var KEY_N = 78;
	var KEY_O = 79;
	var KEY_P = 80;
	var KEY_Q = 81;
	var KEY_R = 82;
	var KEY_S = 83;
	var KEY_T = 84;
	var KEY_U = 85;
	var KEY_V = 86;
	var KEY_W = 87;
	var KEY_X = 88;
	var KEY_Y = 89;
	var KEY_Z = 90;
	var KEY_WINDOWS = 91;
	var KEY_CONTEXT_MENU = 93;
	var KEY_NUMPAD_0 = 96;
	var KEY_NUMPAD_1 = 97;
	var KEY_NUMPAD_2 = 98;
	var KEY_NUMPAD_3 = 99;
	var KEY_NUMPAD_4 = 100;
	var KEY_NUMPAD_5 = 101;
	var KEY_NUMPAD_6 = 102;
	var KEY_NUMPAD_7 = 103;
	var KEY_NUMPAD_8 = 104;
	var KEY_NUMPAD_9 = 105;
	var KEY_MULTIPLY = 106;
	var KEY_ADD = 107;
	var KEY_SEPARATOR = 108;
	var KEY_SUBTRACT = 109;
	var KEY_DECIMAL = 110;
	var KEY_DIVIDE = 111;
	var KEY_F1 = 112;
	var KEY_F2 = 113;
	var KEY_F3 = 114;
	var KEY_F4 = 115;
	var KEY_F5 = 116;
	var KEY_F6 = 117;
	var KEY_F7 = 118;
	var KEY_F8 = 119;
	var KEY_F9 = 120;
	var KEY_F10 = 121;
	var KEY_F11 = 122;
	var KEY_F12 = 123;
	var KEY_COMMA = 188;
	var KEY_PERIOD = 190;
	var KEY_SLASH = 191;
	var KEY_OPEN_BRACKET = 219;
	var KEY_BACK_SLASH = 220;
	var KEY_CLOSE_BRACKET = 221;
	var KEY_META = 224;
	var MOUSEBUTTON_NONE = -1;
	var MOUSEBUTTON_LEFT = 0;
	var MOUSEBUTTON_MIDDLE = 1;
	var MOUSEBUTTON_RIGHT = 2;
	var PAD_1 = 0;
	var PAD_2 = 1;
	var PAD_3 = 2;
	var PAD_4 = 3;
	var PAD_FACE_1 = 0;
	var PAD_FACE_2 = 1;
	var PAD_FACE_3 = 2;
	var PAD_FACE_4 = 3;
	var PAD_L_SHOULDER_1 = 4;
	var PAD_R_SHOULDER_1 = 5;
	var PAD_L_SHOULDER_2 = 6;
	var PAD_R_SHOULDER_2 = 7;
	var PAD_SELECT = 8;
	var PAD_START = 9;
	var PAD_L_STICK_BUTTON = 10;
	var PAD_R_STICK_BUTTON = 11;
	var PAD_UP = 12;
	var PAD_DOWN = 13;
	var PAD_LEFT = 14;
	var PAD_RIGHT = 15;
	var PAD_VENDOR = 16;
	var PAD_L_STICK_X = 0;
	var PAD_L_STICK_Y = 1;
	var PAD_R_STICK_X = 2;
	var PAD_R_STICK_Y = 3;
	var EVENT_GAMEPADCONNECTED = 'gamepadconnected';
	var EVENT_GAMEPADDISCONNECTED = 'gamepaddisconnected';
	var XRPAD_TOUCHPAD_X = 0;
	var XRPAD_TOUCHPAD_Y = 1;
	var XRPAD_STICK_X = 2;
	var XRPAD_STICK_Y = 3;
	var XRPAD_TOUCHPAD_BUTTON = 2;
	var XRPAD_TRIGGER = 0;
	var XRPAD_SQUEEZE = 1;
	var XRPAD_STICK_BUTTON = 3;
	var XRPAD_A = 4;
	var XRPAD_B = 5;

	var KeyboardEvent = function KeyboardEvent(keyboard, event) {
		if (event) {
			this.key = event.keyCode;
			this.element = event.target;
			this.event = event;
		} else {
			this.key = null;
			this.element = null;
			this.event = null;
		}
	};

	var _keyboardEvent = new KeyboardEvent();
	function makeKeyboardEvent(event) {
		_keyboardEvent.key = event.keyCode;
		_keyboardEvent.element = event.target;
		_keyboardEvent.event = event;
		return _keyboardEvent;
	}
	function toKeyCode(s) {
		if (typeof s === 'string') {
			return s.toUpperCase().charCodeAt(0);
		}
		return s;
	}
	var _keyCodeToKeyIdentifier = {
		'9': 'Tab',
		'13': 'Enter',
		'16': 'Shift',
		'17': 'Control',
		'18': 'Alt',
		'27': 'Escape',
		'37': 'Left',
		'38': 'Up',
		'39': 'Right',
		'40': 'Down',
		'46': 'Delete',
		'91': 'Win'
	};
	var Keyboard = function (_EventHandler) {
		_inheritsLoose(Keyboard, _EventHandler);
		function Keyboard(element, options) {
			var _this;
			if (options === void 0) {
				options = {};
			}
			_this = _EventHandler.call(this) || this;
			_this._element = null;
			_this._keyDownHandler = _this._handleKeyDown.bind(_assertThisInitialized(_this));
			_this._keyUpHandler = _this._handleKeyUp.bind(_assertThisInitialized(_this));
			_this._keyPressHandler = _this._handleKeyPress.bind(_assertThisInitialized(_this));
			_this._visibilityChangeHandler = _this._handleVisibilityChange.bind(_assertThisInitialized(_this));
			_this._windowBlurHandler = _this._handleWindowBlur.bind(_assertThisInitialized(_this));
			_this._keymap = {};
			_this._lastmap = {};
			if (element) {
				_this.attach(element);
			}
			_this.preventDefault = options.preventDefault || false;
			_this.stopPropagation = options.stopPropagation || false;
			return _this;
		}
		var _proto = Keyboard.prototype;
		_proto.attach = function attach(element) {
			if (this._element) {
				this.detach();
			}
			this._element = element;
			this._element.addEventListener('keydown', this._keyDownHandler, false);
			this._element.addEventListener('keypress', this._keyPressHandler, false);
			this._element.addEventListener('keyup', this._keyUpHandler, false);
			document.addEventListener('visibilitychange', this._visibilityChangeHandler, false);
			window.addEventListener('blur', this._windowBlurHandler, false);
		};
		_proto.detach = function detach() {
			if (!this._element) {
				return;
			}
			this._element.removeEventListener('keydown', this._keyDownHandler);
			this._element.removeEventListener('keypress', this._keyPressHandler);
			this._element.removeEventListener('keyup', this._keyUpHandler);
			this._element = null;
			document.removeEventListener('visibilitychange', this._visibilityChangeHandler, false);
			window.removeEventListener('blur', this._windowBlurHandler, false);
		};
		_proto.toKeyIdentifier = function toKeyIdentifier(keyCode) {
			keyCode = toKeyCode(keyCode);
			var id = _keyCodeToKeyIdentifier[keyCode.toString()];
			if (id) {
				return id;
			}
			var hex = keyCode.toString(16).toUpperCase();
			var length = hex.length;
			for (var count = 0; count < 4 - length; count++) {
				hex = '0' + hex;
			}
			return 'U+' + hex;
		};
		_proto._handleKeyDown = function _handleKeyDown(event) {
			var code = event.keyCode || event.charCode;
			if (code === undefined) return;
			var id = this.toKeyIdentifier(code);
			this._keymap[id] = true;
			this.fire('keydown', makeKeyboardEvent(event));
			if (this.preventDefault) {
				event.preventDefault();
			}
			if (this.stopPropagation) {
				event.stopPropagation();
			}
		};
		_proto._handleKeyUp = function _handleKeyUp(event) {
			var code = event.keyCode || event.charCode;
			if (code === undefined) return;
			var id = this.toKeyIdentifier(code);
			delete this._keymap[id];
			this.fire('keyup', makeKeyboardEvent(event));
			if (this.preventDefault) {
				event.preventDefault();
			}
			if (this.stopPropagation) {
				event.stopPropagation();
			}
		};
		_proto._handleKeyPress = function _handleKeyPress(event) {
			this.fire('keypress', makeKeyboardEvent(event));
			if (this.preventDefault) {
				event.preventDefault();
			}
			if (this.stopPropagation) {
				event.stopPropagation();
			}
		};
		_proto._handleVisibilityChange = function _handleVisibilityChange() {
			if (document.visibilityState === 'hidden') {
				this._handleWindowBlur();
			}
		};
		_proto._handleWindowBlur = function _handleWindowBlur() {
			this._keymap = {};
			this._lastmap = {};
		};
		_proto.update = function update() {
			for (var prop in this._lastmap) {
				delete this._lastmap[prop];
			}
			for (var _prop in this._keymap) {
				if (this._keymap.hasOwnProperty(_prop)) {
					this._lastmap[_prop] = this._keymap[_prop];
				}
			}
		};
		_proto.isPressed = function isPressed(key) {
			var keyCode = toKeyCode(key);
			var id = this.toKeyIdentifier(keyCode);
			return !!this._keymap[id];
		};
		_proto.wasPressed = function wasPressed(key) {
			var keyCode = toKeyCode(key);
			var id = this.toKeyIdentifier(keyCode);
			return !!this._keymap[id] && !!!this._lastmap[id];
		};
		_proto.wasReleased = function wasReleased(key) {
			var keyCode = toKeyCode(key);
			var id = this.toKeyIdentifier(keyCode);
			return !!!this._keymap[id] && !!this._lastmap[id];
		};
		return Keyboard;
	}(EventHandler);

	function isMousePointerLocked() {
		return !!(document.pointerLockElement || document.mozPointerLockElement || document.webkitPointerLockElement);
	}
	var MouseEvent = function MouseEvent(mouse, event) {
		var coords = {
			x: 0,
			y: 0
		};
		if (event) {
			if (event instanceof MouseEvent) {
				throw Error('Expected MouseEvent');
			}
			coords = mouse._getTargetCoords(event);
		} else {
			event = {};
		}
		if (coords) {
			this.x = coords.x;
			this.y = coords.y;
		} else if (isMousePointerLocked()) {
			this.x = 0;
			this.y = 0;
		} else {
			return;
		}
		this.wheelDelta = 0;
		if (event.type === 'wheel') {
			if (event.deltaY > 0) {
				this.wheelDelta = 1;
			} else if (event.deltaY < 0) {
				this.wheelDelta = -1;
			}
		}
		if (isMousePointerLocked()) {
			this.dx = event.movementX || event.webkitMovementX || event.mozMovementX || 0;
			this.dy = event.movementY || event.webkitMovementY || event.mozMovementY || 0;
		} else {
			this.dx = this.x - mouse._lastX;
			this.dy = this.y - mouse._lastY;
		}
		if (event.type === 'mousedown' || event.type === 'mouseup') {
			this.button = event.button;
		} else {
			this.button = MOUSEBUTTON_NONE;
		}
		this.buttons = mouse._buttons.slice(0);
		this.element = event.target;
		this.ctrlKey = event.ctrlKey || false;
		this.altKey = event.altKey || false;
		this.shiftKey = event.shiftKey || false;
		this.metaKey = event.metaKey || false;
		this.event = event;
	};

	var Mouse = function (_EventHandler) {
		_inheritsLoose(Mouse, _EventHandler);
		function Mouse(element) {
			var _this;
			_this = _EventHandler.call(this) || this;
			_this._lastX = 0;
			_this._lastY = 0;
			_this._buttons = [false, false, false];
			_this._lastbuttons = [false, false, false];
			_this._upHandler = _this._handleUp.bind(_assertThisInitialized(_this));
			_this._downHandler = _this._handleDown.bind(_assertThisInitialized(_this));
			_this._moveHandler = _this._handleMove.bind(_assertThisInitialized(_this));
			_this._wheelHandler = _this._handleWheel.bind(_assertThisInitialized(_this));
			_this._contextMenuHandler = function (event) {
				event.preventDefault();
			};
			_this._target = null;
			_this._attached = false;
			_this.attach(element);
			return _this;
		}
		Mouse.isPointerLocked = function isPointerLocked() {
			return isMousePointerLocked();
		};
		var _proto = Mouse.prototype;
		_proto.attach = function attach(element) {
			this._target = element;
			if (this._attached) return;
			this._attached = true;
			var opts = platform.passiveEvents ? {
				passive: false
			} : false;
			window.addEventListener('mouseup', this._upHandler, opts);
			window.addEventListener('mousedown', this._downHandler, opts);
			window.addEventListener('mousemove', this._moveHandler, opts);
			window.addEventListener('wheel', this._wheelHandler, opts);
		};
		_proto.detach = function detach() {
			if (!this._attached) return;
			this._attached = false;
			this._target = null;
			var opts = platform.passiveEvents ? {
				passive: false
			} : false;
			window.removeEventListener('mouseup', this._upHandler, opts);
			window.removeEventListener('mousedown', this._downHandler, opts);
			window.removeEventListener('mousemove', this._moveHandler, opts);
			window.removeEventListener('wheel', this._wheelHandler, opts);
		};
		_proto.disableContextMenu = function disableContextMenu() {
			if (!this._target) return;
			this._target.addEventListener('contextmenu', this._contextMenuHandler);
		};
		_proto.enableContextMenu = function enableContextMenu() {
			if (!this._target) return;
			this._target.removeEventListener('contextmenu', this._contextMenuHandler);
		};
		_proto.enablePointerLock = function enablePointerLock(success, error) {
			if (!document.body.requestPointerLock) {
				if (error) error();
				return;
			}
			var s = function s() {
				success();
				document.removeEventListener('pointerlockchange', s);
			};
			var e = function e() {
				error();
				document.removeEventListener('pointerlockerror', e);
			};
			if (success) {
				document.addEventListener('pointerlockchange', s, false);
			}
			if (error) {
				document.addEventListener('pointerlockerror', e, false);
			}
			document.body.requestPointerLock();
		};
		_proto.disablePointerLock = function disablePointerLock(success) {
			if (!document.exitPointerLock) {
				return;
			}
			var s = function s() {
				success();
				document.removeEventListener('pointerlockchange', s);
			};
			if (success) {
				document.addEventListener('pointerlockchange', s, false);
			}
			document.exitPointerLock();
		};
		_proto.update = function update() {
			this._lastbuttons[0] = this._buttons[0];
			this._lastbuttons[1] = this._buttons[1];
			this._lastbuttons[2] = this._buttons[2];
		};
		_proto.isPressed = function isPressed(button) {
			return this._buttons[button];
		};
		_proto.wasPressed = function wasPressed(button) {
			return this._buttons[button] && !this._lastbuttons[button];
		};
		_proto.wasReleased = function wasReleased(button) {
			return !this._buttons[button] && this._lastbuttons[button];
		};
		_proto._handleUp = function _handleUp(event) {
			this._buttons[event.button] = false;
			var e = new MouseEvent(this, event);
			if (!e.event) return;
			this.fire(EVENT_MOUSEUP, e);
		};
		_proto._handleDown = function _handleDown(event) {
			this._buttons[event.button] = true;
			var e = new MouseEvent(this, event);
			if (!e.event) return;
			this.fire(EVENT_MOUSEDOWN, e);
		};
		_proto._handleMove = function _handleMove(event) {
			var e = new MouseEvent(this, event);
			if (!e.event) return;
			this.fire(EVENT_MOUSEMOVE, e);
			this._lastX = e.x;
			this._lastY = e.y;
		};
		_proto._handleWheel = function _handleWheel(event) {
			var e = new MouseEvent(this, event);
			if (!e.event) return;
			this.fire(EVENT_MOUSEWHEEL, e);
		};
		_proto._getTargetCoords = function _getTargetCoords(event) {
			var rect = this._target.getBoundingClientRect();
			var left = Math.floor(rect.left);
			var top = Math.floor(rect.top);
			if (event.clientX < left || event.clientX >= left + this._target.clientWidth || event.clientY < top || event.clientY >= top + this._target.clientHeight) {
				return null;
			}
			return {
				x: event.clientX - left,
				y: event.clientY - top
			};
		};
		return Mouse;
	}(EventHandler);

	var Controller = function () {
		function Controller(element, options) {
			if (options === void 0) {
				options = {};
			}
			this._keyboard = options.keyboard || null;
			this._mouse = options.mouse || null;
			this._gamepads = options.gamepads || null;
			this._element = null;
			this._actions = {};
			this._axes = {};
			this._axesValues = {};
			if (element) {
				this.attach(element);
			}
		}
		var _proto = Controller.prototype;
		_proto.attach = function attach(element) {
			this._element = element;
			if (this._keyboard) {
				this._keyboard.attach(element);
			}
			if (this._mouse) {
				this._mouse.attach(element);
			}
		};
		_proto.detach = function detach() {
			if (this._keyboard) {
				this._keyboard.detach();
			}
			if (this._mouse) {
				this._mouse.detach();
			}
			this._element = null;
		};
		_proto.disableContextMenu = function disableContextMenu() {
			if (!this._mouse) {
				this._enableMouse();
			}
			this._mouse.disableContextMenu();
		};
		_proto.enableContextMenu = function enableContextMenu() {
			if (!this._mouse) {
				this._enableMouse();
			}
			this._mouse.enableContextMenu();
		};
		_proto.update = function update(dt) {
			if (this._keyboard) {
				this._keyboard.update();
			}
			if (this._mouse) {
				this._mouse.update();
			}
			if (this._gamepads) {
				this._gamepads.update();
			}
			this._axesValues = {};
			for (var key in this._axes) {
				this._axesValues[key] = [];
			}
		};
		_proto.appendAction = function appendAction(action_name, action) {
			this._actions[action_name] = this._actions[action_name] || [];
			this._actions[action_name].push(action);
		};
		_proto.registerKeys = function registerKeys(action, keys) {
			if (!this._keyboard) {
				this._enableKeyboard();
			}
			if (this._actions[action]) {
				throw new Error("Action: " + action + " already registered");
			}
			if (keys === undefined) {
				throw new Error('Invalid button');
			}
			if (!keys.length) {
				keys = [keys];
			}
			this.appendAction(action, {
				type: ACTION_KEYBOARD,
				keys: keys
			});
		};
		_proto.registerMouse = function registerMouse(action, button) {
			if (!this._mouse) {
				this._enableMouse();
			}
			if (button === undefined) {
				throw new Error('Invalid button');
			}
			this.appendAction(action, {
				type: ACTION_MOUSE,
				button: button
			});
		};
		_proto.registerPadButton = function registerPadButton(action, pad, button) {
			if (button === undefined) {
				throw new Error('Invalid button');
			}
			this.appendAction(action, {
				type: ACTION_GAMEPAD,
				button: button,
				pad: pad
			});
		};
		_proto.registerAxis = function registerAxis(options) {
			var name = options.name;
			if (!this._axes[name]) {
				this._axes[name] = [];
			}
			var i = this._axes[name].push(name);
			options = options || {};
			options.pad = options.pad || PAD_1;
			var bind = function bind(controller, source, value, key) {
				switch (source) {
					case 'mousex':
						controller._mouse.on(EVENT_MOUSEMOVE, function (e) {
							controller._axesValues[name][i] = e.dx / 10;
						});
						break;
					case 'mousey':
						controller._mouse.on(EVENT_MOUSEMOVE, function (e) {
							controller._axesValues[name][i] = e.dy / 10;
						});
						break;
					case 'key':
						controller._axes[name].push(function () {
							return controller._keyboard.isPressed(key) ? value : 0;
						});
						break;
					case 'padrx':
						controller._axes[name].push(function () {
							return controller._gamepads.getAxis(options.pad, PAD_R_STICK_X);
						});
						break;
					case 'padry':
						controller._axes[name].push(function () {
							return controller._gamepads.getAxis(options.pad, PAD_R_STICK_Y);
						});
						break;
					case 'padlx':
						controller._axes[name].push(function () {
							return controller._gamepads.getAxis(options.pad, PAD_L_STICK_X);
						});
						break;
					case 'padly':
						controller._axes[name].push(function () {
							return controller._gamepads.getAxis(options.pad, PAD_L_STICK_Y);
						});
						break;
					default:
						throw new Error('Unknown axis');
				}
			};
			bind(this, options.positive, 1, options.positiveKey);
			if (options.negativeKey || options.negative !== options.positive) {
				bind(this, options.negative, -1, options.negativeKey);
			}
		};
		_proto.isPressed = function isPressed(actionName) {
			if (!this._actions[actionName]) {
				return false;
			}
			var length = this._actions[actionName].length;
			for (var index = 0; index < length; ++index) {
				var action = this._actions[actionName][index];
				switch (action.type) {
					case ACTION_KEYBOARD:
						if (this._keyboard) {
							var len = action.keys.length;
							for (var i = 0; i < len; i++) {
								if (this._keyboard.isPressed(action.keys[i])) {
									return true;
								}
							}
						}
						break;
					case ACTION_MOUSE:
						if (this._mouse && this._mouse.isPressed(action.button)) {
							return true;
						}
						break;
					case ACTION_GAMEPAD:
						if (this._gamepads && this._gamepads.isPressed(action.pad, action.button)) {
							return true;
						}
						break;
				}
			}
			return false;
		};
		_proto.wasPressed = function wasPressed(actionName) {
			if (!this._actions[actionName]) {
				return false;
			}
			var length = this._actions[actionName].length;
			for (var index = 0; index < length; ++index) {
				var action = this._actions[actionName][index];
				switch (action.type) {
					case ACTION_KEYBOARD:
						if (this._keyboard) {
							var len = action.keys.length;
							for (var i = 0; i < len; i++) {
								if (this._keyboard.wasPressed(action.keys[i])) {
									return true;
								}
							}
						}
						break;
					case ACTION_MOUSE:
						if (this._mouse && this._mouse.wasPressed(action.button)) {
							return true;
						}
						break;
					case ACTION_GAMEPAD:
						if (this._gamepads && this._gamepads.wasPressed(action.pad, action.button)) {
							return true;
						}
						break;
				}
			}
			return false;
		};
		_proto.getAxis = function getAxis(name) {
			var value = 0;
			if (this._axes[name]) {
				var len = this._axes[name].length;
				for (var i = 0; i < len; i++) {
					if (type$1(this._axes[name][i]) === 'function') {
						var v = this._axes[name][i]();
						if (Math.abs(v) > Math.abs(value)) {
							value = v;
						}
					} else if (this._axesValues[name]) {
						if (Math.abs(this._axesValues[name][i]) > Math.abs(value)) {
							value = this._axesValues[name][i];
						}
					}
				}
			}
			return value;
		};
		_proto._enableMouse = function _enableMouse() {
			this._mouse = new Mouse();
			if (!this._element) {
				throw new Error('Controller must be attached to an Element');
			}
			this._mouse.attach(this._element);
		};
		_proto._enableKeyboard = function _enableKeyboard() {
			this._keyboard = new Keyboard();
			if (!this._element) {
				throw new Error('Controller must be attached to an Element');
			}
			this._keyboard.attach(this._element);
		};
		return Controller;
	}();

	var dummyArray = Object.freeze([]);
	var getGamepads = function getGamepads() {
		return dummyArray;
	};
	if (typeof navigator !== 'undefined') {
		getGamepads = (navigator.getGamepads || navigator.webkitGetGamepads || getGamepads).bind(navigator);
	}
	var MAPS_INDEXES = {
		buttons: {
			PAD_FACE_1: PAD_FACE_1,
			PAD_FACE_2: PAD_FACE_2,
			PAD_FACE_3: PAD_FACE_3,
			PAD_FACE_4: PAD_FACE_4,
			PAD_L_SHOULDER_1: PAD_L_SHOULDER_1,
			PAD_R_SHOULDER_1: PAD_R_SHOULDER_1,
			PAD_L_SHOULDER_2: PAD_L_SHOULDER_2,
			PAD_R_SHOULDER_2: PAD_R_SHOULDER_2,
			PAD_SELECT: PAD_SELECT,
			PAD_START: PAD_START,
			PAD_L_STICK_BUTTON: PAD_L_STICK_BUTTON,
			PAD_R_STICK_BUTTON: PAD_R_STICK_BUTTON,
			PAD_UP: PAD_UP,
			PAD_DOWN: PAD_DOWN,
			PAD_LEFT: PAD_LEFT,
			PAD_RIGHT: PAD_RIGHT,
			PAD_VENDOR: PAD_VENDOR,
			XRPAD_TRIGGER: XRPAD_TRIGGER,
			XRPAD_SQUEEZE: XRPAD_SQUEEZE,
			XRPAD_TOUCHPAD_BUTTON: XRPAD_TOUCHPAD_BUTTON,
			XRPAD_STICK_BUTTON: XRPAD_STICK_BUTTON,
			XRPAD_A: XRPAD_A,
			XRPAD_B: XRPAD_B
		},
		axes: {
			PAD_L_STICK_X: PAD_L_STICK_X,
			PAD_L_STICK_Y: PAD_L_STICK_Y,
			PAD_R_STICK_X: PAD_R_STICK_X,
			PAD_R_STICK_Y: PAD_R_STICK_Y,
			XRPAD_TOUCHPAD_X: XRPAD_TOUCHPAD_X,
			XRPAD_TOUCHPAD_Y: XRPAD_TOUCHPAD_Y,
			XRPAD_STICK_X: XRPAD_STICK_X,
			XRPAD_STICK_Y: XRPAD_STICK_Y
		}
	};
	var MAPS = {
		DEFAULT: {
			buttons: ['PAD_FACE_1', 'PAD_FACE_2', 'PAD_FACE_3', 'PAD_FACE_4', 'PAD_L_SHOULDER_1', 'PAD_R_SHOULDER_1', 'PAD_L_SHOULDER_2', 'PAD_R_SHOULDER_2', 'PAD_SELECT', 'PAD_START', 'PAD_L_STICK_BUTTON', 'PAD_R_STICK_BUTTON', 'PAD_UP', 'PAD_DOWN', 'PAD_LEFT', 'PAD_RIGHT', 'PAD_VENDOR'],
			axes: ['PAD_L_STICK_X', 'PAD_L_STICK_Y', 'PAD_R_STICK_X', 'PAD_R_STICK_Y']
		},
		DEFAULT_DUAL: {
			buttons: ['PAD_FACE_1', 'PAD_FACE_2', 'PAD_FACE_3', 'PAD_FACE_4', 'PAD_L_SHOULDER_1', 'PAD_R_SHOULDER_1', 'PAD_L_SHOULDER_2', 'PAD_R_SHOULDER_2', 'PAD_SELECT', 'PAD_START', 'PAD_L_STICK_BUTTON', 'PAD_R_STICK_BUTTON', 'PAD_VENDOR'],
			axes: ['PAD_L_STICK_X', 'PAD_L_STICK_Y', 'PAD_R_STICK_X', 'PAD_R_STICK_Y'],
			synthesizedButtons: {
				PAD_UP: {
					axis: 0,
					min: 0,
					max: 1
				},
				PAD_DOWN: {
					axis: 0,
					min: -1,
					max: 0
				},
				PAD_LEFT: {
					axis: 0,
					min: -1,
					max: 0
				},
				PAD_RIGHT: {
					axis: 0,
					min: 0,
					max: 1
				}
			}
		},
		PS3: {
			buttons: ['PAD_FACE_1', 'PAD_FACE_2', 'PAD_FACE_4', 'PAD_FACE_3', 'PAD_L_SHOULDER_1', 'PAD_R_SHOULDER_1', 'PAD_L_SHOULDER_2', 'PAD_R_SHOULDER_2', 'PAD_SELECT', 'PAD_START', 'PAD_L_STICK_BUTTON', 'PAD_R_STICK_BUTTON', 'PAD_UP', 'PAD_DOWN', 'PAD_LEFT', 'PAD_RIGHT', 'PAD_VENDOR'],
			axes: ['PAD_L_STICK_X', 'PAD_L_STICK_Y', 'PAD_R_STICK_X', 'PAD_R_STICK_Y'],
			mapping: 'standard'
		},
		DEFAULT_XR: {
			buttons: ['XRPAD_TRIGGER', 'XRPAD_SQUEEZE', 'XRPAD_TOUCHPAD_BUTTON', 'XRPAD_STICK_BUTTON', 'XRPAD_A', 'XRPAD_B'],
			axes: ['XRPAD_TOUCHPAD_X', 'XRPAD_TOUCHPAD_Y', 'XRPAD_STICK_X', 'XRPAD_STICK_Y'],
			mapping: 'xr-standard'
		}
	};
	var PRODUCT_CODES = {
		'Product: 0268': 'PS3'
	};
	var custom_maps = {};
	function _getMap(pad) {
		var custom = custom_maps[pad.id];
		if (custom) {
			return custom;
		}
		for (var code in PRODUCT_CODES) {
			if (pad.id.indexOf(code) !== -1) {
				var product = PRODUCT_CODES[code];
				if (!pad.mapping) {
					var raw = MAPS['RAW_' + product];
					if (raw) {
						return raw;
					}
				}
				return MAPS[product];
			}
		}
		if (pad.mapping === 'xr-standard') {
			return MAPS.DEFAULT_XR;
		}
		var defaultmap = MAPS.DEFAULT;
		var map = pad.buttons.length < defaultmap.buttons.length ? MAPS.DEFAULT_DUAL : defaultmap;
		map.mapping = pad.mapping;
		return map;
	}
	var deadZone = 0.25;
	function sleep(ms) {
		return new Promise(function (resolve) {
			setTimeout(resolve, ms);
		});
	}
	var GamePadButton = function () {
		function GamePadButton(current, previous) {
			this.value = 0;
			this.pressed = false;
			this.touched = false;
			this.wasPressed = false;
			this.wasReleased = false;
			this.wasTouched = false;
			if (typeof current === 'number') {
				this.value = current;
				this.pressed = current === 1;
				this.touched = current > 0;
			} else {
				var _current$touched;
				this.value = current.value;
				this.pressed = current.pressed;
				this.touched = (_current$touched = current.touched) != null ? _current$touched : current.value > 0;
			}
			if (previous) {
				if (typeof previous === 'number') {
					this.wasPressed = previous !== 1 && this.pressed;
					this.wasReleased = previous === 1 && !this.pressed;
					this.wasTouched = previous === 0 && this.touched;
				} else {
					var _previous$touched;
					this.wasPressed = !previous.pressed && this.pressed;
					this.wasReleased = previous.pressed && !this.pressed;
					this.wasTouched = !((_previous$touched = previous.touched) != null ? _previous$touched : previous.value > 0) && this.touched;
				}
			}
		}
		var _proto = GamePadButton.prototype;
		_proto.update = function update(button) {
			var _button$touched;
			var value = button.value,
				pressed = button.pressed;
			var touched = (_button$touched = button.touched) != null ? _button$touched : value > 0;
			this.wasPressed = !this.pressed && pressed;
			this.wasReleased = this.pressed && !pressed;
			this.wasTouched = !this.touched && touched;
			this.value = value;
			this.pressed = pressed;
			this.touched = touched;
		};
		return GamePadButton;
	}();
	var dummyButton = Object.freeze(new GamePadButton(0));
	var GamePad = function () {
		function GamePad(gamepad, map) {
			this._compiledMapping = {
				buttons: [],
				axes: []
			};
			this.id = gamepad.id;
			this.index = gamepad.index;
			this._buttons = gamepad.buttons.map(function (b) {
				return new GamePadButton(b);
			});
			this._axes = [].concat(gamepad.axes);
			this._previousAxes = [].concat(gamepad.axes);
			this.mapping = map.mapping;
			this.map = map;
			this.hand = gamepad.hand || 'none';
			this.pad = gamepad;
			this._compileMapping();
		}
		var _proto2 = GamePad.prototype;
		_proto2._compileMapping = function _compileMapping() {
			var _this = this;
			var _this$_compiledMappin = this._compiledMapping,
				axes = _this$_compiledMappin.axes,
				buttons = _this$_compiledMappin.buttons;
			var axesIndexes = MAPS_INDEXES.axes;
			var buttonsIndexes = MAPS_INDEXES.buttons;
			axes.length = 0;
			buttons.length = 0;
			var axesMap = this.map.axes;
			if (axesMap) {
				this.map.axes.forEach(function (axis, i) {
					axes[axesIndexes[axis]] = function () {
						return _this.pad.axes[i] || 0;
					};
				});
			}
			for (var i = 0, l = axes.length; i < l; i++) {
				if (!axes[i]) {
					axes[i] = function () {
						return 0;
					};
				}
			}
			var buttonsMap = this.map.buttons;
			if (buttonsMap) {
				buttonsMap.forEach(function (button, i) {
					buttons[buttonsIndexes[button]] = function () {
						return _this._buttons[i] || dummyButton;
					};
				});
			}
			var synthesizedButtonsMap = this.map.synthesizedButtons;
			if (synthesizedButtonsMap) {
				Object.entries(synthesizedButtonsMap).forEach(function (button) {
					var _button$ = button[1],
						axis = _button$.axis,
						max = _button$.max,
						min = _button$.min;
					buttons[buttonsIndexes[button[0]]] = function () {
						var _this$_axes$axis, _this$_previousAxes$a;
						return new GamePadButton(Math.abs(math.clamp((_this$_axes$axis = _this._axes[axis]) != null ? _this$_axes$axis : 0, min, max)), Math.abs(math.clamp((_this$_previousAxes$a = _this._previousAxes[axis]) != null ? _this$_previousAxes$a : 0, min, max)));
					};
				});
			}
			for (var _i = 0, _l = buttons.length; _i < _l; _i++) {
				if (!buttons[_i]) {
					buttons[_i] = function () {
						return dummyButton;
					};
				}
			}
		};
		_proto2.update = function update(gamepad) {
			this.pad = gamepad;
			var previousAxes = this._previousAxes;
			var axes = this._axes;
			previousAxes.length = 0;
			previousAxes.push.apply(previousAxes, axes);
			axes.length = 0;
			axes.push.apply(axes, gamepad.axes);
			var buttons = this._buttons;
			for (var i = 0, l = buttons.length; i < l; i++) {
				buttons[i].update(gamepad.buttons[i]);
			}
			return this;
		};
		_proto2.updateMap = function updateMap(map) {
			map.mapping = 'custom';
			custom_maps[this.id] = map;
			this.map = map;
			this.mapping = 'custom';
			this._compileMapping();
		};
		_proto2.resetMap = function resetMap() {
			if (custom_maps[this.id]) {
				delete custom_maps[this.id];
				var map = _getMap(this.pad);
				this.map = map;
				this.mapping = map.mapping;
				this._compileMapping();
			}
		};
		_proto2.pulse = function () {
			var _pulse = _asyncToGenerator(_regeneratorRuntime().mark(function _callee2(intensity, duration, options) {
				var actuators, _options$startDelay, _options$strongMagnit, _options$weakMagnitud, startDelay, strongMagnitude, weakMagnitude, results;
				return _regeneratorRuntime().wrap(function _callee2$(_context2) {
					while (1) switch (_context2.prev = _context2.next) {
						case 0:
							actuators = this.pad.vibrationActuator ? [this.pad.vibrationActuator] : this.pad.hapticActuators || dummyArray;
							if (!actuators.length) {
								_context2.next = 9;
								break;
							}
							startDelay = (_options$startDelay = options == null ? void 0 : options.startDelay) != null ? _options$startDelay : 0;
							strongMagnitude = (_options$strongMagnit = options == null ? void 0 : options.strongMagnitude) != null ? _options$strongMagnit : intensity;
							weakMagnitude = (_options$weakMagnitud = options == null ? void 0 : options.weakMagnitude) != null ? _options$weakMagnitud : intensity;
							_context2.next = 7;
							return Promise.all(actuators.map(function () {
								var _ref = _asyncToGenerator(_regeneratorRuntime().mark(function _callee(actuator) {
									return _regeneratorRuntime().wrap(function _callee$(_context) {
										while (1) switch (_context.prev = _context.next) {
											case 0:
												if (actuator) {
													_context.next = 2;
													break;
												}
												return _context.abrupt("return", true);
											case 2:
												if (!actuator.playEffect) {
													_context.next = 6;
													break;
												}
												return _context.abrupt("return", actuator.playEffect(actuator.type, {
													duration: duration,
													startDelay: startDelay,
													strongMagnitude: strongMagnitude,
													weakMagnitude: weakMagnitude
												}));
											case 6:
												if (!actuator.pulse) {
													_context.next = 10;
													break;
												}
												_context.next = 9;
												return sleep(startDelay);
											case 9:
												return _context.abrupt("return", actuator.pulse(intensity, duration));
											case 10:
												return _context.abrupt("return", false);
											case 11:
											case "end":
												return _context.stop();
										}
									}, _callee);
								}));
								return function (_x4) {
									return _ref.apply(this, arguments);
								};
							}()));
						case 7:
							results = _context2.sent;
							return _context2.abrupt("return", results.some(function (r) {
								return r === true || r === 'complete';
							}));
						case 9:
							return _context2.abrupt("return", false);
						case 10:
						case "end":
							return _context2.stop();
					}
				}, _callee2, this);
			}));
			function pulse(_x, _x2, _x3) {
				return _pulse.apply(this, arguments);
			}
			return pulse;
		}();
		_proto2.getButton = function getButton(index) {
			var button = this._compiledMapping.buttons[index];
			return button ? button() : dummyButton;
		};
		_proto2.isPressed = function isPressed(button) {
			return this.getButton(button).pressed;
		};
		_proto2.wasPressed = function wasPressed(button) {
			return this.getButton(button).wasPressed;
		};
		_proto2.wasReleased = function wasReleased(button) {
			return this.getButton(button).wasReleased;
		};
		_proto2.isTouched = function isTouched(button) {
			return this.getButton(button).touched;
		};
		_proto2.wasTouched = function wasTouched(button) {
			return this.getButton(button).wasTouched;
		};
		_proto2.getValue = function getValue(button) {
			return this.getButton(button).value;
		};
		_proto2.getAxis = function getAxis(axis) {
			var a = this.axes[axis];
			return a && Math.abs(a) > deadZone ? a : 0;
		};
		_createClass(GamePad, [{
			key: "connected",
			get: function get() {
				return this.pad.connected;
			}
		}, {
			key: "axes",
			get: function get() {
				return this._compiledMapping.axes.map(function (a) {
					return a();
				});
			}
		}, {
			key: "buttons",
			get: function get() {
				return this._compiledMapping.buttons.map(function (b) {
					return b();
				});
			}
		}]);
		return GamePad;
	}();
	var GamePads = function (_EventHandler) {
		_inheritsLoose(GamePads, _EventHandler);
		function GamePads() {
			var _this2;
			_this2 = _EventHandler.call(this) || this;
			_this2.gamepadsSupported = platform.gamepads;
			_this2.current = [];
			_this2._previous = [];
			_this2._ongamepadconnectedHandler = _this2._ongamepadconnected.bind(_assertThisInitialized(_this2));
			_this2._ongamepaddisconnectedHandler = _this2._ongamepaddisconnected.bind(_assertThisInitialized(_this2));
			window.addEventListener('gamepadconnected', _this2._ongamepadconnectedHandler, false);
			window.addEventListener('gamepaddisconnected', _this2._ongamepaddisconnectedHandler, false);
			_this2.poll();
			return _this2;
		}
		var _proto3 = GamePads.prototype;
		_proto3._ongamepadconnected = function _ongamepadconnected(event) {
			var pad = new GamePad(event.gamepad, this.getMap(event.gamepad));
			var current = this.current;
			var padIndex = current.findIndex(function (gp) {
				return gp.index === pad.index;
			});
			while (padIndex !== -1) {
				current.splice(padIndex, 1);
				padIndex = current.findIndex(function (gp) {
					return gp.index === pad.index;
				});
			}
			current.push(pad);
			this.fire(EVENT_GAMEPADCONNECTED, pad);
		};
		_proto3._ongamepaddisconnected = function _ongamepaddisconnected(event) {
			var current = this.current;
			var padIndex = current.findIndex(function (gp) {
				return gp.index === event.gamepad.index;
			});
			if (padIndex !== -1) {
				this.fire(EVENT_GAMEPADDISCONNECTED, current[padIndex]);
				current.splice(padIndex, 1);
			}
		};
		_proto3.update = function update() {
			this.poll();
		};
		_proto3.poll = function poll(pads) {
			if (pads === void 0) {
				pads = [];
			}
			if (pads.length > 0) {
				pads.length = 0;
			}
			var padDevices = getGamepads();
			for (var i = 0, len = padDevices.length; i < len; i++) {
				if (padDevices[i]) {
					var pad = this.findByIndex(padDevices[i].index);
					if (pad) {
						pads.push(pad.update(padDevices[i]));
					} else {
						var nPad = new GamePad(padDevices[i], this.getMap(padDevices[i]));
						this.current.push(nPad);
						pads.push(nPad);
					}
				}
			}
			return pads;
		};
		_proto3.destroy = function destroy() {
			window.removeEventListener('gamepadconnected', this._ongamepadconnectedHandler, false);
			window.removeEventListener('gamepaddisconnected', this._ongamepaddisconnectedHandler, false);
		};
		_proto3.getMap = function getMap(pad) {
			return _getMap(pad);
		};
		_proto3.isPressed = function isPressed(orderIndex, button) {
			var _this$current$orderIn;
			return ((_this$current$orderIn = this.current[orderIndex]) == null ? void 0 : _this$current$orderIn.isPressed(button)) || false;
		};
		_proto3.wasPressed = function wasPressed(orderIndex, button) {
			var _this$current$orderIn2;
			return ((_this$current$orderIn2 = this.current[orderIndex]) == null ? void 0 : _this$current$orderIn2.wasPressed(button)) || false;
		};
		_proto3.wasReleased = function wasReleased(orderIndex, button) {
			var _this$current$orderIn3;
			return ((_this$current$orderIn3 = this.current[orderIndex]) == null ? void 0 : _this$current$orderIn3.wasReleased(button)) || false;
		};
		_proto3.getAxis = function getAxis(orderIndex, axis) {
			var _this$current$orderIn4;
			return ((_this$current$orderIn4 = this.current[orderIndex]) == null ? void 0 : _this$current$orderIn4.getAxis(axis)) || 0;
		};
		_proto3.pulse = function pulse(orderIndex, intensity, duration, options) {
			var pad = this.current[orderIndex];
			return pad ? pad.pulse(intensity, duration, options) : Promise.resolve(false);
		};
		_proto3.pulseAll = function pulseAll(intensity, duration, options) {
			return Promise.all(this.current.map(function (pad) {
				return pad.pulse(intensity, duration, options);
			}));
		};
		_proto3.findById = function findById(id) {
			return this.current.find(function (gp) {
				return gp && gp.id === id;
			}) || null;
		};
		_proto3.findByIndex = function findByIndex(index) {
			return this.current.find(function (gp) {
				return gp && gp.index === index;
			}) || null;
		};
		_createClass(GamePads, [{
			key: "deadZone",
			get: function get() {
				return deadZone;
			},
			set: function set(value) {
				deadZone = value;
			}
		}, {
			key: "previous",
			get: function get() {
				var current = this.current;
				for (var i = 0, l = current.length; i < l; i++) {
					var buttons = current[i]._buttons;
					if (!this._previous[i]) {
						this._previous[i] = [];
					}
					for (var j = 0, m = buttons.length; j < m; j++) {
						var button = buttons[i];
						this.previous[i][j] = button ? !button.wasPressed && button.pressed || button.wasReleased : false;
					}
				}
				this._previous.length = this.current.length;
				return this._previous;
			}
		}]);
		return GamePads;
	}(EventHandler);

	function getTouchTargetCoords(touch) {
		var totalOffsetX = 0;
		var totalOffsetY = 0;
		var target = touch.target;
		while (!(target instanceof HTMLElement)) {
			target = target.parentNode;
		}
		var currentElement = target;
		do {
			totalOffsetX += currentElement.offsetLeft - currentElement.scrollLeft;
			totalOffsetY += currentElement.offsetTop - currentElement.scrollTop;
			currentElement = currentElement.offsetParent;
		} while (currentElement);
		return {
			x: touch.pageX - totalOffsetX,
			y: touch.pageY - totalOffsetY
		};
	}
	var Touch = function Touch(touch) {
		var coords = getTouchTargetCoords(touch);
		this.id = touch.identifier;
		this.x = coords.x;
		this.y = coords.y;
		this.target = touch.target;
		this.touch = touch;
	};
	var TouchEvent = function () {
		function TouchEvent(device, event) {
			this.element = event.target;
			this.event = event;
			this.touches = [];
			this.changedTouches = [];
			if (event) {
				for (var i = 0, l = event.touches.length; i < l; i++) {
					this.touches.push(new Touch(event.touches[i]));
				}
				for (var _i = 0, _l = event.changedTouches.length; _i < _l; _i++) {
					this.changedTouches.push(new Touch(event.changedTouches[_i]));
				}
			}
		}
		var _proto = TouchEvent.prototype;
		_proto.getTouchById = function getTouchById(id, list) {
			for (var i = 0, l = list.length; i < l; i++) {
				if (list[i].id === id) {
					return list[i];
				}
			}
			return null;
		};
		return TouchEvent;
	}();

	var TouchDevice = function (_EventHandler) {
		_inheritsLoose(TouchDevice, _EventHandler);
		function TouchDevice(element) {
			var _this;
			_this = _EventHandler.call(this) || this;
			_this._element = null;
			_this._startHandler = _this._handleTouchStart.bind(_assertThisInitialized(_this));
			_this._endHandler = _this._handleTouchEnd.bind(_assertThisInitialized(_this));
			_this._moveHandler = _this._handleTouchMove.bind(_assertThisInitialized(_this));
			_this._cancelHandler = _this._handleTouchCancel.bind(_assertThisInitialized(_this));
			_this.attach(element);
			return _this;
		}
		var _proto = TouchDevice.prototype;
		_proto.attach = function attach(element) {
			if (this._element) {
				this.detach();
			}
			this._element = element;
			this._element.addEventListener('touchstart', this._startHandler, false);
			this._element.addEventListener('touchend', this._endHandler, false);
			this._element.addEventListener('touchmove', this._moveHandler, false);
			this._element.addEventListener('touchcancel', this._cancelHandler, false);
		};
		_proto.detach = function detach() {
			if (this._element) {
				this._element.removeEventListener('touchstart', this._startHandler, false);
				this._element.removeEventListener('touchend', this._endHandler, false);
				this._element.removeEventListener('touchmove', this._moveHandler, false);
				this._element.removeEventListener('touchcancel', this._cancelHandler, false);
			}
			this._element = null;
		};
		_proto._handleTouchStart = function _handleTouchStart(e) {
			this.fire('touchstart', new TouchEvent(this, e));
		};
		_proto._handleTouchEnd = function _handleTouchEnd(e) {
			this.fire('touchend', new TouchEvent(this, e));
		};
		_proto._handleTouchMove = function _handleTouchMove(e) {
			e.preventDefault();
			this.fire('touchmove', new TouchEvent(this, e));
		};
		_proto._handleTouchCancel = function _handleTouchCancel(e) {
			this.fire('touchcancel', new TouchEvent(this, e));
		};
		return TouchDevice;
	}(EventHandler);

	var Http = function () {
		function Http() {}
		var _proto = Http.prototype;
		_proto.get = function get(url, options, callback) {
			if (typeof options === 'function') {
				callback = options;
				options = {};
			}
			if(typeof url == 'object') { // json object
				//var _this = this;
				setTimeout(function() {
					callback(null, url);
				}, 0);
				return;
			}
			console.log(url);
			return this.request('GET', url, options, callback);
		};
		_proto.post = function post(url, data, options, callback) {
			if (typeof options === 'function') {
				callback = options;
				options = {};
			}
			options.postdata = data;
			return this.request('POST', url, options, callback);
		};
		_proto.put = function put(url, data, options, callback) {
			if (typeof options === 'function') {
				callback = options;
				options = {};
			}
			options.postdata = data;
			return this.request('PUT', url, options, callback);
		};
		_proto.del = function del(url, options, callback) {
			if (typeof options === 'function') {
				callback = options;
				options = {};
			}
			return this.request('DELETE', url, options, callback);
		};
		_proto.request = function request(method, url, options, callback) {
			var _this = this;
			var uri, query, postdata;
			var errored = false;
			if (typeof options === 'function') {
				callback = options;
				options = {};
			}
			if (options.retry) {
				options = Object.assign({
					retries: 0,
					maxRetries: 5
				}, options);
			}
			options.callback = callback;
			if (options.async == null) {
				options.async = true;
			}
			if (options.headers == null) {
				options.headers = {};
			}
			if (options.postdata != null) {
				if (options.postdata instanceof Document) {
					postdata = options.postdata;
				} else if (options.postdata instanceof FormData) {
					postdata = options.postdata;
				} else if (options.postdata instanceof Object) {
					var contentType = options.headers['Content-Type'];
					if (contentType === undefined) {
						options.headers['Content-Type'] = Http.ContentType.FORM_URLENCODED;
						contentType = options.headers['Content-Type'];
					}
					switch (contentType) {
						case Http.ContentType.FORM_URLENCODED:
							{
								postdata = '';
								var bFirstItem = true;
								for (var key in options.postdata) {
									if (options.postdata.hasOwnProperty(key)) {
										if (bFirstItem) {
											bFirstItem = false;
										} else {
											postdata += '&';
										}
										var encodedKey = encodeURIComponent(key);
										var encodedValue = encodeURIComponent(options.postdata[key]);
										postdata += encodedKey + "=" + encodedValue;
									}
								}
								break;
							}
						default:
						case Http.ContentType.JSON:
							if (contentType == null) {
								options.headers['Content-Type'] = Http.ContentType.JSON;
							}
							postdata = JSON.stringify(options.postdata);
							break;
					}
				} else {
					postdata = options.postdata;
				}
			}
			if (options.cache === false) {
				var timestamp = now();
				uri = new URI(url);
				if (!uri.query) {
					uri.query = 'ts=' + timestamp;
				} else {
					uri.query = uri.query + '&ts=' + timestamp;
				}
				url = uri.toString();
			}
			if (options.query) {
				uri = new URI(url);
				query = extend(uri.getQuery(), options.query);
				uri.setQuery(query);
				url = uri.toString();
			}
			var xhr = new XMLHttpRequest();
			xhr.open(method, url, options.async);
			xhr.withCredentials = options.withCredentials !== undefined ? options.withCredentials : false;
			xhr.responseType = options.responseType || this._guessResponseType(url);
			for (var header in options.headers) {
				if (options.headers.hasOwnProperty(header)) {
					xhr.setRequestHeader(header, options.headers[header]);
				}
			}
			xhr.onreadystatechange = function () {
				_this._onReadyStateChange(method, url, options, xhr);
			};
			xhr.onerror = function () {
				_this._onError(method, url, options, xhr);
				errored = true;
			};
			try {
				xhr.send(postdata);
			} catch (e) {
				if (!errored) {
					options.error(xhr.status, xhr, e);
				}
			}
			return xhr;
		};
		_proto._guessResponseType = function _guessResponseType(url) {
			var uri = new URI(url);
			var ext = path.getExtension(uri.path).toLowerCase();
			if (Http.binaryExtensions.indexOf(ext) >= 0) {
				return Http.ResponseType.ARRAY_BUFFER;
			} else if (ext === '.json') {
				return Http.ResponseType.JSON;
			} else if (ext === '.xml') {
				return Http.ResponseType.DOCUMENT;
			}
			return Http.ResponseType.TEXT;
		};
		_proto._isBinaryContentType = function _isBinaryContentType(contentType) {
			var binTypes = [Http.ContentType.BASIS, Http.ContentType.BIN, Http.ContentType.DDS, Http.ContentType.GLB, Http.ContentType.MP3, Http.ContentType.MP4, Http.ContentType.OGG, Http.ContentType.OPUS, Http.ContentType.WAV];
			if (binTypes.indexOf(contentType) >= 0) {
				return true;
			}
			return false;
		};
		_proto._isBinaryResponseType = function _isBinaryResponseType(responseType) {
			return responseType === Http.ResponseType.ARRAY_BUFFER || responseType === Http.ResponseType.BLOB || responseType === Http.ResponseType.JSON;
		};
		_proto._onReadyStateChange = function _onReadyStateChange(method, url, options, xhr) {
			if (xhr.readyState === 4) {
				switch (xhr.status) {
					case 0:
						{
							if (xhr.responseURL && xhr.responseURL.startsWith('file:///')) {
								this._onSuccess(method, url, options, xhr);
							} else {
								this._onError(method, url, options, xhr);
							}
							break;
						}
					case 200:
					case 201:
					case 206:
					case 304:
						{
							this._onSuccess(method, url, options, xhr);
							break;
						}
					default:
						{
							console.log(url, xhr.status);
							this._onError(method, url, options, xhr);
							break;
						}
				}
			}
		};
		_proto._onSuccess = function _onSuccess(method, url, options, xhr) {
			var response;
			var contentType;
			var header = xhr.getResponseHeader('Content-Type');
			if (header) {
				var parts = header.split(';');
				contentType = parts[0].trim();
			}
			try {
				if (this._isBinaryContentType(contentType) || this._isBinaryResponseType(xhr.responseType)) {
					response = xhr.response;
				} else if (contentType === Http.ContentType.JSON || url.split('?')[0].endsWith('.json')) {
					response = JSON.parse(xhr.responseText);
				} else if (xhr.responseType === Http.ResponseType.DOCUMENT || contentType === Http.ContentType.XML) {
					response = xhr.responseXML;
				} else {
					response = xhr.responseText;
				}
				options.callback(null, response);
			} catch (err) {
				options.callback(err);
			}
		};
		_proto._onError = function _onError(method, url, options, xhr) {
			var _this2 = this;
			if (options.retrying) {
				return;
			}
			if (options.retry && options.retries < options.maxRetries) {
				options.retries++;
				options.retrying = true;
				var retryDelay = math.clamp(Math.pow(2, options.retries) * Http.retryDelay, 0, options.maxRetryDelay || 5000);
				console.log(method + ": " + url + " - Error " + xhr.status + ". Retrying in " + retryDelay + " ms");
				setTimeout(function () {
					options.retrying = false;
					_this2.request(method, url, options, options.callback);
				}, retryDelay);
			} else {
				options.callback(xhr.status === 0 ? 'Network error' : xhr.status, null);
			}
		};
		return Http;
	}();
	Http.ContentType = {
		AAC: 'audio/aac',
		BASIS: 'image/basis',
		BIN: 'application/octet-stream',
		DDS: 'image/dds',
		FORM_URLENCODED: 'application/x-www-form-urlencoded',
		GIF: 'image/gif',
		GLB: 'model/gltf-binary',
		JPEG: 'image/jpeg',
		JSON: 'application/json',
		MP3: 'audio/mpeg',
		MP4: 'audio/mp4',
		OGG: 'audio/ogg',
		OPUS: 'audio/ogg; codecs="opus"',
		PNG: 'image/png',
		TEXT: 'text/plain',
		WAV: 'audio/x-wav',
		XML: 'application/xml'
	};
	Http.ResponseType = {
		TEXT: 'text',
		ARRAY_BUFFER: 'arraybuffer',
		BLOB: 'blob',
		DOCUMENT: 'document',
		JSON: 'json'
	};
	Http.binaryExtensions = ['.model', '.wav', '.ogg', '.mp3', '.mp4', '.m4a', '.aac', '.dds', '.basis', '.glb', '.opus'];
	Http.retryDelay = 100;
	var http = new Http();

	function hasAudioContext() {
		return !!(typeof AudioContext !== 'undefined' || typeof webkitAudioContext !== 'undefined');
	}

	var Channel = function () {
		function Channel(manager, sound, options) {
			var _options$volume, _options$loop, _options$pitch;
			if (options === void 0) {
				options = {};
			}
			this.volume = (_options$volume = options.volume) != null ? _options$volume : 1;
			this.loop = (_options$loop = options.loop) != null ? _options$loop : false;
			this.pitch = (_options$pitch = options.pitch) != null ? _options$pitch : 1;
			this.sound = sound;
			this.paused = false;
			this.suspended = false;
			this.manager = manager;
			this.source = null;
			if (hasAudioContext()) {
				this.startTime = 0;
				this.startOffset = 0;
				var context = manager.context;
				this.gain = context.createGain();
			} else if (sound.audio) {
				this.source = sound.audio.cloneNode(false);
				this.source.pause();
			}
		}
		var _proto = Channel.prototype;
		_proto.getVolume = function getVolume() {
			return this.volume;
		};
		_proto.getLoop = function getLoop() {
			return this.loop;
		};
		_proto.setLoop = function setLoop(loop) {
			this.loop = loop;
			if (this.source) {
				this.source.loop = loop;
			}
		};
		_proto.getPitch = function getPitch() {
			return this.pitch;
		};
		_proto.onManagerVolumeChange = function onManagerVolumeChange() {
			this.setVolume(this.getVolume());
		};
		_proto.onManagerSuspend = function onManagerSuspend() {
			if (this.isPlaying() && !this.suspended) {
				this.suspended = true;
				this.pause();
			}
		};
		_proto.onManagerResume = function onManagerResume() {
			if (this.suspended) {
				this.suspended = false;
				this.unpause();
			}
		};
		_proto.play = function play() {
			if (this.source) {
				throw new Error('Call stop() before calling play()');
			}
			this._createSource();
			if (!this.source) {
				return;
			}
			this.startTime = this.manager.context.currentTime;
			this.source.start(0, this.startOffset % this.source.buffer.duration);
			this.setVolume(this.volume);
			this.setLoop(this.loop);
			this.setPitch(this.pitch);
			this.manager.on('volumechange', this.onManagerVolumeChange, this);
			this.manager.on('suspend', this.onManagerSuspend, this);
			this.manager.on('resume', this.onManagerResume, this);
			if (this.manager.suspended) this.onManagerSuspend();
		};
		_proto.pause = function pause() {
			if (this.source) {
				this.paused = true;
				this.startOffset += this.manager.context.currentTime - this.startTime;
				this.source.stop(0);
				this.source = null;
			}
		};
		_proto.unpause = function unpause() {
			if (this.source || !this.paused) {
				console.warn('Call pause() before unpausing.');
				return;
			}
			this._createSource();
			if (!this.source) {
				return;
			}
			this.startTime = this.manager.context.currentTime;
			this.source.start(0, this.startOffset % this.source.buffer.duration);
			this.setVolume(this.volume);
			this.setLoop(this.loop);
			this.setPitch(this.pitch);
			this.paused = false;
		};
		_proto.stop = function stop() {
			if (this.source) {
				this.source.stop(0);
				this.source = null;
			}
			this.manager.off('volumechange', this.onManagerVolumeChange, this);
			this.manager.off('suspend', this.onManagerSuspend, this);
			this.manager.off('resume', this.onManagerResume, this);
		};
		_proto.setVolume = function setVolume(volume) {
			volume = math.clamp(volume, 0, 1);
			this.volume = volume;
			if (this.gain) {
				this.gain.gain.value = volume * this.manager.volume;
			}
		};
		_proto.setPitch = function setPitch(pitch) {
			this.pitch = pitch;
			if (this.source) {
				this.source.playbackRate.value = pitch;
			}
		};
		_proto.isPlaying = function isPlaying() {
			return !this.paused && this.source.playbackState === this.source.PLAYING_STATE;
		};
		_proto.getDuration = function getDuration() {
			return this.source ? this.source.buffer.duration : 0;
		};
		_proto._createSource = function _createSource() {
			var context = this.manager.context;
			if (this.sound.buffer) {
				this.source = context.createBufferSource();
				this.source.buffer = this.sound.buffer;
				this.source.connect(this.gain);
				this.gain.connect(context.destination);
				if (!this.loop) {
					this.source.onended = this.pause.bind(this);
				}
			}
		};
		return Channel;
	}();
	if (!hasAudioContext()) {
		Object.assign(Channel.prototype, {
			play: function play() {
				if (this.source) {
					this.paused = false;
					this.setVolume(this.volume);
					this.setLoop(this.loop);
					this.setPitch(this.pitch);
					this.source.play();
				}
				this.manager.on('volumechange', this.onManagerVolumeChange, this);
				this.manager.on('suspend', this.onManagerSuspend, this);
				this.manager.on('resume', this.onManagerResume, this);
				if (this.manager.suspended) this.onManagerSuspend();
			},
			pause: function pause() {
				if (this.source) {
					this.paused = true;
					this.source.pause();
				}
			},
			unpause: function unpause() {
				if (this.source) {
					this.paused = false;
					this.source.play();
				}
			},
			stop: function stop() {
				if (this.source) {
					this.source.pause();
				}
				this.manager.off('volumechange', this.onManagerVolumeChange, this);
				this.manager.off('suspend', this.onManagerSuspend, this);
				this.manager.off('resume', this.onManagerResume, this);
			},
			setVolume: function setVolume(volume) {
				volume = math.clamp(volume, 0, 1);
				this.volume = volume;
				if (this.source) {
					this.source.volume = volume * this.manager.volume;
				}
			},
			setPitch: function setPitch(pitch) {
				this.pitch = pitch;
				if (this.source) {
					this.source.playbackRate = pitch;
				}
			},
			getDuration: function getDuration() {
				return this.source && !isNaN(this.source.duration) ? this.source.duration : 0;
			},
			isPlaying: function isPlaying() {
				return !this.source.paused;
			}
		});
	}

	var MAX_DISTANCE$1 = 10000;
	var Channel3d = function (_Channel) {
		_inheritsLoose(Channel3d, _Channel);
		function Channel3d(manager, sound, options) {
			var _this;
			_this = _Channel.call(this, manager, sound, options) || this;
			_this.position = new Vec3();
			_this.velocity = new Vec3();
			if (hasAudioContext()) {
				_this.panner = manager.context.createPanner();
			} else {
				_this.maxDistance = MAX_DISTANCE$1;
				_this.minDistance = 1;
				_this.rollOffFactor = 1;
				_this.distanceModel = DISTANCE_INVERSE;
			}
			return _this;
		}
		var _proto = Channel3d.prototype;
		_proto.getPosition = function getPosition() {
			return this.position;
		};
		_proto.setPosition = function setPosition(position) {
			this.position.copy(position);
			var panner = this.panner;
			if ('positionX' in panner) {
				panner.positionX.value = position.x;
				panner.positionY.value = position.y;
				panner.positionZ.value = position.z;
			} else if (panner.setPosition) {
				panner.setPosition(position.x, position.y, position.z);
			}
		};
		_proto.getVelocity = function getVelocity() {
			return this.velocity;
		};
		_proto.setVelocity = function setVelocity(velocity) {
			this.velocity.copy(velocity);
		};
		_proto.getMaxDistance = function getMaxDistance() {
			return this.panner.maxDistance;
		};
		_proto.setMaxDistance = function setMaxDistance(max) {
			this.panner.maxDistance = max;
		};
		_proto.getMinDistance = function getMinDistance() {
			return this.panner.refDistance;
		};
		_proto.setMinDistance = function setMinDistance(min) {
			this.panner.refDistance = min;
		};
		_proto.getRollOffFactor = function getRollOffFactor() {
			return this.panner.rolloffFactor;
		};
		_proto.setRollOffFactor = function setRollOffFactor(factor) {
			this.panner.rolloffFactor = factor;
		};
		_proto.getDistanceModel = function getDistanceModel() {
			return this.panner.distanceModel;
		};
		_proto.setDistanceModel = function setDistanceModel(distanceModel) {
			this.panner.distanceModel = distanceModel;
		};
		_proto._createSource = function _createSource() {
			var context = this.manager.context;
			this.source = context.createBufferSource();
			this.source.buffer = this.sound.buffer;
			this.source.connect(this.panner);
			this.panner.connect(this.gain);
			this.gain.connect(context.destination);
			if (!this.loop) {
				this.source.onended = this.pause.bind(this);
			}
		};
		return Channel3d;
	}(Channel);
	if (!hasAudioContext()) {
		var offset$1 = new Vec3();
		var fallOff$1 = function fallOff(posOne, posTwo, refDistance, maxDistance, rolloffFactor, distanceModel) {
			offset$1 = offset$1.sub2(posOne, posTwo);
			var distance = offset$1.length();
			if (distance < refDistance) {
				return 1;
			} else if (distance > maxDistance) {
				return 0;
			}
			var result = 0;
			if (distanceModel === DISTANCE_LINEAR) {
				result = 1 - rolloffFactor * (distance - refDistance) / (maxDistance - refDistance);
			} else if (distanceModel === DISTANCE_INVERSE) {
				result = refDistance / (refDistance + rolloffFactor * (distance - refDistance));
			} else if (distanceModel === DISTANCE_EXPONENTIAL) {
				result = Math.pow(distance / refDistance, -rolloffFactor);
			}
			return math.clamp(result, 0, 1);
		};
		Object.assign(Channel3d.prototype, {
			setPosition: function setPosition(position) {
				this.position.copy(position);
				if (this.source) {
					var listener = this.manager.listener;
					var lpos = listener.getPosition();
					var factor = fallOff$1(lpos, this.position, this.minDistance, this.maxDistance, this.rollOffFactor, this.distanceModel);
					var v = this.getVolume();
					this.source.volume = v * factor;
				}
			},
			getMaxDistance: function getMaxDistance() {
				return this.maxDistance;
			},
			setMaxDistance: function setMaxDistance(max) {
				this.maxDistance = max;
			},
			getMinDistance: function getMinDistance() {
				return this.minDistance;
			},
			setMinDistance: function setMinDistance(min) {
				this.minDistance = min;
			},
			getRollOffFactor: function getRollOffFactor() {
				return this.rollOffFactor;
			},
			setRollOffFactor: function setRollOffFactor(factor) {
				this.rollOffFactor = factor;
			},
			getDistanceModel: function getDistanceModel() {
				return this.distanceModel;
			},
			setDistanceModel: function setDistanceModel(distanceModel) {
				this.distanceModel = distanceModel;
			}
		});
	}

	var Listener = function () {
		function Listener(manager) {
			this._manager = manager;
			this.position = new Vec3();
			this.velocity = new Vec3();
			this.orientation = new Mat4();
		}
		var _proto = Listener.prototype;
		_proto.getPosition = function getPosition() {
			return this.position;
		};
		_proto.setPosition = function setPosition(position) {
			this.position.copy(position);
			var listener = this.listener;
			if (listener) {
				if ('positionX' in listener) {
					listener.positionX.value = position.x;
					listener.positionY.value = position.y;
					listener.positionZ.value = position.z;
				} else if (listener.setPosition) {
					listener.setPosition(position.x, position.y, position.z);
				}
			}
		};
		_proto.getVelocity = function getVelocity() {
			return this.velocity;
		};
		_proto.setVelocity = function setVelocity(velocity) {};
		_proto.setOrientation = function setOrientation(orientation) {
			this.orientation.copy(orientation);
			var listener = this.listener;
			if (listener) {
				var m = orientation.data;
				if ('forwardX' in listener) {
					listener.forwardX.value = -m[8];
					listener.forwardY.value = -m[9];
					listener.forwardZ.value = -m[10];
					listener.upX.value = m[4];
					listener.upY.value = m[5];
					listener.upZ.value = m[6];
				} else if (listener.setOrientation) {
					listener.setOrientation(-m[8], -m[9], -m[10], m[4], m[5], m[6]);
				}
			}
		};
		_proto.getOrientation = function getOrientation() {
			return this.orientation;
		};
		_createClass(Listener, [{
			key: "listener",
			get: function get() {
				var context = this._manager.context;
				return context ? context.listener : null;
			}
		}]);
		return Listener;
	}();

	var CONTEXT_STATE_RUNNING = 'running';
	var USER_INPUT_EVENTS = ['click', 'touchstart', 'mousedown'];
	var SoundManager = function (_EventHandler) {
		_inheritsLoose(SoundManager, _EventHandler);
		function SoundManager() {
			var _this;
			_this = _EventHandler.call(this) || this;
			_this._context = null;
			_this.AudioContext = typeof AudioContext !== 'undefined' && AudioContext || typeof webkitAudioContext !== 'undefined' && webkitAudioContext;
			if (!_this.AudioContext) ;
			_this._unlockHandlerFunc = _this._unlockHandler.bind(_assertThisInitialized(_this));
			_this._userSuspended = false;
			_this.listener = new Listener(_assertThisInitialized(_this));
			_this._volume = 1;
			return _this;
		}
		var _proto = SoundManager.prototype;
		_proto.suspend = function suspend() {
			if (!this._userSuspended) {
				this._userSuspended = true;
				if (this._context && this._context.state === CONTEXT_STATE_RUNNING) {
					this._suspend();
				}
			}
		};
		_proto.resume = function resume() {
			if (this._userSuspended) {
				this._userSuspended = false;
				if (this._context && this._context.state !== CONTEXT_STATE_RUNNING) {
					this._resume();
				}
			}
		};
		_proto.destroy = function destroy() {
			this.fire('destroy');
			if (this._context) {
				var _this$_context;
				this._removeUnlockListeners();
				(_this$_context = this._context) == null ? void 0 : _this$_context.close();
				this._context = null;
			}
		};
		_proto.playSound = function playSound(sound, options) {
			if (options === void 0) {
				options = {};
			}
			var channel = null;
			if (Channel) {
				channel = new Channel(this, sound, options);
				channel.play();
			}
			return channel;
		};
		_proto.playSound3d = function playSound3d(sound, position, options) {
			if (options === void 0) {
				options = {};
			}
			var channel = null;
			if (Channel3d) {
				channel = new Channel3d(this, sound, options);
				channel.setPosition(position);
				if (options.volume) {
					channel.setVolume(options.volume);
				}
				if (options.loop) {
					channel.setLoop(options.loop);
				}
				if (options.maxDistance) {
					channel.setMaxDistance(options.maxDistance);
				}
				if (options.minDistance) {
					channel.setMinDistance(options.minDistance);
				}
				if (options.rollOffFactor) {
					channel.setRollOffFactor(options.rollOffFactor);
				}
				if (options.distanceModel) {
					channel.setDistanceModel(options.distanceModel);
				}
				channel.play();
			}
			return channel;
		};
		_proto._resume = function _resume() {
			var _this2 = this;
			this._context.resume().then(function () {
				var source = _this2._context.createBufferSource();
				source.buffer = _this2._context.createBuffer(1, 1, _this2._context.sampleRate);
				source.connect(_this2._context.destination);
				source.start(0);
				source.onended = function (event) {
					source.disconnect(0);
					_this2.fire('resume');
				};
			}, function (e) {}).catch(function (e) {});
		};
		_proto._suspend = function _suspend() {
			var _this3 = this;
			this._context.suspend().then(function () {
				_this3.fire('suspend');
			}, function (e) {}).catch(function (e) {});
		};
		_proto._unlockHandler = function _unlockHandler() {
			this._removeUnlockListeners();
			if (!this._userSuspended && this._context.state !== CONTEXT_STATE_RUNNING) {
				this._resume();
			}
		};
		_proto._registerUnlockListeners = function _registerUnlockListeners() {
			var _this4 = this;
			USER_INPUT_EVENTS.forEach(function (eventName) {
				window.addEventListener(eventName, _this4._unlockHandlerFunc, false);
			});
		};
		_proto._removeUnlockListeners = function _removeUnlockListeners() {
			var _this5 = this;
			USER_INPUT_EVENTS.forEach(function (eventName) {
				window.removeEventListener(eventName, _this5._unlockHandlerFunc, false);
			});
		};
		_createClass(SoundManager, [{
			key: "volume",
			get: function get() {
				return this._volume;
			},
			set: function set(volume) {
				volume = math.clamp(volume, 0, 1);
				this._volume = volume;
				this.fire('volumechange', volume);
			}
		}, {
			key: "suspended",
			get: function get() {
				return this._userSuspended;
			}
		}, {
			key: "context",
			get: function get() {
				if (!this._context && this.AudioContext) {
					this._context = new this.AudioContext();
					if (this._context.state !== CONTEXT_STATE_RUNNING) {
						this._registerUnlockListeners();
					}
				}
				return this._context;
			}
		}]);
		return SoundManager;
	}(EventHandler);

	var Sound = function () {
		function Sound(resource) {
			this.audio = void 0;
			this.buffer = void 0;
			if (resource instanceof Audio) {
				this.audio = resource;
			} else {
				this.buffer = resource;
			}
		}
		_createClass(Sound, [{
			key: "duration",
			get: function get() {
				var duration = 0;
				if (this.buffer) {
					duration = this.buffer.duration;
				} else if (this.audio) {
					duration = this.audio.duration;
				}
				return duration || 0;
			}
		}]);
		return Sound;
	}();

	var STATE_PLAYING = 0;
	var STATE_PAUSED = 1;
	var STATE_STOPPED = 2;
	function capTime(time, duration) {
		return time % duration || 0;
	}
	var SoundInstance = function (_EventHandler) {
		_inheritsLoose(SoundInstance, _EventHandler);
		function SoundInstance(manager, sound, options) {
			var _this;
			_this = _EventHandler.call(this) || this;
			_this.source = null;
			_this._manager = manager;
			_this._volume = options.volume !== undefined ? math.clamp(Number(options.volume) || 0, 0, 1) : 1;
			_this._pitch = options.pitch !== undefined ? Math.max(0.01, Number(options.pitch) || 0) : 1;
			_this._loop = !!(options.loop !== undefined ? options.loop : false);
			_this._sound = sound;
			_this._state = STATE_STOPPED;
			_this._suspended = false;
			_this._suspendEndEvent = 0;
			_this._suspendInstanceEvents = false;
			_this._playWhenLoaded = true;
			_this._startTime = Math.max(0, Number(options.startTime) || 0);
			_this._duration = Math.max(0, Number(options.duration) || 0);
			_this._startOffset = null;
			_this._onPlayCallback = options.onPlay;
			_this._onPauseCallback = options.onPause;
			_this._onResumeCallback = options.onResume;
			_this._onStopCallback = options.onStop;
			_this._onEndCallback = options.onEnd;
			if (hasAudioContext()) {
				_this._startedAt = 0;
				_this._currentTime = 0;
				_this._currentOffset = 0;
				_this._inputNode = null;
				_this._connectorNode = null;
				_this._firstNode = null;
				_this._lastNode = null;
				_this._waitingContextSuspension = false;
				_this._initializeNodes();
				_this._endedHandler = _this._onEnded.bind(_assertThisInitialized(_this));
			} else {
				_this._isReady = false;
				_this._loadedMetadataHandler = _this._onLoadedMetadata.bind(_assertThisInitialized(_this));
				_this._timeUpdateHandler = _this._onTimeUpdate.bind(_assertThisInitialized(_this));
				_this._endedHandler = _this._onEnded.bind(_assertThisInitialized(_this));
				_this._createSource();
			}
			return _this;
		}
		var _proto = SoundInstance.prototype;
		_proto._onPlay = function _onPlay() {
			this.fire('play');
			if (this._onPlayCallback) this._onPlayCallback(this);
		};
		_proto._onPause = function _onPause() {
			this.fire('pause');
			if (this._onPauseCallback) this._onPauseCallback(this);
		};
		_proto._onResume = function _onResume() {
			this.fire('resume');
			if (this._onResumeCallback) this._onResumeCallback(this);
		};
		_proto._onStop = function _onStop() {
			this.fire('stop');
			if (this._onStopCallback) this._onStopCallback(this);
		};
		_proto._onEnded = function _onEnded() {
			if (this._suspendEndEvent > 0) {
				this._suspendEndEvent--;
				return;
			}
			this.fire('end');
			if (this._onEndCallback) this._onEndCallback(this);
			this.stop();
		};
		_proto._onManagerVolumeChange = function _onManagerVolumeChange() {
			this.volume = this._volume;
		};
		_proto._onManagerSuspend = function _onManagerSuspend() {
			if (this._state === STATE_PLAYING && !this._suspended) {
				this._suspended = true;
				this.pause();
			}
		};
		_proto._onManagerResume = function _onManagerResume() {
			if (this._suspended) {
				this._suspended = false;
				this.resume();
			}
		};
		_proto._initializeNodes = function _initializeNodes() {
			this.gain = this._manager.context.createGain();
			this._inputNode = this.gain;
			this._connectorNode = this.gain;
			this._connectorNode.connect(this._manager.context.destination);
		};
		_proto.play = function play() {
			if (this._state !== STATE_STOPPED) {
				this.stop();
			}
			this._state = STATE_PLAYING;
			this._playWhenLoaded = false;
			if (this._waitingContextSuspension) {
				return false;
			}
			if (this._manager.suspended) {
				this._manager.once('resume', this._playAudioImmediate, this);
				this._waitingContextSuspension = true;
				return false;
			}
			this._playAudioImmediate();
			return true;
		};
		_proto._playAudioImmediate = function _playAudioImmediate() {
			this._waitingContextSuspension = false;
			if (this._state !== STATE_PLAYING) {
				return;
			}
			if (!this.source) {
				this._createSource();
			}
			var offset = capTime(this._startOffset, this.duration);
			offset = capTime(this._startTime + offset, this._sound.duration);
			this._startOffset = null;
			if (this._duration) {
				this.source.start(0, offset, this._duration);
			} else {
				this.source.start(0, offset);
			}
			this._startedAt = this._manager.context.currentTime;
			this._currentTime = 0;
			this._currentOffset = offset;
			this.volume = this._volume;
			this.loop = this._loop;
			this.pitch = this._pitch;
			this._manager.on('volumechange', this._onManagerVolumeChange, this);
			this._manager.on('suspend', this._onManagerSuspend, this);
			this._manager.on('resume', this._onManagerResume, this);
			this._manager.on('destroy', this._onManagerDestroy, this);
			if (!this._suspendInstanceEvents) {
				this._onPlay();
			}
		};
		_proto.pause = function pause() {
			this._playWhenLoaded = false;
			if (this._state !== STATE_PLAYING) return false;
			this._state = STATE_PAUSED;
			if (this._waitingContextSuspension) {
				return true;
			}
			this._updateCurrentTime();
			this._suspendEndEvent++;
			this.source.stop(0);
			this.source = null;
			this._startOffset = null;
			if (!this._suspendInstanceEvents) this._onPause();
			return true;
		};
		_proto.resume = function resume() {
			if (this._state !== STATE_PAUSED) {
				return false;
			}
			var offset = this.currentTime;
			this._state = STATE_PLAYING;
			if (this._waitingContextSuspension) {
				return true;
			}
			if (!this.source) {
				this._createSource();
			}
			if (this._startOffset !== null) {
				offset = capTime(this._startOffset, this.duration);
				offset = capTime(this._startTime + offset, this._sound.duration);
				this._startOffset = null;
			}
			if (this._duration) {
				this.source.start(0, offset, this._duration);
			} else {
				this.source.start(0, offset);
			}
			this._startedAt = this._manager.context.currentTime;
			this._currentOffset = offset;
			this.volume = this._volume;
			this.loop = this._loop;
			this.pitch = this._pitch;
			this._playWhenLoaded = false;
			if (!this._suspendInstanceEvents) this._onResume();
			return true;
		};
		_proto.stop = function stop() {
			this._playWhenLoaded = false;
			if (this._state === STATE_STOPPED) return false;
			var wasPlaying = this._state === STATE_PLAYING;
			this._state = STATE_STOPPED;
			if (this._waitingContextSuspension) {
				return true;
			}
			this._manager.off('volumechange', this._onManagerVolumeChange, this);
			this._manager.off('suspend', this._onManagerSuspend, this);
			this._manager.off('resume', this._onManagerResume, this);
			this._manager.off('destroy', this._onManagerDestroy, this);
			this._startedAt = 0;
			this._currentTime = 0;
			this._currentOffset = 0;
			this._startOffset = null;
			this._suspendEndEvent++;
			if (wasPlaying && this.source) {
				this.source.stop(0);
			}
			this.source = null;
			if (!this._suspendInstanceEvents) this._onStop();
			return true;
		};
		_proto.setExternalNodes = function setExternalNodes(firstNode, lastNode) {
			if (!firstNode) {
				console.error('The firstNode must be a valid Audio Node');
				return;
			}
			if (!lastNode) {
				lastNode = firstNode;
			}
			var speakers = this._manager.context.destination;
			if (this._firstNode !== firstNode) {
				if (this._firstNode) {
					this._connectorNode.disconnect(this._firstNode);
				} else {
					this._connectorNode.disconnect(speakers);
				}
				this._firstNode = firstNode;
				this._connectorNode.connect(firstNode);
			}
			if (this._lastNode !== lastNode) {
				if (this._lastNode) {
					this._lastNode.disconnect(speakers);
				}
				this._lastNode = lastNode;
				this._lastNode.connect(speakers);
			}
		};
		_proto.clearExternalNodes = function clearExternalNodes() {
			var speakers = this._manager.context.destination;
			if (this._firstNode) {
				this._connectorNode.disconnect(this._firstNode);
				this._firstNode = null;
			}
			if (this._lastNode) {
				this._lastNode.disconnect(speakers);
				this._lastNode = null;
			}
			this._connectorNode.connect(speakers);
		};
		_proto.getExternalNodes = function getExternalNodes() {
			return [this._firstNode, this._lastNode];
		};
		_proto._createSource = function _createSource() {
			if (!this._sound) {
				return null;
			}
			var context = this._manager.context;
			if (this._sound.buffer) {
				this.source = context.createBufferSource();
				this.source.buffer = this._sound.buffer;
				this.source.connect(this._inputNode);
				this.source.onended = this._endedHandler;
				this.source.loopStart = capTime(this._startTime, this.source.buffer.duration);
				if (this._duration) {
					this.source.loopEnd = Math.max(this.source.loopStart, capTime(this._startTime + this._duration, this.source.buffer.duration));
				}
			}
			return this.source;
		};
		_proto._updateCurrentTime = function _updateCurrentTime() {
			this._currentTime = capTime((this._manager.context.currentTime - this._startedAt) * this._pitch + this._currentOffset, this.duration);
		};
		_proto._onManagerDestroy = function _onManagerDestroy() {
			if (this.source && this._state === STATE_PLAYING) {
				this.source.stop(0);
				this.source = null;
			}
		};
		_createClass(SoundInstance, [{
			key: "currentTime",
			get: function get() {
				if (this._startOffset !== null) {
					return this._startOffset;
				}
				if (this._state === STATE_PAUSED) {
					return this._currentTime;
				}
				if (this._state === STATE_STOPPED || !this.source) {
					return 0;
				}
				this._updateCurrentTime();
				return this._currentTime;
			},
			set: function set(value) {
				if (value < 0) return;
				if (this._state === STATE_PLAYING) {
					var suspend = this._suspendInstanceEvents;
					this._suspendInstanceEvents = true;
					this.stop();
					this._startOffset = value;
					this.play();
					this._suspendInstanceEvents = suspend;
				} else {
					this._startOffset = value;
					this._currentTime = value;
				}
			}
		}, {
			key: "duration",
			get: function get() {
				if (!this._sound) {
					return 0;
				}
				if (this._duration) {
					return capTime(this._duration, this._sound.duration);
				}
				return this._sound.duration;
			},
			set: function set(value) {
				this._duration = Math.max(0, Number(value) || 0);
				var isPlaying = this._state === STATE_PLAYING;
				this.stop();
				if (isPlaying) {
					this.play();
				}
			}
		}, {
			key: "isPaused",
			get: function get() {
				return this._state === STATE_PAUSED;
			}
		}, {
			key: "isPlaying",
			get: function get() {
				return this._state === STATE_PLAYING;
			}
		}, {
			key: "isStopped",
			get: function get() {
				return this._state === STATE_STOPPED;
			}
		}, {
			key: "isSuspended",
			get: function get() {
				return this._suspended;
			}
		}, {
			key: "loop",
			get: function get() {
				return this._loop;
			},
			set: function set(value) {
				this._loop = !!value;
				if (this.source) {
					this.source.loop = this._loop;
				}
			}
		}, {
			key: "pitch",
			get: function get() {
				return this._pitch;
			},
			set: function set(pitch) {
				this._currentOffset = this.currentTime;
				this._startedAt = this._manager.context.currentTime;
				this._pitch = Math.max(Number(pitch) || 0, 0.01);
				if (this.source) {
					this.source.playbackRate.value = this._pitch;
				}
			}
		}, {
			key: "sound",
			get: function get() {
				return this._sound;
			},
			set: function set(value) {
				this._sound = value;
				if (this._state !== STATE_STOPPED) {
					this.stop();
				} else {
					this._createSource();
				}
			}
		}, {
			key: "startTime",
			get: function get() {
				return this._startTime;
			},
			set: function set(value) {
				this._startTime = Math.max(0, Number(value) || 0);
				var isPlaying = this._state === STATE_PLAYING;
				this.stop();
				if (isPlaying) {
					this.play();
				}
			}
		}, {
			key: "volume",
			get: function get() {
				return this._volume;
			},
			set: function set(volume) {
				volume = math.clamp(volume, 0, 1);
				this._volume = volume;
				if (this.gain) {
					this.gain.gain.value = volume * this._manager.volume;
				}
			}
		}]);
		return SoundInstance;
	}(EventHandler);
	if (!hasAudioContext()) {
		Object.assign(SoundInstance.prototype, {
			play: function play() {
				if (this._state !== STATE_STOPPED) {
					this.stop();
				}
				if (!this.source) {
					if (!this._createSource()) {
						return false;
					}
				}
				this.volume = this._volume;
				this.pitch = this._pitch;
				this.loop = this._loop;
				this.source.play();
				this._state = STATE_PLAYING;
				this._playWhenLoaded = false;
				this._manager.on('volumechange', this._onManagerVolumeChange, this);
				this._manager.on('suspend', this._onManagerSuspend, this);
				this._manager.on('resume', this._onManagerResume, this);
				this._manager.on('destroy', this._onManagerDestroy, this);
				if (this._manager.suspended) this._onManagerSuspend();
				if (!this._suspendInstanceEvents) this._onPlay();
				return true;
			},
			pause: function pause() {
				if (!this.source || this._state !== STATE_PLAYING) return false;
				this._suspendEndEvent++;
				this.source.pause();
				this._playWhenLoaded = false;
				this._state = STATE_PAUSED;
				this._startOffset = null;
				if (!this._suspendInstanceEvents) this._onPause();
				return true;
			},
			resume: function resume() {
				if (!this.source || this._state !== STATE_PAUSED) return false;
				this._state = STATE_PLAYING;
				this._playWhenLoaded = false;
				if (this.source.paused) {
					this.source.play();
					if (!this._suspendInstanceEvents) this._onResume();
				}
				return true;
			},
			stop: function stop() {
				if (!this.source || this._state === STATE_STOPPED) return false;
				this._manager.off('volumechange', this._onManagerVolumeChange, this);
				this._manager.off('suspend', this._onManagerSuspend, this);
				this._manager.off('resume', this._onManagerResume, this);
				this._manager.off('destroy', this._onManagerDestroy, this);
				this._suspendEndEvent++;
				this.source.pause();
				this._playWhenLoaded = false;
				this._state = STATE_STOPPED;
				this._startOffset = null;
				if (!this._suspendInstanceEvents) this._onStop();
				return true;
			},
			setExternalNodes: function setExternalNodes() {},
			clearExternalNodes: function clearExternalNodes() {},
			getExternalNodes: function getExternalNodes() {
				return [null, null];
			},
			_onLoadedMetadata: function _onLoadedMetadata() {
				this.source.removeEventListener('loadedmetadata', this._loadedMetadataHandler);
				this._isReady = true;
				var offset = capTime(this._startOffset, this.duration);
				offset = capTime(this._startTime + offset, this._sound.duration);
				this._startOffset = null;
				this.source.currentTime = offset;
			},
			_createSource: function _createSource() {
				if (this._sound && this._sound.audio) {
					this._isReady = false;
					this.source = this._sound.audio.cloneNode(true);
					this.source.addEventListener('loadedmetadata', this._loadedMetadataHandler);
					this.source.addEventListener('timeupdate', this._timeUpdateHandler);
					this.source.onended = this._endedHandler;
				}
				return this.source;
			},
			_onTimeUpdate: function _onTimeUpdate() {
				if (!this._duration) return;
				if (this.source.currentTime > capTime(this._startTime + this._duration, this.source.duration)) {
					if (this.loop) {
						this.source.currentTime = capTime(this._startTime, this.source.duration);
					} else {
						this.source.removeEventListener('timeupdate', this._timeUpdateHandler);
						this.source.pause();
						this._onEnded();
					}
				}
			},
			_onManagerDestroy: function _onManagerDestroy() {
				if (this.source) {
					this.source.pause();
				}
			}
		});
		Object.defineProperty(SoundInstance.prototype, 'volume', {
			get: function get() {
				return this._volume;
			},
			set: function set(volume) {
				volume = math.clamp(volume, 0, 1);
				this._volume = volume;
				if (this.source) {
					this.source.volume = volume * this._manager.volume;
				}
			}
		});
		Object.defineProperty(SoundInstance.prototype, 'pitch', {
			get: function get() {
				return this._pitch;
			},
			set: function set(pitch) {
				this._pitch = Math.max(Number(pitch) || 0, 0.01);
				if (this.source) {
					this.source.playbackRate = this._pitch;
				}
			}
		});
		Object.defineProperty(SoundInstance.prototype, 'sound', {
			get: function get() {
				return this._sound;
			},
			set: function set(value) {
				this.stop();
				this._sound = value;
			}
		});
		Object.defineProperty(SoundInstance.prototype, 'currentTime', {
			get: function get() {
				if (this._startOffset !== null) {
					return this._startOffset;
				}
				if (this._state === STATE_STOPPED || !this.source) {
					return 0;
				}
				return this.source.currentTime - this._startTime;
			},
			set: function set(value) {
				if (value < 0) return;
				this._startOffset = value;
				if (this.source && this._isReady) {
					this.source.currentTime = capTime(this._startTime + capTime(value, this.duration), this._sound.duration);
					this._startOffset = null;
				}
			}
		});
	}

	var MAX_DISTANCE = 10000;
	var SoundInstance3d = function (_SoundInstance) {
		_inheritsLoose(SoundInstance3d, _SoundInstance);
		function SoundInstance3d(manager, sound, options) {
			var _this;
			if (options === void 0) {
				options = {};
			}
			_this = _SoundInstance.call(this, manager, sound, options) || this;
			_this._position = new Vec3();
			_this._velocity = new Vec3();
			if (options.position) _this.position = options.position;
			_this.maxDistance = options.maxDistance !== undefined ? Number(options.maxDistance) : MAX_DISTANCE;
			_this.refDistance = options.refDistance !== undefined ? Number(options.refDistance) : 1;
			_this.rollOffFactor = options.rollOffFactor !== undefined ? Number(options.rollOffFactor) : 1;
			_this.distanceModel = options.distanceModel !== undefined ? options.distanceModel : DISTANCE_LINEAR;
			return _this;
		}
		var _proto = SoundInstance3d.prototype;
		_proto._initializeNodes = function _initializeNodes() {
			this.gain = this._manager.context.createGain();
			this.panner = this._manager.context.createPanner();
			this.panner.connect(this.gain);
			this._inputNode = this.panner;
			this._connectorNode = this.gain;
			this._connectorNode.connect(this._manager.context.destination);
		};
		_createClass(SoundInstance3d, [{
			key: "position",
			get: function get() {
				return this._position;
			},
			set: function set(value) {
				this._position.copy(value);
				var panner = this.panner;
				if ('positionX' in panner) {
					panner.positionX.value = value.x;
					panner.positionY.value = value.y;
					panner.positionZ.value = value.z;
				} else if (panner.setPosition) {
					panner.setPosition(value.x, value.y, value.z);
				}
			}
		}, {
			key: "velocity",
			get: function get() {
				return this._velocity;
			},
			set: function set(velocity) {
				this._velocity.copy(velocity);
			}
		}, {
			key: "maxDistance",
			get: function get() {
				return this.panner.maxDistance;
			},
			set: function set(value) {
				this.panner.maxDistance = value;
			}
		}, {
			key: "refDistance",
			get: function get() {
				return this.panner.refDistance;
			},
			set: function set(value) {
				this.panner.refDistance = value;
			}
		}, {
			key: "rollOffFactor",
			get: function get() {
				return this.panner.rolloffFactor;
			},
			set: function set(value) {
				this.panner.rolloffFactor = value;
			}
		}, {
			key: "distanceModel",
			get: function get() {
				return this.panner.distanceModel;
			},
			set: function set(value) {
				this.panner.distanceModel = value;
			}
		}]);
		return SoundInstance3d;
	}(SoundInstance);
	if (!hasAudioContext()) {
		var offset = new Vec3();
		var fallOff = function fallOff(posOne, posTwo, refDistance, maxDistance, rollOffFactor, distanceModel) {
			offset = offset.sub2(posOne, posTwo);
			var distance = offset.length();
			if (distance < refDistance) {
				return 1;
			} else if (distance > maxDistance) {
				return 0;
			}
			var result = 0;
			if (distanceModel === DISTANCE_LINEAR) {
				result = 1 - rollOffFactor * (distance - refDistance) / (maxDistance - refDistance);
			} else if (distanceModel === DISTANCE_INVERSE) {
				result = refDistance / (refDistance + rollOffFactor * (distance - refDistance));
			} else if (distanceModel === DISTANCE_EXPONENTIAL) {
				result = Math.pow(distance / refDistance, -rollOffFactor);
			}
			return math.clamp(result, 0, 1);
		};
		Object.defineProperty(SoundInstance3d.prototype, 'position', {
			get: function get() {
				return this._position;
			},
			set: function set(position) {
				this._position.copy(position);
				if (this.source) {
					var listener = this._manager.listener;
					var lpos = listener.getPosition();
					var factor = fallOff(lpos, this._position, this.refDistance, this.maxDistance, this.rollOffFactor, this.distanceModel);
					var v = this.volume;
					this.source.volume = v * factor * this._manager.volume;
				}
			}
		});
		Object.defineProperty(SoundInstance3d.prototype, 'maxDistance', {
			get: function get() {
				return this._maxDistance;
			},
			set: function set(value) {
				this._maxDistance = value;
			}
		});
		Object.defineProperty(SoundInstance3d.prototype, 'refDistance', {
			get: function get() {
				return this._refDistance;
			},
			set: function set(value) {
				this._refDistance = value;
			}
		});
		Object.defineProperty(SoundInstance3d.prototype, 'rollOffFactor', {
			get: function get() {
				return this._rollOffFactor;
			},
			set: function set(value) {
				this._rollOffFactor = value;
			}
		});
		Object.defineProperty(SoundInstance3d.prototype, 'distanceModel', {
			get: function get() {
				return this._distanceModel;
			},
			set: function set(value) {
				this._distanceModel = value;
			}
		});
	}

	var BLEND_SUBTRACTIVE = 0;
	var BLEND_ADDITIVE = 1;
	var BLEND_NORMAL = 2;
	var BLEND_NONE = 3;
	var BLEND_PREMULTIPLIED = 4;
	var BLEND_MULTIPLICATIVE = 5;
	var BLEND_ADDITIVEALPHA = 6;
	var BLEND_MULTIPLICATIVE2X = 7;
	var BLEND_SCREEN = 8;
	var BLEND_MIN = 9;
	var BLEND_MAX = 10;
	var FOG_NONE = 'none';
	var FOG_LINEAR = 'linear';
	var FOG_EXP = 'exp';
	var FOG_EXP2 = 'exp2';
	var FRESNEL_NONE = 0;
	var FRESNEL_SCHLICK = 2;
	var LAYER_HUD = 0;
	var LAYER_GIZMO = 1;
	var LAYER_FX = 2;
	var LAYER_WORLD = 15;
	var LAYERID_WORLD = 0;
	var LAYERID_DEPTH = 1;
	var LAYERID_SKYBOX = 2;
	var LAYERID_IMMEDIATE = 3;
	var LAYERID_UI = 4;
	var LIGHTTYPE_DIRECTIONAL = 0;
	var LIGHTTYPE_OMNI = 1;
	var LIGHTTYPE_POINT = LIGHTTYPE_OMNI;
	var LIGHTTYPE_SPOT = 2;
	var LIGHTTYPE_COUNT = 3;
	var LIGHTSHAPE_PUNCTUAL = 0;
	var LIGHTSHAPE_RECT = 1;
	var LIGHTSHAPE_DISK = 2;
	var LIGHTSHAPE_SPHERE = 3;
	var LIGHTFALLOFF_LINEAR = 0;
	var LIGHTFALLOFF_INVERSESQUARED = 1;
	var SHADOW_PCF3 = 0;
	var SHADOW_DEPTH = 0;
	var SHADOW_VSM8 = 1;
	var SHADOW_VSM16 = 2;
	var SHADOW_VSM32 = 3;
	var SHADOW_PCF5 = 4;
	var SHADOW_PCF1 = 5;
	var SHADOW_PCSS = 6;
	var shadowTypeToString = {};
	shadowTypeToString[SHADOW_PCF3] = 'PCF3';
	shadowTypeToString[SHADOW_VSM8] = 'VSM8';
	shadowTypeToString[SHADOW_VSM16] = 'VSM16';
	shadowTypeToString[SHADOW_VSM32] = 'VSM32';
	shadowTypeToString[SHADOW_PCF5] = 'PCF5';
	shadowTypeToString[SHADOW_PCF1] = 'PCF1';
	shadowTypeToString[SHADOW_PCSS] = 'PCSS';
	var BLUR_BOX = 0;
	var BLUR_GAUSSIAN = 1;
	var PARTICLESORT_NONE = 0;
	var PARTICLESORT_DISTANCE = 1;
	var PARTICLESORT_NEWER_FIRST = 2;
	var PARTICLESORT_OLDER_FIRST = 3;
	var PARTICLEMODE_GPU = 0;
	var PARTICLEMODE_CPU = 1;
	var EMITTERSHAPE_BOX = 0;
	var EMITTERSHAPE_SPHERE = 1;
	var PARTICLEORIENTATION_SCREEN = 0;
	var PARTICLEORIENTATION_WORLD = 1;
	var PARTICLEORIENTATION_EMITTER = 2;
	var PROJECTION_PERSPECTIVE = 0;
	var PROJECTION_ORTHOGRAPHIC = 1;
	var RENDERSTYLE_SOLID = 0;
	var RENDERSTYLE_WIREFRAME = 1;
	var RENDERSTYLE_POINTS = 2;
	var CUBEPROJ_NONE = 0;
	var CUBEPROJ_BOX = 1;
	var SPECULAR_PHONG = 0;
	var SPECULAR_BLINN = 1;
	var DETAILMODE_MUL = 'mul';
	var DETAILMODE_ADD = 'add';
	var DETAILMODE_SCREEN = 'screen';
	var DETAILMODE_OVERLAY = 'overlay';
	var DETAILMODE_MIN = 'min';
	var DETAILMODE_MAX = 'max';
	var GAMMA_NONE = 0;
	var GAMMA_SRGB = 1;
	var GAMMA_SRGBFAST = 2;
	var GAMMA_SRGBHDR = 3;
	var TONEMAP_LINEAR = 0;
	var TONEMAP_FILMIC = 1;
	var TONEMAP_HEJL = 2;
	var TONEMAP_ACES = 3;
	var TONEMAP_ACES2 = 4;
	var SPECOCC_NONE = 0;
	var SPECOCC_AO = 1;
	var SPECOCC_GLOSSDEPENDENT = 2;
	var SHADERDEF_NOSHADOW = 1;
	var SHADERDEF_SKIN = 2;
	var SHADERDEF_UV0 = 4;
	var SHADERDEF_UV1 = 8;
	var SHADERDEF_VCOLOR = 16;
	var SHADERDEF_INSTANCING = 32;
	var SHADERDEF_LM = 64;
	var SHADERDEF_DIRLM = 128;
	var SHADERDEF_SCREENSPACE = 256;
	var SHADERDEF_TANGENTS = 512;
	var SHADERDEF_MORPH_POSITION = 1024;
	var SHADERDEF_MORPH_NORMAL = 2048;
	var SHADERDEF_MORPH_TEXTURE_BASED = 4096;
	var SHADERDEF_LMAMBIENT = 8192;
	var LINEBATCH_WORLD = 0;
	var LINEBATCH_OVERLAY = 1;
	var LINEBATCH_GIZMO = 2;
	var SHADOWUPDATE_NONE = 0;
	var SHADOWUPDATE_THISFRAME = 1;
	var SHADOWUPDATE_REALTIME = 2;
	var SORTKEY_FORWARD = 0;
	var SORTKEY_DEPTH = 1;
	var MASK_AFFECT_DYNAMIC = 1;
	var MASK_AFFECT_LIGHTMAPPED = 2;
	var MASK_BAKE = 4;
	var SHADER_FORWARD = 0;
	var SHADER_FORWARDHDR = 1;
	var SHADER_DEPTH = 2;
	var SHADER_PICK = 3;
	var SHADER_SHADOW = 4;
	var SHADERPASS_FORWARD = 'forward';
	var SHADERPASS_ALBEDO = 'debug_albedo';
	var SHADERPASS_WORLDNORMAL = 'debug_world_normal';
	var SHADERPASS_OPACITY = 'debug_opacity';
	var SHADERPASS_SPECULARITY = 'debug_specularity';
	var SHADERPASS_GLOSS = 'debug_gloss';
	var SHADERPASS_METALNESS = 'debug_metalness';
	var SHADERPASS_AO = 'debug_ao';
	var SHADERPASS_EMISSION = 'debug_emission';
	var SHADERPASS_LIGHTING = 'debug_lighting';
	var SHADERPASS_UV0 = 'debug_uv0';
	var SPRITE_RENDERMODE_SIMPLE = 0;
	var SPRITE_RENDERMODE_SLICED = 1;
	var SPRITE_RENDERMODE_TILED = 2;
	var BAKE_COLOR = 0;
	var BAKE_COLORDIR = 1;
	var VIEW_CENTER = 0;
	var VIEW_LEFT = 1;
	var VIEW_RIGHT = 2;
	var SORTMODE_NONE = 0;
	var SORTMODE_MANUAL = 1;
	var SORTMODE_MATERIALMESH = 2;
	var SORTMODE_BACK2FRONT = 3;
	var SORTMODE_FRONT2BACK = 4;
	var SORTMODE_CUSTOM = 5;
	var COMPUPDATED_INSTANCES = 1;
	var COMPUPDATED_LIGHTS = 2;
	var COMPUPDATED_CAMERAS = 4;
	var COMPUPDATED_BLEND = 8;
	var ASPECT_AUTO = 0;
	var ASPECT_MANUAL = 1;
	var ORIENTATION_HORIZONTAL = 0;
	var ORIENTATION_VERTICAL = 1;

	var RefCountedObject = function () {
		function RefCountedObject() {
			this._refCount = 0;
		}
		var _proto = RefCountedObject.prototype;
		_proto.incRefCount = function incRefCount() {
			this._refCount++;
		};
		_proto.decRefCount = function decRefCount() {
			this._refCount--;
		};
		_createClass(RefCountedObject, [{
			key: "refCount",
			get: function get() {
				return this._refCount;
			}
		}]);
		return RefCountedObject;
	}();

	var GraphicsDeviceAccess = function () {
		function GraphicsDeviceAccess() {}
		GraphicsDeviceAccess.set = function set(graphicsDevice) {
			GraphicsDeviceAccess._graphicsDevice = graphicsDevice;
		};
		GraphicsDeviceAccess.get = function get() {
			return GraphicsDeviceAccess._graphicsDevice;
		};
		return GraphicsDeviceAccess;
	}();
	GraphicsDeviceAccess._graphicsDevice = null;

	var id$2 = 0;
	var GeometryData = function () {
		function GeometryData() {
			this.initDefaults();
		}
		var _proto = GeometryData.prototype;
		_proto.initDefaults = function initDefaults() {
			this.recreate = false;
			this.verticesUsage = BUFFER_STATIC;
			this.indicesUsage = BUFFER_STATIC;
			this.maxVertices = 0;
			this.maxIndices = 0;
			this.vertexCount = 0;
			this.indexCount = 0;
			this.vertexStreamsUpdated = false;
			this.indexStreamUpdated = false;
			this.vertexStreamDictionary = {};
			this.indices = null;
		};
		_proto._changeVertexCount = function _changeVertexCount(count, semantic) {
			if (!this.vertexCount) {
				this.vertexCount = count;
			}
		};
		return GeometryData;
	}();
	GeometryData.DEFAULT_COMPONENTS_POSITION = 3;
	GeometryData.DEFAULT_COMPONENTS_NORMAL = 3;
	GeometryData.DEFAULT_COMPONENTS_UV = 2;
	GeometryData.DEFAULT_COMPONENTS_COLORS = 4;
	var GeometryVertexStream = function GeometryVertexStream(data, componentCount, dataType, dataTypeNormalize) {
		this.data = data;
		this.componentCount = componentCount;
		this.dataType = dataType;
		this.dataTypeNormalize = dataTypeNormalize;
	};
	var Mesh = function (_RefCountedObject) {
		_inheritsLoose(Mesh, _RefCountedObject);
		function Mesh(graphicsDevice) {
			var _this;
			_this = _RefCountedObject.call(this) || this;
			_this.id = id$2++;
			_this.device = graphicsDevice || GraphicsDeviceAccess.get();
			_this.vertexBuffer = null;
			_this.indexBuffer = [null];
			_this.primitive = [{
				type: 0,
				base: 0,
				count: 0
			}];
			_this.skin = null;
			_this._morph = null;
			_this._geometryData = null;
			_this._aabb = new BoundingBox();
			_this.boneAabb = null;
			return _this;
		}
		var _proto2 = Mesh.prototype;
		_proto2.destroy = function destroy() {
			var morph = this.morph;
			if (morph) {
				this.morph = null;
				if (morph.refCount < 1) {
					morph.destroy();
				}
			}
			if (this.vertexBuffer) {
				this.vertexBuffer.destroy();
				this.vertexBuffer = null;
			}
			for (var j = 0; j < this.indexBuffer.length; j++) {
				this._destroyIndexBuffer(j);
			}
			this.indexBuffer.length = 0;
			this._geometryData = null;
		};
		_proto2._destroyIndexBuffer = function _destroyIndexBuffer(index) {
			if (this.indexBuffer[index]) {
				this.indexBuffer[index].destroy();
				this.indexBuffer[index] = null;
			}
		};
		_proto2._initBoneAabbs = function _initBoneAabbs(morphTargets) {
			this.boneAabb = [];
			this.boneUsed = [];
			var x, y, z;
			var bMax, bMin;
			var boneMin = [];
			var boneMax = [];
			var boneUsed = this.boneUsed;
			var numBones = this.skin.boneNames.length;
			var maxMorphX, maxMorphY, maxMorphZ;
			for (var i = 0; i < numBones; i++) {
				boneMin[i] = new Vec3(Number.MAX_VALUE, Number.MAX_VALUE, Number.MAX_VALUE);
				boneMax[i] = new Vec3(-Number.MAX_VALUE, -Number.MAX_VALUE, -Number.MAX_VALUE);
			}
			var iterator = new VertexIterator(this.vertexBuffer);
			var posElement = iterator.element[SEMANTIC_POSITION];
			var weightsElement = iterator.element[SEMANTIC_BLENDWEIGHT];
			var indicesElement = iterator.element[SEMANTIC_BLENDINDICES];
			var numVerts = this.vertexBuffer.numVertices;
			for (var j = 0; j < numVerts; j++) {
				for (var k = 0; k < 4; k++) {
					var boneWeight = weightsElement.array[weightsElement.index + k];
					if (boneWeight > 0) {
						var boneIndex = indicesElement.array[indicesElement.index + k];
						boneUsed[boneIndex] = true;
						x = posElement.array[posElement.index];
						y = posElement.array[posElement.index + 1];
						z = posElement.array[posElement.index + 2];
						bMax = boneMax[boneIndex];
						bMin = boneMin[boneIndex];
						if (bMin.x > x) bMin.x = x;
						if (bMin.y > y) bMin.y = y;
						if (bMin.z > z) bMin.z = z;
						if (bMax.x < x) bMax.x = x;
						if (bMax.y < y) bMax.y = y;
						if (bMax.z < z) bMax.z = z;
						if (morphTargets) {
							var minMorphX = maxMorphX = x;
							var minMorphY = maxMorphY = y;
							var minMorphZ = maxMorphZ = z;
							for (var l = 0; l < morphTargets.length; l++) {
								var target = morphTargets[l];
								var dx = target.deltaPositions[j * 3];
								var dy = target.deltaPositions[j * 3 + 1];
								var dz = target.deltaPositions[j * 3 + 2];
								if (dx < 0) {
									minMorphX += dx;
								} else {
									maxMorphX += dx;
								}
								if (dy < 0) {
									minMorphY += dy;
								} else {
									maxMorphY += dy;
								}
								if (dz < 0) {
									minMorphZ += dz;
								} else {
									maxMorphZ += dz;
								}
							}
							if (bMin.x > minMorphX) bMin.x = minMorphX;
							if (bMin.y > minMorphY) bMin.y = minMorphY;
							if (bMin.z > minMorphZ) bMin.z = minMorphZ;
							if (bMax.x < maxMorphX) bMax.x = maxMorphX;
							if (bMax.y < maxMorphY) bMax.y = maxMorphY;
							if (bMax.z < maxMorphZ) bMax.z = maxMorphZ;
						}
					}
				}
				iterator.next();
			}
			var positionElement = this.vertexBuffer.getFormat().elements.find(function (e) {
				return e.name === SEMANTIC_POSITION;
			});
			if (positionElement && positionElement.normalize) {
				var func = function () {
					switch (positionElement.dataType) {
						case TYPE_INT8:
							return function (x) {
								return Math.max(x / 127.0, -1.0);
							};
						case TYPE_UINT8:
							return function (x) {
								return x / 255.0;
							};
						case TYPE_INT16:
							return function (x) {
								return Math.max(x / 32767.0, -1.0);
							};
						case TYPE_UINT16:
							return function (x) {
								return x / 65535.0;
							};
						default:
							return function (x) {
								return x;
							};
					}
				}();
				for (var _i = 0; _i < numBones; _i++) {
					if (boneUsed[_i]) {
						var min = boneMin[_i];
						var max = boneMax[_i];
						min.set(func(min.x), func(min.y), func(min.z));
						max.set(func(max.x), func(max.y), func(max.z));
					}
				}
			}
			for (var _i2 = 0; _i2 < numBones; _i2++) {
				var aabb = new BoundingBox();
				aabb.setMinMax(boneMin[_i2], boneMax[_i2]);
				this.boneAabb.push(aabb);
			}
		};
		_proto2._initGeometryData = function _initGeometryData() {
			if (!this._geometryData) {
				this._geometryData = new GeometryData();
				if (this.vertexBuffer) {
					this._geometryData.vertexCount = this.vertexBuffer.numVertices;
					this._geometryData.maxVertices = this.vertexBuffer.numVertices;
				}
				if (this.indexBuffer.length > 0 && this.indexBuffer[0]) {
					this._geometryData.indexCount = this.indexBuffer[0].numIndices;
					this._geometryData.maxIndices = this.indexBuffer[0].numIndices;
				}
			}
		};
		_proto2.clear = function clear(verticesDynamic, indicesDynamic, maxVertices, maxIndices) {
			if (maxVertices === void 0) {
				maxVertices = 0;
			}
			if (maxIndices === void 0) {
				maxIndices = 0;
			}
			this._initGeometryData();
			this._geometryData.initDefaults();
			this._geometryData.recreate = true;
			this._geometryData.maxVertices = maxVertices;
			this._geometryData.maxIndices = maxIndices;
			this._geometryData.verticesUsage = verticesDynamic ? BUFFER_STATIC : BUFFER_DYNAMIC;
			this._geometryData.indicesUsage = indicesDynamic ? BUFFER_STATIC : BUFFER_DYNAMIC;
		};
		_proto2.setVertexStream = function setVertexStream(semantic, data, componentCount, numVertices, dataType, dataTypeNormalize) {
			if (dataType === void 0) {
				dataType = TYPE_FLOAT32;
			}
			if (dataTypeNormalize === void 0) {
				dataTypeNormalize = false;
			}
			this._initGeometryData();
			var vertexCount = numVertices || data.length / componentCount;
			this._geometryData._changeVertexCount(vertexCount, semantic);
			this._geometryData.vertexStreamsUpdated = true;
			this._geometryData.vertexStreamDictionary[semantic] = new GeometryVertexStream(data, componentCount, dataType, dataTypeNormalize);
		};
		_proto2.getVertexStream = function getVertexStream(semantic, data) {
			var count = 0;
			var done = false;
			if (this._geometryData) {
				var stream = this._geometryData.vertexStreamDictionary[semantic];
				if (stream) {
					done = true;
					count = this._geometryData.vertexCount;
					if (ArrayBuffer.isView(data)) {
						data.set(stream.data);
					} else {
						data.length = 0;
						data.push(stream.data);
					}
				}
			}
			if (!done) {
				if (this.vertexBuffer) {
					var iterator = new VertexIterator(this.vertexBuffer);
					count = iterator.readData(semantic, data);
				}
			}
			return count;
		};
		_proto2.setPositions = function setPositions(positions, componentCount, numVertices) {
			if (componentCount === void 0) {
				componentCount = GeometryData.DEFAULT_COMPONENTS_POSITION;
			}
			this.setVertexStream(SEMANTIC_POSITION, positions, componentCount, numVertices, TYPE_FLOAT32, false);
		};
		_proto2.setNormals = function setNormals(normals, componentCount, numVertices) {
			if (componentCount === void 0) {
				componentCount = GeometryData.DEFAULT_COMPONENTS_NORMAL;
			}
			this.setVertexStream(SEMANTIC_NORMAL, normals, componentCount, numVertices, TYPE_FLOAT32, false);
		};
		_proto2.setUvs = function setUvs(channel, uvs, componentCount, numVertices) {
			if (componentCount === void 0) {
				componentCount = GeometryData.DEFAULT_COMPONENTS_UV;
			}
			this.setVertexStream(SEMANTIC_TEXCOORD + channel, uvs, componentCount, numVertices, TYPE_FLOAT32, false);
		};
		_proto2.setColors = function setColors(colors, componentCount, numVertices) {
			if (componentCount === void 0) {
				componentCount = GeometryData.DEFAULT_COMPONENTS_COLORS;
			}
			this.setVertexStream(SEMANTIC_COLOR, colors, componentCount, numVertices, TYPE_FLOAT32, false);
		};
		_proto2.setColors32 = function setColors32(colors, numVertices) {
			this.setVertexStream(SEMANTIC_COLOR, colors, GeometryData.DEFAULT_COMPONENTS_COLORS, numVertices, TYPE_UINT8, true);
		};
		_proto2.setIndices = function setIndices(indices, numIndices) {
			this._initGeometryData();
			this._geometryData.indexStreamUpdated = true;
			this._geometryData.indices = indices;
			this._geometryData.indexCount = numIndices || indices.length;
		};
		_proto2.getPositions = function getPositions(positions) {
			return this.getVertexStream(SEMANTIC_POSITION, positions);
		};
		_proto2.getNormals = function getNormals(normals) {
			return this.getVertexStream(SEMANTIC_NORMAL, normals);
		};
		_proto2.getUvs = function getUvs(channel, uvs) {
			return this.getVertexStream(SEMANTIC_TEXCOORD + channel, uvs);
		};
		_proto2.getColors = function getColors(colors) {
			return this.getVertexStream(SEMANTIC_COLOR, colors);
		};
		_proto2.getIndices = function getIndices(indices) {
			var count = 0;
			if (this._geometryData && this._geometryData.indices) {
				var streamIndices = this._geometryData.indices;
				count = this._geometryData.indexCount;
				if (ArrayBuffer.isView(indices)) {
					indices.set(streamIndices);
				} else {
					indices.length = 0;
					indices.push(streamIndices);
				}
			} else {
				if (this.indexBuffer.length > 0 && this.indexBuffer[0]) {
					var indexBuffer = this.indexBuffer[0];
					count = indexBuffer.readData(indices);
				}
			}
			return count;
		};
		_proto2.update = function update(primitiveType, updateBoundingBox) {
			if (primitiveType === void 0) {
				primitiveType = PRIMITIVE_TRIANGLES;
			}
			if (updateBoundingBox === void 0) {
				updateBoundingBox = true;
			}
			if (this._geometryData) {
				if (updateBoundingBox) {
					var stream = this._geometryData.vertexStreamDictionary[SEMANTIC_POSITION];
					if (stream) {
						if (stream.componentCount === 3) {
							this._aabb.compute(stream.data, this._geometryData.vertexCount);
						}
					}
				}
				var destroyVB = this._geometryData.recreate;
				if (this._geometryData.vertexCount > this._geometryData.maxVertices) {
					destroyVB = true;
					this._geometryData.maxVertices = this._geometryData.vertexCount;
				}
				if (destroyVB) {
					if (this.vertexBuffer) {
						this.vertexBuffer.destroy();
						this.vertexBuffer = null;
					}
				}
				var destroyIB = this._geometryData.recreate;
				if (this._geometryData.indexCount > this._geometryData.maxIndices) {
					destroyIB = true;
					this._geometryData.maxIndices = this._geometryData.indexCount;
				}
				if (destroyIB) {
					if (this.indexBuffer.length > 0 && this.indexBuffer[0]) {
						this.indexBuffer[0].destroy();
						this.indexBuffer[0] = null;
					}
				}
				if (this._geometryData.vertexStreamsUpdated) {
					this._updateVertexBuffer();
				}
				if (this._geometryData.indexStreamUpdated) {
					this._updateIndexBuffer();
				}
				this.primitive[0].type = primitiveType;
				if (this.indexBuffer.length > 0 && this.indexBuffer[0]) {
					if (this._geometryData.indexStreamUpdated) {
						this.primitive[0].count = this._geometryData.indexCount;
						this.primitive[0].indexed = true;
					}
				} else {
					if (this._geometryData.vertexStreamsUpdated) {
						this.primitive[0].count = this._geometryData.vertexCount;
						this.primitive[0].indexed = false;
					}
				}
				this._geometryData.vertexCount = 0;
				this._geometryData.indexCount = 0;
				this._geometryData.vertexStreamsUpdated = false;
				this._geometryData.indexStreamUpdated = false;
				this._geometryData.recreate = false;
				this.updateRenderStates();
			}
		};
		_proto2._buildVertexFormat = function _buildVertexFormat(vertexCount) {
			var vertexDesc = [];
			for (var semantic in this._geometryData.vertexStreamDictionary) {
				var stream = this._geometryData.vertexStreamDictionary[semantic];
				vertexDesc.push({
					semantic: semantic,
					components: stream.componentCount,
					type: stream.dataType,
					normalize: stream.dataTypeNormalize
				});
			}
			return new VertexFormat(this.device, vertexDesc, vertexCount);
		};
		_proto2._updateVertexBuffer = function _updateVertexBuffer() {
			if (!this.vertexBuffer) {
				var allocateVertexCount = this._geometryData.maxVertices;
				var format = this._buildVertexFormat(allocateVertexCount);
				this.vertexBuffer = new VertexBuffer(this.device, format, allocateVertexCount, this._geometryData.verticesUsage);
			}
			var iterator = new VertexIterator(this.vertexBuffer);
			var numVertices = this._geometryData.vertexCount;
			for (var semantic in this._geometryData.vertexStreamDictionary) {
				var stream = this._geometryData.vertexStreamDictionary[semantic];
				iterator.writeData(semantic, stream.data, numVertices);
				delete this._geometryData.vertexStreamDictionary[semantic];
			}
			iterator.end();
		};
		_proto2._updateIndexBuffer = function _updateIndexBuffer() {
			if (this.indexBuffer.length <= 0 || !this.indexBuffer[0]) {
				var createFormat = this._geometryData.maxVertices > 0xffff ? INDEXFORMAT_UINT32 : INDEXFORMAT_UINT16;
				this.indexBuffer[0] = new IndexBuffer(this.device, createFormat, this._geometryData.maxIndices, this._geometryData.indicesUsage);
			}
			var srcIndices = this._geometryData.indices;
			if (srcIndices) {
				var indexBuffer = this.indexBuffer[0];
				indexBuffer.writeData(srcIndices, this._geometryData.indexCount);
				this._geometryData.indices = null;
			}
		};
		_proto2.prepareRenderState = function prepareRenderState(renderStyle) {
			if (renderStyle === RENDERSTYLE_WIREFRAME) {
				this.generateWireframe();
			} else if (renderStyle === RENDERSTYLE_POINTS) {
				this.primitive[RENDERSTYLE_POINTS] = {
					type: PRIMITIVE_POINTS,
					base: 0,
					count: this.vertexBuffer ? this.vertexBuffer.numVertices : 0,
					indexed: false
				};
			}
		};
		_proto2.updateRenderStates = function updateRenderStates() {
			if (this.primitive[RENDERSTYLE_POINTS]) {
				this.prepareRenderState(RENDERSTYLE_POINTS);
			}
			if (this.primitive[RENDERSTYLE_WIREFRAME]) {
				this.prepareRenderState(RENDERSTYLE_WIREFRAME);
			}
		};
		_proto2.generateWireframe = function generateWireframe() {
			this._destroyIndexBuffer(RENDERSTYLE_WIREFRAME);
			var numVertices = this.vertexBuffer.numVertices;
			var lines = [];
			var format;
			if (this.indexBuffer.length > 0 && this.indexBuffer[0]) {
				var offsets = [[0, 1], [1, 2], [2, 0]];
				var base = this.primitive[RENDERSTYLE_SOLID].base;
				var count = this.primitive[RENDERSTYLE_SOLID].count;
				var indexBuffer = this.indexBuffer[RENDERSTYLE_SOLID];
				var srcIndices = new typedArrayIndexFormats[indexBuffer.format](indexBuffer.storage);
				var seen = new Set();
				for (var j = base; j < base + count; j += 3) {
					for (var k = 0; k < 3; k++) {
						var i1 = srcIndices[j + offsets[k][0]];
						var i2 = srcIndices[j + offsets[k][1]];
						var hash = i1 > i2 ? i2 * numVertices + i1 : i1 * numVertices + i2;
						if (!seen.has(hash)) {
							seen.add(hash);
							lines.push(i1, i2);
						}
					}
				}
				format = indexBuffer.format;
			} else {
				for (var i = 0; i < numVertices; i += 3) {
					lines.push(i, i + 1, i + 1, i + 2, i + 2, i);
				}
				format = lines.length > 65535 ? INDEXFORMAT_UINT32 : INDEXFORMAT_UINT16;
			}
			var wireBuffer = new IndexBuffer(this.vertexBuffer.device, format, lines.length);
			var dstIndices = new typedArrayIndexFormats[wireBuffer.format](wireBuffer.storage);
			dstIndices.set(lines);
			wireBuffer.unlock();
			this.primitive[RENDERSTYLE_WIREFRAME] = {
				type: PRIMITIVE_LINES,
				base: 0,
				count: lines.length,
				indexed: true
			};
			this.indexBuffer[RENDERSTYLE_WIREFRAME] = wireBuffer;
		};
		_createClass(Mesh, [{
			key: "morph",
			get: function get() {
				return this._morph;
			},
			set: function set(morph) {
				if (morph !== this._morph) {
					if (this._morph) {
						this._morph.decRefCount();
					}
					this._morph = morph;
					if (morph) {
						morph.incRefCount();
					}
				}
			}
		}, {
			key: "aabb",
			get: function get() {
				return this._aabb;
			},
			set: function set(aabb) {
				this._aabb = aabb;
			}
		}]);
		return Mesh;
	}(RefCountedObject);

	var primitiveUv1Padding = 4.0 / 64;
	var primitiveUv1PaddingScale = 1.0 - primitiveUv1Padding * 2;
	var shapePrimitives = [];
	function calculateNormals(positions, indices) {
		var triangleCount = indices.length / 3;
		var vertexCount = positions.length / 3;
		var p1 = new Vec3();
		var p2 = new Vec3();
		var p3 = new Vec3();
		var p1p2 = new Vec3();
		var p1p3 = new Vec3();
		var faceNormal = new Vec3();
		var normals = [];
		for (var i = 0; i < positions.length; i++) {
			normals[i] = 0;
		}
		for (var _i = 0; _i < triangleCount; _i++) {
			var i1 = indices[_i * 3];
			var i2 = indices[_i * 3 + 1];
			var i3 = indices[_i * 3 + 2];
			p1.set(positions[i1 * 3], positions[i1 * 3 + 1], positions[i1 * 3 + 2]);
			p2.set(positions[i2 * 3], positions[i2 * 3 + 1], positions[i2 * 3 + 2]);
			p3.set(positions[i3 * 3], positions[i3 * 3 + 1], positions[i3 * 3 + 2]);
			p1p2.sub2(p2, p1);
			p1p3.sub2(p3, p1);
			faceNormal.cross(p1p2, p1p3).normalize();
			normals[i1 * 3] += faceNormal.x;
			normals[i1 * 3 + 1] += faceNormal.y;
			normals[i1 * 3 + 2] += faceNormal.z;
			normals[i2 * 3] += faceNormal.x;
			normals[i2 * 3 + 1] += faceNormal.y;
			normals[i2 * 3 + 2] += faceNormal.z;
			normals[i3 * 3] += faceNormal.x;
			normals[i3 * 3 + 1] += faceNormal.y;
			normals[i3 * 3 + 2] += faceNormal.z;
		}
		for (var _i2 = 0; _i2 < vertexCount; _i2++) {
			var nx = normals[_i2 * 3];
			var ny = normals[_i2 * 3 + 1];
			var nz = normals[_i2 * 3 + 2];
			var invLen = 1 / Math.sqrt(nx * nx + ny * ny + nz * nz);
			normals[_i2 * 3] *= invLen;
			normals[_i2 * 3 + 1] *= invLen;
			normals[_i2 * 3 + 2] *= invLen;
		}
		return normals;
	}
	function calculateTangents(positions, normals, uvs, indices) {
		var triangleCount = indices.length / 3;
		var vertexCount = positions.length / 3;
		var v1 = new Vec3();
		var v2 = new Vec3();
		var v3 = new Vec3();
		var w1 = new Vec2();
		var w2 = new Vec2();
		var w3 = new Vec2();
		var sdir = new Vec3();
		var tdir = new Vec3();
		var tan1 = new Float32Array(vertexCount * 3);
		var tan2 = new Float32Array(vertexCount * 3);
		var tangents = [];
		for (var i = 0; i < triangleCount; i++) {
			var i1 = indices[i * 3];
			var i2 = indices[i * 3 + 1];
			var i3 = indices[i * 3 + 2];
			v1.set(positions[i1 * 3], positions[i1 * 3 + 1], positions[i1 * 3 + 2]);
			v2.set(positions[i2 * 3], positions[i2 * 3 + 1], positions[i2 * 3 + 2]);
			v3.set(positions[i3 * 3], positions[i3 * 3 + 1], positions[i3 * 3 + 2]);
			w1.set(uvs[i1 * 2], uvs[i1 * 2 + 1]);
			w2.set(uvs[i2 * 2], uvs[i2 * 2 + 1]);
			w3.set(uvs[i3 * 2], uvs[i3 * 2 + 1]);
			var x1 = v2.x - v1.x;
			var x2 = v3.x - v1.x;
			var y1 = v2.y - v1.y;
			var y2 = v3.y - v1.y;
			var z1 = v2.z - v1.z;
			var z2 = v3.z - v1.z;
			var s1 = w2.x - w1.x;
			var s2 = w3.x - w1.x;
			var _t = w2.y - w1.y;
			var _t2 = w3.y - w1.y;
			var area = s1 * _t2 - s2 * _t;
			if (area === 0) {
				sdir.set(0, 1, 0);
				tdir.set(1, 0, 0);
			} else {
				var r = 1 / area;
				sdir.set((_t2 * x1 - _t * x2) * r, (_t2 * y1 - _t * y2) * r, (_t2 * z1 - _t * z2) * r);
				tdir.set((s1 * x2 - s2 * x1) * r, (s1 * y2 - s2 * y1) * r, (s1 * z2 - s2 * z1) * r);
			}
			tan1[i1 * 3 + 0] += sdir.x;
			tan1[i1 * 3 + 1] += sdir.y;
			tan1[i1 * 3 + 2] += sdir.z;
			tan1[i2 * 3 + 0] += sdir.x;
			tan1[i2 * 3 + 1] += sdir.y;
			tan1[i2 * 3 + 2] += sdir.z;
			tan1[i3 * 3 + 0] += sdir.x;
			tan1[i3 * 3 + 1] += sdir.y;
			tan1[i3 * 3 + 2] += sdir.z;
			tan2[i1 * 3 + 0] += tdir.x;
			tan2[i1 * 3 + 1] += tdir.y;
			tan2[i1 * 3 + 2] += tdir.z;
			tan2[i2 * 3 + 0] += tdir.x;
			tan2[i2 * 3 + 1] += tdir.y;
			tan2[i2 * 3 + 2] += tdir.z;
			tan2[i3 * 3 + 0] += tdir.x;
			tan2[i3 * 3 + 1] += tdir.y;
			tan2[i3 * 3 + 2] += tdir.z;
		}
		var t1 = new Vec3();
		var t2 = new Vec3();
		var n = new Vec3();
		var temp = new Vec3();
		for (var _i3 = 0; _i3 < vertexCount; _i3++) {
			n.set(normals[_i3 * 3], normals[_i3 * 3 + 1], normals[_i3 * 3 + 2]);
			t1.set(tan1[_i3 * 3], tan1[_i3 * 3 + 1], tan1[_i3 * 3 + 2]);
			t2.set(tan2[_i3 * 3], tan2[_i3 * 3 + 1], tan2[_i3 * 3 + 2]);
			var ndott = n.dot(t1);
			temp.copy(n).mulScalar(ndott);
			temp.sub2(t1, temp).normalize();
			tangents[_i3 * 4] = temp.x;
			tangents[_i3 * 4 + 1] = temp.y;
			tangents[_i3 * 4 + 2] = temp.z;
			temp.cross(n, t1);
			tangents[_i3 * 4 + 3] = temp.dot(t2) < 0.0 ? -1.0 : 1.0;
		}
		return tangents;
	}
	function createMesh$1(device, positions, opts) {
		var mesh = new Mesh(device);
		mesh.setPositions(positions);
		if (opts) {
			if (opts.normals) {
				mesh.setNormals(opts.normals);
			}
			if (opts.tangents) {
				mesh.setVertexStream(SEMANTIC_TANGENT, opts.tangents, 4);
			}
			if (opts.colors) {
				mesh.setColors32(opts.colors);
			}
			if (opts.uvs) {
				mesh.setUvs(0, opts.uvs);
			}
			if (opts.uvs1) {
				mesh.setUvs(1, opts.uvs1);
			}
			if (opts.blendIndices) {
				mesh.setVertexStream(SEMANTIC_BLENDINDICES, opts.blendIndices, 4, opts.blendIndices.length / 4, TYPE_UINT8);
			}
			if (opts.blendWeights) {
				mesh.setVertexStream(SEMANTIC_BLENDWEIGHT, opts.blendWeights, 4);
			}
			if (opts.indices) {
				mesh.setIndices(opts.indices);
			}
		}
		mesh.update();
		return mesh;
	}
	function createTorus(device, opts) {
		var _opts$tubeRadius, _opts$ringRadius, _opts$segments, _opts$sides, _opts$calculateTangen;
		if (opts === void 0) {
			opts = {};
		}
		var rc = (_opts$tubeRadius = opts.tubeRadius) != null ? _opts$tubeRadius : 0.2;
		var rt = (_opts$ringRadius = opts.ringRadius) != null ? _opts$ringRadius : 0.3;
		var segments = (_opts$segments = opts.segments) != null ? _opts$segments : 30;
		var sides = (_opts$sides = opts.sides) != null ? _opts$sides : 20;
		var calcTangents = (_opts$calculateTangen = opts.calculateTangents) != null ? _opts$calculateTangen : false;
		var positions = [];
		var normals = [];
		var uvs = [];
		var indices = [];
		for (var i = 0; i <= sides; i++) {
			for (var j = 0; j <= segments; j++) {
				var x = Math.cos(2 * Math.PI * j / segments) * (rt + rc * Math.cos(2 * Math.PI * i / sides));
				var y = Math.sin(2 * Math.PI * i / sides) * rc;
				var z = Math.sin(2 * Math.PI * j / segments) * (rt + rc * Math.cos(2 * Math.PI * i / sides));
				var nx = Math.cos(2 * Math.PI * j / segments) * Math.cos(2 * Math.PI * i / sides);
				var ny = Math.sin(2 * Math.PI * i / sides);
				var nz = Math.sin(2 * Math.PI * j / segments) * Math.cos(2 * Math.PI * i / sides);
				var u = i / sides;
				var v = 1 - j / segments;
				positions.push(x, y, z);
				normals.push(nx, ny, nz);
				uvs.push(u, 1.0 - v);
				if (i < sides && j < segments) {
					var first = i * (segments + 1) + j;
					var second = (i + 1) * (segments + 1) + j;
					var third = i * (segments + 1) + (j + 1);
					var fourth = (i + 1) * (segments + 1) + (j + 1);
					indices.push(first, second, third);
					indices.push(second, fourth, third);
				}
			}
		}
		var options = {
			normals: normals,
			uvs: uvs,
			uvs1: uvs,
			indices: indices
		};
		if (calcTangents) {
			options.tangents = calculateTangents(positions, normals, uvs, indices);
		}
		return createMesh$1(device, positions, options);
	}
	function _createConeData(baseRadius, peakRadius, height, heightSegments, capSegments, roundedCaps) {
		var pos = new Vec3();
		var bottomToTop = new Vec3();
		var norm = new Vec3();
		var top = new Vec3();
		var bottom = new Vec3();
		var tangent = new Vec3();
		var positions = [];
		var normals = [];
		var uvs = [];
		var uvs1 = [];
		var indices = [];
		var offset;
		if (height > 0) {
			for (var i = 0; i <= heightSegments; i++) {
				for (var j = 0; j <= capSegments; j++) {
					var theta = j / capSegments * 2 * Math.PI - Math.PI;
					var sinTheta = Math.sin(theta);
					var cosTheta = Math.cos(theta);
					bottom.set(sinTheta * baseRadius, -height / 2, cosTheta * baseRadius);
					top.set(sinTheta * peakRadius, height / 2, cosTheta * peakRadius);
					pos.lerp(bottom, top, i / heightSegments);
					bottomToTop.sub2(top, bottom).normalize();
					tangent.set(cosTheta, 0, -sinTheta);
					norm.cross(tangent, bottomToTop).normalize();
					positions.push(pos.x, pos.y, pos.z);
					normals.push(norm.x, norm.y, norm.z);
					var u = j / capSegments;
					var v = i / heightSegments;
					uvs.push(u, 1 - v);
					var _v = v;
					v = u;
					u = _v;
					u = u * primitiveUv1PaddingScale + primitiveUv1Padding;
					v = v * primitiveUv1PaddingScale + primitiveUv1Padding;
					u /= 3;
					uvs1.push(u, 1 - v);
					if (i < heightSegments && j < capSegments) {
						var first = i * (capSegments + 1) + j;
						var second = i * (capSegments + 1) + (j + 1);
						var third = (i + 1) * (capSegments + 1) + j;
						var fourth = (i + 1) * (capSegments + 1) + (j + 1);
						indices.push(first, second, third);
						indices.push(second, fourth, third);
					}
				}
			}
		}
		if (roundedCaps) {
			var latitudeBands = Math.floor(capSegments / 2);
			var longitudeBands = capSegments;
			var capOffset = height / 2;
			for (var lat = 0; lat <= latitudeBands; lat++) {
				var _theta = lat * Math.PI * 0.5 / latitudeBands;
				var _sinTheta = Math.sin(_theta);
				var _cosTheta = Math.cos(_theta);
				for (var lon = 0; lon <= longitudeBands; lon++) {
					var phi = lon * 2 * Math.PI / longitudeBands - Math.PI / 2;
					var sinPhi = Math.sin(phi);
					var cosPhi = Math.cos(phi);
					var x = cosPhi * _sinTheta;
					var y = _cosTheta;
					var z = sinPhi * _sinTheta;
					var _u = 1 - lon / longitudeBands;
					var _v2 = 1 - lat / latitudeBands;
					positions.push(x * peakRadius, y * peakRadius + capOffset, z * peakRadius);
					normals.push(x, y, z);
					uvs.push(_u, 1 - _v2);
					_u = _u * primitiveUv1PaddingScale + primitiveUv1Padding;
					_v2 = _v2 * primitiveUv1PaddingScale + primitiveUv1Padding;
					_u /= 3;
					_v2 /= 3;
					_u += 1.0 / 3;
					uvs1.push(_u, 1 - _v2);
				}
			}
			offset = (heightSegments + 1) * (capSegments + 1);
			for (var _lat = 0; _lat < latitudeBands; ++_lat) {
				for (var _lon = 0; _lon < longitudeBands; ++_lon) {
					var _first = _lat * (longitudeBands + 1) + _lon;
					var _second = _first + longitudeBands + 1;
					indices.push(offset + _first + 1, offset + _second, offset + _first);
					indices.push(offset + _first + 1, offset + _second + 1, offset + _second);
				}
			}
			for (var _lat2 = 0; _lat2 <= latitudeBands; _lat2++) {
				var _theta2 = Math.PI * 0.5 + _lat2 * Math.PI * 0.5 / latitudeBands;
				var _sinTheta2 = Math.sin(_theta2);
				var _cosTheta2 = Math.cos(_theta2);
				for (var _lon2 = 0; _lon2 <= longitudeBands; _lon2++) {
					var _phi = _lon2 * 2 * Math.PI / longitudeBands - Math.PI / 2;
					var _sinPhi = Math.sin(_phi);
					var _cosPhi = Math.cos(_phi);
					var _x = _cosPhi * _sinTheta2;
					var _y = _cosTheta2;
					var _z = _sinPhi * _sinTheta2;
					var _u2 = 1 - _lon2 / longitudeBands;
					var _v3 = 1 - _lat2 / latitudeBands;
					positions.push(_x * peakRadius, _y * peakRadius - capOffset, _z * peakRadius);
					normals.push(_x, _y, _z);
					uvs.push(_u2, 1 - _v3);
					_u2 = _u2 * primitiveUv1PaddingScale + primitiveUv1Padding;
					_v3 = _v3 * primitiveUv1PaddingScale + primitiveUv1Padding;
					_u2 /= 3;
					_v3 /= 3;
					_u2 += 2.0 / 3;
					uvs1.push(_u2, 1 - _v3);
				}
			}
			offset = (heightSegments + 1) * (capSegments + 1) + (longitudeBands + 1) * (latitudeBands + 1);
			for (var _lat3 = 0; _lat3 < latitudeBands; ++_lat3) {
				for (var _lon3 = 0; _lon3 < longitudeBands; ++_lon3) {
					var _first2 = _lat3 * (longitudeBands + 1) + _lon3;
					var _second2 = _first2 + longitudeBands + 1;
					indices.push(offset + _first2 + 1, offset + _second2, offset + _first2);
					indices.push(offset + _first2 + 1, offset + _second2 + 1, offset + _second2);
				}
			}
		} else {
			offset = (heightSegments + 1) * (capSegments + 1);
			if (baseRadius > 0) {
				for (var _i4 = 0; _i4 < capSegments; _i4++) {
					var _theta3 = _i4 / capSegments * 2 * Math.PI;
					var _x2 = Math.sin(_theta3);
					var _y2 = -height / 2;
					var _z2 = Math.cos(_theta3);
					var _u3 = 1 - (_x2 + 1) / 2;
					var _v4 = (_z2 + 1) / 2;
					positions.push(_x2 * baseRadius, _y2, _z2 * baseRadius);
					normals.push(0, -1, 0);
					uvs.push(_u3, 1 - _v4);
					_u3 = _u3 * primitiveUv1PaddingScale + primitiveUv1Padding;
					_v4 = _v4 * primitiveUv1PaddingScale + primitiveUv1Padding;
					_u3 /= 3;
					_v4 /= 3;
					_u3 += 1 / 3;
					uvs1.push(_u3, 1 - _v4);
					if (_i4 > 1) {
						indices.push(offset, offset + _i4, offset + _i4 - 1);
					}
				}
			}
			offset += capSegments;
			if (peakRadius > 0) {
				for (var _i5 = 0; _i5 < capSegments; _i5++) {
					var _theta4 = _i5 / capSegments * 2 * Math.PI;
					var _x3 = Math.sin(_theta4);
					var _y3 = height / 2;
					var _z3 = Math.cos(_theta4);
					var _u4 = 1 - (_x3 + 1) / 2;
					var _v5 = (_z3 + 1) / 2;
					positions.push(_x3 * peakRadius, _y3, _z3 * peakRadius);
					normals.push(0, 1, 0);
					uvs.push(_u4, 1 - _v5);
					_u4 = _u4 * primitiveUv1PaddingScale + primitiveUv1Padding;
					_v5 = _v5 * primitiveUv1PaddingScale + primitiveUv1Padding;
					_u4 /= 3;
					_v5 /= 3;
					_u4 += 2 / 3;
					uvs1.push(_u4, 1 - _v5);
					if (_i5 > 1) {
						indices.push(offset, offset + _i5 - 1, offset + _i5);
					}
				}
			}
		}
		return {
			positions: positions,
			normals: normals,
			uvs: uvs,
			uvs1: uvs1,
			indices: indices
		};
	}
	function createCylinder(device, opts) {
		var _opts$radius, _opts$height, _opts$heightSegments, _opts$capSegments, _opts$calculateTangen2;
		if (opts === void 0) {
			opts = {};
		}
		var radius = (_opts$radius = opts.radius) != null ? _opts$radius : 0.5;
		var height = (_opts$height = opts.height) != null ? _opts$height : 1;
		var heightSegments = (_opts$heightSegments = opts.heightSegments) != null ? _opts$heightSegments : 5;
		var capSegments = (_opts$capSegments = opts.capSegments) != null ? _opts$capSegments : 20;
		var calcTangents = (_opts$calculateTangen2 = opts.calculateTangents) != null ? _opts$calculateTangen2 : false;
		var options = _createConeData(radius, radius, height, heightSegments, capSegments, false);
		if (calcTangents) {
			options.tangents = calculateTangents(options.positions, options.normals, options.uvs, options.indices);
		}
		return createMesh$1(device, options.positions, options);
	}
	function createCapsule(device, opts) {
		var _opts$radius2, _opts$height2, _opts$heightSegments2, _opts$sides2, _opts$calculateTangen3;
		if (opts === void 0) {
			opts = {};
		}
		var radius = (_opts$radius2 = opts.radius) != null ? _opts$radius2 : 0.3;
		var height = (_opts$height2 = opts.height) != null ? _opts$height2 : 1;
		var heightSegments = (_opts$heightSegments2 = opts.heightSegments) != null ? _opts$heightSegments2 : 1;
		var sides = (_opts$sides2 = opts.sides) != null ? _opts$sides2 : 20;
		var calcTangents = (_opts$calculateTangen3 = opts.calculateTangents) != null ? _opts$calculateTangen3 : false;
		var options = _createConeData(radius, radius, height - 2 * radius, heightSegments, sides, true);
		if (calcTangents) {
			options.tangents = calculateTangents(options.positions, options.normals, options.uvs, options.indices);
		}
		return createMesh$1(device, options.positions, options);
	}
	function createCone(device, opts) {
		var _opts$baseRadius, _opts$peakRadius, _opts$height3, _opts$heightSegments3, _opts$capSegments2, _opts$calculateTangen4;
		if (opts === void 0) {
			opts = {};
		}
		var baseRadius = (_opts$baseRadius = opts.baseRadius) != null ? _opts$baseRadius : 0.5;
		var peakRadius = (_opts$peakRadius = opts.peakRadius) != null ? _opts$peakRadius : 0;
		var height = (_opts$height3 = opts.height) != null ? _opts$height3 : 1;
		var heightSegments = (_opts$heightSegments3 = opts.heightSegments) != null ? _opts$heightSegments3 : 5;
		var capSegments = (_opts$capSegments2 = opts.capSegments) != null ? _opts$capSegments2 : 18;
		var calcTangents = (_opts$calculateTangen4 = opts.calculateTangents) != null ? _opts$calculateTangen4 : false;
		var options = _createConeData(baseRadius, peakRadius, height, heightSegments, capSegments, false);
		if (calcTangents) {
			options.tangents = calculateTangents(options.positions, options.normals, options.uvs, options.indices);
		}
		return createMesh$1(device, options.positions, options);
	}
	function createSphere(device, opts) {
		var _opts$radius3, _opts$latitudeBands, _opts$longitudeBands, _opts$calculateTangen5;
		if (opts === void 0) {
			opts = {};
		}
		var radius = (_opts$radius3 = opts.radius) != null ? _opts$radius3 : 0.5;
		var latitudeBands = (_opts$latitudeBands = opts.latitudeBands) != null ? _opts$latitudeBands : 16;
		var longitudeBands = (_opts$longitudeBands = opts.longitudeBands) != null ? _opts$longitudeBands : 16;
		var calcTangents = (_opts$calculateTangen5 = opts.calculateTangents) != null ? _opts$calculateTangen5 : false;
		var positions = [];
		var normals = [];
		var uvs = [];
		var indices = [];
		for (var lat = 0; lat <= latitudeBands; lat++) {
			var theta = lat * Math.PI / latitudeBands;
			var sinTheta = Math.sin(theta);
			var cosTheta = Math.cos(theta);
			for (var lon = 0; lon <= longitudeBands; lon++) {
				var phi = lon * 2 * Math.PI / longitudeBands - Math.PI / 2;
				var sinPhi = Math.sin(phi);
				var cosPhi = Math.cos(phi);
				var x = cosPhi * sinTheta;
				var y = cosTheta;
				var z = sinPhi * sinTheta;
				var u = 1 - lon / longitudeBands;
				var v = 1 - lat / latitudeBands;
				positions.push(x * radius, y * radius, z * radius);
				normals.push(x, y, z);
				uvs.push(u, 1 - v);
			}
		}
		for (var _lat4 = 0; _lat4 < latitudeBands; ++_lat4) {
			for (var _lon4 = 0; _lon4 < longitudeBands; ++_lon4) {
				var first = _lat4 * (longitudeBands + 1) + _lon4;
				var second = first + longitudeBands + 1;
				indices.push(first + 1, second, first);
				indices.push(first + 1, second + 1, second);
			}
		}
		var options = {
			normals: normals,
			uvs: uvs,
			uvs1: uvs,
			indices: indices
		};
		if (calcTangents) {
			options.tangents = calculateTangents(positions, normals, uvs, indices);
		}
		return createMesh$1(device, positions, options);
	}
	function createPlane(device, opts) {
		var _opts$halfExtents, _opts$widthSegments, _opts$lengthSegments, _opts$calculateTangen6;
		if (opts === void 0) {
			opts = {};
		}
		var he = (_opts$halfExtents = opts.halfExtents) != null ? _opts$halfExtents : new Vec2(0.5, 0.5);
		var ws = (_opts$widthSegments = opts.widthSegments) != null ? _opts$widthSegments : 5;
		var ls = (_opts$lengthSegments = opts.lengthSegments) != null ? _opts$lengthSegments : 5;
		var calcTangents = (_opts$calculateTangen6 = opts.calculateTangents) != null ? _opts$calculateTangen6 : false;
		var positions = [];
		var normals = [];
		var uvs = [];
		var indices = [];
		var vcounter = 0;
		for (var i = 0; i <= ws; i++) {
			for (var j = 0; j <= ls; j++) {
				var x = -he.x + 2 * he.x * i / ws;
				var y = 0.0;
				var z = -(-he.y + 2 * he.y * j / ls);
				var u = i / ws;
				var v = j / ls;
				positions.push(x, y, z);
				normals.push(0, 1, 0);
				uvs.push(u, 1 - v);
				if (i < ws && j < ls) {
					indices.push(vcounter + ls + 1, vcounter + 1, vcounter);
					indices.push(vcounter + ls + 1, vcounter + ls + 2, vcounter + 1);
				}
				vcounter++;
			}
		}
		var options = {
			normals: normals,
			uvs: uvs,
			uvs1: uvs,
			indices: indices
		};
		if (calcTangents) {
			options.tangents = calculateTangents(positions, normals, uvs, indices);
		}
		return createMesh$1(device, positions, options);
	}
	function createBox(device, opts) {
		var _opts$halfExtents2, _opts$widthSegments2, _opts$lengthSegments2, _opts$heightSegments4, _opts$calculateTangen7;
		if (opts === void 0) {
			opts = {};
		}
		var he = (_opts$halfExtents2 = opts.halfExtents) != null ? _opts$halfExtents2 : new Vec3(0.5, 0.5, 0.5);
		var ws = (_opts$widthSegments2 = opts.widthSegments) != null ? _opts$widthSegments2 : 1;
		var ls = (_opts$lengthSegments2 = opts.lengthSegments) != null ? _opts$lengthSegments2 : 1;
		var hs = (_opts$heightSegments4 = opts.heightSegments) != null ? _opts$heightSegments4 : 1;
		var calcTangents = (_opts$calculateTangen7 = opts.calculateTangents) != null ? _opts$calculateTangen7 : false;
		var corners = [new Vec3(-he.x, -he.y, he.z), new Vec3(he.x, -he.y, he.z), new Vec3(he.x, he.y, he.z), new Vec3(-he.x, he.y, he.z), new Vec3(he.x, -he.y, -he.z), new Vec3(-he.x, -he.y, -he.z), new Vec3(-he.x, he.y, -he.z), new Vec3(he.x, he.y, -he.z)];
		var faceAxes = [[0, 1, 3], [4, 5, 7], [3, 2, 6], [1, 0, 4], [1, 4, 2], [5, 0, 6]];
		var faceNormals = [[0, 0, 1], [0, 0, -1], [0, 1, 0], [0, -1, 0], [1, 0, 0], [-1, 0, 0]];
		var sides = {
			FRONT: 0,
			BACK: 1,
			TOP: 2,
			BOTTOM: 3,
			RIGHT: 4,
			LEFT: 5
		};
		var positions = [];
		var normals = [];
		var uvs = [];
		var uvs1 = [];
		var indices = [];
		var vcounter = 0;
		var generateFace = function generateFace(side, uSegments, vSegments) {
			var temp1 = new Vec3();
			var temp2 = new Vec3();
			var temp3 = new Vec3();
			var r = new Vec3();
			for (var i = 0; i <= uSegments; i++) {
				for (var j = 0; j <= vSegments; j++) {
					temp1.lerp(corners[faceAxes[side][0]], corners[faceAxes[side][1]], i / uSegments);
					temp2.lerp(corners[faceAxes[side][0]], corners[faceAxes[side][2]], j / vSegments);
					temp3.sub2(temp2, corners[faceAxes[side][0]]);
					r.add2(temp1, temp3);
					var u = i / uSegments;
					var v = j / vSegments;
					positions.push(r.x, r.y, r.z);
					normals.push(faceNormals[side][0], faceNormals[side][1], faceNormals[side][2]);
					uvs.push(u, 1 - v);
					u = u * primitiveUv1PaddingScale + primitiveUv1Padding;
					v = v * primitiveUv1PaddingScale + primitiveUv1Padding;
					u /= 3;
					v /= 3;
					u += side % 3 / 3;
					v += Math.floor(side / 3) / 3;
					uvs1.push(u, 1 - v);
					if (i < uSegments && j < vSegments) {
						indices.push(vcounter + vSegments + 1, vcounter + 1, vcounter);
						indices.push(vcounter + vSegments + 1, vcounter + vSegments + 2, vcounter + 1);
					}
					vcounter++;
				}
			}
		};
		generateFace(sides.FRONT, ws, hs);
		generateFace(sides.BACK, ws, hs);
		generateFace(sides.TOP, ws, ls);
		generateFace(sides.BOTTOM, ws, ls);
		generateFace(sides.RIGHT, ls, hs);
		generateFace(sides.LEFT, ls, hs);
		var options = {
			normals: normals,
			uvs: uvs,
			uvs1: uvs1,
			indices: indices
		};
		if (calcTangents) {
			options.tangents = calculateTangents(positions, normals, uvs, indices);
		}
		return createMesh$1(device, positions, options);
	}
	function getShapePrimitive(device, type) {
		var primData = null;
		for (var i = 0; i < shapePrimitives.length; i++) {
			if (shapePrimitives[i].type === type && shapePrimitives[i].device === device) {
				primData = shapePrimitives[i].primData;
			}
		}
		if (!primData) {
			var mesh, area;
			switch (type) {
				case 'box':
					mesh = createBox(device);
					area = {
						x: 2,
						y: 2,
						z: 2,
						uv: 2.0 / 3
					};
					break;
				case 'capsule':
					mesh = createCapsule(device, {
						radius: 0.5,
						height: 2
					});
					area = {
						x: Math.PI * 2,
						y: Math.PI,
						z: Math.PI * 2,
						uv: 1.0 / 3 + 1.0 / 3 / 3 * 2
					};
					break;
				case 'cone':
					mesh = createCone(device, {
						baseRadius: 0.5,
						peakRadius: 0,
						height: 1
					});
					area = {
						x: 2.54,
						y: 2.54,
						z: 2.54,
						uv: 1.0 / 3 + 1.0 / 3 / 3
					};
					break;
				case 'cylinder':
					mesh = createCylinder(device, {
						radius: 0.5,
						height: 1
					});
					area = {
						x: Math.PI,
						y: 0.79 * 2,
						z: Math.PI,
						uv: 1.0 / 3 + 1.0 / 3 / 3 * 2
					};
					break;
				case 'plane':
					mesh = createPlane(device, {
						halfExtents: new Vec2(0.5, 0.5),
						widthSegments: 1,
						lengthSegments: 1
					});
					area = {
						x: 0,
						y: 1,
						z: 0,
						uv: 1
					};
					break;
				case 'sphere':
					mesh = createSphere(device, {
						radius: 0.5
					});
					area = {
						x: Math.PI,
						y: Math.PI,
						z: Math.PI,
						uv: 1
					};
					break;
				case 'torus':
					mesh = createTorus(device, {
						tubeRadius: 0.2,
						ringRadius: 0.3
					});
					area = {
						x: Math.PI * 0.5 * 0.5 - Math.PI * 0.1 * 0.1,
						y: 0.4,
						z: 0.4,
						uv: 1
					};
					break;
				default:
					throw new Error('Invalid primitive type: ' + type);
			}
			mesh.incRefCount();
			primData = {
				mesh: mesh,
				area: area
			};
			shapePrimitives.push({
				type: type,
				device: device,
				primData: primData
			});
		}
		return primData;
	}

	var ColorAttachmentOps = function ColorAttachmentOps() {
		this.clearValue = new Color(0, 0, 0, 1);
		this.clear = false;
		this.store = false;
		this.resolve = true;
		this.mipmaps = false;
	};
	var DepthStencilAttachmentOps = function DepthStencilAttachmentOps() {
		this.clearDepthValue = 1;
		this.clearStencilValue = 0;
		this.clearDepth = false;
		this.clearStencil = false;
		this.storeDepth = false;
		this.storeStencil = false;
	};
	var RenderPass = function () {
		function RenderPass(graphicsDevice, execute) {
			this.name = void 0;
			this.renderTarget = void 0;
			this.samples = 0;
			this.colorArrayOps = [];
			this.depthStencilOps = void 0;
			this.requiresCubemaps = true;
			this.fullSizeClearRect = true;
			this.execute = void 0;
			this.before = void 0;
			this.after = void 0;
			this.device = graphicsDevice;
			this.execute = execute;
		}
		var _proto = RenderPass.prototype;
		_proto.init = function init(renderTarget) {
			var _renderTarget$_colorB;
			this.renderTarget = renderTarget || null;
			this.samples = Math.max(this.renderTarget ? this.renderTarget.samples : this.device.samples, 1);
			this.depthStencilOps = new DepthStencilAttachmentOps();
			var numColorOps = renderTarget ? (_renderTarget$_colorB = renderTarget._colorBuffers) == null ? void 0 : _renderTarget$_colorB.length : 1;
			for (var i = 0; i < numColorOps; i++) {
				var _this$renderTarget;
				var colorOps = new ColorAttachmentOps();
				this.colorArrayOps[i] = colorOps;
				if (this.samples === 1) {
					colorOps.store = true;
					colorOps.resolve = false;
				}
				if ((_this$renderTarget = this.renderTarget) != null && (_this$renderTarget = _this$renderTarget._colorBuffers) != null && _this$renderTarget[i].mipmaps) {
					colorOps.mipmaps = true;
				}
			}
		};
		_proto.setClearColor = function setClearColor(color) {
			var count = this.colorArrayOps.length;
			for (var i = 0; i < count; i++) {
				var colorOps = this.colorArrayOps[i];
				colorOps.clearValue.copy(color);
				colorOps.clear = true;
			}
		};
		_proto.setClearDepth = function setClearDepth(depthValue) {
			this.depthStencilOps.clearDepthValue = depthValue;
			this.depthStencilOps.clearDepth = true;
		};
		_proto.setClearStencil = function setClearStencil(stencilValue) {
			this.depthStencilOps.clearStencilValue = stencilValue;
			this.depthStencilOps.clearStencil = true;
		};
		_proto.render = function render() {
			var _this$before, _this$execute, _this$after;
			var device = this.device;
			var realPass = this.renderTarget !== undefined;
			(_this$before = this.before) == null ? void 0 : _this$before.call(this);
			if (realPass) {
				device.startPass(this);
			}
			(_this$execute = this.execute) == null ? void 0 : _this$execute.call(this);
			if (realPass) {
				device.endPass(this);
			}
			(_this$after = this.after) == null ? void 0 : _this$after.call(this);
			device.renderPassIndex++;
		};
		_createClass(RenderPass, [{
			key: "colorOps",
			get: function get() {
				return this.colorArrayOps[0];
			}
		}]);
		return RenderPass;
	}();

	var ShaderProcessorOptions = function () {
		function ShaderProcessorOptions(viewUniformFormat, viewBindGroupFormat, vertexFormat) {
			this.uniformFormats = [];
			this.bindGroupFormats = [];
			this.vertexFormat = void 0;
			this.uniformFormats[BINDGROUP_VIEW] = viewUniformFormat;
			this.bindGroupFormats[BINDGROUP_VIEW] = viewBindGroupFormat;
			this.vertexFormat = vertexFormat;
		}
		var _proto = ShaderProcessorOptions.prototype;
		_proto.hasUniform = function hasUniform(name) {
			for (var i = 0; i < this.uniformFormats.length; i++) {
				var uniformFormat = this.uniformFormats[i];
				if (uniformFormat != null && uniformFormat.get(name)) {
					return true;
				}
			}
			return false;
		};
		_proto.hasTexture = function hasTexture(name) {
			for (var i = 0; i < this.bindGroupFormats.length; i++) {
				var groupFormat = this.bindGroupFormats[i];
				if (groupFormat != null && groupFormat.getTexture(name)) {
					return true;
				}
			}
			return false;
		};
		_proto.getVertexElement = function getVertexElement(semantic) {
			var _this$vertexFormat;
			return (_this$vertexFormat = this.vertexFormat) == null ? void 0 : _this$vertexFormat.elements.find(function (element) {
				return element.name === semantic;
			});
		};
		_proto.generateKey = function generateKey(device) {
			var key = JSON.stringify(this.uniformFormats) + JSON.stringify(this.bindGroupFormats);
			if (device.isWebGPU) {
				var _this$vertexFormat2;
				key += (_this$vertexFormat2 = this.vertexFormat) == null ? void 0 : _this$vertexFormat2.renderingHashString;
			}
			return key;
		};
		return ShaderProcessorOptions;
	}();

	var alphaTestPS = "\nuniform float alpha_ref;\n\nvoid alphaTest(float a) {\n    if (a < alpha_ref) discard;\n}\n";

	var ambientConstantPS = "\nvoid addAmbient(vec3 worldNormal) {\n    dDiffuseLight += light_globalAmbient;\n}\n";

	var ambientEnvPS = "\n#ifndef ENV_ATLAS\n#define ENV_ATLAS\nuniform sampler2D texture_envAtlas;\n#endif\n\nvoid addAmbient(vec3 worldNormal) {\n    vec3 dir = normalize(cubeMapRotate(worldNormal) * vec3(-1.0, 1.0, 1.0));\n    vec2 uv = mapUv(toSphericalUv(dir), vec4(128.0, 256.0 + 128.0, 64.0, 32.0) / atlasSize);\n\n    vec4 raw = texture2D(texture_envAtlas, uv);\n    vec3 linear = $DECODE(raw);\n    dDiffuseLight += processEnvironment(linear);\n}\n";

	var ambientSHPS = "\nuniform vec3 ambientSH[9];\n\nvoid addAmbient(vec3 worldNormal) {\n    vec3 n = cubeMapRotate(worldNormal);\n\n    vec3 color =\n        ambientSH[0] +\n        ambientSH[1] * n.x +\n        ambientSH[2] * n.y +\n        ambientSH[3] * n.z +\n        ambientSH[4] * n.x * n.z +\n        ambientSH[5] * n.z * n.y +\n        ambientSH[6] * n.y * n.x +\n        ambientSH[7] * (3.0 * n.z * n.z - 1.0) +\n        ambientSH[8] * (n.x * n.x - n.y * n.y);\n\n    dDiffuseLight += processEnvironment(max(color, vec3(0.0)));\n}\n";

	var aoPS = "\n\nvoid getAO() {\n    dAo = 1.0;\n\n    #ifdef MAPTEXTURE\n    float aoBase = texture2DBias($SAMPLER, $UV, textureBias).$CH;\n    dAo *= addAoDetail(aoBase);\n    #endif\n\n    #ifdef MAPVERTEX\n    dAo *= saturate(vVertexColor.$VC);\n    #endif\n}\n";

	var aoDetailMapPS = "\nfloat addAoDetail(float ao) {\n#ifdef MAPTEXTURE\n    float aoDetail = texture2DBias($SAMPLER, $UV, textureBias).$CH;\n    return detailMode_$DETAILMODE(vec3(ao), vec3(aoDetail)).r;\n#else\n    return ao;\n#endif\n}\n";

	var aoDiffuseOccPS = "\nvoid occludeDiffuse(float ao) {\n    dDiffuseLight *= ao;\n}\n";

	var aoSpecOccPS = "\nuniform float material_occludeSpecularIntensity;\n\nvoid occludeSpecular(float gloss, float ao, vec3 worldNormal, vec3 viewDir) {\n    // approximated specular occlusion from AO\n    float specPow = exp2(gloss * 11.0);\n    // http://research.tri-ace.com/Data/cedec2011_RealtimePBR_Implementation_e.pptx\n    float specOcc = saturate(pow(dot(worldNormal, viewDir) + ao, 0.01*specPow) - 1.0 + ao);\n    specOcc = mix(1.0, specOcc, material_occludeSpecularIntensity);\n\n    dSpecularLight *= specOcc;\n    dReflection *= specOcc;\n    \n#ifdef LIT_SHEEN\n    sSpecularLight *= specOcc;\n    sReflection *= specOcc;\n#endif\n}\n";

	var aoSpecOccConstPS = "\nvoid occludeSpecular(float gloss, float ao, vec3 worldNormal, vec3 viewDir) {\n    // approximated specular occlusion from AO\n    float specPow = exp2(gloss * 11.0);\n    // http://research.tri-ace.com/Data/cedec2011_RealtimePBR_Implementation_e.pptx\n    float specOcc = saturate(pow(dot(worldNormal, viewDir) + ao, 0.01*specPow) - 1.0 + ao);\n\n    dSpecularLight *= specOcc;\n    dReflection *= specOcc;\n    \n#ifdef LIT_SHEEN\n    sSpecularLight *= specOcc;\n    sReflection *= specOcc;\n#endif\n}\n";

	var aoSpecOccConstSimplePS = "\nvoid occludeSpecular(float gloss, float ao, vec3 worldNormal, vec3 viewDir) {\n    dSpecularLight *= ao;\n    dReflection *= ao;\n\n#ifdef LIT_SHEEN\n    sSpecularLight *= ao;\n    sReflection *= ao;\n#endif\n}\n";

	var aoSpecOccSimplePS = "\nuniform float material_occludeSpecularIntensity;\n\nvoid occludeSpecular(float gloss, float ao, vec3 worldNormal, vec3 viewDir) {\n    float specOcc = mix(1.0, ao, material_occludeSpecularIntensity);\n    dSpecularLight *= specOcc;\n    dReflection *= specOcc;\n\n#ifdef LIT_SHEEN\n    sSpecularLight *= specOcc;\n    sReflection *= specOcc;\n#endif\n}\n";

	var basePS = "\nuniform vec3 view_position;\n\nuniform vec3 light_globalAmbient;\n\nfloat square(float x) {\n    return x*x;\n}\n\nfloat saturate(float x) {\n    return clamp(x, 0.0, 1.0);\n}\n\nvec3 saturate(vec3 x) {\n    return clamp(x, vec3(0.0), vec3(1.0));\n}\n";

	var baseVS = "\nattribute vec3 vertex_position;\nattribute vec3 vertex_normal;\nattribute vec4 vertex_tangent;\nattribute vec2 vertex_texCoord0;\nattribute vec2 vertex_texCoord1;\nattribute vec4 vertex_color;\n\nuniform mat4 matrix_viewProjection;\nuniform mat4 matrix_model;\nuniform mat3 matrix_normal;\n\nvec3 dPositionW;\nmat4 dModelMatrix;\nmat3 dNormalMatrix;\n";

	var baseNineSlicedPS = "\n#define NINESLICED\n\nvarying vec2 vMask;\nvarying vec2 vTiledUv;\n\nuniform mediump vec4 innerOffset;\nuniform mediump vec2 outerScale;\nuniform mediump vec4 atlasRect;\n\nvec2 nineSlicedUv;\n";

	var baseNineSlicedVS = "\n#define NINESLICED\n\nvarying vec2 vMask;\nvarying vec2 vTiledUv;\n\nuniform mediump vec4 innerOffset;\nuniform mediump vec2 outerScale;\nuniform mediump vec4 atlasRect;\n";

	var baseNineSlicedTiledPS = "\n#define NINESLICED\n#define NINESLICETILED\n\nvarying vec2 vMask;\nvarying vec2 vTiledUv;\n\nuniform mediump vec4 innerOffset;\nuniform mediump vec2 outerScale;\nuniform mediump vec4 atlasRect;\n\nvec2 nineSlicedUv;\n";

	var biasConstPS = "\n#define SHADOWBIAS\n#define SHADOW_SAMPLE_Z_BIAS\n\nfloat getShadowBias(float resolution, float maxBias) {\n    return maxBias;\n}\n";

	var blurVSMPS = "\nvarying vec2 vUv0;\n\nuniform sampler2D source;\nuniform vec2 pixelOffset;\n\n#ifdef GAUSS\nuniform float weight[SAMPLES];\n#endif\n\n#ifdef PACKED\nfloat decodeFloatRG(vec2 rg) {\n    return rg.y*(1.0/255.0) + rg.x;\n}\n\nvec2 encodeFloatRG( float v ) {\n    vec2 enc = vec2(1.0, 255.0) * v;\n    enc = fract(enc);\n    enc -= enc.yy * vec2(1.0/255.0, 1.0/255.0);\n    return enc;\n}\n#endif\n\nvoid main(void) {\n    vec3 moments = vec3(0.0);\n    vec2 uv = vUv0 - pixelOffset * (float(SAMPLES) * 0.5);\n    for (int i=0; i<SAMPLES; i++) {\n        vec4 c = texture2D(source, uv + pixelOffset * float(i));\n\n        #ifdef PACKED\n        c.xy = vec2(decodeFloatRG(c.xy), decodeFloatRG(c.zw));\n        #endif\n\n        #ifdef GAUSS\n        moments += c.xyz * weight[i];\n        #else\n        moments += c.xyz;\n        #endif\n    }\n\n    #ifndef GAUSS\n    moments /= float(SAMPLES);\n    #endif\n\n    #ifdef PACKED\n    gl_FragColor = vec4(encodeFloatRG(moments.x), encodeFloatRG(moments.y));\n    #else\n    gl_FragColor = vec4(moments.x, moments.y, moments.z, 1.0);\n    #endif\n}\n";

	var clearCoatPS = "\n#ifdef MAPFLOAT\nuniform float material_clearCoat;\n#endif\n\nvoid getClearCoat() {\n    ccSpecularity = 1.0;\n\n    #ifdef MAPFLOAT\n    ccSpecularity *= material_clearCoat;\n    #endif\n\n    #ifdef MAPTEXTURE\n    ccSpecularity *= texture2DBias($SAMPLER, $UV, textureBias).$CH;\n    #endif\n\n    #ifdef MAPVERTEX\n    ccSpecularity *= saturate(vVertexColor.$VC);\n    #endif\n}\n";

	var clearCoatGlossPS = "\n#ifdef MAPFLOAT\nuniform float material_clearCoatGloss;\n#endif\n\nvoid getClearCoatGlossiness() {\n    ccGlossiness = 1.0;\n\n    #ifdef MAPFLOAT\n    ccGlossiness *= material_clearCoatGloss;\n    #endif\n\n    #ifdef MAPTEXTURE\n    ccGlossiness *= texture2DBias($SAMPLER, $UV, textureBias).$CH;\n    #endif\n\n    #ifdef MAPVERTEX\n    ccGlossiness *= saturate(vVertexColor.$VC);\n    #endif\n\n    #ifdef MAPINVERT\n    ccGlossiness = 1.0 - ccGlossiness;\n    #endif\n\n    ccGlossiness += 0.0000001;\n}\n";

	var clearCoatNormalPS = "\n#ifdef MAPTEXTURE\nuniform float material_clearCoatBumpiness;\n#endif\n\nvoid getClearCoatNormal() {\n#ifdef MAPTEXTURE\n    vec3 normalMap = unpackNormal(texture2DBias($SAMPLER, $UV, textureBias));\n    normalMap = mix(vec3(0.0, 0.0, 1.0), normalMap, material_clearCoatBumpiness);\n    ccNormalW = normalize(dTBN * normalMap);\n#else\n    ccNormalW = dVertexNormalW;\n#endif\n}\n";

	var clusteredLightUtilsPS = "\n// Converts unnormalized direction vector to a cubemap face index [0..5] and uv coordinates within the face in [0..1] range.\n// Additionally offset to a tile in atlas within 3x3 subdivision is provided\nvec2 getCubemapFaceCoordinates(const vec3 dir, out float faceIndex, out vec2 tileOffset)\n{\n    vec3 vAbs = abs(dir);\n    float ma;\n    vec2 uv;\n    if (vAbs.z >= vAbs.x && vAbs.z >= vAbs.y) {   // front / back\n\n        faceIndex = dir.z < 0.0 ? 5.0 : 4.0;\n        ma = 0.5 / vAbs.z;\n        uv = vec2(dir.z < 0.0 ? -dir.x : dir.x, -dir.y);\n\n        tileOffset.x = 2.0;\n        tileOffset.y = dir.z < 0.0 ? 1.0 : 0.0;\n\n    } else if(vAbs.y >= vAbs.x) {  // top index 2, bottom index 3\n\n        faceIndex = dir.y < 0.0 ? 3.0 : 2.0;\n        ma = 0.5 / vAbs.y;\n        uv = vec2(dir.x, dir.y < 0.0 ? -dir.z : dir.z);\n\n        tileOffset.x = 1.0;\n        tileOffset.y = dir.y < 0.0 ? 1.0 : 0.0;\n\n    } else {    // left / right\n\n        faceIndex = dir.x < 0.0 ? 1.0 : 0.0;\n        ma = 0.5 / vAbs.x;\n        uv = vec2(dir.x < 0.0 ? dir.z : -dir.z, -dir.y);\n\n        tileOffset.x = 0.0;\n        tileOffset.y = dir.x < 0.0 ? 1.0 : 0.0;\n\n    }\n    return uv * ma + 0.5;\n}\n\n// converts unnormalized direction vector to a texture coordinate for a cubemap face stored within texture atlas described by the viewport\nvec2 getCubemapAtlasCoordinates(const vec3 omniAtlasViewport, float shadowEdgePixels, float shadowTextureResolution, const vec3 dir) {\n\n    float faceIndex;\n    vec2 tileOffset;\n    vec2 uv = getCubemapFaceCoordinates(dir, faceIndex, tileOffset);\n\n    // move uv coordinates inwards inside to compensate for larger fov when rendering shadow into atlas\n    float atlasFaceSize = omniAtlasViewport.z;\n    float tileSize = shadowTextureResolution * atlasFaceSize;\n    float offset = shadowEdgePixels / tileSize;\n    uv = uv * vec2(1.0 - offset * 2.0) + vec2(offset * 1.0);\n\n    // scale uv coordinates to cube face area within the viewport\n    uv *= atlasFaceSize;\n\n    // offset into face of the atlas (3x3 grid)\n    uv += tileOffset * atlasFaceSize;\n\n    // offset into the atlas viewport\n    uv += omniAtlasViewport.xy;\n\n    return uv;\n}\n";

	var clusteredLightCookiesPS = "\nvec3 _getCookieClustered(TEXTURE_ACCEPT(tex), vec2 uv, float intensity, bool isRgb, vec4 cookieChannel) {\n    vec4 pixel = mix(vec4(1.0), texture2DLodEXT(tex, uv, 0.0), intensity);\n    return isRgb == true ? pixel.rgb : vec3(dot(pixel, cookieChannel));\n}\n\n// getCookie2D for clustered lighting including channel selector\nvec3 getCookie2DClustered(TEXTURE_ACCEPT(tex), mat4 transform, vec3 worldPosition, float intensity, bool isRgb, vec4 cookieChannel) {\n    vec4 projPos = transform * vec4(worldPosition, 1.0);\n    return _getCookieClustered(TEXTURE_PASS(tex), projPos.xy / projPos.w, intensity, isRgb, cookieChannel);\n}\n\n// getCookie for clustered omni light with the cookie texture being stored in the cookie atlas\nvec3 getCookieCubeClustered(TEXTURE_ACCEPT(tex), vec3 dir, float intensity, bool isRgb, vec4 cookieChannel, float shadowTextureResolution, float shadowEdgePixels, vec3 omniAtlasViewport) {\n    vec2 uv = getCubemapAtlasCoordinates(omniAtlasViewport, shadowEdgePixels, shadowTextureResolution, dir);\n    return _getCookieClustered(TEXTURE_PASS(tex), uv, intensity, isRgb, cookieChannel);\n}\n";

	var clusteredLightShadowsPS = "\n// Clustered Omni Sampling using atlas\n\n\nvoid _getShadowCoordPerspZbuffer(mat4 shadowMatrix, vec4 shadowParams, vec3 wPos) {\n    vec4 projPos = shadowMatrix * vec4(wPos, 1.0);\n    projPos.xyz /= projPos.w;\n    dShadowCoord = projPos.xyz;\n    // depth bias is already applied on render\n}\n\nvoid getShadowCoordPerspZbufferNormalOffset(mat4 shadowMatrix, vec4 shadowParams, vec3 normal) {\n    vec3 wPos = vPositionW + normal * shadowParams.y;\n    _getShadowCoordPerspZbuffer(shadowMatrix, shadowParams, wPos);\n}\n\nvec3 normalOffsetPointShadow(vec4 shadowParams, vec3 lightPos, inout vec3 lightDir, vec3 lightDirNorm, vec3 normal) {\n    float distScale = length(lightDir);\n    vec3 wPos = vPositionW + normal * shadowParams.y * clamp(1.0 - dot(normal, -lightDirNorm), 0.0, 1.0) * distScale; //0.02\n    vec3 dir = wPos - lightPos;\n    return dir;\n}\n\n#ifdef GL2\n\n    #if defined(CLUSTER_SHADOW_TYPE_PCF1)\n\n    float getShadowOmniClusteredPCF1(SHADOWMAP_ACCEPT(shadowMap), vec4 shadowParams, vec3 omniAtlasViewport, float shadowEdgePixels, vec3 lightDir) {\n\n        float shadowTextureResolution = shadowParams.x;\n        vec2 uv = getCubemapAtlasCoordinates(omniAtlasViewport, shadowEdgePixels, shadowTextureResolution, lightDir);\n\n        float shadowZ = length(lightDir) * shadowParams.w + shadowParams.z;\n        return textureShadow(shadowMap, vec3(uv, shadowZ));\n    }\n\n    #endif\n\n    #if defined(CLUSTER_SHADOW_TYPE_PCF3)\n\n    float getShadowOmniClusteredPCF3(SHADOWMAP_ACCEPT(shadowMap), vec4 shadowParams, vec3 omniAtlasViewport, float shadowEdgePixels, vec3 lightDir) {\n\n        float shadowTextureResolution = shadowParams.x;\n        vec2 uv = getCubemapAtlasCoordinates(omniAtlasViewport, shadowEdgePixels, shadowTextureResolution, lightDir);\n\n        float shadowZ = length(lightDir) * shadowParams.w + shadowParams.z;\n        vec3 shadowCoord = vec3(uv, shadowZ);\n        return getShadowPCF3x3(SHADOWMAP_PASS(shadowMap), shadowCoord, shadowParams);\n    }\n\n    #endif\n\n    #if defined(CLUSTER_SHADOW_TYPE_PCF5)\n\n    float getShadowOmniClusteredPCF5(SHADOWMAP_ACCEPT(shadowMap), vec4 shadowParams, vec3 omniAtlasViewport, float shadowEdgePixels, vec3 lightDir) {\n\n        float shadowTextureResolution = shadowParams.x;\n        vec2 uv = getCubemapAtlasCoordinates(omniAtlasViewport, shadowEdgePixels, shadowTextureResolution, lightDir);\n\n        float shadowZ = length(lightDir) * shadowParams.w + shadowParams.z;\n        vec3 shadowCoord = vec3(uv, shadowZ);\n        return getShadowPCF5x5(SHADOWMAP_PASS(shadowMap), shadowCoord, shadowParams);\n    }\n\n    #endif\n\n#else\n\n    #if defined(CLUSTER_SHADOW_TYPE_PCF1)\n\n    float getShadowOmniClusteredPCF1(sampler2D shadowMap, vec4 shadowParams, vec3 omniAtlasViewport, float shadowEdgePixels, vec3 lightDir) {\n\n        float shadowTextureResolution = shadowParams.x;\n        vec2 uv = getCubemapAtlasCoordinates(omniAtlasViewport, shadowEdgePixels, shadowTextureResolution, lightDir);\n\n        // no filter shadow sampling\n        float depth = unpackFloat(textureShadow(shadowMap, uv));\n        float shadowZ = length(lightDir) * shadowParams.w + shadowParams.z;\n        return depth > shadowZ ? 1.0 : 0.0;\n    }\n\n    #endif\n\n    #if defined(CLUSTER_SHADOW_TYPE_PCF3)\n\n    float getShadowOmniClusteredPCF3(sampler2D shadowMap, vec4 shadowParams, vec3 omniAtlasViewport, float shadowEdgePixels, vec3 lightDir) {\n\n        float shadowTextureResolution = shadowParams.x;\n        vec2 uv = getCubemapAtlasCoordinates(omniAtlasViewport, shadowEdgePixels, shadowTextureResolution, lightDir);\n\n        // pcf3\n        float shadowZ = length(lightDir) * shadowParams.w + shadowParams.z;\n        vec3 shadowCoord = vec3(uv, shadowZ);\n        return getShadowPCF3x3(shadowMap, shadowCoord, shadowParams);\n    }\n\n    #endif\n\n    #if defined(CLUSTER_SHADOW_TYPE_PCF5)\n\n    // we don't have PCF5 implementation for webgl1, use PCF3\n    float getShadowOmniClusteredPCF5(sampler2D shadowMap, vec4 shadowParams, vec3 omniAtlasViewport, float shadowEdgePixels, vec3 lightDir) {\n\n        float shadowTextureResolution = shadowParams.x;\n        vec2 uv = getCubemapAtlasCoordinates(omniAtlasViewport, shadowEdgePixels, shadowTextureResolution, lightDir);\n\n        // pcf3\n        float shadowZ = length(lightDir) * shadowParams.w + shadowParams.z;\n        vec3 shadowCoord = vec3(uv, shadowZ);\n        return getShadowPCF3x3(shadowMap, shadowCoord, shadowParams);\n    }\n\n    #endif\n\n#endif\n\n\n// Clustered Spot Sampling using atlas\n\n#ifdef GL2\n\n    #if defined(CLUSTER_SHADOW_TYPE_PCF1)\n\n    float getShadowSpotClusteredPCF1(SHADOWMAP_ACCEPT(shadowMap), vec3 shadowCoord, vec4 shadowParams) {\n        return textureShadow(shadowMap, shadowCoord);\n    }\n\n    #endif\n\n    #if defined(CLUSTER_SHADOW_TYPE_PCF3)\n\n    float getShadowSpotClusteredPCF3(SHADOWMAP_ACCEPT(shadowMap), vec3 shadowCoord, vec4 shadowParams) {\n        return getShadowSpotPCF3x3(SHADOWMAP_PASS(shadowMap), shadowCoord, shadowParams);\n    }\n\n    #endif\n\n    #if defined(CLUSTER_SHADOW_TYPE_PCF5)\n\n    float getShadowSpotClusteredPCF5(SHADOWMAP_ACCEPT(shadowMap), vec3 shadowCoord, vec4 shadowParams) {\n        return getShadowPCF5x5(SHADOWMAP_PASS(shadowMap), shadowCoord, shadowParams);\n    }\n    #endif\n\n#else\n\n    #if defined(CLUSTER_SHADOW_TYPE_PCF1)\n\n    float getShadowSpotClusteredPCF1(sampler2D shadowMap, vec3 shadowCoord, vec4 shadowParams) {\n\n        float depth = unpackFloat(textureShadow(shadowMap, shadowCoord.xy));\n\n        return depth > shadowCoord.z ? 1.0 : 0.0;\n\n    }\n\n    #endif\n\n    #if defined(CLUSTER_SHADOW_TYPE_PCF3)\n\n    float getShadowSpotClusteredPCF3(sampler2D shadowMap, vec3 shadowCoord, vec4 shadowParams) {\n        return getShadowSpotPCF3x3(shadowMap, shadowCoord, shadowParams);\n    }\n\n    #endif\n\n    #if defined(CLUSTER_SHADOW_TYPE_PCF5)\n\n    // we don't have PCF5 implementation for webgl1, use PCF3\n    float getShadowSpotClusteredPCF5(sampler2D shadowMap, vec3 shadowCoord, vec4 shadowParams) {\n        return getShadowSpotPCF3x3(shadowMap, shadowCoord, shadowParams);\n    }\n\n    #endif\n\n#endif\n";

	var clusteredLightPS = "\nuniform highp sampler2D clusterWorldTexture;\nuniform highp sampler2D lightsTexture8;\nuniform highp sampler2D lightsTextureFloat;\n\n// complex ifdef expression are not supported, handle it here\n// defined(CLUSTER_COOKIES) || defined(CLUSTER_SHADOWS)\n#if defined(CLUSTER_COOKIES)\n    #define CLUSTER_COOKIES_OR_SHADOWS\n#endif\n#if defined(CLUSTER_SHADOWS)\n    #define CLUSTER_COOKIES_OR_SHADOWS\n#endif\n\n#ifdef CLUSTER_SHADOWS\n    #ifdef GL2\n        // TODO: when VSM shadow is supported, it needs to use sampler2D in webgl2\n        uniform sampler2DShadow shadowAtlasTexture;\n    #else\n        uniform sampler2D shadowAtlasTexture;\n    #endif\n#endif\n\n#ifdef CLUSTER_COOKIES\n    uniform sampler2D cookieAtlasTexture;\n#endif\n\n#ifdef GL2\n    uniform int clusterMaxCells;\n#else\n    uniform float clusterMaxCells;\n    uniform vec4 lightsTextureInvSize;\n#endif\n\n// 1.0 if clustered lighting can be skipped (0 lights in the clusters)\nuniform float clusterSkip;\n\nuniform vec3 clusterCellsCountByBoundsSize;\nuniform vec3 clusterTextureSize;\nuniform vec3 clusterBoundsMin;\nuniform vec3 clusterBoundsDelta;\nuniform vec3 clusterCellsDot;\nuniform vec3 clusterCellsMax;\nuniform vec2 clusterCompressionLimit0;\nuniform vec2 shadowAtlasParams;\n\n// structure storing light properties of a clustered light\n// it's sorted to have all vectors aligned to 4 floats to limit padding\nstruct ClusterLightData {\n\n    // area light sizes / orientation\n    vec3 halfWidth;\n\n    // type of the light (spot or omni)\n    float lightType;\n\n    // area light sizes / orientation\n    vec3 halfHeight;\n\n    #ifdef GL2\n        // light index\n        int lightIndex;\n    #else\n        // v coordinate to look up the light textures - this is the same as lightIndex but in 0..1 range\n        float lightV;\n    #endif\n\n    // world space position\n    vec3 position;\n\n    // area light shape\n    float shape;\n\n    // world space direction (spot light only)\n    vec3 direction;\n\n    // light follow mode\n    float falloffMode;\n\n    // color\n    vec3 color;\n\n    // 0.0 if the light doesn't cast shadows\n    float shadowIntensity;\n\n    // atlas viewport for omni light shadow and cookie (.xy is offset to the viewport slot, .z is size of the face in the atlas)\n    vec3 omniAtlasViewport;\n\n    // range of the light\n    float range;\n\n    // channel mask - one of the channels has 1, the others are 0\n    vec4 cookieChannelMask;\n\n    // shadow bias values\n    float shadowBias;\n    float shadowNormalBias;\n\n    // spot light inner and outer angle cosine\n    float innerConeAngleCos;\n    float outerConeAngleCos;\n\n    // 1.0 if the light has a cookie texture\n    float cookie;\n\n    // 1.0 if cookie texture is rgb, otherwise it is using a single channel selectable by cookieChannelMask\n    float cookieRgb;\n\n    // intensity of the cookie\n    float cookieIntensity;\n\n    // light mask\n    float mask;\n};\n\n// Note: on some devices (tested on Pixel 3A XL), this matrix when stored inside the light struct has lower precision compared to\n// when stored outside, so we store it outside to avoid spot shadow flickering. This might need to be done to other / all members\n// of the structure if further similar issues are observed.\n\n// shadow (spot light only) / cookie projection matrix\nmat4 lightProjectionMatrix;\n\n// macros for light properties\n#define isClusteredLightCastShadow(light) ( light.shadowIntensity > 0.0 )\n#define isClusteredLightCookie(light) (light.cookie > 0.5 )\n#define isClusteredLightCookieRgb(light) (light.cookieRgb > 0.5 )\n#define isClusteredLightSpot(light) ( light.lightType > 0.5 )\n#define isClusteredLightFalloffLinear(light) ( light.falloffMode < 0.5 )\n\n// macros to test light shape\n// Note: Following functions need to be called serially in listed order as they do not test both '>' and '<'\n#define isClusteredLightArea(light) ( light.shape > 0.1 )\n#define isClusteredLightRect(light) ( light.shape < 0.3 )\n#define isClusteredLightDisk(light) ( light.shape < 0.6 )\n\n// macro to test light mask (mesh accepts dynamic vs lightmapped lights)\n#ifdef CLUSTER_MESH_DYNAMIC_LIGHTS\n    // accept lights marked as dynamic or both dynamic and lightmapped\n    #define acceptLightMask(light) ( light.mask < 0.75)\n#else\n    // accept lights marked as lightmapped or both dynamic and lightmapped\n    #define acceptLightMask(light) ( light.mask > 0.25)\n#endif\n\nvec4 decodeClusterLowRange4Vec4(vec4 d0, vec4 d1, vec4 d2, vec4 d3) {\n    return vec4(\n        bytes2floatRange4(d0, -2.0, 2.0),\n        bytes2floatRange4(d1, -2.0, 2.0),\n        bytes2floatRange4(d2, -2.0, 2.0),\n        bytes2floatRange4(d3, -2.0, 2.0)\n    );\n}\n\n#ifdef GL2\n\n    vec4 sampleLightsTexture8(const ClusterLightData clusterLightData, int index) {\n        return texelFetch(lightsTexture8, ivec2(index, clusterLightData.lightIndex), 0);\n    }\n\n    vec4 sampleLightTextureF(const ClusterLightData clusterLightData, int index) {\n        return texelFetch(lightsTextureFloat, ivec2(index, clusterLightData.lightIndex), 0);\n    }\n\n#else\n\n    vec4 sampleLightsTexture8(const ClusterLightData clusterLightData, float index) {\n        return texture2DLodEXT(lightsTexture8, vec2(index * lightsTextureInvSize.z, clusterLightData.lightV), 0.0);\n    }\n\n    vec4 sampleLightTextureF(const ClusterLightData clusterLightData, float index) {\n        return texture2DLodEXT(lightsTextureFloat, vec2(index * lightsTextureInvSize.x, clusterLightData.lightV), 0.0);\n    }\n\n#endif\n\nvoid decodeClusterLightCore(inout ClusterLightData clusterLightData, float lightIndex) {\n\n    // light index\n    #ifdef GL2\n        clusterLightData.lightIndex = int(lightIndex);\n    #else\n        clusterLightData.lightV = (lightIndex + 0.5) * lightsTextureInvSize.w;\n    #endif\n\n    // shared data from 8bit texture\n    vec4 lightInfo = sampleLightsTexture8(clusterLightData, CLUSTER_TEXTURE_8_FLAGS);\n    clusterLightData.lightType = lightInfo.x;\n    clusterLightData.shape = lightInfo.y;\n    clusterLightData.falloffMode = lightInfo.z;\n    clusterLightData.shadowIntensity = lightInfo.w;\n\n    // color\n    vec4 colorA = sampleLightsTexture8(clusterLightData, CLUSTER_TEXTURE_8_COLOR_A);\n    vec4 colorB = sampleLightsTexture8(clusterLightData, CLUSTER_TEXTURE_8_COLOR_B);\n    clusterLightData.color = vec3(bytes2float2(colorA.xy), bytes2float2(colorA.zw), bytes2float2(colorB.xy)) * clusterCompressionLimit0.y;\n\n    // cookie\n    clusterLightData.cookie = colorB.z;\n\n    // light mask\n    clusterLightData.mask = colorB.w;\n\n    #ifdef CLUSTER_TEXTURE_FLOAT\n\n        vec4 lightPosRange = sampleLightTextureF(clusterLightData, CLUSTER_TEXTURE_F_POSITION_RANGE);\n        clusterLightData.position = lightPosRange.xyz;\n        clusterLightData.range = lightPosRange.w;\n\n        // spot light direction\n        vec4 lightDir_Unused = sampleLightTextureF(clusterLightData, CLUSTER_TEXTURE_F_SPOT_DIRECTION);\n        clusterLightData.direction = lightDir_Unused.xyz;\n\n    #else   // 8bit\n\n        vec4 encPosX = sampleLightsTexture8(clusterLightData, CLUSTER_TEXTURE_8_POSITION_X);\n        vec4 encPosY = sampleLightsTexture8(clusterLightData, CLUSTER_TEXTURE_8_POSITION_Y);\n        vec4 encPosZ = sampleLightsTexture8(clusterLightData, CLUSTER_TEXTURE_8_POSITION_Z);\n        clusterLightData.position = vec3(bytes2float4(encPosX), bytes2float4(encPosY), bytes2float4(encPosZ)) * clusterBoundsDelta + clusterBoundsMin;\n\n        vec4 encRange = sampleLightsTexture8(clusterLightData, CLUSTER_TEXTURE_8_RANGE);\n        clusterLightData.range = bytes2float4(encRange) * clusterCompressionLimit0.x;\n\n        // spot light direction\n        vec4 encDirX = sampleLightsTexture8(clusterLightData, CLUSTER_TEXTURE_8_SPOT_DIRECTION_X);\n        vec4 encDirY = sampleLightsTexture8(clusterLightData, CLUSTER_TEXTURE_8_SPOT_DIRECTION_Y);\n        vec4 encDirZ = sampleLightsTexture8(clusterLightData, CLUSTER_TEXTURE_8_SPOT_DIRECTION_Z);\n        clusterLightData.direction = vec3(bytes2float4(encDirX), bytes2float4(encDirY), bytes2float4(encDirZ)) * 2.0 - 1.0;\n\n    #endif\n}\n\nvoid decodeClusterLightSpot(inout ClusterLightData clusterLightData) {\n\n    // spot light cos angles\n    vec4 coneAngle = sampleLightsTexture8(clusterLightData, CLUSTER_TEXTURE_8_SPOT_ANGLES);\n    clusterLightData.innerConeAngleCos = bytes2float2(coneAngle.xy) * 2.0 - 1.0;\n    clusterLightData.outerConeAngleCos = bytes2float2(coneAngle.zw) * 2.0 - 1.0;\n}\n\nvoid decodeClusterLightOmniAtlasViewport(inout ClusterLightData clusterLightData) {\n    #ifdef CLUSTER_TEXTURE_FLOAT\n        clusterLightData.omniAtlasViewport = sampleLightTextureF(clusterLightData, CLUSTER_TEXTURE_F_PROJ_MAT_0).xyz;\n    #else\n        vec4 viewportA = sampleLightsTexture8(clusterLightData, CLUSTER_TEXTURE_8_ATLAS_VIEWPORT_A);\n        vec4 viewportB = sampleLightsTexture8(clusterLightData, CLUSTER_TEXTURE_8_ATLAS_VIEWPORT_B);\n        clusterLightData.omniAtlasViewport = vec3(bytes2float2(viewportA.xy), bytes2float2(viewportA.zw), bytes2float2(viewportB.xy));\n    #endif\n}\n\nvoid decodeClusterLightAreaData(inout ClusterLightData clusterLightData) {\n    #ifdef CLUSTER_TEXTURE_FLOAT\n        clusterLightData.halfWidth = sampleLightTextureF(clusterLightData, CLUSTER_TEXTURE_F_AREA_DATA_WIDTH).xyz;\n        clusterLightData.halfHeight = sampleLightTextureF(clusterLightData, CLUSTER_TEXTURE_F_AREA_DATA_HEIGHT).xyz;\n    #else\n        vec4 areaWidthX = sampleLightsTexture8(clusterLightData, CLUSTER_TEXTURE_8_AREA_DATA_WIDTH_X);\n        vec4 areaWidthY = sampleLightsTexture8(clusterLightData, CLUSTER_TEXTURE_8_AREA_DATA_WIDTH_Y);\n        vec4 areaWidthZ = sampleLightsTexture8(clusterLightData, CLUSTER_TEXTURE_8_AREA_DATA_WIDTH_Z);\n        clusterLightData.halfWidth = vec3(mantissaExponent2Float(areaWidthX), mantissaExponent2Float(areaWidthY), mantissaExponent2Float(areaWidthZ));\n\n        vec4 areaHeightX = sampleLightsTexture8(clusterLightData, CLUSTER_TEXTURE_8_AREA_DATA_HEIGHT_X);\n        vec4 areaHeightY = sampleLightsTexture8(clusterLightData, CLUSTER_TEXTURE_8_AREA_DATA_HEIGHT_Y);\n        vec4 areaHeightZ = sampleLightsTexture8(clusterLightData, CLUSTER_TEXTURE_8_AREA_DATA_HEIGHT_Z);\n        clusterLightData.halfHeight = vec3(mantissaExponent2Float(areaHeightX), mantissaExponent2Float(areaHeightY), mantissaExponent2Float(areaHeightZ));\n    #endif\n}\n\nvoid decodeClusterLightProjectionMatrixData(inout ClusterLightData clusterLightData) {\n    \n    // shadow matrix\n    #ifdef CLUSTER_TEXTURE_FLOAT\n        vec4 m0 = sampleLightTextureF(clusterLightData, CLUSTER_TEXTURE_F_PROJ_MAT_0);\n        vec4 m1 = sampleLightTextureF(clusterLightData, CLUSTER_TEXTURE_F_PROJ_MAT_1);\n        vec4 m2 = sampleLightTextureF(clusterLightData, CLUSTER_TEXTURE_F_PROJ_MAT_2);\n        vec4 m3 = sampleLightTextureF(clusterLightData, CLUSTER_TEXTURE_F_PROJ_MAT_3);\n    #else\n        vec4 m00 = sampleLightsTexture8(clusterLightData, CLUSTER_TEXTURE_8_PROJ_MAT_00);\n        vec4 m01 = sampleLightsTexture8(clusterLightData, CLUSTER_TEXTURE_8_PROJ_MAT_01);\n        vec4 m02 = sampleLightsTexture8(clusterLightData, CLUSTER_TEXTURE_8_PROJ_MAT_02);\n        vec4 m03 = sampleLightsTexture8(clusterLightData, CLUSTER_TEXTURE_8_PROJ_MAT_03);\n        vec4 m0 = decodeClusterLowRange4Vec4(m00, m01, m02, m03);\n\n        vec4 m10 = sampleLightsTexture8(clusterLightData, CLUSTER_TEXTURE_8_PROJ_MAT_10);\n        vec4 m11 = sampleLightsTexture8(clusterLightData, CLUSTER_TEXTURE_8_PROJ_MAT_11);\n        vec4 m12 = sampleLightsTexture8(clusterLightData, CLUSTER_TEXTURE_8_PROJ_MAT_12);\n        vec4 m13 = sampleLightsTexture8(clusterLightData, CLUSTER_TEXTURE_8_PROJ_MAT_13);\n        vec4 m1 = decodeClusterLowRange4Vec4(m10, m11, m12, m13);\n\n        vec4 m20 = sampleLightsTexture8(clusterLightData, CLUSTER_TEXTURE_8_PROJ_MAT_20);\n        vec4 m21 = sampleLightsTexture8(clusterLightData, CLUSTER_TEXTURE_8_PROJ_MAT_21);\n        vec4 m22 = sampleLightsTexture8(clusterLightData, CLUSTER_TEXTURE_8_PROJ_MAT_22);\n        vec4 m23 = sampleLightsTexture8(clusterLightData, CLUSTER_TEXTURE_8_PROJ_MAT_23);\n        vec4 m2 = decodeClusterLowRange4Vec4(m20, m21, m22, m23);\n\n        vec4 m30 = sampleLightsTexture8(clusterLightData, CLUSTER_TEXTURE_8_PROJ_MAT_30);\n        vec4 m31 = sampleLightsTexture8(clusterLightData, CLUSTER_TEXTURE_8_PROJ_MAT_31);\n        vec4 m32 = sampleLightsTexture8(clusterLightData, CLUSTER_TEXTURE_8_PROJ_MAT_32);\n        vec4 m33 = sampleLightsTexture8(clusterLightData, CLUSTER_TEXTURE_8_PROJ_MAT_33);\n        vec4 m3 = vec4(mantissaExponent2Float(m30), mantissaExponent2Float(m31), mantissaExponent2Float(m32), mantissaExponent2Float(m33));\n    #endif\n    \n    lightProjectionMatrix = mat4(m0, m1, m2, m3);\n}\n\nvoid decodeClusterLightShadowData(inout ClusterLightData clusterLightData) {\n    \n    // shadow biases\n    vec4 biases = sampleLightsTexture8(clusterLightData, CLUSTER_TEXTURE_8_SHADOW_BIAS);\n    clusterLightData.shadowBias = bytes2floatRange2(biases.xy, -1.0, 20.0),\n    clusterLightData.shadowNormalBias = bytes2float2(biases.zw);\n}\n\nvoid decodeClusterLightCookieData(inout ClusterLightData clusterLightData) {\n\n    vec4 cookieA = sampleLightsTexture8(clusterLightData, CLUSTER_TEXTURE_8_COOKIE_A);\n    clusterLightData.cookieIntensity = cookieA.x;\n    clusterLightData.cookieRgb = cookieA.y;\n\n    clusterLightData.cookieChannelMask = sampleLightsTexture8(clusterLightData, CLUSTER_TEXTURE_8_COOKIE_B);\n}\n\nvoid evaluateLight(\n    ClusterLightData light, \n    vec3 worldNormal, \n    vec3 viewDir, \n    vec3 reflectionDir,\n#if defined(LIT_CLEARCOAT)\n    vec3 clearcoatReflectionDir,\n#endif\n    float gloss, \n    vec3 specularity, \n    vec3 geometricNormal, \n    mat3 tbn, \n#if defined(LIT_IRIDESCENCE)\n    vec3 iridescenceFresnel,\n#endif\n    vec3 clearcoat_worldNormal,\n    float clearcoat_gloss,\n    float sheen_gloss,\n    float iridescence_intensity\n) {\n\n    vec3 cookieAttenuation = vec3(1.0);\n    float diffuseAttenuation = 1.0;\n    float falloffAttenuation = 1.0;\n\n    // evaluate omni part of the light\n    getLightDirPoint(light.position);\n\n    #ifdef CLUSTER_AREALIGHTS\n\n    // distance attenuation\n    if (isClusteredLightArea(light)) { // area light\n\n        // area lights\n        decodeClusterLightAreaData(light);\n\n        // handle light shape\n        if (isClusteredLightRect(light)) {\n            calcRectLightValues(light.position, light.halfWidth, light.halfHeight);\n        } else if (isClusteredLightDisk(light)) {\n            calcDiskLightValues(light.position, light.halfWidth, light.halfHeight);\n        } else { // sphere\n            calcSphereLightValues(light.position, light.halfWidth, light.halfHeight);\n        }\n\n        falloffAttenuation = getFalloffWindow(light.range, dLightDirW);\n\n    } else\n\n    #endif\n\n    {   // punctual light\n\n        if (isClusteredLightFalloffLinear(light))\n            falloffAttenuation = getFalloffLinear(light.range, dLightDirW);\n        else\n            falloffAttenuation = getFalloffInvSquared(light.range, dLightDirW);\n    }\n\n    if (falloffAttenuation > 0.00001) {\n\n        #ifdef CLUSTER_AREALIGHTS\n\n        if (isClusteredLightArea(light)) { // area light\n\n            // handle light shape\n            if (isClusteredLightRect(light)) {\n                diffuseAttenuation = getRectLightDiffuse(worldNormal, viewDir, dLightDirW, dLightDirNormW) * 16.0;\n            } else if (isClusteredLightDisk(light)) {\n                diffuseAttenuation = getDiskLightDiffuse(worldNormal, viewDir, dLightDirW, dLightDirNormW) * 16.0;\n            } else { // sphere\n                diffuseAttenuation = getSphereLightDiffuse(worldNormal, viewDir, dLightDirW, dLightDirNormW) * 16.0;\n            }\n\n        } else\n\n        #endif\n\n        {\n            falloffAttenuation *= getLightDiffuse(worldNormal, viewDir, dLightDirW, dLightDirNormW); \n        }\n\n        // spot light falloff\n        if (isClusteredLightSpot(light)) {\n            decodeClusterLightSpot(light);\n            falloffAttenuation *= getSpotEffect(light.direction, light.innerConeAngleCos, light.outerConeAngleCos, dLightDirNormW);\n        }\n\n        #if defined(CLUSTER_COOKIES_OR_SHADOWS)\n\n        if (falloffAttenuation > 0.00001) {\n\n            // shadow / cookie\n            if (isClusteredLightCastShadow(light) || isClusteredLightCookie(light)) {\n\n                // shared shadow / cookie data depends on light type\n                if (isClusteredLightSpot(light)) {\n                    decodeClusterLightProjectionMatrixData(light);\n                } else {\n                    decodeClusterLightOmniAtlasViewport(light);\n                }\n\n                float shadowTextureResolution = shadowAtlasParams.x;\n                float shadowEdgePixels = shadowAtlasParams.y;\n\n                #ifdef CLUSTER_COOKIES\n\n                // cookie\n                if (isClusteredLightCookie(light)) {\n                    decodeClusterLightCookieData(light);\n\n                    if (isClusteredLightSpot(light)) {\n                        cookieAttenuation = getCookie2DClustered(TEXTURE_PASS(cookieAtlasTexture), lightProjectionMatrix, vPositionW, light.cookieIntensity, isClusteredLightCookieRgb(light), light.cookieChannelMask);\n                    } else {\n                        cookieAttenuation = getCookieCubeClustered(TEXTURE_PASS(cookieAtlasTexture), dLightDirW, light.cookieIntensity, isClusteredLightCookieRgb(light), light.cookieChannelMask, shadowTextureResolution, shadowEdgePixels, light.omniAtlasViewport);\n                    }\n                }\n\n                #endif\n\n                #ifdef CLUSTER_SHADOWS\n\n                // shadow\n                if (isClusteredLightCastShadow(light)) {\n                    decodeClusterLightShadowData(light);\n\n                    vec4 shadowParams = vec4(shadowTextureResolution, light.shadowNormalBias, light.shadowBias, 1.0 / light.range);\n\n                    if (isClusteredLightSpot(light)) {\n\n                        // spot shadow\n                        getShadowCoordPerspZbufferNormalOffset(lightProjectionMatrix, shadowParams, geometricNormal);\n                        \n                        #if defined(CLUSTER_SHADOW_TYPE_PCF1)\n                            float shadow = getShadowSpotClusteredPCF1(SHADOWMAP_PASS(shadowAtlasTexture), dShadowCoord, shadowParams);\n                        #elif defined(CLUSTER_SHADOW_TYPE_PCF3)\n                            float shadow = getShadowSpotClusteredPCF3(SHADOWMAP_PASS(shadowAtlasTexture), dShadowCoord, shadowParams);\n                        #elif defined(CLUSTER_SHADOW_TYPE_PCF5)\n                            float shadow = getShadowSpotClusteredPCF5(SHADOWMAP_PASS(shadowAtlasTexture), dShadowCoord, shadowParams);\n                        #elif defined(CLUSTER_SHADOW_TYPE_PCSS)\n                            float shadow = getShadowSpotClusteredPCSS(SHADOWMAP_PASS(shadowAtlasTexture), dShadowCoord, shadowParams);\n                        #endif\n                        falloffAttenuation *= mix(1.0, shadow, light.shadowIntensity);\n\n                    } else {\n\n                        // omni shadow\n                        vec3 dir = normalOffsetPointShadow(shadowParams, dLightPosW, dLightDirW, dLightDirNormW, geometricNormal);  // normalBias adjusted for distance\n\n                        #if defined(CLUSTER_SHADOW_TYPE_PCF1)\n                            float shadow = getShadowOmniClusteredPCF1(SHADOWMAP_PASS(shadowAtlasTexture), shadowParams, light.omniAtlasViewport, shadowEdgePixels, dir);\n                        #elif defined(CLUSTER_SHADOW_TYPE_PCF3)\n                            float shadow = getShadowOmniClusteredPCF3(SHADOWMAP_PASS(shadowAtlasTexture), shadowParams, light.omniAtlasViewport, shadowEdgePixels, dir);\n                        #elif defined(CLUSTER_SHADOW_TYPE_PCF5)\n                            float shadow = getShadowOmniClusteredPCF5(SHADOWMAP_PASS(shadowAtlasTexture), shadowParams, light.omniAtlasViewport, shadowEdgePixels, dir);\n                        #endif\n                        falloffAttenuation *= mix(1.0, shadow, light.shadowIntensity);\n                    }\n                }\n\n                #endif\n            }\n        }\n\n        #endif\n\n        // diffuse / specular / clearcoat\n        #ifdef CLUSTER_AREALIGHTS\n\n        if (isClusteredLightArea(light)) { // area light\n\n            // area light diffuse\n            {\n                vec3 areaDiffuse = (diffuseAttenuation * falloffAttenuation) * light.color * cookieAttenuation;\n\n                #if defined(LIT_SPECULAR)\n                    #if defined(LIT_CONSERVE_ENERGY)\n                        areaDiffuse = mix(areaDiffuse, vec3(0), dLTCSpecFres);\n                    #endif\n                #endif\n\n                // area light diffuse - it does not mix diffuse lighting into specular attenuation\n                dDiffuseLight += areaDiffuse;\n            }\n\n            // specular and clear coat are material settings and get included by a define based on the material\n            #ifdef LIT_SPECULAR\n\n                // area light specular\n                float areaLightSpecular;\n\n                if (isClusteredLightRect(light)) {\n                    areaLightSpecular = getRectLightSpecular(worldNormal, viewDir);\n                } else if (isClusteredLightDisk(light)) {\n                    areaLightSpecular = getDiskLightSpecular(worldNormal, viewDir);\n                } else { // sphere\n                    areaLightSpecular = getSphereLightSpecular(worldNormal, viewDir);\n                }\n\n                dSpecularLight += dLTCSpecFres * areaLightSpecular * falloffAttenuation * light.color * cookieAttenuation;\n\n                #ifdef LIT_CLEARCOAT\n\n                    // area light specular clear coat\n                    float areaLightSpecularCC;\n\n                    if (isClusteredLightRect(light)) {\n                        areaLightSpecularCC = getRectLightSpecular(clearcoat_worldNormal, viewDir);\n                    } else if (isClusteredLightDisk(light)) {\n                        areaLightSpecularCC = getDiskLightSpecular(clearcoat_worldNormal, viewDir);\n                    } else { // sphere\n                        areaLightSpecularCC = getSphereLightSpecular(clearcoat_worldNormal, viewDir);\n                    }\n\n                    ccSpecularLight += ccLTCSpecFres * areaLightSpecularCC * falloffAttenuation * light.color  * cookieAttenuation;\n\n                #endif\n\n            #endif\n\n        } else\n\n        #endif\n\n        {    // punctual light\n\n            // punctual light diffuse\n            {\n                vec3 punctualDiffuse = falloffAttenuation * light.color * cookieAttenuation;\n\n                #if defined(CLUSTER_AREALIGHTS)\n                #if defined(LIT_SPECULAR)\n                #if defined(LIT_CONSERVE_ENERGY)\n                    punctualDiffuse = mix(punctualDiffuse, vec3(0), specularity);\n                #endif\n                #endif\n                #endif\n\n                dDiffuseLight += punctualDiffuse;\n            }\n   \n            // specular and clear coat are material settings and get included by a define based on the material\n            #ifdef LIT_SPECULAR\n\n                vec3 halfDir = normalize(-dLightDirNormW + viewDir);\n                \n                // specular\n                #ifdef LIT_SPECULAR_FRESNEL\n                    dSpecularLight += \n                        getLightSpecular(halfDir, reflectionDir, worldNormal, viewDir, dLightDirNormW, gloss, tbn) * falloffAttenuation * light.color * cookieAttenuation * \n                        getFresnel(\n                            dot(viewDir, halfDir), \n                            gloss, \n                            specularity\n                        #if defined(LIT_IRIDESCENCE)\n                            , iridescenceFresnel,\n                            iridescence_intensity\n                        #endif\n                            );\n                #else\n                    dSpecularLight += getLightSpecular(halfDir, reflectionDir, worldNormal, viewDir, dLightDirNormW, gloss, tbn) * falloffAttenuation * light.color * cookieAttenuation * specularity;\n                #endif\n\n                #ifdef LIT_CLEARCOAT\n                    #ifdef LIT_SPECULAR_FRESNEL\n                        ccSpecularLight += getLightSpecular(halfDir, clearcoatReflectionDir, clearcoat_worldNormal, viewDir, dLightDirNormW, clearcoat_gloss, tbn) * falloffAttenuation * light.color * cookieAttenuation * getFresnelCC(dot(viewDir, halfDir));\n                    #else\n                        ccSpecularLight += getLightSpecular(halfDir, clearcoatReflectionDir, clearcoat_worldNormal, viewDir, dLightDirNormW, clearcoat_gloss, tbn) * falloffAttenuation * light.color * cookieAttenuation; \n                    #endif\n                #endif\n\n                #ifdef LIT_SHEEN\n                    sSpecularLight += getLightSpecularSheen(halfDir, worldNormal, viewDir, dLightDirNormW, sheen_gloss) * falloffAttenuation * light.color * cookieAttenuation;\n                #endif\n\n            #endif\n        }\n    }\n\n    // Write to global attenuation values (for lightmapper)\n    dAtten = falloffAttenuation;\n    dAttenD = diffuseAttenuation;\n    dAtten3 = cookieAttenuation;\n}\n\nvoid evaluateClusterLight(\n    float lightIndex, \n    vec3 worldNormal, \n    vec3 viewDir, \n    vec3 reflectionDir, \n#if defined(LIT_CLEARCOAT)\n    vec3 clearcoatReflectionDir,\n#endif\n    float gloss, \n    vec3 specularity, \n    vec3 geometricNormal, \n    mat3 tbn, \n#if defined(LIT_IRIDESCENCE)\n    vec3 iridescenceFresnel,\n#endif\n    vec3 clearcoat_worldNormal,\n    float clearcoat_gloss,\n    float sheen_gloss,\n    float iridescence_intensity\n) {\n\n    // decode core light data from textures\n    ClusterLightData clusterLightData;\n    decodeClusterLightCore(clusterLightData, lightIndex);\n\n    // evaluate light if it uses accepted light mask\n    if (acceptLightMask(clusterLightData))\n        evaluateLight(\n            clusterLightData, \n            worldNormal, \n            viewDir, \n            reflectionDir, \n#if defined(LIT_CLEARCOAT)\n            clearcoatReflectionDir, \n#endif\n            gloss, \n            specularity, \n            geometricNormal, \n            tbn, \n#if defined(LIT_IRIDESCENCE)\n            iridescenceFresnel,\n#endif\n            clearcoat_worldNormal,\n            clearcoat_gloss,\n            sheen_gloss,\n            iridescence_intensity\n        );\n}\n\nvoid addClusteredLights(\n    vec3 worldNormal, \n    vec3 viewDir, \n    vec3 reflectionDir, \n#if defined(LIT_CLEARCOAT)\n    vec3 clearcoatReflectionDir,\n#endif\n    float gloss, \n    vec3 specularity, \n    vec3 geometricNormal, \n    mat3 tbn, \n#if defined(LIT_IRIDESCENCE)\n    vec3 iridescenceFresnel,\n#endif\n    vec3 clearcoat_worldNormal,\n    float clearcoat_gloss,\n    float sheen_gloss,\n    float iridescence_intensity\n) {\n\n    // skip lights if no lights at all\n    if (clusterSkip > 0.5)\n        return;\n\n    // world space position to 3d integer cell cordinates in the cluster structure\n    vec3 cellCoords = floor((vPositionW - clusterBoundsMin) * clusterCellsCountByBoundsSize);\n\n    // no lighting when cell coordinate is out of range\n    if (!(any(lessThan(cellCoords, vec3(0.0))) || any(greaterThanEqual(cellCoords, clusterCellsMax)))) {\n\n        // cell index (mapping from 3d cell coordinates to linear memory)\n        float cellIndex = dot(clusterCellsDot, cellCoords);\n\n        // convert cell index to uv coordinates\n        float clusterV = floor(cellIndex * clusterTextureSize.y);\n        float clusterU = cellIndex - (clusterV * clusterTextureSize.x);\n\n        #ifdef GL2\n\n            // loop over maximum number of light cells\n            for (int lightCellIndex = 0; lightCellIndex < clusterMaxCells; lightCellIndex++) {\n\n                // using a single channel texture with data in alpha channel\n                float lightIndex = texelFetch(clusterWorldTexture, ivec2(int(clusterU) + lightCellIndex, clusterV), 0).x;\n\n                if (lightIndex <= 0.0)\n                        return;\n\n                evaluateClusterLight(\n                    lightIndex * 255.0, \n                    worldNormal, \n                    viewDir, \n                    reflectionDir,\n#if defined(LIT_CLEARCOAT)\n                    clearcoatReflectionDir,\n#endif\n                    gloss, \n                    specularity, \n                    geometricNormal, \n                    tbn, \n#if defined(LIT_IRIDESCENCE)\n                    iridescenceFresnel,\n#endif\n                    clearcoat_worldNormal,\n                    clearcoat_gloss,\n                    sheen_gloss,\n                    iridescence_intensity\n                ); \n            }\n\n        #else\n\n            clusterV = (clusterV + 0.5) * clusterTextureSize.z;\n\n            // loop over maximum possible number of supported light cells\n            const float maxLightCells = 256.0;\n            for (float lightCellIndex = 0.5; lightCellIndex < maxLightCells; lightCellIndex++) {\n\n                float lightIndex = texture2DLodEXT(clusterWorldTexture, vec2(clusterTextureSize.y * (clusterU + lightCellIndex), clusterV), 0.0).x;\n\n                if (lightIndex <= 0.0)\n                    return;\n                \n                evaluateClusterLight(\n                    lightIndex * 255.0, \n                    worldNormal, \n                    viewDir, \n                    reflectionDir,\n#if defined(LIT_CLEARCOAT)\n                    clearcoatReflectionDir,\n#endif\n                    gloss, \n                    specularity, \n                    geometricNormal, \n                    tbn, \n#if defined(LIT_IRIDESCENCE)\n                    iridescenceFresnel,\n#endif\n                    clearcoat_worldNormal,\n                    clearcoat_gloss,\n                    sheen_gloss,\n                    iridescence_intensity\n                ); \n                // end of the cell array\n                if (lightCellIndex >= clusterMaxCells) {\n                    break;\n                }\n            }\n\n        #endif\n    }\n}\n";

	var combinePS = "\nvec3 combineColor(vec3 albedo, vec3 sheenSpecularity, float clearcoatSpecularity) {\n    vec3 ret = vec3(0);\n#ifdef LIT_OLD_AMBIENT\n    ret += (dDiffuseLight - light_globalAmbient) * albedo + material_ambient * light_globalAmbient;\n#else\n    ret += albedo * dDiffuseLight;\n#endif\n#ifdef LIT_SPECULAR\n    ret += dSpecularLight;\n#endif\n#ifdef LIT_REFLECTIONS\n    ret += dReflection.rgb * dReflection.a;\n#endif\n\n#ifdef LIT_SHEEN\n    float sheenScaling = 1.0 - max(max(sheenSpecularity.r, sheenSpecularity.g), sheenSpecularity.b) * 0.157;\n    ret = ret * sheenScaling + (sSpecularLight + sReflection.rgb) * sheenSpecularity;\n#endif\n#ifdef LIT_CLEARCOAT\n    float clearCoatScaling = 1.0 - ccFresnel * clearcoatSpecularity;\n    ret = ret * clearCoatScaling + (ccSpecularLight + ccReflection.rgb) * clearcoatSpecularity;\n#endif\n\n    return ret;\n}\n";

	var cookiePS = "\n// light cookie functionality for non-clustered lights\nvec4 getCookie2D(sampler2D tex, mat4 transform, float intensity) {\n    vec4 projPos = transform * vec4(vPositionW, 1.0);\n    projPos.xy /= projPos.w;\n    return mix(vec4(1.0), texture2D(tex, projPos.xy), intensity);\n}\n\nvec4 getCookie2DClip(sampler2D tex, mat4 transform, float intensity) {\n    vec4 projPos = transform * vec4(vPositionW, 1.0);\n    projPos.xy /= projPos.w;\n    if (projPos.x < 0.0 || projPos.x > 1.0 || projPos.y < 0.0 || projPos.y > 1.0 || projPos.z < 0.0) return vec4(0.0);\n    return mix(vec4(1.0), texture2D(tex, projPos.xy), intensity);\n}\n\nvec4 getCookie2DXform(sampler2D tex, mat4 transform, float intensity, vec4 cookieMatrix, vec2 cookieOffset) {\n    vec4 projPos = transform * vec4(vPositionW, 1.0);\n    projPos.xy /= projPos.w;\n    projPos.xy += cookieOffset;\n    vec2 uv = mat2(cookieMatrix) * (projPos.xy-vec2(0.5)) + vec2(0.5);\n    return mix(vec4(1.0), texture2D(tex, uv), intensity);\n}\n\nvec4 getCookie2DClipXform(sampler2D tex, mat4 transform, float intensity, vec4 cookieMatrix, vec2 cookieOffset) {\n    vec4 projPos = transform * vec4(vPositionW, 1.0);\n    projPos.xy /= projPos.w;\n    projPos.xy += cookieOffset;\n    if (projPos.x < 0.0 || projPos.x > 1.0 || projPos.y < 0.0 || projPos.y > 1.0 || projPos.z < 0.0) return vec4(0.0);\n    vec2 uv = mat2(cookieMatrix) * (projPos.xy-vec2(0.5)) + vec2(0.5);\n    return mix(vec4(1.0), texture2D(tex, uv), intensity);\n}\n\nvec4 getCookieCube(samplerCube tex, mat4 transform, float intensity) {\n    return mix(vec4(1.0), textureCube(tex, dLightDirNormW * mat3(transform)), intensity);\n}\n";

	var cubeMapProjectBoxPS = "\nuniform vec3 envBoxMin;\nuniform vec3 envBoxMax;\n\nvec3 cubeMapProject(vec3 nrdir) {\n    nrdir = cubeMapRotate(nrdir);\n\n    vec3 rbmax = (envBoxMax - vPositionW) / nrdir;\n    vec3 rbmin = (envBoxMin - vPositionW) / nrdir;\n\n    vec3 rbminmax;\n    rbminmax.x = nrdir.x>0.0? rbmax.x : rbmin.x;\n    rbminmax.y = nrdir.y>0.0? rbmax.y : rbmin.y;\n    rbminmax.z = nrdir.z>0.0? rbmax.z : rbmin.z;\n\n    float fa = min(min(rbminmax.x, rbminmax.y), rbminmax.z);\n\n    vec3 posonbox = vPositionW + nrdir * fa;\n    vec3 envBoxPos = (envBoxMin + envBoxMax) * 0.5;\n    return normalize(posonbox - envBoxPos);\n}\n";

	var cubeMapProjectNonePS = "\nvec3 cubeMapProject(vec3 dir) {\n    return cubeMapRotate(dir);\n}\n";

	var cubeMapRotatePS = "\n#ifdef CUBEMAP_ROTATION\nuniform mat3 cubeMapRotationMatrix;\n#endif\n\nvec3 cubeMapRotate(vec3 refDir) {\n#ifdef CUBEMAP_ROTATION\n    return refDir * cubeMapRotationMatrix;\n#else\n    return refDir;\n#endif\n}\n";

	var debugOutputPS = "\n#ifdef DEBUG_ALBEDO_PASS\ngl_FragColor = vec4(gammaCorrectOutput(litArgs_albedo), 1.0);\n#endif\n\n#ifdef DEBUG_UV0_PASS\ngl_FragColor = vec4(litArgs_albedo , 1.0);\n#endif\n\n#ifdef DEBUG_WORLD_NORMAL_PASS\ngl_FragColor = vec4(litArgs_worldNormal * 0.5 + 0.5, 1.0);\n#endif\n\n#ifdef DEBUG_OPACITY_PASS\ngl_FragColor = vec4(vec3(litArgs_opacity) , 1.0);\n#endif\n\n#ifdef DEBUG_SPECULARITY_PASS\ngl_FragColor = vec4(litArgs_specularity, 1.0);\n#endif\n\n#ifdef DEBUG_GLOSS_PASS\ngl_FragColor = vec4(vec3(litArgs_gloss) , 1.0);\n#endif\n\n#ifdef DEBUG_METALNESS_PASS\ngl_FragColor = vec4(vec3(litArgs_metalness) , 1.0);\n#endif\n\n#ifdef DEBUG_AO_PASS\ngl_FragColor = vec4(vec3(litArgs_ao) , 1.0);\n#endif\n\n#ifdef DEBUG_EMISSION_PASS\ngl_FragColor = vec4(gammaCorrectOutput(litArgs_emission), 1.0);\n#endif\n";

	var debugProcessFrontendPS = "\n#ifdef DEBUG_LIGHTING_PASS\nlitArgs_albedo = vec3(0.5);\n#endif\n\n#ifdef DEBUG_UV0_PASS\n#ifdef VARYING_VUV0\nlitArgs_albedo = vec3(vUv0, 0);\n#else\nlitArgs_albedo = vec3(0);\n#endif\n#endif\n";

	var decodePS = "\nvec3 decodeLinear(vec4 raw) {\n    return raw.rgb;\n}\n\nfloat decodeGamma(float raw) {\n    return pow(raw, 2.2);\n}\n\nvec3 decodeGamma(vec3 raw) {\n    return pow(raw, vec3(2.2));\n}\n\nvec3 decodeGamma(vec4 raw) {\n    return pow(raw.xyz, vec3(2.2));\n}\n\nvec3 decodeRGBM(vec4 raw) {\n    vec3 color = (8.0 * raw.a) * raw.rgb;\n    return color * color;\n}\n\nvec3 decodeRGBP(vec4 raw) {\n    vec3 color = raw.rgb * (-raw.a * 7.0 + 8.0);\n    return color * color;\n}\n\nvec3 decodeRGBE(vec4 raw) {\n    if (raw.a == 0.0) {\n        return vec3(0.0, 0.0, 0.0);\n    } else {\n        return raw.xyz * pow(2.0, raw.w * 255.0 - 128.0);\n    }\n}\n\nvec4 passThrough(vec4 raw) {\n    return raw;\n}\n";

	var detailModesPS = "\nvec3 detailMode_mul(vec3 c1, vec3 c2) {\n    return c1 * c2;\n}\n\nvec3 detailMode_add(vec3 c1, vec3 c2) {\n    return c1 + c2;\n}\n\n// https://en.wikipedia.org/wiki/Blend_modes#Screen\nvec3 detailMode_screen(vec3 c1, vec3 c2) {\n    return 1.0 - (1.0 - c1)*(1.0 - c2);\n}\n\n// https://en.wikipedia.org/wiki/Blend_modes#Overlay\nvec3 detailMode_overlay(vec3 c1, vec3 c2) {\n    return mix(1.0 - 2.0*(1.0 - c1)*(1.0 - c2), 2.0*c1*c2, step(c1, vec3(0.5)));\n}\n\nvec3 detailMode_min(vec3 c1, vec3 c2) {\n    return min(c1, c2);\n}\n\nvec3 detailMode_max(vec3 c1, vec3 c2) {\n    return max(c1, c2);\n}\n";

	var diffusePS = "\n#ifdef MAPCOLOR\nuniform vec3 material_diffuse;\n#endif\n\nvoid getAlbedo() {\n    dAlbedo = vec3(1.0);\n\n#ifdef MAPCOLOR\n    dAlbedo *= material_diffuse.rgb;\n#endif\n\n#ifdef MAPTEXTURE\n    vec3 albedoBase = $DECODE(texture2DBias($SAMPLER, $UV, textureBias)).$CH;\n    dAlbedo *= addAlbedoDetail(albedoBase);\n#endif\n\n#ifdef MAPVERTEX\n    dAlbedo *= gammaCorrectInput(saturate(vVertexColor.$VC));\n#endif\n}\n";

	var diffuseDetailMapPS = "\nvec3 addAlbedoDetail(vec3 albedo) {\n#ifdef MAPTEXTURE\n    vec3 albedoDetail = $DECODE(texture2DBias($SAMPLER, $UV, textureBias)).$CH;\n    return detailMode_$DETAILMODE(albedo, albedoDetail);\n#else\n    return albedo;\n#endif\n}\n";

	var emissivePS = "\n#ifdef MAPCOLOR\nuniform vec3 material_emissive;\n#endif\n\n#ifdef MAPFLOAT\nuniform float material_emissiveIntensity;\n#endif\n\nvoid getEmission() {\n    dEmission = vec3(1.0);\n\n    #ifdef MAPFLOAT\n    dEmission *= material_emissiveIntensity;\n    #endif\n\n    #ifdef MAPCOLOR\n    dEmission *= material_emissive;\n    #endif\n\n    #ifdef MAPTEXTURE\n    dEmission *= $DECODE(texture2DBias($SAMPLER, $UV, textureBias)).$CH;\n    #endif\n\n    #ifdef MAPVERTEX\n    dEmission *= gammaCorrectInput(saturate(vVertexColor.$VC));\n    #endif\n}\n";

	var encodePS = "\nvec4 encodeLinear(vec3 source) {\n    return vec4(source, 1.0);\n}\n\nvec4 encodeGamma(vec3 source) {\n    return vec4(pow(source + 0.0000001, vec3(1.0 / 2.2)), 1.0);\n}\n\nvec4 encodeRGBM(vec3 source) { // modified RGBM\n    vec4 result;\n    result.rgb = pow(source.rgb, vec3(0.5));\n    result.rgb *= 1.0 / 8.0;\n\n    result.a = saturate( max( max( result.r, result.g ), max( result.b, 1.0 / 255.0 ) ) );\n    result.a = ceil(result.a * 255.0) / 255.0;\n\n    result.rgb /= result.a;\n    return result;\n}\n\nvec4 encodeRGBP(vec3 source) {\n    // convert incoming linear to gamma(ish)\n    vec3 gamma = pow(source, vec3(0.5));\n\n    // calculate the maximum component clamped to 1..8\n    float maxVal = min(8.0, max(1.0, max(gamma.x, max(gamma.y, gamma.z))));\n\n    // calculate storage factor\n    float v = 1.0 - ((maxVal - 1.0) / 7.0);\n\n    // round the value for storage in 8bit channel\n    v = ceil(v * 255.0) / 255.0;\n\n    return vec4(gamma / (-v * 7.0 + 8.0), v);    \n}\n\nvec4 encodeRGBE(vec3 source) {\n    float maxVal = max(source.x, max(source.y, source.z));\n    if (maxVal < 1e-32) {\n        return vec4(0, 0, 0, 0);\n    } else {\n        float e = ceil(log2(maxVal));\n        return vec4(source / pow(2.0, e), (e + 128.0) / 255.0);\n    }\n}\n";

	var endPS = "\n    gl_FragColor.rgb = combineColor(litArgs_albedo, litArgs_sheen_specularity, litArgs_clearcoat_specularity);\n\n    gl_FragColor.rgb += litArgs_emission;\n    gl_FragColor.rgb = addFog(gl_FragColor.rgb);\n\n    #ifndef HDR\n    gl_FragColor.rgb = toneMap(gl_FragColor.rgb);\n    gl_FragColor.rgb = gammaCorrectOutput(gl_FragColor.rgb);\n    #endif\n";

	var endVS = "\n";

	var envAtlasPS = "\n// the envAtlas is fixed at 512 pixels. every equirect is generated with 1 pixel boundary.\nconst float atlasSize = 512.0;\nconst float seamSize = 1.0 / atlasSize;\n\n// map a normalized equirect UV to the given rectangle (taking 1 pixel seam into account).\nvec2 mapUv(vec2 uv, vec4 rect) {\n    return vec2(mix(rect.x + seamSize, rect.x + rect.z - seamSize, uv.x),\n                mix(rect.y + seamSize, rect.y + rect.w - seamSize, uv.y));\n}\n\n// map a normalized equirect UV and roughness level to the correct atlas rect.\nvec2 mapRoughnessUv(vec2 uv, float level) {\n    float t = 1.0 / exp2(level);\n    return mapUv(uv, vec4(0, 1.0 - t, t, t * 0.5));\n}\n\n// map shiny level UV\nvec2 mapShinyUv(vec2 uv, float level) {\n    float t = 1.0 / exp2(level);\n    return mapUv(uv, vec4(1.0 - t, 1.0 - t, t, t * 0.5));\n}\n";

	var envConstPS = "\nvec3 processEnvironment(vec3 color) {\n    return color;\n}\n";

	var envMultiplyPS = "\nuniform float skyboxIntensity;\n\nvec3 processEnvironment(vec3 color) {\n    return color * skyboxIntensity;\n}\n";

	var extensionPS = "\n";

	var extensionVS = "\n";

	var falloffInvSquaredPS = "\nfloat getFalloffWindow(float lightRadius, vec3 lightDir) {\n    float sqrDist = dot(lightDir, lightDir);\n    float invRadius = 1.0 / lightRadius;\n    return square( saturate( 1.0 - square( sqrDist * square(invRadius) ) ) );\n}\n\nfloat getFalloffInvSquared(float lightRadius, vec3 lightDir) {\n    float sqrDist = dot(lightDir, lightDir);\n    float falloff = 1.0 / (sqrDist + 1.0);\n    float invRadius = 1.0 / lightRadius;\n\n    falloff *= 16.0;\n    falloff *= square( saturate( 1.0 - square( sqrDist * square(invRadius) ) ) );\n\n    return falloff;\n}\n";

	var falloffLinearPS = "\nfloat getFalloffLinear(float lightRadius, vec3 lightDir) {\n    float d = length(lightDir);\n    return max(((lightRadius - d) / lightRadius), 0.0);\n}\n";

	var fixCubemapSeamsNonePS = "\nvec3 fixSeams(vec3 vec, float mipmapIndex) {\n    return vec;\n}\n\nvec3 fixSeams(vec3 vec) {\n    return vec;\n}\n\nvec3 fixSeamsStatic(vec3 vec, float invRecMipSize) {\n    return vec;\n}\n\nvec3 calcSeam(vec3 vec) {\n    return vec3(0);\n}\n\nvec3 applySeam(vec3 vec, vec3 seam, float scale) {\n    return vec;\n}\n";

	var fixCubemapSeamsStretchPS = "\nvec3 fixSeams(vec3 vec, float mipmapIndex) {\n    vec3 avec = abs(vec);\n    float scale = 1.0 - exp2(mipmapIndex) / 128.0;\n    float M = max(max(avec.x, avec.y), avec.z);\n    if (avec.x != M) vec.x *= scale;\n    if (avec.y != M) vec.y *= scale;\n    if (avec.z != M) vec.z *= scale;\n    return vec;\n}\n\nvec3 fixSeams(vec3 vec) {\n    vec3 avec = abs(vec);\n    float scale = 1.0 - 1.0 / 128.0;\n    float M = max(max(avec.x, avec.y), avec.z);\n    if (avec.x != M) vec.x *= scale;\n    if (avec.y != M) vec.y *= scale;\n    if (avec.z != M) vec.z *= scale;\n    return vec;\n}\n\nvec3 fixSeamsStatic(vec3 vec, float invRecMipSize) {\n    vec3 avec = abs(vec);\n    float scale = invRecMipSize;\n    float M = max(max(avec.x, avec.y), avec.z);\n    if (avec.x != M) vec.x *= scale;\n    if (avec.y != M) vec.y *= scale;\n    if (avec.z != M) vec.z *= scale;\n    return vec;\n}\n\nvec3 calcSeam(vec3 vec) {\n    vec3 avec = abs(vec);\n    float M = max(avec.x, max(avec.y, avec.z));\n    return vec3(avec.x != M ? 1.0 : 0.0,\n                avec.y != M ? 1.0 : 0.0,\n                avec.z != M ? 1.0 : 0.0);\n}\n\nvec3 applySeam(vec3 vec, vec3 seam, float scale) {\n    return vec * (seam * -scale + vec3(1.0));\n}\n";

	var floatUnpackingPS = "\n// float unpacking functionality, complimentary to float-packing.js\nfloat bytes2float2(vec2 data) {\n    return dot(data, vec2(1.0, 1.0 / 255.0));\n}\n\nfloat bytes2float3(vec3 data) {\n    return dot(data, vec3(1.0, 1.0 / 255.0, 1.0 / 65025.0));\n}\n\nfloat bytes2float4(vec4 data) {\n    return dot(data, vec4(1.0, 1.0 / 255.0, 1.0 / 65025.0, 1.0 / 16581375.0));\n}\n\nfloat bytes2floatRange2(vec2 data, float min, float max) {\n    return mix(min, max, bytes2float2(data));\n}\n\nfloat bytes2floatRange3(vec3 data, float min, float max) {\n    return mix(min, max, bytes2float3(data));\n}\n\nfloat bytes2floatRange4(vec4 data, float min, float max) {\n    return mix(min, max, bytes2float4(data));\n}\n\nfloat mantissaExponent2Float(vec4 pack)\n{\n    float value = bytes2floatRange3(pack.xyz, -1.0, 1.0);\n    float exponent = floor(pack.w * 255.0 - 127.0);\n    return value * exp2(exponent);\n}\n";

	var fogExpPS = "\nuniform vec3 fog_color;\nuniform float fog_density;\nfloat dBlendModeFogFactor = 1.0;\n\nvec3 addFog(vec3 color) {\n    float depth = gl_FragCoord.z / gl_FragCoord.w;\n    float fogFactor = exp(-depth * fog_density);\n    fogFactor = clamp(fogFactor, 0.0, 1.0);\n    return mix(fog_color * dBlendModeFogFactor, color, fogFactor);\n}\n";

	var fogExp2PS = "\nuniform vec3 fog_color;\nuniform float fog_density;\nfloat dBlendModeFogFactor = 1.0;\n\nvec3 addFog(vec3 color) {\n    float depth = gl_FragCoord.z / gl_FragCoord.w;\n    float fogFactor = exp(-depth * depth * fog_density * fog_density);\n    fogFactor = clamp(fogFactor, 0.0, 1.0);\n    return mix(fog_color * dBlendModeFogFactor, color, fogFactor);\n}\n";

	var fogLinearPS = "\nuniform vec3 fog_color;\nuniform float fog_start;\nuniform float fog_end;\nfloat dBlendModeFogFactor = 1.0;\n\nvec3 addFog(vec3 color) {\n    float depth = gl_FragCoord.z / gl_FragCoord.w;\n    float fogFactor = (fog_end - depth) / (fog_end - fog_start);\n    fogFactor = clamp(fogFactor, 0.0, 1.0);\n    return mix(fog_color * dBlendModeFogFactor, color, fogFactor);\n}\n";

	var fogNonePS = "\nfloat dBlendModeFogFactor = 1.0;\n\nvec3 addFog(vec3 color) {\n    return color;\n}\n";

	var fresnelSchlickPS = "\n// Schlick's approximation\nvec3 getFresnel(\n        float cosTheta, \n        float gloss, \n        vec3 specularity\n#if defined(LIT_IRIDESCENCE)\n        , vec3 iridescenceFresnel, \n        float iridescenceIntensity\n#endif\n    ) {\n    float fresnel = pow(1.0 - max(cosTheta, 0.0), 5.0);\n    float glossSq = gloss * gloss;\n    vec3 ret = specularity + (max(vec3(glossSq), specularity) - specularity) * fresnel;\n#if defined(LIT_IRIDESCENCE)\n    return mix(ret, iridescenceFresnel, iridescenceIntensity);\n#else\n    return ret;\n#endif    \n}\n\nfloat getFresnelCC(float cosTheta) {\n    float fresnel = pow(1.0 - max(cosTheta, 0.0), 5.0);\n    return 0.04 + (1.0 - 0.04) * fresnel;\n}\n";

	var fullscreenQuadPS = "\nvarying vec2 vUv0;\n\nuniform sampler2D source;\n\nvoid main(void) {\n    gl_FragColor = texture2D(source, vUv0);\n}\n";

	var fullscreenQuadVS = "\nattribute vec2 vertex_position;\n\nvarying vec2 vUv0;\n\nvoid main(void)\n{\n    gl_Position = vec4(vertex_position, 0.5, 1.0);\n    vUv0 = vertex_position.xy*0.5+0.5;\n}\n";

	var gamma1_0PS = "\nfloat gammaCorrectInput(float color) {\n    return color;\n}\n\nvec3 gammaCorrectInput(vec3 color) {\n    return color;\n}\n\nvec4 gammaCorrectInput(vec4 color) {\n    return color;\n}\n\nvec3 gammaCorrectOutput(vec3 color) {\n    return color;\n}\n";

	var gamma2_2PS = "\nfloat gammaCorrectInput(float color) {\n    return decodeGamma(color);\n}\n\nvec3 gammaCorrectInput(vec3 color) {\n    return decodeGamma(color);\n}\n\nvec4 gammaCorrectInput(vec4 color) {\n    return vec4(decodeGamma(color.xyz), color.w);\n}\n\nvec3 gammaCorrectOutput(vec3 color) {\n#ifdef HDR\n    return color;\n#else\n    return pow(color + 0.0000001, vec3(1.0 / 2.2));\n#endif\n}\n";

	var glossPS = "\n#ifdef MAPFLOAT\nuniform float material_gloss;\n#endif\n\nvoid getGlossiness() {\n    dGlossiness = 1.0;\n\n    #ifdef MAPFLOAT\n    dGlossiness *= material_gloss;\n    #endif\n\n    #ifdef MAPTEXTURE\n    dGlossiness *= texture2DBias($SAMPLER, $UV, textureBias).$CH;\n    #endif\n\n    #ifdef MAPVERTEX\n    dGlossiness *= saturate(vVertexColor.$VC);\n    #endif\n\n    #ifdef MAPINVERT\n    dGlossiness = 1.0 - dGlossiness;\n    #endif\n\n    dGlossiness += 0.0000001;\n}\n";

	var iridescenceDiffractionPS = "\nuniform float material_iridescenceRefractionIndex;\n\n#ifndef PI\n#define PI 3.14159265\n#endif\n\nfloat iridescence_iorToFresnel(float transmittedIor, float incidentIor) {\n    return pow((transmittedIor - incidentIor) / (transmittedIor + incidentIor), 2.0);\n}\n\nvec3 iridescence_iorToFresnel(vec3 transmittedIor, float incidentIor) {\n    return pow((transmittedIor - vec3(incidentIor)) / (transmittedIor + vec3(incidentIor)), vec3(2.0));\n}\n\nvec3 iridescence_fresnelToIor(vec3 f0) {\n    vec3 sqrtF0 = sqrt(f0);\n    return (vec3(1.0) + sqrtF0) / (vec3(1.0) - sqrtF0);\n}\n\nvec3 iridescence_sensitivity(float opd, vec3 shift) {\n    float phase = 2.0 * PI * opd * 1.0e-9;\n    const vec3 val = vec3(5.4856e-13, 4.4201e-13, 5.2481e-13);\n    const vec3 pos = vec3(1.6810e+06, 1.7953e+06, 2.2084e+06);\n    const vec3 var = vec3(4.3278e+09, 9.3046e+09, 6.6121e+09);\n\n    vec3 xyz = val * sqrt(2.0 * PI * var) * cos(pos * phase + shift) * exp(-pow(phase, 2.0) * var);\n    xyz.x += 9.7470e-14 * sqrt(2.0 * PI * 4.5282e+09) * cos(2.2399e+06 * phase + shift[0]) * exp(-4.5282e+09 * pow(phase, 2.0));\n    xyz /= vec3(1.0685e-07);\n\n    const mat3 XYZ_TO_REC709 = mat3(\n        3.2404542, -0.9692660,  0.0556434,\n       -1.5371385,  1.8760108, -0.2040259,\n       -0.4985314,  0.0415560,  1.0572252\n    );\n\n    return XYZ_TO_REC709 * xyz;\n}\n\nfloat iridescence_fresnel(float cosTheta, float f0) {\n    float x = clamp(1.0 - cosTheta, 0.0, 1.0);\n    float x2 = x * x;\n    float x5 = x * x2 * x2;\n    return f0 + (1.0 - f0) * x5;\n} \n\nvec3 iridescence_fresnel(float cosTheta, vec3 f0) {\n    float x = clamp(1.0 - cosTheta, 0.0, 1.0);\n    float x2 = x * x;\n    float x5 = x * x2 * x2; \n    return f0 + (vec3(1.0) - f0) * x5;\n}\n\nvec3 calcIridescence(float outsideIor, float cosTheta, vec3 base_f0, float iridescenceThickness) {\n\n    float iridescenceIor = mix(outsideIor, material_iridescenceRefractionIndex, smoothstep(0.0, 0.03, iridescenceThickness));\n    float sinTheta2Sq = pow(outsideIor / iridescenceIor, 2.0) * (1.0 - pow(cosTheta, 2.0));\n    float cosTheta2Sq = 1.0 - sinTheta2Sq;\n\n    if (cosTheta2Sq < 0.0) {\n        return vec3(1.0);\n    }\n\n    float cosTheta2 = sqrt(cosTheta2Sq);\n\n    float r0 = iridescence_iorToFresnel(iridescenceIor, outsideIor);\n    float r12 = iridescence_fresnel(cosTheta, r0);\n    float r21 = r12;\n    float t121 = 1.0 - r12;\n\n    float phi12 = iridescenceIor < outsideIor ? PI : 0.0;\n    float phi21 = PI - phi12;\n\n    vec3 baseIor = iridescence_fresnelToIor(base_f0 + vec3(0.0001));\n    vec3 r1 = iridescence_iorToFresnel(baseIor, iridescenceIor);\n    vec3 r23 = iridescence_fresnel(cosTheta2, r1);\n\n    vec3 phi23 = vec3(0.0);\n    if (baseIor[0] < iridescenceIor) phi23[0] = PI;\n    if (baseIor[1] < iridescenceIor) phi23[1] = PI;\n    if (baseIor[2] < iridescenceIor) phi23[2] = PI;\n    float opd = 2.0 * iridescenceIor * iridescenceThickness * cosTheta2;\n    vec3 phi = vec3(phi21) + phi23; \n\n    vec3 r123Sq = clamp(r12 * r23, 1e-5, 0.9999);\n    vec3 r123 = sqrt(r123Sq);\n    vec3 rs = pow(t121, 2.0) * r23 / (1.0 - r123Sq);\n\n    vec3 c0 = r12 + rs;\n    vec3 i = c0;\n\n    vec3 cm = rs - t121;\n    for (int m = 1; m <= 2; m++) {\n        cm *= r123;\n        vec3 sm = 2.0 * iridescence_sensitivity(float(m) * opd, float(m) * phi);\n        i += cm * sm;\n    }\n    return max(i, vec3(0.0));\n}\n\nvec3 getIridescence(float cosTheta, vec3 specularity, float iridescenceThickness) {\n    return calcIridescence(1.0, cosTheta, specularity, iridescenceThickness);\n}\n";

	var iridescencePS = "\n#ifdef MAPFLOAT\nuniform float material_iridescence;\n#endif\n\nvoid getIridescence() {\n    float iridescence = 1.0;\n\n    #ifdef MAPFLOAT\n    iridescence *= material_iridescence;\n    #endif\n\n    #ifdef MAPTEXTURE\n    iridescence *= texture2DBias($SAMPLER, $UV, textureBias).$CH;\n    #endif\n\n    dIridescence = iridescence; \n}\n";

	var iridescenceThicknessPS = "\nuniform float material_iridescenceThicknessMax;\n\n#ifdef MAPTEXTURE\nuniform float material_iridescenceThicknessMin;\n#endif\n\nvoid getIridescenceThickness() {\n\n    #ifdef MAPTEXTURE\n    float blend = texture2DBias($SAMPLER, $UV, textureBias).$CH;\n    float iridescenceThickness = mix(material_iridescenceThicknessMin, material_iridescenceThicknessMax, blend);\n    #else\n    float iridescenceThickness = material_iridescenceThicknessMax;\n    #endif\n\n    dIridescenceThickness = iridescenceThickness; \n}\n";

	var instancingVS = "\nattribute vec4 instance_line1;\nattribute vec4 instance_line2;\nattribute vec4 instance_line3;\nattribute vec4 instance_line4;\n";

	var iorPS = "\n#ifdef MAPFLOAT\nuniform float material_refractionIndex;\n#endif\n\nvoid getIor() {\n#ifdef MAPFLOAT\n    dIor = material_refractionIndex;\n#else\n    dIor = 1.0 / 1.5;\n#endif\n}\n";

	var lightDiffuseLambertPS = "\nfloat getLightDiffuse(vec3 worldNormal, vec3 viewDir, vec3 lightDir, vec3 lightDirNorm) {\n    return max(dot(worldNormal, -lightDirNorm), 0.0);\n}\n";

	var lightDirPointPS = "\nvoid getLightDirPoint(vec3 lightPosW) {\n    dLightDirW = vPositionW - lightPosW;\n    dLightDirNormW = normalize(dLightDirW);\n    dLightPosW = lightPosW;\n}\n";

	var lightmapAddPS = "\nvoid addLightMap(\n    vec3 lightmap, \n    vec3 dir, \n    vec3 worldNormal, \n    vec3 viewDir, \n    vec3 reflectionDir, \n    float gloss, \n    vec3 specularity, \n    vec3 vertexNormal, \n    mat3 tbn\n#if defined(LIT_IRIDESCENCE)\n    vec3 iridescenceFresnel, \n    float iridescenceIntensity\n#endif\n) {\n    dDiffuseLight += lightmap;\n}\n";

	var lightmapDirAddPS = "\nvoid addLightMap(\n    vec3 lightmap, \n    vec3 dir, \n    vec3 worldNormal, \n    vec3 viewDir, \n    vec3 reflectionDir, \n    float gloss, \n    vec3 specularity, \n    vec3 vertexNormal, \n    mat3 tbn\n#if defined(LIT_IRIDESCENCE)\n    vec3 iridescenceFresnel, \n    float iridescenceIntensity\n#endif\n) {\n    if (dot(dir, dir) < 0.0001) {\n        dDiffuseLight += lightmap;\n    } else {\n        float vlight = saturate(dot(dir, -vertexNormal));\n        float flight = saturate(dot(dir, -worldNormal));\n        float nlight = (flight / max(vlight, 0.01)) * 0.5;\n\n        dDiffuseLight += lightmap * nlight * 2.0;\n\n        vec3 halfDir = normalize(-dir + viewDir);\n        vec3 specularLight = lightmap * getLightSpecular(halfDir, reflectionDir, worldNormal, viewDir, dir, gloss, tbn);\n\n#ifdef LIT_SPECULAR_FRESNEL\n        specularLight *= \n            getFresnel(dot(viewDir, halfDir), \n            gloss, \n            specularity\n        #if defined(LIT_IRIDESCENCE)\n            , iridescenceFresnel,\n            iridescenceIntensity\n        #endif\n            );\n#endif\n\n        dSpecularLight += specularLight;\n    }\n}\n";

	var lightmapDirPS = "\nuniform sampler2D texture_lightMap;\nuniform sampler2D texture_dirLightMap;\n\nvoid getLightMap() {\n    dLightmap = $DECODE(texture2DBias(texture_lightMap, $UV, textureBias)).$CH;\n\n    vec3 dir = texture2DBias(texture_dirLightMap, $UV, textureBias).xyz * 2.0 - 1.0;\n    float dirDot = dot(dir, dir);\n    dLightmapDir = (dirDot > 0.001) ? dir / sqrt(dirDot) : vec3(0.0);\n}\n";

	var lightmapSinglePS = "\nvoid getLightMap() {\n    dLightmap = vec3(1.0);\n\n    #ifdef MAPTEXTURE\n    dLightmap *= $DECODE(texture2DBias($SAMPLER, $UV, textureBias)).$CH;\n    #endif\n\n    #ifdef MAPVERTEX\n    dLightmap *= saturate(vVertexColor.$VC);\n    #endif\n}\n";

	var lightSpecularAnisoGGXPS = "\n// Anisotropic GGX\nfloat calcLightSpecular(float gloss, vec3 worldNormal, vec3 viewDir, vec3 h, vec3 lightDirNorm, mat3 tbn) {\n    float PI = 3.141592653589793;\n    float roughness = max((1.0 - gloss) * (1.0 - gloss), 0.001);\n    float anisotropy = material_anisotropy * roughness;\n \n    float at = max((roughness + anisotropy), roughness / 4.0);\n    float ab = max((roughness - anisotropy), roughness / 4.0);\n\n    float NoH = dot(worldNormal, h);\n    float ToH = dot(tbn[0], h);\n    float BoH = dot(tbn[1], h);\n\n    float a2 = at * ab;\n    vec3 v = vec3(ab * ToH, at * BoH, a2 * NoH);\n    float v2 = dot(v, v);\n    float w2 = a2 / v2;\n    float D = a2 * w2 * w2 * (1.0 / PI);\n\n    float ToV = dot(tbn[0], viewDir);\n    float BoV = dot(tbn[1], viewDir);\n    float ToL = dot(tbn[0], -lightDirNorm);\n    float BoL = dot(tbn[1], -lightDirNorm);\n    float NoV = dot(worldNormal, viewDir);\n    float NoL = dot(worldNormal, -lightDirNorm);\n\n    float lambdaV = NoL * length(vec3(at * ToV, ab * BoV, NoV));\n    float lambdaL = NoV * length(vec3(at * ToL, ab * BoL, NoL));\n    float G = 0.5 / (lambdaV + lambdaL);\n\n    return D * G;\n}\n\nfloat getLightSpecular(vec3 h, vec3 reflDir, vec3 worldNormal, vec3 viewDir, vec3 lightDirNorm, float gloss, mat3 tbn) {\n    return calcLightSpecular(gloss, worldNormal, viewDir, h, lightDirNorm, tbn);\n}\n";

	var lightSpecularBlinnPS = "\n// Energy-conserving (hopefully) Blinn-Phong\nfloat calcLightSpecular(float gloss, vec3 worldNormal, vec3 h) {\n    float nh = max( dot( h, worldNormal ), 0.0 );\n\n    float specPow = exp2(gloss * 11.0); // glossiness is linear, power is not; 0 - 2048\n\n    // Hack: On Mac OS X, calling pow with zero for the exponent generates hideous artifacts so bias up a little\n    specPow = max(specPow, 0.0001);\n\n    return pow(nh, specPow) * (specPow + 2.0) / 8.0;\n}\n\nfloat getLightSpecular(vec3 h, vec3 reflDir, vec3 worldNormal, vec3 viewDir, vec3 lightDirNorm, float gloss, mat3 tbn) {\n    return calcLightSpecular(gloss, worldNormal, h);\n}\n";

	var lightSpecularPhongPS = "\nfloat calcLightSpecular(float gloss, vec3 reflDir, vec3 lightDirNorm) {\n    float specPow = gloss;\n\n    // Hack: On Mac OS X, calling pow with zero for the exponent generates hideous artifacts so bias up a little\n    return pow(max(dot(reflDir, -lightDirNorm), 0.0), specPow + 0.0001);\n}\n\nfloat getLightSpecular(vec3 h, vec3 reflDir, vec3 worldNormal, vec3 viewDir, vec3 lightDirNorm, float gloss, mat3 tbn) {\n    return calcLightSpecular(gloss, reflDir, lightDirNorm);\n}\n";

	var lightSheenPS = "\n\nfloat sheenD(vec3 normal, vec3 h, float roughness) {\n    float invR = 1.0 / (roughness * roughness);\n    float cos2h = max(dot(normal, h), 0.0);\n    cos2h *= cos2h;\n    float sin2h = max(1.0 - cos2h, 0.0078125);\n    return (2.0 + invR) * pow(sin2h, invR * 0.5) / (2.0 * PI);\n}\n\nfloat sheenV(vec3 normal, vec3 viewDir, vec3 light) {\n    float NoV = max(dot(normal, viewDir), 0.000001);\n    float NoL = max(dot(normal, light), 0.000001);\n    return 1.0 / (4.0 * (NoL + NoV - NoL * NoV));\n}\n\nfloat getLightSpecularSheen(vec3 h, vec3 worldNormal, vec3 viewDir, vec3 lightDirNorm, float sheenGloss) {\n    float D = sheenD(worldNormal, h, sheenGloss);\n    float V = sheenV(worldNormal, viewDir, -lightDirNorm);\n    return D * V;\n}\n";

	var linearizeDepthPS = "\n\n#ifndef LINEARIZE_DEPTH\n#define LINEARIZE_DEPTH\n\nfloat linearizeDepth(float z, vec4 cameraParams) {\n    if (cameraParams.w == 0.0)\n        return (cameraParams.z * cameraParams.y) / (cameraParams.y + z * (cameraParams.z - cameraParams.y));\n    else\n        return cameraParams.z + z * (cameraParams.y - cameraParams.z);\n}\n\n#ifndef CAMERAPLANES\n#define CAMERAPLANES\nuniform vec4 camera_params; // x: 1 / camera_far,      y: camera_far,     z: camera_near,        w: is_ortho\n#endif\n\n#ifdef GL2\nfloat linearizeDepth(float z) {\n    return linearizeDepth(z, camera_params);\n}\n#else\n#ifndef UNPACKFLOAT\n#define UNPACKFLOAT\nfloat unpackFloat(vec4 rgbaDepth) {\n    const vec4 bitShift = vec4(1.0 / (256.0 * 256.0 * 256.0), 1.0 / (256.0 * 256.0), 1.0 / 256.0, 1.0);\n    return dot(rgbaDepth, bitShift);\n}\n#endif\n#endif\n#endif\n";

	var litShaderArgsPS = "\n\n// Surface albedo absorbance\nvec3 litArgs_albedo;\n\n// Transparency\nfloat litArgs_opacity;\n\n// Emission color\nvec3 litArgs_emission;\n\n// Normal direction in world space\nvec3 litArgs_worldNormal;\n\n// Ambient occlusion amount, range [0..1]\nfloat litArgs_ao;\n\n// Light map color\nvec3 litArgs_lightmap;\n\n// Light map direction\nvec3 litArgs_lightmapDir;\n\n// Surface metalness factor, range [0..1]\nfloat litArgs_metalness;\n\n// The f0 specularity factor\nvec3 litArgs_specularity;\n\n// Specularity intensity factor, range [0..1]\nfloat litArgs_specularityFactor;\n\n// The microfacet glossiness factor, range [0..1]\nfloat litArgs_gloss;\n\n// Glossiness of the sheen layer, range [0..1]\nfloat litArgs_sheen_gloss;\n\n// The color of the f0 specularity factor for the sheen layer\nvec3 litArgs_sheen_specularity;\n\n// Transmission factor (refraction), range [0..1]\nfloat litArgs_transmission;\n\n// Uniform thickness of medium, used by transmission, range [0..inf]\nfloat litArgs_thickness;\n\n// Index of refraction\nfloat litArgs_ior;\n\n// Iridescence effect intensity, range [0..1]\nfloat litArgs_iridescence_intensity;\n\n// Thickness of the iridescent microfilm layer, value is in nanometers, range [0..1000]\nfloat litArgs_iridescence_thickness;\n\n// The normal used for the clearcoat layer\nvec3 litArgs_clearcoat_worldNormal;\n\n// Intensity of the clearcoat layer, range [0..1]\nfloat litArgs_clearcoat_specularity;\n\n// Glossiness of clearcoat layer, range [0..1]\nfloat litArgs_clearcoat_gloss;\n\n";

	var ltcPS = "\n// Real-Time Polygonal-Light Shading with Linearly Transformed Cosines\n// by Eric Heitz, Jonathan Dupuy, Stephen Hill and David Neubelt\n// code: https://github.com/selfshadow/ltc_code/\n\nmat3 transposeMat3( const in mat3 m ) {\n    mat3 tmp;\n    tmp[ 0 ] = vec3( m[ 0 ].x, m[ 1 ].x, m[ 2 ].x );\n    tmp[ 1 ] = vec3( m[ 0 ].y, m[ 1 ].y, m[ 2 ].y );\n    tmp[ 2 ] = vec3( m[ 0 ].z, m[ 1 ].z, m[ 2 ].z );\n    return tmp;\n}\n\nvec2 LTC_Uv( const in vec3 N, const in vec3 V, const in float roughness ) {\n    const float LUT_SIZE = 64.0;\n    const float LUT_SCALE = ( LUT_SIZE - 1.0 ) / LUT_SIZE;\n    const float LUT_BIAS = 0.5 / LUT_SIZE;\n    float dotNV = saturate( dot( N, V ) );\n    // texture parameterized by sqrt( GGX alpha ) and sqrt( 1 - cos( theta ) )\n    vec2 uv = vec2( roughness, sqrt( 1.0 - dotNV ) );\n    uv = uv * LUT_SCALE + LUT_BIAS;\n    return uv;\n}\n\nfloat LTC_ClippedSphereFormFactor( const in vec3 f ) {\n    // Real-Time Area Lighting: a Journey from Research to Production (p.102)\n    // An approximation of the form factor of a horizon-clipped rectangle.\n    float l = length( f );\n    return max( ( l * l + f.z ) / ( l + 1.0 ), 0.0 );\n}\n\nvec3 LTC_EdgeVectorFormFactor( const in vec3 v1, const in vec3 v2 ) {\n    float x = dot( v1, v2 );\n    float y = abs( x );\n    // rational polynomial approximation to theta / sin( theta ) / 2PI\n    float a = 0.8543985 + ( 0.4965155 + 0.0145206 * y ) * y;\n    float b = 3.4175940 + ( 4.1616724 + y ) * y;\n    float v = a / b;\n    float theta_sintheta = ( x > 0.0 ) ? v : 0.5 * inversesqrt( max( 1.0 - x * x, 1e-7 ) ) - v;\n    return cross( v1, v2 ) * theta_sintheta;\n}\n\nstruct Coords {\n    vec3 coord0;\n    vec3 coord1;\n    vec3 coord2;\n    vec3 coord3;\n};\n\nfloat LTC_EvaluateRect( const in vec3 N, const in vec3 V, const in vec3 P, const in mat3 mInv, const in Coords rectCoords) {\n    // bail if point is on back side of plane of light\n    // assumes ccw winding order of light vertices\n    vec3 v1 = rectCoords.coord1 - rectCoords.coord0;\n    vec3 v2 = rectCoords.coord3 - rectCoords.coord0;\n    \n    vec3 lightNormal = cross( v1, v2 );\n    // if( dot( lightNormal, P - rectCoords.coord0 ) < 0.0 ) return 0.0;\n    float factor = sign(-dot( lightNormal, P - rectCoords.coord0 ));\n\n    // construct orthonormal basis around N\n    vec3 T1, T2;\n    T1 = normalize( V - N * dot( V, N ) );\n    T2 =  factor * cross( N, T1 ); // negated from paper; possibly due to a different handedness of world coordinate system\n    // compute transform\n    mat3 mat = mInv * transposeMat3( mat3( T1, T2, N ) );\n    // transform rect\n    vec3 coords[ 4 ];\n    coords[ 0 ] = mat * ( rectCoords.coord0 - P );\n    coords[ 1 ] = mat * ( rectCoords.coord1 - P );\n    coords[ 2 ] = mat * ( rectCoords.coord2 - P );\n    coords[ 3 ] = mat * ( rectCoords.coord3 - P );\n    // project rect onto sphere\n    coords[ 0 ] = normalize( coords[ 0 ] );\n    coords[ 1 ] = normalize( coords[ 1 ] );\n    coords[ 2 ] = normalize( coords[ 2 ] );\n    coords[ 3 ] = normalize( coords[ 3 ] );\n    // calculate vector form factor\n    vec3 vectorFormFactor = vec3( 0.0 );\n    vectorFormFactor += LTC_EdgeVectorFormFactor( coords[ 0 ], coords[ 1 ] );\n    vectorFormFactor += LTC_EdgeVectorFormFactor( coords[ 1 ], coords[ 2 ] );\n    vectorFormFactor += LTC_EdgeVectorFormFactor( coords[ 2 ], coords[ 3 ] );\n    vectorFormFactor += LTC_EdgeVectorFormFactor( coords[ 3 ], coords[ 0 ] );\n    // adjust for horizon clipping\n    float result = LTC_ClippedSphereFormFactor( vectorFormFactor );\n\n    return result;\n}\n\nCoords dLTCCoords;\nCoords getLTCLightCoords(vec3 lightPos, vec3 halfWidth, vec3 halfHeight){\n    Coords coords;\n    coords.coord0 = lightPos + halfWidth - halfHeight;\n    coords.coord1 = lightPos - halfWidth - halfHeight;\n    coords.coord2 = lightPos - halfWidth + halfHeight;\n    coords.coord3 = lightPos + halfWidth + halfHeight;\n    return coords;\n}\n\nfloat dSphereRadius;\nCoords getSphereLightCoords(vec3 lightPos, vec3 halfWidth, vec3 halfHeight){\n    // used for simple sphere light falloff\n    // also, the code only handles a spherical light, it cannot be non-uniformly scaled in world space, and so we enforce it here\n    dSphereRadius = max(length(halfWidth), length(halfHeight));\n\n    // Billboard the 2d light quad to reflection vector, as it's used for specular. This allows us to use disk math for the sphere.\n    vec3 f = reflect(normalize(lightPos - view_position), vNormalW);\n    vec3 w = normalize(cross(f, halfHeight));\n    vec3 h = normalize(cross(f, w));\n\n    return getLTCLightCoords(lightPos, w * dSphereRadius, h * dSphereRadius);\n}\n\n// used for LTC LUT texture lookup\nvec2 dLTCUV;\n#ifdef LIT_CLEARCOAT\nvec2 ccLTCUV;\n#endif\nvec2 getLTCLightUV(float gloss, vec3 worldNormal, vec3 viewDir)\n{\n    float roughness = max((1.0 - gloss) * (1.0 - gloss), 0.001);\n    return LTC_Uv( worldNormal, viewDir, roughness );\n}\n\n//used for energy conservation and to modulate specular\nvec3 dLTCSpecFres;\n#ifdef LIT_CLEARCOAT\nvec3 ccLTCSpecFres;\n#endif\nvec3 getLTCLightSpecFres(vec2 uv, vec3 specularity)\n{\n    vec4 t2 = texture2DLodEXT(areaLightsLutTex2, uv, 0.0);\n\n    #ifdef AREA_R8_G8_B8_A8_LUTS\n    t2 *= vec4(0.693103,1,1,1);\n    t2 += vec4(0.306897,0,0,0);\n    #endif\n\n    return specularity * t2.x + ( vec3( 1.0 ) - specularity) * t2.y;\n}\n\nvoid calcLTCLightValues(float gloss, vec3 worldNormal, vec3 viewDir, vec3 specularity, float clearcoatGloss, vec3 clearcoatWorldNormal, float clearcoatSpecularity)\n{\n    dLTCUV = getLTCLightUV(gloss, worldNormal, viewDir);\n    dLTCSpecFres = getLTCLightSpecFres(dLTCUV, specularity); \n\n#ifdef LIT_CLEARCOAT\n    ccLTCUV = getLTCLightUV(clearcoatGloss, clearcoatWorldNormal, viewDir);\n    ccLTCSpecFres = getLTCLightSpecFres(ccLTCUV, vec3(clearcoatSpecularity));\n#endif\n}\n\nvoid calcRectLightValues(vec3 lightPos, vec3 halfWidth, vec3 halfHeight)\n{\n    dLTCCoords = getLTCLightCoords(lightPos, halfWidth, halfHeight);\n}\nvoid calcDiskLightValues(vec3 lightPos, vec3 halfWidth, vec3 halfHeight)\n{\n    calcRectLightValues(lightPos, halfWidth, halfHeight);\n}\nvoid calcSphereLightValues(vec3 lightPos, vec3 halfWidth, vec3 halfHeight)\n{\n    dLTCCoords = getSphereLightCoords(lightPos, halfWidth, halfHeight);\n}\n\n// An extended version of the implementation from\n// \"How to solve a cubic equation, revisited\"\n// http://momentsingraphics.de/?p=105\nvec3 SolveCubic(vec4 Coefficient)\n{\n    float pi = 3.14159;\n    // Normalize the polynomial\n    Coefficient.xyz /= Coefficient.w;\n    // Divide middle coefficients by three\n    Coefficient.yz /= 3.0;\n\n    float A = Coefficient.w;\n    float B = Coefficient.z;\n    float C = Coefficient.y;\n    float D = Coefficient.x;\n\n    // Compute the Hessian and the discriminant\n    vec3 Delta = vec3(\n        -Coefficient.z * Coefficient.z + Coefficient.y,\n        -Coefficient.y * Coefficient.z + Coefficient.x,\n        dot(vec2(Coefficient.z, -Coefficient.y), Coefficient.xy)\n    );\n\n    float Discriminant = dot(vec2(4.0 * Delta.x, -Delta.y), Delta.zy);\n\n    vec3 RootsA, RootsD;\n\n    vec2 xlc, xsc;\n\n    // Algorithm A\n    {\n        float A_a = 1.0;\n        float C_a = Delta.x;\n        float D_a = -2.0 * B * Delta.x + Delta.y;\n\n        // Take the cubic root of a normalized complex number\n        float Theta = atan(sqrt(Discriminant), -D_a) / 3.0;\n\n        float x_1a = 2.0 * sqrt(-C_a) * cos(Theta);\n        float x_3a = 2.0 * sqrt(-C_a) * cos(Theta + (2.0 / 3.0) * pi);\n\n        float xl;\n        if ((x_1a + x_3a) > 2.0 * B)\n            xl = x_1a;\n        else\n            xl = x_3a;\n\n        xlc = vec2(xl - B, A);\n    }\n\n    // Algorithm D\n    {\n        float A_d = D;\n        float C_d = Delta.z;\n        float D_d = -D * Delta.y + 2.0 * C * Delta.z;\n\n        // Take the cubic root of a normalized complex number\n        float Theta = atan(D * sqrt(Discriminant), -D_d) / 3.0;\n\n        float x_1d = 2.0 * sqrt(-C_d) * cos(Theta);\n        float x_3d = 2.0 * sqrt(-C_d) * cos(Theta + (2.0 / 3.0) * pi);\n\n        float xs;\n        if (x_1d + x_3d < 2.0 * C)\n            xs = x_1d;\n        else\n            xs = x_3d;\n\n        xsc = vec2(-D, xs + C);\n    }\n\n    float E =  xlc.y * xsc.y;\n    float F = -xlc.x * xsc.y - xlc.y * xsc.x;\n    float G =  xlc.x * xsc.x;\n\n    vec2 xmc = vec2(C * F - B * G, -B * F + C * E);\n\n    vec3 Root = vec3(xsc.x / xsc.y, xmc.x / xmc.y, xlc.x / xlc.y);\n\n    if (Root.x < Root.y && Root.x < Root.z)\n        Root.xyz = Root.yxz;\n    else if (Root.z < Root.x && Root.z < Root.y)\n        Root.xyz = Root.xzy;\n\n    return Root;\n}\n\nfloat LTC_EvaluateDisk(vec3 N, vec3 V, vec3 P, mat3 Minv, Coords points)\n{\n    // construct orthonormal basis around N\n    vec3 T1, T2;\n    T1 = normalize(V - N * dot(V, N));\n    T2 = cross(N, T1);\n\n    // rotate area light in (T1, T2, N) basis\n    //mat3 R = transpose(mat3(T1, T2, N));\n    mat3 R = transposeMat3( mat3( T1, T2, N ) );\n    // polygon (allocate 5 vertices for clipping)\n    vec3 L_[ 3 ];\n    L_[ 0 ] = R * ( points.coord0 - P );\n    L_[ 1 ] = R * ( points.coord1 - P );\n    L_[ 2 ] = R * ( points.coord2 - P );\n\n    vec3 Lo_i = vec3(0);\n\n    // init ellipse\n    vec3 C  = 0.5 * (L_[0] + L_[2]);\n    vec3 V1 = 0.5 * (L_[1] - L_[2]);\n    vec3 V2 = 0.5 * (L_[1] - L_[0]);\n\n    C  = Minv * C;\n    V1 = Minv * V1;\n    V2 = Minv * V2;\n\n    //if(dot(cross(V1, V2), C) > 0.0)\n    //    return 0.0;\n\n    // compute eigenvectors of ellipse\n    float a, b;\n    float d11 = dot(V1, V1);\n    float d22 = dot(V2, V2);\n    float d12 = dot(V1, V2);\n    if (abs(d12) / sqrt(d11 * d22) > 0.0001)\n    {\n        float tr = d11 + d22;\n        float det = -d12 * d12 + d11 * d22;\n\n        // use sqrt matrix to solve for eigenvalues\n        det = sqrt(det);\n        float u = 0.5 * sqrt(tr - 2.0 * det);\n        float v = 0.5 * sqrt(tr + 2.0 * det);\n        float e_max = (u + v) * (u + v);\n        float e_min = (u - v) * (u - v);\n\n        vec3 V1_, V2_;\n\n        if (d11 > d22)\n        {\n            V1_ = d12 * V1 + (e_max - d11) * V2;\n            V2_ = d12 * V1 + (e_min - d11) * V2;\n        }\n        else\n        {\n            V1_ = d12*V2 + (e_max - d22)*V1;\n            V2_ = d12*V2 + (e_min - d22)*V1;\n        }\n\n        a = 1.0 / e_max;\n        b = 1.0 / e_min;\n        V1 = normalize(V1_);\n        V2 = normalize(V2_);\n    }\n    else\n    {\n        a = 1.0 / dot(V1, V1);\n        b = 1.0 / dot(V2, V2);\n        V1 *= sqrt(a);\n        V2 *= sqrt(b);\n    }\n\n    vec3 V3 = cross(V1, V2);\n    if (dot(C, V3) < 0.0)\n        V3 *= -1.0;\n\n    float L  = dot(V3, C);\n    float x0 = dot(V1, C) / L;\n    float y0 = dot(V2, C) / L;\n\n    float E1 = inversesqrt(a);\n    float E2 = inversesqrt(b);\n\n    a *= L * L;\n    b *= L * L;\n\n    float c0 = a * b;\n    float c1 = a * b * (1.0 + x0 * x0 + y0 * y0) - a - b;\n    float c2 = 1.0 - a * (1.0 + x0 * x0) - b * (1.0 + y0 * y0);\n    float c3 = 1.0;\n\n    vec3 roots = SolveCubic(vec4(c0, c1, c2, c3));\n    float e1 = roots.x;\n    float e2 = roots.y;\n    float e3 = roots.z;\n\n    vec3 avgDir = vec3(a * x0 / (a - e2), b * y0 / (b - e2), 1.0);\n\n    mat3 rotate = mat3(V1, V2, V3);\n\n    avgDir = rotate * avgDir;\n    avgDir = normalize(avgDir);\n\n    float L1 = sqrt(-e2 / e3);\n    float L2 = sqrt(-e2 / e1);\n\n    float formFactor = L1 * L2 * inversesqrt((1.0 + L1 * L1) * (1.0 + L2 * L2));\n    \n    const float LUT_SIZE = 64.0;\n    const float LUT_SCALE = ( LUT_SIZE - 1.0 ) / LUT_SIZE;\n    const float LUT_BIAS = 0.5 / LUT_SIZE;\n\n    // use tabulated horizon-clipped sphere\n    vec2 uv = vec2(avgDir.z * 0.5 + 0.5, formFactor);\n    uv = uv*LUT_SCALE + LUT_BIAS;\n\n    float scale = texture2DLodEXT(areaLightsLutTex2, uv, 0.0).w;\n\n    return formFactor*scale;\n}\n\nfloat getRectLightDiffuse(vec3 worldNormal, vec3 viewDir, vec3 lightDir, vec3 lightDirNorm) {\n    return LTC_EvaluateRect( worldNormal, viewDir, vPositionW, mat3( 1.0 ), dLTCCoords );\n}\n\nfloat getDiskLightDiffuse(vec3 worldNormal, vec3 viewDir, vec3 lightDir, vec3 lightDirNorm) {\n    return LTC_EvaluateDisk( worldNormal, viewDir, vPositionW, mat3( 1.0 ), dLTCCoords );\n}\n\nfloat getSphereLightDiffuse(vec3 worldNormal, vec3 viewDir, vec3 lightDir, vec3 lightDirNorm) {\n    // NB: this could be improved further with distance based wrap lighting\n    float falloff = dSphereRadius / (dot(lightDir, lightDir) + dSphereRadius);\n    return getLightDiffuse(worldNormal, viewDir, lightDir, lightDirNorm) * falloff;\n}\n\nmat3 getLTCLightInvMat(vec2 uv)\n{\n    vec4 t1 = texture2DLodEXT(areaLightsLutTex1, uv, 0.0);\n\n    #ifdef AREA_R8_G8_B8_A8_LUTS\n    t1 *= vec4(1.001, 0.3239, 0.60437568, 1.0);\n    t1 += vec4(0.0, -0.2976, -0.01381, 0.0);\n    #endif\n\n    return mat3(\n        vec3( t1.x, 0, t1.y ),\n        vec3(    0, 1,    0 ),\n        vec3( t1.z, 0, t1.w )\n    );\n}\n\nfloat calcRectLightSpecular(vec3 worldNormal, vec3 viewDir, vec2 uv) {\n    mat3 mInv = getLTCLightInvMat(uv);\n    return LTC_EvaluateRect( worldNormal, viewDir, vPositionW, mInv, dLTCCoords );\n}\n\nfloat getRectLightSpecular(vec3 worldNormal, vec3 viewDir) {\n    return calcRectLightSpecular(worldNormal, viewDir, dLTCUV);\n}\n\nfloat calcDiskLightSpecular(vec3 worldNormal, vec3 viewDir, vec2 uv) {\n    mat3 mInv = getLTCLightInvMat(uv);\n    return LTC_EvaluateDisk( worldNormal, viewDir, vPositionW, mInv, dLTCCoords );\n}\n\nfloat getDiskLightSpecular(vec3 worldNormal, vec3 viewDir) {\n    return calcDiskLightSpecular(worldNormal, viewDir, dLTCUV);\n}\n\nfloat getSphereLightSpecular(vec3 worldNormal, vec3 viewDir) {\n    return calcDiskLightSpecular(worldNormal, viewDir, dLTCUV);\n}\n";

	var metalnessPS = "\n#ifdef MAPFLOAT\nuniform float material_metalness;\n#endif\n\nvoid getMetalness() {\n    float metalness = 1.0;\n\n    #ifdef MAPFLOAT\n    metalness *= material_metalness;\n    #endif\n\n    #ifdef MAPTEXTURE\n    metalness *= texture2DBias($SAMPLER, $UV, textureBias).$CH;\n    #endif\n\n    #ifdef MAPVERTEX\n    metalness *= saturate(vVertexColor.$VC);\n    #endif\n\n    dMetalness = metalness;\n}\n";

	var msdfPS = "\nuniform sampler2D texture_msdfMap;\n\n#ifdef GL_OES_standard_derivatives\n#define USE_FWIDTH\n#endif\n\n#ifdef GL2\n#define USE_FWIDTH\n#endif\n\nfloat median(float r, float g, float b) {\n    return max(min(r, g), min(max(r, g), b));\n}\n\nfloat map (float min, float max, float v) {\n    return (v - min) / (max - min);\n}\n\nuniform float font_sdfIntensity; // intensity is used to boost the value read from the SDF, 0 is no boost, 1.0 is max boost\nuniform float font_pxrange;      // the number of pixels between inside and outside the font in SDF\nuniform float font_textureWidth; // the width of the texture atlas\n\n#ifdef UNIFORM_TEXT_PARAMETERS\nuniform vec4 outline_color;\nuniform float outline_thickness;\nuniform vec4 shadow_color;\nuniform vec2 shadow_offset;\n#else\nvarying vec4 outline_color;\nvarying float outline_thickness;\nvarying vec4 shadow_color;\nvarying vec2 shadow_offset;\n#endif\n\nvec4 applyMsdf(vec4 color) {\n    // sample the field\n    vec3 tsample = texture2D(texture_msdfMap, vUv0).rgb;\n    vec2 uvShdw = vUv0 - shadow_offset;\n    vec3 ssample = texture2D(texture_msdfMap, uvShdw).rgb;\n    // get the signed distance value\n    float sigDist = median(tsample.r, tsample.g, tsample.b);\n    float sigDistShdw = median(ssample.r, ssample.g, ssample.b);\n\n    // smoothing limit - smaller value makes for sharper but more aliased text, especially on angles\n    // too large value (0.5) creates a dark glow around the letters\n    float smoothingMax = 0.2;\n\n    #ifdef USE_FWIDTH\n    // smoothing depends on size of texture on screen\n    vec2 w = fwidth(vUv0);\n    float smoothing = clamp(w.x * font_textureWidth / font_pxrange, 0.0, smoothingMax);\n    #else\n    float font_size = 16.0; // TODO fix this\n    // smoothing gets smaller as the font size gets bigger\n    // don't have fwidth we can approximate from font size, this doesn't account for scaling\n    // so a big font scaled down will be wrong...\n    float smoothing = clamp(font_pxrange / font_size, 0.0, smoothingMax);\n    #endif\n\n    float mapMin = 0.05;\n    float mapMax = clamp(1.0 - font_sdfIntensity, mapMin, 1.0);\n\n    // remap to a smaller range (used on smaller font sizes)\n    float sigDistInner = map(mapMin, mapMax, sigDist);\n    float sigDistOutline = map(mapMin, mapMax, sigDist + outline_thickness);\n    sigDistShdw = map(mapMin, mapMax, sigDistShdw + outline_thickness);\n\n    float center = 0.5;\n    // calculate smoothing and use to generate opacity\n    float inside = smoothstep(center-smoothing, center+smoothing, sigDistInner);\n    float outline = smoothstep(center-smoothing, center+smoothing, sigDistOutline);\n    float shadow = smoothstep(center-smoothing, center+smoothing, sigDistShdw);\n\n    vec4 tcolor = (outline > inside) ? outline * vec4(outline_color.a * outline_color.rgb, outline_color.a) : vec4(0.0);\n    tcolor = mix(tcolor, color, inside);\n\n    vec4 scolor = (shadow > outline) ? shadow * vec4(shadow_color.a * shadow_color.rgb, shadow_color.a) : tcolor;\n    tcolor = mix(scolor, tcolor, outline);\n    \n    return tcolor;\n}\n";

	var metalnessModulatePS = "\n\nvec3 getSpecularModulate(in vec3 specularity, in vec3 albedo, in float metalness, in float f0) {\n    vec3 dielectricF0 = f0 * specularity;\n    return mix(dielectricF0, albedo, metalness);\n}\n\nvec3 getAlbedoModulate(in vec3 albedo, in float metalness) {\n    return albedo * (1.0 - metalness);\n}\n";

	var msdfVS = "\nattribute vec3 vertex_outlineParameters;\nattribute vec3 vertex_shadowParameters;\n\nvarying vec4 outline_color;\nvarying float outline_thickness;\nvarying vec4 shadow_color;\nvarying vec2 shadow_offset;\n\nvoid unpackMsdfParams() {\n    vec3 little = mod(vertex_outlineParameters, 256.);\n    vec3 big = (vertex_outlineParameters - little) / 256.;\n\n    outline_color.rb = little.xy / 255.;\n    outline_color.ga = big.xy / 255.;\n\n    // _outlineThicknessScale === 0.2\n    outline_thickness = little.z / 255. * 0.2;\n\n    little = mod(vertex_shadowParameters, 256.);\n    big = (vertex_shadowParameters - little) / 256.;\n\n    shadow_color.rb = little.xy / 255.;\n    shadow_color.ga = big.xy / 255.;\n\n    // vec2(little.z, big.z) / 127. - 1. remaps shadow offset from [0, 254] to [-1, 1]\n    // _shadowOffsetScale === 0.005\n    shadow_offset = (vec2(little.z, big.z) / 127. - 1.) * 0.005;\n}\n";

	var normalVS = "\n#ifdef MORPHING_TEXTURE_BASED_NORMAL\nuniform highp sampler2D morphNormalTex;\n#endif\n\nvec3 getNormal() {\n    #ifdef SKIN\n    dNormalMatrix = mat3(dModelMatrix[0].xyz, dModelMatrix[1].xyz, dModelMatrix[2].xyz);\n    #elif defined(INSTANCING)\n    dNormalMatrix = mat3(instance_line1.xyz, instance_line2.xyz, instance_line3.xyz);\n    #else\n    dNormalMatrix = matrix_normal;\n    #endif\n\n    vec3 tempNormal = vertex_normal;\n\n    #ifdef MORPHING\n    #ifdef MORPHING_NRM03\n    tempNormal += morph_weights_a[0] * morph_nrm0;\n    tempNormal += morph_weights_a[1] * morph_nrm1;\n    tempNormal += morph_weights_a[2] * morph_nrm2;\n    tempNormal += morph_weights_a[3] * morph_nrm3;\n    #endif\n    #ifdef MORPHING_NRM47\n    tempNormal += morph_weights_b[0] * morph_nrm4;\n    tempNormal += morph_weights_b[1] * morph_nrm5;\n    tempNormal += morph_weights_b[2] * morph_nrm6;\n    tempNormal += morph_weights_b[3] * morph_nrm7;\n    #endif\n    #endif\n\n    #ifdef MORPHING_TEXTURE_BASED_NORMAL\n\n        #ifdef WEBGPU\n            ivec2 morphUV = getTextureMorphCoords();\n            vec3 morphNormal = texelFetch(morphNormalTex, ivec2(morphUV), 0).xyz;\n        #else\n            vec2 morphUV = getTextureMorphCoords();\n            vec3 morphNormal = texture2D(morphNormalTex, morphUV).xyz;\n        #endif\n\n    // apply morph offset from texture\n    tempNormal += morphNormal;\n    #endif\n\n    return normalize(dNormalMatrix * tempNormal);\n}\n";

	var normalDetailMapPS = "\n#ifdef MAPTEXTURE\nuniform float material_normalDetailMapBumpiness;\n\nvec3 blendNormals(vec3 n1, vec3 n2) {\n    // https://blog.selfshadow.com/publications/blending-in-detail/#detail-oriented\n    n1 += vec3(0, 0, 1);\n    n2 *= vec3(-1, -1, 1);\n    return n1 * dot(n1, n2) / n1.z - n2;\n}\n#endif\n\nvec3 addNormalDetail(vec3 normalMap) {\n#ifdef MAPTEXTURE\n    vec3 normalDetailMap = unpackNormal(texture2DBias($SAMPLER, $UV, textureBias));\n    normalDetailMap = mix(vec3(0.0, 0.0, 1.0), normalDetailMap, material_normalDetailMapBumpiness);\n    return blendNormals(normalMap, normalDetailMap);\n#else\n    return normalMap;\n#endif\n}\n";

	var normalInstancedVS = "\nvec3 getNormal() {\n    dNormalMatrix = mat3(instance_line1.xyz, instance_line2.xyz, instance_line3.xyz);\n    return normalize(dNormalMatrix * vertex_normal);\n}\n";

	var normalMapPS = "\n#ifdef MAPTEXTURE\nuniform float material_bumpiness;\n#endif\n\nvoid getNormal() {\n#ifdef MAPTEXTURE\n    vec3 normalMap = unpackNormal(texture2DBias($SAMPLER, $UV, textureBias));\n    normalMap = mix(vec3(0.0, 0.0, 1.0), normalMap, material_bumpiness);\n    dNormalW = normalize(dTBN * addNormalDetail(normalMap));\n#else\n    dNormalW = dVertexNormalW;\n#endif\n}\n";

	var normalSkinnedVS = "\nvec3 getNormal() {\n    dNormalMatrix = mat3(dModelMatrix[0].xyz, dModelMatrix[1].xyz, dModelMatrix[2].xyz);\n    return normalize(dNormalMatrix * vertex_normal);\n}\n";

	var normalXYPS = "\nvec3 unpackNormal(vec4 nmap) {\n    vec3 normal;\n    normal.xy = nmap.wy * 2.0 - 1.0;\n    normal.z = sqrt(1.0 - saturate(dot(normal.xy, normal.xy)));\n    return normal;\n}\n";

	var normalXYZPS = "\nvec3 unpackNormal(vec4 nmap) {\n    return nmap.xyz * 2.0 - 1.0;\n}\n";

	var opacityPS = "\n#ifdef MAPFLOAT\nuniform float material_opacity;\n#endif\n\nvoid getOpacity() {\n    dAlpha = 1.0;\n\n    #ifdef MAPFLOAT\n    dAlpha *= material_opacity;\n    #endif\n\n    #ifdef MAPTEXTURE\n    dAlpha *= texture2DBias($SAMPLER, $UV, textureBias).$CH;\n    #endif\n\n    #ifdef MAPVERTEX\n    dAlpha *= clamp(vVertexColor.$VC, 0.0, 1.0);\n    #endif\n}\n";

	var outputPS = "\n";

	var outputAlphaPS = "\ngl_FragColor.a = litArgs_opacity;\n";

	var outputAlphaOpaquePS = "\n    gl_FragColor.a = 1.0;\n";

	var outputAlphaPremulPS = "\ngl_FragColor.rgb *= litArgs_opacity;\ngl_FragColor.a = litArgs_opacity;\n";

	var outputTex2DPS = "\nvarying vec2 vUv0;\n\nuniform sampler2D source;\n\nvoid main(void) {\n    gl_FragColor = texture2D(source, vUv0);\n}\n";

	var packDepthPS = "\n// Packing a float in GLSL with multiplication and mod\n// http://blog.gradientstudios.com/2012/08/23/shadow-map-improvement\nvec4 packFloat(float depth) {\n    const vec4 bit_shift = vec4(256.0 * 256.0 * 256.0, 256.0 * 256.0, 256.0, 1.0);\n    const vec4 bit_mask  = vec4(0.0, 1.0 / 256.0, 1.0 / 256.0, 1.0 / 256.0);\n\n    // combination of mod and multiplication and division works better\n    vec4 res = mod(depth * bit_shift * vec4(255), vec4(256) ) / vec4(255);\n    res -= res.xxyz * bit_mask;\n    return res;\n}\n";

	var sheenPS = "\n\n#ifdef MAPCOLOR\nuniform vec3 material_sheen;\n#endif\n\nvoid getSheen() {\n    vec3 sheenColor = vec3(1, 1, 1);\n\n    #ifdef MAPCOLOR\n    sheenColor *= material_sheen;\n    #endif\n\n    #ifdef MAPTEXTURE\n    sheenColor *= $DECODE(texture2DBias($SAMPLER, $UV, textureBias)).$CH;\n    #endif\n\n    #ifdef MAPVERTEX\n    sheenColor *= saturate(vVertexColor.$VC);\n    #endif\n\n    sSpecularity = sheenColor;\n}\n";

	var sheenGlossPS = "\n#ifdef MAPFLOAT\nuniform float material_sheenGloss;\n#endif\n\nvoid getSheenGlossiness() {\n    float sheenGlossiness = 1.0;\n\n    #ifdef MAPFLOAT\n    sheenGlossiness *= material_sheenGloss;\n    #endif\n\n    #ifdef MAPTEXTURE\n    sheenGlossiness *= texture2DBias($SAMPLER, $UV, textureBias).$CH;\n    #endif\n\n    #ifdef MAPVERTEX\n    sheenGlossiness *= saturate(vVertexColor.$VC);\n    #endif\n\n    #ifdef MAPINVERT\n    sheenGlossiness = 1.0 - sheenGlossiness;\n    #endif\n\n    sheenGlossiness += 0.0000001;\n    sGlossiness = sheenGlossiness;\n}\n";

	var parallaxPS = "\nuniform float material_heightMapFactor;\n\nvoid getParallax() {\n    float parallaxScale = material_heightMapFactor;\n\n    float height = texture2DBias($SAMPLER, $UV, textureBias).$CH;\n    height = height * parallaxScale - parallaxScale*0.5;\n    vec3 viewDirT = dViewDirW * dTBN;\n\n    viewDirT.z += 0.42;\n    dUvOffset = height * (viewDirT.xy / viewDirT.z);\n}\n";

	var particlePS = "\nvarying vec4 texCoordsAlphaLife;\n\nuniform sampler2D colorMap;\nuniform sampler2D colorParam;\nuniform float graphSampleSize;\nuniform float graphNumSamples;\n\n#ifndef CAMERAPLANES\n#define CAMERAPLANES\nuniform vec4 camera_params;\n#endif\n\nuniform float softening;\nuniform float colorMult;\n\nfloat saturate(float x) {\n    return clamp(x, 0.0, 1.0);\n}\n\n#ifndef UNPACKFLOAT\n#define UNPACKFLOAT\nfloat unpackFloat(vec4 rgbaDepth) {\n    const vec4 bitShift = vec4(1.0 / (256.0 * 256.0 * 256.0), 1.0 / (256.0 * 256.0), 1.0 / 256.0, 1.0);\n    float depth = dot(rgbaDepth, bitShift);\n    return depth;\n}\n#endif\n\nvoid main(void) {\n    vec4 tex  = gammaCorrectInput(texture2D(colorMap, vec2(texCoordsAlphaLife.x, 1.0 - texCoordsAlphaLife.y)));\n    vec4 ramp = gammaCorrectInput(texture2D(colorParam, vec2(texCoordsAlphaLife.w, 0.0)));\n    ramp.rgb *= colorMult;\n\n    ramp.a += texCoordsAlphaLife.z;\n\n    vec3 rgb = tex.rgb * ramp.rgb;\n    float a  = tex.a * ramp.a;\n";

	var particleVS = "\nvec3 unpack3NFloats(float src) {\n    float r = fract(src);\n    float g = fract(src * 256.0);\n    float b = fract(src * 65536.0);\n    return vec3(r, g, b);\n}\n\nfloat saturate(float x) {\n    return clamp(x, 0.0, 1.0);\n}\n\nvec4 tex1Dlod_lerp(highp sampler2D tex, vec2 tc) {\n    return mix( texture2D(tex,tc), texture2D(tex,tc + graphSampleSize), fract(tc.x*graphNumSamples) );\n}\n\nvec4 tex1Dlod_lerp(highp sampler2D tex, vec2 tc, out vec3 w) {\n    vec4 a = texture2D(tex,tc);\n    vec4 b = texture2D(tex,tc + graphSampleSize);\n    float c = fract(tc.x*graphNumSamples);\n\n    vec3 unpackedA = unpack3NFloats(a.w);\n    vec3 unpackedB = unpack3NFloats(b.w);\n    w = mix(unpackedA, unpackedB, c);\n\n    return mix(a, b, c);\n}\n\nvec2 rotate(vec2 quadXY, float pRotation, out mat2 rotMatrix) {\n    float c = cos(pRotation);\n    float s = sin(pRotation);\n\n    mat2 m = mat2(c, -s, s, c);\n    rotMatrix = m;\n\n    return m * quadXY;\n}\n\nvec3 billboard(vec3 InstanceCoords, vec2 quadXY) {\n    #ifdef SCREEN_SPACE\n        vec3 pos = vec3(-1, 0, 0) * quadXY.x + vec3(0, -1, 0) * quadXY.y;\n    #else\n        vec3 pos = -matrix_viewInverse[0].xyz * quadXY.x + -matrix_viewInverse[1].xyz * quadXY.y;\n    #endif\n\n    return pos;\n}\n\nvec3 customFace(vec3 InstanceCoords, vec2 quadXY) {\n    vec3 pos = faceTangent * quadXY.x + faceBinorm * quadXY.y;\n    return pos;\n}\n\nvec2 safeNormalize(vec2 v) {\n    float l = length(v);\n    return (l > 1e-06) ? v / l : v;\n}\n\nvoid main(void) {\n    vec3 meshLocalPos = particle_vertexData.xyz;\n    float id = floor(particle_vertexData.w);\n\n    float rndFactor = fract(sin(id + 1.0 + seed));\n    vec3 rndFactor3 = vec3(rndFactor, fract(rndFactor*10.0), fract(rndFactor*100.0));\n\n    float uv = id / numParticlesPot;\n    readInput(uv);\n\n#ifdef LOCAL_SPACE\n    inVel = mat3(matrix_model) * inVel;\n#endif\n    vec2 velocityV = safeNormalize((mat3(matrix_view) * inVel).xy); // should be removed by compiler if align/stretch is not used\n\n    float particleLifetime = lifetime;\n\n    if (inLife <= 0.0 || inLife > particleLifetime || !inShow) meshLocalPos = vec3(0.0);\n    vec2 quadXY = meshLocalPos.xy;\n    float nlife = clamp(inLife / particleLifetime, 0.0, 1.0);\n\n    vec3 paramDiv;\n    vec4 params = tex1Dlod_lerp(internalTex2, vec2(nlife, 0), paramDiv);\n    float scale = params.y;\n    float scaleDiv = paramDiv.x;\n    float alphaDiv = paramDiv.z;\n\n    scale += (scaleDiv * 2.0 - 1.0) * scaleDivMult * fract(rndFactor*10000.0);\n\n#ifndef USE_MESH\n    texCoordsAlphaLife = vec4(quadXY * -0.5 + 0.5, (alphaDiv * 2.0 - 1.0) * alphaDivMult * fract(rndFactor*1000.0), nlife);\n#else\n    texCoordsAlphaLife = vec4(particle_uv, (alphaDiv * 2.0 - 1.0) * alphaDivMult * fract(rndFactor*1000.0), nlife);\n#endif\n\n    vec3 particlePos = inPos;\n    vec3 particlePosMoved = vec3(0.0);\n\n    mat2 rotMatrix;\n";

	var particleAnimFrameClampVS = "\n    float animFrame = min(floor(texCoordsAlphaLife.w * animTexParams.y) + animTexParams.x, animTexParams.z);\n";

	var particleAnimFrameLoopVS = "\n    float animFrame = floor(mod(texCoordsAlphaLife.w * animTexParams.y + animTexParams.x, animTexParams.z + 1.0));\n";

	var particleAnimTexVS = "\n    float animationIndex;\n\n    if (animTexIndexParams.y == 1.0) {\n        animationIndex = floor((animTexParams.w + 1.0) * rndFactor3.z) * (animTexParams.z + 1.0);\n    } else {\n        animationIndex = animTexIndexParams.x * (animTexParams.z + 1.0);\n    }\n\n    float atlasX = (animationIndex + animFrame) * animTexTilesParams.x;\n    float atlasY = 1.0 - floor(atlasX + 1.0) * animTexTilesParams.y;\n    atlasX = fract(atlasX);\n\n    texCoordsAlphaLife.xy *= animTexTilesParams.xy;\n    texCoordsAlphaLife.xy += vec2(atlasX, atlasY);\n";

	var particleInputFloatPS = "\nvoid readInput(float uv) {\n    vec4 tex = texture2D(particleTexIN, vec2(uv, 0.25));\n    vec4 tex2 = texture2D(particleTexIN, vec2(uv, 0.75));\n\n    inPos = tex.xyz;\n    inVel = tex2.xyz;\n    inAngle = (tex.w < 0.0? -tex.w : tex.w) - 1000.0;\n    inShow = tex.w >= 0.0;\n    inLife = tex2.w;\n}\n";

	var particleInputRgba8PS = "\n//RG=X, BA=Y\n//RG=Z, BA=A\n//RGB=V, A=visMode\n//RGBA=life\n\n#define PI2 6.283185307179586\n\nuniform vec3 inBoundsSize;\nuniform vec3 inBoundsCenter;\n\nuniform float maxVel;\n\nfloat decodeFloatRG(vec2 rg) {\n    return rg.y*(1.0/255.0) + rg.x;\n}\n\nfloat decodeFloatRGBA( vec4 rgba ) {\n  return dot( rgba, vec4(1.0, 1.0/255.0, 1.0/65025.0, 1.0/160581375.0) );\n}\n\nvoid readInput(float uv) {\n    vec4 tex0 = texture2D(particleTexIN, vec2(uv, 0.125));\n    vec4 tex1 = texture2D(particleTexIN, vec2(uv, 0.375));\n    vec4 tex2 = texture2D(particleTexIN, vec2(uv, 0.625));\n    vec4 tex3 = texture2D(particleTexIN, vec2(uv, 0.875));\n\n    inPos = vec3(decodeFloatRG(tex0.rg), decodeFloatRG(tex0.ba), decodeFloatRG(tex1.rg));\n    inPos = (inPos - vec3(0.5)) * inBoundsSize + inBoundsCenter;\n\n    inVel = tex2.xyz;\n    inVel = (inVel - vec3(0.5)) * maxVel;\n\n    inAngle = decodeFloatRG(tex1.ba) * PI2;\n    inShow = tex2.a > 0.5;\n\n    inLife = decodeFloatRGBA(tex3);\n    float maxNegLife = max(lifetime, (numParticles - 1.0) * (rate+rateDiv));\n    float maxPosLife = lifetime+1.0;\n    inLife = inLife * (maxNegLife + maxPosLife) - maxNegLife;\n}\n";

	var particleOutputFloatPS = "\nvoid writeOutput() {\n    if (gl_FragCoord.y<1.0) {\n        gl_FragColor = vec4(outPos, (outAngle + 1000.0) * visMode);\n    } else {\n        gl_FragColor = vec4(outVel, outLife);\n    }\n}\n";

	var particleOutputRgba8PS = "\nuniform vec3 outBoundsMul;\nuniform vec3 outBoundsAdd;\n\nvec2 encodeFloatRG( float v ) {\n    vec2 enc = vec2(1.0, 255.0) * v;\n    enc = fract(enc);\n    enc -= enc.yy * vec2(1.0/255.0, 1.0/255.0);\n    return enc;\n}\n\nvec4 encodeFloatRGBA( float v ) {\n    vec4 enc = vec4(1.0, 255.0, 65025.0, 160581375.0) * v;\n    enc = fract(enc);\n    enc -= enc.yzww * vec4(1.0/255.0,1.0/255.0,1.0/255.0,0.0);\n    return enc;\n}\n\nvoid writeOutput() {\n    outPos = outPos * outBoundsMul + outBoundsAdd;\n    outAngle = fract(outAngle / PI2);\n\n    outVel = (outVel / maxVel) + vec3(0.5); // TODO: mul\n\n    float maxNegLife = max(lifetime, (numParticles - 1.0) * (rate+rateDiv));\n    float maxPosLife = lifetime+1.0;\n    outLife = (outLife + maxNegLife) / (maxNegLife + maxPosLife);\n\n    if (gl_FragCoord.y < 1.0) {\n        gl_FragColor = vec4(encodeFloatRG(outPos.x), encodeFloatRG(outPos.y));\n    } else if (gl_FragCoord.y < 2.0) {\n        gl_FragColor = vec4(encodeFloatRG(outPos.z), encodeFloatRG(outAngle));\n    } else if (gl_FragCoord.y < 3.0) {\n        gl_FragColor = vec4(outVel, visMode*0.5+0.5);\n    } else {\n        gl_FragColor = encodeFloatRGBA(outLife);\n    }\n}\n";

	var particleUpdaterAABBPS = "\nuniform mat3 spawnBounds;\nuniform vec3 spawnPosInnerRatio;\n\nvec3 calcSpawnPosition(vec3 inBounds, float rndFactor) {\n    vec3 pos = inBounds - vec3(0.5);\n\n    vec3 posAbs = abs(pos);\n    vec3 maxPos = vec3(max(posAbs.x, max(posAbs.y, posAbs.z)));\n\n    vec3 edge = maxPos + (vec3(0.5) - maxPos) * spawnPosInnerRatio;\n\n    pos.x = edge.x * (maxPos.x == posAbs.x ? sign(pos.x) : 2.0 * pos.x);\n    pos.y = edge.y * (maxPos.y == posAbs.y ? sign(pos.y) : 2.0 * pos.y);\n    pos.z = edge.z * (maxPos.z == posAbs.z ? sign(pos.z) : 2.0 * pos.z);\n\n#ifndef LOCAL_SPACE\n    return emitterPos + spawnBounds * pos;\n#else\n    return spawnBounds * pos;\n#endif\n}\n\nvoid addInitialVelocity(inout vec3 localVelocity, vec3 inBounds) {\n    localVelocity -= vec3(0, 0, initialVelocity);\n}\n";

	var particleUpdaterEndPS = "\n    writeOutput();\n}\n";

	var particleUpdaterInitPS = "\nvarying vec2 vUv0;\n\nuniform highp sampler2D particleTexIN;\nuniform highp sampler2D internalTex0;\nuniform highp sampler2D internalTex1;\nuniform highp sampler2D internalTex2;\nuniform highp sampler2D internalTex3;\n\nuniform mat3 emitterMatrix, emitterMatrixInv;\nuniform vec3 emitterScale;\n\nuniform vec3 emitterPos, frameRandom, localVelocityDivMult, velocityDivMult;\nuniform float delta, rate, rateDiv, lifetime, numParticles, rotSpeedDivMult, radialSpeedDivMult, seed;\nuniform float startAngle, startAngle2;\nuniform float initialVelocity;\n\nuniform float graphSampleSize;\nuniform float graphNumSamples;\n\nvec3 inPos;\nvec3 inVel;\nfloat inAngle;\nbool inShow;\nfloat inLife;\nfloat visMode;\n\nvec3 outPos;\nvec3 outVel;\nfloat outAngle;\nbool outShow;\nfloat outLife;\n";

	var particleUpdaterNoRespawnPS = "\n    if (outLife >= lifetime) {\n        outLife -= max(lifetime, (numParticles - 1.0) * particleRate);\n        visMode = -1.0;\n    }\n";

	var particleUpdaterOnStopPS = "\n    visMode = outLife < 0.0? -1.0: visMode;\n";

	var particleUpdaterRespawnPS = "\n    if (outLife >= lifetime) {\n        outLife -= max(lifetime, (numParticles - 1.0) * particleRate);\n        visMode = 1.0;\n    }\n    visMode = outLife < 0.0? 1.0: visMode;\n";

	var particleUpdaterSpherePS = "\nuniform float spawnBoundsSphere;\nuniform float spawnBoundsSphereInnerRatio;\n\nvec3 calcSpawnPosition(vec3 inBounds, float rndFactor) {\n    float rnd4 = fract(rndFactor * 1000.0);\n    vec3 norm = normalize(inBounds.xyz - vec3(0.5));\n    float r = rnd4 * (1.0 - spawnBoundsSphereInnerRatio) + spawnBoundsSphereInnerRatio;\n#ifndef LOCAL_SPACE\n    return emitterPos + norm * r * spawnBoundsSphere;\n#else\n    return norm * r * spawnBoundsSphere;\n#endif\n}\n\nvoid addInitialVelocity(inout vec3 localVelocity, vec3 inBounds) {\n    localVelocity += normalize(inBounds - vec3(0.5)) * initialVelocity;\n}\n";

	var particleUpdaterStartPS = "\nfloat saturate(float x) {\n    return clamp(x, 0.0, 1.0);\n}\n\nvec3 unpack3NFloats(float src) {\n    float r = fract(src);\n    float g = fract(src * 256.0);\n    float b = fract(src * 65536.0);\n    return vec3(r, g, b);\n}\n\nvec3 tex1Dlod_lerp(highp sampler2D tex, vec2 tc, out vec3 w) {\n    vec4 a = texture2D(tex, tc);\n    vec4 b = texture2D(tex, tc + graphSampleSize);\n    float c = fract(tc.x * graphNumSamples);\n\n    vec3 unpackedA = unpack3NFloats(a.w);\n    vec3 unpackedB = unpack3NFloats(b.w);\n    w = mix(unpackedA, unpackedB, c);\n\n    return mix(a.xyz, b.xyz, c);\n}\n\n#define HASHSCALE4 vec4(1031, .1030, .0973, .1099)\nvec4 hash41(float p) {\n    vec4 p4 = fract(vec4(p) * HASHSCALE4);\n    p4 += dot(p4, p4.wzxy+19.19);\n    return fract(vec4((p4.x + p4.y)*p4.z, (p4.x + p4.z)*p4.y, (p4.y + p4.z)*p4.w, (p4.z + p4.w)*p4.x));\n}\n\nvoid main(void) {\n    if (gl_FragCoord.x > numParticles) discard;\n\n    readInput(vUv0.x);\n    visMode = inShow? 1.0 : -1.0;\n\n    vec4 rndFactor = hash41(gl_FragCoord.x + seed);\n\n    float particleRate = rate + rateDiv * rndFactor.x;\n\n    outLife = inLife + delta;\n    float nlife = clamp(outLife / lifetime, 0.0, 1.0);\n\n    vec3 localVelocityDiv;\n    vec3 velocityDiv;\n    vec3 paramDiv;\n    vec3 localVelocity = tex1Dlod_lerp(internalTex0, vec2(nlife, 0), localVelocityDiv);\n    vec3 velocity =      tex1Dlod_lerp(internalTex1, vec2(nlife, 0), velocityDiv);\n    vec3 params =        tex1Dlod_lerp(internalTex2, vec2(nlife, 0), paramDiv);\n    float rotSpeed = params.x;\n    float rotSpeedDiv = paramDiv.y;\n\n    vec3 radialParams = tex1Dlod_lerp(internalTex3, vec2(nlife, 0), paramDiv);\n    float radialSpeed = radialParams.x;\n    float radialSpeedDiv = radialParams.y;\n\n    bool respawn = inLife <= 0.0 || outLife >= lifetime;\n    inPos = respawn ? calcSpawnPosition(rndFactor.xyz, rndFactor.x) : inPos;\n    inAngle = respawn ? mix(startAngle, startAngle2, rndFactor.x) : inAngle;\n\n#ifndef LOCAL_SPACE\n    vec3 radialVel = inPos - emitterPos;\n#else\n    vec3 radialVel = inPos;\n#endif\n    radialVel = (dot(radialVel, radialVel) > 1.0E-8) ? radialSpeed * normalize(radialVel) : vec3(0.0);\n    radialVel += (radialSpeedDiv * vec3(2.0) - vec3(1.0)) * radialSpeedDivMult * rndFactor.xyz;\n\n    localVelocity +=    (localVelocityDiv * vec3(2.0) - vec3(1.0)) * localVelocityDivMult * rndFactor.xyz;\n    velocity +=         (velocityDiv * vec3(2.0) - vec3(1.0)) * velocityDivMult * rndFactor.xyz;\n    rotSpeed +=         (rotSpeedDiv * 2.0 - 1.0) * rotSpeedDivMult * rndFactor.y;\n\n    addInitialVelocity(localVelocity, rndFactor.xyz);\n\n#ifndef LOCAL_SPACE\n    outVel = emitterMatrix * localVelocity + (radialVel + velocity) * emitterScale;\n#else\n    outVel = (localVelocity + radialVel) / emitterScale + emitterMatrixInv * velocity;\n#endif\n\n    outPos = inPos + outVel * delta;\n    outAngle = inAngle + rotSpeed * delta;\n";

	var particle_billboardVS = "\n    quadXY = rotate(quadXY, inAngle, rotMatrix);\n    vec3 localPos = billboard(particlePos, quadXY);\n";

	var particle_blendAddPS = "\n    dBlendModeFogFactor = 0.0;\n    rgb *= saturate(gammaCorrectInput(max(a, 0.0)));\n    if ((rgb.r + rgb.g + rgb.b) < 0.000001) discard;\n";

	var particle_blendMultiplyPS = "\n    rgb = mix(vec3(1.0), rgb, vec3(a));\n    if (rgb.r + rgb.g + rgb.b > 2.99) discard;\n";

	var particle_blendNormalPS = "\n    if (a < 0.01) discard;\n";

	var particle_cpuVS = "\nattribute vec4 particle_vertexData;   // XYZ = world pos, W = life\nattribute vec4 particle_vertexData2;  // X = angle, Y = scale, Z = alpha, W = velocity.x\nattribute vec4 particle_vertexData3;  // XYZ = particle local pos, W = velocity.y\nattribute float particle_vertexData4; // particle id\n\n// type depends on useMesh property. Start with X = velocity.z, Y = particle ID and for mesh particles proceeds with Z = mesh UV.x, W = mesh UV.y\n#ifndef USE_MESH\nattribute vec2 particle_vertexData5;\n#else\nattribute vec4 particle_vertexData5;\n#endif\n\nuniform mat4 matrix_viewProjection;\nuniform mat4 matrix_model;\n\n#ifndef VIEWMATRIX\n#define VIEWMATRIX\nuniform mat4 matrix_view;\n#endif\n\nuniform mat3 matrix_normal;\nuniform mat4 matrix_viewInverse;\n\nuniform float numParticles;\nuniform float lifetime;\nuniform float stretch;\nuniform float seed;\nuniform vec3 wrapBounds;\nuniform vec3 emitterScale;\nuniform vec3 faceTangent;\nuniform vec3 faceBinorm;\nuniform highp sampler2D internalTex0;\nuniform highp sampler2D internalTex1;\nuniform highp sampler2D internalTex2;\nuniform vec3 emitterPos;\n\nvarying vec4 texCoordsAlphaLife;\n\nvec2 rotate(vec2 quadXY, float pRotation, out mat2 rotMatrix)\n{\n    float c = cos(pRotation);\n    float s = sin(pRotation);\n    //vec4 rotationMatrix = vec4(c, -s, s, c);\n\n    mat2 m = mat2(c, -s, s, c);\n    rotMatrix = m;\n\n    return m * quadXY;\n}\n\nvec3 billboard(vec3 InstanceCoords, vec2 quadXY)\n{\n    vec3 pos = -matrix_viewInverse[0].xyz * quadXY.x + -matrix_viewInverse[1].xyz * quadXY.y;\n    return pos;\n}\n\nvec3 customFace(vec3 InstanceCoords, vec2 quadXY)\n{\n    vec3 pos = faceTangent * quadXY.x + faceBinorm * quadXY.y;\n    return pos;\n}\n\nvoid main(void)\n{\n    vec3 particlePos = particle_vertexData.xyz;\n    vec3 inPos = particlePos;\n    vec3 vertPos = particle_vertexData3.xyz;\n    vec3 inVel = vec3(particle_vertexData2.w, particle_vertexData3.w, particle_vertexData5.x);\n\n    float id = floor(particle_vertexData4);\n    float rndFactor = fract(sin(id + 1.0 + seed));\n    vec3 rndFactor3 = vec3(rndFactor, fract(rndFactor*10.0), fract(rndFactor*100.0));\n\n#ifdef LOCAL_SPACE\n    inVel = mat3(matrix_model) * inVel;\n#endif\n    vec2 velocityV = normalize((mat3(matrix_view) * inVel).xy); // should be removed by compiler if align/stretch is not used\n\n    vec2 quadXY = vertPos.xy;\n\n#ifdef USE_MESH\n    texCoordsAlphaLife = vec4(particle_vertexData5.zw, particle_vertexData2.z, particle_vertexData.w);\n#else\n    texCoordsAlphaLife = vec4(quadXY * -0.5 + 0.5, particle_vertexData2.z, particle_vertexData.w);\n#endif\n    mat2 rotMatrix;\n\n    float inAngle = particle_vertexData2.x;\n    vec3 particlePosMoved = vec3(0.0);\n    vec3 meshLocalPos = particle_vertexData3.xyz;\n";

	var particle_cpu_endVS = "\n    localPos *= particle_vertexData2.y * emitterScale;\n    localPos += particlePos;\n\n    gl_Position = matrix_viewProjection * vec4(localPos, 1.0);\n";

	var particle_customFaceVS = "\n    quadXY = rotate(quadXY, inAngle, rotMatrix);\n    vec3 localPos = customFace(particlePos, quadXY);\n";

	var particle_endPS = "\n    rgb = addFog(rgb);\n    rgb = toneMap(rgb);\n    rgb = gammaCorrectOutput(rgb);\n    gl_FragColor = vec4(rgb, a);\n}\n";

	var particle_endVS = "\n    localPos *= scale * emitterScale;\n    localPos += particlePos;\n\n    #ifdef SCREEN_SPACE\n    gl_Position = vec4(localPos.x, localPos.y, 0.0, 1.0);\n    #else\n    gl_Position = matrix_viewProjection * vec4(localPos.xyz, 1.0);\n    #endif\n";

	var particle_halflambertPS = "\n    vec3 negNormal = normal*0.5+0.5;\n    vec3 posNormal = -normal*0.5+0.5;\n    negNormal *= negNormal;\n    posNormal *= posNormal;\n";

	var particle_initVS = "\nattribute vec4 particle_vertexData; // XYZ = particle position, W = particle ID + random factor\n#ifdef USE_MESH\nattribute vec2 particle_uv;         // mesh UV\n#endif\n\nuniform mat4 matrix_viewProjection;\nuniform mat4 matrix_model;\nuniform mat3 matrix_normal;\nuniform mat4 matrix_viewInverse;\n\n#ifndef VIEWMATRIX\n#define VIEWMATRIX\nuniform mat4 matrix_view;\n#endif\n\nuniform float numParticles, numParticlesPot;\nuniform float graphSampleSize;\nuniform float graphNumSamples;\nuniform float stretch;\nuniform vec3 wrapBounds;\nuniform vec3 emitterScale, emitterPos, faceTangent, faceBinorm;\nuniform float rate, rateDiv, lifetime, deltaRandomnessStatic, scaleDivMult, alphaDivMult, seed, delta;\nuniform sampler2D particleTexOUT, particleTexIN;\nuniform highp sampler2D internalTex0;\nuniform highp sampler2D internalTex1;\nuniform highp sampler2D internalTex2;\n\n#ifndef CAMERAPLANES\n#define CAMERAPLANES\nuniform vec4 camera_params;\n#endif\n\nvarying vec4 texCoordsAlphaLife;\n\nvec3 inPos;\nvec3 inVel;\nfloat inAngle;\nbool inShow;\nfloat inLife;\n";

	var particle_lambertPS = "\n    vec3 negNormal = max(normal, vec3(0.0));\n    vec3 posNormal = max(-normal, vec3(0.0));\n";

	var particle_lightingPS = "\n    vec3 light = negNormal.x*lightCube[0] + posNormal.x*lightCube[1] +\n                        negNormal.y*lightCube[2] + posNormal.y*lightCube[3] +\n                        negNormal.z*lightCube[4] + posNormal.z*lightCube[5];\n\n    rgb *= light;\n";

	var particle_localShiftVS = "\n    particlePos = (matrix_model * vec4(particlePos, 1.0)).xyz;\n";

	var particle_meshVS = "\n    vec3 localPos = meshLocalPos;\n    localPos.xy = rotate(localPos.xy, inAngle, rotMatrix);\n    localPos.yz = rotate(localPos.yz, inAngle, rotMatrix);\n\n    billboard(particlePos, quadXY);\n";

	var particle_normalVS = "\n    Normal = normalize(localPos + matrix_viewInverse[2].xyz);\n";

	var particle_normalMapPS = "\n    vec3 normalMap = normalize(texture2D(normalMap, vec2(texCoordsAlphaLife.x, 1.0 - texCoordsAlphaLife.y)).xyz * 2.0 - 1.0);\n    vec3 normal = ParticleMat * normalMap;\n";

	var particle_pointAlongVS = "\n    inAngle = atan(velocityV.x, velocityV.y); // not the fastest way, but easier to plug in; TODO: create rot matrix right from vectors\n\n";

	var particle_softPS = "\n    float depth = getLinearScreenDepth();\n    float particleDepth = vDepth;\n    float depthDiff = saturate(abs(particleDepth - depth) * softening);\n    a *= depthDiff;\n";

	var particle_softVS = "\n    vDepth = getLinearDepth(localPos);\n";

	var particle_stretchVS = "\n    vec3 moveDir = inVel * stretch;\n    vec3 posPrev = particlePos - moveDir;\n    posPrev += particlePosMoved;\n\n    vec2 centerToVertexV = normalize((mat3(matrix_view) * localPos).xy);\n\n    float interpolation = dot(-velocityV, centerToVertexV) * 0.5 + 0.5;\n\n    particlePos = mix(particlePos, posPrev, interpolation);\n";

	var particle_TBNVS = "\n    mat3 rot3 = mat3(rotMatrix[0][0], rotMatrix[0][1], 0.0, rotMatrix[1][0], rotMatrix[1][1], 0.0, 0.0, 0.0, 1.0);\n    ParticleMat = mat3(-matrix_viewInverse[0].xyz, -matrix_viewInverse[1].xyz, matrix_viewInverse[2].xyz) * rot3;\n";

	var particle_wrapVS = "\n    vec3 origParticlePos = particlePos;\n    particlePos -= matrix_model[3].xyz;\n    particlePos = mod(particlePos, wrapBounds) - wrapBounds * 0.5;\n    particlePos += matrix_model[3].xyz;\n    particlePosMoved = particlePos - origParticlePos;\n";

	var reflDirPS = "\nvoid getReflDir(vec3 worldNormal, vec3 viewDir, float gloss, mat3 tbn) {\n    dReflDirW = normalize(-reflect(viewDir, worldNormal));\n}\n";

	var reflDirAnisoPS = "\nvoid getReflDir(vec3 worldNormal, vec3 viewDir, float gloss, mat3 tbn) {\n    float roughness = sqrt(1.0 - min(gloss, 1.0));\n    float anisotropy = material_anisotropy * roughness;\n    vec3 anisotropicDirection = anisotropy >= 0.0 ? tbn[1] : tbn[0];\n    vec3 anisotropicTangent = cross(anisotropicDirection, viewDir);\n    vec3 anisotropicNormal = cross(anisotropicTangent, anisotropicDirection);\n    vec3 bentNormal = normalize(mix(normalize(worldNormal), normalize(anisotropicNormal), anisotropy));\n    dReflDirW = reflect(-viewDir, bentNormal);\n}\n";

	var reflectionCCPS = "\n#ifdef LIT_CLEARCOAT\nvoid addReflectionCC(vec3 reflDir, float gloss) {\n    ccReflection += calcReflection(reflDir, gloss);\n}\n#endif\n";

	var reflectionCubePS = "\nuniform samplerCube texture_cubeMap;\nuniform float material_reflectivity;\n\nvec3 calcReflection(vec3 reflDir, float gloss) {\n    vec3 lookupVec = fixSeams(cubeMapProject(reflDir));\n    lookupVec.x *= -1.0;\n    return $DECODE(textureCube(texture_cubeMap, lookupVec));\n}\n\nvoid addReflection(vec3 reflDir, float gloss) {   \n    dReflection += vec4(calcReflection(reflDir, gloss), material_reflectivity);\n}\n";

	var reflectionEnvHQPS = "\n#ifndef ENV_ATLAS\n#define ENV_ATLAS\nuniform sampler2D texture_envAtlas;\n#endif\nuniform samplerCube texture_cubeMap;\nuniform float material_reflectivity;\n\nvec3 calcReflection(vec3 reflDir, float gloss) {\n    vec3 dir = cubeMapProject(reflDir) * vec3(-1.0, 1.0, 1.0);\n    vec2 uv = toSphericalUv(dir);\n\n    // calculate roughness level\n    float level = saturate(1.0 - gloss) * 5.0;\n    float ilevel = floor(level);\n    float flevel = level - ilevel;\n\n    vec3 sharp = $DECODE_CUBEMAP(textureCube(texture_cubeMap, fixSeams(dir)));\n    vec3 roughA = $DECODE(texture2D(texture_envAtlas, mapRoughnessUv(uv, ilevel)));\n    vec3 roughB = $DECODE(texture2D(texture_envAtlas, mapRoughnessUv(uv, ilevel + 1.0)));\n\n    return processEnvironment(mix(sharp, mix(roughA, roughB, flevel), min(level, 1.0)));\n}\n\nvoid addReflection(vec3 reflDir, float gloss) {   \n    dReflection += vec4(calcReflection(reflDir, gloss), material_reflectivity);\n}\n";

	var reflectionEnvPS = "\n#ifndef ENV_ATLAS\n#define ENV_ATLAS\nuniform sampler2D texture_envAtlas;\n#endif\nuniform float material_reflectivity;\n\n// calculate mip level for shiny reflection given equirect coords uv.\nfloat shinyMipLevel(vec2 uv) {\n    vec2 dx = dFdx(uv);\n    vec2 dy = dFdy(uv);\n\n    // calculate second dF at 180 degrees\n    vec2 uv2 = vec2(fract(uv.x + 0.5), uv.y);\n    vec2 dx2 = dFdx(uv2);\n    vec2 dy2 = dFdy(uv2);\n\n    // calculate min of both sets of dF to handle discontinuity at the azim edge\n    float maxd = min(max(dot(dx, dx), dot(dy, dy)), max(dot(dx2, dx2), dot(dy2, dy2)));\n\n    return clamp(0.5 * log2(maxd) - 1.0 + textureBias, 0.0, 5.0);\n}\n\nvec3 calcReflection(vec3 reflDir, float gloss) {\n    vec3 dir = cubeMapProject(reflDir) * vec3(-1.0, 1.0, 1.0);\n    vec2 uv = toSphericalUv(dir);\n\n    // calculate roughness level\n    float level = saturate(1.0 - gloss) * 5.0;\n    float ilevel = floor(level);\n\n    // accessing the shiny (top level) reflection - perform manual mipmap lookup\n    float level2 = shinyMipLevel(uv * atlasSize);\n    float ilevel2 = floor(level2);\n\n    vec2 uv0, uv1;\n    float weight;\n    if (ilevel == 0.0) {\n        uv0 = mapShinyUv(uv, ilevel2);\n        uv1 = mapShinyUv(uv, ilevel2 + 1.0);\n        weight = level2 - ilevel2;\n    } else {\n        // accessing rough reflection - just sample the same part twice\n        uv0 = uv1 = mapRoughnessUv(uv, ilevel);\n        weight = 0.0;\n    }\n\n    vec3 linearA = $DECODE(texture2D(texture_envAtlas, uv0));\n    vec3 linearB = $DECODE(texture2D(texture_envAtlas, uv1));\n    vec3 linear0 = mix(linearA, linearB, weight);\n    vec3 linear1 = $DECODE(texture2D(texture_envAtlas, mapRoughnessUv(uv, ilevel + 1.0)));\n\n    return processEnvironment(mix(linear0, linear1, level - ilevel));\n}\n\nvoid addReflection(vec3 reflDir, float gloss) {   \n    dReflection += vec4(calcReflection(reflDir, gloss), material_reflectivity);\n}\n";

	var reflectionSpherePS = "\n#ifndef VIEWMATRIX\n#define VIEWMATRIX\nuniform mat4 matrix_view;\n#endif\nuniform sampler2D texture_sphereMap;\nuniform float material_reflectivity;\n\nvec3 calcReflection(vec3 reflDir, float gloss) {\n    vec3 reflDirV = (mat3(matrix_view) * reflDir).xyz;\n\n    float m = 2.0 * sqrt( dot(reflDirV.xy, reflDirV.xy) + (reflDirV.z+1.0)*(reflDirV.z+1.0) );\n    vec2 sphereMapUv = reflDirV.xy / m + 0.5;\n\n    return $DECODE(texture2D(texture_sphereMap, sphereMapUv));\n}\n\nvoid addReflection(vec3 reflDir, float gloss) {   \n    dReflection += vec4(calcReflection(reflDir, gloss), material_reflectivity);\n}\n";

	var reflectionSphereLowPS = "\nuniform sampler2D texture_sphereMap;\nuniform float material_reflectivity;\n\nvec3 calcReflection(vec3 reflDir, float gloss) {\n    vec3 reflDirV = vNormalV;\n\n    vec2 sphereMapUv = reflDirV.xy * 0.5 + 0.5;\n    return $DECODE(texture2D(texture_sphereMap, sphereMapUv));\n}\n\nvoid addReflection(vec3 reflDir, float gloss) {   \n    dReflection += vec4(calcReflection(reflDir, gloss), material_reflectivity);\n}\n";

	var reflectionSheenPS = "\n\nvoid addReflectionSheen(vec3 worldNormal, vec3 viewDir, float gloss) {\n    float NoV = dot(worldNormal, viewDir);\n    float alphaG = gloss * gloss;\n\n    // Avoid using a LUT and approximate the values analytically\n    float a = gloss < 0.25 ? -339.2 * alphaG + 161.4 * gloss - 25.9 : -8.48 * alphaG + 14.3 * gloss - 9.95;\n    float b = gloss < 0.25 ? 44.0 * alphaG - 23.7 * gloss + 3.26 : 1.97 * alphaG - 3.27 * gloss + 0.72;\n    float DG = exp( a * NoV + b ) + ( gloss < 0.25 ? 0.0 : 0.1 * ( gloss - 0.25 ) );\n    sReflection += calcReflection(worldNormal, 0.0) * saturate(DG);\n}\n";

	var refractionCubePS = "\nvec3 refract2(vec3 viewVec, vec3 normal, float IOR) {\n    float vn = dot(viewVec, normal);\n    float k = 1.0 - IOR * IOR * (1.0 - vn * vn);\n    vec3 refrVec = IOR * viewVec - (IOR * vn + sqrt(k)) * normal;\n    return refrVec;\n}\n\nvoid addRefraction(\n    vec3 worldNormal, \n    vec3 viewDir, \n    float thickness, \n    float gloss, \n    vec3 specularity, \n    vec3 albedo, \n    float transmission,\n    float refractionIndex\n#if defined(LIT_IRIDESCENCE)\n    , vec3 iridescenceFresnel,\n    float iridescenceIntensity\n#endif \n) {\n    // use same reflection code with refraction vector\n    vec4 tmpRefl = dReflection;\n    vec3 reflectionDir = refract2(-viewDir, worldNormal, refractionIndex);\n    dReflection = vec4(0);\n    addReflection(reflectionDir, gloss);\n    dDiffuseLight = mix(dDiffuseLight, dReflection.rgb * albedo, transmission);\n    dReflection = tmpRefl;\n}\n";

	var refractionDynamicPS = "\nuniform float material_invAttenuationDistance;\nuniform vec3 material_attenuation;\n\nvoid addRefraction(\n    vec3 worldNormal, \n    vec3 viewDir, \n    float thickness, \n    float gloss, \n    vec3 specularity, \n    vec3 albedo, \n    float transmission,\n    float refractionIndex\n#if defined(LIT_IRIDESCENCE)\n    , vec3 iridescenceFresnel,\n    float iridescenceIntensity\n#endif\n) {\n\n    // Extract scale from the model transform\n    vec3 modelScale;\n    modelScale.x = length(vec3(matrix_model[0].xyz));\n    modelScale.y = length(vec3(matrix_model[1].xyz));\n    modelScale.z = length(vec3(matrix_model[2].xyz));\n\n    // Calculate the refraction vector, scaled by the thickness and scale of the object\n    vec3 refractionVector = normalize(refract(-viewDir, worldNormal, refractionIndex)) * thickness * modelScale;\n\n    // The refraction point is the entry point + vector to exit point\n    vec4 pointOfRefraction = vec4(vPositionW + refractionVector, 1.0);\n\n    // Project to texture space so we can sample it\n    vec4 projectionPoint = matrix_viewProjection * pointOfRefraction;\n\n    // use built-in getGrabScreenPos function to convert screen position to grab texture uv coords\n    vec2 uv = getGrabScreenPos(projectionPoint);\n\n    #ifdef SUPPORTS_TEXLOD\n        // Use IOR and roughness to select mip\n        float iorToRoughness = (1.0 - gloss) * clamp((1.0 / refractionIndex) * 2.0 - 2.0, 0.0, 1.0);\n        float refractionLod = log2(uScreenSize.x) * iorToRoughness;\n        vec3 refraction = texture2DLodEXT(uSceneColorMap, uv, refractionLod).rgb;\n    #else\n        vec3 refraction = texture2D(uSceneColorMap, uv).rgb;\n    #endif\n\n    // Transmittance is our final refraction color\n    vec3 transmittance;\n    if (material_invAttenuationDistance != 0.0)\n    {\n        vec3 attenuation = -log(material_attenuation) * material_invAttenuationDistance;\n        transmittance = exp(-attenuation * length(refractionVector));\n    }\n    else\n    {\n        transmittance = refraction;\n    }\n\n    // Apply fresnel effect on refraction\n    vec3 fresnel = vec3(1.0) - \n        getFresnel(\n            dot(viewDir, worldNormal), \n            gloss, \n            specularity\n        #if defined(LIT_IRIDESCENCE)\n            , iridescenceFresnel,\n            iridescenceIntensity\n        #endif\n        );\n    dDiffuseLight = mix(dDiffuseLight, refraction * transmittance * fresnel, transmission);\n}\n";

	var reprojectPS = "\n// This shader requires the following #DEFINEs:\n//\n// PROCESS_FUNC - must be one of reproject, prefilter\n// DECODE_FUNC - must be one of decodeRGBM, decodeRGBE, decodeGamma or decodeLinear\n// ENCODE_FUNC - must be one of encodeRGBM, encodeRGBE, encideGamma or encodeLinear\n// SOURCE_FUNC - must be one of sampleCubemap, sampleEquirect, sampleOctahedral\n// TARGET_FUNC - must be one of getDirectionCubemap, getDirectionEquirect, getDirectionOctahedral\n//\n// When filtering:\n// NUM_SAMPLES - number of samples\n// NUM_SAMPLES_SQRT - sqrt of number of samples\n\nvarying vec2 vUv0;\n\n// source\n#ifdef CUBEMAP_SOURCE\n    uniform samplerCube sourceCube;\n#else\n    uniform sampler2D sourceTex;\n#endif\n\n#ifdef USE_SAMPLES_TEX\n    // samples\n    uniform sampler2D samplesTex;\n    uniform vec2 samplesTexInverseSize;\n#endif\n\n// params:\n// x - target cubemap face 0..6\n// y - specular power (when prefiltering)\n// z - source cubemap seam scale (0 to disable)\n// w - target cubemap size for seam calc (0 to disable)\nuniform vec4 params;\n\n// params2:\n// x - target image total pixels\n// y - source cubemap size\nuniform vec2 params2;\n\nfloat targetFace() { return params.x; }\nfloat specularPower() { return params.y; }\nfloat sourceCubeSeamScale() { return params.z; }\nfloat targetCubeSeamScale() { return params.w; }\n\nfloat targetTotalPixels() { return params2.x; }\nfloat sourceTotalPixels() { return params2.y; }\n\nfloat PI = 3.141592653589793;\n\nfloat saturate(float x) {\n    return clamp(x, 0.0, 1.0);\n}\n\n" + decodePS + "\n" + encodePS + "\n\n//-- supported projections\n\nvec3 modifySeams(vec3 dir, float scale) {\n    vec3 adir = abs(dir);\n    float M = max(max(adir.x, adir.y), adir.z);\n    return dir / M * vec3(\n        adir.x == M ? 1.0 : scale,\n        adir.y == M ? 1.0 : scale,\n        adir.z == M ? 1.0 : scale\n    );\n}\n\nvec2 toSpherical(vec3 dir) {\n    return vec2(dir.xz == vec2(0.0) ? 0.0 : atan(dir.x, dir.z), asin(dir.y));\n}\n\nvec3 fromSpherical(vec2 uv) {\n    return vec3(cos(uv.y) * sin(uv.x),\n                sin(uv.y),\n                cos(uv.y) * cos(uv.x));\n}\n\nvec3 getDirectionEquirect() {\n    return fromSpherical((vec2(vUv0.x, 1.0 - vUv0.y) * 2.0 - 1.0) * vec2(PI, PI * 0.5));\n}\n\n// octahedral code, based on http://jcgt.org/published/0003/02/01\n// \"Survey of Efficient Representations for Independent Unit Vectors\" by Cigolle, Donow, Evangelakos, Mara, McGuire, Meyer\n\nfloat signNotZero(float k){\n    return(k >= 0.0) ? 1.0 : -1.0;\n}\n\nvec2 signNotZero(vec2 v) {\n    return vec2(signNotZero(v.x), signNotZero(v.y));\n}\n\n// Returns a unit vector. Argument o is an octahedral vector packed via octEncode, on the [-1, +1] square\nvec3 octDecode(vec2 o) {\n    vec3 v = vec3(o.x, 1.0 - abs(o.x) - abs(o.y), o.y);\n    if (v.y < 0.0) {\n        v.xz = (1.0 - abs(v.zx)) * signNotZero(v.xz);\n    }\n    return normalize(v);\n}\n\nvec3 getDirectionOctahedral() {\n    return octDecode(vec2(vUv0.x, 1.0 - vUv0.y) * 2.0 - 1.0);\n}\n\n// Assumes that v is a unit vector. The result is an octahedral vector on the [-1, +1] square\nvec2 octEncode(in vec3 v) {\n    float l1norm = abs(v.x) + abs(v.y) + abs(v.z);\n    vec2 result = v.xz * (1.0 / l1norm);\n    if (v.y < 0.0) {\n        result = (1.0 - abs(result.yx)) * signNotZero(result.xy);\n    }\n    return result;\n}\n\n/////////////////////////////////////////////////////////////////////\n\n#ifdef CUBEMAP_SOURCE\n    vec4 sampleCubemap(vec3 dir) {\n        return textureCube(sourceCube, modifySeams(dir, 1.0 - sourceCubeSeamScale()));\n    }\n\n    vec4 sampleCubemap(vec2 sph) {\n    return sampleCubemap(fromSpherical(sph));\n}\n\n    vec4 sampleCubemap(vec3 dir, float mipLevel) {\n        return textureCubeLodEXT(sourceCube, modifySeams(dir, 1.0 - exp2(mipLevel) * sourceCubeSeamScale()), mipLevel);\n    }\n\n    vec4 sampleCubemap(vec2 sph, float mipLevel) {\n        return sampleCubemap(fromSpherical(sph), mipLevel);\n    }\n#else\n\n    vec4 sampleEquirect(vec2 sph) {\n        vec2 uv = sph / vec2(PI * 2.0, PI) + 0.5;\n        return texture2D(sourceTex, vec2(uv.x, 1.0 - uv.y));\n    }\n\n    vec4 sampleEquirect(vec3 dir) {\n        return sampleEquirect(toSpherical(dir));\n    }\n\n    vec4 sampleEquirect(vec2 sph, float mipLevel) {\n        vec2 uv = sph / vec2(PI * 2.0, PI) + 0.5;\n        return texture2DLodEXT(sourceTex, vec2(uv.x, 1.0 - uv.y), mipLevel);\n    }\n\n    vec4 sampleEquirect(vec3 dir, float mipLevel) {\n        return sampleEquirect(toSpherical(dir), mipLevel);\n    }\n\n    vec4 sampleOctahedral(vec3 dir) {\n        vec2 uv = octEncode(dir) * 0.5 + 0.5;\n        return texture2D(sourceTex, vec2(uv.x, 1.0 - uv.y));\n    }\n\n    vec4 sampleOctahedral(vec2 sph) {\n        return sampleOctahedral(fromSpherical(sph));\n    }\n\n    vec4 sampleOctahedral(vec3 dir, float mipLevel) {\n        vec2 uv = octEncode(dir) * 0.5 + 0.5;\n        return texture2DLodEXT(sourceTex, vec2(uv.x, 1.0 - uv.y), mipLevel);\n    }\n\n    vec4 sampleOctahedral(vec2 sph, float mipLevel) {\n        return sampleOctahedral(fromSpherical(sph), mipLevel);\n    }\n\n#endif\n\nvec3 getDirectionCubemap() {\n    vec2 st = vUv0 * 2.0 - 1.0;\n    float face = targetFace();\n\n    vec3 vec;\n    if (face == 0.0) {\n        vec = vec3(1, -st.y, -st.x);\n    } else if (face == 1.0) {\n        vec = vec3(-1, -st.y, st.x);\n    } else if (face == 2.0) {\n        vec = vec3(st.x, 1, st.y);\n    } else if (face == 3.0) {\n        vec = vec3(st.x, -1, -st.y);\n    } else if (face == 4.0) {\n        vec = vec3(st.x, -st.y, 1);\n    } else {\n        vec = vec3(-st.x, -st.y, -1);\n    }\n\n    return normalize(modifySeams(vec, 1.0 / (1.0 - targetCubeSeamScale())));\n}\n\nmat3 matrixFromVector(vec3 n) { // frisvad\n    float a = 1.0 / (1.0 + n.z);\n    float b = -n.x * n.y * a;\n    vec3 b1 = vec3(1.0 - n.x * n.x * a, b, -n.x);\n    vec3 b2 = vec3(b, 1.0 - n.y * n.y * a, -n.y);\n    return mat3(b1, b2, n);\n}\n\nmat3 matrixFromVectorSlow(vec3 n) {\n    vec3 up = (1.0 - abs(n.y) <= 0.0000001) ? vec3(0.0, 0.0, n.y > 0.0 ? 1.0 : -1.0) : vec3(0.0, 1.0, 0.0);\n    vec3 x = normalize(cross(up, n));\n    vec3 y = cross(n, x);\n    return mat3(x, y, n);\n}\n\nvec4 reproject() {\n    if (NUM_SAMPLES <= 1) {\n        // single sample\n        return ENCODE_FUNC(DECODE_FUNC(SOURCE_FUNC(TARGET_FUNC())));\n    } else {\n        // multi sample\n        vec3 t = TARGET_FUNC();\n        vec3 tu = dFdx(t);\n        vec3 tv = dFdy(t);\n\n        vec3 result = vec3(0.0);\n        for (float u = 0.0; u < NUM_SAMPLES_SQRT; ++u) {\n            for (float v = 0.0; v < NUM_SAMPLES_SQRT; ++v) {\n                result += DECODE_FUNC(SOURCE_FUNC(normalize(t +\n                                                            tu * (u / NUM_SAMPLES_SQRT - 0.5) +\n                                                            tv * (v / NUM_SAMPLES_SQRT - 0.5))));\n            }\n        }\n        return ENCODE_FUNC(result / (NUM_SAMPLES_SQRT * NUM_SAMPLES_SQRT));\n    }\n}\n\nvec4 unpackFloat = vec4(1.0, 1.0 / 255.0, 1.0 / 65025.0, 1.0 / 16581375.0);\n\n#ifdef USE_SAMPLES_TEX\n    void unpackSample(int i, out vec3 L, out float mipLevel) {\n        float u = (float(i * 4) + 0.5) * samplesTexInverseSize.x;\n        float v = (floor(u) + 0.5) * samplesTexInverseSize.y;\n\n        vec4 raw;\n        raw.x = dot(texture2D(samplesTex, vec2(u, v)), unpackFloat); u += samplesTexInverseSize.x;\n        raw.y = dot(texture2D(samplesTex, vec2(u, v)), unpackFloat); u += samplesTexInverseSize.x;\n        raw.z = dot(texture2D(samplesTex, vec2(u, v)), unpackFloat); u += samplesTexInverseSize.x;\n        raw.w = dot(texture2D(samplesTex, vec2(u, v)), unpackFloat);\n\n        L.xyz = raw.xyz * 2.0 - 1.0;\n        mipLevel = raw.w * 8.0;\n    }\n\n    // convolve an environment given pre-generated samples\n    vec4 prefilterSamples() {\n        // construct vector space given target direction\n        mat3 vecSpace = matrixFromVectorSlow(TARGET_FUNC());\n\n        vec3 L;\n        float mipLevel;\n\n        vec3 result = vec3(0.0);\n        float totalWeight = 0.0;\n        for (int i = 0; i < NUM_SAMPLES; ++i) {\n            unpackSample(i, L, mipLevel);\n            result += DECODE_FUNC(SOURCE_FUNC(vecSpace * L, mipLevel)) * L.z;\n            totalWeight += L.z;\n        }\n\n        return ENCODE_FUNC(result / totalWeight);\n    }\n\n    // unweighted version of prefilterSamples\n    vec4 prefilterSamplesUnweighted() {\n        // construct vector space given target direction\n        mat3 vecSpace = matrixFromVectorSlow(TARGET_FUNC());\n\n        vec3 L;\n        float mipLevel;\n\n        vec3 result = vec3(0.0);\n        float totalWeight = 0.0;\n        for (int i = 0; i < NUM_SAMPLES; ++i) {\n            unpackSample(i, L, mipLevel);\n            result += DECODE_FUNC(SOURCE_FUNC(vecSpace * L, mipLevel));\n        }\n\n        return ENCODE_FUNC(result / float(NUM_SAMPLES));\n    }\n#endif\n\nvoid main(void) {\n    gl_FragColor = PROCESS_FUNC();\n}\n";

	var screenDepthPS = "\nuniform highp sampler2D uSceneDepthMap;\n\n#ifndef SCREENSIZE\n#define SCREENSIZE\nuniform vec4 uScreenSize;\n#endif\n\n#ifndef VIEWMATRIX\n#define VIEWMATRIX\nuniform mat4 matrix_view;\n#endif\n\n#ifndef LINEARIZE_DEPTH\n#ifndef CAMERAPLANES\n#define CAMERAPLANES\nuniform vec4 camera_params; // x: 1 / camera_far,      y: camera_far,     z: camera_near,        w: is_ortho\n#endif\n\n#define LINEARIZE_DEPTH\n#ifdef GL2\nfloat linearizeDepth(float z) {\n    if (camera_params.w == 0.0)\n        return (camera_params.z * camera_params.y) / (camera_params.y + z * (camera_params.z - camera_params.y));\n    else\n        return camera_params.z + z * (camera_params.y - camera_params.z);\n}\n#else // GL2\n#ifndef UNPACKFLOAT\n#define UNPACKFLOAT\nfloat unpackFloat(vec4 rgbaDepth) {\n    const vec4 bitShift = vec4(1.0 / (256.0 * 256.0 * 256.0), 1.0 / (256.0 * 256.0), 1.0 / 256.0, 1.0);\n    return dot(rgbaDepth, bitShift);\n}\n#endif\n#endif\n#endif // LINEARIZE_DEPTH\n\n// Retrieves rendered linear camera depth by UV\nfloat getLinearScreenDepth(vec2 uv) {\n    #ifdef GL2\n        return linearizeDepth(texture2D(uSceneDepthMap, uv).r);\n    #else\n        return unpackFloat(texture2D(uSceneDepthMap, uv)) * camera_params.y;\n    #endif\n}\n\n#ifndef VERTEXSHADER\n// Retrieves rendered linear camera depth under the current pixel\nfloat getLinearScreenDepth() {\n    vec2 uv = gl_FragCoord.xy * uScreenSize.zw;\n    return getLinearScreenDepth(uv);\n}\n#endif\n\n// Generates linear camera depth for the given world position\nfloat getLinearDepth(vec3 pos) {\n    return -(matrix_view * vec4(pos, 1.0)).z;\n}\n";

	var shadowCascadesPS = "\nconst float maxCascades = 4.0;\n\n// shadow matrix for selected cascade\nmat4 cascadeShadowMat;\n\n// function which selects a shadow projection matrix based on cascade distances \nvoid getShadowCascadeMatrix(mat4 shadowMatrixPalette[4], float shadowCascadeDistances[4], float shadowCascadeCount) {\n\n    // depth in 0 .. far plane range\n    float depth = 1.0 / gl_FragCoord.w;\n\n    // find cascade index based on the depth (loop as there is no per component vec compare operator in webgl)\n    float cascadeIndex = 0.0;\n    for (float i = 0.0; i < maxCascades; i++) {\n        if (depth < shadowCascadeDistances[int(i)]) {\n            cascadeIndex = i;\n            break;\n        }\n    }\n\n    // limit to actual number of used cascades\n    cascadeIndex = min(cascadeIndex, shadowCascadeCount - 1.0);\n\n    // pick shadow matrix\n    #ifdef GL2\n        cascadeShadowMat = shadowMatrixPalette[int(cascadeIndex)];\n    #else\n        // webgl 1 does not allow non-cost index array lookup\n        if (cascadeIndex == 0.0) {\n            cascadeShadowMat = shadowMatrixPalette[0];\n        }\n        else if (cascadeIndex == 1.0) {\n            cascadeShadowMat = shadowMatrixPalette[1];\n        }\n        else if (cascadeIndex == 2.0) {\n            cascadeShadowMat = shadowMatrixPalette[2];\n        }\n        else {\n            cascadeShadowMat = shadowMatrixPalette[3];\n        }\n    #endif\n}\n\nvoid fadeShadow(float shadowCascadeDistances[4]) {                  \n\n    // if the pixel is past the shadow distance, remove shadow\n    // this enforces straight line instead of corner of shadow which moves when camera rotates  \n    float depth = 1.0 / gl_FragCoord.w;\n    if (depth > shadowCascadeDistances[int(maxCascades - 1.0)]) {\n        dShadowCoord.z = -9999999.0;\n    }\n}\n";

	var shadowEVSMPS = "\nfloat VSM$(sampler2D tex, vec2 texCoords, float resolution, float Z, float vsmBias, float exponent) {\n    vec3 moments = texture2D(tex, texCoords).xyz;\n    return calculateEVSM(moments, Z, vsmBias, exponent);\n}\n\nfloat getShadowVSM$(sampler2D shadowMap, vec3 shadowCoord, vec4 shadowParams, float exponent, vec3 lightDir) {\n    return VSM$(shadowMap, shadowCoord.xy, shadowParams.x, shadowCoord.z, shadowParams.y, exponent);\n}\n\nfloat getShadowSpotVSM$(sampler2D shadowMap, vec3 shadowCoord, vec4 shadowParams, float exponent, vec3 lightDir) {\n    return VSM$(shadowMap, shadowCoord.xy, shadowParams.x, length(lightDir) * shadowParams.w + shadowParams.z, shadowParams.y, exponent);\n}\n";

	var shadowEVSMnPS = "\nfloat VSM$(TEXTURE_ACCEPT(tex), vec2 texCoords, float resolution, float Z, float vsmBias, float exponent) {\n    float pixelSize = 1.0 / resolution;\n    texCoords -= vec2(pixelSize);\n    vec3 s00 = texture2D(tex, texCoords).xyz;\n    vec3 s10 = texture2D(tex, texCoords + vec2(pixelSize, 0)).xyz;\n    vec3 s01 = texture2D(tex, texCoords + vec2(0, pixelSize)).xyz;\n    vec3 s11 = texture2D(tex, texCoords + vec2(pixelSize)).xyz;\n    vec2 fr = fract(texCoords * resolution);\n    vec3 h0 = mix(s00, s10, fr.x);\n    vec3 h1 = mix(s01, s11, fr.x);\n    vec3 moments = mix(h0, h1, fr.y);\n    return calculateEVSM(moments, Z, vsmBias, exponent);\n}\n\nfloat getShadowVSM$(TEXTURE_ACCEPT(shadowMap), vec3 shadowCoord, vec4 shadowParams, float exponent, vec3 lightDir) {\n    return VSM$(TEXTURE_PASS(shadowMap), shadowCoord.xy, shadowParams.x, shadowCoord.z, shadowParams.y, exponent);\n}\n\nfloat getShadowSpotVSM$(TEXTURE_ACCEPT(shadowMap), vec3 shadowCoord, vec4 shadowParams, float exponent, vec3 lightDir) {\n    return VSM$(TEXTURE_PASS(shadowMap), shadowCoord.xy, shadowParams.x, length(lightDir) * shadowParams.w + shadowParams.z, shadowParams.y, exponent);\n}\n";

	var shadowPCSSPS = "\n\n/**\n * PCSS is a shadow sampling method that provides contact hardening soft shadows. \n * Based on: \n * - https://www.gamedev.net/tutorials/programming/graphics/effect-area-light-shadows-part-1-pcss-r4971/\n * - https://github.com/pboechat/PCSS \n */\n\n\n#define PCSS_SAMPLE_COUNT 16\nuniform float pcssDiskSamples[PCSS_SAMPLE_COUNT];\nuniform float pcssSphereSamples[PCSS_SAMPLE_COUNT];\n\nvec2 vogelDisk(int sampleIndex, float count, float phi, float r) {\n    const float GoldenAngle = 2.4;\n    float theta = float(sampleIndex) * GoldenAngle + phi;\n\n    float sine = sin(theta);\n    float cosine = cos(theta);\n    return vec2(r * cosine, r * sine);\n}\n\nvec3 vogelSphere(int sampleIndex, float count, float phi, float r) {\n    const float GoldenAngle = 2.4;\n    float theta = float(sampleIndex) * GoldenAngle + phi;\n\n    float weight = float(sampleIndex) / count;\n    return vec3(cos(theta) * r, weight, sin(theta) * r);\n}\n\nfloat noise(vec2 screenPos) {\n    const float PHI = 1.61803398874989484820459;  // \u03A6 = Golden Ratio   \n    return fract(tan(distance(screenPos * PHI, screenPos)) * screenPos.x);\n}\n\n#ifndef UNPACKFLOAT\n#define UNPACKFLOAT\nfloat unpackFloat(vec4 rgbaDepth) {\n    const vec4 bitShift = vec4(1.0 / (256.0 * 256.0 * 256.0), 1.0 / (256.0 * 256.0), 1.0 / 256.0, 1.0);\n    return dot(rgbaDepth, bitShift);\n}\n#endif\n\nfloat viewSpaceDepth(float depth, mat4 invProjection) {\n    float z = depth * 2.0 - 1.0;\n    vec4 clipSpace = vec4(0.0, 0.0, z, 1.0);\n    vec4 viewSpace = invProjection * clipSpace;\n    return viewSpace.z;\n}\n\nfloat PCSSBlockerDistance(TEXTURE_ACCEPT(shadowMap), vec2 sampleCoords[PCSS_SAMPLE_COUNT], vec2 shadowCoords, vec2 searchSize, float z) {\n\n    float blockers = 0.0;\n    float averageBlocker = 0.0;\n    for (int i = 0; i < PCSS_SAMPLE_COUNT; i++) {\n        vec2 offset = sampleCoords[i] * searchSize;\n        vec2 sampleUV = shadowCoords + offset;\n\n    #ifdef GL2\n        float blocker = textureLod(shadowMap, sampleUV, 0.0).r;\n    #else // GL1\n        float blocker = unpackFloat(texture2D(shadowMap, sampleUV));\n    #endif        \n        float isBlocking = step(blocker, z);\n        blockers += isBlocking;\n        averageBlocker += blocker * isBlocking;\n    }\n\n    if (blockers > 0.0)\n        return averageBlocker /= blockers;\n    return -1.0;\n}\n\nfloat PCSS(TEXTURE_ACCEPT(shadowMap), vec3 shadowCoords, vec4 cameraParams, vec2 shadowSearchArea) {\n    float receiverDepth = shadowCoords.z;\n#ifndef GL2\n    // If using packed depth on GL1, we need to normalize to get the correct receiver depth\n    receiverDepth *= 1.0 / (cameraParams.y - cameraParams.z);\n#endif\n\n    vec2 samplePoints[PCSS_SAMPLE_COUNT];\n    float noise = noise( gl_FragCoord.xy ) * 2.0 * PI;\n    for (int i = 0; i < PCSS_SAMPLE_COUNT; i++) {\n        float pcssPresample = pcssDiskSamples[i];\n        samplePoints[i] = vogelDisk(i, float(PCSS_SAMPLE_COUNT), noise, pcssPresample);\n    }\n\n    float averageBlocker = PCSSBlockerDistance(TEXTURE_PASS(shadowMap), samplePoints, shadowCoords.xy, shadowSearchArea, receiverDepth);\n    if (averageBlocker == -1.0) {\n        return 1.0;\n    } else {\n\n        vec2 filterRadius = ((receiverDepth - averageBlocker) / averageBlocker) * shadowSearchArea * cameraParams.x;\n\n        float shadow = 0.0;\n\n        for (int i = 0; i < PCSS_SAMPLE_COUNT; i ++)\n        {\n            vec2 sampleUV = samplePoints[i] * filterRadius;\n            sampleUV = shadowCoords.xy + sampleUV;\n\n        #ifdef GL2\n            float depth = textureLod(shadowMap, sampleUV, 0.0).r;\n        #else // GL1\n            float depth = unpackFloat(texture2D(shadowMap, sampleUV));\n        #endif\n            shadow += step(receiverDepth, depth);\n        }\n        return shadow / float(PCSS_SAMPLE_COUNT);\n    } \n}\n\nfloat PCSSCubeBlockerDistance(samplerCube shadowMap, vec3 lightDirNorm, vec3 samplePoints[PCSS_SAMPLE_COUNT], float z, float shadowSearchArea) {\n    float blockers = 0.0;\n    float averageBlocker = 0.0;\n    for (int i = 0; i < PCSS_SAMPLE_COUNT; i++) {\n        vec3 sampleDir = lightDirNorm + samplePoints[i] * shadowSearchArea;\n        sampleDir = normalize(sampleDir);\n\n    #ifdef GL2\n        float blocker = textureCubeLodEXT(shadowMap, sampleDir, 0.0).r;\n    #else // GL1\n        float blocker = unpackFloat(textureCube(shadowMap, sampleDir));\n    #endif\n        float isBlocking = step(blocker, z);\n        blockers += isBlocking;\n        averageBlocker += blocker * isBlocking;\n    }\n\n    if (blockers > 0.0)\n        return averageBlocker /= float(blockers);\n    return -1.0;\n}\n\nfloat PCSSCube(samplerCube shadowMap, vec4 shadowParams, vec3 shadowCoords, vec4 cameraParams, float shadowSearchArea, vec3 lightDir) {\n    \n    vec3 samplePoints[PCSS_SAMPLE_COUNT];\n    float noise = noise( gl_FragCoord.xy ) * 2.0 * PI;\n    for (int i = 0; i < PCSS_SAMPLE_COUNT; i++) {\n        float r = pcssSphereSamples[i];\n        samplePoints[i] = vogelSphere(i, float(PCSS_SAMPLE_COUNT), noise, r);\n    }\n\n    float receiverDepth = length(lightDir) * shadowParams.w + shadowParams.z;\n    vec3 lightDirNorm = normalize(lightDir);\n    \n    float averageBlocker = PCSSCubeBlockerDistance(shadowMap, lightDirNorm, samplePoints, receiverDepth, shadowSearchArea);\n    if (averageBlocker == -1.0) {\n        return 1.0;\n    } else {\n\n        float filterRadius = ((receiverDepth - averageBlocker) / averageBlocker) * shadowSearchArea;\n\n        float shadow = 0.0;\n        for (int i = 0; i < PCSS_SAMPLE_COUNT; i++)\n        {\n            vec3 offset = samplePoints[i] * filterRadius;\n            vec3 sampleDir = lightDirNorm + offset;\n            sampleDir = normalize(sampleDir);\n\n            #ifdef GL2\n                float depth = textureCubeLodEXT(shadowMap, sampleDir, 0.0).r;\n            #else // GL1\n                float depth = unpackFloat(textureCube(shadowMap, sampleDir));\n            #endif\n            shadow += step(receiverDepth, depth);\n        }\n        return shadow / float(PCSS_SAMPLE_COUNT);\n    }\n}\n\nfloat getShadowPointPCSS(samplerCube shadowMap, vec3 shadowCoord, vec4 shadowParams, vec4 cameraParams, vec2 shadowSearchArea, vec3 lightDir) {\n    return PCSSCube(shadowMap, shadowParams, shadowCoord, cameraParams, shadowSearchArea.x, lightDir);\n}\n\nfloat getShadowSpotPCSS(TEXTURE_ACCEPT(shadowMap), vec3 shadowCoord, vec4 shadowParams, vec4 cameraParams, vec2 shadowSearchArea, vec3 lightDir) {\n    return PCSS(TEXTURE_PASS(shadowMap), shadowCoord, cameraParams, shadowSearchArea);\n}\n\nfloat getShadowPCSS(TEXTURE_ACCEPT(shadowMap), vec3 shadowCoord, vec4 shadowParams, vec4 cameraParams, vec2 shadowSearchArea, vec3 lightDir) {\n    return PCSS(TEXTURE_PASS(shadowMap), shadowCoord, cameraParams, shadowSearchArea);\n}\n\n";

	var shadowSampleCoordPS = "\n\nvec3 getShadowSampleCoord$LIGHT(mat4 shadowTransform, vec4 shadowParams, vec3 worldPosition, vec3 lightPos, inout vec3 lightDir, vec3 lightDirNorm, vec3 normal) {\n\n    vec3 surfacePosition = worldPosition;\n\n#ifdef SHADOW_SAMPLE_POINT\n    #ifdef SHADOW_SAMPLE_NORMAL_OFFSET\n        float distScale = length(lightDir);\n        surfacePosition = worldPosition + normal * shadowParams.y * clamp(1.0 - dot(normal, -lightDirNorm), 0.0, 1.0) * distScale;\n        lightDir = surfacePosition - lightPos;\n        return lightDir;\n    #endif\n#else\n    #ifdef SHADOW_SAMPLE_SOURCE_ZBUFFER\n        #ifdef SHADOW_SAMPLE_NORMAL_OFFSET\n            surfacePosition = worldPosition + normal * shadowParams.y;\n        #endif\n    #else\n        #ifdef SHADOW_SAMPLE_NORMAL_OFFSET\n            #ifdef SHADOW_SAMPLE_ORTHO\n                float distScale = 1.0;\n            #else\n                float distScale = abs(dot(vPositionW - lightPos, lightDirNorm));\n            #endif\n            surfacePosition = worldPosition + normal * shadowParams.y * clamp(1.0 - dot(normal, -lightDirNorm), 0.0, 1.0) * distScale;\n        #endif\n    #endif\n\n    vec4 positionInShadowSpace = shadowTransform * vec4(surfacePosition, 1.0);\n    #ifdef SHADOW_SAMPLE_ORTHO\n        positionInShadowSpace.z = saturate(positionInShadowSpace.z) - 0.0001;\n    #else\n        #ifdef SHADOW_SAMPLE_SOURCE_ZBUFFER\n            positionInShadowSpace.xyz /= positionInShadowSpace.w;\n        #else\n            positionInShadowSpace.xy /= positionInShadowSpace.w;\n            positionInShadowSpace.z = length(lightDir) * shadowParams.w;\n        #endif\n    #endif\n\n    #ifdef SHADOW_SAMPLE_Z_BIAS\n        positionInShadowSpace.z += getShadowBias(shadowParams.x, shadowParams.z);\n    #endif\n    surfacePosition = positionInShadowSpace.xyz;\n#endif\n\n    return surfacePosition;\n}\n";

	var shadowStandardPS = "\nvec3 lessThan2(vec3 a, vec3 b) {\n    return clamp((b - a)*1000.0, 0.0, 1.0); // softer version\n}\n\n#ifndef UNPACKFLOAT\n#define UNPACKFLOAT\n    float unpackFloat(vec4 rgbaDepth) {\n        const vec4 bitShift = vec4(1.0 / (256.0 * 256.0 * 256.0), 1.0 / (256.0 * 256.0), 1.0 / 256.0, 1.0);\n        return dot(rgbaDepth, bitShift);\n    }\n#endif\n\n// ----- Direct/Spot Sampling -----\n\n#ifdef GL2\n\nfloat _getShadowPCF3x3(SHADOWMAP_ACCEPT(shadowMap), vec3 shadowCoord, vec3 shadowParams) {\n    float z = shadowCoord.z;\n    vec2 uv = shadowCoord.xy * shadowParams.x; // 1 unit - 1 texel\n    float shadowMapSizeInv = 1.0 / shadowParams.x;\n    vec2 base_uv = floor(uv + 0.5);\n    float s = (uv.x + 0.5 - base_uv.x);\n    float t = (uv.y + 0.5 - base_uv.y);\n    base_uv -= vec2(0.5);\n    base_uv *= shadowMapSizeInv;\n\n    float sum = 0.0;\n\n    float uw0 = (3.0 - 2.0 * s);\n    float uw1 = (1.0 + 2.0 * s);\n\n    float u0 = (2.0 - s) / uw0 - 1.0;\n    float u1 = s / uw1 + 1.0;\n\n    float vw0 = (3.0 - 2.0 * t);\n    float vw1 = (1.0 + 2.0 * t);\n\n    float v0 = (2.0 - t) / vw0 - 1.0;\n    float v1 = t / vw1 + 1.0;\n\n    u0 = u0 * shadowMapSizeInv + base_uv.x;\n    v0 = v0 * shadowMapSizeInv + base_uv.y;\n\n    u1 = u1 * shadowMapSizeInv + base_uv.x;\n    v1 = v1 * shadowMapSizeInv + base_uv.y;\n\n    sum += uw0 * vw0 * textureShadow(shadowMap, vec3(u0, v0, z));\n    sum += uw1 * vw0 * textureShadow(shadowMap, vec3(u1, v0, z));\n    sum += uw0 * vw1 * textureShadow(shadowMap, vec3(u0, v1, z));\n    sum += uw1 * vw1 * textureShadow(shadowMap, vec3(u1, v1, z));\n\n    sum *= 1.0f / 16.0;\n    return sum;\n}\n\nfloat getShadowPCF3x3(SHADOWMAP_ACCEPT(shadowMap), vec3 shadowCoord, vec4 shadowParams) {\n    return _getShadowPCF3x3(SHADOWMAP_PASS(shadowMap), shadowCoord, shadowParams.xyz);\n}\n\nfloat getShadowSpotPCF3x3(SHADOWMAP_ACCEPT(shadowMap), vec3 shadowCoord, vec4 shadowParams) {\n    return _getShadowPCF3x3(SHADOWMAP_PASS(shadowMap), shadowCoord, shadowParams.xyz);\n}\n\nfloat getShadowPCF1x1(SHADOWMAP_ACCEPT(shadowMap), vec3 shadowCoord, vec4 shadowParams) {\n    return textureShadow(shadowMap, shadowCoord);\n}\n\nfloat getShadowSpotPCF1x1(SHADOWMAP_ACCEPT(shadowMap), vec3 shadowCoord, vec4 shadowParams) {\n    return textureShadow(shadowMap, shadowCoord);\n}\n\n#else // GL1\n\nfloat _xgetShadowPCF3x3(mat3 depthKernel, vec3 shadowCoord, sampler2D shadowMap, vec3 shadowParams) {\n    mat3 shadowKernel;\n    vec3 shadowZ = vec3(shadowCoord.z);\n    shadowKernel[0] = vec3(greaterThan(depthKernel[0], shadowZ));\n    shadowKernel[1] = vec3(greaterThan(depthKernel[1], shadowZ));\n    shadowKernel[2] = vec3(greaterThan(depthKernel[2], shadowZ));\n\n    vec2 fractionalCoord = fract( shadowCoord.xy * shadowParams.x );\n\n    shadowKernel[0] = mix(shadowKernel[0], shadowKernel[1], fractionalCoord.x);\n    shadowKernel[1] = mix(shadowKernel[1], shadowKernel[2], fractionalCoord.x);\n\n    vec4 shadowValues;\n    shadowValues.x = mix(shadowKernel[0][0], shadowKernel[0][1], fractionalCoord.y);\n    shadowValues.y = mix(shadowKernel[0][1], shadowKernel[0][2], fractionalCoord.y);\n    shadowValues.z = mix(shadowKernel[1][0], shadowKernel[1][1], fractionalCoord.y);\n    shadowValues.w = mix(shadowKernel[1][1], shadowKernel[1][2], fractionalCoord.y);\n\n    return dot( shadowValues, vec4( 1.0 ) ) * 0.25;\n}\n\nfloat _getShadowPCF3x3(sampler2D shadowMap, vec3 shadowCoord, vec3 shadowParams) {\n    float xoffset = 1.0 / shadowParams.x; // 1/shadow map width\n    float dx0 = -xoffset;\n    float dx1 = xoffset;\n\n    mat3 depthKernel;\n    depthKernel[0][0] = unpackFloat(textureShadow(shadowMap, shadowCoord.xy + vec2(dx0, dx0)));\n    depthKernel[0][1] = unpackFloat(textureShadow(shadowMap, shadowCoord.xy + vec2(dx0, 0.0)));\n    depthKernel[0][2] = unpackFloat(textureShadow(shadowMap, shadowCoord.xy + vec2(dx0, dx1)));\n    depthKernel[1][0] = unpackFloat(textureShadow(shadowMap, shadowCoord.xy + vec2(0.0, dx0)));\n    depthKernel[1][1] = unpackFloat(textureShadow(shadowMap, shadowCoord.xy));\n    depthKernel[1][2] = unpackFloat(textureShadow(shadowMap, shadowCoord.xy + vec2(0.0, dx1)));\n    depthKernel[2][0] = unpackFloat(textureShadow(shadowMap, shadowCoord.xy + vec2(dx1, dx0)));\n    depthKernel[2][1] = unpackFloat(textureShadow(shadowMap, shadowCoord.xy + vec2(dx1, 0.0)));\n    depthKernel[2][2] = unpackFloat(textureShadow(shadowMap, shadowCoord.xy + vec2(dx1, dx1)));\n\n    return _xgetShadowPCF3x3(depthKernel, shadowCoord, shadowMap, shadowParams);\n}\n\nfloat getShadowPCF3x3(sampler2D shadowMap, vec3 shadowCoord, vec4 shadowParams) {\n    return _getShadowPCF3x3(shadowMap, shadowCoord, shadowParams.xyz);\n}\n\nfloat getShadowSpotPCF3x3(sampler2D shadowMap, vec3 shadowCoord, vec4 shadowParams) {\n    return _getShadowPCF3x3(shadowMap, shadowCoord, shadowParams.xyz);\n}\n\nfloat _getShadowPCF1x1(sampler2D shadowMap, vec3 shadowCoord) {\n    float shadowSample = unpackFloat(textureShadow(shadowMap, shadowCoord.xy));\n    return shadowSample > shadowCoord.z ? 1.0 : 0.0;\n}\n\nfloat getShadowPCF1x1(sampler2D shadowMap, vec3 shadowCoord, vec4 shadowParams) {\n    return _getShadowPCF1x1(shadowMap, shadowCoord);\n}\n\nfloat getShadowSpotPCF1x1(sampler2D shadowMap, vec3 shadowCoord, vec4 shadowParams) {\n    return _getShadowPCF1x1(shadowMap, shadowCoord);\n}\n#endif\n\n\n// ----- Omni Sampling -----\n\n#ifndef WEBGPU\n\nfloat _getShadowPoint(samplerCube shadowMap, vec4 shadowParams, vec3 dir) {\n\n    vec3 tc = normalize(dir);\n    vec3 tcAbs = abs(tc);\n\n    vec4 dirX = vec4(1,0,0, tc.x);\n    vec4 dirY = vec4(0,1,0, tc.y);\n    float majorAxisLength = tc.z;\n    if ((tcAbs.x > tcAbs.y) && (tcAbs.x > tcAbs.z)) {\n        dirX = vec4(0,0,1, tc.z);\n        dirY = vec4(0,1,0, tc.y);\n        majorAxisLength = tc.x;\n    } else if ((tcAbs.y > tcAbs.x) && (tcAbs.y > tcAbs.z)) {\n        dirX = vec4(1,0,0, tc.x);\n        dirY = vec4(0,0,1, tc.z);\n        majorAxisLength = tc.y;\n    }\n\n    float shadowParamsInFaceSpace = ((1.0/shadowParams.x) * 2.0) * abs(majorAxisLength);\n\n    vec3 xoffset = (dirX.xyz * shadowParamsInFaceSpace);\n    vec3 yoffset = (dirY.xyz * shadowParamsInFaceSpace);\n    vec3 dx0 = -xoffset;\n    vec3 dy0 = -yoffset;\n    vec3 dx1 = xoffset;\n    vec3 dy1 = yoffset;\n\n    mat3 shadowKernel;\n    mat3 depthKernel;\n\n    depthKernel[0][0] = unpackFloat(textureCube(shadowMap, tc + dx0 + dy0));\n    depthKernel[0][1] = unpackFloat(textureCube(shadowMap, tc + dx0));\n    depthKernel[0][2] = unpackFloat(textureCube(shadowMap, tc + dx0 + dy1));\n    depthKernel[1][0] = unpackFloat(textureCube(shadowMap, tc + dy0));\n    depthKernel[1][1] = unpackFloat(textureCube(shadowMap, tc));\n    depthKernel[1][2] = unpackFloat(textureCube(shadowMap, tc + dy1));\n    depthKernel[2][0] = unpackFloat(textureCube(shadowMap, tc + dx1 + dy0));\n    depthKernel[2][1] = unpackFloat(textureCube(shadowMap, tc + dx1));\n    depthKernel[2][2] = unpackFloat(textureCube(shadowMap, tc + dx1 + dy1));\n\n    vec3 shadowZ = vec3(length(dir) * shadowParams.w + shadowParams.z);\n\n    shadowKernel[0] = vec3(lessThan2(depthKernel[0], shadowZ));\n    shadowKernel[1] = vec3(lessThan2(depthKernel[1], shadowZ));\n    shadowKernel[2] = vec3(lessThan2(depthKernel[2], shadowZ));\n\n    vec2 uv = (vec2(dirX.w, dirY.w) / abs(majorAxisLength)) * 0.5;\n\n    vec2 fractionalCoord = fract( uv * shadowParams.x );\n\n    shadowKernel[0] = mix(shadowKernel[0], shadowKernel[1], fractionalCoord.x);\n    shadowKernel[1] = mix(shadowKernel[1], shadowKernel[2], fractionalCoord.x);\n\n    vec4 shadowValues;\n    shadowValues.x = mix(shadowKernel[0][0], shadowKernel[0][1], fractionalCoord.y);\n    shadowValues.y = mix(shadowKernel[0][1], shadowKernel[0][2], fractionalCoord.y);\n    shadowValues.z = mix(shadowKernel[1][0], shadowKernel[1][1], fractionalCoord.y);\n    shadowValues.w = mix(shadowKernel[1][1], shadowKernel[1][2], fractionalCoord.y);\n\n    return 1.0 - dot( shadowValues, vec4( 1.0 ) ) * 0.25;\n}\n\nfloat getShadowPointPCF3x3(samplerCube shadowMap, vec3 shadowCoord, vec4 shadowParams, vec3 lightDir) {\n    return _getShadowPoint(shadowMap, shadowParams, lightDir);\n}\n\n#endif\n";

	var shadowStandardGL2PS = "\nfloat _getShadowPCF5x5(SHADOWMAP_ACCEPT(shadowMap), vec3 shadowCoord, vec3 shadowParams) {\n    // http://the-witness.net/news/2013/09/shadow-mapping-summary-part-1/\n\n    float z = shadowCoord.z;\n    vec2 uv = shadowCoord.xy * shadowParams.x; // 1 unit - 1 texel\n    float shadowMapSizeInv = 1.0 / shadowParams.x;\n    vec2 base_uv = floor(uv + 0.5);\n    float s = (uv.x + 0.5 - base_uv.x);\n    float t = (uv.y + 0.5 - base_uv.y);\n    base_uv -= vec2(0.5);\n    base_uv *= shadowMapSizeInv;\n\n\n    float uw0 = (4.0 - 3.0 * s);\n    float uw1 = 7.0;\n    float uw2 = (1.0 + 3.0 * s);\n\n    float u0 = (3.0 - 2.0 * s) / uw0 - 2.0;\n    float u1 = (3.0 + s) / uw1;\n    float u2 = s / uw2 + 2.0;\n\n    float vw0 = (4.0 - 3.0 * t);\n    float vw1 = 7.0;\n    float vw2 = (1.0 + 3.0 * t);\n\n    float v0 = (3.0 - 2.0 * t) / vw0 - 2.0;\n    float v1 = (3.0 + t) / vw1;\n    float v2 = t / vw2 + 2.0;\n\n    float sum = 0.0;\n\n    u0 = u0 * shadowMapSizeInv + base_uv.x;\n    v0 = v0 * shadowMapSizeInv + base_uv.y;\n\n    u1 = u1 * shadowMapSizeInv + base_uv.x;\n    v1 = v1 * shadowMapSizeInv + base_uv.y;\n\n    u2 = u2 * shadowMapSizeInv + base_uv.x;\n    v2 = v2 * shadowMapSizeInv + base_uv.y;\n\n    sum += uw0 * vw0 * textureShadow(shadowMap, vec3(u0, v0, z));\n    sum += uw1 * vw0 * textureShadow(shadowMap, vec3(u1, v0, z));\n    sum += uw2 * vw0 * textureShadow(shadowMap, vec3(u2, v0, z));\n\n    sum += uw0 * vw1 * textureShadow(shadowMap, vec3(u0, v1, z));\n    sum += uw1 * vw1 * textureShadow(shadowMap, vec3(u1, v1, z));\n    sum += uw2 * vw1 * textureShadow(shadowMap, vec3(u2, v1, z));\n\n    sum += uw0 * vw2 * textureShadow(shadowMap, vec3(u0, v2, z));\n    sum += uw1 * vw2 * textureShadow(shadowMap, vec3(u1, v2, z));\n    sum += uw2 * vw2 * textureShadow(shadowMap, vec3(u2, v2, z));\n\n    sum *= 1.0f / 144.0;\n\n    sum = saturate(sum);\n\n    return sum;\n}\n\nfloat getShadowPCF5x5(SHADOWMAP_ACCEPT(shadowMap), vec3 shadowCoord, vec4 shadowParams) {\n    return _getShadowPCF5x5(SHADOWMAP_PASS(shadowMap), shadowCoord, shadowParams.xyz);\n}\n\nfloat getShadowSpotPCF5x5(SHADOWMAP_ACCEPT(shadowMap), vec3 shadowCoord, vec4 shadowParams) {\n    return _getShadowPCF5x5(SHADOWMAP_PASS(shadowMap), shadowCoord, shadowParams.xyz);\n}\n";

	var shadowVSM8PS = "\nfloat calculateVSM8(vec3 moments, float Z, float vsmBias) {\n    float VSMBias = vsmBias;//0.01 * 0.25;\n    float depthScale = VSMBias * Z;\n    float minVariance1 = depthScale * depthScale;\n    return chebyshevUpperBound(moments.xy, Z, minVariance1, 0.1);\n}\n\nfloat decodeFloatRG(vec2 rg) {\n    return rg.y*(1.0/255.0) + rg.x;\n}\n\nfloat VSM8(TEXTURE_ACCEPT(tex), vec2 texCoords, float resolution, float Z, float vsmBias, float exponent) {\n    vec4 c = texture2D(tex, texCoords);\n    vec3 moments = vec3(decodeFloatRG(c.xy), decodeFloatRG(c.zw), 0.0);\n    return calculateVSM8(moments, Z, vsmBias);\n}\n\nfloat getShadowVSM8(TEXTURE_ACCEPT(shadowMap), vec3 shadowCoord, vec4 shadowParams, float exponent, vec3 lightDir) {\n    return VSM8(TEXTURE_PASS(shadowMap), shadowCoord.xy, shadowParams.x, shadowCoord.z, shadowParams.y, 0.0);\n}\n\nfloat getShadowSpotVSM8(TEXTURE_ACCEPT(shadowMap), vec3 shadowCoord, vec4 shadowParams, float exponent, vec3 lightDir) {\n    return VSM8(TEXTURE_PASS(shadowMap), shadowCoord.xy, shadowParams.x, length(lightDir) * shadowParams.w + shadowParams.z, shadowParams.y, 0.0);\n}\n";

	var shadowVSM_commonPS = "\nfloat linstep(float a, float b, float v) {\n    return saturate((v - a) / (b - a));\n}\n\nfloat reduceLightBleeding(float pMax, float amount) {\n   // Remove the [0, amount] tail and linearly rescale (amount, 1].\n   return linstep(amount, 1.0, pMax);\n}\n\nfloat chebyshevUpperBound(vec2 moments, float mean, float minVariance, float lightBleedingReduction) {\n    // Compute variance\n    float variance = moments.y - (moments.x * moments.x);\n    variance = max(variance, minVariance);\n\n    // Compute probabilistic upper bound\n    float d = mean - moments.x;\n    float pMax = variance / (variance + (d * d));\n\n    pMax = reduceLightBleeding(pMax, lightBleedingReduction);\n\n    // One-tailed Chebyshev\n    return (mean <= moments.x ? 1.0 : pMax);\n}\n\nfloat calculateEVSM(vec3 moments, float Z, float vsmBias, float exponent) {\n    Z = 2.0 * Z - 1.0;\n    float warpedDepth = exp(exponent * Z);\n\n    moments.xy += vec2(warpedDepth, warpedDepth*warpedDepth) * (1.0 - moments.z);\n\n    float VSMBias = vsmBias;//0.01 * 0.25;\n    float depthScale = VSMBias * exponent * warpedDepth;\n    float minVariance1 = depthScale * depthScale;\n    return chebyshevUpperBound(moments.xy, warpedDepth, minVariance1, 0.1);\n}\n";

	var skinBatchConstVS = "\nattribute float vertex_boneIndices;\n\nuniform vec4 matrix_pose[BONE_LIMIT * 3];\n\nmat4 getBoneMatrix(const in float i) {\n    // read 4x3 matrix\n    vec4 v1 = matrix_pose[int(3.0 * i)];\n    vec4 v2 = matrix_pose[int(3.0 * i + 1.0)];\n    vec4 v3 = matrix_pose[int(3.0 * i + 2.0)];\n\n    // transpose to 4x4 matrix\n    return mat4(\n        v1.x, v2.x, v3.x, 0,\n        v1.y, v2.y, v3.y, 0,\n        v1.z, v2.z, v3.z, 0,\n        v1.w, v2.w, v3.w, 1\n    );\n}\n";

	var skinBatchTexVS = "\nattribute float vertex_boneIndices;\n\nuniform highp sampler2D texture_poseMap;\nuniform vec4 texture_poseMapSize;\n\nmat4 getBoneMatrix(const in float i) {\n    float j = i * 3.0;\n    float dx = texture_poseMapSize.z;\n    float dy = texture_poseMapSize.w;\n\n    float y = floor(j * dx);\n    float x = j - (y * texture_poseMapSize.x);\n    y = dy * (y + 0.5);\n\n    // read elements of 4x3 matrix\n    vec4 v1 = texture2D(texture_poseMap, vec2(dx * (x + 0.5), y));\n    vec4 v2 = texture2D(texture_poseMap, vec2(dx * (x + 1.5), y));\n    vec4 v3 = texture2D(texture_poseMap, vec2(dx * (x + 2.5), y));\n\n    // transpose to 4x4 matrix\n    return mat4(\n        v1.x, v2.x, v3.x, 0,\n        v1.y, v2.y, v3.y, 0,\n        v1.z, v2.z, v3.z, 0,\n        v1.w, v2.w, v3.w, 1\n    );\n}\n";

	var skinConstVS = "\nattribute vec4 vertex_boneWeights;\nattribute vec4 vertex_boneIndices;\n\nuniform vec4 matrix_pose[BONE_LIMIT * 3];\n\nvoid getBoneMatrix(const in float i, out vec4 v1, out vec4 v2, out vec4 v3) {\n    // read 4x3 matrix\n    v1 = matrix_pose[int(3.0 * i)];\n    v2 = matrix_pose[int(3.0 * i + 1.0)];\n    v3 = matrix_pose[int(3.0 * i + 2.0)];\n}\n\nmat4 getSkinMatrix(const in vec4 indices, const in vec4 weights) {\n    // get 4 bone matrices\n    vec4 a1, a2, a3;\n    getBoneMatrix(indices.x, a1, a2, a3);\n\n    vec4 b1, b2, b3;\n    getBoneMatrix(indices.y, b1, b2, b3);\n\n    vec4 c1, c2, c3;\n    getBoneMatrix(indices.z, c1, c2, c3);\n\n    vec4 d1, d2, d3;\n    getBoneMatrix(indices.w, d1, d2, d3);\n\n    // multiply them by weights and add up to get final 4x3 matrix\n    vec4 v1 = a1 * weights.x + b1 * weights.y + c1 * weights.z + d1 * weights.w;\n    vec4 v2 = a2 * weights.x + b2 * weights.y + c2 * weights.z + d2 * weights.w;\n    vec4 v3 = a3 * weights.x + b3 * weights.y + c3 * weights.z + d3 * weights.w;\n\n    // add up weights\n    float one = dot(weights, vec4(1.0));\n\n    // transpose to 4x4 matrix\n    return mat4(\n        v1.x, v2.x, v3.x, 0,\n        v1.y, v2.y, v3.y, 0,\n        v1.z, v2.z, v3.z, 0,\n        v1.w, v2.w, v3.w, one\n    );\n}\n";

	var skinTexVS = "\n\nattribute vec4 vertex_boneWeights;\nattribute vec4 vertex_boneIndices;\n\nuniform highp sampler2D texture_poseMap;\nuniform vec4 texture_poseMapSize;\n\nvoid getBoneMatrix(const in float index, out vec4 v1, out vec4 v2, out vec4 v3) {\n\n    float i = float(index);\n    float j = i * 3.0;\n    float dx = texture_poseMapSize.z;\n    float dy = texture_poseMapSize.w;\n    \n    float y = floor(j * dx);\n    float x = j - (y * texture_poseMapSize.x);\n    y = dy * (y + 0.5);\n\n    // read elements of 4x3 matrix\n    v1 = texture2D(texture_poseMap, vec2(dx * (x + 0.5), y));\n    v2 = texture2D(texture_poseMap, vec2(dx * (x + 1.5), y));\n    v3 = texture2D(texture_poseMap, vec2(dx * (x + 2.5), y));\n}\n\nmat4 getSkinMatrix(const in vec4 indices, const in vec4 weights) {\n    // get 4 bone matrices\n    vec4 a1, a2, a3;\n    getBoneMatrix(indices.x, a1, a2, a3);\n\n    vec4 b1, b2, b3;\n    getBoneMatrix(indices.y, b1, b2, b3);\n\n    vec4 c1, c2, c3;\n    getBoneMatrix(indices.z, c1, c2, c3);\n\n    vec4 d1, d2, d3;\n    getBoneMatrix(indices.w, d1, d2, d3);\n\n    // multiply them by weights and add up to get final 4x3 matrix\n    vec4 v1 = a1 * weights.x + b1 * weights.y + c1 * weights.z + d1 * weights.w;\n    vec4 v2 = a2 * weights.x + b2 * weights.y + c2 * weights.z + d2 * weights.w;\n    vec4 v3 = a3 * weights.x + b3 * weights.y + c3 * weights.z + d3 * weights.w;\n\n    // add up weights\n    float one = dot(weights, vec4(1.0));\n\n    // transpose to 4x4 matrix\n    return mat4(\n        v1.x, v2.x, v3.x, 0,\n        v1.y, v2.y, v3.y, 0,\n        v1.z, v2.z, v3.z, 0,\n        v1.w, v2.w, v3.w, one\n    );\n}\n";

	var skyboxEnvPS = "\nvarying vec3 vViewDir;\n\nuniform sampler2D texture_envAtlas;\nuniform float mipLevel;\n\nvoid main(void) {\n    vec3 dir = vViewDir * vec3(-1.0, 1.0, 1.0);\n    vec2 uv = toSphericalUv(normalize(dir));\n\n    vec3 linear = $DECODE(texture2D(texture_envAtlas, mapRoughnessUv(uv, mipLevel)));\n\n    gl_FragColor = vec4(gammaCorrectOutput(toneMap(processEnvironment(linear))), 1.0);\n}\n";

	var skyboxHDRPS = "\nvarying vec3 vViewDir;\n\nuniform samplerCube texture_cubeMap;\n\nvoid main(void) {\n    vec3 dir=vViewDir;\n    dir.x *= -1.0;\n\n    vec3 linear = $DECODE(textureCube(texture_cubeMap, fixSeamsStatic(dir, $FIXCONST)));\n\n    gl_FragColor = vec4(gammaCorrectOutput(toneMap(processEnvironment(linear))), 1.0);\n}\n";

	var skyboxVS = "\nattribute vec3 aPosition;\n\n#ifndef VIEWMATRIX\n#define VIEWMATRIX\nuniform mat4 matrix_view;\n#endif\n\nuniform mat4 matrix_projectionSkybox;\nuniform mat3 cubeMapRotationMatrix;\n\nvarying vec3 vViewDir;\n\nvoid main(void) {\n    mat4 view = matrix_view;\n    view[3][0] = view[3][1] = view[3][2] = 0.0;\n    gl_Position = matrix_projectionSkybox * view * vec4(aPosition, 1.0);\n\n    // Force skybox to far Z, regardless of the clip planes on the camera\n    // Subtract a tiny fudge factor to ensure floating point errors don't\n    // still push pixels beyond far Z. See:\n    // http://www.opengl.org/discussion_boards/showthread.php/171867-skybox-problem\n\n    gl_Position.z = gl_Position.w - 0.00001;\n    vViewDir = aPosition * cubeMapRotationMatrix;\n}\n";

	var specularPS = "\n\n#ifdef MAPCOLOR\nuniform vec3 material_specular;\n#endif\n\nvoid getSpecularity() {\n    vec3 specularColor = vec3(1,1,1);\n\n    #ifdef MAPCOLOR\n    specularColor *= material_specular;\n    #endif\n\n    #ifdef MAPTEXTURE\n    specularColor *= $DECODE(texture2DBias($SAMPLER, $UV, textureBias)).$CH;\n    #endif\n\n    #ifdef MAPVERTEX\n    specularColor *= saturate(vVertexColor.$VC);\n    #endif\n\n    dSpecularity = specularColor;\n}\n";

	var sphericalPS = "\n// equirectangular helper functions\nconst float PI = 3.141592653589793;\n\nvec2 toSpherical(vec3 dir) {\n    return vec2(dir.xz == vec2(0.0) ? 0.0 : atan(dir.x, dir.z), asin(dir.y));\n}\n\nvec2 toSphericalUv(vec3 dir) {\n    vec2 uv = toSpherical(dir) / vec2(PI * 2.0, PI) + 0.5;\n    return vec2(uv.x, 1.0 - uv.y);\n}\n";

	var specularityFactorPS = "\n\n#ifdef MAPFLOAT\nuniform float material_specularityFactor;\n#endif\n\nvoid getSpecularityFactor() {\n    float specularityFactor = 1.0;\n\n    #ifdef MAPFLOAT\n    specularityFactor *= material_specularityFactor;\n    #endif\n\n    #ifdef MAPTEXTURE\n    specularityFactor *= texture2DBias($SAMPLER, $UV, textureBias).$CH;\n    #endif\n\n    #ifdef MAPVERTEX\n    specularityFactor *= saturate(vVertexColor.$VC);\n    #endif\n\n    dSpecularityFactor = specularityFactor;\n}\n";

	var spotPS = "\nfloat getSpotEffect(vec3 lightSpotDir, float lightInnerConeAngle, float lightOuterConeAngle, vec3 lightDirNorm) {\n    float cosAngle = dot(lightDirNorm, lightSpotDir);\n    return smoothstep(lightOuterConeAngle, lightInnerConeAngle, cosAngle);\n}\n";

	var startPS = "\nvoid main(void) {\n    dReflection = vec4(0);\n\n    #ifdef LIT_CLEARCOAT\n    ccSpecularLight = vec3(0);\n    ccReflection = vec3(0);\n    #endif\n";

	var startVS = "\nvoid main(void) {\n    gl_Position = getPosition();\n";

	var startNineSlicedPS = "\n    nineSlicedUv = vUv0;\n    nineSlicedUv.y = 1.0 - nineSlicedUv.y;\n\n";

	var startNineSlicedTiledPS = "\n    vec2 tileMask = step(vMask, vec2(0.99999));\n    vec2 tileSize = 0.5 * (innerOffset.xy + innerOffset.zw);\n    vec2 tileScale = vec2(1.0) / (vec2(1.0) - tileSize);\n    vec2 clampedUv = mix(innerOffset.xy * 0.5, vec2(1.0) - innerOffset.zw * 0.5, fract((vTiledUv - tileSize) * tileScale));\n    clampedUv = clampedUv * atlasRect.zw + atlasRect.xy;\n    nineSlicedUv = vUv0 * tileMask + clampedUv * (vec2(1.0) - tileMask);\n    nineSlicedUv.y = 1.0 - nineSlicedUv.y;\n    \n";

	var storeEVSMPS = "\nfloat exponent = VSM_EXPONENT;\n\ndepth = 2.0 * depth - 1.0;\ndepth =  exp(exponent * depth);\ngl_FragColor = vec4(depth, depth*depth, 1.0, 1.0);\n";

	var tangentBinormalVS = "\nvec3 getTangent() {\n    return normalize(dNormalMatrix * vertex_tangent.xyz);\n}\n\nvec3 getBinormal() {\n    return cross(vNormalW, vTangentW) * vertex_tangent.w;\n}\n";

	var TBNPS = "\nvoid getTBN(vec3 tangent, vec3 binormal, vec3 normal) {\n    dTBN = mat3(normalize(tangent), normalize(binormal), normalize(normal));\n}\n";

	var TBNderivativePS = "\nuniform float tbnBasis;\n\n// http://www.thetenthplanet.de/archives/1180\nvoid getTBN(vec3 tangent, vec3 binormal, vec3 normal) {\n    vec2 uv = $UV;\n\n    // get edge vectors of the pixel triangle\n    vec3 dp1 = dFdx( vPositionW );\n    vec3 dp2 = dFdy( vPositionW );\n    vec2 duv1 = dFdx( uv );\n    vec2 duv2 = dFdy( uv );\n\n    // solve the linear system\n    vec3 dp2perp = cross( dp2, normal );\n    vec3 dp1perp = cross( normal, dp1 );\n    vec3 T = dp2perp * duv1.x + dp1perp * duv2.x;\n    vec3 B = dp2perp * duv1.y + dp1perp * duv2.y;\n\n    // construct a scale-invariant frame\n    float denom = max( dot(T,T), dot(B,B) );\n    float invmax = (denom == 0.0) ? 0.0 : tbnBasis / sqrt( denom );\n    dTBN = mat3(T * invmax, -B * invmax, normal );\n}\n";

	var TBNfastPS = "\nvoid getTBN(vec3 tangent, vec3 binormal, vec3 normal) {\n    dTBN = mat3(tangent, binormal, normal);\n}\n";

	var TBNObjectSpacePS = "\nvoid getTBN(vec3 tangent, vec3 binormal, vec3 normal) {\n\n    vec3 B = cross(normal, vObjectSpaceUpW);\n    vec3 T = cross(normal, B);\n\n    if (dot(B,B)==0.0) // deal with case when vObjectSpaceUpW normal are parallel\n    {\n        float major=max(max(normal.x, normal.y), normal.z);\n\n        if (normal.x == major)\n        {\n            B=cross(normal, vec3(0,1,0));\n            T=cross(normal, B);\n        }\n        else if (normal.y == major)\n        {\n            B=cross(normal, vec3(0,0,1));\n            T=cross(normal, B);\n        }\n        else if (normal.z == major)\n        {\n            B=cross(normal, vec3(1,0,0));\n            T=cross(normal, B);\n        }\n    }\n\n    dTBN = mat3(normalize(T), normalize(B), normalize(normal));\n}\n";

	var textureSamplePS = "\nvec4 texture2DSRGB(sampler2D tex, vec2 uv) {\n    return gammaCorrectInput(texture2D(tex, uv));\n}\n\nvec4 texture2DSRGB(sampler2D tex, vec2 uv, float bias) {\n    return gammaCorrectInput(texture2D(tex, uv, bias));\n}\n\nvec3 texture2DRGBM(sampler2D tex, vec2 uv) {\n    return decodeRGBM(texture2D(tex, uv));\n}\n\nvec3 texture2DRGBM(sampler2D tex, vec2 uv, float bias) {\n    return decodeRGBM(texture2D(tex, uv, bias));\n}\n\nvec3 texture2DRGBE(sampler2D tex, vec2 uv) {\n    return decodeRGBM(texture2D(tex, uv));\n}\n\nvec3 texture2DRGBE(sampler2D tex, vec2 uv, float bias) {\n    return decodeRGBM(texture2D(tex, uv, bias));\n}\n";

	var thicknessPS = "\n#ifdef MAPFLOAT\nuniform float material_thickness;\n#endif\n\nvoid getThickness() {\n    dThickness = 1.0;\n\n    #ifdef MAPFLOAT\n    dThickness *= material_thickness;\n    #endif\n\n    #ifdef MAPTEXTURE\n    dThickness *= texture2DBias($SAMPLER, $UV, textureBias).$CH;\n    #endif\n\n    #ifdef MAPVERTEX\n    dThickness *= saturate(vVertexColor.$VC);\n    #endif\n}\n";

	var tonemappingAcesPS = "\nuniform float exposure;\n\nvec3 toneMap(vec3 color) {\n    float tA = 2.51;\n    float tB = 0.03;\n    float tC = 2.43;\n    float tD = 0.59;\n    float tE = 0.14;\n    vec3 x = color * exposure;\n    return (x*(tA*x+tB))/(x*(tC*x+tD)+tE);\n}\n";

	var tonemappingAces2PS = "\nuniform float exposure;\n\n// ACES approximation by Stephen Hill\n\n// sRGB => XYZ => D65_2_D60 => AP1 => RRT_SAT\nconst mat3 ACESInputMat = mat3(\n    0.59719, 0.35458, 0.04823,\n    0.07600, 0.90834, 0.01566,\n    0.02840, 0.13383, 0.83777\n);\n\n// ODT_SAT => XYZ => D60_2_D65 => sRGB\nconst mat3 ACESOutputMat = mat3(\n     1.60475, -0.53108, -0.07367,\n    -0.10208,  1.10813, -0.00605,\n    -0.00327, -0.07276,  1.07602\n);\n\nvec3 RRTAndODTFit(vec3 v) {\n    vec3 a = v * (v + 0.0245786) - 0.000090537;\n    vec3 b = v * (0.983729 * v + 0.4329510) + 0.238081;\n    return a / b;\n}\n\nvec3 toneMap(vec3 color) {\n    color *= exposure / 0.6;\n    color = color * ACESInputMat;\n\n    // Apply RRT and ODT\n    color = RRTAndODTFit(color);\n    color = color * ACESOutputMat;\n\n    // Clamp to [0, 1]\n    color = clamp(color, 0.0, 1.0);\n\n    return color;\n}\n";

	var tonemappingFilmicPS = "\nconst float A =  0.15;\nconst float B =  0.50;\nconst float C =  0.10;\nconst float D =  0.20;\nconst float E =  0.02;\nconst float F =  0.30;\nconst float W =  11.2;\n\nuniform float exposure;\n\nvec3 uncharted2Tonemap(vec3 x) {\n   return ((x*(A*x+C*B)+D*E)/(x*(A*x+B)+D*F))-E/F;\n}\n\nvec3 toneMap(vec3 color) {\n    color = uncharted2Tonemap(color * exposure);\n    vec3 whiteScale = 1.0 / uncharted2Tonemap(vec3(W,W,W));\n    color = color * whiteScale;\n\n    return color;\n}\n";

	var tonemappingHejlPS = "\nuniform float exposure;\n\nvec3 toneMap(vec3 color) {\n    color *= exposure;\n    const float  A = 0.22, B = 0.3, C = .1, D = 0.2, E = .01, F = 0.3;\n    const float Scl = 1.25;\n\n    vec3 h = max( vec3(0.0), color - vec3(0.004) );\n    return (h*((Scl*A)*h+Scl*vec3(C*B,C*B,C*B))+Scl*vec3(D*E,D*E,D*E)) / (h*(A*h+vec3(B,B,B))+vec3(D*F,D*F,D*F)) - Scl*vec3(E/F,E/F,E/F);\n}\n";

	var tonemappingLinearPS = "\nuniform float exposure;\n\nvec3 toneMap(vec3 color) {\n    return color * exposure;\n}\n";

	var tonemappingNonePS = "\nvec3 toneMap(vec3 color) {\n    return color;\n}\n";

	var transformVS = "\n#ifdef PIXELSNAP\nuniform vec4 uScreenSize;\n#endif\n\n#ifdef SCREENSPACE\nuniform float projectionFlipY;\n#endif\n\n#ifdef MORPHING\nuniform vec4 morph_weights_a;\nuniform vec4 morph_weights_b;\n#endif\n\n#ifdef MORPHING_TEXTURE_BASED\n    uniform vec4 morph_tex_params;\n\n    #ifdef WEBGPU\n        ivec2 getTextureMorphCoords() {\n\n            // turn morph_vertex_id into int grid coordinates\n            ivec2 textureSize = ivec2(morph_tex_params.xy);\n            int morphGridV = int(morph_vertex_id / textureSize.x);\n            int morphGridU = int(morph_vertex_id - (morphGridV * textureSize.x));\n            morphGridV = textureSize.y - morphGridV - 1;\n            return ivec2(morphGridU, morphGridV);\n        }\n    #else\n        vec2 getTextureMorphCoords() {\n            vec2 textureSize = morph_tex_params.xy;\n            vec2 invTextureSize = morph_tex_params.zw;\n\n            // turn morph_vertex_id into int grid coordinates\n            float morphGridV = floor(morph_vertex_id * invTextureSize.x);\n            float morphGridU = morph_vertex_id - (morphGridV * textureSize.x);\n\n            // convert grid coordinates to uv coordinates with half pixel offset\n            return vec2(morphGridU, morphGridV) * invTextureSize + (0.5 * invTextureSize);\n        }\n    #endif\n\n#endif\n\n#ifdef MORPHING_TEXTURE_BASED_POSITION\nuniform highp sampler2D morphPositionTex;\n#endif\n\nmat4 getModelMatrix() {\n    #ifdef DYNAMICBATCH\n    return getBoneMatrix(vertex_boneIndices);\n    #elif defined(SKIN)\n    return matrix_model * getSkinMatrix(vertex_boneIndices, vertex_boneWeights);\n    #elif defined(INSTANCING)\n    return mat4(instance_line1, instance_line2, instance_line3, instance_line4);\n    #else\n    return matrix_model;\n    #endif\n}\n\nvec4 getPosition() {\n    dModelMatrix = getModelMatrix();\n    vec3 localPos = vertex_position;\n\n    #ifdef NINESLICED\n    // outer and inner vertices are at the same position, scale both\n    localPos.xz *= outerScale;\n\n    // offset inner vertices inside\n    // (original vertices must be in [-1;1] range)\n    vec2 positiveUnitOffset = clamp(vertex_position.xz, vec2(0.0), vec2(1.0));\n    vec2 negativeUnitOffset = clamp(-vertex_position.xz, vec2(0.0), vec2(1.0));\n    localPos.xz += (-positiveUnitOffset * innerOffset.xy + negativeUnitOffset * innerOffset.zw) * vertex_texCoord0.xy;\n\n    vTiledUv = (localPos.xz - outerScale + innerOffset.xy) * -0.5 + 1.0; // uv = local pos - inner corner\n\n    localPos.xz *= -0.5; // move from -1;1 to -0.5;0.5\n    localPos = localPos.xzy;\n    #endif\n\n    #ifdef MORPHING\n    #ifdef MORPHING_POS03\n    localPos.xyz += morph_weights_a[0] * morph_pos0;\n    localPos.xyz += morph_weights_a[1] * morph_pos1;\n    localPos.xyz += morph_weights_a[2] * morph_pos2;\n    localPos.xyz += morph_weights_a[3] * morph_pos3;\n    #endif // MORPHING_POS03\n    #ifdef MORPHING_POS47\n    localPos.xyz += morph_weights_b[0] * morph_pos4;\n    localPos.xyz += morph_weights_b[1] * morph_pos5;\n    localPos.xyz += morph_weights_b[2] * morph_pos6;\n    localPos.xyz += morph_weights_b[3] * morph_pos7;\n    #endif // MORPHING_POS47\n    #endif // MORPHING\n\n    #ifdef MORPHING_TEXTURE_BASED_POSITION\n\n        #ifdef WEBGPU\n            ivec2 morphUV = getTextureMorphCoords();\n            vec3 morphPos = texelFetch(morphPositionTex, ivec2(morphUV), 0).xyz;\n        #else\n            vec2 morphUV = getTextureMorphCoords();\n            vec3 morphPos = texture2D(morphPositionTex, morphUV).xyz;\n        #endif\n\n        localPos += morphPos;\n\n    #endif\n\n    vec4 posW = dModelMatrix * vec4(localPos, 1.0);\n    #ifdef SCREENSPACE\n    posW.zw = vec2(0.0, 1.0);\n    #endif\n    dPositionW = posW.xyz;\n\n    vec4 screenPos;\n    #ifdef UV1LAYOUT\n    screenPos = vec4(vertex_texCoord1.xy * 2.0 - 1.0, 0.5, 1);\n    #else\n    #ifdef SCREENSPACE\n    screenPos = posW;\n    screenPos.y *= projectionFlipY;\n    #else\n    screenPos = matrix_viewProjection * posW;\n    #endif\n\n    #ifdef PIXELSNAP\n    // snap vertex to a pixel boundary\n    screenPos.xy = (screenPos.xy * 0.5) + 0.5;\n    screenPos.xy *= uScreenSize.xy;\n    screenPos.xy = floor(screenPos.xy);\n    screenPos.xy *= uScreenSize.zw;\n    screenPos.xy = (screenPos.xy * 2.0) - 1.0;\n    #endif\n    #endif\n\n    return screenPos;\n}\n\nvec3 getWorldPosition() {\n    return dPositionW;\n}\n";

	var transformDeclVS = "\nattribute vec3 vertex_position;\n\nuniform mat4 matrix_model;\nuniform mat4 matrix_viewProjection;\n\nvec3 dPositionW;\nmat4 dModelMatrix;\n";

	var transmissionPS = "\n\n#ifdef MAPFLOAT\nuniform float material_refraction;\n#endif\n\nvoid getRefraction() {\n    float refraction = 1.0;\n\n    #ifdef MAPFLOAT\n    refraction = material_refraction;\n    #endif\n\n    #ifdef MAPTEXTURE\n    refraction *= texture2DBias($SAMPLER, $UV, textureBias).$CH;\n    #endif\n\n    #ifdef MAPVERTEX\n    refraction *= saturate(vVertexColor.$VC);\n    #endif\n\n    dTransmission = refraction;\n}\n";

	var uv0VS = "\n#ifdef NINESLICED\nvec2 getUv0() {\n    vec2 uv = vertex_position.xz;\n\n    // offset inner vertices inside\n    // (original vertices must be in [-1;1] range)\n    vec2 positiveUnitOffset = clamp(vertex_position.xz, vec2(0.0), vec2(1.0));\n    vec2 negativeUnitOffset = clamp(-vertex_position.xz, vec2(0.0), vec2(1.0));\n    uv += (-positiveUnitOffset * innerOffset.xy + negativeUnitOffset * innerOffset.zw) * vertex_texCoord0.xy;\n\n    uv = uv * -0.5 + 0.5;\n    uv = uv * atlasRect.zw + atlasRect.xy;\n\n    vMask = vertex_texCoord0.xy;\n\n    return uv;\n}\n#else\nvec2 getUv0() {\n    return vertex_texCoord0;\n}\n#endif\n";

	var uv1VS = "\nvec2 getUv1() {\n    return vertex_texCoord1;\n}\n";

	var viewDirPS = "\nvoid getViewDir() {\n    dViewDirW = normalize(view_position - vPositionW);\n}\n";

	var viewNormalVS = "\n#ifndef VIEWMATRIX\n#define VIEWMATRIX\nuniform mat4 matrix_view;\n#endif\n\nvec3 getViewNormal() {\n    return mat3(matrix_view) * vNormalW;\n}\n";

	var shaderChunks = {
		alphaTestPS: alphaTestPS,
		ambientConstantPS: ambientConstantPS,
		ambientEnvPS: ambientEnvPS,
		ambientSHPS: ambientSHPS,
		aoPS: aoPS,
		aoDetailMapPS: aoDetailMapPS,
		aoDiffuseOccPS: aoDiffuseOccPS,
		aoSpecOccPS: aoSpecOccPS,
		aoSpecOccConstPS: aoSpecOccConstPS,
		aoSpecOccConstSimplePS: aoSpecOccConstSimplePS,
		aoSpecOccSimplePS: aoSpecOccSimplePS,
		basePS: basePS,
		baseVS: baseVS,
		baseNineSlicedPS: baseNineSlicedPS,
		baseNineSlicedVS: baseNineSlicedVS,
		baseNineSlicedTiledPS: baseNineSlicedTiledPS,
		biasConstPS: biasConstPS,
		blurVSMPS: blurVSMPS,
		clearCoatPS: clearCoatPS,
		clearCoatGlossPS: clearCoatGlossPS,
		clearCoatNormalPS: clearCoatNormalPS,
		clusteredLightCookiesPS: clusteredLightCookiesPS,
		clusteredLightShadowsPS: clusteredLightShadowsPS,
		clusteredLightUtilsPS: clusteredLightUtilsPS,
		clusteredLightPS: clusteredLightPS,
		combinePS: combinePS,
		cookiePS: cookiePS,
		cubeMapProjectBoxPS: cubeMapProjectBoxPS,
		cubeMapProjectNonePS: cubeMapProjectNonePS,
		cubeMapRotatePS: cubeMapRotatePS,
		debugOutputPS: debugOutputPS,
		debugProcessFrontendPS: debugProcessFrontendPS,
		detailModesPS: detailModesPS,
		diffusePS: diffusePS,
		diffuseDetailMapPS: diffuseDetailMapPS,
		decodePS: decodePS,
		emissivePS: emissivePS,
		encodePS: encodePS,
		endPS: endPS,
		endVS: endVS,
		envAtlasPS: envAtlasPS,
		envConstPS: envConstPS,
		envMultiplyPS: envMultiplyPS,
		extensionPS: extensionPS,
		extensionVS: extensionVS,
		falloffInvSquaredPS: falloffInvSquaredPS,
		falloffLinearPS: falloffLinearPS,
		fixCubemapSeamsNonePS: fixCubemapSeamsNonePS,
		fixCubemapSeamsStretchPS: fixCubemapSeamsStretchPS,
		floatUnpackingPS: floatUnpackingPS,
		fogExpPS: fogExpPS,
		fogExp2PS: fogExp2PS,
		fogLinearPS: fogLinearPS,
		fogNonePS: fogNonePS,
		fresnelSchlickPS: fresnelSchlickPS,
		fullscreenQuadPS: fullscreenQuadPS,
		fullscreenQuadVS: fullscreenQuadVS,
		gamma1_0PS: gamma1_0PS,
		gamma2_2PS: gamma2_2PS,
		gles2PS: gles2PS,
		gles3PS: gles3PS,
		gles3VS: gles3VS,
		glossPS: glossPS,
		iridescenceDiffractionPS: iridescenceDiffractionPS,
		iridescencePS: iridescencePS,
		iridescenceThicknessPS: iridescenceThicknessPS,
		instancingVS: instancingVS,
		iorPS: iorPS,
		lightDiffuseLambertPS: lightDiffuseLambertPS,
		lightDirPointPS: lightDirPointPS,
		lightmapAddPS: lightmapAddPS,
		lightmapDirAddPS: lightmapDirAddPS,
		lightmapDirPS: lightmapDirPS,
		lightmapSinglePS: lightmapSinglePS,
		lightSpecularAnisoGGXPS: lightSpecularAnisoGGXPS,
		lightSpecularBlinnPS: lightSpecularBlinnPS,
		lightSpecularPhongPS: lightSpecularPhongPS,
		lightSheenPS: lightSheenPS,
		linearizeDepthPS: linearizeDepthPS,
		litShaderArgsPS: litShaderArgsPS,
		ltcPS: ltcPS,
		metalnessPS: metalnessPS,
		metalnessModulatePS: metalnessModulatePS,
		msdfPS: msdfPS,
		msdfVS: msdfVS,
		normalVS: normalVS,
		normalDetailMapPS: normalDetailMapPS,
		normalInstancedVS: normalInstancedVS,
		normalMapPS: normalMapPS,
		normalSkinnedVS: normalSkinnedVS,
		normalXYPS: normalXYPS,
		normalXYZPS: normalXYZPS,
		opacityPS: opacityPS,
		outputPS: outputPS,
		outputAlphaPS: outputAlphaPS,
		outputAlphaOpaquePS: outputAlphaOpaquePS,
		outputAlphaPremulPS: outputAlphaPremulPS,
		outputTex2DPS: outputTex2DPS,
		packDepthPS: packDepthPS,
		sheenPS: sheenPS,
		sheenGlossPS: sheenGlossPS,
		parallaxPS: parallaxPS,
		particlePS: particlePS,
		particleVS: particleVS,
		particleAnimFrameClampVS: particleAnimFrameClampVS,
		particleAnimFrameLoopVS: particleAnimFrameLoopVS,
		particleAnimTexVS: particleAnimTexVS,
		particleInputFloatPS: particleInputFloatPS,
		particleInputRgba8PS: particleInputRgba8PS,
		particleOutputFloatPS: particleOutputFloatPS,
		particleOutputRgba8PS: particleOutputRgba8PS,
		particleUpdaterAABBPS: particleUpdaterAABBPS,
		particleUpdaterEndPS: particleUpdaterEndPS,
		particleUpdaterInitPS: particleUpdaterInitPS,
		particleUpdaterNoRespawnPS: particleUpdaterNoRespawnPS,
		particleUpdaterOnStopPS: particleUpdaterOnStopPS,
		particleUpdaterRespawnPS: particleUpdaterRespawnPS,
		particleUpdaterSpherePS: particleUpdaterSpherePS,
		particleUpdaterStartPS: particleUpdaterStartPS,
		particle_billboardVS: particle_billboardVS,
		particle_blendAddPS: particle_blendAddPS,
		particle_blendMultiplyPS: particle_blendMultiplyPS,
		particle_blendNormalPS: particle_blendNormalPS,
		particle_cpuVS: particle_cpuVS,
		particle_cpu_endVS: particle_cpu_endVS,
		particle_customFaceVS: particle_customFaceVS,
		particle_endPS: particle_endPS,
		particle_endVS: particle_endVS,
		particle_halflambertPS: particle_halflambertPS,
		particle_initVS: particle_initVS,
		particle_lambertPS: particle_lambertPS,
		particle_lightingPS: particle_lightingPS,
		particle_localShiftVS: particle_localShiftVS,
		particle_meshVS: particle_meshVS,
		particle_normalVS: particle_normalVS,
		particle_normalMapPS: particle_normalMapPS,
		particle_pointAlongVS: particle_pointAlongVS,
		particle_softPS: particle_softPS,
		particle_softVS: particle_softVS,
		particle_stretchVS: particle_stretchVS,
		particle_TBNVS: particle_TBNVS,
		particle_wrapVS: particle_wrapVS,
		reflDirPS: reflDirPS,
		reflDirAnisoPS: reflDirAnisoPS,
		reflectionCCPS: reflectionCCPS,
		reflectionCubePS: reflectionCubePS,
		reflectionEnvHQPS: reflectionEnvHQPS,
		reflectionEnvPS: reflectionEnvPS,
		reflectionSpherePS: reflectionSpherePS,
		reflectionSphereLowPS: reflectionSphereLowPS,
		reflectionSheenPS: reflectionSheenPS,
		refractionCubePS: refractionCubePS,
		refractionDynamicPS: refractionDynamicPS,
		reprojectPS: reprojectPS,
		screenDepthPS: screenDepthPS,
		shadowCascadesPS: shadowCascadesPS,
		shadowEVSMPS: shadowEVSMPS,
		shadowEVSMnPS: shadowEVSMnPS,
		shadowPCSSPS: shadowPCSSPS,
		shadowSampleCoordPS: shadowSampleCoordPS,
		shadowStandardPS: shadowStandardPS,
		shadowStandardGL2PS: shadowStandardGL2PS,
		shadowVSM8PS: shadowVSM8PS,
		shadowVSM_commonPS: shadowVSM_commonPS,
		skinBatchConstVS: skinBatchConstVS,
		skinBatchTexVS: skinBatchTexVS,
		skinConstVS: skinConstVS,
		skinTexVS: skinTexVS,
		skyboxEnvPS: skyboxEnvPS,
		skyboxHDRPS: skyboxHDRPS,
		skyboxVS: skyboxVS,
		specularPS: specularPS,
		sphericalPS: sphericalPS,
		specularityFactorPS: specularityFactorPS,
		spotPS: spotPS,
		startPS: startPS,
		startVS: startVS,
		startNineSlicedPS: startNineSlicedPS,
		startNineSlicedTiledPS: startNineSlicedTiledPS,
		storeEVSMPS: storeEVSMPS,
		tangentBinormalVS: tangentBinormalVS,
		TBNPS: TBNPS,
		TBNderivativePS: TBNderivativePS,
		TBNfastPS: TBNfastPS,
		TBNObjectSpacePS: TBNObjectSpacePS,
		textureSamplePS: textureSamplePS,
		thicknessPS: thicknessPS,
		tonemappingAcesPS: tonemappingAcesPS,
		tonemappingAces2PS: tonemappingAces2PS,
		tonemappingFilmicPS: tonemappingFilmicPS,
		tonemappingHejlPS: tonemappingHejlPS,
		tonemappingLinearPS: tonemappingLinearPS,
		tonemappingNonePS: tonemappingNonePS,
		transformVS: transformVS,
		transformDeclVS: transformDeclVS,
		transmissionPS: transmissionPS,
		uv0VS: uv0VS,
		uv1VS: uv1VS,
		viewDirPS: viewDirPS,
		viewNormalVS: viewNormalVS,
		webgpuPS: webgpuPS,
		webgpuVS: webgpuVS
	};

	var programLibraryDeviceCache = new DeviceCache();
	function getProgramLibrary(device) {
		var library = programLibraryDeviceCache.get(device);
		return library;
	}
	function setProgramLibrary(device, library) {
		programLibraryDeviceCache.get(device, function () {
			return library;
		});
	}

	function createShader(device, vsName, fsName, useTransformFeedback) {
		if (useTransformFeedback === void 0) {
			useTransformFeedback = false;
		}
		return new Shader(device, ShaderUtils.createDefinition(device, {
			name: vsName + "_" + fsName,
			vertexCode: shaderChunks[vsName],
			fragmentCode: shaderChunks[fsName],
			useTransformFeedback: useTransformFeedback
		}));
	}
	function createShaderFromCode(device, vsCode, fsCode, uniqueName, attributes, useTransformFeedback) {
		if (useTransformFeedback === void 0) {
			useTransformFeedback = false;
		}
		var programLibrary = getProgramLibrary(device);
		var shader = programLibrary.getCachedShader(uniqueName);
		if (!shader) {
			shader = new Shader(device, ShaderUtils.createDefinition(device, {
				name: uniqueName,
				vertexCode: vsCode,
				fragmentCode: fsCode,
				attributes: attributes,
				useTransformFeedback: useTransformFeedback
			}));
			programLibrary.setCachedShader(uniqueName, shader);
		}
		return shader;
	}
	function processShader(shader, processingOptions) {
		var _shaderDefinition$nam;
		var shaderDefinition = shader.definition;
		var name = (_shaderDefinition$nam = shaderDefinition.name) != null ? _shaderDefinition$nam : 'shader';
		var key = name + "-id-" + shader.id;
		var materialGenerator = {
			generateKey: function generateKey(options) {
				return key;
			},
			createShaderDefinition: function createShaderDefinition(device, options) {
				return shaderDefinition;
			}
		};
		var libraryModuleName = 'shader';
		var library = getProgramLibrary(shader.device);
		library.register(libraryModuleName, materialGenerator);
		var variant = library.getProgram(libraryModuleName, {}, processingOptions);
		library.unregister(libraryModuleName);
		return variant;
	}
	shaderChunks.createShader = createShader;
	shaderChunks.createShaderFromCode = createShaderFromCode;

	var _quadPrimitive = {
		type: PRIMITIVE_TRISTRIP,
		base: 0,
		count: 4,
		indexed: false
	};
	var _tempViewport = new Vec4();
	var _tempScissor = new Vec4();
	var QuadRender = function () {
		function QuadRender(shader) {
			this.uniformBuffer = void 0;
			this.bindGroup = void 0;
			var device = shader.device;
			this.shader = shader;
			if (device.supportsUniformBuffers) {
				var processingOptions = new ShaderProcessorOptions();
				this.shader = processShader(shader, processingOptions);
				var ubFormat = this.shader.meshUniformBufferFormat;
				if (ubFormat) {
					this.uniformBuffer = new UniformBuffer(device, ubFormat, false);
				}
				var bindGroupFormat = this.shader.meshBindGroupFormat;
				this.bindGroup = new BindGroup(device, bindGroupFormat, this.uniformBuffer);
			}
		}
		var _proto = QuadRender.prototype;
		_proto.destroy = function destroy() {
			var _this$uniformBuffer, _this$bindGroup;
			(_this$uniformBuffer = this.uniformBuffer) == null ? void 0 : _this$uniformBuffer.destroy();
			this.uniformBuffer = null;
			(_this$bindGroup = this.bindGroup) == null ? void 0 : _this$bindGroup.destroy();
			this.bindGroup = null;
		};
		_proto.render = function render(viewport, scissor) {
			var device = this.shader.device;
			if (viewport) {
				var _scissor;
				_tempViewport.set(device.vx, device.vy, device.vw, device.vh);
				_tempScissor.set(device.sx, device.sy, device.sw, device.sh);
				scissor = (_scissor = scissor) != null ? _scissor : viewport;
				device.setViewport(viewport.x, viewport.y, viewport.z, viewport.w);
				device.setScissor(scissor.x, scissor.y, scissor.z, scissor.w);
			}
			device.setVertexBuffer(device.quadVertexBuffer, 0);
			var shader = this.shader;
			device.setShader(shader);
			if (device.supportsUniformBuffers) {
				var _bindGroup$defaultUni;
				var bindGroup = this.bindGroup;
				(_bindGroup$defaultUni = bindGroup.defaultUniformBuffer) == null ? void 0 : _bindGroup$defaultUni.update();
				bindGroup.update();
				device.setBindGroup(BINDGROUP_MESH, bindGroup);
			}
			device.draw(_quadPrimitive);
			if (viewport) {
				device.setViewport(_tempViewport.x, _tempViewport.y, _tempViewport.z, _tempViewport.w);
				device.setScissor(_tempScissor.x, _tempScissor.y, _tempScissor.z, _tempScissor.w);
			}
		};
		return QuadRender;
	}();

	var _tempRect = new Vec4();
	function drawQuadWithShader(device, target, shader, rect, scissorRect) {
		device.setCullMode(CULLFACE_NONE);
		device.setDepthState(DepthState.NODEPTH);
		device.setStencilState(null, null);
		var quad = new QuadRender(shader);
		if (!rect) {
			rect = _tempRect;
			rect.x = 0;
			rect.y = 0;
			rect.z = target ? target.width : device.width;
			rect.w = target ? target.height : device.height;
		}
		var renderPass = new RenderPass(device, function () {
			quad.render(rect, scissorRect);
		});
		renderPass.init(target);
		renderPass.colorOps.clear = false;
		renderPass.depthStencilOps.clearDepth = false;
		if (device.isWebGPU && target === null) {
			var _target$samples;
			var samples = (_target$samples = target == null ? void 0 : target.samples) != null ? _target$samples : device.samples;
			if (samples > 1) renderPass.colorOps.store = true;
		}
		renderPass.render();
		quad.destroy();
	}
	function drawTexture(device, texture, target, shader, rect, scissorRect) {
		shader = shader || device.getCopyShader();
		device.constantTexSource.setValue(texture);
		drawQuadWithShader(device, target, shader, rect, scissorRect);
	}

	var shaderPassDeviceCache = new DeviceCache();
	var ShaderPassInfo = function () {
		function ShaderPassInfo(name, index, options) {
			if (options === void 0) {
				options = {};
			}
			this.index = void 0;
			this.name = void 0;
			this.shaderDefine = void 0;
			this.name = name;
			this.index = index;
			Object.assign(this, options);
			this.initShaderDefines();
		}
		var _proto = ShaderPassInfo.prototype;
		_proto.initShaderDefines = function initShaderDefines() {
			var keyword;
			if (this.isShadow) {
				keyword = 'SHADOW';
			} else if (this.isForward) {
				keyword = 'FORWARD';
			} else if (this.index === SHADER_DEPTH) {
				keyword = 'DEPTH';
			} else if (this.index === SHADER_PICK) {
				keyword = 'PICK';
			}
			var define1 = keyword ? "#define " + keyword + "_PASS\n" : '';
			var define2 = "#define " + this.name.toUpperCase() + "_PASS\n";
			this.shaderDefines = define1 + define2;
		};
		return ShaderPassInfo;
	}();
	var ShaderPass = function () {
		function ShaderPass() {
			var _this = this;
			this.passesNamed = new Map();
			this.passesIndexed = [];
			this.nextIndex = 0;
			var add = function add(name, index, options) {
				_this.allocate(name, options);
			};
			add('forward', SHADER_FORWARD, {
				isForward: true
			});
			add('forward_hdr', SHADER_FORWARDHDR, {
				isForward: true
			});
			add('depth');
			add('pick');
			add('shadow');
		}
		ShaderPass.get = function get(device) {
			return shaderPassDeviceCache.get(device, function () {
				return new ShaderPass();
			});
		};
		var _proto2 = ShaderPass.prototype;
		_proto2.allocate = function allocate(name, options) {
			var info = this.passesNamed.get(name);
			if (info === undefined) {
				info = new ShaderPassInfo(name, this.nextIndex, options);
				this.passesNamed.set(info.name, info);
				this.passesIndexed[info.index] = info;
				this.nextIndex++;
			}
			return info;
		};
		_proto2.getByIndex = function getByIndex(index) {
			var info = this.passesIndexed[index];
			return info;
		};
		_proto2.getByName = function getByName(name) {
			return this.passesNamed.get(name);
		};
		return ShaderPass;
	}();

	function gammaCode(value, chunks) {
		if (!chunks) chunks = shaderChunks;
		if (value === GAMMA_SRGB || value === GAMMA_SRGBFAST) {
			return chunks.gamma2_2PS ? chunks.gamma2_2PS : shaderChunks.gamma2_2PS;
		} else if (value === GAMMA_SRGBHDR) {
			return "#define HDR\n" + (chunks.gamma2_2PS ? chunks.gamma2_2PS : shaderChunks.gamma2_2PS);
		}
		return chunks.gamma1_0PS ? chunks.gamma1_0PS : shaderChunks.gamma1_0PS;
	}
	function tonemapCode(value, chunks) {
		if (!chunks) chunks = shaderChunks;
		if (value === TONEMAP_FILMIC) {
			return chunks.tonemappingFilmicPS ? chunks.tonemappingFilmicPS : shaderChunks.tonemappingFilmicPS;
		} else if (value === TONEMAP_LINEAR) {
			return chunks.tonemappingLinearPS ? chunks.tonemappingLinearPS : shaderChunks.tonemappingLinearPS;
		} else if (value === TONEMAP_HEJL) {
			return chunks.tonemappingHejlPS ? chunks.tonemappingHejlPS : shaderChunks.tonemappingHejlPS;
		} else if (value === TONEMAP_ACES) {
			return chunks.tonemappingAcesPS ? chunks.tonemappingAcesPS : shaderChunks.tonemappingAcesPS;
		} else if (value === TONEMAP_ACES2) {
			return chunks.tonemappingAces2PS ? chunks.tonemappingAces2PS : shaderChunks.tonemappingAces2PS;
		}
		return chunks.tonemapingNonePS ? chunks.tonemapingNonePS : shaderChunks.tonemappingNonePS;
	}
	function fogCode(value, chunks) {
		if (!chunks) chunks = shaderChunks;
		if (value === 'linear') {
			return chunks.fogLinearPS ? chunks.fogLinearPS : shaderChunks.fogLinearPS;
		} else if (value === 'exp') {
			return chunks.fogExpPS ? chunks.fogExpPS : shaderChunks.fogExpPS;
		} else if (value === 'exp2') {
			return chunks.fogExp2PS ? chunks.fogExp2PS : shaderChunks.fogExp2PS;
		}
		return chunks.fogNonePS ? chunks.fogNonePS : shaderChunks.fogNonePS;
	}
	function skinCode(device, chunks) {
		if (!chunks) chunks = shaderChunks;
		if (device.supportsBoneTextures) {
			return chunks.skinTexVS;
		}
		return "#define BONE_LIMIT " + device.getBoneLimit() + "\n" + chunks.skinConstVS;
	}
	function begin() {
		return 'void main(void)\n{\n';
	}
	function end() {
		return '}\n';
	}

	var basic = {
		generateKey: function generateKey(options) {
			var key = 'basic';
			if (options.fog) key += '_fog';
			if (options.alphaTest) key += '_atst';
			if (options.vertexColors) key += '_vcol';
			if (options.diffuseMap) key += '_diff';
			if (options.skin) key += '_skin';
			if (options.screenSpace) key += '_ss';
			if (options.useInstancing) key += '_inst';
			if (options.useMorphPosition) key += '_morphp';
			if (options.useMorphNormal) key += '_morphn';
			if (options.useMorphTextureBased) key += '_morpht';
			key += '_' + options.pass;
			return key;
		},
		createShaderDefinition: function createShaderDefinition(device, options) {
			var attributes = {
				vertex_position: SEMANTIC_POSITION
			};
			if (options.skin) {
				attributes.vertex_boneWeights = SEMANTIC_BLENDWEIGHT;
				attributes.vertex_boneIndices = SEMANTIC_BLENDINDICES;
			}
			if (options.vertexColors) {
				attributes.vertex_color = SEMANTIC_COLOR;
			}
			if (options.diffuseMap) {
				attributes.vertex_texCoord0 = SEMANTIC_TEXCOORD0;
			}
			var shaderPassInfo = ShaderPass.get(device).getByIndex(options.pass);
			var shaderPassDefines = shaderPassInfo.shaderDefines;
			var vshader = shaderPassDefines;
			vshader += shaderChunks.transformDeclVS;
			if (options.skin) {
				vshader += skinCode(device);
				vshader += shaderChunks.transformSkinnedVS;
			} else {
				vshader += shaderChunks.transformVS;
			}
			if (options.vertexColors) {
				vshader += 'attribute vec4 vertex_color;\n';
				vshader += 'varying vec4 vColor;\n';
			}
			if (options.diffuseMap) {
				vshader += 'attribute vec2 vertex_texCoord0;\n';
				vshader += 'varying vec2 vUv0;\n';
			}
			if (options.pass === SHADER_DEPTH) {
				vshader += 'varying float vDepth;\n';
				vshader += '#ifndef VIEWMATRIX\n';
				vshader += '#define VIEWMATRIX\n';
				vshader += 'uniform mat4 matrix_view;\n';
				vshader += '#endif\n';
				vshader += '#ifndef CAMERAPLANES\n';
				vshader += '#define CAMERAPLANES\n';
				vshader += 'uniform vec4 camera_params;\n\n';
				vshader += '#endif\n';
			}
			vshader += begin();
			vshader += "   gl_Position = getPosition();\n";
			if (options.pass === SHADER_DEPTH) {
				vshader += "    vDepth = -(matrix_view * vec4(getWorldPosition(),1.0)).z * camera_params.x;\n";
			}
			if (options.vertexColors) {
				vshader += '    vColor = vertex_color;\n';
			}
			if (options.diffuseMap) {
				vshader += '    vUv0 = vertex_texCoord0;\n';
			}
			vshader += end();
			var fshader = shaderPassDefines;
			if (options.vertexColors) {
				fshader += 'varying vec4 vColor;\n';
			} else {
				fshader += 'uniform vec4 uColor;\n';
			}
			if (options.diffuseMap) {
				fshader += 'varying vec2 vUv0;\n';
				fshader += 'uniform sampler2D texture_diffuseMap;\n';
			}
			if (options.fog) {
				fshader += fogCode(options.fog);
			}
			if (options.alphaTest) {
				fshader += shaderChunks.alphaTestPS;
			}
			if (options.pass === SHADER_DEPTH) {
				fshader += 'varying float vDepth;\n';
				fshader += shaderChunks.packDepthPS;
			}
			fshader += begin();
			if (options.vertexColors) {
				fshader += '    gl_FragColor = vColor;\n';
			} else {
				fshader += '    gl_FragColor = uColor;\n';
			}
			if (options.diffuseMap) {
				fshader += '    gl_FragColor *= texture2D(texture_diffuseMap, vUv0);\n';
			}
			if (options.alphaTest) {
				fshader += "   alphaTest(gl_FragColor.a);\n";
			}
			if (options.pass !== SHADER_PICK) {
				if (options.pass === SHADER_DEPTH) {
					fshader += "    gl_FragColor = packFloat(vDepth);\n";
				} else {
					if (options.fog) {
						fshader += "   glFragColor.rgb = addFog(gl_FragColor.rgb);\n";
					}
				}
			}
			fshader += end();
			return ShaderUtils.createDefinition(device, {
				name: 'BasicShader',
				attributes: attributes,
				vertexCode: vshader,
				fragmentCode: fshader
			});
		}
	};

	var defaultMaterialDeviceCache = new DeviceCache();
	function getDefaultMaterial(device) {
		var material = defaultMaterialDeviceCache.get(device);
		return material;
	}
	function setDefaultMaterial(device, material) {
		defaultMaterialDeviceCache.get(device, function () {
			return material;
		});
	}

	var blendModes = [];
	blendModes[BLEND_SUBTRACTIVE] = {
		src: BLENDMODE_ONE,
		dst: BLENDMODE_ONE,
		op: BLENDEQUATION_REVERSE_SUBTRACT
	};
	blendModes[BLEND_NONE] = {
		src: BLENDMODE_ONE,
		dst: BLENDMODE_ZERO,
		op: BLENDEQUATION_ADD
	};
	blendModes[BLEND_NORMAL] = {
		src: BLENDMODE_SRC_ALPHA,
		dst: BLENDMODE_ONE_MINUS_SRC_ALPHA,
		op: BLENDEQUATION_ADD
	};
	blendModes[BLEND_PREMULTIPLIED] = {
		src: BLENDMODE_ONE,
		dst: BLENDMODE_ONE_MINUS_SRC_ALPHA,
		op: BLENDEQUATION_ADD
	};
	blendModes[BLEND_ADDITIVE] = {
		src: BLENDMODE_ONE,
		dst: BLENDMODE_ONE,
		op: BLENDEQUATION_ADD
	};
	blendModes[BLEND_ADDITIVEALPHA] = {
		src: BLENDMODE_SRC_ALPHA,
		dst: BLENDMODE_ONE,
		op: BLENDEQUATION_ADD
	};
	blendModes[BLEND_MULTIPLICATIVE2X] = {
		src: BLENDMODE_DST_COLOR,
		dst: BLENDMODE_SRC_COLOR,
		op: BLENDEQUATION_ADD
	};
	blendModes[BLEND_SCREEN] = {
		src: BLENDMODE_ONE_MINUS_DST_COLOR,
		dst: BLENDMODE_ONE,
		op: BLENDEQUATION_ADD
	};
	blendModes[BLEND_MULTIPLICATIVE] = {
		src: BLENDMODE_DST_COLOR,
		dst: BLENDMODE_ZERO,
		op: BLENDEQUATION_ADD
	};
	blendModes[BLEND_MIN] = {
		src: BLENDMODE_ONE,
		dst: BLENDMODE_ONE,
		op: BLENDEQUATION_MIN
	};
	blendModes[BLEND_MAX] = {
		src: BLENDMODE_ONE,
		dst: BLENDMODE_ONE,
		op: BLENDEQUATION_MAX
	};
	var id$1 = 0;
	var Material = function () {
		function Material() {
			this._shader = null;
			this.meshInstances = [];
			this.name = 'Untitled';
			this.userId = '';
			this.id = id$1++;
			this.variants = new Map();
			this.parameters = {};
			this.alphaTest = 0;
			this.alphaToCoverage = false;
			this._blendState = new BlendState();
			this._depthState = new DepthState();
			this.cull = CULLFACE_BACK;
			this.stencilFront = null;
			this.stencilBack = null;
			this.depthBias = 0;
			this.slopeDepthBias = 0;
			this._shaderVersion = 0;
			this._scene = null;
			this._dirtyBlend = false;
			this.dirty = true;
		}
		var _proto = Material.prototype;
		_proto._updateTransparency = function _updateTransparency() {
			var transparent = this.transparent;
			var meshInstances = this.meshInstances;
			for (var i = 0; i < meshInstances.length; i++) {
				meshInstances[i].transparent = transparent;
			}
		};
		_proto._markBlendDirty = function _markBlendDirty() {
			if (this._scene) {
				this._scene.layers._dirtyBlend = true;
			} else {
				this._dirtyBlend = true;
			}
		};
		_proto.copy = function copy(source) {
			var _source$stencilFront;
			this.name = source.name;
			this._shader = source._shader;
			this.alphaTest = source.alphaTest;
			this.alphaToCoverage = source.alphaToCoverage;
			this._blendState.copy(source._blendState);
			this._depthState.copy(source._depthState);
			this.cull = source.cull;
			this.depthBias = source.depthBias;
			this.slopeDepthBias = source.slopeDepthBias;
			this.stencilFront = (_source$stencilFront = source.stencilFront) == null ? void 0 : _source$stencilFront.clone();
			if (source.stencilBack) {
				this.stencilBack = source.stencilFront === source.stencilBack ? this.stencilFront : source.stencilBack.clone();
			}
			return this;
		};
		_proto.clone = function clone() {
			var clone = new this.constructor();
			return clone.copy(this);
		};
		_proto._updateMeshInstanceKeys = function _updateMeshInstanceKeys() {
			var meshInstances = this.meshInstances;
			for (var i = 0; i < meshInstances.length; i++) {
				meshInstances[i].updateKey();
			}
		};
		_proto.updateUniforms = function updateUniforms(device, scene) {};
		_proto.getShaderVariant = function getShaderVariant(device, scene, objDefs, unused, pass, sortedLights, viewUniformFormat, viewBindGroupFormat, vertexFormat) {
			var processingOptions = new ShaderProcessorOptions(viewUniformFormat, viewBindGroupFormat, vertexFormat);
			return processShader(this._shader, processingOptions);
		};
		_proto.update = function update() {
			this.dirty = true;
			if (this._shader) this._shader.failed = false;
		};
		_proto.clearParameters = function clearParameters() {
			this.parameters = {};
		};
		_proto.getParameters = function getParameters() {
			return this.parameters;
		};
		_proto.clearVariants = function clearVariants() {
			this.variants.clear();
			var meshInstances = this.meshInstances;
			var count = meshInstances.length;
			for (var i = 0; i < count; i++) {
				meshInstances[i].clearShaders();
			}
		};
		_proto.getParameter = function getParameter(name) {
			return this.parameters[name];
		};
		_proto.setParameter = function setParameter(name, data) {
			if (data === undefined && typeof name === 'object') {
				var uniformObject = name;
				if (uniformObject.length) {
					for (var i = 0; i < uniformObject.length; i++) {
						this.setParameter(uniformObject[i]);
					}
					return;
				}
				name = uniformObject.name;
				data = uniformObject.value;
			}
			var param = this.parameters[name];
			if (param) {
				param.data = data;
			} else {
				this.parameters[name] = {
					scopeId: null,
					data: data
				};
			}
		};
		_proto.deleteParameter = function deleteParameter(name) {
			if (this.parameters[name]) {
				delete this.parameters[name];
			}
		};
		_proto.setParameters = function setParameters(device, names) {
			var parameters = this.parameters;
			if (names === undefined) names = parameters;
			for (var paramName in names) {
				var parameter = parameters[paramName];
				if (parameter) {
					if (!parameter.scopeId) {
						parameter.scopeId = device.scope.resolve(paramName);
					}
					parameter.scopeId.setValue(parameter.data);
				}
			}
		};
		_proto.destroy = function destroy() {
			this.variants.clear();
			this._shader = null;
			for (var i = 0; i < this.meshInstances.length; i++) {
				var meshInstance = this.meshInstances[i];
				meshInstance.clearShaders();
				meshInstance._material = null;
				if (meshInstance.mesh) {
					var defaultMaterial = getDefaultMaterial(meshInstance.mesh.device);
					if (this !== defaultMaterial) {
						meshInstance.material = defaultMaterial;
					}
				}
			}
			this.meshInstances.length = 0;
		};
		_proto.addMeshInstanceRef = function addMeshInstanceRef(meshInstance) {
			this.meshInstances.push(meshInstance);
		};
		_proto.removeMeshInstanceRef = function removeMeshInstanceRef(meshInstance) {
			var meshInstances = this.meshInstances;
			var i = meshInstances.indexOf(meshInstance);
			if (i !== -1) {
				meshInstances.splice(i, 1);
			}
		};
		_createClass(Material, [{
			key: "redWrite",
			get: function get() {
				return this._blendState.redWrite;
			},
			set: function set(value) {
				this._blendState.redWrite = value;
			}
		}, {
			key: "greenWrite",
			get: function get() {
				return this._blendState.greenWrite;
			},
			set: function set(value) {
				this._blendState.greenWrite = value;
			}
		}, {
			key: "blueWrite",
			get: function get() {
				return this._blendState.blueWrite;
			},
			set: function set(value) {
				this._blendState.blueWrite = value;
			}
		}, {
			key: "alphaWrite",
			get: function get() {
				return this._blendState.alphaWrite;
			},
			set: function set(value) {
				this._blendState.alphaWrite = value;
			}
		}, {
			key: "shader",
			get: function get() {
				return this._shader;
			},
			set: function set(shader) {
				this._shader = shader;
			}
		}, {
			key: "transparent",
			get: function get() {
				return this._blendState.blend;
			}
		}, {
			key: "blendState",
			get: function get() {
				return this._blendState;
			},
			set: function set(value) {
				if (this._blendState.blend !== value.blend) {
					this._markBlendDirty();
				}
				this._blendState.copy(value);
				this._updateTransparency();
			}
		}, {
			key: "blendType",
			get: function get() {
				if (!this.transparent) {
					return BLEND_NONE;
				}
				var _this$_blendState = this._blendState,
					colorOp = _this$_blendState.colorOp,
					colorSrcFactor = _this$_blendState.colorSrcFactor,
					colorDstFactor = _this$_blendState.colorDstFactor,
					alphaOp = _this$_blendState.alphaOp,
					alphaSrcFactor = _this$_blendState.alphaSrcFactor,
					alphaDstFactor = _this$_blendState.alphaDstFactor;
				for (var i = 0; i < blendModes.length; i++) {
					var blendMode = blendModes[i];
					if (blendMode.src === colorSrcFactor && blendMode.dst === colorDstFactor && blendMode.op === colorOp && blendMode.src === alphaSrcFactor && blendMode.dst === alphaDstFactor && blendMode.op === alphaOp) {
						return i;
					}
				}
				return BLEND_NORMAL;
			},
			set: function set(type) {
				var blendMode = blendModes[type];
				this._blendState.setColorBlend(blendMode.op, blendMode.src, blendMode.dst);
				this._blendState.setAlphaBlend(blendMode.op, blendMode.src, blendMode.dst);
				var blend = type !== BLEND_NONE;
				if (this._blendState.blend !== blend) {
					this._blendState.blend = blend;
					this._updateTransparency();
					this._markBlendDirty();
				}
				this._updateMeshInstanceKeys();
			}
		}, {
			key: "depthState",
			get: function get() {
				return this._depthState;
			},
			set: function set(value) {
				this._depthState.copy(value);
			}
		}, {
			key: "depthTest",
			get: function get() {
				return this._depthState.test;
			},
			set: function set(value) {
				this._depthState.test = value;
			}
		}, {
			key: "depthFunc",
			get: function get() {
				return this._depthState.func;
			},
			set: function set(value) {
				this._depthState.func = value;
			}
		}, {
			key: "depthWrite",
			get: function get() {
				return this._depthState.write;
			},
			set: function set(value) {
				this._depthState.write = value;
			}
		}]);
		return Material;
	}();

	var BasicMaterial = function (_Material) {
		_inheritsLoose(BasicMaterial, _Material);
		function BasicMaterial() {
			var _this;
			for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
				args[_key] = arguments[_key];
			}
			_this = _Material.call.apply(_Material, [this].concat(args)) || this;
			_this.color = new Color(1, 1, 1, 1);
			_this.colorUniform = new Float32Array(4);
			_this.colorMap = null;
			_this.vertexColors = false;
			return _this;
		}
		var _proto = BasicMaterial.prototype;
		_proto.copy = function copy(source) {
			_Material.prototype.copy.call(this, source);
			this.color.copy(source.color);
			this.colorMap = source.colorMap;
			this.vertexColors = source.vertexColors;
			return this;
		};
		_proto.updateUniforms = function updateUniforms(device, scene) {
			this.clearParameters();
			this.colorUniform[0] = this.color.r;
			this.colorUniform[1] = this.color.g;
			this.colorUniform[2] = this.color.b;
			this.colorUniform[3] = this.color.a;
			this.setParameter('uColor', this.colorUniform);
			if (this.colorMap) {
				this.setParameter('texture_diffuseMap', this.colorMap);
			}
		};
		_proto.getShaderVariant = function getShaderVariant(device, scene, objDefs, unused, pass, sortedLights, viewUniformFormat, viewBindGroupFormat, vertexFormat) {
			var options = {
				skin: objDefs && (objDefs & SHADERDEF_SKIN) !== 0,
				screenSpace: objDefs && (objDefs & SHADERDEF_SCREENSPACE) !== 0,
				useInstancing: objDefs && (objDefs & SHADERDEF_INSTANCING) !== 0,
				useMorphPosition: objDefs && (objDefs & SHADERDEF_MORPH_POSITION) !== 0,
				useMorphNormal: objDefs && (objDefs & SHADERDEF_MORPH_NORMAL) !== 0,
				useMorphTextureBased: objDefs && (objDefs & SHADERDEF_MORPH_TEXTURE_BASED) !== 0,
				alphaTest: this.alphaTest > 0,
				vertexColors: this.vertexColors,
				diffuseMap: !!this.colorMap,
				pass: pass
			};
			var processingOptions = new ShaderProcessorOptions(viewUniformFormat, viewBindGroupFormat, vertexFormat);
			var library = getProgramLibrary(device);
			library.register('basic', basic);
			return library.getProgram('basic', options, processingOptions, this.userId);
		};
		return BasicMaterial;
	}(Material);

	var Batch = function () {
		function Batch(meshInstances, dynamic, batchGroupId) {
			this._aabb = new BoundingBox();
			this.origMeshInstances = void 0;
			this.meshInstance = null;
			this.dynamic = void 0;
			this.batchGroupId = void 0;
			this.origMeshInstances = meshInstances;
			this.dynamic = dynamic;
			this.batchGroupId = batchGroupId;
		}
		var _proto = Batch.prototype;
		_proto.destroy = function destroy(scene, layers) {
			if (this.meshInstance) {
				this.removeFromLayers(scene, layers);
				this.meshInstance.destroy();
				this.meshInstance = null;
			}
		};
		_proto.addToLayers = function addToLayers(scene, layers) {
			for (var i = 0; i < layers.length; i++) {
				var layer = scene.layers.getLayerById(layers[i]);
				if (layer) {
					layer.addMeshInstances([this.meshInstance]);
				}
			}
		};
		_proto.removeFromLayers = function removeFromLayers(scene, layers) {
			for (var i = 0; i < layers.length; i++) {
				var layer = scene.layers.getLayerById(layers[i]);
				if (layer) {
					layer.removeMeshInstances([this.meshInstance]);
				}
			}
		};
		_proto.updateBoundingBox = function updateBoundingBox() {
			this._aabb.copy(this.origMeshInstances[0].aabb);
			for (var i = 1; i < this.origMeshInstances.length; i++) {
				this._aabb.add(this.origMeshInstances[i].aabb);
			}
			this.meshInstance.aabb = this._aabb;
			this.meshInstance._aabbVer = 0;
		};
		return Batch;
	}();

	var BatchGroup = function BatchGroup(id, name, dynamic, maxAabbSize, layers) {
		if (layers === void 0) {
			layers = [LAYERID_WORLD];
		}
		this._ui = false;
		this._sprite = false;
		this._obj = {
			model: [],
			element: [],
			sprite: [],
			render: []
		};
		this.id = void 0;
		this.name = void 0;
		this.dynamic = void 0;
		this.maxAabbSize = void 0;
		this.layers = void 0;
		this.id = id;
		this.name = name;
		this.dynamic = dynamic;
		this.maxAabbSize = maxAabbSize;
		this.layers = layers;
	};
	BatchGroup.MODEL = 'model';
	BatchGroup.ELEMENT = 'element';
	BatchGroup.SPRITE = 'sprite';
	BatchGroup.RENDER = 'render';

	var _invMatrix = new Mat4();
	var SkinInstance = function () {
		function SkinInstance(skin) {
			this.bones = void 0;
			this._dirty = true;
			this._rootBone = null;
			this._skinUpdateIndex = -1;
			this._updateBeforeCull = true;
			if (skin) {
				this.initSkin(skin);
			}
		}
		var _proto = SkinInstance.prototype;
		_proto.init = function init(device, numBones) {
			if (device.supportsBoneTextures) {
				var numPixels = numBones * 3;
				var width = Math.ceil(Math.sqrt(numPixels));
				width = math.roundUp(width, 3);
				var height = Math.ceil(numPixels / width);
				this.boneTexture = new Texture(device, {
					width: width,
					height: height,
					format: PIXELFORMAT_RGBA32F,
					mipmaps: false,
					minFilter: FILTER_NEAREST,
					magFilter: FILTER_NEAREST,
					name: 'skin'
				});
				this.matrixPalette = this.boneTexture.lock();
			} else {
				this.matrixPalette = new Float32Array(numBones * 12);
			}
		};
		_proto.destroy = function destroy() {
			if (this.boneTexture) {
				this.boneTexture.destroy();
				this.boneTexture = null;
			}
		};
		_proto.resolve = function resolve(rootBone, entity) {
			this.rootBone = rootBone;
			var skin = this.skin;
			var bones = [];
			for (var j = 0; j < skin.boneNames.length; j++) {
				var boneName = skin.boneNames[j];
				var bone = rootBone.findByName(boneName);
				if (!bone) {
					bone = entity;
				}
				bones.push(bone);
			}
			this.bones = bones;
		};
		_proto.initSkin = function initSkin(skin) {
			this.skin = skin;
			this.bones = [];
			var numBones = skin.inverseBindPose.length;
			this.init(skin.device, numBones);
			this.matrices = [];
			for (var i = 0; i < numBones; i++) {
				this.matrices[i] = new Mat4();
			}
		};
		_proto.uploadBones = function uploadBones(device) {
			if (device.supportsBoneTextures) {
				this.boneTexture.lock();
				this.boneTexture.unlock();
			}
		};
		_proto._updateMatrices = function _updateMatrices(rootNode, skinUpdateIndex) {
			if (this._skinUpdateIndex !== skinUpdateIndex) {
				this._skinUpdateIndex = skinUpdateIndex;
				_invMatrix.copy(rootNode.getWorldTransform()).invert();
				for (var i = this.bones.length - 1; i >= 0; i--) {
					this.matrices[i].mulAffine2(_invMatrix, this.bones[i].getWorldTransform());
					this.matrices[i].mulAffine2(this.matrices[i], this.skin.inverseBindPose[i]);
				}
			}
		};
		_proto.updateMatrices = function updateMatrices(rootNode, skinUpdateIndex) {
			if (this._updateBeforeCull) {
				this._updateMatrices(rootNode, skinUpdateIndex);
			}
		};
		_proto.updateMatrixPalette = function updateMatrixPalette(rootNode, skinUpdateIndex) {
			this._updateMatrices(rootNode, skinUpdateIndex);
			var mp = this.matrixPalette;
			var count = this.bones.length;
			for (var i = 0; i < count; i++) {
				var pe = this.matrices[i].data;
				var base = i * 12;
				mp[base] = pe[0];
				mp[base + 1] = pe[4];
				mp[base + 2] = pe[8];
				mp[base + 3] = pe[12];
				mp[base + 4] = pe[1];
				mp[base + 5] = pe[5];
				mp[base + 6] = pe[9];
				mp[base + 7] = pe[13];
				mp[base + 8] = pe[2];
				mp[base + 9] = pe[6];
				mp[base + 10] = pe[10];
				mp[base + 11] = pe[14];
			}
			this.uploadBones(this.skin.device);
		};
		_createClass(SkinInstance, [{
			key: "rootBone",
			get: function get() {
				return this._rootBone;
			},
			set: function set(rootBone) {
				this._rootBone = rootBone;
			}
		}]);
		return SkinInstance;
	}();

	var SkinBatchInstance = function (_SkinInstance) {
		_inheritsLoose(SkinBatchInstance, _SkinInstance);
		function SkinBatchInstance(device, nodes, rootNode) {
			var _this;
			_this = _SkinInstance.call(this) || this;
			var numBones = nodes.length;
			_this.init(device, numBones);
			_this.device = device;
			_this.rootNode = rootNode;
			_this.bones = nodes;
			return _this;
		}
		var _proto = SkinBatchInstance.prototype;
		_proto.updateMatrices = function updateMatrices(rootNode, skinUpdateIndex) {};
		_proto.updateMatrixPalette = function updateMatrixPalette(rootNode, skinUpdateIndex) {
			var mp = this.matrixPalette;
			var count = this.bones.length;
			for (var i = 0; i < count; i++) {
				var pe = this.bones[i].getWorldTransform().data;
				var base = i * 12;
				mp[base] = pe[0];
				mp[base + 1] = pe[4];
				mp[base + 2] = pe[8];
				mp[base + 3] = pe[12];
				mp[base + 4] = pe[1];
				mp[base + 5] = pe[5];
				mp[base + 6] = pe[9];
				mp[base + 7] = pe[13];
				mp[base + 8] = pe[2];
				mp[base + 9] = pe[6];
				mp[base + 10] = pe[10];
				mp[base + 11] = pe[14];
			}
			this.uploadBones(this.device);
		};
		return SkinBatchInstance;
	}(SkinInstance);

	var scaleCompensatePosTransform = new Mat4();
	var scaleCompensatePos = new Vec3();
	var scaleCompensateRot = new Quat();
	var scaleCompensateRot2 = new Quat();
	var scaleCompensateScale = new Vec3();
	var scaleCompensateScaleForParent = new Vec3();
	var tmpMat4 = new Mat4();
	var tmpQuat = new Quat();
	var position$1 = new Vec3();
	var invParentWtm$1 = new Mat4();
	var rotation = new Quat();
	var invParentRot = new Quat();
	var matrix = new Mat4();
	var target = new Vec3();
	var up = new Vec3();
	var GraphNode = function (_EventHandler) {
		_inheritsLoose(GraphNode, _EventHandler);
		function GraphNode(name) {
			var _this;
			if (name === void 0) {
				name = 'Untitled';
			}
			_this = _EventHandler.call(this) || this;
			_this.name = void 0;
			_this.tags = new Tags(_assertThisInitialized(_this));
			_this._labels = {};
			_this.localPosition = new Vec3();
			_this.localRotation = new Quat();
			_this.localScale = new Vec3(1, 1, 1);
			_this.localEulerAngles = new Vec3();
			_this.position = new Vec3();
			_this.rotation = new Quat();
			_this.eulerAngles = new Vec3();
			_this._scale = null;
			_this.localTransform = new Mat4();
			_this._dirtyLocal = false;
			_this._aabbVer = 0;
			_this._frozen = false;
			_this.worldTransform = new Mat4();
			_this._dirtyWorld = false;
			_this._worldScaleSign = 0;
			_this._normalMatrix = new Mat3();
			_this._dirtyNormal = true;
			_this._right = null;
			_this._up = null;
			_this._forward = null;
			_this._parent = null;
			_this._children = [];
			_this._graphDepth = 0;
			_this._enabled = true;
			_this._enabledInHierarchy = false;
			_this.scaleCompensation = false;
			_this.name = name;
			return _this;
		}
		var _proto = GraphNode.prototype;
		_proto._notifyHierarchyStateChanged = function _notifyHierarchyStateChanged(node, enabled) {
			node._onHierarchyStateChanged(enabled);
			var c = node._children;
			for (var i = 0, len = c.length; i < len; i++) {
				if (c[i]._enabled) this._notifyHierarchyStateChanged(c[i], enabled);
			}
		};
		_proto._onHierarchyStateChanged = function _onHierarchyStateChanged(enabled) {
			this._enabledInHierarchy = enabled;
			if (enabled && !this._frozen) this._unfreezeParentToRoot();
		};
		_proto._cloneInternal = function _cloneInternal(clone) {
			clone.name = this.name;
			var tags = this.tags._list;
			clone.tags.clear();
			for (var i = 0; i < tags.length; i++) clone.tags.add(tags[i]);
			clone._labels = Object.assign({}, this._labels);
			clone.localPosition.copy(this.localPosition);
			clone.localRotation.copy(this.localRotation);
			clone.localScale.copy(this.localScale);
			clone.localEulerAngles.copy(this.localEulerAngles);
			clone.position.copy(this.position);
			clone.rotation.copy(this.rotation);
			clone.eulerAngles.copy(this.eulerAngles);
			clone.localTransform.copy(this.localTransform);
			clone._dirtyLocal = this._dirtyLocal;
			clone.worldTransform.copy(this.worldTransform);
			clone._dirtyWorld = this._dirtyWorld;
			clone._dirtyNormal = this._dirtyNormal;
			clone._aabbVer = this._aabbVer + 1;
			clone._enabled = this._enabled;
			clone.scaleCompensation = this.scaleCompensation;
			clone._enabledInHierarchy = false;
		};
		_proto.clone = function clone() {
			var clone = new this.constructor();
			this._cloneInternal(clone);
			return clone;
		};
		_proto.copy = function copy(source) {
			source._cloneInternal(this);
			return this;
		};
		_proto.destroy = function destroy() {
			this.remove();
			var children = this._children;
			while (children.length) {
				var child = children.pop();
				child._parent = null;
				child.destroy();
			}
			this.fire('destroy', this);
			this.off();
		};
		_proto.find = function find(attr, value) {
			var result,
				results = [];
			var len = this._children.length;
			if (attr instanceof Function) {
				var fn = attr;
				result = fn(this);
				if (result) results.push(this);
				for (var i = 0; i < len; i++) {
					var descendants = this._children[i].find(fn);
					if (descendants.length) results = results.concat(descendants);
				}
			} else {
				var testValue;
				if (this[attr]) {
					if (this[attr] instanceof Function) {
						testValue = this[attr]();
					} else {
						testValue = this[attr];
					}
					if (testValue === value) results.push(this);
				}
				for (var _i = 0; _i < len; ++_i) {
					var _descendants = this._children[_i].find(attr, value);
					if (_descendants.length) results = results.concat(_descendants);
				}
			}
			return results;
		};
		_proto.findOne = function findOne(attr, value) {
			var len = this._children.length;
			var result = null;
			if (attr instanceof Function) {
				var fn = attr;
				result = fn(this);
				if (result) return this;
				for (var i = 0; i < len; i++) {
					result = this._children[i].findOne(fn);
					if (result) return result;
				}
			} else {
				var testValue;
				if (this[attr]) {
					if (this[attr] instanceof Function) {
						testValue = this[attr]();
					} else {
						testValue = this[attr];
					}
					if (testValue === value) {
						return this;
					}
				}
				for (var _i2 = 0; _i2 < len; _i2++) {
					result = this._children[_i2].findOne(attr, value);
					if (result !== null) return result;
				}
			}
			return null;
		};
		_proto.findByTag = function findByTag() {
			var query = arguments;
			var results = [];
			var queryNode = function queryNode(node, checkNode) {
				var _node$tags;
				if (checkNode && (_node$tags = node.tags).has.apply(_node$tags, query)) {
					results.push(node);
				}
				for (var i = 0; i < node._children.length; i++) {
					queryNode(node._children[i], true);
				}
			};
			queryNode(this, false);
			return results;
		};
		_proto.findByName = function findByName(name) {
			if (this.name === name) return this;
			for (var i = 0; i < this._children.length; i++) {
				var found = this._children[i].findByName(name);
				if (found !== null) return found;
			}
			return null;
		};
		_proto.findByPath = function findByPath(path) {
			var parts = Array.isArray(path) ? path : path.split('/');
			var result = this;
			var _loop = function _loop(i) {
				result = result.children.find(function (c) {
					return c.name === parts[i];
				});
				if (!result) {
					return {
						v: null
					};
				}
			};
			for (var i = 0, imax = parts.length; i < imax; ++i) {
				var _ret = _loop(i);
				if (typeof _ret === "object") return _ret.v;
			}
			return result;
		};
		_proto.forEach = function forEach(callback, thisArg) {
			callback.call(thisArg, this);
			var children = this._children;
			for (var i = 0; i < children.length; i++) {
				children[i].forEach(callback, thisArg);
			}
		};
		_proto.isDescendantOf = function isDescendantOf(node) {
			var parent = this._parent;
			while (parent) {
				if (parent === node) return true;
				parent = parent._parent;
			}
			return false;
		};
		_proto.isAncestorOf = function isAncestorOf(node) {
			return node.isDescendantOf(this);
		};
		_proto.getEulerAngles = function getEulerAngles() {
			this.getWorldTransform().getEulerAngles(this.eulerAngles);
			return this.eulerAngles;
		};
		_proto.getLocalEulerAngles = function getLocalEulerAngles() {
			this.localRotation.getEulerAngles(this.localEulerAngles);
			return this.localEulerAngles;
		};
		_proto.getLocalPosition = function getLocalPosition() {
			return this.localPosition;
		};
		_proto.getLocalRotation = function getLocalRotation() {
			return this.localRotation;
		};
		_proto.getLocalScale = function getLocalScale() {
			return this.localScale;
		};
		_proto.getLocalTransform = function getLocalTransform() {
			if (this._dirtyLocal) {
				this.localTransform.setTRS(this.localPosition, this.localRotation, this.localScale);
				this._dirtyLocal = false;
			}
			return this.localTransform;
		};
		_proto.getPosition = function getPosition() {
			this.getWorldTransform().getTranslation(this.position);
			return this.position;
		};
		_proto.getRotation = function getRotation() {
			this.rotation.setFromMat4(this.getWorldTransform());
			return this.rotation;
		};
		_proto.getScale = function getScale() {
			if (!this._scale) {
				this._scale = new Vec3();
			}
			return this.getWorldTransform().getScale(this._scale);
		};
		_proto.getWorldTransform = function getWorldTransform() {
			if (!this._dirtyLocal && !this._dirtyWorld) return this.worldTransform;
			if (this._parent) this._parent.getWorldTransform();
			this._sync();
			return this.worldTransform;
		};
		_proto.remove = function remove() {
			var _this$_parent;
			(_this$_parent = this._parent) == null ? void 0 : _this$_parent.removeChild(this);
		};
		_proto.reparent = function reparent(parent, index) {
			this.remove();
			if (parent) {
				if (index >= 0) {
					parent.insertChild(this, index);
				} else {
					parent.addChild(this);
				}
			}
		};
		_proto.setLocalEulerAngles = function setLocalEulerAngles(x, y, z) {
			this.localRotation.setFromEulerAngles(x, y, z);
			if (!this._dirtyLocal) this._dirtifyLocal();
		};
		_proto.setLocalPosition = function setLocalPosition(x, y, z) {
			if (x instanceof Vec3) {
				this.localPosition.copy(x);
			} else {
				this.localPosition.set(x, y, z);
			}
			if (!this._dirtyLocal) this._dirtifyLocal();
		};
		_proto.setLocalRotation = function setLocalRotation(x, y, z, w) {
			if (x instanceof Quat) {
				this.localRotation.copy(x);
			} else {
				this.localRotation.set(x, y, z, w);
			}
			if (!this._dirtyLocal) this._dirtifyLocal();
		};
		_proto.setLocalScale = function setLocalScale(x, y, z) {
			if (x instanceof Vec3) {
				this.localScale.copy(x);
			} else {
				this.localScale.set(x, y, z);
			}
			if (!this._dirtyLocal) this._dirtifyLocal();
		};
		_proto._dirtifyLocal = function _dirtifyLocal() {
			if (!this._dirtyLocal) {
				this._dirtyLocal = true;
				if (!this._dirtyWorld) this._dirtifyWorld();
			}
		};
		_proto._unfreezeParentToRoot = function _unfreezeParentToRoot() {
			var p = this._parent;
			while (p) {
				p._frozen = false;
				p = p._parent;
			}
		};
		_proto._dirtifyWorld = function _dirtifyWorld() {
			if (!this._dirtyWorld) this._unfreezeParentToRoot();
			this._dirtifyWorldInternal();
		};
		_proto._dirtifyWorldInternal = function _dirtifyWorldInternal() {
			if (!this._dirtyWorld) {
				this._frozen = false;
				this._dirtyWorld = true;
				for (var i = 0; i < this._children.length; i++) {
					if (!this._children[i]._dirtyWorld) this._children[i]._dirtifyWorldInternal();
				}
			}
			this._dirtyNormal = true;
			this._worldScaleSign = 0;
			this._aabbVer++;
		};
		_proto.setPosition = function setPosition(x, y, z) {
			if (x instanceof Vec3) {
				position$1.copy(x);
			} else {
				position$1.set(x, y, z);
			}
			if (this._parent === null) {
				this.localPosition.copy(position$1);
			} else {
				invParentWtm$1.copy(this._parent.getWorldTransform()).invert();
				invParentWtm$1.transformPoint(position$1, this.localPosition);
			}
			if (!this._dirtyLocal) this._dirtifyLocal();
		};
		_proto.setRotation = function setRotation(x, y, z, w) {
			if (x instanceof Quat) {
				rotation.copy(x);
			} else {
				rotation.set(x, y, z, w);
			}
			if (this._parent === null) {
				this.localRotation.copy(rotation);
			} else {
				var parentRot = this._parent.getRotation();
				invParentRot.copy(parentRot).invert();
				this.localRotation.copy(invParentRot).mul(rotation);
			}
			if (!this._dirtyLocal) this._dirtifyLocal();
		};
		_proto.setEulerAngles = function setEulerAngles(x, y, z) {
			this.localRotation.setFromEulerAngles(x, y, z);
			if (this._parent !== null) {
				var parentRot = this._parent.getRotation();
				invParentRot.copy(parentRot).invert();
				this.localRotation.mul2(invParentRot, this.localRotation);
			}
			if (!this._dirtyLocal) this._dirtifyLocal();
		};
		_proto.addChild = function addChild(node) {
			this._prepareInsertChild(node);
			this._children.push(node);
			this._onInsertChild(node);
		};
		_proto.addChildAndSaveTransform = function addChildAndSaveTransform(node) {
			var wPos = node.getPosition();
			var wRot = node.getRotation();
			this._prepareInsertChild(node);
			node.setPosition(tmpMat4.copy(this.worldTransform).invert().transformPoint(wPos));
			node.setRotation(tmpQuat.copy(this.getRotation()).invert().mul(wRot));
			this._children.push(node);
			this._onInsertChild(node);
		};
		_proto.insertChild = function insertChild(node, index) {
			this._prepareInsertChild(node);
			this._children.splice(index, 0, node);
			this._onInsertChild(node);
		};
		_proto._prepareInsertChild = function _prepareInsertChild(node) {
			node.remove();
		};
		_proto._fireOnHierarchy = function _fireOnHierarchy(name, nameHierarchy, parent) {
			this.fire(name, parent);
			for (var i = 0; i < this._children.length; i++) {
				this._children[i]._fireOnHierarchy(nameHierarchy, nameHierarchy, parent);
			}
		};
		_proto._onInsertChild = function _onInsertChild(node) {
			node._parent = this;
			var enabledInHierarchy = node._enabled && this.enabled;
			if (node._enabledInHierarchy !== enabledInHierarchy) {
				node._enabledInHierarchy = enabledInHierarchy;
				node._notifyHierarchyStateChanged(node, enabledInHierarchy);
			}
			node._updateGraphDepth();
			node._dirtifyWorld();
			if (this._frozen) node._unfreezeParentToRoot();
			node._fireOnHierarchy('insert', 'inserthierarchy', this);
			if (this.fire) this.fire('childinsert', node);
		};
		_proto._updateGraphDepth = function _updateGraphDepth() {
			this._graphDepth = this._parent ? this._parent._graphDepth + 1 : 0;
			for (var i = 0, len = this._children.length; i < len; i++) {
				this._children[i]._updateGraphDepth();
			}
		};
		_proto.removeChild = function removeChild(child) {
			var index = this._children.indexOf(child);
			if (index === -1) {
				return;
			}
			this._children.splice(index, 1);
			child._parent = null;
			child._fireOnHierarchy('remove', 'removehierarchy', this);
			this.fire('childremove', child);
		};
		_proto._sync = function _sync() {
			if (this._dirtyLocal) {
				this.localTransform.setTRS(this.localPosition, this.localRotation, this.localScale);
				this._dirtyLocal = false;
			}
			if (this._dirtyWorld) {
				if (this._parent === null) {
					this.worldTransform.copy(this.localTransform);
				} else {
					if (this.scaleCompensation) {
						var parentWorldScale;
						var parent = this._parent;
						var scale = this.localScale;
						var parentToUseScaleFrom = parent;
						if (parentToUseScaleFrom) {
							while (parentToUseScaleFrom && parentToUseScaleFrom.scaleCompensation) {
								parentToUseScaleFrom = parentToUseScaleFrom._parent;
							}
							if (parentToUseScaleFrom) {
								parentToUseScaleFrom = parentToUseScaleFrom._parent;
								if (parentToUseScaleFrom) {
									parentWorldScale = parentToUseScaleFrom.worldTransform.getScale();
									scaleCompensateScale.mul2(parentWorldScale, this.localScale);
									scale = scaleCompensateScale;
								}
							}
						}
						scaleCompensateRot2.setFromMat4(parent.worldTransform);
						scaleCompensateRot.mul2(scaleCompensateRot2, this.localRotation);
						var tmatrix = parent.worldTransform;
						if (parent.scaleCompensation) {
							scaleCompensateScaleForParent.mul2(parentWorldScale, parent.getLocalScale());
							scaleCompensatePosTransform.setTRS(parent.worldTransform.getTranslation(scaleCompensatePos), scaleCompensateRot2, scaleCompensateScaleForParent);
							tmatrix = scaleCompensatePosTransform;
						}
						tmatrix.transformPoint(this.localPosition, scaleCompensatePos);
						this.worldTransform.setTRS(scaleCompensatePos, scaleCompensateRot, scale);
					} else {
						this.worldTransform.mulAffine2(this._parent.worldTransform, this.localTransform);
					}
				}
				this._dirtyWorld = false;
			}
		};
		_proto.syncHierarchy = function syncHierarchy() {
			if (!this._enabled) return;
			if (this._frozen) return;
			this._frozen = true;
			if (this._dirtyLocal || this._dirtyWorld) {
				this._sync();
			}
			var children = this._children;
			for (var i = 0, len = children.length; i < len; i++) {
				children[i].syncHierarchy();
			}
		};
		_proto.lookAt = function lookAt(x, y, z, ux, uy, uz) {
			if (ux === void 0) {
				ux = 0;
			}
			if (uy === void 0) {
				uy = 1;
			}
			if (uz === void 0) {
				uz = 0;
			}
			if (x instanceof Vec3) {
				target.copy(x);
				if (y instanceof Vec3) {
					up.copy(y);
				} else {
					up.copy(Vec3.UP);
				}
			} else if (z === undefined) {
				return;
			} else {
				target.set(x, y, z);
				up.set(ux, uy, uz);
			}
			matrix.setLookAt(this.getPosition(), target, up);
			rotation.setFromMat4(matrix);
			this.setRotation(rotation);
		};
		_proto.translate = function translate(x, y, z) {
			if (x instanceof Vec3) {
				position$1.copy(x);
			} else {
				position$1.set(x, y, z);
			}
			position$1.add(this.getPosition());
			this.setPosition(position$1);
		};
		_proto.translateLocal = function translateLocal(x, y, z) {
			if (x instanceof Vec3) {
				position$1.copy(x);
			} else {
				position$1.set(x, y, z);
			}
			this.localRotation.transformVector(position$1, position$1);
			this.localPosition.add(position$1);
			if (!this._dirtyLocal) this._dirtifyLocal();
		};
		_proto.rotate = function rotate(x, y, z) {
			rotation.setFromEulerAngles(x, y, z);
			if (this._parent === null) {
				this.localRotation.mul2(rotation, this.localRotation);
			} else {
				var rot = this.getRotation();
				var parentRot = this._parent.getRotation();
				invParentRot.copy(parentRot).invert();
				rotation.mul2(invParentRot, rotation);
				this.localRotation.mul2(rotation, rot);
			}
			if (!this._dirtyLocal) this._dirtifyLocal();
		};
		_proto.rotateLocal = function rotateLocal(x, y, z) {
			rotation.setFromEulerAngles(x, y, z);
			this.localRotation.mul(rotation);
			if (!this._dirtyLocal) this._dirtifyLocal();
		};
		_createClass(GraphNode, [{
			key: "right",
			get: function get() {
				if (!this._right) {
					this._right = new Vec3();
				}
				return this.getWorldTransform().getX(this._right).normalize();
			}
		}, {
			key: "up",
			get: function get() {
				if (!this._up) {
					this._up = new Vec3();
				}
				return this.getWorldTransform().getY(this._up).normalize();
			}
		}, {
			key: "forward",
			get: function get() {
				if (!this._forward) {
					this._forward = new Vec3();
				}
				return this.getWorldTransform().getZ(this._forward).normalize().mulScalar(-1);
			}
		}, {
			key: "normalMatrix",
			get: function get() {
				var normalMat = this._normalMatrix;
				if (this._dirtyNormal) {
					this.getWorldTransform().invertTo3x3(normalMat);
					normalMat.transpose();
					this._dirtyNormal = false;
				}
				return normalMat;
			}
		}, {
			key: "enabled",
			get: function get() {
				return this._enabled && this._enabledInHierarchy;
			},
			set: function set(enabled) {
				if (this._enabled !== enabled) {
					var _this$_parent2;
					this._enabled = enabled;
					if (enabled && (_this$_parent2 = this._parent) != null && _this$_parent2.enabled || !enabled) {
						this._notifyHierarchyStateChanged(this, enabled);
					}
				}
			}
		}, {
			key: "parent",
			get: function get() {
				return this._parent;
			}
		}, {
			key: "path",
			get: function get() {
				var node = this._parent;
				if (!node) {
					return '';
				}
				var result = this.name;
				while (node && node._parent) {
					result = node.name + "/" + result;
					node = node._parent;
				}
				return result;
			}
		}, {
			key: "root",
			get: function get() {
				var result = this;
				while (result._parent) {
					result = result._parent;
				}
				return result;
			}
		}, {
			key: "children",
			get: function get() {
				return this._children;
			}
		}, {
			key: "graphDepth",
			get: function get() {
				return this._graphDepth;
			}
		}, {
			key: "worldScaleSign",
			get: function get() {
				if (this._worldScaleSign === 0) {
					this._worldScaleSign = this.getWorldTransform().scaleSign;
				}
				return this._worldScaleSign;
			}
		}]);
		return GraphNode;
	}(EventHandler);

	var RefCountedCache = function () {
		function RefCountedCache() {
			this.cache = new Map();
		}
		var _proto = RefCountedCache.prototype;
		_proto.destroy = function destroy() {
			this.cache.forEach(function (refCount, object) {
				object.destroy();
			});
			this.cache.clear();
		};
		_proto.incRef = function incRef(object) {
			var refCount = (this.cache.get(object) || 0) + 1;
			this.cache.set(object, refCount);
		};
		_proto.decRef = function decRef(object) {
			if (object) {
				var refCount = this.cache.get(object);
				if (refCount) {
					refCount--;
					if (refCount === 0) {
						this.cache.delete(object);
						object.destroy();
					} else {
						this.cache.set(object, refCount);
					}
				}
			}
		};
		return RefCountedCache;
	}();

	var LightmapCache = function () {
		function LightmapCache() {}
		LightmapCache.incRef = function incRef(texture) {
			this.cache.incRef(texture);
		};
		LightmapCache.decRef = function decRef(texture) {
			this.cache.decRef(texture);
		};
		LightmapCache.destroy = function destroy() {
			this.cache.destroy();
		};
		return LightmapCache;
	}();
	LightmapCache.cache = new RefCountedCache();

	var _tmpAabb = new BoundingBox();
	var _tempBoneAabb = new BoundingBox();
	var _tempSphere = new BoundingSphere();
	var _meshSet = new Set();
	var InstancingData = function InstancingData(numObjects) {
		this.vertexBuffer = null;
		this.count = numObjects;
	};
	var Command = function () {
		function Command(layer, blendType, command) {
			this._key = [];
			this._key[SORTKEY_FORWARD] = getKey(layer, blendType, true, 0);
			this.command = command;
		}
		_createClass(Command, [{
			key: "key",
			get: function get() {
				return this._key[SORTKEY_FORWARD];
			},
			set: function set(val) {
				this._key[SORTKEY_FORWARD] = val;
			}
		}]);
		return Command;
	}();
	var ShaderInstance = function () {
		function ShaderInstance() {
			this.shader = void 0;
			this.bindGroup = null;
		}
		var _proto = ShaderInstance.prototype;
		_proto.getBindGroup = function getBindGroup(device) {
			if (!this.bindGroup) {
				var shader = this.shader;
				var ubFormat = shader.meshUniformBufferFormat;
				var uniformBuffer = new UniformBuffer(device, ubFormat, false);
				var bindGroupFormat = shader.meshBindGroupFormat;
				this.bindGroup = new BindGroup(device, bindGroupFormat, uniformBuffer);
			}
			return this.bindGroup;
		};
		_proto.destroy = function destroy() {
			var group = this.bindGroup;
			if (group) {
				var _group$defaultUniform;
				(_group$defaultUniform = group.defaultUniformBuffer) == null ? void 0 : _group$defaultUniform.destroy();
				group.destroy();
				this.bindGroup = null;
			}
		};
		return ShaderInstance;
	}();
	var ShaderCacheEntry = function () {
		function ShaderCacheEntry() {
			this.shaderInstances = new Map();
		}
		var _proto2 = ShaderCacheEntry.prototype;
		_proto2.destroy = function destroy() {
			this.shaderInstances.forEach(function (instance) {
				return instance.destroy();
			});
			this.shaderInstances.clear();
		};
		return ShaderCacheEntry;
	}();
	var MeshInstance = function () {
		function MeshInstance(mesh, material, node) {
			if (node === void 0) {
				node = null;
			}
			this.visible = true;
			this.castShadow = false;
			this.transparent = false;
			this._material = null;
			this._shaderCache = [];
			if (mesh instanceof GraphNode) {
				var temp = mesh;
				mesh = material;
				material = node;
				node = temp;
			}
			this._key = [0, 0];
			this.node = node;
			this._mesh = mesh;
			mesh.incRefCount();
			this.material = material;
			this._shaderDefs = MASK_AFFECT_DYNAMIC << 16;
			this._shaderDefs |= mesh.vertexBuffer.format.hasUv0 ? SHADERDEF_UV0 : 0;
			this._shaderDefs |= mesh.vertexBuffer.format.hasUv1 ? SHADERDEF_UV1 : 0;
			this._shaderDefs |= mesh.vertexBuffer.format.hasColor ? SHADERDEF_VCOLOR : 0;
			this._shaderDefs |= mesh.vertexBuffer.format.hasTangents ? SHADERDEF_TANGENTS : 0;
			this.layer = LAYER_WORLD;
			this._renderStyle = RENDERSTYLE_SOLID;
			this._receiveShadow = true;
			this._screenSpace = false;
			this._noDepthDrawGl1 = false;
			this.cull = true;
			this.pick = true;
			this._updateAabb = true;
			this._updateAabbFunc = null;
			this._calculateSortDistance = null;
			this.updateKey();
			this._skinInstance = null;
			this._morphInstance = null;
			this.instancingData = null;
			this._customAabb = null;
			this.aabb = new BoundingBox();
			this._aabbVer = -1;
			this.drawOrder = 0;
			this.visibleThisFrame = false;
			this.isVisibleFunc = null;
			this.parameters = {};
			this.stencilFront = null;
			this.stencilBack = null;
			this.flipFacesFactor = 1;
		}
		var _proto3 = MeshInstance.prototype;
		_proto3.clearShaders = function clearShaders() {
			var shaderCache = this._shaderCache;
			for (var i = 0; i < shaderCache.length; i++) {
				var _shaderCache$i;
				(_shaderCache$i = shaderCache[i]) == null ? void 0 : _shaderCache$i.destroy();
				shaderCache[i] = null;
			}
		};
		_proto3.getShaderInstance = function getShaderInstance(shaderPass, lightHash, scene, viewUniformFormat, viewBindGroupFormat, sortedLights) {
			var shaderInstance;
			var passEntry = this._shaderCache[shaderPass];
			if (passEntry) {
				shaderInstance = passEntry.shaderInstances.get(lightHash);
			} else {
				passEntry = new ShaderCacheEntry();
				this._shaderCache[shaderPass] = passEntry;
			}
			if (!shaderInstance) {
				var mat = this._material;
				var shaderDefs = this._shaderDefs;
				var variantKey = shaderPass + '_' + shaderDefs + '_' + lightHash;
				shaderInstance = new ShaderInstance();
				shaderInstance.shader = mat.variants.get(variantKey);
				if (!shaderInstance.shader) {
					var shader = mat.getShaderVariant(this.mesh.device, scene, shaderDefs, null, shaderPass, sortedLights, viewUniformFormat, viewBindGroupFormat, this._mesh.vertexBuffer.format);
					mat.variants.set(variantKey, shader);
					shaderInstance.shader = shader;
				}
				passEntry.shaderInstances.set(lightHash, shaderInstance);
			}
			return shaderInstance;
		};
		_proto3._updateShaderDefs = function _updateShaderDefs(shaderDefs) {
			if (shaderDefs !== this._shaderDefs) {
				this._shaderDefs = shaderDefs;
				this.clearShaders();
			}
		};
		_proto3.destroy = function destroy() {
			var _this$_skinInstance, _this$morphInstance;
			var mesh = this.mesh;
			if (mesh) {
				this.mesh = null;
				if (mesh.refCount < 1) {
					mesh.destroy();
				}
			}
			this.setRealtimeLightmap(MeshInstance.lightmapParamNames[0], null);
			this.setRealtimeLightmap(MeshInstance.lightmapParamNames[1], null);
			(_this$_skinInstance = this._skinInstance) == null ? void 0 : _this$_skinInstance.destroy();
			this._skinInstance = null;
			(_this$morphInstance = this.morphInstance) == null ? void 0 : _this$morphInstance.destroy();
			this.morphInstance = null;
			this.clearShaders();
			this.material = null;
		};
		MeshInstance._prepareRenderStyleForArray = function _prepareRenderStyleForArray(meshInstances, renderStyle) {
			if (meshInstances) {
				for (var i = 0; i < meshInstances.length; i++) {
					meshInstances[i]._renderStyle = renderStyle;
					var mesh = meshInstances[i].mesh;
					if (!_meshSet.has(mesh)) {
						_meshSet.add(mesh);
						mesh.prepareRenderState(renderStyle);
					}
				}
				_meshSet.clear();
			}
		};
		_proto3._isVisible = function _isVisible(camera) {
			if (this.visible) {
				if (this.isVisibleFunc) {
					return this.isVisibleFunc(camera);
				}
				_tempSphere.center = this.aabb.center;
				_tempSphere.radius = this._aabb.halfExtents.length();
				return camera.frustum.containsSphere(_tempSphere);
			}
			return false;
		};
		_proto3.updateKey = function updateKey() {
			var material = this.material;
			this._key[SORTKEY_FORWARD] = getKey(this.layer, material.alphaToCoverage || material.alphaTest ? BLEND_NORMAL : material.blendType, false, material.id);
		};
		_proto3.setInstancing = function setInstancing(vertexBuffer) {
			if (vertexBuffer) {
				this.instancingData = new InstancingData(vertexBuffer.numVertices);
				this.instancingData.vertexBuffer = vertexBuffer;
				vertexBuffer.format.instancing = true;
				this.cull = false;
			} else {
				this.instancingData = null;
				this.cull = true;
			}
			this._updateShaderDefs(vertexBuffer ? this._shaderDefs | SHADERDEF_INSTANCING : this._shaderDefs & ~SHADERDEF_INSTANCING);
		};
		_proto3.ensureMaterial = function ensureMaterial(device) {
			if (!this.material) {
				this.material = getDefaultMaterial(device);
			}
		};
		_proto3.clearParameters = function clearParameters() {
			this.parameters = {};
		};
		_proto3.getParameters = function getParameters() {
			return this.parameters;
		};
		_proto3.getParameter = function getParameter(name) {
			return this.parameters[name];
		};
		_proto3.setParameter = function setParameter(name, data, passFlags) {
			if (passFlags === void 0) {
				passFlags = -262141;
			}
			if (data === undefined && typeof name === 'object') {
				var uniformObject = name;
				if (uniformObject.length) {
					for (var i = 0; i < uniformObject.length; i++) {
						this.setParameter(uniformObject[i]);
					}
					return;
				}
				name = uniformObject.name;
				data = uniformObject.value;
			}
			var param = this.parameters[name];
			if (param) {
				param.data = data;
				param.passFlags = passFlags;
			} else {
				this.parameters[name] = {
					scopeId: null,
					data: data,
					passFlags: passFlags
				};
			}
		};
		_proto3.setRealtimeLightmap = function setRealtimeLightmap(name, texture) {
			var old = this.getParameter(name);
			if (old === texture) return;
			if (old) {
				LightmapCache.decRef(old.data);
			}
			if (texture) {
				LightmapCache.incRef(texture);
				this.setParameter(name, texture);
			} else {
				this.deleteParameter(name);
			}
		};
		_proto3.deleteParameter = function deleteParameter(name) {
			if (this.parameters[name]) {
				delete this.parameters[name];
			}
		};
		_proto3.setParameters = function setParameters(device, passFlag) {
			var parameters = this.parameters;
			for (var paramName in parameters) {
				var parameter = parameters[paramName];
				if (parameter.passFlags & passFlag) {
					if (!parameter.scopeId) {
						parameter.scopeId = device.scope.resolve(paramName);
					}
					parameter.scopeId.setValue(parameter.data);
				}
			}
		};
		_proto3.setLightmapped = function setLightmapped(value) {
			if (value) {
				this.mask = (this.mask | MASK_AFFECT_LIGHTMAPPED) & ~(MASK_AFFECT_DYNAMIC | MASK_BAKE);
			} else {
				this.setRealtimeLightmap(MeshInstance.lightmapParamNames[0], null);
				this.setRealtimeLightmap(MeshInstance.lightmapParamNames[1], null);
				this._shaderDefs &= ~(SHADERDEF_LM | SHADERDEF_DIRLM | SHADERDEF_LMAMBIENT);
				this.mask = (this.mask | MASK_AFFECT_DYNAMIC) & ~(MASK_AFFECT_LIGHTMAPPED | MASK_BAKE);
			}
		};
		_proto3.setCustomAabb = function setCustomAabb(aabb) {
			if (aabb) {
				if (this._customAabb) {
					this._customAabb.copy(aabb);
				} else {
					this._customAabb = aabb.clone();
				}
			} else {
				this._customAabb = null;
				this._aabbVer = -1;
			}
			this._setupSkinUpdate();
		};
		_proto3._setupSkinUpdate = function _setupSkinUpdate() {
			if (this._skinInstance) {
				this._skinInstance._updateBeforeCull = !this._customAabb;
			}
		};
		_createClass(MeshInstance, [{
			key: "renderStyle",
			get: function get() {
				return this._renderStyle;
			},
			set: function set(renderStyle) {
				this._renderStyle = renderStyle;
				this.mesh.prepareRenderState(renderStyle);
			}
		}, {
			key: "mesh",
			get: function get() {
				return this._mesh;
			},
			set: function set(mesh) {
				if (mesh === this._mesh) return;
				if (this._mesh) {
					this._mesh.decRefCount();
				}
				this._mesh = mesh;
				if (mesh) {
					mesh.incRefCount();
				}
			}
		}, {
			key: "aabb",
			get: function get() {
				if (!this._updateAabb) {
					return this._aabb;
				}
				if (this._updateAabbFunc) {
					return this._updateAabbFunc(this._aabb);
				}
				var localAabb = this._customAabb;
				var toWorldSpace = !!localAabb;
				if (!localAabb) {
					localAabb = _tmpAabb;
					if (this.skinInstance) {
						if (!this.mesh.boneAabb) {
							var morphTargets = this._morphInstance ? this._morphInstance.morph._targets : null;
							this.mesh._initBoneAabbs(morphTargets);
						}
						var boneUsed = this.mesh.boneUsed;
						var first = true;
						for (var i = 0; i < this.mesh.boneAabb.length; i++) {
							if (boneUsed[i]) {
								_tempBoneAabb.setFromTransformedAabb(this.mesh.boneAabb[i], this.skinInstance.matrices[i]);
								if (first) {
									first = false;
									localAabb.center.copy(_tempBoneAabb.center);
									localAabb.halfExtents.copy(_tempBoneAabb.halfExtents);
								} else {
									localAabb.add(_tempBoneAabb);
								}
							}
						}
						toWorldSpace = true;
					} else if (this.node._aabbVer !== this._aabbVer) {
						if (this.mesh) {
							localAabb.center.copy(this.mesh.aabb.center);
							localAabb.halfExtents.copy(this.mesh.aabb.halfExtents);
						} else {
							localAabb.center.set(0, 0, 0);
							localAabb.halfExtents.set(0, 0, 0);
						}
						if (this.mesh && this.mesh.morph) {
							var morphAabb = this.mesh.morph.aabb;
							localAabb._expand(morphAabb.getMin(), morphAabb.getMax());
						}
						toWorldSpace = true;
						this._aabbVer = this.node._aabbVer;
					}
				}
				if (toWorldSpace) {
					this._aabb.setFromTransformedAabb(localAabb, this.node.getWorldTransform());
				}
				return this._aabb;
			},
			set: function set(aabb) {
				this._aabb = aabb;
			}
		}, {
			key: "material",
			get: function get() {
				return this._material;
			},
			set: function set(material) {
				this.clearShaders();
				var prevMat = this._material;
				if (prevMat) {
					prevMat.removeMeshInstanceRef(this);
				}
				this._material = material;
				if (material) {
					material.addMeshInstanceRef(this);
					this.transparent = material.transparent;
					this.updateKey();
					var prevBlend = prevMat && prevMat.transparent;
					if (material.transparent !== prevBlend) {
						var scene = this._material._scene || (prevMat == null ? void 0 : prevMat._scene);
						if (scene) {
							scene.layers._dirtyBlend = true;
						} else {
							material._dirtyBlend = true;
						}
					}
				}
			}
		}, {
			key: "layer",
			get: function get() {
				return this._layer;
			},
			set: function set(layer) {
				this._layer = layer;
				this.updateKey();
			}
		}, {
			key: "calculateSortDistance",
			get: function get() {
				return this._calculateSortDistance;
			},
			set: function set(calculateSortDistance) {
				this._calculateSortDistance = calculateSortDistance;
			}
		}, {
			key: "receiveShadow",
			get: function get() {
				return this._receiveShadow;
			},
			set: function set(val) {
				if (this._receiveShadow !== val) {
					this._receiveShadow = val;
					this._updateShaderDefs(val ? this._shaderDefs & ~SHADERDEF_NOSHADOW : this._shaderDefs | SHADERDEF_NOSHADOW);
				}
			}
		}, {
			key: "skinInstance",
			get: function get() {
				return this._skinInstance;
			},
			set: function set(val) {
				this._skinInstance = val;
				this._updateShaderDefs(val ? this._shaderDefs | SHADERDEF_SKIN : this._shaderDefs & ~SHADERDEF_SKIN);
				this._setupSkinUpdate();
			}
		}, {
			key: "morphInstance",
			get: function get() {
				return this._morphInstance;
			},
			set: function set(val) {
				var _this$_morphInstance;
				(_this$_morphInstance = this._morphInstance) == null ? void 0 : _this$_morphInstance.destroy();
				this._morphInstance = val;
				var shaderDefs = this._shaderDefs;
				shaderDefs = val && val.morph.useTextureMorph ? shaderDefs | SHADERDEF_MORPH_TEXTURE_BASED : shaderDefs & ~SHADERDEF_MORPH_TEXTURE_BASED;
				shaderDefs = val && val.morph.morphPositions ? shaderDefs | SHADERDEF_MORPH_POSITION : shaderDefs & ~SHADERDEF_MORPH_POSITION;
				shaderDefs = val && val.morph.morphNormals ? shaderDefs | SHADERDEF_MORPH_NORMAL : shaderDefs & ~SHADERDEF_MORPH_NORMAL;
				this._updateShaderDefs(shaderDefs);
			}
		}, {
			key: "screenSpace",
			get: function get() {
				return this._screenSpace;
			},
			set: function set(val) {
				if (this._screenSpace !== val) {
					this._screenSpace = val;
					this._updateShaderDefs(val ? this._shaderDefs | SHADERDEF_SCREENSPACE : this._shaderDefs & ~SHADERDEF_SCREENSPACE);
				}
			}
		}, {
			key: "key",
			get: function get() {
				return this._key[SORTKEY_FORWARD];
			},
			set: function set(val) {
				this._key[SORTKEY_FORWARD] = val;
			}
		}, {
			key: "mask",
			get: function get() {
				return this._shaderDefs >> 16;
			},
			set: function set(val) {
				var toggles = this._shaderDefs & 0x0000FFFF;
				this._updateShaderDefs(toggles | val << 16);
			}
		}, {
			key: "instancingCount",
			get: function get() {
				return this.instancingData ? this.instancingData.count : 0;
			},
			set: function set(value) {
				if (this.instancingData) this.instancingData.count = value;
			}
		}]);
		return MeshInstance;
	}();
	MeshInstance.lightmapParamNames = ['texture_lightMap', 'texture_dirLightMap'];
	function getKey(layer, blendType, isCommand, materialId) {
		return (layer & 0x0f) << 27 | (blendType === BLEND_NONE ? 1 : 0) << 26 | (isCommand ? 1 : 0) << 25 | (materialId & 0x1ffffff) << 0;
	}

	function paramsIdentical(a, b) {
		if (a && !b) return false;
		if (!a && b) return false;
		a = a.data;
		b = b.data;
		if (a === b) return true;
		if (a instanceof Float32Array && b instanceof Float32Array) {
			if (a.length !== b.length) return false;
			for (var i = 0; i < a.length; i++) {
				if (a[i] !== b[i]) return false;
			}
			return true;
		}
		return false;
	}
	function equalParamSets(params1, params2) {
		for (var param in params1) {
			if (params1.hasOwnProperty(param) && !paramsIdentical(params1[param], params2[param])) return false;
		}
		for (var _param in params2) {
			if (params2.hasOwnProperty(_param) && !paramsIdentical(params2[_param], params1[_param])) return false;
		}
		return true;
	}
	var _triFanIndices = [0, 1, 3, 2, 3, 1];
	var _triStripIndices = [0, 1, 3, 0, 3, 2];
	var mat3 = new Mat3();
	function getScaleSign(mi) {
		return mi.node.worldTransform.scaleSign;
	}
	var BatchManager = function () {
		function BatchManager(device, root, scene) {
			this.device = device;
			this.rootNode = root;
			this.scene = scene;
			this._init = false;
			this._batchGroups = {};
			this._batchGroupCounter = 0;
			this._batchList = [];
			this._dirtyGroups = [];
		}
		var _proto = BatchManager.prototype;
		_proto.destroy = function destroy() {
			this.device = null;
			this.rootNode = null;
			this.scene = null;
			this._batchGroups = {};
			this._batchList = [];
			this._dirtyGroups = [];
		};
		_proto.addGroup = function addGroup(name, dynamic, maxAabbSize, id, layers) {
			if (id === undefined) {
				id = this._batchGroupCounter;
				this._batchGroupCounter++;
			}
			if (this._batchGroups[id]) {
				return undefined;
			}
			var group = new BatchGroup(id, name, dynamic, maxAabbSize, layers);
			this._batchGroups[id] = group;
			return group;
		};
		_proto.removeGroup = function removeGroup(id) {
			if (!this._batchGroups[id]) {
				return;
			}
			var newBatchList = [];
			for (var i = 0; i < this._batchList.length; i++) {
				if (this._batchList[i].batchGroupId === id) {
					this.destroyBatch(this._batchList[i]);
				} else {
					newBatchList.push(this._batchList[i]);
				}
			}
			this._batchList = newBatchList;
			this._removeModelsFromBatchGroup(this.rootNode, id);
			delete this._batchGroups[id];
		};
		_proto.markGroupDirty = function markGroupDirty(id) {
			if (this._dirtyGroups.indexOf(id) < 0) {
				this._dirtyGroups.push(id);
			}
		};
		_proto.getGroupByName = function getGroupByName(name) {
			var groups = this._batchGroups;
			for (var group in groups) {
				if (!groups.hasOwnProperty(group)) continue;
				if (groups[group].name === name) {
					return groups[group];
				}
			}
			return null;
		};
		_proto.getBatches = function getBatches(batchGroupId) {
			var results = [];
			var len = this._batchList.length;
			for (var i = 0; i < len; i++) {
				var batch = this._batchList[i];
				if (batch.batchGroupId === batchGroupId) {
					results.push(batch);
				}
			}
			return results;
		};
		_proto._removeModelsFromBatchGroup = function _removeModelsFromBatchGroup(node, id) {
			if (!node.enabled) return;
			if (node.model && node.model.batchGroupId === id) {
				node.model.batchGroupId = -1;
			}
			if (node.render && node.render.batchGroupId === id) {
				node.render.batchGroupId = -1;
			}
			if (node.element && node.element.batchGroupId === id) {
				node.element.batchGroupId = -1;
			}
			if (node.sprite && node.sprite.batchGroupId === id) {
				node.sprite.batchGroupId = -1;
			}
			for (var i = 0; i < node._children.length; i++) {
				this._removeModelsFromBatchGroup(node._children[i], id);
			}
		};
		_proto.insert = function insert(type, groupId, node) {
			var group = this._batchGroups[groupId];
			if (group) {
				if (group._obj[type].indexOf(node) < 0) {
					group._obj[type].push(node);
					this.markGroupDirty(groupId);
				}
			}
		};
		_proto.remove = function remove(type, groupId, node) {
			var group = this._batchGroups[groupId];
			if (group) {
				var idx = group._obj[type].indexOf(node);
				if (idx >= 0) {
					group._obj[type].splice(idx, 1);
					this.markGroupDirty(groupId);
				}
			}
		};
		_proto._extractRender = function _extractRender(node, arr, group, groupMeshInstances) {
			if (node.render) {
				arr = groupMeshInstances[node.render.batchGroupId] = arr.concat(node.render.meshInstances);
				node.render.removeFromLayers();
			}
			return arr;
		};
		_proto._extractModel = function _extractModel(node, arr, group, groupMeshInstances) {
			if (node.model && node.model.model) {
				arr = groupMeshInstances[node.model.batchGroupId] = arr.concat(node.model.meshInstances);
				node.model.removeModelFromLayers();
			}
			return arr;
		};
		_proto._extractElement = function _extractElement(node, arr, group) {
			if (!node.element) return;
			var valid = false;
			if (node.element._text && node.element._text._model.meshInstances.length > 0) {
				arr.push(node.element._text._model.meshInstances[0]);
				node.element.removeModelFromLayers(node.element._text._model);
				valid = true;
			} else if (node.element._image) {
				arr.push(node.element._image._renderable.meshInstance);
				node.element.removeModelFromLayers(node.element._image._renderable.model);
				if (node.element._image._renderable.unmaskMeshInstance) {
					arr.push(node.element._image._renderable.unmaskMeshInstance);
					if (!node.element._image._renderable.unmaskMeshInstance.stencilFront || !node.element._image._renderable.unmaskMeshInstance.stencilBack) {
						node.element._dirtifyMask();
						node.element._onPrerender();
					}
				}
				valid = true;
			}
			if (valid) {
				group._ui = true;
			}
		};
		_proto._collectAndRemoveMeshInstances = function _collectAndRemoveMeshInstances(groupMeshInstances, groupIds) {
			for (var g = 0; g < groupIds.length; g++) {
				var id = groupIds[g];
				var group = this._batchGroups[id];
				if (!group) continue;
				var arr = groupMeshInstances[id];
				if (!arr) arr = groupMeshInstances[id] = [];
				for (var m = 0; m < group._obj.model.length; m++) {
					arr = this._extractModel(group._obj.model[m], arr, group, groupMeshInstances);
				}
				for (var r = 0; r < group._obj.render.length; r++) {
					arr = this._extractRender(group._obj.render[r], arr, group, groupMeshInstances);
				}
				for (var e = 0; e < group._obj.element.length; e++) {
					this._extractElement(group._obj.element[e], arr, group);
				}
				for (var s = 0; s < group._obj.sprite.length; s++) {
					var node = group._obj.sprite[s];
					if (node.sprite && node.sprite._meshInstance && (group.dynamic || node.sprite.sprite._renderMode === SPRITE_RENDERMODE_SIMPLE)) {
						arr.push(node.sprite._meshInstance);
						node.sprite.removeModelFromLayers();
						group._sprite = true;
						node.sprite._batchGroup = group;
					}
				}
			}
		};
		_proto.generate = function generate(groupIds) {
			var groupMeshInstances = {};
			if (!groupIds) {
				groupIds = Object.keys(this._batchGroups);
			}
			var newBatchList = [];
			for (var i = 0; i < this._batchList.length; i++) {
				if (groupIds.indexOf(this._batchList[i].batchGroupId) < 0) {
					newBatchList.push(this._batchList[i]);
					continue;
				}
				this.destroyBatch(this._batchList[i]);
			}
			this._batchList = newBatchList;
			this._collectAndRemoveMeshInstances(groupMeshInstances, groupIds);
			if (groupIds === this._dirtyGroups) {
				this._dirtyGroups.length = 0;
			} else {
				var newDirtyGroups = [];
				for (var _i = 0; _i < this._dirtyGroups.length; _i++) {
					if (groupIds.indexOf(this._dirtyGroups[_i]) < 0) newDirtyGroups.push(this._dirtyGroups[_i]);
				}
				this._dirtyGroups = newDirtyGroups;
			}
			var group, lists, groupData, batch;
			for (var groupId in groupMeshInstances) {
				if (!groupMeshInstances.hasOwnProperty(groupId)) continue;
				group = groupMeshInstances[groupId];
				groupData = this._batchGroups[groupId];
				if (!groupData) {
					continue;
				}
				lists = this.prepare(group, groupData.dynamic, groupData.maxAabbSize, groupData._ui || groupData._sprite);
				for (var _i2 = 0; _i2 < lists.length; _i2++) {
					batch = this.create(lists[_i2], groupData.dynamic, parseInt(groupId, 10));
					if (batch) {
						batch.addToLayers(this.scene, groupData.layers);
					}
				}
			}
		};
		_proto.prepare = function prepare(meshInstances, dynamic, maxAabbSize, translucent) {
			if (maxAabbSize === void 0) {
				maxAabbSize = Number.POSITIVE_INFINITY;
			}
			if (meshInstances.length === 0) return [];
			var halfMaxAabbSize = maxAabbSize * 0.5;
			var maxInstanceCount = this.device.supportsBoneTextures ? 1024 : this.device.boneLimit;
			var maxNumVertices = this.device.extUintElement ? 0xffffffff : 0xffff;
			var aabb = new BoundingBox();
			var testAabb = new BoundingBox();
			var skipTranslucentAabb = null;
			var sf;
			var lists = [];
			var j = 0;
			if (translucent) {
				meshInstances.sort(function (a, b) {
					return a.drawOrder - b.drawOrder;
				});
			}
			var meshInstancesLeftA = meshInstances;
			var meshInstancesLeftB;
			var skipMesh = translucent ? function (mi) {
				if (skipTranslucentAabb) {
					skipTranslucentAabb.add(mi.aabb);
				} else {
					skipTranslucentAabb = mi.aabb.clone();
				}
				meshInstancesLeftB.push(mi);
			} : function (mi) {
				meshInstancesLeftB.push(mi);
			};
			while (meshInstancesLeftA.length > 0) {
				lists[j] = [meshInstancesLeftA[0]];
				meshInstancesLeftB = [];
				var material = meshInstancesLeftA[0].material;
				var layer = meshInstancesLeftA[0].layer;
				var defs = meshInstancesLeftA[0]._shaderDefs;
				var params = meshInstancesLeftA[0].parameters;
				var stencil = meshInstancesLeftA[0].stencilFront;
				var vertCount = meshInstancesLeftA[0].mesh.vertexBuffer.getNumVertices();
				var drawOrder = meshInstancesLeftA[0].drawOrder;
				aabb.copy(meshInstancesLeftA[0].aabb);
				var scaleSign = getScaleSign(meshInstancesLeftA[0]);
				var vertexFormatBatchingHash = meshInstancesLeftA[0].mesh.vertexBuffer.format.batchingHash;
				var indexed = meshInstancesLeftA[0].mesh.primitive[0].indexed;
				skipTranslucentAabb = null;
				for (var i = 1; i < meshInstancesLeftA.length; i++) {
					var mi = meshInstancesLeftA[i];
					if (dynamic && lists[j].length >= maxInstanceCount) {
						meshInstancesLeftB = meshInstancesLeftB.concat(meshInstancesLeftA.slice(i));
						break;
					}
					if (material !== mi.material || layer !== mi.layer || vertexFormatBatchingHash !== mi.mesh.vertexBuffer.format.batchingHash || indexed !== mi.mesh.primitive[0].indexed || defs !== mi._shaderDefs || vertCount + mi.mesh.vertexBuffer.getNumVertices() > maxNumVertices) {
						skipMesh(mi);
						continue;
					}
					testAabb.copy(aabb);
					testAabb.add(mi.aabb);
					if (testAabb.halfExtents.x > halfMaxAabbSize || testAabb.halfExtents.y > halfMaxAabbSize || testAabb.halfExtents.z > halfMaxAabbSize) {
						skipMesh(mi);
						continue;
					}
					if (stencil) {
						if (!(sf = mi.stencilFront) || stencil.func !== sf.func || stencil.zpass !== sf.zpass) {
							skipMesh(mi);
							continue;
						}
					}
					if (scaleSign !== getScaleSign(mi)) {
						skipMesh(mi);
						continue;
					}
					if (!equalParamSets(params, mi.parameters)) {
						skipMesh(mi);
						continue;
					}
					if (translucent && skipTranslucentAabb && skipTranslucentAabb.intersects(mi.aabb) && mi.drawOrder !== drawOrder) {
						skipMesh(mi);
						continue;
					}
					aabb.add(mi.aabb);
					vertCount += mi.mesh.vertexBuffer.getNumVertices();
					lists[j].push(mi);
				}
				j++;
				meshInstancesLeftA = meshInstancesLeftB;
			}
			return lists;
		};
		_proto.collectBatchedMeshData = function collectBatchedMeshData(meshInstances, dynamic) {
			var streams = null;
			var batchNumVerts = 0;
			var batchNumIndices = 0;
			var material = null;
			for (var i = 0; i < meshInstances.length; i++) {
				if (meshInstances[i].visible) {
					var mesh = meshInstances[i].mesh;
					var numVerts = mesh.vertexBuffer.numVertices;
					batchNumVerts += numVerts;
					if (mesh.primitive[0].indexed) {
						batchNumIndices += mesh.primitive[0].count;
					} else {
						var primitiveType = mesh.primitive[0].type;
						if (primitiveType === PRIMITIVE_TRIFAN || primitiveType === PRIMITIVE_TRISTRIP) {
							if (mesh.primitive[0].count === 4) batchNumIndices += 6;
						}
					}
					if (!streams) {
						material = meshInstances[i].material;
						streams = {};
						var elems = mesh.vertexBuffer.format.elements;
						for (var j = 0; j < elems.length; j++) {
							var semantic = elems[j].name;
							streams[semantic] = {
								numComponents: elems[j].numComponents,
								dataType: elems[j].dataType,
								normalize: elems[j].normalize,
								count: 0
							};
						}
						if (dynamic) {
							streams[SEMANTIC_BLENDINDICES] = {
								numComponents: 1,
								dataType: TYPE_FLOAT32,
								normalize: false,
								count: 0
							};
						}
					}
				}
			}
			return {
				streams: streams,
				batchNumVerts: batchNumVerts,
				batchNumIndices: batchNumIndices,
				material: material
			};
		};
		_proto.create = function create(meshInstances, dynamic, batchGroupId) {
			if (!this._init) {
				var boneLimit = '#define BONE_LIMIT ' + this.device.getBoneLimit() + '\n';
				this.transformVS = boneLimit + '#define DYNAMICBATCH\n' + shaderChunks.transformVS;
				this.skinTexVS = shaderChunks.skinBatchTexVS;
				this.skinConstVS = shaderChunks.skinBatchConstVS;
				this.vertexFormats = {};
				this._init = true;
			}
			var stream = null;
			var semantic;
			var mesh, numVerts;
			var batch = null;
			var batchData = this.collectBatchedMeshData(meshInstances, dynamic);
			if (batchData.streams) {
				var streams = batchData.streams;
				var material = batchData.material;
				var batchNumVerts = batchData.batchNumVerts;
				var batchNumIndices = batchData.batchNumIndices;
				batch = new Batch(meshInstances, dynamic, batchGroupId);
				this._batchList.push(batch);
				var indexBase, numIndices, indexData;
				var verticesOffset = 0;
				var indexOffset = 0;
				var transform;
				var vec = new Vec3();
				var indexArrayType = batchNumVerts <= 0xffff ? Uint16Array : Uint32Array;
				var indices = new indexArrayType(batchNumIndices);
				for (semantic in streams) {
					stream = streams[semantic];
					stream.typeArrayType = typedArrayTypes[stream.dataType];
					stream.elementByteSize = typedArrayTypesByteSize[stream.dataType];
					stream.buffer = new stream.typeArrayType(batchNumVerts * stream.numComponents);
				}
				for (var i = 0; i < meshInstances.length; i++) {
					if (!meshInstances[i].visible) continue;
					mesh = meshInstances[i].mesh;
					numVerts = mesh.vertexBuffer.numVertices;
					if (!dynamic) {
						transform = meshInstances[i].node.getWorldTransform();
					}
					for (semantic in streams) {
						if (semantic !== SEMANTIC_BLENDINDICES) {
							stream = streams[semantic];
							var subarray = new stream.typeArrayType(stream.buffer.buffer, stream.elementByteSize * stream.count);
							var totalComponents = mesh.getVertexStream(semantic, subarray) * stream.numComponents;
							stream.count += totalComponents;
							if (!dynamic && stream.numComponents >= 3) {
								if (semantic === SEMANTIC_POSITION) {
									for (var j = 0; j < totalComponents; j += stream.numComponents) {
										vec.set(subarray[j], subarray[j + 1], subarray[j + 2]);
										transform.transformPoint(vec, vec);
										subarray[j] = vec.x;
										subarray[j + 1] = vec.y;
										subarray[j + 2] = vec.z;
									}
								} else if (semantic === SEMANTIC_NORMAL || semantic === SEMANTIC_TANGENT) {
									transform.invertTo3x3(mat3);
									mat3.transpose();
									for (var _j = 0; _j < totalComponents; _j += stream.numComponents) {
										vec.set(subarray[_j], subarray[_j + 1], subarray[_j + 2]);
										mat3.transformVector(vec, vec);
										subarray[_j] = vec.x;
										subarray[_j + 1] = vec.y;
										subarray[_j + 2] = vec.z;
									}
								}
							}
						}
					}
					if (dynamic) {
						stream = streams[SEMANTIC_BLENDINDICES];
						for (var _j2 = 0; _j2 < numVerts; _j2++) stream.buffer[stream.count++] = i;
					}
					if (mesh.primitive[0].indexed) {
						indexBase = mesh.primitive[0].base;
						numIndices = mesh.primitive[0].count;
						var srcFormat = mesh.indexBuffer[0].getFormat();
						indexData = new typedArrayIndexFormats[srcFormat](mesh.indexBuffer[0].storage);
					} else {
						var primitiveType = mesh.primitive[0].type;
						if (primitiveType === PRIMITIVE_TRIFAN || primitiveType === PRIMITIVE_TRISTRIP) {
							if (mesh.primitive[0].count === 4) {
								indexBase = 0;
								numIndices = 6;
								indexData = primitiveType === PRIMITIVE_TRIFAN ? _triFanIndices : _triStripIndices;
							} else {
								numIndices = 0;
								continue;
							}
						}
					}
					for (var _j3 = 0; _j3 < numIndices; _j3++) {
						indices[_j3 + indexOffset] = indexData[indexBase + _j3] + verticesOffset;
					}
					indexOffset += numIndices;
					verticesOffset += numVerts;
				}
				mesh = new Mesh(this.device);
				for (semantic in streams) {
					stream = streams[semantic];
					mesh.setVertexStream(semantic, stream.buffer, stream.numComponents, undefined, stream.dataType, stream.normalize);
				}
				if (indices.length > 0) mesh.setIndices(indices);
				mesh.update(PRIMITIVE_TRIANGLES, false);
				if (dynamic) {
					material = material.clone();
					material.chunks.transformVS = this.transformVS;
					material.chunks.skinTexVS = this.skinTexVS;
					material.chunks.skinConstVS = this.skinConstVS;
					material.update();
				}
				var meshInstance = new MeshInstance(mesh, material, this.rootNode);
				meshInstance.castShadow = batch.origMeshInstances[0].castShadow;
				meshInstance.parameters = batch.origMeshInstances[0].parameters;
				meshInstance.layer = batch.origMeshInstances[0].layer;
				meshInstance._shaderDefs = batch.origMeshInstances[0]._shaderDefs;
				meshInstance.cull = batch.origMeshInstances[0].cull;
				var batchGroup = this._batchGroups[batchGroupId];
				if (batchGroup && batchGroup._ui) meshInstance.cull = false;
				if (dynamic) {
					var nodes = [];
					for (var _i3 = 0; _i3 < batch.origMeshInstances.length; _i3++) {
						nodes.push(batch.origMeshInstances[_i3].node);
					}
					meshInstance.skinInstance = new SkinBatchInstance(this.device, nodes, this.rootNode);
				}
				meshInstance._updateAabb = false;
				meshInstance.drawOrder = batch.origMeshInstances[0].drawOrder;
				meshInstance.stencilFront = batch.origMeshInstances[0].stencilFront;
				meshInstance.stencilBack = batch.origMeshInstances[0].stencilBack;
				meshInstance.flipFacesFactor = getScaleSign(batch.origMeshInstances[0]);
				meshInstance.castShadow = batch.origMeshInstances[0].castShadow;
				batch.meshInstance = meshInstance;
				batch.updateBoundingBox();
			}
			return batch;
		};
		_proto.updateAll = function updateAll() {
			if (this._dirtyGroups.length > 0) {
				this.generate(this._dirtyGroups);
			}
			for (var i = 0; i < this._batchList.length; i++) {
				if (!this._batchList[i].dynamic) continue;
				this._batchList[i].updateBoundingBox();
			}
		};
		_proto.clone = function clone(batch, clonedMeshInstances) {
			var batch2 = new Batch(clonedMeshInstances, batch.dynamic, batch.batchGroupId);
			this._batchList.push(batch2);
			var nodes = [];
			for (var i = 0; i < clonedMeshInstances.length; i++) {
				nodes.push(clonedMeshInstances[i].node);
			}
			batch2.meshInstance = new MeshInstance(batch.meshInstance.mesh, batch.meshInstance.material, batch.meshInstance.node);
			batch2.meshInstance._updateAabb = false;
			batch2.meshInstance.parameters = clonedMeshInstances[0].parameters;
			batch2.meshInstance.cull = clonedMeshInstances[0].cull;
			batch2.meshInstance.layer = clonedMeshInstances[0].layer;
			if (batch.dynamic) {
				batch2.meshInstance.skinInstance = new SkinBatchInstance(this.device, nodes, this.rootNode);
			}
			batch2.meshInstance.castShadow = batch.meshInstance.castShadow;
			batch2.meshInstance._shader = batch.meshInstance._shader.slice();
			batch2.meshInstance.castShadow = batch.meshInstance.castShadow;
			return batch2;
		};
		_proto.destroyBatch = function destroyBatch(batch) {
			batch.destroy(this.scene, this._batchGroups[batch.batchGroupId].layers);
		};
		return BatchManager;
	}();

	var _deviceCoord = new Vec3();
	var _halfSize = new Vec3();
	var _point$1 = new Vec3();
	var _invViewProjMat = new Mat4();
	var _frustumPoints = [new Vec3(), new Vec3(), new Vec3(), new Vec3(), new Vec3(), new Vec3(), new Vec3(), new Vec3()];
	var Camera = function () {
		function Camera() {
			this.shaderPassInfo = void 0;
			this._aspectRatio = 16 / 9;
			this._aspectRatioMode = ASPECT_AUTO;
			this._calculateProjection = null;
			this._calculateTransform = null;
			this._clearColor = new Color(0.75, 0.75, 0.75, 1);
			this._clearColorBuffer = true;
			this._clearDepth = 1;
			this._clearDepthBuffer = true;
			this._clearStencil = 0;
			this._clearStencilBuffer = true;
			this._cullFaces = true;
			this._farClip = 1000;
			this._flipFaces = false;
			this._fov = 45;
			this._frustumCulling = true;
			this._horizontalFov = false;
			this._layers = [LAYERID_WORLD, LAYERID_DEPTH, LAYERID_SKYBOX, LAYERID_UI, LAYERID_IMMEDIATE];
			this._layersSet = new Set(this._layers);
			this._nearClip = 0.1;
			this._node = null;
			this._orthoHeight = 10;
			this._projection = PROJECTION_PERSPECTIVE;
			this._rect = new Vec4(0, 0, 1, 1);
			this._renderTarget = null;
			this._scissorRect = new Vec4(0, 0, 1, 1);
			this._scissorRectClear = false;
			this._aperture = 16.0;
			this._shutter = 1.0 / 1000.0;
			this._sensitivity = 1000;
			this._projMat = new Mat4();
			this._projMatDirty = true;
			this._projMatSkybox = new Mat4();
			this._viewMat = new Mat4();
			this._viewMatDirty = true;
			this._viewProjMat = new Mat4();
			this._viewProjMatDirty = true;
			this.frustum = new Frustum();
			this._xr = null;
			this._xrProperties = {
				horizontalFov: this._horizontalFov,
				fov: this._fov,
				aspectRatio: this._aspectRatio,
				farClip: this._farClip,
				nearClip: this._nearClip
			};
		}
		var _proto = Camera.prototype;
		_proto.clone = function clone() {
			return new Camera().copy(this);
		};
		_proto.copy = function copy(other) {
			this._aspectRatio = other._aspectRatio;
			this._farClip = other._farClip;
			this._fov = other._fov;
			this._horizontalFov = other._horizontalFov;
			this._nearClip = other._nearClip;
			this._xrProperties.aspectRatio = other._xrProperties.aspectRatio;
			this._xrProperties.farClip = other._xrProperties.farClip;
			this._xrProperties.fov = other._xrProperties.fov;
			this._xrProperties.horizontalFov = other._xrProperties.horizontalFov;
			this._xrProperties.nearClip = other._xrProperties.nearClip;
			this.aspectRatioMode = other.aspectRatioMode;
			this.calculateProjection = other.calculateProjection;
			this.calculateTransform = other.calculateTransform;
			this.clearColor = other.clearColor;
			this.clearColorBuffer = other.clearColorBuffer;
			this.clearDepth = other.clearDepth;
			this.clearDepthBuffer = other.clearDepthBuffer;
			this.clearStencil = other.clearStencil;
			this.clearStencilBuffer = other.clearStencilBuffer;
			this.cullFaces = other.cullFaces;
			this.flipFaces = other.flipFaces;
			this.frustumCulling = other.frustumCulling;
			this.layers = other.layers;
			this.orthoHeight = other.orthoHeight;
			this.projection = other.projection;
			this.rect = other.rect;
			this.renderTarget = other.renderTarget;
			this.scissorRect = other.scissorRect;
			this.aperture = other.aperture;
			this.shutter = other.shutter;
			this.sensitivity = other.sensitivity;
			this.shaderPassInfo = other.shaderPassInfo;
			this._projMatDirty = true;
			return this;
		};
		_proto._updateViewProjMat = function _updateViewProjMat() {
			if (this._projMatDirty || this._viewMatDirty || this._viewProjMatDirty) {
				this._viewProjMat.mul2(this.projectionMatrix, this.viewMatrix);
				this._viewProjMatDirty = false;
			}
		};
		_proto.worldToScreen = function worldToScreen(worldCoord, cw, ch, screenCoord) {
			if (screenCoord === void 0) {
				screenCoord = new Vec3();
			}
			this._updateViewProjMat();
			this._viewProjMat.transformPoint(worldCoord, screenCoord);
			var vpm = this._viewProjMat.data;
			var w = worldCoord.x * vpm[3] + worldCoord.y * vpm[7] + worldCoord.z * vpm[11] + 1 * vpm[15];
			screenCoord.x = (screenCoord.x / w + 1) * 0.5 * cw;
			screenCoord.y = (1 - screenCoord.y / w) * 0.5 * ch;
			return screenCoord;
		};
		_proto.screenToWorld = function screenToWorld(x, y, z, cw, ch, worldCoord) {
			if (worldCoord === void 0) {
				worldCoord = new Vec3();
			}
			var range = this.farClip - this.nearClip;
			_deviceCoord.set(x / cw, (ch - y) / ch, z / range);
			_deviceCoord.mulScalar(2);
			_deviceCoord.sub(Vec3.ONE);
			if (this._projection === PROJECTION_PERSPECTIVE) {
				Mat4._getPerspectiveHalfSize(_halfSize, this.fov, this.aspectRatio, this.nearClip, this.horizontalFov);
				_halfSize.x *= _deviceCoord.x;
				_halfSize.y *= _deviceCoord.y;
				var invView = this._node.getWorldTransform();
				_halfSize.z = -this.nearClip;
				invView.transformPoint(_halfSize, _point$1);
				var cameraPos = this._node.getPosition();
				worldCoord.sub2(_point$1, cameraPos);
				worldCoord.normalize();
				worldCoord.mulScalar(z);
				worldCoord.add(cameraPos);
			} else {
				this._updateViewProjMat();
				_invViewProjMat.copy(this._viewProjMat).invert();
				_invViewProjMat.transformPoint(_deviceCoord, worldCoord);
			}
			return worldCoord;
		};
		_proto._evaluateProjectionMatrix = function _evaluateProjectionMatrix() {
			if (this._projMatDirty) {
				if (this._projection === PROJECTION_PERSPECTIVE) {
					this._projMat.setPerspective(this.fov, this.aspectRatio, this.nearClip, this.farClip, this.horizontalFov);
					this._projMatSkybox.copy(this._projMat);
				} else {
					var y = this._orthoHeight;
					var x = y * this.aspectRatio;
					this._projMat.setOrtho(-x, x, -y, y, this.nearClip, this.farClip);
					this._projMatSkybox.setPerspective(this.fov, this.aspectRatio, this.nearClip, this.farClip);
				}
				this._projMatDirty = false;
			}
		};
		_proto.getProjectionMatrixSkybox = function getProjectionMatrixSkybox() {
			this._evaluateProjectionMatrix();
			return this._projMatSkybox;
		};
		_proto.getExposure = function getExposure() {
			var ev100 = Math.log2(this._aperture * this._aperture / this._shutter * 100.0 / this._sensitivity);
			return 1.0 / (Math.pow(2.0, ev100) * 1.2);
		};
		_proto.getScreenSize = function getScreenSize(sphere) {
			if (this._projection === PROJECTION_PERSPECTIVE) {
				var distance = this._node.getPosition().distance(sphere.center);
				if (distance < sphere.radius) {
					return 1;
				}
				var viewAngle = Math.asin(sphere.radius / distance);
				var sphereViewHeight = Math.tan(viewAngle);
				var screenViewHeight = Math.tan(this.fov / 2 * math.DEG_TO_RAD);
				return Math.min(sphereViewHeight / screenViewHeight, 1);
			}
			return math.clamp(sphere.radius / this._orthoHeight, 0, 1);
		};
		_proto.getFrustumCorners = function getFrustumCorners(near, far) {
			if (near === void 0) {
				near = this.nearClip;
			}
			if (far === void 0) {
				far = this.farClip;
			}
			var fov = this.fov * Math.PI / 180.0;
			var y = this._projection === PROJECTION_PERSPECTIVE ? Math.tan(fov / 2.0) * near : this._orthoHeight;
			var x = y * this.aspectRatio;
			var points = _frustumPoints;
			points[0].x = x;
			points[0].y = -y;
			points[0].z = -near;
			points[1].x = x;
			points[1].y = y;
			points[1].z = -near;
			points[2].x = -x;
			points[2].y = y;
			points[2].z = -near;
			points[3].x = -x;
			points[3].y = -y;
			points[3].z = -near;
			if (this._projection === PROJECTION_PERSPECTIVE) {
				y = Math.tan(fov / 2.0) * far;
				x = y * this.aspectRatio;
			}
			points[4].x = x;
			points[4].y = -y;
			points[4].z = -far;
			points[5].x = x;
			points[5].y = y;
			points[5].z = -far;
			points[6].x = -x;
			points[6].y = y;
			points[6].z = -far;
			points[7].x = -x;
			points[7].y = -y;
			points[7].z = -far;
			return points;
		};
		_proto.setXrProperties = function setXrProperties(properties) {
			Object.assign(this._xrProperties, properties);
			this._projMatDirty = true;
		};
		_createClass(Camera, [{
			key: "fullSizeClearRect",
			get: function get() {
				var rect = this._scissorRectClear ? this.scissorRect : this._rect;
				return rect.x === 0 && rect.y === 0 && rect.z === 1 && rect.w === 1;
			}
		}, {
			key: "aspectRatio",
			get: function get() {
				var _this$xr;
				return (_this$xr = this.xr) != null && _this$xr.active ? this._xrProperties.aspectRatio : this._aspectRatio;
			},
			set: function set(newValue) {
				if (this._aspectRatio !== newValue) {
					this._aspectRatio = newValue;
					this._projMatDirty = true;
				}
			}
		}, {
			key: "aspectRatioMode",
			get: function get() {
				return this._aspectRatioMode;
			},
			set: function set(newValue) {
				if (this._aspectRatioMode !== newValue) {
					this._aspectRatioMode = newValue;
					this._projMatDirty = true;
				}
			}
		}, {
			key: "calculateProjection",
			get: function get() {
				return this._calculateProjection;
			},
			set: function set(newValue) {
				this._calculateProjection = newValue;
				this._projMatDirty = true;
			}
		}, {
			key: "calculateTransform",
			get: function get() {
				return this._calculateTransform;
			},
			set: function set(newValue) {
				this._calculateTransform = newValue;
			}
		}, {
			key: "clearColor",
			get: function get() {
				return this._clearColor;
			},
			set: function set(newValue) {
				this._clearColor.copy(newValue);
			}
		}, {
			key: "clearColorBuffer",
			get: function get() {
				return this._clearColorBuffer;
			},
			set: function set(newValue) {
				this._clearColorBuffer = newValue;
			}
		}, {
			key: "clearDepth",
			get: function get() {
				return this._clearDepth;
			},
			set: function set(newValue) {
				this._clearDepth = newValue;
			}
		}, {
			key: "clearDepthBuffer",
			get: function get() {
				return this._clearDepthBuffer;
			},
			set: function set(newValue) {
				this._clearDepthBuffer = newValue;
			}
		}, {
			key: "clearStencil",
			get: function get() {
				return this._clearStencil;
			},
			set: function set(newValue) {
				this._clearStencil = newValue;
			}
		}, {
			key: "clearStencilBuffer",
			get: function get() {
				return this._clearStencilBuffer;
			},
			set: function set(newValue) {
				this._clearStencilBuffer = newValue;
			}
		}, {
			key: "cullFaces",
			get: function get() {
				return this._cullFaces;
			},
			set: function set(newValue) {
				this._cullFaces = newValue;
			}
		}, {
			key: "farClip",
			get: function get() {
				var _this$xr2;
				return (_this$xr2 = this.xr) != null && _this$xr2.active ? this._xrProperties.farClip : this._farClip;
			},
			set: function set(newValue) {
				if (this._farClip !== newValue) {
					this._farClip = newValue;
					this._projMatDirty = true;
				}
			}
		}, {
			key: "flipFaces",
			get: function get() {
				return this._flipFaces;
			},
			set: function set(newValue) {
				this._flipFaces = newValue;
			}
		}, {
			key: "fov",
			get: function get() {
				var _this$xr3;
				return (_this$xr3 = this.xr) != null && _this$xr3.active ? this._xrProperties.fov : this._fov;
			},
			set: function set(newValue) {
				if (this._fov !== newValue) {
					this._fov = newValue;
					this._projMatDirty = true;
				}
			}
		}, {
			key: "frustumCulling",
			get: function get() {
				return this._frustumCulling;
			},
			set: function set(newValue) {
				this._frustumCulling = newValue;
			}
		}, {
			key: "horizontalFov",
			get: function get() {
				var _this$xr4;
				return (_this$xr4 = this.xr) != null && _this$xr4.active ? this._xrProperties.horizontalFov : this._horizontalFov;
			},
			set: function set(newValue) {
				if (this._horizontalFov !== newValue) {
					this._horizontalFov = newValue;
					this._projMatDirty = true;
				}
			}
		}, {
			key: "layers",
			get: function get() {
				return this._layers;
			},
			set: function set(newValue) {
				this._layers = newValue.slice(0);
				this._layersSet = new Set(this._layers);
			}
		}, {
			key: "layersSet",
			get: function get() {
				return this._layersSet;
			}
		}, {
			key: "nearClip",
			get: function get() {
				var _this$xr5;
				return (_this$xr5 = this.xr) != null && _this$xr5.active ? this._xrProperties.nearClip : this._nearClip;
			},
			set: function set(newValue) {
				if (this._nearClip !== newValue) {
					this._nearClip = newValue;
					this._projMatDirty = true;
				}
			}
		}, {
			key: "node",
			get: function get() {
				return this._node;
			},
			set: function set(newValue) {
				this._node = newValue;
			}
		}, {
			key: "orthoHeight",
			get: function get() {
				return this._orthoHeight;
			},
			set: function set(newValue) {
				if (this._orthoHeight !== newValue) {
					this._orthoHeight = newValue;
					this._projMatDirty = true;
				}
			}
		}, {
			key: "projection",
			get: function get() {
				return this._projection;
			},
			set: function set(newValue) {
				if (this._projection !== newValue) {
					this._projection = newValue;
					this._projMatDirty = true;
				}
			}
		}, {
			key: "projectionMatrix",
			get: function get() {
				this._evaluateProjectionMatrix();
				return this._projMat;
			}
		}, {
			key: "rect",
			get: function get() {
				return this._rect;
			},
			set: function set(newValue) {
				this._rect.copy(newValue);
			}
		}, {
			key: "renderTarget",
			get: function get() {
				return this._renderTarget;
			},
			set: function set(newValue) {
				this._renderTarget = newValue;
			}
		}, {
			key: "scissorRect",
			get: function get() {
				return this._scissorRect;
			},
			set: function set(newValue) {
				this._scissorRect.copy(newValue);
			}
		}, {
			key: "viewMatrix",
			get: function get() {
				if (this._viewMatDirty) {
					var wtm = this._node.getWorldTransform();
					this._viewMat.copy(wtm).invert();
					this._viewMatDirty = false;
				}
				return this._viewMat;
			}
		}, {
			key: "aperture",
			get: function get() {
				return this._aperture;
			},
			set: function set(newValue) {
				this._aperture = newValue;
			}
		}, {
			key: "sensitivity",
			get: function get() {
				return this._sensitivity;
			},
			set: function set(newValue) {
				this._sensitivity = newValue;
			}
		}, {
			key: "shutter",
			get: function get() {
				return this._shutter;
			},
			set: function set(newValue) {
				this._shutter = newValue;
			}
		}, {
			key: "xr",
			get: function get() {
				return this._xr;
			},
			set: function set(newValue) {
				if (this._xr !== newValue) {
					this._xr = newValue;
					this._projMatDirty = true;
				}
			}
		}]);
		return Camera;
	}();

	var LitShaderOptions = function LitShaderOptions() {
		this.hasTangents = false;
		this.chunks = {};
		this.pass = 0;
		this.alphaTest = false;
		this.blendType = BLEND_NONE;
		this.separateAmbient = false;
		this.screenSpace = false;
		this.skin = false;
		this.useInstancing = false;
		this.useMorphPosition = false;
		this.useMorphNormal = false;
		this.useMorphTextureBased = false;
		this.nineSlicedMode = 0;
		this.clusteredLightingEnabled = true;
		this.clusteredLightingCookiesEnabled = false;
		this.clusteredLightingShadowsEnabled = false;
		this.clusteredLightingShadowType = 0;
		this.clusteredLightingAreaLightsEnabled = false;
		this.vertexColors = false;
		this.lightMapEnabled = false;
		this.dirLightMapEnabled = false;
		this.useHeights = false;
		this.useNormals = false;
		this.useClearCoatNormals = false;
		this.useAo = false;
		this.diffuseMapEnabled = false;
		this.useAmbientTint = false;
		this.customFragmentShader = null;
		this.pixelSnap = false;
		this.shadingModel = 0;
		this.ambientSH = false;
		this.fastTbn = false;
		this.twoSidedLighting = false;
		this.occludeDirect = false;
		this.occludeSpecular = 0;
		this.occludeSpecularFloat = false;
		this.useMsdf = false;
		this.msdfTextAttribute = false;
		this.alphaToCoverage = false;
		this.opacityFadesSpecular = false;
		this.cubeMapProjection = 0;
		this.conserveEnergy = false;
		this.useSpecular = false;
		this.useSpecularityFactor = false;
		this.enableGGXSpecular = false;
		this.fresnelModel = 0;
		this.useRefraction = false;
		this.useClearCoat = false;
		this.useSheen = false;
		this.useIridescence = false;
		this.useMetalness = false;
		this.useDynamicRefraction = false;
		this.fog = FOG_NONE;
		this.gamma = GAMMA_NONE;
		this.toneMap = -1;
		this.fixSeams = false;
		this.reflectionSource = null;
		this.reflectionEncoding = null;
		this.reflectionCubemapEncoding = null;
		this.ambientSource = 'constant';
		this.ambientEncoding = null;
		this.skyboxIntensity = 1.0;
		this.useCubeMapRotation = false;
		this.lightMapWithoutAmbient = false;
		this.lights = [];
		this.noShadow = false;
		this.lightMaskDynamic = 0x0;
	};

	var LitMaterialOptions = function LitMaterialOptions() {
		this.usedUvs = void 0;
		this.shaderChunk = void 0;
		this.litOptions = new LitShaderOptions();
	};

	var LitMaterialOptionsBuilder = function () {
		function LitMaterialOptionsBuilder() {}
		LitMaterialOptionsBuilder.update = function update(litOptions, material, scene, objDefs, pass, sortedLights) {
			LitMaterialOptionsBuilder.updateSharedOptions(litOptions, material, scene, objDefs, pass);
			LitMaterialOptionsBuilder.updateMaterialOptions(litOptions, material);
			LitMaterialOptionsBuilder.updateEnvOptions(litOptions, material, scene);
			LitMaterialOptionsBuilder.updateLightingOptions(litOptions, material, objDefs, sortedLights);
			if (pass === SHADER_FORWARDHDR) {
				litOptions.gamma = GAMMA_SRGBHDR;
				litOptions.toneMap = TONEMAP_LINEAR;
			}
		};
		LitMaterialOptionsBuilder.updateSharedOptions = function updateSharedOptions(litOptions, material, scene, objDefs, pass) {
			litOptions.chunks = material.chunks;
			litOptions.pass = pass;
			litOptions.alphaTest = material.alphaTest > 0;
			litOptions.blendType = material.blendType;
			litOptions.screenSpace = objDefs && (objDefs & SHADERDEF_SCREENSPACE) !== 0;
			litOptions.skin = objDefs && (objDefs & SHADERDEF_SKIN) !== 0;
			litOptions.useInstancing = objDefs && (objDefs & SHADERDEF_INSTANCING) !== 0;
			litOptions.useMorphPosition = objDefs && (objDefs & SHADERDEF_MORPH_POSITION) !== 0;
			litOptions.useMorphNormal = objDefs && (objDefs & SHADERDEF_MORPH_NORMAL) !== 0;
			litOptions.useMorphTextureBased = objDefs && (objDefs & SHADERDEF_MORPH_TEXTURE_BASED) !== 0;
			litOptions.hasTangents = objDefs && (objDefs & SHADERDEF_TANGENTS) !== 0;
			litOptions.nineSlicedMode = material.nineSlicedMode || SPRITE_RENDERMODE_SIMPLE;
			if (material.useLighting && scene.clusteredLightingEnabled) {
				litOptions.clusteredLightingEnabled = true;
				litOptions.clusteredLightingCookiesEnabled = scene.lighting.cookiesEnabled;
				litOptions.clusteredLightingShadowsEnabled = scene.lighting.shadowsEnabled;
				litOptions.clusteredLightingShadowType = scene.lighting.shadowType;
				litOptions.clusteredLightingAreaLightsEnabled = scene.lighting.areaLightsEnabled;
			} else {
				litOptions.clusteredLightingEnabled = false;
				litOptions.clusteredLightingCookiesEnabled = false;
				litOptions.clusteredLightingShadowsEnabled = false;
				litOptions.clusteredLightingAreaLightsEnabled = false;
			}
		};
		LitMaterialOptionsBuilder.updateMaterialOptions = function updateMaterialOptions(litOptions, material) {
			litOptions.useAmbientTint = false;
			litOptions.separateAmbient = false;
			litOptions.customFragmentShader = null;
			litOptions.pixelSnap = material.pixelSnap;
			litOptions.shadingModel = material.shadingModel;
			litOptions.ambientSH = material.ambientSH;
			litOptions.fastTbn = material.fastTbn;
			litOptions.twoSidedLighting = material.twoSidedLighting;
			litOptions.occludeDirect = material.occludeDirect;
			litOptions.occludeSpecular = material.occludeSpecular;
			litOptions.occludeSpecularFloat = material.occludeSpecularIntensity !== 1.0;
			litOptions.useMsdf = false;
			litOptions.msdfTextAttribute = false;
			litOptions.alphaToCoverage = material.alphaToCoverage;
			litOptions.opacityFadesSpecular = material.opacityFadesSpecular;
			litOptions.cubeMapProjection = CUBEPROJ_NONE;
			litOptions.conserveEnergy = material.conserveEnergy && material.shadingModel === SPECULAR_BLINN;
			litOptions.useSpecular = material.hasSpecular;
			litOptions.useSpecularityFactor = material.hasSpecularityFactor;
			litOptions.enableGGXSpecular = material.ggxSpecular;
			litOptions.fresnelModel = material.fresnelModel;
			litOptions.useRefraction = material.hasRefraction;
			litOptions.useClearCoat = material.hasClearCoat;
			litOptions.useSheen = material.hasSheen;
			litOptions.useIridescence = material.hasIrridescence;
			litOptions.useMetalness = material.hasMetalness;
			litOptions.useDynamicRefraction = material.dynamicRefraction;
			litOptions.vertexColors = false;
			litOptions.lightMapEnabled = material.hasLighting;
			litOptions.dirLightMapEnabled = material.dirLightMap;
			litOptions.useHeights = material.hasHeights;
			litOptions.useNormals = material.hasNormals;
			litOptions.useClearCoatNormals = material.hasClearCoatNormals;
			litOptions.useAo = material.hasAo;
			litOptions.diffuseMapEnabled = material.hasDiffuseMap;
		};
		LitMaterialOptionsBuilder.updateEnvOptions = function updateEnvOptions(litOptions, material, scene) {
			litOptions.fog = material.useFog ? scene.fog : 'none';
			litOptions.gamma = material.useGammaTonemap ? scene.gammaCorrection : GAMMA_NONE;
			litOptions.toneMap = material.useGammaTonemap ? scene.toneMapping : -1;
			litOptions.fixSeams = false;
			if (material.useSkybox && scene.envAtlas && scene.skybox) {
				litOptions.reflectionSource = 'envAtlasHQ';
				litOptions.reflectionEncoding = scene.envAtlas.encoding;
				litOptions.reflectionCubemapEncoding = scene.skybox.encoding;
			} else if (material.useSkybox && scene.envAtlas) {
				litOptions.reflectionSource = 'envAtlas';
				litOptions.reflectionEncoding = scene.envAtlas.encoding;
			} else if (material.useSkybox && scene.skybox) {
				litOptions.reflectionSource = 'cubeMap';
				litOptions.reflectionEncoding = scene.skybox.encoding;
			} else {
				litOptions.reflectionSource = null;
				litOptions.reflectionEncoding = null;
			}
			if (material.ambientSH) {
				litOptions.ambientSource = 'ambientSH';
				litOptions.ambientEncoding = null;
			} else if (litOptions.reflectionSource && scene.envAtlas) {
				litOptions.ambientSource = 'envAtlas';
				litOptions.ambientEncoding = scene.envAtlas.encoding;
			} else {
				litOptions.ambientSource = 'constant';
				litOptions.ambientEncoding = null;
			}
			var hasSkybox = !!litOptions.reflectionSource;
			litOptions.skyboxIntensity = hasSkybox && (scene.skyboxIntensity !== 1 || scene.physicalUnits);
			litOptions.useCubeMapRotation = hasSkybox && scene._skyboxRotationShaderInclude;
		};
		LitMaterialOptionsBuilder.updateLightingOptions = function updateLightingOptions(litOptions, material, objDefs, sortedLights) {
			litOptions.lightMapWithoutAmbient = false;
			if (material.useLighting) {
				var lightsFiltered = [];
				var mask = objDefs ? objDefs >> 16 : MASK_AFFECT_DYNAMIC;
				litOptions.lightMaskDynamic = !!(mask & MASK_AFFECT_DYNAMIC);
				litOptions.lightMapWithoutAmbient = false;
				if (sortedLights) {
					LitMaterialOptionsBuilder.collectLights(LIGHTTYPE_DIRECTIONAL, sortedLights[LIGHTTYPE_DIRECTIONAL], lightsFiltered, mask);
					LitMaterialOptionsBuilder.collectLights(LIGHTTYPE_OMNI, sortedLights[LIGHTTYPE_OMNI], lightsFiltered, mask);
					LitMaterialOptionsBuilder.collectLights(LIGHTTYPE_SPOT, sortedLights[LIGHTTYPE_SPOT], lightsFiltered, mask);
				}
				litOptions.lights = lightsFiltered;
			} else {
				litOptions.lights = [];
			}
			if (litOptions.lights.length === 0 || (objDefs & SHADERDEF_NOSHADOW) !== 0) {
				litOptions.noShadow = true;
			}
		};
		LitMaterialOptionsBuilder.collectLights = function collectLights(lType, lights, lightsFiltered, mask) {
			for (var i = 0; i < lights.length; i++) {
				var light = lights[i];
				if (light.enabled) {
					if (light.mask & mask) {
						if (lType !== LIGHTTYPE_DIRECTIONAL) {
							if (light.isStatic) {
								continue;
							}
						}
						lightsFiltered.push(light);
					}
				}
			}
		};
		return LitMaterialOptionsBuilder;
	}();

	var ChunkBuilder = function () {
		function ChunkBuilder() {
			this.code = '';
		}
		var _proto = ChunkBuilder.prototype;
		_proto.append = function append() {
			var _this = this;
			for (var _len = arguments.length, chunks = new Array(_len), _key = 0; _key < _len; _key++) {
				chunks[_key] = arguments[_key];
			}
			chunks.forEach(function (chunk) {
				if (chunk.endsWith('\n')) {
					_this.code += chunk;
				} else {
					_this.code += chunk + '\n';
				}
			});
		};
		_proto.prepend = function prepend() {
			var _this2 = this;
			for (var _len2 = arguments.length, chunks = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
				chunks[_key2] = arguments[_key2];
			}
			chunks.forEach(function (chunk) {
				if (chunk.endsWith('\n')) {
					_this2.code = chunk + _this2.code;
				} else {
					_this2.code = chunk + '\n' + _this2.code;
				}
			});
		};
		return ChunkBuilder;
	}();

	var decodeTable = {
		'linear': 'decodeLinear',
		'srgb': 'decodeGamma',
		'rgbm': 'decodeRGBM',
		'rgbe': 'decodeRGBE',
		'rgbp': 'decodeRGBP'
	};
	var encodeTable = {
		'linear': 'encodeLinear',
		'srgb': 'encodeGamma',
		'rgbm': 'encodeRGBM',
		'rgbe': 'encodeRGBE',
		'rgbp': 'encodeRGBP'
	};
	var ChunkUtils = function () {
		function ChunkUtils() {}
		ChunkUtils.decodeFunc = function decodeFunc(encoding) {
			return decodeTable[encoding] || 'decodeGamma';
		};
		ChunkUtils.encodeFunc = function encodeFunc(encoding) {
			return encodeTable[encoding] || 'encodeGamma';
		};
		return ChunkUtils;
	}();

	var oneDiv255 = 1 / 255;
	var floatView = new Float32Array(1);
	var int32View = new Int32Array(floatView.buffer);
	var FloatPacking = function () {
		function FloatPacking() {}
		FloatPacking.float2Half = function float2Half(value) {
			floatView[0] = value;
			var x = int32View[0];
			var bits = x >> 16 & 0x8000;
			var m = x >> 12 & 0x07ff;
			var e = x >> 23 & 0xff;
			if (e < 103) {
				return bits;
			}
			if (e > 142) {
				bits |= 0x7c00;
				bits |= (e === 255 ? 0 : 1) && x & 0x007fffff;
				return bits;
			}
			if (e < 113) {
				m |= 0x0800;
				bits |= (m >> 114 - e) + (m >> 113 - e & 1);
				return bits;
			}
			bits |= e - 112 << 10 | m >> 1;
			bits += m & 1;
			return bits;
		};
		FloatPacking.float2Bytes = function float2Bytes(value, array, offset, numBytes) {
			var enc1 = 255.0 * value % 1;
			array[offset + 0] = Math.round((value % 1 - oneDiv255 * enc1) * 255);
			if (numBytes > 1) {
				var enc2 = 65025.0 * value % 1;
				array[offset + 1] = Math.round((enc1 - oneDiv255 * enc2) * 255);
				if (numBytes > 2) {
					var enc3 = 16581375.0 * value % 1;
					array[offset + 2] = Math.round((enc2 - oneDiv255 * enc3) * 255);
					if (numBytes > 3) {
						array[offset + 3] = Math.round(enc3 * 255);
					}
				}
			}
		};
		FloatPacking.float2BytesRange = function float2BytesRange(value, array, offset, min, max, numBytes) {
			value = math.clamp((value - min) / (max - min), 0, 1);
			FloatPacking.float2Bytes(value, array, offset, numBytes);
		};
		FloatPacking.float2MantissaExponent = function float2MantissaExponent(value, array, offset, numBytes) {
			var exponent = Math.floor(Math.log2(Math.abs(value))) + 1;
			value /= Math.pow(2, exponent);
			FloatPacking.float2BytesRange(value, array, offset, -1, 1, numBytes - 1);
			array[offset + numBytes - 1] = Math.round(exponent + 127);
		};
		return FloatPacking;
	}();

	var _viewMat = new Mat4();
	var _viewProjMat = new Mat4();
	var _viewportMatrix = new Mat4();
	var LightCamera = function () {
		function LightCamera() {}
		LightCamera.create = function create(name, lightType, face) {
			var camera = new Camera();
			camera.node = new GraphNode(name);
			camera.aspectRatio = 1;
			camera.aspectRatioMode = ASPECT_MANUAL;
			camera._scissorRectClear = true;
			switch (lightType) {
				case LIGHTTYPE_OMNI:
					camera.node.setRotation(LightCamera.pointLightRotations[face]);
					camera.fov = 90;
					camera.projection = PROJECTION_PERSPECTIVE;
					break;
				case LIGHTTYPE_SPOT:
					camera.projection = PROJECTION_PERSPECTIVE;
					break;
				case LIGHTTYPE_DIRECTIONAL:
					camera.projection = PROJECTION_ORTHOGRAPHIC;
					break;
			}
			return camera;
		};
		LightCamera.evalSpotCookieMatrix = function evalSpotCookieMatrix(light) {
			var cookieCamera = LightCamera._spotCookieCamera;
			if (!cookieCamera) {
				cookieCamera = LightCamera.create('SpotCookieCamera', LIGHTTYPE_SPOT);
				LightCamera._spotCookieCamera = cookieCamera;
			}
			cookieCamera.fov = light._outerConeAngle * 2;
			var cookieNode = cookieCamera._node;
			cookieNode.setPosition(light._node.getPosition());
			cookieNode.setRotation(light._node.getRotation());
			cookieNode.rotateLocal(-90, 0, 0);
			_viewMat.setTRS(cookieNode.getPosition(), cookieNode.getRotation(), Vec3.ONE).invert();
			_viewProjMat.mul2(cookieCamera.projectionMatrix, _viewMat);
			var cookieMatrix = light.cookieMatrix;
			var rectViewport = light.atlasViewport;
			_viewportMatrix.setViewport(rectViewport.x, rectViewport.y, rectViewport.z, rectViewport.w);
			cookieMatrix.mul2(_viewportMatrix, _viewProjMat);
			return cookieMatrix;
		};
		return LightCamera;
	}();
	LightCamera.pointLightRotations = [new Quat().setFromEulerAngles(0, 90, 180), new Quat().setFromEulerAngles(0, -90, 180), new Quat().setFromEulerAngles(90, 0, 0), new Quat().setFromEulerAngles(-90, 0, 0), new Quat().setFromEulerAngles(0, 180, 180), new Quat().setFromEulerAngles(0, 0, 180)];
	LightCamera._spotCookieCamera = null;

	var epsilon$1 = 0.000001;
	var tempVec3$1 = new Vec3();
	var tempAreaLightSizes = new Float32Array(6);
	var areaHalfAxisWidth = new Vec3(-0.5, 0, 0);
	var areaHalfAxisHeight = new Vec3(0, 0, 0.5);
	var TextureIndex8 = {
		FLAGS: 0,
		COLOR_A: 1,
		COLOR_B: 2,
		SPOT_ANGLES: 3,
		SHADOW_BIAS: 4,
		COOKIE_A: 5,
		COOKIE_B: 6,
		COUNT_ALWAYS: 7,
		POSITION_X: 7,
		POSITION_Y: 8,
		POSITION_Z: 9,
		RANGE: 10,
		SPOT_DIRECTION_X: 11,
		SPOT_DIRECTION_Y: 12,
		SPOT_DIRECTION_Z: 13,
		PROJ_MAT_00: 14,
		ATLAS_VIEWPORT_A: 14,
		PROJ_MAT_01: 15,
		ATLAS_VIEWPORT_B: 15,
		PROJ_MAT_02: 16,
		PROJ_MAT_03: 17,
		PROJ_MAT_10: 18,
		PROJ_MAT_11: 19,
		PROJ_MAT_12: 20,
		PROJ_MAT_13: 21,
		PROJ_MAT_20: 22,
		PROJ_MAT_21: 23,
		PROJ_MAT_22: 24,
		PROJ_MAT_23: 25,
		PROJ_MAT_30: 26,
		PROJ_MAT_31: 27,
		PROJ_MAT_32: 28,
		PROJ_MAT_33: 29,
		AREA_DATA_WIDTH_X: 30,
		AREA_DATA_WIDTH_Y: 31,
		AREA_DATA_WIDTH_Z: 32,
		AREA_DATA_HEIGHT_X: 33,
		AREA_DATA_HEIGHT_Y: 34,
		AREA_DATA_HEIGHT_Z: 35,
		COUNT: 36
	};
	var TextureIndexFloat = {
		POSITION_RANGE: 0,
		SPOT_DIRECTION: 1,
		PROJ_MAT_0: 2,
		ATLAS_VIEWPORT: 2,
		PROJ_MAT_1: 3,
		PROJ_MAT_2: 4,
		PROJ_MAT_3: 5,
		AREA_DATA_WIDTH: 6,
		AREA_DATA_HEIGHT: 7,
		COUNT: 8
	};
	var LightsBuffer = function () {
		LightsBuffer.initShaderDefines = function initShaderDefines() {
			var clusterTextureFormat = LightsBuffer.lightTextureFormat === LightsBuffer.FORMAT_FLOAT ? 'FLOAT' : '8BIT';
			LightsBuffer.shaderDefines = "\n            \n#define CLUSTER_TEXTURE_" + clusterTextureFormat + "\n            " + LightsBuffer.buildShaderDefines(TextureIndex8, 'CLUSTER_TEXTURE_8_') + "\n            " + LightsBuffer.buildShaderDefines(TextureIndexFloat, 'CLUSTER_TEXTURE_F_') + "\n        ";
		};
		LightsBuffer.buildShaderDefines = function buildShaderDefines(object, prefix) {
			var str = '';
			var floatOffset = LightsBuffer.useTexelFetch ? '' : '.5';
			Object.keys(object).forEach(function (key) {
				str += "\n#define " + prefix + key + " " + object[key] + floatOffset;
			});
			return str;
		};
		LightsBuffer.init = function init(device) {
			LightsBuffer.lightTextureFormat = device.extTextureFloat && device.maxTextures > 8 ? LightsBuffer.FORMAT_FLOAT : LightsBuffer.FORMAT_8BIT;
			LightsBuffer.useTexelFetch = device.supportsTextureFetch;
			LightsBuffer.initShaderDefines();
		};
		LightsBuffer.createTexture = function createTexture(device, width, height, format, name) {
			var tex = new Texture(device, {
				name: name,
				width: width,
				height: height,
				mipmaps: false,
				format: format,
				addressU: ADDRESS_CLAMP_TO_EDGE,
				addressV: ADDRESS_CLAMP_TO_EDGE,
				type: TEXTURETYPE_DEFAULT,
				magFilter: FILTER_NEAREST,
				minFilter: FILTER_NEAREST,
				anisotropy: 1
			});
			return tex;
		};
		function LightsBuffer(device) {
			this.device = device;
			this.cookiesEnabled = false;
			this.shadowsEnabled = false;
			this.areaLightsEnabled = false;
			this.maxLights = 255;
			var pixelsPerLight8 = TextureIndex8.COUNT_ALWAYS;
			var pixelsPerLightFloat = 0;
			if (LightsBuffer.lightTextureFormat === LightsBuffer.FORMAT_FLOAT) {
				pixelsPerLightFloat = TextureIndexFloat.COUNT;
			} else {
				pixelsPerLight8 = TextureIndex8.COUNT;
			}
			this.lights8 = new Uint8ClampedArray(4 * pixelsPerLight8 * this.maxLights);
			this.lightsTexture8 = LightsBuffer.createTexture(this.device, pixelsPerLight8, this.maxLights, PIXELFORMAT_RGBA8, 'LightsTexture8');
			this._lightsTexture8Id = this.device.scope.resolve('lightsTexture8');
			if (pixelsPerLightFloat) {
				this.lightsFloat = new Float32Array(4 * pixelsPerLightFloat * this.maxLights);
				this.lightsTextureFloat = LightsBuffer.createTexture(this.device, pixelsPerLightFloat, this.maxLights, PIXELFORMAT_RGBA32F, 'LightsTextureFloat');
				this._lightsTextureFloatId = this.device.scope.resolve('lightsTextureFloat');
			} else {
				this.lightsFloat = null;
				this.lightsTextureFloat = null;
				this._lightsTextureFloatId = undefined;
			}
			this._lightsTextureInvSizeId = this.device.scope.resolve('lightsTextureInvSize');
			this._lightsTextureInvSizeData = new Float32Array(4);
			this._lightsTextureInvSizeData[0] = pixelsPerLightFloat ? 1.0 / this.lightsTextureFloat.width : 0;
			this._lightsTextureInvSizeData[1] = pixelsPerLightFloat ? 1.0 / this.lightsTextureFloat.height : 0;
			this._lightsTextureInvSizeData[2] = 1.0 / this.lightsTexture8.width;
			this._lightsTextureInvSizeData[3] = 1.0 / this.lightsTexture8.height;
			this.invMaxColorValue = 0;
			this.invMaxAttenuation = 0;
			this.boundsMin = new Vec3();
			this.boundsDelta = new Vec3();
		}
		var _proto = LightsBuffer.prototype;
		_proto.destroy = function destroy() {
			if (this.lightsTexture8) {
				this.lightsTexture8.destroy();
				this.lightsTexture8 = null;
			}
			if (this.lightsTextureFloat) {
				this.lightsTextureFloat.destroy();
				this.lightsTextureFloat = null;
			}
		};
		_proto.setCompressionRanges = function setCompressionRanges(maxAttenuation, maxColorValue) {
			this.invMaxColorValue = 1 / maxColorValue;
			this.invMaxAttenuation = 1 / maxAttenuation;
		};
		_proto.setBounds = function setBounds(min, delta) {
			this.boundsMin.copy(min);
			this.boundsDelta.copy(delta);
		};
		_proto.uploadTextures = function uploadTextures() {
			if (this.lightsTextureFloat) {
				this.lightsTextureFloat.lock().set(this.lightsFloat);
				this.lightsTextureFloat.unlock();
			}
			this.lightsTexture8.lock().set(this.lights8);
			this.lightsTexture8.unlock();
		};
		_proto.updateUniforms = function updateUniforms() {
			this._lightsTexture8Id.setValue(this.lightsTexture8);
			if (LightsBuffer.lightTextureFormat === LightsBuffer.FORMAT_FLOAT) {
				this._lightsTextureFloatId.setValue(this.lightsTextureFloat);
			}
			this._lightsTextureInvSizeId.setValue(this._lightsTextureInvSizeData);
		};
		_proto.getSpotDirection = function getSpotDirection(direction, spot) {
			var mat = spot._node.getWorldTransform();
			mat.getY(direction).mulScalar(-1);
			direction.normalize();
		};
		_proto.getLightAreaSizes = function getLightAreaSizes(light) {
			var mat = light._node.getWorldTransform();
			mat.transformVector(areaHalfAxisWidth, tempVec3$1);
			tempAreaLightSizes[0] = tempVec3$1.x;
			tempAreaLightSizes[1] = tempVec3$1.y;
			tempAreaLightSizes[2] = tempVec3$1.z;
			mat.transformVector(areaHalfAxisHeight, tempVec3$1);
			tempAreaLightSizes[3] = tempVec3$1.x;
			tempAreaLightSizes[4] = tempVec3$1.y;
			tempAreaLightSizes[5] = tempVec3$1.z;
			return tempAreaLightSizes;
		};
		_proto.addLightDataFlags = function addLightDataFlags(data8, index, light, isSpot, castShadows, shadowIntensity) {
			data8[index + 0] = isSpot ? 255 : 0;
			data8[index + 1] = light._shape * 64;
			data8[index + 2] = light._falloffMode * 255;
			data8[index + 3] = castShadows ? shadowIntensity * 255 : 0;
		};
		_proto.addLightDataColor = function addLightDataColor(data8, index, light, gammaCorrection, isCookie) {
			var invMaxColorValue = this.invMaxColorValue;
			var color = gammaCorrection ? light._linearFinalColor : light._finalColor;
			FloatPacking.float2Bytes(color[0] * invMaxColorValue, data8, index + 0, 2);
			FloatPacking.float2Bytes(color[1] * invMaxColorValue, data8, index + 2, 2);
			FloatPacking.float2Bytes(color[2] * invMaxColorValue, data8, index + 4, 2);
			data8[index + 6] = isCookie ? 255 : 0;
			var isDynamic = !!(light.mask & MASK_AFFECT_DYNAMIC);
			var isLightmapped = !!(light.mask & MASK_AFFECT_LIGHTMAPPED);
			data8[index + 7] = isDynamic && isLightmapped ? 127 : isLightmapped ? 255 : 0;
		};
		_proto.addLightDataSpotAngles = function addLightDataSpotAngles(data8, index, light) {
			FloatPacking.float2Bytes(light._innerConeAngleCos * (0.5 - epsilon$1) + 0.5, data8, index + 0, 2);
			FloatPacking.float2Bytes(light._outerConeAngleCos * (0.5 - epsilon$1) + 0.5, data8, index + 2, 2);
		};
		_proto.addLightDataShadowBias = function addLightDataShadowBias(data8, index, light) {
			var lightRenderData = light.getRenderData(null, 0);
			var biases = light._getUniformBiasValues(lightRenderData);
			FloatPacking.float2BytesRange(biases.bias, data8, index, -1, 20, 2);
			FloatPacking.float2Bytes(biases.normalBias, data8, index + 2, 2);
		};
		_proto.addLightDataPositionRange = function addLightDataPositionRange(data8, index, light, pos) {
			var normPos = tempVec3$1.sub2(pos, this.boundsMin).div(this.boundsDelta);
			FloatPacking.float2Bytes(normPos.x, data8, index + 0, 4);
			FloatPacking.float2Bytes(normPos.y, data8, index + 4, 4);
			FloatPacking.float2Bytes(normPos.z, data8, index + 8, 4);
			FloatPacking.float2Bytes(light.attenuationEnd * this.invMaxAttenuation, data8, index + 12, 4);
		};
		_proto.addLightDataSpotDirection = function addLightDataSpotDirection(data8, index, light) {
			this.getSpotDirection(tempVec3$1, light);
			FloatPacking.float2Bytes(tempVec3$1.x * (0.5 - epsilon$1) + 0.5, data8, index + 0, 4);
			FloatPacking.float2Bytes(tempVec3$1.y * (0.5 - epsilon$1) + 0.5, data8, index + 4, 4);
			FloatPacking.float2Bytes(tempVec3$1.z * (0.5 - epsilon$1) + 0.5, data8, index + 8, 4);
		};
		_proto.addLightDataLightProjMatrix = function addLightDataLightProjMatrix(data8, index, lightProjectionMatrix) {
			var matData = lightProjectionMatrix.data;
			for (var m = 0; m < 12; m++) FloatPacking.float2BytesRange(matData[m], data8, index + 4 * m, -2, 2, 4);
			for (var _m = 12; _m < 16; _m++) {
				FloatPacking.float2MantissaExponent(matData[_m], data8, index + 4 * _m, 4);
			}
		};
		_proto.addLightDataCookies = function addLightDataCookies(data8, index, light) {
			var isRgb = light._cookieChannel === 'rgb';
			data8[index + 0] = Math.floor(light.cookieIntensity * 255);
			data8[index + 1] = isRgb ? 255 : 0;
			if (!isRgb) {
				var channel = light._cookieChannel;
				data8[index + 4] = channel === 'rrr' ? 255 : 0;
				data8[index + 5] = channel === 'ggg' ? 255 : 0;
				data8[index + 6] = channel === 'bbb' ? 255 : 0;
				data8[index + 7] = channel === 'aaa' ? 255 : 0;
			}
		};
		_proto.addLightAtlasViewport = function addLightAtlasViewport(data8, index, atlasViewport) {
			FloatPacking.float2Bytes(atlasViewport.x, data8, index + 0, 2);
			FloatPacking.float2Bytes(atlasViewport.y, data8, index + 2, 2);
			FloatPacking.float2Bytes(atlasViewport.z / 3, data8, index + 4, 2);
		};
		_proto.addLightAreaSizes = function addLightAreaSizes(data8, index, light) {
			var areaSizes = this.getLightAreaSizes(light);
			for (var i = 0; i < 6; i++) {
				FloatPacking.float2MantissaExponent(areaSizes[i], data8, index + 4 * i, 4);
			}
		};
		_proto.addLightData = function addLightData(light, lightIndex, gammaCorrection) {
			var isSpot = light._type === LIGHTTYPE_SPOT;
			var hasAtlasViewport = light.atlasViewportAllocated;
			var isCookie = this.cookiesEnabled && !!light._cookie && hasAtlasViewport;
			var isArea = this.areaLightsEnabled && light.shape !== LIGHTSHAPE_PUNCTUAL;
			var castShadows = this.shadowsEnabled && light.castShadows && hasAtlasViewport;
			var pos = light._node.getPosition();
			var lightProjectionMatrix = null;
			var atlasViewport = null;
			if (isSpot) {
				if (castShadows) {
					var lightRenderData = light.getRenderData(null, 0);
					lightProjectionMatrix = lightRenderData.shadowMatrix;
				} else if (isCookie) {
					lightProjectionMatrix = LightCamera.evalSpotCookieMatrix(light);
				}
			} else {
				if (castShadows || isCookie) {
					atlasViewport = light.atlasViewport;
				}
			}
			var data8 = this.lights8;
			var data8Start = lightIndex * this.lightsTexture8.width * 4;
			this.addLightDataFlags(data8, data8Start + 4 * TextureIndex8.FLAGS, light, isSpot, castShadows, light.shadowIntensity);
			this.addLightDataColor(data8, data8Start + 4 * TextureIndex8.COLOR_A, light, gammaCorrection, isCookie);
			if (isSpot) {
				this.addLightDataSpotAngles(data8, data8Start + 4 * TextureIndex8.SPOT_ANGLES, light);
			}
			if (light.castShadows) {
				this.addLightDataShadowBias(data8, data8Start + 4 * TextureIndex8.SHADOW_BIAS, light);
			}
			if (isCookie) {
				this.addLightDataCookies(data8, data8Start + 4 * TextureIndex8.COOKIE_A, light);
			}
			if (LightsBuffer.lightTextureFormat === LightsBuffer.FORMAT_FLOAT) {
				var dataFloat = this.lightsFloat;
				var dataFloatStart = lightIndex * this.lightsTextureFloat.width * 4;
				dataFloat[dataFloatStart + 4 * TextureIndexFloat.POSITION_RANGE + 0] = pos.x;
				dataFloat[dataFloatStart + 4 * TextureIndexFloat.POSITION_RANGE + 1] = pos.y;
				dataFloat[dataFloatStart + 4 * TextureIndexFloat.POSITION_RANGE + 2] = pos.z;
				dataFloat[dataFloatStart + 4 * TextureIndexFloat.POSITION_RANGE + 3] = light.attenuationEnd;
				if (isSpot) {
					this.getSpotDirection(tempVec3$1, light);
					dataFloat[dataFloatStart + 4 * TextureIndexFloat.SPOT_DIRECTION + 0] = tempVec3$1.x;
					dataFloat[dataFloatStart + 4 * TextureIndexFloat.SPOT_DIRECTION + 1] = tempVec3$1.y;
					dataFloat[dataFloatStart + 4 * TextureIndexFloat.SPOT_DIRECTION + 2] = tempVec3$1.z;
				}
				if (lightProjectionMatrix) {
					var matData = lightProjectionMatrix.data;
					for (var m = 0; m < 16; m++) dataFloat[dataFloatStart + 4 * TextureIndexFloat.PROJ_MAT_0 + m] = matData[m];
				}
				if (atlasViewport) {
					dataFloat[dataFloatStart + 4 * TextureIndexFloat.ATLAS_VIEWPORT + 0] = atlasViewport.x;
					dataFloat[dataFloatStart + 4 * TextureIndexFloat.ATLAS_VIEWPORT + 1] = atlasViewport.y;
					dataFloat[dataFloatStart + 4 * TextureIndexFloat.ATLAS_VIEWPORT + 2] = atlasViewport.z / 3;
				}
				if (isArea) {
					var areaSizes = this.getLightAreaSizes(light);
					dataFloat[dataFloatStart + 4 * TextureIndexFloat.AREA_DATA_WIDTH + 0] = areaSizes[0];
					dataFloat[dataFloatStart + 4 * TextureIndexFloat.AREA_DATA_WIDTH + 1] = areaSizes[1];
					dataFloat[dataFloatStart + 4 * TextureIndexFloat.AREA_DATA_WIDTH + 2] = areaSizes[2];
					dataFloat[dataFloatStart + 4 * TextureIndexFloat.AREA_DATA_HEIGHT + 0] = areaSizes[3];
					dataFloat[dataFloatStart + 4 * TextureIndexFloat.AREA_DATA_HEIGHT + 1] = areaSizes[4];
					dataFloat[dataFloatStart + 4 * TextureIndexFloat.AREA_DATA_HEIGHT + 2] = areaSizes[5];
				}
			} else {
				this.addLightDataPositionRange(data8, data8Start + 4 * TextureIndex8.POSITION_X, light, pos);
				if (isSpot) {
					this.addLightDataSpotDirection(data8, data8Start + 4 * TextureIndex8.SPOT_DIRECTION_X, light);
				}
				if (lightProjectionMatrix) {
					this.addLightDataLightProjMatrix(data8, data8Start + 4 * TextureIndex8.PROJ_MAT_00, lightProjectionMatrix);
				}
				if (atlasViewport) {
					this.addLightAtlasViewport(data8, data8Start + 4 * TextureIndex8.ATLAS_VIEWPORT_A, atlasViewport);
				}
				if (isArea) {
					this.addLightAreaSizes(data8, data8Start + 4 * TextureIndex8.AREA_DATA_WIDTH_X, light);
				}
			}
		};
		return LightsBuffer;
	}();
	LightsBuffer.FORMAT_FLOAT = 0;
	LightsBuffer.FORMAT_8BIT = 1;
	LightsBuffer.lightTextureFormat = LightsBuffer.FORMAT_8BIT;
	LightsBuffer.useTexelFetch = false;
	LightsBuffer.shaderDefines = '';

	var builtinAttributes = {
		vertex_normal: SEMANTIC_NORMAL,
		vertex_tangent: SEMANTIC_TANGENT,
		vertex_texCoord0: SEMANTIC_TEXCOORD0,
		vertex_texCoord1: SEMANTIC_TEXCOORD1,
		vertex_color: SEMANTIC_COLOR,
		vertex_boneWeights: SEMANTIC_BLENDWEIGHT,
		vertex_boneIndices: SEMANTIC_BLENDINDICES
	};
	var builtinVaryings = {
		vVertexColor: "vec4",
		vPositionW: "vec3",
		vNormalV: "vec3",
		vNormalW: "vec3",
		vTangentW: "vec3",
		vBinormalW: "vec3",
		vObjectSpaceUpW: "vec3",
		vUv0: "vec2",
		vUv1: "vec2"
	};
	var LitShader = function () {
		function LitShader(device, options) {
			this.device = device;
			this.options = options;
			this.attributes = {
				vertex_position: SEMANTIC_POSITION
			};
			if (options.chunks) {
				var userChunks = options.chunks;
				this.chunks = Object.create(shaderChunks);
				for (var chunkName in shaderChunks) {
					if (userChunks.hasOwnProperty(chunkName)) {
						var chunk = userChunks[chunkName];
						for (var a in builtinAttributes) {
							if (builtinAttributes.hasOwnProperty(a) && chunk.indexOf(a) >= 0) {
								this.attributes[a] = builtinAttributes[a];
							}
						}
						this.chunks[chunkName] = chunk;
					}
				}
			} else {
				this.chunks = shaderChunks;
			}
			this.shaderPassInfo = ShaderPass.get(this.device).getByIndex(options.pass);
			this.shadowPass = this.shaderPassInfo.isShadow;
			this.lighting = options.lights.length > 0 || options.dirLightMapEnabled || options.clusteredLightingEnabled;
			this.reflections = !!options.reflectionSource;
			this.needsNormal = this.lighting || this.reflections || options.useSpecular || options.ambientSH || options.useHeights || options.enableGGXSpecular || options.clusteredLightingEnabled && !this.shadowPass || options.useClearCoatNormals;
			this.needsNormal = this.needsNormal && !this.shadowPass;
			this.needsSceneColor = options.useDynamicRefraction;
			this.needsScreenSize = options.useDynamicRefraction;
			this.needsTransforms = options.useDynamicRefraction;
			this.varyings = "";
			this.varyingDefines = "";
			this.vshader = null;
			this.frontendDecl = null;
			this.frontendCode = null;
			this.frontendFunc = null;
			this.lightingUv = null;
			this.defines = [];
			this.fshader = null;
		}
		var _proto = LitShader.prototype;
		_proto._vsAddBaseCode = function _vsAddBaseCode(code, chunks, options) {
			code += chunks.baseVS;
			if (options.nineSlicedMode === SPRITE_RENDERMODE_SLICED || options.nineSlicedMode === SPRITE_RENDERMODE_TILED) {
				code += chunks.baseNineSlicedVS;
			}
			return code;
		};
		_proto._vsAddTransformCode = function _vsAddTransformCode(code, device, chunks, options) {
			code += this.chunks.transformVS;
			return code;
		};
		_proto._setMapTransform = function _setMapTransform(codes, name, id, uv) {
			var checkId = id + uv * 100;
			if (!codes[3][checkId]) {
				var varName = "texture_" + name + "MapTransform";
				codes[0] += "uniform vec3 " + varName + "0;\n";
				codes[0] += "uniform vec3 " + varName + "1;\n";
				codes[1] += "varying vec2 vUV" + uv + "_" + id + ";\n";
				codes[2] += "   vUV" + uv + "_" + id + " = vec2(dot(vec3(uv" + uv + ", 1), " + varName + "0), dot(vec3(uv" + uv + ", 1), " + varName + "1));\n";
				codes[3][checkId] = true;
			}
			return codes;
		};
		_proto._fsGetBaseCode = function _fsGetBaseCode() {
			var options = this.options;
			var chunks = this.chunks;
			var result = this.chunks.basePS;
			if (options.nineSlicedMode === SPRITE_RENDERMODE_SLICED) {
				result += chunks.baseNineSlicedPS;
			} else if (options.nineSlicedMode === SPRITE_RENDERMODE_TILED) {
				result += chunks.baseNineSlicedTiledPS;
			}
			return result;
		};
		_proto._fsGetStartCode = function _fsGetStartCode(code, device, chunks, options) {
			var result = chunks.startPS;
			if (options.nineSlicedMode === SPRITE_RENDERMODE_SLICED) {
				result += chunks.startNineSlicedPS;
			} else if (options.nineSlicedMode === SPRITE_RENDERMODE_TILED) {
				result += chunks.startNineSlicedTiledPS;
			}
			return result;
		};
		_proto._getLightSourceShapeString = function _getLightSourceShapeString(shape) {
			switch (shape) {
				case LIGHTSHAPE_RECT:
					return 'Rect';
				case LIGHTSHAPE_DISK:
					return 'Disk';
				case LIGHTSHAPE_SPHERE:
					return 'Sphere';
				default:
					return '';
			}
		};
		_proto.generateVertexShader = function generateVertexShader(useUv, useUnmodifiedUv, mapTransforms) {
			var _this = this;
			var device = this.device;
			var options = this.options;
			var chunks = this.chunks;
			var code = '';
			var codeBody = '';
			code = this._vsAddBaseCode(code, chunks, options);
			codeBody += "   vPositionW    = getWorldPosition();\n";
			if (this.options.pass === SHADER_DEPTH) {
				code += 'varying float vDepth;\n';
				code += '#ifndef VIEWMATRIX\n';
				code += '#define VIEWMATRIX\n';
				code += 'uniform mat4 matrix_view;\n';
				code += '#endif\n';
				code += '#ifndef CAMERAPLANES\n';
				code += '#define CAMERAPLANES\n';
				code += 'uniform vec4 camera_params;\n\n';
				code += '#endif\n';
				codeBody += "    vDepth = -(matrix_view * vec4(vPositionW,1.0)).z * camera_params.x;\n";
			}
			if (this.options.useInstancing) {
				this.attributes.instance_line1 = SEMANTIC_ATTR12;
				this.attributes.instance_line2 = SEMANTIC_ATTR13;
				this.attributes.instance_line3 = SEMANTIC_ATTR14;
				this.attributes.instance_line4 = SEMANTIC_ATTR15;
				code += chunks.instancingVS;
			}
			if (this.needsNormal) {
				this.attributes.vertex_normal = SEMANTIC_NORMAL;
				codeBody += "   vNormalW = getNormal();\n";
				if (options.reflectionSource === 'sphereMap' && device.fragmentUniformsCount <= 16) {
					code += chunks.viewNormalVS;
					codeBody += "   vNormalV    = getViewNormal();\n";
				}
				if (options.hasTangents && (options.useHeights || options.useNormals || options.enableGGXSpecular)) {
					this.attributes.vertex_tangent = SEMANTIC_TANGENT;
					code += chunks.tangentBinormalVS;
					codeBody += "   vTangentW   = getTangent();\n";
					codeBody += "   vBinormalW  = getBinormal();\n";
				} else if (options.enableGGXSpecular || !device.extStandardDerivatives) {
					codeBody += "   vObjectSpaceUpW = normalize(dNormalMatrix * vec3(0, 1, 0));\n";
				}
			}
			var maxUvSets = 2;
			for (var i = 0; i < maxUvSets; i++) {
				if (useUv[i]) {
					this.attributes["vertex_texCoord" + i] = "TEXCOORD" + i;
					code += chunks["uv" + i + "VS"];
					codeBody += "   vec2 uv" + i + " = getUv" + i + "();\n";
				}
				if (useUnmodifiedUv[i]) {
					codeBody += "   vUv" + i + " = uv" + i + ";\n";
				}
			}
			var codes = [code, this.varyings, codeBody, []];
			mapTransforms.forEach(function (mapTransform) {
				_this._setMapTransform(codes, mapTransform.name, mapTransform.id, mapTransform.uv);
			});
			code = codes[0];
			this.varyings = codes[1];
			codeBody = codes[2];
			if (options.vertexColors) {
				this.attributes.vertex_color = SEMANTIC_COLOR;
				codeBody += "   vVertexColor = vertex_color;\n";
			}
			if (options.useMsdf && options.msdfTextAttribute) {
				this.attributes.vertex_outlineParameters = SEMANTIC_ATTR8;
				this.attributes.vertex_shadowParameters = SEMANTIC_ATTR9;
				codeBody += "    unpackMsdfParams();\n";
				code += chunks.msdfVS;
			}
			if (options.useMorphPosition || options.useMorphNormal) {
				if (options.useMorphTextureBased) {
					code += "#define MORPHING_TEXTURE_BASED\n";
					if (options.useMorphPosition) {
						code += "#define MORPHING_TEXTURE_BASED_POSITION\n";
					}
					if (options.useMorphNormal) {
						code += "#define MORPHING_TEXTURE_BASED_NORMAL\n";
					}
					this.attributes.morph_vertex_id = SEMANTIC_ATTR15;
					var morphIdType = device.isWebGPU ? 'uint' : 'float';
					code += "attribute " + morphIdType + " morph_vertex_id;\n";
				} else {
					code += "#define MORPHING\n";
					if (options.useMorphPosition) {
						this.attributes.morph_pos0 = SEMANTIC_ATTR8;
						this.attributes.morph_pos1 = SEMANTIC_ATTR9;
						this.attributes.morph_pos2 = SEMANTIC_ATTR10;
						this.attributes.morph_pos3 = SEMANTIC_ATTR11;
						code += "#define MORPHING_POS03\n";
						code += "attribute vec3 morph_pos0;\n";
						code += "attribute vec3 morph_pos1;\n";
						code += "attribute vec3 morph_pos2;\n";
						code += "attribute vec3 morph_pos3;\n";
					} else if (options.useMorphNormal) {
						this.attributes.morph_nrm0 = SEMANTIC_ATTR8;
						this.attributes.morph_nrm1 = SEMANTIC_ATTR9;
						this.attributes.morph_nrm2 = SEMANTIC_ATTR10;
						this.attributes.morph_nrm3 = SEMANTIC_ATTR11;
						code += "#define MORPHING_NRM03\n";
						code += "attribute vec3 morph_nrm0;\n";
						code += "attribute vec3 morph_nrm1;\n";
						code += "attribute vec3 morph_nrm2;\n";
						code += "attribute vec3 morph_nrm3;\n";
					}
					if (!options.useMorphNormal) {
						this.attributes.morph_pos4 = SEMANTIC_ATTR12;
						this.attributes.morph_pos5 = SEMANTIC_ATTR13;
						this.attributes.morph_pos6 = SEMANTIC_ATTR14;
						this.attributes.morph_pos7 = SEMANTIC_ATTR15;
						code += "#define MORPHING_POS47\n";
						code += "attribute vec3 morph_pos4;\n";
						code += "attribute vec3 morph_pos5;\n";
						code += "attribute vec3 morph_pos6;\n";
						code += "attribute vec3 morph_pos7;\n";
					} else {
						this.attributes.morph_nrm4 = SEMANTIC_ATTR12;
						this.attributes.morph_nrm5 = SEMANTIC_ATTR13;
						this.attributes.morph_nrm6 = SEMANTIC_ATTR14;
						this.attributes.morph_nrm7 = SEMANTIC_ATTR15;
						code += "#define MORPHING_NRM47\n";
						code += "attribute vec3 morph_nrm4;\n";
						code += "attribute vec3 morph_nrm5;\n";
						code += "attribute vec3 morph_nrm6;\n";
						code += "attribute vec3 morph_nrm7;\n";
					}
				}
			}
			if (options.skin) {
				this.attributes.vertex_boneWeights = SEMANTIC_BLENDWEIGHT;
				this.attributes.vertex_boneIndices = SEMANTIC_BLENDINDICES;
				code += skinCode(device, chunks);
				code += "#define SKIN\n";
			} else if (options.useInstancing) {
				code += "#define INSTANCING\n";
			}
			if (options.screenSpace) {
				code += "#define SCREENSPACE\n";
			}
			if (options.pixelSnap) {
				code += "#define PIXELSNAP\n";
			}
			code = this._vsAddTransformCode(code, device, chunks, options);
			if (this.needsNormal) {
				code += chunks.normalVS;
			}
			code += "\n";
			code += chunks.startVS;
			code += codeBody;
			code += chunks.endVS;
			code += "}";
			Object.keys(builtinVaryings).forEach(function (v) {
				if (code.indexOf(v) >= 0) {
					_this.varyings += "varying " + builtinVaryings[v] + " " + v + ";\n";
					_this.varyingDefines += "#define VARYING_" + v.toUpperCase() + "\n";
				}
			});
			var shaderPassDefines = this.shaderPassInfo.shaderDefines;
			this.vshader = shaderPassDefines + this.varyings + code;
		};
		_proto._fsGetBeginCode = function _fsGetBeginCode() {
			var code = this.shaderPassInfo.shaderDefines;
			for (var i = 0; i < this.defines.length; i++) {
				code += "#define " + this.defines[i] + "\n";
			}
			return code;
		};
		_proto._fsGetPickPassCode = function _fsGetPickPassCode() {
			var code = this._fsGetBeginCode();
			code += "uniform vec4 uColor;\n";
			code += this.varyings;
			code += this.varyingDefines;
			code += this.frontendDecl;
			code += this.frontendCode;
			code += begin();
			code += this.frontendFunc;
			code += "    gl_FragColor = uColor;\n";
			code += end();
			return code;
		};
		_proto._fsGetDepthPassCode = function _fsGetDepthPassCode() {
			var chunks = this.chunks;
			var code = this._fsGetBeginCode();
			code += 'varying float vDepth;\n';
			code += this.varyings;
			code += this.varyingDefines;
			code += chunks.packDepthPS;
			code += this.frontendDecl;
			code += this.frontendCode;
			code += begin();
			code += this.frontendFunc;
			code += "    gl_FragColor = packFloat(vDepth);\n";
			code += end();
			return code;
		};
		_proto._fsGetShadowPassCode = function _fsGetShadowPassCode() {
			var device = this.device;
			var options = this.options;
			var chunks = this.chunks;
			var varyings = this.varyings;
			var lightType = this.shaderPassInfo.lightType;
			var shadowType = this.shaderPassInfo.shadowType;
			if (lightType !== LIGHTTYPE_DIRECTIONAL && options.clusteredLightingEnabled) {
				if (shadowType === SHADOW_VSM8 || shadowType === SHADOW_VSM16 || shadowType === SHADOW_VSM32 || shadowType === SHADOW_PCSS) {
					shadowType = SHADOW_PCF3;
				}
			}
			var code = this._fsGetBeginCode();
			if (device.extStandardDerivatives && !device.webgl2 && !device.isWebGPU) {
				code += 'uniform vec2 polygonOffset;\n';
			}
			if (shadowType === SHADOW_VSM32) {
				if (device.textureFloatHighPrecision) {
					code += '#define VSM_EXPONENT 15.0\n\n';
				} else {
					code += '#define VSM_EXPONENT 5.54\n\n';
				}
			} else if (shadowType === SHADOW_VSM16) {
				code += '#define VSM_EXPONENT 5.54\n\n';
			}
			if (lightType !== LIGHTTYPE_DIRECTIONAL) {
				code += 'uniform vec3 view_position;\n';
				code += 'uniform float light_radius;\n';
			}
			code += varyings;
			code += this.varyingDefines;
			code += this.frontendDecl;
			code += this.frontendCode;
			var mayPackDepth = shadowType === SHADOW_PCF1 || shadowType === SHADOW_PCF3 || shadowType === SHADOW_PCF5 || shadowType === SHADOW_PCSS;
			var mustPackDepth = lightType === LIGHTTYPE_OMNI && shadowType !== SHADOW_PCSS && !options.clusteredLightingEnabled;
			var usePackedDepth = mayPackDepth && !device.supportsDepthShadow || mustPackDepth;
			if (usePackedDepth) {
				code += chunks.packDepthPS;
			} else if (shadowType === SHADOW_VSM8) {
				code += "vec2 encodeFloatRG( float v ) {\n";
				code += "    vec2 enc = vec2(1.0, 255.0) * v;\n";
				code += "    enc = fract(enc);\n";
				code += "    enc -= enc.yy * vec2(1.0/255.0, 1.0/255.0);\n";
				code += "    return enc;\n";
				code += "}\n\n";
			}
			if (shadowType === SHADOW_PCSS) {
				code += shaderChunks.linearizeDepthPS;
			}
			code += begin();
			code += this.frontendFunc;
			var isVsm = shadowType === SHADOW_VSM8 || shadowType === SHADOW_VSM16 || shadowType === SHADOW_VSM32;
			var applySlopeScaleBias = !device.webgl2 && device.extStandardDerivatives && !device.isWebGPU;
			var usePerspectiveDepth = lightType === LIGHTTYPE_DIRECTIONAL || !isVsm && lightType === LIGHTTYPE_SPOT;
			var hasModifiedDepth = false;
			if (usePerspectiveDepth) {
				code += "    float depth = gl_FragCoord.z;\n";
			} else {
				code += "    float depth = min(distance(view_position, vPositionW) / light_radius, 0.99999);\n";
				hasModifiedDepth = true;
			}
			if (applySlopeScaleBias) {
				code += "    float minValue = 2.3374370500153186e-10; //(1.0 / 255.0) / (256.0 * 256.0 * 256.0);\n";
				code += "    depth += polygonOffset.x * max(abs(dFdx(depth)), abs(dFdy(depth))) + minValue * polygonOffset.y;\n";
				hasModifiedDepth = true;
			}
			if (usePackedDepth) {
				code += "    gl_FragColor = packFloat(depth);\n";
			} else if (!isVsm) {
				var exportR32 = shadowType === SHADOW_PCSS;
				if (exportR32) {
					code += "    gl_FragColor.r = depth;\n";
				} else {
					if (hasModifiedDepth) {
						code += "    gl_FragDepth = depth;\n";
					}
					code += "    gl_FragColor = vec4(1.0);\n";
				}
			} else if (shadowType === SHADOW_VSM8) {
				code += "    gl_FragColor = vec4(encodeFloatRG(depth), encodeFloatRG(depth*depth));\n";
			} else {
				code += chunks.storeEVSMPS;
			}
			code += end();
			return code;
		};
		_proto._fsGetLitPassCode = function _fsGetLitPassCode() {
			var device = this.device;
			var options = this.options;
			var chunks = this.chunks;
			var decl = new ChunkBuilder();
			var func = new ChunkBuilder();
			var backend = new ChunkBuilder();
			var code = new ChunkBuilder();
			if (options.opacityFadesSpecular === false) {
				decl.append('uniform float material_alphaFade;');
			}
			if (options.useSpecular) {
				this.defines.push("LIT_SPECULAR");
				if (this.reflections) {
					this.defines.push("LIT_REFLECTIONS");
				}
				if (options.useClearCoat) {
					this.defines.push("LIT_CLEARCOAT");
				}
				if (options.fresnelModel > 0) {
					this.defines.push("LIT_SPECULAR_FRESNEL");
				}
				if (options.conserveEnergy) {
					this.defines.push("LIT_CONSERVE_ENERGY");
				}
				if (options.useSheen) {
					this.defines.push("LIT_SHEEN");
				}
				if (options.useIridescence) {
					this.defines.push("LIT_IRIDESCENCE");
				}
			}
			var shadowTypeUsed = [];
			var numShadowLights = 0;
			var shadowedDirectionalLightUsed = false;
			var useVsm = false;
			var usePcss = false;
			var hasAreaLights = options.lights.some(function (light) {
				return light._shape && light._shape !== LIGHTSHAPE_PUNCTUAL;
			});
			if (options.clusteredLightingEnabled && options.clusteredLightingAreaLightsEnabled) {
				hasAreaLights = true;
			}
			var areaLutsPrecision = 'highp';
			if (device.areaLightLutFormat === PIXELFORMAT_RGBA8) {
				decl.append("#define AREA_R8_G8_B8_A8_LUTS");
				areaLutsPrecision = 'lowp';
			}
			if (hasAreaLights || options.clusteredLightingEnabled) {
				decl.append("#define AREA_LIGHTS");
				decl.append("uniform " + areaLutsPrecision + " sampler2D areaLightsLutTex1;");
				decl.append("uniform " + areaLutsPrecision + " sampler2D areaLightsLutTex2;");
			}
			for (var i = 0; i < options.lights.length; i++) {
				var light = options.lights[i];
				var lightType = light._type;
				if (options.clusteredLightingEnabled && lightType !== LIGHTTYPE_DIRECTIONAL) continue;
				var lightShape = hasAreaLights && light._shape ? light._shape : LIGHTSHAPE_PUNCTUAL;
				decl.append("uniform vec3 light" + i + "_color;");
				if (light._shadowType === SHADOW_PCSS && light.castShadows && !options.noShadow) {
					decl.append("uniform float light" + i + "_shadowSearchArea;");
					decl.append("uniform vec4 light" + i + "_cameraParams;");
				}
				if (lightType === LIGHTTYPE_DIRECTIONAL) {
					decl.append("uniform vec3 light" + i + "_direction;");
				} else {
					decl.append("uniform vec3 light" + i + "_position;");
					decl.append("uniform float light" + i + "_radius;");
					if (lightType === LIGHTTYPE_SPOT) {
						decl.append("uniform vec3 light" + i + "_direction;");
						decl.append("uniform float light" + i + "_innerConeAngle;");
						decl.append("uniform float light" + i + "_outerConeAngle;");
					}
				}
				if (lightShape !== LIGHTSHAPE_PUNCTUAL) {
					if (lightType === LIGHTTYPE_DIRECTIONAL) {
						decl.append("uniform vec3 light" + i + "_position;");
					}
					decl.append("uniform vec3 light" + i + "_halfWidth;");
					decl.append("uniform vec3 light" + i + "_halfHeight;");
				}
				if (light.castShadows && !options.noShadow) {
					decl.append("uniform mat4 light" + i + "_shadowMatrix;");
					decl.append("uniform float light" + i + "_shadowIntensity;");
					if (lightType === LIGHTTYPE_DIRECTIONAL) {
						decl.append("uniform mat4 light" + i + "_shadowMatrixPalette[4];");
						decl.append("uniform float light" + i + "_shadowCascadeDistances[4];");
						decl.append("uniform float light" + i + "_shadowCascadeCount;");
					}
					decl.append("uniform vec4 light" + i + "_shadowParams;");
					if (lightType === LIGHTTYPE_DIRECTIONAL) {
						shadowedDirectionalLightUsed = true;
					}
					if (lightType === LIGHTTYPE_OMNI) {
						decl.append("uniform samplerCube light" + i + "_shadowMap;");
					} else {
						if (light._isPcf && device.supportsDepthShadow) {
							decl.append("uniform sampler2DShadow light" + i + "_shadowMap;");
						} else {
							decl.append("uniform sampler2D light" + i + "_shadowMap;");
						}
					}
					numShadowLights++;
					shadowTypeUsed[light._shadowType] = true;
					if (light._isVsm) useVsm = true;
					if (light._shadowType === SHADOW_PCSS) usePcss = true;
				}
				if (light._cookie) {
					if (light._cookie._cubemap) {
						if (lightType === LIGHTTYPE_OMNI) {
							decl.append("uniform samplerCube light" + i + "_cookie;");
							decl.append("uniform float light" + i + "_cookieIntensity;");
							if (!light.castShadows || options.noShadow) {
								decl.append("uniform mat4 light" + i + "_shadowMatrix;");
							}
						}
					} else {
						if (lightType === LIGHTTYPE_SPOT) {
							decl.append("uniform sampler2D light" + i + "_cookie;");
							decl.append("uniform float light" + i + "_cookieIntensity;");
							if (!light.castShadows || options.noShadow) {
								decl.append("uniform mat4 light" + i + "_shadowMatrix;");
							}
							if (light._cookieTransform) {
								decl.append("uniform vec4 light" + i + "_cookieMatrix;");
								decl.append("uniform vec2 light" + i + "_cookieOffset;");
							}
						}
					}
				}
			}
			var hasTBN = this.needsNormal && (options.useNormals || options.useClearCoatNormals || options.enableGGXSpecular && !options.useHeights);
			if (hasTBN) {
				if (options.hasTangents) {
					func.append(options.fastTbn ? chunks.TBNfastPS : chunks.TBNPS);
				} else {
					if (device.extStandardDerivatives && (options.useNormals || options.useClearCoatNormals)) {
						func.append(chunks.TBNderivativePS.replace(/\$UV/g, this.lightingUv));
					} else {
						func.append(chunks.TBNObjectSpacePS);
					}
				}
			}
			func.append(chunks.sphericalPS);
			func.append(chunks.decodePS);
			func.append(gammaCode(options.gamma, chunks));
			func.append(tonemapCode(options.toneMap, chunks));
			func.append(fogCode(options.fog, chunks));
			func.append(this.frontendCode);
			if (options.useCubeMapRotation) {
				decl.append("#define CUBEMAP_ROTATION");
			}
			if (this.needsNormal) {
				func.append(chunks.cubeMapRotatePS);
				func.append(options.cubeMapProjection > 0 ? chunks.cubeMapProjectBoxPS : chunks.cubeMapProjectNonePS);
				func.append(options.skyboxIntensity ? chunks.envMultiplyPS : chunks.envConstPS);
			}
			if (this.lighting && options.useSpecular || this.reflections) {
				if (options.useMetalness) {
					func.append(chunks.metalnessModulatePS);
				}
				if (options.fresnelModel === FRESNEL_SCHLICK) {
					func.append(chunks.fresnelSchlickPS);
				}
				if (options.useIridescence) {
					func.append(chunks.iridescenceDiffractionPS);
				}
			}
			if (options.useAo) {
				func.append(chunks.aoDiffuseOccPS);
				switch (options.occludeSpecular) {
					case SPECOCC_AO:
						func.append(options.occludeSpecularFloat ? chunks.aoSpecOccSimplePS : chunks.aoSpecOccConstSimplePS);
						break;
					case SPECOCC_GLOSSDEPENDENT:
						func.append(options.occludeSpecularFloat ? chunks.aoSpecOccPS : chunks.aoSpecOccConstPS);
						break;
				}
			}
			if (options.reflectionSource === 'envAtlasHQ') {
				func.append(options.fixSeams ? chunks.fixCubemapSeamsStretchPS : chunks.fixCubemapSeamsNonePS);
				func.append(chunks.envAtlasPS);
				func.append(chunks.reflectionEnvHQPS.replace(/\$DECODE_CUBEMAP/g, ChunkUtils.decodeFunc(options.reflectionCubemapEncoding)).replace(/\$DECODE/g, ChunkUtils.decodeFunc(options.reflectionEncoding)));
			} else if (options.reflectionSource === 'envAtlas') {
				func.append(chunks.envAtlasPS);
				func.append(chunks.reflectionEnvPS.replace(/\$DECODE/g, ChunkUtils.decodeFunc(options.reflectionEncoding)));
			} else if (options.reflectionSource === 'cubeMap') {
				func.append(options.fixSeams ? chunks.fixCubemapSeamsStretchPS : chunks.fixCubemapSeamsNonePS);
				func.append(chunks.reflectionCubePS.replace(/\$DECODE/g, ChunkUtils.decodeFunc(options.reflectionEncoding)));
			} else if (options.reflectionSource === 'sphereMap') {
				var scode = device.fragmentUniformsCount > 16 ? chunks.reflectionSpherePS : chunks.reflectionSphereLowPS;
				func.append(scode.replace(/\$DECODE/g, ChunkUtils.decodeFunc(options.reflectionEncoding)));
			}
			if (this.reflections) {
				if (options.useClearCoat) {
					func.append(chunks.reflectionCCPS);
				}
				if (options.useSheen) {
					func.append(chunks.reflectionSheenPS);
				}
			}
			if (options.useRefraction) {
				if (options.useDynamicRefraction) {
					func.append(chunks.refractionDynamicPS);
				} else if (this.reflections) {
					func.append(chunks.refractionCubePS);
				}
			}
			if (options.useSheen) {
				func.append(chunks.lightSheenPS);
			}
			if (options.clusteredLightingEnabled) {
				func.append(chunks.clusteredLightUtilsPS);
				if (options.clusteredLightingCookiesEnabled) func.append(chunks.clusteredLightCookiesPS);
				if (options.clusteredLightingShadowsEnabled && !options.noShadow) {
					shadowTypeUsed[SHADOW_PCF3] = true;
					shadowTypeUsed[SHADOW_PCF5] = true;
					shadowTypeUsed[SHADOW_PCSS] = true;
				}
			}
			if (numShadowLights > 0 || options.clusteredLightingEnabled) {
				if (shadowedDirectionalLightUsed) {
					func.append(chunks.shadowCascadesPS);
				}
				if (shadowTypeUsed[SHADOW_PCF1] || shadowTypeUsed[SHADOW_PCF3]) {
					func.append(chunks.shadowStandardPS);
				}
				if (shadowTypeUsed[SHADOW_PCF5] && (device.webgl2 || device.isWebGPU)) {
					func.append(chunks.shadowStandardGL2PS);
				}
				if (useVsm) {
					func.append(chunks.shadowVSM_commonPS);
					if (shadowTypeUsed[SHADOW_VSM8]) {
						func.append(chunks.shadowVSM8PS);
					}
					if (shadowTypeUsed[SHADOW_VSM16]) {
						func.append(device.extTextureHalfFloatLinear ? chunks.shadowEVSMPS.replace(/\$/g, "16") : chunks.shadowEVSMnPS.replace(/\$/g, "16"));
					}
					if (shadowTypeUsed[SHADOW_VSM32]) {
						func.append(device.extTextureFloatLinear ? chunks.shadowEVSMPS.replace(/\$/g, "32") : chunks.shadowEVSMnPS.replace(/\$/g, "32"));
					}
				}
				if (usePcss) {
					func.append(chunks.linearizeDepthPS);
					func.append(chunks.shadowPCSSPS);
				}
				if (!(device.webgl2 || device.extStandardDerivatives || device.isWebGPU)) {
					func.append(chunks.biasConstPS);
				}
			}
			if (options.enableGGXSpecular) func.append("uniform float material_anisotropy;");
			if (this.lighting) {
				func.append(chunks.lightDiffuseLambertPS);
				if (hasAreaLights || options.clusteredLightingAreaLightsEnabled) {
					func.append(chunks.ltcPS);
				}
			}
			var useOldAmbient = false;
			if (options.useSpecular) {
				if (this.lighting) {
					func.append(options.shadingModel === SPECULAR_PHONG ? chunks.lightSpecularPhongPS : options.enableGGXSpecular ? chunks.lightSpecularAnisoGGXPS : chunks.lightSpecularBlinnPS);
				}
				if (!options.fresnelModel && !this.reflections && !options.diffuseMapEnabled) {
					decl.append("uniform vec3 material_ambient;");
					decl.append("#define LIT_OLD_AMBIENT");
					useOldAmbient = true;
				}
			}
			func.append(chunks.combinePS);
			if (options.lightMapEnabled) {
				func.append(options.useSpecular && options.dirLightMapEnabled ? chunks.lightmapDirAddPS : chunks.lightmapAddPS);
			}
			var addAmbient = !options.lightMapEnabled || options.lightMapWithoutAmbient;
			if (addAmbient) {
				if (options.ambientSource === 'ambientSH') {
					func.append(chunks.ambientSHPS);
				} else if (options.ambientSource === 'envAtlas') {
					if (options.reflectionSource !== 'envAtlas' && options.reflectionSource !== 'envAtlasHQ') {
						func.append(chunks.envAtlasPS);
					}
					func.append(chunks.ambientEnvPS.replace(/\$DECODE/g, ChunkUtils.decodeFunc(options.ambientEncoding)));
				} else {
					func.append(chunks.ambientConstantPS);
				}
			}
			if (options.useAmbientTint && !useOldAmbient) {
				decl.append("uniform vec3 material_ambient;");
			}
			if (options.useMsdf) {
				if (!options.msdfTextAttribute) {
					decl.append("#define UNIFORM_TEXT_PARAMETERS");
				}
				func.append(chunks.msdfPS);
			}
			if (this.needsNormal) {
				func.append(chunks.viewDirPS);
				if (options.useSpecular) {
					func.append(options.enableGGXSpecular ? chunks.reflDirAnisoPS : chunks.reflDirPS);
				}
			}
			var hasPointLights = false;
			var usesLinearFalloff = false;
			var usesInvSquaredFalloff = false;
			var usesSpot = false;
			var usesCookie = false;
			var usesCookieNow;
			if (options.clusteredLightingEnabled && this.lighting) {
				usesSpot = true;
				hasPointLights = true;
				usesLinearFalloff = true;
				usesCookie = true;
				func.append(chunks.floatUnpackingPS);
				if (options.lightMaskDynamic) decl.append("#define CLUSTER_MESH_DYNAMIC_LIGHTS");
				if (options.clusteredLightingCookiesEnabled) decl.append("#define CLUSTER_COOKIES");
				if (options.clusteredLightingShadowsEnabled && !options.noShadow) {
					decl.append("#define CLUSTER_SHADOWS");
					decl.append("#define CLUSTER_SHADOW_TYPE_" + shadowTypeToString[options.clusteredLightingShadowType]);
				}
				if (options.clusteredLightingAreaLightsEnabled) decl.append("#define CLUSTER_AREALIGHTS");
				decl.append(LightsBuffer.shaderDefines);
				if (options.clusteredLightingShadowsEnabled && !options.noShadow) {
					func.append(chunks.clusteredLightShadowsPS);
				}
				func.append(chunks.clusteredLightPS);
			}
			if (options.twoSidedLighting) {
				decl.append("uniform float twoSidedLightingNegScaleFactor;");
			}
			code.append(this._fsGetStartCode(code, device, chunks, options));
			if (this.needsNormal) {
				if (options.twoSidedLighting) {
					code.append("    dVertexNormalW = normalize(gl_FrontFacing ? vNormalW * twoSidedLightingNegScaleFactor : -vNormalW * twoSidedLightingNegScaleFactor);");
				} else {
					code.append("    dVertexNormalW = normalize(vNormalW);");
				}
				if ((options.useHeights || options.useNormals) && options.hasTangents) {
					if (options.twoSidedLighting) {
						code.append("    dTangentW = gl_FrontFacing ? vTangentW * twoSidedLightingNegScaleFactor : -vTangentW * twoSidedLightingNegScaleFactor;");
						code.append("    dBinormalW = gl_FrontFacing ? vBinormalW * twoSidedLightingNegScaleFactor : -vBinormalW * twoSidedLightingNegScaleFactor;");
					} else {
						code.append("    dTangentW = vTangentW;");
						code.append("    dBinormalW = vBinormalW;");
					}
				}
				code.append("    getViewDir();");
				if (hasTBN) {
					code.append("    getTBN(dTangentW, dBinormalW, dVertexNormalW);");
				}
			}
			code.append(this.frontendFunc);
			if (this.needsNormal) {
				if (options.useSpecular) {
					backend.append("    getReflDir(litArgs_worldNormal, dViewDirW, litArgs_gloss, dTBN);");
				}
				if (options.useClearCoat) {
					backend.append("    ccReflDirW = normalize(-reflect(dViewDirW, litArgs_clearcoat_worldNormal));");
				}
			}
			if (this.lighting && options.useSpecular || this.reflections) {
				if (options.useMetalness) {
					backend.append("    float f0 = 1.0 / litArgs_ior; f0 = (f0 - 1.0) / (f0 + 1.0); f0 *= f0;");
					backend.append("    litArgs_specularity = getSpecularModulate(litArgs_specularity, litArgs_albedo, litArgs_metalness, f0);");
					backend.append("    litArgs_albedo = getAlbedoModulate(litArgs_albedo, litArgs_metalness);");
				}
				if (options.useIridescence) {
					backend.append("    vec3 iridescenceFresnel = getIridescence(saturate(dot(dViewDirW, litArgs_worldNormal)), litArgs_specularity, litArgs_iridescence_thickness);");
				}
			}
			if (addAmbient) {
				backend.append("    addAmbient(litArgs_worldNormal);");
				if (options.conserveEnergy && options.useSpecular) {
					backend.append("   dDiffuseLight = dDiffuseLight * (1.0 - litArgs_specularity);");
				}
				if (options.separateAmbient) {
					backend.append("\n                    vec3 dAmbientLight = dDiffuseLight;\n                    dDiffuseLight = vec3(0);\n                ");
				}
			}
			if (options.useAmbientTint && !useOldAmbient) {
				backend.append("    dDiffuseLight *= material_ambient;");
			}
			if (options.useAo && !options.occludeDirect) {
				backend.append("    occludeDiffuse(litArgs_ao);");
			}
			if (options.lightMapEnabled) {
				backend.append("    addLightMap(\n                litArgs_lightmap, \n                litArgs_lightmapDir, \n                litArgs_worldNormal, \n                dViewDirW, \n                dReflDirW, \n                litArgs_gloss, \n                litArgs_specularity, \n                dVertexNormalW,\n                dTBN\n            #if defined(LIT_IRIDESCENCE)\n                , iridescenceFresnel,\n                litArgs_iridescence_intensity\n            #endif\n                );");
			}
			if (this.lighting || this.reflections) {
				if (this.reflections) {
					if (options.useClearCoat) {
						backend.append("    addReflectionCC(ccReflDirW, litArgs_clearcoat_gloss);");
						if (options.fresnelModel > 0) {
							backend.append("    ccFresnel = getFresnelCC(dot(dViewDirW, litArgs_clearcoat_worldNormal));");
							backend.append("    ccReflection.rgb *= ccFresnel;");
						} else {
							backend.append("    ccFresnel = 0.0;");
						}
					}
					if (options.useSpecularityFactor) {
						backend.append("    ccReflection.rgb *= litArgs_specularityFactor;");
					}
					if (options.useSheen) {
						backend.append("    addReflectionSheen(litArgs_worldNormal, dViewDirW, litArgs_sheen_gloss);");
					}
					backend.append("    addReflection(dReflDirW, litArgs_gloss);");
					if (options.fresnelModel > 0) {
						backend.append("    dReflection.rgb *= \n                        getFresnel(\n                            dot(dViewDirW, litArgs_worldNormal), \n                            litArgs_gloss, \n                            litArgs_specularity\n                        #if defined(LIT_IRIDESCENCE)\n                            , iridescenceFresnel,\n                            litArgs_iridescence_intensity\n                        #endif\n                            );");
					} else {
						backend.append("    dReflection.rgb *= litArgs_specularity;");
					}
					if (options.useSpecularityFactor) {
						backend.append("    dReflection.rgb *= litArgs_specularityFactor;");
					}
				}
				if (hasAreaLights) {
					backend.append("    dSpecularLight *= litArgs_specularity;");
					if (options.useSpecular) {
						backend.append("    calcLTCLightValues(litArgs_gloss, litArgs_worldNormal, dViewDirW, litArgs_specularity, litArgs_clearcoat_gloss, litArgs_clearcoat_worldNormal, litArgs_clearcoat_specularity);");
					}
				}
				for (var _i = 0; _i < options.lights.length; _i++) {
					var _light = options.lights[_i];
					var _lightType = _light._type;
					if (options.clusteredLightingEnabled && _lightType !== LIGHTTYPE_DIRECTIONAL) {
						continue;
					}
					usesCookieNow = false;
					var _lightShape = hasAreaLights && _light._shape ? _light.shape : LIGHTSHAPE_PUNCTUAL;
					var shapeString = hasAreaLights && _light._shape ? this._getLightSourceShapeString(_lightShape) : '';
					if (_lightShape !== LIGHTSHAPE_PUNCTUAL) {
						backend.append("    calc" + shapeString + "LightValues(light" + _i + "_position, light" + _i + "_halfWidth, light" + _i + "_halfHeight);");
					}
					if (_lightType === LIGHTTYPE_DIRECTIONAL) {
						backend.append("    dLightDirNormW = light" + _i + "_direction;");
						backend.append("    dAtten = 1.0;");
					} else {
						if (_light._cookie) {
							if (_lightType === LIGHTTYPE_SPOT && !_light._cookie._cubemap) {
								usesCookie = true;
								usesCookieNow = true;
							} else if (_lightType === LIGHTTYPE_OMNI && _light._cookie._cubemap) {
								usesCookie = true;
								usesCookieNow = true;
							}
						}
						backend.append("    getLightDirPoint(light" + _i + "_position);");
						hasPointLights = true;
						if (usesCookieNow) {
							if (_lightType === LIGHTTYPE_SPOT) {
								backend.append("    dAtten3 = getCookie2D" + (_light._cookieFalloff ? "" : "Clip") + (_light._cookieTransform ? "Xform" : "") + "(light" + _i + "_cookie, light" + _i + "_shadowMatrix, light" + _i + "_cookieIntensity" + (_light._cookieTransform ? ", light" + _i + "_cookieMatrix, light" + _i + "_cookieOffset" : "") + ")." + _light._cookieChannel + ";");
							} else {
								backend.append("    dAtten3 = getCookieCube(light" + _i + "_cookie, light" + _i + "_shadowMatrix, light" + _i + "_cookieIntensity)." + _light._cookieChannel + ";");
							}
						}
						if (_lightShape === LIGHTSHAPE_PUNCTUAL) {
							if (_light._falloffMode === LIGHTFALLOFF_LINEAR) {
								backend.append("    dAtten = getFalloffLinear(light" + _i + "_radius, dLightDirW);");
								usesLinearFalloff = true;
							} else {
								backend.append("    dAtten = getFalloffInvSquared(light" + _i + "_radius, dLightDirW);");
								usesInvSquaredFalloff = true;
							}
						} else {
							backend.append("    dAtten = getFalloffWindow(light" + _i + "_radius, dLightDirW);");
							usesInvSquaredFalloff = true;
						}
						backend.append("    if (dAtten > 0.00001) {");
						if (_lightType === LIGHTTYPE_SPOT) {
							if (!(usesCookieNow && !_light._cookieFalloff)) {
								backend.append("    dAtten *= getSpotEffect(light" + _i + "_direction, light" + _i + "_innerConeAngle, light" + _i + "_outerConeAngle, dLightDirNormW);");
								usesSpot = true;
							}
						}
					}
					if (_lightShape !== LIGHTSHAPE_PUNCTUAL) {
						if (_lightType === LIGHTTYPE_DIRECTIONAL) {
							backend.append("    dAttenD = getLightDiffuse(litArgs_worldNormal, dViewDirW, dLightDirW, dLightDirNormW);");
						} else {
							backend.append("    dAttenD = get" + shapeString + "LightDiffuse(litArgs_worldNormal, dViewDirW, dLightDirW, dLightDirNormW) * 16.0;");
						}
					} else {
						backend.append("    dAtten *= getLightDiffuse(litArgs_worldNormal, dViewDirW, dLightDirW, dLightDirNormW);");
					}
					if (_light.castShadows && !options.noShadow) {
						var pcssShadows = _light._shadowType === SHADOW_PCSS;
						var vsmShadows = _light._shadowType === SHADOW_VSM8 || _light._shadowType === SHADOW_VSM16 || _light._shadowType === SHADOW_VSM32;
						var pcfShadows = _light._shadowType === SHADOW_PCF1 || _light._shadowType === SHADOW_PCF3 || _light._shadowType === SHADOW_PCF5;
						var shadowReadMode = null;
						var evsmExp = void 0;
						switch (_light._shadowType) {
							case SHADOW_VSM8:
								shadowReadMode = "VSM8";
								evsmExp = "0.0";
								break;
							case SHADOW_VSM16:
								shadowReadMode = "VSM16";
								evsmExp = "5.54";
								break;
							case SHADOW_VSM32:
								shadowReadMode = "VSM32";
								if (device.textureFloatHighPrecision) {
									evsmExp = "15.0";
								} else {
									evsmExp = "5.54";
								}
								break;
							case SHADOW_PCF1:
								shadowReadMode = "PCF1x1";
								break;
							case SHADOW_PCF5:
								shadowReadMode = "PCF5x5";
								break;
							case SHADOW_PCSS:
								shadowReadMode = "PCSS";
								break;
							case SHADOW_PCF3:
							default:
								shadowReadMode = "PCF3x3";
								break;
						}
						if (shadowReadMode !== null) {
							if (_light._normalOffsetBias && !_light._isVsm) {
								func.append("#define SHADOW_SAMPLE_NORMAL_OFFSET");
							}
							if (_lightType === LIGHTTYPE_DIRECTIONAL) {
								func.append("#define SHADOW_SAMPLE_ORTHO");
							}
							if ((pcfShadows || pcssShadows) && device.webgl2 || device.extStandardDerivatives || device.isWebGPU) {
								func.append("#define SHADOW_SAMPLE_SOURCE_ZBUFFER");
							}
							if (_lightType === LIGHTTYPE_OMNI) {
								func.append("#define SHADOW_SAMPLE_POINT");
							}
							var coordCode = chunks.shadowSampleCoordPS;
							func.append(coordCode.replace("$LIGHT", _i));
							func.append("#undef SHADOW_SAMPLE_NORMAL_OFFSET");
							func.append("#undef SHADOW_SAMPLE_ORTHO");
							func.append("#undef SHADOW_SAMPLE_SOURCE_ZBUFFER");
							func.append("#undef SHADOW_SAMPLE_POINT");
							var shadowMatrix = "light" + _i + "_shadowMatrix";
							if (_lightType === LIGHTTYPE_DIRECTIONAL && _light.numCascades > 1) {
								backend.append("    getShadowCascadeMatrix(light" + _i + "_shadowMatrixPalette, light" + _i + "_shadowCascadeDistances, light" + _i + "_shadowCascadeCount);");
								shadowMatrix = "cascadeShadowMat";
							}
							backend.append("    dShadowCoord = getShadowSampleCoord" + _i + "(" + shadowMatrix + ", light" + _i + "_shadowParams, vPositionW, dLightPosW, dLightDirW, dLightDirNormW, dVertexNormalW);");
							if (_lightType === LIGHTTYPE_DIRECTIONAL) {
								backend.append("    fadeShadow(light" + _i + "_shadowCascadeDistances);");
							}
							var shadowCoordArgs = "SHADOWMAP_PASS(light" + _i + "_shadowMap), dShadowCoord, light" + _i + "_shadowParams";
							if (vsmShadows) {
								shadowCoordArgs = shadowCoordArgs + ", " + evsmExp + ", dLightDirW";
							} else if (pcssShadows) {
								var penumbraSizeArg = "vec2(light" + _i + "_shadowSearchArea)";
								if (_lightShape !== LIGHTSHAPE_PUNCTUAL) {
									penumbraSizeArg = "vec2(length(light" + _i + "_halfWidth), length(light" + _i + "_halfHeight)) * light" + _i + "_shadowSearchArea";
								}
								shadowCoordArgs = shadowCoordArgs + ", light" + _i + "_cameraParams, " + penumbraSizeArg + ", dLightDirW";
							}
							if (_lightType === LIGHTTYPE_OMNI) {
								shadowReadMode = "Point" + shadowReadMode;
								if (!pcssShadows) {
									shadowCoordArgs = shadowCoordArgs + ", dLightDirW";
								}
							} else if (_lightType === LIGHTTYPE_SPOT) {
								shadowReadMode = "Spot" + shadowReadMode;
							}
							backend.append("    float shadow" + _i + " = getShadow" + shadowReadMode + "(" + shadowCoordArgs + ");");
							backend.append("    dAtten *= mix(1.0, shadow" + _i + ", light" + _i + "_shadowIntensity);");
						}
					}
					if (_lightShape !== LIGHTSHAPE_PUNCTUAL) {
						if (options.conserveEnergy && options.useSpecular) {
							backend.append("    dDiffuseLight += ((dAttenD * dAtten) * light" + _i + "_color" + (usesCookieNow ? " * dAtten3" : "") + ") * (1.0 - dLTCSpecFres);");
						} else {
							backend.append("    dDiffuseLight += (dAttenD * dAtten) * light" + _i + "_color" + (usesCookieNow ? " * dAtten3" : "") + ";");
						}
					} else {
						if (hasAreaLights && options.conserveEnergy && options.useSpecular) {
							backend.append("    dDiffuseLight += (dAtten * light" + _i + "_color" + (usesCookieNow ? " * dAtten3" : "") + ") * (1.0 - litArgs_specularity);");
						} else {
							backend.append("    dDiffuseLight += dAtten * light" + _i + "_color" + (usesCookieNow ? " * dAtten3" : "") + ";");
						}
					}
					if (options.useSpecular) {
						backend.append("    dHalfDirW = normalize(-dLightDirNormW + dViewDirW);");
					}
					if (_light.affectSpecularity) {
						if (_lightShape !== LIGHTSHAPE_PUNCTUAL) {
							if (options.useClearCoat) {
								backend.append("    ccSpecularLight += ccLTCSpecFres * get" + shapeString + "LightSpecular(litArgs_clearcoat_worldNormal, dViewDirW) * dAtten * light" + _i + "_color" + (usesCookieNow ? " * dAtten3" : "") + ";");
							}
							if (options.useSpecular) {
								backend.append("    dSpecularLight += dLTCSpecFres * get" + shapeString + "LightSpecular(litArgs_worldNormal, dViewDirW) * dAtten * light" + _i + "_color" + (usesCookieNow ? " * dAtten3" : "") + ";");
							}
						} else {
							var calcFresnel = false;
							if (_lightType === LIGHTTYPE_DIRECTIONAL && options.fresnelModel > 0) {
								calcFresnel = true;
							}
							if (options.useClearCoat) {
								backend.append("    ccSpecularLight += getLightSpecular(dHalfDirW, ccReflDirW, litArgs_clearcoat_worldNormal, dViewDirW, dLightDirNormW, litArgs_clearcoat_gloss, dTBN) * dAtten * light" + _i + "_color" + (usesCookieNow ? " * dAtten3" : "") + (calcFresnel ? " * getFresnelCC(dot(dViewDirW, dHalfDirW));" : ";"));
							}
							if (options.useSheen) {
								backend.append("    sSpecularLight += getLightSpecularSheen(dHalfDirW, litArgs_worldNormal, dViewDirW, dLightDirNormW, litArgs_sheen_gloss) * dAtten * light" + _i + "_color" + (usesCookieNow ? " * dAtten3;" : ";"));
							}
							if (options.useSpecular) {
								backend.append("    dSpecularLight += getLightSpecular(dHalfDirW, dReflDirW, litArgs_worldNormal, dViewDirW, dLightDirNormW, litArgs_gloss, dTBN) * dAtten * light" + _i + "_color" + (usesCookieNow ? " * dAtten3" : "") + (calcFresnel ? " \n                                    * getFresnel(\n                                        dot(dViewDirW, dHalfDirW), \n                                        litArgs_gloss, \n                                        litArgs_specularity\n                                    #if defined(LIT_IRIDESCENCE)\n                                        , iridescenceFresnel, \n                                        litArgs_iridescence_intensity\n                                    #endif\n                                    );" : "* litArgs_specularity;"));
							}
						}
					}
					if (_lightType !== LIGHTTYPE_DIRECTIONAL) {
						backend.append("    }");
					}
				}
				if (options.clusteredLightingEnabled && this.lighting) {
					usesLinearFalloff = true;
					usesInvSquaredFalloff = true;
					hasPointLights = true;
					backend.append("    addClusteredLights(\n                                        litArgs_worldNormal, \n                                        dViewDirW, \n                                        dReflDirW,\n                                #if defined(LIT_CLEARCOAT)\n                                        ccReflDirW,\n                                #endif\n                                        litArgs_gloss, \n                                        litArgs_specularity, \n                                        dVertexNormalW, \n                                        dTBN, \n                                #if defined(LIT_IRIDESCENCE)\n                                        iridescenceFresnel,\n                                #endif\n                                        litArgs_clearcoat_worldNormal, \n                                        litArgs_clearcoat_gloss,\n                                        litArgs_sheen_gloss,\n                                        litArgs_iridescence_intensity\n                                    );");
				}
				if (hasAreaLights) {
					if (options.useClearCoat) {
						backend.append("    litArgs_clearcoat_specularity = 1.0;");
					}
					if (options.useSpecular) {
						backend.append("    litArgs_specularity = vec3(1);");
					}
				}
				if (options.useRefraction) {
					backend.append("    addRefraction(\n                        litArgs_worldNormal, \n                        dViewDirW, \n                        litArgs_thickness, \n                        litArgs_gloss, \n                        litArgs_specularity, \n                        litArgs_albedo, \n                        litArgs_transmission,\n                        litArgs_ior\n                    #if defined(LIT_IRIDESCENCE)\n                        , iridescenceFresnel, \n                        litArgs_iridescence_intensity\n                    #endif\n                    );");
				}
			}
			if (options.useAo) {
				if (options.occludeDirect) {
					backend.append("    occludeDiffuse(litArgs_ao);");
				}
				if (options.occludeSpecular === SPECOCC_AO || options.occludeSpecular === SPECOCC_GLOSSDEPENDENT) {
					backend.append("    occludeSpecular(litArgs_gloss, litArgs_ao, litArgs_worldNormal, dViewDirW);");
				}
			}
			if (options.useSpecularityFactor) {
				backend.append("    dSpecularLight *= litArgs_specularityFactor;");
			}
			if (options.opacityFadesSpecular === false) {
				if (options.blendType === BLEND_NORMAL || options.blendType === BLEND_PREMULTIPLIED) {
					backend.append("float specLum = dot((dSpecularLight + dReflection.rgb * dReflection.a), vec3( 0.2126, 0.7152, 0.0722 ));");
					backend.append("#ifdef LIT_CLEARCOAT\n specLum += dot(ccSpecularLight * litArgs_clearcoat_specularity + ccReflection.rgb * litArgs_clearcoat_specularity, vec3( 0.2126, 0.7152, 0.0722 ));\n#endif");
					backend.append("litArgs_opacity = clamp(litArgs_opacity + gammaCorrectInput(specLum), 0.0, 1.0);");
				}
				backend.append("litArgs_opacity *= material_alphaFade;");
			}
			backend.append(chunks.endPS);
			if (options.blendType === BLEND_NORMAL || options.blendType === BLEND_ADDITIVEALPHA || options.alphaToCoverage) {
				backend.append(chunks.outputAlphaPS);
			} else if (options.blendType === BLEND_PREMULTIPLIED) {
				backend.append(chunks.outputAlphaPremulPS);
			} else {
				backend.append(chunks.outputAlphaOpaquePS);
			}
			if (options.useMsdf) {
				backend.append("    gl_FragColor = applyMsdf(gl_FragColor);");
			}
			backend.append(chunks.outputPS);
			backend.append(chunks.debugOutputPS);
			if (hasPointLights) {
				func.prepend(chunks.lightDirPointPS);
			}
			if (usesLinearFalloff) {
				func.prepend(chunks.falloffLinearPS);
			}
			if (usesInvSquaredFalloff) {
				func.prepend(chunks.falloffInvSquaredPS);
			}
			if (usesSpot) {
				func.prepend(chunks.spotPS);
			}
			if (usesCookie && !options.clusteredLightingEnabled) {
				func.prepend(chunks.cookiePS);
			}
			var structCode = "";
			var backendCode = "void evaluateBackend() {\n" + backend.code + "\n}";
			func.append(backendCode);
			code.append(chunks.debugProcessFrontendPS);
			code.append("    evaluateBackend();");
			code.append(end());
			var mergedCode = decl.code + func.code + code.code;
			if (mergedCode.includes("dTBN")) structCode += "mat3 dTBN;\n";
			if (mergedCode.includes("dVertexNormalW")) structCode += "vec3 dVertexNormalW;\n";
			if (mergedCode.includes("dTangentW")) structCode += "vec3 dTangentW;\n";
			if (mergedCode.includes("dBinormalW")) structCode += "vec3 dBinormalW;\n";
			if (mergedCode.includes("dViewDirW")) structCode += "vec3 dViewDirW;\n";
			if (mergedCode.includes("dReflDirW")) structCode += "vec3 dReflDirW;\n";
			if (mergedCode.includes("dHalfDirW")) structCode += "vec3 dHalfDirW;\n";
			if (mergedCode.includes("ccReflDirW")) structCode += "vec3 ccReflDirW;\n";
			if (mergedCode.includes("dLightDirNormW")) structCode += "vec3 dLightDirNormW;\n";
			if (mergedCode.includes("dLightDirW")) structCode += "vec3 dLightDirW;\n";
			if (mergedCode.includes("dLightPosW")) structCode += "vec3 dLightPosW;\n";
			if (mergedCode.includes("dShadowCoord")) structCode += "vec3 dShadowCoord;\n";
			if (mergedCode.includes("dReflection")) structCode += "vec4 dReflection;\n";
			if (mergedCode.includes("dDiffuseLight")) structCode += "vec3 dDiffuseLight;\n";
			if (mergedCode.includes("dSpecularLight")) structCode += "vec3 dSpecularLight;\n";
			if (mergedCode.includes("dAtten")) structCode += "float dAtten;\n";
			if (mergedCode.includes("dAttenD")) structCode += "float dAttenD;\n";
			if (mergedCode.includes("dAtten3")) structCode += "vec3 dAtten3;\n";
			if (mergedCode.includes("dMsdf")) structCode += "vec4 dMsdf;\n";
			if (mergedCode.includes("ccFresnel")) structCode += "float ccFresnel;\n";
			if (mergedCode.includes("ccReflection")) structCode += "vec3 ccReflection;\n";
			if (mergedCode.includes("ccSpecularLight")) structCode += "vec3 ccSpecularLight;\n";
			if (mergedCode.includes("ccSpecularityNoFres")) structCode += "float ccSpecularityNoFres;\n";
			if (mergedCode.includes("sSpecularLight")) structCode += "vec3 sSpecularLight;\n";
			if (mergedCode.includes("sReflection")) structCode += "vec3 sReflection;\n";
			var result = this._fsGetBeginCode() + this.varyings + this.varyingDefines + this._fsGetBaseCode() + structCode + this.frontendDecl + mergedCode;
			return result;
		};
		_proto.generateFragmentShader = function generateFragmentShader(frontendDecl, frontendCode, frontendFunc, lightingUv) {
			var _this$handleCompatibi;
			var options = this.options;
			this.frontendDecl = frontendDecl;
			this.frontendCode = frontendCode;
			this.frontendFunc = frontendFunc;
			this.lightingUv = lightingUv;
			if (options.pass === SHADER_PICK) {
				this.fshader = this._fsGetPickPassCode();
			} else if (options.pass === SHADER_DEPTH) {
				this.fshader = this._fsGetDepthPassCode();
			} else if (this.shadowPass) {
				this.fshader = this._fsGetShadowPassCode();
			} else if (options.customFragmentShader) {
				this.fshader = this._fsGetBeginCode() + options.customFragmentShader;
			} else {
				this.fshader = this._fsGetLitPassCode();
			}
			(_this$handleCompatibi = this.handleCompatibility) == null ? void 0 : _this$handleCompatibi.call(this);
		};
		_proto.getDefinition = function getDefinition() {
			var definition = ShaderUtils.createDefinition(this.device, {
				name: 'LitShader',
				attributes: this.attributes,
				vertexCode: this.vshader,
				fragmentCode: this.fshader
			});
			if (this.shaderPassInfo.isForward) {
				definition.tag = SHADERTAG_MATERIAL;
			}
			return definition;
		};
		return LitShader;
	}();

	var LitOptionsUtils = {
		generateKey: function generateKey(options) {
			return "lit" + Object.keys(options).sort().map(function (key) {
				if (key === "chunks") {
					return LitOptionsUtils.generateChunksKey(options);
				} else if (key === "lights") {
					return LitOptionsUtils.generateLightsKey(options);
				}
				return key + options[key];
			}).join("\n");
		},
		generateLightsKey: function generateLightsKey(options) {
			return 'lights:' + options.lights.map(function (light) {
				return !options.clusteredLightingEnabled || light._type === LIGHTTYPE_DIRECTIONAL ? light.key + "," : '';
			}).join("");
		},
		generateChunksKey: function generateChunksKey(options) {
			var _options$chunks;
			return 'chunks:\n' + Object.keys((_options$chunks = options.chunks) != null ? _options$chunks : {}).sort().map(function (key) {
				return key + options.chunks[key];
			}).join("");
		}
	};

	var dummyUvs = [0, 1, 2, 3, 4, 5, 6, 7];
	var lit = {
		generateKey: function generateKey(options) {
			var key = "lit" + dummyUvs.map(function (dummy, index) {
				return options.usedUvs[index] ? "1" : "0";
			}).join("") + options.shaderChunk + LitOptionsUtils.generateKey(options.litOptions);
			return key;
		},
		createShaderDefinition: function createShaderDefinition(device, options) {
			var litShader = new LitShader(device, options.litOptions);
			var decl = new ChunkBuilder();
			var code = new ChunkBuilder();
			var func = new ChunkBuilder();
			decl.append("uniform float textureBias;");
			decl.append(litShader.chunks.litShaderArgsPS);
			code.append(options.shaderChunk);
			func.code = "evaluateFrontend();";
			func.code = "\n" + func.code.split('\n').map(function (l) {
				return "    " + l;
			}).join('\n') + "\n\n";
			var usedUvSets = options.usedUvs || [true];
			var mapTransforms = [];
			litShader.generateVertexShader(usedUvSets, usedUvSets, mapTransforms);
			litShader.generateFragmentShader(decl.code, code.code, func.code, "vUv0");
			return litShader.getDefinition();
		}
	};

	var options = new LitMaterialOptions();
	var LitMaterial = function (_Material) {
		_inheritsLoose(LitMaterial, _Material);
		function LitMaterial() {
			var _this;
			for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
				args[_key] = arguments[_key];
			}
			_this = _Material.call.apply(_Material, [this].concat(args)) || this;
			_this.usedUvs = [true];
			_this.shaderChunk = 'void evaluateFrontend() {}\n';
			_this.chunks = null;
			_this.useLighting = true;
			_this.useFog = true;
			_this.useGammaTonemap = true;
			_this.useSkybox = true;
			_this.shadingModel = SPECULAR_BLINN;
			_this.ambientSH = null;
			_this.pixelSnap = false;
			_this.nineSlicedMode = null;
			_this.fastTbn = false;
			_this.twoSidedLighting = false;
			_this.occludeDirect = false;
			_this.occludeSpecular = SPECOCC_AO;
			_this.occludeSpecularIntensity = 1;
			_this.opacityFadesSpecular = true;
			_this.conserveEnergy = true;
			_this.ggxSpecular = false;
			_this.fresnelModel = FRESNEL_SCHLICK;
			_this.dynamicRefraction = false;
			_this.hasAo = false;
			_this.hasSpecular = false;
			_this.hasSpecularityFactor = false;
			_this.hasLighting = false;
			_this.hasHeights = false;
			_this.hasNormals = false;
			_this.hasSheen = false;
			_this.hasRefraction = false;
			_this.hasIrridescence = false;
			_this.hasMetalness = false;
			_this.hasClearCoat = false;
			_this.hasClearCoatNormals = false;
			return _this;
		}
		var _proto = LitMaterial.prototype;
		_proto.getShaderVariant = function getShaderVariant(device, scene, objDefs, unused, pass, sortedLights, viewUniformFormat, viewBindGroupFormat, vertexFormat) {
			options.usedUvs = this.usedUvs.slice();
			options.shaderChunk = this.shaderChunk;
			LitMaterialOptionsBuilder.update(options.litOptions, this, scene, objDefs, pass, sortedLights);
			var processingOptions = new ShaderProcessorOptions(viewUniformFormat, viewBindGroupFormat, vertexFormat);
			var library = getProgramLibrary(device);
			library.register('lit', lit);
			var shader = library.getProgram('lit', options, processingOptions, this.userId);
			return shader;
		};
		return LitMaterial;
	}(Material);

	var tempVec3 = new Vec3();
	var tempMin3 = new Vec3();
	var tempMax3 = new Vec3();
	var tempBox = new BoundingBox();
	var epsilon = 0.000001;
	var ClusterLight = function ClusterLight() {
		this.light = null;
		this.min = new Vec3();
		this.max = new Vec3();
	};
	var WorldClusters = function () {
		function WorldClusters(device) {
			this.clusterTexture = void 0;
			this.device = device;
			this.name = 'Untitled';
			this.reportCount = 0;
			this.boundsMin = new Vec3();
			this.boundsMax = new Vec3();
			this.boundsDelta = new Vec3();
			this._cells = new Vec3(1, 1, 1);
			this._cellsLimit = new Vec3();
			this.cells = this._cells;
			this.maxCellLightCount = 4;
			this._maxAttenuation = 0;
			this._maxColorValue = 0;
			this._usedLights = [];
			this._usedLights.push(new ClusterLight());
			this.lightsBuffer = new LightsBuffer(device);
			this.registerUniforms(device);
		}
		var _proto = WorldClusters.prototype;
		_proto.destroy = function destroy() {
			this.lightsBuffer.destroy();
			this.releaseClusterTexture();
		};
		_proto.releaseClusterTexture = function releaseClusterTexture() {
			if (this.clusterTexture) {
				this.clusterTexture.destroy();
				this.clusterTexture = null;
			}
		};
		_proto.registerUniforms = function registerUniforms(device) {
			this._clusterSkipId = device.scope.resolve('clusterSkip');
			this._clusterMaxCellsId = device.scope.resolve('clusterMaxCells');
			this._clusterWorldTextureId = device.scope.resolve('clusterWorldTexture');
			this._clusterTextureSizeId = device.scope.resolve('clusterTextureSize');
			this._clusterTextureSizeData = new Float32Array(3);
			this._clusterBoundsMinId = device.scope.resolve('clusterBoundsMin');
			this._clusterBoundsMinData = new Float32Array(3);
			this._clusterBoundsDeltaId = device.scope.resolve('clusterBoundsDelta');
			this._clusterBoundsDeltaData = new Float32Array(3);
			this._clusterCellsCountByBoundsSizeId = device.scope.resolve('clusterCellsCountByBoundsSize');
			this._clusterCellsCountByBoundsSizeData = new Float32Array(3);
			this._clusterCellsDotId = device.scope.resolve('clusterCellsDot');
			this._clusterCellsDotData = new Float32Array(3);
			this._clusterCellsMaxId = device.scope.resolve('clusterCellsMax');
			this._clusterCellsMaxData = new Float32Array(3);
			this._clusterCompressionLimit0Id = device.scope.resolve('clusterCompressionLimit0');
			this._clusterCompressionLimit0Data = new Float32Array(2);
		};
		_proto.updateParams = function updateParams(lightingParams) {
			if (lightingParams) {
				this.cells = lightingParams.cells;
				this.maxCellLightCount = lightingParams.maxLightsPerCell;
				this.lightsBuffer.cookiesEnabled = lightingParams.cookiesEnabled;
				this.lightsBuffer.shadowsEnabled = lightingParams.shadowsEnabled;
				this.lightsBuffer.areaLightsEnabled = lightingParams.areaLightsEnabled;
			}
		};
		_proto.updateCells = function updateCells() {
			if (this._cellsDirty) {
				this._cellsDirty = false;
				var cx = this._cells.x;
				var cy = this._cells.y;
				var cz = this._cells.z;
				var numCells = cx * cy * cz;
				var totalPixels = this.maxCellLightCount * numCells;
				var width = Math.ceil(Math.sqrt(totalPixels));
				width = math.roundUp(width, this.maxCellLightCount);
				var height = Math.ceil(totalPixels / width);
				this._clusterCellsMaxData[0] = cx;
				this._clusterCellsMaxData[1] = cy;
				this._clusterCellsMaxData[2] = cz;
				this._clusterCellsDotData[0] = this.maxCellLightCount;
				this._clusterCellsDotData[1] = cx * cz * this.maxCellLightCount;
				this._clusterCellsDotData[2] = cx * this.maxCellLightCount;
				this.clusters = new Uint8ClampedArray(totalPixels);
				this.counts = new Int32Array(numCells);
				this._clusterTextureSizeData[0] = width;
				this._clusterTextureSizeData[1] = 1.0 / width;
				this._clusterTextureSizeData[2] = 1.0 / height;
				this.releaseClusterTexture();
				this.clusterTexture = LightsBuffer.createTexture(this.device, width, height, PIXELFORMAT_L8, 'ClusterTexture');
			}
		};
		_proto.uploadTextures = function uploadTextures() {
			this.clusterTexture.lock().set(this.clusters);
			this.clusterTexture.unlock();
			this.lightsBuffer.uploadTextures();
		};
		_proto.updateUniforms = function updateUniforms() {
			this._clusterSkipId.setValue(this._usedLights.length > 1 ? 0 : 1);
			this.lightsBuffer.updateUniforms();
			this._clusterWorldTextureId.setValue(this.clusterTexture);
			this._clusterMaxCellsId.setValue(this.maxCellLightCount);
			var boundsDelta = this.boundsDelta;
			this._clusterCellsCountByBoundsSizeData[0] = this._cells.x / boundsDelta.x;
			this._clusterCellsCountByBoundsSizeData[1] = this._cells.y / boundsDelta.y;
			this._clusterCellsCountByBoundsSizeData[2] = this._cells.z / boundsDelta.z;
			this._clusterCellsCountByBoundsSizeId.setValue(this._clusterCellsCountByBoundsSizeData);
			this._clusterBoundsMinData[0] = this.boundsMin.x;
			this._clusterBoundsMinData[1] = this.boundsMin.y;
			this._clusterBoundsMinData[2] = this.boundsMin.z;
			this._clusterBoundsDeltaData[0] = boundsDelta.x;
			this._clusterBoundsDeltaData[1] = boundsDelta.y;
			this._clusterBoundsDeltaData[2] = boundsDelta.z;
			this._clusterCompressionLimit0Data[0] = this._maxAttenuation;
			this._clusterCompressionLimit0Data[1] = this._maxColorValue;
			this._clusterTextureSizeId.setValue(this._clusterTextureSizeData);
			this._clusterBoundsMinId.setValue(this._clusterBoundsMinData);
			this._clusterBoundsDeltaId.setValue(this._clusterBoundsDeltaData);
			this._clusterCellsDotId.setValue(this._clusterCellsDotData);
			this._clusterCellsMaxId.setValue(this._clusterCellsMaxData);
			this._clusterCompressionLimit0Id.setValue(this._clusterCompressionLimit0Data);
		};
		_proto.evalLightCellMinMax = function evalLightCellMinMax(clusteredLight, min, max) {
			min.copy(clusteredLight.min);
			min.sub(this.boundsMin);
			min.div(this.boundsDelta);
			min.mul2(min, this.cells);
			min.floor();
			max.copy(clusteredLight.max);
			max.sub(this.boundsMin);
			max.div(this.boundsDelta);
			max.mul2(max, this.cells);
			max.ceil();
			min.max(Vec3.ZERO);
			max.min(this._cellsLimit);
		};
		_proto.collectLights = function collectLights(lights) {
			var maxLights = this.lightsBuffer.maxLights;
			var usedLights = this._usedLights;
			var lightIndex = 1;
			lights.forEach(function (light) {
				var runtimeLight = !!(light.mask & (MASK_AFFECT_DYNAMIC | MASK_AFFECT_LIGHTMAPPED));
				var zeroAngleSpotlight = light.type === LIGHTTYPE_SPOT && light._outerConeAngle === 0;
				if (light.enabled && light.type !== LIGHTTYPE_DIRECTIONAL && light.visibleThisFrame && light.intensity > 0 && runtimeLight && !zeroAngleSpotlight) {
					if (lightIndex < maxLights) {
						var clusteredLight;
						if (lightIndex < usedLights.length) {
							clusteredLight = usedLights[lightIndex];
						} else {
							clusteredLight = new ClusterLight();
							usedLights.push(clusteredLight);
						}
						clusteredLight.light = light;
						light.getBoundingBox(tempBox);
						clusteredLight.min.copy(tempBox.getMin());
						clusteredLight.max.copy(tempBox.getMax());
						lightIndex++;
					}
				}
			});
			usedLights.length = lightIndex;
		};
		_proto.evaluateBounds = function evaluateBounds() {
			var usedLights = this._usedLights;
			var min = this.boundsMin;
			var max = this.boundsMax;
			if (usedLights.length > 1) {
				min.copy(usedLights[1].min);
				max.copy(usedLights[1].max);
				for (var i = 2; i < usedLights.length; i++) {
					min.min(usedLights[i].min);
					max.max(usedLights[i].max);
				}
			} else {
				min.set(0, 0, 0);
				max.set(1, 1, 1);
			}
			this.boundsDelta.sub2(max, min);
			this.lightsBuffer.setBounds(min, this.boundsDelta);
		};
		_proto.evaluateCompressionLimits = function evaluateCompressionLimits(gammaCorrection) {
			var maxAttenuation = 0;
			var maxColorValue = 0;
			var usedLights = this._usedLights;
			for (var i = 1; i < usedLights.length; i++) {
				var light = usedLights[i].light;
				maxAttenuation = Math.max(light.attenuationEnd, maxAttenuation);
				var color = gammaCorrection ? light._linearFinalColor : light._finalColor;
				maxColorValue = Math.max(color[0], maxColorValue);
				maxColorValue = Math.max(color[1], maxColorValue);
				maxColorValue = Math.max(color[2], maxColorValue);
			}
			this._maxAttenuation = maxAttenuation + epsilon;
			this._maxColorValue = maxColorValue + epsilon;
			this.lightsBuffer.setCompressionRanges(this._maxAttenuation, this._maxColorValue);
		};
		_proto.updateClusters = function updateClusters(gammaCorrection) {
			this.counts.fill(0);
			this.clusters.fill(0);
			var divX = this._cells.x;
			var divZ = this._cells.z;
			var counts = this.counts;
			var limit = this._maxCellLightCount;
			var clusters = this.clusters;
			var pixelsPerCellCount = this.maxCellLightCount;
			var usedLights = this._usedLights;
			for (var i = 1; i < usedLights.length; i++) {
				var clusteredLight = usedLights[i];
				var light = clusteredLight.light;
				this.lightsBuffer.addLightData(light, i, gammaCorrection);
				this.evalLightCellMinMax(clusteredLight, tempMin3, tempMax3);
				var xStart = tempMin3.x;
				var xEnd = tempMax3.x;
				var yStart = tempMin3.y;
				var yEnd = tempMax3.y;
				var zStart = tempMin3.z;
				var zEnd = tempMax3.z;
				for (var x = xStart; x <= xEnd; x++) {
					for (var z = zStart; z <= zEnd; z++) {
						for (var y = yStart; y <= yEnd; y++) {
							var clusterIndex = x + divX * (z + y * divZ);
							var count = counts[clusterIndex];
							if (count < limit) {
								clusters[pixelsPerCellCount * clusterIndex + count] = i;
								counts[clusterIndex] = count + 1;
							}
						}
					}
				}
			}
		};
		_proto.update = function update(lights, gammaCorrection, lightingParams) {
			this.updateParams(lightingParams);
			this.updateCells();
			this.collectLights(lights);
			this.evaluateBounds();
			this.evaluateCompressionLimits(gammaCorrection);
			this.updateClusters(gammaCorrection);
			this.uploadTextures();
		};
		_proto.activate = function activate() {
			this.updateUniforms();
		};
		_createClass(WorldClusters, [{
			key: "maxCellLightCount",
			get: function get() {
				return this._maxCellLightCount;
			},
			set: function set(count) {
				if (count !== this._maxCellLightCount) {
					this._maxCellLightCount = count;
					this._cellsDirty = true;
				}
			}
		}, {
			key: "cells",
			get: function get() {
				return this._cells;
			},
			set: function set(value) {
				tempVec3.copy(value).floor();
				if (!this._cells.equals(tempVec3)) {
					this._cells.copy(tempVec3);
					this._cellsLimit.copy(tempVec3).sub(Vec3.ONE);
					this._cellsDirty = true;
				}
			}
		}]);
		return WorldClusters;
	}();

	var textureBlitVertexShader = "\n    attribute vec2 vertex_position;\n    varying vec2 uv0;\n    void main(void) {\n        gl_Position = vec4(vertex_position, 0.5, 1.0);\n        uv0 = vertex_position.xy * 0.5 + 0.5;\n        #ifndef WEBGPU\n            uv0.y = 1.0 - uv0.y;\n        #endif\n    }";
	var textureBlitFragmentShader = "\n    varying vec2 uv0;\n    uniform sampler2D blitTexture;\n    void main(void) {\n        gl_FragColor = texture2D(blitTexture, uv0);\n    }";
	var textureCubeBlitFragmentShader = "\n    varying vec2 uv0;\n    uniform samplerCube blitTexture;\n    uniform mat4 invViewProj;\n    void main(void) {\n        vec4 projPos = vec4(uv0 * 2.0 - 1.0, 0.5, 1.0);\n        vec4 worldPos = invViewProj * projPos;\n        gl_FragColor = textureCube(blitTexture, worldPos.xyz);\n    }";
	var _viewport$3 = new Vec4();
	var CookieRenderer = function () {
		function CookieRenderer(device, lightTextureAtlas) {
			this.device = device;
			this.lightTextureAtlas = lightTextureAtlas;
			this.blitShader2d = null;
			this.blitShaderCube = null;
			this.blitTextureId = null;
			this.invViewProjId = null;
		}
		var _proto = CookieRenderer.prototype;
		_proto.destroy = function destroy() {};
		_proto.getShader = function getShader(shader, fragment) {
			if (!this[shader]) this[shader] = createShaderFromCode(this.device, textureBlitVertexShader, fragment, "cookie_renderer_" + shader);
			if (!this.blitTextureId) this.blitTextureId = this.device.scope.resolve('blitTexture');
			if (!this.invViewProjId) this.invViewProjId = this.device.scope.resolve('invViewProj');
			return this[shader];
		};
		CookieRenderer.createTexture = function createTexture(device, resolution) {
			var texture = new Texture(device, {
				name: 'CookieAtlas',
				width: resolution,
				height: resolution,
				format: PIXELFORMAT_RGBA8,
				cubemap: false,
				mipmaps: false,
				minFilter: FILTER_NEAREST,
				magFilter: FILTER_NEAREST,
				addressU: ADDRESS_CLAMP_TO_EDGE,
				addressV: ADDRESS_CLAMP_TO_EDGE
			});
			return texture;
		};
		_proto.initInvViewProjMatrices = function initInvViewProjMatrices() {
			if (!CookieRenderer._invViewProjMatrices) {
				CookieRenderer._invViewProjMatrices = [];
				for (var face = 0; face < 6; face++) {
					var camera = LightCamera.create(null, LIGHTTYPE_OMNI, face);
					var projMat = camera.projectionMatrix;
					var viewMat = camera.node.getLocalTransform().clone().invert();
					CookieRenderer._invViewProjMatrices[face] = new Mat4().mul2(projMat, viewMat).invert();
				}
			}
		};
		_proto.render = function render(light, renderTarget) {
			if (light.enabled && light.cookie && light.visibleThisFrame) {
				var faceCount = light.numShadowFaces;
				var shader = faceCount > 1 ? this.shaderCube : this.shader2d;
				var device = this.device;
				if (faceCount > 1) {
					this.initInvViewProjMatrices();
				}
				this.blitTextureId.setValue(light.cookie);
				device.setBlendState(BlendState.NOBLEND);
				for (var face = 0; face < faceCount; face++) {
					_viewport$3.copy(light.atlasViewport);
					if (faceCount > 1) {
						var smallSize = _viewport$3.z / 3;
						var offset = this.lightTextureAtlas.cubeSlotsOffsets[face];
						_viewport$3.x += smallSize * offset.x;
						_viewport$3.y += smallSize * offset.y;
						_viewport$3.z = smallSize;
						_viewport$3.w = smallSize;
						this.invViewProjId.setValue(CookieRenderer._invViewProjMatrices[face].data);
					}
					_viewport$3.mulScalar(renderTarget.colorBuffer.width);
					drawQuadWithShader(device, renderTarget, shader, _viewport$3);
				}
			}
		};
		_createClass(CookieRenderer, [{
			key: "shader2d",
			get: function get() {
				return this.getShader('blitShader2d', textureBlitFragmentShader);
			}
		}, {
			key: "shaderCube",
			get: function get() {
				return this.getShader('blitShaderCube', textureCubeBlitFragmentShader);
			}
		}]);
		return CookieRenderer;
	}();
	CookieRenderer._invViewProjMatrices = null;

	var ShadowMap = function () {
		function ShadowMap(texture, targets) {
			this.texture = texture;
			this.cached = false;
			this.renderTargets = targets;
		}
		var _proto = ShadowMap.prototype;
		_proto.destroy = function destroy() {
			if (this.texture) {
				this.texture.destroy();
				this.texture = null;
			}
			var targets = this.renderTargets;
			for (var i = 0; i < targets.length; i++) {
				targets[i].destroy();
			}
			this.renderTargets.length = 0;
		};
		ShadowMap.getShadowFormat = function getShadowFormat(device, shadowType) {
			if (shadowType === SHADOW_VSM32) {
				return PIXELFORMAT_RGBA32F;
			} else if (shadowType === SHADOW_VSM16) {
				return PIXELFORMAT_RGBA16F;
			} else if (shadowType === SHADOW_PCF5) {
				return PIXELFORMAT_DEPTH;
			} else if ((shadowType === SHADOW_PCF1 || shadowType === SHADOW_PCF3) && device.supportsDepthShadow) {
				return PIXELFORMAT_DEPTH;
			} else if (shadowType === SHADOW_PCSS && (device.webgl2 || device.isWebGPU)) {
				return PIXELFORMAT_R32F;
			}
			return PIXELFORMAT_RGBA8;
		};
		ShadowMap.getShadowFiltering = function getShadowFiltering(device, shadowType) {
			if ((shadowType === SHADOW_PCF1 || shadowType === SHADOW_PCF3 || shadowType === SHADOW_PCSS) && !device.supportsDepthShadow) {
				return FILTER_NEAREST;
			} else if (shadowType === SHADOW_VSM32) {
				return device.extTextureFloatLinear ? FILTER_LINEAR : FILTER_NEAREST;
			} else if (shadowType === SHADOW_VSM16) {
				return device.extTextureHalfFloatLinear ? FILTER_LINEAR : FILTER_NEAREST;
			}
			return FILTER_LINEAR;
		};
		ShadowMap.create = function create(device, light) {
			var shadowMap = null;
			if (light._type === LIGHTTYPE_OMNI) {
				shadowMap = this.createCubemap(device, light._shadowResolution, light._shadowType);
			} else {
				shadowMap = this.create2dMap(device, light._shadowResolution, light._shadowType);
			}
			return shadowMap;
		};
		ShadowMap.createAtlas = function createAtlas(device, resolution, shadowType) {
			var shadowMap = this.create2dMap(device, resolution, shadowType);
			var targets = shadowMap.renderTargets;
			var rt = targets[0];
			for (var i = 0; i < 5; i++) {
				targets.push(rt);
			}
			return shadowMap;
		};
		ShadowMap.create2dMap = function create2dMap(device, size, shadowType) {
			var format = this.getShadowFormat(device, shadowType);
			var filter = this.getShadowFiltering(device, shadowType);
			var texture = new Texture(device, {
				format: format,
				width: size,
				height: size,
				mipmaps: false,
				minFilter: filter,
				magFilter: filter,
				addressU: ADDRESS_CLAMP_TO_EDGE,
				addressV: ADDRESS_CLAMP_TO_EDGE,
				name: 'ShadowMap2D'
			});
			var target = null;
			if (shadowType === SHADOW_PCF5 || (shadowType === SHADOW_PCF1 || shadowType === SHADOW_PCF3) && device.supportsDepthShadow) {
				texture.compareOnRead = true;
				texture.compareFunc = FUNC_LESS;
				target = new RenderTarget({
					depthBuffer: texture
				});
			} else {
				target = new RenderTarget({
					colorBuffer: texture,
					depth: true
				});
			}
			if (device.isWebGPU) {
				target.flipY = true;
			}
			return new ShadowMap(texture, [target]);
		};
		ShadowMap.createCubemap = function createCubemap(device, size, shadowType) {
			var format = shadowType === SHADOW_PCSS && (device.webgl2 || device.isWebGPU) ? PIXELFORMAT_R32F : PIXELFORMAT_RGBA8;
			var cubemap = new Texture(device, {
				format: format,
				width: size,
				height: size,
				cubemap: true,
				mipmaps: false,
				minFilter: FILTER_NEAREST,
				magFilter: FILTER_NEAREST,
				addressU: ADDRESS_CLAMP_TO_EDGE,
				addressV: ADDRESS_CLAMP_TO_EDGE,
				name: 'ShadowMapCube'
			});
			var targets = [];
			for (var i = 0; i < 6; i++) {
				var target = new RenderTarget({
					colorBuffer: cubemap,
					face: i,
					depth: true
				});
				targets.push(target);
			}
			return new ShadowMap(cubemap, targets);
		};
		return ShadowMap;
	}();

	var _tempArray = [];
	var _tempArray2 = [];
	var _viewport$2 = new Vec4();
	var _scissor = new Vec4();
	var Slot = function Slot(rect) {
		this.size = Math.floor(rect.w * 1024);
		this.used = false;
		this.lightId = -1;
		this.rect = rect;
	};
	var LightTextureAtlas = function () {
		function LightTextureAtlas(device) {
			this.device = device;
			this.version = 1;
			this.shadowAtlasResolution = 2048;
			this.shadowAtlas = null;
			this.shadowEdgePixels = 3;
			this.cookieAtlasResolution = 2048;
			this.cookieAtlas = null;
			this.cookieRenderTarget = null;
			this.slots = [];
			this.atlasSplit = [];
			this.cubeSlotsOffsets = [new Vec2(0, 0), new Vec2(0, 1), new Vec2(1, 0), new Vec2(1, 1), new Vec2(2, 0), new Vec2(2, 1)];
			this.scissorVec = new Vec4();
			this.allocateShadowAtlas(1);
			this.allocateCookieAtlas(1);
			this.allocateUniforms();
		}
		var _proto = LightTextureAtlas.prototype;
		_proto.destroy = function destroy() {
			this.destroyShadowAtlas();
			this.destroyCookieAtlas();
		};
		_proto.destroyShadowAtlas = function destroyShadowAtlas() {
			if (this.shadowAtlas) {
				this.shadowAtlas.destroy();
				this.shadowAtlas = null;
			}
		};
		_proto.destroyCookieAtlas = function destroyCookieAtlas() {
			if (this.cookieAtlas) {
				this.cookieAtlas.destroy();
				this.cookieAtlas = null;
			}
			if (this.cookieRenderTarget) {
				this.cookieRenderTarget.destroy();
				this.cookieRenderTarget = null;
			}
		};
		_proto.allocateShadowAtlas = function allocateShadowAtlas(resolution) {
			if (!this.shadowAtlas || this.shadowAtlas.texture.width !== resolution) {
				this.version++;
				this.destroyShadowAtlas();
				this.shadowAtlas = ShadowMap.createAtlas(this.device, resolution, SHADOW_PCF3);
				this.shadowAtlas.cached = true;
				var scissorOffset = 4 / this.shadowAtlasResolution;
				this.scissorVec.set(scissorOffset, scissorOffset, -2 * scissorOffset, -2 * scissorOffset);
			}
		};
		_proto.allocateCookieAtlas = function allocateCookieAtlas(resolution) {
			if (!this.cookieAtlas || this.cookieAtlas.width !== resolution) {
				this.version++;
				this.destroyCookieAtlas();
				this.cookieAtlas = CookieRenderer.createTexture(this.device, resolution);
				this.cookieRenderTarget = new RenderTarget({
					colorBuffer: this.cookieAtlas,
					depth: false,
					flipY: true
				});
			}
		};
		_proto.allocateUniforms = function allocateUniforms() {
			this._shadowAtlasTextureId = this.device.scope.resolve('shadowAtlasTexture');
			this._shadowAtlasParamsId = this.device.scope.resolve('shadowAtlasParams');
			this._shadowAtlasParams = new Float32Array(2);
			this._cookieAtlasTextureId = this.device.scope.resolve('cookieAtlasTexture');
		};
		_proto.updateUniforms = function updateUniforms() {
			var isShadowFilterPcf = true;
			var rt = this.shadowAtlas.renderTargets[0];
			var isDepthShadow = (this.device.isWebGPU || this.device.webgl2) && isShadowFilterPcf;
			var shadowBuffer = isDepthShadow ? rt.depthBuffer : rt.colorBuffer;
			this._shadowAtlasTextureId.setValue(shadowBuffer);
			this._shadowAtlasParams[0] = this.shadowAtlasResolution;
			this._shadowAtlasParams[1] = this.shadowEdgePixels;
			this._shadowAtlasParamsId.setValue(this._shadowAtlasParams);
			this._cookieAtlasTextureId.setValue(this.cookieAtlas);
		};
		_proto.subdivide = function subdivide(numLights, lightingParams) {
			var atlasSplit = lightingParams.atlasSplit;
			if (!atlasSplit) {
				var gridSize = Math.ceil(Math.sqrt(numLights));
				atlasSplit = _tempArray2;
				atlasSplit[0] = gridSize;
				atlasSplit.length = 1;
			}
			var arraysEqual = function arraysEqual(a, b) {
				return a.length === b.length && a.every(function (v, i) {
					return v === b[i];
				});
			};
			if (!arraysEqual(atlasSplit, this.atlasSplit)) {
				var _this$atlasSplit;
				this.version++;
				this.slots.length = 0;
				this.atlasSplit.length = 0;
				(_this$atlasSplit = this.atlasSplit).push.apply(_this$atlasSplit, atlasSplit);
				var splitCount = this.atlasSplit[0];
				if (splitCount > 1) {
					var invSize = 1 / splitCount;
					for (var i = 0; i < splitCount; i++) {
						for (var j = 0; j < splitCount; j++) {
							var rect = new Vec4(i * invSize, j * invSize, invSize, invSize);
							var nextLevelSplit = this.atlasSplit[1 + i * splitCount + j];
							if (nextLevelSplit > 1) {
								for (var x = 0; x < nextLevelSplit; x++) {
									for (var y = 0; y < nextLevelSplit; y++) {
										var invSizeNext = invSize / nextLevelSplit;
										var rectNext = new Vec4(rect.x + x * invSizeNext, rect.y + y * invSizeNext, invSizeNext, invSizeNext);
										this.slots.push(new Slot(rectNext));
									}
								}
							} else {
								this.slots.push(new Slot(rect));
							}
						}
					}
				} else {
					this.slots.push(new Slot(new Vec4(0, 0, 1, 1)));
				}
				this.slots.sort(function (a, b) {
					return b.size - a.size;
				});
			}
		};
		_proto.collectLights = function collectLights(spotLights, omniLights, lightingParams) {
			var cookiesEnabled = lightingParams.cookiesEnabled;
			var shadowsEnabled = lightingParams.shadowsEnabled;
			var needsShadowAtlas = false;
			var needsCookieAtlas = false;
			var lights = _tempArray;
			lights.length = 0;
			var processLights = function processLights(list) {
				for (var i = 0; i < list.length; i++) {
					var light = list[i];
					if (light.visibleThisFrame) {
						var lightShadow = shadowsEnabled && light.castShadows;
						var lightCookie = cookiesEnabled && !!light.cookie;
						needsShadowAtlas || (needsShadowAtlas = lightShadow);
						needsCookieAtlas || (needsCookieAtlas = lightCookie);
						if (lightShadow || lightCookie) {
							lights.push(light);
						}
					}
				}
			};
			if (cookiesEnabled || shadowsEnabled) {
				processLights(spotLights);
				processLights(omniLights);
			}
			lights.sort(function (a, b) {
				return b.maxScreenSize - a.maxScreenSize;
			});
			if (needsShadowAtlas) {
				this.allocateShadowAtlas(this.shadowAtlasResolution);
			}
			if (needsCookieAtlas) {
				this.allocateCookieAtlas(this.cookieAtlasResolution);
			}
			if (needsShadowAtlas || needsCookieAtlas) {
				this.subdivide(lights.length, lightingParams);
			}
			return lights;
		};
		_proto.setupSlot = function setupSlot(light, rect) {
			light.atlasViewport.copy(rect);
			var faceCount = light.numShadowFaces;
			for (var face = 0; face < faceCount; face++) {
				if (light.castShadows || light._cookie) {
					_viewport$2.copy(rect);
					_scissor.copy(rect);
					if (light._type === LIGHTTYPE_SPOT) {
						_viewport$2.add(this.scissorVec);
					}
					if (light._type === LIGHTTYPE_OMNI) {
						var smallSize = _viewport$2.z / 3;
						var offset = this.cubeSlotsOffsets[face];
						_viewport$2.x += smallSize * offset.x;
						_viewport$2.y += smallSize * offset.y;
						_viewport$2.z = smallSize;
						_viewport$2.w = smallSize;
						_scissor.copy(_viewport$2);
					}
					if (light.castShadows) {
						var lightRenderData = light.getRenderData(null, face);
						lightRenderData.shadowViewport.copy(_viewport$2);
						lightRenderData.shadowScissor.copy(_scissor);
					}
				}
			}
		};
		_proto.assignSlot = function assignSlot(light, slotIndex, slotReassigned) {
			light.atlasViewportAllocated = true;
			var slot = this.slots[slotIndex];
			slot.lightId = light.id;
			slot.used = true;
			if (slotReassigned) {
				light.atlasSlotUpdated = true;
				light.atlasVersion = this.version;
				light.atlasSlotIndex = slotIndex;
			}
		};
		_proto.update = function update(spotLights, omniLights, lightingParams) {
			this.shadowAtlasResolution = lightingParams.shadowAtlasResolution;
			this.cookieAtlasResolution = lightingParams.cookieAtlasResolution;
			var lights = this.collectLights(spotLights, omniLights, lightingParams);
			if (lights.length > 0) {
				var slots = this.slots;
				for (var i = 0; i < slots.length; i++) {
					slots[i].used = false;
				}
				var assignCount = Math.min(lights.length, slots.length);
				for (var _i = 0; _i < assignCount; _i++) {
					var light = lights[_i];
					if (light.castShadows) light._shadowMap = this.shadowAtlas;
					var previousSlot = slots[light.atlasSlotIndex];
					if (light.atlasVersion === this.version && light.id === (previousSlot == null ? void 0 : previousSlot.lightId)) {
						var _previousSlot = slots[light.atlasSlotIndex];
						if (_previousSlot.size === slots[_i].size && !_previousSlot.used) {
							this.assignSlot(light, light.atlasSlotIndex, false);
						}
					}
				}
				var usedCount = 0;
				for (var _i2 = 0; _i2 < assignCount; _i2++) {
					while (usedCount < slots.length && slots[usedCount].used) usedCount++;
					var _light = lights[_i2];
					if (!_light.atlasViewportAllocated) {
						this.assignSlot(_light, usedCount, true);
					}
					var slot = slots[_light.atlasSlotIndex];
					this.setupSlot(_light, slot.rect);
				}
			}
			this.updateUniforms();
		};
		return LightTextureAtlas;
	}();

	var ShadowMapCache = function () {
		function ShadowMapCache() {
			this.cache = new Map();
		}
		var _proto = ShadowMapCache.prototype;
		_proto.destroy = function destroy() {
			this.clear();
			this.cache = null;
		};
		_proto.clear = function clear() {
			this.cache.forEach(function (shadowMaps) {
				shadowMaps.forEach(function (shadowMap) {
					shadowMap.destroy();
				});
			});
			this.cache.clear();
		};
		_proto.getKey = function getKey(light) {
			var isCubeMap = light._type === LIGHTTYPE_OMNI;
			var shadowType = light._shadowType;
			var resolution = light._shadowResolution;
			return isCubeMap + "-" + shadowType + "-" + resolution;
		};
		_proto.get = function get(device, light) {
			var key = this.getKey(light);
			var shadowMaps = this.cache.get(key);
			if (shadowMaps && shadowMaps.length) {
				return shadowMaps.pop();
			}
			var shadowMap = ShadowMap.create(device, light);
			shadowMap.cached = true;
			return shadowMap;
		};
		_proto.add = function add(light, shadowMap) {
			var key = this.getKey(light);
			var shadowMaps = this.cache.get(key);
			if (shadowMaps) {
				shadowMaps.push(shadowMap);
			} else {
				this.cache.set(key, [shadowMap]);
			}
		};
		return ShadowMapCache;
	}();

	var ShadowRendererLocal = function () {
		function ShadowRendererLocal(renderer, shadowRenderer) {
			this.shadowLights = [];
			this.renderer = void 0;
			this.shadowRenderer = void 0;
			this.device = void 0;
			this.renderer = renderer;
			this.shadowRenderer = shadowRenderer;
			this.device = renderer.device;
		}
		var _proto = ShadowRendererLocal.prototype;
		_proto.cull = function cull(light, drawCalls) {
			var isClustered = this.renderer.scene.clusteredLightingEnabled;
			light.visibleThisFrame = true;
			if (!isClustered) {
				if (!light._shadowMap) {
					light._shadowMap = ShadowMap.create(this.device, light);
				}
			}
			var type = light._type;
			var faceCount = type === LIGHTTYPE_SPOT ? 1 : 6;
			for (var face = 0; face < faceCount; face++) {
				var lightRenderData = light.getRenderData(null, face);
				var shadowCam = lightRenderData.shadowCamera;
				shadowCam.nearClip = light.attenuationEnd / 1000;
				shadowCam.farClip = light.attenuationEnd;
				lightRenderData.depthRangeCompensation = shadowCam.farClip - shadowCam.nearClip;
				var shadowCamNode = shadowCam._node;
				var lightNode = light._node;
				shadowCamNode.setPosition(lightNode.getPosition());
				if (type === LIGHTTYPE_SPOT) {
					shadowCam.fov = light._outerConeAngle * 2;
					shadowCamNode.setRotation(lightNode.getRotation());
					shadowCamNode.rotateLocal(-90, 0, 0);
				} else if (type === LIGHTTYPE_OMNI) {
					if (isClustered) {
						var tileSize = this.shadowRenderer.lightTextureAtlas.shadowAtlasResolution * light.atlasViewport.z / 3;
						var texelSize = 2 / tileSize;
						var filterSize = texelSize * this.shadowRenderer.lightTextureAtlas.shadowEdgePixels;
						shadowCam.fov = Math.atan(1 + filterSize) * math.RAD_TO_DEG * 2;
					} else {
						shadowCam.fov = 90;
					}
				}
				this.renderer.updateCameraFrustum(shadowCam);
				this.shadowRenderer.cullShadowCasters(drawCalls, lightRenderData.visibleCasters, shadowCam);
			}
		};
		_proto.prepareLights = function prepareLights(shadowLights, lights) {
			var shadowCamera;
			for (var i = 0; i < lights.length; i++) {
				var light = lights[i];
				if (this.shadowRenderer.needsShadowRendering(light) && light.atlasViewportAllocated) {
					shadowLights.push(light);
					for (var face = 0; face < light.numShadowFaces; face++) {
						shadowCamera = this.shadowRenderer.prepareFace(light, null, face);
					}
				}
			}
			return shadowCamera;
		};
		_proto.prepareClusteredRenderPass = function prepareClusteredRenderPass(renderPass, lightsSpot, lightsOmni) {
			var _this = this;
			var shadowLights = this.shadowLights;
			var shadowCamSpot = this.prepareLights(shadowLights, lightsSpot);
			var shadowCamOmni = this.prepareLights(shadowLights, lightsOmni);
			var shadowCamera = shadowCamSpot != null ? shadowCamSpot : shadowCamOmni;
			var count = shadowLights.length;
			if (count) {
				this.shadowRenderer.setupRenderPass(renderPass, shadowCamera, false);
				renderPass.execute = function () {
					for (var i = 0; i < count; i++) {
						var light = shadowLights[i];
						for (var face = 0; face < light.numShadowFaces; face++) {
							_this.shadowRenderer.renderFace(light, null, face, true);
						}
					}
					shadowLights.length = 0;
				};
			}
		};
		_proto.setupNonClusteredFaceRenderPass = function setupNonClusteredFaceRenderPass(frameGraph, light, face, applyVsm) {
			var _this2 = this;
			var shadowCamera = this.shadowRenderer.prepareFace(light, null, face);
			var renderPass = new RenderPass(this.device, function () {
				_this2.shadowRenderer.renderFace(light, null, face, false);
			});
			this.shadowRenderer.setupRenderPass(renderPass, shadowCamera, true);
			if (applyVsm) {
				renderPass.after = function () {
					_this2.shadowRenderer.renderVsm(light, shadowCamera);
				};
			}
			frameGraph.addRenderPass(renderPass);
		};
		_proto.buildNonClusteredRenderPasses = function buildNonClusteredRenderPasses(frameGraph, lightsSpot, lightsOmni) {
			for (var i = 0; i < lightsSpot.length; i++) {
				var light = lightsSpot[i];
				if (this.shadowRenderer.needsShadowRendering(light)) {
					this.setupNonClusteredFaceRenderPass(frameGraph, light, 0, true);
				}
			}
			for (var _i = 0; _i < lightsOmni.length; _i++) {
				var _light = lightsOmni[_i];
				if (this.shadowRenderer.needsShadowRendering(_light)) {
					var faceCount = _light.numShadowFaces;
					for (var face = 0; face < faceCount; face++) {
						this.setupNonClusteredFaceRenderPass(frameGraph, _light, face, false);
					}
				}
			}
		};
		return ShadowRendererLocal;
	}();

	var visibleSceneAabb = new BoundingBox();
	var center = new Vec3();
	var shadowCamView$1 = new 