; Initial register state
;
; A  = 0CH	; cassette control bits
; HL = 12D4H	; start address
; BC = 0000H	; left zero from ldir
; DE = 1309H	; end address

	ORG	12D4H

	CALL	0F003H
	DEFB	23H	; call system routine "OSTR"
	DB	1BH,'0\\O/\r\n',0

	LD	C,D	; number of rows

ROW_LOOP:

	LD	B,D	; number of columns

COLUMN_LOOP:

	LD	H,' '	; initial character
	LD	L,'-'	; line character
	LD	A,C	; check row
	CALL	CHECK

	LD	H,L	; initial character
	LD	L,'!'	; line character

	JR	NZ,NO_CROSS

	LD	L,'+'	; lines cross

NO_CROSS:

	LD	A,B	; check column
	CALL	CHECK

	LD	A,L
	CALL	0E329H	; call system routine "CRT"

	DJNZ	COLUMN_LOOP

	CALL	0F36BH	; call system routine "CRLF"

	DEC	C
	JR	NZ,ROW_LOOP

	; return to system further below

; Set zero flag on match.
; Resets otherwise line character to initial value.
;
; Params:
;
; H = initial character
; L = line character
; A = column or row position
;
CHECK:

	SUB	E	; A = A - 9
	JR	NC,CHECK

	CP	-8	; pos 1, 10, 19?
	RET	Z

	LD	L,H	; reset to initial character

	RET
