; VCCC64 https://logiker.com/Vintage-Computing-Christmas-Challenge-2024
; C64 assembler by JoeyC64 - 99 bytes

    processor 6502    
	.org	$1000
	
ZP_REPEAT  .equ $f7 
ZP_X       .equ $f8
	
Christmas:
    tax                 ; accu always zero (after reboot) (save 1 byte instead of ldx #0)
    stx ZP_X
    
christ0
    ldy #8
    sty ZP_REPEAT

christ1
    lda data,x
    beq parse2            ; END! (akku is zero, important for multiple calls of this prg)
    pha
    stx ZP_X
    jsr parse
    ldx ZP_X
    inx
    pla
    bpl christ1     ; accu positive? Then NO repeat required
    
    dec ZP_REPEAT   ; REPEAT cnt finished?
    beq christ0     ; yes, initialize
                    ; no, repeat last 6 bytes
    txa
    ;sec            ; carry at this point is always clear, save 1 byte
    sbc #6-1        ; so take this into account
    tax
    bne christ1
    ; NEVER reached
    
parse:
    pha
    and #%00111000  ; get number of repeats
    lsr
    lsr
    lsr
    tax
    pla
    and #%00000111  ; get character index
    tay
    lda chars,y     ; get character itself from table
parse1
    jsr $FFD2
    dex
    bpl parse1      ; repeat 
parse2
    rts    

; 'compressed' table on what to print

; used chars (8 total = 3 bits)
; 0 : minus = 45
; 1 : plus  = 43
; 2 : !     = 33
; 3 : Backslash = 205
; 4 : slash = 47
; 5 : O     = 79
; 6 : space = 32
; 7 : RETURN = 13
chars   .byte 45,43,33,205,47,79,32,13

; num repeat (max 8 = 0-7 = 3 bits)
; repeat 8 times the last 6 bytes (1 bit)

data    .byte (6) | (7<<3) ; 8 x space
        .byte (3) | (0<<3) ; 1 x backslash
        .byte (5) | (0<<3) ; 1 x O
        .byte (4) | (0<<3) ; 1 x slash 
        .byte (7) | (0<<3) ; 1 x NEWLINE
        
        .byte (1) | (0<<3) ; 1 x plus
        .byte (0) | (7<<3) ; 8 x minus
        .byte (1) | (0<<3) ; 1 x plus
        .byte (0) | (7<<3) ; 8 x minus
        .byte (1) | (0<<3) ; 1 x plus
        .byte (7) | (0<<3) ; 1 x NEWLINE
        
        .byte (2) | (0<<3) ; 1 x !
        .byte (6) | (7<<3) ; 8 x space
        .byte (2) | (0<<3) ; 1 x !
        .byte (6) | (7<<3) ; 8 x space
        .byte (2) | (0<<3) ; 1 x ! 
        .byte (7) | (0<<3) | 1<<7; 1 x NEWLINE - REPEAT
        
        .byte (1) | (0<<3) ; 1 x plus
        .byte (0) | (7<<3) ; 8 x minus
        .byte (1) | (0<<3) ; 1 x plus
        .byte (0) | (7<<3) ; 8 x minus
        .byte (1) | (0<<3) ; 1 x plus
        .byte (7) | (0<<3) ; 1 x NEWLINE
        
        .byte (2) | (0<<3) ; 1 x !
        .byte (6) | (7<<3) ; 8 x space
        .byte (2) | (0<<3) ; 1 x !
        .byte (6) | (7<<3) ; 8 x space
        .byte (2) | (0<<3) ; 1 x ! 
        .byte (7) | (0<<3) | 1<<7; 1 x NEWLINE - REPEAT

        .byte (1) | (0<<3) ; 1 x plus
        .byte (0) | (7<<3) ; 8 x minus
        .byte (1) | (0<<3) ; 1 x plus
        .byte (0) | (7<<3) ; 8 x minus
        .byte (1) | (0<<3) ; 1 x plus
        .byte (7) | (0<<3) ; 1 x NEWLINE

        .byte 0 ; end
data2
    

ChristmasEnd


