; ==========================================================================
; FAIRLY BAD SOLUTION FOR THE 2024 CHRISTMAS CONTEST 
; (Version 2. Mode 6 Text)
;
; Use Atari's structured load format to create a custom screen in memory.   
; Only one 6502 instruction is executed. JMP to prevent returning to DOS.
;
; Written for Atari 8-bit computers.
; Should work on any model.
; Should work on any memory size capable of running DOS to load an XEX.
;
; Assembly source intended for MADS assembler.
;
; Bare Source Code file size is 636 bytes.
;
; Executable File size is 142 bytes. (118 bytes loaded into memory as the "program")
;
; == 6502 EXECUTABLE:
; == == 3  bytes of 6502 code (only JMP to prevent returning to DOS)
; == GRAPHICS DATA:
; == == SCREEN DATA:
; == == == 60 bytes graphic memory
; == == == 55 bytes of display list
; == METADATA:
; == 6  bytes of miscellaneous data loaded in OS registers.
; == 18 bytes of Atari load file format overhead.
;
; ==========================================================================
;
; Center the 19-byte gift picture in the 32-byte wide display line:
;
;     00000000001111111111222222222233
;     01234567890123456789012345678901
; 00 "               \O/              "
; 01 "       +--------+--------+      "
; 02 "       !        !        !      "
; 03 "       !        !        !      "
; 04 "       !        !        !      "
; 05 "       !        !        !      "
; 06 "       !        !        !      "
; 07 "       !        !        !      "
; 08 "       !        !        !      "
; 09 "       !        !        !      "
; 10 "       +--------+--------+      "
; 11 "       !        !        !      "
; 12 "       !        !        !      "
; 13 "       !        !        !      "
; 14 "       !        !        !      "
; 15 "       !        !        !      "
; 16 "       !        !        !      "
; 17 "       !        !        !      "
; 18 "       !        !        !      "
; 19 "       +--------+--------+      "
;
; ==========================================================================
;
; OS Shadow registers for ANTIC.  
SDMCTL = $022F ; DMACTL - DMA Control of ANTIC
SDLSTL = $0230 ; DLISTL - Address of Display List

PLAYFIELD_WIDTH_NORMAL = %00000010 ; 20 or 40 characters/160 color clocks
ENABLE_DL_DMA          = %00100000 ; Enable running the Display List

DL_BLANK_8 = $70       ; 8 Blank Scan lines
DL_LMS     = %01000000 ; Reload Memory Scan address for a display list graphics line
; Originally.....
; DL_TEXT_2  = $02       ; 2 Color text, 32 or 40 Columns X 8 Scan lines, 32 or 40 bytes/line
; USING MODE 6 instead reduces screen memory requirements by 36 bytes.
DL_TEXT_6  = $06       ; Text. 5 color mode, 16 or 20 Columns x 8 Scan lines, 16 or 20 bytes per line
DL_JUMP_VB = $41       ; Display List jump to address and start Vertical Blank

DOS_RUN_ADDR = $02E0   ; Execute at the address stored here when file loading completes.

	ORG $3800          ; After Atari DOS 2.0s and Dup.  Before 16K.

; Total Screen RAM == 20 bytes * 3 lines == 60 bytes
; There are only 3 unique lines of screen data.   
; The display will be built to reuse the same memory repetitively.
; Using Mode 6 text instead of Mode 2 text reduces the demand for 
; screen memeory by 36 bytes.
LINE_1 .sb "        \O/         "
LINE_2 .sb "+--------+--------+ "
LINE_3 .sb "!        !        ! "

; DISPLAY LIST
; Total DL size == 2 (blanks) + 20 (Mode 2) + 34 (17 LMS addresses) + 1 (JVB) == 57 bytes

DISPLAY_LIST
	.byte DL_LMS|DL_TEXT_6
	.word LINE_1                               ; (1) Line 1, Bow
	.byte DL_TEXT_6,DL_TEXT_6,DL_LMS|DL_TEXT_6 ; (2) Line2, (3) Line 3, (4) Then LMS back to Line 3 again
	.word LINE_3
	.byte DL_LMS|DL_TEXT_6                     ; (5) Repeat Line 3 again...
	.word LINE_3
	.byte DL_LMS|DL_TEXT_6                     ; (6) Repeat Line 3 again...
	.word LINE_3
	.byte DL_LMS|DL_TEXT_6                     ; (7) Repeat Line 3 again...
	.word LINE_3
	.byte DL_LMS|DL_TEXT_6                     ; (9) Repeat Line 3 again...
	.word LINE_3
	.byte DL_LMS|DL_TEXT_6                     ; (9) Repeat Line 3 again...
	.word LINE_3
	.byte DL_LMS|DL_TEXT_6                     ; (10) Repeat Line 3 again...
	.word LINE_3
	.byte DL_LMS|DL_TEXT_6                     ; (11) Go back to Line 2 ...
	.word LINE_2
	.byte DL_TEXT_6,DL_LMS|DL_TEXT_6           ; (12) Line 3, (13) Then LMS back to Line 3 again
	.word LINE_3
	.byte DL_LMS|DL_TEXT_6                     ; (14) Repeat Line 3 again...
	.word LINE_3
	.byte DL_LMS|DL_TEXT_6                     ; (15) Repeat Line 3 again...
	.word LINE_3
	.byte DL_LMS|DL_TEXT_6                     ; (16) Repeat Line 3 again...
	.word LINE_3
	.byte DL_LMS|DL_TEXT_6                     ; (17) Repeat Line 3 again...
	.word LINE_3
	.byte DL_LMS|DL_TEXT_6                     ; (18) Repeat Line 3 again...
	.word LINE_3
	.byte DL_LMS|DL_TEXT_6                     ; (19) Repeat Line 3 again...
	.word LINE_3
	.byte DL_LMS|DL_TEXT_6                     ; (20) Go back to Line 2 ...
	.word LINE_2
	.byte DL_JUMP_VB                           ; JuMP for Vertical Blank

; Some evil happen here.  It does not matter what bytes are used for the JVB 
; instruction above.  No matter what appears in the Display List, the Operating 
; System's Vertical Blank Interrupt will reload the ANTIC Display List register 
; DLISTL/$D402 from the shadow register in RAM at SDLSTL/$0230.  THEREFORE, nothing
; is even defined here where a two-byte address is expected.  The next two bytes 
; of whatever data is ok.  In this case, it is part of the 6502 JMP instruction below...

; The "program" starts here.  Loop infinitely to prevent immediately returning to DOS.

PROGRAM_START
	JMP PROGRAM_START

; That's it, no more code.

; Do some gymnastics with the Atari's load file format to have the file 
; loading also update shadow registers to enable the new display.

; This is Six bytes of data which will be loaded in three additional file segment (four total).
; Each segment has Start address and End address, so that's an extra 16 bytes of 
; file structure information beyond the actual program data and executable loaded into memory.
; == 1 (file header byte) + 16 bytes (4 segments * 4 bytes) + 6 data bytes == 23 bytes of file structure

	ORG SDMCTL         ; OS Shadow register for DMACTL -  DMA Control of ANTIC
	.byte $00          ; Turn off the display/DMA.
	;                    It just so happens that SDLSTL, the Display List pointer, follows here.
	.word DISPLAY_LIST ; Point ANTIC to the new Display List. 

	ORG SDMCTL
	.byte PLAYFIELD_WIDTH_NORMAL|ENABLE_DL_DMA ; Turn on ANTIC DMA and start the screen mode.

	ORG DOS_RUN_ADDR   ; Tell DOS where this program begins execution after it loads the file.
	.word PROGRAM_START
;
	END
