#version 440

layout(binding = 0) buffer dcA { float A [  ]; };
layout(binding = 1) buffer dcB { float B [  ]; };
layout(rgba8, binding = 4) uniform image2D img;
layout(local_size_x = 20, local_size_y = 20, local_size_z = 1) in;

int per(int x, int nx)
{
    if (x < 0) x += nx;
    if (x >= nx) x -= nx;
    return x;
}

uniform int NX;
uniform int NY;
uniform float t;
//  Golfed SmoothLifeL (457 chars)
// https://www.shadertoy.com/view/sdKSzV
// https://www.shadertoy.com/view/XtdSDn

const float PI = 3.14159265;
const float RI = 4.0;          // inner radius
const float RA = 3 * RI;        // outer radius
float b1 = 0.257;
float b2 = 0.336;
float d1 = 0.365;
float d2 = 0.549;
//const float alpha_n = 0.028;// 0.028;
//const float alpha_m = 0.097;// 0.147;
//const float dt = 0.3;// 43235;
const float alpha_n = 0.028;// 0.028;
const float alpha_m = 0.082;// 0.147;
const float dt = 0.26;// 43235;


// https://github.com/GollyGang/ready/blob/7516f5c0c4ab4aee81763ea7ad4db92c7b19162c/Ready/Patterns/smoothlife_smoothglider.vti

//Rafler.pdf
float sigma1(float x, float a, float alpha)
{
    return 1.0 / (1.0 + exp(-(x - a) * 4.0 / alpha));
}

float sigma2(float x, float a, float b, float alpha)
{
    return sigma1(x, a, alpha) * (1.0 - sigma1(x, b, alpha));
}

float sigmam(float x, float y, float m, float alpha)
{
    return x * (1.0 - sigma1(m, 0.5, alpha)) + y * sigma1(m, 0.5, alpha);
}


/* ----------------------------------------------------------------------- */


/*float s(float n, float m)
{
	return sigma2(n, sigmam(b1, d1, m, alpha_m), sigmam(b2, d2, m, alpha_m), alpha_n);
}*/
/*float s(float n, float m) // org?
{
	return sigma2(n, sigmam(b1, d1, m, alpha_m), sigmam(b2, d2, m, alpha_m), alpha_n);
}*/
float s(float n, float m)
{
    return sigmam(sigma2(n, b1, b2, alpha_n),
                  sigma2(n, d1, d2, alpha_n), m, alpha_m
                  );
}

/*float transition_function(vec2 disk_ring)
{
	return sigmoid_mix(sigmoid_ab(disk_ring.x, b1, b2, alpha_n, alpha_n),
					   sigmoid_ab(disk_ring.x, d1, d2, alpha_n, alpha_n), disk_ring.y, alpha_m
					  );
}*/

void main()
{
    int i, j, idx, ip, jp;
    i = int(gl_GlobalInvocationID.x);
    j = int(gl_GlobalInvocationID.y);
    idx = i + NX * j;


    //if (i < NX / 6 || j < NY / 6 || i > NX - NX / 6 || j > NY - NY / 6)
    if ((i - NX / 2) * (i - NX / 2) + (j - NY / 2) * (j - NY / 2) < (NX / 6) * (NX / 6))
    {


        //const float RI = 4;          // inner radius
        //const float RA = 3 * RI;        // outer radius

        //RI = 4.0 * (i / float(NX)) + 2;
        //RA = 4 * RI;// 6.0 * (i / float(NX)) + 2;
        float dx = (i / float(NX));
        //b1 = 0.257;
        //b2 = 0.336;
        //const float d1 = 0.365;
        //const float d2 = 0.549;

        //M
        float u, v;
        float M = 0;
        float avg;
        int num;
        for (u = -RI - 2; u < RI + 2; u += 1)
            for (v = -RI - 2; v < RI + 2; v += 1)
            {
                float d = sqrt(u * u + v * v);
                if (d <= RI)
                {
                    ip = per(int(i + u), NX);
                    jp = per(int(j + v), NY);
                    M += A[ip + NX * jp];
                }
            }
        M = float(M) / (PI * RI * RI);//float(num);

        //N
        float N = 0;
        num = 0;
        for (u = -RA - 2; u < RA + 2; u += 1)
            for (v = -RA - 2; v < RA + 2; v += 1)
            {
                float d = sqrt(u * u + v * v);
                if (d >= RI && d < RA)
                {
                    ip = per(int(i + u), NX);
                    jp = per(int(j + v), NY);
                    N += A[ip + NX * jp];
                }
            }
        //N = float(N) / float(num);
        N = float(N) / (PI * RA * RA - PI * RI * RI);//float(num);
                                                     //N = float(N) / (8*PI*RI*RI);//float(num);


        //B[idx] = A[idx] + dt * s(N, M) * A[idx];
        //B[idx] = A[idx] + dt * s(N, M) * A[idx];
        //B[idx] = s(N, M) * A[idx];
        //B[idx] = s(N, M);

        B[idx] = A[idx] + dt * (2.0 * s(N, M) - 1.0);
        B[idx] = clamp(B[idx], 0, 1);
    }


    if(t>124)
    if ((i - NX / 2) * (i - NX / 2) + (j - NY / 2) * (j - NY / 2) > (NX / 6 - NX / 64) * (NX / 6 - NX / 64))
    {

        //if ((i - NX / 2) * (i - NX / 2) + (j - NY / 2) * (j - NY / 2) == (NY / 2.5) * (NY / 2.5))
        //A[idx] = B[idx] = 0.0;
        //vec4 col = vec4(vec3(0.0), 1.0);
        //imageStore(img, ivec2(gl_GlobalInvocationID.xy), col);

        //GOL
        int idx0, idx1, idx2, idx3, idx4, idx5, idx6, idx7, idx8, suma, im, jm;

        ip = per(i + 1, NX);     // periodicity
        im = per(i - 1, NX);
        jp = per(j + 1, NY);
        jm = per(j - 1, NY);

        idx0 = i + NX * j;           // neighbours
        idx1 = ip + NX * (jp);
        idx2 = ip + NX * (j);        // i+1,j
        idx3 = ip + NX * (jm);
        idx4 = i + NX * (jm);        // i,j-1
        idx5 = im + NX * (jm);
        idx6 = im + NX * (j);        // i-1, j
        idx7 = im + NX * (jp);
        idx8 = i + NX * (jp);        // i, j+1

        suma = int(A[idx1] + A[idx2] + A[idx3] + A[idx4] + A[idx5] + A[idx6] + A[idx7] + A[idx8]);

        //    wikipedia
        //    1 Any live cell with fewer than two live neighbours dies, as if caused by under-population.
        //    2 Any live cell with two or three live neighbours lives on to the next generation.
        //    3 Any live cell with more than three live neighbours dies, as if by overcrowding.
        //    4 Any dead cell with exactly three live neighbours becomes a live cell, as if by reproduction.

        // Game of Life
        B[idx0] = A[idx0];
        if (A[idx0] == 1)
        {
            if (suma < 2) B[idx0] = 0;
            if (suma > 3) B[idx0] = 0;
        }
        else
        {
            if (suma == 3) B[idx0] = 1;
        }

    }

    float b = B[idx];
    vec4 col = vec4(b, b, b, 1.0);
    if (t > 128)
//        if ((i - NX / 2) * (i - NX / 2) + (j - NY / 2) * (j - NY / 2) > (NX / 6 + NX / 64) * (NX / 6 + NX / 64))
        {
            col.g /= 5.0;
            col.b /= 5.0;
        }

    /*if (t < 124)
        if ((i - NX / 2) * (i - NX / 2) + (j - NY / 2) * (j - NY / 2) > (NX / 6) * (NX / 6))
        {
            col.g /= 5.0;
            col.b /= 5.0;
        }*/

    /*    if (t < 124)
        {
            col.g /= 5.0;
            col.b /= 5.0;
        }*/

    imageStore(img, ivec2(gl_GlobalInvocationID.xy), col);
}
