
struct MaterialEval
{
	vec4  albedo;
	vec4  albedo_texture;
	vec3  emissive;
	vec3  emissive_texture;
	float roughness;
	float roughness_texture;
	float metalness;
	float metalness_texture;
	float transparency;
	vec3  normal;
	bool  is_discarded;
	uint  flag_overrides;
};

struct MaterialEvalInput
{
	vec2  uv0;
	vec3  normal;		// for triplanar mapping, not modified by normal map
	vec4  color;
	vec3  world_coords;
	vec3  local_coords;
	vec3  world_normal;
	vec3  local_normal;
	float modifier_factor;
};

void material_evaluate_sample_textures(MaterialPropertiesGPU material, inout MaterialEval material_eval, inout MaterialEvalInput eval_input);

#ifdef INLINE_MATERIAL_OVERRIDE
#inline <INLINE_MATERIAL_OVERRIDE>
#endif

#ifndef MATERIAL_OVERRIDE_ALBEDO
vec4 getMaterialAlbedo(MaterialPropertiesGPU material, vec4 albedo, vec3 worldCoords, vec3 localCoords, vec3 worldNormal, vec3 localNormal)
{
	return albedo;
}
#endif

#ifndef MATERIAL_OVERRIDE_EMISSIVE
vec3 getMaterialEmissive(MaterialPropertiesGPU material, vec3 emissive, vec3 worldCoords, vec3 localCoords, vec3 worldNormal, vec3 localNormal)
{
	return emissive;
}
#endif

#ifndef MATERIAL_OVERRIDE_ROUGHNESS
float getMaterialRoughness(MaterialPropertiesGPU material, float roughness, vec3 worldCoords, vec3 localCoords, vec3 worldNormal, vec3 localNormal)
{
	return roughness;
}
#endif

#ifndef MATERIAL_OVERRIDE_METALNESS
float getMaterialMetalness(MaterialPropertiesGPU material, float metalness, vec3 worldCoords, vec3 localCoords, vec3 worldNormal, vec3 localNormal)
{
	return metalness;
}
#endif

#ifndef MATERIAL_OVERRIDE_NORMAL
vec3 getMaterialNormal(MaterialPropertiesGPU material, vec3 normal, vec3 worldCoords, vec3 localCoords, vec3 worldNormal, vec3 localNormal)
{
	return normal;
}
#endif

#ifndef MATERIAL_OVERRIDE_DISCARD
bool getMaterialDiscard(MaterialPropertiesGPU material, vec3 worldCoords, vec3 localCoords, vec3 worldNormal, vec3 localNormal)
{
	return false;
}
#endif

#if 0
// TEMPLATE, NOT EXECUTED
void material_evaluate(MaterialPropertiesGPU material, in out MaterialEval eval, in out MaterialEvalInput eval_input)
{
	material_evaluate_sample_textures(material, eval, eval_input);
	eval.albedo.rgb *= eval_input.color.rgb;
}
#endif
