#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct ParticleState
{
    float life_time;
    float life_span;
    float generation_id;
    uint color;
};

struct ModifierFactorNoise_Params
{
    mat4 transform_local_to_gizmo;
    vec3 noise_domain_scale;
    uint modifier_function;
    vec3 noise_domain_offset;
    float noise_value_scale;
    float noise_value_offset;
    int influence_scope;
    int _pad0;
    int _pad1;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct VertexModifierColorizeParams
{
    vec3 color;
    float alpha;
    int use_gradient;
    float color_blend;
    float alpha_blend;
    int color_gradient_idx;
    int mixing_mode;
};

struct VertexInput
{
    uint id;
    vec3 pos;
    vec3 norm;
    vec4 color;
    vec2 uv0;
};

struct RibbonRenderParams
{
    int max_segments;
    int base_idx;
    int base_segment;
    int particles_per_segment;
    float thickness;
    int lights_num;
    int material_index;
    float first_segment_time_factor;
    int render_as_strips;
    int _pad0;
    int _pad1;
    int _pad2;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    vec3 vCameraPosition;
};

struct ParticleRibbonState
{
    float generation_id;
    uint segments;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct LightProperties
{
    vec4 diffuse;
    vec4 direction;
    vec4 position;
    vec4 up;
    vec4 right;
    vec2 dimensions;
    vec2 _pad1;
    float intensity;
    float range;
    float cutoff;
    float roughness_modifier;
    int is_area;
    int type;
    int projector_sampler;
    float projector_intensity;
    int shadowmap_sampler0;
    int shadowmap_sampler1;
    int shadowmap_sampler2;
    int shadowmap_sampler3;
    float cascade_distance0;
    float cascade_distance1;
    float cascade_distance2;
    float cascade_distance3;
    mat4 mat_shadow_mv;
    mat4 mat_shadow_p[4];
    mat4 mat_shadow_mvp[4];
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std430) buffer ParticleStatesData
{
    ParticleState prt_states[];
} _643;

layout(set = 0, binding = 4, std140) uniform RibbonRenderParamsBuffer
{
    RibbonRenderParams ribbon_render_params;
} _683;

layout(set = 0, binding = 5, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _920;

layout(set = 0, binding = 6, std140) uniform VM0
{
    layout(row_major) ModifierFactorNoise_Params VM0_params;
} _948;

layout(set = 0, binding = 7, std140) uniform VM1
{
    VertexModifierColorizeParams VM1_params;
} _963;

layout(set = 0, binding = 2, std430) buffer RibbonPositionsData
{
    float position[];
} prt_position_snapshots;

layout(set = 0, binding = 3, std430) buffer RibbonStatesData
{
    ParticleRibbonState states[];
} prt_states_snapshots;

layout(set = 0, binding = 8) uniform sampler2D s_Gradients;

bool prt_is_alive(uint id)
{
    return _643.prt_states[id].life_time < _643.prt_states[id].life_span;
}

int calculate_vidx_for_ribbon_segment(int ribbon_id, inout int ribbon_segment)
{
    ribbon_segment = _683.ribbon_render_params.base_segment - ribbon_segment;
    if (ribbon_segment < 0)
    {
        ribbon_segment += _683.ribbon_render_params.max_segments;
    }
    if (ribbon_segment >= _683.ribbon_render_params.max_segments)
    {
        ribbon_segment -= _683.ribbon_render_params.max_segments;
    }
    int vidx = ((ribbon_segment * _683.ribbon_render_params.particles_per_segment) + ribbon_id) + _683.ribbon_render_params.base_idx;
    return vidx;
}

vec3 color_convert_uint_to_float3(uint vi)
{
    vec3 v = vec3(0.0);
    uint v_mag = vi >> uint(24);
    float v_mag_rcp = 0.0039215688593685626983642578125 * float(v_mag);
    v.x = float((vi >> uint(0)) & 255u) * v_mag_rcp;
    v.y = float((vi >> uint(8)) & 255u) * v_mag_rcp;
    v.z = float((vi >> uint(16)) & 255u) * v_mag_rcp;
    return v;
}

vec4 prt_get_color(uint id)
{
    vec4 c = vec4(1.0);
    uint param = _643.prt_states[id].color;
    vec3 _670 = color_convert_uint_to_float3(param);
    c.x = _670.x;
    c.y = _670.y;
    c.z = _670.z;
    return c;
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

mat4 mat_mul_affine(mat4 ma, mat4 mb)
{
    return ma * mb;
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

vec3 mod289(vec3 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 mod289(vec4 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 permute(vec4 x)
{
    vec4 param = ((x * 34.0) + vec4(1.0)) * x;
    return mod289(param);
}

vec4 taylorInvSqrt(vec4 r)
{
    return vec4(1.792842864990234375) - (r * 0.8537347316741943359375);
}

float snoise(vec3 v)
{
    vec3 i = floor(v + vec3(dot(v, vec3(0.3333333432674407958984375))));
    vec3 x0 = (v - i) + vec3(dot(i, vec3(0.16666667163372039794921875)));
    vec3 g = step(x0.yzx, x0);
    vec3 l = vec3(1.0) - g;
    vec3 i1 = min(g, l.zxy);
    vec3 i2 = max(g, l.zxy);
    vec3 x1 = (x0 - i1) + vec3(0.16666667163372039794921875);
    vec3 x2 = (x0 - i2) + vec3(0.3333333432674407958984375);
    vec3 x3 = x0 - vec3(0.5);
    vec3 param = i;
    i = mod289(param);
    vec4 param_1 = vec4(i.z) + vec4(0.0, i1.z, i2.z, 1.0);
    vec4 param_2 = (permute(param_1) + vec4(i.y)) + vec4(0.0, i1.y, i2.y, 1.0);
    vec4 param_3 = (permute(param_2) + vec4(i.x)) + vec4(0.0, i1.x, i2.x, 1.0);
    vec4 p = permute(param_3);
    float n_ = 0.14285714924335479736328125;
    vec3 ns = (vec3(2.0, 0.5, 1.0) * n_) - vec3(0.0, 1.0, 0.0);
    vec4 j = p - (floor((p * ns.z) * ns.z) * 49.0);
    vec4 x_ = floor(j * ns.z);
    vec4 y_ = floor(j - (x_ * 7.0));
    vec4 x = (x_ * ns.x) + ns.yyyy;
    vec4 y = (y_ * ns.x) + ns.yyyy;
    vec4 h = (vec4(1.0) - abs(x)) - abs(y);
    vec4 b0 = vec4(x.xy, y.xy);
    vec4 b1 = vec4(x.zw, y.zw);
    vec4 s0 = (floor(b0) * 2.0) + vec4(1.0);
    vec4 s1 = (floor(b1) * 2.0) + vec4(1.0);
    vec4 sh = -step(h, vec4(0.0));
    vec4 a0 = b0.xzyw + (s0.xzyw * sh.xxyy);
    vec4 a1 = b1.xzyw + (s1.xzyw * sh.zzww);
    vec3 p0 = vec3(a0.xy, h.x);
    vec3 p1 = vec3(a0.zw, h.y);
    vec3 p2 = vec3(a1.xy, h.z);
    vec3 p3 = vec3(a1.zw, h.w);
    vec4 param_4 = vec4(dot(p0, p0), dot(p1, p1), dot(p2, p2), dot(p3, p3));
    vec4 norm = taylorInvSqrt(param_4);
    p0 *= norm.x;
    p1 *= norm.y;
    p2 *= norm.z;
    p3 *= norm.w;
    vec4 m = max(vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3)), vec4(0.0));
    m *= m;
    return 105.0 * dot(m * m, vec4(dot(p0, x0), dot(p1, x1), dot(p2, x2), dot(p3, x3)));
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_noise_default(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        vec3 _734 = vector_transform_by_mat43(param, param_1);
        coords = _734;
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 _741 = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = _741;
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = snoise(param_4);
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

vec4 gradient_sample(int idx, float t)
{
    return textureLod(s_Gradients, vec2(t, (float(idx) + 0.5) / 256.0), 0.0);
}

void vertex_modifier_colorize_apply(VertexModifierColorizeParams modifier_params, ModifierFactor modifier_factor, inout VertexInput vtx)
{
    vec3 c = vec3(1.0);
    float a = modifier_params.alpha;
    if (modifier_params.use_gradient != 0)
    {
        int param = modifier_params.color_gradient_idx;
        float param_1 = modifier_factor.factor;
        c = gradient_sample(param, param_1).xyz;
        c *= modifier_params.color;
    }
    else
    {
        c = modifier_params.color;
    }
    if (modifier_params.mixing_mode == 0)
    {
        if (modifier_params.use_gradient == 0)
        {
            c *= modifier_factor.factor;
        }
        a *= modifier_factor.factor;
    }
    if (modifier_params.mixing_mode == 1)
    {
        c = mix(vtx.color.xyz, c, vec3(modifier_factor.factor));
        a = mix(vtx.color.w, a, modifier_factor.factor);
    }
    if (modifier_params.mixing_mode == 2)
    {
        c = vtx.color.xyz + (c * modifier_factor.factor);
        a = vtx.color.w + (a * modifier_factor.factor);
    }
    vec4 _870 = vtx.color;
    vec3 _876 = mix(_870.xyz, c, vec3(modifier_params.color_blend));
    vtx.color.x = _876.x;
    vtx.color.y = _876.y;
    vtx.color.z = _876.z;
    vtx.color.w = mix(vtx.color.w, a, modifier_params.alpha_blend);
}

vec3 apply_vtx_modifier(inout vec3 pos, vec3 norm, inout vec3 color, uint ribbon_id)
{
    VertexInput vtx_input;
    vtx_input.id = ribbon_id;
    vtx_input.pos = pos;
    vtx_input.norm = norm;
    vtx_input.color = vec4(color, 1.0);
    vtx_input.uv0 = vec2(0.0);
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = ribbon_id;
    modifier_factor.id = ribbon_id;
    modifier_factor.instance_id = ribbon_id;
    modifier_factor.position = pos;
    modifier_factor.is_spawned = false;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = _920.transform_params.mModel;
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = _920.transform_params.mModelInv;
    mat4 param = cs_transforms.mat_local_to_instance;
    mat4 param_1 = cs_transforms.mat_local_to_model;
    mat4 mat_local_to_instance = mat_mul_affine(param, param_1);
    vec3 param_2 = vtx_input.pos;
    mat4 param_3 = mat_local_to_instance;
    vec3 _943 = vector_transform_by_mat43(param_2, param_3);
    modifier_factor.position = _943;
    ModifierFactorNoise_Params _953;
    _953.transform_local_to_gizmo = _948.VM0_params.transform_local_to_gizmo;
    _953.noise_domain_scale = _948.VM0_params.noise_domain_scale;
    _953.modifier_function = _948.VM0_params.modifier_function;
    _953.noise_domain_offset = _948.VM0_params.noise_domain_offset;
    _953.noise_value_scale = _948.VM0_params.noise_value_scale;
    _953.noise_value_offset = _948.VM0_params.noise_value_offset;
    _953.influence_scope = _948.VM0_params.influence_scope;
    _953._pad0 = _948.VM0_params._pad0;
    _953._pad1 = _948.VM0_params._pad1;
    ModifierFactorNoise_Params param_4 = _953;
    ModifierFactor param_5 = modifier_factor;
    CoordinateSystemTrasforms param_6 = cs_transforms;
    modifier_factor_noise_default(param_4, param_5, param_6);
    modifier_factor = param_5;
    VertexModifierColorizeParams _968;
    _968.color = _963.VM1_params.color;
    _968.alpha = _963.VM1_params.alpha;
    _968.use_gradient = _963.VM1_params.use_gradient;
    _968.color_blend = _963.VM1_params.color_blend;
    _968.alpha_blend = _963.VM1_params.alpha_blend;
    _968.color_gradient_idx = _963.VM1_params.color_gradient_idx;
    _968.mixing_mode = _963.VM1_params.mixing_mode;
    VertexModifierColorizeParams param_7 = _968;
    ModifierFactor param_8 = modifier_factor;
    VertexInput param_9 = vtx_input;
    vertex_modifier_colorize_apply(param_7, param_8, param_9);
    modifier_factor = param_8;
    vtx_input = param_9;
    pos = vtx_input.pos;
    color = vtx_input.color.xyz;
    return pos;
}

ParticleState prt_get_state(uint id)
{
    ParticleState _660;
    _660.life_time = _643.prt_states[id].life_time;
    _660.life_span = _643.prt_states[id].life_span;
    _660.generation_id = _643.prt_states[id].generation_id;
    _660.color = _643.prt_states[id].color;
    ParticleState _659 = _660;
    return _659;
}

vec3 get_ribbon_transformed_segment_position(int ribbon_id, int segment_idx)
{
    int param = ribbon_id;
    int param_1 = segment_idx;
    int _989 = calculate_vidx_for_ribbon_segment(param, param_1);
    int vidx = _989;
    vec3 p = vec3(prt_position_snapshots.position[(vidx * 3) + 0], prt_position_snapshots.position[(vidx * 3) + 1], prt_position_snapshots.position[(vidx * 3) + 2]);
    vec3 dummy_normal = vec3(0.0);
    vec3 dummy_color = vec3(0.0);
    vec3 param_2 = p;
    vec3 param_3 = dummy_normal;
    vec3 param_4 = dummy_color;
    uint param_5 = uint(ribbon_id);
    vec3 _1023 = apply_vtx_modifier(param_2, param_3, param_4, param_5);
    dummy_color = param_4;
    vec3 modified_p = _1023;
    vec3 param_6 = modified_p;
    mat4 param_7 = _920.transform_params.mModelView;
    vec3 _1030 = vector_transform_by_mat43(param_6, param_7);
    return _1030;
}

vec4 vector_transform_by_mat_projection(vec3 v, inout mat4 m)
{
    m[0].y = 0.0;
    m[0].z = 0.0;
    m[0].w = 0.0;
    m[1].x = 0.0;
    m[1].z = 0.0;
    m[1].w = 0.0;
    return m * vec4(v, 1.0);
}

void main()
{
    int odd_even = ((gl_VertexIndex & 1) == 0) ? 1 : (-1);
    int ribbon_id;
    int ribbon_segment;
    if (_683.ribbon_render_params.render_as_strips != 0)
    {
        ribbon_id = gl_InstanceIndex;
        ribbon_segment = gl_VertexIndex / 2;
    }
    else
    {
        uint max_segments_uint = uint(_683.ribbon_render_params.max_segments);
        ribbon_segment = gl_VertexIndex / 2;
        ribbon_id = (gl_InstanceIndex * 64) + int(uint(ribbon_segment) / max_segments_uint);
        ribbon_segment = int(uint(ribbon_segment) % max_segments_uint);
    }
    if (false)
    {
        uint param = uint(ribbon_id);
        if (!prt_is_alive(param))
        {
            gl_Position = vec4(0.0, 0.0, 0.0, -1.0);
            return;
        }
    }
    int ribbon_segments = max(0, (min(_683.ribbon_render_params.max_segments, int(prt_states_snapshots.states[ribbon_id].segments)) - 1));
    ribbon_segment = min(ribbon_segment, ribbon_segments);
    int param_1 = ribbon_id;
    int param_2 = ribbon_segment;
    int _1114 = calculate_vidx_for_ribbon_segment(param_1, param_2);
    int vidx = _1114;
    vec3 vInstPosition = vec3(prt_position_snapshots.position[(vidx * 3) + 0], prt_position_snapshots.position[(vidx * 3) + 1], prt_position_snapshots.position[(vidx * 3) + 2]);
    vec3 vInstNormal = vec3(1.0, 0.0, 0.0);
    uint param_3 = uint(ribbon_id);
    vec4 vInstColor = prt_get_color(param_3);
    vec3 param_4 = vInstPosition;
    vec3 param_5 = vInstNormal;
    vec3 param_6 = vInstColor.xyz;
    uint param_7 = uint(ribbon_id);
    vec3 _1149 = apply_vtx_modifier(param_4, param_5, param_6, param_7);
    vInstColor.x = param_6.x;
    vInstColor.y = param_6.y;
    vInstColor.z = param_6.z;
    vInstPosition = _1149;
    uint param_8 = uint(ribbon_id);
    ParticleState vState = prt_get_state(param_8);
    bool is_last = ribbon_segment >= ribbon_segments;
    bool is_first = ribbon_segment == 0;
    vec3 extrusion = vec3(0.0);
    vec3 modelview_cylinder_axis = vec3(0.0, 0.0, 1.0);
    int second_segment_offset = -1;
    if (ribbon_segment == 0)
    {
        second_segment_offset = 1;
    }
    if (true)
    {
        float shrink_factor = _683.ribbon_render_params.first_segment_time_factor;
        float min_shrink_modifier = 0.1500000059604644775390625;
        int param_9 = ribbon_id;
        int param_10 = ribbon_segment;
        vec3 currPosition = get_ribbon_transformed_segment_position(param_9, param_10);
        int param_11 = ribbon_id;
        int param_12 = ribbon_segment + second_segment_offset;
        vec3 nextPosition = get_ribbon_transformed_segment_position(param_11, param_12);
        modelview_cylinder_axis = currPosition - nextPosition;
        if (length(modelview_cylinder_axis) <= 9.9999997473787516355514526367188e-05)
        {
            if (ribbon_segment > 1)
            {
                int param_13 = ribbon_id;
                int param_14 = ribbon_segment + (second_segment_offset * 2);
                nextPosition = get_ribbon_transformed_segment_position(param_13, param_14);
                modelview_cylinder_axis = currPosition - nextPosition;
            }
        }
        modelview_cylinder_axis = normalize(modelview_cylinder_axis);
        vec2 dir2d = normalize(currPosition.xy - nextPosition.xy);
        dir2d = vec2(-dir2d.y, dir2d.x);
        vec3 dir = vec3(dir2d, 0.0);
        if ((ribbon_segment == ribbon_segments) && (ribbon_segments > 1))
        {
        }
        if (is_first)
        {
            dir *= (-min_shrink_modifier);
        }
        else
        {
            if (is_last)
            {
                dir *= min_shrink_modifier;
            }
            else
            {
                if ((ribbon_segment == 1) && (ribbon_segments > 2))
                {
                    dir *= max(min_shrink_modifier, shrink_factor);
                }
                if ((ribbon_segment == (ribbon_segments - 1)) && (ribbon_segments == 2))
                {
                    dir *= max(min_shrink_modifier, shrink_factor);
                }
            }
        }
        extrusion = dir * _683.ribbon_render_params.thickness;
    }
    if (ribbon_segment == 0)
    {
        modelview_cylinder_axis *= (-1.0);
    }
    uint param_15 = uint(ribbon_id);
    if (!prt_is_alive(param_15))
    {
        gl_Position = vec4(0.0, 0.0, 0.0, -1.0);
        return;
    }
    vec3 pos = vInstPosition;
    vec3 vPos1 = pos;
    vec3 param_16 = vPos1;
    mat4 param_17 = _920.transform_params.mModelView;
    vec3 _1322 = vector_transform_by_mat43(param_16, param_17);
    vec3 vPos = _1322;
    if (vPos.z > 1.0)
    {
        mat4 projection_no_jitter = _920.transform_params.mProjection;
        projection_no_jitter[2].x = 0.0;
        projection_no_jitter[2].y = 0.0;
        vec3 param_18 = vec3(extrusion.xy, vPos.z);
        mat4 param_19 = projection_no_jitter;
        vec4 _1344 = vector_transform_by_mat_projection(param_18, param_19);
        vec4 projected_extrusion = _1344;
        vec4 _1345 = projected_extrusion;
        float _1348 = projected_extrusion.w;
        vec3 _1350 = _1345.xyz / vec3(_1348);
        projected_extrusion.x = _1350.x;
        projected_extrusion.y = _1350.y;
        projected_extrusion.z = _1350.z;
        float min_extrusion_size = 0.0006500000017695128917694091796875;
        float projected_extrusion_size = length(projected_extrusion.xy);
        if (projected_extrusion_size > 0.0)
        {
            if (projected_extrusion_size < min_extrusion_size)
            {
                float scale = min_extrusion_size / projected_extrusion_size;
                extrusion *= scale;
            }
        }
    }
    vPos += (extrusion * float(odd_even));
    vec3 param_20 = vPos;
    mat4 param_21 = _920.transform_params.mProjection;
    vec4 _1390 = vector_transform_by_mat_projection(param_20, param_21);
    gl_Position = _1390;
}

 