#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    vec3 vCameraPosition;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct LightProperties
{
    vec4 diffuse;
    vec4 direction;
    vec4 position;
    vec4 up;
    vec4 right;
    vec2 dimensions;
    vec2 _pad1;
    float intensity;
    float range;
    float cutoff;
    float roughness_modifier;
    int is_area;
    int type;
    int projector_sampler;
    float projector_intensity;
    int shadowmap_sampler0;
    int shadowmap_sampler1;
    int shadowmap_sampler2;
    int shadowmap_sampler3;
    float cascade_distance0;
    float cascade_distance1;
    float cascade_distance2;
    float cascade_distance3;
    mat4 mat_shadow_mv;
    mat4 mat_shadow_p[4];
    mat4 mat_shadow_mvp[4];
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

layout(set = 0, binding = 1, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _71;

layout(location = 0) out uint instanceID;
layout(location = 1) out Vertex
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vCameraRelativeWorldPos;
    vec4 vColor;
    vec2 vUV0;
} vtx_output;


void main()
{
    instanceID = 0u;
    vec3 pos = vec3(0.0);
    if (gl_VertexIndex == 0)
    {
        pos = vec3(-1.0, 1.0, 0.0);
    }
    if (gl_VertexIndex == 1)
    {
        pos = vec3(1.0, 1.0, 0.0);
    }
    if (gl_VertexIndex == 2)
    {
        pos = vec3(1.0, -1.0, 0.0);
    }
    if (gl_VertexIndex == 3)
    {
        pos = vec3(-1.0, -1.0, 0.0);
    }
    vec3 norm = vec3(0.0, 0.0, -1.0);
    vtx_output.vLocalPos = pos;
    vec4 vPos1 = vec4(pos, 1.0);
    vtx_output.vCameraRelativeWorldPos = vPos1.xyz - _71.transform_params.vCameraPosition;
    vtx_output.vWorldNorm = norm;
    vtx_output.vNorm.x = dot(_71.transform_params.mModelViewInvTrans[0].xyz, norm);
    vtx_output.vNorm.y = dot(_71.transform_params.mModelViewInvTrans[1].xyz, norm);
    vtx_output.vNorm.z = dot(_71.transform_params.mModelViewInvTrans[2].xyz, norm);
    vtx_output.vNorm = normalize(vtx_output.vNorm);
    vtx_output.vCoords = vPos1.xyz;
    gl_Position = vPos1;
    vtx_output.vColor = vec4(1.0);
    vtx_output.vUV0 = vec2(0.0);
}

 