#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct ModifierFactorInstanceID_Params
{
    uint modifier_function;
    float multiplier;
    float range;
    float base;
};

struct VertexModifierColorizeParams
{
    vec3 color;
    float alpha;
    int use_gradient;
    float color_blend;
    float alpha_blend;
    int color_gradient_idx;
    int mixing_mode;
};

struct VertexInput
{
    uint id;
    vec3 pos;
    vec3 norm;
    vec4 color;
    vec2 uv0;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    vec3 vCameraPosition;
};

struct _1104
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vCameraRelativeWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 11, scalar) uniform GeometryInformationBuffer
{
    GeometryInformation geometry_information;
} _232;

layout(set = 0, binding = 1, std430) readonly buffer VTXCoords
{
    float coords[];
} vtx_coords;

layout(set = 0, binding = 2, std430) readonly buffer VTXNormals
{
    float normals[];
} vtx_normals;

layout(set = 0, binding = 3, std430) readonly buffer VTXAlbedo
{
    float albedo[];
} vtx_albedo;

layout(set = 0, binding = 4, std430) readonly buffer VTXUV0
{
    float uv0[];
} vtx_uv0;

layout(set = 0, binding = 5, std430) readonly buffer VTXCustom0
{
    uint custom0[];
} vtx_custom0;

layout(set = 0, binding = 12, std140) uniform InstanceParamsBuffer
{
    InstanceParams instance_params;
} _731;

layout(set = 0, binding = 6, std430) buffer InstanceFlipbookCardBuffer
{
    uint instance_flipbook_card[];
} _742;

layout(set = 0, binding = 7, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _830;

layout(set = 0, binding = 8, std430) buffer InstanceHashBuffer
{
    uint instance_hash[];
} _1022;

layout(set = 0, binding = 13, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _1065;

layout(set = 0, binding = 9, std430) buffer VM0
{
    ModifierFactorInstanceID_Params VM0_params;
} _1078;

layout(set = 0, binding = 14, std140) uniform VM1
{
    VertexModifierColorizeParams VM1_params;
} _1091;

layout(set = 0, binding = 10, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _1199;

layout(set = 0, binding = 15) uniform sampler2D s_Gradients;

layout(location = 1) out _1104 vtx_output;
layout(location = 0) out uint instanceID;

vec3 vtx_coords_load(inout uint idx)
{
    idx *= _232.geometry_information.attributes[0].stride;
    idx += _232.geometry_information.attributes[0].offset;
    return vec3(vtx_coords.coords[idx + 0u], vtx_coords.coords[idx + 1u], vtx_coords.coords[idx + 2u]);
}

vec3 vtx_albedo_load(inout uint idx)
{
    idx *= _232.geometry_information.attributes[2].stride;
    idx += _232.geometry_information.attributes[2].offset;
    return vec3(vtx_albedo.albedo[idx + 0u], vtx_albedo.albedo[idx + 1u], vtx_albedo.albedo[idx + 2u]);
}

vec3 vtx_normals_load(inout uint idx)
{
    idx *= _232.geometry_information.attributes[1].stride;
    idx += _232.geometry_information.attributes[1].offset;
    return vec3(vtx_normals.normals[idx + 0u], vtx_normals.normals[idx + 1u], vtx_normals.normals[idx + 2u]);
}

vec2 vtx_uv0_load(inout uint idx)
{
    idx *= _232.geometry_information.attributes[3].stride;
    idx += _232.geometry_information.attributes[3].offset;
    return vec2(vtx_uv0.uv0[idx + 0u], vtx_uv0.uv0[idx + 1u]);
}

float det(mat2 matrix)
{
    return (matrix[0].x * matrix[1].y) - (matrix[0].y * matrix[1].x);
}

mat3 transpose_mat3(mat3 matrix)
{
    vec3 row0 = matrix[0];
    vec3 row1 = matrix[1];
    vec3 row2 = matrix[2];
    mat3 result = mat3(vec3(vec3(row0.x, row1.x, row2.x)), vec3(vec3(row0.y, row1.y, row2.y)), vec3(vec3(row0.z, row1.z, row2.z)));
    return result;
}

mat3 inverse_mat3(mat3 matrix)
{
    vec3 row0 = matrix[0];
    vec3 row1 = matrix[1];
    vec3 row2 = matrix[2];
    mat2 param = mat2(vec2(row1.y, row1.z), vec2(row2.y, row2.z));
    mat2 param_1 = mat2(vec2(row1.z, row1.x), vec2(row2.z, row2.x));
    mat2 param_2 = mat2(vec2(row1.x, row1.y), vec2(row2.x, row2.y));
    vec3 minors0 = vec3(det(param), det(param_1), det(param_2));
    mat2 param_3 = mat2(vec2(row2.y, row2.z), vec2(row0.y, row0.z));
    mat2 param_4 = mat2(vec2(row2.z, row2.x), vec2(row0.z, row0.x));
    mat2 param_5 = mat2(vec2(row2.x, row2.y), vec2(row0.x, row0.y));
    vec3 minors1 = vec3(det(param_3), det(param_4), det(param_5));
    mat2 param_6 = mat2(vec2(row0.y, row0.z), vec2(row1.y, row1.z));
    mat2 param_7 = mat2(vec2(row0.z, row0.x), vec2(row1.z, row1.x));
    mat2 param_8 = mat2(vec2(row0.x, row0.y), vec2(row1.x, row1.y));
    vec3 minors2 = vec3(det(param_6), det(param_7), det(param_8));
    mat3 param_9 = mat3(vec3(minors0), vec3(minors1), vec3(minors2));
    mat3 adj = transpose_mat3(param_9);
    return adj * (1.0 / dot(row0, minors0));
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

uint vtx_custom0_load(inout uint idx)
{
    idx *= _232.geometry_information.attributes[6].stride;
    idx += _232.geometry_information.attributes[6].offset;
    return vtx_custom0.custom0[idx + 0u];
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_instance_id(ModifierFactorInstanceID_Params modifier_params, inout ModifierFactor modifier_factor)
{
    uint instance_id = modifier_factor.instance_id;
    float v = mod(float(instance_id) * modifier_params.multiplier, modifier_params.range) + modifier_params.base;
    ModifierFactor param = modifier_factor;
    uint param_1 = modifier_params.modifier_function;
    float param_2 = v;
    modifier_process_modifier_factor(param, param_1, param_2);
    modifier_factor = param;
}

vec4 gradient_sample(int idx, float t)
{
    return textureLod(s_Gradients, vec2(t, (float(idx) + 0.5) / 256.0), 0.0);
}

void vertex_modifier_colorize_apply(VertexModifierColorizeParams modifier_params, ModifierFactor modifier_factor, inout VertexInput vtx)
{
    vec3 c = vec3(1.0);
    float a = modifier_params.alpha;
    if (modifier_params.use_gradient != 0)
    {
        int param = modifier_params.color_gradient_idx;
        float param_1 = modifier_factor.factor;
        c = gradient_sample(param, param_1).xyz;
        c *= modifier_params.color;
    }
    else
    {
        c = modifier_params.color;
    }
    if (modifier_params.mixing_mode == 0)
    {
        if (modifier_params.use_gradient == 0)
        {
            c *= modifier_factor.factor;
        }
        a *= modifier_factor.factor;
    }
    if (modifier_params.mixing_mode == 1)
    {
        c = mix(vtx.color.xyz, c, vec3(modifier_factor.factor));
        a = mix(vtx.color.w, a, modifier_factor.factor);
    }
    if (modifier_params.mixing_mode == 2)
    {
        c = vtx.color.xyz + (c * modifier_factor.factor);
        a = vtx.color.w + (a * modifier_factor.factor);
    }
    vec4 _484 = vtx.color;
    vec3 _490 = mix(_484.xyz, c, vec3(modifier_params.color_blend));
    vtx.color.x = _490.x;
    vtx.color.y = _490.y;
    vtx.color.z = _490.z;
    vtx.color.w = mix(vtx.color.w, a, modifier_params.alpha_blend);
}

vec3 vector_transform_by_mat33(vec3 v, mat4 m)
{
    return (m * vec4(v, 0.0)).xyz;
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

vec4 vector_transform_by_mat_projection(vec3 v, inout mat4 m)
{
    m[0].y = 0.0;
    m[0].z = 0.0;
    m[0].w = 0.0;
    m[1].x = 0.0;
    m[1].z = 0.0;
    m[1].w = 0.0;
    return m * vec4(v, 1.0);
}

void main()
{
    uint load_vertex_idx = uint(gl_VertexIndex);
    if (_731.instance_params.stride > 0)
    {
        uint flipbook_card = _742.instance_flipbook_card[gl_InstanceIndex];
        flipbook_card = min(flipbook_card, (_232.geometry_information.flipbook_cards_num - 1u));
        load_vertex_idx += (_232.geometry_information.vtx_num * flipbook_card);
    }
    VertexInput vtx_input;
    vtx_input.id = uint(gl_VertexIndex);
    uint param = load_vertex_idx;
    vec3 _764 = vtx_coords_load(param);
    vtx_input.pos = _764;
    vtx_input.norm = vec3(1.0, 0.0, 0.0);
    vtx_input.color = vec4(1.0);
    vtx_input.uv0 = vtx_input.pos.xy;
    if ((_232.geometry_information.builtin_attribute_mask & 4u) != 0u)
    {
        uint param_1 = uint(gl_VertexIndex);
        vec3 _782 = vtx_albedo_load(param_1);
        vtx_input.color.x = _782.x;
        vtx_input.color.y = _782.y;
        vtx_input.color.z = _782.z;
    }
    if ((_232.geometry_information.builtin_attribute_mask & 2u) != 0u)
    {
        uint param_2 = load_vertex_idx;
        vec3 _797 = vtx_normals_load(param_2);
        vtx_input.norm = _797;
    }
    if ((_232.geometry_information.builtin_attribute_mask & 8u) != 0u)
    {
        uint param_3 = uint(gl_VertexIndex);
        vec2 _808 = vtx_uv0_load(param_3);
        vtx_input.uv0 = _808;
    }
    mat4 mat_instance_model;
    mat_instance_model[0] = vec4(1.0, 0.0, 0.0, 0.0);
    mat_instance_model[1] = vec4(0.0, 1.0, 0.0, 0.0);
    mat_instance_model[2] = vec4(0.0, 0.0, 1.0, 0.0);
    mat_instance_model[3] = vec4(0.0, 0.0, 0.0, 1.0);
    mat4 mat_instance_model_inv = mat_instance_model;
    if (_731.instance_params.stride > 0)
    {
        vec4 inst_m0 = _830.instance_transform[(gl_InstanceIndex * _731.instance_params.stride) + 0];
        vec4 inst_m1 = _830.instance_transform[(gl_InstanceIndex * _731.instance_params.stride) + 1];
        vec4 inst_m2 = _830.instance_transform[(gl_InstanceIndex * _731.instance_params.stride) + 2];
        vec3 _861 = vec3(inst_m0.x, inst_m1.x, inst_m2.x);
        mat_instance_model[0].x = _861.x;
        mat_instance_model[0].y = _861.y;
        mat_instance_model[0].z = _861.z;
        vec3 _874 = vec3(inst_m0.y, inst_m1.y, inst_m2.y);
        mat_instance_model[1].x = _874.x;
        mat_instance_model[1].y = _874.y;
        mat_instance_model[1].z = _874.z;
        vec3 _887 = vec3(inst_m0.z, inst_m1.z, inst_m2.z);
        mat_instance_model[2].x = _887.x;
        mat_instance_model[2].y = _887.y;
        mat_instance_model[2].z = _887.z;
        vec3 _900 = vec3(inst_m0.w, inst_m1.w, inst_m2.w);
        mat_instance_model[3].x = _900.x;
        mat_instance_model[3].y = _900.y;
        mat_instance_model[3].z = _900.z;
        mat_instance_model_inv = mat_instance_model;
        mat3 param_4 = mat3(mat_instance_model_inv[0].xyz, mat_instance_model_inv[1].xyz, mat_instance_model_inv[2].xyz);
        mat3 inv = inverse_mat3(param_4);
        mat_instance_model_inv[0].x = inv[0].x;
        mat_instance_model_inv[0].y = inv[0].y;
        mat_instance_model_inv[0].z = inv[0].z;
        mat_instance_model_inv[1].x = inv[1].x;
        mat_instance_model_inv[1].y = inv[1].y;
        mat_instance_model_inv[1].z = inv[1].z;
        mat_instance_model_inv[2].x = inv[2].x;
        mat_instance_model_inv[2].y = inv[2].y;
        mat_instance_model_inv[2].z = inv[2].z;
        mat_instance_model_inv[3].x = -(((inv[0].x * mat_instance_model[3].x) + (inv[1].x * mat_instance_model[3].y)) + (inv[2].x * mat_instance_model[3].z));
        mat_instance_model_inv[3].y = -(((inv[0].y * mat_instance_model[3].x) + (inv[1].y * mat_instance_model[3].y)) + (inv[2].y * mat_instance_model[3].z));
        mat_instance_model_inv[3].z = -(((inv[0].z * mat_instance_model[3].x) + (inv[1].z * mat_instance_model[3].y)) + (inv[2].z * mat_instance_model[3].z));
    }
    VertexInput vtx_modifier_input_base = vtx_input;
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = uint(gl_VertexIndex);
    modifier_factor.id = uint(gl_VertexIndex);
    modifier_factor.instance_id = uint(gl_InstanceIndex);
    if (_731.instance_params.stride > 0)
    {
        modifier_factor.instance_id = _1022.instance_hash[gl_InstanceIndex];
    }
    modifier_factor.position = vtx_input.pos;
    modifier_factor.normal = vtx_input.norm;
    modifier_factor.color = vtx_input.color;
    if ((_232.geometry_information.builtin_attribute_mask & 64u) != 0u)
    {
        uint param_5 = uint(gl_VertexIndex);
        uint _1045 = vtx_custom0_load(param_5);
        modifier_factor.custom0 = _1045;
    }
    if ((_232.geometry_information.builtin_attribute_mask & 8u) != 0u)
    {
        uint param_6 = uint(gl_VertexIndex);
        vec2 _1056 = vtx_uv0_load(param_6);
        modifier_factor.uv0 = _1056;
    }
    modifier_factor.is_spawned = false;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = _1065.transform_params.mModel;
    cs_transforms.mat_local_to_instance = mat_instance_model;
    cs_transforms.mat_local_to_model_inv = _1065.transform_params.mModelInv;
    ModifierFactorInstanceID_Params _1083;
    _1083.modifier_function = _1078.VM0_params.modifier_function;
    _1083.multiplier = _1078.VM0_params.multiplier;
    _1083.range = _1078.VM0_params.range;
    _1083.base = _1078.VM0_params.base;
    ModifierFactorInstanceID_Params param_7 = _1083;
    ModifierFactor param_8 = modifier_factor;
    modifier_factor_instance_id(param_7, param_8);
    modifier_factor = param_8;
    VertexModifierColorizeParams _1096;
    _1096.color = _1091.VM1_params.color;
    _1096.alpha = _1091.VM1_params.alpha;
    _1096.use_gradient = _1091.VM1_params.use_gradient;
    _1096.color_blend = _1091.VM1_params.color_blend;
    _1096.alpha_blend = _1091.VM1_params.alpha_blend;
    _1096.color_gradient_idx = _1091.VM1_params.color_gradient_idx;
    _1096.mixing_mode = _1091.VM1_params.mixing_mode;
    VertexModifierColorizeParams param_9 = _1096;
    ModifierFactor param_10 = modifier_factor;
    VertexInput param_11 = vtx_input;
    vertex_modifier_colorize_apply(param_9, param_10, param_11);
    modifier_factor = param_10;
    vtx_input = param_11;
    vtx_output.vLocalPos = vtx_input.pos;
    instanceID = uint(gl_InstanceIndex);
    if (_731.instance_params.stride > 0)
    {
        vec4 inst_m0_1 = _830.instance_transform[(gl_InstanceIndex * _731.instance_params.stride) + 0];
        vec4 inst_m1_1 = _830.instance_transform[(gl_InstanceIndex * _731.instance_params.stride) + 1];
        vec4 inst_m2_1 = _830.instance_transform[(gl_InstanceIndex * _731.instance_params.stride) + 2];
        vec4 v = vec4(vtx_input.pos, 1.0);
        vtx_input.pos.x = dot(inst_m0_1, v);
        vtx_input.pos.y = dot(inst_m1_1, v);
        vtx_input.pos.z = dot(inst_m2_1, v);
        vec3 param_12 = vtx_input.norm;
        mat4 param_13 = transpose(mat4(vec4(inst_m0_1), vec4(inst_m1_1), vec4(inst_m2_1), vec4(0.0, 0.0, 0.0, 1.0)));
        vtx_input.norm = normalize(vector_transform_by_mat33(param_12, param_13));
        vec2 _1205 = unpackHalf2x16(_1199.instance_color[(gl_InstanceIndex * 2) + 0]);
        vec4 inst_c;
        inst_c.x = _1205.x;
        inst_c.y = _1205.y;
        vec2 _1215 = unpackHalf2x16(_1199.instance_color[(gl_InstanceIndex * 2) + 1]);
        inst_c.z = _1215.x;
        inst_c.w = _1215.y;
        vec4 _1221 = vtx_input.color;
        vec3 _1225 = _1221.xyz * inst_c.xyz;
        vtx_input.color.x = _1225.x;
        vtx_input.color.y = _1225.y;
        vtx_input.color.z = _1225.z;
        vtx_input.color.w *= inst_c.w;
    }
    vec3 param_14 = vtx_input.pos;
    mat4 param_15 = _1065.transform_params.mModel;
    vec3 _1245 = vector_transform_by_mat43(param_14, param_15);
    vec3 vPosModel = _1245;
    vec3 param_16 = vtx_input.norm;
    mat4 param_17 = _1065.transform_params.mModelNormal;
    vtx_output.vWorldNorm = vector_transform_by_mat33(param_16, param_17);
    vec3 param_18 = vPosModel;
    mat4 param_19 = _1065.transform_params.mView;
    vec3 _1260 = vector_transform_by_mat43(param_18, param_19);
    vec3 vPosModelView = _1260;
    vtx_output.vCoords = vPosModelView;
    vtx_output.vCameraRelativeWorldPos = vPosModel - _1065.transform_params.vCameraPosition;
    vtx_output.vNorm.x = dot(_1065.transform_params.mModelViewInvTrans[0].xyz, vtx_input.norm);
    vtx_output.vNorm.y = dot(_1065.transform_params.mModelViewInvTrans[1].xyz, vtx_input.norm);
    vtx_output.vNorm.z = dot(_1065.transform_params.mModelViewInvTrans[2].xyz, vtx_input.norm);
    vtx_output.vNorm = vtx_input.norm;
    vtx_output.vColor = vtx_input.color;
    vtx_output.vUV0 = vtx_input.uv0;
    vec3 param_20 = vtx_output.vCoords;
    mat4 param_21 = _1065.transform_params.mProjection;
    vec4 _1313 = vector_transform_by_mat_projection(param_20, param_21);
    gl_Position = _1313;
}

 